/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.resthandler;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.action.SearchRuleAction;
import org.opensearch.securityanalytics.action.SearchRuleRequest;
import org.opensearch.securityanalytics.model.Rule;

public class RestSearchRuleAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestSearchRuleAction.class);

    public String getName() {
        return "search_rule_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_plugins/_security_analytics/rules/_search"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        log.debug(String.format(Locale.getDefault(), "%s %s/_search", request.method(), "/_plugins/_security_analytics/rules"));
        Boolean isPrepackaged = request.paramAsBoolean("pre_packaged", true);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.parseXContent(request.contentOrSourceParamParser());
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must(searchSourceBuilder.query());
        searchSourceBuilder.query((QueryBuilder)queryBuilder).seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true));
        SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder).indices(new String[]{isPrepackaged != false ? ".opensearch-sap-pre-packaged-rules-config" : ".opensearch-sap-custom-rules-config"}).preference(Preference.PRIMARY_FIRST.type());
        SearchRuleRequest searchRuleRequest = new SearchRuleRequest(isPrepackaged, searchRequest);
        return channel -> client.execute((ActionType)SearchRuleAction.INSTANCE, (ActionRequest)searchRuleRequest, this.searchRuleResponse((RestChannel)channel));
    }

    private RestResponseListener<SearchResponse> searchRuleResponse(RestChannel channel) {
        return new RestResponseListener<SearchResponse>(channel){

            public RestResponse buildResponse(SearchResponse response) throws Exception {
                if (response.isTimedOut()) {
                    return new BytesRestResponse(RestStatus.REQUEST_TIMEOUT, response.toString());
                }
                try {
                    for (SearchHit hit : response.getHits()) {
                        XContentParser xcp = XContentType.JSON.xContent().createParser(this.channel.request().getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                        Rule rule = Rule.docParse(xcp, hit.getId(), hit.getVersion());
                        XContentBuilder xcb = rule.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS);
                        hit.sourceRef(BytesReference.bytes((XContentBuilder)xcb));
                    }
                }
                catch (Exception ex) {
                    log.info("The rule parsing failed. Will return response as is.");
                }
                return new BytesRestResponse(RestStatus.OK, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
            }
        };
    }
}

