/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.correlation.index.mapper;

import java.io.IOException;
import java.util.Optional;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.KnnVectorField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.opensearch.common.Explicit;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.securityanalytics.correlation.index.CorrelationParamsContext;
import org.opensearch.securityanalytics.correlation.index.VectorField;
import org.opensearch.securityanalytics.correlation.index.mapper.CorrelationVectorFieldMapper;

public class LuceneFieldMapper
extends CorrelationVectorFieldMapper {
    private static final int LUCENE_MAX_DIMENSION = 1024;
    private final FieldType vectorFieldType;

    public LuceneFieldMapper(CreateLuceneFieldMapperInput input) {
        super(input.getName(), input.getMappedFieldType(), input.getMultiFields(), input.getCopyTo(), input.getIgnoreMalformed(), input.isStored(), input.isHasDocValues());
        this.correlationParams = input.getCorrelationParams();
        VectorSimilarityFunction vectorSimilarityFunction = this.correlationParams.getSimilarityFunction();
        int dimension = input.getMappedFieldType().getDimension();
        if (dimension > 1024) {
            throw new IllegalArgumentException(String.format("Dimension value cannot be greater than [%s] but got [%s] for vector [%s]", 1024, dimension, input.getName()));
        }
        this.fieldType = KnnVectorField.createFieldType((int)dimension, (VectorSimilarityFunction)vectorSimilarityFunction);
        this.vectorFieldType = this.hasDocValues ? LuceneFieldMapper.buildDocValuesFieldType() : null;
    }

    private static FieldType buildDocValuesFieldType() {
        FieldType field = new FieldType();
        field.setDocValuesType(DocValuesType.BINARY);
        field.freeze();
        return field;
    }

    @Override
    protected void parseCreateField(ParseContext context, int dimension) throws IOException {
        Optional<float[]> arrayOptional = this.getFloatsFromContext(context, dimension);
        if (arrayOptional.isEmpty()) {
            return;
        }
        float[] array = arrayOptional.get();
        KnnVectorField point = new KnnVectorField(this.name(), array, this.fieldType);
        context.doc().add((IndexableField)point);
        if (this.fieldType.stored()) {
            context.doc().add((IndexableField)new StoredField(this.name(), point.toString()));
        }
        if (this.hasDocValues && this.vectorFieldType != null) {
            context.doc().add((IndexableField)new VectorField(this.name(), array, (IndexableFieldType)this.vectorFieldType));
        }
        context.path().remove();
    }

    static class CreateLuceneFieldMapperInput {
        String name;
        CorrelationVectorFieldMapper.CorrelationVectorFieldType mappedFieldType;
        FieldMapper.MultiFields multiFields;
        FieldMapper.CopyTo copyTo;
        Explicit<Boolean> ignoreMalformed;
        boolean stored;
        boolean hasDocValues;
        CorrelationParamsContext correlationParams;

        public CreateLuceneFieldMapperInput(String name, CorrelationVectorFieldMapper.CorrelationVectorFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Explicit<Boolean> ignoreMalformed, boolean stored, boolean hasDocValues, CorrelationParamsContext correlationParams) {
            this.name = name;
            this.mappedFieldType = mappedFieldType;
            this.multiFields = multiFields;
            this.copyTo = copyTo;
            this.ignoreMalformed = ignoreMalformed;
            this.stored = stored;
            this.hasDocValues = hasDocValues;
            this.correlationParams = correlationParams;
        }

        public String getName() {
            return this.name;
        }

        public CorrelationVectorFieldMapper.CorrelationVectorFieldType getMappedFieldType() {
            return this.mappedFieldType;
        }

        public FieldMapper.MultiFields getMultiFields() {
            return this.multiFields;
        }

        public FieldMapper.CopyTo getCopyTo() {
            return this.copyTo;
        }

        public Explicit<Boolean> getIgnoreMalformed() {
            return this.ignoreMalformed;
        }

        public boolean isStored() {
            return this.stored;
        }

        public boolean isHasDocValues() {
            return this.hasDocValues;
        }

        public CorrelationParamsContext getCorrelationParams() {
            return this.correlationParams;
        }
    }
}

