/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.shingle.FixedShingleFilter;
import org.apache.lucene.analysis.tokenattributes.BytesTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.intervals.Intervals;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.queries.spans.FieldMaskingSpanQuery;
import org.apache.lucene.queries.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.queries.spans.SpanNearQuery;
import org.apache.lucene.queries.spans.SpanOrQuery;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.queries.spans.SpanTermQuery;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SynonymQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.common.collect.Iterators;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.lucene.search.AutomatonQueries;
import org.opensearch.common.lucene.search.MultiPhrasePrefixQuery;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.analysis.AnalyzerScope;
import org.opensearch.index.analysis.IndexAnalyzers;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.plain.PagedBytesIndexFieldData;
import org.opensearch.index.mapper.DocumentMapperParser;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.SourceValueFetcher;
import org.opensearch.index.mapper.StringFieldType;
import org.opensearch.index.mapper.TextParams;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.IntervalBuilder;
import org.opensearch.index.query.IntervalMode;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.similarity.SimilarityProvider;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.lookup.SearchLookup;

public class TextFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "text";
    private static final int POSITION_INCREMENT_GAP_USE_ANALYZER = -1;
    private static final String FAST_PHRASE_SUFFIX = "._index_phrase";
    private static final FielddataFrequencyFilter DEFAULT_FILTER = new FielddataFrequencyFilter(0.0, 2.147483647E9, 0);
    public static final ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n, c.indexVersionCreated(), c.getIndexAnalyzers()));
    private final FieldType fieldType;
    private final PrefixFieldMapper prefixFieldMapper;
    private final PhraseFieldMapper phraseFieldMapper;
    private final SimilarityProvider similarity;
    private final String indexOptions;
    private final String termVectors;
    private final int positionIncrementGap;
    private final Version indexCreatedVersion;
    private final IndexAnalyzers indexAnalyzers;
    private final FielddataFrequencyFilter freqFilter;

    private static TextFieldMapper toType(FieldMapper in) {
        return (TextFieldMapper)in;
    }

    private static PrefixConfig parsePrefixConfig(String propName, Mapper.TypeParser.ParserContext parserContext, Object propNode) {
        if (propNode == null) {
            return null;
        }
        Map indexPrefix = (Map)propNode;
        int minChars = XContentMapValues.nodeIntegerValue(indexPrefix.remove("min_chars"), 2);
        int maxChars = XContentMapValues.nodeIntegerValue(indexPrefix.remove("max_chars"), 5);
        DocumentMapperParser.checkNoRemainingFields(propName, indexPrefix, parserContext.indexVersionCreated());
        return new PrefixConfig(minChars, maxChars);
    }

    private static FielddataFrequencyFilter parseFrequencyFilter(String name, Mapper.TypeParser.ParserContext parserContext, Object node) {
        Map frequencyFilter = (Map)node;
        double minFrequency = XContentMapValues.nodeDoubleValue(frequencyFilter.remove("min"), 0.0);
        double maxFrequency = XContentMapValues.nodeDoubleValue(frequencyFilter.remove("max"), 2.147483647E9);
        int minSegmentSize = XContentMapValues.nodeIntegerValue(frequencyFilter.remove("min_segment_size"), 0);
        DocumentMapperParser.checkNoRemainingFields(name, frequencyFilter, parserContext.indexVersionCreated());
        return new FielddataFrequencyFilter(minFrequency, maxFrequency, minSegmentSize);
    }

    protected TextFieldMapper(String simpleName, FieldType fieldType, TextFieldType mappedFieldType, PrefixFieldMapper prefixFieldMapper, PhraseFieldMapper phraseFieldMapper, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        assert (mappedFieldType.getTextSearchInfo().isTokenized());
        assert (!mappedFieldType.hasDocValues());
        if (fieldType.indexOptions() == IndexOptions.NONE && this.fieldType().fielddata()) {
            throw new IllegalArgumentException("Cannot enable fielddata on a [text] field that is not indexed: [" + this.name() + "]");
        }
        this.fieldType = fieldType;
        this.prefixFieldMapper = prefixFieldMapper;
        this.phraseFieldMapper = phraseFieldMapper;
        this.similarity = builder.similarity.getValue();
        this.indexOptions = builder.indexOptions.getValue();
        this.termVectors = builder.termVectors.getValue();
        this.positionIncrementGap = builder.positionIncrementGap.getValue();
        this.indexCreatedVersion = builder.indexCreatedVersion;
        this.indexAnalyzers = builder.analyzers.indexAnalyzers;
        this.freqFilter = builder.freqFilter.getValue();
    }

    @Override
    protected TextFieldMapper clone() {
        return (TextFieldMapper)super.clone();
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.indexCreatedVersion, this.indexAnalyzers).init(this);
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        String value = context.externalValueSet() ? context.externalValue().toString() : context.parser().textOrNull();
        if (value == null) {
            return;
        }
        if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
            Field field = new Field(this.fieldType().name(), (CharSequence)value, (IndexableFieldType)this.fieldType);
            context.doc().add((IndexableField)field);
            if (this.fieldType.omitNorms()) {
                this.createFieldNamesField(context);
            }
            if (this.prefixFieldMapper != null) {
                this.prefixFieldMapper.addField(context, value);
            }
            if (this.phraseFieldMapper != null) {
                context.doc().add((IndexableField)new Field(this.phraseFieldMapper.fieldType().name(), (CharSequence)value, (IndexableFieldType)this.phraseFieldMapper.fieldType));
            }
        }
    }

    @Override
    public Iterator<Mapper> iterator() {
        ArrayList<FieldMapper> subIterators = new ArrayList<FieldMapper>();
        if (this.prefixFieldMapper != null) {
            subIterators.add(this.prefixFieldMapper);
        }
        if (this.phraseFieldMapper != null) {
            subIterators.add(this.phraseFieldMapper);
        }
        if (subIterators.size() == 0) {
            return super.iterator();
        }
        return Iterators.concat((Iterator[])new Iterator[]{super.iterator(), subIterators.iterator()});
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public TextFieldType fieldType() {
        return (TextFieldType)super.fieldType();
    }

    public static Query createPhraseQuery(TokenStream stream, String field, int slop, boolean enablePositionIncrements) throws IOException {
        MultiPhraseQuery.Builder mpqb = new MultiPhraseQuery.Builder();
        mpqb.setSlop(slop);
        TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)stream.getAttribute(PositionIncrementAttribute.class);
        int position = -1;
        ArrayList<Term> multiTerms = new ArrayList<Term>();
        stream.reset();
        while (stream.incrementToken()) {
            int positionIncrement = posIncrAtt.getPositionIncrement();
            if (positionIncrement > 0 && multiTerms.size() > 0) {
                if (enablePositionIncrements) {
                    mpqb.add(multiTerms.toArray(new Term[0]), position);
                } else {
                    mpqb.add(multiTerms.toArray(new Term[0]));
                }
                multiTerms.clear();
            }
            position += positionIncrement;
            multiTerms.add(new Term(field, termAtt.getBytesRef()));
        }
        if (enablePositionIncrements) {
            mpqb.add(multiTerms.toArray(new Term[0]), position);
        } else {
            mpqb.add(multiTerms.toArray(new Term[0]));
        }
        return mpqb.build();
    }

    public static Query createPhrasePrefixQuery(TokenStream stream, String field, int slop, int maxExpansions, String prefixField, IntPredicate usePrefixField) throws IOException {
        MultiPhrasePrefixQuery builder = new MultiPhrasePrefixQuery(field);
        builder.setSlop(slop);
        builder.setMaxExpansions(maxExpansions);
        ArrayList<Term> currentTerms = new ArrayList<Term>();
        TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)stream.getAttribute(PositionIncrementAttribute.class);
        stream.reset();
        int position = -1;
        while (stream.incrementToken()) {
            if (posIncrAtt.getPositionIncrement() != 0) {
                if (!currentTerms.isEmpty()) {
                    builder.add(currentTerms.toArray(new Term[0]), position);
                }
                position += posIncrAtt.getPositionIncrement();
                currentTerms.clear();
            }
            currentTerms.add(new Term(field, termAtt.getBytesRef()));
        }
        builder.add(currentTerms.toArray(new Term[0]), position);
        if (prefixField == null) {
            return builder;
        }
        int lastPos = builder.getTerms().length - 1;
        Term[][] terms = builder.getTerms();
        int[] positions = builder.getPositions();
        for (Term term2 : terms[lastPos]) {
            String value = term2.text();
            if (usePrefixField.test(value.length())) continue;
            return builder;
        }
        if (terms.length == 1) {
            SynonymQuery.Builder sb = new SynonymQuery.Builder(prefixField);
            Arrays.stream(terms[0]).map(term -> new Term(prefixField, term.bytes())).forEach(arg_0 -> ((SynonymQuery.Builder)sb).addTerm(arg_0));
            return sb.build();
        }
        SpanNearQuery.Builder spanQuery = new SpanNearQuery.Builder(field, true);
        spanQuery.setSlop(slop);
        int previousPos = -1;
        for (int i = 0; i < terms.length; ++i) {
            SpanTermQuery[] queries;
            Term[] posTerms = terms[i];
            int posInc = positions[i] - previousPos;
            previousPos = positions[i];
            if (posInc > 1) {
                spanQuery.addGap(posInc - 1);
            }
            if (i == lastPos) {
                if (posTerms.length == 1) {
                    FieldMaskingSpanQuery fieldMask = new FieldMaskingSpanQuery((SpanQuery)new SpanTermQuery(new Term(prefixField, posTerms[0].bytes())), field);
                    spanQuery.addClause((SpanQuery)fieldMask);
                    continue;
                }
                queries = (SpanQuery[])Arrays.stream(posTerms).map(term -> new FieldMaskingSpanQuery((SpanQuery)new SpanTermQuery(new Term(prefixField, term.bytes())), field)).toArray(SpanQuery[]::new);
                spanQuery.addClause((SpanQuery)new SpanOrQuery((SpanQuery[])queries));
                continue;
            }
            if (posTerms.length == 1) {
                spanQuery.addClause((SpanQuery)new SpanTermQuery(posTerms[0]));
                continue;
            }
            queries = (SpanTermQuery[])Arrays.stream(posTerms).map(SpanTermQuery::new).toArray(SpanTermQuery[]::new);
            spanQuery.addClause((SpanQuery)new SpanOrQuery((SpanQuery[])queries));
        }
        return spanQuery.build();
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        builder.field("type", this.contentType());
        Builder mapperBuilder = (Builder)this.getMergeBuilder();
        mapperBuilder.boost.toXContent(builder, includeDefaults);
        mapperBuilder.index.toXContent(builder, includeDefaults);
        mapperBuilder.store.toXContent(builder, includeDefaults);
        this.multiFields.toXContent(builder, params);
        this.copyTo.toXContent(builder, params);
        mapperBuilder.meta.toXContent(builder, includeDefaults);
        mapperBuilder.indexOptions.toXContent(builder, includeDefaults);
        mapperBuilder.termVectors.toXContent(builder, includeDefaults);
        mapperBuilder.norms.toXContent(builder, includeDefaults);
        mapperBuilder.analyzers.indexAnalyzer.toXContent(builder, includeDefaults);
        mapperBuilder.analyzers.searchAnalyzer.toXContent(builder, includeDefaults);
        mapperBuilder.analyzers.searchQuoteAnalyzer.toXContent(builder, includeDefaults);
        mapperBuilder.similarity.toXContent(builder, includeDefaults);
        mapperBuilder.eagerGlobalOrdinals.toXContent(builder, includeDefaults);
        mapperBuilder.positionIncrementGap.toXContent(builder, includeDefaults);
        mapperBuilder.fieldData.toXContent(builder, includeDefaults);
        mapperBuilder.freqFilter.toXContent(builder, includeDefaults);
        mapperBuilder.indexPrefixes.toXContent(builder, includeDefaults);
        mapperBuilder.indexPhrases.toXContent(builder, includeDefaults);
    }

    public static class Defaults {
        public static final double FIELDDATA_MIN_FREQUENCY = 0.0;
        public static final double FIELDDATA_MAX_FREQUENCY = 2.147483647E9;
        public static final int FIELDDATA_MIN_SEGMENT_SIZE = 0;
        public static final int INDEX_PREFIX_MIN_CHARS = 2;
        public static final int INDEX_PREFIX_MAX_CHARS = 5;
        public static final FieldType FIELD_TYPE = new FieldType();
        public static final int POSITION_INCREMENT_GAP = 100;

        static {
            FIELD_TYPE.setTokenized(true);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setStoreTermVectors(false);
            FIELD_TYPE.setOmitNorms(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            FIELD_TYPE.freeze();
        }
    }

    private static final class PrefixConfig
    implements ToXContent {
        final int minChars;
        final int maxChars;

        private PrefixConfig(int minChars, int maxChars) {
            this.minChars = minChars;
            this.maxChars = maxChars;
            if (minChars > maxChars) {
                throw new IllegalArgumentException("min_chars [" + minChars + "] must be less than max_chars [" + maxChars + "]");
            }
            if (minChars < 1) {
                throw new IllegalArgumentException("min_chars [" + minChars + "] must be greater than zero");
            }
            if (maxChars >= 20) {
                throw new IllegalArgumentException("max_chars [" + maxChars + "] must be less than 20");
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrefixConfig that = (PrefixConfig)o;
            return this.minChars == that.minChars && this.maxChars == that.maxChars;
        }

        public int hashCode() {
            return Objects.hash(this.minChars, this.maxChars);
        }

        public String toString() {
            return "{ min_chars=" + this.minChars + ", max_chars=" + this.maxChars + " }";
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("min_chars", this.minChars);
            builder.field("max_chars", this.maxChars);
            builder.endObject();
            return builder;
        }
    }

    private static final class FielddataFrequencyFilter
    implements ToXContent {
        final double minFreq;
        final double maxFreq;
        final int minSegmentSize;

        private FielddataFrequencyFilter(double minFreq, double maxFreq, int minSegmentSize) {
            this.minFreq = minFreq;
            this.maxFreq = maxFreq;
            this.minSegmentSize = minSegmentSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FielddataFrequencyFilter that = (FielddataFrequencyFilter)o;
            return Double.compare(that.minFreq, this.minFreq) == 0 && Double.compare(that.maxFreq, this.maxFreq) == 0 && this.minSegmentSize == that.minSegmentSize;
        }

        public int hashCode() {
            return Objects.hash(this.minFreq, this.maxFreq, this.minSegmentSize);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("min", this.minFreq);
            builder.field("max", this.maxFreq);
            builder.field("min_segment_size", this.minSegmentSize);
            builder.endObject();
            return builder;
        }

        public String toString() {
            return "{ min=" + this.minFreq + ", max=" + this.maxFreq + ", min_segment_size=" + this.minSegmentSize + " }";
        }
    }

    public static class TextFieldType
    extends StringFieldType {
        private boolean fielddata = false;
        private FielddataFrequencyFilter filter;
        private PrefixFieldType prefixFieldType;
        private boolean indexPhrases = false;

        public TextFieldType(String name, boolean indexed, boolean stored, TextSearchInfo tsi, Map<String, String> meta) {
            super(name, indexed, stored, false, tsi, meta);
        }

        public TextFieldType(String name, boolean indexed, boolean stored, Map<String, String> meta) {
            super(name, indexed, stored, false, new TextSearchInfo(Defaults.FIELD_TYPE, null, Lucene.STANDARD_ANALYZER, Lucene.STANDARD_ANALYZER), meta);
        }

        public TextFieldType(String name) {
            this(name, true, false, new TextSearchInfo(Defaults.FIELD_TYPE, null, Lucene.STANDARD_ANALYZER, Lucene.STANDARD_ANALYZER), Collections.emptyMap());
        }

        public boolean fielddata() {
            return this.fielddata;
        }

        public void setFielddata(boolean fielddata, FielddataFrequencyFilter filter) {
            this.fielddata = fielddata;
            this.filter = filter;
        }

        public void setFielddata(boolean fielddata) {
            this.setFielddata(fielddata, DEFAULT_FILTER);
        }

        double fielddataMinFrequency() {
            return this.filter.minFreq;
        }

        double fielddataMaxFrequency() {
            return this.filter.maxFreq;
        }

        int fielddataMinSegmentSize() {
            return this.filter.minSegmentSize;
        }

        void setPrefixFieldType(PrefixFieldType prefixFieldType) {
            this.prefixFieldType = prefixFieldType;
        }

        void setIndexPhrases() {
            this.indexPhrases = true;
        }

        public PrefixFieldType getPrefixFieldType() {
            return this.prefixFieldType;
        }

        @Override
        public String typeName() {
            return TextFieldMapper.CONTENT_TYPE;
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            return SourceValueFetcher.toString(this.name(), context, format);
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
            if (this.prefixFieldType == null || !this.prefixFieldType.accept(value.length())) {
                return super.prefixQuery(value, method, caseInsensitive, context);
            }
            Query tq = this.prefixFieldType.prefixQuery(value, method, caseInsensitive, context);
            if (method == null || method == MultiTermQuery.CONSTANT_SCORE_REWRITE || method == MultiTermQuery.CONSTANT_SCORE_BOOLEAN_REWRITE) {
                return new ConstantScoreQuery(tq);
            }
            return tq;
        }

        @Override
        public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, QueryShardContext context) {
            this.failIfNotIndexed();
            if (this.prefixFieldType != null && value.length() >= this.prefixFieldType.minChars && value.length() <= this.prefixFieldType.maxChars && this.prefixFieldType.getTextSearchInfo().hasPositions()) {
                return new FieldMaskingSpanQuery((SpanQuery)new SpanTermQuery(new Term(this.prefixFieldType.name(), this.indexedValueForSearch(value))), this.name());
            }
            SpanMultiTermQueryWrapper spanMulti = new SpanMultiTermQueryWrapper((MultiTermQuery)new PrefixQuery(new Term(this.name(), this.indexedValueForSearch(value))));
            spanMulti.setRewriteMethod(method);
            return spanMulti;
        }

        @Override
        public IntervalsSource intervals(String text, int maxGaps, IntervalMode mode, NamedAnalyzer analyzer, boolean prefix) throws IOException {
            if (!this.getTextSearchInfo().hasPositions()) {
                throw new IllegalArgumentException("Cannot create intervals over field [" + this.name() + "] with no positions indexed");
            }
            if (analyzer == null) {
                analyzer = this.getTextSearchInfo().getSearchAnalyzer();
            }
            if (prefix) {
                BytesRef normalizedTerm = analyzer.normalize(this.name(), text);
                if (this.prefixFieldType != null) {
                    return this.prefixFieldType.intervals(normalizedTerm);
                }
                return Intervals.prefix((BytesRef)normalizedTerm);
            }
            IntervalBuilder builder = new IntervalBuilder(this.name(), (Analyzer)(analyzer == null ? this.getTextSearchInfo().getSearchAnalyzer() : analyzer));
            return builder.analyzeText(text, maxGaps, mode);
        }

        @Override
        public Query phraseQuery(TokenStream stream, int slop, boolean enablePosIncrements) throws IOException {
            Object field = this.name();
            if (this.indexPhrases && slop == 0 && !TextFieldType.hasGaps(stream) && !stream.hasAttribute(BytesTermAttribute.class)) {
                stream = new FixedShingleFilter(stream, 2);
                field = (String)field + TextFieldMapper.FAST_PHRASE_SUFFIX;
            }
            PhraseQuery.Builder builder = new PhraseQuery.Builder();
            builder.setSlop(slop);
            TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(TermToBytesRefAttribute.class);
            PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)stream.getAttribute(PositionIncrementAttribute.class);
            int position = -1;
            stream.reset();
            while (stream.incrementToken()) {
                if (termAtt.getBytesRef() == null) {
                    throw new IllegalStateException("Null term while building phrase query");
                }
                position = enablePosIncrements ? (position += posIncrAtt.getPositionIncrement()) : ++position;
                builder.add(new Term((String)field, termAtt.getBytesRef()), position);
            }
            return builder.build();
        }

        @Override
        public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
            Object field = this.name();
            if (this.indexPhrases && slop == 0 && !TextFieldType.hasGaps(stream)) {
                stream = new FixedShingleFilter(stream, 2);
                field = (String)field + TextFieldMapper.FAST_PHRASE_SUFFIX;
            }
            return TextFieldMapper.createPhraseQuery(stream, (String)field, slop, enablePositionIncrements);
        }

        @Override
        public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions) throws IOException {
            return this.analyzePhrasePrefix(stream, slop, maxExpansions);
        }

        private Query analyzePhrasePrefix(TokenStream stream, int slop, int maxExpansions) throws IOException {
            String prefixField = this.prefixFieldType == null || slop > 0 ? null : this.prefixFieldType.name();
            IntPredicate usePrefix = len -> len >= this.prefixFieldType.minChars && len <= this.prefixFieldType.maxChars;
            return TextFieldMapper.createPhrasePrefixQuery(stream, this.name(), slop, maxExpansions, prefixField, usePrefix);
        }

        public static boolean hasGaps(TokenStream stream) throws IOException {
            assert (stream instanceof CachingTokenFilter);
            PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)stream.getAttribute(PositionIncrementAttribute.class);
            stream.reset();
            while (stream.incrementToken()) {
                if (posIncAtt.getPositionIncrement() <= 1) continue;
                return true;
            }
            return false;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            if (!this.fielddata) {
                throw new IllegalArgumentException("Text fields are not optimised for operations that require per-document field data like aggregations and sorting, so these operations are disabled by default. Please use a keyword field instead. Alternatively, set fielddata=true on [" + this.name() + "] in order to load field data by uninverting the inverted index. Note that this can use significant memory.");
            }
            return new PagedBytesIndexFieldData.Builder(this.name(), this.filter.minFreq, this.filter.maxFreq, this.filter.minSegmentSize, CoreValuesSourceType.BYTES);
        }
    }

    private static final class PrefixFieldMapper
    extends FieldMapper {
        protected PrefixFieldMapper(FieldType fieldType, PrefixFieldType mappedFieldType) {
            super(mappedFieldType.name(), fieldType, mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        }

        void addField(ParseContext context, String value) {
            context.doc().add((IndexableField)new Field(this.fieldType().name(), (CharSequence)value, (IndexableFieldType)this.fieldType));
        }

        @Override
        protected void parseCreateField(ParseContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        }

        @Override
        protected String contentType() {
            return "prefix";
        }

        public String toString() {
            return this.fieldType().toString();
        }
    }

    private static final class PhraseFieldMapper
    extends FieldMapper {
        PhraseFieldMapper(FieldType fieldType, PhraseFieldType mappedFieldType) {
            super(mappedFieldType.name(), fieldType, mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        }

        @Override
        protected void parseCreateField(ParseContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        }

        @Override
        protected String contentType() {
            return "phrase";
        }
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final Version indexCreatedVersion;
        private final ParametrizedFieldMapper.Parameter<Boolean> index = ParametrizedFieldMapper.Parameter.indexParam(m -> TextFieldMapper.toType((FieldMapper)m).mappedFieldType.isSearchable(), true);
        private final ParametrizedFieldMapper.Parameter<Boolean> store = ParametrizedFieldMapper.Parameter.storeParam(m -> TextFieldMapper.toType((FieldMapper)m).fieldType.stored(), false);
        final ParametrizedFieldMapper.Parameter<SimilarityProvider> similarity = TextParams.similarity(m -> TextFieldMapper.toType((FieldMapper)m).similarity);
        final ParametrizedFieldMapper.Parameter<String> indexOptions = TextParams.indexOptions(m -> TextFieldMapper.toType((FieldMapper)m).indexOptions);
        final ParametrizedFieldMapper.Parameter<Boolean> norms = TextParams.norms(true, m -> !TextFieldMapper.toType((FieldMapper)m).fieldType.omitNorms());
        final ParametrizedFieldMapper.Parameter<String> termVectors = TextParams.termVectors(m -> TextFieldMapper.toType((FieldMapper)m).termVectors);
        final ParametrizedFieldMapper.Parameter<Integer> positionIncrementGap = ParametrizedFieldMapper.Parameter.intParam("position_increment_gap", false, m -> TextFieldMapper.toType((FieldMapper)m).positionIncrementGap, -1);
        final ParametrizedFieldMapper.Parameter<Boolean> fieldData = ParametrizedFieldMapper.Parameter.boolParam("fielddata", true, m -> ((TextFieldType)TextFieldMapper.toType((FieldMapper)m).mappedFieldType).fielddata, false);
        final ParametrizedFieldMapper.Parameter<FielddataFrequencyFilter> freqFilter = new ParametrizedFieldMapper.Parameter<FielddataFrequencyFilter>("fielddata_frequency_filter", true, () -> DEFAULT_FILTER, (x$0, x$1, x$2) -> TextFieldMapper.parseFrequencyFilter(x$0, x$1, x$2), m -> TextFieldMapper.toType((FieldMapper)m).freqFilter);
        final ParametrizedFieldMapper.Parameter<Boolean> eagerGlobalOrdinals = ParametrizedFieldMapper.Parameter.boolParam("eager_global_ordinals", true, m -> TextFieldMapper.toType((FieldMapper)m).mappedFieldType.eagerGlobalOrdinals(), false);
        final ParametrizedFieldMapper.Parameter<Boolean> indexPhrases = ParametrizedFieldMapper.Parameter.boolParam("index_phrases", false, m -> ((TextFieldType)TextFieldMapper.toType((FieldMapper)m).mappedFieldType).indexPhrases, false);
        final ParametrizedFieldMapper.Parameter<PrefixConfig> indexPrefixes = new ParametrizedFieldMapper.Parameter<PrefixConfig>("index_prefixes", false, () -> null, (x$0, x$1, x$2) -> TextFieldMapper.parsePrefixConfig(x$0, x$1, x$2), m -> Optional.ofNullable(((TextFieldType)TextFieldMapper.toType((FieldMapper)m).mappedFieldType).prefixFieldType).map(p -> new PrefixConfig(p.minChars, p.maxChars)).orElse(null)).acceptsNull();
        private final ParametrizedFieldMapper.Parameter<Float> boost = ParametrizedFieldMapper.Parameter.boostParam();
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();
        final TextParams.Analyzers analyzers;

        public Builder(String name, IndexAnalyzers indexAnalyzers) {
            this(name, Version.CURRENT, indexAnalyzers);
        }

        public Builder(String name, Version indexCreatedVersion, IndexAnalyzers indexAnalyzers) {
            super(name);
            this.indexCreatedVersion = indexCreatedVersion;
            this.analyzers = new TextParams.Analyzers(indexAnalyzers);
        }

        public Builder index(boolean index) {
            this.index.setValue(index);
            return this;
        }

        public Builder store(boolean store) {
            this.store.setValue(store);
            return this;
        }

        public Builder fielddata(boolean fielddata) {
            this.fieldData.setValue(fielddata);
            return this;
        }

        public Builder fielddataFrequencyFilter(double min, double max, int segs) {
            this.freqFilter.setValue(new FielddataFrequencyFilter(min, max, segs));
            return this;
        }

        public Builder addMultiField(Mapper.Builder<?> builder) {
            this.multiFieldsBuilder.add(builder);
            return this;
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.index, this.store, this.indexOptions, this.norms, this.termVectors, this.analyzers.indexAnalyzer, this.analyzers.searchAnalyzer, this.analyzers.searchQuoteAnalyzer, this.similarity, this.positionIncrementGap, this.fieldData, this.freqFilter, this.eagerGlobalOrdinals, this.indexPhrases, this.indexPrefixes, this.boost, this.meta);
        }

        private TextFieldType buildFieldType(FieldType fieldType, Mapper.BuilderContext context) {
            NamedAnalyzer indexAnalyzer = this.analyzers.getIndexAnalyzer();
            NamedAnalyzer searchAnalyzer = this.analyzers.getSearchAnalyzer();
            NamedAnalyzer searchQuoteAnalyzer = this.analyzers.getSearchQuoteAnalyzer();
            if (this.positionIncrementGap.get() != -1) {
                if (fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                    throw new IllegalArgumentException("Cannot set position_increment_gap on field [" + this.name + "] without positions enabled");
                }
                indexAnalyzer = new NamedAnalyzer(indexAnalyzer, this.positionIncrementGap.get());
                searchAnalyzer = new NamedAnalyzer(searchAnalyzer, this.positionIncrementGap.get());
                searchQuoteAnalyzer = new NamedAnalyzer(searchQuoteAnalyzer, this.positionIncrementGap.get());
            }
            TextSearchInfo tsi = new TextSearchInfo(fieldType, this.similarity.getValue(), searchAnalyzer, searchQuoteAnalyzer);
            TextFieldType ft = new TextFieldType(this.buildFullName(context), this.index.getValue(), this.store.getValue(), tsi, this.meta.getValue());
            ft.setIndexAnalyzer(indexAnalyzer);
            ft.setEagerGlobalOrdinals(this.eagerGlobalOrdinals.getValue());
            ft.setBoost(this.boost.getValue().floatValue());
            if (this.fieldData.getValue().booleanValue()) {
                ft.setFielddata(true, this.freqFilter.getValue());
            }
            return ft;
        }

        private PrefixFieldMapper buildPrefixMapper(Mapper.BuilderContext context, FieldType fieldType, TextFieldType tft) {
            if (this.indexPrefixes.get() == null) {
                return null;
            }
            if (!this.index.getValue().booleanValue()) {
                throw new IllegalArgumentException("Cannot set index_prefixes on unindexed field [" + this.name() + "]");
            }
            String fullName = this.indexCreatedVersion.before((Version)LegacyESVersion.V_7_2_1) ? this.name() : this.buildFullName(context);
            FieldType pft = new FieldType((IndexableFieldType)fieldType);
            pft.setOmitNorms(true);
            if (fieldType.indexOptions() == IndexOptions.DOCS_AND_FREQS) {
                pft.setIndexOptions(IndexOptions.DOCS);
            } else {
                pft.setIndexOptions(fieldType.indexOptions());
            }
            if (fieldType.storeTermVectorOffsets()) {
                pft.setStoreTermVectorOffsets(true);
            }
            PrefixFieldType prefixFieldType = new PrefixFieldType(tft, fullName + "._index_prefix", this.indexPrefixes.get());
            prefixFieldType.setAnalyzer(this.analyzers.getIndexAnalyzer());
            tft.setPrefixFieldType(prefixFieldType);
            return new PrefixFieldMapper(pft, prefixFieldType);
        }

        private PhraseFieldMapper buildPhraseMapper(FieldType fieldType, TextFieldType parent) {
            if (!this.indexPhrases.get().booleanValue()) {
                return null;
            }
            if (!this.index.get().booleanValue()) {
                throw new IllegalArgumentException("Cannot set index_phrases on unindexed field [" + this.name() + "]");
            }
            if (fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                throw new IllegalArgumentException("Cannot set index_phrases on field [" + this.name() + "] if positions are not enabled");
            }
            FieldType phraseFieldType = new FieldType((IndexableFieldType)fieldType);
            parent.setIndexPhrases();
            return new PhraseFieldMapper(phraseFieldType, new PhraseFieldType(parent));
        }

        @Override
        public TextFieldMapper build(Mapper.BuilderContext context) {
            FieldType fieldType = TextParams.buildFieldType(this.index, this.store, this.indexOptions, this.norms, this.termVectors);
            TextFieldType tft = this.buildFieldType(fieldType, context);
            return new TextFieldMapper(this.name, fieldType, tft, this.buildPrefixMapper(context, fieldType, tft), this.buildPhraseMapper(fieldType, tft), this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }
    }

    static final class PrefixFieldType
    extends StringFieldType {
        final int minChars;
        final int maxChars;
        final TextFieldType parentField;

        PrefixFieldType(TextFieldType parentField, String name, PrefixConfig config) {
            this(parentField, name, config.minChars, config.maxChars);
        }

        PrefixFieldType(TextFieldType parentField, String name, int minChars, int maxChars) {
            super(name, true, false, false, parentField.getTextSearchInfo(), Collections.emptyMap());
            this.minChars = minChars;
            this.maxChars = maxChars;
            this.parentField = parentField;
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            return SourceValueFetcher.toString(this.name(), context, format);
        }

        void setAnalyzer(NamedAnalyzer delegate) {
            this.setIndexAnalyzer(new NamedAnalyzer(delegate.name(), AnalyzerScope.INDEX, (Analyzer)new PrefixWrappedAnalyzer(delegate.analyzer(), this.minChars, this.maxChars)));
        }

        boolean accept(int length) {
            return length >= this.minChars - 1 && length <= this.maxChars;
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
            if (value.length() >= this.minChars) {
                if (caseInsensitive) {
                    return super.termQueryCaseInsensitive(value, context);
                }
                return super.termQuery(value, context);
            }
            ArrayList<Automaton> automata = new ArrayList<Automaton>();
            if (caseInsensitive) {
                automata.add(AutomatonQueries.toCaseInsensitiveString(value, Integer.MAX_VALUE));
            } else {
                automata.add(Automata.makeString((String)value));
            }
            for (int i = value.length(); i < this.minChars; ++i) {
                automata.add(Automata.makeAnyChar());
            }
            Automaton automaton = Operations.concatenate(automata);
            AutomatonQuery query = AutomatonQueries.createAutomatonQuery(new Term(this.name(), value + "*"), automaton, method);
            return new BooleanQuery.Builder().add((Query)query, BooleanClause.Occur.SHOULD).add((Query)new TermQuery(new Term(this.parentField.name(), value)), BooleanClause.Occur.SHOULD).build();
        }

        public IntervalsSource intervals(BytesRef term) {
            if (!this.getTextSearchInfo().hasPositions()) {
                throw new IllegalArgumentException("Cannot create intervals over a field [" + this.name() + "] without indexed positions");
            }
            if (term.length > this.maxChars) {
                return Intervals.prefix((BytesRef)term);
            }
            if (term.length >= this.minChars) {
                return Intervals.fixField((String)this.name(), (IntervalsSource)Intervals.term((BytesRef)term));
            }
            StringBuilder sb = new StringBuilder(term.utf8ToString());
            for (int i = term.length; i < this.minChars; ++i) {
                sb.append("?");
            }
            String wildcardTerm = sb.toString();
            return Intervals.or((IntervalsSource[])new IntervalsSource[]{Intervals.fixField((String)this.name(), (IntervalsSource)Intervals.wildcard((BytesRef)new BytesRef((CharSequence)wildcardTerm))), Intervals.term((BytesRef)term)});
        }

        @Override
        public String typeName() {
            return "prefix";
        }

        public String toString() {
            return super.toString() + ",prefixChars=" + this.minChars + ":" + this.maxChars;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            throw new UnsupportedOperationException();
        }
    }

    static final class PhraseFieldType
    extends StringFieldType {
        final TextFieldType parent;

        PhraseFieldType(TextFieldType parent) {
            super(parent.name() + TextFieldMapper.FAST_PHRASE_SUFFIX, true, false, false, parent.getTextSearchInfo(), Collections.emptyMap());
            this.setAnalyzer(parent.indexAnalyzer().name(), parent.indexAnalyzer().analyzer());
            this.parent = parent;
        }

        void setAnalyzer(String name, Analyzer delegate) {
            this.setIndexAnalyzer(new NamedAnalyzer(name, AnalyzerScope.INDEX, (Analyzer)new PhraseWrappedAnalyzer(delegate)));
        }

        @Override
        public String typeName() {
            return "phrase";
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            return SourceValueFetcher.toString(this.name(), context, format);
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            throw new UnsupportedOperationException();
        }
    }

    private static class PrefixWrappedAnalyzer
    extends AnalyzerWrapper {
        private final int minChars;
        private final int maxChars;
        private final Analyzer delegate;

        PrefixWrappedAnalyzer(Analyzer delegate, int minChars, int maxChars) {
            super(delegate.getReuseStrategy());
            this.delegate = delegate;
            this.minChars = minChars;
            this.maxChars = maxChars;
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            return this.delegate;
        }

        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
            EdgeNGramTokenFilter filter = new EdgeNGramTokenFilter(components.getTokenStream(), this.minChars, this.maxChars, false);
            return new Analyzer.TokenStreamComponents(components.getSource(), (TokenStream)filter);
        }
    }

    private static class PhraseWrappedAnalyzer
    extends AnalyzerWrapper {
        private final Analyzer delegate;

        PhraseWrappedAnalyzer(Analyzer delegate) {
            super(delegate.getReuseStrategy());
            this.delegate = delegate;
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            return this.delegate;
        }

        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
            return new Analyzer.TokenStreamComponents(components.getSource(), (TokenStream)new FixedShingleFilter(components.getTokenStream(), 2));
        }
    }
}

