/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.blobstore.stream.read.listener;

import java.util.concurrent.atomic.AtomicInteger;
import org.opensearch.common.annotation.InternalApi;
import org.opensearch.core.action.ActionListener;

@InternalApi
class FileCompletionListener
implements ActionListener<Integer> {
    private final int numberOfParts;
    private final String fileName;
    private final AtomicInteger completedPartsCount = new AtomicInteger();
    private final ActionListener<String> completionListener;

    public FileCompletionListener(int numberOfParts, String fileName, ActionListener<String> completionListener) {
        this.numberOfParts = numberOfParts;
        this.fileName = fileName;
        this.completionListener = completionListener;
    }

    public void onResponse(Integer unused) {
        if (this.completedPartsCount.incrementAndGet() == this.numberOfParts) {
            this.completionListener.onResponse((Object)this.fileName);
        }
    }

    public void onFailure(Exception e) {
        this.completionListener.onFailure(e);
    }
}

