/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.delete;

import java.io.IOException;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.CompositeIndicesRequest;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.replication.ReplicatedWriteRequest;
import org.opensearch.common.Nullable;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.VersionType;

public class DeleteRequest
extends ReplicatedWriteRequest<DeleteRequest>
implements DocWriteRequest<DeleteRequest>,
CompositeIndicesRequest {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(DeleteRequest.class);
    private static final ShardId NO_SHARD_ID = null;
    private String id;
    @Nullable
    private String routing;
    private long version = -3L;
    private VersionType versionType = VersionType.INTERNAL;
    private long ifSeqNo = -2L;
    private long ifPrimaryTerm = 0L;

    public DeleteRequest(StreamInput in) throws IOException {
        this(null, in);
    }

    public DeleteRequest(@Nullable ShardId shardId, StreamInput in) throws IOException {
        super(shardId, in);
        if (in.getVersion().before(Version.V_2_0_0)) {
            String type = in.readString();
            assert ("_doc".equals(type)) : "Expected [_doc] but received [" + type + "]";
        }
        this.id = in.readString();
        this.routing = in.readOptionalString();
        if (in.getVersion().before((Version)LegacyESVersion.V_7_0_0)) {
            in.readOptionalString();
        }
        this.version = in.readLong();
        this.versionType = VersionType.fromValue(in.readByte());
        this.ifSeqNo = in.readZLong();
        this.ifPrimaryTerm = in.readVLong();
    }

    public DeleteRequest() {
        super(NO_SHARD_ID);
    }

    public DeleteRequest(String index) {
        super(NO_SHARD_ID);
        this.index = index;
    }

    public DeleteRequest(String index, String id) {
        super(NO_SHARD_ID);
        this.index = index;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (Strings.isEmpty((CharSequence)this.id)) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        validationException = DocWriteRequest.validateSeqNoBasedCASParams(this, validationException);
        return validationException;
    }

    @Override
    public String id() {
        return this.id;
    }

    public DeleteRequest id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public DeleteRequest routing(String routing) {
        this.routing = routing != null && routing.length() == 0 ? null : routing;
        return this;
    }

    @Override
    public String routing() {
        return this.routing;
    }

    @Override
    public DeleteRequest version(long version) {
        this.version = version;
        return this;
    }

    @Override
    public long version() {
        return this.version;
    }

    @Override
    public DeleteRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    @Override
    public long ifSeqNo() {
        return this.ifSeqNo;
    }

    @Override
    public long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    @Override
    public DeleteRequest setIfSeqNo(long seqNo) {
        if (seqNo < 0L && seqNo != -2L) {
            throw new IllegalArgumentException("sequence numbers must be non negative. got [" + seqNo + "].");
        }
        this.ifSeqNo = seqNo;
        return this;
    }

    @Override
    public DeleteRequest setIfPrimaryTerm(long term) {
        if (term < 0L) {
            throw new IllegalArgumentException("primary term must be non negative. got [" + term + "]");
        }
        this.ifPrimaryTerm = term;
        return this;
    }

    @Override
    public VersionType versionType() {
        return this.versionType;
    }

    @Override
    public DocWriteRequest.OpType opType() {
        return DocWriteRequest.OpType.DELETE;
    }

    @Override
    public boolean isRequireAlias() {
        return false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.writeBody(out);
    }

    @Override
    public void writeThin(StreamOutput out) throws IOException {
        super.writeThin(out);
        this.writeBody(out);
    }

    private void writeBody(StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_2_0_0)) {
            out.writeString("_doc");
        }
        out.writeString(this.id);
        out.writeOptionalString(this.routing());
        if (out.getVersion().before((Version)LegacyESVersion.V_7_0_0)) {
            out.writeOptionalString(null);
        }
        out.writeLong(this.version);
        out.writeByte(this.versionType.getValue());
        out.writeZLong(this.ifSeqNo);
        out.writeVLong(this.ifPrimaryTerm);
    }

    @Override
    public String toString() {
        return "delete {[" + this.index + "][" + this.id + "]}";
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + RamUsageEstimator.sizeOf((String)this.id);
    }
}

