/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.role.delegate;

import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.UUID;
import org.keycloak.models.map.common.EntityField;
import org.keycloak.models.map.common.delegate.DelegateProvider;
import org.keycloak.models.map.role.MapRoleEntity;
import org.keycloak.models.map.role.MapRoleEntityFields;
import org.keycloak.models.map.storage.jpa.JpaDelegateProvider;
import org.keycloak.models.map.storage.jpa.role.entity.JpaRoleEntity;

public class JpaRoleDelegateProvider
extends JpaDelegateProvider<JpaRoleEntity>
implements DelegateProvider<MapRoleEntity> {
    private final EntityManager em;

    public JpaRoleDelegateProvider(JpaRoleEntity delegate, EntityManager em) {
        super(delegate);
        this.em = em;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JpaRoleEntity getDelegate(boolean isRead, Enum<? extends EntityField<MapRoleEntity>> field, Object ... parameters) {
        if (((JpaRoleEntity)this.getDelegate()).isMetadataInitialized()) {
            return (JpaRoleEntity)this.getDelegate();
        }
        if (isRead) {
            if (!(field instanceof MapRoleEntityFields)) throw new IllegalStateException("Not a valid role field: " + field);
            switch ((MapRoleEntityFields)field) {
                case ID: 
                case REALM_ID: 
                case CLIENT_ID: 
                case NAME: 
                case DESCRIPTION: {
                    return (JpaRoleEntity)this.getDelegate();
                }
                case ATTRIBUTES: {
                    CriteriaBuilder cb = this.em.getCriteriaBuilder();
                    CriteriaQuery query = cb.createQuery(JpaRoleEntity.class);
                    Root root = query.from(JpaRoleEntity.class);
                    root.fetch("attributes", JoinType.LEFT);
                    query.select((Selection)root).where((Expression)cb.equal((Expression)root.get("id"), (Object)UUID.fromString(((JpaRoleEntity)this.getDelegate()).getId())));
                    this.setDelegate((JpaRoleEntity)this.em.createQuery(query).getSingleResult());
                    return (JpaRoleEntity)this.getDelegate();
                }
                default: {
                    this.setDelegate((JpaRoleEntity)this.em.find(JpaRoleEntity.class, (Object)UUID.fromString(((JpaRoleEntity)this.getDelegate()).getId())));
                    return (JpaRoleEntity)this.getDelegate();
                }
            }
        } else {
            this.setDelegate((JpaRoleEntity)this.em.find(JpaRoleEntity.class, (Object)UUID.fromString(((JpaRoleEntity)this.getDelegate()).getId())));
        }
        return (JpaRoleEntity)this.getDelegate();
    }
}

