/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class InputLexer {
    private BufferedInputStream in;
    private boolean pushedBack;
    private byte backBuf;

    public InputLexer(BufferedInputStream in) throws IOException {
        this.in = in;
        this.pushedBack = false;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public boolean parseBoolean() throws IOException {
        int val = this.parseInt();
        return val != 0;
    }

    public int parseInt() throws IOException {
        long mask;
        long l = this.parseLong();
        if ((l & (mask = -4294967296L)) != 0L) {
            throw new IOException("Overflow error reading int from debug server (read " + l + ")");
        }
        return (int)l;
    }

    public long parseLong() throws IOException {
        this.skipWhitespace();
        byte b = this.readByte();
        if (!Character.isDigit((char)b)) {
            this.error();
        }
        long l = 0L;
        while (Character.isDigit((char)b)) {
            l *= 10L;
            l += (long)(b - 48);
            b = this.readByte();
        }
        this.pushBack(b);
        return l;
    }

    public long parseAddress() throws IOException {
        this.skipWhitespace();
        byte b = this.readByte();
        if (b != 48) {
            this.error();
        }
        if ((b = this.readByte()) != 120) {
            this.error();
        }
        long val = 0L;
        while (this.isHexDigit((char)(b = this.readByte()))) {
            val *= 16L;
            val += (long)Character.digit((char)b, 16);
        }
        this.pushBack(b);
        return val;
    }

    public void skipByte() throws IOException {
        this.readByte();
    }

    public byte readByte() throws IOException {
        if (this.pushedBack) {
            this.pushedBack = false;
            return this.backBuf;
        }
        return this.readByteInternal();
    }

    public void readBytes(byte[] buf, int off, int len) throws IOException {
        int startIdx = off;
        int numRead = 0;
        if (this.pushedBack) {
            buf[startIdx] = this.backBuf;
            this.pushedBack = false;
            ++startIdx;
            ++numRead;
        }
        while (numRead < len) {
            numRead += this.in.read(buf, startIdx + numRead, len - numRead);
        }
    }

    public char readChar() throws IOException {
        int hi = this.readByte() & 0xFF;
        int lo = this.readByte() & 0xFF;
        return (char)(hi << 8 | lo);
    }

    public long readUnsignedInt() throws IOException {
        long b1 = (long)this.readByte() & 0xFFL;
        long b2 = (long)this.readByte() & 0xFFL;
        long b3 = (long)this.readByte() & 0xFFL;
        long b4 = (long)this.readByte() & 0xFFL;
        return b1 << 24 | b2 << 16 | b3 << 8 | b4;
    }

    public String readByteString(int len) throws IOException {
        byte[] b = new byte[len];
        for (int i = 0; i < len; ++i) {
            b[i] = this.readByte();
        }
        try {
            return new String(b, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e.toString());
        }
    }

    public String readCharString(int len) throws IOException {
        char[] c = new char[len];
        for (int i = 0; i < len; ++i) {
            c[i] = this.readChar();
        }
        return new String(c);
    }

    private void skipWhitespace() throws IOException {
        byte b;
        while (Character.isWhitespace((char)(b = this.readByte()))) {
        }
        this.pushBack(b);
    }

    private boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    private void pushBack(byte b) {
        if (this.pushedBack) {
            throw new InternalError("Only one character pushback supported");
        }
        this.backBuf = b;
        this.pushedBack = true;
    }

    private byte readByteInternal() throws IOException {
        int i = this.in.read();
        if (i == -1) {
            throw new IOException("End-of-file reached while reading from server");
        }
        return (byte)i;
    }

    private void error() throws IOException {
        throw new IOException("Error parsing output of debug server");
    }
}

