/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.networking;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.FreeColServer;

public final class Server
extends Thread {
    private static final Logger logger = Logger.getLogger(Server.class.getName());
    private static final int BACKLOG_DEFAULT = 10;
    private final ServerSocket serverSocket;
    private final HashMap<Socket, Connection> connections = new HashMap();
    private boolean running = true;
    private final FreeColServer freeColServer;
    private final String host;
    private final int port;
    private final Object shutdownLock = new Object();

    public Server(FreeColServer freeColServer, String host, int port) throws IOException {
        super("FreeColServer:Server");
        this.freeColServer = freeColServer;
        this.host = host;
        this.port = port;
        this.serverSocket = new ServerSocket(port, 10, InetAddress.getByName(host));
        this.serverSocket.setReuseAddress(true);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Connection getConnection(Socket socket) {
        return this.connections.get(socket);
    }

    public void addDummyConnection(Connection connection) {
        if (!this.running) {
            return;
        }
        this.connections.put(new Socket(), connection);
    }

    public void addConnection(Connection connection) {
        if (!this.running) {
            return;
        }
        this.connections.put(connection.getSocket(), connection);
    }

    public void removeConnection(Connection connection) {
        this.connections.remove(connection.getSocket());
    }

    public void setMessageHandlerToAllConnections(MessageHandler mh) {
        for (Connection c : this.connections.values()) {
            c.setMessageHandler(mh);
        }
    }

    public void sendToAll(Message message, Connection exceptConnection) {
        for (Connection conn : CollectionUtils.transform(this.connections.values(), c -> c != exceptConnection)) {
            if (conn.isAlive()) {
                try {
                    conn.sendMessage(message);
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Unable to send to: " + conn, ex);
                }
                continue;
            }
            logger.log(Level.INFO, "Reap dead connection: " + conn);
            this.removeConnection(conn);
        }
    }

    public void setCommsLogging(boolean log) {
        for (Connection conn : this.connections.values()) {
            conn.setCommsLogging(log);
        }
    }

    public void sendToAll(Message message) {
        this.sendToAll(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Object object = this.shutdownLock;
        synchronized (object) {
            while (this.running) {
                try {
                    Socket sock = this.serverSocket.accept();
                    if (sock == null) continue;
                    this.freeColServer.addNewUserConnection(sock);
                }
                catch (Exception ex) {
                    if (!this.running) continue;
                    logger.log(Level.WARNING, "Connection failed: ", ex);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.running = false;
        try {
            this.serverSocket.close();
            logger.fine("Closed server socket.");
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not close the server socket!", e);
        }
        Iterator<Connection> iterator = this.shutdownLock;
        synchronized (iterator) {
            logger.fine("Wait for Server.run to complete.");
        }
        for (Connection c : CollectionUtils.transform(this.connections.values(), Connection::isAlive)) {
            c.disconnect();
        }
        this.connections.clear();
        this.freeColServer.removeFromMetaServer();
        logger.fine("Server shutdown.");
    }
}

