/* This file is autogenerated by sid_tables.py from sid.h. Do not edit directly. */

/*
 * Copyright 2015-2019 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef SID_TABLES_H
#define SID_TABLES_H

struct si_field {
        unsigned name_offset;
        unsigned mask;
        unsigned num_values;
        unsigned values_offset; /* offset into sid_strings_offsets */
};

struct si_reg {
        unsigned name_offset;
        unsigned offset;
        unsigned num_fields;
        unsigned fields_offset;
};

struct si_packet3 {
        unsigned name_offset;
        unsigned op;
};

static const struct si_packet3 packet3_table[] = {
	{0, PKT3_NOP},
	{4, PKT3_SET_BASE},
	{13, PKT3_CLEAR_STATE},
	{25, PKT3_INDEX_BUFFER_SIZE},
	{43, PKT3_DISPATCH_DIRECT},
	{59, PKT3_DISPATCH_INDIRECT},
	{77, PKT3_ATOMIC_MEM},
	{88, PKT3_OCCLUSION_QUERY},
	{104, PKT3_SET_PREDICATION},
	{120, PKT3_COND_EXEC},
	{130, PKT3_PRED_EXEC},
	{140, PKT3_DRAW_INDIRECT},
	{154, PKT3_DRAW_INDEX_INDIRECT},
	{174, PKT3_INDEX_BASE},
	{185, PKT3_DRAW_INDEX_2},
	{198, PKT3_CONTEXT_CONTROL},
	{214, PKT3_INDEX_TYPE},
	{225, PKT3_DRAW_INDIRECT_MULTI},
	{245, PKT3_DRAW_INDEX_AUTO},
	{261, PKT3_DRAW_INDEX_IMMD},
	{277, PKT3_NUM_INSTANCES},
	{291, PKT3_DRAW_INDEX_MULTI_AUTO},
	{313, PKT3_INDIRECT_BUFFER_SI},
	{332, PKT3_INDIRECT_BUFFER_CONST},
	{354, PKT3_STRMOUT_BUFFER_UPDATE},
	{376, PKT3_DRAW_INDEX_OFFSET_2},
	{396, PKT3_WRITE_DATA},
	{407, PKT3_DRAW_INDEX_INDIRECT_MULTI},
	{433, PKT3_MEM_SEMAPHORE},
	{447, PKT3_MPEG_INDEX},
	{458, PKT3_WAIT_REG_MEM},
	{471, PKT3_MEM_WRITE},
	{481, PKT3_INDIRECT_BUFFER_CIK},
	{501, PKT3_COPY_DATA},
	{511, PKT3_PFP_SYNC_ME},
	{523, PKT3_SURFACE_SYNC},
	{536, PKT3_ME_INITIALIZE},
	{550, PKT3_COND_WRITE},
	{561, PKT3_EVENT_WRITE},
	{573, PKT3_EVENT_WRITE_EOP},
	{589, PKT3_EVENT_WRITE_EOS},
	{605, PKT3_RELEASE_MEM},
	{617, PKT3_CONTEXT_REG_RMW},
	{633, PKT3_ONE_REG_WRITE},
	{647, PKT3_ACQUIRE_MEM},
	{659, PKT3_REWIND},
	{666, PKT3_LOAD_UCONFIG_REG},
	{683, PKT3_LOAD_SH_REG},
	{695, PKT3_LOAD_CONTEXT_REG},
	{712, PKT3_LOAD_SH_REG_INDEX},
	{730, PKT3_SET_CONFIG_REG},
	{745, PKT3_SET_CONTEXT_REG},
	{761, PKT3_SET_SH_REG},
	{772, PKT3_SET_SH_REG_OFFSET},
	{790, PKT3_SET_UCONFIG_REG},
	{806, PKT3_SET_UCONFIG_REG_INDEX},
	{828, PKT3_LOAD_CONST_RAM},
	{843, PKT3_WRITE_CONST_RAM},
	{859, PKT3_DUMP_CONST_RAM},
	{874, PKT3_INCREMENT_CE_COUNTER},
	{895, PKT3_INCREMENT_DE_COUNTER},
	{916, PKT3_WAIT_ON_CE_COUNTER},
	{935, PKT3_SET_SH_REG_INDEX},
	{952, PKT3_LOAD_CONTEXT_REG_INDEX},
	{975, PKT3_DISPATCH_TASK_STATE_INIT},
	{1000, PKT3_DISPATCH_MESH_INDIRECT_MULTI},
	{1029, PKT3_DISPATCH_TASKMESH_GFX},
	{1051, PKT3_DISPATCH_TASKMESH_DIRECT_ACE},
	{1080, PKT3_DISPATCH_TASKMESH_INDIRECT_MULTI_ACE},
	{1117, PKT3_IT_OPCODE_C},
	{1129, PKT3_CP_DMA},
	{1136, PKT3_DMA_DATA},
};

static const struct si_reg gfx10_reg_table[] = {
	{1145, 1028, 10, 0},
	{1158, 1032, 20, 10},
	{1173, 1036, 10, 30},
	{1189, 1040, 12, 40},
	{1210, 1044, 4, 52},
	{1228, 1048, 3, 56},
	{1246, 1052, 11, 59},
	{1261, 1056},
	{1275, 1060, 1, 70},
	{1289, 1064},
	{1306, 1076, 9, 71},
	{1322, 1080},
	{1339, 1116, 5, 80},
	{1354, 1120, 7, 85},
	{1369, 1124, 2, 92},
	{1389, 1128, 1, 94},
	{1408, 1132, 4, 95},
	{1428, 1136, 7, 99},
	{1444, 2480},
	{1458, 2484},
	{1472, 2488},
	{1486, 2492},
	{1500, 2496},
	{1514, 2500},
	{1528, 2504},
	{1542, 2508},
	{1556, 2512},
	{1570, 2516},
	{1584, 2520},
	{1599, 2524},
	{1614, 2528},
	{1629, 2532},
	{1644, 2536},
	{1659, 2540},
	{1674, 2544},
	{1685, 2552},
	{1701, 2556},
	{1717, 2560},
	{1741, 2564},
	{1765, 2568},
	{1789, 32776, 27, 106},
	{1802, 32784, 21, 133},
	{1814, 32788, 14, 154},
	{1830, 32792, 14, 154},
	{1846, 32796, 15, 168},
	{1859, 32824, 14, 154},
	{1875, 32828, 14, 154},
	{1891, 33296, 21, 183},
	{1905, 33300, 28, 204},
	{1922, 33304, 15, 232},
	{1943, 33308, 28, 247},
	{1957, 33312, 32, 275},
	{1974, 33316, 13, 307},
	{1995, 33320, 9, 320},
	{2013, 33324, 1, 329},
	{2036, 33344, 2, 330},
	{2057, 33348},
	{2077, 33352, 1, 332},
	{2100, 33356, 9, 333},
	{2118, 33436, 1, 342},
	{2141, 36096},
	{2167, 36100, 2, 343},
	{2193, 36104},
	{2219, 36108, 2, 343},
	{2245, 36112, 2, 345},
	{2266, 36116, 4, 347},
	{2287, 36120, 4, 351},
	{2314, 36124, 17, 355},
	{2335, 36128, 6, 372},
	{2358, 36132},
	{2387, 36140},
	{2417, 36144},
	{2449, 36148},
	{2480, 36152},
	{2513, 36348, 5, 378},
	{2522, 36608},
	{2540, 36612, 4, 383},
	{2558, 36616},
	{2576, 36620, 10, 387},
	{2594, 36656, 14, 397},
	{2612, 36660, 4, 411},
	{2630, 36664, 12, 415},
	{2648, 36668, 2, 427},
	{2666, 37120, 9, 429},
	{2682, 39160, 5, 438},
	{2697, 39184, 5, 443},
	{2711, 39188, 5, 443},
	{2725, 39192, 5, 443},
	{2739, 39196, 5, 443},
	{2753, 39200, 5, 443},
	{2767, 39204, 5, 443},
	{2781, 39208, 5, 443},
	{2795, 39212, 5, 443},
	{2809, 39216, 5, 443},
	{2823, 39220, 5, 443},
	{2837, 39224, 5, 443},
	{2852, 39228, 5, 443},
	{2867, 39232, 5, 443},
	{2882, 39236, 5, 443},
	{2897, 39240, 5, 443},
	{2912, 39244, 5, 443},
	{2927, 39248, 5, 443},
	{2942, 39252, 5, 443},
	{2957, 39256, 5, 443},
	{2972, 39260, 5, 443},
	{2987, 39264, 5, 443},
	{3002, 39268, 5, 443},
	{3017, 39272, 5, 443},
	{3032, 39276, 5, 443},
	{3047, 39280, 5, 443},
	{3062, 39284, 5, 443},
	{3077, 39288, 5, 443},
	{3092, 39292, 5, 443},
	{3107, 39296, 5, 443},
	{3122, 39300, 5, 443},
	{3137, 39304, 5, 443},
	{3152, 39308, 5, 443},
	{3167, 39312, 4, 448},
	{3186, 39316, 4, 448},
	{3205, 39320, 4, 448},
	{3224, 39324, 4, 448},
	{3243, 39328, 4, 448},
	{3262, 39332, 4, 448},
	{3281, 39336, 4, 448},
	{3300, 39340, 4, 448},
	{3319, 39344, 4, 448},
	{3338, 39348, 4, 448},
	{3357, 39352, 4, 448},
	{3377, 39356, 4, 448},
	{3397, 39360, 4, 448},
	{3417, 39364, 4, 448},
	{3437, 39368, 4, 448},
	{3457, 39372, 4, 448},
	{3477, 40960},
	{3495, 40964, 4, 452},
	{3513, 40968, 3, 456},
	{3531, 40972, 9, 459},
	{3549, 40976, 2, 468},
	{3567, 40980, 7, 470},
	{3585, 40984, 10, 477},
	{3603, 40988},
	{3621, 45060, 1, 487},
	{3645, 45080},
	{3670, 45084, 3, 488},
	{3694, 45088},
	{3715, 45092, 1, 491},
	{3736, 45096, 11, 492},
	{3760, 45100, 10, 503},
	{3784, 45104},
	{3810, 45108},
	{3836, 45112},
	{3862, 45116},
	{3888, 45120},
	{3914, 45124},
	{3940, 45128},
	{3966, 45132},
	{3992, 45136},
	{4018, 45140},
	{4044, 45144},
	{4071, 45148},
	{4098, 45152},
	{4125, 45156},
	{4152, 45160},
	{4179, 45164},
	{4206, 45168},
	{4233, 45172},
	{4260, 45176},
	{4287, 45180},
	{4314, 45184},
	{4341, 45188},
	{4368, 45192},
	{4395, 45196},
	{4422, 45200},
	{4449, 45204},
	{4476, 45208},
	{4503, 45212},
	{4530, 45216},
	{4557, 45220},
	{4584, 45224},
	{4611, 45228},
	{4638, 45248, 8, 513},
	{4661, 45252, 5, 521},
	{4694, 45256, 1, 526},
	{4721, 45260, 1, 526},
	{4748, 45264, 1, 526},
	{4775, 45268, 1, 526},
	{4802, 45316, 1, 487},
	{4826, 45332},
	{4851, 45336, 3, 488},
	{4875, 45340, 1, 527},
	{4900, 45344},
	{4921, 45348, 1, 491},
	{4942, 45352, 12, 528},
	{4966, 45356, 14, 540},
	{4990, 45360},
	{5016, 45364},
	{5042, 45368},
	{5068, 45372},
	{5094, 45376},
	{5120, 45380},
	{5146, 45384},
	{5172, 45388},
	{5198, 45392},
	{5224, 45396},
	{5250, 45400},
	{5277, 45404},
	{5304, 45408},
	{5331, 45412},
	{5358, 45416},
	{5385, 45420},
	{5412, 45424},
	{5439, 45428},
	{5466, 45432},
	{5493, 45436},
	{5520, 45440},
	{5547, 45444},
	{5574, 45448},
	{5601, 45452},
	{5628, 45456},
	{5655, 45460},
	{5682, 45464},
	{5709, 45468},
	{5736, 45472},
	{5763, 45476},
	{5790, 45480},
	{5817, 45484},
	{5844, 45504, 8, 513},
	{5867, 45508, 5, 521},
	{5900, 45512, 1, 526},
	{5927, 45516, 1, 526},
	{5954, 45520, 1, 526},
	{5981, 45524, 1, 526},
	{6008, 45548, 9, 554},
	{6035, 45552, 6, 563},
	{6062, 45556, 5, 569},
	{6089, 45568},
	{6114, 45572, 2, 574},
	{6138, 45576},
	{6170, 45580},
	{6202, 45584},
	{6226, 45588, 1, 491},
	{6250, 45596, 4, 576},
	{6274, 45600},
	{6295, 45604, 1, 491},
	{6316, 45608, 13, 580},
	{6340, 45612, 9, 593},
	{6364, 45616},
	{6390, 45620},
	{6416, 45624},
	{6442, 45628},
	{6468, 45632},
	{6494, 45636},
	{6520, 45640},
	{6546, 45644},
	{6572, 45648},
	{6598, 45652},
	{6624, 45656},
	{6651, 45660},
	{6678, 45664},
	{6705, 45668},
	{6732, 45672},
	{6759, 45676},
	{6786, 45680},
	{6813, 45684},
	{6840, 45688},
	{6867, 45692},
	{6894, 45696},
	{6921, 45700},
	{6948, 45704},
	{6975, 45708},
	{7002, 45712},
	{7029, 45716},
	{7056, 45720},
	{7083, 45724},
	{7110, 45728},
	{7137, 45732},
	{7164, 45736},
	{7191, 45740},
	{7218, 45760, 8, 513},
	{7243, 45764, 5, 521},
	{7278, 45768, 1, 526},
	{7307, 45772, 1, 526},
	{7336, 45776, 1, 526},
	{7365, 45780, 1, 526},
	{7394, 45808, 6, 563},
	{7421, 45852, 4, 576},
	{7445, 45856},
	{7466, 45860, 1, 491},
	{7487, 45864, 10, 602},
	{7511, 45868, 6, 563},
	{7535, 45872},
	{7561, 45876},
	{7587, 45880},
	{7613, 45884},
	{7639, 45888},
	{7665, 45892},
	{7691, 45896},
	{7717, 45900},
	{7743, 45904},
	{7769, 45908},
	{7795, 45912},
	{7822, 45916},
	{7849, 45920},
	{7876, 45924},
	{7903, 45928},
	{7930, 45932},
	{7957, 46068, 5, 569},
	{7984, 46080},
	{8009, 46084, 1, 487},
	{8033, 46088},
	{8065, 46092},
	{8097, 46096},
	{8121, 46100, 1, 491},
	{8145, 46108, 4, 612},
	{8169, 46112},
	{8190, 46116, 1, 491},
	{8211, 46120, 12, 616},
	{8235, 46124, 9, 628},
	{8259, 46128},
	{8285, 46132},
	{8311, 46136},
	{8337, 46140},
	{8363, 46144},
	{8389, 46148},
	{8415, 46152},
	{8441, 46156},
	{8467, 46160},
	{8493, 46164},
	{8519, 46168},
	{8546, 46172},
	{8573, 46176},
	{8600, 46180},
	{8627, 46184},
	{8654, 46188},
	{8681, 46192},
	{8708, 46196},
	{8735, 46200},
	{8762, 46204},
	{8789, 46208},
	{8816, 46212},
	{8843, 46216},
	{8870, 46220},
	{8897, 46224},
	{8924, 46228},
	{8951, 46232},
	{8978, 46236},
	{9005, 46240},
	{9032, 46244},
	{9059, 46248},
	{9086, 46252},
	{9113, 46272, 8, 513},
	{9138, 46276, 5, 521},
	{9173, 46280, 1, 526},
	{9202, 46284, 1, 526},
	{9231, 46288, 1, 526},
	{9260, 46292, 1, 526},
	{9289, 46324, 5, 569},
	{9316, 46364, 4, 576},
	{9340, 46368},
	{9361, 46372, 1, 491},
	{9382, 46376, 9, 637},
	{9406, 46380, 5, 569},
	{9430, 46384},
	{9456, 46388},
	{9482, 46392},
	{9508, 46396},
	{9534, 46400},
	{9560, 46404},
	{9586, 46408},
	{9612, 46412},
	{9638, 46416},
	{9664, 46420},
	{9690, 46424},
	{9717, 46428},
	{9744, 46432},
	{9771, 46436},
	{9798, 46440},
	{9825, 46444},
	{9852, 47104, 13, 646},
	{9879, 47108},
	{9893, 47112},
	{9907, 47116},
	{9921, 47120},
	{9937, 47124},
	{9953, 47128},
	{9969, 47132, 2, 659},
	{9990, 47136, 2, 659},
	{10011, 47140, 2, 659},
	{10032, 47144, 1, 661},
	{10060, 47148, 1, 662},
	{10085, 47152},
	{10100, 47156, 1, 663},
	{10115, 47160},
	{10144, 47164, 1, 663},
	{10173, 47168},
	{10206, 47172, 1, 663},
	{10239, 47176, 12, 664},
	{10257, 47180, 11, 676},
	{10275, 47184, 1, 687},
	{10288, 47188, 6, 688},
	{10312, 47192},
	{10339, 47196},
	{10366, 47200, 2, 694},
	{10387, 47204},
	{10414, 47208},
	{10441, 47212},
	{10459, 47216},
	{10477, 47220},
	{10495, 47224, 1, 696},
	{10523, 47228, 5, 697},
	{10545, 47232},
	{10565, 47236},
	{10588, 47240, 9, 702},
	{10605, 47248, 1, 526},
	{10626, 47252, 1, 526},
	{10647, 47256, 1, 526},
	{10668, 47260, 1, 526},
	{10689, 47264, 1, 711},
	{10707, 47268, 1, 712},
	{10726, 47272},
	{10748, 47276, 3, 713},
	{10765, 47280},
	{10794, 47284, 1, 716},
	{10823, 47288, 3, 713},
	{10841, 47360},
	{10861, 47364},
	{10881, 47368},
	{10901, 47372},
	{10921, 47376},
	{10941, 47380},
	{10961, 47384},
	{10981, 47388},
	{11001, 47392},
	{11021, 47396},
	{11041, 47400},
	{11062, 47404},
	{11083, 47408},
	{11104, 47412},
	{11125, 47416},
	{11146, 47420},
	{11167, 47604, 2, 717},
	{11191, 47608},
	{11212, 47612},
	{11228, 163840, 10, 719},
	{11246, 163844, 11, 729},
	{11263, 163848, 7, 740},
	{11277, 163852, 23, 747},
	{11296, 163856, 16, 770},
	{11316, 163860},
	{11335, 163868, 2, 786},
	{11352, 163872},
	{11372, 163876},
	{11392, 163880, 1, 788},
	{11409, 163884},
	{11424, 163888, 2, 789},
	{11448, 163892, 2, 791},
	{11472, 163896, 3, 793},
	{11488, 163900, 8, 796},
	{11506, 163904, 14, 804},
	{11516, 163908, 9, 818},
	{11532, 163912},
	{11547, 163916},
	{11568, 163920},
	{11584, 163924},
	{11606, 163928, 2, 827},
	{11624, 163932, 1, 829},
	{11642, 163944, 1, 830},
	{11660, 163948, 1, 830},
	{11684, 163952, 1, 830},
	{11703, 163956, 1, 830},
	{11728, 163960, 1, 830},
	{11750, 163964, 9, 831},
	{11774, 163968},
	{11790, 163972, 1, 840},
	{11809, 164328, 1, 841},
	{11830, 164332, 1, 841},
	{11851, 164336, 1, 841},
	{11872, 164340, 1, 841},
	{11893, 164344},
	{11911, 164348},
	{11929, 164352, 2, 842},
	{11949, 164356, 3, 844},
	{11973, 164360, 2, 847},
	{11997, 164364, 1, 849},
	{12017, 164368, 2, 844},
	{12037, 164372, 2, 847},
	{12057, 164376, 2, 844},
	{12077, 164380, 2, 847},
	{12097, 164384, 2, 844},
	{12117, 164388, 2, 847},
	{12137, 164392, 2, 844},
	{12157, 164396, 2, 847},
	{12177, 164400, 7, 850},
	{12192, 164404, 2, 857},
	{12221, 164408, 8, 859},
	{12236, 164412, 8, 867},
	{12251, 164416, 3, 844},
	{12276, 164420, 2, 847},
	{12301, 164424},
	{12319, 164428},
	{12337, 164432, 3, 844},
	{12362, 164436, 2, 847},
	{12387, 164440, 3, 844},
	{12412, 164444, 2, 847},
	{12437, 164448, 3, 844},
	{12462, 164452, 2, 847},
	{12487, 164456, 3, 844},
	{12512, 164460, 2, 847},
	{12537, 164464, 3, 844},
	{12562, 164468, 2, 847},
	{12587, 164472, 3, 844},
	{12612, 164476, 2, 847},
	{12637, 164480, 3, 844},
	{12662, 164484, 2, 847},
	{12687, 164488, 3, 844},
	{12712, 164492, 2, 847},
	{12737, 164496, 3, 844},
	{12762, 164500, 2, 847},
	{12787, 164504, 3, 844},
	{12812, 164508, 2, 847},
	{12837, 164512, 3, 844},
	{12863, 164516, 2, 847},
	{12889, 164520, 3, 844},
	{12915, 164524, 2, 847},
	{12941, 164528, 3, 844},
	{12967, 164532, 2, 847},
	{12993, 164536, 3, 844},
	{13019, 164540, 2, 847},
	{13045, 164544, 3, 844},
	{13071, 164548, 2, 847},
	{13097, 164552, 3, 844},
	{13123, 164556, 2, 847},
	{13149, 164560},
	{13168, 164564},
	{13187, 164568},
	{13206, 164572},
	{13225, 164576},
	{13244, 164580},
	{13263, 164584},
	{13282, 164588},
	{13301, 164592},
	{13320, 164596},
	{13339, 164600},
	{13358, 164604},
	{13377, 164608},
	{13396, 164612},
	{13415, 164616},
	{13434, 164620},
	{13453, 164624},
	{13472, 164628},
	{13491, 164632},
	{13510, 164636},
	{13529, 164640},
	{13549, 164644},
	{13569, 164648},
	{13589, 164652},
	{13609, 164656},
	{13629, 164660},
	{13649, 164664},
	{13669, 164668},
	{13689, 164672},
	{13709, 164676},
	{13729, 164680},
	{13749, 164684},
	{13769, 164688, 15, 875},
	{13789, 164692, 3, 890},
	{13811, 164696, 2, 893},
	{13839, 164700, 7, 895},
	{13868, 164704, 1, 902},
	{13889, 164708, 1, 903},
	{13899, 164712, 1, 904},
	{13907, 164768, 4, 905},
	{13929, 164772, 4, 905},
	{13950, 164776, 4, 909},
	{13967, 164864},
	{13984, 164868},
	{14001, 164872},
	{14017, 164876},
	{14046, 164880, 10, 913},
	{14071, 164884},
	{14084, 164888},
	{14099, 164892},
	{14113, 164896},
	{14128, 164900, 8, 923},
	{14143, 164904, 4, 931},
	{14167, 164908, 6, 935},
	{14186, 164912, 4, 941},
	{14204, 164916, 4, 945},
	{14225, 164924},
	{14244, 164928},
	{14264, 164932},
	{14283, 164936},
	{14303, 164940},
	{14322, 164944},
	{14342, 164948},
	{14363, 164952},
	{14385, 164956},
	{14406, 164960},
	{14428, 164964},
	{14449, 164968},
	{14471, 164972},
	{14492, 164976},
	{14514, 164980},
	{14535, 164984},
	{14557, 164988},
	{14578, 164992},
	{14600, 164996},
	{14621, 165000},
	{14643, 165004},
	{14664, 165008},
	{14686, 165012},
	{14707, 165016},
	{14729, 165020},
	{14750, 165024},
	{14772, 165028},
	{14793, 165032},
	{14815, 165036},
	{14836, 165040},
	{14858, 165044},
	{14879, 165048},
	{14901, 165052},
	{14922, 165056},
	{14944, 165060},
	{14965, 165064},
	{14987, 165068},
	{15008, 165072},
	{15030, 165076},
	{15051, 165080},
	{15073, 165084},
	{15094, 165088},
	{15116, 165092},
	{15137, 165096},
	{15159, 165100},
	{15180, 165104},
	{15202, 165108},
	{15223, 165112},
	{15245, 165116},
	{15266, 165120},
	{15288, 165124},
	{15309, 165128},
	{15331, 165132},
	{15352, 165136},
	{15374, 165140},
	{15395, 165144},
	{15417, 165148},
	{15438, 165152},
	{15460, 165156},
	{15481, 165160},
	{15503, 165164},
	{15525, 165168},
	{15548, 165172},
	{15570, 165176},
	{15593, 165180},
	{15615, 165184},
	{15638, 165188},
	{15660, 165192},
	{15683, 165196},
	{15705, 165200},
	{15728, 165204},
	{15750, 165208},
	{15773, 165212},
	{15795, 165216},
	{15818, 165220},
	{15840, 165224},
	{15863, 165228},
	{15885, 165232},
	{15908, 165236},
	{15930, 165240},
	{15953, 165244},
	{15975, 165248},
	{15998, 165252},
	{16020, 165256},
	{16043, 165260},
	{16065, 165264},
	{16088, 165268},
	{16110, 165272},
	{16133, 165276},
	{16155, 165280},
	{16178, 165284},
	{16200, 165288},
	{16223, 165292},
	{16245, 165296},
	{16268, 165300},
	{16290, 165304},
	{16313, 165308},
	{16327, 165312},
	{16341, 165316},
	{16355, 165320},
	{16369, 165324},
	{16383, 165328},
	{16397, 165332},
	{16411, 165336},
	{16425, 165340},
	{16439, 165344},
	{16453, 165348},
	{16467, 165352},
	{16481, 165356},
	{16495, 165360},
	{16509, 165364},
	{16523, 165368},
	{16537, 165372},
	{16551, 165376},
	{16565, 165380},
	{16579, 165384},
	{16593, 165388},
	{16607, 165392},
	{16621, 165396},
	{16635, 165400},
	{16649, 165404},
	{16672, 165444, 12, 949},
	{16692, 165448, 12, 949},
	{16712, 165452, 12, 949},
	{16732, 165456, 12, 949},
	{16752, 165460, 12, 949},
	{16772, 165464, 12, 949},
	{16792, 165468, 12, 949},
	{16812, 165472, 12, 949},
	{16832, 165476, 12, 949},
	{16852, 165480, 12, 949},
	{16872, 165484, 12, 949},
	{16893, 165488, 12, 949},
	{16914, 165492, 12, 949},
	{16935, 165496, 12, 949},
	{16956, 165500, 12, 949},
	{16977, 165504, 12, 949},
	{16998, 165508, 12, 949},
	{17019, 165512, 12, 949},
	{17040, 165516, 12, 949},
	{17061, 165520, 12, 949},
	{17082, 165524, 9, 961},
	{17103, 165528, 9, 961},
	{17124, 165532, 9, 961},
	{17145, 165536, 9, 961},
	{17166, 165540, 9, 961},
	{17187, 165544, 9, 961},
	{17208, 165548, 9, 961},
	{17229, 165552, 9, 961},
	{17250, 165556, 9, 961},
	{17271, 165560, 9, 961},
	{17292, 165564, 9, 961},
	{17313, 165568, 9, 961},
	{17334, 165572, 3, 970},
	{17352, 165580, 16, 973},
	{17369, 165584, 16, 973},
	{17387, 165588, 7, 989},
	{17408, 165592, 6, 996},
	{17426, 165600, 7, 1002},
	{17441, 165608, 2, 694},
	{17458, 165640, 1, 1009},
	{17480, 165644, 5, 1010},
	{17502, 165648, 1, 1015},
	{17522, 165652, 8, 1016},
	{17544, 165716, 8, 1024},
	{17562, 165720, 8, 1032},
	{17583, 165724, 17, 1040},
	{17604, 165728, 6, 1057},
	{17622, 165732, 6, 1057},
	{17640, 165736, 6, 1057},
	{17658, 165740, 6, 1057},
	{17676, 165744, 6, 1057},
	{17694, 165748, 6, 1057},
	{17712, 165752, 6, 1057},
	{17730, 165756, 6, 1057},
	{17748, 165760, 9, 1063},
	{17766, 165764, 9, 1063},
	{17784, 165768, 9, 1063},
	{17802, 165772, 9, 1063},
	{17820, 165776, 9, 1063},
	{17838, 165780, 9, 1063},
	{17856, 165784, 9, 1063},
	{17874, 165788, 9, 1063},
	{17892, 165836, 1, 1072},
	{17906, 165840, 1, 1072},
	{17921, 165844},
	{17939, 165848},
	{17957, 165852},
	{17974, 165856},
	{17995, 165860, 1, 1073},
	{18011, 165864},
	{18024, 165872, 8, 1074},
	{18043, 165876},
	{18058, 165880, 1, 1082},
	{18080, 165884, 1, 1083},
	{18107, 165888, 10, 1084},
	{18124, 165892, 12, 1094},
	{18132, 165896, 4, 1106},
	{18149, 165900, 17, 1110},
	{18167, 165904, 20, 1127},
	{18183, 165908, 16, 1147},
	{18202, 165912, 10, 1163},
	{18217, 165916, 28, 1173},
	{18235, 165920, 16, 1201},
	{18253, 165924, 4, 1217},
	{18277, 165928},
	{18302, 165932, 11, 1221},
	{18325, 165936, 7, 1232},
	{18354, 165940, 2, 1239},
	{18376, 165944, 2, 1241},
	{18391, 165948, 5, 1243},
	{18421, 165952, 5, 1248},
	{18436, 165956},
	{18454, 166400, 2, 1253},
	{18471, 166404, 2, 1255},
	{18490, 166408, 1, 1257},
	{18506, 166412, 4, 1258},
	{18525, 166416, 1, 1262},
	{18546, 166420, 1, 1263},
	{18559, 166424},
	{18582, 166428},
	{18605, 166432, 1, 1264},
	{18625, 166436, 4, 1265},
	{18645, 166440, 1, 1269},
	{18666, 166444, 1, 1270},
	{18681, 166448, 6, 1271},
	{18703, 166452, 6, 1271},
	{18725, 166456, 8, 1277},
	{18751, 166460, 8, 1277},
	{18777, 166464, 15, 1285},
	{18789, 166468, 3, 1300},
	{18808, 166472, 7, 1303},
	{18826, 166476, 24, 1310},
	{18844, 166480},
	{18856, 166484, 1, 1334},
	{18870, 166488, 1, 1335},
	{18884, 166492, 1, 1336},
	{18898, 166496, 1, 1337},
	{18921, 166500, 1, 1337},
	{18944, 166504, 1, 1337},
	{18967, 166508, 5, 1338},
	{18988, 166512},
	{18999, 166516},
	{19012, 166520},
	{19029, 166524, 8, 1343},
	{19048, 166528},
	{19059, 166532, 3, 1351},
	{19078, 166536},
	{19100, 166540},
	{19122, 166544, 3, 1354},
	{19142, 166548, 2, 1357},
	{19169, 166552, 5, 1359},
	{19191, 166560},
	{19216, 166564},
	{19241, 166568, 6, 1364},
	{19260, 166572, 1, 1370},
	{19283, 166576, 1, 1370},
	{19306, 166580, 1, 1371},
	{19320, 166584, 1, 1372},
	{19335, 166588, 9, 1373},
	{19352, 166592, 4, 1382},
	{19379, 166596, 4, 1386},
	{19406, 166600, 4, 1390},
	{19425, 166608},
	{19451, 166612, 1, 1394},
	{19476, 166620},
	{19504, 166624},
	{19530, 166628, 1, 1394},
	{19555, 166636},
	{19583, 166640},
	{19609, 166644, 1, 1394},
	{19634, 166652},
	{19662, 166656},
	{19688, 166660, 1, 1394},
	{19713, 166668},
	{19741, 166696},
	{19772, 166700},
	{19815, 166704, 1, 1395},
	{19853, 166712, 1, 1396},
	{19873, 166732, 2, 1397},
	{19892, 166736, 5, 1399},
	{19914, 166740, 19, 1404},
	{19935, 166744, 3, 1423},
	{19952, 166748, 1, 1370},
	{19973, 166752, 1, 1370},
	{19996, 166756, 1, 1370},
	{20019, 166760, 1, 1370},
	{20042, 166764, 12, 1426},
	{20055, 166768, 6, 1438},
	{20072, 166772},
	{20096, 166776, 2, 1444},
	{20126, 166780},
	{20150, 166784},
	{20180, 166788},
	{20211, 166792},
	{20240, 166796},
	{20270, 166800, 3, 1446},
	{20290, 166804, 8, 1449},
	{20309, 166808, 4, 1457},
	{20335, 166812, 3, 1354},
	{20359, 166868, 8, 1461},
	{20385, 166872, 8, 1469},
	{20411, 166876, 5, 1477},
	{20427, 166880, 6, 1482},
	{20443, 166884, 3, 1488},
	{20458, 166888},
	{20481, 166892},
	{20504, 166896},
	{20527, 166900},
	{20550, 166904, 8, 1491},
	{20584, 166908, 8, 1499},
	{20618, 166912, 8, 1507},
	{20652, 166916, 8, 1515},
	{20686, 166920, 8, 1491},
	{20720, 166924, 8, 1499},
	{20754, 166928, 8, 1507},
	{20788, 166932, 8, 1515},
	{20822, 166936, 8, 1491},
	{20856, 166940, 8, 1499},
	{20890, 166944, 8, 1507},
	{20924, 166948, 8, 1515},
	{20958, 166952, 8, 1491},
	{20992, 166956, 8, 1499},
	{21026, 166960, 8, 1507},
	{21060, 166964, 8, 1515},
	{21094, 166968, 2, 1523},
	{21118, 166972, 2, 1525},
	{21142, 166976, 4, 1527},
	{21163, 166980, 12, 1531},
	{21183, 166984, 2, 1543},
	{21203, 166988, 20, 1545},
	{21241, 166992, 2, 1565},
	{21261, 167000, 1, 1567},
	{21289, 167004, 1, 1568},
	{21310, 167008},
	{21325, 167012, 2, 1569},
	{21341, 167016, 1, 1571},
	{21357, 167020, 3, 1572},
	{21372, 167024, 19, 1575},
	{21387, 167028, 8, 1594},
	{21404, 167032, 12, 1602},
	{21426, 167036},
	{21442, 167040, 1, 1614},
	{21464, 167044},
	{21480, 167048, 1, 1571},
	{21502, 167052},
	{21524, 167056},
	{21546, 167060},
	{21565, 167068},
	{21580, 167072, 2, 1569},
	{21596, 167076, 1, 1571},
	{21612, 167080, 3, 1572},
	{21627, 167084, 19, 1575},
	{21642, 167088, 8, 1594},
	{21659, 167092, 12, 1602},
	{21681, 167096},
	{21697, 167100, 1, 1614},
	{21719, 167104},
	{21735, 167108, 1, 1571},
	{21757, 167112},
	{21779, 167116},
	{21801, 167120},
	{21820, 167128},
	{21835, 167132, 2, 1569},
	{21851, 167136, 1, 1571},
	{21867, 167140, 3, 1572},
	{21882, 167144, 19, 1575},
	{21897, 167148, 8, 1594},
	{21914, 167152, 12, 1602},
	{21936, 167156},
	{21952, 167160, 1, 1614},
	{21974, 167164},
	{21990, 167168, 1, 1571},
	{22012, 167172},
	{22034, 167176},
	{22056, 167180},
	{22075, 167188},
	{22090, 167192, 2, 1569},
	{22106, 167196, 1, 1571},
	{22122, 167200, 3, 1572},
	{22137, 167204, 19, 1575},
	{22152, 167208, 8, 1594},
	{22169, 167212, 12, 1602},
	{22191, 167216},
	{22207, 167220, 1, 1614},
	{22229, 167224},
	{22245, 167228, 1, 1571},
	{22267, 167232},
	{22289, 167236},
	{22311, 167240},
	{22330, 167248},
	{22345, 167252, 2, 1569},
	{22361, 167256, 1, 1571},
	{22377, 167260, 3, 1572},
	{22392, 167264, 19, 1575},
	{22407, 167268, 8, 1594},
	{22424, 167272, 12, 1602},
	{22446, 167276},
	{22462, 167280, 1, 1614},
	{22484, 167284},
	{22500, 167288, 1, 1571},
	{22522, 167292},
	{22544, 167296},
	{22566, 167300},
	{22585, 167308},
	{22600, 167312, 2, 1569},
	{22616, 167316, 1, 1571},
	{22632, 167320, 3, 1572},
	{22647, 167324, 19, 1575},
	{22662, 167328, 8, 1594},
	{22679, 167332, 12, 1602},
	{22701, 167336},
	{22717, 167340, 1, 1614},
	{22739, 167344},
	{22755, 167348, 1, 1571},
	{22777, 167352},
	{22799, 167356},
	{22821, 167360},
	{22840, 167368},
	{22855, 167372, 2, 1569},
	{22871, 167376, 1, 1571},
	{22887, 167380, 3, 1572},
	{22902, 167384, 19, 1575},
	{22917, 167388, 8, 1594},
	{22934, 167392, 12, 1602},
	{22956, 167396},
	{22972, 167400, 1, 1614},
	{22994, 167404},
	{23010, 167408, 1, 1571},
	{23032, 167412},
	{23054, 167416},
	{23076, 167420},
	{23095, 167428},
	{23110, 167432, 2, 1569},
	{23126, 167436, 1, 1571},
	{23142, 167440, 3, 1572},
	{23157, 167444, 19, 1575},
	{23172, 167448, 8, 1594},
	{23189, 167452, 12, 1602},
	{23211, 167456},
	{23227, 167460, 1, 1614},
	{23249, 167464},
	{23265, 167468, 1, 1571},
	{23287, 167472},
	{23309, 167476},
	{23331, 167480},
	{23350, 167488, 1, 1615},
	{23369, 167492, 1, 1615},
	{23388, 167496, 1, 1615},
	{23407, 167500, 1, 1615},
	{23426, 167504, 1, 1615},
	{23445, 167508, 1, 1615},
	{23464, 167512, 1, 1615},
	{23483, 167516, 1, 1615},
	{23502, 167520, 1, 1615},
	{23527, 167524, 1, 1615},
	{23552, 167528, 1, 1615},
	{23577, 167532, 1, 1615},
	{23602, 167536, 1, 1615},
	{23627, 167540, 1, 1615},
	{23652, 167544, 1, 1615},
	{23677, 167548, 1, 1615},
	{23702, 167552, 1, 1615},
	{23727, 167556, 1, 1615},
	{23752, 167560, 1, 1615},
	{23777, 167564, 1, 1615},
	{23802, 167568, 1, 1615},
	{23827, 167572, 1, 1615},
	{23852, 167576, 1, 1615},
	{23877, 167580, 1, 1615},
	{23902, 167584, 1, 1615},
	{23925, 167588, 1, 1615},
	{23948, 167592, 1, 1615},
	{23971, 167596, 1, 1615},
	{23994, 167600, 1, 1615},
	{24017, 167604, 1, 1615},
	{24040, 167608, 1, 1615},
	{24063, 167612, 1, 1615},
	{24086, 167616, 3, 1616},
	{24104, 167620, 3, 1616},
	{24122, 167624, 3, 1616},
	{24140, 167628, 3, 1616},
	{24158, 167632, 3, 1616},
	{24176, 167636, 3, 1616},
	{24194, 167640, 3, 1616},
	{24212, 167644, 3, 1616},
	{24230, 167648, 8, 1619},
	{24248, 167652, 8, 1619},
	{24266, 167656, 8, 1619},
	{24284, 167660, 8, 1619},
	{24302, 167664, 8, 1619},
	{24320, 167668, 8, 1619},
	{24338, 167672, 8, 1619},
	{24356, 167676, 8, 1619},
	{24374, 196608, 1, 1627},
	{24394, 196612, 1, 1628},
	{24414, 196616},
	{24434, 196620},
	{24454, 196624},
	{24475, 196628},
	{24496, 196632, 1, 1629},
	{24518, 196636, 1, 1630},
	{24540, 196640},
	{24570, 196644},
	{24600, 196648},
	{24629, 196652},
	{24658, 196656},
	{24688, 196660},
	{24718, 196664},
	{24747, 196668},
	{24776, 196672},
	{24806, 196676},
	{24836, 196680},
	{24865, 196684},
	{24894, 196688},
	{24924, 196692},
	{24954, 196696},
	{24983, 196700},
	{25012, 196704, 1, 1631},
	{25034, 196708, 1, 1632},
	{25056, 196712},
	{25079, 196716},
	{25102, 196720},
	{25125, 196724},
	{25148, 196728},
	{25171, 196732},
	{25194, 196736},
	{25218, 196740},
	{25242, 196744},
	{25266, 196748},
	{25290, 196752},
	{25314, 196756},
	{25338, 196760},
	{25362, 196764},
	{25386, 196768},
	{25408, 196772},
	{25430, 196776},
	{25451, 196780},
	{25472, 196784},
	{25496, 196788},
	{25520, 196792},
	{25544, 196796},
	{25568, 196800},
	{25592, 196804},
	{25616, 196808, 1, 1633},
	{25637, 196812, 1, 1633},
	{25660, 196816, 1, 1633},
	{25676, 196852, 1, 1634},
	{25698, 196856, 1, 1634},
	{25720, 196860, 1, 1635},
	{25736, 196864},
	{25749, 196868},
	{25762, 196872},
	{25775, 196876},
	{25788, 196880},
	{25801, 196884},
	{25814, 196888},
	{25827, 196892},
	{25840, 196896, 1, 1633},
	{25863, 196908, 1, 663},
	{25882, 196912},
	{25900, 196916},
	{25927, 196920},
	{25954, 196928, 2, 1636},
	{25967, 196932},
	{25980, 196936},
	{26003, 196940},
	{26026, 196944},
	{26054, 196948},
	{26082, 196952},
	{26110, 196956},
	{26138, 196960, 1, 1638},
	{26156, 196964, 4, 1639},
	{26174, 196968},
	{26189, 196972},
	{26213, 196976},
	{26237, 196980},
	{26256, 196984},
	{26275, 196988},
	{26299, 196992},
	{26323, 196996},
	{26347, 197000},
	{26371, 197028, 1, 1643},
	{26389, 197032, 2, 1644},
	{26407, 197036},
	{26425, 197040},
	{26443, 197044, 1, 1646},
	{26461, 197048, 2, 1647},
	{26479, 197052},
	{26497, 197056, 2, 1649},
	{26516, 197060, 5, 1651},
	{26535, 197072},
	{26559, 197076, 2, 1649},
	{26579, 197080, 5, 1651},
	{26599, 197084, 7, 1656},
	{26618, 197088, 7, 1656},
	{26636, 197092, 1, 1663},
	{26653, 197100, 1, 1664},
	{26674, 197104, 13, 1665},
	{26688, 197108},
	{26702, 197112},
	{26716, 197116, 2, 1678},
	{26732, 197120},
	{26751, 197124, 1, 1680},
	{26773, 197128},
	{26792, 197132, 1, 1681},
	{26814, 197136, 7, 1682},
	{26832, 197140},
	{26852, 197144, 1, 1680},
	{26875, 197148},
	{26895, 197152, 1, 1681},
	{26918, 197156, 7, 1682},
	{26937, 197160, 7, 1689},
	{26949, 197164, 2, 1696},
	{26966, 197168, 1, 1698},
	{26983, 197172, 1, 1699},
	{27001, 197176, 4, 1700},
	{27021, 197180, 2, 1704},
	{27038, 197184},
	{27054, 197188, 1, 1706},
	{27067, 197192, 1, 1707},
	{27081, 197196, 1, 1708},
	{27095, 197200, 1, 1709},
	{27117, 197204, 1, 1710},
	{27137, 197208, 1, 1711},
	{27159, 197212, 1, 1712},
	{27179, 197216, 1, 1707},
	{27196, 197220, 1, 1708},
	{27213, 197224},
	{27227, 197232, 2, 1713},
	{27249, 197236, 2, 1715},
	{27271, 197240, 2, 1713},
	{27294, 197244, 2, 1715},
	{27317, 197248, 2, 1713},
	{27339, 197252, 2, 1715},
	{27361, 197364, 1, 1717},
	{27382, 197368, 1, 1718},
	{27402, 197372, 1, 1719},
	{27422, 197376, 1, 1718},
	{27439, 197380, 1, 1719},
	{27456, 197384, 1, 1720},
	{27472, 197388, 1, 1721},
	{27491, 197392, 1, 1722},
	{27510, 197396, 1, 1723},
	{27527, 197400, 1, 1724},
	{27545, 197404, 1, 1725},
	{27563, 197408, 1, 1726},
	{27579, 197412, 1, 1727},
	{27597, 197416, 1, 1728},
	{27615, 197420, 1, 1729},
	{27631, 197424, 1, 1724},
	{27646, 197428, 1, 1725},
	{27661, 197432, 1, 1726},
	{27674, 197436, 1, 1727},
	{27689, 197440, 1, 1728},
	{27704, 197444, 1, 1729},
	{27717, 197448, 1, 1730},
	{27731, 197452, 1, 1731},
	{27745, 197456, 1, 1732},
	{27757, 197460, 4, 1733},
	{27780, 197464, 3, 1737},
	{27802, 197468, 1, 1740},
	{27822, 197472, 1, 1741},
	{27836, 197476, 1, 1742},
	{27850, 197480, 1, 1743},
	{27862, 197484, 1, 1744},
	{27878, 197488, 1, 1741},
	{27895, 197492, 1, 1742},
	{27912, 197496, 1, 1743},
	{27927, 197500, 1, 1744},
	{27946, 197552, 1, 1745},
	{27971, 197556, 1, 1745},
	{27995, 197560, 1, 1746},
	{28015, 197568},
	{28041, 197572, 1, 1628},
	{28070, 197576},
	{28095, 197580, 1, 1628},
	{28123, 197584},
	{28146, 197588, 1, 1628},
	{28172, 197592},
	{28194, 197596, 1, 1628},
	{28219, 197600},
	{28238, 197604, 1, 1628},
	{28260, 197608, 1, 1343},
	{28274, 197612},
	{28291, 197616, 1, 1628},
	{28311, 197620, 8, 1747},
	{28328, 197624, 13, 1755},
	{28345, 197628},
	{28362, 197632, 1, 1698},
	{28382, 197636},
	{28399, 197640, 1, 1663},
	{28419, 197644, 2, 1768},
	{28438, 197888, 8, 1770},
	{28459, 197892, 8, 1770},
	{28480, 198656, 6, 1778},
	{28495, 198912},
	{28514, 198916},
	{28533, 198920, 1, 1784},
	{28552, 198924, 1, 1343},
	{28567, 198928},
	{28600, 198932},
	{28633, 198936},
	{28666, 198940},
	{28699, 198948},
	{28715, 198952},
	{28730, 198956, 2, 1357},
	{28756, 198960},
	{28772, 198964},
	{28790, 198968, 1, 1785},
	{28807, 198972, 2, 1786},
	{28828, 198976},
	{28847, 198980},
	{28866, 198984},
	{28882, 198988, 1, 830},
	{28901, 198992},
	{28921, 198996, 1, 830},
	{28944, 199000},
	{28962, 199004, 1, 830},
	{28983, 199008, 9, 1788},
	{29008, 199012},
	{29024, 199016},
	{29045, 199020, 4, 1797},
	{29053, 199024},
	{29067, 199028},
	{29081, 199032},
	{29095, 199036, 3, 1801},
	{29110, 199040, 2, 1804},
	{29122, 199044, 1, 830},
	{29144, 199048, 3, 1806},
	{29160, 199168, 1, 1809},
	{29185, 199172, 2, 1810},
	{29210, 199184, 2, 1812},
	{29236, 199188, 2, 1812},
	{29262, 199192, 2, 1812},
	{29288, 199212, 2, 1812},
	{29314, 199296, 2, 1814},
	{29342, 199300, 1, 1816},
	{29366, 199304, 1, 1817},
	{29390, 199308, 1, 1818},
	{29423, 199312, 1, 1818},
	{29451, 199328, 2, 1814},
	{29480, 199332, 1, 1816},
	{29505, 199336, 1, 1817},
	{29530, 199340, 1, 1818},
	{29564, 199344, 1, 1818},
	{29593, 199360, 2, 1814},
	{29617, 199364, 1, 1816},
	{29637, 199368, 1, 1817},
	{29657, 199372, 1, 1818},
	{29686, 199376, 1, 1818},
	{29710, 199936},
	{29737, 199940},
	{29764, 199944},
	{29791, 199948},
	{29818, 199952},
	{29845, 199956},
	{29872, 199960},
	{29899, 199964},
	{29926, 199968, 7, 1819},
	{29937, 199972, 2, 1826},
	{29951, 200192},
	{29970, 200196, 1, 840},
	{29992, 200448},
	{30016, 200452, 1, 1828},
	{30039, 200456},
	{30063, 200460, 1, 1828},
	{30086, 200464},
	{30110, 200468, 1, 1828},
	{30133, 200472},
	{30157, 200476, 1, 1828},
	{30180, 200696},
	{30199, 200700, 1, 1828},
	{30217, 200704},
	{30229, 200708},
	{30241, 200712},
	{30259, 200716},
	{30278, 200720},
	{30296, 200724},
	{30308, 200728},
	{30320, 200732},
	{30338, 200736},
	{30356, 200740},
	{30375, 200744, 4, 1829},
	{30389, 200748, 2, 1833},
	{30407, 200752, 2, 1835},
	{30421, 200756, 2, 1837},
	{30435, 200760, 2, 1839},
	{30452, 200764, 2, 1841},
	{30469, 200768},
	{30482, 200772, 2, 1843},
	{30494, 200776},
	{30508, 200780},
	{30524, 200784},
	{30538, 200788},
	{30554, 200792},
	{30569, 200796},
	{30586, 200800},
	{30601, 200804},
	{30618, 200808, 2, 1845},
	{30640, 200812, 10, 1847},
	{30657, 200816, 2, 1857},
	{30678, 200820, 2, 1859},
	{30690, 200824},
	{30705, 200828, 6, 1861},
	{30720, 200832, 2, 1867},
	{30734, 200836},
	{30751, 200960},
	{30773, 200964},
	{30797, 200968},
	{30821, 200972},
	{30847, 212992},
	{30867, 212996},
	{30887, 213000},
	{30907, 213004},
	{30927, 213008},
	{30947, 213012},
	{30967, 213016},
	{30987, 213020},
	{31007, 213024},
	{31027, 213028},
	{31047, 213032},
	{31067, 213036},
	{31087, 213040},
	{31110, 213044},
	{31133, 213048},
	{31156, 213248},
	{31177, 213252},
	{31198, 213260},
	{31219, 213264},
	{31240, 213268},
	{31264, 213272},
	{31288, 213276},
	{31312, 213280},
	{31336, 213284},
	{31360, 213288},
	{31384, 213292},
	{31408, 213296},
	{31432, 213504},
	{31451, 213508},
	{31470, 213512},
	{31489, 213516},
	{31508, 213520},
	{31527, 213524},
	{31546, 213528},
	{31565, 213532},
	{31584, 213536},
	{31603, 213540},
	{31622, 213544},
	{31641, 213548},
	{31660, 213552},
	{31679, 213556},
	{31698, 213560},
	{31717, 213564},
	{31736, 213568},
	{31755, 213572},
	{31774, 213576},
	{31793, 213580},
	{31812, 213584},
	{31832, 213588},
	{31852, 213592},
	{31872, 213596},
	{31892, 214016},
	{31914, 214020, 1, 1869},
	{31936, 214024},
	{31958, 214028, 1, 1869},
	{31980, 214032},
	{32002, 214036, 1, 1869},
	{32024, 214040},
	{32046, 214044, 1, 1869},
	{32068, 214272},
	{32090, 214276},
	{32112, 214280},
	{32134, 214284},
	{32156, 214288},
	{32178, 214292},
	{32200, 214296},
	{32222, 214300},
	{32244, 214304},
	{32266, 214308},
	{32288, 214312},
	{32310, 214316},
	{32332, 214320},
	{32354, 214324},
	{32376, 214328},
	{32398, 214332},
	{32420, 214528},
	{32440, 214532},
	{32460, 214536},
	{32480, 214540},
	{32500, 214544},
	{32520, 214548},
	{32540, 214552},
	{32560, 214556},
	{32580, 214560},
	{32600, 214564},
	{32620, 214568},
	{32640, 214572},
	{32660, 214784},
	{32679, 214788},
	{32698, 214792},
	{32717, 214796},
	{32736, 214800},
	{32755, 214804},
	{32774, 214808},
	{32793, 214812},
	{32812, 214816},
	{32831, 214820},
	{32850, 214824},
	{32869, 214828},
	{32888, 214832},
	{32907, 214836},
	{32926, 214840},
	{32945, 214844},
	{32964, 214848},
	{32983, 214852},
	{33002, 214856},
	{33021, 214860},
	{33040, 214864},
	{33060, 214868},
	{33080, 214872},
	{33100, 214876},
	{33120, 214880},
	{33140, 214884},
	{33160, 214888},
	{33180, 214892},
	{33200, 214896},
	{33220, 214900},
	{33240, 214904},
	{33260, 214908},
	{33280, 215296},
	{33299, 215300},
	{33318, 215304},
	{33337, 215308},
	{33356, 215312},
	{33375, 215316},
	{33394, 215320},
	{33413, 215324},
	{33432, 215424},
	{33453, 215428},
	{33474, 215552},
	{33494, 215556},
	{33514, 215560},
	{33534, 215564},
	{33554, 215568},
	{33574, 215572},
	{33594, 215576},
	{33614, 215580},
	{33634, 215808},
	{33653, 215812},
	{33672, 215816},
	{33691, 215820},
	{33710, 216064},
	{33729, 216068},
	{33748, 216072},
	{33767, 216076},
	{33786, 216320},
	{33806, 216324},
	{33826, 216328},
	{33846, 216332},
	{33866, 216336},
	{33886, 216340},
	{33906, 216344},
	{33926, 216348},
	{33946, 216576},
	{33967, 216580},
	{33988, 216584},
	{34009, 216588},
	{34030, 216592},
	{34051, 216596},
	{34072, 216600},
	{34093, 216604},
	{34114, 216640},
	{34135, 216644},
	{34156, 216648},
	{34177, 216652},
	{34198, 216656},
	{34219, 216660},
	{34240, 216664},
	{34261, 216668},
	{34282, 216704},
	{34303, 216708},
	{34324, 216712},
	{34345, 216716},
	{34366, 216720},
	{34387, 216724},
	{34408, 216728},
	{34429, 216732},
	{34450, 216832},
	{34470, 216836},
	{34490, 216840},
	{34510, 216844},
	{34530, 216848},
	{34550, 216852},
	{34570, 216856},
	{34590, 216860},
	{34610, 216864},
	{34631, 216868},
	{34652, 216872},
	{34673, 216876},
	{34694, 216880},
	{34715, 216884},
	{34736, 216888},
	{34757, 216892},
	{34778, 217112},
	{34797, 217116},
	{34816, 217120},
	{34835, 217124},
	{34854, 217128},
	{34873, 217132},
	{34892, 217136},
	{34911, 217140},
	{34930, 217344},
	{34949, 217348},
	{34968, 217352},
	{34987, 217356},
	{35006, 217360},
	{35025, 217364},
	{35044, 217368},
	{35063, 217372},
	{35082, 217600},
	{35102, 217604},
	{35122, 217608},
	{35142, 217612},
	{35162, 217856},
	{35182, 217860},
	{35202, 217864},
	{35222, 217868},
	{35242, 217872},
	{35262, 217876},
	{35282, 217880},
	{35302, 217884},
	{35322, 217984},
	{35347, 217988, 2, 1870},
	{35372, 218016},
	{35398, 218020, 2, 1870},
	{35424, 218080},
	{35449, 218084},
	{35474, 218088},
	{35499, 218092},
	{35524, 218096},
	{35550, 218100},
	{35576, 218224},
	{35598, 218228},
	{35620, 218232},
	{35642, 218236},
	{35664, 218240},
	{35684, 218244},
	{35704, 218248},
	{35724, 218252},
	{35744, 218624},
	{35766, 218628},
	{35788, 218632},
	{35810, 218636},
	{35832, 218640},
	{35854, 218644},
	{35876, 218648},
	{35898, 218652},
	{35920, 218656},
	{35942, 218660},
	{35964, 218664},
	{35986, 218668},
	{36008, 218672},
	{36030, 218676},
	{36052, 218680},
	{36074, 218684},
	{36096, 218880},
	{36117, 218884},
	{36138, 218888},
	{36159, 218892},
	{36180, 218896},
	{36201, 218900},
	{36222, 218904},
	{36243, 218908},
	{36264, 219136},
	{36284, 219140},
	{36304, 219144},
	{36324, 219148},
	{36344, 219152},
	{36364, 219156},
	{36384, 219160},
	{36404, 219164},
	{36424, 219392},
	{36444, 219396},
	{36464, 221184, 5, 1872},
	{36488, 221188, 4, 1877},
	{36513, 221192, 5, 1872},
	{36537, 221196, 5, 1872},
	{36561, 221200, 4, 1877},
	{36586, 221204, 5, 1872},
	{36610, 221208, 4, 1877},
	{36635, 221212, 5, 1872},
	{36659, 221216, 4, 1881},
	{36675, 221220, 5, 1872},
	{36699, 221224, 3, 1885},
	{36733, 221228, 3, 1888},
	{36767, 221232, 3, 1891},
	{36792, 221236, 3, 1894},
	{36817, 221240, 3, 1891},
	{36842, 221248},
	{36857, 221252, 1, 1818},
	{36880, 221256},
	{36903, 221260},
	{36921, 221264, 2, 1897},
	{36939, 221268, 4, 1899},
	{36959, 221440, 20, 1903},
	{36984, 221444, 20, 1903},
	{37009, 221448, 15, 1923},
	{37037, 221452, 15, 1923},
	{37065, 221456, 15, 1923},
	{37093, 221460, 15, 1923},
	{37121, 221492, 8, 1938},
	{37149, 221496, 8, 1938},
	{37177, 221696, 5, 1946},
	{37200, 221700, 4, 1951},
	{37224, 221704, 5, 1946},
	{37247, 221708, 4, 1951},
	{37271, 221712, 5, 1946},
	{37294, 221716, 4, 1951},
	{37318, 221720, 5, 1946},
	{37341, 221724, 4, 1951},
	{37365, 221728, 2, 1955},
	{37388, 221736, 2, 1955},
	{37411, 221744, 2, 1955},
	{37434, 221752, 2, 1955},
	{37457, 221760, 2, 1955},
	{37480, 221768, 2, 1955},
	{37503, 221776, 2, 1955},
	{37527, 221784, 2, 1955},
	{37551, 222208, 5, 1957},
	{37577, 222212, 4, 1962},
	{37604, 222216, 5, 1957},
	{37630, 222220, 4, 1962},
	{37657, 222224, 5, 1957},
	{37683, 222228, 4, 1962},
	{37710, 222232, 5, 1957},
	{37736, 222236, 4, 1962},
	{37763, 222464, 5, 1957},
	{37789, 222468, 4, 1962},
	{37816, 222472, 1, 1872},
	{37842, 222476, 1, 1872},
	{37868, 222480, 1, 1872},
	{37894, 222484, 1, 1872},
	{37920, 222488, 1, 1872},
	{37946, 222492, 1, 1872},
	{37972, 222496, 1, 1872},
	{37998, 222720, 5, 1957},
	{38022, 222724, 5, 1957},
	{38046, 222728, 5, 1957},
	{38070, 222732, 5, 1957},
	{38094, 222736, 4, 1962},
	{38119, 222740, 4, 1962},
	{38144, 222744, 4, 1962},
	{38169, 222748, 4, 1962},
	{38194, 222752, 1, 1872},
	{38218, 222756, 1, 1872},
	{38242, 222760, 8, 1966},
	{38263, 222976, 4, 1974},
	{38286, 222980, 4, 1974},
	{38309, 222984, 4, 1974},
	{38332, 222988, 4, 1974},
	{38355, 222992, 4, 1974},
	{38378, 222996, 4, 1974},
	{38401, 223000, 4, 1974},
	{38424, 223004, 4, 1974},
	{38447, 223008, 4, 1974},
	{38470, 223012, 4, 1974},
	{38493, 223016, 4, 1974},
	{38517, 223020, 4, 1974},
	{38541, 223024, 4, 1974},
	{38565, 223028, 4, 1974},
	{38589, 223032, 4, 1974},
	{38613, 223036, 4, 1974},
	{38637, 223104, 9, 1978},
	{38657, 223112, 1, 1987},
	{38678, 223232, 5, 1957},
	{38703, 223236, 4, 1962},
	{38729, 223240, 8, 1988},
	{38752, 223488, 3, 1996},
	{38775, 223492, 3, 1996},
	{38798, 223496, 3, 1996},
	{38821, 223500, 3, 1996},
	{38844, 223504, 2, 1999},
	{38868, 223508, 2, 1999},
	{38892, 223744, 5, 1957},
	{38916, 223748, 5, 1957},
	{38940, 223752, 5, 1957},
	{38964, 223756, 5, 1957},
	{38988, 223760, 4, 1962},
	{39013, 224000, 5, 2001},
	{39036, 224004, 4, 2006},
	{39060, 224008, 3, 2010},
	{39083, 224256, 5, 2001},
	{39106, 224260, 4, 2006},
	{39130, 224264, 3, 2010},
	{39153, 224512, 5, 1957},
	{39177, 224516, 4, 1962},
	{39202, 224520, 5, 1957},
	{39226, 224524, 4, 1962},
	{39251, 224528, 3, 2013},
	{39275, 224532, 3, 2013},
	{39299, 224768, 5, 1957},
	{39324, 224772, 4, 1951},
	{39350, 224776, 5, 1957},
	{39375, 224780, 4, 1951},
	{39401, 224784, 3, 2013},
	{39426, 224788, 3, 2013},
	{39451, 224832, 5, 1957},
	{39476, 224836, 4, 1951},
	{39502, 224840, 5, 1957},
	{39527, 224844, 4, 1951},
	{39553, 224848, 3, 2013},
	{39578, 224852, 3, 2013},
	{39603, 224896, 5, 1957},
	{39628, 224900, 4, 1951},
	{39654, 224904, 3, 2013},
	{39679, 224908, 3, 2013},
	{39704, 224912, 3, 2013},
	{39729, 225024, 5, 1957},
	{39753, 225028, 4, 1951},
	{39778, 225032, 3, 2013},
	{39802, 225036, 3, 2013},
	{39826, 225040, 3, 2013},
	{39850, 225048, 5, 1957},
	{39875, 225052, 4, 1951},
	{39901, 225056, 3, 2013},
	{39926, 225060, 3, 2013},
	{39951, 225064, 3, 2013},
	{39976, 225280, 12, 2016},
	{39998, 225284, 5, 2028},
	{40021, 225288, 4, 2033},
	{40045, 225292, 2, 2037},
	{40068, 225296, 2, 2037},
	{40091, 225300, 2, 2037},
	{40114, 225536, 5, 1957},
	{40137, 225540, 4, 1962},
	{40161, 225544, 5, 1957},
	{40184, 225548, 4, 1962},
	{40208, 225552, 5, 1957},
	{40231, 225560, 5, 1957},
	{40254, 225792, 4, 2039},
	{40275, 225796},
	{40304, 225800, 2, 2043},
	{40333, 225804},
	{40359, 225808, 7, 2045},
	{40388, 225812},
	{40407, 225816, 2, 2052},
	{40433, 225820, 2, 2054},
	{40456, 225824},
	{40479, 225828, 2, 2056},
	{40506, 225832},
	{40533, 225836, 2, 2058},
	{40558, 225840, 2, 2060},
	{40586, 225844, 2, 2062},
	{40614, 225848, 2, 2064},
	{40637, 225852, 2, 2066},
	{40660, 225856},
	{40693, 225860, 2, 2068},
	{40726, 225864},
	{40758, 225868, 2, 2068},
	{40790, 225872, 2, 2070},
	{40809, 225876, 2, 2072},
	{40836, 225880},
	{40863, 225884, 2, 2074},
	{40890, 225888, 2, 2076},
	{40917, 225892, 10, 2078},
	{40938, 225896, 8, 2088},
	{40957, 225900, 8, 2096},
	{40976, 225904, 2, 2104},
	{41000, 225908, 2, 2106},
	{41032, 225912, 2, 2108},
	{41062, 225916, 4, 2110},
	{41098, 225920, 3, 2114},
	{41131, 225924, 1, 2117},
	{41149, 225932, 1, 2118},
	{41169, 226048, 2, 2119},
	{41186, 226052, 1, 2121},
	{41210, 226056, 1, 2121},
	{41234, 226060, 4, 2122},
	{41260, 226064, 3, 2126},
	{41289, 226068, 1, 687},
	{41318, 226072, 3, 2126},
	{41347, 226076, 1, 687},
	{41376, 226192, 1, 2129},
	{41397, 226196, 1, 2129},
	{41424, 226304, 5, 2028},
	{41448, 226308, 4, 2033},
	{41473, 226312, 2, 2037},
	{41497, 226316, 5, 2028},
	{41521, 226320, 4, 2033},
	{41546, 226324, 2, 2037},
	{41570, 226328, 10, 2130},
	{41592, 226432, 5, 2140},
	{41619, 226436, 5, 2140},
	{41646, 226440, 6, 2145},
	{41678, 226480, 5, 2140},
	{41706, 226484, 5, 2140},
	{41734, 226488, 5, 2140},
	{41762, 226492, 5, 2140},
	{41790, 226496, 5, 2140},
	{41818, 226500, 5, 2140},
	{41846, 226504, 5, 2140},
	{41874, 226508, 5, 2140},
	{41902, 226512, 6, 2145},
	{41935, 226544, 5, 1957},
	{41964, 226548, 5, 1957},
	{41993, 226552, 4, 1962},
	{42023, 226556, 4, 1962},
	{42053, 226560, 8, 1988},
	{42080, 226564, 8, 1988},
	{42107, 226608, 5, 1957},
	{42137, 226612, 4, 1962},
	{42168, 226616, 8, 1988},
	{42196, 226688, 5, 2028},
	{42220, 226692, 4, 2033},
	{42245, 226696, 3, 2151},
	{42269, 226700, 2, 2154},
	{42295, 226704, 2, 2154},
	{42321, 226816, 5, 1957},
	{42347, 226820, 4, 1962},
	{42374, 226824, 5, 1957},
	{42400, 226828, 5, 1957},
	{42426, 226832, 5, 1957},
	{42452, 226836, 1, 1872},
	{42478, 226840, 1, 1872},
	{42504, 226844, 1, 1872},
	{42530, 226848, 1, 1872},
	{42556, 226880, 4, 1962},
	{42583, 226884, 4, 1962},
	{42610, 226888, 4, 1962},
	{42637, 227072, 5, 1957},
	{42662, 227076, 4, 1951},
	{42688, 227080, 3, 2013},
	{42713, 227084, 3, 2013},
	{42738, 227088, 3, 2013},
	{42763, 227200, 5, 1957},
	{42787, 227204, 4, 1951},
	{42812, 227208, 3, 2013},
	{42836, 227212, 3, 2013},
	{42860, 227216, 3, 2013},
	{42884, 227328, 5, 1957},
	{42908, 227332, 4, 1962},
	{42933, 227336, 8, 1988},
	{206, 880, 4, 2156},
	{42955, 881},
	{26802, 882},
	{42967, 1008},
	{42978, 1009},
	{26990, 1010, 4, 2160},
	{42989, 1040, 1, 2164},
	{43002, 1041, 5, 2165},
	{43015, 1042, 1, 2170},
	{43028, 1043, 1, 1681},
	{26824, 1045, 7, 2171},
	{43041, 1168, 12, 2178},
	{43056, 1280, 6, 2190},
	{43071, 1281},
	{26761, 1282},
	{42955, 1283},
	{26802, 1284},
	{43083, 1414, 15, 2196},
};

static const struct si_reg gfx103_reg_table[] = {
	{43092, 40, 1, 2211},
	{43107, 44, 1, 2211},
	{1145, 1028, 8, 0},
	{1158, 1032, 20, 10},
	{1173, 1036, 10, 2212},
	{1189, 1040, 12, 40},
	{1210, 1044, 4, 52},
	{1228, 1048, 3, 56},
	{1246, 1052, 8, 2222},
	{1261, 1056},
	{1275, 1060, 1, 70},
	{1289, 1064},
	{1306, 1076, 2, 78},
	{1322, 1080},
	{1717, 1104},
	{1741, 1108},
	{1339, 1116, 5, 80},
	{1354, 1120, 6, 85},
	{1369, 1124, 2, 92},
	{1389, 1128, 1, 94},
	{1408, 1132, 4, 95},
	{1428, 1136, 5, 99},
	{43130, 1140, 1, 2230},
	{1444, 2480},
	{1458, 2484},
	{1472, 2488},
	{1486, 2492},
	{1500, 2496},
	{1514, 2500},
	{1528, 2504},
	{1542, 2508},
	{1556, 2512},
	{1570, 2516},
	{1584, 2520},
	{1599, 2524},
	{1614, 2528},
	{1629, 2532},
	{1644, 2536},
	{1659, 2540},
	{1674, 2544},
	{1685, 2552},
	{1701, 2556},
	{1789, 32776, 29, 2231},
	{1802, 32784, 20, 2260},
	{1814, 32788, 14, 154},
	{1830, 32792, 14, 154},
	{1846, 32796, 15, 168},
	{1859, 32824, 14, 154},
	{1875, 32828, 14, 154},
	{1891, 33296, 21, 183},
	{1905, 33300, 28, 204},
	{1922, 33304, 15, 232},
	{1943, 33308, 28, 247},
	{1957, 33312, 32, 275},
	{1974, 33316, 13, 307},
	{1995, 33320, 9, 320},
	{2013, 33324, 1, 329},
	{43152, 33328, 1, 2280},
	{2036, 33344, 2, 330},
	{2057, 33348},
	{2077, 33352, 1, 332},
	{2100, 33356, 9, 333},
	{2118, 33436, 1, 342},
	{2141, 36096},
	{2167, 36100, 2, 343},
	{2193, 36104},
	{2219, 36108, 2, 343},
	{2245, 36112, 2, 345},
	{2266, 36116, 4, 347},
	{2287, 36120, 6, 2281},
	{2314, 36124, 20, 2287},
	{2335, 36128, 7, 2307},
	{2358, 36132},
	{2387, 36140},
	{2417, 36144},
	{2449, 36148},
	{2480, 36152},
	{43179, 36156, 3, 2314},
	{2513, 36348, 5, 378},
	{2522, 36608},
	{2540, 36612, 4, 383},
	{2558, 36616},
	{2576, 36620, 11, 2317},
	{2594, 36656, 14, 397},
	{2612, 36660, 4, 411},
	{2630, 36664, 12, 415},
	{2648, 36668, 2, 427},
	{2666, 37168, 9, 2328},
	{2682, 39160, 6, 2337},
	{3477, 40960},
	{3495, 40964, 4, 452},
	{3513, 40968, 3, 456},
	{3531, 40972, 9, 459},
	{3549, 40976, 3, 2343},
	{3567, 40980, 8, 2346},
	{3585, 40984, 11, 2354},
	{3603, 40988},
	{3621, 45060, 1, 487},
	{3645, 45080},
	{3670, 45084, 3, 488},
	{3694, 45088},
	{3715, 45092, 1, 491},
	{3736, 45096, 12, 2365},
	{3760, 45100, 10, 503},
	{3784, 45104},
	{3810, 45108},
	{3836, 45112},
	{3862, 45116},
	{3888, 45120},
	{3914, 45124},
	{3940, 45128},
	{3966, 45132},
	{3992, 45136},
	{4018, 45140},
	{4044, 45144},
	{4071, 45148},
	{4098, 45152},
	{4125, 45156},
	{4152, 45160},
	{4179, 45164},
	{4206, 45168},
	{4233, 45172},
	{4260, 45176},
	{4287, 45180},
	{4314, 45184},
	{4341, 45188},
	{4368, 45192},
	{4395, 45196},
	{4422, 45200},
	{4449, 45204},
	{4476, 45208},
	{4503, 45212},
	{4530, 45216},
	{4557, 45220},
	{4584, 45224},
	{4611, 45228},
	{4638, 45248, 8, 513},
	{4694, 45256, 1, 526},
	{4721, 45260, 1, 526},
	{4748, 45264, 1, 526},
	{4775, 45268, 1, 526},
	{4802, 45316, 1, 487},
	{4826, 45332},
	{4851, 45336, 3, 488},
	{4875, 45340, 1, 527},
	{4900, 45344},
	{4921, 45348, 1, 491},
	{4942, 45352, 12, 528},
	{4966, 45356, 14, 540},
	{4990, 45360},
	{5016, 45364},
	{5042, 45368},
	{5068, 45372},
	{5094, 45376},
	{5120, 45380},
	{5146, 45384},
	{5172, 45388},
	{5198, 45392},
	{5224, 45396},
	{5250, 45400},
	{5277, 45404},
	{5304, 45408},
	{5331, 45412},
	{5358, 45416},
	{5385, 45420},
	{5412, 45424},
	{5439, 45428},
	{5466, 45432},
	{5493, 45436},
	{5520, 45440},
	{5547, 45444},
	{5574, 45448},
	{5601, 45452},
	{5628, 45456},
	{5655, 45460},
	{5682, 45464},
	{5709, 45468},
	{5736, 45472},
	{5763, 45476},
	{5790, 45480},
	{5817, 45484},
	{5844, 45504, 8, 513},
	{5900, 45512, 1, 526},
	{5927, 45516, 1, 526},
	{5954, 45520, 1, 526},
	{5981, 45524, 1, 526},
	{6008, 45548, 9, 554},
	{6089, 45568},
	{6114, 45572, 2, 574},
	{6138, 45576},
	{6170, 45580},
	{6202, 45584},
	{6226, 45588, 1, 491},
	{6250, 45596, 4, 576},
	{6274, 45600},
	{6295, 45604, 1, 491},
	{6316, 45608, 13, 580},
	{6340, 45612, 9, 593},
	{6364, 45616},
	{6390, 45620},
	{6416, 45624},
	{6442, 45628},
	{6468, 45632},
	{6494, 45636},
	{6520, 45640},
	{6546, 45644},
	{6572, 45648},
	{6598, 45652},
	{6624, 45656},
	{6651, 45660},
	{6678, 45664},
	{6705, 45668},
	{6732, 45672},
	{6759, 45676},
	{6786, 45680},
	{6813, 45684},
	{6840, 45688},
	{6867, 45692},
	{6894, 45696},
	{6921, 45700},
	{6948, 45704},
	{6975, 45708},
	{7002, 45712},
	{7029, 45716},
	{7056, 45720},
	{7083, 45724},
	{7110, 45728},
	{7137, 45732},
	{7164, 45736},
	{7191, 45740},
	{7218, 45760, 8, 513},
	{7278, 45768, 1, 526},
	{7307, 45772, 1, 526},
	{7336, 45776, 1, 526},
	{7365, 45780, 1, 526},
	{7445, 45856},
	{7466, 45860, 1, 491},
	{7984, 46080},
	{8009, 46084, 1, 487},
	{8033, 46088},
	{8065, 46092},
	{8097, 46096},
	{8121, 46100, 1, 491},
	{8145, 46108, 4, 612},
	{8169, 46112},
	{8190, 46116, 1, 491},
	{8211, 46120, 12, 616},
	{8235, 46124, 9, 628},
	{8259, 46128},
	{8285, 46132},
	{8311, 46136},
	{8337, 46140},
	{8363, 46144},
	{8389, 46148},
	{8415, 46152},
	{8441, 46156},
	{8467, 46160},
	{8493, 46164},
	{8519, 46168},
	{8546, 46172},
	{8573, 46176},
	{8600, 46180},
	{8627, 46184},
	{8654, 46188},
	{8681, 46192},
	{8708, 46196},
	{8735, 46200},
	{8762, 46204},
	{8789, 46208},
	{8816, 46212},
	{8843, 46216},
	{8870, 46220},
	{8897, 46224},
	{8924, 46228},
	{8951, 46232},
	{8978, 46236},
	{9005, 46240},
	{9032, 46244},
	{9059, 46248},
	{9086, 46252},
	{9113, 46272, 8, 513},
	{9173, 46280, 1, 526},
	{9202, 46284, 1, 526},
	{9231, 46288, 1, 526},
	{9260, 46292, 1, 526},
	{9340, 46368},
	{9361, 46372, 1, 491},
	{9852, 47104, 13, 646},
	{9879, 47108},
	{9893, 47112},
	{9907, 47116},
	{9921, 47120},
	{9937, 47124},
	{9953, 47128},
	{9969, 47132, 2, 659},
	{9990, 47136, 2, 659},
	{10011, 47140, 2, 659},
	{10032, 47144, 1, 661},
	{10060, 47148, 1, 662},
	{10085, 47152},
	{10100, 47156, 1, 663},
	{10115, 47160},
	{10144, 47164, 1, 663},
	{10173, 47168},
	{10206, 47172, 1, 663},
	{10239, 47176, 12, 664},
	{10257, 47180, 11, 676},
	{10275, 47184, 1, 687},
	{10288, 47188, 6, 688},
	{10312, 47192},
	{10339, 47196},
	{10366, 47200, 2, 694},
	{10387, 47204},
	{10414, 47208},
	{10441, 47212},
	{10459, 47216},
	{10477, 47220},
	{10495, 47224, 1, 696},
	{10523, 47228, 5, 697},
	{10545, 47232},
	{10565, 47236},
	{10588, 47240, 9, 702},
	{10605, 47248, 1, 526},
	{10626, 47252, 1, 526},
	{10647, 47256, 1, 526},
	{10668, 47260, 1, 526},
	{10689, 47264, 1, 711},
	{10707, 47268, 1, 712},
	{10726, 47272},
	{10748, 47276, 3, 713},
	{10765, 47280},
	{10794, 47284, 1, 716},
	{10823, 47288, 3, 713},
	{10841, 47360},
	{10861, 47364},
	{10881, 47368},
	{10901, 47372},
	{10921, 47376},
	{10941, 47380},
	{10961, 47384},
	{10981, 47388},
	{11001, 47392},
	{11021, 47396},
	{11041, 47400},
	{11062, 47404},
	{11083, 47408},
	{11104, 47412},
	{11125, 47416},
	{11146, 47420},
	{11167, 47604, 2, 717},
	{11191, 47608},
	{11212, 47612},
	{43203, 47616},
	{43220, 47620},
	{11228, 163840, 11, 2377},
	{11246, 163844, 11, 729},
	{11263, 163848, 7, 740},
	{11277, 163852, 23, 747},
	{11296, 163856, 18, 2388},
	{11316, 163860},
	{11335, 163868, 2, 786},
	{11352, 163872},
	{11372, 163876},
	{11392, 163880, 1, 788},
	{11409, 163884},
	{11424, 163888, 2, 789},
	{11448, 163892, 2, 791},
	{11472, 163896, 3, 793},
	{11488, 163900, 8, 796},
	{11506, 163904, 14, 804},
	{11516, 163908, 9, 818},
	{11532, 163912},
	{11547, 163916},
	{11568, 163920},
	{11584, 163924},
	{11606, 163928, 2, 827},
	{11624, 163932, 1, 829},
	{43237, 163940, 3, 2406},
	{11642, 163944, 1, 830},
	{11660, 163948, 1, 830},
	{11684, 163952, 1, 830},
	{11703, 163956, 1, 830},
	{11728, 163960, 1, 830},
	{11750, 163964, 13, 2409},
	{11774, 163968},
	{11790, 163972, 1, 840},
	{11809, 164328, 1, 841},
	{11830, 164332, 1, 841},
	{11851, 164336, 1, 841},
	{11872, 164340, 1, 841},
	{11893, 164344},
	{11911, 164348},
	{11929, 164352, 2, 842},
	{11949, 164356, 3, 844},
	{11973, 164360, 2, 847},
	{11997, 164364, 1, 849},
	{12017, 164368, 2, 844},
	{12037, 164372, 2, 847},
	{12057, 164376, 2, 844},
	{12077, 164380, 2, 847},
	{12097, 164384, 2, 844},
	{12117, 164388, 2, 847},
	{12137, 164392, 2, 844},
	{12157, 164396, 2, 847},
	{12177, 164400, 7, 850},
	{12192, 164404, 2, 857},
	{12221, 164408, 8, 859},
	{12236, 164412, 8, 867},
	{12251, 164416, 3, 844},
	{12276, 164420, 2, 847},
	{12301, 164424},
	{12319, 164428},
	{12337, 164432, 3, 844},
	{12362, 164436, 2, 847},
	{12387, 164440, 3, 844},
	{12412, 164444, 2, 847},
	{12437, 164448, 3, 844},
	{12462, 164452, 2, 847},
	{12487, 164456, 3, 844},
	{12512, 164460, 2, 847},
	{12537, 164464, 3, 844},
	{12562, 164468, 2, 847},
	{12587, 164472, 3, 844},
	{12612, 164476, 2, 847},
	{12637, 164480, 3, 844},
	{12662, 164484, 2, 847},
	{12687, 164488, 3, 844},
	{12712, 164492, 2, 847},
	{12737, 164496, 3, 844},
	{12762, 164500, 2, 847},
	{12787, 164504, 3, 844},
	{12812, 164508, 2, 847},
	{12837, 164512, 3, 844},
	{12863, 164516, 2, 847},
	{12889, 164520, 3, 844},
	{12915, 164524, 2, 847},
	{12941, 164528, 3, 844},
	{12967, 164532, 2, 847},
	{12993, 164536, 3, 844},
	{13019, 164540, 2, 847},
	{13045, 164544, 3, 844},
	{13071, 164548, 2, 847},
	{13097, 164552, 3, 844},
	{13123, 164556, 2, 847},
	{13149, 164560},
	{13168, 164564},
	{13187, 164568},
	{13206, 164572},
	{13225, 164576},
	{13244, 164580},
	{13263, 164584},
	{13282, 164588},
	{13301, 164592},
	{13320, 164596},
	{13339, 164600},
	{13358, 164604},
	{13377, 164608},
	{13396, 164612},
	{13415, 164616},
	{13434, 164620},
	{13453, 164624},
	{13472, 164628},
	{13491, 164632},
	{13510, 164636},
	{13529, 164640},
	{13549, 164644},
	{13569, 164648},
	{13589, 164652},
	{13609, 164656},
	{13629, 164660},
	{13649, 164664},
	{13669, 164668},
	{13689, 164672},
	{13709, 164676},
	{13729, 164680},
	{13749, 164684},
	{13769, 164688, 15, 875},
	{13789, 164692, 3, 890},
	{13811, 164696, 2, 893},
	{13839, 164700, 6, 2422},
	{13868, 164704, 1, 902},
	{13889, 164708, 1, 903},
	{13899, 164712, 1, 904},
	{43258, 164716},
	{43280, 164720},
	{13967, 164864},
	{13984, 164868},
	{14001, 164872},
	{14017, 164876},
	{14046, 164880, 14, 2428},
	{14071, 164884},
	{14084, 164888},
	{14099, 164892},
	{14113, 164896},
	{14128, 164900, 8, 923},
	{14143, 164904, 4, 931},
	{14167, 164908, 6, 935},
	{14186, 164912, 4, 941},
	{14204, 164916, 4, 945},
	{14225, 164924},
	{14244, 164928},
	{14264, 164932},
	{14283, 164936},
	{14303, 164940},
	{14322, 164944},
	{14342, 164948},
	{14363, 164952},
	{14385, 164956},
	{14406, 164960},
	{14428, 164964},
	{14449, 164968},
	{14471, 164972},
	{14492, 164976},
	{14514, 164980},
	{14535, 164984},
	{14557, 164988},
	{14578, 164992},
	{14600, 164996},
	{14621, 165000},
	{14643, 165004},
	{14664, 165008},
	{14686, 165012},
	{14707, 165016},
	{14729, 165020},
	{14750, 165024},
	{14772, 165028},
	{14793, 165032},
	{14815, 165036},
	{14836, 165040},
	{14858, 165044},
	{14879, 165048},
	{14901, 165052},
	{14922, 165056},
	{14944, 165060},
	{14965, 165064},
	{14987, 165068},
	{15008, 165072},
	{15030, 165076},
	{15051, 165080},
	{15073, 165084},
	{15094, 165088},
	{15116, 165092},
	{15137, 165096},
	{15159, 165100},
	{15180, 165104},
	{15202, 165108},
	{15223, 165112},
	{15245, 165116},
	{15266, 165120},
	{15288, 165124},
	{15309, 165128},
	{15331, 165132},
	{15352, 165136},
	{15374, 165140},
	{15395, 165144},
	{15417, 165148},
	{15438, 165152},
	{15460, 165156},
	{15481, 165160},
	{15503, 165164},
	{15525, 165168},
	{15548, 165172},
	{15570, 165176},
	{15593, 165180},
	{15615, 165184},
	{15638, 165188},
	{15660, 165192},
	{15683, 165196},
	{15705, 165200},
	{15728, 165204},
	{15750, 165208},
	{15773, 165212},
	{15795, 165216},
	{15818, 165220},
	{15840, 165224},
	{15863, 165228},
	{15885, 165232},
	{15908, 165236},
	{15930, 165240},
	{15953, 165244},
	{15975, 165248},
	{15998, 165252},
	{16020, 165256},
	{16043, 165260},
	{16065, 165264},
	{16088, 165268},
	{16110, 165272},
	{16133, 165276},
	{16155, 165280},
	{16178, 165284},
	{16200, 165288},
	{16223, 165292},
	{16245, 165296},
	{16268, 165300},
	{16290, 165304},
	{16313, 165308},
	{16327, 165312},
	{16341, 165316},
	{16355, 165320},
	{16369, 165324},
	{16383, 165328},
	{16397, 165332},
	{16411, 165336},
	{16425, 165340},
	{16439, 165344},
	{16453, 165348},
	{16467, 165352},
	{16481, 165356},
	{16495, 165360},
	{16509, 165364},
	{16523, 165368},
	{16537, 165372},
	{16551, 165376},
	{16565, 165380},
	{16579, 165384},
	{16593, 165388},
	{16607, 165392},
	{16621, 165396},
	{16635, 165400},
	{16649, 165404},
	{16672, 165444, 13, 2442},
	{16692, 165448, 13, 2442},
	{16712, 165452, 13, 2442},
	{16732, 165456, 13, 2442},
	{16752, 165460, 13, 2442},
	{16772, 165464, 13, 2442},
	{16792, 165468, 13, 2442},
	{16812, 165472, 13, 2442},
	{16832, 165476, 13, 2442},
	{16852, 165480, 13, 2442},
	{16872, 165484, 13, 2442},
	{16893, 165488, 13, 2442},
	{16914, 165492, 13, 2442},
	{16935, 165496, 13, 2442},
	{16956, 165500, 13, 2442},
	{16977, 165504, 13, 2442},
	{16998, 165508, 13, 2442},
	{17019, 165512, 13, 2442},
	{17040, 165516, 13, 2442},
	{17061, 165520, 13, 2442},
	{17082, 165524, 10, 2455},
	{17103, 165528, 10, 2455},
	{17124, 165532, 10, 2455},
	{17145, 165536, 10, 2455},
	{17166, 165540, 10, 2455},
	{17187, 165544, 10, 2455},
	{17208, 165548, 10, 2455},
	{17229, 165552, 10, 2455},
	{17250, 165556, 10, 2455},
	{17271, 165560, 10, 2455},
	{17292, 165564, 10, 2455},
	{17313, 165568, 10, 2455},
	{17334, 165572, 4, 2465},
	{17352, 165580, 16, 973},
	{17369, 165584, 16, 973},
	{17387, 165588, 7, 989},
	{17408, 165592, 6, 2469},
	{17426, 165600, 7, 1002},
	{17441, 165608, 2, 694},
	{17458, 165640, 1, 1009},
	{17480, 165644, 5, 1010},
	{17502, 165648, 1, 1015},
	{17522, 165652, 8, 1016},
	{43302, 165712, 8, 2475},
	{17544, 165716, 8, 2483},
	{17562, 165720, 8, 1032},
	{17583, 165724, 17, 1040},
	{17604, 165728, 6, 1057},
	{17622, 165732, 6, 1057},
	{17640, 165736, 6, 1057},
	{17658, 165740, 6, 1057},
	{17676, 165744, 6, 1057},
	{17694, 165748, 6, 1057},
	{17712, 165752, 6, 1057},
	{17730, 165756, 6, 1057},
	{17748, 165760, 9, 1063},
	{17766, 165764, 9, 1063},
	{17784, 165768, 9, 1063},
	{17802, 165772, 9, 1063},
	{17820, 165776, 9, 1063},
	{17838, 165780, 9, 1063},
	{17856, 165784, 9, 1063},
	{17874, 165788, 9, 1063},
	{17892, 165836, 1, 1072},
	{17906, 165840, 1, 1072},
	{17921, 165844},
	{17939, 165848},
	{17957, 165852},
	{17974, 165856},
	{17995, 165860, 1, 1073},
	{18011, 165864},
	{18024, 165872, 6, 2491},
	{18043, 165876},
	{18058, 165880, 1, 1082},
	{18080, 165884, 1, 1083},
	{18107, 165888, 10, 1084},
	{18124, 165892, 12, 1094},
	{18132, 165896, 5, 2497},
	{18149, 165900, 17, 1110},
	{18167, 165904, 20, 1127},
	{18183, 165908, 16, 1147},
	{18202, 165912, 10, 1163},
	{18217, 165916, 30, 2502},
	{18235, 165920, 16, 1201},
	{18253, 165924, 4, 1217},
	{18277, 165928},
	{18302, 165932, 11, 1221},
	{18325, 165936, 5, 1232},
	{18376, 165944, 3, 2532},
	{18391, 165948, 5, 1243},
	{18421, 165952, 5, 1248},
	{18436, 165956},
	{43328, 165960, 6, 2535},
	{18454, 166400, 2, 1253},
	{18471, 166404, 2, 1255},
	{18490, 166408, 1, 1257},
	{18506, 166412, 4, 1258},
	{18525, 166416, 1, 1262},
	{18546, 166420, 1, 1263},
	{18559, 166424},
	{18582, 166428},
	{18605, 166432, 1, 1264},
	{18625, 166436, 4, 1265},
	{18645, 166440, 1, 1269},
	{18666, 166444, 1, 1270},
	{18681, 166448, 6, 1271},
	{18703, 166452, 6, 1271},
	{18725, 166456, 8, 1277},
	{18751, 166460, 8, 1277},
	{18777, 166464, 15, 1285},
	{18789, 166468, 3, 1300},
	{18808, 166472, 6, 2541},
	{18826, 166476, 24, 1310},
	{18844, 166480},
	{18856, 166484, 1, 1334},
	{18870, 166488, 1, 1335},
	{18884, 166492, 1, 1336},
	{18898, 166496, 1, 1337},
	{18921, 166500, 1, 1337},
	{18944, 166504, 1, 1337},
	{18967, 166508, 5, 1338},
	{18988, 166512},
	{18999, 166516},
	{19012, 166520},
	{19029, 166524, 9, 2547},
	{19048, 166528},
	{19059, 166532, 3, 1351},
	{19078, 166536},
	{19100, 166540},
	{19122, 166544, 3, 1354},
	{19142, 166548, 2, 1357},
	{19169, 166552, 4, 2556},
	{19191, 166560},
	{19216, 166564},
	{19241, 166568, 6, 1364},
	{19260, 166572, 1, 1370},
	{19283, 166576, 1, 1370},
	{19306, 166580, 1, 1371},
	{19320, 166584, 1, 1372},
	{19335, 166588, 10, 2560},
	{19352, 166592, 4, 1382},
	{19379, 166596, 4, 1386},
	{19406, 166600, 4, 1390},
	{19425, 166608},
	{19451, 166612, 1, 1394},
	{19476, 166620},
	{19504, 166624},
	{19530, 166628, 1, 1394},
	{19555, 166636},
	{19583, 166640},
	{19609, 166644, 1, 1394},
	{19634, 166652},
	{19662, 166656},
	{19688, 166660, 1, 1394},
	{19713, 166668},
	{19741, 166696},
	{19772, 166700},
	{19815, 166704, 1, 1395},
	{19853, 166712, 1, 1396},
	{19873, 166732, 2, 1397},
	{19892, 166736, 5, 1399},
	{19914, 166740, 20, 2570},
	{19935, 166744, 3, 1423},
	{19952, 166748, 1, 1370},
	{19973, 166752, 1, 1370},
	{19996, 166756, 1, 1370},
	{20019, 166760, 1, 1370},
	{20042, 166764, 12, 1426},
	{20055, 166768, 6, 1438},
	{20072, 166772},
	{20096, 166776, 2, 1444},
	{20126, 166780},
	{20150, 166784},
	{20180, 166788},
	{20211, 166792},
	{20240, 166796},
	{20270, 166800, 3, 1446},
	{20290, 166804, 8, 1449},
	{20309, 166808, 4, 1457},
	{20335, 166812, 3, 1354},
	{20359, 166868, 8, 1461},
	{20385, 166872, 8, 1469},
	{20411, 166876, 5, 1477},
	{20427, 166880, 8, 2590},
	{20443, 166884, 3, 1488},
	{20458, 166888},
	{20481, 166892},
	{20504, 166896},
	{20527, 166900},
	{20550, 166904, 8, 1491},
	{20584, 166908, 8, 1499},
	{20618, 166912, 8, 1507},
	{20652, 166916, 8, 1515},
	{20686, 166920, 8, 1491},
	{20720, 166924, 8, 1499},
	{20754, 166928, 8, 1507},
	{20788, 166932, 8, 1515},
	{20822, 166936, 8, 1491},
	{20856, 166940, 8, 1499},
	{20890, 166944, 8, 1507},
	{20924, 166948, 8, 1515},
	{20958, 166952, 8, 1491},
	{20992, 166956, 8, 1499},
	{21026, 166960, 8, 1507},
	{21060, 166964, 8, 1515},
	{21094, 166968, 2, 1523},
	{21118, 166972, 2, 1525},
	{21142, 166976, 4, 1527},
	{21163, 166980, 12, 1531},
	{21183, 166984, 2, 1543},
	{21203, 166988, 20, 1545},
	{21241, 166992, 2, 1565},
	{21261, 167000, 1, 1567},
	{21289, 167004, 1, 1568},
	{21310, 167008},
	{21325, 167012, 2, 1569},
	{21341, 167016, 1, 1571},
	{21357, 167020, 3, 1572},
	{21372, 167024, 19, 2598},
	{21387, 167028, 8, 1594},
	{21404, 167032, 14, 2617},
	{21426, 167036},
	{21442, 167040, 1, 1614},
	{21464, 167044},
	{21480, 167048, 1, 1571},
	{21502, 167052},
	{21524, 167056},
	{21546, 167060},
	{21565, 167068},
	{21580, 167072, 2, 1569},
	{21596, 167076, 1, 1571},
	{21612, 167080, 3, 1572},
	{21627, 167084, 19, 2598},
	{21642, 167088, 8, 1594},
	{21659, 167092, 14, 2617},
	{21681, 167096},
	{21697, 167100, 1, 1614},
	{21719, 167104},
	{21735, 167108, 1, 1571},
	{21757, 167112},
	{21779, 167116},
	{21801, 167120},
	{21820, 167128},
	{21835, 167132, 2, 1569},
	{21851, 167136, 1, 1571},
	{21867, 167140, 3, 1572},
	{21882, 167144, 19, 2598},
	{21897, 167148, 8, 1594},
	{21914, 167152, 14, 2617},
	{21936, 167156},
	{21952, 167160, 1, 1614},
	{21974, 167164},
	{21990, 167168, 1, 1571},
	{22012, 167172},
	{22034, 167176},
	{22056, 167180},
	{22075, 167188},
	{22090, 167192, 2, 1569},
	{22106, 167196, 1, 1571},
	{22122, 167200, 3, 1572},
	{22137, 167204, 19, 2598},
	{22152, 167208, 8, 1594},
	{22169, 167212, 14, 2617},
	{22191, 167216},
	{22207, 167220, 1, 1614},
	{22229, 167224},
	{22245, 167228, 1, 1571},
	{22267, 167232},
	{22289, 167236},
	{22311, 167240},
	{22330, 167248},
	{22345, 167252, 2, 1569},
	{22361, 167256, 1, 1571},
	{22377, 167260, 3, 1572},
	{22392, 167264, 19, 2598},
	{22407, 167268, 8, 1594},
	{22424, 167272, 14, 2617},
	{22446, 167276},
	{22462, 167280, 1, 1614},
	{22484, 167284},
	{22500, 167288, 1, 1571},
	{22522, 167292},
	{22544, 167296},
	{22566, 167300},
	{22585, 167308},
	{22600, 167312, 2, 1569},
	{22616, 167316, 1, 1571},
	{22632, 167320, 3, 1572},
	{22647, 167324, 19, 2598},
	{22662, 167328, 8, 1594},
	{22679, 167332, 14, 2617},
	{22701, 167336},
	{22717, 167340, 1, 1614},
	{22739, 167344},
	{22755, 167348, 1, 1571},
	{22777, 167352},
	{22799, 167356},
	{22821, 167360},
	{22840, 167368},
	{22855, 167372, 2, 1569},
	{22871, 167376, 1, 1571},
	{22887, 167380, 3, 1572},
	{22902, 167384, 19, 2598},
	{22917, 167388, 8, 1594},
	{22934, 167392, 14, 2617},
	{22956, 167396},
	{22972, 167400, 1, 1614},
	{22994, 167404},
	{23010, 167408, 1, 1571},
	{23032, 167412},
	{23054, 167416},
	{23076, 167420},
	{23095, 167428},
	{23110, 167432, 2, 1569},
	{23126, 167436, 1, 1571},
	{23142, 167440, 3, 1572},
	{23157, 167444, 19, 2598},
	{23172, 167448, 8, 1594},
	{23189, 167452, 14, 2617},
	{23211, 167456},
	{23227, 167460, 1, 1614},
	{23249, 167464},
	{23265, 167468, 1, 1571},
	{23287, 167472},
	{23309, 167476},
	{23331, 167480},
	{23350, 167488, 1, 1615},
	{23369, 167492, 1, 1615},
	{23388, 167496, 1, 1615},
	{23407, 167500, 1, 1615},
	{23426, 167504, 1, 1615},
	{23445, 167508, 1, 1615},
	{23464, 167512, 1, 1615},
	{23483, 167516, 1, 1615},
	{23502, 167520, 1, 1615},
	{23527, 167524, 1, 1615},
	{23552, 167528, 1, 1615},
	{23577, 167532, 1, 1615},
	{23602, 167536, 1, 1615},
	{23627, 167540, 1, 1615},
	{23652, 167544, 1, 1615},
	{23677, 167548, 1, 1615},
	{23702, 167552, 1, 1615},
	{23727, 167556, 1, 1615},
	{23752, 167560, 1, 1615},
	{23777, 167564, 1, 1615},
	{23802, 167568, 1, 1615},
	{23827, 167572, 1, 1615},
	{23852, 167576, 1, 1615},
	{23877, 167580, 1, 1615},
	{23902, 167584, 1, 1615},
	{23925, 167588, 1, 1615},
	{23948, 167592, 1, 1615},
	{23971, 167596, 1, 1615},
	{23994, 167600, 1, 1615},
	{24017, 167604, 1, 1615},
	{24040, 167608, 1, 1615},
	{24063, 167612, 1, 1615},
	{24086, 167616, 3, 1616},
	{24104, 167620, 3, 1616},
	{24122, 167624, 3, 1616},
	{24140, 167628, 3, 1616},
	{24158, 167632, 3, 1616},
	{24176, 167636, 3, 1616},
	{24194, 167640, 3, 1616},
	{24212, 167644, 3, 1616},
	{24230, 167648, 9, 2631},
	{24248, 167652, 9, 2631},
	{24266, 167656, 9, 2631},
	{24284, 167660, 9, 2631},
	{24302, 167664, 9, 2631},
	{24320, 167668, 9, 2631},
	{24338, 167672, 9, 2631},
	{24356, 167676, 9, 2631},
	{24374, 196608, 1, 1627},
	{24394, 196612, 1, 1628},
	{24414, 196616},
	{24434, 196620},
	{24454, 196624},
	{24475, 196628},
	{24496, 196632, 1, 1629},
	{24518, 196636, 1, 1630},
	{24540, 196640},
	{24570, 196644},
	{24600, 196648},
	{24629, 196652},
	{24658, 196656},
	{24688, 196660},
	{24718, 196664},
	{24747, 196668},
	{24776, 196672},
	{24806, 196676},
	{24836, 196680},
	{24865, 196684},
	{24894, 196688},
	{24924, 196692},
	{24954, 196696},
	{24983, 196700},
	{25012, 196704, 1, 1631},
	{25034, 196708, 1, 1632},
	{25056, 196712},
	{25079, 196716},
	{25102, 196720},
	{25125, 196724},
	{25148, 196728},
	{25171, 196732},
	{25194, 196736},
	{25218, 196740},
	{25242, 196744},
	{25266, 196748},
	{25290, 196752},
	{25314, 196756},
	{25338, 196760},
	{25362, 196764},
	{25386, 196768},
	{25408, 196772},
	{25430, 196776},
	{25451, 196780},
	{25472, 196784},
	{25496, 196788},
	{25520, 196792},
	{25544, 196796},
	{25568, 196800},
	{25592, 196804},
	{25676, 196852, 1, 1634},
	{25698, 196856, 1, 1634},
	{25720, 196860, 1, 1635},
	{25736, 196864},
	{25749, 196868},
	{25762, 196872},
	{25775, 196876},
	{25788, 196880},
	{25801, 196884},
	{25814, 196888},
	{25827, 196892},
	{43343, 196896, 5, 2640},
	{25863, 196908, 1, 663},
	{25882, 196912},
	{25900, 196916},
	{25927, 196920},
	{25954, 196928, 2, 1636},
	{25967, 196932},
	{25980, 196936},
	{26003, 196940},
	{26026, 196944},
	{26054, 196948},
	{26082, 196952},
	{26110, 196956},
	{26138, 196960, 1, 1638},
	{26156, 196964, 4, 1639},
	{26174, 196968},
	{26189, 196972},
	{26213, 196976},
	{26237, 196980},
	{26256, 196984},
	{26275, 196988},
	{26299, 196992},
	{26323, 196996},
	{26347, 197000},
	{26371, 197028, 1, 1643},
	{26389, 197032, 2, 1644},
	{26407, 197036},
	{26425, 197040},
	{26443, 197044, 1, 1646},
	{26461, 197048, 2, 1647},
	{26479, 197052},
	{26497, 197056, 2, 2645},
	{26516, 197060, 5, 1651},
	{26535, 197072},
	{26559, 197076, 2, 2645},
	{26579, 197080, 5, 1651},
	{26599, 197084, 7, 1656},
	{26618, 197088, 7, 1656},
	{26636, 197092, 1, 1663},
	{26653, 197100, 1, 1664},
	{26674, 197104, 13, 1665},
	{26688, 197108},
	{26702, 197112},
	{26716, 197116, 2, 1678},
	{26732, 197120},
	{26751, 197124, 1, 1680},
	{26773, 197128},
	{26792, 197132, 1, 1681},
	{26814, 197136, 7, 1682},
	{26832, 197140},
	{26852, 197144, 1, 1680},
	{26875, 197148},
	{26895, 197152, 1, 1681},
	{26918, 197156, 7, 1682},
	{26937, 197160, 7, 1689},
	{26949, 197164, 2, 1696},
	{26966, 197168, 1, 1698},
	{26983, 197172, 1, 1699},
	{27001, 197176, 5, 2647},
	{27021, 197180, 2, 330},
	{27038, 197184},
	{27054, 197188, 1, 1706},
	{27081, 197196, 1, 1708},
	{27137, 197208, 1, 1711},
	{27159, 197212, 1, 1712},
	{27179, 197216, 1, 1707},
	{27196, 197220, 1, 1708},
	{27213, 197224},
	{27227, 197232, 2, 1713},
	{27249, 197236, 2, 1715},
	{27271, 197240, 2, 1713},
	{27294, 197244, 2, 1715},
	{27317, 197248, 2, 1713},
	{27339, 197252, 2, 1715},
	{43362, 197256},
	{43384, 197260},
	{43406, 197280},
	{43428, 197284},
	{43450, 197288},
	{43477, 197292},
	{43504, 197296},
	{43531, 197300},
	{27361, 197364, 1, 1717},
	{27382, 197368, 1, 1718},
	{27402, 197372, 1, 1719},
	{27439, 197380, 1, 1719},
	{27456, 197384, 1, 1720},
	{27472, 197388, 1, 1721},
	{27491, 197392, 1, 1722},
	{27510, 197396, 1, 1723},
	{27527, 197400, 1, 1724},
	{27545, 197404, 1, 1725},
	{27563, 197408, 1, 1726},
	{27579, 197412, 1, 1727},
	{27597, 197416, 1, 1728},
	{27615, 197420, 1, 1729},
	{27631, 197424, 1, 1724},
	{27646, 197428, 1, 1725},
	{27661, 197432, 1, 1726},
	{27674, 197436, 1, 1727},
	{27689, 197440, 1, 1728},
	{27704, 197444, 1, 1729},
	{27717, 197448, 1, 1730},
	{27731, 197452, 1, 1731},
	{27745, 197456, 1, 1732},
	{27757, 197460, 4, 1733},
	{27780, 197464, 5, 2652},
	{27802, 197468, 1, 1740},
	{27822, 197472, 1, 1741},
	{27836, 197476, 1, 1742},
	{27850, 197480, 1, 1743},
	{27862, 197484, 1, 1744},
	{27878, 197488, 1, 1741},
	{27895, 197492, 1, 1742},
	{27912, 197496, 1, 1743},
	{27927, 197500, 1, 1744},
	{27946, 197552, 1, 1745},
	{27971, 197556, 1, 1745},
	{27995, 197560, 1, 1746},
	{28015, 197568},
	{28041, 197572, 1, 1628},
	{28070, 197576},
	{28095, 197580, 1, 1628},
	{28123, 197584},
	{28146, 197588, 1, 1628},
	{28172, 197592},
	{28194, 197596, 1, 1628},
	{28219, 197600},
	{28238, 197604, 1, 1628},
	{28260, 197608, 1, 1343},
	{28274, 197612},
	{28291, 197616, 1, 1628},
	{28311, 197620, 8, 1747},
	{28328, 197624, 13, 1755},
	{28345, 197628},
	{28362, 197632, 1, 1698},
	{28382, 197636},
	{28399, 197640, 1, 1663},
	{28419, 197644, 2, 1768},
	{28438, 197888, 8, 1770},
	{28459, 197892, 8, 1770},
	{28480, 198656, 6, 1778},
	{28495, 198912},
	{28514, 198916},
	{28533, 198920, 1, 1784},
	{28552, 198924, 2, 2657},
	{28567, 198928},
	{28600, 198932},
	{28633, 198936},
	{28666, 198940},
	{28699, 198948},
	{28715, 198952},
	{28730, 198956, 2, 1357},
	{28756, 198960},
	{28772, 198964},
	{28790, 198968, 1, 1785},
	{28807, 198972, 2, 2659},
	{28828, 198976},
	{28847, 198980},
	{28866, 198984},
	{28882, 198988, 1, 830},
	{28901, 198992},
	{28921, 198996, 1, 830},
	{28944, 199000},
	{28962, 199004, 1, 830},
	{28983, 199008, 9, 1788},
	{29008, 199012},
	{29024, 199016},
	{29045, 199020, 4, 1797},
	{29053, 199024},
	{29067, 199028},
	{29081, 199032},
	{29095, 199036, 3, 1801},
	{29110, 199040, 2, 1804},
	{29122, 199044, 1, 830},
	{29144, 199048, 3, 1806},
	{43558, 199052, 2, 2661},
	{29160, 199168, 1, 1809},
	{29185, 199172, 2, 1810},
	{29210, 199184, 2, 1812},
	{29236, 199188, 2, 1812},
	{29262, 199192, 2, 1812},
	{29288, 199212, 2, 1812},
	{29314, 199296, 2, 1814},
	{29342, 199300, 1, 1816},
	{29366, 199304, 1, 1817},
	{29390, 199308, 1, 1818},
	{29423, 199312, 1, 1818},
	{29451, 199328, 2, 1814},
	{29480, 199332, 1, 1816},
	{29505, 199336, 1, 1817},
	{29530, 199340, 1, 1818},
	{29564, 199344, 1, 1818},
	{29593, 199360, 2, 1814},
	{29617, 199364, 1, 1816},
	{29637, 199368, 1, 1817},
	{29657, 199372, 1, 1818},
	{29686, 199376, 1, 1818},
	{29710, 199936},
	{29737, 199940},
	{29764, 199944},
	{29791, 199948},
	{29818, 199952},
	{29845, 199956},
	{29872, 199960},
	{29899, 199964},
	{29926, 199968, 5, 2663},
	{29951, 200192},
	{29970, 200196, 1, 840},
	{29992, 200448},
	{30016, 200452, 1, 1828},
	{30039, 200456},
	{30063, 200460, 1, 1828},
	{30086, 200464},
	{30110, 200468, 1, 1828},
	{30133, 200472},
	{30157, 200476, 1, 1828},
	{30180, 200696},
	{30199, 200700, 1, 1828},
	{30217, 200704},
	{30229, 200708},
	{30241, 200712},
	{30259, 200716},
	{30278, 200720},
	{30296, 200724},
	{30308, 200728},
	{30320, 200732},
	{30338, 200736},
	{30356, 200740},
	{30375, 200744, 4, 1829},
	{30389, 200748, 2, 1833},
	{30407, 200752, 2, 1835},
	{30421, 200756, 2, 1837},
	{30435, 200760, 2, 1839},
	{30452, 200764, 2, 1841},
	{30469, 200768},
	{30482, 200772, 2, 1843},
	{30494, 200776},
	{30508, 200780},
	{30524, 200784},
	{30538, 200788},
	{30554, 200792},
	{30569, 200796},
	{30586, 200800},
	{30601, 200804},
	{30618, 200808, 2, 1845},
	{30640, 200812, 11, 2668},
	{30657, 200816, 2, 1857},
	{30678, 200820, 2, 1859},
	{30690, 200824},
	{30705, 200828, 6, 1861},
	{30720, 200832, 2, 1867},
	{30734, 200836},
	{30751, 200960},
	{30773, 200964},
	{30797, 200968},
	{30821, 200972},
	{30847, 212992},
	{30867, 212996},
	{30887, 213000},
	{30907, 213004},
	{30927, 213008},
	{30947, 213012},
	{30967, 213016},
	{30987, 213020},
	{31007, 213024},
	{31027, 213028},
	{31047, 213032},
	{31067, 213036},
	{31087, 213040},
	{31110, 213044},
	{31133, 213048},
	{31156, 213248},
	{31177, 213252},
	{31198, 213260},
	{31219, 213264},
	{31240, 213268},
	{31264, 213272},
	{31288, 213276},
	{31312, 213280},
	{31336, 213284},
	{31360, 213288},
	{31384, 213292},
	{31408, 213296},
	{43570, 213648},
	{43590, 213652},
	{43610, 213656},
	{43630, 213660},
	{43650, 213664},
	{43670, 213668},
	{43690, 213672},
	{43710, 213676},
	{43730, 213680},
	{43755, 213684},
	{43780, 213688},
	{43805, 213692},
	{43830, 213696},
	{43855, 213700},
	{43880, 213704},
	{43905, 213708},
	{43930, 213712},
	{43953, 213716},
	{43976, 213720},
	{43999, 213724},
	{44022, 213728},
	{44045, 213732},
	{44068, 213736},
	{44091, 213740},
	{31892, 214016},
	{31914, 214020, 1, 1869},
	{31936, 214024},
	{31958, 214028, 1, 1869},
	{31980, 214032},
	{32002, 214036, 1, 1869},
	{32024, 214040},
	{32046, 214044, 1, 1869},
	{32068, 214272},
	{32090, 214276},
	{32112, 214280},
	{32134, 214284},
	{32156, 214288},
	{32178, 214292},
	{32200, 214296},
	{32222, 214300},
	{32244, 214304},
	{32266, 214308},
	{32288, 214312},
	{32310, 214316},
	{32332, 214320},
	{32354, 214324},
	{32376, 214328},
	{32398, 214332},
	{32420, 214528},
	{32440, 214532},
	{32460, 214536},
	{32480, 214540},
	{32500, 214544},
	{32520, 214548},
	{32540, 214552},
	{32560, 214556},
	{32580, 214560},
	{32600, 214564},
	{32620, 214568},
	{32640, 214572},
	{32660, 214784},
	{32679, 214788},
	{32698, 214792},
	{32717, 214796},
	{32736, 214800},
	{32755, 214804},
	{32774, 214808},
	{32793, 214812},
	{32812, 214816},
	{32831, 214820},
	{32850, 214824},
	{32869, 214828},
	{32888, 214832},
	{32907, 214836},
	{32926, 214840},
	{32945, 214844},
	{32964, 214848},
	{32983, 214852},
	{33002, 214856},
	{33021, 214860},
	{33040, 214864},
	{33060, 214868},
	{33080, 214872},
	{33100, 214876},
	{33120, 214880},
	{33140, 214884},
	{33160, 214888},
	{33180, 214892},
	{33200, 214896},
	{33220, 214900},
	{33240, 214904},
	{33260, 214908},
	{33280, 215296},
	{33299, 215300},
	{33318, 215304},
	{33337, 215308},
	{33356, 215312},
	{33375, 215316},
	{33394, 215320},
	{33413, 215324},
	{33432, 215424},
	{33453, 215428},
	{44114, 215432},
	{44134, 215436, 2, 1870},
	{33474, 215552},
	{33494, 215556},
	{33514, 215560},
	{33534, 215564},
	{33554, 215568},
	{33574, 215572},
	{33594, 215576},
	{33614, 215580},
	{33634, 215808},
	{33653, 215812},
	{33672, 215816},
	{33691, 215820},
	{33710, 216064},
	{33729, 216068},
	{33748, 216072},
	{33767, 216076},
	{33786, 216320},
	{33806, 216324},
	{33826, 216328},
	{33846, 216332},
	{33866, 216336},
	{33886, 216340},
	{33906, 216344},
	{33926, 216348},
	{33946, 216576},
	{33967, 216580},
	{33988, 216584},
	{34009, 216588},
	{34030, 216592},
	{34051, 216596},
	{34072, 216600},
	{34093, 216604},
	{34114, 216640},
	{34135, 216644},
	{34156, 216648},
	{34177, 216652},
	{34198, 216656},
	{34219, 216660},
	{34240, 216664},
	{34261, 216668},
	{34282, 216704},
	{34303, 216708},
	{34324, 216712},
	{34345, 216716},
	{34366, 216720},
	{34387, 216724},
	{34408, 216728},
	{34429, 216732},
	{34450, 216832},
	{34470, 216836},
	{34490, 216840},
	{34510, 216844},
	{34530, 216848},
	{34550, 216852},
	{34570, 216856},
	{34590, 216860},
	{34610, 216864},
	{34631, 216868},
	{34652, 216872},
	{34673, 216876},
	{34694, 216880},
	{34715, 216884},
	{34736, 216888},
	{34757, 216892},
	{34778, 217112},
	{34797, 217116},
	{34816, 217120},
	{34835, 217124},
	{34854, 217128},
	{34873, 217132},
	{34892, 217136},
	{34911, 217140},
	{34930, 217344},
	{34949, 217348},
	{34968, 217352},
	{34987, 217356},
	{35006, 217360},
	{35025, 217364},
	{35044, 217368},
	{35063, 217372},
	{35082, 217600},
	{35102, 217604},
	{35122, 217608},
	{35142, 217612},
	{35162, 217856},
	{35182, 217860},
	{35202, 217864},
	{35222, 217868},
	{35242, 217872},
	{35262, 217876},
	{35282, 217880},
	{35302, 217884},
	{35372, 218016},
	{35398, 218020, 2, 1870},
	{44154, 218024},
	{44177, 218028, 2, 1870},
	{35424, 218080},
	{35449, 218084},
	{35474, 218088},
	{35499, 218092},
	{35576, 218224},
	{35598, 218228},
	{35620, 218232},
	{35642, 218236},
	{35664, 218240},
	{35684, 218244},
	{35704, 218248},
	{35724, 218252},
	{35744, 218624},
	{35766, 218628},
	{35788, 218632},
	{35810, 218636},
	{35832, 218640},
	{35854, 218644},
	{35876, 218648},
	{35898, 218652},
	{35920, 218656},
	{35942, 218660},
	{35964, 218664},
	{35986, 218668},
	{36008, 218672},
	{36030, 218676},
	{36052, 218680},
	{36074, 218684},
	{36096, 218880},
	{36117, 218884},
	{36138, 218888},
	{36159, 218892},
	{36180, 218896},
	{36201, 218900},
	{36222, 218904},
	{36243, 218908},
	{36264, 219136},
	{36284, 219140},
	{36304, 219144},
	{36324, 219148},
	{36344, 219152},
	{36364, 219156},
	{36384, 219160},
	{36404, 219164},
	{36424, 219392},
	{36444, 219396},
	{44200, 219400},
	{44219, 219404, 2, 1870},
	{44238, 219520},
	{44267, 219524, 2, 1870},
	{44296, 219528},
	{44318, 219532},
	{44340, 219536},
	{44362, 219540},
	{44384, 219568},
	{44413, 219572, 2, 1870},
	{44442, 219576},
	{44464, 219580},
	{44486, 219584},
	{44508, 219588},
	{44530, 219616},
	{44559, 219620, 2, 1870},
	{44588, 219624},
	{44610, 219628},
	{44632, 219632},
	{44654, 219636},
	{44676, 219664},
	{44705, 219668, 2, 1870},
	{44734, 219672},
	{44756, 219676},
	{44778, 219680},
	{44800, 219684},
	{36464, 221184, 5, 1872},
	{36488, 221188, 4, 1877},
	{36513, 221192, 5, 1872},
	{36537, 221196, 5, 1872},
	{36561, 221200, 4, 1877},
	{36586, 221204, 5, 1872},
	{36610, 221208, 4, 1877},
	{36635, 221212, 5, 1872},
	{36659, 221216, 4, 1881},
	{36675, 221220, 5, 1872},
	{36699, 221224, 3, 1885},
	{36733, 221228, 3, 1888},
	{36767, 221232, 3, 1891},
	{36792, 221236, 3, 1894},
	{36817, 221240, 3, 1891},
	{36842, 221248},
	{36857, 221252, 1, 1818},
	{36880, 221256},
	{36903, 221260},
	{36921, 221264, 2, 1897},
	{36939, 221268, 4, 1899},
	{36959, 221440, 20, 1903},
	{36984, 221444, 20, 1903},
	{37009, 221448, 15, 1923},
	{37037, 221452, 15, 1923},
	{37065, 221456, 15, 1923},
	{37093, 221460, 15, 1923},
	{37121, 221492, 8, 1938},
	{37149, 221496, 8, 1938},
	{44822, 221840, 5, 1946},
	{44846, 221844, 4, 1951},
	{44871, 221848, 5, 1946},
	{44895, 221852, 4, 1951},
	{44920, 221856, 5, 1946},
	{44944, 221860, 4, 1951},
	{44969, 221864, 5, 1946},
	{44993, 221868, 4, 1951},
	{45018, 221872, 5, 1946},
	{45047, 221876, 4, 1951},
	{45077, 221880, 5, 1946},
	{45106, 221884, 4, 1951},
	{45136, 221888, 5, 1946},
	{45165, 221892, 4, 1951},
	{45195, 221896, 5, 1946},
	{45224, 221900, 4, 1951},
	{45254, 221904, 5, 1946},
	{45281, 221908, 4, 1951},
	{45309, 221912, 5, 1946},
	{45336, 221916, 4, 1951},
	{45364, 221920, 5, 1946},
	{45391, 221924, 4, 1951},
	{45419, 221928, 5, 1946},
	{45446, 221932, 4, 1951},
	{37551, 222208, 5, 1957},
	{37577, 222212, 4, 1962},
	{37604, 222216, 5, 1957},
	{37630, 222220, 4, 1962},
	{37657, 222224, 5, 1957},
	{37683, 222228, 4, 1962},
	{37710, 222232, 5, 1957},
	{37736, 222236, 4, 1962},
	{37763, 222464, 5, 1957},
	{37789, 222468, 4, 1962},
	{37816, 222472, 1, 1872},
	{37842, 222476, 1, 1872},
	{37868, 222480, 1, 1872},
	{37894, 222484, 1, 1872},
	{37920, 222488, 1, 1872},
	{37946, 222492, 1, 1872},
	{37972, 222496, 1, 1872},
	{37998, 222720, 5, 1957},
	{38022, 222724, 5, 1957},
	{38046, 222728, 5, 1957},
	{38070, 222732, 5, 1957},
	{38094, 222736, 4, 1962},
	{38119, 222740, 4, 1962},
	{38144, 222744, 4, 1962},
	{38169, 222748, 4, 1962},
	{38194, 222752, 1, 1872},
	{38218, 222756, 1, 1872},
	{38242, 222760, 8, 1966},
	{38263, 222976, 3, 2679},
	{38286, 222980, 3, 2679},
	{38309, 222984, 3, 2679},
	{38332, 222988, 3, 2679},
	{38355, 222992, 3, 2679},
	{38378, 222996, 3, 2679},
	{38401, 223000, 3, 2679},
	{38424, 223004, 3, 2679},
	{38447, 223008, 3, 2679},
	{38470, 223012, 3, 2679},
	{38493, 223016, 3, 2679},
	{38517, 223020, 3, 2679},
	{38541, 223024, 3, 2679},
	{38565, 223028, 3, 2679},
	{38589, 223032, 3, 2679},
	{38613, 223036, 3, 2679},
	{38637, 223104, 15, 2682},
	{38657, 223112, 1, 1987},
	{38678, 223232, 5, 1957},
	{38703, 223236, 4, 1962},
	{38729, 223240, 8, 1988},
	{45474, 223244, 5, 2140},
	{45496, 223248, 5, 2140},
	{45518, 223252, 6, 2145},
	{38752, 223488, 5, 1957},
	{38775, 223492, 5, 1957},
	{38798, 223496, 3, 2013},
	{38821, 223500, 3, 2013},
	{38844, 223504, 4, 1962},
	{38868, 223508, 4, 1962},
	{38892, 223744, 5, 1957},
	{38916, 223748, 5, 1957},
	{38940, 223752, 5, 1957},
	{38964, 223756, 5, 1957},
	{38988, 223760, 4, 1962},
	{45545, 223764, 4, 1962},
	{45570, 223768, 4, 1962},
	{45595, 223772, 4, 1962},
	{39013, 224000, 5, 1957},
	{39036, 224004, 4, 1962},
	{39060, 224008, 3, 2013},
	{39083, 224256, 5, 1957},
	{39106, 224260, 4, 1962},
	{39130, 224264, 3, 2013},
	{39153, 224512, 5, 1957},
	{39177, 224516, 4, 1962},
	{39202, 224520, 5, 1957},
	{39226, 224524, 4, 1962},
	{39251, 224528, 3, 2013},
	{39275, 224532, 3, 2013},
	{39299, 224768, 5, 1957},
	{39324, 224772, 4, 1951},
	{39350, 224776, 5, 1957},
	{39375, 224780, 4, 1951},
	{39401, 224784, 3, 2013},
	{39426, 224788, 3, 2013},
	{39451, 224832, 5, 1957},
	{39476, 224836, 4, 1951},
	{39502, 224840, 5, 1957},
	{39527, 224844, 4, 1951},
	{39553, 224848, 3, 2013},
	{39578, 224852, 3, 2013},
	{39603, 224896, 5, 1957},
	{39628, 224900, 4, 1951},
	{39654, 224904, 3, 2013},
	{39679, 224908, 3, 2013},
	{39704, 224912, 3, 2013},
	{39729, 225024, 5, 1957},
	{39753, 225028, 4, 1951},
	{39778, 225032, 3, 2013},
	{39802, 225036, 3, 2013},
	{39826, 225040, 3, 2013},
	{39850, 225048, 5, 1957},
	{39875, 225052, 4, 1951},
	{39901, 225056, 3, 2013},
	{39926, 225060, 3, 2013},
	{39951, 225064, 3, 2013},
	{39976, 225280, 12, 2016},
	{39998, 225284, 5, 2028},
	{40021, 225288, 4, 2033},
	{40045, 225292, 2, 2037},
	{40068, 225296, 2, 2037},
	{40091, 225300, 2, 2037},
	{40114, 225536, 5, 1957},
	{40137, 225540, 4, 1962},
	{40161, 225544, 5, 1957},
	{40184, 225548, 4, 1962},
	{40208, 225552, 5, 1957},
	{40231, 225560, 5, 1957},
	{40254, 225792, 4, 2039},
	{40275, 225796},
	{40304, 225800, 2, 2043},
	{40333, 225804},
	{40359, 225808, 7, 2045},
	{40388, 225812},
	{40407, 225816, 2, 2052},
	{40433, 225820, 2, 2054},
	{40456, 225824},
	{40479, 225828, 2, 2056},
	{40506, 225832},
	{40533, 225836, 2, 2058},
	{40558, 225840, 2, 2060},
	{40586, 225844, 2, 2062},
	{40614, 225848, 2, 2064},
	{40637, 225852, 2, 2066},
	{40660, 225856},
	{40693, 225860, 2, 2068},
	{40726, 225864},
	{40758, 225868, 2, 2068},
	{40790, 225872, 2, 2070},
	{40809, 225876, 2, 2072},
	{40836, 225880},
	{40863, 225884, 2, 2697},
	{40890, 225888, 2, 2076},
	{40917, 225892, 17, 2699},
	{40938, 225896, 9, 2716},
	{40957, 225900, 19, 2725},
	{40976, 225904, 1, 2104},
	{41000, 225908, 1, 2106},
	{41032, 225912, 2, 2108},
	{41062, 225916, 4, 2110},
	{41098, 225920, 3, 2114},
	{41131, 225924, 1, 2117},
	{45620, 225928, 7, 2045},
	{41149, 225932, 1, 2118},
	{45653, 225936},
	{45680, 225940},
	{45706, 225944, 4, 2110},
	{45746, 225948, 2, 2744},
	{45780, 225952, 2, 2744},
	{45810, 225956, 2, 2072},
	{45841, 225960},
	{45872, 225964, 4, 2746},
	{45906, 225968, 3, 2114},
	{45943, 225972, 3, 2750},
	{41169, 226048, 2, 2119},
	{41186, 226052, 1, 2121},
	{41210, 226056, 1, 2121},
	{41234, 226060, 4, 2122},
	{41260, 226064, 3, 2126},
	{41289, 226068, 1, 687},
	{41318, 226072, 3, 2126},
	{41347, 226076, 1, 687},
	{41376, 226192, 1, 2129},
	{41424, 226304, 5, 2028},
	{41448, 226308, 4, 2033},
	{41473, 226312, 2, 2037},
	{41497, 226316, 5, 2028},
	{41521, 226320, 4, 2033},
	{41546, 226324, 2, 2037},
	{41570, 226328, 10, 2130},
	{41678, 226480, 5, 2140},
	{41706, 226484, 5, 2140},
	{41734, 226488, 5, 2140},
	{41762, 226492, 5, 2140},
	{41790, 226496, 5, 2140},
	{41818, 226500, 5, 2140},
	{41846, 226504, 5, 2140},
	{41874, 226508, 5, 2140},
	{41902, 226512, 6, 2145},
	{45984, 226516, 5, 2140},
	{46009, 226520, 5, 2140},
	{46034, 226524, 5, 2140},
	{46059, 226528, 5, 2140},
	{46084, 226532, 6, 2145},
	{41935, 226544, 5, 1957},
	{41964, 226548, 5, 1957},
	{41993, 226552, 4, 1962},
	{42023, 226556, 4, 1962},
	{42053, 226560, 8, 1988},
	{42080, 226564, 8, 1988},
	{42196, 226688, 5, 2028},
	{42220, 226692, 4, 2033},
	{42245, 226696, 3, 2151},
	{42269, 226700, 2, 2154},
	{42295, 226704, 2, 2154},
	{42321, 226816, 5, 1957},
	{42347, 226820, 4, 1962},
	{42374, 226824, 5, 1957},
	{42400, 226828, 5, 1957},
	{42426, 226832, 5, 1957},
	{42452, 226836, 1, 1872},
	{42478, 226840, 1, 1872},
	{42504, 226844, 1, 1872},
	{42530, 226848, 1, 1872},
	{42556, 226880, 4, 1962},
	{42583, 226884, 4, 1962},
	{42610, 226888, 4, 1962},
	{42637, 227072, 5, 1957},
	{42662, 227076, 4, 1951},
	{42688, 227080, 3, 2013},
	{42713, 227084, 3, 2013},
	{42738, 227088, 3, 2013},
	{42763, 227200, 5, 1957},
	{42787, 227204, 4, 1951},
	{42812, 227208, 3, 2013},
	{42836, 227212, 3, 2013},
	{42860, 227216, 3, 2013},
	{42884, 227328, 5, 1957},
	{42908, 227332, 4, 1962},
	{42933, 227336, 8, 1988},
	{46114, 227340, 5, 2140},
	{46135, 227344, 5, 2140},
	{46156, 227348, 6, 2145},
	{46182, 227456, 5, 2140},
	{46213, 227460, 5, 2140},
	{46244, 227464, 6, 2145},
	{46280, 227468, 1, 2753},
	{46304, 227472, 5, 1957},
	{46330, 227476, 4, 1962},
	{46357, 227480, 5, 1957},
	{46383, 227484, 4, 1962},
	{46410, 227504, 5, 2140},
	{46441, 227508, 5, 2140},
	{46472, 227512, 6, 2145},
	{46508, 227516, 1, 2753},
	{46532, 227520, 5, 1957},
	{46558, 227524, 4, 1962},
	{46585, 227528, 5, 1957},
	{46611, 227532, 4, 1962},
	{46638, 227552, 5, 2140},
	{46669, 227556, 5, 2140},
	{46700, 227560, 6, 2145},
	{46736, 227564, 1, 2753},
	{46760, 227568, 5, 1957},
	{46786, 227572, 4, 1962},
	{46813, 227576, 5, 1957},
	{46839, 227580, 4, 1962},
	{46866, 227600, 5, 2140},
	{46897, 227604, 5, 2140},
	{46928, 227608, 6, 2145},
	{46964, 227612, 1, 2753},
	{46988, 227616, 5, 1957},
	{47014, 227620, 4, 1962},
	{47041, 227624, 5, 1957},
	{47067, 227628, 4, 1962},
	{206, 880, 4, 2156},
	{42955, 881},
	{26802, 882},
	{42967, 1008},
	{42978, 1009},
	{26990, 1010, 4, 2160},
	{42989, 1040, 1, 2164},
	{43002, 1041, 5, 2165},
	{43015, 1042, 1, 2170},
	{43028, 1043, 1, 1681},
	{26824, 1045, 7, 2171},
	{43041, 1168, 12, 2178},
	{43056, 1280, 6, 2190},
	{43071, 1281},
	{26761, 1282},
	{42955, 1283},
	{26802, 1284},
	{43083, 1414, 15, 2196},
};

static const struct si_reg gfx11_reg_table[] = {
	{43092, 40, 1, 2211},
	{43107, 44, 1, 2211},
	{1145, 1028, 10, 2754},
	{1158, 1032, 26, 2764},
	{1173, 1036, 11, 2790},
	{1210, 1044, 2, 2801},
	{1228, 1048, 3, 56},
	{1246, 1052, 4, 2803},
	{1261, 1056},
	{1275, 1060, 1, 70},
	{1306, 1076, 2, 78},
	{1322, 1080},
	{1717, 1104},
	{1741, 1108},
	{1339, 1116, 6, 2807},
	{1354, 1120, 6, 85},
	{1369, 1124, 2, 92},
	{1389, 1128, 1, 94},
	{1428, 1136, 4, 2813},
	{43130, 1140, 1, 2230},
	{1444, 2480},
	{1458, 2484},
	{1486, 2492},
	{1500, 2496},
	{1514, 2500},
	{1528, 2504},
	{1542, 2508},
	{1556, 2512},
	{1570, 2516},
	{1584, 2520},
	{1599, 2524},
	{1614, 2528},
	{1629, 2532},
	{1644, 2536},
	{1659, 2540},
	{1674, 2548},
	{1685, 2552},
	{1701, 2556},
	{1789, 32776, 22, 2817},
	{1802, 32784, 22, 2839},
	{1814, 32788, 17, 2861},
	{1830, 32792, 17, 2861},
	{1846, 32796, 15, 2878},
	{1859, 32824, 17, 2861},
	{1875, 32828, 17, 2861},
	{47094, 32832, 17, 2861},
	{47110, 32836, 17, 2861},
	{47126, 33280, 1, 2893},
	{47144, 33284},
	{1891, 33296, 23, 2894},
	{1905, 33300, 28, 2917},
	{1922, 33304, 16, 2945},
	{1943, 33308, 28, 247},
	{1957, 33312, 32, 275},
	{1974, 33316, 13, 307},
	{1995, 33320, 9, 320},
	{2013, 33324, 1, 329},
	{43152, 33328, 1, 2961},
	{2036, 33344, 2, 330},
	{2057, 33348},
	{2077, 33352, 1, 332},
	{2100, 33356, 11, 2962},
	{2118, 33436, 1, 342},
	{2522, 36608},
	{2540, 36612, 3, 2973},
	{2558, 36616},
	{2576, 36620, 10, 2976},
	{2594, 36656, 14, 397},
	{2612, 36660, 4, 411},
	{2630, 36664, 8, 2986},
	{2648, 36668, 2, 2994},
	{2682, 39160, 6, 2337},
	{3477, 40960},
	{3495, 40964, 6, 2996},
	{3513, 40968, 2, 456},
	{3531, 40972, 9, 459},
	{3549, 40976, 2, 468},
	{3567, 40980, 6, 3002},
	{3585, 40984, 11, 3008},
	{3603, 40988},
	{47162, 45056, 7, 3019},
	{3621, 45060, 5, 3026},
	{47186, 45064, 6, 3031},
	{47209, 45068, 6, 3031},
	{47232, 45072, 6, 3037},
	{47256, 45076, 6, 3037},
	{3645, 45080},
	{3670, 45084, 3, 3043},
	{3694, 45088},
	{3715, 45092, 1, 491},
	{3736, 45096, 12, 2365},
	{3760, 45100, 10, 503},
	{3784, 45104},
	{3810, 45108},
	{3836, 45112},
	{3862, 45116},
	{3888, 45120},
	{3914, 45124},
	{3940, 45128},
	{3966, 45132},
	{3992, 45136},
	{4018, 45140},
	{4044, 45144},
	{4071, 45148},
	{4098, 45152},
	{4125, 45156},
	{4152, 45160},
	{4179, 45164},
	{4206, 45168},
	{4233, 45172},
	{4260, 45176},
	{4287, 45180},
	{4314, 45184},
	{4341, 45188},
	{4368, 45192},
	{4395, 45196},
	{4422, 45200},
	{4449, 45204},
	{4476, 45208},
	{4503, 45212},
	{4530, 45216},
	{4557, 45220},
	{4584, 45224},
	{4611, 45228},
	{47280, 45232, 2, 3046},
	{47305, 45236, 2, 3046},
	{47330, 45240, 2, 3046},
	{47355, 45244, 2, 3046},
	{4638, 45248, 8, 513},
	{47380, 45252, 2, 3048},
	{4694, 45256, 1, 526},
	{4721, 45260, 1, 526},
	{4748, 45264, 1, 526},
	{4775, 45268, 1, 526},
	{47401, 45272, 4, 3050},
	{47422, 45276, 5, 3054},
	{47443, 45280, 4, 3059},
	{47464, 45284, 5, 3054},
	{47485, 45288, 4, 3059},
	{47506, 45292, 5, 3063},
	{47523, 45296, 9, 3068},
	{47532, 45300, 14, 3077},
	{47553, 45304, 7, 3091},
	{47568, 45308, 19, 3098},
	{47578, 45332, 1, 895},
	{47593, 45336},
	{47611, 45340},
	{47630, 45344},
	{47649, 45348},
	{47669, 45352},
	{47690, 45356},
	{47712, 45360},
	{47730, 45364},
	{47749, 45368},
	{47768, 45372},
	{47788, 45376},
	{47809, 45380},
	{47831, 45384},
	{47849, 45388},
	{47868, 45392},
	{47887, 45396},
	{47907, 45400},
	{47928, 45404},
	{47950, 45408},
	{47968, 45412},
	{47987, 45416},
	{48006, 45420},
	{48026, 45424},
	{48047, 45428},
	{48069, 45432},
	{48087, 45436},
	{48106, 45440},
	{48125, 45444},
	{48145, 45448},
	{48166, 45452},
	{48188, 45456},
	{48206, 45460},
	{48225, 45464},
	{48244, 45468},
	{48264, 45472},
	{48285, 45476},
	{48307, 45480, 2, 3117},
	{48317, 45484, 1, 3119},
	{6089, 45568},
	{6114, 45572, 9, 3120},
	{6138, 45576},
	{6170, 45580},
	{6202, 45584},
	{6226, 45588, 1, 491},
	{6250, 45596, 4, 576},
	{6274, 45600},
	{6295, 45604, 1, 491},
	{6316, 45608, 13, 580},
	{6340, 45612, 9, 593},
	{6364, 45616},
	{6390, 45620},
	{6416, 45624},
	{6442, 45628},
	{6468, 45632},
	{6494, 45636},
	{6520, 45640},
	{6546, 45644},
	{6572, 45648},
	{6598, 45652},
	{6624, 45656},
	{6651, 45660},
	{6678, 45664},
	{6705, 45668},
	{6732, 45672},
	{6759, 45676},
	{6786, 45680},
	{6813, 45684},
	{6840, 45688},
	{6867, 45692},
	{6894, 45696},
	{6921, 45700},
	{6948, 45704},
	{6975, 45708},
	{7002, 45712},
	{7029, 45716},
	{7056, 45720},
	{7083, 45724},
	{7110, 45728},
	{7137, 45732},
	{7164, 45736},
	{7191, 45740},
	{48337, 45744, 4, 3129},
	{48363, 45748, 2, 3133},
	{7218, 45760, 8, 513},
	{7278, 45768, 1, 526},
	{7307, 45772, 1, 526},
	{7336, 45776, 1, 526},
	{7365, 45780, 1, 526},
	{7445, 45856},
	{7466, 45860, 1, 491},
	{7984, 46080},
	{8009, 46084, 5, 3026},
	{8033, 46088},
	{8065, 46092},
	{8097, 46096},
	{8121, 46100, 1, 491},
	{8145, 46108, 4, 612},
	{8169, 46112},
	{8190, 46116, 1, 491},
	{8211, 46120, 12, 616},
	{8235, 46124, 9, 628},
	{8259, 46128},
	{8285, 46132},
	{8311, 46136},
	{8337, 46140},
	{8363, 46144},
	{8389, 46148},
	{8415, 46152},
	{8441, 46156},
	{8467, 46160},
	{8493, 46164},
	{8519, 46168},
	{8546, 46172},
	{8573, 46176},
	{8600, 46180},
	{8627, 46184},
	{8654, 46188},
	{8681, 46192},
	{8708, 46196},
	{8735, 46200},
	{8762, 46204},
	{8789, 46208},
	{8816, 46212},
	{8843, 46216},
	{8870, 46220},
	{8897, 46224},
	{8924, 46228},
	{8951, 46232},
	{8978, 46236},
	{9005, 46240},
	{9032, 46244},
	{9059, 46248},
	{9086, 46252},
	{9113, 46272, 8, 513},
	{9173, 46280, 1, 526},
	{9202, 46284, 1, 526},
	{9231, 46288, 1, 526},
	{9260, 46292, 1, 526},
	{48395, 46340, 20, 3135},
	{48407, 46348, 9, 3155},
	{48424, 46352, 3, 3164},
	{48442, 46356, 2, 3167},
	{9340, 46368},
	{9361, 46372, 1, 491},
	{48459, 46592, 5, 3169},
	{48471, 46600, 1, 3174},
	{48490, 46604, 2, 3175},
	{48504, 46608, 7, 3177},
	{48523, 46624, 2, 3184},
	{48539, 46628, 5, 3186},
	{48561, 46640, 4, 3191},
	{48587, 46672, 1, 3195},
	{48601, 46848, 6, 3196},
	{48610, 46852, 15, 3202},
	{48621, 46856, 6, 3217},
	{48631, 46860, 19, 3223},
	{9852, 47104, 15, 3242},
	{9879, 47108},
	{9893, 47112},
	{9907, 47116},
	{9921, 47120},
	{9937, 47124},
	{9953, 47128},
	{9969, 47132, 2, 659},
	{9990, 47136, 2, 659},
	{10011, 47140, 2, 659},
	{10032, 47144, 1, 661},
	{10060, 47148, 1, 662},
	{10085, 47152},
	{10100, 47156, 1, 663},
	{10115, 47160},
	{10144, 47164, 1, 663},
	{10173, 47168},
	{10206, 47172, 1, 663},
	{10239, 47176, 12, 664},
	{10257, 47180, 11, 676},
	{10275, 47184, 1, 687},
	{10288, 47188, 6, 688},
	{10312, 47192},
	{10339, 47196},
	{10366, 47200, 2, 3257},
	{10387, 47204},
	{10414, 47208},
	{10441, 47212},
	{10459, 47216},
	{10477, 47220},
	{10495, 47224, 1, 696},
	{10523, 47228, 4, 3259},
	{10545, 47232},
	{10565, 47236},
	{10588, 47240, 9, 702},
	{48643, 47244},
	{10605, 47248, 1, 526},
	{10626, 47252, 1, 526},
	{10647, 47256, 1, 526},
	{10668, 47260, 1, 526},
	{10689, 47264, 5, 3263},
	{10707, 47268, 1, 712},
	{10726, 47272},
	{48662, 47276, 2, 3268},
	{48693, 47280, 2, 3268},
	{48724, 47284, 2, 3268},
	{48755, 47288, 2, 3268},
	{48786, 47292, 1, 3270},
	{10748, 47296, 3, 713},
	{10765, 47300},
	{10794, 47304, 1, 716},
	{10823, 47308, 3, 713},
	{10841, 47360},
	{10861, 47364},
	{10881, 47368},
	{10901, 47372},
	{10921, 47376},
	{10941, 47380},
	{10961, 47384},
	{10981, 47388},
	{11001, 47392},
	{11021, 47396},
	{11041, 47400},
	{11062, 47404},
	{11083, 47408},
	{11104, 47412},
	{11125, 47416},
	{11146, 47420},
	{11167, 47604, 2, 717},
	{11191, 47608},
	{11212, 47612},
	{43203, 47616},
	{43220, 47620},
	{11228, 163840, 15, 3271},
	{11246, 163844, 10, 730},
	{11263, 163848, 7, 740},
	{11277, 163852, 22, 3286},
	{11296, 163856, 18, 3308},
	{11316, 163860},
	{11335, 163868, 2, 786},
	{11352, 163872},
	{11372, 163876},
	{11392, 163880, 1, 788},
	{11409, 163884},
	{11424, 163888, 2, 789},
	{11448, 163892, 2, 791},
	{11488, 163900, 8, 3326},
	{11506, 163904, 14, 804},
	{11516, 163908, 9, 818},
	{11532, 163912},
	{11547, 163916},
	{11568, 163920},
	{11584, 163924},
	{11606, 163928, 2, 827},
	{11624, 163932, 1, 829},
	{11642, 163944, 1, 830},
	{11660, 163948, 1, 830},
	{11684, 163952, 1, 830},
	{11703, 163956, 1, 830},
	{11728, 163960, 1, 830},
	{11750, 163964, 13, 3334},
	{11774, 163968},
	{11790, 163972, 1, 840},
	{11809, 164328, 1, 841},
	{11830, 164332, 1, 841},
	{11851, 164336, 1, 841},
	{11872, 164340, 1, 841},
	{11893, 164344},
	{11911, 164348},
	{11929, 164352, 2, 842},
	{11949, 164356, 3, 844},
	{11973, 164360, 2, 847},
	{11997, 164364, 1, 849},
	{12017, 164368, 2, 844},
	{12037, 164372, 2, 847},
	{12057, 164376, 2, 844},
	{12077, 164380, 2, 847},
	{12097, 164384, 2, 844},
	{12117, 164388, 2, 847},
	{12137, 164392, 2, 844},
	{12157, 164396, 2, 847},
	{12177, 164400, 7, 850},
	{12192, 164404, 2, 857},
	{12221, 164408, 8, 859},
	{12236, 164412, 8, 867},
	{12251, 164416, 3, 844},
	{12276, 164420, 2, 847},
	{12301, 164424},
	{12319, 164428},
	{12337, 164432, 3, 844},
	{12362, 164436, 2, 847},
	{12387, 164440, 3, 844},
	{12412, 164444, 2, 847},
	{12437, 164448, 3, 844},
	{12462, 164452, 2, 847},
	{12487, 164456, 3, 844},
	{12512, 164460, 2, 847},
	{12537, 164464, 3, 844},
	{12562, 164468, 2, 847},
	{12587, 164472, 3, 844},
	{12612, 164476, 2, 847},
	{12637, 164480, 3, 844},
	{12662, 164484, 2, 847},
	{12687, 164488, 3, 844},
	{12712, 164492, 2, 847},
	{12737, 164496, 3, 844},
	{12762, 164500, 2, 847},
	{12787, 164504, 3, 844},
	{12812, 164508, 2, 847},
	{12837, 164512, 3, 844},
	{12863, 164516, 2, 847},
	{12889, 164520, 3, 844},
	{12915, 164524, 2, 847},
	{12941, 164528, 3, 844},
	{12967, 164532, 2, 847},
	{12993, 164536, 3, 844},
	{13019, 164540, 2, 847},
	{13045, 164544, 3, 844},
	{13071, 164548, 2, 847},
	{13097, 164552, 3, 844},
	{13123, 164556, 2, 847},
	{13149, 164560},
	{13168, 164564},
	{13187, 164568},
	{13206, 164572},
	{13225, 164576},
	{13244, 164580},
	{13263, 164584},
	{13282, 164588},
	{13301, 164592},
	{13320, 164596},
	{13339, 164600},
	{13358, 164604},
	{13377, 164608},
	{13396, 164612},
	{13415, 164616},
	{13434, 164620},
	{13453, 164624},
	{13472, 164628},
	{13491, 164632},
	{13510, 164636},
	{13529, 164640},
	{13549, 164644},
	{13569, 164648},
	{13589, 164652},
	{13609, 164656},
	{13629, 164660},
	{13649, 164664},
	{13669, 164668},
	{13689, 164672},
	{13709, 164676},
	{13729, 164680},
	{13749, 164684},
	{13769, 164688, 15, 875},
	{13789, 164692, 3, 890},
	{13811, 164696, 2, 893},
	{13839, 164700, 4, 3347},
	{13868, 164704, 1, 902},
	{13889, 164708, 1, 903},
	{13899, 164712, 1, 904},
	{43258, 164716},
	{43280, 164720},
	{48814, 164816, 5, 3351},
	{48838, 164820},
	{48867, 164824, 1, 1615},
	{48900, 164828, 2, 3356},
	{48932, 164836, 11, 3358},
	{48958, 164848},
	{48978, 164852, 2, 3369},
	{49002, 164856, 2, 3356},
	{14017, 164876},
	{14046, 164880, 7, 3371},
	{14071, 164884},
	{14084, 164888},
	{14099, 164892},
	{14113, 164896},
	{49025, 164900, 8, 3378},
	{14143, 164904, 4, 931},
	{14167, 164908, 6, 935},
	{14186, 164912, 4, 941},
	{14204, 164916, 4, 945},
	{14225, 164924},
	{14244, 164928},
	{14264, 164932},
	{14283, 164936},
	{14303, 164940},
	{14322, 164944},
	{14342, 164948},
	{14363, 164952},
	{14385, 164956},
	{14406, 164960},
	{14428, 164964},
	{14449, 164968},
	{14471, 164972},
	{14492, 164976},
	{14514, 164980},
	{14535, 164984},
	{14557, 164988},
	{14578, 164992},
	{14600, 164996},
	{14621, 165000},
	{14643, 165004},
	{14664, 165008},
	{14686, 165012},
	{14707, 165016},
	{14729, 165020},
	{14750, 165024},
	{14772, 165028},
	{14793, 165032},
	{14815, 165036},
	{14836, 165040},
	{14858, 165044},
	{14879, 165048},
	{14901, 165052},
	{14922, 165056},
	{14944, 165060},
	{14965, 165064},
	{14987, 165068},
	{15008, 165072},
	{15030, 165076},
	{15051, 165080},
	{15073, 165084},
	{15094, 165088},
	{15116, 165092},
	{15137, 165096},
	{15159, 165100},
	{15180, 165104},
	{15202, 165108},
	{15223, 165112},
	{15245, 165116},
	{15266, 165120},
	{15288, 165124},
	{15309, 165128},
	{15331, 165132},
	{15352, 165136},
	{15374, 165140},
	{15395, 165144},
	{15417, 165148},
	{15438, 165152},
	{15460, 165156},
	{15481, 165160},
	{15503, 165164},
	{15525, 165168},
	{15548, 165172},
	{15570, 165176},
	{15593, 165180},
	{15615, 165184},
	{15638, 165188},
	{15660, 165192},
	{15683, 165196},
	{15705, 165200},
	{15728, 165204},
	{15750, 165208},
	{15773, 165212},
	{15795, 165216},
	{15818, 165220},
	{15840, 165224},
	{15863, 165228},
	{15885, 165232},
	{15908, 165236},
	{15930, 165240},
	{15953, 165244},
	{15975, 165248},
	{15998, 165252},
	{16020, 165256},
	{16043, 165260},
	{16065, 165264},
	{16088, 165268},
	{16110, 165272},
	{16133, 165276},
	{16155, 165280},
	{16178, 165284},
	{16200, 165288},
	{16223, 165292},
	{16245, 165296},
	{16268, 165300},
	{16290, 165304},
	{16313, 165308},
	{16327, 165312},
	{16341, 165316},
	{16355, 165320},
	{16369, 165324},
	{16383, 165328},
	{16397, 165332},
	{16411, 165336},
	{16425, 165340},
	{16439, 165344},
	{16453, 165348},
	{16467, 165352},
	{16481, 165356},
	{16495, 165360},
	{16509, 165364},
	{16523, 165368},
	{16537, 165372},
	{16551, 165376},
	{16565, 165380},
	{16579, 165384},
	{16593, 165388},
	{16607, 165392},
	{16621, 165396},
	{16635, 165400},
	{16649, 165404},
	{49041, 165408, 2, 3386},
	{16672, 165444, 13, 3388},
	{16692, 165448, 13, 3388},
	{16712, 165452, 13, 3388},
	{16732, 165456, 13, 3388},
	{16752, 165460, 13, 3388},
	{16772, 165464, 13, 3388},
	{16792, 165468, 13, 3388},
	{16812, 165472, 13, 3388},
	{16832, 165476, 13, 3388},
	{16852, 165480, 13, 3388},
	{16872, 165484, 13, 3388},
	{16893, 165488, 13, 3388},
	{16914, 165492, 13, 3388},
	{16935, 165496, 13, 3388},
	{16956, 165500, 13, 3388},
	{16977, 165504, 13, 3388},
	{16998, 165508, 13, 3388},
	{17019, 165512, 13, 3388},
	{17040, 165516, 13, 3388},
	{17061, 165520, 13, 3388},
	{17082, 165524, 11, 3401},
	{17103, 165528, 11, 3401},
	{17124, 165532, 11, 3401},
	{17145, 165536, 11, 3401},
	{17166, 165540, 11, 3401},
	{17187, 165544, 11, 3401},
	{17208, 165548, 11, 3401},
	{17229, 165552, 11, 3401},
	{17250, 165556, 11, 3401},
	{17271, 165560, 11, 3401},
	{17292, 165564, 11, 3401},
	{17313, 165568, 11, 3401},
	{17334, 165572, 3, 3412},
	{17352, 165580, 16, 973},
	{17369, 165584, 16, 973},
	{17387, 165588, 7, 989},
	{17408, 165592, 7, 3415},
	{17426, 165600, 7, 1002},
	{17441, 165608, 2, 3257},
	{49054, 165612},
	{49078, 165616, 1, 663},
	{17458, 165640, 1, 1009},
	{17480, 165644, 5, 1010},
	{17502, 165648, 1, 1015},
	{17522, 165652, 8, 1016},
	{43302, 165712, 8, 2475},
	{17544, 165716, 8, 3422},
	{17562, 165720, 8, 1032},
	{17583, 165724, 17, 1040},
	{17604, 165728, 6, 1057},
	{17622, 165732, 6, 1057},
	{17640, 165736, 6, 1057},
	{17658, 165740, 6, 1057},
	{17676, 165744, 6, 1057},
	{17694, 165748, 6, 1057},
	{17712, 165752, 6, 1057},
	{17730, 165756, 6, 1057},
	{17748, 165760, 9, 3430},
	{17766, 165764, 9, 3430},
	{17784, 165768, 9, 3430},
	{17802, 165772, 9, 3430},
	{17820, 165776, 9, 3430},
	{17838, 165780, 9, 3430},
	{17856, 165784, 9, 3430},
	{17874, 165788, 9, 3430},
	{17906, 165840, 1, 1072},
	{17921, 165844},
	{17939, 165848},
	{17957, 165852},
	{17974, 165856},
	{17995, 165860, 1, 1073},
	{18011, 165864},
	{18024, 165872, 6, 2491},
	{18058, 165880, 1, 1082},
	{18080, 165884, 1, 1083},
	{18107, 165888, 10, 1084},
	{18124, 165892, 12, 1094},
	{18132, 165896, 5, 3439},
	{18149, 165900, 18, 3444},
	{18167, 165904, 20, 1127},
	{18183, 165908, 16, 1147},
	{18202, 165912, 10, 1163},
	{18217, 165916, 29, 3462},
	{18235, 165920, 16, 1201},
	{18253, 165924, 3, 1217},
	{18277, 165928},
	{18302, 165932, 11, 1221},
	{18325, 165936, 5, 1232},
	{18376, 165944, 3, 2532},
	{18391, 165948, 5, 1243},
	{18421, 165952, 5, 1248},
	{18436, 165956},
	{43328, 165960, 6, 3491},
	{18454, 166400, 2, 1253},
	{18471, 166404, 2, 1255},
	{18490, 166408, 1, 1257},
	{18506, 166412, 4, 1258},
	{18559, 166424},
	{18582, 166428},
	{18808, 166472, 6, 2541},
	{18826, 166476, 24, 1310},
	{18844, 166480},
	{18988, 166512},
	{18999, 166516},
	{19012, 166520},
	{19029, 166524, 9, 2547},
	{19048, 166528},
	{19059, 166532, 3, 1351},
	{19078, 166536},
	{19100, 166540},
	{19122, 166544, 3, 3497},
	{19169, 166552, 3, 2556},
	{19260, 166572, 1, 1370},
	{19306, 166580, 1, 1371},
	{19335, 166588, 9, 1373},
	{19352, 166592, 4, 1382},
	{19379, 166596, 4, 1386},
	{19406, 166600, 4, 1390},
	{19741, 166696},
	{19772, 166700},
	{19815, 166704, 1, 1395},
	{19853, 166712, 1, 1396},
	{19873, 166732, 2, 1397},
	{19892, 166736, 5, 1399},
	{19914, 166740, 17, 3500},
	{19935, 166744, 3, 1423},
	{20042, 166764, 11, 3517},
	{20055, 166768, 6, 1438},
	{20096, 166776, 2, 1444},
	{20126, 166780},
	{20150, 166784},
	{20180, 166788},
	{20211, 166792},
	{20240, 166796},
	{20270, 166800, 3, 1446},
	{20359, 166868, 8, 1461},
	{20385, 166872, 8, 1469},
	{20411, 166876, 5, 1477},
	{20427, 166880, 8, 2590},
	{20443, 166884, 3, 1488},
	{20458, 166888},
	{20481, 166892},
	{20504, 166896},
	{20527, 166900},
	{20550, 166904, 8, 1491},
	{20584, 166908, 8, 1499},
	{20618, 166912, 8, 1507},
	{20652, 166916, 8, 1515},
	{20686, 166920, 8, 1491},
	{20720, 166924, 8, 1499},
	{20754, 166928, 8, 1507},
	{20788, 166932, 8, 1515},
	{20822, 166936, 8, 1491},
	{20856, 166940, 8, 1499},
	{20890, 166944, 8, 1507},
	{20924, 166948, 8, 1515},
	{20958, 166952, 8, 1491},
	{20992, 166956, 8, 1499},
	{21026, 166960, 8, 1507},
	{21060, 166964, 8, 1515},
	{21094, 166968, 2, 1523},
	{21118, 166972, 2, 1525},
	{21142, 166976, 5, 3528},
	{21163, 166980, 12, 1531},
	{21183, 166984, 2, 1543},
	{21203, 166988, 20, 1545},
	{21241, 166992, 6, 3533},
	{49102, 166996, 10, 3539},
	{21310, 167008},
	{21357, 167020, 3, 1572},
	{21372, 167024, 10, 3549},
	{21387, 167028, 5, 3559},
	{49122, 167032, 14, 3564},
	{21546, 167060},
	{21565, 167068},
	{21612, 167080, 3, 1572},
	{21627, 167084, 10, 3549},
	{21642, 167088, 5, 3559},
	{49145, 167092, 14, 3564},
	{21801, 167120},
	{21820, 167128},
	{21867, 167140, 3, 1572},
	{21882, 167144, 10, 3549},
	{21897, 167148, 5, 3559},
	{49168, 167152, 14, 3564},
	{22056, 167180},
	{22075, 167188},
	{22122, 167200, 3, 1572},
	{22137, 167204, 10, 3549},
	{22152, 167208, 5, 3559},
	{49191, 167212, 14, 3564},
	{22311, 167240},
	{22330, 167248},
	{22377, 167260, 3, 1572},
	{22392, 167264, 10, 3549},
	{22407, 167268, 5, 3559},
	{49214, 167272, 14, 3564},
	{22566, 167300},
	{22585, 167308},
	{22632, 167320, 3, 1572},
	{22647, 167324, 10, 3549},
	{22662, 167328, 5, 3559},
	{49237, 167332, 14, 3564},
	{22821, 167360},
	{22840, 167368},
	{22887, 167380, 3, 1572},
	{22902, 167384, 10, 3549},
	{22917, 167388, 5, 3559},
	{49260, 167392, 14, 3564},
	{23076, 167420},
	{23095, 167428},
	{23142, 167440, 3, 1572},
	{23157, 167444, 10, 3549},
	{23172, 167448, 5, 3559},
	{49283, 167452, 14, 3564},
	{23331, 167480},
	{23350, 167488, 1, 1615},
	{23369, 167492, 1, 1615},
	{23388, 167496, 1, 1615},
	{23407, 167500, 1, 1615},
	{23426, 167504, 1, 1615},
	{23445, 167508, 1, 1615},
	{23464, 167512, 1, 1615},
	{23483, 167516, 1, 1615},
	{23902, 167584, 1, 1615},
	{23925, 167588, 1, 1615},
	{23948, 167592, 1, 1615},
	{23971, 167596, 1, 1615},
	{23994, 167600, 1, 1615},
	{24017, 167604, 1, 1615},
	{24040, 167608, 1, 1615},
	{24063, 167612, 1, 1615},
	{24086, 167616, 3, 1616},
	{24104, 167620, 3, 1616},
	{24122, 167624, 3, 1616},
	{24140, 167628, 3, 1616},
	{24158, 167632, 3, 1616},
	{24176, 167636, 3, 1616},
	{24194, 167640, 3, 1616},
	{24212, 167644, 3, 1616},
	{24230, 167648, 5, 3578},
	{24248, 167652, 5, 3578},
	{24266, 167656, 5, 3578},
	{24284, 167660, 5, 3578},
	{24302, 167664, 5, 3578},
	{24320, 167668, 5, 3578},
	{24338, 167672, 5, 3578},
	{24356, 167676, 5, 3578},
	{24374, 196608, 1, 1627},
	{24394, 196612, 1, 1628},
	{24414, 196616},
	{24434, 196620},
	{24454, 196624},
	{24475, 196628},
	{25012, 196704, 1, 1631},
	{25034, 196708, 1, 1632},
	{25056, 196712},
	{25079, 196716},
	{25102, 196720},
	{25125, 196724},
	{25148, 196728},
	{25171, 196732},
	{25194, 196736},
	{25218, 196740},
	{25242, 196744},
	{25266, 196748},
	{25290, 196752},
	{25314, 196756},
	{25338, 196760},
	{25362, 196764},
	{25386, 196768},
	{25408, 196772},
	{25430, 196776},
	{25451, 196780},
	{25472, 196784},
	{25496, 196788},
	{25520, 196792},
	{25544, 196796},
	{25568, 196800},
	{25592, 196804},
	{49306, 196808},
	{49330, 196812},
	{25676, 196852, 1, 1634},
	{25736, 196864},
	{25749, 196868},
	{25762, 196872},
	{25775, 196876},
	{25788, 196880},
	{25801, 196884},
	{25814, 196888},
	{25827, 196892},
	{43343, 196896, 5, 2640},
	{25863, 196908, 1, 663},
	{25882, 196912},
	{25900, 196916},
	{25927, 196920},
	{25980, 196936},
	{26003, 196940},
	{26026, 196944},
	{26054, 196948},
	{26082, 196952},
	{26110, 196956},
	{26138, 196960, 1, 1638},
	{26156, 196964, 6, 3583},
	{26174, 196968},
	{26189, 196972},
	{26213, 196976},
	{26237, 196980},
	{26256, 196984},
	{26275, 196988},
	{26299, 196992},
	{26323, 196996},
	{26347, 197000},
	{26371, 197028, 1, 1643},
	{26389, 197032, 7, 3589},
	{26407, 197036},
	{26425, 197040},
	{26443, 197044, 1, 1646},
	{26461, 197048, 5, 3596},
	{26479, 197052},
	{26497, 197056, 2, 2645},
	{26516, 197060, 5, 1651},
	{26535, 197072},
	{26559, 197076, 2, 2645},
	{26579, 197080, 5, 1651},
	{26599, 197084, 9, 3601},
	{26618, 197088, 9, 3601},
	{26732, 197120},
	{26751, 197124, 1, 1680},
	{26773, 197128},
	{26792, 197132, 1, 1681},
	{26814, 197136, 7, 1682},
	{26832, 197140},
	{26852, 197144, 1, 1680},
	{26875, 197148},
	{26895, 197152, 1, 1681},
	{26918, 197156, 7, 1682},
	{26937, 197160, 7, 1689},
	{26949, 197164, 2, 1696},
	{26983, 197172, 1, 1699},
	{27001, 197176, 6, 3610},
	{27021, 197180, 2, 330},
	{27038, 197184},
	{27054, 197188, 1, 1706},
	{27081, 197196, 1, 1708},
	{27137, 197208, 1, 1711},
	{27159, 197212, 1, 1712},
	{27227, 197232, 2, 1713},
	{27249, 197236, 2, 1715},
	{27271, 197240, 2, 1713},
	{27294, 197244, 2, 1715},
	{27317, 197248, 2, 1713},
	{27339, 197252, 2, 1715},
	{43362, 197256},
	{43384, 197260},
	{49354, 197264},
	{49376, 197268},
	{49398, 197272},
	{49421, 197276},
	{27439, 197380, 1, 1719},
	{27456, 197384, 1, 1720},
	{27674, 197436, 1, 1727},
	{27689, 197440, 1, 1728},
	{27704, 197444, 1, 1729},
	{27717, 197448, 1, 1730},
	{27731, 197452, 1, 1731},
	{27745, 197456, 1, 1732},
	{27757, 197460, 6, 3616},
	{27780, 197464, 6, 3622},
	{27802, 197468, 1, 1740},
	{27822, 197472, 1, 1741},
	{27836, 197476, 1, 1742},
	{27850, 197480, 1, 1743},
	{27862, 197484, 1, 1744},
	{27946, 197552, 1, 1745},
	{27995, 197560, 1, 1746},
	{28015, 197568},
	{28041, 197572, 1, 1628},
	{28123, 197584},
	{28146, 197588, 1, 1628},
	{28172, 197592},
	{28194, 197596, 1, 1628},
	{28219, 197600},
	{28238, 197604, 1, 1628},
	{28260, 197608, 1, 1343},
	{28274, 197612},
	{28291, 197616, 1, 1628},
	{28311, 197620, 8, 1747},
	{28328, 197624, 13, 1755},
	{28345, 197628},
	{28362, 197632, 1, 1698},
	{28382, 197636},
	{28399, 197640, 1, 1663},
	{28419, 197644, 2, 1768},
	{28438, 197888, 8, 1770},
	{28459, 197892, 8, 1770},
	{28480, 198656, 6, 1778},
	{28533, 198920, 1, 3628},
	{28552, 198924, 2, 2657},
	{28699, 198948},
	{28715, 198952},
	{28730, 198956, 3, 3629},
	{28756, 198960},
	{28772, 198964},
	{28790, 198968, 1, 3632},
	{28807, 198972, 2, 2659},
	{28828, 198976},
	{29008, 199012},
	{29024, 199016},
	{29045, 199020, 8, 3633},
	{29053, 199024},
	{29067, 199028},
	{29081, 199032},
	{29095, 199036, 3, 1801},
	{29110, 199040, 2, 1804},
	{29122, 199044, 1, 830},
	{29144, 199048, 3, 1806},
	{43558, 199052, 2, 2661},
	{49444, 199056, 2, 3641},
	{49469, 199060, 1, 3643},
	{18967, 199064, 1, 3644},
	{29160, 199168, 1, 1809},
	{29185, 199172, 2, 1810},
	{29210, 199184, 2, 1812},
	{29236, 199188, 2, 1812},
	{29262, 199192, 2, 1812},
	{29288, 199212, 2, 1812},
	{29314, 199296, 2, 1814},
	{29342, 199300, 1, 1816},
	{29366, 199304, 1, 1817},
	{29390, 199308, 1, 1818},
	{29423, 199312, 1, 1818},
	{29451, 199328, 2, 1814},
	{29480, 199332, 1, 1816},
	{29505, 199336, 1, 1817},
	{29530, 199340, 1, 1818},
	{29564, 199344, 1, 1818},
	{29593, 199360, 2, 1814},
	{29617, 199364, 1, 1816},
	{29637, 199368, 1, 1817},
	{29657, 199372, 1, 1818},
	{29686, 199376, 1, 1818},
	{29710, 199936},
	{29737, 199940},
	{29764, 199944},
	{29791, 199948},
	{29818, 199952},
	{29845, 199956},
	{29872, 199960},
	{29899, 199964},
	{29926, 199968, 4, 2663},
	{29951, 200192},
	{29970, 200196, 1, 840},
	{29992, 200448},
	{30016, 200452, 1, 1828},
	{30039, 200456},
	{30063, 200460, 1, 1828},
	{30086, 200464},
	{30110, 200468, 1, 1828},
	{30133, 200472},
	{30157, 200476, 1, 1828},
	{30217, 200704},
	{30229, 200708},
	{30241, 200712},
	{30259, 200716},
	{30278, 200720},
	{30296, 200724},
	{30308, 200728},
	{30320, 200732},
	{30338, 200736},
	{30356, 200740},
	{30375, 200744, 4, 1829},
	{30389, 200748, 2, 1833},
	{30407, 200752, 2, 3645},
	{30421, 200756, 2, 3647},
	{30435, 200760, 2, 1839},
	{30452, 200764, 2, 1841},
	{30469, 200768},
	{30482, 200772, 2, 1843},
	{30494, 200776},
	{30508, 200780},
	{30524, 200784},
	{30538, 200788},
	{30554, 200792},
	{30569, 200796},
	{30586, 200800},
	{30601, 200804},
	{30618, 200808, 2, 1845},
	{30640, 200812, 9, 3649},
	{30657, 200816, 2, 1857},
	{30678, 200820, 2, 1859},
	{30690, 200824},
	{30705, 200828, 6, 1861},
	{30720, 200832, 2, 1867},
	{30734, 200836},
	{49496, 200840},
	{49525, 200844},
	{49554, 200848},
	{49583, 200852},
	{49612, 200856},
	{49621, 200860},
	{49630, 200864},
	{49639, 200868},
	{49648, 200872},
	{49678, 200876},
	{49708, 200880},
	{49739, 200884},
	{49770, 200888},
	{49800, 200892},
	{49830, 200896},
	{49861, 200900},
	{49892, 200904},
	{49922, 200908},
	{49952, 200912},
	{49983, 200916},
	{50014, 200920},
	{50044, 200924},
	{50074, 200928},
	{50105, 200932},
	{2666, 200960, 7, 3658},
	{50136, 200964, 13, 3665},
	{50154, 200968, 7, 3678},
	{50172, 200972, 3, 3685},
	{50192, 200976, 8, 3688},
	{50214, 200980, 8, 3696},
	{50236, 200984},
	{50260, 200988, 6, 3704},
	{30847, 212992},
	{30867, 212996},
	{30887, 213000},
	{30907, 213004},
	{30927, 213008},
	{30947, 213012},
	{30967, 213016},
	{30987, 213020},
	{31007, 213024},
	{31027, 213028},
	{31047, 213032},
	{31067, 213036},
	{31087, 213040},
	{31110, 213044},
	{31133, 213048},
	{31156, 213248},
	{31177, 213252},
	{31198, 213260},
	{31219, 213264},
	{31240, 213268},
	{31264, 213272},
	{31288, 213276},
	{31312, 213280},
	{31336, 213284},
	{31360, 213288},
	{31384, 213292},
	{31408, 213296},
	{50284, 213300},
	{50308, 213304},
	{50332, 213308},
	{50356, 213312},
	{50380, 213316},
	{50404, 213320},
	{43570, 213648},
	{43590, 213652},
	{43610, 213656},
	{43630, 213660},
	{43650, 213664},
	{43670, 213668},
	{43690, 213672},
	{43710, 213676},
	{43730, 213680},
	{43755, 213684},
	{43780, 213688},
	{43805, 213692},
	{43830, 213696},
	{43855, 213700},
	{43880, 213704},
	{43905, 213708},
	{43930, 213712},
	{43953, 213716},
	{43976, 213720},
	{43999, 213724},
	{44022, 213728},
	{44045, 213732},
	{44068, 213736},
	{44091, 213740},
	{31892, 214016},
	{31914, 214020, 1, 1869},
	{31936, 214024},
	{31958, 214028, 1, 1869},
	{31980, 214032},
	{32002, 214036, 1, 1869},
	{32024, 214040},
	{32046, 214044, 1, 1869},
	{32068, 214272},
	{32090, 214276},
	{32112, 214280},
	{32134, 214284},
	{32156, 214288},
	{32178, 214292},
	{32200, 214296},
	{32222, 214300},
	{32244, 214304},
	{32266, 214308},
	{32288, 214312},
	{32310, 214316},
	{32332, 214320},
	{32354, 214324},
	{32376, 214328},
	{32398, 214332},
	{32420, 214528},
	{32440, 214532},
	{32460, 214536},
	{32480, 214540},
	{32500, 214544},
	{32520, 214548},
	{32540, 214552},
	{32560, 214556},
	{32580, 214560},
	{32600, 214564},
	{32620, 214568},
	{32640, 214572},
	{30988, 214576},
	{30968, 214580},
	{30948, 214584},
	{30928, 214588},
	{50428, 214592},
	{50447, 214596},
	{50466, 214600},
	{50485, 214604},
	{32660, 214784},
	{32698, 214792},
	{32736, 214800},
	{32774, 214808},
	{32812, 214816},
	{32850, 214824},
	{32888, 214832},
	{32926, 214840},
	{50504, 214928},
	{50524, 214932},
	{50544, 214936},
	{50564, 214940},
	{50584, 214944},
	{50604, 214948},
	{50624, 214952},
	{50644, 214956},
	{50664, 214960},
	{50684, 214964},
	{50704, 214968},
	{50724, 214972},
	{50744, 214976},
	{50764, 214980},
	{50784, 214984},
	{50804, 214988},
	{33280, 215296},
	{33299, 215300},
	{33318, 215304},
	{33337, 215308},
	{33356, 215312},
	{33375, 215316},
	{33394, 215320},
	{33413, 215324},
	{33432, 215424},
	{33453, 215428},
	{44114, 215432},
	{44134, 215436, 2, 1870},
	{33474, 215552},
	{33494, 215556},
	{33514, 215560},
	{33534, 215564},
	{33554, 215568},
	{33574, 215572},
	{33594, 215576},
	{33614, 215580},
	{33634, 215808},
	{33653, 215812},
	{33672, 215816},
	{33691, 215820},
	{33710, 216064},
	{33729, 216068},
	{33748, 216072},
	{33767, 216076},
	{33786, 216320},
	{33806, 216324},
	{33826, 216328},
	{33846, 216332},
	{33866, 216336},
	{33886, 216340},
	{33906, 216344},
	{33926, 216348},
	{50824, 216352, 12, 3710},
	{50847, 216356, 1, 3722},
	{50871, 216360, 13, 3723},
	{33946, 216576},
	{33967, 216580},
	{33988, 216584},
	{34009, 216588},
	{34030, 216592},
	{34051, 216596},
	{34072, 216600},
	{34093, 216604},
	{34114, 216640},
	{34135, 216644},
	{34156, 216648},
	{34177, 216652},
	{34198, 216656},
	{34219, 216660},
	{34240, 216664},
	{34261, 216668},
	{34282, 216704},
	{34303, 216708},
	{34324, 216712},
	{34345, 216716},
	{34366, 216720},
	{34387, 216724},
	{34408, 216728},
	{34429, 216732},
	{34450, 216832},
	{34470, 216836},
	{34490, 216840},
	{34510, 216844},
	{34530, 216848},
	{34550, 216852},
	{34570, 216856},
	{34590, 216860},
	{34610, 216864},
	{34631, 216868},
	{34652, 216872},
	{34673, 216876},
	{34694, 216880},
	{34715, 216884},
	{34736, 216888},
	{34757, 216892},
	{34778, 217112},
	{34797, 217116},
	{34816, 217120},
	{34835, 217124},
	{34854, 217128},
	{34873, 217132},
	{34892, 217136},
	{34911, 217140},
	{34930, 217344},
	{34949, 217348},
	{34968, 217352},
	{34987, 217356},
	{35006, 217360},
	{35025, 217364},
	{35044, 217368},
	{35063, 217372},
	{35082, 217600},
	{35102, 217604},
	{35122, 217608},
	{35142, 217612},
	{35162, 217856},
	{35182, 217860},
	{35202, 217864},
	{35222, 217868},
	{35242, 217872},
	{35262, 217876},
	{35282, 217880},
	{35302, 217884},
	{35424, 217984},
	{35449, 217988},
	{35474, 217992},
	{35499, 217996},
	{35372, 218000},
	{35398, 218004, 2, 1870},
	{44154, 218008},
	{44177, 218012, 2, 1870},
	{35664, 218240},
	{35684, 218244},
	{35704, 218248},
	{35724, 218252},
	{35744, 218624},
	{35766, 218628},
	{35788, 218632},
	{35810, 218636},
	{35832, 218640},
	{35854, 218644},
	{35876, 218648},
	{35898, 218652},
	{35920, 218656},
	{35942, 218660},
	{35964, 218664},
	{35986, 218668},
	{36008, 218672},
	{36030, 218676},
	{36052, 218680},
	{36074, 218684},
	{35576, 218752},
	{35598, 218756},
	{35620, 218760},
	{35642, 218764},
	{50897, 218768},
	{50919, 218772},
	{50941, 218776},
	{50963, 218780},
	{36096, 218880},
	{36117, 218884},
	{36138, 218888},
	{36159, 218892},
	{36180, 218896},
	{36201, 218900},
	{36222, 218904},
	{36243, 218908},
	{50985, 218944},
	{51006, 218948},
	{51027, 218952},
	{51048, 218956},
	{51069, 218960},
	{51090, 218964},
	{51111, 218968},
	{51132, 218972},
	{36264, 219136},
	{36284, 219140},
	{36304, 219144},
	{36324, 219148},
	{36344, 219152},
	{36364, 219156},
	{36384, 219160},
	{36404, 219164},
	{36424, 219392},
	{36444, 219396},
	{44200, 219400},
	{44219, 219404, 2, 1870},
	{44238, 219520},
	{44267, 219524, 2, 1870},
	{44296, 219528},
	{44318, 219532},
	{44340, 219536},
	{44362, 219540},
	{44384, 219568},
	{44413, 219572, 2, 1870},
	{44442, 219576},
	{44464, 219580},
	{44486, 219584},
	{44508, 219588},
	{36464, 221184, 3, 3736},
	{36488, 221188, 4, 1877},
	{36513, 221192, 5, 1872},
	{36537, 221196, 3, 3736},
	{36561, 221200, 4, 1877},
	{36586, 221204, 3, 3736},
	{36610, 221208, 4, 1877},
	{36635, 221212, 5, 1872},
	{36659, 221216, 4, 1881},
	{36675, 221220, 5, 1872},
	{36699, 221224, 3, 1885},
	{36733, 221228, 3, 1888},
	{36767, 221232, 3, 1891},
	{36792, 221236, 3, 1894},
	{36817, 221240, 3, 1891},
	{51153, 221244, 3, 1888},
	{36842, 221248},
	{36857, 221252, 1, 1818},
	{36880, 221256},
	{36903, 221260},
	{36921, 221264, 2, 1897},
	{36939, 221268, 4, 1899},
	{36959, 221440, 20, 1903},
	{36984, 221444, 20, 1903},
	{37009, 221448, 18, 3739},
	{37037, 221452, 18, 3739},
	{37065, 221456, 18, 3739},
	{37093, 221460, 18, 3739},
	{51187, 221464, 18, 3739},
	{51215, 221468, 18, 3739},
	{51243, 221472, 18, 3739},
	{37121, 221492, 9, 3757},
	{37149, 221496, 9, 3757},
	{44822, 221840, 5, 3766},
	{44846, 221844, 4, 1962},
	{44871, 221848, 5, 3766},
	{44895, 221852, 4, 1962},
	{44920, 221856, 5, 3766},
	{44944, 221860, 4, 1962},
	{44969, 221864, 5, 3766},
	{44993, 221868, 4, 1962},
	{45018, 221872, 5, 3766},
	{45047, 221876, 4, 1962},
	{45077, 221880, 5, 3766},
	{45106, 221884, 4, 1962},
	{45136, 221888, 5, 3766},
	{45165, 221892, 4, 1962},
	{45195, 221896, 5, 3766},
	{45224, 221900, 4, 1962},
	{45254, 221904, 5, 3766},
	{45281, 221908, 4, 1962},
	{45309, 221912, 5, 3766},
	{45336, 221916, 4, 1962},
	{45364, 221920, 5, 3766},
	{45391, 221924, 4, 1962},
	{45419, 221928, 5, 3766},
	{45446, 221932, 4, 1962},
	{37551, 222208, 5, 1957},
	{37577, 222212, 4, 1962},
	{37604, 222216, 5, 1957},
	{37630, 222220, 4, 1962},
	{37657, 222224, 5, 1957},
	{37683, 222228, 4, 1962},
	{37710, 222232, 5, 1957},
	{37736, 222236, 4, 1962},
	{37763, 222464, 5, 1957},
	{37789, 222468, 4, 1962},
	{37816, 222472, 1, 1872},
	{37842, 222476, 1, 1872},
	{37868, 222480, 1, 1872},
	{37894, 222484, 1, 1872},
	{37920, 222488, 1, 1872},
	{37946, 222492, 1, 1872},
	{37972, 222496, 1, 1872},
	{37998, 222720, 5, 1957},
	{38022, 222724, 5, 1957},
	{38046, 222728, 5, 1957},
	{38070, 222732, 5, 1957},
	{38094, 222736, 4, 1962},
	{38119, 222740, 4, 1962},
	{38144, 222744, 4, 1962},
	{38169, 222748, 4, 1962},
	{38194, 222752, 1, 1872},
	{38218, 222756, 1, 1872},
	{38242, 222760, 8, 1966},
	{36676, 222768, 5, 1957},
	{36538, 222772, 5, 1957},
	{51271, 222776, 5, 1957},
	{51294, 222780, 5, 1957},
	{36562, 222784, 4, 1962},
	{51317, 222788, 4, 1962},
	{51341, 222792, 4, 1962},
	{51365, 222796, 4, 1962},
	{38263, 222976, 3, 2679},
	{38286, 222980, 3, 2679},
	{38309, 222984, 3, 2679},
	{38332, 222988, 3, 2679},
	{38355, 222992, 3, 2679},
	{38378, 222996, 3, 2679},
	{38401, 223000, 3, 2679},
	{38424, 223004, 3, 2679},
	{38447, 223008, 3, 2679},
	{38470, 223012, 3, 2679},
	{38493, 223016, 3, 2679},
	{38517, 223020, 3, 2679},
	{38541, 223024, 3, 2679},
	{38565, 223028, 3, 2679},
	{38589, 223032, 3, 2679},
	{38613, 223036, 3, 2679},
	{51389, 223040, 3, 2679},
	{51413, 223044, 3, 2679},
	{51437, 223048, 3, 2679},
	{51461, 223052, 3, 2679},
	{51485, 223056, 3, 2679},
	{51509, 223060, 3, 2679},
	{51533, 223064, 3, 2679},
	{51557, 223068, 3, 2679},
	{51581, 223072, 10, 3771},
	{51602, 223080, 2, 3781},
	{51624, 223084, 1, 3783},
	{38637, 223104, 10, 3771},
	{38657, 223112, 2, 3781},
	{2141, 223136},
	{2167, 223140, 2, 343},
	{2193, 223144},
	{2219, 223148, 2, 343},
	{2314, 223152, 18, 3784},
	{2266, 223156, 5, 3802},
	{2287, 223160, 7, 3807},
	{2245, 223164, 2, 345},
	{2335, 223184, 5, 3814},
	{43179, 223188, 6, 3819},
	{2387, 223192},
	{2417, 223196},
	{2449, 223200},
	{2480, 223204},
	{2358, 223208},
	{38678, 223232, 5, 1957},
	{38703, 223236, 4, 1962},
	{38729, 223240, 8, 1988},
	{45474, 223244, 5, 2140},
	{45496, 223248, 5, 2140},
	{45518, 223252, 6, 2145},
	{38752, 223488, 5, 1957},
	{38775, 223492, 5, 1957},
	{38798, 223496, 3, 2013},
	{38821, 223500, 3, 2013},
	{38844, 223504, 4, 1962},
	{38868, 223508, 4, 1962},
	{38892, 223744, 5, 1957},
	{38916, 223748, 5, 1957},
	{38940, 223752, 5, 1957},
	{38964, 223756, 5, 1957},
	{38988, 223760, 4, 1962},
	{45545, 223764, 4, 1962},
	{45570, 223768, 4, 1962},
	{45595, 223772, 4, 1962},
	{39013, 224000, 5, 1957},
	{39036, 224004, 4, 1962},
	{39060, 224008, 3, 2013},
	{39083, 224256, 5, 1957},
	{39106, 224260, 4, 1962},
	{39130, 224264, 3, 2013},
	{39153, 224512, 5, 1957},
	{39177, 224516, 4, 1962},
	{39202, 224520, 5, 1957},
	{39226, 224524, 4, 1962},
	{39251, 224528, 3, 2013},
	{39275, 224532, 3, 2013},
	{39299, 224768, 5, 1957},
	{39324, 224772, 4, 1951},
	{39350, 224776, 5, 1957},
	{39375, 224780, 4, 1951},
	{39401, 224784, 3, 2013},
	{39426, 224788, 3, 2013},
	{39451, 224832, 5, 1957},
	{39476, 224836, 4, 1951},
	{39502, 224840, 5, 1957},
	{39527, 224844, 4, 1951},
	{39553, 224848, 3, 2013},
	{39578, 224852, 3, 2013},
	{39603, 224896, 5, 1957},
	{39628, 224900, 4, 1951},
	{39654, 224904, 3, 2013},
	{39679, 224908, 3, 2013},
	{39704, 224912, 3, 2013},
	{39729, 225024, 5, 1957},
	{39753, 225028, 4, 1951},
	{39778, 225032, 3, 2013},
	{39802, 225036, 3, 2013},
	{39826, 225040, 3, 2013},
	{39850, 225048, 5, 1957},
	{39875, 225052, 4, 1951},
	{39901, 225056, 3, 2013},
	{39926, 225060, 3, 2013},
	{39951, 225064, 3, 2013},
	{39976, 225280, 12, 2016},
	{39998, 225284, 5, 1957},
	{40021, 225288, 4, 1962},
	{40045, 225292, 2, 3825},
	{40068, 225296, 2, 3825},
	{40091, 225300, 2, 3825},
	{40114, 225536, 5, 1957},
	{40137, 225540, 4, 1962},
	{40161, 225544, 5, 1957},
	{40184, 225548, 4, 1962},
	{40208, 225552, 5, 1957},
	{40231, 225560, 5, 1957},
	{40254, 225792, 5, 3827},
	{40275, 225796},
	{40304, 225800, 2, 2043},
	{40333, 225804},
	{40790, 225808, 2, 2070},
	{40388, 225812},
	{40407, 225816, 2, 2052},
	{40359, 225820, 3, 3832},
	{40479, 225824, 1, 3835},
	{40506, 225828, 2, 3836},
	{40433, 225832, 1, 3835},
	{40456, 225836, 2, 3836},
	{40809, 225864, 2, 2072},
	{40836, 225868},
	{45810, 225872, 2, 2072},
	{45841, 225876},
	{40863, 225880, 2, 2697},
	{40890, 225884, 2, 2076},
	{45872, 225888, 4, 2746},
	{40917, 225892, 18, 3838},
	{40938, 225896, 9, 2716},
	{40957, 225900, 22, 3856},
	{40976, 225904, 1, 2104},
	{41000, 225908, 1, 2106},
	{41032, 225912, 2, 2108},
	{45943, 225916, 3, 2750},
	{51647, 225928, 2, 3878},
	{51661, 225932, 10, 3880},
	{45680, 225936},
	{45653, 225940},
	{51676, 225972, 1, 3890},
	{51689, 225976},
	{51714, 225980, 1, 3891},
	{51739, 225984, 1, 3892},
	{51759, 225988},
	{51781, 225992, 2, 3893},
	{51801, 225996},
	{51829, 226000, 1, 3891},
	{51857, 226004, 1, 3892},
	{51880, 226008},
	{51905, 226012, 2, 3893},
	{51928, 226016, 1, 3895},
	{51945, 226020, 9, 3896},
	{51966, 226044},
	{41169, 226048, 2, 2119},
	{41186, 226052, 1, 2121},
	{41210, 226056, 1, 2121},
	{41234, 226060, 4, 2122},
	{41260, 226064, 3, 2126},
	{41289, 226068, 1, 687},
	{41318, 226072, 3, 2126},
	{41347, 226076, 1, 687},
	{41424, 226304, 5, 1957},
	{41448, 226308, 4, 1962},
	{41473, 226312, 2, 3825},
	{41497, 226316, 5, 1957},
	{41521, 226320, 4, 1962},
	{41546, 226324, 2, 3825},
	{41570, 226328, 10, 2130},
	{41935, 226432, 5, 1957},
	{41964, 226436, 5, 1957},
	{41993, 226440, 4, 1962},
	{42023, 226444, 4, 1962},
	{42053, 226448, 8, 1988},
	{42080, 226452, 8, 1988},
	{41678, 226496, 5, 2140},
	{41706, 226500, 5, 2140},
	{41734, 226504, 5, 2140},
	{41762, 226508, 5, 2140},
	{41790, 226512, 5, 2140},
	{41818, 226516, 5, 2140},
	{41846, 226520, 5, 2140},
	{41874, 226524, 5, 2140},
	{41902, 226528, 6, 2145},
	{45984, 226532, 5, 2140},
	{46009, 226536, 5, 2140},
	{46034, 226540, 5, 2140},
	{46059, 226544, 5, 2140},
	{46084, 226548, 6, 2145},
	{42196, 226688, 5, 1957},
	{42220, 226692, 4, 1962},
	{42245, 226696, 3, 2013},
	{42321, 226816, 5, 1957},
	{42347, 226820, 4, 1962},
	{42374, 226824, 5, 1957},
	{42400, 226828, 5, 1957},
	{42426, 226832, 5, 1957},
	{42452, 226836, 1, 1872},
	{42478, 226840, 1, 1872},
	{42504, 226844, 1, 1872},
	{42530, 226848, 1, 1872},
	{42556, 226880, 4, 1962},
	{42583, 226884, 4, 1962},
	{42610, 226888, 4, 1962},
	{42269, 226944, 2, 2154},
	{42295, 226948, 2, 2154},
	{51980, 226952, 2, 2154},
	{52006, 226956, 2, 2154},
	{42637, 227072, 5, 1957},
	{42662, 227076, 4, 1951},
	{42688, 227080, 3, 2013},
	{42713, 227084, 3, 2013},
	{42738, 227088, 3, 2013},
	{52032, 227136, 5, 1957},
	{52057, 227140, 4, 1951},
	{52083, 227144, 3, 2013},
	{52108, 227148, 3, 2013},
	{52133, 227152, 3, 2013},
	{42763, 227200, 5, 1957},
	{42787, 227204, 4, 1951},
	{42812, 227208, 3, 2013},
	{42836, 227212, 3, 2013},
	{42860, 227216, 3, 2013},
	{42884, 227328, 5, 1957},
	{42908, 227332, 4, 1962},
	{42933, 227336, 8, 1988},
	{46114, 227340, 5, 2140},
	{46135, 227344, 5, 2140},
	{46156, 227348, 6, 2145},
	{46182, 227456, 5, 2140},
	{46213, 227460, 5, 2140},
	{46244, 227464, 6, 2145},
	{46280, 227468, 1, 2753},
	{46304, 227472, 5, 1957},
	{46330, 227476, 4, 1962},
	{46357, 227480, 5, 1957},
	{46383, 227484, 4, 1962},
	{46410, 227504, 5, 2140},
	{46441, 227508, 5, 2140},
	{46472, 227512, 6, 2145},
	{46508, 227516, 1, 2753},
	{46532, 227520, 5, 1957},
	{46558, 227524, 4, 1962},
	{46585, 227528, 5, 1957},
	{46611, 227532, 4, 1962},
	{206, 880, 4, 2156},
	{42955, 881},
	{26802, 882},
	{42967, 1008},
	{42978, 1009},
	{26990, 1010, 4, 2160},
	{42989, 1040, 1, 2164},
	{43002, 1041, 5, 2165},
	{43015, 1042, 1, 2170},
	{43028, 1043, 1, 1681},
	{26824, 1045, 7, 2171},
	{43041, 1168, 18, 3905},
	{43056, 1280, 6, 2190},
	{43071, 1281},
	{26761, 1282},
	{42955, 1283},
	{26802, 1284},
	{52158, 1408, 4, 3923},
	{52176, 1413, 1, 3927},
	{43083, 1414, 15, 2196},
};

static const struct si_reg gfx6_reg_table[] = {
	{1145, 68, 9, 3928},
	{1158, 72, 24, 3937},
	{1173, 76, 3, 3961},
	{52194, 80, 11, 3964},
	{1210, 84, 4, 3975},
	{1228, 88, 2, 3979},
	{1246, 92, 4, 3981},
	{1261, 96},
	{1275, 100, 1, 3985},
	{1289, 104},
	{52208, 108},
	{52225, 112, 13, 3986},
	{52241, 2480},
	{52256, 2484, 1, 3999},
	{52271, 2488},
	{52286, 2492, 1, 3999},
	{1444, 2496},
	{1458, 2500},
	{1472, 2504},
	{1486, 2508},
	{1500, 2512},
	{1514, 2516},
	{1528, 2520},
	{1542, 2524},
	{1556, 2528},
	{1570, 2532},
	{1584, 2536},
	{1599, 2540},
	{1674, 2544},
	{1685, 2552},
	{1701, 2556},
	{52301, 3660, 21, 4000},
	{52314, 3664, 20, 4021},
	{52326, 3668, 16, 4041},
	{52339, 32768, 1, 4057},
	{52349, 32772, 2, 4058},
	{1789, 32776, 17, 4060},
	{52364, 32780, 2, 4077},
	{1802, 32784, 24, 4079},
	{1814, 32788, 11, 4103},
	{1830, 32792, 11, 4103},
	{52378, 32800, 6, 4114},
	{52394, 32804, 1, 4120},
	{52410, 32808},
	{28480, 32812, 6, 4121},
	{52426, 32816, 2, 4127},
	{52446, 32820, 1, 4129},
	{52468, 32848, 6, 4130},
	{52479, 32852, 22, 4136},
	{52499, 32856, 4, 4158},
	{52515, 32864, 2, 4162},
	{36959, 32880, 19, 4164},
	{36984, 32884, 19, 4164},
	{31156, 32888},
	{31177, 32892},
	{31198, 32896},
	{31219, 32900},
	{37009, 32920, 12, 4183},
	{37037, 32924, 12, 4183},
	{31240, 32936},
	{31264, 32940},
	{31288, 32944},
	{31312, 32948},
	{52529, 33008, 1, 4195},
	{47151, 33012},
	{52541, 33020},
	{52554, 33024},
	{52572, 33028},
	{52590, 33032},
	{52608, 33036},
	{52626, 33040},
	{52644, 33044},
	{52662, 33048},
	{52680, 33052},
	{52698, 33536, 10, 4196},
	{24374, 33792, 2, 4206},
	{24394, 33796, 1, 1628},
	{24414, 33800},
	{24434, 33804},
	{24454, 33808},
	{24475, 33812},
	{24496, 33816, 2, 4208},
	{24518, 33820},
	{24540, 33824},
	{24570, 33828},
	{24600, 33832},
	{24629, 33836},
	{24658, 33840},
	{24688, 33844},
	{24718, 33848},
	{24747, 33852},
	{24776, 33856},
	{24806, 33860},
	{24836, 33864},
	{24865, 33868},
	{24894, 33872},
	{24924, 33876},
	{24954, 33880},
	{24983, 33884},
	{25012, 33888, 2, 4210},
	{25034, 33892},
	{25056, 33896},
	{25079, 33900},
	{25102, 33904},
	{25125, 33908},
	{25148, 33912},
	{25171, 33916},
	{25194, 33920},
	{25218, 33924},
	{25242, 33928},
	{25266, 33932},
	{25290, 33936},
	{25314, 33940},
	{25338, 33944},
	{25362, 33948},
	{25386, 33952},
	{25408, 33956},
	{25430, 33960},
	{25451, 33964},
	{25472, 33968},
	{25496, 33972},
	{25520, 33976},
	{25544, 33980},
	{25568, 33984},
	{25592, 33988},
	{25720, 34044, 1, 1635},
	{25736, 34048},
	{25749, 34052},
	{25762, 34056},
	{25775, 34060},
	{25788, 34064},
	{25801, 34068},
	{25814, 34072},
	{25827, 34076},
	{25954, 34112, 2, 1636},
	{25967, 34116},
	{26138, 34144, 1, 1638},
	{26156, 34148, 3, 4212},
	{26174, 34152},
	{26189, 34156},
	{26213, 34160},
	{26237, 34164},
	{26256, 34168},
	{26275, 34172},
	{26299, 34176},
	{26323, 34180},
	{26347, 34184},
	{26371, 34212, 2, 4215},
	{26389, 34216, 1, 4217},
	{26407, 34220},
	{26425, 34224},
	{26443, 34228, 2, 4218},
	{26461, 34232, 1, 4220},
	{26479, 34236},
	{26497, 34240, 2, 1649},
	{26516, 34244, 5, 4221},
	{26535, 34256},
	{26559, 34260, 2, 1649},
	{26579, 34264, 5, 4221},
	{26653, 34284, 1, 1664},
	{26674, 34288, 23, 4226},
	{26688, 34292},
	{26702, 34296},
	{26716, 34300, 4, 4249},
	{26732, 34304},
	{26751, 34308, 1, 4253},
	{26773, 34312},
	{26792, 34316, 1, 4254},
	{26814, 34320, 9, 4255},
	{26832, 34324},
	{26852, 34328, 1, 4253},
	{26875, 34332},
	{26895, 34336, 1, 4254},
	{26918, 34340, 9, 4255},
	{26937, 34344, 5, 4264},
	{26949, 34348, 2, 1696},
	{26983, 34356, 1, 4269},
	{27001, 34360, 5, 2647},
	{27021, 34364, 1, 1704},
	{27038, 34368},
	{27054, 34372, 1, 1706},
	{27067, 34376, 1, 1707},
	{27081, 34380, 1, 1708},
	{27095, 34384, 1, 1709},
	{27117, 34388, 1, 1710},
	{27137, 34392, 1, 1711},
	{27159, 34396, 1, 1712},
	{52721, 34416, 15, 4270},
	{52738, 34420, 18, 4285},
	{52755, 34424, 31, 4303},
	{52772, 34428, 16, 4334},
	{52785, 34432, 24, 4350},
	{52793, 34436},
	{52811, 34440},
	{52830, 34444, 3, 4374},
	{52849, 34448},
	{52867, 34460, 1, 4377},
	{52888, 34512, 2, 4378},
	{52900, 34516, 1, 4380},
	{52912, 34520, 9, 4381},
	{52923, 34528, 4, 4390},
	{52936, 34532, 1, 4394},
	{52953, 34552, 1, 4395},
	{52965, 34556, 1, 4395},
	{52977, 34560, 1, 4395},
	{52989, 34564, 2, 4396},
	{53006, 34568, 2, 4398},
	{27472, 34572, 1, 1721},
	{27491, 34576, 1, 4400},
	{27510, 34580, 1, 1723},
	{27527, 34584, 1, 1724},
	{27545, 34588, 1, 4401},
	{27563, 34592, 1, 1726},
	{27579, 34596, 1, 1727},
	{27597, 34600, 1, 4402},
	{27615, 34604, 1, 1729},
	{27631, 34608, 1, 1724},
	{27646, 34612, 1, 4401},
	{27661, 34616, 1, 1726},
	{27674, 34620, 1, 1727},
	{27689, 34624, 1, 4402},
	{27704, 34628, 1, 1729},
	{27717, 34632, 1, 1730},
	{27731, 34636, 1, 4403},
	{27745, 34640, 1, 1732},
	{53027, 34644, 4, 4404},
	{53046, 34648, 4, 4408},
	{53065, 34652, 3, 4412},
	{53083, 34656, 2, 4415},
	{53103, 34660, 2, 4417},
	{53121, 34664, 2, 4419},
	{53134, 34668, 1, 4421},
	{53147, 34672, 1, 4422},
	{53161, 34676, 1, 4423},
	{53174, 34680, 3, 4424},
	{53187, 34684},
	{53199, 34688, 2, 4427},
	{53214, 34692, 2, 4429},
	{53230, 34696, 2, 4431},
	{53246, 34700, 1, 4433},
	{53258, 34708, 2, 4434},
	{53270, 34712, 2, 4436},
	{53284, 34716, 1, 4438},
	{53298, 34720, 2, 4439},
	{53316, 34724, 2, 4441},
	{53335, 34728, 2, 4443},
	{53354, 34780, 12, 4445},
	{36659, 34812, 4, 1881},
	{53372, 34944, 5, 4457},
	{53395, 34948, 2, 4462},
	{53418, 34952, 2, 4462},
	{53441, 34956, 2, 4462},
	{53464, 34960},
	{53483, 34964},
	{53502, 34968},
	{53521, 34972},
	{53540, 34976},
	{53559, 34980},
	{53578, 34984},
	{53597, 34988},
	{53616, 34992, 1, 4464},
	{53639, 34996, 1, 4465},
	{53663, 35000, 1, 4466},
	{53686, 35004, 1, 4467},
	{53711, 35008, 2, 4468},
	{53731, 35012, 8, 4470},
	{28495, 35016},
	{28514, 35020},
	{53754, 35024, 4, 4478},
	{53770, 35028, 1, 4482},
	{53790, 35032, 1, 4483},
	{53806, 35036, 5, 4484},
	{53821, 35040, 2, 4489},
	{53836, 35044},
	{53851, 35048, 2, 4491},
	{53865, 35052},
	{53879, 35056, 10, 4493},
	{53895, 35100, 1, 4503},
	{53921, 35104, 5, 4457},
	{53945, 35108, 5, 4457},
	{53969, 35112, 2, 4462},
	{53993, 35116, 2, 4462},
	{54017, 35120},
	{54037, 35124},
	{54057, 35128},
	{54077, 35132},
	{54097, 35136},
	{54117, 35140},
	{54137, 35144},
	{54157, 35148},
	{28533, 35160, 1, 4504},
	{28552, 35164, 1, 4505},
	{28567, 35168},
	{28600, 35172},
	{28633, 35176},
	{28666, 35180},
	{28756, 35184},
	{28772, 35188},
	{54177, 35196, 10, 4506},
	{54195, 35200, 2, 4516},
	{54212, 35204, 10, 4518},
	{28790, 35208, 1, 1785},
	{54229, 35212, 3, 4528},
	{28807, 35248, 2, 4531},
	{28828, 35256},
	{54244, 35260, 4, 4533},
	{54270, 35264, 4, 4533},
	{54298, 35328, 1, 4537},
	{54315, 35332},
	{54332, 35344, 1, 4538},
	{54350, 35348, 9, 4539},
	{54364, 35352, 10, 4548},
	{37551, 35360, 3, 4457},
	{37604, 35364, 3, 4457},
	{37657, 35368, 2, 2010},
	{37710, 35372, 2, 2010},
	{31892, 35376},
	{31914, 35380, 1, 1869},
	{31936, 35384},
	{31958, 35388, 1, 1869},
	{31980, 35392},
	{32002, 35396, 1, 1869},
	{32024, 35400},
	{32046, 35404, 1, 1869},
	{54381, 35408, 1, 4558},
	{54399, 35412, 1, 4559},
	{29160, 35424, 1, 1809},
	{37763, 35456, 3, 4560},
	{37816, 35460, 1, 1974},
	{37842, 35464, 1, 1974},
	{37868, 35468, 1, 1974},
	{37894, 35472, 1, 1974},
	{37920, 35476, 1, 1974},
	{37946, 35480, 1, 1974},
	{37972, 35484, 1, 1974},
	{32068, 35488},
	{32090, 35492},
	{32112, 35496},
	{32134, 35500},
	{32156, 35504},
	{32178, 35508},
	{32200, 35512},
	{32222, 35516},
	{32244, 35520},
	{32266, 35524},
	{32288, 35528},
	{32310, 35532},
	{32332, 35536},
	{32354, 35540},
	{32376, 35544},
	{32398, 35548},
	{29185, 35600, 2, 1810},
	{54421, 35620, 2, 4563},
	{54446, 35624, 10, 4565},
	{54463, 35788, 4, 4575},
	{54479, 35796, 4, 4579},
	{54498, 35800, 1, 4583},
	{54515, 35804},
	{54532, 35824, 26, 4584},
	{54546, 35840, 9, 4610},
	{54556, 35844, 9, 4619},
	{29926, 35848, 3, 4628},
	{54567, 35852, 3, 4631},
	{54586, 35856, 6, 4634},
	{54601, 35860, 4, 4640},
	{38637, 35864, 9, 4644},
	{54615, 35868, 4, 4653},
	{54635, 35872, 4, 4653},
	{54657, 35876, 4, 4657},
	{32660, 35968},
	{32679, 35972},
	{32698, 35976},
	{32717, 35980},
	{32736, 35984},
	{32755, 35988},
	{32774, 35992},
	{32793, 35996},
	{32812, 36000},
	{32831, 36004},
	{32850, 36008},
	{32869, 36012},
	{32888, 36016},
	{32907, 36020},
	{32926, 36024},
	{32945, 36028},
	{32964, 36032},
	{32983, 36036},
	{33002, 36040},
	{33021, 36044},
	{33040, 36048},
	{33060, 36052},
	{33080, 36056},
	{33100, 36060},
	{33120, 36064},
	{33140, 36068},
	{33160, 36072},
	{33180, 36076},
	{33200, 36080},
	{33220, 36084},
	{33240, 36088},
	{33260, 36092},
	{38263, 36096, 6, 4661},
	{38286, 36100, 6, 4661},
	{38309, 36104, 6, 4661},
	{38332, 36108, 6, 4661},
	{38355, 36112, 6, 4661},
	{38378, 36116, 6, 4661},
	{38401, 36120, 6, 4661},
	{38424, 36124, 6, 4661},
	{38447, 36128, 6, 4661},
	{38470, 36132, 6, 4661},
	{38493, 36136, 6, 4661},
	{38517, 36140, 6, 4661},
	{38541, 36144, 6, 4661},
	{38565, 36148, 6, 4661},
	{38589, 36152, 6, 4661},
	{38613, 36156, 6, 4661},
	{54677, 36224, 2, 4667},
	{54693, 36228, 2, 4667},
	{54709, 36232, 4, 4669},
	{54726, 36236, 4, 4669},
	{54744, 36320, 8, 4673},
	{54757, 36324},
	{54769, 36336},
	{54780, 36340},
	{54791, 36352},
	{54812, 36356, 1, 4681},
	{2266, 36360, 8, 4682},
	{2287, 36364, 3, 4690},
	{54833, 36368, 2, 4693},
	{29710, 36384},
	{29737, 36388},
	{29764, 36392},
	{29791, 36396},
	{2245, 36400, 2, 4695},
	{2335, 36404, 5, 4697},
	{54859, 36408, 15, 4702},
	{2314, 36412, 1, 4717},
	{54880, 36416},
	{54901, 36424, 1, 4718},
	{54925, 36440, 3, 4719},
	{54943, 36444, 4, 4722},
	{54962, 36448, 3, 4726},
	{54977, 36452},
	{54999, 36456},
	{55021, 36460},
	{55043, 36464},
	{55065, 36480, 4, 4729},
	{55080, 36484, 3, 4733},
	{55091, 36488, 3, 4736},
	{55102, 36492, 4, 4739},
	{2522, 36608},
	{2540, 36612, 4, 383},
	{2558, 36616},
	{2576, 36620, 14, 4743},
	{3477, 36624},
	{3495, 36628, 5, 4757},
	{3513, 36632, 4, 4762},
	{3531, 36636, 11, 4766},
	{3549, 36640, 2, 4777},
	{3567, 36644, 2, 4779},
	{3585, 36648, 4, 4781},
	{3603, 36652},
	{2594, 36656, 13, 4785},
	{2612, 36660, 4, 411},
	{2630, 36664, 9, 4798},
	{2648, 36668, 3, 4807},
	{2666, 37120, 6, 429},
	{29951, 38156},
	{2682, 39160, 9, 4810},
	{2697, 39184, 6, 4819},
	{2711, 39188, 5, 4820},
	{2725, 39192, 5, 4820},
	{2739, 39196, 5, 4820},
	{2753, 39200, 5, 4820},
	{2767, 39204, 5, 4820},
	{2781, 39208, 5, 4820},
	{2795, 39212, 5, 4820},
	{2809, 39216, 5, 4820},
	{2823, 39220, 5, 4820},
	{2837, 39224, 5, 4820},
	{2852, 39228, 5, 4820},
	{2867, 39232, 5, 4820},
	{2882, 39236, 5, 4820},
	{2897, 39240, 5, 4820},
	{2912, 39244, 5, 4820},
	{2927, 39248, 5, 4820},
	{2942, 39252, 5, 4820},
	{2957, 39256, 5, 4820},
	{2972, 39260, 5, 4820},
	{2987, 39264, 5, 4820},
	{3002, 39268, 5, 4820},
	{3017, 39272, 5, 4820},
	{3032, 39276, 5, 4820},
	{3047, 39280, 5, 4820},
	{3062, 39284, 5, 4820},
	{3077, 39288, 5, 4820},
	{3092, 39292, 5, 4820},
	{3107, 39296, 5, 4820},
	{3122, 39300, 5, 4820},
	{3137, 39304, 5, 4820},
	{3152, 39308, 5, 4820},
	{55114, 45056},
	{55135, 45060, 1, 491},
	{55156, 45064},
	{55177, 45068, 1, 491},
	{3694, 45088},
	{3715, 45092, 1, 491},
	{3736, 45096, 11, 4825},
	{3760, 45100, 6, 4836},
	{3784, 45104},
	{3810, 45108},
	{3836, 45112},
	{3862, 45116},
	{3888, 45120},
	{3914, 45124},
	{3940, 45128},
	{3966, 45132},
	{3992, 45136},
	{4018, 45140},
	{4044, 45144},
	{4071, 45148},
	{4098, 45152},
	{4125, 45156},
	{4152, 45160},
	{4179, 45164},
	{55198, 45312},
	{55219, 45316, 1, 491},
	{55240, 45320},
	{55261, 45324, 1, 491},
	{4900, 45344},
	{4921, 45348, 1, 491},
	{4942, 45352, 12, 4842},
	{4966, 45356, 10, 4854},
	{4990, 45360},
	{5016, 45364},
	{5042, 45368},
	{5068, 45372},
	{5094, 45376},
	{5120, 45380},
	{5146, 45384},
	{5172, 45388},
	{5198, 45392},
	{5224, 45396},
	{5250, 45400},
	{5277, 45404},
	{5304, 45408},
	{5331, 45412},
	{5358, 45416},
	{5385, 45420},
	{55282, 45568},
	{55303, 45572, 1, 491},
	{55324, 45576},
	{55345, 45580, 1, 491},
	{6274, 45600},
	{6295, 45604, 1, 491},
	{6316, 45608, 11, 4864},
	{6340, 45612, 4, 4875},
	{6364, 45616},
	{6390, 45620},
	{6416, 45624},
	{6442, 45628},
	{6468, 45632},
	{6494, 45636},
	{6520, 45640},
	{6546, 45644},
	{6572, 45648},
	{6598, 45652},
	{6624, 45656},
	{6651, 45660},
	{6678, 45664},
	{6705, 45668},
	{6732, 45672},
	{6759, 45676},
	{55366, 45824},
	{55387, 45828, 1, 491},
	{55408, 45832},
	{55429, 45836, 1, 491},
	{7445, 45856},
	{7466, 45860, 1, 491},
	{7487, 45864, 12, 4842},
	{7511, 45868, 6, 4879},
	{7535, 45872},
	{7561, 45876},
	{7587, 45880},
	{7613, 45884},
	{7639, 45888},
	{7665, 45892},
	{7691, 45896},
	{7717, 45900},
	{7743, 45904},
	{7769, 45908},
	{7795, 45912},
	{7822, 45916},
	{7849, 45920},
	{7876, 45924},
	{7903, 45928},
	{7930, 45932},
	{55450, 46080},
	{55471, 46084, 1, 491},
	{55492, 46088},
	{55513, 46092, 1, 491},
	{8169, 46112},
	{8190, 46116, 1, 491},
	{8211, 46120, 10, 4885},
	{8235, 46124, 6, 4895},
	{8259, 46128},
	{8285, 46132},
	{8311, 46136},
	{8337, 46140},
	{8363, 46144},
	{8389, 46148},
	{8415, 46152},
	{8441, 46156},
	{8467, 46160},
	{8493, 46164},
	{8519, 46168},
	{8546, 46172},
	{8573, 46176},
	{8600, 46180},
	{8627, 46184},
	{8654, 46188},
	{55534, 46336},
	{55555, 46340, 1, 491},
	{55576, 46344},
	{55597, 46348, 1, 491},
	{9340, 46368},
	{9361, 46372, 1, 491},
	{9382, 46376, 11, 4901},
	{9406, 46380, 5, 4912},
	{9430, 46384},
	{9456, 46388},
	{9482, 46392},
	{9508, 46396},
	{9534, 46400},
	{9560, 46404},
	{9586, 46408},
	{9612, 46412},
	{9638, 46416},
	{9664, 46420},
	{9690, 46424},
	{9717, 46428},
	{9744, 46432},
	{9771, 46436},
	{9798, 46440},
	{9825, 46444},
	{9852, 47104, 12, 4917},
	{9879, 47108},
	{9893, 47112},
	{9907, 47116},
	{9921, 47120},
	{9937, 47124},
	{9953, 47128},
	{9969, 47132, 2, 659},
	{9990, 47136, 2, 659},
	{10011, 47140, 2, 659},
	{55618, 47148, 1, 4929},
	{10085, 47152},
	{10100, 47156, 2, 4930},
	{55638, 47160},
	{55653, 47164, 1, 663},
	{55668, 47168},
	{55683, 47172, 1, 663},
	{10239, 47176, 10, 4932},
	{10257, 47180, 11, 676},
	{10275, 47184, 1, 687},
	{10288, 47188, 7, 4942},
	{55698, 47192, 2, 4949},
	{55729, 47196, 2, 4949},
	{10366, 47200, 2, 694},
	{10841, 47360},
	{10861, 47364},
	{10881, 47368},
	{10901, 47372},
	{10921, 47376},
	{10941, 47380},
	{10961, 47384},
	{10981, 47388},
	{11001, 47392},
	{11021, 47396},
	{11041, 47400},
	{11062, 47404},
	{11083, 47408},
	{11104, 47412},
	{11125, 47416},
	{11146, 47420},
	{55760, 53300, 29, 4951},
	{55777, 55348, 29, 4951},
	{11228, 163840, 9, 719},
	{11246, 163844, 9, 4980},
	{11263, 163848, 4, 4989},
	{11277, 163852, 23, 747},
	{11296, 163856, 15, 770},
	{11316, 163860},
	{11352, 163872},
	{11372, 163876},
	{11392, 163880, 1, 788},
	{11409, 163884},
	{11424, 163888, 2, 789},
	{11448, 163892, 2, 791},
	{55794, 163900, 7, 4993},
	{11506, 163904, 8, 5000},
	{11516, 163908, 5, 5008},
	{11532, 163912},
	{11547, 163916},
	{11568, 163920},
	{11584, 163924},
	{55808, 163928, 2, 5013},
	{55822, 163932, 1, 5015},
	{11774, 163968},
	{11893, 164344},
	{11911, 164348},
	{11929, 164352, 2, 842},
	{11949, 164356, 3, 844},
	{11973, 164360, 2, 847},
	{11997, 164364, 1, 849},
	{12017, 164368, 2, 844},
	{12037, 164372, 2, 847},
	{12057, 164376, 2, 844},
	{12077, 164380, 2, 847},
	{12097, 164384, 2, 844},
	{12117, 164388, 2, 847},
	{12137, 164392, 2, 844},
	{12157, 164396, 2, 847},
	{12177, 164400, 7, 850},
	{12192, 164404, 2, 857},
	{12221, 164408, 8, 859},
	{12236, 164412, 8, 867},
	{12251, 164416, 3, 844},
	{12276, 164420, 2, 847},
	{12301, 164424},
	{12319, 164428},
	{12337, 164432, 3, 844},
	{12362, 164436, 2, 847},
	{12387, 164440, 3, 844},
	{12412, 164444, 2, 847},
	{12437, 164448, 3, 844},
	{12462, 164452, 2, 847},
	{12487, 164456, 3, 844},
	{12512, 164460, 2, 847},
	{12537, 164464, 3, 844},
	{12562, 164468, 2, 847},
	{12587, 164472, 3, 844},
	{12612, 164476, 2, 847},
	{12637, 164480, 3, 844},
	{12662, 164484, 2, 847},
	{12687, 164488, 3, 844},
	{12712, 164492, 2, 847},
	{12737, 164496, 3, 844},
	{12762, 164500, 2, 847},
	{12787, 164504, 3, 844},
	{12812, 164508, 2, 847},
	{12837, 164512, 3, 844},
	{12863, 164516, 2, 847},
	{12889, 164520, 3, 844},
	{12915, 164524, 2, 847},
	{12941, 164528, 3, 844},
	{12967, 164532, 2, 847},
	{12993, 164536, 3, 844},
	{13019, 164540, 2, 847},
	{13045, 164544, 3, 844},
	{13071, 164548, 2, 847},
	{13097, 164552, 3, 844},
	{13123, 164556, 2, 847},
	{13149, 164560},
	{13168, 164564},
	{13187, 164568},
	{13206, 164572},
	{13225, 164576},
	{13244, 164580},
	{13263, 164584},
	{13282, 164588},
	{13301, 164592},
	{13320, 164596},
	{13339, 164600},
	{13358, 164604},
	{13377, 164608},
	{13396, 164612},
	{13415, 164616},
	{13434, 164620},
	{13453, 164624},
	{13472, 164628},
	{13491, 164632},
	{13510, 164636},
	{13529, 164640},
	{13549, 164644},
	{13569, 164648},
	{13589, 164652},
	{13609, 164656},
	{13629, 164660},
	{13649, 164664},
	{13669, 164668},
	{13689, 164672},
	{13709, 164676},
	{13729, 164680},
	{13749, 164684},
	{13769, 164688, 15, 875},
	{13868, 164704, 1, 902},
	{55837, 164708, 1, 5016},
	{13899, 164712, 1, 904},
	{13967, 164864},
	{13984, 164868},
	{14001, 164872},
	{14017, 164876},
	{14071, 164884},
	{14084, 164888},
	{14099, 164892},
	{14113, 164896},
	{14167, 164908, 6, 935},
	{14186, 164912, 4, 941},
	{14204, 164916, 4, 945},
	{14225, 164924},
	{14244, 164928},
	{14264, 164932},
	{14283, 164936},
	{14303, 164940},
	{14322, 164944},
	{14342, 164948},
	{14363, 164952},
	{14385, 164956},
	{14406, 164960},
	{14428, 164964},
	{14449, 164968},
	{14471, 164972},
	{14492, 164976},
	{14514, 164980},
	{14535, 164984},
	{14557, 164988},
	{14578, 164992},
	{14600, 164996},
	{14621, 165000},
	{14643, 165004},
	{14664, 165008},
	{14686, 165012},
	{14707, 165016},
	{14729, 165020},
	{14750, 165024},
	{14772, 165028},
	{14793, 165032},
	{14815, 165036},
	{14836, 165040},
	{14858, 165044},
	{14879, 165048},
	{14901, 165052},
	{14922, 165056},
	{14944, 165060},
	{14965, 165064},
	{14987, 165068},
	{15008, 165072},
	{15030, 165076},
	{15051, 165080},
	{15073, 165084},
	{15094, 165088},
	{15116, 165092},
	{15137, 165096},
	{15159, 165100},
	{15180, 165104},
	{15202, 165108},
	{15223, 165112},
	{15245, 165116},
	{15266, 165120},
	{15288, 165124},
	{15309, 165128},
	{15331, 165132},
	{15352, 165136},
	{15374, 165140},
	{15395, 165144},
	{15417, 165148},
	{15438, 165152},
	{15460, 165156},
	{15481, 165160},
	{15503, 165164},
	{15525, 165168},
	{15548, 165172},
	{15570, 165176},
	{15593, 165180},
	{15615, 165184},
	{15638, 165188},
	{15660, 165192},
	{15683, 165196},
	{15705, 165200},
	{15728, 165204},
	{15750, 165208},
	{15773, 165212},
	{15795, 165216},
	{15818, 165220},
	{15840, 165224},
	{15863, 165228},
	{15885, 165232},
	{15908, 165236},
	{15930, 165240},
	{15953, 165244},
	{15975, 165248},
	{15998, 165252},
	{16020, 165256},
	{16043, 165260},
	{16065, 165264},
	{16088, 165268},
	{16110, 165272},
	{16133, 165276},
	{16155, 165280},
	{16178, 165284},
	{16200, 165288},
	{16223, 165292},
	{16245, 165296},
	{16268, 165300},
	{16290, 165304},
	{16313, 165308},
	{16327, 165312},
	{16341, 165316},
	{16355, 165320},
	{16369, 165324},
	{16383, 165328},
	{16397, 165332},
	{16411, 165336},
	{16425, 165340},
	{16439, 165344},
	{16453, 165348},
	{16467, 165352},
	{16481, 165356},
	{16495, 165360},
	{16509, 165364},
	{16523, 165368},
	{16537, 165372},
	{16551, 165376},
	{16565, 165380},
	{16579, 165384},
	{16593, 165388},
	{16607, 165392},
	{16621, 165396},
	{16635, 165400},
	{16672, 165444, 6, 949},
	{16692, 165448, 6, 949},
	{16712, 165452, 6, 949},
	{16732, 165456, 6, 949},
	{16752, 165460, 6, 949},
	{16772, 165464, 6, 949},
	{16792, 165468, 6, 949},
	{16812, 165472, 6, 949},
	{16832, 165476, 6, 949},
	{16852, 165480, 6, 949},
	{16872, 165484, 6, 949},
	{16893, 165488, 6, 949},
	{16914, 165492, 6, 949},
	{16935, 165496, 6, 949},
	{16956, 165500, 6, 949},
	{16977, 165504, 6, 949},
	{16998, 165508, 6, 949},
	{17019, 165512, 6, 949},
	{17040, 165516, 6, 949},
	{17061, 165520, 6, 949},
	{17082, 165524, 4, 961},
	{17103, 165528, 4, 961},
	{17124, 165532, 4, 961},
	{17145, 165536, 4, 961},
	{17166, 165540, 4, 961},
	{17187, 165544, 4, 961},
	{17208, 165548, 4, 961},
	{17229, 165552, 4, 961},
	{17250, 165556, 4, 961},
	{17271, 165560, 4, 961},
	{17292, 165564, 4, 961},
	{17313, 165568, 4, 961},
	{17334, 165572, 2, 970},
	{17352, 165580, 16, 973},
	{17369, 165584, 16, 973},
	{17387, 165588, 7, 989},
	{17408, 165592, 3, 5017},
	{17426, 165600, 7, 1002},
	{17441, 165608, 2, 694},
	{17480, 165644, 4, 1010},
	{17502, 165648, 1, 1015},
	{17522, 165652, 8, 1016},
	{17748, 165760, 9, 1063},
	{17766, 165764, 9, 1063},
	{17784, 165768, 9, 1063},
	{17802, 165772, 9, 1063},
	{17820, 165776, 9, 1063},
	{17838, 165780, 9, 1063},
	{17856, 165784, 9, 1063},
	{17874, 165788, 9, 1063},
	{17892, 165836, 1, 1072},
	{17906, 165840, 1, 1072},
	{17921, 165844},
	{17939, 165848},
	{17957, 165852},
	{17974, 165856},
	{17995, 165860, 1, 5020},
	{18011, 165864},
	{18024, 165872, 5, 1074},
	{18043, 165876},
	{18058, 165880, 1, 1082},
	{18107, 165888, 10, 1084},
	{18124, 165892, 12, 1094},
	{18132, 165896, 3, 5021},
	{18149, 165900, 12, 1110},
	{18167, 165904, 19, 1127},
	{18183, 165908, 13, 1147},
	{18202, 165912, 10, 1163},
	{18217, 165916, 26, 1173},
	{18235, 165920, 16, 1201},
	{18253, 165924, 4, 1217},
	{18277, 165928},
	{18302, 165932, 11, 1221},
	{18454, 166400, 2, 1253},
	{18471, 166404, 2, 1255},
	{18490, 166408, 1, 1257},
	{18506, 166412, 4, 1258},
	{18525, 166416, 1, 1262},
	{18546, 166420, 1, 1263},
	{18559, 166424},
	{18582, 166428},
	{18605, 166432, 1, 1264},
	{18625, 166436, 4, 5024},
	{18645, 166440, 1, 1269},
	{18666, 166444, 1, 1270},
	{18681, 166448, 6, 1271},
	{18703, 166452, 6, 1271},
	{18725, 166456, 8, 1277},
	{18751, 166460, 8, 1277},
	{18777, 166464, 15, 1285},
	{18808, 166472, 4, 1303},
	{18826, 166476, 24, 1310},
	{18844, 166480},
	{18856, 166484, 1, 1334},
	{18870, 166488, 1, 1335},
	{18884, 166492, 1, 1336},
	{18898, 166496, 1, 1337},
	{18921, 166500, 1, 1337},
	{18944, 166504, 1, 1337},
	{18967, 166508, 5, 5028},
	{18988, 166512},
	{18999, 166516},
	{19012, 166520},
	{19029, 166524, 7, 5033},
	{19059, 166532, 2, 1351},
	{19078, 166536},
	{19100, 166540},
	{19122, 166544, 3, 5040},
	{19142, 166548, 1, 1357},
	{19191, 166560},
	{19216, 166564},
	{19241, 166568, 6, 1364},
	{19260, 166572, 1, 1370},
	{19283, 166576, 1, 1370},
	{19306, 166580, 1, 1371},
	{19320, 166584, 1, 1372},
	{19335, 166588, 7, 5043},
	{19352, 166592, 4, 1382},
	{19379, 166596, 4, 1386},
	{19406, 166600, 4, 1390},
	{19425, 166608},
	{19451, 166612, 1, 1394},
	{19476, 166620},
	{19504, 166624},
	{19530, 166628, 1, 1394},
	{19555, 166636},
	{19583, 166640},
	{19609, 166644, 1, 1394},
	{19634, 166652},
	{19662, 166656},
	{19688, 166660, 1, 1394},
	{19713, 166668},
	{19741, 166696},
	{19772, 166700},
	{19815, 166704, 1, 1395},
	{19853, 166712, 1, 1396},
	{19914, 166740, 6, 1404},
	{19935, 166744, 3, 1423},
	{19952, 166748, 1, 1370},
	{19973, 166752, 1, 1370},
	{19996, 166756, 1, 1370},
	{20019, 166760, 1, 1370},
	{20042, 166764, 8, 5050},
	{20055, 166768, 6, 1438},
	{20096, 166776, 2, 1444},
	{20126, 166780},
	{20150, 166784},
	{20180, 166788},
	{20211, 166792},
	{20240, 166796},
	{20270, 166800, 2, 1446},
	{20290, 166804, 7, 5058},
	{20309, 166808, 4, 1457},
	{20359, 166868, 8, 1461},
	{20385, 166872, 8, 1469},
	{20411, 166876, 4, 1477},
	{20427, 166880, 5, 1482},
	{20443, 166884, 3, 1488},
	{20458, 166888},
	{20481, 166892},
	{20504, 166896},
	{20527, 166900},
	{20550, 166904, 8, 1491},
	{20584, 166908, 8, 1499},
	{20618, 166912, 8, 1507},
	{20652, 166916, 8, 1515},
	{20686, 166920, 8, 1491},
	{20720, 166924, 8, 1499},
	{20754, 166928, 8, 1507},
	{20788, 166932, 8, 1515},
	{20822, 166936, 8, 1491},
	{20856, 166940, 8, 1499},
	{20890, 166944, 8, 1507},
	{20924, 166948, 8, 1515},
	{20958, 166952, 8, 1491},
	{20992, 166956, 8, 1499},
	{21026, 166960, 8, 1507},
	{21060, 166964, 8, 1515},
	{21094, 166968, 2, 1523},
	{21118, 166972, 2, 1525},
	{21261, 167000, 1, 1567},
	{21289, 167004, 1, 1568},
	{21310, 167008},
	{21325, 167012, 2, 1569},
	{21341, 167016, 1, 1571},
	{21357, 167020, 2, 4989},
	{21372, 167024, 15, 5065},
	{21387, 167028, 6, 1594},
	{21426, 167036},
	{21442, 167040, 1, 1614},
	{21464, 167044},
	{21480, 167048, 1, 1571},
	{21502, 167052},
	{21524, 167056},
	{21565, 167068},
	{21580, 167072, 2, 1569},
	{21596, 167076, 1, 1571},
	{21612, 167080, 2, 4989},
	{21627, 167084, 15, 5065},
	{21642, 167088, 6, 1594},
	{21681, 167096},
	{21697, 167100, 1, 1614},
	{21719, 167104},
	{21735, 167108, 1, 1571},
	{21757, 167112},
	{21779, 167116},
	{21820, 167128},
	{21835, 167132, 2, 1569},
	{21851, 167136, 1, 1571},
	{21867, 167140, 2, 4989},
	{21882, 167144, 15, 5065},
	{21897, 167148, 6, 1594},
	{21936, 167156},
	{21952, 167160, 1, 1614},
	{21974, 167164},
	{21990, 167168, 1, 1571},
	{22012, 167172},
	{22034, 167176},
	{22075, 167188},
	{22090, 167192, 2, 1569},
	{22106, 167196, 1, 1571},
	{22122, 167200, 2, 4989},
	{22137, 167204, 15, 5065},
	{22152, 167208, 6, 1594},
	{22191, 167216},
	{22207, 167220, 1, 1614},
	{22229, 167224},
	{22245, 167228, 1, 1571},
	{22267, 167232},
	{22289, 167236},
	{22330, 167248},
	{22345, 167252, 2, 1569},
	{22361, 167256, 1, 1571},
	{22377, 167260, 2, 4989},
	{22392, 167264, 15, 5065},
	{22407, 167268, 6, 1594},
	{22446, 167276},
	{22462, 167280, 1, 1614},
	{22484, 167284},
	{22500, 167288, 1, 1571},
	{22522, 167292},
	{22544, 167296},
	{22585, 167308},
	{22600, 167312, 2, 1569},
	{22616, 167316, 1, 1571},
	{22632, 167320, 2, 4989},
	{22647, 167324, 15, 5065},
	{22662, 167328, 6, 1594},
	{22701, 167336},
	{22717, 167340, 1, 1614},
	{22739, 167344},
	{22755, 167348, 1, 1571},
	{22777, 167352},
	{22799, 167356},
	{22840, 167368},
	{22855, 167372, 2, 1569},
	{22871, 167376, 1, 1571},
	{22887, 167380, 2, 4989},
	{22902, 167384, 15, 5065},
	{22917, 167388, 6, 1594},
	{22956, 167396},
	{22972, 167400, 1, 1614},
	{22994, 167404},
	{23010, 167408, 1, 1571},
	{23032, 167412},
	{23054, 167416},
	{23095, 167428},
	{23110, 167432, 2, 1569},
	{23126, 167436, 1, 1571},
	{23142, 167440, 2, 4989},
	{23157, 167444, 15, 5065},
	{23172, 167448, 6, 1594},
	{23211, 167456},
	{23227, 167460, 1, 1614},
	{23249, 167464},
	{23265, 167468, 1, 1571},
	{23287, 167472},
	{23309, 167476},
	{206, 880, 4, 5080},
	{42955, 881},
	{26802, 882},
	{42967, 1008},
	{42978, 1009},
	{26990, 1010, 4, 2160},
	{42989, 1040, 1, 2164},
	{43002, 1041, 5, 5084},
	{43015, 1042, 1, 2170},
	{43028, 1043, 1, 1681},
	{26824, 1045, 9, 5089},
	{43056, 1280, 4, 5098},
	{43071, 1281},
	{26761, 1282},
	{42955, 1283},
	{26802, 1284},
};

static const struct si_reg gfx7_reg_table[] = {
	{1145, 68, 9, 5102},
	{1158, 72, 24, 3937},
	{1173, 76, 3, 5111},
	{52194, 80, 11, 5114},
	{1210, 84, 4, 3975},
	{1228, 88, 2, 3979},
	{1246, 92, 4, 5125},
	{1261, 96},
	{1275, 100, 1, 3985},
	{1289, 104},
	{52208, 108},
	{52225, 112, 13, 3986},
	{52241, 2480},
	{52256, 2484, 1, 3999},
	{52271, 2488},
	{52286, 2492, 1, 3999},
	{1444, 2496},
	{1458, 2500},
	{1472, 2504},
	{1486, 2508},
	{1500, 2512},
	{1514, 2516},
	{1528, 2520},
	{1542, 2524},
	{1556, 2528},
	{1570, 2532},
	{1584, 2536},
	{1599, 2540},
	{1674, 2544},
	{1685, 2552},
	{1701, 2556},
	{52301, 3660, 21, 4000},
	{52314, 3664, 20, 4021},
	{52326, 3668, 16, 4041},
	{1789, 32776, 17, 5129},
	{1802, 32784, 24, 4079},
	{1814, 32788, 11, 4103},
	{1830, 32792, 11, 4103},
	{1859, 32824, 11, 4103},
	{1875, 32828, 11, 4103},
	{1891, 33296, 16, 5146},
	{1905, 33300, 28, 204},
	{1922, 33304, 17, 5162},
	{1943, 33308, 18, 5179},
	{1957, 33312, 31, 5197},
	{1974, 33316, 7, 5228},
	{55847, 33320, 1, 4377},
	{2013, 33324, 1, 329},
	{2036, 33344, 1, 1704},
	{2057, 33348},
	{2118, 33436, 1, 342},
	{54791, 36352},
	{54812, 36356, 1, 4681},
	{2266, 36360, 9, 5235},
	{2287, 36364, 3, 4690},
	{54833, 36368, 2, 4693},
	{55862, 36372, 2, 5244},
	{55884, 36376, 1, 5246},
	{2245, 36400, 2, 4695},
	{2335, 36404, 5, 5247},
	{54859, 36408, 15, 4702},
	{2314, 36412, 1, 4717},
	{54880, 36416},
	{54901, 36424, 1, 4718},
	{2522, 36608},
	{2540, 36612, 4, 383},
	{2558, 36616},
	{2576, 36620, 14, 4743},
	{3477, 36624},
	{3495, 36628, 5, 4757},
	{3513, 36632, 4, 4762},
	{3531, 36636, 11, 4766},
	{3549, 36640, 2, 4777},
	{3567, 36644, 2, 4779},
	{3585, 36648, 4, 4781},
	{3603, 36652},
	{2594, 36656, 13, 4785},
	{2612, 36660, 4, 411},
	{2630, 36664, 9, 4798},
	{2648, 36668, 3, 4807},
	{2666, 37120, 6, 429},
	{2682, 39160, 9, 4810},
	{2697, 39184, 5, 4820},
	{2711, 39188, 5, 4820},
	{2725, 39192, 5, 4820},
	{2739, 39196, 5, 4820},
	{2753, 39200, 5, 4820},
	{2767, 39204, 5, 4820},
	{2781, 39208, 5, 4820},
	{2795, 39212, 5, 4820},
	{2809, 39216, 5, 4820},
	{2823, 39220, 5, 4820},
	{2837, 39224, 5, 4820},
	{2852, 39228, 5, 4820},
	{2867, 39232, 5, 4820},
	{2882, 39236, 5, 4820},
	{2897, 39240, 5, 4820},
	{2912, 39244, 5, 4820},
	{2927, 39248, 5, 4820},
	{2942, 39252, 5, 4820},
	{2957, 39256, 5, 4820},
	{2972, 39260, 5, 4820},
	{2987, 39264, 5, 4820},
	{3002, 39268, 5, 4820},
	{3017, 39272, 5, 4820},
	{3032, 39276, 5, 4820},
	{3047, 39280, 5, 4820},
	{3062, 39284, 5, 4820},
	{3077, 39288, 5, 4820},
	{3092, 39292, 5, 4820},
	{3107, 39296, 5, 4820},
	{3122, 39300, 5, 4820},
	{3137, 39304, 5, 4820},
	{3152, 39308, 5, 4820},
	{3167, 39312, 4, 448},
	{3186, 39316, 4, 448},
	{3205, 39320, 4, 448},
	{3224, 39324, 4, 448},
	{3243, 39328, 4, 448},
	{3262, 39332, 4, 448},
	{3281, 39336, 4, 448},
	{3300, 39340, 4, 448},
	{3319, 39344, 4, 448},
	{3338, 39348, 4, 448},
	{3357, 39352, 4, 448},
	{3377, 39356, 4, 448},
	{3397, 39360, 4, 448},
	{3417, 39364, 4, 448},
	{3437, 39368, 4, 448},
	{3457, 39372, 4, 448},
	{55114, 45056},
	{55135, 45060, 1, 491},
	{55156, 45064},
	{55177, 45068, 1, 491},
	{3670, 45084, 3, 488},
	{3694, 45088},
	{3715, 45092, 1, 491},
	{3736, 45096, 11, 4825},
	{3760, 45100, 6, 503},
	{3784, 45104},
	{3810, 45108},
	{3836, 45112},
	{3862, 45116},
	{3888, 45120},
	{3914, 45124},
	{3940, 45128},
	{3966, 45132},
	{3992, 45136},
	{4018, 45140},
	{4044, 45144},
	{4071, 45148},
	{4098, 45152},
	{4125, 45156},
	{4152, 45160},
	{4179, 45164},
	{55198, 45312},
	{55219, 45316, 1, 491},
	{55240, 45320},
	{55261, 45324, 1, 491},
	{4851, 45336, 3, 488},
	{4875, 45340, 1, 527},
	{4900, 45344},
	{4921, 45348, 1, 491},
	{4942, 45352, 12, 4842},
	{4966, 45356, 10, 540},
	{4990, 45360},
	{5016, 45364},
	{5042, 45368},
	{5068, 45372},
	{5094, 45376},
	{5120, 45380},
	{5146, 45384},
	{5172, 45388},
	{5198, 45392},
	{5224, 45396},
	{5250, 45400},
	{5277, 45404},
	{5304, 45408},
	{5331, 45412},
	{5358, 45416},
	{5385, 45420},
	{6035, 45552, 6, 563},
	{6062, 45556, 5, 569},
	{55282, 45568},
	{55303, 45572, 1, 491},
	{55324, 45576},
	{55345, 45580, 1, 491},
	{6250, 45596, 3, 488},
	{6274, 45600},
	{6295, 45604, 1, 491},
	{6316, 45608, 11, 4864},
	{6340, 45612, 4, 554},
	{6364, 45616},
	{6390, 45620},
	{6416, 45624},
	{6442, 45628},
	{6468, 45632},
	{6494, 45636},
	{6520, 45640},
	{6546, 45644},
	{6572, 45648},
	{6598, 45652},
	{6624, 45656},
	{6651, 45660},
	{6678, 45664},
	{6705, 45668},
	{6732, 45672},
	{6759, 45676},
	{7394, 45808, 6, 563},
	{55366, 45824},
	{55387, 45828, 1, 491},
	{55408, 45832},
	{55429, 45836, 1, 491},
	{7421, 45852, 3, 488},
	{7445, 45856},
	{7466, 45860, 1, 491},
	{7487, 45864, 12, 4842},
	{7511, 45868, 6, 563},
	{7535, 45872},
	{7561, 45876},
	{7587, 45880},
	{7613, 45884},
	{7639, 45888},
	{7665, 45892},
	{7691, 45896},
	{7717, 45900},
	{7743, 45904},
	{7769, 45908},
	{7795, 45912},
	{7822, 45916},
	{7849, 45920},
	{7876, 45924},
	{7903, 45928},
	{7930, 45932},
	{7957, 46068, 5, 569},
	{55450, 46080},
	{55471, 46084, 1, 491},
	{55492, 46088},
	{55513, 46092, 1, 491},
	{8145, 46108, 2, 612},
	{8169, 46112},
	{8190, 46116, 1, 491},
	{8211, 46120, 10, 4885},
	{8235, 46124, 6, 628},
	{8259, 46128},
	{8285, 46132},
	{8311, 46136},
	{8337, 46140},
	{8363, 46144},
	{8389, 46148},
	{8415, 46152},
	{8441, 46156},
	{8467, 46160},
	{8493, 46164},
	{8519, 46168},
	{8546, 46172},
	{8573, 46176},
	{8600, 46180},
	{8627, 46184},
	{8654, 46188},
	{9289, 46324, 5, 569},
	{55534, 46336},
	{55555, 46340, 1, 491},
	{55576, 46344},
	{55597, 46348, 1, 491},
	{9316, 46364, 3, 488},
	{9340, 46368},
	{9361, 46372, 1, 491},
	{9382, 46376, 11, 4901},
	{9406, 46380, 5, 569},
	{9430, 46384},
	{9456, 46388},
	{9482, 46392},
	{9508, 46396},
	{9534, 46400},
	{9560, 46404},
	{9586, 46408},
	{9612, 46412},
	{9638, 46416},
	{9664, 46420},
	{9690, 46424},
	{9717, 46428},
	{9744, 46432},
	{9771, 46436},
	{9798, 46440},
	{9825, 46444},
	{9852, 47104, 12, 4917},
	{9879, 47108},
	{9893, 47112},
	{9907, 47116},
	{9921, 47120},
	{9937, 47124},
	{9953, 47128},
	{9969, 47132, 2, 659},
	{9990, 47136, 2, 659},
	{10011, 47140, 2, 659},
	{10032, 47144, 1, 661},
	{10060, 47148, 1, 662},
	{10085, 47152},
	{10100, 47156, 2, 4930},
	{55638, 47160},
	{55653, 47164, 1, 663},
	{55668, 47168},
	{55683, 47172, 1, 663},
	{10239, 47176, 10, 4932},
	{10257, 47180, 11, 676},
	{10275, 47184, 1, 687},
	{10288, 47188, 6, 688},
	{55698, 47192, 2, 4949},
	{55729, 47196, 2, 4949},
	{10366, 47200, 2, 694},
	{55912, 47204, 2, 4949},
	{55943, 47208, 2, 4949},
	{10441, 47212},
	{10459, 47216},
	{10477, 47220},
	{10495, 47224, 1, 696},
	{10523, 47228, 4, 697},
	{10841, 47360},
	{10861, 47364},
	{10881, 47368},
	{10901, 47372},
	{10921, 47376},
	{10941, 47380},
	{10961, 47384},
	{10981, 47388},
	{11001, 47392},
	{11021, 47396},
	{11041, 47400},
	{11062, 47404},
	{11083, 47408},
	{11104, 47412},
	{11125, 47416},
	{11146, 47420},
	{55760, 53300, 29, 4951},
	{55777, 55348, 29, 4951},
	{11228, 163840, 9, 719},
	{11246, 163844, 9, 4980},
	{11263, 163848, 4, 4989},
	{11277, 163852, 23, 747},
	{11296, 163856, 15, 770},
	{11316, 163860},
	{11352, 163872},
	{11372, 163876},
	{11392, 163880, 1, 788},
	{11409, 163884},
	{11424, 163888, 2, 789},
	{11448, 163892, 2, 791},
	{55794, 163900, 7, 4993},
	{11506, 163904, 8, 5000},
	{11516, 163908, 5, 5008},
	{11532, 163912},
	{11547, 163916},
	{11568, 163920},
	{11584, 163924},
	{55808, 163928, 2, 5013},
	{55822, 163932, 1, 5015},
	{11774, 163968},
	{11790, 163972, 1, 840},
	{11809, 164328, 1, 841},
	{11830, 164332, 1, 841},
	{11851, 164336, 1, 841},
	{11872, 164340, 1, 841},
	{11893, 164344},
	{11911, 164348},
	{11929, 164352, 2, 842},
	{11949, 164356, 3, 844},
	{11973, 164360, 2, 847},
	{11997, 164364, 1, 849},
	{12017, 164368, 2, 844},
	{12037, 164372, 2, 847},
	{12057, 164376, 2, 844},
	{12077, 164380, 2, 847},
	{12097, 164384, 2, 844},
	{12117, 164388, 2, 847},
	{12137, 164392, 2, 844},
	{12157, 164396, 2, 847},
	{12177, 164400, 7, 850},
	{12192, 164404, 2, 857},
	{12221, 164408, 8, 859},
	{12236, 164412, 8, 867},
	{12251, 164416, 3, 844},
	{12276, 164420, 2, 847},
	{12301, 164424},
	{12319, 164428},
	{12337, 164432, 3, 844},
	{12362, 164436, 2, 847},
	{12387, 164440, 3, 844},
	{12412, 164444, 2, 847},
	{12437, 164448, 3, 844},
	{12462, 164452, 2, 847},
	{12487, 164456, 3, 844},
	{12512, 164460, 2, 847},
	{12537, 164464, 3, 844},
	{12562, 164468, 2, 847},
	{12587, 164472, 3, 844},
	{12612, 164476, 2, 847},
	{12637, 164480, 3, 844},
	{12662, 164484, 2, 847},
	{12687, 164488, 3, 844},
	{12712, 164492, 2, 847},
	{12737, 164496, 3, 844},
	{12762, 164500, 2, 847},
	{12787, 164504, 3, 844},
	{12812, 164508, 2, 847},
	{12837, 164512, 3, 844},
	{12863, 164516, 2, 847},
	{12889, 164520, 3, 844},
	{12915, 164524, 2, 847},
	{12941, 164528, 3, 844},
	{12967, 164532, 2, 847},
	{12993, 164536, 3, 844},
	{13019, 164540, 2, 847},
	{13045, 164544, 3, 844},
	{13071, 164548, 2, 847},
	{13097, 164552, 3, 844},
	{13123, 164556, 2, 847},
	{13149, 164560},
	{13168, 164564},
	{13187, 164568},
	{13206, 164572},
	{13225, 164576},
	{13244, 164580},
	{13263, 164584},
	{13282, 164588},
	{13301, 164592},
	{13320, 164596},
	{13339, 164600},
	{13358, 164604},
	{13377, 164608},
	{13396, 164612},
	{13415, 164616},
	{13434, 164620},
	{13453, 164624},
	{13472, 164628},
	{13491, 164632},
	{13510, 164636},
	{13529, 164640},
	{13549, 164644},
	{13569, 164648},
	{13589, 164652},
	{13609, 164656},
	{13629, 164660},
	{13649, 164664},
	{13669, 164668},
	{13689, 164672},
	{13709, 164676},
	{13729, 164680},
	{13749, 164684},
	{13769, 164688, 15, 875},
	{13789, 164692, 3, 890},
	{13811, 164696, 2, 893},
	{13868, 164704, 1, 902},
	{55837, 164708, 1, 5016},
	{13899, 164712, 1, 904},
	{13967, 164864},
	{13984, 164868},
	{14001, 164872},
	{14017, 164876},
	{14071, 164884},
	{14084, 164888},
	{14099, 164892},
	{14113, 164896},
	{14167, 164908, 6, 935},
	{14186, 164912, 4, 941},
	{14204, 164916, 4, 945},
	{14225, 164924},
	{14244, 164928},
	{14264, 164932},
	{14283, 164936},
	{14303, 164940},
	{14322, 164944},
	{14342, 164948},
	{14363, 164952},
	{14385, 164956},
	{14406, 164960},
	{14428, 164964},
	{14449, 164968},
	{14471, 164972},
	{14492, 164976},
	{14514, 164980},
	{14535, 164984},
	{14557, 164988},
	{14578, 164992},
	{14600, 164996},
	{14621, 165000},
	{14643, 165004},
	{14664, 165008},
	{14686, 165012},
	{14707, 165016},
	{14729, 165020},
	{14750, 165024},
	{14772, 165028},
	{14793, 165032},
	{14815, 165036},
	{14836, 165040},
	{14858, 165044},
	{14879, 165048},
	{14901, 165052},
	{14922, 165056},
	{14944, 165060},
	{14965, 165064},
	{14987, 165068},
	{15008, 165072},
	{15030, 165076},
	{15051, 165080},
	{15073, 165084},
	{15094, 165088},
	{15116, 165092},
	{15137, 165096},
	{15159, 165100},
	{15180, 165104},
	{15202, 165108},
	{15223, 165112},
	{15245, 165116},
	{15266, 165120},
	{15288, 165124},
	{15309, 165128},
	{15331, 165132},
	{15352, 165136},
	{15374, 165140},
	{15395, 165144},
	{15417, 165148},
	{15438, 165152},
	{15460, 165156},
	{15481, 165160},
	{15503, 165164},
	{15525, 165168},
	{15548, 165172},
	{15570, 165176},
	{15593, 165180},
	{15615, 165184},
	{15638, 165188},
	{15660, 165192},
	{15683, 165196},
	{15705, 165200},
	{15728, 165204},
	{15750, 165208},
	{15773, 165212},
	{15795, 165216},
	{15818, 165220},
	{15840, 165224},
	{15863, 165228},
	{15885, 165232},
	{15908, 165236},
	{15930, 165240},
	{15953, 165244},
	{15975, 165248},
	{15998, 165252},
	{16020, 165256},
	{16043, 165260},
	{16065, 165264},
	{16088, 165268},
	{16110, 165272},
	{16133, 165276},
	{16155, 165280},
	{16178, 165284},
	{16200, 165288},
	{16223, 165292},
	{16245, 165296},
	{16268, 165300},
	{16290, 165304},
	{16313, 165308},
	{16327, 165312},
	{16341, 165316},
	{16355, 165320},
	{16369, 165324},
	{16383, 165328},
	{16397, 165332},
	{16411, 165336},
	{16425, 165340},
	{16439, 165344},
	{16453, 165348},
	{16467, 165352},
	{16481, 165356},
	{16495, 165360},
	{16509, 165364},
	{16523, 165368},
	{16537, 165372},
	{16551, 165376},
	{16565, 165380},
	{16579, 165384},
	{16593, 165388},
	{16607, 165392},
	{16621, 165396},
	{16635, 165400},
	{16672, 165444, 6, 949},
	{16692, 165448, 6, 949},
	{16712, 165452, 6, 949},
	{16732, 165456, 6, 949},
	{16752, 165460, 6, 949},
	{16772, 165464, 6, 949},
	{16792, 165468, 6, 949},
	{16812, 165472, 6, 949},
	{16832, 165476, 6, 949},
	{16852, 165480, 6, 949},
	{16872, 165484, 6, 949},
	{16893, 165488, 6, 949},
	{16914, 165492, 6, 949},
	{16935, 165496, 6, 949},
	{16956, 165500, 6, 949},
	{16977, 165504, 6, 949},
	{16998, 165508, 6, 949},
	{17019, 165512, 6, 949},
	{17040, 165516, 6, 949},
	{17061, 165520, 6, 949},
	{17082, 165524, 4, 961},
	{17103, 165528, 4, 961},
	{17124, 165532, 4, 961},
	{17145, 165536, 4, 961},
	{17166, 165540, 4, 961},
	{17187, 165544, 4, 961},
	{17208, 165548, 4, 961},
	{17229, 165552, 4, 961},
	{17250, 165556, 4, 961},
	{17271, 165560, 4, 961},
	{17292, 165564, 4, 961},
	{17313, 165568, 4, 961},
	{17334, 165572, 2, 970},
	{17352, 165580, 16, 973},
	{17369, 165584, 16, 973},
	{17387, 165588, 7, 989},
	{17408, 165592, 3, 5017},
	{17426, 165600, 7, 1002},
	{17441, 165608, 2, 694},
	{17480, 165644, 4, 1010},
	{17502, 165648, 1, 1015},
	{17522, 165652, 8, 1016},
	{17748, 165760, 9, 1063},
	{17766, 165764, 9, 1063},
	{17784, 165768, 9, 1063},
	{17802, 165772, 9, 1063},
	{17820, 165776, 9, 1063},
	{17838, 165780, 9, 1063},
	{17856, 165784, 9, 1063},
	{17874, 165788, 9, 1063},
	{17892, 165836, 1, 1072},
	{17906, 165840, 1, 1072},
	{17921, 165844},
	{17939, 165848},
	{17957, 165852},
	{17974, 165856},
	{17995, 165860, 1, 5020},
	{18011, 165864},
	{18024, 165872, 5, 1074},
	{18043, 165876},
	{18058, 165880, 1, 1082},
	{18107, 165888, 10, 1084},
	{18124, 165892, 12, 1094},
	{18132, 165896, 3, 5021},
	{18149, 165900, 12, 1110},
	{18167, 165904, 19, 1127},
	{18183, 165908, 13, 1147},
	{18202, 165912, 10, 1163},
	{18217, 165916, 26, 1173},
	{18235, 165920, 16, 1201},
	{18253, 165924, 4, 1217},
	{18277, 165928},
	{18302, 165932, 11, 1221},
	{18454, 166400, 2, 1253},
	{18471, 166404, 2, 1255},
	{18490, 166408, 1, 1257},
	{18506, 166412, 4, 1258},
	{18525, 166416, 1, 1262},
	{18546, 166420, 1, 1263},
	{18559, 166424},
	{18582, 166428},
	{18605, 166432, 1, 1264},
	{18625, 166436, 4, 5024},
	{18645, 166440, 1, 1269},
	{18666, 166444, 1, 1270},
	{18681, 166448, 6, 1271},
	{18703, 166452, 6, 1271},
	{18725, 166456, 8, 1277},
	{18751, 166460, 8, 1277},
	{18777, 166464, 15, 1285},
	{18789, 166468, 2, 1300},
	{18808, 166472, 4, 1303},
	{18826, 166476, 24, 1310},
	{18844, 166480},
	{18856, 166484, 1, 1334},
	{18870, 166488, 1, 1335},
	{18884, 166492, 1, 1336},
	{18898, 166496, 1, 1337},
	{18921, 166500, 1, 1337},
	{18944, 166504, 1, 1337},
	{18967, 166508, 5, 5028},
	{18988, 166512},
	{18999, 166516},
	{19012, 166520},
	{19029, 166524, 7, 5033},
	{19048, 166528},
	{19059, 166532, 2, 1351},
	{19078, 166536},
	{19100, 166540},
	{19122, 166544, 3, 5040},
	{19142, 166548, 1, 1357},
	{19191, 166560},
	{19216, 166564},
	{19241, 166568, 6, 1364},
	{19260, 166572, 1, 1370},
	{19283, 166576, 1, 1370},
	{19306, 166580, 1, 1371},
	{19320, 166584, 1, 1372},
	{19335, 166588, 7, 5043},
	{19352, 166592, 4, 1382},
	{19379, 166596, 4, 1386},
	{19406, 166600, 4, 1390},
	{19425, 166608},
	{19451, 166612, 1, 1394},
	{19476, 166620},
	{19504, 166624},
	{19530, 166628, 1, 1394},
	{19555, 166636},
	{19583, 166640},
	{19609, 166644, 1, 1394},
	{19634, 166652},
	{19662, 166656},
	{19688, 166660, 1, 1394},
	{19713, 166668},
	{19741, 166696},
	{19772, 166700},
	{19815, 166704, 1, 1395},
	{19853, 166712, 1, 1396},
	{19914, 166740, 6, 1404},
	{19935, 166744, 3, 1423},
	{19952, 166748, 1, 1370},
	{19973, 166752, 1, 1370},
	{19996, 166756, 1, 1370},
	{20019, 166760, 1, 1370},
	{20042, 166764, 8, 5050},
	{20055, 166768, 6, 1438},
	{20072, 166772},
	{20096, 166776, 2, 1444},
	{20126, 166780},
	{20150, 166784},
	{20180, 166788},
	{20211, 166792},
	{20240, 166796},
	{20270, 166800, 2, 1446},
	{20290, 166804, 7, 5058},
	{20309, 166808, 4, 1457},
	{20359, 166868, 8, 1461},
	{20385, 166872, 8, 1469},
	{20411, 166876, 4, 1477},
	{20427, 166880, 5, 1482},
	{20443, 166884, 3, 1488},
	{20458, 166888},
	{20481, 166892},
	{20504, 166896},
	{20527, 166900},
	{20550, 166904, 8, 1491},
	{20584, 166908, 8, 1499},
	{20618, 166912, 8, 1507},
	{20652, 166916, 8, 1515},
	{20686, 166920, 8, 1491},
	{20720, 166924, 8, 1499},
	{20754, 166928, 8, 1507},
	{20788, 166932, 8, 1515},
	{20822, 166936, 8, 1491},
	{20856, 166940, 8, 1499},
	{20890, 166944, 8, 1507},
	{20924, 166948, 8, 1515},
	{20958, 166952, 8, 1491},
	{20992, 166956, 8, 1499},
	{21026, 166960, 8, 1507},
	{21060, 166964, 8, 1515},
	{21094, 166968, 2, 1523},
	{21118, 166972, 2, 1525},
	{21261, 167000, 1, 1567},
	{21289, 167004, 1, 1568},
	{21310, 167008},
	{21325, 167012, 2, 1569},
	{21341, 167016, 1, 1571},
	{21357, 167020, 2, 4989},
	{21372, 167024, 15, 5065},
	{21387, 167028, 6, 1594},
	{21426, 167036},
	{21442, 167040, 1, 1614},
	{21464, 167044},
	{21480, 167048, 1, 1571},
	{21502, 167052},
	{21524, 167056},
	{21565, 167068},
	{21580, 167072, 2, 1569},
	{21596, 167076, 1, 1571},
	{21612, 167080, 2, 4989},
	{21627, 167084, 15, 5065},
	{21642, 167088, 6, 1594},
	{21681, 167096},
	{21697, 167100, 1, 1614},
	{21719, 167104},
	{21735, 167108, 1, 1571},
	{21757, 167112},
	{21779, 167116},
	{21820, 167128},
	{21835, 167132, 2, 1569},
	{21851, 167136, 1, 1571},
	{21867, 167140, 2, 4989},
	{21882, 167144, 15, 5065},
	{21897, 167148, 6, 1594},
	{21936, 167156},
	{21952, 167160, 1, 1614},
	{21974, 167164},
	{21990, 167168, 1, 1571},
	{22012, 167172},
	{22034, 167176},
	{22075, 167188},
	{22090, 167192, 2, 1569},
	{22106, 167196, 1, 1571},
	{22122, 167200, 2, 4989},
	{22137, 167204, 15, 5065},
	{22152, 167208, 6, 1594},
	{22191, 167216},
	{22207, 167220, 1, 1614},
	{22229, 167224},
	{22245, 167228, 1, 1571},
	{22267, 167232},
	{22289, 167236},
	{22330, 167248},
	{22345, 167252, 2, 1569},
	{22361, 167256, 1, 1571},
	{22377, 167260, 2, 4989},
	{22392, 167264, 15, 5065},
	{22407, 167268, 6, 1594},
	{22446, 167276},
	{22462, 167280, 1, 1614},
	{22484, 167284},
	{22500, 167288, 1, 1571},
	{22522, 167292},
	{22544, 167296},
	{22585, 167308},
	{22600, 167312, 2, 1569},
	{22616, 167316, 1, 1571},
	{22632, 167320, 2, 4989},
	{22647, 167324, 15, 5065},
	{22662, 167328, 6, 1594},
	{22701, 167336},
	{22717, 167340, 1, 1614},
	{22739, 167344},
	{22755, 167348, 1, 1571},
	{22777, 167352},
	{22799, 167356},
	{22840, 167368},
	{22855, 167372, 2, 1569},
	{22871, 167376, 1, 1571},
	{22887, 167380, 2, 4989},
	{22902, 167384, 15, 5065},
	{22917, 167388, 6, 1594},
	{22956, 167396},
	{22972, 167400, 1, 1614},
	{22994, 167404},
	{23010, 167408, 1, 1571},
	{23032, 167412},
	{23054, 167416},
	{23095, 167428},
	{23110, 167432, 2, 1569},
	{23126, 167436, 1, 1571},
	{23142, 167440, 2, 4989},
	{23157, 167444, 15, 5065},
	{23172, 167448, 6, 1594},
	{23211, 167456},
	{23227, 167460, 1, 1614},
	{23249, 167464},
	{23265, 167468, 1, 1571},
	{23287, 167472},
	{23309, 167476},
	{24374, 196608, 2, 4206},
	{24394, 196612, 1, 1628},
	{24414, 196616},
	{24434, 196620},
	{24454, 196624},
	{24475, 196628},
	{24496, 196632, 2, 4208},
	{24518, 196636, 1, 1630},
	{24540, 196640},
	{24570, 196644},
	{24600, 196648},
	{24629, 196652},
	{24658, 196656},
	{24688, 196660},
	{24718, 196664},
	{24747, 196668},
	{24776, 196672},
	{24806, 196676},
	{24836, 196680},
	{24865, 196684},
	{24894, 196688},
	{24924, 196692},
	{24954, 196696},
	{24983, 196700},
	{25012, 196704, 2, 4210},
	{25034, 196708, 1, 1632},
	{25056, 196712},
	{25079, 196716},
	{25102, 196720},
	{25125, 196724},
	{25148, 196728},
	{25171, 196732},
	{25194, 196736},
	{25218, 196740},
	{25242, 196744},
	{25266, 196748},
	{25290, 196752},
	{25314, 196756},
	{25338, 196760},
	{25362, 196764},
	{25386, 196768},
	{25408, 196772},
	{25430, 196776},
	{25451, 196780},
	{25472, 196784},
	{25496, 196788},
	{25520, 196792},
	{25544, 196796},
	{25568, 196800},
	{25592, 196804},
	{25720, 196860, 1, 1635},
	{25736, 196864},
	{25749, 196868},
	{25762, 196872},
	{25775, 196876},
	{25788, 196880},
	{25801, 196884},
	{25814, 196888},
	{25827, 196892},
	{25954, 196928, 2, 1636},
	{25967, 196932},
	{25980, 196936},
	{26003, 196940},
	{26026, 196944},
	{26054, 196948},
	{26082, 196952},
	{26110, 196956},
	{26138, 196960, 1, 1638},
	{26156, 196964, 3, 5252},
	{26174, 196968},
	{26189, 196972},
	{26213, 196976},
	{26237, 196980},
	{26256, 196984},
	{26275, 196988},
	{26299, 196992},
	{26323, 196996},
	{26347, 197000},
	{26371, 197028, 2, 4215},
	{26389, 197032, 1, 1644},
	{26407, 197036},
	{26425, 197040},
	{26443, 197044, 2, 4218},
	{26461, 197048, 1, 1647},
	{26479, 197052},
	{26497, 197056, 2, 1649},
	{26516, 197060, 5, 1651},
	{26535, 197072},
	{26559, 197076, 2, 1649},
	{26579, 197080, 5, 1651},
	{26599, 197084, 8, 5255},
	{26618, 197088, 8, 5255},
	{26636, 197092, 1, 1663},
	{26653, 197100, 1, 1664},
	{26674, 197104, 23, 4226},
	{26688, 197108},
	{26702, 197112},
	{26716, 197116, 4, 4249},
	{26732, 197120},
	{26751, 197124, 1, 1680},
	{26773, 197128},
	{26792, 197132, 1, 1681},
	{26814, 197136, 9, 4255},
	{26832, 197140},
	{26852, 197144, 1, 1680},
	{26875, 197148},
	{26895, 197152, 1, 1681},
	{26918, 197156, 9, 4255},
	{26937, 197160, 5, 4264},
	{26949, 197164, 2, 1696},
	{26966, 197168, 1, 1698},
	{26983, 197172, 1, 1699},
	{27001, 197176, 5, 2647},
	{27021, 197180, 1, 1704},
	{27038, 197184},
	{27054, 197188, 1, 1706},
	{27067, 197192, 1, 1707},
	{27081, 197196, 1, 1708},
	{27095, 197200, 1, 1709},
	{27117, 197204, 1, 1710},
	{27137, 197208, 1, 1711},
	{27159, 197212, 1, 1712},
	{27179, 197216, 1, 1707},
	{27196, 197220, 1, 1708},
	{27213, 197224},
	{27472, 197388, 1, 1721},
	{27491, 197392, 1, 1722},
	{27510, 197396, 1, 1723},
	{27527, 197400, 1, 1724},
	{27545, 197404, 1, 1725},
	{27563, 197408, 1, 1726},
	{27579, 197412, 1, 1727},
	{27597, 197416, 1, 1728},
	{27615, 197420, 1, 1729},
	{27631, 197424, 1, 1724},
	{27646, 197428, 1, 1725},
	{27661, 197432, 1, 1726},
	{27674, 197436, 1, 1727},
	{27689, 197440, 1, 1728},
	{27704, 197444, 1, 1729},
	{27717, 197448, 1, 1730},
	{27731, 197452, 1, 1731},
	{27745, 197456, 1, 1732},
	{27757, 197460, 4, 5263},
	{27780, 197464, 4, 5267},
	{28480, 198656, 6, 4121},
	{28495, 198912},
	{28514, 198916},
	{28533, 198920, 1, 4504},
	{28552, 198924, 1, 4505},
	{28567, 198928},
	{28600, 198932},
	{28633, 198936},
	{28666, 198940},
	{28756, 198960},
	{28772, 198964},
	{28790, 198968, 1, 1785},
	{28807, 198972, 2, 1786},
	{28828, 198976},
	{29160, 199168, 1, 1809},
	{29185, 199172, 2, 1810},
	{29210, 199184, 2, 1812},
	{29236, 199188, 2, 1812},
	{29262, 199192, 2, 1812},
	{29288, 199212, 2, 1812},
	{29314, 199296, 2, 1814},
	{29342, 199300, 1, 1816},
	{29366, 199304, 1, 1817},
	{29390, 199308, 1, 1818},
	{29423, 199312, 1, 1818},
	{29451, 199328, 2, 1814},
	{29480, 199332, 1, 1816},
	{29505, 199336, 1, 1817},
	{29530, 199340, 1, 1818},
	{29564, 199344, 1, 1818},
	{29593, 199360, 2, 1814},
	{29617, 199364, 1, 1816},
	{29637, 199368, 1, 1817},
	{29657, 199372, 1, 1818},
	{29686, 199376, 1, 1818},
	{29710, 199936},
	{29737, 199940},
	{29764, 199944},
	{29791, 199948},
	{29926, 199968, 3, 4628},
	{29951, 200192},
	{29970, 200196, 1, 840},
	{29992, 200448},
	{30016, 200452, 1, 1828},
	{30039, 200456},
	{30063, 200460, 1, 1828},
	{30086, 200464},
	{30110, 200468, 1, 1828},
	{30133, 200472},
	{30157, 200476, 1, 1828},
	{30180, 200696},
	{30199, 200700, 1, 1828},
	{30217, 200704},
	{30229, 200708},
	{30241, 200712},
	{30259, 200716},
	{30278, 200720},
	{30296, 200724},
	{30308, 200728},
	{30320, 200732},
	{30338, 200736},
	{30356, 200740},
	{30375, 200744, 4, 5271},
	{30389, 200748, 2, 1833},
	{30407, 200752, 2, 1835},
	{30421, 200756, 2, 1837},
	{30435, 200760, 2, 1839},
	{30452, 200764, 2, 1841},
	{30469, 200768},
	{30482, 200772, 2, 1843},
	{30494, 200776},
	{30508, 200780},
	{30524, 200784},
	{30538, 200788},
	{30554, 200792},
	{30569, 200796},
	{30586, 200800},
	{30601, 200804},
	{30618, 200808, 2, 1845},
	{30640, 200812, 9, 5275},
	{30657, 200816, 2, 1857},
	{30678, 200820, 2, 1859},
	{30690, 200824},
	{30705, 200828, 6, 1861},
	{30720, 200832, 2, 1867},
	{30734, 200836},
	{30847, 212992},
	{30867, 212996},
	{30887, 213000},
	{30907, 213004},
	{30927, 213008},
	{30947, 213012},
	{30967, 213016},
	{30987, 213020},
	{31007, 213024},
	{31027, 213028},
	{31047, 213032},
	{31067, 213036},
	{31156, 213248},
	{31177, 213252},
	{31198, 213260},
	{31219, 213264},
	{31240, 213268},
	{31264, 213272},
	{31288, 213276},
	{31312, 213280},
	{31336, 213284},
	{31360, 213288},
	{31384, 213292},
	{31408, 213296},
	{55974, 213504},
	{55993, 213508},
	{56012, 213512},
	{56031, 213516},
	{56050, 213520},
	{56069, 213524},
	{56088, 213528},
	{56107, 213532},
	{53464, 213536},
	{53483, 213540},
	{53502, 213544},
	{53521, 213548},
	{53540, 213552},
	{53559, 213556},
	{53578, 213560},
	{53597, 213564},
	{54017, 213568},
	{54037, 213572},
	{54057, 213576},
	{54077, 213580},
	{54097, 213584},
	{54117, 213588},
	{54137, 213592},
	{54157, 213596},
	{31892, 214016},
	{31914, 214020, 1, 1869},
	{31936, 214024},
	{31958, 214028, 1, 1869},
	{31980, 214032},
	{32002, 214036, 1, 1869},
	{32024, 214040},
	{32046, 214044, 1, 1869},
	{32068, 214272},
	{32090, 214276},
	{32112, 214280},
	{32134, 214284},
	{32156, 214288},
	{32178, 214292},
	{32200, 214296},
	{32222, 214300},
	{32244, 214304},
	{32266, 214308},
	{32288, 214312},
	{32310, 214316},
	{32332, 214320},
	{32354, 214324},
	{32376, 214328},
	{32398, 214332},
	{32420, 214528},
	{32440, 214532},
	{32460, 214536},
	{32480, 214540},
	{32500, 214544},
	{32520, 214548},
	{32540, 214552},
	{32560, 214556},
	{32580, 214560},
	{32600, 214564},
	{32620, 214568},
	{32640, 214572},
	{32660, 214784},
	{32679, 214788},
	{32698, 214792},
	{32717, 214796},
	{32736, 214800},
	{32755, 214804},
	{32774, 214808},
	{32793, 214812},
	{32812, 214816},
	{32831, 214820},
	{32850, 214824},
	{32869, 214828},
	{32888, 214832},
	{32907, 214836},
	{32926, 214840},
	{32945, 214844},
	{32964, 214848},
	{32983, 214852},
	{33002, 214856},
	{33021, 214860},
	{33040, 214864},
	{33060, 214868},
	{33080, 214872},
	{33100, 214876},
	{33120, 214880},
	{33140, 214884},
	{33160, 214888},
	{33180, 214892},
	{33200, 214896},
	{33220, 214900},
	{33240, 214904},
	{33260, 214908},
	{33280, 215296},
	{33299, 215300},
	{33318, 215304},
	{33337, 215308},
	{33356, 215312},
	{33375, 215316},
	{33394, 215320},
	{33413, 215324},
	{33474, 215552},
	{33494, 215556},
	{33514, 215560},
	{33534, 215564},
	{33554, 215568},
	{33574, 215572},
	{33594, 215576},
	{33614, 215580},
	{33634, 215808},
	{33653, 215812},
	{33672, 215816},
	{33691, 215820},
	{33710, 216064},
	{33729, 216068},
	{33748, 216072},
	{33767, 216076},
	{33786, 216320},
	{33806, 216324},
	{33826, 216328},
	{33846, 216332},
	{33866, 216336},
	{33886, 216340},
	{33906, 216344},
	{33926, 216348},
	{56126, 216576},
	{56146, 216580},
	{56166, 216584},
	{56186, 216588},
	{56206, 216592},
	{56226, 216596},
	{56246, 216600},
	{56266, 216604},
	{56286, 216640},
	{56306, 216644},
	{56326, 216648},
	{56346, 216652},
	{56366, 216656},
	{56386, 216660},
	{56406, 216664},
	{56426, 216668},
	{56446, 216704},
	{56466, 216708},
	{56486, 216712},
	{56506, 216716},
	{56526, 216720},
	{56546, 216724},
	{56566, 216728},
	{56586, 216732},
	{34778, 217112},
	{34797, 217116},
	{34816, 217120},
	{34835, 217124},
	{34854, 217128},
	{34873, 217132},
	{34892, 217136},
	{34911, 217140},
	{34930, 217344},
	{34949, 217348},
	{34968, 217352},
	{34987, 217356},
	{35006, 217360},
	{35025, 217364},
	{35044, 217368},
	{35063, 217372},
	{35082, 217600},
	{35102, 217604},
	{35122, 217608},
	{35142, 217612},
	{36464, 221184, 1, 1903},
	{36488, 221188, 2, 5284},
	{36513, 221192, 3, 5286},
	{36537, 221196, 1, 1903},
	{36561, 221200, 2, 5284},
	{36586, 221204, 1, 1903},
	{36610, 221208, 2, 5284},
	{36635, 221212, 3, 5286},
	{36659, 221216, 4, 1881},
	{36675, 221220, 3, 5286},
	{36842, 221248},
	{36857, 221252, 1, 1818},
	{36880, 221256},
	{36903, 221260},
	{36921, 221264, 2, 1897},
	{36939, 221268, 4, 1899},
	{36959, 221440, 19, 4164},
	{36984, 221444, 19, 4164},
	{37009, 221448, 12, 4183},
	{37037, 221452, 12, 4183},
	{37065, 221456, 12, 4183},
	{37093, 221460, 12, 4183},
	{56606, 221696, 2, 4462},
	{56629, 221700, 2, 4462},
	{56652, 221704, 2, 4462},
	{56675, 221708, 2, 4462},
	{53372, 221712, 5, 1957},
	{53395, 221716, 2, 4462},
	{53418, 221720, 2, 4462},
	{53441, 221724, 2, 4462},
	{56698, 221728, 4, 1962},
	{53921, 221744, 5, 1957},
	{53945, 221748, 5, 1957},
	{53969, 221752, 2, 4462},
	{53993, 221756, 2, 4462},
	{56722, 221760, 4, 1962},
	{56747, 221764, 4, 1962},
	{53895, 221776, 1, 4503},
	{37551, 222208, 3, 1957},
	{37577, 222212, 2, 1877},
	{37604, 222216, 3, 1957},
	{37630, 222220, 2, 1877},
	{37657, 222224, 2, 2013},
	{37710, 222228, 2, 2013},
	{37763, 222464, 3, 1957},
	{37789, 222468, 2, 1877},
	{37816, 222472, 1, 1872},
	{37842, 222476, 1, 1872},
	{37868, 222480, 1, 1872},
	{37894, 222484, 1, 1872},
	{37920, 222488, 1, 1872},
	{37946, 222492, 1, 1872},
	{37972, 222496, 1, 1872},
	{37998, 222720, 3, 1957},
	{38022, 222724, 3, 1957},
	{38046, 222728, 3, 1957},
	{38070, 222732, 3, 1957},
	{38094, 222736, 2, 1877},
	{38119, 222740, 2, 1877},
	{38144, 222744, 2, 1877},
	{38169, 222748, 2, 1877},
	{38194, 222752, 1, 2001},
	{38218, 222756, 1, 2001},
	{38242, 222760, 8, 1966},
	{38263, 222976, 6, 5289},
	{38286, 222980, 6, 5289},
	{38309, 222984, 6, 5289},
	{38332, 222988, 6, 5289},
	{38355, 222992, 6, 5289},
	{38378, 222996, 6, 5289},
	{38401, 223000, 6, 5289},
	{38424, 223004, 6, 5289},
	{38447, 223008, 6, 5289},
	{38470, 223012, 6, 5289},
	{38493, 223016, 6, 5289},
	{38517, 223020, 6, 5289},
	{38541, 223024, 6, 5289},
	{38565, 223028, 6, 5289},
	{38589, 223032, 6, 5289},
	{38613, 223036, 6, 5289},
	{38637, 223104, 9, 4644},
	{56772, 223108, 2, 4693},
	{38657, 223112, 1, 1987},
	{38752, 223488, 3, 1996},
	{38775, 223492, 3, 1996},
	{38798, 223496, 3, 1996},
	{38821, 223500, 3, 1996},
	{38844, 223504, 2, 1999},
	{38868, 223508, 2, 1999},
	{38892, 223744, 3, 1996},
	{38916, 223748, 3, 1996},
	{38940, 223752, 3, 1996},
	{38964, 223756, 3, 1996},
	{38988, 223760, 2, 1999},
	{39013, 224000, 5, 2001},
	{39036, 224004, 4, 2006},
	{39060, 224008, 5, 2001},
	{39083, 224256, 5, 2001},
	{39106, 224260, 4, 2006},
	{39130, 224264, 5, 2001},
	{39153, 224512, 5, 1957},
	{39177, 224516, 4, 1962},
	{39202, 224520, 5, 1957},
	{39226, 224524, 4, 1962},
	{39251, 224528, 3, 2013},
	{39275, 224532, 3, 2013},
	{56792, 224768, 5, 1957},
	{56816, 224772, 4, 1951},
	{56841, 224776, 5, 1957},
	{56865, 224780, 4, 1951},
	{56890, 224784, 3, 2013},
	{56914, 224788, 3, 2013},
	{56938, 224832, 5, 1957},
	{56962, 224836, 4, 1951},
	{56987, 224840, 5, 1957},
	{57011, 224844, 4, 1951},
	{57036, 224848, 3, 2013},
	{57060, 224852, 3, 2013},
	{57084, 224896, 5, 1957},
	{57108, 224900, 4, 1951},
	{57133, 224904, 3, 2013},
	{57157, 224908, 3, 2013},
	{57181, 224912, 3, 2013},
	{39976, 225280, 12, 2016},
	{39998, 225284, 5, 2028},
	{40021, 225288, 4, 2033},
	{40045, 225292, 2, 2037},
	{40068, 225296, 2, 2037},
	{40091, 225300, 2, 2037},
	{40114, 225536, 5, 1957},
	{40137, 225540, 4, 1962},
	{40161, 225544, 5, 1957},
	{40184, 225548, 4, 1962},
	{40208, 225552, 5, 1957},
	{40231, 225560, 5, 1957},
	{40254, 225792, 4, 2039},
	{40275, 225796},
	{40304, 225800, 2, 2043},
	{40333, 225804},
	{40359, 225808, 7, 2045},
	{40433, 225812},
	{40456, 225816},
	{57205, 225820, 2, 5295},
	{57238, 225824, 2, 5295},
	{57271, 225828, 2, 5295},
	{57304, 225832, 2, 5295},
	{57336, 225836, 2, 5295},
	{57368, 225840, 2, 5295},
	{57400, 225844, 2, 5295},
	{57433, 225848, 2, 5295},
	{57465, 225856, 2, 5295},
	{57497, 225860, 2, 5295},
	{57530, 225864, 2, 5295},
	{57563, 225868, 2, 5295},
	{57596, 225872, 2, 5295},
	{57628, 225876, 2, 5295},
	{57660, 225880, 2, 5295},
	{57693, 225884, 2, 5295},
	{57726, 225888, 2, 5295},
	{57759, 225892, 2, 5295},
	{57792, 225896, 2, 5295},
	{40479, 225900},
	{40506, 225904},
	{40388, 225908},
	{40407, 225912},
	{57824, 225916, 2, 5295},
	{57858, 225920, 2, 5295},
	{57892, 225924, 2, 5295},
	{57926, 225928, 2, 5295},
	{41169, 226048, 2, 2119},
	{41186, 226052, 1, 2121},
	{41210, 226056, 1, 2121},
	{206, 880, 4, 2156},
	{42955, 881},
	{26802, 882},
	{42967, 1008},
	{42978, 1009},
	{26990, 1010, 4, 2160},
	{42989, 1040, 1, 2164},
	{43002, 1041, 5, 5297},
	{43015, 1042, 1, 2170},
	{43028, 1043, 1, 1681},
	{26824, 1045, 9, 5089},
	{43056, 1280, 6, 5302},
	{43071, 1281},
	{26761, 1282},
	{42955, 1283},
	{26802, 1284},
};

static const struct si_reg gfx8_reg_table[] = {
	{1145, 68, 10, 5308},
	{1158, 72, 23, 5318},
	{1173, 76, 4, 5341},
	{52194, 80, 11, 5114},
	{1210, 84, 4, 3975},
	{1228, 88, 2, 3979},
	{1246, 92, 6, 5345},
	{1261, 96},
	{1275, 100, 1, 3985},
	{1289, 104},
	{52208, 108},
	{52225, 112, 13, 5351},
	{1306, 116, 5, 5364},
	{52241, 2480},
	{52256, 2484, 1, 3999},
	{52271, 2488},
	{52286, 2492, 1, 3999},
	{1444, 2496},
	{1458, 2500},
	{1472, 2504},
	{1486, 2508},
	{1500, 2512},
	{1514, 2516},
	{1528, 2520},
	{1542, 2524},
	{1556, 2528},
	{1570, 2532},
	{1584, 2536},
	{1599, 2540},
	{1674, 2544},
	{1685, 2552},
	{1701, 2556},
	{52301, 3660, 21, 4000},
	{52314, 3664, 20, 4021},
	{52326, 3668, 16, 4041},
	{1789, 32776, 18, 5369},
	{1802, 32784, 24, 4079},
	{1814, 32788, 11, 4103},
	{1830, 32792, 11, 4103},
	{1859, 32824, 11, 4103},
	{1875, 32828, 11, 4103},
	{1891, 33296, 15, 5387},
	{1905, 33300, 28, 204},
	{1922, 33304, 14, 5402},
	{1943, 33308, 21, 5416},
	{1957, 33312, 31, 5197},
	{1974, 33316, 9, 5437},
	{2013, 33324, 1, 329},
	{2036, 33344, 1, 330},
	{2057, 33348},
	{2118, 33436, 1, 342},
	{54880, 36416},
	{2522, 36608},
	{2540, 36612, 4, 383},
	{2558, 36616},
	{2576, 36620, 14, 5446},
	{3477, 36624},
	{3495, 36628, 5, 5460},
	{3513, 36632, 4, 4762},
	{3531, 36636, 11, 4766},
	{3549, 36640, 2, 4777},
	{3567, 36644, 2, 4779},
	{3585, 36648, 8, 5465},
	{3603, 36652},
	{2594, 36656, 14, 5473},
	{2612, 36660, 4, 411},
	{2630, 36664, 10, 5487},
	{2648, 36668, 3, 4807},
	{2666, 37120, 6, 429},
	{2682, 39160, 9, 4810},
	{2697, 39184, 5, 4820},
	{2711, 39188, 5, 4820},
	{2725, 39192, 5, 4820},
	{2739, 39196, 5, 4820},
	{2753, 39200, 5, 4820},
	{2767, 39204, 5, 4820},
	{2781, 39208, 5, 4820},
	{2795, 39212, 5, 4820},
	{2809, 39216, 5, 4820},
	{2823, 39220, 5, 4820},
	{2837, 39224, 5, 4820},
	{2852, 39228, 5, 4820},
	{2867, 39232, 5, 4820},
	{2882, 39236, 5, 4820},
	{2897, 39240, 5, 4820},
	{2912, 39244, 5, 4820},
	{2927, 39248, 5, 4820},
	{2942, 39252, 5, 4820},
	{2957, 39256, 5, 4820},
	{2972, 39260, 5, 4820},
	{2987, 39264, 5, 4820},
	{3002, 39268, 5, 4820},
	{3017, 39272, 5, 4820},
	{3032, 39276, 5, 4820},
	{3047, 39280, 5, 4820},
	{3062, 39284, 5, 4820},
	{3077, 39288, 5, 4820},
	{3092, 39292, 5, 4820},
	{3107, 39296, 5, 4820},
	{3122, 39300, 5, 4820},
	{3137, 39304, 5, 4820},
	{3152, 39308, 5, 4820},
	{3167, 39312, 4, 448},
	{3186, 39316, 4, 448},
	{3205, 39320, 4, 448},
	{3224, 39324, 4, 448},
	{3243, 39328, 4, 448},
	{3262, 39332, 4, 448},
	{3281, 39336, 4, 448},
	{3300, 39340, 4, 448},
	{3319, 39344, 4, 448},
	{3338, 39348, 4, 448},
	{3357, 39352, 4, 448},
	{3377, 39356, 4, 448},
	{3397, 39360, 4, 448},
	{3417, 39364, 4, 448},
	{3437, 39368, 4, 448},
	{3457, 39372, 4, 448},
	{55114, 45056},
	{55135, 45060, 1, 491},
	{55156, 45064},
	{55177, 45068, 1, 491},
	{3670, 45084, 3, 488},
	{3694, 45088},
	{3715, 45092, 1, 491},
	{3736, 45096, 11, 4825},
	{3760, 45100, 6, 503},
	{3784, 45104},
	{3810, 45108},
	{3836, 45112},
	{3862, 45116},
	{3888, 45120},
	{3914, 45124},
	{3940, 45128},
	{3966, 45132},
	{3992, 45136},
	{4018, 45140},
	{4044, 45144},
	{4071, 45148},
	{4098, 45152},
	{4125, 45156},
	{4152, 45160},
	{4179, 45164},
	{55198, 45312},
	{55219, 45316, 1, 491},
	{55240, 45320},
	{55261, 45324, 1, 491},
	{4851, 45336, 3, 488},
	{4875, 45340, 1, 527},
	{4900, 45344},
	{4921, 45348, 1, 491},
	{4942, 45352, 12, 4842},
	{4966, 45356, 11, 5497},
	{4990, 45360},
	{5016, 45364},
	{5042, 45368},
	{5068, 45372},
	{5094, 45376},
	{5120, 45380},
	{5146, 45384},
	{5172, 45388},
	{5198, 45392},
	{5224, 45396},
	{5250, 45400},
	{5277, 45404},
	{5304, 45408},
	{5331, 45412},
	{5358, 45416},
	{5385, 45420},
	{6035, 45552, 6, 563},
	{6062, 45556, 5, 569},
	{55282, 45568},
	{55303, 45572, 1, 491},
	{55324, 45576},
	{55345, 45580, 1, 491},
	{6250, 45596, 4, 576},
	{6274, 45600},
	{6295, 45604, 1, 491},
	{6316, 45608, 11, 4864},
	{6340, 45612, 4, 554},
	{6364, 45616},
	{6390, 45620},
	{6416, 45624},
	{6442, 45628},
	{6468, 45632},
	{6494, 45636},
	{6520, 45640},
	{6546, 45644},
	{6572, 45648},
	{6598, 45652},
	{6624, 45656},
	{6651, 45660},
	{6678, 45664},
	{6705, 45668},
	{6732, 45672},
	{6759, 45676},
	{7394, 45808, 6, 563},
	{55366, 45824},
	{55387, 45828, 1, 491},
	{55408, 45832},
	{55429, 45836, 1, 491},
	{7421, 45852, 4, 576},
	{7445, 45856},
	{7466, 45860, 1, 491},
	{7487, 45864, 12, 4842},
	{7511, 45868, 6, 563},
	{7535, 45872},
	{7561, 45876},
	{7587, 45880},
	{7613, 45884},
	{7639, 45888},
	{7665, 45892},
	{7691, 45896},
	{7717, 45900},
	{7743, 45904},
	{7769, 45908},
	{7795, 45912},
	{7822, 45916},
	{7849, 45920},
	{7876, 45924},
	{7903, 45928},
	{7930, 45932},
	{7957, 46068, 5, 569},
	{55450, 46080},
	{55471, 46084, 1, 491},
	{55492, 46088},
	{55513, 46092, 1, 491},
	{8145, 46108, 3, 612},
	{8169, 46112},
	{8190, 46116, 1, 491},
	{8211, 46120, 10, 4885},
	{8235, 46124, 6, 628},
	{8259, 46128},
	{8285, 46132},
	{8311, 46136},
	{8337, 46140},
	{8363, 46144},
	{8389, 46148},
	{8415, 46152},
	{8441, 46156},
	{8467, 46160},
	{8493, 46164},
	{8519, 46168},
	{8546, 46172},
	{8573, 46176},
	{8600, 46180},
	{8627, 46184},
	{8654, 46188},
	{9289, 46324, 5, 569},
	{55534, 46336},
	{55555, 46340, 1, 491},
	{55576, 46344},
	{55597, 46348, 1, 491},
	{9316, 46364, 4, 576},
	{9340, 46368},
	{9361, 46372, 1, 491},
	{9382, 46376, 11, 4901},
	{9406, 46380, 5, 569},
	{9430, 46384},
	{9456, 46388},
	{9482, 46392},
	{9508, 46396},
	{9534, 46400},
	{9560, 46404},
	{9586, 46408},
	{9612, 46412},
	{9638, 46416},
	{9664, 46420},
	{9690, 46424},
	{9717, 46428},
	{9744, 46432},
	{9771, 46436},
	{9798, 46440},
	{9825, 46444},
	{9852, 47104, 12, 4917},
	{9879, 47108},
	{9893, 47112},
	{9907, 47116},
	{9921, 47120},
	{9937, 47124},
	{9953, 47128},
	{9969, 47132, 2, 659},
	{9990, 47136, 2, 659},
	{10011, 47140, 2, 659},
	{10032, 47144, 1, 661},
	{10060, 47148, 1, 662},
	{10085, 47152},
	{10100, 47156, 2, 4930},
	{55638, 47160},
	{55653, 47164, 1, 663},
	{55668, 47168},
	{55683, 47172, 1, 663},
	{10239, 47176, 10, 4932},
	{10257, 47180, 11, 676},
	{10275, 47184, 1, 687},
	{10288, 47188, 6, 688},
	{55698, 47192, 2, 4949},
	{55729, 47196, 2, 4949},
	{10366, 47200, 2, 694},
	{55912, 47204, 2, 4949},
	{55943, 47208, 2, 4949},
	{10441, 47212},
	{10459, 47216},
	{10477, 47220},
	{10495, 47224, 1, 696},
	{10523, 47228, 5, 697},
	{10545, 47232},
	{10565, 47236},
	{10748, 47240, 3, 713},
	{10765, 47244},
	{10794, 47248, 1, 716},
	{57960, 47252, 2, 5508},
	{10841, 47360},
	{10861, 47364},
	{10881, 47368},
	{10901, 47372},
	{10921, 47376},
	{10941, 47380},
	{10961, 47384},
	{10981, 47388},
	{11001, 47392},
	{11021, 47396},
	{11041, 47400},
	{11062, 47404},
	{11083, 47408},
	{11104, 47412},
	{11125, 47416},
	{11146, 47420},
	{11212, 47612},
	{55760, 53300, 29, 4951},
	{55777, 55348, 29, 4951},
	{11228, 163840, 10, 719},
	{11246, 163844, 9, 4980},
	{11263, 163848, 4, 4989},
	{11277, 163852, 23, 747},
	{11296, 163856, 15, 770},
	{11316, 163860},
	{11352, 163872},
	{11372, 163876},
	{11392, 163880, 1, 788},
	{11409, 163884},
	{11424, 163888, 2, 789},
	{11448, 163892, 2, 791},
	{55794, 163900, 7, 4993},
	{11506, 163904, 10, 5510},
	{11516, 163908, 6, 5520},
	{11532, 163912},
	{11547, 163916},
	{11568, 163920},
	{11584, 163924},
	{55808, 163928, 2, 5013},
	{55822, 163932, 1, 5015},
	{11774, 163968},
	{11790, 163972, 1, 840},
	{11809, 164328, 1, 841},
	{11830, 164332, 1, 841},
	{11851, 164336, 1, 841},
	{11872, 164340, 1, 841},
	{11893, 164344},
	{11911, 164348},
	{11929, 164352, 2, 842},
	{11949, 164356, 3, 844},
	{11973, 164360, 2, 847},
	{11997, 164364, 1, 849},
	{12017, 164368, 2, 844},
	{12037, 164372, 2, 847},
	{12057, 164376, 2, 844},
	{12077, 164380, 2, 847},
	{12097, 164384, 2, 844},
	{12117, 164388, 2, 847},
	{12137, 164392, 2, 844},
	{12157, 164396, 2, 847},
	{12177, 164400, 7, 850},
	{12192, 164404, 2, 857},
	{12221, 164408, 8, 859},
	{12236, 164412, 8, 867},
	{12251, 164416, 3, 844},
	{12276, 164420, 2, 847},
	{12301, 164424},
	{12319, 164428},
	{12337, 164432, 3, 844},
	{12362, 164436, 2, 847},
	{12387, 164440, 3, 844},
	{12412, 164444, 2, 847},
	{12437, 164448, 3, 844},
	{12462, 164452, 2, 847},
	{12487, 164456, 3, 844},
	{12512, 164460, 2, 847},
	{12537, 164464, 3, 844},
	{12562, 164468, 2, 847},
	{12587, 164472, 3, 844},
	{12612, 164476, 2, 847},
	{12637, 164480, 3, 844},
	{12662, 164484, 2, 847},
	{12687, 164488, 3, 844},
	{12712, 164492, 2, 847},
	{12737, 164496, 3, 844},
	{12762, 164500, 2, 847},
	{12787, 164504, 3, 844},
	{12812, 164508, 2, 847},
	{12837, 164512, 3, 844},
	{12863, 164516, 2, 847},
	{12889, 164520, 3, 844},
	{12915, 164524, 2, 847},
	{12941, 164528, 3, 844},
	{12967, 164532, 2, 847},
	{12993, 164536, 3, 844},
	{13019, 164540, 2, 847},
	{13045, 164544, 3, 844},
	{13071, 164548, 2, 847},
	{13097, 164552, 3, 844},
	{13123, 164556, 2, 847},
	{13149, 164560},
	{13168, 164564},
	{13187, 164568},
	{13206, 164572},
	{13225, 164576},
	{13244, 164580},
	{13263, 164584},
	{13282, 164588},
	{13301, 164592},
	{13320, 164596},
	{13339, 164600},
	{13358, 164604},
	{13377, 164608},
	{13396, 164612},
	{13415, 164616},
	{13434, 164620},
	{13453, 164624},
	{13472, 164628},
	{13491, 164632},
	{13510, 164636},
	{13529, 164640},
	{13549, 164644},
	{13569, 164648},
	{13589, 164652},
	{13609, 164656},
	{13629, 164660},
	{13649, 164664},
	{13669, 164668},
	{13689, 164672},
	{13709, 164676},
	{13729, 164680},
	{13749, 164684},
	{13769, 164688, 15, 875},
	{13789, 164692, 3, 890},
	{13811, 164696, 2, 893},
	{13868, 164704, 1, 902},
	{55837, 164708, 1, 5016},
	{13899, 164712, 1, 904},
	{13967, 164864},
	{13984, 164868},
	{14001, 164872},
	{14017, 164876},
	{14071, 164884},
	{14084, 164888},
	{14099, 164892},
	{14113, 164896},
	{14128, 164900, 3, 5526},
	{14167, 164908, 6, 935},
	{14186, 164912, 4, 941},
	{14204, 164916, 4, 945},
	{14225, 164924},
	{14244, 164928},
	{14264, 164932},
	{14283, 164936},
	{14303, 164940},
	{14322, 164944},
	{14342, 164948},
	{14363, 164952},
	{14385, 164956},
	{14406, 164960},
	{14428, 164964},
	{14449, 164968},
	{14471, 164972},
	{14492, 164976},
	{14514, 164980},
	{14535, 164984},
	{14557, 164988},
	{14578, 164992},
	{14600, 164996},
	{14621, 165000},
	{14643, 165004},
	{14664, 165008},
	{14686, 165012},
	{14707, 165016},
	{14729, 165020},
	{14750, 165024},
	{14772, 165028},
	{14793, 165032},
	{14815, 165036},
	{14836, 165040},
	{14858, 165044},
	{14879, 165048},
	{14901, 165052},
	{14922, 165056},
	{14944, 165060},
	{14965, 165064},
	{14987, 165068},
	{15008, 165072},
	{15030, 165076},
	{15051, 165080},
	{15073, 165084},
	{15094, 165088},
	{15116, 165092},
	{15137, 165096},
	{15159, 165100},
	{15180, 165104},
	{15202, 165108},
	{15223, 165112},
	{15245, 165116},
	{15266, 165120},
	{15288, 165124},
	{15309, 165128},
	{15331, 165132},
	{15352, 165136},
	{15374, 165140},
	{15395, 165144},
	{15417, 165148},
	{15438, 165152},
	{15460, 165156},
	{15481, 165160},
	{15503, 165164},
	{15525, 165168},
	{15548, 165172},
	{15570, 165176},
	{15593, 165180},
	{15615, 165184},
	{15638, 165188},
	{15660, 165192},
	{15683, 165196},
	{15705, 165200},
	{15728, 165204},
	{15750, 165208},
	{15773, 165212},
	{15795, 165216},
	{15818, 165220},
	{15840, 165224},
	{15863, 165228},
	{15885, 165232},
	{15908, 165236},
	{15930, 165240},
	{15953, 165244},
	{15975, 165248},
	{15998, 165252},
	{16020, 165256},
	{16043, 165260},
	{16065, 165264},
	{16088, 165268},
	{16110, 165272},
	{16133, 165276},
	{16155, 165280},
	{16178, 165284},
	{16200, 165288},
	{16223, 165292},
	{16245, 165296},
	{16268, 165300},
	{16290, 165304},
	{16313, 165308},
	{16327, 165312},
	{16341, 165316},
	{16355, 165320},
	{16369, 165324},
	{16383, 165328},
	{16397, 165332},
	{16411, 165336},
	{16425, 165340},
	{16439, 165344},
	{16453, 165348},
	{16467, 165352},
	{16481, 165356},
	{16495, 165360},
	{16509, 165364},
	{16523, 165368},
	{16537, 165372},
	{16551, 165376},
	{16565, 165380},
	{16579, 165384},
	{16593, 165388},
	{16607, 165392},
	{16621, 165396},
	{16635, 165400},
	{16672, 165444, 12, 949},
	{16692, 165448, 12, 949},
	{16712, 165452, 12, 949},
	{16732, 165456, 12, 949},
	{16752, 165460, 12, 949},
	{16772, 165464, 12, 949},
	{16792, 165468, 12, 949},
	{16812, 165472, 12, 949},
	{16832, 165476, 12, 949},
	{16852, 165480, 12, 949},
	{16872, 165484, 12, 949},
	{16893, 165488, 12, 949},
	{16914, 165492, 12, 949},
	{16935, 165496, 12, 949},
	{16956, 165500, 12, 949},
	{16977, 165504, 12, 949},
	{16998, 165508, 12, 949},
	{17019, 165512, 12, 949},
	{17040, 165516, 12, 949},
	{17061, 165520, 12, 949},
	{17082, 165524, 9, 961},
	{17103, 165528, 9, 961},
	{17124, 165532, 9, 961},
	{17145, 165536, 9, 961},
	{17166, 165540, 9, 961},
	{17187, 165544, 9, 961},
	{17208, 165548, 9, 961},
	{17229, 165552, 9, 961},
	{17250, 165556, 9, 961},
	{17271, 165560, 9, 961},
	{17292, 165564, 9, 961},
	{17313, 165568, 9, 961},
	{17334, 165572, 2, 970},
	{17352, 165580, 16, 973},
	{17369, 165584, 16, 973},
	{17387, 165588, 7, 989},
	{17408, 165592, 3, 5017},
	{17426, 165600, 7, 1002},
	{17441, 165608, 2, 694},
	{17480, 165644, 4, 1010},
	{17502, 165648, 1, 1015},
	{17522, 165652, 8, 1016},
	{17748, 165760, 9, 1063},
	{17766, 165764, 9, 1063},
	{17784, 165768, 9, 1063},
	{17802, 165772, 9, 1063},
	{17820, 165776, 9, 1063},
	{17838, 165780, 9, 1063},
	{17856, 165784, 9, 1063},
	{17874, 165788, 9, 1063},
	{17892, 165836, 1, 1072},
	{17906, 165840, 1, 1072},
	{17921, 165844},
	{17939, 165848},
	{17957, 165852},
	{17974, 165856},
	{17995, 165860, 1, 5020},
	{18011, 165864},
	{18024, 165872, 5, 1074},
	{18043, 165876},
	{18058, 165880, 1, 1082},
	{18107, 165888, 10, 1084},
	{18124, 165892, 12, 1094},
	{18132, 165896, 3, 5529},
	{18149, 165900, 12, 1110},
	{18167, 165904, 19, 1127},
	{18183, 165908, 13, 1147},
	{18202, 165912, 10, 1163},
	{18217, 165916, 27, 5532},
	{18235, 165920, 16, 1201},
	{18253, 165924, 4, 1217},
	{18277, 165928},
	{18302, 165932, 11, 1221},
	{18454, 166400, 2, 1253},
	{18471, 166404, 2, 1255},
	{18490, 166408, 1, 1257},
	{18506, 166412, 4, 1258},
	{18525, 166416, 1, 1262},
	{18546, 166420, 1, 1263},
	{18559, 166424},
	{18582, 166428},
	{18605, 166432, 1, 1264},
	{18625, 166436, 4, 5024},
	{18645, 166440, 1, 1269},
	{18666, 166444, 1, 1270},
	{18681, 166448, 6, 1271},
	{18703, 166452, 6, 1271},
	{18725, 166456, 8, 1277},
	{18751, 166460, 8, 1277},
	{18777, 166464, 15, 5559},
	{18789, 166468, 2, 1300},
	{18808, 166472, 4, 1303},
	{18826, 166476, 24, 1310},
	{18844, 166480},
	{18856, 166484, 1, 1334},
	{18870, 166488, 1, 1335},
	{18884, 166492, 1, 1336},
	{18898, 166496, 1, 1337},
	{18921, 166500, 1, 1337},
	{18944, 166504, 1, 1337},
	{18967, 166508, 5, 5028},
	{18988, 166512},
	{18999, 166516},
	{19012, 166520},
	{19029, 166524, 7, 5574},
	{19048, 166528},
	{19059, 166532, 2, 1351},
	{19078, 166536},
	{19100, 166540},
	{19122, 166544, 3, 5581},
	{19142, 166548, 1, 1357},
	{19191, 166560},
	{19216, 166564},
	{19241, 166568, 7, 5584},
	{19260, 166572, 1, 1370},
	{19283, 166576, 1, 1370},
	{19306, 166580, 1, 1371},
	{19320, 166584, 1, 1372},
	{19335, 166588, 8, 5591},
	{19352, 166592, 4, 1382},
	{19379, 166596, 4, 1386},
	{19406, 166600, 4, 1390},
	{19425, 166608},
	{19451, 166612, 1, 1394},
	{19476, 166620},
	{19504, 166624},
	{19530, 166628, 1, 1394},
	{19555, 166636},
	{19583, 166640},
	{19609, 166644, 1, 1394},
	{19634, 166652},
	{19662, 166656},
	{19688, 166660, 1, 1394},
	{19713, 166668},
	{19741, 166696},
	{19772, 166700},
	{19815, 166704, 1, 1395},
	{19853, 166712, 1, 1396},
	{19892, 166736, 3, 1399},
	{19914, 166740, 10, 1404},
	{19935, 166744, 3, 1423},
	{19952, 166748, 1, 1370},
	{19973, 166752, 1, 1370},
	{19996, 166756, 1, 1370},
	{20019, 166760, 1, 1370},
	{20042, 166764, 10, 5599},
	{20055, 166768, 6, 1438},
	{20072, 166772},
	{20096, 166776, 2, 1444},
	{20126, 166780},
	{20150, 166784},
	{20180, 166788},
	{20211, 166792},
	{20240, 166796},
	{20270, 166800, 2, 1446},
	{20290, 166804, 7, 5058},
	{20309, 166808, 4, 1457},
	{20359, 166868, 8, 1461},
	{20385, 166872, 8, 1469},
	{20411, 166876, 4, 1477},
	{20427, 166880, 5, 1482},
	{20443, 166884, 3, 1488},
	{20458, 166888},
	{20481, 166892},
	{20504, 166896},
	{20527, 166900},
	{20550, 166904, 8, 1491},
	{20584, 166908, 8, 1499},
	{20618, 166912, 8, 1507},
	{20652, 166916, 8, 1515},
	{20686, 166920, 8, 1491},
	{20720, 166924, 8, 1499},
	{20754, 166928, 8, 1507},
	{20788, 166932, 8, 1515},
	{20822, 166936, 8, 1491},
	{20856, 166940, 8, 1499},
	{20890, 166944, 8, 1507},
	{20924, 166948, 8, 1515},
	{20958, 166952, 8, 1491},
	{20992, 166956, 8, 1499},
	{21026, 166960, 8, 1507},
	{21060, 166964, 8, 1515},
	{21094, 166968, 2, 1523},
	{21118, 166972, 2, 1525},
	{21261, 167000, 1, 1567},
	{21289, 167004, 1, 1568},
	{21310, 167008},
	{21325, 167012, 2, 1569},
	{21341, 167016, 1, 1571},
	{21357, 167020, 2, 4989},
	{21372, 167024, 18, 5609},
	{21387, 167028, 6, 1594},
	{21404, 167032, 9, 1602},
	{21426, 167036},
	{21442, 167040, 1, 1614},
	{21464, 167044},
	{21480, 167048, 1, 1571},
	{21502, 167052},
	{21524, 167056},
	{21546, 167060},
	{21565, 167068},
	{21580, 167072, 2, 1569},
	{21596, 167076, 1, 1571},
	{21612, 167080, 2, 4989},
	{21627, 167084, 18, 5609},
	{21642, 167088, 6, 1594},
	{21659, 167092, 9, 1602},
	{21681, 167096},
	{21697, 167100, 1, 1614},
	{21719, 167104},
	{21735, 167108, 1, 1571},
	{21757, 167112},
	{21779, 167116},
	{21801, 167120},
	{21820, 167128},
	{21835, 167132, 2, 1569},
	{21851, 167136, 1, 1571},
	{21867, 167140, 2, 4989},
	{21882, 167144, 18, 5609},
	{21897, 167148, 6, 1594},
	{21914, 167152, 9, 1602},
	{21936, 167156},
	{21952, 167160, 1, 1614},
	{21974, 167164},
	{21990, 167168, 1, 1571},
	{22012, 167172},
	{22034, 167176},
	{22056, 167180},
	{22075, 167188},
	{22090, 167192, 2, 1569},
	{22106, 167196, 1, 1571},
	{22122, 167200, 2, 4989},
	{22137, 167204, 18, 5609},
	{22152, 167208, 6, 1594},
	{22169, 167212, 9, 1602},
	{22191, 167216},
	{22207, 167220, 1, 1614},
	{22229, 167224},
	{22245, 167228, 1, 1571},
	{22267, 167232},
	{22289, 167236},
	{22311, 167240},
	{22330, 167248},
	{22345, 167252, 2, 1569},
	{22361, 167256, 1, 1571},
	{22377, 167260, 2, 4989},
	{22392, 167264, 18, 5609},
	{22407, 167268, 6, 1594},
	{22424, 167272, 9, 1602},
	{22446, 167276},
	{22462, 167280, 1, 1614},
	{22484, 167284},
	{22500, 167288, 1, 1571},
	{22522, 167292},
	{22544, 167296},
	{22566, 167300},
	{22585, 167308},
	{22600, 167312, 2, 1569},
	{22616, 167316, 1, 1571},
	{22632, 167320, 2, 4989},
	{22647, 167324, 18, 5609},
	{22662, 167328, 6, 1594},
	{22679, 167332, 9, 1602},
	{22701, 167336},
	{22717, 167340, 1, 1614},
	{22739, 167344},
	{22755, 167348, 1, 1571},
	{22777, 167352},
	{22799, 167356},
	{22821, 167360},
	{22840, 167368},
	{22855, 167372, 2, 1569},
	{22871, 167376, 1, 1571},
	{22887, 167380, 2, 4989},
	{22902, 167384, 18, 5609},
	{22917, 167388, 6, 1594},
	{22934, 167392, 9, 1602},
	{22956, 167396},
	{22972, 167400, 1, 1614},
	{22994, 167404},
	{23010, 167408, 1, 1571},
	{23032, 167412},
	{23054, 167416},
	{23076, 167420},
	{23095, 167428},
	{23110, 167432, 2, 1569},
	{23126, 167436, 1, 1571},
	{23142, 167440, 2, 4989},
	{23157, 167444, 18, 5609},
	{23172, 167448, 6, 1594},
	{23189, 167452, 9, 1602},
	{23211, 167456},
	{23227, 167460, 1, 1614},
	{23249, 167464},
	{23265, 167468, 1, 1571},
	{23287, 167472},
	{23309, 167476},
	{23331, 167480},
	{24374, 196608, 1, 1627},
	{24394, 196612, 1, 1628},
	{24414, 196616},
	{24434, 196620},
	{24454, 196624},
	{24475, 196628},
	{24496, 196632, 1, 1629},
	{24518, 196636, 1, 1630},
	{24540, 196640},
	{24570, 196644},
	{24600, 196648},
	{24629, 196652},
	{24658, 196656},
	{24688, 196660},
	{24718, 196664},
	{24747, 196668},
	{24776, 196672},
	{24806, 196676},
	{24836, 196680},
	{24865, 196684},
	{24894, 196688},
	{24924, 196692},
	{24954, 196696},
	{24983, 196700},
	{25012, 196704, 1, 1631},
	{25034, 196708, 1, 1632},
	{25056, 196712},
	{25079, 196716},
	{25102, 196720},
	{25125, 196724},
	{25148, 196728},
	{25171, 196732},
	{25194, 196736},
	{25218, 196740},
	{25242, 196744},
	{25266, 196748},
	{25290, 196752},
	{25314, 196756},
	{25338, 196760},
	{25362, 196764},
	{25386, 196768},
	{25408, 196772},
	{25430, 196776},
	{25451, 196780},
	{25472, 196784},
	{25496, 196788},
	{25520, 196792},
	{25544, 196796},
	{25568, 196800},
	{25592, 196804},
	{25676, 196852, 2, 5627},
	{25698, 196856, 2, 5627},
	{25720, 196860, 1, 1635},
	{25736, 196864},
	{25749, 196868},
	{25762, 196872},
	{25775, 196876},
	{25788, 196880},
	{25801, 196884},
	{25814, 196888},
	{25827, 196892},
	{25954, 196928, 2, 1636},
	{25967, 196932},
	{25980, 196936},
	{26003, 196940},
	{26026, 196944},
	{26054, 196948},
	{26082, 196952},
	{26110, 196956},
	{26138, 196960, 1, 1638},
	{26156, 196964, 5, 5629},
	{26174, 196968},
	{26189, 196972},
	{26213, 196976},
	{26237, 196980},
	{26256, 196984},
	{26275, 196988},
	{26299, 196992},
	{26323, 196996},
	{26347, 197000},
	{26371, 197028, 2, 4215},
	{26389, 197032, 3, 5634},
	{26407, 197036},
	{26425, 197040},
	{26443, 197044, 2, 4218},
	{26461, 197048, 3, 5637},
	{26479, 197052},
	{26497, 197056, 2, 1649},
	{26516, 197060, 5, 1651},
	{26535, 197072},
	{26559, 197076, 2, 1649},
	{26579, 197080, 5, 1651},
	{26599, 197084, 8, 5640},
	{26618, 197088, 8, 5640},
	{26636, 197092, 1, 1663},
	{26653, 197100, 1, 1664},
	{26674, 197104, 26, 5648},
	{26688, 197108},
	{26702, 197112},
	{26716, 197116, 4, 4249},
	{26732, 197120},
	{26751, 197124, 1, 1680},
	{26773, 197128},
	{26792, 197132, 1, 1681},
	{26814, 197136, 9, 4255},
	{26832, 197140},
	{26852, 197144, 1, 1680},
	{26875, 197148},
	{26895, 197152, 1, 1681},
	{26918, 197156, 9, 4255},
	{26937, 197160, 5, 4264},
	{26949, 197164, 2, 1696},
	{26966, 197168, 1, 1698},
	{26983, 197172, 1, 1699},
	{27001, 197176, 4, 1700},
	{27021, 197180, 1, 1704},
	{27038, 197184},
	{27054, 197188, 1, 1706},
	{27067, 197192, 1, 1707},
	{27081, 197196, 1, 1708},
	{27095, 197200, 1, 1709},
	{27117, 197204, 1, 1710},
	{27137, 197208, 1, 1711},
	{27159, 197212, 1, 1712},
	{27179, 197216, 1, 1707},
	{27196, 197220, 1, 1708},
	{27213, 197224},
	{57989, 197228, 1, 1706},
	{27472, 197388, 1, 1721},
	{27491, 197392, 1, 1722},
	{27510, 197396, 1, 1723},
	{27527, 197400, 1, 1724},
	{27545, 197404, 1, 1725},
	{27563, 197408, 1, 1726},
	{27579, 197412, 1, 1727},
	{27597, 197416, 1, 1728},
	{27615, 197420, 1, 1729},
	{27631, 197424, 1, 1724},
	{27646, 197428, 1, 1725},
	{27661, 197432, 1, 1726},
	{27674, 197436, 1, 1727},
	{27689, 197440, 1, 1728},
	{27704, 197444, 1, 1729},
	{27717, 197448, 1, 1730},
	{27731, 197452, 1, 1731},
	{27745, 197456, 1, 1732},
	{27757, 197460, 4, 5674},
	{27780, 197464, 4, 5267},
	{27802, 197468, 1, 1740},
	{27946, 197552, 1, 1745},
	{27971, 197556, 1, 1745},
	{27995, 197560, 1, 1746},
	{28015, 197568},
	{28041, 197572, 1, 1628},
	{28070, 197576},
	{28095, 197580, 1, 1628},
	{28123, 197584},
	{28146, 197588, 1, 1628},
	{28172, 197592},
	{28194, 197596, 1, 1628},
	{28219, 197600},
	{28238, 197604, 1, 1628},
	{28260, 197608, 1, 1343},
	{28274, 197612},
	{28291, 197616, 1, 1628},
	{28311, 197620, 8, 1747},
	{28480, 198656, 6, 4121},
	{28495, 198912},
	{28514, 198916},
	{28533, 198920, 1, 4504},
	{28552, 198924, 1, 1343},
	{28567, 198928},
	{28600, 198932},
	{28633, 198936},
	{28666, 198940},
	{28756, 198960},
	{28772, 198964},
	{28790, 198968, 1, 1785},
	{28807, 198972, 2, 1786},
	{28828, 198976},
	{29160, 199168, 1, 1809},
	{29185, 199172, 2, 1810},
	{29210, 199184, 2, 1812},
	{29236, 199188, 2, 1812},
	{29262, 199192, 2, 1812},
	{29288, 199212, 2, 1812},
	{29314, 199296, 2, 1814},
	{29342, 199300, 1, 1816},
	{29366, 199304, 1, 1817},
	{29390, 199308, 1, 1818},
	{29423, 199312, 1, 1818},
	{29451, 199328, 2, 1814},
	{29480, 199332, 1, 1816},
	{29505, 199336, 1, 1817},
	{29530, 199340, 1, 1818},
	{29564, 199344, 1, 1818},
	{29593, 199360, 2, 1814},
	{29617, 199364, 1, 1816},
	{29637, 199368, 1, 1817},
	{29657, 199372, 1, 1818},
	{29686, 199376, 1, 1818},
	{54791, 199872},
	{54812, 199876, 1, 4681},
	{2266, 199880, 8, 5235},
	{2287, 199884, 3, 4690},
	{54833, 199888, 2, 4693},
	{2314, 199892, 1, 4717},
	{54859, 199896, 15, 4702},
	{55862, 199900, 1, 5244},
	{55884, 199904},
	{2245, 199908, 2, 4695},
	{2335, 199912, 5, 5247},
	{54901, 199916, 1, 4718},
	{29710, 199936},
	{29737, 199940},
	{29764, 199944},
	{29791, 199948},
	{29926, 199968, 6, 1819},
	{29937, 199972, 2, 1826},
	{29951, 200192},
	{29970, 200196, 1, 840},
	{29992, 200448},
	{30016, 200452, 1, 1828},
	{30039, 200456},
	{30063, 200460, 1, 1828},
	{30086, 200464},
	{30110, 200468, 1, 1828},
	{30133, 200472},
	{30157, 200476, 1, 1828},
	{30180, 200696},
	{30199, 200700, 1, 1828},
	{30217, 200704},
	{30229, 200708},
	{30241, 200712},
	{30259, 200716},
	{30278, 200720},
	{30296, 200724},
	{30308, 200728},
	{30320, 200732},
	{30338, 200736},
	{30356, 200740},
	{30375, 200744, 4, 1829},
	{30389, 200748, 2, 1833},
	{30407, 200752, 2, 1835},
	{30421, 200756, 2, 1837},
	{30435, 200760, 2, 1839},
	{30452, 200764, 2, 1841},
	{30469, 200768},
	{30482, 200772, 2, 1843},
	{30494, 200776},
	{30508, 200780},
	{30524, 200784},
	{30538, 200788},
	{30554, 200792},
	{30569, 200796},
	{30586, 200800},
	{30601, 200804},
	{30618, 200808, 2, 1845},
	{30640, 200812, 9, 5275},
	{30657, 200816, 2, 1857},
	{30678, 200820, 2, 1859},
	{30690, 200824},
	{30705, 200828, 6, 5678},
	{30720, 200832, 2, 1867},
	{30734, 200836},
	{30847, 212992},
	{30867, 212996},
	{30887, 213000},
	{30907, 213004},
	{30927, 213008},
	{30947, 213012},
	{30967, 213016},
	{30987, 213020},
	{31007, 213024},
	{31027, 213028},
	{31047, 213032},
	{31067, 213036},
	{31156, 213248},
	{31177, 213252},
	{31198, 213260},
	{31219, 213264},
	{31240, 213268},
	{31264, 213272},
	{31288, 213276},
	{31312, 213280},
	{31336, 213284},
	{31360, 213288},
	{31384, 213292},
	{31408, 213296},
	{55974, 213504},
	{55993, 213508},
	{56012, 213512},
	{56031, 213516},
	{56050, 213520},
	{56069, 213524},
	{56088, 213528},
	{56107, 213532},
	{53464, 213536},
	{53483, 213540},
	{53502, 213544},
	{53521, 213548},
	{53540, 213552},
	{53559, 213556},
	{53578, 213560},
	{53597, 213564},
	{54017, 213568},
	{54037, 213572},
	{54057, 213576},
	{54077, 213580},
	{54097, 213584},
	{54117, 213588},
	{54137, 213592},
	{54157, 213596},
	{31892, 214016},
	{31914, 214020, 1, 1869},
	{31936, 214024},
	{31958, 214028, 1, 1869},
	{31980, 214032},
	{32002, 214036, 1, 1869},
	{32024, 214040},
	{32046, 214044, 1, 1869},
	{32068, 214272},
	{32090, 214276},
	{32112, 214280},
	{32134, 214284},
	{32156, 214288},
	{32178, 214292},
	{32200, 214296},
	{32222, 214300},
	{32244, 214304},
	{32266, 214308},
	{32288, 214312},
	{32310, 214316},
	{32332, 214320},
	{32354, 214324},
	{32376, 214328},
	{32398, 214332},
	{32420, 214528},
	{32440, 214532},
	{32460, 214536},
	{32480, 214540},
	{32500, 214544},
	{32520, 214548},
	{32540, 214552},
	{32560, 214556},
	{32580, 214560},
	{32600, 214564},
	{32620, 214568},
	{32640, 214572},
	{32660, 214784},
	{32679, 214788},
	{32698, 214792},
	{32717, 214796},
	{32736, 214800},
	{32755, 214804},
	{32774, 214808},
	{32793, 214812},
	{32812, 214816},
	{32831, 214820},
	{32850, 214824},
	{32869, 214828},
	{32888, 214832},
	{32907, 214836},
	{32926, 214840},
	{32945, 214844},
	{32964, 214848},
	{32983, 214852},
	{33002, 214856},
	{33021, 214860},
	{33040, 214864},
	{33060, 214868},
	{33080, 214872},
	{33100, 214876},
	{33120, 214880},
	{33140, 214884},
	{33160, 214888},
	{33180, 214892},
	{33200, 214896},
	{33220, 214900},
	{33240, 214904},
	{33260, 214908},
	{33280, 215296},
	{33299, 215300},
	{33318, 215304},
	{33337, 215308},
	{33356, 215312},
	{33375, 215316},
	{33394, 215320},
	{33413, 215324},
	{33474, 215552},
	{33494, 215556},
	{33514, 215560},
	{33534, 215564},
	{33554, 215568},
	{33574, 215572},
	{33594, 215576},
	{33614, 215580},
	{33634, 215808},
	{33653, 215812},
	{33672, 215816},
	{33691, 215820},
	{33710, 216064},
	{33729, 216068},
	{33748, 216072},
	{33767, 216076},
	{33786, 216320},
	{33806, 216324},
	{33826, 216328},
	{33846, 216332},
	{33866, 216336},
	{33886, 216340},
	{33906, 216344},
	{33926, 216348},
	{56126, 216576},
	{56146, 216580},
	{56166, 216584},
	{56186, 216588},
	{56206, 216592},
	{56226, 216596},
	{56246, 216600},
	{56266, 216604},
	{56286, 216640},
	{56306, 216644},
	{56326, 216648},
	{56346, 216652},
	{56366, 216656},
	{56386, 216660},
	{56406, 216664},
	{56426, 216668},
	{34778, 217112},
	{34797, 217116},
	{34816, 217120},
	{34835, 217124},
	{34854, 217128},
	{34873, 217132},
	{34892, 217136},
	{34911, 217140},
	{34930, 217344},
	{34949, 217348},
	{34968, 217352},
	{34987, 217356},
	{35006, 217360},
	{35025, 217364},
	{35044, 217368},
	{35063, 217372},
	{35082, 217600},
	{35102, 217604},
	{35122, 217608},
	{35142, 217612},
	{36464, 221184, 1, 1903},
	{36488, 221188, 2, 5284},
	{36513, 221192, 3, 5286},
	{36537, 221196, 1, 1903},
	{36561, 221200, 2, 5284},
	{36586, 221204, 1, 1903},
	{36610, 221208, 2, 5284},
	{36635, 221212, 3, 5286},
	{36659, 221216, 4, 1881},
	{36675, 221220, 3, 5286},
	{36842, 221248},
	{36857, 221252, 1, 1818},
	{36880, 221256},
	{36903, 221260},
	{36921, 221264, 2, 1897},
	{36939, 221268, 4, 1899},
	{36959, 221440, 19, 4164},
	{36984, 221444, 19, 4164},
	{37009, 221448, 12, 4183},
	{37037, 221452, 12, 4183},
	{37065, 221456, 12, 4183},
	{37093, 221460, 12, 4183},
	{56606, 221696, 2, 4462},
	{56629, 221700, 2, 4462},
	{56652, 221704, 2, 4462},
	{56675, 221708, 2, 4462},
	{53372, 221712, 5, 1957},
	{53395, 221716, 2, 4462},
	{53418, 221720, 2, 4462},
	{53441, 221724, 2, 4462},
	{56698, 221728, 4, 1962},
	{53921, 221744, 5, 1957},
	{53945, 221748, 5, 1957},
	{53969, 221752, 2, 4462},
	{53993, 221756, 2, 4462},
	{56722, 221760, 4, 1962},
	{56747, 221764, 4, 1962},
	{53895, 221776, 1, 4503},
	{37551, 222208, 3, 1957},
	{37577, 222212, 2, 1877},
	{37604, 222216, 3, 1957},
	{37630, 222220, 2, 1877},
	{37657, 222224, 2, 2013},
	{37710, 222228, 2, 2013},
	{37763, 222464, 3, 1957},
	{37789, 222468, 2, 1877},
	{37816, 222472, 1, 1872},
	{37842, 222476, 1, 1872},
	{37868, 222480, 1, 1872},
	{37894, 222484, 1, 1872},
	{37920, 222488, 1, 1872},
	{37946, 222492, 1, 1872},
	{37972, 222496, 1, 1872},
	{37998, 222720, 3, 1957},
	{38022, 222724, 3, 1957},
	{38046, 222728, 3, 1957},
	{38070, 222732, 3, 1957},
	{38094, 222736, 2, 1877},
	{38119, 222740, 2, 1877},
	{38144, 222744, 2, 1877},
	{38169, 222748, 2, 1877},
	{38194, 222752, 1, 2001},
	{38218, 222756, 1, 2001},
	{38242, 222760, 8, 1966},
	{38263, 222976, 6, 4661},
	{38286, 222980, 6, 4661},
	{38309, 222984, 6, 4661},
	{38332, 222988, 6, 4661},
	{38355, 222992, 6, 4661},
	{38378, 222996, 6, 4661},
	{38401, 223000, 6, 4661},
	{38424, 223004, 6, 4661},
	{38447, 223008, 6, 4661},
	{38470, 223012, 6, 4661},
	{38493, 223016, 6, 4661},
	{38517, 223020, 6, 4661},
	{38541, 223024, 6, 4661},
	{38565, 223028, 6, 4661},
	{38589, 223032, 6, 4661},
	{38613, 223036, 6, 4661},
	{38637, 223104, 9, 4644},
	{56772, 223108, 2, 4693},
	{38657, 223112, 1, 1987},
	{38752, 223488, 3, 1996},
	{38775, 223492, 3, 1996},
	{38798, 223496, 3, 1996},
	{38821, 223500, 3, 1996},
	{38844, 223504, 2, 1999},
	{38868, 223508, 2, 1999},
	{38892, 223744, 3, 1996},
	{38916, 223748, 3, 1996},
	{38940, 223752, 3, 1996},
	{38964, 223756, 3, 1996},
	{38988, 223760, 2, 1999},
	{39013, 224000, 5, 2001},
	{39036, 224004, 4, 2006},
	{39060, 224008, 5, 2001},
	{39083, 224256, 5, 2001},
	{39106, 224260, 4, 2006},
	{39130, 224264, 5, 2001},
	{39153, 224512, 5, 1957},
	{39177, 224516, 4, 1962},
	{39202, 224520, 5, 1957},
	{39226, 224524, 4, 1962},
	{39251, 224528, 3, 2013},
	{39275, 224532, 3, 2013},
	{56792, 224768, 5, 1957},
	{56816, 224772, 4, 1951},
	{56841, 224776, 5, 1957},
	{56865, 224780, 4, 1951},
	{56890, 224784, 3, 2013},
	{56914, 224788, 3, 2013},
	{56938, 224832, 5, 1957},
	{56962, 224836, 4, 1951},
	{56987, 224840, 5, 1957},
	{57011, 224844, 4, 1951},
	{57036, 224848, 3, 2013},
	{57060, 224852, 3, 2013},
	{39976, 225280, 12, 2016},
	{39998, 225284, 5, 2028},
	{40021, 225288, 4, 2033},
	{40045, 225292, 2, 2037},
	{40068, 225296, 2, 2037},
	{40091, 225300, 2, 2037},
	{40114, 225536, 5, 1957},
	{40137, 225540, 4, 1962},
	{40161, 225544, 5, 1957},
	{40184, 225548, 4, 1962},
	{40208, 225552, 5, 1957},
	{40231, 225560, 5, 1957},
	{40254, 225792, 4, 2039},
	{40275, 225796},
	{40304, 225800, 2, 2043},
	{40333, 225804},
	{40359, 225808, 7, 2045},
	{40433, 225812},
	{40456, 225816},
	{57205, 225820, 2, 5295},
	{57238, 225824, 2, 5295},
	{57271, 225828, 2, 5295},
	{57304, 225832, 2, 5295},
	{57336, 225836, 2, 5295},
	{57368, 225840, 2, 5295},
	{57400, 225844, 2, 5295},
	{57433, 225848, 2, 5295},
	{57465, 225856, 2, 5295},
	{57497, 225860, 2, 5295},
	{57530, 225864, 2, 5295},
	{57563, 225868, 2, 5295},
	{57596, 225872, 2, 5295},
	{57628, 225876, 2, 5295},
	{57660, 225880, 2, 5295},
	{57693, 225884, 2, 5295},
	{57726, 225888, 2, 5295},
	{57792, 225896, 2, 5295},
	{40479, 225900},
	{40506, 225904},
	{40388, 225908},
	{40407, 225912},
	{57824, 225916, 2, 5295},
	{57858, 225920, 2, 5295},
	{57892, 225924, 2, 5295},
	{57926, 225928, 2, 5295},
	{41376, 226044, 1, 2129},
	{41169, 226048, 2, 2119},
	{41186, 226052, 1, 2121},
	{41210, 226056, 1, 2121},
	{206, 880, 4, 2156},
	{42955, 881},
	{26802, 882},
	{42967, 1008},
	{42978, 1009},
	{26990, 1010, 4, 2160},
	{42989, 1040, 1, 2164},
	{43002, 1041, 5, 5297},
	{43015, 1042, 1, 2170},
	{43028, 1043, 1, 1681},
	{26824, 1045, 9, 5089},
	{43056, 1280, 6, 5302},
	{43071, 1281},
	{26761, 1282},
	{42955, 1283},
	{26802, 1284},
};

static const struct si_reg gfx81_reg_table[] = {
	{1145, 68, 10, 5308},
	{1158, 72, 23, 5318},
	{1173, 76, 4, 5341},
	{52194, 80, 11, 5114},
	{1210, 84, 4, 3975},
	{1228, 88, 2, 3979},
	{1246, 92, 6, 5345},
	{1261, 96},
	{1275, 100, 1, 70},
	{1289, 104},
	{52208, 108},
	{52225, 112, 13, 5351},
	{1306, 116, 5, 5364},
	{52241, 2480},
	{52256, 2484, 1, 3999},
	{52271, 2488},
	{52286, 2492, 1, 3999},
	{1444, 2496},
	{1458, 2500},
	{1472, 2504},
	{1486, 2508},
	{1500, 2512},
	{1514, 2516},
	{1528, 2520},
	{1542, 2524},
	{1556, 2528},
	{1570, 2532},
	{1584, 2536},
	{1599, 2540},
	{1674, 2544},
	{1685, 2552},
	{1701, 2556},
	{52301, 3660, 21, 4000},
	{52314, 3664, 20, 4021},
	{52326, 3668, 16, 4041},
	{1789, 32776, 18, 5369},
	{1802, 32784, 24, 4079},
	{1814, 32788, 11, 4103},
	{1830, 32792, 11, 4103},
	{1859, 32824, 11, 4103},
	{1875, 32828, 11, 4103},
	{1891, 33296, 15, 5387},
	{1905, 33300, 28, 204},
	{1922, 33304, 14, 5402},
	{1943, 33308, 21, 5416},
	{1957, 33312, 31, 5197},
	{1974, 33316, 9, 5437},
	{2013, 33324, 1, 329},
	{2036, 33344, 1, 330},
	{2057, 33348},
	{2118, 33436, 1, 342},
	{54880, 36416},
	{2522, 36608},
	{2540, 36612, 4, 383},
	{2558, 36616},
	{2576, 36620, 14, 5446},
	{3477, 36624},
	{3495, 36628, 5, 5684},
	{3513, 36632, 4, 4762},
	{3531, 36636, 11, 4766},
	{3549, 36640, 2, 4777},
	{3567, 36644, 2, 4779},
	{3585, 36648, 8, 5465},
	{3603, 36652},
	{2594, 36656, 14, 5473},
	{2612, 36660, 4, 411},
	{2630, 36664, 10, 5487},
	{2648, 36668, 3, 4807},
	{2666, 37120, 6, 429},
	{2682, 39160, 9, 4810},
	{2697, 39184, 5, 4820},
	{2711, 39188, 5, 4820},
	{2725, 39192, 5, 4820},
	{2739, 39196, 5, 4820},
	{2753, 39200, 5, 4820},
	{2767, 39204, 5, 4820},
	{2781, 39208, 5, 4820},
	{2795, 39212, 5, 4820},
	{2809, 39216, 5, 4820},
	{2823, 39220, 5, 4820},
	{2837, 39224, 5, 4820},
	{2852, 39228, 5, 4820},
	{2867, 39232, 5, 4820},
	{2882, 39236, 5, 4820},
	{2897, 39240, 5, 4820},
	{2912, 39244, 5, 4820},
	{2927, 39248, 5, 4820},
	{2942, 39252, 5, 4820},
	{2957, 39256, 5, 4820},
	{2972, 39260, 5, 4820},
	{2987, 39264, 5, 4820},
	{3002, 39268, 5, 4820},
	{3017, 39272, 5, 4820},
	{3032, 39276, 5, 4820},
	{3047, 39280, 5, 4820},
	{3062, 39284, 5, 4820},
	{3077, 39288, 5, 4820},
	{3092, 39292, 5, 4820},
	{3107, 39296, 5, 4820},
	{3122, 39300, 5, 4820},
	{3137, 39304, 5, 4820},
	{3152, 39308, 5, 4820},
	{3167, 39312, 4, 448},
	{3186, 39316, 4, 448},
	{3205, 39320, 4, 448},
	{3224, 39324, 4, 448},
	{3243, 39328, 4, 448},
	{3262, 39332, 4, 448},
	{3281, 39336, 4, 448},
	{3300, 39340, 4, 448},
	{3319, 39344, 4, 448},
	{3338, 39348, 4, 448},
	{3357, 39352, 4, 448},
	{3377, 39356, 4, 448},
	{3397, 39360, 4, 448},
	{3417, 39364, 4, 448},
	{3437, 39368, 4, 448},
	{3457, 39372, 4, 448},
	{55114, 45056},
	{55135, 45060, 1, 491},
	{55156, 45064},
	{55177, 45068, 1, 491},
	{3670, 45084, 3, 488},
	{3694, 45088},
	{3715, 45092, 1, 491},
	{3736, 45096, 11, 4825},
	{3760, 45100, 6, 503},
	{3784, 45104},
	{3810, 45108},
	{3836, 45112},
	{3862, 45116},
	{3888, 45120},
	{3914, 45124},
	{3940, 45128},
	{3966, 45132},
	{3992, 45136},
	{4018, 45140},
	{4044, 45144},
	{4071, 45148},
	{4098, 45152},
	{4125, 45156},
	{4152, 45160},
	{4179, 45164},
	{55198, 45312},
	{55219, 45316, 1, 491},
	{55240, 45320},
	{55261, 45324, 1, 491},
	{4851, 45336, 3, 488},
	{4875, 45340, 1, 527},
	{4900, 45344},
	{4921, 45348, 1, 491},
	{4942, 45352, 12, 4842},
	{4966, 45356, 11, 5497},
	{4990, 45360},
	{5016, 45364},
	{5042, 45368},
	{5068, 45372},
	{5094, 45376},
	{5120, 45380},
	{5146, 45384},
	{5172, 45388},
	{5198, 45392},
	{5224, 45396},
	{5250, 45400},
	{5277, 45404},
	{5304, 45408},
	{5331, 45412},
	{5358, 45416},
	{5385, 45420},
	{6035, 45552, 6, 563},
	{6062, 45556, 5, 569},
	{55282, 45568},
	{55303, 45572, 1, 491},
	{55324, 45576},
	{55345, 45580, 1, 491},
	{6250, 45596, 4, 576},
	{6274, 45600},
	{6295, 45604, 1, 491},
	{6316, 45608, 11, 4864},
	{6340, 45612, 4, 554},
	{6364, 45616},
	{6390, 45620},
	{6416, 45624},
	{6442, 45628},
	{6468, 45632},
	{6494, 45636},
	{6520, 45640},
	{6546, 45644},
	{6572, 45648},
	{6598, 45652},
	{6624, 45656},
	{6651, 45660},
	{6678, 45664},
	{6705, 45668},
	{6732, 45672},
	{6759, 45676},
	{7394, 45808, 6, 563},
	{55366, 45824},
	{55387, 45828, 1, 491},
	{55408, 45832},
	{55429, 45836, 1, 491},
	{7421, 45852, 4, 576},
	{7445, 45856},
	{7466, 45860, 1, 491},
	{7487, 45864, 12, 4842},
	{7511, 45868, 6, 563},
	{7535, 45872},
	{7561, 45876},
	{7587, 45880},
	{7613, 45884},
	{7639, 45888},
	{7665, 45892},
	{7691, 45896},
	{7717, 45900},
	{7743, 45904},
	{7769, 45908},
	{7795, 45912},
	{7822, 45916},
	{7849, 45920},
	{7876, 45924},
	{7903, 45928},
	{7930, 45932},
	{7957, 46068, 5, 569},
	{55450, 46080},
	{55471, 46084, 1, 491},
	{55492, 46088},
	{55513, 46092, 1, 491},
	{8145, 46108, 3, 612},
	{8169, 46112},
	{8190, 46116, 1, 491},
	{8211, 46120, 10, 4885},
	{8235, 46124, 6, 628},
	{8259, 46128},
	{8285, 46132},
	{8311, 46136},
	{8337, 46140},
	{8363, 46144},
	{8389, 46148},
	{8415, 46152},
	{8441, 46156},
	{8467, 46160},
	{8493, 46164},
	{8519, 46168},
	{8546, 46172},
	{8573, 46176},
	{8600, 46180},
	{8627, 46184},
	{8654, 46188},
	{9289, 46324, 5, 569},
	{55534, 46336},
	{55555, 46340, 1, 491},
	{55576, 46344},
	{55597, 46348, 1, 491},
	{9316, 46364, 4, 576},
	{9340, 46368},
	{9361, 46372, 1, 491},
	{9382, 46376, 11, 4901},
	{9406, 46380, 5, 569},
	{9430, 46384},
	{9456, 46388},
	{9482, 46392},
	{9508, 46396},
	{9534, 46400},
	{9560, 46404},
	{9586, 46408},
	{9612, 46412},
	{9638, 46416},
	{9664, 46420},
	{9690, 46424},
	{9717, 46428},
	{9744, 46432},
	{9771, 46436},
	{9798, 46440},
	{9825, 46444},
	{9852, 47104, 12, 4917},
	{9879, 47108},
	{9893, 47112},
	{9907, 47116},
	{9921, 47120},
	{9937, 47124},
	{9953, 47128},
	{9969, 47132, 2, 659},
	{9990, 47136, 2, 659},
	{10011, 47140, 2, 659},
	{10032, 47144, 1, 661},
	{10060, 47148, 1, 662},
	{10085, 47152},
	{10100, 47156, 2, 4930},
	{55638, 47160},
	{55653, 47164, 1, 663},
	{55668, 47168},
	{55683, 47172, 1, 663},
	{10239, 47176, 10, 4932},
	{10257, 47180, 11, 676},
	{10275, 47184, 1, 687},
	{10288, 47188, 6, 688},
	{55698, 47192, 2, 4949},
	{55729, 47196, 2, 4949},
	{10366, 47200, 2, 694},
	{55912, 47204, 2, 4949},
	{55943, 47208, 2, 4949},
	{10441, 47212},
	{10459, 47216},
	{10477, 47220},
	{10495, 47224, 1, 696},
	{10523, 47228, 5, 697},
	{10545, 47232},
	{10565, 47236},
	{10748, 47240, 3, 713},
	{10765, 47244},
	{10794, 47248, 1, 716},
	{57960, 47252, 2, 5508},
	{10841, 47360},
	{10861, 47364},
	{10881, 47368},
	{10901, 47372},
	{10921, 47376},
	{10941, 47380},
	{10961, 47384},
	{10981, 47388},
	{11001, 47392},
	{11021, 47396},
	{11041, 47400},
	{11062, 47404},
	{11083, 47408},
	{11104, 47412},
	{11125, 47416},
	{11146, 47420},
	{11212, 47612},
	{55760, 53300, 29, 4951},
	{55777, 55348, 29, 4951},
	{11228, 163840, 10, 719},
	{11246, 163844, 9, 4980},
	{11263, 163848, 4, 4989},
	{11277, 163852, 23, 747},
	{11296, 163856, 15, 770},
	{11316, 163860},
	{11352, 163872},
	{11372, 163876},
	{11392, 163880, 1, 788},
	{11409, 163884},
	{11424, 163888, 2, 789},
	{11448, 163892, 2, 791},
	{55794, 163900, 7, 4993},
	{11506, 163904, 10, 5510},
	{11516, 163908, 6, 5520},
	{11532, 163912},
	{11547, 163916},
	{11568, 163920},
	{11584, 163924},
	{55808, 163928, 2, 5013},
	{55822, 163932, 1, 5015},
	{11774, 163968},
	{11790, 163972, 1, 840},
	{11809, 164328, 1, 841},
	{11830, 164332, 1, 841},
	{11851, 164336, 1, 841},
	{11872, 164340, 1, 841},
	{11893, 164344},
	{11911, 164348},
	{11929, 164352, 2, 842},
	{11949, 164356, 3, 844},
	{11973, 164360, 2, 847},
	{11997, 164364, 1, 849},
	{12017, 164368, 2, 844},
	{12037, 164372, 2, 847},
	{12057, 164376, 2, 844},
	{12077, 164380, 2, 847},
	{12097, 164384, 2, 844},
	{12117, 164388, 2, 847},
	{12137, 164392, 2, 844},
	{12157, 164396, 2, 847},
	{12177, 164400, 7, 850},
	{12192, 164404, 2, 857},
	{12221, 164408, 8, 859},
	{12236, 164412, 8, 867},
	{12251, 164416, 3, 844},
	{12276, 164420, 2, 847},
	{12301, 164424},
	{12319, 164428},
	{12337, 164432, 3, 844},
	{12362, 164436, 2, 847},
	{12387, 164440, 3, 844},
	{12412, 164444, 2, 847},
	{12437, 164448, 3, 844},
	{12462, 164452, 2, 847},
	{12487, 164456, 3, 844},
	{12512, 164460, 2, 847},
	{12537, 164464, 3, 844},
	{12562, 164468, 2, 847},
	{12587, 164472, 3, 844},
	{12612, 164476, 2, 847},
	{12637, 164480, 3, 844},
	{12662, 164484, 2, 847},
	{12687, 164488, 3, 844},
	{12712, 164492, 2, 847},
	{12737, 164496, 3, 844},
	{12762, 164500, 2, 847},
	{12787, 164504, 3, 844},
	{12812, 164508, 2, 847},
	{12837, 164512, 3, 844},
	{12863, 164516, 2, 847},
	{12889, 164520, 3, 844},
	{12915, 164524, 2, 847},
	{12941, 164528, 3, 844},
	{12967, 164532, 2, 847},
	{12993, 164536, 3, 844},
	{13019, 164540, 2, 847},
	{13045, 164544, 3, 844},
	{13071, 164548, 2, 847},
	{13097, 164552, 3, 844},
	{13123, 164556, 2, 847},
	{13149, 164560},
	{13168, 164564},
	{13187, 164568},
	{13206, 164572},
	{13225, 164576},
	{13244, 164580},
	{13263, 164584},
	{13282, 164588},
	{13301, 164592},
	{13320, 164596},
	{13339, 164600},
	{13358, 164604},
	{13377, 164608},
	{13396, 164612},
	{13415, 164616},
	{13434, 164620},
	{13453, 164624},
	{13472, 164628},
	{13491, 164632},
	{13510, 164636},
	{13529, 164640},
	{13549, 164644},
	{13569, 164648},
	{13589, 164652},
	{13609, 164656},
	{13629, 164660},
	{13649, 164664},
	{13669, 164668},
	{13689, 164672},
	{13709, 164676},
	{13729, 164680},
	{13749, 164684},
	{13769, 164688, 15, 875},
	{13789, 164692, 3, 890},
	{13811, 164696, 2, 893},
	{13868, 164704, 1, 902},
	{55837, 164708, 1, 5016},
	{13899, 164712, 1, 904},
	{13967, 164864},
	{13984, 164868},
	{14001, 164872},
	{14017, 164876},
	{14071, 164884},
	{14084, 164888},
	{14099, 164892},
	{14113, 164896},
	{14128, 164900, 3, 5526},
	{14167, 164908, 6, 935},
	{14186, 164912, 4, 941},
	{14204, 164916, 4, 945},
	{14225, 164924},
	{14244, 164928},
	{14264, 164932},
	{14283, 164936},
	{14303, 164940},
	{14322, 164944},
	{14342, 164948},
	{14363, 164952},
	{14385, 164956},
	{14406, 164960},
	{14428, 164964},
	{14449, 164968},
	{14471, 164972},
	{14492, 164976},
	{14514, 164980},
	{14535, 164984},
	{14557, 164988},
	{14578, 164992},
	{14600, 164996},
	{14621, 165000},
	{14643, 165004},
	{14664, 165008},
	{14686, 165012},
	{14707, 165016},
	{14729, 165020},
	{14750, 165024},
	{14772, 165028},
	{14793, 165032},
	{14815, 165036},
	{14836, 165040},
	{14858, 165044},
	{14879, 165048},
	{14901, 165052},
	{14922, 165056},
	{14944, 165060},
	{14965, 165064},
	{14987, 165068},
	{15008, 165072},
	{15030, 165076},
	{15051, 165080},
	{15073, 165084},
	{15094, 165088},
	{15116, 165092},
	{15137, 165096},
	{15159, 165100},
	{15180, 165104},
	{15202, 165108},
	{15223, 165112},
	{15245, 165116},
	{15266, 165120},
	{15288, 165124},
	{15309, 165128},
	{15331, 165132},
	{15352, 165136},
	{15374, 165140},
	{15395, 165144},
	{15417, 165148},
	{15438, 165152},
	{15460, 165156},
	{15481, 165160},
	{15503, 165164},
	{15525, 165168},
	{15548, 165172},
	{15570, 165176},
	{15593, 165180},
	{15615, 165184},
	{15638, 165188},
	{15660, 165192},
	{15683, 165196},
	{15705, 165200},
	{15728, 165204},
	{15750, 165208},
	{15773, 165212},
	{15795, 165216},
	{15818, 165220},
	{15840, 165224},
	{15863, 165228},
	{15885, 165232},
	{15908, 165236},
	{15930, 165240},
	{15953, 165244},
	{15975, 165248},
	{15998, 165252},
	{16020, 165256},
	{16043, 165260},
	{16065, 165264},
	{16088, 165268},
	{16110, 165272},
	{16133, 165276},
	{16155, 165280},
	{16178, 165284},
	{16200, 165288},
	{16223, 165292},
	{16245, 165296},
	{16268, 165300},
	{16290, 165304},
	{16313, 165308},
	{16327, 165312},
	{16341, 165316},
	{16355, 165320},
	{16369, 165324},
	{16383, 165328},
	{16397, 165332},
	{16411, 165336},
	{16425, 165340},
	{16439, 165344},
	{16453, 165348},
	{16467, 165352},
	{16481, 165356},
	{16495, 165360},
	{16509, 165364},
	{16523, 165368},
	{16537, 165372},
	{16551, 165376},
	{16565, 165380},
	{16579, 165384},
	{16593, 165388},
	{16607, 165392},
	{16621, 165396},
	{16635, 165400},
	{16672, 165444, 12, 949},
	{16692, 165448, 12, 949},
	{16712, 165452, 12, 949},
	{16732, 165456, 12, 949},
	{16752, 165460, 12, 949},
	{16772, 165464, 12, 949},
	{16792, 165468, 12, 949},
	{16812, 165472, 12, 949},
	{16832, 165476, 12, 949},
	{16852, 165480, 12, 949},
	{16872, 165484, 12, 949},
	{16893, 165488, 12, 949},
	{16914, 165492, 12, 949},
	{16935, 165496, 12, 949},
	{16956, 165500, 12, 949},
	{16977, 165504, 12, 949},
	{16998, 165508, 12, 949},
	{17019, 165512, 12, 949},
	{17040, 165516, 12, 949},
	{17061, 165520, 12, 949},
	{17082, 165524, 9, 961},
	{17103, 165528, 9, 961},
	{17124, 165532, 9, 961},
	{17145, 165536, 9, 961},
	{17166, 165540, 9, 961},
	{17187, 165544, 9, 961},
	{17208, 165548, 9, 961},
	{17229, 165552, 9, 961},
	{17250, 165556, 9, 961},
	{17271, 165560, 9, 961},
	{17292, 165564, 9, 961},
	{17313, 165568, 9, 961},
	{17334, 165572, 2, 970},
	{17352, 165580, 16, 973},
	{17369, 165584, 16, 973},
	{17387, 165588, 7, 989},
	{17408, 165592, 3, 5017},
	{17426, 165600, 7, 1002},
	{17441, 165608, 2, 694},
	{17480, 165644, 4, 1010},
	{17502, 165648, 1, 1015},
	{17522, 165652, 8, 1016},
	{17544, 165716, 8, 1024},
	{17562, 165720, 8, 1032},
	{17583, 165724, 17, 1040},
	{17604, 165728, 6, 1057},
	{17622, 165732, 6, 1057},
	{17640, 165736, 6, 1057},
	{17658, 165740, 6, 1057},
	{17676, 165744, 6, 1057},
	{17694, 165748, 6, 1057},
	{17712, 165752, 6, 1057},
	{17730, 165756, 6, 1057},
	{17748, 165760, 9, 1063},
	{17766, 165764, 9, 1063},
	{17784, 165768, 9, 1063},
	{17802, 165772, 9, 1063},
	{17820, 165776, 9, 1063},
	{17838, 165780, 9, 1063},
	{17856, 165784, 9, 1063},
	{17874, 165788, 9, 1063},
	{17892, 165836, 1, 1072},
	{17906, 165840, 1, 1072},
	{17921, 165844},
	{17939, 165848},
	{17957, 165852},
	{17974, 165856},
	{17995, 165860, 1, 5020},
	{18011, 165864},
	{18024, 165872, 5, 1074},
	{18043, 165876},
	{18058, 165880, 1, 1082},
	{18107, 165888, 10, 1084},
	{18124, 165892, 12, 1094},
	{18132, 165896, 4, 5689},
	{18149, 165900, 13, 1110},
	{18167, 165904, 19, 1127},
	{18183, 165908, 13, 1147},
	{18202, 165912, 10, 1163},
	{18217, 165916, 27, 5532},
	{18235, 165920, 16, 1201},
	{18253, 165924, 4, 1217},
	{18277, 165928},
	{18302, 165932, 11, 1221},
	{18454, 166400, 2, 1253},
	{18471, 166404, 2, 1255},
	{18490, 166408, 1, 1257},
	{18506, 166412, 4, 1258},
	{18525, 166416, 1, 1262},
	{18546, 166420, 1, 1263},
	{18559, 166424},
	{18582, 166428},
	{18605, 166432, 1, 1264},
	{18625, 166436, 4, 5024},
	{18645, 166440, 1, 1269},
	{18666, 166444, 1, 1270},
	{18681, 166448, 6, 1271},
	{18703, 166452, 6, 1271},
	{18725, 166456, 8, 1277},
	{18751, 166460, 8, 1277},
	{18777, 166464, 15, 5559},
	{18789, 166468, 2, 1300},
	{18808, 166472, 4, 1303},
	{18826, 166476, 24, 1310},
	{18844, 166480},
	{18856, 166484, 1, 1334},
	{18870, 166488, 1, 1335},
	{18884, 166492, 1, 1336},
	{18898, 166496, 1, 1337},
	{18921, 166500, 1, 1337},
	{18944, 166504, 1, 1337},
	{18967, 166508, 5, 5028},
	{18988, 166512},
	{18999, 166516},
	{19012, 166520},
	{19029, 166524, 7, 5574},
	{19048, 166528},
	{19059, 166532, 2, 1351},
	{19078, 166536},
	{19100, 166540},
	{19122, 166544, 3, 5581},
	{19142, 166548, 1, 1357},
	{19191, 166560},
	{19216, 166564},
	{19241, 166568, 7, 5584},
	{19260, 166572, 1, 1370},
	{19283, 166576, 1, 1370},
	{19306, 166580, 1, 1371},
	{19320, 166584, 1, 1372},
	{19335, 166588, 8, 5591},
	{19352, 166592, 4, 1382},
	{19379, 166596, 4, 1386},
	{19406, 166600, 4, 1390},
	{19425, 166608},
	{19451, 166612, 1, 1394},
	{19476, 166620},
	{19504, 166624},
	{19530, 166628, 1, 1394},
	{19555, 166636},
	{19583, 166640},
	{19609, 166644, 1, 1394},
	{19634, 166652},
	{19662, 166656},
	{19688, 166660, 1, 1394},
	{19713, 166668},
	{19741, 166696},
	{19772, 166700},
	{19815, 166704, 1, 1395},
	{19853, 166712, 1, 1396},
	{19892, 166736, 4, 5693},
	{19914, 166740, 10, 1404},
	{19935, 166744, 3, 1423},
	{19952, 166748, 1, 1370},
	{19973, 166752, 1, 1370},
	{19996, 166756, 1, 1370},
	{20019, 166760, 1, 1370},
	{20042, 166764, 10, 5599},
	{20055, 166768, 6, 1438},
	{20072, 166772},
	{20096, 166776, 2, 1444},
	{20126, 166780},
	{20150, 166784},
	{20180, 166788},
	{20211, 166792},
	{20240, 166796},
	{20270, 166800, 2, 1446},
	{20290, 166804, 7, 5058},
	{20309, 166808, 4, 1457},
	{20359, 166868, 8, 1461},
	{20385, 166872, 8, 1469},
	{20411, 166876, 4, 1477},
	{20427, 166880, 5, 1482},
	{20443, 166884, 3, 1488},
	{20458, 166888},
	{20481, 166892},
	{20504, 166896},
	{20527, 166900},
	{20550, 166904, 8, 1491},
	{20584, 166908, 8, 1499},
	{20618, 166912, 8, 1507},
	{20652, 166916, 8, 1515},
	{20686, 166920, 8, 1491},
	{20720, 166924, 8, 1499},
	{20754, 166928, 8, 1507},
	{20788, 166932, 8, 1515},
	{20822, 166936, 8, 1491},
	{20856, 166940, 8, 1499},
	{20890, 166944, 8, 1507},
	{20924, 166948, 8, 1515},
	{20958, 166952, 8, 1491},
	{20992, 166956, 8, 1499},
	{21026, 166960, 8, 1507},
	{21060, 166964, 8, 1515},
	{21094, 166968, 2, 1523},
	{21118, 166972, 2, 1525},
	{21142, 166976, 1, 1527},
	{21261, 167000, 1, 1567},
	{21289, 167004, 1, 1568},
	{21310, 167008},
	{21325, 167012, 2, 1569},
	{21341, 167016, 1, 1571},
	{21357, 167020, 2, 4989},
	{21372, 167024, 18, 5697},
	{21387, 167028, 6, 1594},
	{21404, 167032, 9, 1602},
	{21426, 167036},
	{21442, 167040, 1, 1614},
	{21464, 167044},
	{21480, 167048, 1, 1571},
	{21502, 167052},
	{21524, 167056},
	{21546, 167060},
	{21565, 167068},
	{21580, 167072, 2, 1569},
	{21596, 167076, 1, 1571},
	{21612, 167080, 2, 4989},
	{21627, 167084, 18, 5697},
	{21642, 167088, 6, 1594},
	{21659, 167092, 9, 1602},
	{21681, 167096},
	{21697, 167100, 1, 1614},
	{21719, 167104},
	{21735, 167108, 1, 1571},
	{21757, 167112},
	{21779, 167116},
	{21801, 167120},
	{21820, 167128},
	{21835, 167132, 2, 1569},
	{21851, 167136, 1, 1571},
	{21867, 167140, 2, 4989},
	{21882, 167144, 18, 5697},
	{21897, 167148, 6, 1594},
	{21914, 167152, 9, 1602},
	{21936, 167156},
	{21952, 167160, 1, 1614},
	{21974, 167164},
	{21990, 167168, 1, 1571},
	{22012, 167172},
	{22034, 167176},
	{22056, 167180},
	{22075, 167188},
	{22090, 167192, 2, 1569},
	{22106, 167196, 1, 1571},
	{22122, 167200, 2, 4989},
	{22137, 167204, 18, 5697},
	{22152, 167208, 6, 1594},
	{22169, 167212, 9, 1602},
	{22191, 167216},
	{22207, 167220, 1, 1614},
	{22229, 167224},
	{22245, 167228, 1, 1571},
	{22267, 167232},
	{22289, 167236},
	{22311, 167240},
	{22330, 167248},
	{22345, 167252, 2, 1569},
	{22361, 167256, 1, 1571},
	{22377, 167260, 2, 4989},
	{22392, 167264, 18, 5697},
	{22407, 167268, 6, 1594},
	{22424, 167272, 9, 1602},
	{22446, 167276},
	{22462, 167280, 1, 1614},
	{22484, 167284},
	{22500, 167288, 1, 1571},
	{22522, 167292},
	{22544, 167296},
	{22566, 167300},
	{22585, 167308},
	{22600, 167312, 2, 1569},
	{22616, 167316, 1, 1571},
	{22632, 167320, 2, 4989},
	{22647, 167324, 18, 5697},
	{22662, 167328, 6, 1594},
	{22679, 167332, 9, 1602},
	{22701, 167336},
	{22717, 167340, 1, 1614},
	{22739, 167344},
	{22755, 167348, 1, 1571},
	{22777, 167352},
	{22799, 167356},
	{22821, 167360},
	{22840, 167368},
	{22855, 167372, 2, 1569},
	{22871, 167376, 1, 1571},
	{22887, 167380, 2, 4989},
	{22902, 167384, 18, 5697},
	{22917, 167388, 6, 1594},
	{22934, 167392, 9, 1602},
	{22956, 167396},
	{22972, 167400, 1, 1614},
	{22994, 167404},
	{23010, 167408, 1, 1571},
	{23032, 167412},
	{23054, 167416},
	{23076, 167420},
	{23095, 167428},
	{23110, 167432, 2, 1569},
	{23126, 167436, 1, 1571},
	{23142, 167440, 2, 4989},
	{23157, 167444, 18, 5697},
	{23172, 167448, 6, 1594},
	{23189, 167452, 9, 1602},
	{23211, 167456},
	{23227, 167460, 1, 1614},
	{23249, 167464},
	{23265, 167468, 1, 1571},
	{23287, 167472},
	{23309, 167476},
	{23331, 167480},
	{24374, 196608, 1, 1627},
	{24394, 196612, 1, 1628},
	{24414, 196616},
	{24434, 196620},
	{24454, 196624},
	{24475, 196628},
	{24496, 196632, 1, 1629},
	{24518, 196636, 1, 1630},
	{24540, 196640},
	{24570, 196644},
	{24600, 196648},
	{24629, 196652},
	{24658, 196656},
	{24688, 196660},
	{24718, 196664},
	{24747, 196668},
	{24776, 196672},
	{24806, 196676},
	{24836, 196680},
	{24865, 196684},
	{24894, 196688},
	{24924, 196692},
	{24954, 196696},
	{24983, 196700},
	{25012, 196704, 1, 1631},
	{25034, 196708, 1, 1632},
	{25056, 196712},
	{25079, 196716},
	{25102, 196720},
	{25125, 196724},
	{25148, 196728},
	{25171, 196732},
	{25194, 196736},
	{25218, 196740},
	{25242, 196744},
	{25266, 196748},
	{25290, 196752},
	{25314, 196756},
	{25338, 196760},
	{25362, 196764},
	{25386, 196768},
	{25408, 196772},
	{25430, 196776},
	{25451, 196780},
	{25472, 196784},
	{25496, 196788},
	{25520, 196792},
	{25544, 196796},
	{25568, 196800},
	{25592, 196804},
	{25676, 196852, 2, 5627},
	{25698, 196856, 2, 5627},
	{25720, 196860, 1, 1635},
	{25736, 196864},
	{25749, 196868},
	{25762, 196872},
	{25775, 196876},
	{25788, 196880},
	{25801, 196884},
	{25814, 196888},
	{25827, 196892},
	{25954, 196928, 2, 1636},
	{25967, 196932},
	{25980, 196936},
	{26003, 196940},
	{26026, 196944},
	{26054, 196948},
	{26082, 196952},
	{26110, 196956},
	{26138, 196960, 1, 1638},
	{26156, 196964, 5, 5629},
	{26174, 196968},
	{26189, 196972},
	{26213, 196976},
	{26237, 196980},
	{26256, 196984},
	{26275, 196988},
	{26299, 196992},
	{26323, 196996},
	{26347, 197000},
	{26371, 197028, 2, 4215},
	{26389, 197032, 3, 5634},
	{26407, 197036},
	{26425, 197040},
	{26443, 197044, 2, 4218},
	{26461, 197048, 3, 5637},
	{26479, 197052},
	{26497, 197056, 2, 1649},
	{26516, 197060, 5, 1651},
	{26535, 197072},
	{26559, 197076, 2, 1649},
	{26579, 197080, 5, 1651},
	{26599, 197084, 8, 5640},
	{26618, 197088, 8, 5640},
	{26636, 197092, 1, 1663},
	{26653, 197100, 1, 1664},
	{26674, 197104, 26, 5648},
	{26688, 197108},
	{26702, 197112},
	{26716, 197116, 4, 4249},
	{26732, 197120},
	{26751, 197124, 1, 1680},
	{26773, 197128},
	{26792, 197132, 1, 1681},
	{26814, 197136, 9, 4255},
	{26832, 197140},
	{26852, 197144, 1, 1680},
	{26875, 197148},
	{26895, 197152, 1, 1681},
	{26918, 197156, 9, 4255},
	{26937, 197160, 5, 4264},
	{26949, 197164, 2, 1696},
	{26966, 197168, 1, 1698},
	{26983, 197172, 1, 1699},
	{27001, 197176, 4, 1700},
	{27021, 197180, 1, 1704},
	{27038, 197184},
	{27054, 197188, 1, 1706},
	{27067, 197192, 1, 1707},
	{27081, 197196, 1, 1708},
	{27095, 197200, 1, 1709},
	{27117, 197204, 1, 1710},
	{27137, 197208, 1, 1711},
	{27159, 197212, 1, 1712},
	{27179, 197216, 1, 1707},
	{27196, 197220, 1, 1708},
	{27213, 197224},
	{57989, 197228, 1, 1706},
	{27472, 197388, 1, 1721},
	{27491, 197392, 1, 1722},
	{27510, 197396, 1, 1723},
	{27527, 197400, 1, 1724},
	{27545, 197404, 1, 1725},
	{27563, 197408, 1, 1726},
	{27579, 197412, 1, 1727},
	{27597, 197416, 1, 1728},
	{27615, 197420, 1, 1729},
	{27631, 197424, 1, 1724},
	{27646, 197428, 1, 1725},
	{27661, 197432, 1, 1726},
	{27674, 197436, 1, 1727},
	{27689, 197440, 1, 1728},
	{27704, 197444, 1, 1729},
	{27717, 197448, 1, 1730},
	{27731, 197452, 1, 1731},
	{27745, 197456, 1, 1732},
	{27757, 197460, 4, 5674},
	{27780, 197464, 4, 5267},
	{27802, 197468, 1, 1740},
	{27946, 197552, 1, 1745},
	{27971, 197556, 1, 1745},
	{27995, 197560, 1, 1746},
	{28015, 197568},
	{28041, 197572, 1, 1628},
	{28070, 197576},
	{28095, 197580, 1, 1628},
	{28123, 197584},
	{28146, 197588, 1, 1628},
	{28172, 197592},
	{28194, 197596, 1, 1628},
	{28219, 197600},
	{28238, 197604, 1, 1628},
	{28260, 197608, 1, 1343},
	{28274, 197612},
	{28291, 197616, 1, 1628},
	{28311, 197620, 8, 1747},
	{28480, 198656, 6, 4121},
	{28495, 198912},
	{28514, 198916},
	{28533, 198920, 1, 4504},
	{28552, 198924, 1, 1343},
	{28567, 198928},
	{28600, 198932},
	{28633, 198936},
	{28666, 198940},
	{28756, 198960},
	{28772, 198964},
	{28790, 198968, 1, 1785},
	{28807, 198972, 2, 1786},
	{28828, 198976},
	{29160, 199168, 1, 1809},
	{29185, 199172, 2, 1810},
	{29210, 199184, 2, 1812},
	{29236, 199188, 2, 1812},
	{29262, 199192, 2, 1812},
	{29288, 199212, 2, 1812},
	{29314, 199296, 2, 1814},
	{29342, 199300, 1, 1816},
	{29366, 199304, 1, 1817},
	{29390, 199308, 1, 1818},
	{29423, 199312, 1, 1818},
	{29451, 199328, 2, 1814},
	{29480, 199332, 1, 1816},
	{29505, 199336, 1, 1817},
	{29530, 199340, 1, 1818},
	{29564, 199344, 1, 1818},
	{29593, 199360, 2, 1814},
	{29617, 199364, 1, 1816},
	{29637, 199368, 1, 1817},
	{29657, 199372, 1, 1818},
	{29686, 199376, 1, 1818},
	{54791, 199872},
	{54812, 199876, 1, 4681},
	{2266, 199880, 8, 5235},
	{2287, 199884, 3, 4690},
	{54833, 199888, 2, 4693},
	{2314, 199892, 1, 4717},
	{54859, 199896, 15, 4702},
	{55862, 199900, 1, 5244},
	{55884, 199904},
	{2245, 199908, 2, 4695},
	{2335, 199912, 5, 5247},
	{54901, 199916, 1, 4718},
	{29710, 199936},
	{29737, 199940},
	{29764, 199944},
	{29791, 199948},
	{29926, 199968, 6, 1819},
	{29937, 199972, 2, 1826},
	{29951, 200192},
	{29970, 200196, 1, 840},
	{29992, 200448},
	{30016, 200452, 1, 1828},
	{30039, 200456},
	{30063, 200460, 1, 1828},
	{30086, 200464},
	{30110, 200468, 1, 1828},
	{30133, 200472},
	{30157, 200476, 1, 1828},
	{30180, 200696},
	{30199, 200700, 1, 1828},
	{30217, 200704},
	{30229, 200708},
	{30241, 200712},
	{30259, 200716},
	{30278, 200720},
	{30296, 200724},
	{30308, 200728},
	{30320, 200732},
	{30338, 200736},
	{30356, 200740},
	{30375, 200744, 4, 1829},
	{30389, 200748, 2, 1833},
	{30407, 200752, 2, 1835},
	{30421, 200756, 2, 1837},
	{30435, 200760, 2, 1839},
	{30452, 200764, 2, 1841},
	{30469, 200768},
	{30482, 200772, 2, 1843},
	{30494, 200776},
	{30508, 200780},
	{30524, 200784},
	{30538, 200788},
	{30554, 200792},
	{30569, 200796},
	{30586, 200800},
	{30601, 200804},
	{30618, 200808, 2, 1845},
	{30640, 200812, 9, 5715},
	{30657, 200816, 2, 1857},
	{30678, 200820, 2, 1859},
	{30690, 200824},
	{30705, 200828, 6, 5678},
	{30720, 200832, 2, 1867},
	{30734, 200836},
	{30847, 212992},
	{30867, 212996},
	{30887, 213000},
	{30907, 213004},
	{30927, 213008},
	{30947, 213012},
	{30967, 213016},
	{30987, 213020},
	{31007, 213024},
	{31027, 213028},
	{31047, 213032},
	{31067, 213036},
	{31156, 213248},
	{31177, 213252},
	{31198, 213260},
	{31219, 213264},
	{31240, 213268},
	{31264, 213272},
	{31288, 213276},
	{31312, 213280},
	{31336, 213284},
	{31360, 213288},
	{31384, 213292},
	{31408, 213296},
	{55974, 213504},
	{55993, 213508},
	{56012, 213512},
	{56031, 213516},
	{56050, 213520},
	{56069, 213524},
	{56088, 213528},
	{56107, 213532},
	{53464, 213536},
	{53483, 213540},
	{53502, 213544},
	{53521, 213548},
	{53540, 213552},
	{53559, 213556},
	{53578, 213560},
	{53597, 213564},
	{54017, 213568},
	{54037, 213572},
	{54057, 213576},
	{54077, 213580},
	{54097, 213584},
	{54117, 213588},
	{54137, 213592},
	{54157, 213596},
	{31892, 214016},
	{31914, 214020, 1, 1869},
	{31936, 214024},
	{31958, 214028, 1, 1869},
	{31980, 214032},
	{32002, 214036, 1, 1869},
	{32024, 214040},
	{32046, 214044, 1, 1869},
	{32068, 214272},
	{32090, 214276},
	{32112, 214280},
	{32134, 214284},
	{32156, 214288},
	{32178, 214292},
	{32200, 214296},
	{32222, 214300},
	{32244, 214304},
	{32266, 214308},
	{32288, 214312},
	{32310, 214316},
	{32332, 214320},
	{32354, 214324},
	{32376, 214328},
	{32398, 214332},
	{32420, 214528},
	{32440, 214532},
	{32460, 214536},
	{32480, 214540},
	{32500, 214544},
	{32520, 214548},
	{32540, 214552},
	{32560, 214556},
	{32580, 214560},
	{32600, 214564},
	{32620, 214568},
	{32640, 214572},
	{32660, 214784},
	{32679, 214788},
	{32698, 214792},
	{32717, 214796},
	{32736, 214800},
	{32755, 214804},
	{32774, 214808},
	{32793, 214812},
	{32812, 214816},
	{32831, 214820},
	{32850, 214824},
	{32869, 214828},
	{32888, 214832},
	{32907, 214836},
	{32926, 214840},
	{32945, 214844},
	{32964, 214848},
	{32983, 214852},
	{33002, 214856},
	{33021, 214860},
	{33040, 214864},
	{33060, 214868},
	{33080, 214872},
	{33100, 214876},
	{33120, 214880},
	{33140, 214884},
	{33160, 214888},
	{33180, 214892},
	{33200, 214896},
	{33220, 214900},
	{33240, 214904},
	{33260, 214908},
	{33280, 215296},
	{33299, 215300},
	{33318, 215304},
	{33337, 215308},
	{33356, 215312},
	{33375, 215316},
	{33394, 215320},
	{33413, 215324},
	{33474, 215552},
	{33494, 215556},
	{33514, 215560},
	{33534, 215564},
	{33554, 215568},
	{33574, 215572},
	{33594, 215576},
	{33614, 215580},
	{33634, 215808},
	{33653, 215812},
	{33672, 215816},
	{33691, 215820},
	{33710, 216064},
	{33729, 216068},
	{33748, 216072},
	{33767, 216076},
	{33786, 216320},
	{33806, 216324},
	{33826, 216328},
	{33846, 216332},
	{33866, 216336},
	{33886, 216340},
	{33906, 216344},
	{33926, 216348},
	{56126, 216576},
	{56146, 216580},
	{56166, 216584},
	{56186, 216588},
	{56206, 216592},
	{56226, 216596},
	{56246, 216600},
	{56266, 216604},
	{56286, 216640},
	{56306, 216644},
	{56326, 216648},
	{56346, 216652},
	{56366, 216656},
	{56386, 216660},
	{56406, 216664},
	{56426, 216668},
	{34778, 217112},
	{34797, 217116},
	{34816, 217120},
	{34835, 217124},
	{34854, 217128},
	{34873, 217132},
	{34892, 217136},
	{34911, 217140},
	{34930, 217344},
	{34949, 217348},
	{34968, 217352},
	{34987, 217356},
	{35006, 217360},
	{35025, 217364},
	{35044, 217368},
	{35063, 217372},
	{35082, 217600},
	{35102, 217604},
	{35122, 217608},
	{35142, 217612},
	{36464, 221184, 1, 1903},
	{36488, 221188, 2, 5284},
	{36513, 221192, 3, 5286},
	{36537, 221196, 1, 1903},
	{36561, 221200, 2, 5284},
	{36586, 221204, 1, 1903},
	{36610, 221208, 2, 5284},
	{36635, 221212, 3, 5286},
	{36659, 221216, 4, 1881},
	{36675, 221220, 3, 5286},
	{36842, 221248},
	{36857, 221252, 1, 1818},
	{36880, 221256},
	{36903, 221260},
	{36921, 221264, 2, 1897},
	{36939, 221268, 4, 1899},
	{36959, 221440, 19, 4164},
	{36984, 221444, 19, 4164},
	{37009, 221448, 12, 4183},
	{37037, 221452, 12, 4183},
	{37065, 221456, 12, 4183},
	{37093, 221460, 12, 4183},
	{56606, 221696, 2, 4462},
	{56629, 221700, 2, 4462},
	{56652, 221704, 2, 4462},
	{56675, 221708, 2, 4462},
	{53372, 221712, 5, 1957},
	{53395, 221716, 2, 4462},
	{53418, 221720, 2, 4462},
	{53441, 221724, 2, 4462},
	{56698, 221728, 4, 1962},
	{53921, 221744, 5, 1957},
	{53945, 221748, 5, 1957},
	{53969, 221752, 2, 4462},
	{53993, 221756, 2, 4462},
	{56722, 221760, 4, 1962},
	{56747, 221764, 4, 1962},
	{53895, 221776, 1, 4503},
	{37551, 222208, 3, 1957},
	{37577, 222212, 2, 1877},
	{37604, 222216, 3, 1957},
	{37630, 222220, 2, 1877},
	{37657, 222224, 2, 2013},
	{37710, 222228, 2, 2013},
	{37763, 222464, 3, 1957},
	{37789, 222468, 2, 1877},
	{37816, 222472, 1, 1872},
	{37842, 222476, 1, 1872},
	{37868, 222480, 1, 1872},
	{37894, 222484, 1, 1872},
	{37920, 222488, 1, 1872},
	{37946, 222492, 1, 1872},
	{37972, 222496, 1, 1872},
	{37998, 222720, 3, 1957},
	{38022, 222724, 3, 1957},
	{38046, 222728, 3, 1957},
	{38070, 222732, 3, 1957},
	{38094, 222736, 2, 1877},
	{38119, 222740, 2, 1877},
	{38144, 222744, 2, 1877},
	{38169, 222748, 2, 1877},
	{38194, 222752, 1, 2001},
	{38218, 222756, 1, 2001},
	{38242, 222760, 8, 1966},
	{38263, 222976, 6, 4661},
	{38286, 222980, 6, 4661},
	{38309, 222984, 6, 4661},
	{38332, 222988, 6, 4661},
	{38355, 222992, 6, 4661},
	{38378, 222996, 6, 4661},
	{38401, 223000, 6, 4661},
	{38424, 223004, 6, 4661},
	{38447, 223008, 6, 4661},
	{38470, 223012, 6, 4661},
	{38493, 223016, 6, 4661},
	{38517, 223020, 6, 4661},
	{38541, 223024, 6, 4661},
	{38565, 223028, 6, 4661},
	{38589, 223032, 6, 4661},
	{38613, 223036, 6, 4661},
	{38637, 223104, 9, 4644},
	{56772, 223108, 2, 4693},
	{38657, 223112, 1, 1987},
	{38752, 223488, 3, 1996},
	{38775, 223492, 3, 1996},
	{38798, 223496, 3, 1996},
	{38821, 223500, 3, 1996},
	{38844, 223504, 2, 1999},
	{38868, 223508, 2, 1999},
	{38892, 223744, 3, 1996},
	{38916, 223748, 3, 1996},
	{38940, 223752, 3, 1996},
	{38964, 223756, 3, 1996},
	{38988, 223760, 2, 1999},
	{39013, 224000, 5, 2001},
	{39036, 224004, 4, 2006},
	{39060, 224008, 5, 2001},
	{39083, 224256, 5, 2001},
	{39106, 224260, 4, 2006},
	{39130, 224264, 5, 2001},
	{39153, 224512, 5, 1957},
	{39177, 224516, 4, 1962},
	{39202, 224520, 5, 1957},
	{39226, 224524, 4, 1962},
	{39251, 224528, 3, 2013},
	{39275, 224532, 3, 2013},
	{56792, 224768, 5, 1957},
	{56816, 224772, 4, 1951},
	{56841, 224776, 5, 1957},
	{56865, 224780, 4, 1951},
	{56890, 224784, 3, 2013},
	{56914, 224788, 3, 2013},
	{56938, 224832, 5, 1957},
	{56962, 224836, 4, 1951},
	{56987, 224840, 5, 1957},
	{57011, 224844, 4, 1951},
	{57036, 224848, 3, 2013},
	{57060, 224852, 3, 2013},
	{39976, 225280, 12, 2016},
	{39998, 225284, 5, 2028},
	{40021, 225288, 4, 2033},
	{40045, 225292, 2, 2037},
	{40068, 225296, 2, 2037},
	{40091, 225300, 2, 2037},
	{40114, 225536, 5, 1957},
	{40137, 225540, 4, 1962},
	{40161, 225544, 5, 1957},
	{40184, 225548, 4, 1962},
	{40208, 225552, 5, 1957},
	{40231, 225560, 5, 1957},
	{40254, 225792, 4, 2039},
	{40275, 225796},
	{40304, 225800, 2, 2043},
	{40333, 225804},
	{40359, 225808, 7, 2045},
	{40433, 225812},
	{40456, 225816},
	{57205, 225820, 2, 5295},
	{57238, 225824, 2, 5295},
	{57271, 225828, 2, 5295},
	{57304, 225832, 2, 5295},
	{57336, 225836, 2, 5295},
	{57368, 225840, 2, 5295},
	{57400, 225844, 2, 5295},
	{57433, 225848, 2, 5295},
	{57465, 225856, 2, 5295},
	{57497, 225860, 2, 5295},
	{57530, 225864, 2, 5295},
	{57563, 225868, 2, 5295},
	{57596, 225872, 2, 5295},
	{57628, 225876, 2, 5295},
	{57660, 225880, 2, 5295},
	{57693, 225884, 2, 5295},
	{57726, 225888, 2, 5295},
	{57792, 225896, 2, 5295},
	{40479, 225900},
	{40506, 225904},
	{40388, 225908},
	{40407, 225912},
	{41376, 226044, 1, 2129},
	{41169, 226048, 2, 2119},
	{41186, 226052, 1, 2121},
	{41210, 226056, 1, 2121},
	{206, 880, 4, 2156},
	{42955, 881},
	{26802, 882},
	{42967, 1008},
	{42978, 1009},
	{26990, 1010, 4, 2160},
	{42989, 1040, 1, 2164},
	{43002, 1041, 5, 5297},
	{43015, 1042, 1, 2170},
	{43028, 1043, 1, 1681},
	{26824, 1045, 9, 5089},
	{43056, 1280, 6, 5302},
	{43071, 1281},
	{26761, 1282},
	{42955, 1283},
	{26802, 1284},
};

static const struct si_reg gfx9_reg_table[] = {
	{1145, 68, 14, 5724},
	{1158, 72, 23, 5738},
	{1173, 76, 7, 5761},
	{52194, 80, 11, 5114},
	{1210, 84, 4, 3975},
	{1228, 88, 2, 3979},
	{1246, 92, 7, 5768},
	{1261, 96},
	{1275, 100, 1, 70},
	{1289, 104},
	{52208, 108},
	{52225, 112, 13, 5775},
	{1306, 116, 7, 5788},
	{1322, 120},
	{1444, 2480},
	{1458, 2484},
	{1472, 2488},
	{1486, 2492},
	{1500, 2496},
	{1514, 2500},
	{1528, 2504},
	{1542, 2508},
	{1556, 2512},
	{1570, 2516},
	{1584, 2520},
	{1599, 2524},
	{1614, 2528},
	{1629, 2532},
	{1644, 2536},
	{1659, 2540},
	{1674, 2544},
	{1685, 2552},
	{1701, 2556},
	{1789, 32776, 25, 5795},
	{1802, 32784, 24, 5820},
	{1814, 32788, 12, 5844},
	{1830, 32792, 12, 5844},
	{1859, 32824, 12, 5844},
	{1875, 32828, 12, 5844},
	{1891, 33296, 16, 5856},
	{1905, 33300, 28, 204},
	{1922, 33304, 14, 232},
	{1943, 33308, 21, 5872},
	{1957, 33312, 31, 5197},
	{1974, 33316, 11, 307},
	{2013, 33324, 1, 329},
	{2036, 33344, 1, 330},
	{2057, 33348},
	{2077, 33352, 1, 332},
	{2118, 33436, 1, 342},
	{2522, 36608},
	{2540, 36612, 4, 383},
	{2558, 36616},
	{2576, 36620, 12, 5893},
	{3477, 36624},
	{3495, 36628, 8, 5905},
	{3513, 36632, 3, 4762},
	{3531, 36636, 8, 5913},
	{3549, 36640, 3, 5921},
	{3567, 36644, 7, 5924},
	{3585, 36648, 8, 5465},
	{3603, 36652},
	{2594, 36656, 14, 5473},
	{2612, 36660, 4, 411},
	{2630, 36664, 10, 5931},
	{2648, 36668, 3, 5941},
	{2682, 39160, 13, 5944},
	{2697, 39184, 5, 4820},
	{2711, 39188, 5, 4820},
	{2725, 39192, 5, 4820},
	{2739, 39196, 5, 4820},
	{2753, 39200, 5, 4820},
	{2767, 39204, 5, 4820},
	{2781, 39208, 5, 4820},
	{2795, 39212, 5, 4820},
	{2809, 39216, 5, 4820},
	{2823, 39220, 5, 4820},
	{2837, 39224, 5, 4820},
	{2852, 39228, 5, 4820},
	{2867, 39232, 5, 4820},
	{2882, 39236, 5, 4820},
	{2897, 39240, 5, 4820},
	{2912, 39244, 5, 4820},
	{2927, 39248, 5, 4820},
	{2942, 39252, 5, 4820},
	{2957, 39256, 5, 4820},
	{2972, 39260, 5, 4820},
	{2987, 39264, 5, 4820},
	{3002, 39268, 5, 4820},
	{3017, 39272, 5, 4820},
	{3032, 39276, 5, 4820},
	{3047, 39280, 5, 4820},
	{3062, 39284, 5, 4820},
	{3077, 39288, 5, 4820},
	{3092, 39292, 5, 4820},
	{3107, 39296, 5, 4820},
	{3122, 39300, 5, 4820},
	{3137, 39304, 5, 4820},
	{3152, 39308, 5, 4820},
	{3167, 39312, 4, 448},
	{3186, 39316, 4, 448},
	{3205, 39320, 4, 448},
	{3224, 39324, 4, 448},
	{3243, 39328, 4, 448},
	{3262, 39332, 4, 448},
	{3281, 39336, 4, 448},
	{3300, 39340, 4, 448},
	{3319, 39344, 4, 448},
	{3338, 39348, 4, 448},
	{3357, 39352, 4, 448},
	{3377, 39356, 4, 448},
	{3397, 39360, 4, 448},
	{3417, 39364, 4, 448},
	{3437, 39368, 4, 448},
	{3457, 39372, 4, 448},
	{3670, 45084, 4, 5957},
	{3694, 45088},
	{3715, 45092, 1, 491},
	{3736, 45096, 11, 5961},
	{3760, 45100, 10, 5972},
	{3784, 45104},
	{3810, 45108},
	{3836, 45112},
	{3862, 45116},
	{3888, 45120},
	{3914, 45124},
	{3940, 45128},
	{3966, 45132},
	{3992, 45136},
	{4018, 45140},
	{4044, 45144},
	{4071, 45148},
	{4098, 45152},
	{4125, 45156},
	{4152, 45160},
	{4179, 45164},
	{4206, 45168},
	{4233, 45172},
	{4260, 45176},
	{4287, 45180},
	{4314, 45184},
	{4341, 45188},
	{4368, 45192},
	{4395, 45196},
	{4422, 45200},
	{4449, 45204},
	{4476, 45208},
	{4503, 45212},
	{4530, 45216},
	{4557, 45220},
	{4584, 45224},
	{4611, 45228},
	{4851, 45336, 4, 5957},
	{4875, 45340, 1, 527},
	{4900, 45344},
	{4921, 45348, 1, 491},
	{4942, 45352, 12, 5982},
	{4966, 45356, 14, 5994},
	{4990, 45360},
	{5016, 45364},
	{5042, 45368},
	{5068, 45372},
	{5094, 45376},
	{5120, 45380},
	{5146, 45384},
	{5172, 45388},
	{5198, 45392},
	{5224, 45396},
	{5250, 45400},
	{5277, 45404},
	{5304, 45408},
	{5331, 45412},
	{5358, 45416},
	{5385, 45420},
	{5412, 45424},
	{5439, 45428},
	{5466, 45432},
	{5493, 45436},
	{5520, 45440},
	{5547, 45444},
	{5574, 45448},
	{5601, 45452},
	{5628, 45456},
	{5655, 45460},
	{5682, 45464},
	{5709, 45468},
	{5736, 45472},
	{5763, 45476},
	{5790, 45480},
	{5817, 45484},
	{6008, 45552, 9, 554},
	{6114, 45572, 2, 6008},
	{6138, 45576},
	{6170, 45580},
	{7445, 45584},
	{7466, 45588, 1, 491},
	{6250, 45596, 4, 5957},
	{6274, 45600},
	{6295, 45604, 1, 491},
	{6316, 45608, 12, 6010},
	{6340, 45612, 9, 6022},
	{7535, 45872},
	{7561, 45876},
	{7587, 45880},
	{7613, 45884},
	{7639, 45888},
	{7665, 45892},
	{7691, 45896},
	{7717, 45900},
	{7743, 45904},
	{7769, 45908},
	{7795, 45912},
	{7822, 45916},
	{7849, 45920},
	{7876, 45924},
	{7903, 45928},
	{7930, 45932},
	{58005, 45936},
	{58032, 45940},
	{58059, 45944},
	{58086, 45948},
	{58113, 45952},
	{58140, 45956},
	{58167, 45960},
	{58194, 45964},
	{58221, 45968},
	{58248, 45972},
	{58275, 45976},
	{58302, 45980},
	{58329, 45984},
	{58356, 45988},
	{58383, 45992},
	{58410, 45996},
	{8009, 46084, 1, 6008},
	{8033, 46088},
	{8065, 46092},
	{9340, 46096},
	{9361, 46100, 1, 491},
	{8145, 46108, 4, 6031},
	{8169, 46112},
	{8190, 46116, 1, 491},
	{8211, 46120, 11, 6035},
	{8235, 46124, 7, 6046},
	{9430, 46128},
	{9456, 46132},
	{9482, 46136},
	{9508, 46140},
	{9534, 46144},
	{9560, 46148},
	{9586, 46152},
	{9612, 46156},
	{9638, 46160},
	{9664, 46164},
	{9690, 46168},
	{9717, 46172},
	{9744, 46176},
	{9771, 46180},
	{9798, 46184},
	{9825, 46188},
	{58437, 46192},
	{58464, 46196},
	{58491, 46200},
	{58518, 46204},
	{58545, 46208},
	{58572, 46212},
	{58599, 46216},
	{58626, 46220},
	{58653, 46224},
	{58680, 46228},
	{58707, 46232},
	{58734, 46236},
	{58761, 46240},
	{58788, 46244},
	{58815, 46248},
	{58842, 46252},
	{58869, 46384},
	{58899, 46388},
	{58929, 46392},
	{58959, 46396},
	{58989, 46400},
	{59019, 46404},
	{59049, 46408},
	{59079, 46412},
	{59109, 46416},
	{59139, 46420},
	{59169, 46424},
	{59200, 46428},
	{59231, 46432},
	{59262, 46436},
	{59293, 46440},
	{59324, 46444},
	{59355, 46448},
	{59386, 46452},
	{59417, 46456},
	{59448, 46460},
	{59479, 46464},
	{59510, 46468},
	{59541, 46472},
	{59572, 46476},
	{59603, 46480},
	{59634, 46484},
	{59665, 46488},
	{59696, 46492},
	{59727, 46496},
	{59758, 46500},
	{59789, 46504},
	{59820, 46508},
	{9852, 47104, 11, 6053},
	{9879, 47108},
	{9893, 47112},
	{9907, 47116},
	{9921, 47120},
	{9937, 47124},
	{9953, 47128},
	{9969, 47132, 2, 659},
	{9990, 47136, 2, 659},
	{10011, 47140, 2, 659},
	{10032, 47144, 1, 661},
	{10060, 47148, 1, 662},
	{10085, 47152},
	{10100, 47156, 1, 663},
	{10115, 47160},
	{10144, 47164, 1, 663},
	{10173, 47168},
	{10206, 47172, 1, 663},
	{10239, 47176, 11, 6064},
	{10257, 47180, 12, 6075},
	{10275, 47184, 1, 687},
	{10288, 47188, 7, 6087},
	{55698, 47192, 2, 4949},
	{55729, 47196, 2, 4949},
	{10366, 47200, 2, 694},
	{55912, 47204, 2, 4949},
	{55943, 47208, 2, 4949},
	{10441, 47212},
	{10459, 47216},
	{10477, 47220},
	{10495, 47224, 1, 696},
	{10523, 47228, 5, 697},
	{10545, 47232},
	{10565, 47236},
	{10748, 47240, 3, 713},
	{10765, 47244},
	{10794, 47248, 1, 716},
	{10726, 47252},
	{48662, 47252},
	{48693, 47256},
	{48724, 47260},
	{48755, 47264},
	{10841, 47360},
	{10861, 47364},
	{10881, 47368},
	{10901, 47372},
	{10921, 47376},
	{10941, 47380},
	{10961, 47384},
	{10981, 47388},
	{11001, 47392},
	{11021, 47396},
	{11041, 47400},
	{11062, 47404},
	{11083, 47408},
	{11104, 47412},
	{11125, 47416},
	{11146, 47420},
	{11191, 47608},
	{11212, 47612},
	{11228, 163840, 10, 719},
	{11246, 163844, 9, 4980},
	{11263, 163848, 5, 6094},
	{11277, 163852, 23, 747},
	{11296, 163856, 16, 770},
	{11316, 163860},
	{11728, 163864, 1, 830},
	{55808, 163868, 2, 786},
	{11352, 163872},
	{11372, 163876},
	{11392, 163880, 1, 788},
	{11409, 163884},
	{11424, 163888, 2, 789},
	{11448, 163892, 2, 791},
	{11506, 163896, 13, 6099},
	{11516, 163900, 8, 6112},
	{11532, 163904},
	{11642, 163908, 1, 830},
	{11547, 163912},
	{11660, 163916, 1, 830},
	{11568, 163920},
	{11684, 163924, 1, 830},
	{11584, 163928},
	{11703, 163932, 1, 830},
	{11472, 163936, 3, 793},
	{59851, 163944, 1, 6120},
	{59862, 163948, 1, 6120},
	{11774, 163968},
	{11790, 163972, 1, 840},
	{11809, 164328, 1, 841},
	{11830, 164332, 1, 841},
	{11851, 164336, 1, 841},
	{11872, 164340, 1, 841},
	{11893, 164344},
	{11911, 164348},
	{11929, 164352, 2, 842},
	{11949, 164356, 3, 844},
	{11973, 164360, 2, 847},
	{11997, 164364, 1, 849},
	{12017, 164368, 2, 844},
	{12037, 164372, 2, 847},
	{12057, 164376, 2, 844},
	{12077, 164380, 2, 847},
	{12097, 164384, 2, 844},
	{12117, 164388, 2, 847},
	{12137, 164392, 2, 844},
	{12157, 164396, 2, 847},
	{12177, 164400, 7, 850},
	{12192, 164404, 2, 857},
	{12221, 164408, 8, 859},
	{12236, 164412, 8, 867},
	{12251, 164416, 3, 844},
	{12276, 164420, 2, 847},
	{12301, 164424},
	{12319, 164428},
	{12337, 164432, 3, 844},
	{12362, 164436, 2, 847},
	{12387, 164440, 3, 844},
	{12412, 164444, 2, 847},
	{12437, 164448, 3, 844},
	{12462, 164452, 2, 847},
	{12487, 164456, 3, 844},
	{12512, 164460, 2, 847},
	{12537, 164464, 3, 844},
	{12562, 164468, 2, 847},
	{12587, 164472, 3, 844},
	{12612, 164476, 2, 847},
	{12637, 164480, 3, 844},
	{12662, 164484, 2, 847},
	{12687, 164488, 3, 844},
	{12712, 164492, 2, 847},
	{12737, 164496, 3, 844},
	{12762, 164500, 2, 847},
	{12787, 164504, 3, 844},
	{12812, 164508, 2, 847},
	{12837, 164512, 3, 844},
	{12863, 164516, 2, 847},
	{12889, 164520, 3, 844},
	{12915, 164524, 2, 847},
	{12941, 164528, 3, 844},
	{12967, 164532, 2, 847},
	{12993, 164536, 3, 844},
	{13019, 164540, 2, 847},
	{13045, 164544, 3, 844},
	{13071, 164548, 2, 847},
	{13097, 164552, 3, 844},
	{13123, 164556, 2, 847},
	{13149, 164560},
	{13168, 164564},
	{13187, 164568},
	{13206, 164572},
	{13225, 164576},
	{13244, 164580},
	{13263, 164584},
	{13282, 164588},
	{13301, 164592},
	{13320, 164596},
	{13339, 164600},
	{13358, 164604},
	{13377, 164608},
	{13396, 164612},
	{13415, 164616},
	{13434, 164620},
	{13453, 164624},
	{13472, 164628},
	{13491, 164632},
	{13510, 164636},
	{13529, 164640},
	{13549, 164644},
	{13569, 164648},
	{13589, 164652},
	{13609, 164656},
	{13629, 164660},
	{13649, 164664},
	{13669, 164668},
	{13689, 164672},
	{13709, 164676},
	{13729, 164680},
	{13749, 164684},
	{13769, 164688, 15, 6121},
	{13789, 164692, 3, 6136},
	{13811, 164696, 2, 893},
	{13839, 164700, 3, 895},
	{13868, 164704, 1, 902},
	{13889, 164708, 1, 903},
	{13899, 164712, 1, 904},
	{13907, 164768, 4, 905},
	{13929, 164772, 4, 905},
	{13950, 164776, 4, 909},
	{14017, 164876},
	{14071, 164884},
	{14084, 164888},
	{14099, 164892},
	{14113, 164896},
	{14128, 164900, 9, 6139},
	{14167, 164908, 6, 935},
	{14186, 164912, 4, 941},
	{14204, 164916, 4, 945},
	{14225, 164924},
	{14244, 164928},
	{14264, 164932},
	{14283, 164936},
	{14303, 164940},
	{14322, 164944},
	{14342, 164948},
	{14363, 164952},
	{14385, 164956},
	{14406, 164960},
	{14428, 164964},
	{14449, 164968},
	{14471, 164972},
	{14492, 164976},
	{14514, 164980},
	{14535, 164984},
	{14557, 164988},
	{14578, 164992},
	{14600, 164996},
	{14621, 165000},
	{14643, 165004},
	{14664, 165008},
	{14686, 165012},
	{14707, 165016},
	{14729, 165020},
	{14750, 165024},
	{14772, 165028},
	{14793, 165032},
	{14815, 165036},
	{14836, 165040},
	{14858, 165044},
	{14879, 165048},
	{14901, 165052},
	{14922, 165056},
	{14944, 165060},
	{14965, 165064},
	{14987, 165068},
	{15008, 165072},
	{15030, 165076},
	{15051, 165080},
	{15073, 165084},
	{15094, 165088},
	{15116, 165092},
	{15137, 165096},
	{15159, 165100},
	{15180, 165104},
	{15202, 165108},
	{15223, 165112},
	{15245, 165116},
	{15266, 165120},
	{15288, 165124},
	{15309, 165128},
	{15331, 165132},
	{15352, 165136},
	{15374, 165140},
	{15395, 165144},
	{15417, 165148},
	{15438, 165152},
	{15460, 165156},
	{15481, 165160},
	{15503, 165164},
	{15525, 165168},
	{15548, 165172},
	{15570, 165176},
	{15593, 165180},
	{15615, 165184},
	{15638, 165188},
	{15660, 165192},
	{15683, 165196},
	{15705, 165200},
	{15728, 165204},
	{15750, 165208},
	{15773, 165212},
	{15795, 165216},
	{15818, 165220},
	{15840, 165224},
	{15863, 165228},
	{15885, 165232},
	{15908, 165236},
	{15930, 165240},
	{15953, 165244},
	{15975, 165248},
	{15998, 165252},
	{16020, 165256},
	{16043, 165260},
	{16065, 165264},
	{16088, 165268},
	{16110, 165272},
	{16133, 165276},
	{16155, 165280},
	{16178, 165284},
	{16200, 165288},
	{16223, 165292},
	{16245, 165296},
	{16268, 165300},
	{16290, 165304},
	{16313, 165308},
	{16327, 165312},
	{16341, 165316},
	{16355, 165320},
	{16369, 165324},
	{16383, 165328},
	{16397, 165332},
	{16411, 165336},
	{16425, 165340},
	{16439, 165344},
	{16453, 165348},
	{16467, 165352},
	{16481, 165356},
	{16495, 165360},
	{16509, 165364},
	{16523, 165368},
	{16537, 165372},
	{16551, 165376},
	{16565, 165380},
	{16579, 165384},
	{16593, 165388},
	{16607, 165392},
	{16621, 165396},
	{16635, 165400},
	{16649, 165404},
	{16672, 165444, 12, 949},
	{16692, 165448, 12, 949},
	{16712, 165452, 12, 949},
	{16732, 165456, 12, 949},
	{16752, 165460, 12, 949},
	{16772, 165464, 12, 949},
	{16792, 165468, 12, 949},
	{16812, 165472, 12, 949},
	{16832, 165476, 12, 949},
	{16852, 165480, 12, 949},
	{16872, 165484, 12, 949},
	{16893, 165488, 12, 949},
	{16914, 165492, 12, 949},
	{16935, 165496, 12, 949},
	{16956, 165500, 12, 949},
	{16977, 165504, 12, 949},
	{16998, 165508, 12, 949},
	{17019, 165512, 12, 949},
	{17040, 165516, 12, 949},
	{17061, 165520, 12, 949},
	{17082, 165524, 9, 961},
	{17103, 165528, 9, 961},
	{17124, 165532, 9, 961},
	{17145, 165536, 9, 961},
	{17166, 165540, 9, 961},
	{17187, 165544, 9, 961},
	{17208, 165548, 9, 961},
	{17229, 165552, 9, 961},
	{17250, 165556, 9, 961},
	{17271, 165560, 9, 961},
	{17292, 165564, 9, 961},
	{17313, 165568, 9, 961},
	{17334, 165572, 2, 970},
	{17352, 165580, 16, 973},
	{17369, 165584, 16, 973},
	{17387, 165588, 7, 989},
	{17408, 165592, 5, 996},
	{17426, 165600, 7, 1002},
	{17441, 165608, 2, 694},
	{17480, 165644, 4, 1010},
	{17502, 165648, 1, 1015},
	{17522, 165652, 8, 1016},
	{17544, 165716, 8, 1024},
	{17562, 165720, 8, 1032},
	{17583, 165724, 17, 1040},
	{17604, 165728, 6, 1057},
	{17622, 165732, 6, 1057},
	{17640, 165736, 6, 1057},
	{17658, 165740, 6, 1057},
	{17676, 165744, 6, 1057},
	{17694, 165748, 6, 1057},
	{17712, 165752, 6, 1057},
	{17730, 165756, 6, 1057},
	{17748, 165760, 9, 1063},
	{17766, 165764, 9, 1063},
	{17784, 165768, 9, 1063},
	{17802, 165772, 9, 1063},
	{17820, 165776, 9, 1063},
	{17838, 165780, 9, 1063},
	{17856, 165784, 9, 1063},
	{17874, 165788, 9, 1063},
	{59879, 165792, 1, 6120},
	{59894, 165796, 1, 6120},
	{59909, 165800, 1, 6120},
	{59924, 165804, 1, 6120},
	{59939, 165808, 1, 6120},
	{59954, 165812, 1, 6120},
	{59969, 165816, 1, 6120},
	{59984, 165820, 1, 6120},
	{17892, 165836, 1, 1072},
	{17906, 165840, 1, 1072},
	{17921, 165844},
	{17939, 165848},
	{17957, 165852},
	{17974, 165856},
	{17995, 165860, 1, 1073},
	{18011, 165864},
	{18024, 165872, 8, 1074},
	{18043, 165876},
	{18058, 165880, 1, 1082},
	{18107, 165888, 10, 1084},
	{18124, 165892, 12, 1094},
	{18132, 165896, 4, 5689},
	{18149, 165900, 16, 1110},
	{18167, 165904, 20, 1127},
	{18183, 165908, 15, 1147},
	{18202, 165912, 10, 1163},
	{18217, 165916, 28, 6148},
	{18235, 165920, 16, 1201},
	{18253, 165924, 4, 1217},
	{18277, 165928},
	{18302, 165932, 11, 1221},
	{18325, 165936, 6, 6176},
	{18354, 165940, 3, 6182},
	{18376, 165944, 2, 1241},
	{18391, 165948, 5, 1243},
	{18421, 165952, 6, 6185},
	{18454, 166400, 2, 1253},
	{18471, 166404, 2, 1255},
	{18490, 166408, 1, 1257},
	{18506, 166412, 4, 1258},
	{18525, 166416, 1, 1262},
	{18546, 166420, 1, 1263},
	{18559, 166424},
	{18582, 166428},
	{18605, 166432, 1, 1264},
	{18625, 166436, 4, 1265},
	{18645, 166440, 1, 1269},
	{18666, 166444, 1, 1270},
	{18681, 166448, 6, 1271},
	{18703, 166452, 6, 1271},
	{18725, 166456, 8, 1277},
	{18751, 166460, 8, 1277},
	{18777, 166464, 15, 5559},
	{18789, 166468, 3, 1300},
	{18808, 166472, 7, 1303},
	{18826, 166476, 24, 1310},
	{18844, 166480},
	{18856, 166484, 1, 1334},
	{18870, 166488, 1, 1335},
	{18884, 166492, 1, 1336},
	{18898, 166496, 1, 1337},
	{18921, 166500, 1, 1337},
	{18944, 166504, 1, 1337},
	{18967, 166508, 5, 1338},
	{18988, 166512},
	{18999, 166516},
	{19012, 166520},
	{19029, 166524, 7, 6191},
	{19048, 166528},
	{19059, 166532, 3, 1351},
	{19078, 166536},
	{19100, 166540},
	{19122, 166544, 3, 6198},
	{59999, 166548, 1, 6201},
	{19169, 166552, 4, 6202},
	{19191, 166560},
	{19216, 166564},
	{19260, 166572, 1, 1370},
	{19283, 166576, 1, 1370},
	{19306, 166580, 1, 1371},
	{19320, 166584, 1, 1372},
	{19335, 166588, 8, 6206},
	{19352, 166592, 4, 1382},
	{19379, 166596, 4, 1386},
	{19406, 166600, 4, 1390},
	{19425, 166608},
	{19451, 166612, 1, 1394},
	{19476, 166620},
	{19504, 166624},
	{19530, 166628, 1, 1394},
	{19555, 166636},
	{19583, 166640},
	{19609, 166644, 1, 1394},
	{19634, 166652},
	{19662, 166656},
	{19688, 166660, 1, 1394},
	{19713, 166668},
	{19741, 166696},
	{19772, 166700},
	{19815, 166704, 1, 1395},
	{19853, 166712, 1, 1396},
	{19892, 166736, 5, 1399},
	{19914, 166740, 13, 6214},
	{19935, 166744, 3, 1423},
	{19952, 166748, 1, 1370},
	{19973, 166752, 1, 1370},
	{19996, 166756, 1, 1370},
	{20019, 166760, 1, 1370},
	{20042, 166764, 8, 6227},
	{20055, 166768, 6, 1438},
	{20072, 166772},
	{20096, 166776, 2, 1444},
	{20126, 166780},
	{20150, 166784},
	{20180, 166788},
	{20211, 166792},
	{20240, 166796},
	{20270, 166800, 2, 1446},
	{20290, 166804, 8, 1449},
	{20309, 166808, 4, 1457},
	{20335, 166812, 3, 6198},
	{20359, 166868, 8, 1461},
	{20385, 166872, 8, 1469},
	{20411, 166876, 5, 1477},
	{20427, 166880, 6, 1482},
	{20443, 166884, 3, 1488},
	{20458, 166888},
	{20481, 166892},
	{20504, 166896},
	{20527, 166900},
	{20550, 166904, 8, 1491},
	{20584, 166908, 8, 1499},
	{20618, 166912, 8, 1507},
	{20652, 166916, 8, 1515},
	{20686, 166920, 8, 1491},
	{20720, 166924, 8, 1499},
	{20754, 166928, 8, 1507},
	{20788, 166932, 8, 1515},
	{20822, 166936, 8, 1491},
	{20856, 166940, 8, 1499},
	{20890, 166944, 8, 1507},
	{20924, 166948, 8, 1515},
	{20958, 166952, 8, 1491},
	{20992, 166956, 8, 1499},
	{21026, 166960, 8, 1507},
	{21060, 166964, 8, 1515},
	{21094, 166968, 2, 1523},
	{21118, 166972, 2, 1525},
	{21142, 166976, 3, 1527},
	{21163, 166980, 11, 6235},
	{21183, 166984, 2, 1543},
	{21203, 166988, 18, 6246},
	{21241, 166992, 1, 1565},
	{21261, 167000, 1, 1567},
	{21289, 167004, 1, 1568},
	{21310, 167008},
	{23350, 167012, 1, 1615},
	{24086, 167016, 3, 1616},
	{21357, 167020, 3, 6264},
	{21372, 167024, 16, 6267},
	{21387, 167028, 10, 6283},
	{21404, 167032, 11, 1602},
	{21426, 167036},
	{23502, 167040, 1, 1615},
	{21464, 167044},
	{23702, 167048, 1, 1615},
	{21502, 167052},
	{21524, 167056},
	{21546, 167060},
	{23902, 167064, 1, 1615},
	{21565, 167068},
	{23369, 167072, 1, 1615},
	{24104, 167076, 3, 1616},
	{21612, 167080, 3, 6264},
	{21627, 167084, 16, 6267},
	{21642, 167088, 10, 6283},
	{21659, 167092, 11, 1602},
	{21681, 167096},
	{23527, 167100, 1, 1615},
	{21719, 167104},
	{23727, 167108, 1, 1615},
	{21757, 167112},
	{21779, 167116},
	{21801, 167120},
	{23925, 167124, 1, 1615},
	{21820, 167128},
	{23388, 167132, 1, 1615},
	{24122, 167136, 3, 1616},
	{21867, 167140, 3, 6264},
	{21882, 167144, 16, 6267},
	{21897, 167148, 10, 6283},
	{21914, 167152, 11, 1602},
	{21936, 167156},
	{23552, 167160, 1, 1615},
	{21974, 167164},
	{23752, 167168, 1, 1615},
	{22012, 167172},
	{22034, 167176},
	{22056, 167180},
	{23948, 167184, 1, 1615},
	{22075, 167188},
	{23407, 167192, 1, 1615},
	{24140, 167196, 3, 1616},
	{22122, 167200, 3, 6264},
	{22137, 167204, 16, 6267},
	{22152, 167208, 10, 6283},
	{22169, 167212, 11, 1602},
	{22191, 167216},
	{23577, 167220, 1, 1615},
	{22229, 167224},
	{23777, 167228, 1, 1615},
	{22267, 167232},
	{22289, 167236},
	{22311, 167240},
	{23971, 167244, 1, 1615},
	{22330, 167248},
	{23426, 167252, 1, 1615},
	{24158, 167256, 3, 1616},
	{22377, 167260, 3, 6264},
	{22392, 167264, 16, 6267},
	{22407, 167268, 10, 6283},
	{22424, 167272, 11, 1602},
	{22446, 167276},
	{23602, 167280, 1, 1615},
	{22484, 167284},
	{23802, 167288, 1, 1615},
	{22522, 167292},
	{22544, 167296},
	{22566, 167300},
	{23994, 167304, 1, 1615},
	{22585, 167308},
	{23445, 167312, 1, 1615},
	{24176, 167316, 3, 1616},
	{22632, 167320, 3, 6264},
	{22647, 167324, 16, 6267},
	{22662, 167328, 10, 6283},
	{22679, 167332, 11, 1602},
	{22701, 167336},
	{23627, 167340, 1, 1615},
	{22739, 167344},
	{23827, 167348, 1, 1615},
	{22777, 167352},
	{22799, 167356},
	{22821, 167360},
	{24017, 167364, 1, 1615},
	{22840, 167368},
	{23464, 167372, 1, 1615},
	{24194, 167376, 3, 1616},
	{22887, 167380, 3, 6264},
	{22902, 167384, 16, 6267},
	{22917, 167388, 10, 6283},
	{22934, 167392, 11, 1602},
	{22956, 167396},
	{23652, 167400, 1, 1615},
	{22994, 167404},
	{23852, 167408, 1, 1615},
	{23032, 167412},
	{23054, 167416},
	{23076, 167420},
	{24040, 167424, 1, 1615},
	{23095, 167428},
	{23483, 167432, 1, 1615},
	{24212, 167436, 3, 1616},
	{23142, 167440, 3, 6264},
	{23157, 167444, 16, 6267},
	{23172, 167448, 10, 6283},
	{23189, 167452, 11, 1602},
	{23211, 167456},
	{23677, 167460, 1, 1615},
	{23249, 167464},
	{23877, 167468, 1, 1615},
	{23287, 167472},
	{23309, 167476},
	{23331, 167480},
	{24063, 167484, 1, 1615},
	{24374, 196608, 1, 1627},
	{24394, 196612, 1, 1628},
	{24414, 196616},
	{24434, 196620},
	{24454, 196624},
	{24475, 196628},
	{24496, 196632, 1, 1629},
	{24518, 196636, 1, 1630},
	{24540, 196640},
	{24570, 196644},
	{24600, 196648},
	{24629, 196652},
	{24658, 196656},
	{24688, 196660},
	{24718, 196664},
	{24747, 196668},
	{24776, 196672},
	{24806, 196676},
	{24836, 196680},
	{24865, 196684},
	{24894, 196688},
	{24924, 196692},
	{24954, 196696},
	{24983, 196700},
	{25012, 196704, 1, 1631},
	{25034, 196708, 1, 1632},
	{25056, 196712},
	{25079, 196716},
	{25102, 196720},
	{25125, 196724},
	{25148, 196728},
	{25171, 196732},
	{25194, 196736},
	{25218, 196740},
	{25242, 196744},
	{25266, 196748},
	{25290, 196752},
	{25314, 196756},
	{25338, 196760},
	{25362, 196764},
	{25386, 196768},
	{25408, 196772},
	{25430, 196776},
	{25451, 196780},
	{25472, 196784},
	{25496, 196788},
	{25520, 196792},
	{25544, 196796},
	{25568, 196800},
	{25592, 196804},
	{25676, 196852, 1, 5631},
	{25698, 196856, 1, 5631},
	{25720, 196860, 1, 1635},
	{25736, 196864},
	{25749, 196868},
	{25762, 196872},
	{25775, 196876},
	{25788, 196880},
	{25801, 196884},
	{25814, 196888},
	{25827, 196892},
	{25882, 196912},
	{25900, 196916},
	{25927, 196920},
	{25954, 196928, 2, 1636},
	{25967, 196932},
	{25980, 196936},
	{26003, 196940},
	{26026, 196944},
	{26054, 196948},
	{26082, 196952},
	{26110, 196956},
	{26138, 196960, 1, 1638},
	{26156, 196964, 4, 6293},
	{60029, 196968},
	{60047, 196972},
	{60074, 196976},
	{26237, 196980},
	{26256, 196984},
	{26275, 196988},
	{26299, 196992},
	{26323, 196996},
	{26347, 197000},
	{26371, 197028, 1, 1643},
	{26389, 197032, 2, 6297},
	{26407, 197036},
	{26425, 197040},
	{26443, 197044, 1, 1646},
	{26461, 197048, 2, 6299},
	{26479, 197052},
	{26497, 197056, 2, 1649},
	{26516, 197060, 5, 1651},
	{26535, 197072},
	{26559, 197076, 2, 1649},
	{26579, 197080, 5, 1651},
	{26599, 197084, 5, 6301},
	{26618, 197088, 5, 6301},
	{26636, 197092, 1, 1663},
	{26653, 197100, 1, 1664},
	{26674, 197104, 13, 1665},
	{26688, 197108},
	{26702, 197112},
	{26716, 197116, 2, 1678},
	{26732, 197120},
	{26751, 197124, 1, 1680},
	{26773, 197128},
	{26792, 197132, 1, 1681},
	{26814, 197136, 7, 1682},
	{26832, 197140},
	{26852, 197144, 1, 1680},
	{26875, 197148},
	{26895, 197152, 1, 1681},
	{26918, 197156, 7, 1682},
	{26937, 197160, 6, 6306},
	{26949, 197164, 2, 1696},
	{26966, 197168, 1, 1698},
	{26983, 197172, 1, 1699},
	{27001, 197176, 4, 1700},
	{27021, 197180, 1, 1704},
	{27038, 197184},
	{27054, 197188, 1, 1706},
	{27067, 197192, 1, 1707},
	{27081, 197196, 1, 1708},
	{27095, 197200, 1, 1709},
	{27117, 197204, 1, 1710},
	{27137, 197208, 1, 1711},
	{27159, 197212, 1, 1712},
	{27179, 197216, 1, 1707},
	{27196, 197220, 1, 1708},
	{27213, 197224},
	{57989, 197228, 1, 1706},
	{27361, 197364, 1, 1717},
	{27382, 197368, 1, 1718},
	{27402, 197372, 1, 1719},
	{27422, 197376, 1, 1718},
	{27439, 197380, 1, 1719},
	{27456, 197384, 1, 1720},
	{27472, 197388, 1, 1721},
	{27491, 197392, 1, 1722},
	{27510, 197396, 1, 1723},
	{27527, 197400, 1, 1724},
	{27545, 197404, 1, 1725},
	{27563, 197408, 1, 1726},
	{27579, 197412, 1, 1727},
	{27597, 197416, 1, 1728},
	{27615, 197420, 1, 1729},
	{27631, 197424, 1, 1724},
	{27646, 197428, 1, 1725},
	{27661, 197432, 1, 1726},
	{27674, 197436, 1, 1727},
	{27689, 197440, 1, 1728},
	{27704, 197444, 1, 1729},
	{27717, 197448, 1, 1730},
	{27731, 197452, 1, 1731},
	{27745, 197456, 1, 1732},
	{27757, 197460, 4, 6312},
	{27780, 197464, 3, 1737},
	{27802, 197468, 1, 1740},
	{27946, 197552, 1, 1745},
	{27971, 197556, 1, 1745},
	{27995, 197560, 1, 1746},
	{28015, 197568},
	{28041, 197572, 1, 1628},
	{28070, 197576},
	{28095, 197580, 1, 1628},
	{28123, 197584},
	{28146, 197588, 1, 1628},
	{28172, 197592},
	{28194, 197596, 1, 1628},
	{28219, 197600},
	{28238, 197604, 1, 1628},
	{28260, 197608, 1, 1343},
	{28274, 197612},
	{28291, 197616, 1, 1628},
	{28311, 197620, 8, 1747},
	{28328, 197624, 13, 1755},
	{28345, 197628},
	{28362, 197632, 1, 1698},
	{28382, 197636},
	{28399, 197640, 1, 1663},
	{28419, 197644, 2, 1768},
	{28438, 197888, 8, 6316},
	{28459, 197892, 8, 6316},
	{28480, 198656, 6, 4121},
	{28514, 198916},
	{28533, 198920, 1, 1784},
	{28552, 198924, 2, 6324},
	{28567, 198928},
	{28600, 198932},
	{28633, 198936},
	{28666, 198940},
	{13967, 198944},
	{13984, 198948},
	{14001, 198952},
	{19142, 198956, 2, 1357},
	{28756, 198960},
	{28772, 198964},
	{28790, 198968, 1, 1785},
	{28807, 198972, 2, 1786},
	{28828, 198976},
	{29122, 198980, 1, 830},
	{28866, 198984},
	{28882, 198988, 1, 830},
	{28901, 198992},
	{28921, 198996, 1, 830},
	{28944, 199000},
	{28962, 199004, 1, 830},
	{19241, 199008, 9, 1788},
	{29024, 199016},
	{29160, 199168, 1, 1809},
	{29185, 199172, 2, 1810},
	{29210, 199184, 2, 1812},
	{29236, 199188, 2, 1812},
	{29262, 199192, 2, 1812},
	{29288, 199212, 2, 1812},
	{29314, 199296, 2, 1814},
	{29342, 199300, 1, 1816},
	{29366, 199304, 1, 1817},
	{29390, 199308, 1, 1818},
	{29423, 199312, 1, 1818},
	{29451, 199328, 2, 1814},
	{29480, 199332, 1, 1816},
	{29505, 199336, 1, 1817},
	{29530, 199340, 1, 1818},
	{29564, 199344, 1, 1818},
	{29593, 199360, 2, 1814},
	{29617, 199364, 1, 1816},
	{29637, 199368, 1, 1817},
	{29657, 199372, 1, 1818},
	{29686, 199376, 1, 1818},
	{18436, 199380},
	{54791, 199872},
	{54812, 199876, 1, 4681},
	{2266, 199880, 7, 5235},
	{2287, 199884, 3, 4690},
	{54833, 199888, 2, 4693},
	{2314, 199892, 1, 4717},
	{54859, 199896, 15, 6326},
	{55862, 199900, 1, 5244},
	{55884, 199904},
	{2245, 199908, 2, 4695},
	{2335, 199912, 6, 6341},
	{54901, 199916, 1, 4718},
	{54880, 199920},
	{29710, 199936},
	{29737, 199940},
	{29764, 199944},
	{29791, 199948},
	{29926, 199968, 6, 1819},
	{29937, 199972, 2, 1826},
	{29951, 200192},
	{29970, 200196, 1, 840},
	{29992, 200448},
	{30016, 200452, 1, 1828},
	{30039, 200456},
	{30063, 200460, 1, 1828},
	{30086, 200464},
	{30110, 200468, 1, 1828},
	{30133, 200472},
	{30157, 200476, 1, 1828},
	{30180, 200696},
	{30199, 200700, 1, 1828},
	{30217, 200704},
	{30229, 200708},
	{30241, 200712},
	{30259, 200716},
	{30278, 200720},
	{30296, 200724},
	{30308, 200728},
	{30320, 200732},
	{30338, 200736},
	{30356, 200740},
	{30375, 200744, 4, 1829},
	{30389, 200748, 2, 1833},
	{30407, 200752, 2, 1835},
	{30421, 200756, 2, 1837},
	{30435, 200760, 2, 1839},
	{30452, 200764, 2, 1841},
	{30469, 200768},
	{30482, 200772, 2, 1843},
	{30494, 200776},
	{30508, 200780},
	{30524, 200784},
	{30538, 200788},
	{30554, 200792},
	{30569, 200796},
	{30586, 200800},
	{30601, 200804},
	{30618, 200808, 2, 1845},
	{30640, 200812, 10, 6347},
	{30657, 200816, 2, 1857},
	{30678, 200820, 2, 1859},
	{30690, 200824},
	{30705, 200828, 6, 5678},
	{30720, 200832, 2, 1867},
	{30734, 200836},
	{2666, 200960, 9, 429},
	{50136, 200964, 11, 6357},
	{50154, 200968, 2, 3678},
	{50172, 200972, 4, 6368},
	{30847, 212992},
	{30867, 212996},
	{30887, 213000},
	{30907, 213004},
	{30927, 213008},
	{30947, 213012},
	{30967, 213016},
	{30987, 213020},
	{31007, 213024},
	{31027, 213028},
	{31047, 213032},
	{31067, 213036},
	{31087, 213040},
	{31110, 213044},
	{31133, 213048},
	{31156, 213248},
	{31177, 213252},
	{31198, 213260},
	{31219, 213264},
	{31240, 213268},
	{31264, 213272},
	{31288, 213276},
	{31312, 213280},
	{31336, 213284},
	{31360, 213288},
	{31384, 213292},
	{31408, 213296},
	{55974, 213504},
	{55993, 213508},
	{56012, 213512},
	{56031, 213516},
	{56050, 213520},
	{56069, 213524},
	{56088, 213528},
	{56107, 213532},
	{53464, 213536},
	{53483, 213540},
	{53502, 213544},
	{53521, 213548},
	{53540, 213552},
	{53559, 213556},
	{53578, 213560},
	{53597, 213564},
	{54017, 213568},
	{54037, 213572},
	{54057, 213576},
	{54077, 213580},
	{54097, 213584},
	{54117, 213588},
	{54137, 213592},
	{54157, 213596},
	{31892, 214016},
	{31914, 214020, 1, 1869},
	{31936, 214024},
	{31958, 214028, 1, 1869},
	{31980, 214032},
	{32002, 214036, 1, 1869},
	{32024, 214040},
	{32046, 214044, 1, 1869},
	{32068, 214272},
	{32090, 214276},
	{32112, 214280},
	{32134, 214284},
	{32156, 214288},
	{32178, 214292},
	{32200, 214296},
	{32222, 214300},
	{32244, 214304},
	{32266, 214308},
	{32288, 214312},
	{32310, 214316},
	{32332, 214320},
	{32354, 214324},
	{32376, 214328},
	{32398, 214332},
	{32420, 214528},
	{32440, 214532},
	{32460, 214536},
	{32480, 214540},
	{32500, 214544},
	{32520, 214548},
	{32540, 214552},
	{32560, 214556},
	{32580, 214560},
	{32600, 214564},
	{32620, 214568},
	{32640, 214572},
	{32660, 214784},
	{32679, 214788},
	{32698, 214792},
	{32717, 214796},
	{32736, 214800},
	{32755, 214804},
	{32774, 214808},
	{32793, 214812},
	{32812, 214816},
	{32831, 214820},
	{32850, 214824},
	{32869, 214828},
	{32888, 214832},
	{32907, 214836},
	{32926, 214840},
	{32945, 214844},
	{32964, 214848},
	{32983, 214852},
	{33002, 214856},
	{33021, 214860},
	{33040, 214864},
	{33060, 214868},
	{33080, 214872},
	{33100, 214876},
	{33120, 214880},
	{33140, 214884},
	{33160, 214888},
	{33180, 214892},
	{33200, 214896},
	{33220, 214900},
	{33240, 214904},
	{33260, 214908},
	{33280, 215296},
	{33299, 215300},
	{33318, 215304},
	{33337, 215308},
	{33356, 215312},
	{33375, 215316},
	{33394, 215320},
	{33413, 215324},
	{33474, 215552},
	{33494, 215556},
	{33514, 215560},
	{33534, 215564},
	{33554, 215568},
	{33574, 215572},
	{33594, 215576},
	{33614, 215580},
	{33634, 215808},
	{33653, 215812},
	{33672, 215816},
	{33691, 215820},
	{33710, 216064},
	{33729, 216068},
	{33748, 216072},
	{33767, 216076},
	{33786, 216320},
	{33806, 216324},
	{33826, 216328},
	{33846, 216332},
	{33866, 216336},
	{33886, 216340},
	{33906, 216344},
	{33926, 216348},
	{56126, 216576},
	{56146, 216580},
	{56166, 216584},
	{56186, 216588},
	{56206, 216592},
	{56226, 216596},
	{56246, 216600},
	{56266, 216604},
	{56286, 216640},
	{56306, 216644},
	{56326, 216648},
	{56346, 216652},
	{56366, 216656},
	{56386, 216660},
	{56406, 216664},
	{56426, 216668},
	{34778, 217112},
	{34797, 217116},
	{34816, 217120},
	{34835, 217124},
	{34854, 217128},
	{34873, 217132},
	{34892, 217136},
	{34911, 217140},
	{34930, 217344},
	{34949, 217348},
	{34968, 217352},
	{34987, 217356},
	{35006, 217360},
	{35025, 217364},
	{35044, 217368},
	{35063, 217372},
	{35082, 217600},
	{35102, 217604},
	{35122, 217608},
	{35142, 217612},
	{35162, 217856},
	{35182, 217860},
	{35202, 217864},
	{35222, 217868},
	{35242, 217872},
	{35262, 217876},
	{35282, 217880},
	{35302, 217884},
	{35325, 218112},
	{35350, 218116, 2, 1870},
	{35374, 218144},
	{35400, 218148, 2, 1870},
	{36464, 221184, 5, 6372},
	{36488, 221188, 4, 6377},
	{36513, 221192, 5, 6372},
	{36537, 221196, 5, 6372},
	{36561, 221200, 4, 6377},
	{36586, 221204, 5, 6372},
	{36610, 221208, 4, 6377},
	{36635, 221212, 5, 6372},
	{36659, 221216, 4, 1881},
	{36675, 221220, 5, 6372},
	{36699, 221224, 3, 1885},
	{36733, 221228, 3, 1888},
	{36767, 221232, 3, 1891},
	{36792, 221236, 3, 1894},
	{36817, 221240, 3, 6381},
	{36842, 221248},
	{36857, 221252, 1, 1818},
	{36880, 221256},
	{36903, 221260},
	{36921, 221264, 2, 1897},
	{36939, 221268, 4, 1899},
	{36959, 221440, 22, 6384},
	{36984, 221444, 22, 6384},
	{37009, 221448, 13, 6406},
	{37037, 221452, 13, 6406},
	{37065, 221456, 13, 6406},
	{37093, 221460, 13, 6406},
	{56606, 221696, 2, 4462},
	{56629, 221700, 2, 4462},
	{56652, 221704, 2, 4462},
	{56675, 221708, 2, 4462},
	{53372, 221712, 5, 1957},
	{53395, 221716, 2, 4462},
	{53418, 221720, 2, 4462},
	{53441, 221724, 2, 4462},
	{56698, 221728, 4, 1962},
	{53921, 221744, 5, 1957},
	{53945, 221748, 5, 1957},
	{53969, 221752, 2, 4462},
	{53993, 221756, 2, 4462},
	{56722, 221760, 4, 1962},
	{56747, 221764, 4, 1962},
	{53895, 221776, 1, 4503},
	{37551, 222208, 5, 1957},
	{37577, 222212, 4, 1962},
	{37604, 222216, 5, 1957},
	{37630, 222220, 4, 1962},
	{37657, 222224, 3, 2013},
	{37710, 222228, 3, 2013},
	{37763, 222464, 5, 1957},
	{37789, 222468, 4, 1962},
	{37816, 222472, 1, 1872},
	{37842, 222476, 1, 1872},
	{37868, 222480, 1, 1872},
	{37894, 222484, 1, 1872},
	{37920, 222488, 1, 1872},
	{37946, 222492, 1, 1872},
	{37972, 222496, 1, 1872},
	{37998, 222720, 5, 1957},
	{38022, 222724, 5, 1957},
	{38046, 222728, 5, 1957},
	{38070, 222732, 5, 1957},
	{38094, 222736, 4, 1962},
	{38119, 222740, 4, 1962},
	{38144, 222744, 4, 1962},
	{38169, 222748, 4, 1962},
	{38194, 222752, 1, 2001},
	{38218, 222756, 1, 2001},
	{38242, 222760, 8, 1966},
	{38263, 222976, 6, 4661},
	{38286, 222980, 6, 4661},
	{38309, 222984, 6, 4661},
	{38332, 222988, 6, 4661},
	{38355, 222992, 6, 4661},
	{38378, 222996, 6, 4661},
	{38401, 223000, 6, 4661},
	{38424, 223004, 6, 4661},
	{38447, 223008, 6, 4661},
	{38470, 223012, 6, 4661},
	{38493, 223016, 6, 4661},
	{38517, 223020, 6, 4661},
	{38541, 223024, 6, 4661},
	{38565, 223028, 6, 4661},
	{38589, 223032, 6, 4661},
	{38613, 223036, 6, 4661},
	{38637, 223104, 9, 4644},
	{56772, 223108, 2, 4693},
	{38657, 223112, 1, 1987},
	{38752, 223488, 5, 1957},
	{38775, 223492, 5, 1957},
	{38798, 223496, 3, 2013},
	{38821, 223500, 3, 2013},
	{38844, 223504, 4, 1962},
	{38868, 223508, 4, 1962},
	{38892, 223744, 5, 1957},
	{38916, 223748, 5, 1957},
	{38940, 223752, 5, 1957},
	{38964, 223756, 5, 1957},
	{38988, 223760, 4, 1962},
	{39013, 224000, 5, 2001},
	{39036, 224004, 4, 2006},
	{39060, 224008, 3, 2010},
	{39083, 224256, 5, 2001},
	{39106, 224260, 4, 2006},
	{39130, 224264, 3, 2010},
	{39153, 224512, 5, 1957},
	{39177, 224516, 4, 1962},
	{39202, 224520, 5, 1957},
	{39226, 224524, 4, 1962},
	{39251, 224528, 3, 2013},
	{39275, 224532, 3, 2013},
	{56792, 224768, 5, 1957},
	{56816, 224772, 4, 1951},
	{56841, 224776, 5, 1957},
	{56865, 224780, 4, 1951},
	{56890, 224784, 3, 2013},
	{56914, 224788, 3, 2013},
	{56938, 224832, 5, 1957},
	{56962, 224836, 4, 1951},
	{56987, 224840, 5, 1957},
	{57011, 224844, 4, 1951},
	{57036, 224848, 3, 2013},
	{57060, 224852, 3, 2013},
	{39976, 225280, 12, 2016},
	{39998, 225284, 5, 2028},
	{40021, 225288, 4, 2033},
	{40045, 225292, 2, 2037},
	{40068, 225296, 2, 2037},
	{40091, 225300, 2, 2037},
	{40114, 225536, 5, 1957},
	{40137, 225540, 4, 1962},
	{40161, 225544, 5, 1957},
	{40184, 225548, 4, 1962},
	{40208, 225552, 5, 1957},
	{40231, 225560, 5, 1957},
	{40254, 225792, 4, 2039},
	{40275, 225796},
	{40304, 225800, 2, 2043},
	{40333, 225804},
	{40359, 225808, 7, 2045},
	{40433, 225812},
	{40456, 225816},
	{57205, 225820, 2, 5295},
	{57238, 225824, 2, 5295},
	{57271, 225828, 2, 5295},
	{57304, 225832, 2, 5295},
	{57336, 225836, 2, 5295},
	{57368, 225840, 2, 5295},
	{57400, 225844, 2, 5295},
	{57433, 225848, 2, 5295},
	{57465, 225856, 2, 5295},
	{57497, 225860, 2, 5295},
	{57530, 225864, 2, 5295},
	{57563, 225868, 2, 5295},
	{57596, 225872, 2, 5295},
	{57628, 225876, 2, 5295},
	{57660, 225880, 2, 5295},
	{57693, 225884, 2, 5295},
	{57726, 225888, 2, 5295},
	{57792, 225896, 2, 5295},
	{40479, 225900},
	{40506, 225904},
	{40388, 225908},
	{40407, 225912},
	{60101, 225932, 2, 5295},
	{60134, 225936, 2, 6419},
	{41397, 226040, 1, 2129},
	{41376, 226044, 1, 2129},
	{41169, 226048, 2, 2119},
	{41186, 226052, 1, 2121},
	{41210, 226056, 1, 2121},
	{41234, 226060, 4, 2122},
	{41260, 226064, 3, 2126},
	{41289, 226068, 1, 687},
	{41318, 226072, 3, 2126},
	{41347, 226076, 1, 687},
	{41424, 226304, 5, 2028},
	{41448, 226308, 4, 2033},
	{41473, 226312, 2, 2037},
	{41497, 226316, 5, 2028},
	{41521, 226320, 4, 2033},
	{41546, 226324, 2, 2037},
	{41570, 226328, 10, 2130},
	{41595, 226560, 5, 2140},
	{41622, 226564, 5, 2140},
	{41649, 226568, 6, 2145},
	{41680, 226608, 5, 2140},
	{41708, 226612, 5, 2140},
	{41736, 226616, 5, 2140},
	{41764, 226620, 5, 2140},
	{41792, 226624, 5, 2140},
	{41820, 226628, 5, 2140},
	{41848, 226632, 5, 2140},
	{41876, 226636, 5, 2140},
	{41904, 226640, 6, 2145},
	{206, 880, 4, 2156},
	{42955, 881},
	{26802, 882},
	{42967, 1008},
	{42978, 1009},
	{26990, 1010, 4, 2160},
	{42989, 1040, 1, 2164},
	{43002, 1041, 5, 2165},
	{43015, 1042, 1, 2170},
	{43028, 1043, 1, 1681},
	{26824, 1045, 7, 2171},
	{43056, 1280, 6, 2190},
	{43071, 1281},
	{26761, 1282},
	{42955, 1283},
	{26802, 1284},
};

static const struct si_field sid_fields_table[] = {
	/* 0 */
	{60167, 0xF},
	{60176, 0xF0},
	{60186, 0x100},
	{60197, 0x200},
	{60202, 0x400},
	{60329, 0x1FF000, 257, 0},
	{60337, 0x800000},
	{60347, 0x8000000},
	{60360, 0x10000000},
	{60366, 0xE0000000},
	/* 10 */
	{60370, 0x1},
	{60374, 0x6},
	{60383, 0x18},
	{60393, 0x20},
	{60398, 0x40},
	{60406, 0x80},
	{60416, 0x100},
	{60427, 0x200},
	{60433, 0x400},
	{60438, 0x800},
	{60444, 0x1000},
	{60455, 0x2000},
	{60460, 0x4000},
	{60465, 0x8000},
	{60216, 0x10000},
	{60480, 0x20000},
	{60488, 0x40000},
	{60500, 0x80000},
	{60508, 0x800000},
	{60519, 0x8000000},
	/* 30 */
	{60531, 0x1FF, 257, 0},
	{60536, 0x400},
	{60544, 0x800},
	{60557, 0x7000},
	{60565, 0x8000},
	{60576, 0xF0000},
	{60587, 0xF00000},
	{60603, 0x1000000},
	{60617, 0x10000000},
	{60629, 0xE0000000},
	/* 40 */
	{55630, 0xF},
	{60637, 0x30},
	{60645, 0xC0},
	{60653, 0xF00},
	{60659, 0x1000},
	{29039, 0x6000},
	{60665, 0x8000},
	{60677, 0xF0000},
	{60683, 0xF00000},
	{60689, 0x7000000},
	{60698, 0x38000000},
	{60707, 0xC0000000},
	/* 52 */
	{60713, 0xFF},
	{60723, 0xFF00},
	{60733, 0xFF0000},
	{60743, 0xF000000},
	/* 56 */
	{60753, 0x1FF},
	{60762, 0x1FF000},
	{60771, 0xF000000},
	/* 59 */
	{60788, 0xF},
	{60795, 0x70},
	{60803, 0x80},
	{60817, 0xF00},
	{60826, 0x7000},
	{60835, 0x8000},
	{60848, 0x3F0000},
	{60853, 0xC00000},
	{60863, 0x1000000},
	{60877, 0x2000000},
	{60889, 0xFC000000},
	/* 70 */
	{1283, 0xFFFF},
	/* 71 */
	{60617, 0x1},
	{60896, 0x2},
	{60902, 0x4},
	{60916, 0x8},
	{60931, 0x3F0},
	{60936, 0x1F800},
	{60848, 0xFC0000},
	{60941, 0x1000000},
	{60951, 0xFE000000},
	/* 80 */
	{55630, 0x1F},
	{60637, 0x300},
	{60960, 0x3C00},
	{60967, 0x10000},
	{29039, 0xC0000},
	/* 85 */
	{60689, 0xF},
	{60645, 0x30},
	{60707, 0x300},
	{60698, 0x7000},
	{60973, 0x1F0000},
	{60683, 0xF000000},
	{60979, 0x60000000},
	/* 92 */
	{60992, 0x1},
	{61000, 0x6},
	/* 94 */
	{61015, 0x3},
	/* 95 */
	{30503, 0x3F},
	{10252, 0xFC0},
	{10270, 0x3F000},
	{30478, 0xFC0000},
	/* 99 */
	{61024, 0x3},
	{61038, 0x80},
	{61056, 0x300},
	{61066, 0x400},
	{61079, 0x800},
	{60608, 0x1000},
	{61086, 0x2000},
	/* 106 */
	{61096, 0xF},
	{61119, 0x10},
	{61142, 0x20},
	{61165, 0x40},
	{61185, 0x80},
	{61205, 0x100},
	{61225, 0x200},
	{61245, 0x400},
	{61265, 0x800},
	{61285, 0x1000},
	{61305, 0x2000},
	{61325, 0x4000},
	{61340, 0x8000},
	{61351, 0x10000},
	{61359, 0x20000},
	{61368, 0x40000},
	{61385, 0x80000},
	{61400, 0x100000},
	{61413, 0x200000},
	{61423, 0x400000},
	{61440, 0x800000},
	{61457, 0x1000000},
	{61466, 0x2000000},
	{61475, 0x10000000},
	{61484, 0x20000000},
	{61493, 0x40000000},
	{61502, 0x80000000},
	/* 133 */
	{61513, 0xF},
	{61536, 0x20},
	{61552, 0x80},
	{61575, 0x100},
	{61598, 0x200},
	{61617, 0x1000},
	{61626, 0x2000},
	{61635, 0x4000},
	{61643, 0x8000},
	{61652, 0x10000},
	{61667, 0x100000},
	{61675, 0x200000},
	{61683, 0x400000},
	{61692, 0x800000},
	{61701, 0x1000000},
	{61709, 0x2000000},
	{61717, 0x4000000},
	{61725, 0x10000000},
	{61467, 0x20000000},
	{61743, 0x40000000},
	{61751, 0x80000000},
	/* 154 */
	{61617, 0x2},
	{61626, 0x4},
	{61762, 0x8},
	{61466, 0x10},
	{61773, 0x20},
	{61359, 0x200000},
	{61692, 0x400000},
	{61709, 0x1000000},
	{61635, 0x2000000},
	{61667, 0x4000000},
	{61683, 0x8000000},
	{61701, 0x20000000},
	{61717, 0x40000000},
	{61743, 0x80000000},
	/* 168 */
	{61784, 0x20},
	{61813, 0x40},
	{61844, 0x80},
	{61873, 0x100},
	{61893, 0x200},
	{61913, 0x400},
	{61933, 0x800},
	{61953, 0x2000},
	{61961, 0x4000},
	{61969, 0x8000},
	{61773, 0x10000},
	{61980, 0x10000000},
	{61994, 0x20000000},
	{61762, 0x40000000},
	{62003, 0x80000000},
	/* 183 */
	{62012, 0x1},
	{62022, 0x2},
	{62032, 0x4},
	{62041, 0x8},
	{62050, 0x10},
	{62061, 0x20},
	{62072, 0x40},
	{62082, 0x80},
	{62092, 0x400},
	{62102, 0x800},
	{62119, 0x1000},
	{62127, 0x2000},
	{62140, 0x4000},
	{62158, 0x8000},
	{62169, 0x10000},
	{62178, 0x20000},
	{62199, 0x40000},
	{62210, 0x80000},
	{62237, 0x20000000},
	{62250, 0x40000000},
	{61484, 0x80000000},
	/* 204 */
	{62263, 0x1},
	{62278, 0x2},
	{62298, 0x4},
	{62314, 0x8},
	{62332, 0x10},
	{62352, 0x20},
	{62371, 0x40},
	{62390, 0x80},
	{62403, 0x100},
	{62417, 0x200},
	{62441, 0x400},
	{62457, 0x800},
	{62473, 0x1000},
	{62489, 0x2000},
	{62505, 0x10000},
	{62520, 0x20000},
	{62540, 0x40000},
	{62556, 0x80000},
	{62574, 0x100000},
	{62594, 0x200000},
	{62613, 0x400000},
	{62632, 0x800000},
	{62645, 0x1000000},
	{62659, 0x2000000},
	{62683, 0x4000000},
	{62699, 0x8000000},
	{62715, 0x10000000},
	{62731, 0x20000000},
	/* 232 */
	{62747, 0x8},
	{62766, 0x10},
	{62786, 0x40},
	{62805, 0x100},
	{62826, 0x200},
	{62844, 0x400},
	{62867, 0x2000},
	{62889, 0x10000},
	{62910, 0x20000},
	{62928, 0x40000},
	{62951, 0x200000},
	{62973, 0x400000},
	{62997, 0x800000},
	{63021, 0x1000000},
	{63044, 0x2000000},
	/* 247 */
	{63066, 0x1},
	{63085, 0x2},
	{63094, 0x10},
	{63109, 0x20},
	{63123, 0x40},
	{63142, 0x80},
	{63161, 0x100},
	{63176, 0x200},
	{63193, 0x400},
	{63215, 0x800},
	{63237, 0x1000},
	{63252, 0x2000},
	{62092, 0x4000},
	{63267, 0x8000},
	{63276, 0x10000},
	{62127, 0x20000},
	{63285, 0x40000},
	{63295, 0x80000},
	{63309, 0x100000},
	{63323, 0x200000},
	{63337, 0x400000},
	{62158, 0x800000},
	{63354, 0x1000000},
	{63367, 0x4000000},
	{63380, 0x8000000},
	{63393, 0x30000000},
	{63412, 0x40000000},
	{61475, 0x80000000},
	/* 275 */
	{63425, 0x1},
	{63443, 0x2},
	{63457, 0x4},
	{63476, 0x8},
	{63495, 0x10},
	{63510, 0x20},
	{63528, 0x40},
	{63546, 0x80},
	{63563, 0x100},
	{63578, 0x200},
	{63592, 0x400},
	{63609, 0x800},
	{63633, 0x1000},
	{63651, 0x2000},
	{63669, 0x4000},
	{63690, 0x8000},
	{63714, 0x10000},
	{63740, 0x20000},
	{63757, 0x40000},
	{63777, 0x80000},
	{63797, 0x100000},
	{63817, 0x200000},
	{63838, 0x400000},
	{63861, 0x800000},
	{63882, 0x1000000},
	{63901, 0x2000000},
	{63918, 0x4000000},
	{63934, 0x8000000},
	{63950, 0x10000000},
	{63966, 0x20000000},
	{63985, 0x40000000},
	{63997, 0x80000000},
	/* 307 */
	{64009, 0x1},
	{64028, 0x2},
	{64048, 0x4},
	{64068, 0x8},
	{64088, 0x20},
	{64109, 0x40},
	{62973, 0x80},
	{62997, 0x100},
	{64130, 0x200},
	{64157, 0x400},
	{64184, 0x800},
	{64205, 0x1000},
	{64224, 0x2000},
	/* 320 */
	{64243, 0x1},
	{64257, 0x4},
	{64272, 0x8},
	{64289, 0x80},
	{64301, 0x100},
	{64314, 0x400},
	{64329, 0x800},
	{64344, 0x1000},
	{64359, 0x2000},
	/* 329 */
	{2025, 0x3F},
	/* 330 */
	{2043, 0x1FF},
	{64374, 0x80000000},
	/* 332 */
	{2025, 0x7},
	/* 333 */
	{64399, 0x1000},
	{64421, 0x4000},
	{64446, 0x20000},
	{64467, 0x40000},
	{64491, 0x400000},
	{64518, 0x800000},
	{64543, 0x1000000},
	{64566, 0x8000000},
	{64586, 0x40000000},
	/* 342 */
	{2030, 0xF},
	/* 343 */
	{10231, 0xF},
	{38, 0x3FFFFF00},
	/* 345 */
	{783, 0x1FFFFFFF},
	{64602, 0x80000000},
	/* 347 */
	{64612, 0x3},
	{64621, 0xF0},
	{64629, 0x200},
	{64636, 0x1FC00},
	/* 351 */
	{64907, 0xFFF, 2049, 257},
	{65069, 0xFF0000, 129, 2306},
	{65081, 0x3000000},
	{65094, 0x80000000},
	/* 355 */
	{1153, 0x3},
	{65109, 0x4},
	{65118, 0x8},
	{65129, 0x10},
	{65142, 0x20},
	{54917, 0x1C0},
	{65156, 0x200},
	{65169, 0x400},
	{65182, 0x800},
	{65194, 0x1000},
	{65212, 0x2000},
	{65223, 0xC000},
	{65238, 0x30000},
	{65246, 0x40000},
	{65265, 0x80000},
	{65282, 0x40000000},
	{65294, 0x80000000},
	/* 372 */
	{65308, 0xFFF},
	{65323, 0xFFF000},
	{65335, 0x1000000},
	{61346, 0x2000000},
	{65343, 0x4000000},
	{65363, 0x8000000},
	/* 378 */
	{14096, 0xF},
	{65451, 0x3F0, 33, 2435},
	{65455, 0x400},
	{65330, 0x800},
	{65461, 0x1000},
	/* 383 */
	{65464, 0xFFFF},
	{19846, 0x3FFF0000},
	{65480, 0x40000000},
	{65494, 0x80000000},
	/* 387 */
	{65509, 0x7},
	{65519, 0x38},
	{65529, 0x1C0},
	{65539, 0xE00},
	{17473, 0x7F000, 293, 2468},
	{69776, 0x600000},
	{69789, 0x800000},
	{69804, 0x1000000},
	{69910, 0x30000000, 4, 2761},
	{220, 0xC0000000},
	/* 397 */
	{69921, 0x7},
	{69929, 0x38},
	{69937, 0x1C0},
	{69945, 0xE00},
	{69961, 0x7000},
	{69980, 0x8000},
	{69999, 0x70000},
	{70015, 0x80000},
	{70030, 0x100000},
	{70044, 0x7E00000},
	{70055, 0x8000000},
	{70067, 0x10000000},
	{70085, 0x60000000},
	{70097, 0x80000000},
	/* 411 */
	{70110, 0xFFF},
	{70118, 0xFFF000},
	{70126, 0xF000000},
	{70135, 0xF0000000},
	/* 415 */
	{70142, 0x3FFF},
	{70151, 0xFFF},
	{70168, 0x3000},
	{70186, 0xFC000},
	{70199, 0x300000},
	{70213, 0xC00000},
	{70227, 0x3000000},
	{70236, 0xC000000},
	{70247, 0x10000000},
	{70266, 0x20000000},
	{70281, 0x40000000},
	{70296, 0x80000000},
	/* 427 */
	{70151, 0xFFF},
	{70168, 0xC0000000},
	/* 429 */
	{70312, 0x1FFFFF},
	{70331, 0xE00000},
	{70350, 0x1000000},
	{70372, 0x2000000},
	{70394, 0x4000000},
	{70410, 0x8000000},
	{70427, 0x10000000},
	{70445, 0x20000000},
	{70461, 0xC0000000},
	/* 438 */
	{70482, 0x7},
	{70492, 0x38},
	{70513, 0xC0},
	{70534, 0x180000},
	{70553, 0xC000000},
	/* 443 */
	{70923, 0x3C, 16, 2765},
	{71351, 0x7C0, 19, 2781},
	{71541, 0x3800, 7, 2800},
	{71700, 0x1C00000, 5, 2807},
	{71720, 0x6000000},
	/* 448 */
	{71825, 0x3, 4, 2812},
	{71932, 0xC, 4, 2816},
	{72044, 0x30, 4, 2820},
	{72131, 0xC0, 4, 2824},
	/* 452 */
	{65464, 0xFF},
	{70110, 0xFFF00},
	{17473, 0x1FF00000, 293, 2468},
	{72141, 0xC0000000},
	/* 456 */
	{72150, 0xFFF},
	{71937, 0xFFFC000},
	{69804, 0x80000000},
	/* 459 */
	{65509, 0x7},
	{65519, 0x38},
	{65529, 0x1C0},
	{65539, 0xE00},
	{72159, 0xF000},
	{72170, 0xF0000},
	{72181, 0x1F00000},
	{72285, 0xE000000, 6, 2828},
	{220, 0xF0000000},
	/* 468 */
	{18619, 0x1FFF},
	{72296, 0x1FFF0000},
	/* 470 */
	{72307, 0xF},
	{72319, 0xF0},
	{72327, 0xFFF00},
	{72340, 0x700000},
	{72349, 0x800000},
	{72364, 0x2000000},
	{72379, 0x4000000},
	/* 477 */
	{72391, 0xFF},
	{72407, 0x400},
	{72419, 0x18000},
	{72447, 0x60000},
	{72473, 0x80000},
	{72491, 0x100000},
	{72513, 0x200000},
	{72528, 0x400000},
	{72544, 0x800000},
	{72560, 0xFF000000},
	/* 487 */
	{72581, 0xFFFF},
	/* 488 */
	{72581, 0xFFFF},
	{72587, 0x3F0000},
	{72598, 0x3C00000},
	/* 491 */
	{72617, 0xFF},
	/* 492 */
	{72626, 0x3F},
	{72632, 0x3C0},
	{70322, 0xC00},
	{72722, 0xFF000, 193, 2834},
	{60393, 0x100000},
	{60186, 0x200000},
	{72733, 0x800000},
	{72743, 0x1000000},
	{72760, 0x2000000},
	{61066, 0x4000000},
	{60337, 0x20000000},
	/* 503 */
	{72772, 0x1},
	{72783, 0x3E},
	{72793, 0x40},
	{72806, 0x80},
	{72818, 0xFF00},
	{60329, 0x1FF0000, 257, 0},
	{72833, 0x2000000},
	{72855, 0x4000000},
	{72880, 0x8000000},
	{72894, 0xF0000000},
	/* 513 */
	{72910, 0x1},
	{72927, 0x1E},
	{72953, 0x1E0},
	{72986, 0x200},
	{73007, 0x7C00},
	{73031, 0x8000},
	{73056, 0x10000},
	{73075, 0xE0000},
	/* 521 */
	{73112, 0x7},
	{73141, 0x38},
	{73173, 0x40},
	{73189, 0xFF00},
	{73218, 0xFF0000},
	/* 526 */
	{73250, 0x7F},
	/* 527 */
	{72592, 0x3F},
	/* 528 */
	{72626, 0x3F},
	{72632, 0x3C0},
	{70322, 0xC00},
	{72722, 0xFF000, 193, 2834},
	{60393, 0x100000},
	{60186, 0x200000},
	{72733, 0x800000},
	{73263, 0x3000000},
	{73277, 0x4000000},
	{72760, 0x8000000},
	{61066, 0x10000000},
	{60337, 0x80000000},
	/* 540 */
	{72772, 0x1},
	{72783, 0x3E},
	{72793, 0x40},
	{73293, 0x80},
	{73303, 0x100},
	{73315, 0x200},
	{73327, 0x400},
	{73339, 0x800},
	{73351, 0x1000},
	{60329, 0x3FE000, 257, 0},
	{73357, 0x400000},
	{73368, 0x1000000},
	{72880, 0x8000000},
	{72894, 0xF0000000},
	/* 554 */
	{72772, 0x1},
	{72783, 0x3E},
	{72793, 0x40},
	{60329, 0xFF80, 257, 0},
	{73263, 0x30000},
	{73293, 0x40000},
	{60762, 0x7F80000},
	{73385, 0x8000000},
	{72880, 0x10000000},
	/* 563 */
	{72772, 0x1},
	{72783, 0x3E},
	{72793, 0x40},
	{73293, 0x80},
	{60329, 0x1FF00, 257, 0},
	{60762, 0x1FF00000},
	/* 569 */
	{72772, 0x1},
	{72783, 0x3E},
	{72793, 0x40},
	{60762, 0xFF80},
	{60329, 0x1FF0000, 257, 0},
	/* 574 */
	{72581, 0xFFFF},
	{73397, 0x7F0000},
	/* 576 */
	{72581, 0xFFFF},
	{72587, 0x3F0000},
	{72598, 0x3C00000},
	{73422, 0xFC000000},
	/* 580 */
	{72626, 0x3F},
	{72632, 0x3C0},
	{70322, 0xC00},
	{72722, 0xFF000, 193, 2834},
	{60393, 0x100000},
	{60186, 0x200000},
	{72733, 0x800000},
	{73277, 0x1000000},
	{72760, 0x2000000},
	{61066, 0x4000000},
	{73439, 0x8000000},
	{73448, 0x60000000},
	{60337, 0x80000000},
	/* 593 */
	{72772, 0x1},
	{72783, 0x3E},
	{72793, 0x40},
	{60329, 0xFF80, 257, 0},
	{73465, 0x30000},
	{73293, 0x40000},
	{60762, 0x7F80000},
	{72880, 0x8000000},
	{72894, 0xF0000000},
	/* 602 */
	{72626, 0x3F},
	{72632, 0x3C0},
	{70322, 0xC00},
	{72722, 0xFF000, 193, 2834},
	{60393, 0x100000},
	{60186, 0x200000},
	{72733, 0x800000},
	{73263, 0x3000000},
	{73277, 0x4000000},
	{60337, 0x80000000},
	/* 612 */
	{72587, 0x3F},
	{72598, 0x3C0},
	{73422, 0xFC00},
	{72581, 0xFFFF0000},
	/* 616 */
	{72626, 0x3F},
	{72632, 0x3C0},
	{70322, 0xC00},
	{72722, 0xFF000, 193, 2834},
	{60393, 0x100000},
	{60186, 0x200000},
	{72733, 0x800000},
	{72760, 0x1000000},
	{61066, 0x2000000},
	{73439, 0x4000000},
	{73482, 0x30000000},
	{60337, 0x40000000},
	/* 628 */
	{72772, 0x1},
	{72783, 0x3E},
	{72793, 0x40},
	{73293, 0x80},
	{73499, 0x100},
	{60329, 0x3FE00, 257, 0},
	{60762, 0x7FC0000},
	{72880, 0x8000000},
	{72894, 0xF0000000},
	/* 637 */
	{72626, 0x3F},
	{72632, 0x3C0},
	{70322, 0xC00},
	{72722, 0xFF000, 193, 2834},
	{60393, 0x100000},
	{60186, 0x200000},
	{72733, 0x800000},
	{73263, 0x3000000},
	{60337, 0x40000000},
	/* 646 */
	{73510, 0x1},
	{73528, 0x2},
	{73542, 0x4},
	{73561, 0x8},
	{73581, 0x10},
	{73601, 0x20},
	{73623, 0x40},
	{73634, 0x400},
	{73652, 0x800},
	{10536, 0x1000},
	{73670, 0x2000},
	{73684, 0x4000},
	{73692, 0x8000},
	/* 659 */
	{73702, 0xFFFF},
	{73718, 0xFFFF0000},
	/* 661 */
	{10040, 0x1},
	/* 662 */
	{10068, 0x1},
	/* 663 */
	{402, 0xFF},
	/* 664 */
	{72626, 0x3F},
	{72632, 0x3C0},
	{70322, 0xC00},
	{72722, 0xFF000, 193, 2834},
	{60393, 0x100000},
	{60186, 0x200000},
	{72733, 0x800000},
	{73737, 0x1000000},
	{60337, 0x4000000},
	{73439, 0x20000000},
	{72760, 0x40000000},
	{61066, 0x80000000},
	/* 676 */
	{72772, 0x1},
	{72783, 0x3E},
	{72793, 0x40},
	{73743, 0x80},
	{73753, 0x100},
	{73763, 0x200},
	{73499, 0x400},
	{73773, 0x1800},
	{73788, 0x6000},
	{60762, 0xFF8000},
	{60329, 0x7F000000, 257, 0},
	/* 687 */
	{402, 0xF},
	/* 688 */
	{73800, 0x3FF},
	{73813, 0xF000},
	{73823, 0x3F0000},
	{73838, 0x400000},
	{73853, 0x800000},
	{73869, 0x7000000},
	/* 694 */
	{73884, 0xFFF},
	{73890, 0x1FFF000},
	/* 696 */
	{10503, 0x1},
	/* 697 */
	{73899, 0x3},
	{71006, 0x4},
	{73909, 0x8},
	{73919, 0x10},
	{73929, 0x1FFE0},
	/* 702 */
	{72910, 0x1},
	{72927, 0x1E},
	{72953, 0x1E0},
	{72986, 0x200},
	{73007, 0x7C00},
	{73031, 0x8000},
	{73056, 0x10000},
	{73075, 0xE0000},
	{73942, 0x7F00000},
	/* 711 */
	{72894, 0xF},
	/* 712 */
	{452, 0x7FF},
	/* 713 */
	{73979, 0x3FFFFFFF},
	{73987, 0x40000000},
	{73996, 0x80000000},
	/* 716 */
	{11785, 0xFFFF},
	/* 717 */
	{74005, 0x3FF},
	{64775, 0x400},
	/* 719 */
	{74015, 0x1},
	{74034, 0x2},
	{74055, 0x4},
	{74066, 0x8},
	{74079, 0x10},
	{74098, 0x20},
	{74123, 0x40},
	{74146, 0x80},
	{74160, 0xF00},
	{74172, 0x1000},
	/* 729 */
	{74190, 0x1},
	{74214, 0x2},
	{74235, 0x4},
	{74269, 0x8},
	{74304, 0x70},
	{74316, 0xF00},
	{74329, 0xF000},
	{74342, 0xF0000},
	{74355, 0xF00000},
	{74369, 0xF000000},
	{74387, 0xF0000000},
	/* 740 */
	{74404, 0x7FF},
	{74416, 0x1800},
	{74431, 0xFFE000},
	{74441, 0x1000000},
	{74453, 0x2000000},
	{74471, 0x3C000000},
	{74477, 0xC0000000},
	/* 747 */
	{74542, 0x3, 4, 3027},
	{74559, 0xC, 4, 3027},
	{74577, 0x30, 4, 3027},
	{74595, 0x40},
	{74616, 0x80},
	{74631, 0x100},
	{74652, 0x200},
	{74670, 0x400},
	{74687, 0x800},
	{74700, 0x1000},
	{74719, 0x6000, 4, 3027},
	{74738, 0x8000},
	{74762, 0x10000},
	{74785, 0x20000},
	{74802, 0x40000},
	{74887, 0x180000, 4, 3031},
	{74906, 0x3E00000},
	{74923, 0x4000000},
	{74947, 0x8000000},
	{74961, 0x10000000},
	{74981, 0x20000000},
	{74995, 0x40000000},
	{75015, 0x80000000},
	/* 770 */
	{75089, 0x3, 4, 3035},
	{75118, 0x1C},
	{75149, 0x20},
	{75185, 0x40},
	{75220, 0x80},
	{75248, 0x100},
	{75270, 0x200},
	{75288, 0x400},
	{75320, 0x800},
	{75441, 0x7000, 8, 3039},
	{75451, 0x38000},
	{75464, 0x1C0000},
	{75477, 0x200000},
	{75493, 0x400000},
	{75511, 0x800000},
	{75529, 0x2000000},
	/* 786 */
	{75557, 0x3FFF},
	{60161, 0x3FFF0000},
	/* 788 */
	{11403, 0xFF},
	/* 789 */
	{75563, 0xFFFF},
	{75568, 0xFFFF0000},
	/* 791 */
	{75573, 0xFFFF},
	{75578, 0xFFFF0000},
	/* 793 */
	{75592, 0x3, 4, 3047},
	{75606, 0x4},
	{75631, 0x8},
	/* 796 */
	{75649, 0xF},
	{75657, 0xF0},
	{75665, 0x1F00},
	{75673, 0x6000},
	{75681, 0x18000},
	{75689, 0x60000},
	{75697, 0x180000},
	{69804, 0xF0000000},
	/* 804 */
	{17473, 0x3, 4, 3051},
	{75736, 0xC},
	{72181, 0x1F0},
	{75791, 0x600, 4, 3055},
	{75806, 0x800},
	{75820, 0x1000},
	{75839, 0xE000},
	{75856, 0xF0000},
	{72407, 0x100000},
	{75863, 0x7800000},
	{75887, 0x8000000},
	{75902, 0x10000000},
	{75912, 0x20000000},
	{75932, 0x80000000},
	/* 818 */
	{17473, 0x1, 2, 3059},
	{72181, 0x1F0},
	{75791, 0x600, 4, 3055},
	{75806, 0x800},
	{75820, 0x1000},
	{75839, 0xE000},
	{72407, 0x100000},
	{75887, 0x8000000},
	{75975, 0x20000000},
	/* 827 */
	{75649, 0x7FF},
	{75657, 0x3FF800},
	/* 829 */
	{75649, 0x3FFFFF},
	/* 830 */
	{10231, 0xFF},
	/* 831 */
	{76047, 0x3, 4, 3061},
	{76059, 0xC, 4, 3061},
	{76071, 0x30, 4, 3061},
	{76087, 0xC0, 4, 3061},
	{76157, 0x30000, 4, 3065},
	{76169, 0xC0000, 4, 3065},
	{76181, 0x300000, 4, 3065},
	{76197, 0x1000000},
	{76208, 0x2000000},
	/* 840 */
	{30712, 0xFF},
	/* 841 */
	{76219, 0xFF},
	/* 842 */
	{76237, 0xFFFF},
	{76253, 0xFFFF0000},
	/* 844 */
	{75563, 0x7FFF},
	{75568, 0x7FFF0000},
	{76269, 0x80000000},
	/* 847 */
	{75573, 0x7FFF},
	{75578, 0x7FFF0000},
	/* 849 */
	{76357, 0xFFFF, 32769, 3069},
	/* 850 */
	{76367, 0xF},
	{76374, 0xF0},
	{76383, 0xF00},
	{76391, 0x3F000},
	{76402, 0xFC0000},
	{76413, 0xF000000},
	{76424, 0xF0000000},
	/* 857 */
	{76435, 0x1FF},
	{76454, 0x1FF0000},
	/* 859 */
	{76473, 0xF},
	{76488, 0xF0},
	{76503, 0xF00},
	{76518, 0xF000},
	{76533, 0xF0000},
	{76548, 0xF00000},
	{76563, 0xF000000},
	{76578, 0xF0000000},
	/* 867 */
	{76593, 0xF},
	{76608, 0xF0},
	{76623, 0xF00},
	{76638, 0xF000},
	{76653, 0xF0000},
	{76668, 0xF00000},
	{76683, 0xF000000},
	{76698, 0xF0000000},
	/* 875 */
	{76805, 0x3, 4, 35838},
	{76817, 0xC, 4, 35838},
	{76929, 0x30, 4, 35842},
	{76986, 0x40, 2, 35846},
	{77042, 0x80, 2, 35848},
	{77146, 0x300, 4, 35850},
	{77254, 0xC00, 4, 35854},
	{77363, 0x3000, 4, 35858},
	{77476, 0xC000, 4, 35862},
	{77578, 0x30000, 4, 35866},
	{77724, 0xC0000, 4, 35870},
	{77871, 0x300000, 4, 35874},
	{77971, 0x3000000, 4, 35878},
	{78117, 0xC000000, 4, 35882},
	{78264, 0x30000000, 4, 35886},
	/* 890 */
	{78384, 0x3, 4, 35890},
	{78555, 0xC, 4, 35894},
	{78727, 0x30, 4, 35898},
	/* 893 */
	{74369, 0x3},
	{74387, 0xC},
	/* 895 */
	{10053, 0x1},
	{78740, 0x6},
	{70553, 0x60},
	{78747, 0x100},
	{78782, 0x3000},
	{78789, 0x30000},
	{78803, 0x100000},
	/* 902 */
	{78821, 0x80000000},
	/* 903 */
	{60645, 0x3},
	/* 904 */
	{10283, 0xF},
	/* 905 */
	{78836, 0xFF},
	{78845, 0xFF00},
	{78855, 0xFF0000},
	{78866, 0xFF000000},
	/* 909 */
	{78876, 0xFF},
	{78884, 0xFF00},
	{78893, 0xFF0000},
	{78902, 0xFF000000},
	/* 913 */
	{78910, 0x3, 4, 3061},
	{78926, 0xC, 4, 3061},
	{78942, 0x30, 4, 3061},
	{78956, 0xC0, 4, 3061},
	{78972, 0x30000, 4, 3065},
	{78988, 0xC0000, 4, 3065},
	{79004, 0x300000, 4, 3065},
	{79018, 0xC00000, 4, 3065},
	{79034, 0x40000000},
	{79049, 0x80000000},
	/* 923 */
	{79064, 0x1},
	{79091, 0x7C},
	{79120, 0x100},
	{79149, 0x200},
	{79180, 0x400},
	{79208, 0x1000},
	{79236, 0x2000},
	{79266, 0x4000},
	/* 931 */
	{79292, 0x1},
	{79312, 0xE},
	{79329, 0x30},
	{79350, 0xF00},
	/* 935 */
	{79608, 0xF, 16, 35902},
	{79620, 0xF0, 16, 35902},
	{79633, 0xF00, 16, 35902},
	{79646, 0xF000, 16, 35902},
	{79661, 0xF0000, 16, 35902},
	{79677, 0xF00000, 16, 35902},
	/* 941 */
	{79693, 0xFF},
	{79708, 0xFF00},
	{79720, 0xFF0000},
	{79737, 0xFF000000},
	/* 945 */
	{79750, 0xFF},
	{79768, 0xFF00},
	{79783, 0xFF0000},
	{79803, 0xFF000000},
	/* 949 */
	{783, 0x3F},
	{79819, 0x300},
	{79831, 0x400},
	{79842, 0x1E000},
	{79851, 0x20000},
	{79865, 0x40000},
	{79869, 0x80000},
	{79886, 0x100000},
	{79904, 0x600000},
	{79922, 0x800000},
	{79942, 0x1000000},
	{79954, 0x2000000},
	/* 961 */
	{783, 0x3F},
	{79819, 0x300},
	{79831, 0x400},
	{79865, 0x40000},
	{79869, 0x80000},
	{79886, 0x100000},
	{79904, 0x600000},
	{79942, 0x1000000},
	{79954, 0x2000000},
	/* 970 */
	{79966, 0x3E},
	{79982, 0x40},
	{79995, 0x80},
	/* 973 */
	{80008, 0x1},
	{80025, 0x2},
	{80042, 0x4},
	{80061, 0x8},
	{80082, 0x10},
	{80100, 0x20},
	{80118, 0x40},
	{80138, 0x80},
	{80159, 0x100},
	{80175, 0x200},
	{80191, 0x400},
	{80207, 0x800},
	{80223, 0x1000},
	{80238, 0x2000},
	{80252, 0x4000},
	{80272, 0x8000},
	/* 989 */
	{80289, 0x1},
	{80304, 0x2},
	{80427, 0x1C, 5, 35918},
	{80445, 0xE0, 5, 35918},
	{80463, 0x700, 5, 35918},
	{80481, 0x3800, 5, 35918},
	{80499, 0x4000},
	/* 996 */
	{80516, 0x3F},
	{80527, 0x40},
	{80537, 0x80},
	{80554, 0x100},
	{80570, 0x4000},
	{80590, 0x8000},
	/* 1002 */
	{80600, 0x1},
	{80618, 0x10},
	{80638, 0x100},
	{80657, 0x1000},
	{80678, 0x30000},
	{80697, 0x100000},
	{80711, 0x1000000},
	/* 1009 */
	{80819, 0xF, 5, 35923},
	/* 1010 */
	{80838, 0xF, 5, 35923},
	{80857, 0xF0, 5, 35923},
	{80876, 0xF00, 5, 35923},
	{80895, 0xF000, 5, 35923},
	{80914, 0xF0000, 5, 35923},
	/* 1015 */
	{81133, 0xF, 10, 35928},
	/* 1016 */
	{81149, 0xF, 10, 35928},
	{81168, 0xF0, 10, 35928},
	{81187, 0xF00, 10, 35928},
	{81206, 0xF000, 10, 35928},
	{81225, 0xF0000, 10, 35928},
	{81244, 0xF00000, 10, 35928},
	{81263, 0xF000000, 10, 35928},
	{81282, 0xF0000000, 10, 35928},
	/* 1024 */
	{81536, 0xF, 11, 35938},
	{81541, 0xF0, 11, 35938},
	{81546, 0xF00, 11, 35938},
	{81551, 0xF000, 11, 35938},
	{81556, 0xF0000, 11, 35938},
	{81561, 0xF00000, 11, 35938},
	{81566, 0xF000000, 11, 35938},
	{81571, 0xF0000000, 11, 35938},
	/* 1032 */
	{81650, 0xF, 16, 35949},
	{81663, 0xF0},
	{81676, 0xF00},
	{81689, 0xF000},
	{81702, 0xF0000},
	{81715, 0xF00000},
	{81728, 0xF000000},
	{81741, 0xF0000000},
	/* 1040 */
	{81754, 0x1},
	{81777, 0x2},
	{81800, 0x10},
	{81823, 0x20},
	{81846, 0x100},
	{81869, 0x200},
	{81892, 0x1000},
	{81915, 0x2000},
	{81938, 0x10000},
	{81961, 0x20000},
	{81984, 0x100000},
	{82007, 0x200000},
	{82030, 0x1000000},
	{82053, 0x2000000},
	{82076, 0x10000000},
	{82099, 0x20000000},
	{82122, 0x80000000},
	/* 1057 */
	{82413, 0x7, 8, 35965},
	{82427, 0x70, 8, 35965},
	{82575, 0x700, 8, 35973},
	{82590, 0x70000, 8, 35965},
	{82604, 0x700000, 8, 35965},
	{82618, 0x7000000, 8, 35973},
	/* 1063 */
	{83073, 0x1F, 21, 35981},
	{82575, 0xE0, 5, 36002},
	{83178, 0x1F00, 21, 35981},
	{83194, 0x1F0000, 21, 35981},
	{82618, 0xE00000, 5, 36002},
	{83209, 0x1F000000, 21, 35981},
	{83225, 0x20000000},
	{10053, 0x40000000},
	{83246, 0x80000000},
	/* 1072 */
	{83259, 0x7},
	/* 1073 */
	{11780, 0xFFFF},
	/* 1074 */
	{83350, 0x3, 4, 36007},
	{83396, 0xC, 2, 36011},
	{83407, 0x10},
	{83422, 0x20},
	{83430, 0x40},
	{83441, 0x80},
	{83455, 0x100},
	{83472, 0xE0000000},
	/* 1082 */
	{83485, 0xFFFFFFF},
	/* 1083 */
	{83497, 0x3FF},
	/* 1084 */
	{83520, 0x1},
	{74550, 0x2},
	{83535, 0x4},
	{83550, 0x8},
	{75445, 0x70, 8, 3039},
	{83570, 0x80},
	{83586, 0x700, 8, 3039},
	{83598, 0x700000, 8, 3039},
	{83613, 0x40000000},
	{83647, 0x80000000},
	/* 1094 */
	{83682, 0x7},
	{83701, 0x70},
	{83717, 0x700},
	{83741, 0x7000},
	{83767, 0x10000},
	{83794, 0x20000},
	{83816, 0x40000},
	{83835, 0x80000},
	{83853, 0x100000},
	{83880, 0x200000},
	{83907, 0x7000000},
	{83932, 0x8000000},
	/* 1106 */
	{83963, 0x1},
	{83981, 0x8},
	{1153, 0x70, 8, 36013},
	{83254, 0xFF0000, 256, 36021},
	/* 1110 */
	{84401, 0x1},
	{84417, 0x2},
	{84448, 0x4},
	{74608, 0x30, 4, 36277},
	{84527, 0x40},
	{84539, 0x80},
	{84563, 0x100},
	{84582, 0x200},
	{84600, 0x400},
	{84613, 0x800},
	{84635, 0x1000},
	{84725, 0x6000, 4, 36281},
	{84747, 0x8000},
	{84765, 0x10000},
	{84796, 0x20000},
	{84815, 0x700000},
	{84840, 0x800000},
	/* 1127 */
	{84873, 0x1},
	{84883, 0x2},
	{84893, 0x4},
	{84903, 0x8},
	{84913, 0x10},
	{84923, 0x20},
	{84933, 0x2000},
	{84952, 0xC000},
	{84964, 0x10000},
	{84977, 0x20000},
	{84995, 0x40000},
	{85018, 0x80000},
	{85036, 0x100000},
	{85056, 0x200000},
	{85068, 0x400000},
	{85090, 0x1000000},
	{85114, 0x2000000},
	{85140, 0x4000000},
	{85159, 0x8000000},
	{85177, 0x10000000},
	/* 1147 */
	{85197, 0x1},
	{85208, 0x2},
	{19347, 0x4},
	{85228, 0x18, 2, 36285},
	{85294, 0xE0, 3, 36287},
	{85315, 0x700, 3, 36287},
	{85335, 0x800},
	{85360, 0x1000},
	{85384, 0x2000},
	{85408, 0x10000},
	{85433, 0x80000},
	{85452, 0x100000},
	{85467, 0x200000},
	{85485, 0x400000},
	{85523, 0x800000},
	{85546, 0x1000000},
	/* 1163 */
	{85567, 0x1},
	{85585, 0x2},
	{85604, 0x4},
	{85622, 0x8},
	{85641, 0x10},
	{85659, 0x20},
	{85678, 0x100},
	{85689, 0x200},
	{85699, 0x400},
	{85710, 0x800},
	/* 1173 */
	{85726, 0x1},
	{85742, 0x2},
	{85758, 0x4},
	{85774, 0x8},
	{85790, 0x10},
	{85806, 0x20},
	{85822, 0x40},
	{85838, 0x80},
	{85854, 0x100},
	{85870, 0x200},
	{85886, 0x400},
	{85902, 0x800},
	{85918, 0x1000},
	{85934, 0x2000},
	{85950, 0x4000},
	{85966, 0x8000},
	{85982, 0x10000},
	{86001, 0x20000},
	{86019, 0x40000},
	{86046, 0x80000},
	{86068, 0x100000},
	{86086, 0x200000},
	{86106, 0x400000},
	{86129, 0x800000},
	{86152, 0x1000000},
	{86177, 0x2000000},
	{86197, 0x4000000},
	{86220, 0x8000000},
	/* 1201 */
	{86239, 0x1},
	{86258, 0x2},
	{86276, 0x4},
	{86294, 0x8},
	{86312, 0x10},
	{86330, 0x20},
	{86347, 0x40},
	{86364, 0x80},
	{86385, 0x100},
	{86402, 0x200},
	{86419, 0x400},
	{86435, 0x800},
	{86451, 0x1000},
	{86467, 0x2000},
	{86483, 0x4000},
	{86508, 0x100000},
	/* 1217 */
	{86528, 0x3},
	{86547, 0x4},
	{86566, 0x8},
	{86583, 0x10},
	/* 1221 */
	{86598, 0x1},
	{86622, 0x2},
	{86642, 0x4},
	{86663, 0x8},
	{86688, 0x10},
	{86708, 0x20},
	{86724, 0x40},
	{86741, 0x80},
	{86762, 0xFF00},
	{86783, 0x40000000},
	{86804, 0x80000000},
	/* 1232 */
	{86826, 0x1},
	{86598, 0x2},
	{86622, 0x4},
	{86642, 0x8},
	{86663, 0x10},
	{86851, 0x20},
	{86864, 0x40},
	/* 1239 */
	{86893, 0x1},
	{86904, 0x2},
	/* 1241 */
	{86922, 0x1},
	{86939, 0x2},
	/* 1243 */
	{86963, 0x1},
	{86988, 0x2},
	{87009, 0x4},
	{87031, 0x8},
	{87057, 0x10},
	/* 1248 */
	{87074, 0x1E},
	{87086, 0xE0},
	{87100, 0xF00},
	{87116, 0x70000},
	{87127, 0x780000},
	/* 1253 */
	{71937, 0xFFFF},
	{71830, 0xFFFF0000},
	/* 1255 */
	{87140, 0xFFFF},
	{19020, 0xFFFF0000},
	/* 1257 */
	{71830, 0xFFFF},
	/* 1258 */
	{87149, 0xFFFF},
	{87162, 0xFF0000},
	{87175, 0x10000000},
	{87193, 0x60000000},
	/* 1262 */
	{87209, 0x7},
	/* 1263 */
	{87221, 0x3},
	/* 1264 */
	{18613, 0xFF},
	/* 1265 */
	{18635, 0x1F, 22, 36290},
	{87580, 0x4000},
	{87593, 0x8000},
	{87606, 0x70000},
	/* 1269 */
	{18655, 0xF},
	/* 1270 */
	{18661, 0xF},
	/* 1271 */
	{87617, 0x1},
	{87627, 0x2},
	{87637, 0x4},
	{87647, 0x8},
	{19846, 0xFF00},
	{87657, 0xFF0000},
	/* 1277 */
	{87663, 0xF},
	{14008, 0xF0},
	{87670, 0xF00},
	{76260, 0xF000},
	{87677, 0xF0000},
	{87684, 0xF00000},
	{87693, 0xF000000},
	{11940, 0xF0000000},
	/* 1285 */
	{1153, 0x7, 6, 36312},
	{87773, 0x8},
	{87829, 0x30, 4, 36318},
	{87838, 0x7C0},
	{87849, 0x800},
	{87862, 0x1000},
	{87873, 0x2000},
	{87885, 0x4000},
	{87898, 0x8000},
	{87916, 0x10000},
	{87932, 0x20000},
	{87951, 0x40000},
	{87965, 0x80000},
	{87983, 0x100000},
	{88001, 0x600000},
	/* 1300 */
	{88008, 0x7FF},
	{88028, 0x3FF800},
	{88048, 0xFFC00000},
	/* 1303 */
	{88072, 0x1},
	{88084, 0x2},
	{88105, 0x4},
	{88125, 0x8},
	{88150, 0x10},
	{88171, 0x20},
	{88194, 0x40},
	/* 1310 */
	{88224, 0x1},
	{88234, 0x2},
	{88249, 0x4},
	{88274, 0x8},
	{88292, 0x70},
	{88308, 0x80},
	{88313, 0x100},
	{88336, 0x200},
	{88355, 0x400},
	{88377, 0x800},
	{88393, 0x1000},
	{88409, 0x2000},
	{88425, 0x4000},
	{88444, 0x8000},
	{88470, 0x10000},
	{88485, 0x20000},
	{88525, 0x40000},
	{88552, 0x80000},
	{88575, 0xF00000},
	{88591, 0x1000000},
	{88621, 0x2000000},
	{88645, 0x4000000},
	{88666, 0x8000000},
	{88696, 0x70000000},
	/* 1334 */
	{18860, 0x7FF},
	/* 1335 */
	{18874, 0x7FF},
	/* 1336 */
	{18888, 0xF},
	/* 1337 */
	{783, 0x7FFF},
	/* 1338 */
	{88720, 0x3F, 4, 36322},
	{88733, 0x3F00, 4, 36322},
	{88748, 0x3F0000, 4, 36322},
	{88763, 0xFC00000, 4, 36322},
	{88778, 0x80000000},
	/* 1343 */
	{214, 0x3, 3, 36326},
	{88915, 0xC, 4, 36329},
	{88995, 0x30, 4, 36333},
	{89055, 0xC0, 3, 36337},
	{89068, 0x100},
	{83422, 0x200},
	{89072, 0x400},
	{89081, 0x3800},
	/* 1351 */
	{19063, 0x1},
	{89087, 0x2},
	{89108, 0x4},
	/* 1354 */
	{90291, 0x3F, 64, 36340},
	{65469, 0x7FFFC00},
	{90302, 0x8000000},
	/* 1357 */
	{19160, 0x1},
	{90317, 0x2},
	/* 1359 */
	{90332, 0x1},
	{90346, 0x2},
	{90362, 0x4},
	{90380, 0x8},
	{90396, 0x10},
	/* 1364 */
	{90407, 0xFFFF},
	{90422, 0x10000},
	{90441, 0x20000},
	{90455, 0x40000},
	{90474, 0x80000},
	{90488, 0x100000},
	/* 1370 */
	{19274, 0x7FFF},
	/* 1371 */
	{19310, 0x1},
	/* 1372 */
	{19324, 0x1},
	/* 1373 */
	{75839, 0x1},
	{90505, 0x2},
	{90516, 0x4},
	{90533, 0x8},
	{90550, 0x3F0},
	{90567, 0xFC00},
	{90584, 0x10000},
	{90608, 0x20000},
	{72478, 0x40000},
	/* 1382 */
	{90625, 0x7, 8, 3039},
	{90638, 0xFF0},
	{90652, 0xFF000},
	{74569, 0x1000000},
	/* 1386 */
	{90665, 0x7, 8, 3039},
	{90678, 0xFF0},
	{90692, 0xFF000},
	{74587, 0x1000000},
	/* 1390 */
	{9929, 0xFF},
	{9945, 0xFF00},
	{90705, 0xFF0000},
	{90711, 0xFF000000},
	/* 1394 */
	{19846, 0x3FF},
	/* 1395 */
	{19839, 0x1FF},
	/* 1396 */
	{19860, 0x7FF},
	/* 1397 */
	{90717, 0x1FF},
	{90733, 0x3FE00},
	/* 1399 */
	{90749, 0xFF},
	{90763, 0xFF00},
	{90773, 0xFF0000},
	{90784, 0x1F000000},
	{90796, 0xE0000000},
	/* 1404 */
	{90856, 0x3, 4, 36404},
	{90887, 0x4, 2, 36408},
	{19929, 0x18, 4, 36410},
	{90969, 0x20, 2, 36414},
	{91034, 0xC0, 4, 36416},
	{91040, 0x100},
	{73368, 0x200},
	{91051, 0x400},
	{91071, 0x800},
	{91091, 0x1000},
	{91105, 0x2000},
	{91116, 0x4000},
	{91132, 0x78000},
	{91152, 0x180000},
	{91167, 0x200000},
	{91177, 0x400000},
	{91187, 0x800000},
	{91197, 0x1000000},
	{91212, 0x2000000},
	/* 1423 */
	{91232, 0xFF},
	{91244, 0x3F00},
	{91260, 0xFC000},
	/* 1426 */
	{220, 0x3, 3, 36420},
	{91366, 0x1C, 4, 36423},
	{91443, 0xE0, 4, 36427},
	{91452, 0x100},
	{91472, 0x200},
	{91483, 0x3C00},
	{91505, 0x4000},
	{89055, 0x18000, 3, 36337},
	{91539, 0x60000, 4, 36431},
	{91598, 0x80000, 3, 36435},
	{91650, 0x100000, 3, 36438},
	{89081, 0x3800000},
	/* 1438 */
	{91662, 0x1},
	{91683, 0x300},
	{91705, 0xC00},
	{91727, 0x3000},
	{91749, 0xC000},
	{91771, 0x10000},
	/* 1444 */
	{91784, 0xFF},
	{91812, 0x100},
	/* 1446 */
	{10053, 0x1},
	{20286, 0x1FC},
	{91840, 0x80000000},
	/* 1449 */
	{91872, 0x1},
	{91887, 0x2},
	{91902, 0x4},
	{91917, 0x8},
	{91932, 0x70},
	{91944, 0x80},
	{91964, 0xF00},
	{91981, 0x80000000},
	/* 1457 */
	{92002, 0xF},
	{92021, 0xF0},
	{92040, 0xF00},
	{92059, 0xF000},
	/* 1461 */
	{92078, 0xF},
	{92089, 0xF0},
	{92100, 0xF00},
	{92111, 0xF000},
	{92122, 0xF0000},
	{92133, 0xF00000},
	{92144, 0xF000000},
	{92155, 0xF0000000},
	/* 1469 */
	{92166, 0xF},
	{92177, 0xF0},
	{92188, 0xF00},
	{92200, 0xF000},
	{92212, 0xF0000},
	{92224, 0xF00000},
	{92236, 0xF000000},
	{92248, 0xF0000000},
	/* 1477 */
	{92260, 0x200},
	{92278, 0x400},
	{92289, 0x800},
	{92314, 0x1000},
	{92336, 0x2000},
	/* 1482 */
	{92358, 0x7},
	{92375, 0x10},
	{92397, 0x1E000},
	{92413, 0x700000},
	{92434, 0x3000000},
	{92514, 0xC000000, 4, 36441},
	/* 1488 */
	{92540, 0x1},
	{92601, 0x6, 4, 36445},
	{92817, 0x38, 8, 36449},
	/* 1491 */
	{92828, 0xF},
	{92833, 0xF0},
	{92838, 0xF00},
	{92843, 0xF000},
	{92848, 0xF0000},
	{92853, 0xF00000},
	{92858, 0xF000000},
	{92863, 0xF0000000},
	/* 1499 */
	{92868, 0xF},
	{92873, 0xF0},
	{92878, 0xF00},
	{92883, 0xF000},
	{92888, 0xF0000},
	{92893, 0xF00000},
	{92898, 0xF000000},
	{92903, 0xF0000000},
	/* 1507 */
	{92908, 0xF},
	{92913, 0xF0},
	{92918, 0xF00},
	{92923, 0xF000},
	{92928, 0xF0000},
	{92934, 0xF00000},
	{92940, 0xF000000},
	{92946, 0xF0000000},
	/* 1515 */
	{92952, 0xF},
	{92958, 0xF0},
	{92964, 0xF00},
	{92970, 0xF000},
	{92976, 0xF0000},
	{92982, 0xF00000},
	{92988, 0xF000000},
	{92994, 0xF0000000},
	/* 1523 */
	{93000, 0xFFFF},
	{93013, 0xFFFF0000},
	/* 1525 */
	{93026, 0xFFFF},
	{93039, 0xFFFF0000},
	/* 1527 */
	{93052, 0x3},
	{72833, 0x4},
	{72855, 0x8},
	{93081, 0x60},
	/* 1531 */
	{93194, 0x3, 4, 36457},
	{93207, 0x4},
	{93218, 0x8},
	{93327, 0x70, 5, 36461},
	{93345, 0x380, 5, 36461},
	{93363, 0x1C00},
	{93386, 0x3E000},
	{93412, 0x40000},
	{93434, 0x7F80000},
	{93450, 0x8000000},
	{93472, 0x10000000},
	{93559, 0x60000000, 3, 36466},
	/* 1543 */
	{93576, 0xFFFF},
	{93592, 0xFFFF0000},
	/* 1545 */
	{93611, 0x1},
	{93628, 0x1E},
	{93652, 0x20},
	{93670, 0x3C0},
	{93695, 0x400},
	{93725, 0x800},
	{93740, 0x1000},
	{93755, 0x2000},
	{93790, 0x4000},
	{93826, 0x8000},
	{93916, 0x30000, 3, 36469},
	{93940, 0x40000},
	{93976, 0x80000},
	{94012, 0x100000},
	{94038, 0x200000},
	{94062, 0x400000},
	{94082, 0x800000},
	{94103, 0x1000000},
	{94128, 0x6000000},
	{94152, 0x18000000},
	/* 1565 */
	{94180, 0x7FF},
	{94201, 0xFF0000},
	/* 1567 */
	{94219, 0xFF},
	/* 1568 */
	{94235, 0x7F},
	/* 1569 */
	{94248, 0x7FF},
	{94257, 0x7FF00000},
	/* 1571 */
	{94248, 0x3FFFFF},
	/* 1572 */
	{74404, 0x1FFF},
	{74431, 0x3FFE000},
	{94272, 0x3C000000},
	/* 1575 */
	{94333, 0x3, 4, 36472},
	{17473, 0x7C, 32, 36476},
	{70573, 0x80},
	{94931, 0x700, 8, 36508},
	{94987, 0x1800, 4, 36516},
	{84030, 0x2000},
	{75024, 0x4000},
	{94997, 0x8000},
	{95009, 0x10000},
	{95022, 0x20000},
	{92601, 0x40000},
	{95035, 0x80000},
	{95262, 0x700000, 8, 36520},
	{95284, 0x3800000, 8, 36520},
	{95308, 0x4000000},
	{95334, 0x8000000},
	{95360, 0x10000000},
	{95428, 0x60000000, 3, 36528},
	{95444, 0x80000000},
	/* 1594 */
	{95458, 0x1F},
	{95474, 0x3E0},
	{95496, 0xC00},
	{75736, 0x7000},
	{95514, 0x18000},
	{95528, 0x20000},
	{95546, 0x40000},
	{95572, 0x80000},
	/* 1602 */
	{79064, 0x1},
	{95602, 0x2},
	{72419, 0xC, 3, 36531},
	{95716, 0x10, 2, 36534},
	{72447, 0x60},
	{72544, 0x180},
	{95742, 0x200},
	{95765, 0x3C00},
	{95785, 0x3C000},
	{79180, 0x40000},
	{95807, 0x80000},
	{95840, 0x100000},
	/* 1614 */
	{94248, 0x3FFF},
	/* 1615 */
	{95864, 0xFF},
	/* 1616 */
	{95874, 0x3FFF},
	{95886, 0xFFFC000},
	{72319, 0xF0000000},
	/* 1619 */
	{95897, 0x1FFF},
	{95908, 0x2000},
	{95920, 0x7C000},
	{95934, 0xF80000},
	{95948, 0x3000000},
	{95962, 0x4000000},
	{69804, 0x38000000},
	{95981, 0x40000000},
	/* 1627 */
	{10136, 0xFFFFFFFC},
	/* 1628 */
	{10165, 0xFFFF},
	/* 1629 */
	{24499, 0xFFFFFFFC},
	/* 1630 */
	{24521, 0xFFFF},
	/* 1631 */
	{25015, 0xFFFFFFFC},
	/* 1632 */
	{25037, 0xFFFF},
	/* 1633 */
	{95998, 0xFFFFFFC},
	/* 1634 */
	{96014, 0x6000000},
	/* 1635 */
	{96027, 0x1},
	/* 1636 */
	{96046, 0xFF},
	{96060, 0x30000},
	/* 1638 */
	{96074, 0xFFFFFFFC},
	/* 1639 */
	{96086, 0xFFFF},
	{96098, 0x10000},
	{96014, 0x6000000},
	{26824, 0xE0000000},
	/* 1643 */
	{26374, 0xFFFFFFFC},
	/* 1644 */
	{26392, 0xFFFF},
	{96014, 0xC00000},
	/* 1646 */
	{26446, 0xFFFFFFFC},
	/* 1647 */
	{26464, 0xFFFF},
	{96014, 0xC00000},
	/* 1649 */
	{96108, 0x3},
	{26504, 0xFFFFFFF8},
	/* 1651 */
	{26523, 0xFFFF},
	{96122, 0x10000},
	{96138, 0x100000},
	{96154, 0x3000000},
	{96170, 0xE0000000},
	/* 1656 */
	{96181, 0x400},
	{96194, 0x6000},
	{96211, 0x8000},
	{96223, 0x300000},
	{96234, 0x6000000},
	{96251, 0x8000000},
	{96263, 0x60000000},
	/* 1663 */
	{96274, 0xFF},
	/* 1664 */
	{96293, 0x3F},
	/* 1665 */
	{96311, 0x8},
	{96328, 0x10},
	{96345, 0x20},
	{96372, 0x8000},
	{96392, 0x40000},
	{96409, 0x400000},
	{96425, 0x800000},
	{96439, 0x2000000},
	{96453, 0x4000000},
	{96467, 0x8000000},
	{96488, 0x10000000},
	{96513, 0x20000000},
	{96534, 0x40000000},
	/* 1678 */
	{96558, 0x3000000},
	{1166, 0x80000000},
	/* 1680 */
	{26761, 0xFFFF},
	/* 1681 */
	{26802, 0xFFFF},
	/* 1682 */
	{96563, 0x3FFFFFF},
	{96574, 0x4000000},
	{96578, 0x8000000},
	{96582, 0x10000000},
	{96587, 0x20000000},
	{96592, 0x40000000},
	{96601, 0x80000000},
	/* 1689 */
	{96608, 0x1},
	{96628, 0x2},
	{96642, 0x30},
	{96654, 0x1FF0000},
	{96667, 0x10000000},
	{96682, 0x20000000},
	{96696, 0xC0000000},
	/* 1696 */
	{96706, 0x3FFFFFF},
	{96719, 0x10000000},
	/* 1698 */
	{96738, 0xFF},
	/* 1699 */
	{96757, 0xFF},
	/* 1700 */
	{96763, 0x1},
	{96777, 0x2},
	{96789, 0x10000},
	{96803, 0x1000000},
	/* 1704 */
	{2043, 0xFF},
	{64374, 0x80000000},
	/* 1706 */
	{27057, 0xFFFFF},
	/* 1707 */
	{27070, 0xFFFFF},
	/* 1708 */
	{27084, 0xFFFFF},
	/* 1709 */
	{27098, 0xFFFFF},
	/* 1710 */
	{27120, 0xFFFFF},
	/* 1711 */
	{27140, 0xFFFFF},
	/* 1712 */
	{27162, 0xFFFFF},
	/* 1713 */
	{96816, 0x3},
	{10136, 0xFFFFFFFC},
	/* 1715 */
	{10165, 0xFFFF},
	{96816, 0xFFFF0000},
	/* 1717 */
	{96821, 0xFFF},
	/* 1718 */
	{96836, 0xFFFFF},
	/* 1719 */
	{96850, 0xFFFFF},
	/* 1720 */
	{96864, 0xFFFFF},
	/* 1721 */
	{27478, 0xFFFFFFE0},
	/* 1722 */
	{27497, 0xFFFF},
	/* 1723 */
	{27516, 0xFFF},
	/* 1724 */
	{27533, 0xFFFFFFFC},
	/* 1725 */
	{27551, 0xFFFF},
	/* 1726 */
	{27569, 0xFFFFF},
	/* 1727 */
	{27585, 0xFFFFFFFC},
	/* 1728 */
	{27603, 0xFFFF},
	/* 1729 */
	{27621, 0xFFFFF},
	/* 1730 */
	{27720, 0xFFFFFFFC},
	/* 1731 */
	{27734, 0xFFFF},
	/* 1732 */
	{27748, 0xFFFFF},
	/* 1733 */
	{43083, 0xFFF000},
	{96014, 0x6000000},
	{96877, 0x8000000},
	{96890, 0x10000000},
	/* 1737 */
	{96898, 0x30000},
	{96906, 0x7000000},
	{96914, 0xE0000000},
	/* 1740 */
	{27814, 0xFFFFFFF},
	/* 1741 */
	{27825, 0xFFFFFFFC},
	/* 1742 */
	{27839, 0xFFFF},
	/* 1743 */
	{27853, 0xFFFFF},
	/* 1744 */
	{96923, 0xFFFFF},
	/* 1745 */
	{1166, 0x3},
	/* 1746 */
	{28003, 0x1},
	/* 1747 */
	{96936, 0x1},
	{96950, 0x2},
	{96967, 0x4},
	{96983, 0x8},
	{96998, 0x10},
	{97017, 0x20},
	{97035, 0x40},
	{97056, 0x80},
	/* 1755 */
	{97077, 0x1},
	{97093, 0x2},
	{97109, 0x40},
	{97127, 0x80},
	{97145, 0x100},
	{97163, 0x200},
	{97181, 0x400},
	{97199, 0x800},
	{97217, 0x1000},
	{97235, 0x2000},
	{97253, 0x4000},
	{97270, 0x80000},
	{97286, 0x200000},
	/* 1768 */
	{97302, 0xFF},
	{1166, 0x80000000},
	/* 1770 */
	{97320, 0xF},
	{97332, 0xF0},
	{97341, 0xF00},
	{97350, 0xF000},
	{97360, 0x30000},
	{97370, 0xC0000},
	{10053, 0x100000},
	{10536, 0xFFE00000},
	/* 1778 */
	{97377, 0xFF},
	{97341, 0xFF00},
	{97332, 0xFF0000},
	{97392, 0x20000000},
	{97412, 0x40000000},
	{97438, 0x80000000},
	/* 1784 */
	{18635, 0x3F, 22, 36290},
	/* 1785 */
	{38, 0xFFFF},
	/* 1786 */
	{97458, 0x1FF},
	{97524, 0x600, 4, 36536},
	/* 1788 */
	{90407, 0xFFFF},
	{90422, 0x10000},
	{90441, 0x20000},
	{90455, 0x40000},
	{90474, 0x80000},
	{90488, 0x100000},
	{97544, 0x200000},
	{97562, 0x400000},
	{97578, 0x800000},
	/* 1797 */
	{97590, 0x1FF},
	{97604, 0x3FE00},
	{97618, 0x40000},
	{97636, 0x80000},
	/* 1801 */
	{97653, 0x7},
	{97662, 0x78},
	{97671, 0x100},
	/* 1804 */
	{97681, 0x1},
	{97692, 0x7FE},
	/* 1806 */
	{97705, 0x1},
	{97719, 0x2},
	{97733, 0x4},
	/* 1809 */
	{29166, 0xFFFFFF},
	/* 1810 */
	{97747, 0xF},
	{97759, 0xFF00},
	/* 1812 */
	{456, 0xFFFF},
	{102, 0xFFFF0000},
	/* 1814 */
	{97773, 0x1},
	{97794, 0x2},
	/* 1816 */
	{97822, 0x3FFF},
	/* 1817 */
	{97830, 0x3FFF},
	/* 1818 */
	{2030, 0xFFFF},
	/* 1819 */
	{97838, 0x1},
	{97850, 0x2},
	{97862, 0x4},
	{29941, 0x8},
	{73648, 0x10},
	{30366, 0x10000},
	{97873, 0x60000},
	/* 1826 */
	{97886, 0x1},
	{74955, 0x2},
	/* 1828 */
	{25093, 0x7FFFFFFF},
	/* 1829 */
	{97890, 0x3F},
	{97895, 0xC0},
	{97903, 0x300},
	{97909, 0xFFFFFC00},
	/* 1833 */
	{30366, 0x1},
	{97370, 0xFFFFFFFE},
	/* 1835 */
	{8, 0xFFFF},
	{97370, 0xFFFF0000},
	/* 1837 */
	{38, 0xFFFF},
	{97370, 0xFFFF0000},
	/* 1839 */
	{30444, 0xFF},
	{97370, 0xFFFFFF00},
	/* 1841 */
	{30461, 0xFF},
	{97370, 0xFFFFFF00},
	/* 1843 */
	{1, 0xFF},
	{97370, 0xFFFFFF00},
	/* 1845 */
	{452, 0x3F},
	{97370, 0xFFFFFFC0},
	/* 1847 */
	{86014, 0x1},
	{887, 0x1FFE},
	{220, 0x2000},
	{93895, 0x4000},
	{97917, 0x8000},
	{97929, 0x7FF0000},
	{97940, 0x8000000},
	{97951, 0x10000000},
	{97961, 0x20000000},
	{97895, 0xC0000000},
	/* 1857 */
	{30665, 0xFFFF},
	{97370, 0xFFFF0000},
	/* 1859 */
	{452, 0xF},
	{97370, 0xFFFFFFF0},
	/* 1861 */
	{97968, 0xFFFF},
	{97979, 0xF0000},
	{97992, 0xF00000},
	{97370, 0x3F000000},
	{98000, 0x40000000},
	{10053, 0x80000000},
	/* 1867 */
	{29179, 0x7FFFFFFF},
	{30727, 0x80000000},
	/* 1869 */
	{31273, 0xFFFF},
	/* 1870 */
	{31277, 0xFFFF},
	{98009, 0xFFFF0000},
	/* 1872 */
	{98023, 0x3FF},
	{98032, 0xFFC00},
	{51680, 0xF00000},
	{98042, 0xF000000},
	{98053, 0xF0000000},
	/* 1877 */
	{98064, 0x3FF},
	{98074, 0xFFC00},
	{98084, 0xF000000},
	{98095, 0xF0000000},
	/* 1881 */
	{98315, 0xF, 6, 36540},
	{98550, 0xF0, 6, 36546},
	{98723, 0x300, 4, 36552},
	{98743, 0x400},
	/* 1885 */
	{452, 0x7},
	{75434, 0x40000000},
	{10053, 0x80000000},
	/* 1888 */
	{452, 0x1F},
	{75434, 0x40000000},
	{10053, 0x80000000},
	/* 1891 */
	{452, 0xF},
	{11403, 0x40000000},
	{10053, 0x80000000},
	/* 1894 */
	{452, 0x1F},
	{11403, 0x40000000},
	{10053, 0x80000000},
	/* 1897 */
	{11368, 0xFFFF},
	{11388, 0xFFFF0000},
	/* 1899 */
	{98765, 0x1},
	{98792, 0x2},
	{98819, 0x4},
	{1153, 0x100},
	/* 1903 */
	{98023, 0x3F},
	{98842, 0x400},
	{98869, 0x800},
	{98896, 0x2000},
	{98922, 0x4000},
	{98948, 0x10000},
	{98975, 0x20000},
	{99001, 0x40000},
	{99027, 0x80000},
	{99055, 0x100000},
	{99081, 0x200000},
	{99107, 0x400000},
	{99133, 0x1000000},
	{99160, 0x2000000},
	{99187, 0x4000000},
	{99214, 0x8000000},
	{99241, 0x10000000},
	{99267, 0x20000000},
	{99296, 0x40000000},
	{99322, 0x80000000},
	/* 1923 */
	{98023, 0x3F},
	{98842, 0x400},
	{98869, 0x800},
	{98896, 0x1000},
	{98922, 0x2000},
	{98948, 0x8000},
	{98975, 0x10000},
	{99055, 0x20000},
	{99081, 0x40000},
	{99001, 0x100000},
	{99160, 0x200000},
	{99322, 0x400000},
	{99349, 0x800000},
	{99214, 0x1000000},
	{99378, 0x2000000},
	/* 1938 */
	{99349, 0x2},
	{99407, 0x4},
	{99436, 0x8},
	{99464, 0x10},
	{99490, 0x20},
	{99516, 0x40},
	{99543, 0x80},
	{99378, 0x100},
	/* 1946 */
	{99570, 0x3FF},
	{98032, 0xFFC00},
	{99580, 0xF00000},
	{99590, 0xF000000},
	{99601, 0xF0000000},
	/* 1951 */
	{98064, 0x3FF},
	{98074, 0xFFC00},
	{99612, 0xF000000},
	{99623, 0xF0000000},
	/* 1955 */
	{99570, 0x3FF},
	{99634, 0xF0000000},
	/* 1957 */
	{98023, 0x3FF},
	{98032, 0xFFC00},
	{99580, 0xF00000},
	{99601, 0xF000000},
	{99634, 0xF0000000},
	/* 1962 */
	{98064, 0x3FF},
	{98074, 0xFFC00},
	{99623, 0xF000000},
	{99612, 0xF0000000},
	/* 1966 */
	{99644, 0xF},
	{99653, 0xF0},
	{99662, 0xF00},
	{99671, 0xF000},
	{99680, 0xF0000},
	{99689, 0xF00000},
	{99698, 0xF000000},
	{99707, 0xF0000000},
	/* 1974 */
	{98023, 0x1FF},
	{99716, 0xF000},
	{51680, 0xF00000},
	{99634, 0xF0000000},
	/* 1978 */
	{60994, 0x1},
	{91034, 0x2, 4, 36416},
	{90969, 0x4, 2, 36414},
	{19929, 0x8, 4, 36410},
	{90887, 0x10, 2, 36408},
	{90856, 0x20, 4, 36404},
	{99730, 0x40},
	{99736, 0x300},
	{99746, 0x2000},
	/* 1987 */
	{99760, 0x1},
	/* 1988 */
	{99769, 0x3},
	{99783, 0xC},
	{99797, 0x30},
	{99811, 0xC0},
	{99825, 0xF00},
	{99840, 0xF000},
	{99855, 0xF0000},
	{99870, 0xF00000},
	/* 1996 */
	{37018, 0x3FF},
	{99885, 0xFFC00},
	{99580, 0xF00000},
	/* 1999 */
	{99905, 0x3FF},
	{99925, 0xFFC00},
	/* 2001 */
	{98023, 0xFF},
	{98032, 0x3FC00},
	{99580, 0xF00000},
	{99601, 0xF000000},
	{99634, 0xF0000000},
	/* 2006 */
	{98064, 0xFF},
	{98074, 0x3FC00},
	{99623, 0xF000000},
	{99612, 0xF0000000},
	/* 2010 */
	{98023, 0xFF},
	{99580, 0xF00000},
	{99634, 0xF0000000},
	/* 2013 */
	{98023, 0x3FF},
	{99580, 0xF00000},
	{99634, 0xF0000000},
	/* 2016 */
	{99945, 0x1},
	{100180, 0xE, 6, 36556},
	{100194, 0x10},
	{100215, 0x3E0},
	{100233, 0x400},
	{100318, 0x800, 2, 36562},
	{100335, 0x1000},
	{100353, 0xE000},
	{100368, 0x20000},
	{100394, 0x1C0000},
	{100417, 0x200000},
	{100445, 0xC00000},
	/* 2028 */
	{98023, 0x1FF},
	{98032, 0x7FC00},
	{99580, 0xF00000},
	{99601, 0xF000000},
	{99634, 0xF0000000},
	/* 2033 */
	{98064, 0x1FF},
	{98074, 0x7FC00},
	{99623, 0xF000000},
	{99612, 0xF0000000},
	/* 2037 */
	{98023, 0x1FF},
	{99634, 0xF0000000},
	/* 2039 */
	{70983, 0xFFF},
	{100470, 0x3000},
	{10536, 0xC000},
	{100488, 0xFFFF0000},
	/* 2043 */
	{40320, 0xFFFF},
	{10536, 0xFFFF0000},
	/* 2045 */
	{40367, 0xFF},
	{70983, 0x700},
	{100512, 0xF800},
	{100528, 0x1F0000},
	{100541, 0x3E00000},
	{100554, 0x7C000000},
	{10536, 0x80000000},
	/* 2052 */
	{100567, 0xFF},
	{10536, 0xFFFFFF00},
	/* 2054 */
	{100589, 0x1FF},
	{10536, 0xFFFFFE00},
	/* 2056 */
	{100589, 0xFF},
	{10536, 0xFFFFFF00},
	/* 2058 */
	{40541, 0x7F},
	{10536, 0xFFFFFF80},
	/* 2060 */
	{40566, 0x7F},
	{10536, 0xFFFFFF80},
	/* 2062 */
	{40594, 0x7F},
	{10536, 0xFFFFFF80},
	/* 2064 */
	{40622, 0x7F},
	{10536, 0xFFFFFF80},
	/* 2066 */
	{40645, 0x7F},
	{10536, 0xFFFFFF80},
	/* 2068 */
	{100606, 0x7F},
	{10536, 0xFFFFFF80},
	/* 2070 */
	{10536, 0x1F},
	{100611, 0xFFFFFFE0},
	/* 2072 */
	{100630, 0x7F},
	{10536, 0xFFFFFF80},
	/* 2074 */
	{100630, 0x1FF},
	{10536, 0xFFFFFE00},
	/* 2076 */
	{100606, 0xFF},
	{10536, 0xFFFFFF00},
	/* 2078 */
	{100635, 0xFF},
	{100656, 0x100},
	{100666, 0x200},
	{100674, 0x400},
	{100688, 0x800},
	{100699, 0x1000},
	{100718, 0x2000},
	{100742, 0x4000},
	{100756, 0x8000},
	{10536, 0xFFFF0000},
	/* 2088 */
	{100766, 0x1},
	{100790, 0x2},
	{100814, 0x4},
	{100831, 0x8},
	{100848, 0x10},
	{100867, 0x20},
	{100884, 0x3C0},
	{10536, 0xFFFFFC00},
	/* 2096 */
	{100899, 0x1},
	{100911, 0x2},
	{100923, 0x4},
	{100933, 0x8},
	{100954, 0x10},
	{100971, 0x20},
	{100988, 0x40},
	{10536, 0xFFFFFF80},
	/* 2104 */
	{101012, 0xFFFF},
	{10536, 0xFFFF0000},
	/* 2106 */
	{101022, 0xFF},
	{10536, 0xFFFFFF00},
	/* 2108 */
	{101039, 0x7FFFF},
	{10536, 0xFFF80000},
	/* 2110 */
	{100528, 0xFF},
	{100541, 0xFF00},
	{100554, 0xFF0000},
	{101054, 0xFF000000},
	/* 2114 */
	{40367, 0xFF},
	{100512, 0xFF00},
	{10536, 0xFFFF0000},
	/* 2117 */
	{101067, 0x1},
	/* 2118 */
	{101091, 0x1},
	/* 2119 */
	{98315, 0x7, 6, 36540},
	{98743, 0x400},
	/* 2121 */
	{37018, 0xFF},
	/* 2122 */
	{10053, 0x1},
	{101109, 0x2},
	{19116, 0x4},
	{10536, 0xFFFFFFF8},
	/* 2126 */
	{101121, 0xF},
	{101126, 0x30},
	{10536, 0xFFFFFFC0},
	/* 2129 */
	{101133, 0x1},
	/* 2130 */
	{101153, 0x3},
	{101177, 0xC},
	{101201, 0x30},
	{101216, 0xC0},
	{101240, 0x300},
	{101264, 0x3C00},
	{101281, 0x7C000},
	{101299, 0x1F80000},
	{101335, 0x2000000},
	{101351, 0x4000000},
	/* 2140 */
	{98023, 0xFF},
	{101369, 0xFF00},
	{99634, 0xF000000},
	{10053, 0x10000000},
	{11403, 0x20000000},
	/* 2145 */
	{101382, 0xF},
	{101402, 0xFF00},
	{101416, 0xFF0000},
	{101429, 0x1000000},
	{101440, 0x2000000},
	{101450, 0x4000000},
	/* 2151 */
	{98023, 0x1FF},
	{99634, 0xF000000},
	{101471, 0xF0000000},
	/* 2154 */
	{98023, 0x3FF},
	{101481, 0xF0000000},
	/* 2156 */
	{96898, 0xF00, 6, 36564},
	{101533, 0x10000},
	{101545, 0x100000},
	{101560, 0xC0000000, 4, 36570},
	/* 2160 */
	{101571, 0xFFFFF},
	{101579, 0x100000},
	{101585, 0x200000},
	{60216, 0x800000},
	/* 2164 */
	{43071, 0xFFFFFFFF},
	/* 2165 */
	{26761, 0xFFFF},
	{96898, 0x300000, 4, 36574},
	{101608, 0x8000000, 2, 36570},
	{101630, 0x60000000, 4, 36578},
	{101638, 0x80000000},
	/* 2170 */
	{42955, 0xFFFFFFFF},
	/* 2171 */
	{96563, 0x3FFFFFF},
	{96574, 0x4000000, 2, 36582},
	{96578, 0x8000000, 2, 36582},
	{96582, 0x10000000, 2, 36584},
	{96587, 0x20000000, 2, 36584},
	{96592, 0x40000000},
	{101676, 0x80000000},
	/* 2178 */
	{90291, 0x3F},
	{101695, 0xF00},
	{101707, 0x1000},
	{101714, 0x2000},
	{101722, 0x4000},
	{101730, 0x8000},
	{101738, 0x10000},
	{101761, 0x60000, 4, 36586},
	{101786, 0x80000},
	{101798, 0x100000},
	{101806, 0x200000},
	{101850, 0xC00000, 3, 36590},
	/* 2190 */
	{101608, 0x1, 2, 36570},
	{96194, 0x6000},
	{96898, 0x300000, 4, 36574},
	{96234, 0x6000000},
	{101630, 0x60000000, 4, 36578},
	{101638, 0x80000000},
	/* 2196 */
	{101895, 0x3, 4, 36593},
	{101911, 0xC, 4, 36597},
	{101707, 0x10},
	{101714, 0x20},
	{101936, 0x40},
	{101943, 0x80},
	{101722, 0x100},
	{101730, 0x200},
	{101738, 0x400},
	{101761, 0x1800, 4, 36586},
	{101786, 0x2000},
	{101798, 0x4000},
	{101806, 0x8000},
	{101850, 0x30000, 3, 36590},
	{101951, 0x40000},
	/* 2211 */
	{101963, 0xFFFFF},
	/* 2212 */
	{60531, 0x1FF, 257, 0},
	{60536, 0x400},
	{60544, 0x800},
	{60557, 0x7000},
	{60565, 0x8000},
	{60576, 0xF0000},
	{60587, 0xF00000},
	{60603, 0x1000000},
	{101973, 0x10000000},
	{60629, 0xE0000000},
	/* 2222 */
	{60788, 0xF},
	{60795, 0x70},
	{60803, 0x80},
	{60817, 0xF00},
	{60826, 0x7000},
	{60853, 0xC00000},
	{60863, 0x1000000},
	{60889, 0xFC000000},
	/* 2230 */
	{43145, 0xFFFFF},
	/* 2231 */
	{61096, 0xF},
	{61119, 0x10},
	{61142, 0x20},
	{61165, 0x40},
	{61185, 0x80},
	{61205, 0x100},
	{61225, 0x200},
	{61245, 0x400},
	{61265, 0x800},
	{61285, 0x1000},
	{61305, 0x2000},
	{61325, 0x4000},
	{61340, 0x8000},
	{61351, 0x10000},
	{61359, 0x20000},
	{61368, 0x40000},
	{101983, 0x80000},
	{61400, 0x100000},
	{61413, 0x200000},
	{61423, 0x400000},
	{61440, 0x800000},
	{102003, 0x1000000},
	{102020, 0x2000000},
	{61457, 0x4000000},
	{61466, 0x8000000},
	{61475, 0x10000000},
	{61484, 0x20000000},
	{61493, 0x40000000},
	{61502, 0x80000000},
	/* 2260 */
	{61513, 0xF},
	{61552, 0x80},
	{61575, 0x100},
	{61598, 0x200},
	{61617, 0x1000},
	{61626, 0x2000},
	{61635, 0x4000},
	{61643, 0x8000},
	{61652, 0x10000},
	{61667, 0x100000},
	{61675, 0x200000},
	{61683, 0x400000},
	{61692, 0x800000},
	{61701, 0x1000000},
	{61709, 0x2000000},
	{61717, 0x4000000},
	{61725, 0x10000000},
	{61467, 0x20000000},
	{61743, 0x40000000},
	{61751, 0x80000000},
	/* 2280 */
	{43159, 0xFFFF},
	/* 2281 */
	{64907, 0x7FF, 2049, 257},
	{102037, 0x1000},
	{65069, 0xFF0000, 129, 2306},
	{65081, 0x3000000},
	{102062, 0x1C000000},
	{65094, 0x80000000},
	/* 2287 */
	{1153, 0x3},
	{65109, 0x4},
	{65118, 0x8},
	{65129, 0x10},
	{65142, 0x20},
	{54917, 0x1C0},
	{65156, 0x200},
	{65169, 0x400},
	{65182, 0x800},
	{65194, 0x1000},
	{65212, 0x2000},
	{65223, 0xC000},
	{65238, 0x30000},
	{65246, 0x40000},
	{65265, 0x80000},
	{102074, 0x700000},
	{102089, 0x10000000},
	{102112, 0x20000000},
	{65282, 0x40000000},
	{65294, 0x80000000},
	/* 2307 */
	{65308, 0xFFF},
	{65323, 0xFFF000},
	{65335, 0x1000000},
	{61346, 0x2000000},
	{65343, 0x4000000},
	{65363, 0x8000000},
	{102128, 0xF0000000},
	/* 2314 */
	{102139, 0x1},
	{102149, 0x2},
	{102159, 0x10},
	/* 2317 */
	{65509, 0x7},
	{65519, 0x38},
	{65529, 0x1C0},
	{65539, 0xE00},
	{17473, 0x7F000, 293, 2468},
	{69776, 0x600000},
	{69789, 0x800000},
	{69804, 0x1000000},
	{102187, 0xC000000},
	{69910, 0x30000000, 4, 2761},
	{220, 0xC0000000},
	/* 2328 */
	{70312, 0x1FFFFF},
	{70331, 0xE00000},
	{70350, 0x1000000},
	{70372, 0x2000000},
	{102199, 0x4000000},
	{70410, 0x8000000},
	{70427, 0x10000000},
	{70445, 0x20000000},
	{70461, 0xC0000000},
	/* 2337 */
	{70482, 0x7},
	{70492, 0x38},
	{70513, 0xC0},
	{102222, 0x700},
	{70534, 0x180000},
	{70553, 0xC000000},
	/* 2343 */
	{18619, 0x1FFF},
	{21335, 0x3FFF},
	{72296, 0x1FFF0000},
	/* 2346 */
	{72307, 0xF},
	{72319, 0xF0},
	{72327, 0xFFF00},
	{72340, 0x700000},
	{72349, 0x800000},
	{72364, 0x2000000},
	{72379, 0x4000000},
	{76199, 0x80000000},
	/* 2354 */
	{72391, 0xFF},
	{102187, 0x300},
	{72407, 0x400},
	{72419, 0x18000},
	{72447, 0x60000},
	{72473, 0x80000},
	{72491, 0x100000},
	{72513, 0x200000},
	{72528, 0x400000},
	{72544, 0x800000},
	{72560, 0xFF000000},
	/* 2365 */
	{72626, 0x3F},
	{72632, 0x3C0},
	{70322, 0xC00},
	{72722, 0xFF000, 193, 2834},
	{60393, 0x100000},
	{60186, 0x200000},
	{72733, 0x800000},
	{72743, 0x1000000},
	{72760, 0x2000000},
	{61066, 0x4000000},
	{102231, 0x8000000},
	{60337, 0x20000000},
	/* 2377 */
	{74015, 0x1},
	{74034, 0x2},
	{74055, 0x4},
	{74066, 0x8},
	{74079, 0x10},
	{74098, 0x20},
	{74123, 0x40},
	{74146, 0x80},
	{74160, 0xF00},
	{74172, 0x1000},
	{102250, 0x2000},
	/* 2388 */
	{75089, 0x3, 4, 3035},
	{75118, 0x1C},
	{75149, 0x20},
	{75185, 0x40},
	{75220, 0x80},
	{75248, 0x100},
	{75270, 0x200},
	{75288, 0x400},
	{75320, 0x800},
	{75441, 0x7000, 8, 3039},
	{75451, 0x38000},
	{75464, 0x1C0000},
	{75477, 0x200000},
	{75493, 0x400000},
	{75511, 0x800000},
	{75529, 0x2000000},
	{102268, 0x4000000},
	{102288, 0x18000000},
	/* 2406 */
	{102419, 0x7, 5, 36601},
	{102451, 0x30},
	{102471, 0xC0},
	/* 2409 */
	{76047, 0x3, 4, 3061},
	{76059, 0xC, 4, 3061},
	{76071, 0x30, 4, 3061},
	{76087, 0xC0, 4, 3061},
	{76157, 0x30000, 4, 3065},
	{76169, 0xC0000, 4, 3065},
	{76181, 0x300000, 4, 3065},
	{76197, 0x1000000},
	{76208, 0x2000000},
	{102491, 0x4000000},
	{102501, 0x8000000},
	{102511, 0x10000000},
	{102525, 0x20000000},
	/* 2422 */
	{10053, 0x1},
	{78740, 0x6},
	{70553, 0x60},
	{78782, 0x3000},
	{78789, 0x30000},
	{78803, 0x300000},
	/* 2428 */
	{78910, 0x3, 4, 3061},
	{78926, 0xC, 4, 3061},
	{78942, 0x30, 4, 3061},
	{78956, 0xC0, 4, 3061},
	{78972, 0x30000, 4, 3065},
	{78988, 0xC0000, 4, 3065},
	{79004, 0x300000, 4, 3065},
	{79018, 0xC00000, 4, 3065},
	{102540, 0x1000000},
	{102556, 0x2000000},
	{102572, 0x4000000},
	{102586, 0x8000000},
	{79034, 0x40000000},
	{79049, 0x80000000},
	/* 2442 */
	{783, 0x3F},
	{79819, 0x300},
	{79831, 0x400},
	{102602, 0x800},
	{79842, 0x1E000},
	{79851, 0x20000},
	{79865, 0x40000},
	{79869, 0x80000},
	{79886, 0x100000},
	{79904, 0x600000},
	{79922, 0x800000},
	{79942, 0x1000000},
	{79954, 0x2000000},
	/* 2455 */
	{783, 0x3F},
	{79819, 0x300},
	{79831, 0x400},
	{102602, 0x800},
	{79865, 0x40000},
	{79869, 0x80000},
	{79886, 0x100000},
	{79904, 0x600000},
	{79942, 0x1000000},
	{79954, 0x2000000},
	/* 2465 */
	{79966, 0x3E},
	{79982, 0x40},
	{79995, 0x80},
	{102616, 0x1F00},
	/* 2469 */
	{80516, 0x3F},
	{80537, 0x80},
	{80554, 0x100},
	{102634, 0x3E00},
	{80570, 0x4000},
	{80590, 0x8000},
	/* 2475 */
	{102650, 0x1},
	{102675, 0x2},
	{102700, 0x4},
	{102725, 0x8},
	{102750, 0x10},
	{102775, 0x20},
	{102800, 0x40},
	{102825, 0x80},
	/* 2483 */
	{81536, 0xF, 12, 36606},
	{81541, 0xF0, 12, 36606},
	{81546, 0xF00, 12, 36606},
	{81551, 0xF000, 12, 36606},
	{81556, 0xF0000, 12, 36606},
	{81561, 0xF00000, 12, 36606},
	{81566, 0xF000000, 12, 36606},
	{81571, 0xF0000000, 12, 36606},
	/* 2491 */
	{83350, 0x3, 4, 36007},
	{83396, 0xC, 2, 36011},
	{83407, 0x10},
	{83422, 0x20},
	{83430, 0x40},
	{83472, 0xE0000000},
	/* 2497 */
	{83963, 0x1},
	{102872, 0x2},
	{83981, 0x8},
	{1153, 0x70, 8, 36013},
	{83254, 0xFF0000, 256, 36021},
	/* 2502 */
	{85726, 0x1},
	{85742, 0x2},
	{85758, 0x4},
	{85774, 0x8},
	{85790, 0x10},
	{85806, 0x20},
	{85822, 0x40},
	{85838, 0x80},
	{85854, 0x100},
	{85870, 0x200},
	{85886, 0x400},
	{85902, 0x800},
	{85918, 0x1000},
	{85934, 0x2000},
	{85950, 0x4000},
	{85966, 0x8000},
	{85982, 0x10000},
	{86001, 0x20000},
	{86019, 0x40000},
	{86046, 0x80000},
	{86068, 0x100000},
	{86086, 0x200000},
	{86106, 0x400000},
	{86129, 0x800000},
	{86152, 0x1000000},
	{86177, 0x2000000},
	{86220, 0x8000000},
	{102895, 0x10000000},
	{102912, 0x20000000},
	{102937, 0x40000000},
	/* 2532 */
	{86922, 0x1},
	{86939, 0x2},
	{102963, 0x3FC},
	/* 2535 */
	{102982, 0x7, 5, 36601},
	{103008, 0x38, 5, 36601},
	{103037, 0x1C0, 5, 36601},
	{103062, 0xE00, 5, 36601},
	{103088, 0x2000},
	{103111, 0x4000},
	/* 2541 */
	{88072, 0x1},
	{88084, 0x2},
	{88105, 0x4},
	{88125, 0x8},
	{88171, 0x20},
	{88194, 0x40},
	/* 2547 */
	{214, 0x3, 3, 36326},
	{88915, 0xC, 4, 36329},
	{88995, 0x30, 4, 36333},
	{89055, 0xC0, 3, 36337},
	{89068, 0x100},
	{83422, 0x200},
	{89072, 0x400},
	{89081, 0x3800},
	{103138, 0x4000},
	/* 2556 */
	{90346, 0x2},
	{90380, 0x8},
	{90396, 0x10},
	{103163, 0x40},
	/* 2560 */
	{75839, 0x1},
	{90505, 0x2},
	{90516, 0x4},
	{90533, 0x8},
	{90550, 0x3F0},
	{90567, 0xFC00},
	{90584, 0x10000},
	{90608, 0x20000},
	{72478, 0x40000},
	{103241, 0x180000, 3, 36618},
	/* 2570 */
	{90856, 0x3, 4, 36404},
	{90887, 0x4, 2, 36408},
	{19929, 0x18, 4, 36410},
	{90969, 0x20, 2, 36414},
	{91034, 0xC0, 4, 36416},
	{91040, 0x100},
	{73368, 0x200},
	{91051, 0x400},
	{91071, 0x800},
	{91091, 0x1000},
	{91105, 0x2000},
	{91116, 0x4000},
	{91132, 0x78000},
	{91152, 0x180000},
	{91167, 0x200000},
	{91177, 0x400000},
	{91187, 0x800000},
	{91197, 0x1000000},
	{91212, 0x2000000},
	{103260, 0x4000000},
	/* 2590 */
	{92358, 0x7},
	{92375, 0x10},
	{92397, 0x1E000},
	{92413, 0x700000},
	{92434, 0x3000000},
	{92514, 0xC000000, 4, 36441},
	{103284, 0x10000000},
	{103309, 0x20000000},
	/* 2598 */
	{94333, 0x3, 4, 36472},
	{17473, 0x7C, 25, 36621},
	{70573, 0x80},
	{94931, 0x700, 8, 36508},
	{94987, 0x1800, 4, 36516},
	{84030, 0x2000},
	{75024, 0x4000},
	{94997, 0x8000},
	{95009, 0x10000},
	{95022, 0x20000},
	{92601, 0x40000},
	{95035, 0x80000},
	{95262, 0x700000, 8, 36520},
	{95284, 0x3800000, 8, 36520},
	{95308, 0x4000000},
	{95334, 0x8000000},
	{95360, 0x10000000},
	{95428, 0x60000000, 3, 36528},
	{103350, 0x80000000},
	/* 2617 */
	{79064, 0x1},
	{95602, 0x2},
	{72419, 0xC, 3, 36531},
	{95716, 0x10, 2, 36534},
	{72447, 0x60},
	{72544, 0x180},
	{95742, 0x200},
	{95765, 0x3C00},
	{95785, 0x3C000},
	{79180, 0x40000},
	{95807, 0x80000},
	{95840, 0x100000},
	{103361, 0x200000},
	{103381, 0x400000},
	/* 2631 */
	{95897, 0x1FFF},
	{95908, 0x2000},
	{95920, 0x7C000},
	{95934, 0xF80000},
	{95948, 0x3000000},
	{95962, 0x4000000},
	{69804, 0x38000000},
	{95981, 0x40000000},
	{103402, 0x80000000},
	/* 2640 */
	{103423, 0xFFFFFF},
	{10285, 0x7000000},
	{103429, 0x8000000},
	{1, 0x70000000},
	{103440, 0x80000000},
	/* 2645 */
	{103451, 0x1},
	{26504, 0xFFFFFFF8},
	/* 2647 */
	{96763, 0x1},
	{96777, 0x2},
	{103460, 0x8000},
	{96789, 0x10000},
	{96803, 0x1000000},
	/* 2652 */
	{96898, 0x30000},
	{103475, 0x300000},
	{103490, 0xC00000},
	{96906, 0x7000000},
	{96914, 0xE0000000},
	/* 2657 */
	{214, 0x3, 3, 36326},
	{103138, 0x4000},
	/* 2659 */
	{97458, 0x3FF},
	{97524, 0xC00, 4, 36536},
	/* 2661 */
	{102464, 0x3},
	{102484, 0x30},
	/* 2663 */
	{97838, 0x1},
	{97850, 0x2},
	{97862, 0x4},
	{30366, 0x10000},
	{97873, 0x60000},
	/* 2668 */
	{86014, 0x1},
	{887, 0x1FFE},
	{220, 0x2000},
	{93895, 0x4000},
	{97917, 0x8000},
	{97929, 0x7FF0000},
	{97940, 0x8000000},
	{97951, 0x10000000},
	{97961, 0x20000000},
	{103500, 0x40000000},
	{97895, 0x80000000},
	/* 2679 */
	{98023, 0x1FF},
	{51680, 0xF00000},
	{99634, 0xF0000000},
	/* 2682 */
	{60994, 0x1},
	{91034, 0x2, 4, 36416},
	{90969, 0x4, 2, 36414},
	{19929, 0x8, 4, 36410},
	{90887, 0x10, 2, 36408},
	{90856, 0x20, 4, 36404},
	{99730, 0x40},
	{99736, 0x300},
	{99746, 0x2000},
	{103512, 0x4000},
	{103534, 0x8000},
	{103556, 0x10000},
	{103578, 0x20000},
	{103600, 0x40000},
	{103622, 0x80000},
	/* 2697 */
	{100630, 0x7FF},
	{10536, 0xFFFFF800},
	/* 2699 */
	{100635, 0xFF},
	{100656, 0x100},
	{100666, 0x200},
	{100674, 0x400},
	{100688, 0x800},
	{100699, 0x1000},
	{100718, 0x2000},
	{100742, 0x4000},
	{100756, 0x8000},
	{103644, 0x10000},
	{103657, 0x20000},
	{103668, 0x40000},
	{103685, 0x80000},
	{103699, 0x100000},
	{103711, 0x200000},
	{103727, 0x400000},
	{10536, 0xFF800000},
	/* 2716 */
	{100766, 0x1},
	{100790, 0x2},
	{100814, 0x4},
	{103743, 0x8},
	{100884, 0xF0},
	{103763, 0x100},
	{103783, 0x200},
	{103798, 0x400},
	{10536, 0xFFFFF800},
	/* 2725 */
	{100899, 0x1},
	{103823, 0x2},
	{103846, 0x4},
	{100988, 0x8},
	{103860, 0x10},
	{100911, 0x20},
	{103887, 0x40},
	{100923, 0x80},
	{103902, 0x100},
	{100933, 0x200},
	{103915, 0x400},
	{100954, 0x800},
	{103939, 0x1000},
	{100971, 0x2000},
	{103959, 0x4000},
	{103979, 0x8000},
	{103996, 0x10000},
	{104016, 0x20000},
	{104033, 0x40000},
	/* 2744 */
	{783, 0xFFFF},
	{10536, 0xFFFF0000},
	/* 2746 */
	{104053, 0xFF},
	{104067, 0xFF00},
	{104090, 0xFF0000},
	{10536, 0xFF000000},
	/* 2750 */
	{104117, 0xFF},
	{104133, 0xFF00},
	{10536, 0xFFFF0000},
	/* 2753 */
	{104149, 0xFFFF},
	/* 2754 */
	{60167, 0xF},
	{60176, 0xF0},
	{60186, 0x100},
	{60197, 0x200},
	{60202, 0x400},
	{104156, 0x800},
	{60329, 0x1FF000, 257, 0},
	{104175, 0x200000},
	{60337, 0x800000},
	{60347, 0x8000000},
	/* 2764 */
	{60370, 0x1},
	{60374, 0x6},
	{60383, 0x18},
	{60393, 0x20},
	{60398, 0x40},
	{60406, 0x80},
	{60416, 0x100},
	{60427, 0x200},
	{60433, 0x400},
	{60438, 0x800},
	{60444, 0x1000},
	{60455, 0x2000},
	{60460, 0x4000},
	{60465, 0x8000},
	{60216, 0x10000},
	{60480, 0x20000},
	{60488, 0x40000},
	{60500, 0x80000},
	{104184, 0x400000},
	{60508, 0x800000},
	{104198, 0x1000000},
	{104207, 0x2000000},
	{104223, 0x4000000},
	{60519, 0x8000000},
	{43125, 0x10000000},
	{72772, 0x20000000},
	/* 2790 */
	{60531, 0x1FF, 257, 0},
	{60536, 0x400},
	{60544, 0x800},
	{60557, 0x7000},
	{60565, 0x8000},
	{104237, 0x10000},
	{104247, 0x20000},
	{104175, 0x40000},
	{104257, 0x80000},
	{104271, 0x100000},
	{101973, 0x10000000},
	/* 2801 */
	{60713, 0x1FF},
	{60723, 0xFF000},
	/* 2803 */
	{60795, 0x7},
	{60817, 0x3F0},
	{60788, 0xFC00},
	{60889, 0xFC000000},
	/* 2807 */
	{55630, 0x1F},
	{60637, 0x300},
	{60960, 0x3C00},
	{60967, 0x10000},
	{29039, 0x1C0000},
	{60629, 0xE0000000},
	/* 2813 */
	{61024, 0x3},
	{61056, 0x300},
	{61066, 0x400},
	{61079, 0x800},
	/* 2817 */
	{61096, 0xF},
	{61119, 0x10},
	{61142, 0x20},
	{61165, 0x40},
	{61185, 0x80},
	{61205, 0x100},
	{61225, 0x200},
	{61325, 0x4000},
	{61340, 0x8000},
	{61351, 0x10000},
	{61359, 0x20000},
	{61368, 0x40000},
	{101983, 0x80000},
	{61400, 0x100000},
	{61413, 0x200000},
	{61423, 0x400000},
	{61440, 0x800000},
	{61457, 0x4000000},
	{61466, 0x8000000},
	{61475, 0x10000000},
	{61484, 0x20000000},
	{61493, 0x40000000},
	/* 2839 */
	{61513, 0xF},
	{104287, 0x40},
	{61552, 0x80},
	{61575, 0x100},
	{61598, 0x200},
	{61617, 0x1000},
	{61626, 0x2000},
	{61635, 0x4000},
	{61643, 0x8000},
	{61652, 0x10000},
	{61667, 0x100000},
	{61675, 0x200000},
	{61683, 0x400000},
	{61692, 0x800000},
	{61701, 0x1000000},
	{61709, 0x2000000},
	{61717, 0x4000000},
	{104303, 0x8000000},
	{61725, 0x10000000},
	{61467, 0x20000000},
	{61743, 0x40000000},
	{61751, 0x80000000},
	/* 2861 */
	{61617, 0x2},
	{61626, 0x4},
	{61762, 0x8},
	{61466, 0x10},
	{61773, 0x20},
	{104314, 0x40},
	{61485, 0x80},
	{104324, 0x100},
	{61359, 0x200000},
	{61692, 0x400000},
	{61709, 0x1000000},
	{61635, 0x2000000},
	{61667, 0x4000000},
	{61683, 0x8000000},
	{61701, 0x20000000},
	{61717, 0x40000000},
	{61743, 0x80000000},
	/* 2878 */
	{61784, 0x20},
	{61844, 0x80},
	{61873, 0x100},
	{61893, 0x200},
	{61953, 0x2000},
	{61961, 0x4000},
	{61969, 0x8000},
	{61773, 0x10000},
	{104324, 0x2000000},
	{61485, 0x4000000},
	{104314, 0x8000000},
	{61980, 0x10000000},
	{61994, 0x20000000},
	{61762, 0x40000000},
	{62003, 0x80000000},
	/* 2893 */
	{104334, 0x7F},
	/* 2894 */
	{62012, 0x1},
	{62022, 0x2},
	{62032, 0x4},
	{62041, 0x8},
	{62050, 0x10},
	{62061, 0x20},
	{62072, 0x40},
	{62082, 0x80},
	{62092, 0x400},
	{62102, 0x800},
	{62119, 0x1000},
	{62127, 0x2000},
	{62140, 0x4000},
	{62158, 0x8000},
	{62169, 0x10000},
	{62178, 0x20000},
	{62199, 0x40000},
	{62210, 0x80000},
	{104345, 0x100000},
	{104365, 0x200000},
	{62237, 0x20000000},
	{62250, 0x40000000},
	{61484, 0x80000000},
	/* 2917 */
	{62263, 0x1},
	{104385, 0x2},
	{62298, 0x4},
	{62314, 0x8},
	{62332, 0x10},
	{62352, 0x20},
	{62371, 0x40},
	{62390, 0x80},
	{62403, 0x100},
	{62417, 0x200},
	{62441, 0x400},
	{62457, 0x800},
	{62473, 0x1000},
	{62489, 0x2000},
	{62505, 0x10000},
	{104405, 0x20000},
	{62540, 0x40000},
	{62556, 0x80000},
	{62574, 0x100000},
	{62594, 0x200000},
	{62613, 0x400000},
	{62632, 0x800000},
	{62645, 0x1000000},
	{62659, 0x2000000},
	{62683, 0x4000000},
	{62699, 0x8000000},
	{62715, 0x10000000},
	{62731, 0x20000000},
	/* 2945 */
	{62747, 0x8},
	{62766, 0x10},
	{62786, 0x40},
	{64109, 0x80},
	{62805, 0x100},
	{62826, 0x200},
	{62844, 0x400},
	{62867, 0x2000},
	{62889, 0x10000},
	{62910, 0x20000},
	{62928, 0x40000},
	{62951, 0x200000},
	{62973, 0x400000},
	{62997, 0x800000},
	{63021, 0x1000000},
	{63044, 0x2000000},
	/* 2961 */
	{43159, 0x3FFFF},
	/* 2962 */
	{104425, 0x1},
	{104442, 0x2},
	{64399, 0x1000},
	{64421, 0x4000},
	{64446, 0x20000},
	{64467, 0x40000},
	{64491, 0x400000},
	{64518, 0x800000},
	{64543, 0x1000000},
	{64566, 0x8000000},
	{64586, 0x40000000},
	/* 2973 */
	{65464, 0xFFFF},
	{19846, 0x3FFF0000},
	{65494, 0xC0000000},
	/* 2976 */
	{65509, 0x7},
	{65519, 0x38},
	{65529, 0x1C0},
	{65539, 0xE00},
	{17473, 0x3F000, 229, 36646},
	{69776, 0x600000},
	{69789, 0x800000},
	{102187, 0xC000000},
	{69910, 0x30000000, 4, 2761},
	{220, 0xC0000000},
	/* 2986 */
	{70142, 0x3FFF},
	{70186, 0xFC000},
	{70199, 0x300000},
	{70213, 0xC00000},
	{70227, 0x3000000},
	{70236, 0xC000000},
	{70266, 0x20000000},
	{108013, 0x40000000},
	/* 2994 */
	{70151, 0x3FFC0000},
	{70168, 0xC0000000},
	/* 2996 */
	{65464, 0xFF},
	{102187, 0x6000},
	{76199, 0x8000},
	{72319, 0xF0000},
	{17473, 0xFF00000, 229, 36646},
	{72141, 0xC0000000},
	/* 3002 */
	{72307, 0xF},
	{72327, 0xFFF00},
	{72340, 0x700000},
	{72349, 0x800000},
	{72379, 0x4000000},
	{108023, 0xF8000000},
	/* 3008 */
	{108034, 0x7F},
	{72407, 0x400},
	{108045, 0x7800},
	{72419, 0x18000},
	{72447, 0x60000},
	{72473, 0x80000},
	{72491, 0x100000},
	{72513, 0x200000},
	{72528, 0x400000},
	{72544, 0x800000},
	{72560, 0xFF000000},
	/* 3019 */
	{108067, 0xF},
	{108080, 0xF0},
	{108093, 0xF00},
	{108106, 0xF000},
	{108119, 0xF0000},
	{108132, 0xF00000},
	{108145, 0x3000000},
	/* 3026 */
	{72581, 0xFFFF},
	{108155, 0x3F0000},
	{108170, 0x20000000},
	{108184, 0x40000000},
	{108196, 0x80000000},
	/* 3031 */
	{108205, 0x7},
	{108223, 0x38},
	{108241, 0x1C0},
	{108259, 0xE00},
	{108277, 0x7000},
	{108295, 0x38000},
	/* 3037 */
	{108313, 0x7},
	{108336, 0x38},
	{108359, 0x1C0},
	{108382, 0xE00},
	{108405, 0x7000},
	{108428, 0x38000},
	/* 3043 */
	{72581, 0xFFFF},
	{72587, 0x3F0000},
	{108451, 0xC00000},
	/* 3046 */
	{108466, 0xFF},
	{108483, 0xFF00},
	/* 3048 */
	{108500, 0xFF},
	{108514, 0xFF00},
	/* 3050 */
	{108528, 0xFF},
	{108532, 0xFF00},
	{108536, 0xFF0000},
	{108540, 0xFF000000},
	/* 3054 */
	{108544, 0x3F},
	{108556, 0xFC0},
	{108568, 0x3F000},
	{108580, 0xFC0000},
	{108592, 0x3F000000},
	/* 3059 */
	{108604, 0x3F},
	{108616, 0xFC0},
	{108628, 0x3F000},
	{108640, 0x80000000},
	/* 3063 */
	{108656, 0x1},
	{108682, 0x2},
	{108709, 0x4},
	{108737, 0x8},
	{108761, 0x10},
	/* 3068 */
	{108779, 0x1},
	{108804, 0x2},
	{108830, 0x4},
	{108856, 0x8},
	{108875, 0x30},
	{108896, 0xC0},
	{108919, 0x300},
	{108943, 0x7C00},
	{108966, 0x8000},
	/* 3077 */
	{108982, 0x1},
	{108996, 0x2},
	{109010, 0x4},
	{109022, 0x8},
	{109034, 0x10},
	{109048, 0x20},
	{109062, 0x40},
	{109077, 0x80},
	{109092, 0x100},
	{109112, 0x200},
	{109132, 0x400},
	{109154, 0x800},
	{109176, 0xFF000},
	{109188, 0xFF00000},
	/* 3091 */
	{109200, 0xF},
	{109217, 0xF0},
	{109234, 0x300},
	{109255, 0x400},
	{109282, 0x800},
	{109301, 0x1000},
	{109315, 0x2000},
	/* 3098 */
	{109324, 0x1},
	{109348, 0x2},
	{109362, 0x4},
	{109377, 0x8},
	{109392, 0x10},
	{109407, 0x20},
	{109422, 0x40},
	{109438, 0x80},
	{109455, 0x100},
	{109472, 0x200},
	{109489, 0x400},
	{109506, 0x800},
	{109524, 0x1000},
	{109537, 0x2000},
	{109550, 0x4000},
	{109565, 0x8000},
	{109582, 0x10000},
	{109610, 0x20000},
	{109638, 0x40000},
	/* 3117 */
	{109667, 0x1},
	{109682, 0x2},
	/* 3119 */
	{40423, 0x3F},
	/* 3120 */
	{72581, 0x1},
	{10536, 0x3FFE},
	{109692, 0x4000},
	{109707, 0x8000},
	{73397, 0x7F0000},
	{108155, 0x1F800000},
	{108170, 0x20000000},
	{108184, 0x40000000},
	{108196, 0x80000000},
	/* 3129 */
	{109723, 0xFF},
	{109744, 0xFF00},
	{109765, 0xFF0000},
	{109786, 0xFF000000},
	/* 3133 */
	{109811, 0x1FF},
	{109825, 0x3FE00},
	/* 3135 */
	{109839, 0x1},
	{109866, 0x2},
	{109884, 0x4},
	{109907, 0x8},
	{109925, 0x10},
	{109944, 0x20},
	{109962, 0x40},
	{109981, 0x80},
	{110003, 0x100},
	{110026, 0x200},
	{110038, 0xFFC00},
	{110062, 0x100000},
	{110086, 0x200000},
	{110096, 0x400000},
	{110105, 0x800000},
	{110119, 0x1000000},
	{110137, 0x2000000},
	{110174, 0x4000000},
	{110184, 0x78000000},
	{110212, 0x80000000},
	/* 3155 */
	{51974, 0xFF},
	{110249, 0x100},
	{110267, 0x200},
	{110282, 0x400},
	{110297, 0x4000},
	{110309, 0x20000},
	{110323, 0x4000000},
	{110344, 0x40000000},
	{110357, 0x80000000},
	/* 3164 */
	{110374, 0x1},
	{110389, 0x2},
	{110404, 0x4},
	/* 3167 */
	{110417, 0xFF},
	{2030, 0xF00},
	/* 3169 */
	{110422, 0x3},
	{110436, 0x4},
	{110344, 0x8},
	{110450, 0x10},
	{110472, 0x1FE0},
	/* 3174 */
	{110485, 0xFF},
	/* 3175 */
	{110506, 0x1},
	{110519, 0x2},
	/* 3177 */
	{110532, 0x7},
	{110547, 0x8},
	{110561, 0x10},
	{110593, 0x20},
	{110621, 0x40},
	{110653, 0x80},
	{110681, 0x100},
	/* 3184 */
	{110711, 0xFF},
	{110727, 0xFF00},
	/* 3186 */
	{110744, 0x7},
	{110769, 0x38},
	{110794, 0x1C0},
	{110819, 0xE00},
	{110844, 0x7000},
	/* 3191 */
	{110869, 0x1},
	{110896, 0x2},
	{110923, 0x4},
	{110953, 0x8},
	/* 3195 */
	{110983, 0x2},
	/* 3196 */
	{111000, 0xF},
	{111017, 0x7F0},
	{111033, 0x3F800},
	{111050, 0x40000},
	{111078, 0x80000},
	{111106, 0x20000000},
	/* 3202 */
	{109839, 0x1},
	{109866, 0x2},
	{109884, 0x4},
	{109907, 0x8},
	{109925, 0x10},
	{109944, 0x20},
	{109962, 0x40},
	{109981, 0x80},
	{110003, 0x100},
	{110026, 0x200},
	{110038, 0xFFC00},
	{111139, 0x100000},
	{111163, 0x200000},
	{111192, 0x400000},
	{111213, 0x800000},
	/* 3217 */
	{111000, 0xF},
	{111225, 0xF0},
	{111017, 0x7F00},
	{111033, 0x3F8000},
	{111050, 0x400000},
	{111078, 0x800000},
	/* 3223 */
	{109839, 0x1},
	{109866, 0x2},
	{109884, 0x4},
	{109907, 0x8},
	{109925, 0x10},
	{109944, 0x20},
	{109962, 0x40},
	{109981, 0x80},
	{110003, 0x100},
	{110026, 0x200},
	{110038, 0xFFC00},
	{111139, 0x100000},
	{111163, 0x200000},
	{111192, 0x400000},
	{111213, 0x800000},
	{111246, 0x1000000},
	{111268, 0x2000000},
	{111291, 0x4000000},
	{111318, 0x8000000},
	/* 3242 */
	{73510, 0x1},
	{73528, 0x2},
	{73542, 0x4},
	{73561, 0x8},
	{73581, 0x10},
	{73601, 0x20},
	{73623, 0x40},
	{73634, 0x400},
	{73652, 0x800},
	{10536, 0x1000},
	{73670, 0x2000},
	{73684, 0x4000},
	{73692, 0x8000},
	{111341, 0x10000},
	{111355, 0x20000},
	/* 3257 */
	{73884, 0xFFF},
	{73890, 0x7FFF000},
	/* 3259 */
	{73899, 0x7},
	{73909, 0x8},
	{73919, 0x10},
	{73929, 0x1FFE0},
	/* 3263 */
	{72894, 0xF},
	{108155, 0x3F0},
	{108170, 0x400},
	{108184, 0x800},
	{108196, 0x80000000},
	/* 3268 */
	{111378, 0xFFFF},
	{111388, 0xFFFF0000},
	/* 3270 */
	{48803, 0x3FF},
	/* 3271 */
	{74015, 0x1},
	{74034, 0x2},
	{74055, 0x4},
	{74066, 0x8},
	{74079, 0x10},
	{74098, 0x20},
	{74123, 0x40},
	{74146, 0x80},
	{74160, 0xF00},
	{74172, 0x1000},
	{102250, 0x4000},
	{111464, 0x30000, 4, 36875},
	{111474, 0x40000},
	{111490, 0x80000},
	{111509, 0xF00000},
	/* 3286 */
	{74542, 0x3, 4, 3027},
	{74559, 0xC, 4, 3027},
	{74577, 0x30, 4, 3027},
	{74595, 0x40},
	{74616, 0x80},
	{74631, 0x100},
	{74652, 0x200},
	{74670, 0x400},
	{74687, 0x800},
	{74700, 0x1000},
	{74719, 0x6000, 4, 3027},
	{74762, 0x10000},
	{74785, 0x20000},
	{74802, 0x40000},
	{74887, 0x180000, 4, 3031},
	{74906, 0x3E00000},
	{74923, 0x4000000},
	{74947, 0x8000000},
	{74961, 0x10000000},
	{74981, 0x20000000},
	{74995, 0x40000000},
	{75015, 0x80000000},
	/* 3308 */
	{75089, 0x3, 4, 3035},
	{75118, 0x1C},
	{75149, 0x20},
	{75185, 0x40},
	{75220, 0x80},
	{75248, 0x100},
	{75270, 0x200},
	{75288, 0x400},
	{75320, 0x800},
	{75441, 0x7000, 8, 3039},
	{75451, 0x38000},
	{75464, 0x1C0000},
	{75477, 0x200000},
	{75493, 0x400000},
	{75511, 0x800000},
	{75529, 0x2000000},
	{102288, 0x18000000},
	{111535, 0x20000000},
	/* 3326 */
	{75649, 0xF},
	{75657, 0xF0},
	{75665, 0x1F00},
	{75673, 0x6000},
	{75681, 0x18000},
	{75689, 0x60000},
	{75697, 0x180000},
	{111547, 0xF0000000},
	/* 3334 */
	{76047, 0x3, 4, 36879},
	{76059, 0xC, 4, 36879},
	{76071, 0x30, 4, 36879},
	{76087, 0xC0, 4, 36879},
	{76157, 0x30000, 4, 36883},
	{76169, 0xC0000, 4, 36883},
	{76181, 0x300000, 4, 36883},
	{76197, 0x1000000},
	{76208, 0x2000000},
	{102491, 0x4000000},
	{102501, 0x8000000},
	{102511, 0x10000000},
	{102525, 0x20000000},
	/* 3347 */
	{10053, 0x1},
	{78782, 0x3000},
	{78789, 0x30000},
	{78803, 0x300000},
	/* 3351 */
	{102419, 0x7, 5, 36887},
	{43561, 0xF0, 16, 36892},
	{112092, 0x1000},
	{112111, 0x2000},
	{112139, 0x4000},
	/* 3356 */
	{75557, 0x7FF},
	{60161, 0x7FF0000},
	/* 3358 */
	{112166, 0x1},
	{112178, 0x2},
	{112190, 0xC},
	{112203, 0x30},
	{112216, 0xC0},
	{112229, 0x100},
	{112244, 0x200},
	{112259, 0x400},
	{112269, 0x800},
	{112279, 0x1000},
	{112295, 0x2000},
	/* 3369 */
	{95864, 0xFF},
	{112311, 0xF0000000},
	/* 3371 */
	{78942, 0x3, 4, 36879},
	{78956, 0xC, 4, 36879},
	{79004, 0x300000, 4, 36883},
	{79018, 0xC00000, 4, 36883},
	{102572, 0x4000000},
	{102586, 0x8000000},
	{79049, 0x80000000},
	/* 3378 */
	{112326, 0x1},
	{112354, 0x7C},
	{79120, 0x100},
	{79149, 0x200},
	{79180, 0x400},
	{79208, 0x1000},
	{79236, 0x2000},
	{79266, 0x4000},
	/* 3386 */
	{112384, 0xF},
	{112396, 0xF0},
	/* 3388 */
	{783, 0x3F},
	{79819, 0x300},
	{79831, 0x400},
	{102602, 0x800},
	{112406, 0x1000},
	{79851, 0x20000},
	{79865, 0x40000},
	{79869, 0x80000},
	{79886, 0x100000},
	{79904, 0x600000},
	{79922, 0x800000},
	{79942, 0x1000000},
	{79954, 0x2000000},
	/* 3401 */
	{783, 0x3F},
	{79819, 0x300},
	{79831, 0x400},
	{102602, 0x800},
	{112406, 0x1000},
	{79865, 0x40000},
	{79869, 0x80000},
	{79886, 0x100000},
	{79904, 0x600000},
	{79942, 0x1000000},
	{79954, 0x2000000},
	/* 3412 */
	{79966, 0x3E},
	{79995, 0x80},
	{102616, 0x1F00},
	/* 3415 */
	{80516, 0x3F},
	{80527, 0x40},
	{80537, 0x80},
	{80554, 0x100},
	{102634, 0x3E00},
	{80570, 0x4000},
	{80590, 0x8000},
	/* 3422 */
	{81536, 0xF, 14, 36908},
	{81541, 0xF0, 14, 36908},
	{81546, 0xF00, 14, 36908},
	{81551, 0xF000, 14, 36908},
	{81556, 0xF0000, 14, 36908},
	{81561, 0xF00000, 14, 36908},
	{81566, 0xF000000, 14, 36908},
	{81571, 0xF0000000, 14, 36908},
	/* 3430 */
	{83073, 0x1F, 19, 36922},
	{82575, 0xE0, 5, 36002},
	{83178, 0x1F00, 19, 36922},
	{83194, 0x1F0000, 19, 36922},
	{82618, 0xE00000, 5, 36002},
	{83209, 0x1F000000, 19, 36922},
	{83225, 0x20000000},
	{10053, 0x40000000},
	{83246, 0x80000000},
	/* 3439 */
	{83963, 0x1},
	{102872, 0x2},
	{83981, 0x8},
	{1153, 0x70, 5, 36941},
	{83254, 0xFF0000, 256, 36021},
	/* 3444 */
	{84401, 0x1},
	{84417, 0x2},
	{84448, 0x4},
	{74608, 0x30, 4, 36277},
	{84527, 0x40},
	{84539, 0x80},
	{84563, 0x100},
	{84582, 0x200},
	{84600, 0x400},
	{84613, 0x800},
	{84635, 0x1000},
	{84725, 0x6000, 4, 36281},
	{84747, 0x8000},
	{84765, 0x10000},
	{84840, 0x800000},
	{112472, 0x1000000},
	{112490, 0x2000000},
	{112521, 0x1C000000},
	/* 3462 */
	{85726, 0x1},
	{85742, 0x2},
	{85758, 0x4},
	{85774, 0x8},
	{85790, 0x10},
	{85806, 0x20},
	{85822, 0x40},
	{85838, 0x80},
	{85854, 0x100},
	{85870, 0x200},
	{85886, 0x400},
	{85902, 0x800},
	{85918, 0x1000},
	{85934, 0x2000},
	{85950, 0x4000},
	{85966, 0x8000},
	{85982, 0x10000},
	{86001, 0x20000},
	{86019, 0x40000},
	{86046, 0x80000},
	{86068, 0x100000},
	{86086, 0x200000},
	{86106, 0x400000},
	{86129, 0x800000},
	{86152, 0x1000000},
	{86220, 0x8000000},
	{102895, 0x10000000},
	{102912, 0x20000000},
	{102937, 0x40000000},
	/* 3491 */
	{102982, 0x7, 5, 36887},
	{103008, 0x38, 5, 36887},
	{103037, 0x1C0, 5, 36887},
	{103062, 0xE00, 5, 36887},
	{103088, 0x2000},
	{103111, 0x4000},
	/* 3497 */
	{90291, 0x3F, 64, 36946},
	{65469, 0x7FFFC00},
	{90302, 0x8000000},
	/* 3500 */
	{90856, 0x3, 4, 36404},
	{90887, 0x4, 2, 36408},
	{19929, 0x18, 4, 36410},
	{90969, 0x20, 2, 36414},
	{91034, 0xC0, 4, 36416},
	{91040, 0x100},
	{91091, 0x1000},
	{91105, 0x2000},
	{91116, 0x4000},
	{91132, 0x78000},
	{91152, 0x180000},
	{91167, 0x200000},
	{91177, 0x400000},
	{91187, 0x800000},
	{91197, 0x1000000},
	{91212, 0x2000000},
	{103260, 0x4000000},
	/* 3517 */
	{220, 0x3, 3, 36420},
	{91366, 0x1C, 4, 36423},
	{91443, 0xE0, 4, 36427},
	{112569, 0x200},
	{91483, 0x3C00},
	{91505, 0x4000},
	{89055, 0x18000, 3, 36337},
	{91539, 0x60000, 4, 36431},
	{91598, 0x80000, 2, 37010},
	{91650, 0x100000, 2, 37012},
	{89081, 0x3800000},
	/* 3528 */
	{93052, 0x3},
	{72833, 0x4},
	{72855, 0x8},
	{93081, 0x60},
	{112640, 0x80},
	/* 3533 */
	{94180, 0x7FF},
	{112667, 0x1000},
	{112701, 0x2000},
	{112721, 0x4000},
	{94201, 0xFF0000},
	{112744, 0xFF000000},
	/* 3539 */
	{112767, 0x1},
	{112791, 0x2},
	{112815, 0x4},
	{112858, 0x8},
	{112883, 0x70},
	{112911, 0x780},
	{112939, 0x800},
	{112951, 0x1000},
	{112976, 0x1FE000},
	{112995, 0x200000},
	/* 3549 */
	{17473, 0x1F, 25, 36621},
	{70573, 0x80},
	{94931, 0x700, 8, 36508},
	{94987, 0x1800, 4, 36516},
	{94997, 0x8000},
	{95009, 0x10000},
	{95022, 0x20000},
	{92601, 0x40000},
	{95262, 0x700000, 8, 36520},
	{95284, 0x3800000, 8, 36520},
	/* 3559 */
	{95514, 0x3},
	{95528, 0x4},
	{113035, 0x8},
	{95572, 0x10},
	{113061, 0x20},
	/* 3564 */
	{112326, 0x1},
	{113098, 0x2},
	{72419, 0xC, 3, 36531},
	{95716, 0x10, 2, 36534},
	{72447, 0x60},
	{72544, 0x180},
	{95742, 0x200},
	{95840, 0x400},
	{79180, 0x40000},
	{95807, 0x80000},
	{103361, 0x200000},
	{113128, 0x400000},
	{103381, 0x800000},
	{113140, 0x1000000},
	/* 3578 */
	{95897, 0x1FFF},
	{95908, 0x2000},
	{95920, 0x7C000},
	{95948, 0x3000000},
	{95981, 0x40000000},
	/* 3583 */
	{96086, 0xFFFF},
	{96098, 0x30000},
	{88297, 0x40000},
	{113166, 0x80000},
	{96014, 0x6000000},
	{26824, 0xE0000000},
	/* 3589 */
	{26392, 0xFFFF},
	{113177, 0x20000},
	{113191, 0x40000},
	{96014, 0xC00000},
	{10283, 0xF000000},
	{55840, 0x30000000},
	{113199, 0x80000000},
	/* 3596 */
	{26464, 0xFFFF},
	{38, 0xF0000},
	{96014, 0xC00000},
	{10283, 0xF000000},
	{113199, 0x80000000},
	/* 3601 */
	{10283, 0xF},
	{113209, 0x10},
	{96181, 0x400},
	{96194, 0x6000},
	{96211, 0x8000},
	{96223, 0x300000},
	{96234, 0x6000000},
	{96251, 0x8000000},
	{96263, 0x60000000},
	/* 3610 */
	{96763, 0x1},
	{96777, 0x2},
	{103460, 0x8000},
	{96789, 0x10000},
	{96803, 0x1000000},
	{113213, 0x80000000},
	/* 3616 */
	{43083, 0x1FFF000},
	{96014, 0x6000000},
	{96877, 0x8000000},
	{96890, 0x10000000},
	{101943, 0x40000000},
	{113166, 0x80000000},
	/* 3622 */
	{96898, 0x30000},
	{113226, 0x80000},
	{103475, 0x300000},
	{103490, 0xC00000},
	{96906, 0x7000000},
	{96914, 0xE0000000},
	/* 3628 */
	{18635, 0x3F, 22, 37014},
	/* 3629 */
	{19160, 0x1},
	{90317, 0x2},
	{113263, 0x4},
	/* 3632 */
	{38, 0x1FFFF},
	/* 3633 */
	{88031, 0x1FF},
	{88011, 0x3FE00},
	{113286, 0x40000},
	{97636, 0x80000},
	{113306, 0x100000},
	{97590, 0x3FE00000},
	{113327, 0x40000000},
	{113339, 0x80000000},
	/* 3641 */
	{113368, 0xFFFF},
	{113380, 0xFFFF0000},
	/* 3643 */
	{113392, 0xFFFF},
	/* 3644 */
	{88720, 0x3F, 5, 37036},
	/* 3645 */
	{8, 0xFFF},
	{97370, 0xFFFFF000},
	/* 3647 */
	{38, 0x1FFF},
	{97370, 0xFFFFE000},
	/* 3649 */
	{86014, 0x1},
	{887, 0x1FFE},
	{220, 0x2000},
	{93895, 0x4000},
	{97917, 0x8000},
	{97929, 0x1FFF0000},
	{97940, 0x20000000},
	{97951, 0x40000000},
	{97961, 0x80000000},
	/* 3658 */
	{70312, 0x1FFFFF},
	{70331, 0xE00000},
	{70350, 0x1000000},
	{70372, 0x2000000},
	{70427, 0x10000000},
	{70445, 0x20000000},
	{70461, 0xC0000000},
	/* 3665 */
	{113412, 0xF},
	{113427, 0x10},
	{113451, 0x60},
	{113467, 0x80},
	{113483, 0x100},
	{113505, 0x200},
	{113525, 0x3C00},
	{113541, 0x4000},
	{113562, 0x8000},
	{113583, 0x1F0000},
	{113600, 0x200000},
	{113614, 0x400000},
	{113628, 0xFF800000},
	/* 3678 */
	{113645, 0xF},
	{113686, 0xF0},
	{113725, 0x100},
	{113746, 0x200},
	{113766, 0x400},
	{113786, 0x800},
	{113806, 0x1F000},
	/* 3685 */
	{113825, 0x3},
	{113838, 0x30},
	{113851, 0xC0},
	/* 3688 */
	{113864, 0xF},
	{113881, 0xF0},
	{113898, 0xF00},
	{113920, 0xF000},
	{113939, 0xF0000},
	{113957, 0xF00000},
	{113975, 0xF000000},
	{113993, 0xF0000000},
	/* 3696 */
	{114016, 0x3},
	{114034, 0x3C},
	{114057, 0xC0},
	{114087, 0x700},
	{114109, 0x3800},
	{114131, 0xC000},
	{114150, 0x10000},
	{10536, 0xFFFE0000},
	/* 3704 */
	{114158, 0xFF},
	{76199, 0x10000},
	{114167, 0x60000},
	{114177, 0x180000},
	{102187, 0x200000},
	{114187, 0x400000},
	/* 3710 */
	{65149, 0x1},
	{114212, 0x2},
	{48359, 0x1C},
	{114217, 0xFE0},
	{114229, 0x1E000},
	{72181, 0x3E0000},
	{75736, 0xC00000},
	{114240, 0x7000000},
	{114252, 0x8000000},
	{114256, 0x10000000},
	{114260, 0x20000000},
	{114264, 0x40000000},
	/* 3722 */
	{114283, 0x7},
	/* 3723 */
	{65149, 0x1},
	{114212, 0x2},
	{48359, 0x4},
	{114217, 0x8},
	{114229, 0x10},
	{72181, 0x20},
	{75736, 0x40},
	{114240, 0x80},
	{114252, 0x100},
	{114256, 0x200},
	{114260, 0x400},
	{114264, 0x800},
	{114283, 0x1000},
	/* 3736 */
	{98023, 0x3FF},
	{51680, 0xF00000},
	{99580, 0xF0000000},
	/* 3739 */
	{98023, 0x3F},
	{98842, 0x400},
	{98869, 0x800},
	{98896, 0x1000},
	{98922, 0x2000},
	{98948, 0x8000},
	{98975, 0x10000},
	{99055, 0x20000},
	{99081, 0x40000},
	{99001, 0x100000},
	{99160, 0x200000},
	{99322, 0x400000},
	{99349, 0x800000},
	{99214, 0x1000000},
	{99378, 0x2000000},
	{114292, 0x4000000},
	{114320, 0x8000000},
	{114346, 0x10000000},
	/* 3757 */
	{99349, 0x2},
	{99407, 0x4},
	{99436, 0x8},
	{99464, 0x10},
	{99490, 0x20},
	{99516, 0x40},
	{99543, 0x80},
	{99378, 0x100},
	{114292, 0x200},
	/* 3766 */
	{99570, 0x3FF},
	{98032, 0xFFC00},
	{99580, 0xF00000},
	{99601, 0xF000000},
	{99590, 0xF0000000},
	/* 3771 */
	{60994, 0x1},
	{90969, 0x4, 2, 36414},
	{90887, 0x10, 2, 36408},
	{99730, 0x40},
	{103512, 0x4000},
	{103534, 0x8000},
	{103556, 0x10000},
	{103578, 0x20000},
	{103600, 0x40000},
	{103622, 0x80000},
	/* 3781 */
	{99760, 0x1},
	{114374, 0x1FFFE},
	/* 3783 */
	{1166, 0x7F},
	/* 3784 */
	{1153, 0x3},
	{65109, 0x4},
	{114382, 0x8},
	{65129, 0x10},
	{65142, 0x20},
	{54917, 0x1C0},
	{114394, 0x600},
	{65169, 0x800},
	{65182, 0x1000},
	{65212, 0x2000},
	{65223, 0xC000},
	{65238, 0x30000},
	{65246, 0x40000},
	{65265, 0x80000},
	{102074, 0x700000},
	{102089, 0x10000000},
	{102112, 0x20000000},
	{65294, 0x80000000},
	/* 3802 */
	{64612, 0x3},
	{64621, 0xF0},
	{64629, 0x200},
	{64636, 0x1FC00},
	{114405, 0x20000},
	/* 3807 */
	{64907, 0x7FF, 2049, 257},
	{114434, 0x800},
	{102037, 0x1000},
	{65069, 0xFF0000, 129, 2306},
	{65081, 0x3000000},
	{102062, 0x1C000000},
	{65094, 0x80000000},
	/* 3814 */
	{65308, 0xFFF},
	{65323, 0xFFF000},
	{114446, 0x1000000},
	{61346, 0x2000000},
	{102128, 0xF0000000},
	/* 3819 */
	{102139, 0x1},
	{102149, 0x2},
	{102159, 0x10},
	{114458, 0x1F00},
	{114475, 0x2000},
	{114485, 0x4000},
	/* 3825 */
	{98023, 0x3FF},
	{99634, 0xF0000000},
	/* 3827 */
	{70983, 0xFFF},
	{100470, 0x3000},
	{114500, 0x4000},
	{10536, 0x8000},
	{100488, 0xFFFF0000},
	/* 3832 */
	{114523, 0xFFFF},
	{114541, 0xFF0000},
	{114560, 0xFF000000},
	/* 3835 */
	{11785, 0xFFF},
	/* 3836 */
	{99575, 0xFFFF},
	{98037, 0xFFFF0000},
	/* 3838 */
	{100635, 0xFF},
	{100656, 0x100},
	{100666, 0x200},
	{100674, 0x400},
	{100688, 0x800},
	{100699, 0x1000},
	{100718, 0x2000},
	{100742, 0x4000},
	{100756, 0x8000},
	{103644, 0x10000},
	{103657, 0x20000},
	{103668, 0x40000},
	{103685, 0x80000},
	{103699, 0x100000},
	{103711, 0x200000},
	{103727, 0x400000},
	{114575, 0x800000},
	{10536, 0xFF000000},
	/* 3856 */
	{100899, 0x1},
	{103823, 0x2},
	{103846, 0x4},
	{100988, 0x8},
	{100911, 0x20},
	{103887, 0x40},
	{100923, 0x80},
	{103902, 0x100},
	{100933, 0x200},
	{103915, 0x400},
	{100954, 0x800},
	{103939, 0x1000},
	{100971, 0x2000},
	{103959, 0x4000},
	{103979, 0x8000},
	{103996, 0x10000},
	{104016, 0x20000},
	{104033, 0x40000},
	{114594, 0x80000},
	{114611, 0x100000},
	{114631, 0x200000},
	{114648, 0x400000},
	/* 3878 */
	{51655, 0x1},
	{114668, 0x2},
	/* 3880 */
	{114675, 0x1},
	{114684, 0x2},
	{114698, 0x4},
	{114712, 0x8},
	{114729, 0xFF0},
	{114745, 0x8000},
	{114756, 0xF0000},
	{114773, 0xF00000},
	{114790, 0x3000000},
	{114804, 0x4000000},
	/* 3890 */
	{1153, 0x1},
	/* 3891 */
	{402, 0xFFF},
	/* 3892 */
	{1, 0xF},
	/* 3893 */
	{1, 0xF},
	{60216, 0x100},
	/* 3895 */
	{51941, 0xF},
	/* 3896 */
	{114818, 0x1},
	{114826, 0x2},
	{114834, 0x4},
	{114842, 0x8},
	{114850, 0x10},
	{114858, 0x20},
	{114866, 0x40},
	{114874, 0x80},
	{114882, 0x100},
	/* 3905 */
	{90291, 0x3F, 64, 36946},
	{112559, 0x80},
	{101695, 0xF00},
	{101707, 0x1000},
	{101714, 0x2000},
	{101722, 0x4000},
	{101730, 0x8000},
	{101738, 0x10000},
	{101761, 0x60000, 4, 36586},
	{101786, 0x80000},
	{101798, 0x100000},
	{101806, 0x200000},
	{101850, 0xC00000, 3, 36590},
	{101936, 0x1000000},
	{96014, 0x6000000},
	{96890, 0x30000000},
	{101943, 0x40000000},
	{113166, 0x80000000},
	/* 3923 */
	{114938, 0x3800, 6, 37041},
	{114972, 0xC000, 3, 37047},
	{114988, 0x20000},
	{114997, 0xFC0000},
	/* 3927 */
	{115007, 0x80000000},
	/* 3928 */
	{60167, 0xF},
	{60176, 0xF0},
	{60186, 0x100},
	{60197, 0x200},
	{60202, 0x400},
	{115015, 0x800},
	{60329, 0x7F000, 257, 0},
	{60360, 0x10000000},
	{60366, 0xE0000000},
	/* 3937 */
	{60370, 0x1},
	{60374, 0x6},
	{115024, 0x18},
	{60393, 0x20},
	{60398, 0x40},
	{60406, 0x80},
	{60416, 0x100},
	{60427, 0x200},
	{60433, 0x400},
	{60438, 0x800},
	{60444, 0x1000},
	{60455, 0x2000},
	{60460, 0x4000},
	{115034, 0x8000},
	{60216, 0x10000},
	{60480, 0x20000},
	{60488, 0x40000},
	{60500, 0x80000},
	{115047, 0x100000},
	{115061, 0x200000},
	{115074, 0x400000},
	{115083, 0x800000},
	{115092, 0x7000000},
	{60519, 0x8000000},
	/* 3961 */
	{60531, 0x7F, 257, 0},
	{60576, 0x3F0000},
	{60629, 0xE0000000},
	/* 3964 */
	{55630, 0xF},
	{60637, 0x30},
	{60645, 0xC0},
	{60653, 0xF00},
	{60659, 0x1000},
	{29039, 0x2000},
	{60677, 0xF0000},
	{60683, 0xF00000},
	{60689, 0x7000000},
	{60698, 0x38000000},
	{60707, 0xC0000000},
	/* 3975 */
	{60713, 0x3F},
	{60723, 0x3F00},
	{60733, 0x3F0000},
	{60743, 0xF000000},
	/* 3979 */
	{60753, 0xFF},
	{60762, 0x1FF000},
	/* 3981 */
	{60788, 0xF},
	{60795, 0x70},
	{60817, 0x1F00},
	{60826, 0xE000},
	/* 3985 */
	{1283, 0xFF},
	/* 3986 */
	{115112, 0x7},
	{115120, 0x8},
	{115131, 0x10},
	{115144, 0xE0},
	{115160, 0x300},
	{115170, 0xC00},
	{115180, 0x70000},
	{60951, 0x380000},
	{115192, 0xC00000},
	{115199, 0x1000000},
	{115206, 0x6000000},
	{74682, 0x8000000},
	{115214, 0x10000000},
	/* 3999 */
	{10165, 0xFF},
	/* 4000 */
	{104287, 0x1},
	{115231, 0x2},
	{61440, 0x4},
	{115246, 0x8},
	{115262, 0x10},
	{61413, 0x20},
	{115271, 0x40},
	{115282, 0x80},
	{115292, 0x100},
	{115302, 0x200},
	{115312, 0x400},
	{115323, 0x800},
	{115334, 0x1000},
	{115346, 0x2000},
	{115355, 0x4000},
	{115365, 0x8000},
	{102003, 0x10000},
	{102020, 0x20000},
	{115374, 0x40000},
	{115392, 0x80000},
	{115407, 0x100000},
	/* 4021 */
	{115423, 0x2},
	{115438, 0x4},
	{115456, 0x8},
	{61537, 0x10},
	{115471, 0x20},
	{115487, 0x40},
	{115501, 0x100},
	{115510, 0x200},
	{115519, 0x400},
	{115540, 0x800},
	{115549, 0x1000},
	{115558, 0x2000},
	{115568, 0x4000},
	{115577, 0x10000},
	{115586, 0x20000},
	{115594, 0x80000},
	{115603, 0x100000},
	{115615, 0x200000},
	{115628, 0x400000},
	{115641, 0x20000000},
	/* 4041 */
	{115650, 0x1},
	{115660, 0x2},
	{115670, 0x4},
	{115680, 0x8},
	{115690, 0x10},
	{115700, 0x20},
	{115710, 0x40},
	{115720, 0x80},
	{115730, 0x100},
	{115740, 0x200},
	{115750, 0x400},
	{115760, 0x800},
	{115770, 0x1000},
	{115780, 0x2000},
	{115790, 0x4000},
	{115800, 0x8000},
	/* 4057 */
	{115810, 0xFF},
	/* 4058 */
	{115823, 0x3F},
	{115842, 0xFC0},
	/* 4060 */
	{61096, 0xF},
	{61325, 0x1},
	{61119, 0x10},
	{61142, 0x20},
	{61165, 0x40},
	{61185, 0x80},
	{61205, 0x100},
	{61457, 0x100},
	{61225, 0x200},
	{62395, 0x200},
	{61245, 0x400},
	{61265, 0x800},
	{61285, 0x1000},
	{61305, 0x2000},
	{61475, 0x10000000},
	{61484, 0x20000000},
	{61493, 0x40000000},
	/* 4077 */
	{115853, 0xF},
	{115862, 0xF0},
	/* 4079 */
	{61513, 0xF},
	{115871, 0x20},
	{61552, 0x80},
	{61575, 0x100},
	{61598, 0x200},
	{61617, 0x1000},
	{61626, 0x2000},
	{61635, 0x4000},
	{61643, 0x8000},
	{115887, 0x10000},
	{115902, 0x20000},
	{115911, 0x40000},
	{115926, 0x80000},
	{61667, 0x100000},
	{115934, 0x200000},
	{61683, 0x400000},
	{61692, 0x800000},
	{61701, 0x1000000},
	{61709, 0x2000000},
	{61717, 0x4000000},
	{61725, 0x10000000},
	{61467, 0x20000000},
	{61743, 0x40000000},
	{61751, 0x80000000},
	/* 4103 */
	{61617, 0x2},
	{61626, 0x4},
	{61692, 0x400000},
	{115902, 0x800000},
	{61709, 0x1000000},
	{61635, 0x2000000},
	{61667, 0x4000000},
	{61683, 0x8000000},
	{61701, 0x20000000},
	{61717, 0x40000000},
	{61743, 0x80000000},
	/* 4114 */
	{115942, 0x1},
	{115956, 0x4},
	{115971, 0x10000},
	{115986, 0x20000},
	{116001, 0x40000},
	{116016, 0x80000},
	/* 4120 */
	{116031, 0x3F},
	/* 4121 */
	{97377, 0xFF},
	{116048, 0xFF00},
	{97332, 0xFF0000},
	{116057, 0x20000000},
	{97412, 0x40000000},
	{97438, 0x80000000},
	/* 4127 */
	{116077, 0xF},
	{116094, 0x1F00},
	/* 4129 */
	{52451, 0xFF},
	/* 4130 */
	{116109, 0x2},
	{116120, 0x20},
	{116131, 0x40},
	{116152, 0x80},
	{116172, 0xF00},
	{116194, 0x1000},
	/* 4136 */
	{116220, 0x1},
	{116228, 0x2},
	{116236, 0x2},
	{116245, 0x8},
	{116261, 0x10},
	{116277, 0x40},
	{116298, 0x80},
	{116319, 0x100},
	{116340, 0x200},
	{116348, 0x200},
	{116369, 0x400},
	{116390, 0x800},
	{116411, 0x1000},
	{116432, 0x2000},
	{116453, 0x4000},
	{116474, 0x8000},
	{116495, 0x10000},
	{116516, 0x20000},
	{116537, 0x40000},
	{116558, 0x80000},
	{116579, 0x100000},
	{116600, 0x200000},
	/* 4158 */
	{116621, 0x3FFFC},
	{116634, 0x300000},
	{116646, 0xC00000},
	{52504, 0x80000000},
	/* 4162 */
	{116656, 0x1},
	{116673, 0x80000},
	/* 4164 */
	{98023, 0x3F},
	{98842, 0x400},
	{98869, 0x800},
	{116693, 0x1000},
	{98896, 0x2000},
	{98922, 0x4000},
	{98948, 0x10000},
	{98975, 0x20000},
	{99001, 0x40000},
	{99027, 0x80000},
	{99055, 0x100000},
	{99081, 0x200000},
	{99107, 0x400000},
	{116720, 0x800000},
	{99133, 0x1000000},
	{99160, 0x2000000},
	{99187, 0x4000000},
	{116746, 0x8000000},
	{116772, 0x10000000},
	/* 4183 */
	{98023, 0x3F},
	{98842, 0x400},
	{98869, 0x800},
	{98896, 0x1000},
	{98922, 0x2000},
	{98948, 0x8000},
	{98975, 0x10000},
	{99055, 0x20000},
	{99081, 0x40000},
	{116693, 0x80000},
	{99001, 0x100000},
	{99160, 0x200000},
	/* 4195 */
	{52529, 0x3FFFF},
	/* 4196 */
	{116798, 0x1},
	{116811, 0x2},
	{116815, 0x4},
	{116837, 0x8},
	{116851, 0x10},
	{116865, 0x20},
	{116883, 0x40},
	{116901, 0x80},
	{29039, 0x2000000},
	{103208, 0xC000000},
	/* 4206 */
	{96112, 0x3},
	{10136, 0xFFFFFFFC},
	/* 4208 */
	{116916, 0x3},
	{24499, 0xFFFFFFFC},
	/* 4210 */
	{116937, 0x3},
	{25015, 0xFFFFFFFC},
	/* 4212 */
	{96086, 0xFF},
	{96098, 0x30000},
	{26824, 0xE0000000},
	/* 4215 */
	{116958, 0x3},
	{26374, 0xFFFFFFFC},
	/* 4217 */
	{26392, 0xFF},
	/* 4218 */
	{116975, 0x3},
	{26446, 0xFFFFFFFC},
	/* 4220 */
	{26464, 0xFF},
	/* 4221 */
	{26523, 0xFF},
	{96122, 0x10000},
	{96138, 0x100000},
	{96154, 0x3000000},
	{96170, 0xE0000000},
	/* 4226 */
	{97077, 0x1},
	{97093, 0x2},
	{97109, 0x40},
	{97127, 0x80},
	{97145, 0x100},
	{97163, 0x200},
	{97181, 0x400},
	{97199, 0x800},
	{97217, 0x1000},
	{97235, 0x2000},
	{97253, 0x4000},
	{96372, 0x8000},
	{116992, 0x10000},
	{96392, 0x40000},
	{97270, 0x80000},
	{97286, 0x200000},
	{96409, 0x400000},
	{96425, 0x800000},
	{96439, 0x2000000},
	{96453, 0x4000000},
	{96467, 0x8000000},
	{96488, 0x10000000},
	{96513, 0x20000000},
	/* 4249 */
	{97302, 0xFF},
	{96558, 0x3000000},
	{117010, 0x40000000},
	{1166, 0x80000000},
	/* 4253 */
	{26761, 0xFF},
	/* 4254 */
	{26802, 0xFF},
	/* 4255 */
	{96563, 0x1FFFFF},
	{96601, 0x200000},
	{117024, 0xC00000},
	{117033, 0x3000000},
	{96574, 0x4000000},
	{96578, 0x8000000},
	{96582, 0x10000000},
	{96587, 0x20000000},
	{96592, 0x40000000},
	/* 4264 */
	{96642, 0x30},
	{96654, 0xF0000},
	{96667, 0x10000000},
	{96682, 0x20000000},
	{96696, 0xC0000000},
	/* 4269 */
	{96757, 0x1},
	/* 4270 */
	{117042, 0x1},
	{117067, 0x2},
	{117105, 0x4},
	{117146, 0x8},
	{117169, 0x10},
	{117192, 0x20},
	{117216, 0x40},
	{117246, 0x80},
	{117275, 0x100},
	{117306, 0x400},
	{117332, 0x800},
	{117361, 0x1000},
	{117386, 0x2000},
	{64088, 0x4000},
	{64109, 0x8000},
	/* 4285 */
	{117421, 0x1},
	{117448, 0x4},
	{117475, 0x10},
	{117504, 0x400},
	{117533, 0x800},
	{117562, 0x1000},
	{117590, 0x2000},
	{117620, 0x4000},
	{117647, 0x8000},
	{117675, 0x10000},
	{117701, 0x20000},
	{117727, 0x800000},
	{117752, 0x1000000},
	{117778, 0x2000000},
	{117803, 0x4000000},
	{117827, 0x8000000},
	{117852, 0x10000000},
	{117881, 0x10000000},
	/* 4303 */
	{117909, 0x1},
	{117935, 0x2},
	{117961, 0x4},
	{117988, 0x10},
	{118014, 0x20},
	{118036, 0x40},
	{118057, 0x80},
	{118089, 0x100},
	{118116, 0x200},
	{118138, 0x400},
	{118162, 0x800},
	{118187, 0x1000},
	{118210, 0x2000},
	{118237, 0x4000},
	{118262, 0x8000},
	{118290, 0x10000},
	{118315, 0x20000},
	{118340, 0x40000},
	{118365, 0x80000},
	{118394, 0x100000},
	{118425, 0x200000},
	{118453, 0x400000},
	{118480, 0x800000},
	{118510, 0x1000000},
	{118537, 0x2000000},
	{118564, 0x4000000},
	{118591, 0x8000000},
	{118617, 0x10000000},
	{118641, 0x20000000},
	{118673, 0x40000000},
	{118700, 0x80000000},
	/* 4334 */
	{63425, 0x1},
	{118726, 0x40},
	{118745, 0x80},
	{118765, 0x100},
	{118784, 0x200},
	{118798, 0x400},
	{118811, 0x1000},
	{118833, 0x2000},
	{118856, 0x4000},
	{118877, 0x8000},
	{118894, 0x20000},
	{118909, 0x40000},
	{118923, 0x80000},
	{118937, 0x100000},
	{118953, 0x200000},
	{118966, 0x400000},
	/* 4350 */
	{118985, 0x80},
	{119000, 0x100},
	{63109, 0x200},
	{63123, 0x400},
	{63142, 0x800},
	{63161, 0x1000},
	{104326, 0x2000},
	{118789, 0x8000},
	{119015, 0x10000},
	{118803, 0x20000},
	{119024, 0x40000},
	{63237, 0x80000},
	{63252, 0x100000},
	{119035, 0x200000},
	{61414, 0x400000},
	{63285, 0x800000},
	{62102, 0x1000000},
	{119053, 0x2000000},
	{118958, 0x4000000},
	{62092, 0x8000000},
	{63176, 0x10000000},
	{63193, 0x20000000},
	{63215, 0x40000000},
	{61467, 0x80000000},
	/* 4374 */
	{2025, 0x3F},
	{119066, 0x3F00},
	{119081, 0x3F0000},
	/* 4377 */
	{52873, 0x1F},
	/* 4378 */
	{119096, 0xF},
	{119119, 0x3F00},
	/* 4380 */
	{119140, 0xF},
	/* 4381 */
	{119159, 0x10},
	{119180, 0x40},
	{119202, 0x100},
	{119223, 0x1000000},
	{119231, 0x2000000},
	{119239, 0x4000000},
	{119248, 0x8000000},
	{119257, 0x10000000},
	{119265, 0x20000000},
	/* 4390 */
	{119273, 0xFF},
	{119294, 0x700},
	{119315, 0xFF00000},
	{119335, 0x70000000},
	/* 4394 */
	{119355, 0x1},
	/* 4395 */
	{119376, 0xFFFFF},
	/* 4396 */
	{119384, 0xFFFFFFF},
	{119400, 0xF0000000},
	/* 4398 */
	{119416, 0xFFFF},
	{119431, 0xFFFF0000},
	/* 4400 */
	{27497, 0xFF},
	/* 4401 */
	{27551, 0xFF},
	/* 4402 */
	{27603, 0xFF},
	/* 4403 */
	{27734, 0xFF},
	/* 4404 */
	{119447, 0xFF},
	{119457, 0xFF00},
	{119467, 0xFF0000},
	{119480, 0xFF000000},
	/* 4408 */
	{119493, 0xFF},
	{119506, 0xFF00},
	{119519, 0xFF0000},
	{119532, 0xFF000000},
	/* 4412 */
	{119545, 0xFF},
	{119556, 0xFF00},
	{119567, 0xFF0000},
	/* 4415 */
	{119578, 0x3F},
	{119592, 0x3F00},
	/* 4417 */
	{119606, 0xFF},
	{119617, 0xFF00},
	/* 4419 */
	{119628, 0x7FF},
	{119641, 0x7FF0000},
	/* 4421 */
	{119653, 0x1FF},
	/* 4422 */
	{119661, 0x7FF},
	/* 4423 */
	{119673, 0x3FF},
	/* 4424 */
	{53177, 0x7FF},
	{119681, 0x3000},
	{119692, 0x30000},
	/* 4427 */
	{119706, 0x3FF},
	{119723, 0x3FF0000},
	/* 4429 */
	{119740, 0x3FF},
	{119759, 0x3FF0000},
	/* 4431 */
	{119778, 0x3FF},
	{119797, 0x3FF0000},
	/* 4433 */
	{119816, 0x3FF},
	/* 4434 */
	{119825, 0x3FF},
	{119834, 0x3FF0000},
	/* 4436 */
	{119843, 0x7FF},
	{119856, 0x7FF0000},
	/* 4438 */
	{119868, 0x7FF},
	/* 4439 */
	{119880, 0x3FF},
	{119897, 0x3FF0000},
	/* 4441 */
	{119914, 0x3FF},
	{119933, 0x3FF0000},
	/* 4443 */
	{119952, 0x3FF},
	{119971, 0x3FF0000},
	/* 4445 */
	{119990, 0x4000},
	{120016, 0x20000},
	{120046, 0x80000},
	{120069, 0x100000},
	{120093, 0x400000},
	{120117, 0x800000},
	{120139, 0x1000000},
	{120165, 0x4000000},
	{120189, 0x8000000},
	{120221, 0x20000000},
	{120243, 0x40000000},
	{120265, 0x80000000},
	/* 4457 */
	{98023, 0xFF},
	{98032, 0xFFC00},
	{99580, 0xF00000},
	{99601, 0xF000000},
	{99634, 0xF0000000},
	/* 4462 */
	{98023, 0xFF},
	{99634, 0xF0000000},
	/* 4464 */
	{120287, 0x3FF},
	/* 4465 */
	{53643, 0x1FF},
	/* 4466 */
	{53667, 0x3F},
	/* 4467 */
	{53690, 0x3F},
	/* 4468 */
	{83259, 0x7},
	{120298, 0x70000},
	/* 4470 */
	{53735, 0x3},
	{120311, 0x20},
	{120330, 0xC0},
	{120344, 0x200},
	{120356, 0x800},
	{120377, 0x1000},
	{120394, 0x2000},
	{120415, 0x1F0000},
	/* 4478 */
	{120424, 0x7F},
	{87773, 0x80},
	{120445, 0x3FFF00},
	{87838, 0xFFC00000},
	/* 4482 */
	{120462, 0x1F},
	/* 4483 */
	{120473, 0x3},
	/* 4484 */
	{115926, 0x1},
	{120491, 0x2},
	{120503, 0x4},
	{120519, 0x8},
	{120531, 0x10},
	/* 4489 */
	{120543, 0x3F},
	{120558, 0x40},
	/* 4491 */
	{120578, 0x3F},
	{120592, 0x40},
	/* 4493 */
	{115902, 0x1},
	{120611, 0x2},
	{120629, 0x4},
	{120642, 0x8},
	{120654, 0x10},
	{120666, 0x20},
	{120678, 0x40},
	{120690, 0x80},
	{120702, 0x100},
	{120714, 0x200},
	/* 4503 */
	{120728, 0xFF},
	/* 4504 */
	{18635, 0x3F, 29, 37050},
	/* 4505 */
	{214, 0x3, 2, 36326},
	/* 4506 */
	{120936, 0xF},
	{120945, 0xFF0},
	{120960, 0x1000000},
	{120975, 0x2000000},
	{120987, 0x4000000},
	{120998, 0x8000000},
	{121013, 0x10000000},
	{121028, 0x20000000},
	{121040, 0x40000000},
	{121054, 0x80000000},
	/* 4516 */
	{10053, 0x1},
	{10283, 0x1E},
	/* 4518 */
	{120936, 0xF},
	{120945, 0xFF0},
	{120960, 0x1000000},
	{120975, 0x2000000},
	{120987, 0x4000000},
	{120998, 0x8000000},
	{121013, 0x10000000},
	{121040, 0x20000000},
	{121067, 0x20000000},
	{121054, 0x80000000},
	/* 4528 */
	{121082, 0x1},
	{121095, 0x7E},
	{121112, 0x80},
	/* 4531 */
	{97458, 0x7F},
	{97524, 0x600, 4, 36536},
	/* 4533 */
	{121137, 0x6},
	{121147, 0x8},
	{121167, 0x10},
	{121176, 0xFFFF0000},
	/* 4537 */
	{121189, 0x1F},
	/* 4538 */
	{121203, 0x80000000},
	/* 4539 */
	{121211, 0x1},
	{121232, 0x6},
	{121245, 0x8},
	{121268, 0x10},
	{121288, 0x20},
	{121307, 0x10000000},
	{121318, 0x20000000},
	{121329, 0x40000000},
	{121340, 0x80000000},
	/* 4548 */
	{120936, 0xF},
	{120945, 0xFF0},
	{120960, 0x1000000},
	{121351, 0x2000000},
	{121366, 0x4000000},
	{120998, 0x8000000},
	{121013, 0x10000000},
	{121381, 0x20000000},
	{121397, 0x40000000},
	{121413, 0x80000000},
	/* 4558 */
	{121430, 0x80000000},
	/* 4559 */
	{18619, 0xFF},
	/* 4560 */
	{98023, 0x1FF},
	{98032, 0xFFC00},
	{99580, 0xF00000},
	/* 4563 */
	{121438, 0xFFFF},
	{121460, 0xFFFF0000},
	/* 4565 */
	{120936, 0xF},
	{120945, 0xFF0},
	{120960, 0x1000000},
	{121351, 0x2000000},
	{121366, 0x4000000},
	{120998, 0x8000000},
	{121013, 0x10000000},
	{121067, 0x20000000},
	{121482, 0x40000000},
	{121497, 0x80000000},
	/* 4575 */
	{121512, 0x3F},
	{121539, 0x7FC0},
	{121565, 0x1F8000},
	{121587, 0xFF800000},
	/* 4579 */
	{121612, 0x3F},
	{121636, 0xFC0},
	{121660, 0x3F000},
	{121680, 0xFC0000},
	/* 4583 */
	{121700, 0x3F},
	/* 4584 */
	{121714, 0x1},
	{121740, 0x2},
	{121763, 0x4},
	{121788, 0x8},
	{121819, 0x10},
	{121853, 0x20},
	{121873, 0xC0},
	{121900, 0x100},
	{121928, 0x200},
	{121963, 0x400},
	{121993, 0x800},
	{122028, 0x1000},
	{122058, 0x2000},
	{122081, 0x4000},
	{122120, 0x8000},
	{122152, 0x10000},
	{122188, 0x20000},
	{122218, 0x40000},
	{122264, 0x80000},
	{122305, 0x100000},
	{122355, 0x200000},
	{122405, 0x400000},
	{122456, 0x800000},
	{122504, 0x1000000},
	{121329, 0x40000000},
	{121340, 0x80000000},
	/* 4610 */
	{97370, 0xFF},
	{115015, 0x100},
	{122550, 0x200},
	{122569, 0x400},
	{122590, 0x800},
	{122609, 0x1000},
	{122631, 0x2000},
	{122652, 0x4000},
	{122675, 0x8000},
	/* 4619 */
	{122705, 0x3},
	{122721, 0xC},
	{122737, 0x30},
	{122753, 0x40},
	{122768, 0x80},
	{122786, 0x100},
	{122801, 0x200},
	{122820, 0x400},
	{122838, 0x800},
	/* 4628 */
	{122859, 0x1},
	{122875, 0x2},
	{122891, 0x4},
	/* 4631 */
	{109108, 0x7F},
	{122911, 0x380},
	{122915, 0x1FFC00},
	/* 4634 */
	{122919, 0x3F},
	{122932, 0xF00},
	{114689, 0x10000000},
	{122944, 0x20000000},
	{116901, 0x40000000},
	{116870, 0x80000000},
	/* 4640 */
	{122958, 0xF},
	{122978, 0xF00},
	{122995, 0x30000},
	{123011, 0xC0000},
	/* 4644 */
	{60994, 0x1},
	{91034, 0x2, 4, 36416},
	{90969, 0x4, 2, 36414},
	{19929, 0x8, 4, 36410},
	{90887, 0x10, 2, 36408},
	{90856, 0x20, 4, 36404},
	{99730, 0x40},
	{99736, 0x1F00},
	{99746, 0x2000},
	/* 4653 */
	{123031, 0xF0000},
	{123049, 0xF00000},
	{123067, 0xF000000},
	{123085, 0xF0000000},
	/* 4657 */
	{61346, 0x1},
	{123103, 0x2},
	{123122, 0xFFF0},
	{123137, 0xFFF0000},
	/* 4661 */
	{98023, 0x1FF},
	{99716, 0xF000},
	{123152, 0xF0000},
	{51680, 0xF00000},
	{123168, 0xF000000},
	{99634, 0xF0000000},
	/* 4667 */
	{123178, 0xFFFF},
	{123194, 0xFFFF0000},
	/* 4669 */
	{120936, 0xF},
	{120945, 0xFF0},
	{121040, 0x40000000},
	{121054, 0x80000000},
	/* 4673 */
	{55630, 0xF},
	{60637, 0x30},
	{123210, 0xFC0},
	{123220, 0x1000},
	{123230, 0x2000},
	{115810, 0x4000},
	{123241, 0x8000},
	{452, 0xFFFF0000},
	/* 4681 */
	{38, 0x3FFFFF},
	/* 4682 */
	{123251, 0x1F},
	{123258, 0x20},
	{65156, 0x80},
	{123265, 0x3000},
	{65169, 0x4000},
	{65182, 0x8000},
	{123276, 0xFFFF0000},
	{123276, 0xFFFF0000},
	/* 4690 */
	{2303, 0xFFFF},
	{123288, 0xFF0000},
	{65194, 0x1000000},
	/* 4693 */
	{123297, 0xFFFF},
	{123306, 0xFFFF0000},
	/* 4695 */
	{2261, 0x3FFFFFFF},
	{123315, 0xC0000000},
	/* 4697 */
	{65308, 0x7},
	{65323, 0x70000},
	{123327, 0x20000000},
	{61346, 0x40000000},
	{73713, 0x80000000},
	/* 4702 */
	{123335, 0x7},
	{123343, 0x38},
	{123351, 0x1C0},
	{123359, 0xE00},
	{123367, 0x7000},
	{123375, 0x38000},
	{123383, 0x1C0000},
	{1153, 0x600000},
	{123391, 0x1800000},
	{123404, 0x2000000},
	{60393, 0x4000000},
	{123417, 0x18000000},
	{123428, 0x20000000},
	{65129, 0x40000000},
	{70080, 0x80000000},
	/* 4717 */
	{123438, 0x80000000},
	/* 4718 */
	{54917, 0x7},
	/* 4719 */
	{123451, 0x3FFF},
	{123461, 0x3FFF0000},
	{123471, 0xC0000000},
	/* 4722 */
	{123484, 0x3FFF},
	{123500, 0x3FF0000},
	{123525, 0x78000000},
	{123550, 0x80000000},
	/* 4726 */
	{74410, 0x1},
	{73982, 0x2},
	{11403, 0x4},
	/* 4729 */
	{123564, 0xFF},
	{123573, 0xFF00},
	{123582, 0xFF0000},
	{123591, 0xFF000000},
	/* 4733 */
	{123600, 0x3F},
	{123608, 0x1F00},
	{123617, 0x1FF0000},
	/* 4736 */
	{123626, 0x3F},
	{123634, 0x1F00},
	{123643, 0x1FF0000},
	/* 4739 */
	{55630, 0xF},
	{60637, 0x30},
	{30650, 0x1C0},
	{60683, 0x1E00},
	/* 4743 */
	{65509, 0x7, 8, 37079},
	{65519, 0x38, 8, 37079},
	{65529, 0x1C0, 8, 37079},
	{65539, 0xE00, 8, 37079},
	{114229, 0x7000, 8, 37087},
	{114217, 0x78000, 16, 37095},
	{124297, 0x180000},
	{69776, 0x600000},
	{69789, 0x800000},
	{89068, 0x1000000},
	{124310, 0x2000000},
	{124322, 0x4000000},
	{89081, 0x38000000},
	{220, 0xC0000000, 4, 37111},
	/* 4757 */
	{65464, 0xFF},
	{70110, 0xFFF00},
	{114217, 0x3F00000, 64, 37115},
	{114229, 0x3C000000, 16, 37179},
	{89081, 0xC0000000},
	/* 4762 */
	{71830, 0x3FFF},
	{71937, 0xFFFC000},
	{72340, 0x70000000},
	{126380, 0x80000000},
	/* 4766 */
	{65509, 0x7, 8, 37079},
	{65519, 0x38, 8, 37079},
	{65529, 0x1C0, 8, 37079},
	{65539, 0xE00, 8, 37079},
	{72159, 0xF000},
	{72170, 0xF0000},
	{126391, 0x1F00000},
	{126404, 0x2000000},
	{89081, 0x4000000},
	{89068, 0x8000000},
	{220, 0xF0000000, 16, 37195},
	/* 4777 */
	{18619, 0x1FFF},
	{21335, 0x7FFE000},
	/* 4779 */
	{72296, 0x1FFF},
	{126715, 0x3FFE000},
	/* 4781 */
	{72327, 0xFFF},
	{72391, 0xFF000},
	{72364, 0x100000},
	{126726, 0xFFE00000},
	/* 4785 */
	{69921, 0x7, 8, 37211},
	{69929, 0x38, 8, 37211},
	{69937, 0x1C0, 8, 37211},
	{69945, 0xE00},
	{69961, 0x7000, 8, 37219},
	{69980, 0x8000},
	{69999, 0x70000},
	{70015, 0x80000},
	{70030, 0x100000},
	{70044, 0x7E00000},
	{70055, 0x8000000},
	{70067, 0x10000000},
	{70085, 0x60000000, 3, 37227},
	/* 4798 */
	{70142, 0x3FFF},
	{70186, 0xFC000},
	{70199, 0x300000, 4, 37230},
	{70213, 0xC00000, 4, 37230},
	{70227, 0x3000000, 3, 37234},
	{70236, 0xC000000, 3, 37237},
	{70247, 0x10000000},
	{127467, 0x20000000},
	{127484, 0x40000000},
	/* 4807 */
	{70151, 0xFFF},
	{127500, 0x20000000},
	{70168, 0xC0000000, 4, 37240},
	/* 4810 */
	{70482, 0x7},
	{70492, 0x70},
	{127642, 0x700},
	{70534, 0x3000},
	{127663, 0x70000},
	{127687, 0x700000},
	{127696, 0x3000000},
	{127716, 0x30000000},
	{127725, 0x40000000},
	/* 4819 */
	{127775, 0x3, 4, 37244},
	{70923, 0x3C, 16, 2765},
	{71351, 0x7C0, 18, 2781},
	{71541, 0x3800, 7, 2800},
	{71700, 0x1C00000, 5, 2807},
	{71720, 0x6000000},
	/* 4825 */
	{72626, 0x3F},
	{72632, 0x3C0},
	{70322, 0xC00},
	{72722, 0xFF000, 193, 2834},
	{60393, 0x100000},
	{60186, 0x200000},
	{127791, 0x400000},
	{72733, 0x800000},
	{72743, 0x1000000},
	{127802, 0xE000000},
	{127812, 0x10000000},
	/* 4836 */
	{72772, 0x1},
	{72783, 0x3E},
	{72793, 0x40},
	{72806, 0x80},
	{72818, 0xFF00},
	{60329, 0x7F0000, 257, 0},
	/* 4842 */
	{72626, 0x3F},
	{72632, 0x3C0},
	{70322, 0xC00},
	{72722, 0xFF000, 193, 2834},
	{60393, 0x100000},
	{60186, 0x200000},
	{127791, 0x400000},
	{72733, 0x800000},
	{73263, 0x3000000},
	{73277, 0x4000000},
	{127802, 0x38000000},
	{127812, 0x40000000},
	/* 4854 */
	{72772, 0x1},
	{72783, 0x3E},
	{72793, 0x40},
	{73293, 0x80},
	{73303, 0x100},
	{73315, 0x200},
	{73327, 0x400},
	{73339, 0x800},
	{73351, 0x1000},
	{60329, 0xFE000, 257, 0},
	/* 4864 */
	{72626, 0x3F},
	{72632, 0x3C0},
	{70322, 0xC00},
	{72722, 0xFF000, 193, 2834},
	{60393, 0x100000},
	{60186, 0x200000},
	{127791, 0x400000},
	{72733, 0x800000},
	{73277, 0x1000000},
	{127802, 0xE000000},
	{127812, 0x10000000},
	/* 4875 */
	{72772, 0x1},
	{72783, 0x3E},
	{72793, 0x40},
	{60329, 0x3F80, 257, 0},
	/* 4879 */
	{72772, 0x1},
	{72783, 0x3E},
	{72793, 0x40},
	{73293, 0x80},
	{60329, 0x7F00, 257, 0},
	{60762, 0x1FF00000},
	/* 4885 */
	{72626, 0x3F},
	{72632, 0x3C0},
	{70322, 0xC00},
	{72722, 0xFF000, 193, 2834},
	{60393, 0x100000},
	{60186, 0x200000},
	{127791, 0x400000},
	{72733, 0x800000},
	{127802, 0x7000000},
	{127812, 0x8000000},
	/* 4895 */
	{72772, 0x1},
	{72783, 0x3E},
	{72793, 0x40},
	{73293, 0x80},
	{73499, 0x100},
	{60329, 0xFE00, 257, 0},
	/* 4901 */
	{72626, 0x3F},
	{72632, 0x3C0},
	{70322, 0xC00},
	{72722, 0xFF000, 193, 2834},
	{60393, 0x100000},
	{60186, 0x200000},
	{127791, 0x400000},
	{72733, 0x800000},
	{73263, 0x3000000},
	{127802, 0x1C000000},
	{127812, 0x20000000},
	/* 4912 */
	{72772, 0x1},
	{72783, 0x3E},
	{72793, 0x40},
	{60762, 0xFF80},
	{60329, 0x7F0000, 257, 0},
	/* 4917 */
	{73510, 0x1},
	{73528, 0x2},
	{73542, 0x4},
	{73561, 0x8},
	{73581, 0x10},
	{73601, 0x20},
	{73623, 0x40},
	{127822, 0x380},
	{73634, 0x400},
	{73652, 0x800},
	{115074, 0x1000},
	{73684, 0x4000},
	/* 4929 */
	{55626, 0xFFF},
	/* 4930 */
	{402, 0xFF},
	{115083, 0x100},
	/* 4932 */
	{72626, 0x3F},
	{72632, 0x3C0},
	{70322, 0xC00},
	{72722, 0xFF000, 193, 2834},
	{60393, 0x100000},
	{60186, 0x200000},
	{127791, 0x400000},
	{72733, 0x800000},
	{73737, 0x1000000},
	{127812, 0x2000000},
	/* 4942 */
	{73800, 0x3F},
	{127842, 0x3F},
	{73813, 0xF000},
	{73823, 0x3F0000},
	{73838, 0x400000},
	{73853, 0x800000},
	{73869, 0x7000000},
	/* 4949 */
	{127860, 0xFFFF},
	{127870, 0xFFFF0000},
	/* 4951 */
	{43125, 0x1},
	{127880, 0x2},
	{127889, 0x4},
	{127898, 0x8},
	{127906, 0x10},
	{127918, 0x20},
	{127930, 0x40},
	{127942, 0x80},
	{127954, 0x100},
	{127965, 0x200},
	{127975, 0x400},
	{127983, 0x800},
	{128009, 0x1000},
	{128022, 0x2000},
	{128033, 0x4000},
	{128043, 0x8000},
	{128057, 0x10000},
	{128073, 0x20000},
	{128089, 0x40000},
	{128105, 0x80000},
	{128116, 0x100000},
	{128133, 0x200000},
	{128149, 0x400000},
	{128168, 0x2000000},
	{128182, 0x4000000},
	{128191, 0x8000000},
	{128205, 0x30000000},
	{128220, 0x40000000},
	{128229, 0x80000000},
	/* 4980 */
	{74190, 0x1},
	{74214, 0x2},
	{74304, 0x70},
	{74316, 0xF00},
	{74329, 0xF000},
	{74342, 0xF0000},
	{74355, 0xF00000},
	{74369, 0xF000000},
	{74387, 0xF0000000},
	/* 4989 */
	{74404, 0x7FF},
	{74431, 0xFFE000},
	{74441, 0x1000000},
	{74453, 0x2000000},
	/* 4993 */
	{128243, 0xF},
	{70923, 0xF0, 16, 2765},
	{71351, 0x1F00, 18, 2781},
	{71825, 0x6000, 4, 2812},
	{71932, 0x18000, 4, 2816},
	{72044, 0x60000, 4, 2820},
	{72131, 0x180000, 4, 2824},
	/* 5000 */
	{17473, 0x3, 4, 3051},
	{75736, 0xC},
	{71541, 0xE000, 7, 2800},
	{95458, 0x700000},
	{75887, 0x8000000},
	{75902, 0x10000000},
	{75912, 0x20000000},
	{75932, 0x80000000},
	/* 5008 */
	{17473, 0x1, 2, 3059},
	{71541, 0xE000, 7, 2800},
	{95458, 0x700000},
	{75887, 0x8000000},
	{75975, 0x20000000},
	/* 5013 */
	{128262, 0x7FF},
	{128277, 0x3FF800},
	/* 5015 */
	{128293, 0x3FFFFF},
	/* 5016 */
	{55840, 0x3},
	/* 5017 */
	{80516, 0x3F},
	{80527, 0x40},
	{80570, 0x4000},
	/* 5020 */
	{11780, 0xFF},
	/* 5021 */
	{83981, 0x8},
	{1153, 0x70, 6, 36013},
	{83254, 0xFF0000, 256, 36021},
	/* 5024 */
	{18635, 0x1F, 29, 37050},
	{87580, 0x4000},
	{87593, 0x8000},
	{87606, 0x70000},
	/* 5028 */
	{88720, 0x3F, 3, 36322},
	{88733, 0x3F00, 3, 36322},
	{88748, 0x3F0000, 3, 36322},
	{88763, 0xFC00000, 3, 36322},
	{88778, 0x80000000},
	/* 5033 */
	{214, 0x3, 2, 36326},
	{88915, 0xC, 4, 36329},
	{88995, 0x30, 3, 36333},
	{89055, 0xC0, 4, 37248},
	{89068, 0x100},
	{83422, 0x200},
	{89072, 0x400},
	/* 5040 */
	{90291, 0x3F, 60, 37252},
	{65469, 0x7FC0000},
	{90302, 0x8000000},
	/* 5043 */
	{95044, 0x1},
	{90505, 0x2},
	{128421, 0x4},
	{128444, 0x8},
	{128452, 0x3F0},
	{128467, 0xFC00},
	{90584, 0x10000},
	/* 5050 */
	{220, 0x3, 3, 36420},
	{91366, 0x1C, 4, 36423},
	{91443, 0xE0, 4, 36427},
	{91452, 0x100},
	{91472, 0x200},
	{91483, 0x3C00},
	{91505, 0x4000},
	{89055, 0x18000, 4, 37248},
	/* 5058 */
	{91872, 0x1},
	{91887, 0x2},
	{91902, 0x4},
	{91917, 0x8},
	{91932, 0x70},
	{91964, 0xF00},
	{91981, 0x80000000},
	/* 5065 */
	{94333, 0x3, 4, 36472},
	{17473, 0x7C, 24, 36476},
	{70573, 0x80},
	{94931, 0x700, 8, 36508},
	{94987, 0x1800, 4, 36516},
	{84030, 0x2000},
	{75024, 0x4000},
	{94997, 0x8000},
	{95009, 0x10000},
	{95022, 0x20000},
	{92601, 0x40000},
	{95035, 0x80000},
	{95262, 0x700000, 8, 36520},
	{95284, 0x3800000, 8, 36520},
	{95308, 0x4000000},
	/* 5080 */
	{96898, 0xF00, 5, 36564},
	{101533, 0x10000},
	{101545, 0x100000},
	{101560, 0xC0000000, 4, 36570},
	/* 5084 */
	{26761, 0xFFFF},
	{96898, 0x300000, 2, 36574},
	{101608, 0x8000000, 2, 36570},
	{101630, 0x60000000, 3, 36578},
	{101638, 0x80000000},
	/* 5089 */
	{96563, 0x1FFFFF},
	{101676, 0x200000},
	{117024, 0xC00000, 4, 37312},
	{117033, 0x3000000, 4, 37312},
	{96574, 0x4000000, 2, 36582},
	{96578, 0x8000000, 2, 36582},
	{96582, 0x10000000, 2, 36584},
	{96587, 0x20000000, 2, 36584},
	{96592, 0x40000000},
	/* 5098 */
	{101608, 0x1, 2, 36570},
	{96898, 0x300000, 2, 36574},
	{101630, 0x60000000, 3, 36578},
	{101638, 0x80000000},
	/* 5102 */
	{60167, 0xF},
	{60176, 0xF0},
	{60186, 0x100},
	{60197, 0x200},
	{60202, 0x400},
	{115015, 0x800},
	{60329, 0x1FF000, 257, 0},
	{60360, 0x10000000},
	{60366, 0xE0000000},
	/* 5111 */
	{60531, 0x1FF, 257, 0},
	{60576, 0x3F0000},
	{60629, 0xE0000000},
	/* 5114 */
	{55630, 0xF},
	{60637, 0x30},
	{60645, 0xC0},
	{60653, 0xF00},
	{60659, 0x1000},
	{29039, 0x6000},
	{60677, 0xF0000},
	{60683, 0xF00000},
	{60689, 0x7000000},
	{60698, 0x38000000},
	{60707, 0xC0000000},
	/* 5125 */
	{60788, 0xF},
	{60795, 0x70},
	{60817, 0xF00},
	{60826, 0x7000},
	/* 5129 */
	{61096, 0xF},
	{61119, 0x10},
	{61142, 0x20},
	{61165, 0x40},
	{61185, 0x80},
	{61205, 0x100},
	{61225, 0x200},
	{61245, 0x400},
	{61265, 0x800},
	{61285, 0x1000},
	{61305, 0x2000},
	{61325, 0x4000},
	{61457, 0x1000000},
	{62395, 0x2000000},
	{61475, 0x10000000},
	{61484, 0x20000000},
	{61493, 0x40000000},
	/* 5146 */
	{62012, 0x1},
	{62022, 0x2},
	{62032, 0x4},
	{62041, 0x8},
	{62050, 0x10},
	{62061, 0x20},
	{62072, 0x40},
	{62082, 0x80},
	{118985, 0x100},
	{119000, 0x200},
	{62092, 0x400},
	{62102, 0x800},
	{62119, 0x1000},
	{62237, 0x20000000},
	{62250, 0x40000000},
	{61484, 0x80000000},
	/* 5162 */
	{128507, 0x1},
	{128528, 0x2},
	{62747, 0x8},
	{62766, 0x10},
	{62786, 0x40},
	{62805, 0x100},
	{62826, 0x200},
	{62844, 0x400},
	{128549, 0x800},
	{128570, 0x1000},
	{62867, 0x2000},
	{62889, 0x10000},
	{62910, 0x20000},
	{62928, 0x40000},
	{128593, 0x80000},
	{128614, 0x100000},
	{62951, 0x200000},
	/* 5179 */
	{63066, 0x1},
	{63085, 0x2},
	{118985, 0x4},
	{119000, 0x8},
	{63094, 0x10},
	{63109, 0x20},
	{63123, 0x40},
	{63142, 0x80},
	{63161, 0x100},
	{63176, 0x200},
	{63193, 0x400},
	{63215, 0x800},
	{63237, 0x1000},
	{63252, 0x2000},
	{62092, 0x4000},
	{63267, 0x8000},
	{63412, 0x40000000},
	{61475, 0x80000000},
	/* 5197 */
	{63425, 0x1},
	{63443, 0x2},
	{63457, 0x4},
	{63476, 0x8},
	{63495, 0x10},
	{63510, 0x20},
	{63528, 0x40},
	{63546, 0x80},
	{63563, 0x100},
	{128637, 0x200},
	{63609, 0x800},
	{63633, 0x1000},
	{63651, 0x2000},
	{63669, 0x4000},
	{63690, 0x8000},
	{63714, 0x10000},
	{63740, 0x20000},
	{63757, 0x40000},
	{63777, 0x80000},
	{63797, 0x100000},
	{63817, 0x200000},
	{63838, 0x400000},
	{63861, 0x800000},
	{63882, 0x1000000},
	{63901, 0x2000000},
	{63918, 0x4000000},
	{63934, 0x8000000},
	{63950, 0x10000000},
	{63966, 0x20000000},
	{63985, 0x40000000},
	{63997, 0x80000000},
	/* 5228 */
	{64009, 0x1},
	{64028, 0x2},
	{64048, 0x4},
	{64068, 0x8},
	{117675, 0x10},
	{64088, 0x20},
	{64109, 0x40},
	/* 5235 */
	{123251, 0x1F},
	{123258, 0x20},
	{65156, 0x80},
	{60472, 0xF00},
	{123265, 0x3000},
	{65169, 0x4000},
	{65182, 0x8000},
	{123276, 0xFFFF0000},
	{123276, 0xFFFF0000},
	/* 5244 */
	{10165, 0xF},
	{89068, 0x10},
	/* 5246 */
	{128659, 0xFFFF},
	/* 5247 */
	{65308, 0x3FF},
	{65323, 0x3FF0000},
	{123327, 0x20000000},
	{61346, 0x40000000},
	{73713, 0x80000000},
	/* 5252 */
	{96086, 0xFFFF},
	{96098, 0x10000},
	{26824, 0xE0000000},
	/* 5255 */
	{128669, 0x1000},
	{96194, 0x6000},
	{128677, 0x8000},
	{96223, 0x300000},
	{128690, 0x1000000},
	{96234, 0x6000000},
	{128698, 0x8000000},
	{96263, 0x60000000},
	/* 5263 */
	{128711, 0x7F},
	{128723, 0x3F000},
	{11760, 0x6000000},
	{96877, 0x8000000},
	/* 5267 */
	{27814, 0xFFFF},
	{96898, 0x30000},
	{96906, 0x7000000},
	{96914, 0xE0000000},
	/* 5271 */
	{97890, 0x3F},
	{97895, 0xC0},
	{97903, 0x100},
	{97909, 0xFFFFFE00},
	/* 5275 */
	{86014, 0x1},
	{887, 0x1FFE},
	{220, 0x2000},
	{93895, 0x4000},
	{97917, 0x8000},
	{97929, 0x7FF0000},
	{97940, 0x8000000},
	{97951, 0x10000000},
	{97895, 0xE0000000},
	/* 5284 */
	{98064, 0x3F},
	{98074, 0xFC00},
	/* 5286 */
	{98023, 0x3F},
	{98032, 0xFC00},
	{99580, 0xF00000},
	/* 5289 */
	{98023, 0xFF},
	{99716, 0xF000},
	{123152, 0xF0000},
	{51680, 0xF00000},
	{123168, 0xF000000},
	{99634, 0xF0000000},
	/* 5295 */
	{57217, 0xFF},
	{10536, 0xFFFFFF00},
	/* 5297 */
	{26761, 0xFFFF},
	{96898, 0x300000, 4, 37316},
	{101608, 0x8000000, 2, 36570},
	{101630, 0x60000000, 4, 36578},
	{101638, 0x80000000},
	/* 5302 */
	{101608, 0x1, 2, 36570},
	{96194, 0x6000},
	{96898, 0x300000, 4, 37316},
	{96234, 0x6000000},
	{101630, 0x60000000, 4, 36578},
	{101638, 0x80000000},
	/* 5308 */
	{60167, 0xF},
	{60176, 0xF0},
	{60186, 0x100},
	{60197, 0x200},
	{60202, 0x400},
	{115015, 0x800},
	{60329, 0x1FF000, 257, 0},
	{128740, 0x8000000},
	{60360, 0x10000000},
	{60366, 0xE0000000},
	/* 5318 */
	{60370, 0x1},
	{60374, 0x6},
	{60383, 0x18},
	{60393, 0x20},
	{60398, 0x40},
	{60406, 0x80},
	{60416, 0x100},
	{60427, 0x200},
	{60433, 0x400},
	{60438, 0x800},
	{60444, 0x1000},
	{60455, 0x2000},
	{60460, 0x4000},
	{115034, 0x8000},
	{60216, 0x10000},
	{60480, 0x20000},
	{60488, 0x40000},
	{60500, 0x80000},
	{115047, 0x100000},
	{115061, 0x200000},
	{128751, 0x400000},
	{115083, 0x800000},
	{60519, 0x8000000},
	/* 5341 */
	{60531, 0x1FF, 257, 0},
	{60536, 0x400},
	{60576, 0x3F0000},
	{60629, 0xE0000000},
	/* 5345 */
	{60788, 0xF},
	{60795, 0x70},
	{60817, 0xF00},
	{60826, 0x7000},
	{60835, 0x8000},
	{60848, 0xF0000},
	/* 5351 */
	{115112, 0x7},
	{115120, 0x8},
	{115131, 0x10},
	{115144, 0xE0},
	{115160, 0x300},
	{115170, 0xC00},
	{115180, 0xF0000},
	{60951, 0xF00000},
	{115192, 0x3000000},
	{115199, 0x4000000},
	{115206, 0x18000000},
	{74682, 0x20000000},
	{115214, 0x40000000},
	/* 5364 */
	{128764, 0x1},
	{60896, 0x2},
	{60902, 0x4},
	{60931, 0xF0},
	{60936, 0xF00},
	/* 5369 */
	{61096, 0xF},
	{61119, 0x10},
	{61142, 0x20},
	{61165, 0x40},
	{61185, 0x80},
	{61205, 0x100},
	{61225, 0x200},
	{61245, 0x400},
	{61265, 0x800},
	{61285, 0x1000},
	{61305, 0x2000},
	{61325, 0x4000},
	{61457, 0x1000000},
	{62395, 0x2000000},
	{128771, 0x4000000},
	{61475, 0x10000000},
	{61484, 0x20000000},
	{61493, 0x40000000},
	/* 5387 */
	{62012, 0x1},
	{62022, 0x2},
	{62032, 0x4},
	{62041, 0x8},
	{62050, 0x10},
	{62061, 0x20},
	{62072, 0x40},
	{62082, 0x80},
	{62092, 0x400},
	{62102, 0x800},
	{62119, 0x1000},
	{128787, 0x2000},
	{62237, 0x20000000},
	{62250, 0x40000000},
	{61484, 0x80000000},
	/* 5402 */
	{62747, 0x8},
	{62766, 0x10},
	{62786, 0x40},
	{62805, 0x100},
	{62826, 0x200},
	{62844, 0x400},
	{62867, 0x2000},
	{62889, 0x10000},
	{62910, 0x20000},
	{62928, 0x40000},
	{62951, 0x200000},
	{128800, 0x400000},
	{128824, 0x800000},
	{128848, 0x1000000},
	/* 5416 */
	{63066, 0x1},
	{63085, 0x2},
	{63094, 0x10},
	{63109, 0x20},
	{63123, 0x40},
	{63142, 0x80},
	{63161, 0x100},
	{63176, 0x200},
	{63193, 0x400},
	{63215, 0x800},
	{63237, 0x1000},
	{63252, 0x2000},
	{62092, 0x4000},
	{63267, 0x8000},
	{63276, 0x10000},
	{128787, 0x20000},
	{63367, 0x4000000},
	{63380, 0x8000000},
	{63393, 0x30000000},
	{63412, 0x40000000},
	{61475, 0x80000000},
	/* 5437 */
	{64009, 0x1},
	{64028, 0x2},
	{64048, 0x4},
	{64068, 0x8},
	{64088, 0x20},
	{64109, 0x40},
	{128800, 0x80},
	{128824, 0x100},
	{128848, 0x200},
	/* 5446 */
	{65509, 0x7, 8, 37079},
	{65519, 0x38, 8, 37079},
	{65529, 0x1C0, 8, 37079},
	{65539, 0xE00, 8, 37079},
	{114229, 0x7000, 8, 37320},
	{114217, 0x78000, 16, 37095},
	{124297, 0x180000},
	{69776, 0x600000},
	{69789, 0x800000},
	{89068, 0x1000000},
	{124310, 0x2000000},
	{124322, 0x4000000},
	{89081, 0x38000000},
	{220, 0xC0000000, 4, 37111},
	/* 5460 */
	{65464, 0xFF},
	{70110, 0xFFF00},
	{114217, 0x3F00000, 64, 37115},
	{114229, 0x3C000000, 16, 37328},
	{89081, 0xC0000000},
	/* 5465 */
	{72327, 0xFFF},
	{72391, 0xFF000},
	{72364, 0x100000},
	{72513, 0x200000},
	{72528, 0x400000},
	{72544, 0x800000},
	{129031, 0xF000000},
	{129047, 0xF0000000},
	/* 5473 */
	{69921, 0x7, 8, 37211},
	{69929, 0x38, 8, 37211},
	{69937, 0x1C0, 8, 37211},
	{69945, 0xE00},
	{69961, 0x7000, 8, 37219},
	{69980, 0x8000},
	{69999, 0x70000},
	{70015, 0x80000},
	{70030, 0x100000},
	{70044, 0x7E00000},
	{70055, 0x8000000},
	{70067, 0x10000000},
	{70085, 0x60000000, 3, 37227},
	{129063, 0x80000000},
	/* 5487 */
	{70142, 0x3FFF},
	{70186, 0xFC000},
	{70199, 0x300000, 4, 37230},
	{70213, 0xC00000, 4, 37230},
	{70227, 0x3000000, 3, 37234},
	{70236, 0xC000000, 4, 37344},
	{70247, 0x10000000},
	{127467, 0x20000000},
	{127484, 0x40000000},
	{70266, 0x80000000},
	/* 5497 */
	{72772, 0x1},
	{72783, 0x3E},
	{72793, 0x40},
	{73293, 0x80},
	{73303, 0x100},
	{73315, 0x200},
	{73327, 0x400},
	{73339, 0x800},
	{73351, 0x1000},
	{60329, 0x3FE000, 257, 0},
	{73368, 0x1000000},
	/* 5508 */
	{89068, 0x1},
	{89081, 0x6},
	/* 5510 */
	{17473, 0x3, 4, 3051},
	{75736, 0xC},
	{71541, 0xE000, 7, 2800},
	{95458, 0x700000},
	{75863, 0x7800000},
	{75887, 0x8000000},
	{75902, 0x10000000},
	{75912, 0x20000000},
	{129109, 0x40000000},
	{75932, 0x80000000},
	/* 5520 */
	{17473, 0x1, 2, 3059},
	{71541, 0xE000, 7, 2800},
	{95458, 0x700000},
	{75887, 0x8000000},
	{75975, 0x20000000},
	{129109, 0x40000000},
	/* 5526 */
	{79064, 0x1},
	{129126, 0x2},
	{79091, 0x7C},
	/* 5529 */
	{83981, 0x8},
	{1153, 0x70, 7, 36013},
	{83254, 0xFF0000, 256, 36021},
	/* 5532 */
	{85726, 0x1},
	{85742, 0x2},
	{85758, 0x4},
	{85774, 0x8},
	{85790, 0x10},
	{85806, 0x20},
	{85822, 0x40},
	{85838, 0x80},
	{85854, 0x100},
	{85870, 0x200},
	{85886, 0x400},
	{85902, 0x800},
	{85918, 0x1000},
	{85934, 0x2000},
	{85950, 0x4000},
	{85966, 0x8000},
	{85982, 0x10000},
	{86001, 0x20000},
	{86019, 0x40000},
	{86046, 0x80000},
	{86068, 0x100000},
	{86086, 0x200000},
	{86106, 0x400000},
	{86129, 0x800000},
	{86152, 0x1000000},
	{86177, 0x2000000},
	{86220, 0x4000000},
	/* 5559 */
	{1153, 0x7, 6, 36312},
	{87773, 0x8},
	{87829, 0x30, 4, 36318},
	{87838, 0x7C0},
	{87849, 0x800},
	{87862, 0x1000},
	{87873, 0x2000},
	{98221, 0x4000},
	{129165, 0x8000},
	{129176, 0x10000},
	{87932, 0x20000},
	{87951, 0x40000},
	{87965, 0x80000},
	{87983, 0x100000},
	{88001, 0x600000},
	/* 5574 */
	{214, 0x3, 3, 36326},
	{88915, 0xC, 4, 36329},
	{88995, 0x30, 4, 36333},
	{89055, 0x40, 2, 36337},
	{83422, 0x200},
	{89072, 0x400},
	{89081, 0x1800},
	/* 5581 */
	{90291, 0x3F, 61, 37348},
	{65469, 0x7FC0000},
	{90302, 0x8000000},
	/* 5584 */
	{90407, 0xFFFF},
	{90422, 0x10000},
	{90441, 0x20000},
	{90455, 0x40000},
	{90474, 0x80000},
	{90488, 0x100000},
	{91132, 0xF0000000},
	/* 5591 */
	{95044, 0x1},
	{90505, 0x2},
	{128421, 0x4},
	{128444, 0x8},
	{128452, 0x3F0},
	{128467, 0xFC00},
	{90584, 0x10000},
	{129187, 0x20000},
	/* 5599 */
	{220, 0x3, 3, 36420},
	{91366, 0x1C, 4, 36423},
	{91443, 0xE0, 4, 36427},
	{91452, 0x100},
	{91472, 0x200},
	{91483, 0x3C00},
	{91505, 0x4000},
	{89055, 0x8000, 2, 36337},
	{91539, 0x60000, 3, 36431},
	{89081, 0x180000},
	/* 5609 */
	{94333, 0x3, 4, 36472},
	{17473, 0x7C, 24, 36476},
	{70573, 0x80},
	{94931, 0x700, 8, 36508},
	{94987, 0x1800, 4, 36516},
	{84030, 0x2000},
	{75024, 0x4000},
	{94997, 0x8000},
	{95009, 0x10000},
	{95022, 0x20000},
	{92601, 0x40000},
	{95035, 0x80000},
	{95262, 0x700000, 8, 36520},
	{95284, 0x3800000, 8, 36520},
	{95308, 0x4000000},
	{95334, 0x8000000},
	{95360, 0x10000000},
	{95428, 0x60000000, 3, 36528},
	/* 5627 */
	{11760, 0x2000000},
	{89081, 0x18000000},
	/* 5629 */
	{96086, 0xFFFF},
	{96098, 0x10000},
	{96014, 0x2000000},
	{89081, 0x18000000},
	{26824, 0xE0000000},
	/* 5634 */
	{26392, 0xFFFF},
	{89081, 0x300000},
	{96014, 0x400000},
	/* 5637 */
	{26464, 0xFFFF},
	{89081, 0x300000},
	{96014, 0x400000},
	/* 5640 */
	{129201, 0xC00},
	{128669, 0x1000},
	{96194, 0x2000},
	{96223, 0x300000},
	{129211, 0xC00000},
	{128690, 0x1000000},
	{96234, 0x2000000},
	{96263, 0x60000000},
	/* 5648 */
	{97077, 0x1},
	{97093, 0x2},
	{129221, 0x4},
	{96311, 0x8},
	{97109, 0x40},
	{97127, 0x80},
	{97145, 0x100},
	{97163, 0x200},
	{97181, 0x400},
	{97199, 0x800},
	{97217, 0x1000},
	{97235, 0x2000},
	{97253, 0x4000},
	{96372, 0x8000},
	{96392, 0x40000},
	{97270, 0x80000},
	{97286, 0x200000},
	{96409, 0x400000},
	{96425, 0x800000},
	{96439, 0x2000000},
	{96453, 0x4000000},
	{96467, 0x8000000},
	{96488, 0x10000000},
	{96513, 0x20000000},
	{96534, 0x40000000},
	{129238, 0x80000000},
	/* 5674 */
	{128711, 0x7F},
	{128723, 0x3F000},
	{11760, 0x2000000},
	{89081, 0x18000000},
	/* 5678 */
	{97968, 0xFFFF},
	{97992, 0xF0000},
	{97979, 0x300000},
	{97370, 0x3FC00000},
	{98000, 0x40000000},
	{10053, 0x80000000},
	/* 5684 */
	{65464, 0xFF},
	{70110, 0xFFF00},
	{114217, 0x3F00000, 64, 37409},
	{114229, 0x3C000000, 16, 37328},
	{89081, 0xC0000000},
	/* 5689 */
	{83963, 0x1},
	{83981, 0x8},
	{1153, 0x70, 7, 36013},
	{83254, 0xFF0000, 256, 36021},
	/* 5693 */
	{90749, 0xFF},
	{90763, 0xFF00},
	{90773, 0xFF0000},
	{90784, 0xFF000000},
	/* 5697 */
	{94333, 0x3, 4, 36472},
	{17473, 0x7C, 31, 36476},
	{70573, 0x80},
	{94931, 0x700, 8, 36508},
	{94987, 0x1800, 4, 36516},
	{84030, 0x2000},
	{75024, 0x4000},
	{94997, 0x8000},
	{95009, 0x10000},
	{95022, 0x20000},
	{92601, 0x40000},
	{95035, 0x80000},
	{95262, 0x700000, 8, 36520},
	{95284, 0x3800000, 8, 36520},
	{95308, 0x4000000},
	{95334, 0x8000000},
	{95360, 0x10000000},
	{95428, 0x60000000, 3, 36528},
	/* 5715 */
	{86014, 0x1},
	{887, 0x1FFE},
	{220, 0x2000},
	{93895, 0x4000},
	{97917, 0x8000},
	{97929, 0xFFF0000},
	{97940, 0x10000000},
	{97951, 0x20000000},
	{97895, 0xC0000000},
	/* 5724 */
	{60167, 0xF},
	{60176, 0xF0},
	{60186, 0x100},
	{60197, 0x200},
	{60202, 0x400},
	{115015, 0x800},
	{60329, 0x1FF000, 257, 0},
	{60337, 0x800000},
	{129556, 0x1000000},
	{129569, 0x2000000},
	{60347, 0x4000000},
	{128740, 0x8000000},
	{60360, 0x10000000},
	{60366, 0xE0000000},
	/* 5738 */
	{60370, 0x1},
	{60374, 0x6},
	{60383, 0x18},
	{60393, 0x20},
	{60398, 0x40},
	{60406, 0x80},
	{60416, 0x100},
	{60427, 0x200},
	{60433, 0x400},
	{60438, 0x800},
	{60444, 0x1000},
	{60455, 0x2000},
	{60460, 0x4000},
	{115034, 0x8000},
	{60216, 0x10000},
	{60480, 0x20000},
	{60488, 0x40000},
	{60500, 0x80000},
	{115047, 0x100000},
	{115061, 0x200000},
	{128751, 0x400000},
	{60508, 0x800000},
	{60519, 0x8000000},
	/* 5761 */
	{60531, 0x1FF, 257, 0},
	{60536, 0x400},
	{60544, 0x800},
	{60557, 0x7000},
	{60576, 0x3F0000},
	{60617, 0x10000000},
	{60629, 0xE0000000},
	/* 5768 */
	{60788, 0xF},
	{60795, 0x70},
	{60817, 0xF00},
	{60826, 0x7000},
	{60835, 0x8000},
	{60848, 0x1F0000},
	{60853, 0xC00000},
	/* 5775 */
	{115112, 0x7},
	{115120, 0x8},
	{115131, 0x10},
	{115144, 0xE0},
	{115160, 0x300},
	{115170, 0xC00},
	{115180, 0xF0000},
	{115192, 0x3000000},
	{115199, 0x4000000},
	{115206, 0x18000000},
	{74682, 0x20000000},
	{115214, 0x40000000},
	{129582, 0x80000000},
	/* 5788 */
	{128764, 0x1},
	{60896, 0x2},
	{60902, 0x4},
	{60931, 0x1F0},
	{60936, 0xF800},
	{60848, 0x7C0000},
	{60951, 0xFE000000},
	/* 5795 */
	{61096, 0xF},
	{61119, 0x10},
	{61142, 0x20},
	{61165, 0x40},
	{61185, 0x80},
	{61205, 0x100},
	{61225, 0x200},
	{61245, 0x400},
	{61265, 0x800},
	{61285, 0x1000},
	{61305, 0x2000},
	{61325, 0x4000},
	{61340, 0x8000},
	{61351, 0x10000},
	{61359, 0x20000},
	{61368, 0x40000},
	{61385, 0x80000},
	{61400, 0x100000},
	{61457, 0x1000000},
	{62395, 0x2000000},
	{128771, 0x4000000},
	{61475, 0x10000000},
	{61484, 0x20000000},
	{61493, 0x40000000},
	{61502, 0x80000000},
	/* 5820 */
	{61513, 0xF},
	{61536, 0x20},
	{61552, 0x80},
	{61575, 0x100},
	{61598, 0x200},
	{61617, 0x1000},
	{61626, 0x2000},
	{61635, 0x4000},
	{61643, 0x8000},
	{115887, 0x10000},
	{115902, 0x20000},
	{115911, 0x40000},
	{115926, 0x80000},
	{61667, 0x100000},
	{115934, 0x200000},
	{61683, 0x400000},
	{61692, 0x800000},
	{61701, 0x1000000},
	{61709, 0x2000000},
	{61717, 0x4000000},
	{61725, 0x10000000},
	{61467, 0x20000000},
	{61743, 0x40000000},
	{61751, 0x80000000},
	/* 5844 */
	{61617, 0x2},
	{61626, 0x4},
	{61359, 0x200000},
	{61692, 0x400000},
	{115902, 0x800000},
	{61709, 0x1000000},
	{61635, 0x2000000},
	{61667, 0x4000000},
	{61683, 0x8000000},
	{61701, 0x20000000},
	{61717, 0x40000000},
	{61743, 0x80000000},
	/* 5856 */
	{62012, 0x1},
	{62022, 0x2},
	{62032, 0x4},
	{62041, 0x8},
	{62050, 0x10},
	{62061, 0x20},
	{62072, 0x40},
	{62082, 0x80},
	{62092, 0x400},
	{62102, 0x800},
	{62119, 0x1000},
	{62127, 0x2000},
	{62140, 0x4000},
	{62237, 0x20000000},
	{62250, 0x40000000},
	{61484, 0x80000000},
	/* 5872 */
	{63066, 0x1},
	{63085, 0x2},
	{63094, 0x10},
	{63109, 0x20},
	{63123, 0x40},
	{63142, 0x80},
	{63161, 0x100},
	{63176, 0x200},
	{63193, 0x400},
	{63215, 0x800},
	{63237, 0x1000},
	{63252, 0x2000},
	{62092, 0x4000},
	{63267, 0x8000},
	{63276, 0x10000},
	{62127, 0x20000},
	{63367, 0x4000000},
	{63380, 0x8000000},
	{63393, 0x30000000},
	{63412, 0x40000000},
	{61475, 0x80000000},
	/* 5893 */
	{65509, 0x7, 8, 37079},
	{65519, 0x38, 8, 37079},
	{65529, 0x1C0, 8, 37079},
	{65539, 0xE00, 8, 37079},
	{114229, 0x7000, 8, 37473},
	{114217, 0x78000, 16, 37095},
	{129627, 0x80000},
	{129642, 0x100000},
	{69776, 0x600000},
	{69789, 0x800000},
	{87667, 0x8000000},
	{220, 0xC0000000, 4, 37111},
	/* 5905 */
	{65464, 0xFF},
	{70110, 0xFFF00},
	{114217, 0x3F00000, 64, 37481},
	{130126, 0x3F00000, 61, 37545},
	{114229, 0x3C000000, 16, 37606},
	{130633, 0x3C000000, 16, 37622},
	{87667, 0x40000000},
	{130650, 0x80000000},
	/* 5913 */
	{65509, 0x7, 8, 37079},
	{65519, 0x38, 8, 37079},
	{65529, 0x1C0, 8, 37079},
	{65539, 0xE00, 8, 37079},
	{72159, 0xF000},
	{72170, 0xF0000},
	{72181, 0x1F00000},
	{220, 0xF0000000, 16, 37195},
	/* 5921 */
	{18619, 0x1FFF},
	{21335, 0x1FFFE000},
	{72285, 0xE0000000, 6, 2828},
	/* 5924 */
	{72296, 0x1FFF},
	{72307, 0x1E000},
	{130662, 0x1FE0000},
	{95908, 0x2000000},
	{72473, 0x4000000},
	{130680, 0x8000000},
	{72319, 0xF0000000},
	/* 5931 */
	{70142, 0x3FFF},
	{70186, 0xFC000},
	{70199, 0x300000, 4, 37230},
	{70213, 0xC00000, 4, 37230},
	{70227, 0x3000000, 3, 37234},
	{70236, 0xC000000, 4, 37344},
	{70247, 0x10000000},
	{70281, 0x20000000},
	{127484, 0x40000000},
	{70266, 0x80000000},
	/* 5941 */
	{70151, 0xFFF},
	{70097, 0x1000},
	{70168, 0xC0000000, 4, 37240},
	/* 5944 */
	{70482, 0x7},
	{70492, 0x38},
	{70513, 0xC0},
	{127642, 0x700},
	{72131, 0x7000, 4, 2824},
	{127663, 0x70000},
	{70534, 0x180000},
	{127687, 0xE00000},
	{127696, 0x3000000},
	{70553, 0xC000000},
	{127716, 0x30000000},
	{127725, 0x40000000},
	{130696, 0x80000000},
	/* 5957 */
	{72581, 0xFFFF},
	{72587, 0x3F0000},
	{72598, 0x3C00000},
	{130706, 0x3C000000},
	/* 5961 */
	{72626, 0x3F},
	{72632, 0x3C0},
	{70322, 0xC00},
	{72722, 0xFF000, 193, 2834},
	{60393, 0x100000},
	{60186, 0x200000},
	{127791, 0x400000},
	{72733, 0x800000},
	{72743, 0x1000000},
	{127812, 0x10000000},
	{60337, 0x20000000},
	/* 5972 */
	{72772, 0x1},
	{72783, 0x3E},
	{72793, 0x40},
	{72806, 0x80},
	{72818, 0xFF00},
	{60329, 0x1FF0000, 257, 0},
	{72833, 0x2000000},
	{72855, 0x4000000},
	{73385, 0x8000000},
	{72880, 0x10000000},
	/* 5982 */
	{72626, 0x3F},
	{72632, 0x3C0},
	{70322, 0xC00},
	{72722, 0xFF000, 193, 2834},
	{60393, 0x100000},
	{60186, 0x200000},
	{127791, 0x400000},
	{72733, 0x800000},
	{73263, 0x3000000},
	{73277, 0x4000000},
	{127812, 0x40000000},
	{60337, 0x80000000},
	/* 5994 */
	{72772, 0x1},
	{72783, 0x3E},
	{72793, 0x40},
	{73293, 0x80},
	{73303, 0x100},
	{73315, 0x200},
	{73327, 0x400},
	{73339, 0x800},
	{73351, 0x1000},
	{60329, 0x3FE000, 257, 0},
	{73357, 0x400000},
	{73368, 0x1000000},
	{73385, 0x8000000},
	{72880, 0x10000000},
	/* 6008 */
	{73422, 0x7F},
	{73397, 0x3F80},
	/* 6010 */
	{72626, 0x3F},
	{72632, 0x3C0},
	{70322, 0xC00},
	{72722, 0xFF000, 193, 2834},
	{60393, 0x100000},
	{60186, 0x200000},
	{127791, 0x400000},
	{72733, 0x800000},
	{73277, 0x1000000},
	{127812, 0x10000000},
	{73448, 0x60000000},
	{60337, 0x80000000},
	/* 6022 */
	{72772, 0x1},
	{72783, 0x3E},
	{72793, 0x40},
	{60329, 0xFF80, 257, 0},
	{73465, 0x30000},
	{73293, 0x40000},
	{60762, 0x7F80000},
	{73385, 0x8000000},
	{72880, 0x10000000},
	/* 6031 */
	{72587, 0x3F},
	{72598, 0x3C0},
	{130706, 0x3C00},
	{72581, 0xFFFF0000},
	/* 6035 */
	{72626, 0x3F},
	{72632, 0x3C0},
	{70322, 0xC00},
	{72722, 0xFF000, 193, 2834},
	{60393, 0x100000},
	{60186, 0x200000},
	{127791, 0x400000},
	{72733, 0x800000},
	{127812, 0x8000000},
	{73482, 0x30000000},
	{60337, 0x40000000},
	/* 6046 */
	{72772, 0x1},
	{72783, 0x3E},
	{72793, 0x40},
	{60329, 0xFF80, 257, 0},
	{60762, 0x1FF0000},
	{73385, 0x8000000},
	{72880, 0x10000000},
	/* 6053 */
	{73510, 0x1},
	{73528, 0x2},
	{73542, 0x4},
	{73561, 0x8},
	{73581, 0x10},
	{73601, 0x20},
	{73623, 0x40},
	{73634, 0x400},
	{73652, 0x800},
	{10536, 0x1000},
	{73684, 0x4000},
	/* 6064 */
	{72626, 0x3F},
	{72632, 0x3C0},
	{70322, 0xC00},
	{72722, 0xFF000, 193, 2834},
	{60393, 0x100000},
	{60186, 0x200000},
	{127791, 0x400000},
	{72733, 0x800000},
	{73737, 0x1000000},
	{127812, 0x2000000},
	{60337, 0x4000000},
	/* 6075 */
	{72772, 0x1},
	{72783, 0x3E},
	{72793, 0x40},
	{73743, 0x80},
	{73753, 0x100},
	{73763, 0x200},
	{73499, 0x400},
	{73773, 0x1800},
	{73788, 0x6000},
	{60762, 0xFF8000},
	{60329, 0x7F000000, 257, 0},
	{73385, 0x80000000},
	/* 6087 */
	{73800, 0x3FF},
	{73813, 0xF000},
	{73823, 0x3F0000},
	{73838, 0x400000},
	{73853, 0x800000},
	{73869, 0x7000000},
	{130706, 0x78000000},
	/* 6094 */
	{74404, 0x7FF},
	{74431, 0xFFE000},
	{74441, 0x1000000},
	{74453, 0x2000000},
	{74471, 0x3C000000},
	/* 6099 */
	{17473, 0x3, 4, 3051},
	{75736, 0xC},
	{72181, 0x1F0},
	{75820, 0x1000},
	{75791, 0x6000, 4, 3055},
	{75806, 0x8000},
	{75856, 0xF0000},
	{75863, 0x7800000},
	{75887, 0x8000000},
	{75902, 0x10000000},
	{75912, 0x20000000},
	{129109, 0x40000000},
	{75932, 0x80000000},
	/* 6112 */
	{17473, 0x1, 2, 3059},
	{72181, 0x1F0},
	{75820, 0x1000},
	{75791, 0x6000, 4, 3055},
	{75806, 0x8000},
	{75887, 0x8000000},
	{75975, 0x20000000},
	{129109, 0x40000000},
	/* 6120 */
	{59887, 0xFFFF},
	/* 6121 */
	{76805, 0x3, 4, 35838},
	{76817, 0xC, 4, 35838},
	{76929, 0x30, 4, 35842},
	{76986, 0x40, 2, 35846},
	{77042, 0x80, 2, 35848},
	{77146, 0x300, 4, 35850},
	{77254, 0xC00, 4, 35854},
	{77363, 0x3000, 4, 35858},
	{77476, 0xC000, 4, 35862},
	{77578, 0x30000, 4, 35866},
	{77724, 0xC0000, 4, 35870},
	{77871, 0x300000, 4, 35874},
	{77971, 0x3000000, 4, 35878},
	{78117, 0x1C000000, 5, 37638},
	{78264, 0xE0000000, 5, 37643},
	/* 6136 */
	{78384, 0x3, 4, 35890},
	{78555, 0x1C, 5, 37648},
	{78727, 0xE0, 5, 37653},
	/* 6139 */
	{79064, 0x1},
	{129126, 0x2},
	{79091, 0x7C},
	{79120, 0x100},
	{79149, 0x200},
	{79180, 0x400},
	{79208, 0x1000},
	{79236, 0x2000},
	{79266, 0x4000},
	/* 6148 */
	{85726, 0x1},
	{85742, 0x2},
	{85758, 0x4},
	{85774, 0x8},
	{85790, 0x10},
	{85806, 0x20},
	{85822, 0x40},
	{85838, 0x80},
	{85854, 0x100},
	{85870, 0x200},
	{85886, 0x400},
	{85902, 0x800},
	{85918, 0x1000},
	{85934, 0x2000},
	{85950, 0x4000},
	{85966, 0x8000},
	{85982, 0x10000},
	{86001, 0x20000},
	{86019, 0x40000},
	{86046, 0x80000},
	{86068, 0x100000},
	{86086, 0x200000},
	{86106, 0x400000},
	{86129, 0x800000},
	{86152, 0x1000000},
	{86177, 0x2000000},
	{86220, 0x4000000},
	{86197, 0x8000000},
	/* 6176 */
	{86826, 0x1},
	{86598, 0x2},
	{86622, 0x4},
	{86642, 0x8},
	{86663, 0x10},
	{86864, 0x40},
	/* 6182 */
	{86893, 0x1},
	{86904, 0x2},
	{130873, 0x4},
	/* 6185 */
	{97671, 0x1},
	{87074, 0x1E},
	{87086, 0xE0},
	{87100, 0x300},
	{87116, 0x1C00},
	{87127, 0x1E000},
	/* 6191 */
	{214, 0x3, 3, 36326},
	{88915, 0xC, 4, 36329},
	{88995, 0x30, 4, 36333},
	{89055, 0x40, 2, 36337},
	{91105, 0x100},
	{83422, 0x200},
	{89072, 0x400},
	/* 6198 */
	{90291, 0x3F, 64, 37658},
	{65469, 0x7FFFC00},
	{90302, 0x8000000},
	/* 6201 */
	{60006, 0xFFFF},
	/* 6202 */
	{90332, 0x1},
	{90346, 0x2},
	{130936, 0x4},
	{90362, 0x8},
	/* 6206 */
	{90505, 0x2},
	{128421, 0x4},
	{128444, 0x8},
	{128452, 0x3F0},
	{128467, 0xFC00},
	{90584, 0x10000},
	{72478, 0x40000},
	{130685, 0x80000},
	/* 6214 */
	{90856, 0x3, 4, 36404},
	{90887, 0x4, 2, 36408},
	{19929, 0x18, 4, 36410},
	{90969, 0x20, 2, 36414},
	{91034, 0xC0, 4, 36416},
	{73368, 0x200},
	{91051, 0x400},
	{91071, 0x800},
	{91091, 0x1000},
	{91105, 0x2000},
	{91116, 0x4000},
	{91132, 0x78000},
	{91152, 0x180000},
	/* 6227 */
	{220, 0x3, 3, 36420},
	{91366, 0x1C, 4, 36423},
	{91443, 0xE0, 4, 36427},
	{91452, 0x100},
	{91472, 0x200},
	{91505, 0x4000},
	{89055, 0x8000, 2, 36337},
	{91539, 0x60000, 4, 36431},
	/* 6235 */
	{93194, 0x3, 4, 36457},
	{93207, 0x4},
	{93218, 0x8},
	{93327, 0x70},
	{93345, 0x380},
	{93363, 0x1C00},
	{93386, 0x3E000},
	{93412, 0x40000},
	{93434, 0x7F80000},
	{93450, 0x8000000},
	{93472, 0x10000000},
	/* 6246 */
	{93611, 0x1},
	{93628, 0x1E},
	{93652, 0x20},
	{93670, 0x3C0},
	{93695, 0x400},
	{93725, 0x800},
	{93740, 0x1000},
	{93755, 0x2000},
	{93790, 0x4000},
	{93826, 0x8000},
	{93916, 0x30000},
	{93940, 0x40000},
	{93976, 0x80000},
	{94012, 0x100000},
	{94038, 0x200000},
	{94062, 0x400000},
	{94082, 0x800000},
	{94103, 0x1000000},
	/* 6264 */
	{74404, 0x7FF},
	{74431, 0xFFE000},
	{94272, 0xF000000},
	/* 6267 */
	{94333, 0x3, 4, 36472},
	{17473, 0x7C, 32, 36476},
	{94931, 0x700, 8, 36508},
	{94987, 0x1800, 4, 36516},
	{84030, 0x2000},
	{75024, 0x4000},
	{94997, 0x8000},
	{95009, 0x10000},
	{95022, 0x20000},
	{92601, 0x40000},
	{95262, 0x700000, 8, 36520},
	{95284, 0x3800000, 8, 36520},
	{95308, 0x4000000},
	{95334, 0x8000000},
	{95360, 0x10000000},
	{95428, 0x60000000, 3, 36528},
	/* 6283 */
	{95897, 0x7FF},
	{95908, 0x800},
	{75736, 0x7000},
	{95514, 0x18000},
	{95528, 0x20000},
	{95920, 0x7C0000},
	{95934, 0xF800000},
	{95948, 0x30000000},
	{130685, 0x40000000},
	{72478, 0x80000000},
	/* 6293 */
	{96086, 0xFFFF},
	{96098, 0x10000},
	{96014, 0x2000000},
	{26824, 0xE0000000},
	/* 6297 */
	{26392, 0xFFFF},
	{96014, 0x400000},
	/* 6299 */
	{26464, 0xFFFF},
	{96014, 0x400000},
	/* 6301 */
	{96181, 0x400},
	{96194, 0x2000},
	{96223, 0x300000},
	{96234, 0x2000000},
	{96263, 0x60000000},
	/* 6306 */
	{96608, 0x1},
	{96642, 0x30},
	{96654, 0xF0000},
	{96667, 0x10000000},
	{96682, 0x20000000},
	{96696, 0xC0000000},
	/* 6312 */
	{128711, 0x7F},
	{128723, 0x3F000},
	{96014, 0x2000000},
	{96890, 0x10000000},
	/* 6316 */
	{97320, 0xF},
	{97332, 0xF0},
	{116048, 0xF00},
	{130955, 0xF000},
	{97360, 0x30000},
	{97370, 0xC0000},
	{10053, 0x100000},
	{10536, 0xFFE00000},
	/* 6324 */
	{214, 0x3, 3, 36326},
	{91105, 0x100},
	/* 6326 */
	{123335, 0x7},
	{123343, 0x38},
	{123351, 0x1C0},
	{123359, 0xE00},
	{123367, 0x7000},
	{123375, 0x38000},
	{123383, 0x1C0000},
	{1153, 0x600000},
	{123391, 0x1800000},
	{123404, 0x2000000},
	{130964, 0x4000000},
	{123417, 0x18000000},
	{123428, 0x20000000},
	{65129, 0x40000000},
	{70080, 0x80000000},
	/* 6341 */
	{65308, 0x3FF},
	{65323, 0x3FF0000},
	{101973, 0x10000000},
	{123327, 0x20000000},
	{61346, 0x40000000},
	{73713, 0x80000000},
	/* 6347 */
	{86014, 0x1},
	{887, 0x1FFE},
	{220, 0x2000},
	{93895, 0x4000},
	{97917, 0x8000},
	{97929, 0xFFF0000},
	{97940, 0x10000000},
	{97951, 0x20000000},
	{97961, 0x40000000},
	{97895, 0x80000000},
	/* 6357 */
	{113412, 0xF},
	{113427, 0x10},
	{130975, 0x20},
	{113451, 0x40},
	{113467, 0x80},
	{130995, 0x100},
	{131021, 0x200},
	{113525, 0x3C00},
	{113541, 0x4000},
	{113562, 0x8000},
	{131038, 0xFFFF0000},
	/* 6368 */
	{113825, 0x3},
	{131052, 0xC},
	{113838, 0x30},
	{113851, 0xC0},
	/* 6372 */
	{131065, 0x3FF},
	{131075, 0xFFC00},
	{51680, 0xF00000},
	{98042, 0xF000000},
	{98053, 0xF0000000},
	/* 6377 */
	{131085, 0x3FF},
	{131095, 0xFFC00},
	{98084, 0xF000000},
	{98095, 0xF0000000},
	/* 6381 */
	{452, 0x7},
	{11403, 0x40000000},
	{10053, 0x80000000},
	/* 6384 */
	{98023, 0x3F},
	{98842, 0x400},
	{98869, 0x800},
	{116693, 0x1000},
	{98896, 0x2000},
	{98922, 0x4000},
	{98948, 0x10000},
	{98975, 0x20000},
	{99001, 0x40000},
	{99027, 0x80000},
	{99055, 0x100000},
	{99081, 0x200000},
	{99107, 0x400000},
	{116720, 0x800000},
	{99133, 0x1000000},
	{99160, 0x2000000},
	{99187, 0x4000000},
	{116746, 0x8000000},
	{116772, 0x10000000},
	{99267, 0x20000000},
	{99296, 0x40000000},
	{99322, 0x80000000},
	/* 6406 */
	{98023, 0x3F},
	{98842, 0x400},
	{98869, 0x800},
	{98896, 0x1000},
	{98922, 0x2000},
	{98948, 0x8000},
	{98975, 0x10000},
	{99055, 0x20000},
	{99081, 0x40000},
	{116693, 0x80000},
	{99001, 0x100000},
	{99160, 0x200000},
	{99322, 0x400000},
	/* 6419 */
	{131105, 0xFF},
	{10536, 0xFFFFFF00},
};

static const char sid_strings[] = {
	'N', 'O', 'P', '\0', /* NOP (0, 1) */
	'S', 'E', 'T', '_', 'B', 'A', 'S', 'E', '\0', /* SET_BASE (4, 8) */
	'C', 'L', 'E', 'A', 'R', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* CLEAR_STATE (13) */
	'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* INDEX_BUFFER_SIZE (25, 38) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DISPATCH_DIRECT (43) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DISPATCH_INDIRECT (59) */
	'A', 'T', 'O', 'M', 'I', 'C', '_', 'M', 'E', 'M', '\0', /* ATOMIC_MEM (77, 84) */
	'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'Q', 'U', 'E', 'R', 'Y', '\0', /* OCCLUSION_QUERY (88, 102) */
	'S', 'E', 'T', '_', 'P', 'R', 'E', 'D', 'I', 'C', 'A', 'T', 'I', 'O', 'N', '\0', /* SET_PREDICATION (104) */
	'C', 'O', 'N', 'D', '_', 'E', 'X', 'E', 'C', '\0', /* COND_EXEC (120) */
	'P', 'R', 'E', 'D', '_', 'E', 'X', 'E', 'C', '\0', /* PRED_EXEC (130) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DRAW_INDIRECT (140) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DRAW_INDEX_INDIRECT (154) */
	'I', 'N', 'D', 'E', 'X', '_', 'B', 'A', 'S', 'E', '\0', /* INDEX_BASE (174) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', '2', '\0', /* DRAW_INDEX_2 (185) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CONTEXT_CONTROL (198, 206) */
	'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* INDEX_TYPE (214, 220) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '\0', /* DRAW_INDIRECT_MULTI (225) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'A', 'U', 'T', 'O', '\0', /* DRAW_INDEX_AUTO (245, 256) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'I', 'M', 'M', 'D', '\0', /* DRAW_INDEX_IMMD (261) */
	'N', 'U', 'M', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', 'S', '\0', /* NUM_INSTANCES (277) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'M', 'U', 'L', 'T', 'I', '_', 'A', 'U', 'T', 'O', '\0', /* DRAW_INDEX_MULTI_AUTO (291) */
	'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', '\0', /* INDIRECT_BUFFER_SI (313) */
	'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'C', 'O', 'N', 'S', 'T', '\0', /* INDIRECT_BUFFER_CONST (332) */
	'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'U', 'P', 'D', 'A', 'T', 'E', '\0', /* STRMOUT_BUFFER_UPDATE (354) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* DRAW_INDEX_OFFSET_2 (376) */
	'W', 'R', 'I', 'T', 'E', '_', 'D', 'A', 'T', 'A', '\0', /* WRITE_DATA (396, 402) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '\0', /* DRAW_INDEX_INDIRECT_MULTI (407) */
	'M', 'E', 'M', '_', 'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '\0', /* MEM_SEMAPHORE (433) */
	'M', 'P', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* MPEG_INDEX (447, 452, 456) */
	'W', 'A', 'I', 'T', '_', 'R', 'E', 'G', '_', 'M', 'E', 'M', '\0', /* WAIT_REG_MEM (458) */
	'M', 'E', 'M', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* MEM_WRITE (471) */
	'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'C', 'I', 'K', '\0', /* INDIRECT_BUFFER_CIK (481) */
	'C', 'O', 'P', 'Y', '_', 'D', 'A', 'T', 'A', '\0', /* COPY_DATA (501) */
	'P', 'F', 'P', '_', 'S', 'Y', 'N', 'C', '_', 'M', 'E', '\0', /* PFP_SYNC_ME (511, 520) */
	'S', 'U', 'R', 'F', 'A', 'C', 'E', '_', 'S', 'Y', 'N', 'C', '\0', /* SURFACE_SYNC (523) */
	'M', 'E', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'L', 'I', 'Z', 'E', '\0', /* ME_INITIALIZE (536) */
	'C', 'O', 'N', 'D', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* COND_WRITE (550) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* EVENT_WRITE (561) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '_', 'E', 'O', 'P', '\0', /* EVENT_WRITE_EOP (573) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '_', 'E', 'O', 'S', '\0', /* EVENT_WRITE_EOS (589) */
	'R', 'E', 'L', 'E', 'A', 'S', 'E', '_', 'M', 'E', 'M', '\0', /* RELEASE_MEM (605) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '_', 'R', 'M', 'W', '\0', /* CONTEXT_REG_RMW (617) */
	'O', 'N', 'E', '_', 'R', 'E', 'G', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* ONE_REG_WRITE (633) */
	'A', 'C', 'Q', 'U', 'I', 'R', 'E', '_', 'M', 'E', 'M', '\0', /* ACQUIRE_MEM (647) */
	'R', 'E', 'W', 'I', 'N', 'D', '\0', /* REWIND (659) */
	'L', 'O', 'A', 'D', '_', 'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '\0', /* LOAD_UCONFIG_REG (666) */
	'L', 'O', 'A', 'D', '_', 'S', 'H', '_', 'R', 'E', 'G', '\0', /* LOAD_SH_REG (683) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '\0', /* LOAD_CONTEXT_REG (695) */
	'L', 'O', 'A', 'D', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* LOAD_SH_REG_INDEX (712) */
	'S', 'E', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '\0', /* SET_CONFIG_REG (730) */
	'S', 'E', 'T', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '\0', /* SET_CONTEXT_REG (745) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '\0', /* SET_SH_REG (761) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* SET_SH_REG_OFFSET (772, 783) */
	'S', 'E', 'T', '_', 'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '\0', /* SET_UCONFIG_REG (790) */
	'S', 'E', 'T', '_', 'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SET_UCONFIG_REG_INDEX (806) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'S', 'T', '_', 'R', 'A', 'M', '\0', /* LOAD_CONST_RAM (828) */
	'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'N', 'S', 'T', '_', 'R', 'A', 'M', '\0', /* WRITE_CONST_RAM (843) */
	'D', 'U', 'M', 'P', '_', 'C', 'O', 'N', 'S', 'T', '_', 'R', 'A', 'M', '\0', /* DUMP_CONST_RAM (859) */
	'I', 'N', 'C', 'R', 'E', 'M', 'E', 'N', 'T', '_', 'C', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* INCREMENT_CE_COUNTER (874, 887) */
	'I', 'N', 'C', 'R', 'E', 'M', 'E', 'N', 'T', '_', 'D', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* INCREMENT_DE_COUNTER (895) */
	'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'C', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* WAIT_ON_CE_COUNTER (916) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SET_SH_REG_INDEX (935) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* LOAD_CONTEXT_REG_INDEX (952) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'A', 'S', 'K', '_', 'S', 'T', 'A', 'T', 'E', '_', 'I', 'N', 'I', 'T', '\0', /* DISPATCH_TASK_STATE_INIT (975) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'M', 'E', 'S', 'H', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '\0', /* DISPATCH_MESH_INDIRECT_MULTI (1000) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'A', 'S', 'K', 'M', 'E', 'S', 'H', '_', 'G', 'F', 'X', '\0', /* DISPATCH_TASKMESH_GFX (1029) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'A', 'S', 'K', 'M', 'E', 'S', 'H', '_', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'A', 'C', 'E', '\0', /* DISPATCH_TASKMESH_DIRECT_ACE (1051, 1077) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'A', 'S', 'K', 'M', 'E', 'S', 'H', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '_', 'A', 'C', 'E', '\0', /* DISPATCH_TASKMESH_INDIRECT_MULTI_ACE (1080) */
	'I', 'T', '_', 'O', 'P', 'C', 'O', 'D', 'E', '_', 'C', '\0', /* IT_OPCODE_C (1117) */
	'C', 'P', '_', 'D', 'M', 'A', '\0', /* CP_DMA (1129) */
	'D', 'M', 'A', '_', 'D', 'A', 'T', 'A', '\0', /* DMA_DATA (1136) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* SQ_WAVE_MODE (1145, 1153, 1155) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* SQ_WAVE_STATUS (1158, 1166) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'R', 'A', 'P', 'S', 'T', 'S', '\0', /* SQ_WAVE_TRAPSTS (1173) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '_', 'L', 'E', 'G', 'A', 'C', 'Y', '\0', /* SQ_WAVE_HW_ID_LEGACY (1189) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'G', 'P', 'R', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* SQ_WAVE_GPR_ALLOC (1210) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'L', 'D', 'S', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* SQ_WAVE_LDS_ALLOC (1228) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'S', 'T', 'S', '\0', /* SQ_WAVE_IB_STS (1246) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'P', 'C', '_', 'L', 'O', '\0', /* SQ_WAVE_PC_LO (1261) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'P', 'C', '_', 'H', 'I', '\0', /* SQ_WAVE_PC_HI (1275, 1283) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'N', 'S', 'T', '_', 'D', 'W', '0', '\0', /* SQ_WAVE_INST_DW0 (1289) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'D', 'B', 'G', '1', '\0', /* SQ_WAVE_IB_DBG1 (1306) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'U', 'S', 'H', '_', 'I', 'B', '\0', /* SQ_WAVE_FLUSH_IB (1322) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '1', '\0', /* SQ_WAVE_HW_ID1 (1339) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '2', '\0', /* SQ_WAVE_HW_ID2 (1354) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'P', 'O', 'P', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'R', '\0', /* SQ_WAVE_POPS_PACKER (1369) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'C', 'H', 'E', 'D', '_', 'M', 'O', 'D', 'E', '\0', /* SQ_WAVE_SCHED_MODE (1389) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'V', 'G', 'P', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* SQ_WAVE_VGPR_OFFSET (1408) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'S', 'T', 'S', '2', '\0', /* SQ_WAVE_IB_STS2 (1428) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '0', '\0', /* SQ_WAVE_TTMP0 (1444) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '\0', /* SQ_WAVE_TTMP1 (1458) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '2', '\0', /* SQ_WAVE_TTMP2 (1472) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '3', '\0', /* SQ_WAVE_TTMP3 (1486) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '4', '\0', /* SQ_WAVE_TTMP4 (1500) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '5', '\0', /* SQ_WAVE_TTMP5 (1514) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '6', '\0', /* SQ_WAVE_TTMP6 (1528) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '7', '\0', /* SQ_WAVE_TTMP7 (1542) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '8', '\0', /* SQ_WAVE_TTMP8 (1556) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '9', '\0', /* SQ_WAVE_TTMP9 (1570) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '0', '\0', /* SQ_WAVE_TTMP10 (1584) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '1', '\0', /* SQ_WAVE_TTMP11 (1599) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '2', '\0', /* SQ_WAVE_TTMP12 (1614) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '3', '\0', /* SQ_WAVE_TTMP13 (1629) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '4', '\0', /* SQ_WAVE_TTMP14 (1644) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '5', '\0', /* SQ_WAVE_TTMP15 (1659) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'M', '0', '\0', /* SQ_WAVE_M0 (1674) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'E', 'X', 'E', 'C', '_', 'L', 'O', '\0', /* SQ_WAVE_EXEC_LO (1685) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'E', 'X', 'E', 'C', '_', 'H', 'I', '\0', /* SQ_WAVE_EXEC_HI (1701) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'A', 'T', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'L', 'O', '\0', /* SQ_WAVE_FLAT_SCRATCH_LO (1717) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'A', 'T', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'H', 'I', '\0', /* SQ_WAVE_FLAT_SCRATCH_HI (1741) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'A', 'T', '_', 'X', 'N', 'A', 'C', 'K', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_WAVE_FLAT_XNACK_MASK (1765) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '2', '\0', /* GRBM_STATUS2 (1789) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* GRBM_STATUS (1802) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '0', '\0', /* GRBM_STATUS_SE0 (1814) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '1', '\0', /* GRBM_STATUS_SE1 (1830) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '3', '\0', /* GRBM_STATUS3 (1846) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '2', '\0', /* GRBM_STATUS_SE2 (1859) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '3', '\0', /* GRBM_STATUS_SE3 (1875) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_CPC_STATUS (1891) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CPC_BUSY_STAT (1905) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '1', '\0', /* CP_CPC_STALLED_STAT1 (1922) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_CPF_STATUS (1943) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CPF_BUSY_STAT (1957) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '1', '\0', /* CP_CPF_STALLED_STAT1 (1974) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '2', '\0', /* CP_CPC_BUSY_STAT2 (1995) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'G', 'R', 'B', 'M', '_', 'F', 'R', 'E', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_CPC_GRBM_FREE_COUNT (2013, 2025, 2030) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* CP_CPC_SCRATCH_INDEX (2036, 2043) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'D', 'A', 'T', 'A', '\0', /* CP_CPC_SCRATCH_DATA (2057) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'G', 'R', 'B', 'M', '_', 'F', 'R', 'E', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_CPF_GRBM_FREE_COUNT (2077) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '2', '\0', /* CP_CPF_BUSY_STAT2 (2100) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'H', 'A', 'L', 'T', '_', 'H', 'Y', 'S', 'T', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_CPC_HALT_HYST_COUNT (2118) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '0', '_', 'B', 'A', 'S', 'E', '\0', /* SQ_THREAD_TRACE_BUF0_BASE (2141) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '0', '_', 'S', 'I', 'Z', 'E', '\0', /* SQ_THREAD_TRACE_BUF0_SIZE (2167) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '1', '_', 'B', 'A', 'S', 'E', '\0', /* SQ_THREAD_TRACE_BUF1_BASE (2193) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '1', '_', 'S', 'I', 'Z', 'E', '\0', /* SQ_THREAD_TRACE_BUF1_SIZE (2219) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'W', 'P', 'T', 'R', '\0', /* SQ_THREAD_TRACE_WPTR (2245, 2261) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_THREAD_TRACE_MASK (2266) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'T', 'O', 'K', 'E', 'N', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_THREAD_TRACE_TOKEN_MASK (2287, 2303) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_THREAD_TRACE_CTRL (2314) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* SQ_THREAD_TRACE_STATUS (2335) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'D', 'R', 'O', 'P', 'P', 'E', 'D', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_DROPPED_CNTR (2358) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'G', 'F', 'X', '_', 'D', 'R', 'A', 'W', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_GFX_DRAW_CNTR (2387) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'G', 'F', 'X', '_', 'M', 'A', 'R', 'K', 'E', 'R', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_GFX_MARKER_CNTR (2417) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'H', 'P', '3', 'D', '_', 'D', 'R', 'A', 'W', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_HP3D_DRAW_CNTR (2449) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'H', 'P', '3', 'D', '_', 'M', 'A', 'R', 'K', 'E', 'R', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_HP3D_MARKER_CNTR (2480) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', '0', '\0', /* SQ_EXP_0 (2513) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '0', '\0', /* SQ_BUF_RSRC_WORD0 (2522) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '1', '\0', /* SQ_BUF_RSRC_WORD1 (2540) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '2', '\0', /* SQ_BUF_RSRC_WORD2 (2558) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '3', '\0', /* SQ_BUF_RSRC_WORD3 (2576) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '0', '\0', /* SQ_IMG_SAMP_WORD0 (2594) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '1', '\0', /* SQ_IMG_SAMP_WORD1 (2612) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '2', '\0', /* SQ_IMG_SAMP_WORD2 (2630) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '3', '\0', /* SQ_IMG_SAMP_WORD3 (2648) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_CONFIG_CNTL (2666) */
	'G', 'B', '_', 'A', 'D', 'D', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* GB_ADDR_CONFIG (2682) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '0', '\0', /* GB_TILE_MODE0 (2697) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '\0', /* GB_TILE_MODE1 (2711) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '\0', /* GB_TILE_MODE2 (2725) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '\0', /* GB_TILE_MODE3 (2739) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '4', '\0', /* GB_TILE_MODE4 (2753) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '5', '\0', /* GB_TILE_MODE5 (2767) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '6', '\0', /* GB_TILE_MODE6 (2781) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '7', '\0', /* GB_TILE_MODE7 (2795) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '8', '\0', /* GB_TILE_MODE8 (2809) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '9', '\0', /* GB_TILE_MODE9 (2823) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '0', '\0', /* GB_TILE_MODE10 (2837) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '1', '\0', /* GB_TILE_MODE11 (2852) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '2', '\0', /* GB_TILE_MODE12 (2867) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '3', '\0', /* GB_TILE_MODE13 (2882) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '4', '\0', /* GB_TILE_MODE14 (2897) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '5', '\0', /* GB_TILE_MODE15 (2912) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '6', '\0', /* GB_TILE_MODE16 (2927) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '7', '\0', /* GB_TILE_MODE17 (2942) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '8', '\0', /* GB_TILE_MODE18 (2957) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '9', '\0', /* GB_TILE_MODE19 (2972) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '0', '\0', /* GB_TILE_MODE20 (2987) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '1', '\0', /* GB_TILE_MODE21 (3002) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '2', '\0', /* GB_TILE_MODE22 (3017) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '3', '\0', /* GB_TILE_MODE23 (3032) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '4', '\0', /* GB_TILE_MODE24 (3047) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '5', '\0', /* GB_TILE_MODE25 (3062) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '6', '\0', /* GB_TILE_MODE26 (3077) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '7', '\0', /* GB_TILE_MODE27 (3092) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '8', '\0', /* GB_TILE_MODE28 (3107) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '9', '\0', /* GB_TILE_MODE29 (3122) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '0', '\0', /* GB_TILE_MODE30 (3137) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '1', '\0', /* GB_TILE_MODE31 (3152) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '0', '\0', /* GB_MACROTILE_MODE0 (3167) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '\0', /* GB_MACROTILE_MODE1 (3186) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '\0', /* GB_MACROTILE_MODE2 (3205) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '\0', /* GB_MACROTILE_MODE3 (3224) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '4', '\0', /* GB_MACROTILE_MODE4 (3243) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '5', '\0', /* GB_MACROTILE_MODE5 (3262) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '6', '\0', /* GB_MACROTILE_MODE6 (3281) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '7', '\0', /* GB_MACROTILE_MODE7 (3300) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '8', '\0', /* GB_MACROTILE_MODE8 (3319) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '9', '\0', /* GB_MACROTILE_MODE9 (3338) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '0', '\0', /* GB_MACROTILE_MODE10 (3357) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '1', '\0', /* GB_MACROTILE_MODE11 (3377) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '2', '\0', /* GB_MACROTILE_MODE12 (3397) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '3', '\0', /* GB_MACROTILE_MODE13 (3417) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '4', '\0', /* GB_MACROTILE_MODE14 (3437) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '5', '\0', /* GB_MACROTILE_MODE15 (3457) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '0', '\0', /* SQ_IMG_RSRC_WORD0 (3477) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '1', '\0', /* SQ_IMG_RSRC_WORD1 (3495) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '2', '\0', /* SQ_IMG_RSRC_WORD2 (3513) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '3', '\0', /* SQ_IMG_RSRC_WORD3 (3531) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '4', '\0', /* SQ_IMG_RSRC_WORD4 (3549) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '5', '\0', /* SQ_IMG_RSRC_WORD5 (3567) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '6', '\0', /* SQ_IMG_RSRC_WORD6 (3585) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '7', '\0', /* SQ_IMG_RSRC_WORD7 (3603) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_PS (3621) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_PS (3645) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_PS (3670) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_LO_PS (3694) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_HI_PS (3715) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_PS (3736) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_PS (3760) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_PS_0 (3784) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_PS_1 (3810) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_PS_2 (3836) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_PS_3 (3862) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_PS_4 (3888) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_PS_5 (3914) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_PS_6 (3940) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_PS_7 (3966) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_PS_8 (3992) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_PS_9 (4018) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_PS_10 (4044) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_PS_11 (4071) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_PS_12 (4098) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_PS_13 (4125) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_PS_14 (4152) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_PS_15 (4179) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_PS_16 (4206) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_PS_17 (4233) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_PS_18 (4260) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_PS_19 (4287) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_PS_20 (4314) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_PS_21 (4341) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_PS_22 (4368) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_PS_23 (4395) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_PS_24 (4422) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_PS_25 (4449) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_PS_26 (4476) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_PS_27 (4503) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_PS_28 (4530) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_PS_29 (4557) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_PS_30 (4584) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_PS_31 (4611) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'P', 'S', '\0', /* SPI_SHADER_REQ_CTRL_PS (4638) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'P', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_PS (4661) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_PS_0 (4694) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_PS_1 (4721) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_PS_2 (4748) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_PS_3 (4775) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_VS (4802) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_VS (4826) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_VS (4851) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'L', 'A', 'T', 'E', '_', 'A', 'L', 'L', 'O', 'C', '_', 'V', 'S', '\0', /* SPI_SHADER_LATE_ALLOC_VS (4875) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_LO_VS (4900) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_HI_VS (4921) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_VS (4942) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_VS (4966) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_VS_0 (4990) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_VS_1 (5016) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_VS_2 (5042) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_VS_3 (5068) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_VS_4 (5094) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_VS_5 (5120) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_VS_6 (5146) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_VS_7 (5172) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_VS_8 (5198) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_VS_9 (5224) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_VS_10 (5250) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_VS_11 (5277) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_VS_12 (5304) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_VS_13 (5331) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_VS_14 (5358) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_VS_15 (5385) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_VS_16 (5412) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_VS_17 (5439) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_VS_18 (5466) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_VS_19 (5493) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_VS_20 (5520) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_VS_21 (5547) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_VS_22 (5574) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_VS_23 (5601) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_VS_24 (5628) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_VS_25 (5655) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_VS_26 (5682) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_VS_27 (5709) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_VS_28 (5736) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_VS_29 (5763) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_VS_30 (5790) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_VS_31 (5817) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'V', 'S', '\0', /* SPI_SHADER_REQ_CTRL_VS (5844) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'V', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_VS (5867) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_VS_0 (5900) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_VS_1 (5927) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_VS_2 (5954) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_VS_3 (5981) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'G', 'S', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_GS_VS (6008) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'E', 'S', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_ES_VS (6035) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS_VS (6062) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_GS (6089) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_GS (6114) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_LO_GS (6138) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_HI_GS (6170) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'E', 'S', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_LO_ES_GS (6202) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'E', 'S', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_HI_ES_GS (6226) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_GS (6250) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_LO_GS (6274) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_HI_GS (6295) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_GS (6316) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_GS (6340) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_GS_0 (6364) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_GS_1 (6390) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_GS_2 (6416) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_GS_3 (6442) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_GS_4 (6468) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_GS_5 (6494) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_GS_6 (6520) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_GS_7 (6546) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_GS_8 (6572) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_GS_9 (6598) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_GS_10 (6624) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_GS_11 (6651) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_GS_12 (6678) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_GS_13 (6705) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_GS_14 (6732) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_GS_15 (6759) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_GS_16 (6786) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_GS_17 (6813) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_GS_18 (6840) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_GS_19 (6867) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_GS_20 (6894) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_GS_21 (6921) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_GS_22 (6948) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_GS_23 (6975) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_GS_24 (7002) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_GS_25 (7029) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_GS_26 (7056) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_GS_27 (7083) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_GS_28 (7110) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_GS_29 (7137) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_GS_30 (7164) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_GS_31 (7191) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'E', 'S', 'G', 'S', '\0', /* SPI_SHADER_REQ_CTRL_ESGS (7218) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'E', 'S', 'G', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_ESGS (7243) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_0 (7278) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_1 (7307) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_2 (7336) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_3 (7365) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'E', 'S', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_ES_GS (7394) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_ES (7421) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_LO_ES (7445) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_HI_ES (7466) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_ES (7487) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_ES (7511) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_ES_0 (7535) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_ES_1 (7561) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_ES_2 (7587) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_ES_3 (7613) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_ES_4 (7639) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_ES_5 (7665) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_ES_6 (7691) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_ES_7 (7717) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_ES_8 (7743) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_ES_9 (7769) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_ES_10 (7795) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_ES_11 (7822) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_ES_12 (7849) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_ES_13 (7876) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_ES_14 (7903) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_ES_15 (7930) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS_ES (7957) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_HS (7984) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_HS (8009) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_LO_HS (8033) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_HI_HS (8065) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'L', 'S', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_LO_LS_HS (8097) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'L', 'S', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_HI_LS_HS (8121) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_HS (8145) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_LO_HS (8169) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_HI_HS (8190) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_HS (8211) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_HS (8235) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_HS_0 (8259) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_HS_1 (8285) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_HS_2 (8311) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_HS_3 (8337) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_HS_4 (8363) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_HS_5 (8389) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_HS_6 (8415) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_HS_7 (8441) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_HS_8 (8467) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_HS_9 (8493) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_HS_10 (8519) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_HS_11 (8546) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_HS_12 (8573) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_HS_13 (8600) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_HS_14 (8627) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_HS_15 (8654) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_HS_16 (8681) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_HS_17 (8708) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_HS_18 (8735) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_HS_19 (8762) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_HS_20 (8789) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_HS_21 (8816) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_HS_22 (8843) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_HS_23 (8870) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_HS_24 (8897) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_HS_25 (8924) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_HS_26 (8951) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_HS_27 (8978) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_HS_28 (9005) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_HS_29 (9032) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_HS_30 (9059) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_HS_31 (9086) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'L', 'S', 'H', 'S', '\0', /* SPI_SHADER_REQ_CTRL_LSHS (9113) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'L', 'S', 'H', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_LSHS (9138) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_0 (9173) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_1 (9202) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_2 (9231) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_3 (9260) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS_HS (9289) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_LS (9316) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_LO_LS (9340) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_HI_LS (9361) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_LS (9382) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS (9406) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_LS_0 (9430) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_LS_1 (9456) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_LS_2 (9482) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_LS_3 (9508) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_LS_4 (9534) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_LS_5 (9560) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_LS_6 (9586) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_LS_7 (9612) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_LS_8 (9638) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_LS_9 (9664) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_LS_10 (9690) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_LS_11 (9717) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_LS_12 (9744) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_LS_13 (9771) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_LS_14 (9798) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_LS_15 (9825) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* COMPUTE_DISPATCH_INITIATOR (9852) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'M', '_', 'X', '\0', /* COMPUTE_DIM_X (9879) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'M', '_', 'Y', '\0', /* COMPUTE_DIM_Y (9893) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'M', '_', 'Z', '\0', /* COMPUTE_DIM_Z (9907) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'X', '\0', /* COMPUTE_START_X (9921, 9929) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'Y', '\0', /* COMPUTE_START_Y (9937, 9945) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'Z', '\0', /* COMPUTE_START_Z (9953) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'X', '\0', /* COMPUTE_NUM_THREAD_X (9969) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'Y', '\0', /* COMPUTE_NUM_THREAD_Y (9990) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'Z', '\0', /* COMPUTE_NUM_THREAD_Z (10011) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'I', 'P', 'E', 'L', 'I', 'N', 'E', 'S', 'T', 'A', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COMPUTE_PIPELINESTAT_ENABLE (10032, 10040, 10053) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COMPUTE_PERFCOUNT_ENABLE (10060, 10068) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'L', 'O', '\0', /* COMPUTE_PGM_LO (10085) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'H', 'I', '\0', /* COMPUTE_PGM_HI (10100) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'P', 'K', 'T', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* COMPUTE_DISPATCH_PKT_ADDR_LO (10115, 10136) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'P', 'K', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* COMPUTE_DISPATCH_PKT_ADDR_HI (10144, 10165) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* COMPUTE_DISPATCH_SCRATCH_BASE_LO (10173) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* COMPUTE_DISPATCH_SCRATCH_BASE_HI (10206, 10231) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '\0', /* COMPUTE_PGM_RSRC1 (10239, 10252) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '\0', /* COMPUTE_PGM_RSRC2 (10257, 10270) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'V', 'M', 'I', 'D', '\0', /* COMPUTE_VMID (10275, 10283, 10285) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'L', 'I', 'M', 'I', 'T', 'S', '\0', /* COMPUTE_RESOURCE_LIMITS (10288) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '0', '\0', /* COMPUTE_DESTINATION_EN_SE0 (10312) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '1', '\0', /* COMPUTE_DESTINATION_EN_SE1 (10339) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'M', 'P', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* COMPUTE_TMPRING_SIZE (10366) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '2', '\0', /* COMPUTE_DESTINATION_EN_SE2 (10387) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '3', '\0', /* COMPUTE_DESTINATION_EN_SE3 (10414) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'X', '\0', /* COMPUTE_RESTART_X (10441) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'Y', '\0', /* COMPUTE_RESTART_Y (10459) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'Z', '\0', /* COMPUTE_RESTART_Z (10477) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COMPUTE_THREAD_TRACE_ENABLE (10495, 10503) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'M', 'I', 'S', 'C', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '\0', /* COMPUTE_MISC_RESERVED (10523, 10536) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'D', '\0', /* COMPUTE_DISPATCH_ID (10545) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'H', 'R', 'E', 'A', 'D', 'G', 'R', 'O', 'U', 'P', '_', 'I', 'D', '\0', /* COMPUTE_THREADGROUP_ID (10565) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '\0', /* COMPUTE_REQ_CTRL (10588) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '0', '\0', /* COMPUTE_USER_ACCUM_0 (10605) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '1', '\0', /* COMPUTE_USER_ACCUM_1 (10626) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '2', '\0', /* COMPUTE_USER_ACCUM_2 (10647) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '3', '\0', /* COMPUTE_USER_ACCUM_3 (10668) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '\0', /* COMPUTE_PGM_RSRC3 (10689) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'D', 'I', 'D', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* COMPUTE_DDID_INDEX (10707) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'H', 'K', 'S', 'U', 'M', '\0', /* COMPUTE_SHADER_CHKSUM (10726) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'L', 'A', 'U', 'N', 'C', 'H', '\0', /* COMPUTE_RELAUNCH (10748) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'W', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* COMPUTE_WAVE_RESTORE_ADDR_LO (10765) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'W', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* COMPUTE_WAVE_RESTORE_ADDR_HI (10794) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'L', 'A', 'U', 'N', 'C', 'H', '2', '\0', /* COMPUTE_RELAUNCH2 (10823) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '0', '\0', /* COMPUTE_USER_DATA_0 (10841) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '\0', /* COMPUTE_USER_DATA_1 (10861) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '2', '\0', /* COMPUTE_USER_DATA_2 (10881) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '3', '\0', /* COMPUTE_USER_DATA_3 (10901) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '4', '\0', /* COMPUTE_USER_DATA_4 (10921) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '5', '\0', /* COMPUTE_USER_DATA_5 (10941) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '6', '\0', /* COMPUTE_USER_DATA_6 (10961) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '7', '\0', /* COMPUTE_USER_DATA_7 (10981) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '8', '\0', /* COMPUTE_USER_DATA_8 (11001) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '9', '\0', /* COMPUTE_USER_DATA_9 (11021) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '0', '\0', /* COMPUTE_USER_DATA_10 (11041) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '1', '\0', /* COMPUTE_USER_DATA_11 (11062) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '2', '\0', /* COMPUTE_USER_DATA_12 (11083) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '3', '\0', /* COMPUTE_USER_DATA_13 (11104) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '4', '\0', /* COMPUTE_USER_DATA_14 (11125) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '5', '\0', /* COMPUTE_USER_DATA_15 (11146) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'U', 'N', 'N', 'E', 'L', '\0', /* COMPUTE_DISPATCH_TUNNEL (11167) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'E', 'N', 'D', '\0', /* COMPUTE_DISPATCH_END (11191) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'O', 'W', 'H', 'E', 'R', 'E', '\0', /* COMPUTE_NOWHERE (11212, 11220) */
	'D', 'B', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_RENDER_CONTROL (11228) */
	'D', 'B', '_', 'C', 'O', 'U', 'N', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_COUNT_CONTROL (11246) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'V', 'I', 'E', 'W', '\0', /* DB_DEPTH_VIEW (11263) */
	'D', 'B', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* DB_RENDER_OVERRIDE (11277) */
	'D', 'B', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '2', '\0', /* DB_RENDER_OVERRIDE2 (11296) */
	'D', 'B', '_', 'H', 'T', 'I', 'L', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '\0', /* DB_HTILE_DATA_BASE (11316) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'S', 'I', 'Z', 'E', '_', 'X', 'Y', '\0', /* DB_DEPTH_SIZE_XY (11335) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'M', 'I', 'N', '\0', /* DB_DEPTH_BOUNDS_MIN (11352, 11368) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'M', 'A', 'X', '\0', /* DB_DEPTH_BOUNDS_MAX (11372, 11388) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'L', 'E', 'A', 'R', '\0', /* DB_STENCIL_CLEAR (11392, 11403) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'L', 'E', 'A', 'R', '\0', /* DB_DEPTH_CLEAR (11409) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'T', 'L', '\0', /* PA_SC_SCREEN_SCISSOR_TL (11424) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'B', 'R', '\0', /* PA_SC_SCREEN_SCISSOR_BR (11448) */
	'D', 'B', '_', 'D', 'F', 'S', 'M', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_DFSM_CONTROL (11472) */
	'D', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '_', '2', '\0', /* DB_RESERVED_REG_2 (11488) */
	'D', 'B', '_', 'Z', '_', 'I', 'N', 'F', 'O', '\0', /* DB_Z_INFO (11506) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'F', 'O', '\0', /* DB_STENCIL_INFO (11516) */
	'D', 'B', '_', 'Z', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '\0', /* DB_Z_READ_BASE (11532) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '\0', /* DB_STENCIL_READ_BASE (11547) */
	'D', 'B', '_', 'Z', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* DB_Z_WRITE_BASE (11568) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* DB_STENCIL_WRITE_BASE (11584) */
	'D', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '_', '1', '\0', /* DB_RESERVED_REG_1 (11606) */
	'D', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '_', '3', '\0', /* DB_RESERVED_REG_3 (11624) */
	'D', 'B', '_', 'Z', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_Z_READ_BASE_HI (11642) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_STENCIL_READ_BASE_HI (11660) */
	'D', 'B', '_', 'Z', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_Z_WRITE_BASE_HI (11684) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_STENCIL_WRITE_BASE_HI (11703) */
	'D', 'B', '_', 'H', 'T', 'I', 'L', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_HTILE_DATA_BASE_HI (11728) */
	'D', 'B', '_', 'R', 'M', 'I', '_', 'L', '2', '_', 'C', 'A', 'C', 'H', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_RMI_L2_CACHE_CONTROL (11750, 11760) */
	'T', 'A', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* TA_BC_BASE_ADDR (11774, 11780, 11785) */
	'T', 'A', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* TA_BC_BASE_ADDR_HI (11790) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '0', '\0', /* COHER_DEST_BASE_HI_0 (11809) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '1', '\0', /* COHER_DEST_BASE_HI_1 (11830) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '2', '\0', /* COHER_DEST_BASE_HI_2 (11851) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '3', '\0', /* COHER_DEST_BASE_HI_3 (11872) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '2', '\0', /* COHER_DEST_BASE_2 (11893) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '3', '\0', /* COHER_DEST_BASE_3 (11911) */
	'P', 'A', '_', 'S', 'C', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SC_WINDOW_OFFSET (11929, 11940) */
	'P', 'A', '_', 'S', 'C', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'T', 'L', '\0', /* PA_SC_WINDOW_SCISSOR_TL (11949) */
	'P', 'A', '_', 'S', 'C', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'B', 'R', '\0', /* PA_SC_WINDOW_SCISSOR_BR (11973) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', 'R', 'U', 'L', 'E', '\0', /* PA_SC_CLIPRECT_RULE (11997) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '0', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_0_TL (12017) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '0', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_0_BR (12037) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '1', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_1_TL (12057) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '1', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_1_BR (12077) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '2', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_2_TL (12097) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '2', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_2_BR (12117) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '3', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_3_TL (12137) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '3', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_3_BR (12157) */
	'P', 'A', '_', 'S', 'C', '_', 'E', 'D', 'G', 'E', 'R', 'U', 'L', 'E', '\0', /* PA_SC_EDGERULE (12177) */
	'P', 'A', '_', 'S', 'U', '_', 'H', 'A', 'R', 'D', 'W', 'A', 'R', 'E', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SU_HARDWARE_SCREEN_OFFSET (12192) */
	'C', 'B', '_', 'T', 'A', 'R', 'G', 'E', 'T', '_', 'M', 'A', 'S', 'K', '\0', /* CB_TARGET_MASK (12221) */
	'C', 'B', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'M', 'A', 'S', 'K', '\0', /* CB_SHADER_MASK (12236) */
	'P', 'A', '_', 'S', 'C', '_', 'G', 'E', 'N', 'E', 'R', 'I', 'C', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'T', 'L', '\0', /* PA_SC_GENERIC_SCISSOR_TL (12251) */
	'P', 'A', '_', 'S', 'C', '_', 'G', 'E', 'N', 'E', 'R', 'I', 'C', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'B', 'R', '\0', /* PA_SC_GENERIC_SCISSOR_BR (12276) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '0', '\0', /* COHER_DEST_BASE_0 (12301) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '1', '\0', /* COHER_DEST_BASE_1 (12319) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '0', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_0_TL (12337) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '0', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_0_BR (12362) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_1_TL (12387) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_1_BR (12412) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '2', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_2_TL (12437) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '2', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_2_BR (12462) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '3', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_3_TL (12487) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '3', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_3_BR (12512) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '4', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_4_TL (12537) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '4', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_4_BR (12562) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '5', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_5_TL (12587) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '5', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_5_BR (12612) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '6', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_6_TL (12637) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '6', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_6_BR (12662) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '7', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_7_TL (12687) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '7', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_7_BR (12712) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '8', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_8_TL (12737) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '8', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_8_BR (12762) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '9', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_9_TL (12787) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '9', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_9_BR (12812) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '0', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_10_TL (12837) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '0', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_10_BR (12863) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '1', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_11_TL (12889) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '1', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_11_BR (12915) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '2', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_12_TL (12941) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '2', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_12_BR (12967) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '3', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_13_TL (12993) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '3', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_13_BR (13019) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '4', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_14_TL (13045) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '4', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_14_BR (13071) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '5', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_15_TL (13097) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '5', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_15_BR (13123) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '0', '\0', /* PA_SC_VPORT_ZMIN_0 (13149, 13163) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '0', '\0', /* PA_SC_VPORT_ZMAX_0 (13168) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '\0', /* PA_SC_VPORT_ZMIN_1 (13187, 13201) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '\0', /* PA_SC_VPORT_ZMAX_1 (13206) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '2', '\0', /* PA_SC_VPORT_ZMIN_2 (13225, 13239) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '2', '\0', /* PA_SC_VPORT_ZMAX_2 (13244) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '3', '\0', /* PA_SC_VPORT_ZMIN_3 (13263, 13277) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '3', '\0', /* PA_SC_VPORT_ZMAX_3 (13282) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '4', '\0', /* PA_SC_VPORT_ZMIN_4 (13301) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '4', '\0', /* PA_SC_VPORT_ZMAX_4 (13320) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '5', '\0', /* PA_SC_VPORT_ZMIN_5 (13339) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '5', '\0', /* PA_SC_VPORT_ZMAX_5 (13358) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '6', '\0', /* PA_SC_VPORT_ZMIN_6 (13377) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '6', '\0', /* PA_SC_VPORT_ZMAX_6 (13396) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '7', '\0', /* PA_SC_VPORT_ZMIN_7 (13415) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '7', '\0', /* PA_SC_VPORT_ZMAX_7 (13434) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '8', '\0', /* PA_SC_VPORT_ZMIN_8 (13453) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '8', '\0', /* PA_SC_VPORT_ZMAX_8 (13472) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '9', '\0', /* PA_SC_VPORT_ZMIN_9 (13491) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '9', '\0', /* PA_SC_VPORT_ZMAX_9 (13510) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '0', '\0', /* PA_SC_VPORT_ZMIN_10 (13529, 13543) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '0', '\0', /* PA_SC_VPORT_ZMAX_10 (13549) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '1', '\0', /* PA_SC_VPORT_ZMIN_11 (13569) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '1', '\0', /* PA_SC_VPORT_ZMAX_11 (13589) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '2', '\0', /* PA_SC_VPORT_ZMIN_12 (13609) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '2', '\0', /* PA_SC_VPORT_ZMAX_12 (13629) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '3', '\0', /* PA_SC_VPORT_ZMIN_13 (13649) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '3', '\0', /* PA_SC_VPORT_ZMAX_13 (13669) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '4', '\0', /* PA_SC_VPORT_ZMIN_14 (13689) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '4', '\0', /* PA_SC_VPORT_ZMAX_14 (13709) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '5', '\0', /* PA_SC_VPORT_ZMIN_15 (13729) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '5', '\0', /* PA_SC_VPORT_ZMAX_15 (13749) */
	'P', 'A', '_', 'S', 'C', '_', 'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* PA_SC_RASTER_CONFIG (13769) */
	'P', 'A', '_', 'S', 'C', '_', 'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', '1', '\0', /* PA_SC_RASTER_CONFIG_1 (13789) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PA_SC_SCREEN_EXTENT_CONTROL (13811) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'I', 'L', 'E', '_', 'S', 'T', 'E', 'E', 'R', 'I', 'N', 'G', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* PA_SC_TILE_STEERING_OVERRIDE (13839) */
	'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'X', '_', 'C', 'N', 'T', 'L', '\0', /* CP_PERFMON_CNTX_CNTL (13868) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', 'I', 'D', '\0', /* CP_PIPEID (13889) */
	'C', 'P', '_', 'V', 'M', 'I', 'D', '\0', /* CP_VMID (13899) */
	'P', 'A', '_', 'S', 'C', '_', 'R', 'I', 'G', 'H', 'T', '_', 'V', 'E', 'R', 'T', '_', 'G', 'R', 'I', 'D', '\0', /* PA_SC_RIGHT_VERT_GRID (13907) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'E', 'F', 'T', '_', 'V', 'E', 'R', 'T', '_', 'G', 'R', 'I', 'D', '\0', /* PA_SC_LEFT_VERT_GRID (13929) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'O', 'R', 'I', 'Z', '_', 'G', 'R', 'I', 'D', '\0', /* PA_SC_HORIZ_GRID (13950) */
	'V', 'G', 'T', '_', 'M', 'A', 'X', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* VGT_MAX_VTX_INDX (13967) */
	'V', 'G', 'T', '_', 'M', 'I', 'N', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* VGT_MIN_VTX_INDX (13984) */
	'V', 'G', 'T', '_', 'I', 'N', 'D', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* VGT_INDX_OFFSET (14001, 14008) */
	'V', 'G', 'T', '_', 'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'R', 'E', 'S', 'E', 'T', '_', 'I', 'N', 'D', 'X', '\0', /* VGT_MULTI_PRIM_IB_RESET_INDX (14017) */
	'C', 'B', '_', 'R', 'M', 'I', '_', 'G', 'L', '2', '_', 'C', 'A', 'C', 'H', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_RMI_GL2_CACHE_CONTROL (14046) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'R', 'E', 'D', '\0', /* CB_BLEND_RED (14071) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'G', 'R', 'E', 'E', 'N', '\0', /* CB_BLEND_GREEN (14084, 14096) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'B', 'L', 'U', 'E', '\0', /* CB_BLEND_BLUE (14099) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* CB_BLEND_ALPHA (14113) */
	'C', 'B', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_DCC_CONTROL (14128) */
	'C', 'B', '_', 'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COVERAGE_OUT_CONTROL (14143) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_STENCIL_CONTROL (14167) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', 'R', 'E', 'F', 'M', 'A', 'S', 'K', '\0', /* DB_STENCILREFMASK (14186) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', 'R', 'E', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'F', '\0', /* DB_STENCILREFMASK_BF (14204) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_CL_VPORT_XSCALE (14225) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_CL_VPORT_XOFFSET (14244) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_CL_VPORT_YSCALE (14264) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_CL_VPORT_YOFFSET (14283) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_CL_VPORT_ZSCALE (14303) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_CL_VPORT_ZOFFSET (14322) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '\0', /* PA_CL_VPORT_XSCALE_1 (14342) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* PA_CL_VPORT_XOFFSET_1 (14363) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '\0', /* PA_CL_VPORT_YSCALE_1 (14385) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* PA_CL_VPORT_YOFFSET_1 (14406) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '\0', /* PA_CL_VPORT_ZSCALE_1 (14428) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* PA_CL_VPORT_ZOFFSET_1 (14449) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '2', '\0', /* PA_CL_VPORT_XSCALE_2 (14471) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* PA_CL_VPORT_XOFFSET_2 (14492) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '2', '\0', /* PA_CL_VPORT_YSCALE_2 (14514) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* PA_CL_VPORT_YOFFSET_2 (14535) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '2', '\0', /* PA_CL_VPORT_ZSCALE_2 (14557) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* PA_CL_VPORT_ZOFFSET_2 (14578) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '3', '\0', /* PA_CL_VPORT_XSCALE_3 (14600) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* PA_CL_VPORT_XOFFSET_3 (14621) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '3', '\0', /* PA_CL_VPORT_YSCALE_3 (14643) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* PA_CL_VPORT_YOFFSET_3 (14664) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '3', '\0', /* PA_CL_VPORT_ZSCALE_3 (14686) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* PA_CL_VPORT_ZOFFSET_3 (14707) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '4', '\0', /* PA_CL_VPORT_XSCALE_4 (14729) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '4', '\0', /* PA_CL_VPORT_XOFFSET_4 (14750) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '4', '\0', /* PA_CL_VPORT_YSCALE_4 (14772) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '4', '\0', /* PA_CL_VPORT_YOFFSET_4 (14793) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '4', '\0', /* PA_CL_VPORT_ZSCALE_4 (14815) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '4', '\0', /* PA_CL_VPORT_ZOFFSET_4 (14836) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '5', '\0', /* PA_CL_VPORT_XSCALE_5 (14858) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '5', '\0', /* PA_CL_VPORT_XOFFSET_5 (14879) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '5', '\0', /* PA_CL_VPORT_YSCALE_5 (14901) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '5', '\0', /* PA_CL_VPORT_YOFFSET_5 (14922) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '5', '\0', /* PA_CL_VPORT_ZSCALE_5 (14944) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '5', '\0', /* PA_CL_VPORT_ZOFFSET_5 (14965) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '6', '\0', /* PA_CL_VPORT_XSCALE_6 (14987) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '6', '\0', /* PA_CL_VPORT_XOFFSET_6 (15008) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '6', '\0', /* PA_CL_VPORT_YSCALE_6 (15030) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '6', '\0', /* PA_CL_VPORT_YOFFSET_6 (15051) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '6', '\0', /* PA_CL_VPORT_ZSCALE_6 (15073) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '6', '\0', /* PA_CL_VPORT_ZOFFSET_6 (15094) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '7', '\0', /* PA_CL_VPORT_XSCALE_7 (15116) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '7', '\0', /* PA_CL_VPORT_XOFFSET_7 (15137) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '7', '\0', /* PA_CL_VPORT_YSCALE_7 (15159) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '7', '\0', /* PA_CL_VPORT_YOFFSET_7 (15180) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '7', '\0', /* PA_CL_VPORT_ZSCALE_7 (15202) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '7', '\0', /* PA_CL_VPORT_ZOFFSET_7 (15223) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '8', '\0', /* PA_CL_VPORT_XSCALE_8 (15245) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '8', '\0', /* PA_CL_VPORT_XOFFSET_8 (15266) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '8', '\0', /* PA_CL_VPORT_YSCALE_8 (15288) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '8', '\0', /* PA_CL_VPORT_YOFFSET_8 (15309) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '8', '\0', /* PA_CL_VPORT_ZSCALE_8 (15331) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '8', '\0', /* PA_CL_VPORT_ZOFFSET_8 (15352) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '9', '\0', /* PA_CL_VPORT_XSCALE_9 (15374) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '9', '\0', /* PA_CL_VPORT_XOFFSET_9 (15395) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '9', '\0', /* PA_CL_VPORT_YSCALE_9 (15417) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '9', '\0', /* PA_CL_VPORT_YOFFSET_9 (15438) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '9', '\0', /* PA_CL_VPORT_ZSCALE_9 (15460) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '9', '\0', /* PA_CL_VPORT_ZOFFSET_9 (15481) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '0', '\0', /* PA_CL_VPORT_XSCALE_10 (15503) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '0', '\0', /* PA_CL_VPORT_XOFFSET_10 (15525) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '0', '\0', /* PA_CL_VPORT_YSCALE_10 (15548) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '0', '\0', /* PA_CL_VPORT_YOFFSET_10 (15570) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '0', '\0', /* PA_CL_VPORT_ZSCALE_10 (15593) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '0', '\0', /* PA_CL_VPORT_ZOFFSET_10 (15615) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '1', '\0', /* PA_CL_VPORT_XSCALE_11 (15638) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '1', '\0', /* PA_CL_VPORT_XOFFSET_11 (15660) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '1', '\0', /* PA_CL_VPORT_YSCALE_11 (15683) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '1', '\0', /* PA_CL_VPORT_YOFFSET_11 (15705) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '1', '\0', /* PA_CL_VPORT_ZSCALE_11 (15728) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '1', '\0', /* PA_CL_VPORT_ZOFFSET_11 (15750) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '2', '\0', /* PA_CL_VPORT_XSCALE_12 (15773) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '2', '\0', /* PA_CL_VPORT_XOFFSET_12 (15795) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '2', '\0', /* PA_CL_VPORT_YSCALE_12 (15818) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '2', '\0', /* PA_CL_VPORT_YOFFSET_12 (15840) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '2', '\0', /* PA_CL_VPORT_ZSCALE_12 (15863) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '2', '\0', /* PA_CL_VPORT_ZOFFSET_12 (15885) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '3', '\0', /* PA_CL_VPORT_XSCALE_13 (15908) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '3', '\0', /* PA_CL_VPORT_XOFFSET_13 (15930) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '3', '\0', /* PA_CL_VPORT_YSCALE_13 (15953) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '3', '\0', /* PA_CL_VPORT_YOFFSET_13 (15975) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '3', '\0', /* PA_CL_VPORT_ZSCALE_13 (15998) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '3', '\0', /* PA_CL_VPORT_ZOFFSET_13 (16020) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '4', '\0', /* PA_CL_VPORT_XSCALE_14 (16043) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '4', '\0', /* PA_CL_VPORT_XOFFSET_14 (16065) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '4', '\0', /* PA_CL_VPORT_YSCALE_14 (16088) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '4', '\0', /* PA_CL_VPORT_YOFFSET_14 (16110) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '4', '\0', /* PA_CL_VPORT_ZSCALE_14 (16133) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '4', '\0', /* PA_CL_VPORT_ZOFFSET_14 (16155) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '5', '\0', /* PA_CL_VPORT_XSCALE_15 (16178) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '5', '\0', /* PA_CL_VPORT_XOFFSET_15 (16200) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '5', '\0', /* PA_CL_VPORT_YSCALE_15 (16223) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '5', '\0', /* PA_CL_VPORT_YOFFSET_15 (16245) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '5', '\0', /* PA_CL_VPORT_ZSCALE_15 (16268) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '5', '\0', /* PA_CL_VPORT_ZOFFSET_15 (16290) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'X', '\0', /* PA_CL_UCP_0_X (16313) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'Y', '\0', /* PA_CL_UCP_0_Y (16327) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'Z', '\0', /* PA_CL_UCP_0_Z (16341) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'W', '\0', /* PA_CL_UCP_0_W (16355) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'X', '\0', /* PA_CL_UCP_1_X (16369) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'Y', '\0', /* PA_CL_UCP_1_Y (16383) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'Z', '\0', /* PA_CL_UCP_1_Z (16397) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'W', '\0', /* PA_CL_UCP_1_W (16411) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'X', '\0', /* PA_CL_UCP_2_X (16425) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'Y', '\0', /* PA_CL_UCP_2_Y (16439) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'Z', '\0', /* PA_CL_UCP_2_Z (16453) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'W', '\0', /* PA_CL_UCP_2_W (16467) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'X', '\0', /* PA_CL_UCP_3_X (16481) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'Y', '\0', /* PA_CL_UCP_3_Y (16495) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'Z', '\0', /* PA_CL_UCP_3_Z (16509) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'W', '\0', /* PA_CL_UCP_3_W (16523) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'X', '\0', /* PA_CL_UCP_4_X (16537) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'Y', '\0', /* PA_CL_UCP_4_Y (16551) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'Z', '\0', /* PA_CL_UCP_4_Z (16565) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'W', '\0', /* PA_CL_UCP_4_W (16579) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'X', '\0', /* PA_CL_UCP_5_X (16593) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'Y', '\0', /* PA_CL_UCP_5_Y (16607) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'Z', '\0', /* PA_CL_UCP_5_Z (16621) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'W', '\0', /* PA_CL_UCP_5_W (16635) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'R', 'O', 'G', '_', 'N', 'E', 'A', 'R', '_', 'C', 'L', 'I', 'P', '_', 'Z', '\0', /* PA_CL_PROG_NEAR_CLIP_Z (16649) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '0', '\0', /* SPI_PS_INPUT_CNTL_0 (16672) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* SPI_PS_INPUT_CNTL_1 (16692) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '\0', /* SPI_PS_INPUT_CNTL_2 (16712) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '3', '\0', /* SPI_PS_INPUT_CNTL_3 (16732) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '4', '\0', /* SPI_PS_INPUT_CNTL_4 (16752) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '5', '\0', /* SPI_PS_INPUT_CNTL_5 (16772) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '6', '\0', /* SPI_PS_INPUT_CNTL_6 (16792) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '7', '\0', /* SPI_PS_INPUT_CNTL_7 (16812) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '8', '\0', /* SPI_PS_INPUT_CNTL_8 (16832) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '9', '\0', /* SPI_PS_INPUT_CNTL_9 (16852) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '0', '\0', /* SPI_PS_INPUT_CNTL_10 (16872) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '1', '\0', /* SPI_PS_INPUT_CNTL_11 (16893) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '2', '\0', /* SPI_PS_INPUT_CNTL_12 (16914) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '3', '\0', /* SPI_PS_INPUT_CNTL_13 (16935) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '4', '\0', /* SPI_PS_INPUT_CNTL_14 (16956) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '5', '\0', /* SPI_PS_INPUT_CNTL_15 (16977) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '6', '\0', /* SPI_PS_INPUT_CNTL_16 (16998) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '7', '\0', /* SPI_PS_INPUT_CNTL_17 (17019) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '8', '\0', /* SPI_PS_INPUT_CNTL_18 (17040) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '9', '\0', /* SPI_PS_INPUT_CNTL_19 (17061) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '0', '\0', /* SPI_PS_INPUT_CNTL_20 (17082) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '1', '\0', /* SPI_PS_INPUT_CNTL_21 (17103) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '2', '\0', /* SPI_PS_INPUT_CNTL_22 (17124) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '3', '\0', /* SPI_PS_INPUT_CNTL_23 (17145) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '4', '\0', /* SPI_PS_INPUT_CNTL_24 (17166) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '5', '\0', /* SPI_PS_INPUT_CNTL_25 (17187) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '6', '\0', /* SPI_PS_INPUT_CNTL_26 (17208) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '7', '\0', /* SPI_PS_INPUT_CNTL_27 (17229) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '8', '\0', /* SPI_PS_INPUT_CNTL_28 (17250) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '9', '\0', /* SPI_PS_INPUT_CNTL_29 (17271) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '3', '0', '\0', /* SPI_PS_INPUT_CNTL_30 (17292) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '3', '1', '\0', /* SPI_PS_INPUT_CNTL_31 (17313) */
	'S', 'P', 'I', '_', 'V', 'S', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* SPI_VS_OUT_CONFIG (17334) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'E', 'N', 'A', '\0', /* SPI_PS_INPUT_ENA (17352) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* SPI_PS_INPUT_ADDR (17369) */
	'S', 'P', 'I', '_', 'I', 'N', 'T', 'E', 'R', 'P', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '_', '0', '\0', /* SPI_INTERP_CONTROL_0 (17387) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* SPI_PS_IN_CONTROL (17408) */
	'S', 'P', 'I', '_', 'B', 'A', 'R', 'Y', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_BARYC_CNTL (17426) */
	'S', 'P', 'I', '_', 'T', 'M', 'P', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* SPI_TMPRING_SIZE (17441) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'I', 'D', 'X', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_IDX_FORMAT (17458, 17473) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'O', 'S', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_POS_FORMAT (17480) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'Z', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_Z_FORMAT (17502) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'O', 'L', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_COL_FORMAT (17522) */
	'S', 'X', '_', 'P', 'S', '_', 'D', 'O', 'W', 'N', 'C', 'O', 'N', 'V', 'E', 'R', 'T', '\0', /* SX_PS_DOWNCONVERT (17544) */
	'S', 'X', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* SX_BLEND_OPT_EPSILON (17562) */
	'S', 'X', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* SX_BLEND_OPT_CONTROL (17583) */
	'S', 'X', '_', 'M', 'R', 'T', '0', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT0_BLEND_OPT (17604) */
	'S', 'X', '_', 'M', 'R', 'T', '1', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT1_BLEND_OPT (17622) */
	'S', 'X', '_', 'M', 'R', 'T', '2', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT2_BLEND_OPT (17640) */
	'S', 'X', '_', 'M', 'R', 'T', '3', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT3_BLEND_OPT (17658) */
	'S', 'X', '_', 'M', 'R', 'T', '4', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT4_BLEND_OPT (17676) */
	'S', 'X', '_', 'M', 'R', 'T', '5', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT5_BLEND_OPT (17694) */
	'S', 'X', '_', 'M', 'R', 'T', '6', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT6_BLEND_OPT (17712) */
	'S', 'X', '_', 'M', 'R', 'T', '7', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT7_BLEND_OPT (17730) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '0', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND0_CONTROL (17748) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '1', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND1_CONTROL (17766) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '2', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND2_CONTROL (17784) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '3', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND3_CONTROL (17802) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '4', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND4_CONTROL (17820) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '5', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND5_CONTROL (17838) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '6', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND6_CONTROL (17856) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '7', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND7_CONTROL (17874) */
	'C', 'S', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* CS_COPY_STATE (17892) */
	'G', 'F', 'X', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* GFX_COPY_STATE (17906) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'X', '_', 'R', 'A', 'D', '\0', /* PA_CL_POINT_X_RAD (17921) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'Y', '_', 'R', 'A', 'D', '\0', /* PA_CL_POINT_Y_RAD (17939) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_CL_POINT_SIZE (17957) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'C', 'U', 'L', 'L', '_', 'R', 'A', 'D', '\0', /* PA_CL_POINT_CULL_RAD (17974) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* VGT_DMA_BASE_HI (17995) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'B', 'A', 'S', 'E', '\0', /* VGT_DMA_BASE (18011) */
	'V', 'G', 'T', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* VGT_DRAW_INITIATOR (18024) */
	'V', 'G', 'T', '_', 'I', 'M', 'M', 'E', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* VGT_IMMED_DATA (18043) */
	'V', 'G', 'T', '_', 'E', 'V', 'E', 'N', 'T', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'R', 'E', 'G', '\0', /* VGT_EVENT_ADDRESS_REG (18058) */
	'G', 'E', '_', 'M', 'A', 'X', '_', 'O', 'U', 'T', 'P', 'U', 'T', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'O', 'U', 'P', '\0', /* GE_MAX_OUTPUT_PER_SUBGROUP (18080) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_DEPTH_CONTROL (18107) */
	'D', 'B', '_', 'E', 'Q', 'A', 'A', '\0', /* DB_EQAA (18124) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR_CONTROL (18132) */
	'D', 'B', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_SHADER_CONTROL (18149) */
	'P', 'A', '_', 'C', 'L', '_', 'C', 'L', 'I', 'P', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_CLIP_CNTL (18167) */
	'P', 'A', '_', 'S', 'U', '_', 'S', 'C', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_SC_MODE_CNTL (18183) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'T', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_VTE_CNTL (18202) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'S', '_', 'O', 'U', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_VS_OUT_CNTL (18217) */
	'P', 'A', '_', 'C', 'L', '_', 'N', 'A', 'N', 'I', 'N', 'F', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_NANINF_CNTL (18235) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_LINE_STIPPLE_CNTL (18253) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_SU_LINE_STIPPLE_SCALE (18277) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'R', 'I', 'M', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_PRIM_FILTER_CNTL (18302) */
	'P', 'A', '_', 'S', 'U', '_', 'S', 'M', 'A', 'L', 'L', '_', 'P', 'R', 'I', 'M', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_SMALL_PRIM_FILTER_CNTL (18325) */
	'P', 'A', '_', 'C', 'L', '_', 'O', 'B', 'J', 'P', 'R', 'I', 'M', '_', 'I', 'D', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_OBJPRIM_ID_CNTL (18354) */
	'P', 'A', '_', 'C', 'L', '_', 'N', 'G', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_NGG_CNTL (18376) */
	'P', 'A', '_', 'S', 'U', '_', 'O', 'V', 'E', 'R', '_', 'R', 'A', 'S', 'T', 'E', 'R', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_OVER_RASTERIZATION_CNTL (18391) */
	'P', 'A', '_', 'S', 'T', 'E', 'R', 'E', 'O', '_', 'C', 'N', 'T', 'L', '\0', /* PA_STEREO_CNTL (18421) */
	'P', 'A', '_', 'S', 'T', 'A', 'T', 'E', '_', 'S', 'T', 'E', 'R', 'E', 'O', '_', 'X', '\0', /* PA_STATE_STEREO_X (18436) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'I', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_SU_POINT_SIZE (18454) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'I', 'N', 'T', '_', 'M', 'I', 'N', 'M', 'A', 'X', '\0', /* PA_SU_POINT_MINMAX (18471) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_LINE_CNTL (18490) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '\0', /* PA_SC_LINE_STIPPLE (18506) */
	'V', 'G', 'T', '_', 'O', 'U', 'T', 'P', 'U', 'T', '_', 'P', 'A', 'T', 'H', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_OUTPUT_PATH_CNTL (18525) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_HOS_CNTL (18546) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'M', 'A', 'X', '_', 'T', 'E', 'S', 'S', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* VGT_HOS_MAX_TESS_LEVEL (18559) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'M', 'I', 'N', '_', 'T', 'E', 'S', 'S', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* VGT_HOS_MIN_TESS_LEVEL (18582) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'R', 'E', 'U', 'S', 'E', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_HOS_REUSE_DEPTH (18605, 18613, 18619) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'P', 'R', 'I', 'M', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_GROUP_PRIM_TYPE (18625, 18635) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'F', 'I', 'R', 'S', 'T', '_', 'D', 'E', 'C', 'R', '\0', /* VGT_GROUP_FIRST_DECR (18645, 18655, 18661) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'D', 'E', 'C', 'R', '\0', /* VGT_GROUP_DECR (18666) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '0', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_0_CNTL (18681) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '1', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_1_CNTL (18703) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '0', '_', 'F', 'M', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_0_FMT_CNTL (18725) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '1', '_', 'F', 'M', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_1_FMT_CNTL (18751) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'M', 'O', 'D', 'E', '\0', /* VGT_GS_MODE (18777) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'O', 'N', 'C', 'H', 'I', 'P', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GS_ONCHIP_CNTL (18789) */
	'P', 'A', '_', 'S', 'C', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '_', '0', '\0', /* PA_SC_MODE_CNTL_0 (18808) */
	'P', 'A', '_', 'S', 'C', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* PA_SC_MODE_CNTL_1 (18826) */
	'V', 'G', 'T', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* VGT_ENHANCE (18844) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'P', 'E', 'R', '_', 'E', 'S', '\0', /* VGT_GS_PER_ES (18856, 18860) */
	'V', 'G', 'T', '_', 'E', 'S', '_', 'P', 'E', 'R', '_', 'G', 'S', '\0', /* VGT_ES_PER_GS (18870, 18874) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'P', 'E', 'R', '_', 'V', 'S', '\0', /* VGT_GS_PER_VS (18884, 18888) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* VGT_GSVS_RING_OFFSET_1 (18898) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* VGT_GSVS_RING_OFFSET_2 (18921) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* VGT_GSVS_RING_OFFSET_3 (18944) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_GS_OUT_PRIM_TYPE (18967) */
	'I', 'A', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* IA_ENHANCE (18988) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_DMA_SIZE (18999) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'M', 'A', 'X', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_DMA_MAX_SIZE (19012, 19020) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_DMA_INDEX_TYPE (19029) */
	'W', 'D', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* WD_ENHANCE (19048) */
	'V', 'G', 'T', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', 'I', 'D', '_', 'E', 'N', '\0', /* VGT_PRIMITIVEID_EN (19059, 19063) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'N', 'U', 'M', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', 'S', '\0', /* VGT_DMA_NUM_INSTANCES (19078) */
	'V', 'G', 'T', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', 'I', 'D', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* VGT_PRIMITIVEID_RESET (19100, 19116) */
	'V', 'G', 'T', '_', 'E', 'V', 'E', 'N', 'T', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* VGT_EVENT_INITIATOR (19122) */
	'V', 'G', 'T', '_', 'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'R', 'E', 'S', 'E', 'T', '_', 'E', 'N', '\0', /* VGT_MULTI_PRIM_IB_RESET_EN (19142, 19160) */
	'V', 'G', 'T', '_', 'D', 'R', 'A', 'W', '_', 'P', 'A', 'Y', 'L', 'O', 'A', 'D', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_DRAW_PAYLOAD_CNTL (19169) */
	'V', 'G', 'T', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'S', 'T', 'E', 'P', '_', 'R', 'A', 'T', 'E', '_', '0', '\0', /* VGT_INSTANCE_STEP_RATE_0 (19191) */
	'V', 'G', 'T', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'S', 'T', 'E', 'P', '_', 'R', 'A', 'T', 'E', '_', '1', '\0', /* VGT_INSTANCE_STEP_RATE_1 (19216) */
	'I', 'A', '_', 'M', 'U', 'L', 'T', 'I', '_', 'V', 'G', 'T', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* IA_MULTI_VGT_PARAM (19241) */
	'V', 'G', 'T', '_', 'E', 'S', 'G', 'S', '_', 'R', 'I', 'N', 'G', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '\0', /* VGT_ESGS_RING_ITEMSIZE (19260, 19274) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '\0', /* VGT_GSVS_RING_ITEMSIZE (19283) */
	'V', 'G', 'T', '_', 'R', 'E', 'U', 'S', 'E', '_', 'O', 'F', 'F', '\0', /* VGT_REUSE_OFF (19306, 19310) */
	'V', 'G', 'T', '_', 'V', 'T', 'X', '_', 'C', 'N', 'T', '_', 'E', 'N', '\0', /* VGT_VTX_CNT_EN (19320, 19324) */
	'D', 'B', '_', 'H', 'T', 'I', 'L', 'E', '_', 'S', 'U', 'R', 'F', 'A', 'C', 'E', '\0', /* DB_HTILE_SURFACE (19335, 19347) */
	'D', 'B', '_', 'S', 'R', 'E', 'S', 'U', 'L', 'T', 'S', '_', 'C', 'O', 'M', 'P', 'A', 'R', 'E', '_', 'S', 'T', 'A', 'T', 'E', '0', '\0', /* DB_SRESULTS_COMPARE_STATE0 (19352) */
	'D', 'B', '_', 'S', 'R', 'E', 'S', 'U', 'L', 'T', 'S', '_', 'C', 'O', 'M', 'P', 'A', 'R', 'E', '_', 'S', 'T', 'A', 'T', 'E', '1', '\0', /* DB_SRESULTS_COMPARE_STATE1 (19379) */
	'D', 'B', '_', 'P', 'R', 'E', 'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_PRELOAD_CONTROL (19406) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '0', '\0', /* VGT_STRMOUT_BUFFER_SIZE_0 (19425) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '0', '\0', /* VGT_STRMOUT_VTX_STRIDE_0 (19451) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '0', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_0 (19476) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '1', '\0', /* VGT_STRMOUT_BUFFER_SIZE_1 (19504) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '1', '\0', /* VGT_STRMOUT_VTX_STRIDE_1 (19530) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_1 (19555) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '2', '\0', /* VGT_STRMOUT_BUFFER_SIZE_2 (19583) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '2', '\0', /* VGT_STRMOUT_VTX_STRIDE_2 (19609) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_2 (19634) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '3', '\0', /* VGT_STRMOUT_BUFFER_SIZE_3 (19662) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '3', '\0', /* VGT_STRMOUT_VTX_STRIDE_3 (19688) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_3 (19713) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'R', 'A', 'W', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* VGT_STRMOUT_DRAW_OPAQUE_OFFSET (19741) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'R', 'A', 'W', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE (19772) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'R', 'A', 'W', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '_', 'V', 'E', 'R', 'T', 'E', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '\0', /* VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE (19815, 19839, 19846) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'M', 'A', 'X', '_', 'V', 'E', 'R', 'T', '_', 'O', 'U', 'T', '\0', /* VGT_GS_MAX_VERT_OUT (19853, 19860, 19869) */
	'G', 'E', '_', 'N', 'G', 'G', '_', 'S', 'U', 'B', 'G', 'R', 'P', '_', 'C', 'N', 'T', 'L', '\0', /* GE_NGG_SUBGRP_CNTL (19873) */
	'V', 'G', 'T', '_', 'T', 'E', 'S', 'S', '_', 'D', 'I', 'S', 'T', 'R', 'I', 'B', 'U', 'T', 'I', 'O', 'N', '\0', /* VGT_TESS_DISTRIBUTION (19892) */
	'V', 'G', 'T', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'S', 'T', 'A', 'G', 'E', 'S', '_', 'E', 'N', '\0', /* VGT_SHADER_STAGES_EN (19914, 19929) */
	'V', 'G', 'T', '_', 'L', 'S', '_', 'H', 'S', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_LS_HS_CONFIG (19935) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '\0', /* VGT_GS_VERT_ITEMSIZE (19952) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '_', '1', '\0', /* VGT_GS_VERT_ITEMSIZE_1 (19973) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '_', '2', '\0', /* VGT_GS_VERT_ITEMSIZE_2 (19996) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '_', '3', '\0', /* VGT_GS_VERT_ITEMSIZE_3 (20019) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* VGT_TF_PARAM (20042) */
	'D', 'B', '_', 'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '\0', /* DB_ALPHA_TO_MASK (20055) */
	'V', 'G', 'T', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* VGT_DISPATCH_DRAW_INDEX (20072) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'D', 'B', '_', 'F', 'M', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_POLY_OFFSET_DB_FMT_CNTL (20096) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* PA_SU_POLY_OFFSET_CLAMP (20126) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'F', 'R', 'O', 'N', 'T', '_', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_SU_POLY_OFFSET_FRONT_SCALE (20150) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'F', 'R', 'O', 'N', 'T', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SU_POLY_OFFSET_FRONT_OFFSET (20180) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'B', 'A', 'C', 'K', '_', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_SU_POLY_OFFSET_BACK_SCALE (20211) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'B', 'A', 'C', 'K', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SU_POLY_OFFSET_BACK_OFFSET (20240) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'C', 'N', 'T', '\0', /* VGT_GS_INSTANCE_CNT (20270, 20286) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_STRMOUT_CONFIG (20290) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_STRMOUT_BUFFER_CONFIG (20309) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'E', 'V', 'E', 'N', 'T', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* VGT_DMA_EVENT_INITIATOR (20335) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', '0', '\0', /* PA_SC_CENTROID_PRIORITY_0 (20359) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', '1', '\0', /* PA_SC_CENTROID_PRIORITY_1 (20385) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'I', 'N', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_LINE_CNTL (20411) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* PA_SC_AA_CONFIG (20427) */
	'P', 'A', '_', 'S', 'U', '_', 'V', 'T', 'X', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_VTX_CNTL (20443) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'V', 'E', 'R', 'T', '_', 'C', 'L', 'I', 'P', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_VERT_CLIP_ADJ (20458) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'V', 'E', 'R', 'T', '_', 'D', 'I', 'S', 'C', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_VERT_DISC_ADJ (20481) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'H', 'O', 'R', 'Z', '_', 'C', 'L', 'I', 'P', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_HORZ_CLIP_ADJ (20504) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'H', 'O', 'R', 'Z', '_', 'D', 'I', 'S', 'C', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_HORZ_DISC_ADJ (20527) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0 (20550) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1 (20584) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2 (20618) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3 (20652) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0 (20686) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1 (20720) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2 (20754) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3 (20788) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0 (20822) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1 (20856) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2 (20890) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3 (20924) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0 (20958) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1 (20992) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2 (21026) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3 (21060) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'X', '0', 'Y', '0', '_', 'X', '1', 'Y', '0', '\0', /* PA_SC_AA_MASK_X0Y0_X1Y0 (21094) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'X', '0', 'Y', '1', '_', 'X', '1', 'Y', '1', '\0', /* PA_SC_AA_MASK_X0Y1_X1Y1 (21118) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PA_SC_SHADER_CONTROL (21142) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'C', 'N', 'T', 'L', '_', '0', '\0', /* PA_SC_BINNER_CNTL_0 (21163) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* PA_SC_BINNER_CNTL_1 (21183) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'O', 'N', 'S', 'E', 'R', 'V', 'A', 'T', 'I', 'V', 'E', '_', 'R', 'A', 'S', 'T', 'E', 'R', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_CONSERVATIVE_RASTERIZATION_CNTL (21203) */
	'P', 'A', '_', 'S', 'C', '_', 'N', 'G', 'G', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_NGG_MODE_CNTL (21241) */
	'V', 'G', 'T', '_', 'V', 'E', 'R', 'T', 'E', 'X', '_', 'R', 'E', 'U', 'S', 'E', '_', 'B', 'L', 'O', 'C', 'K', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_VERTEX_REUSE_BLOCK_CNTL (21261) */
	'V', 'G', 'T', '_', 'O', 'U', 'T', '_', 'D', 'E', 'A', 'L', 'L', 'O', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_OUT_DEALLOC_CNTL (21289) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR0_BASE (21310) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR0_PITCH (21325, 21335) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR0_SLICE (21341) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR0_VIEW (21357) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR0_INFO (21372) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR0_ATTRIB (21387) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR0_DCC_CONTROL (21404) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR0_CMASK (21426) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR0_CMASK_SLICE (21442) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR0_FMASK (21464) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR0_FMASK_SLICE (21480) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR0_CLEAR_WORD0 (21502) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR0_CLEAR_WORD1 (21524) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR0_DCC_BASE (21546) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR1_BASE (21565) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR1_PITCH (21580) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR1_SLICE (21596) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR1_VIEW (21612) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR1_INFO (21627) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR1_ATTRIB (21642) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR1_DCC_CONTROL (21659) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR1_CMASK (21681) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR1_CMASK_SLICE (21697) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR1_FMASK (21719) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR1_FMASK_SLICE (21735) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR1_CLEAR_WORD0 (21757) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR1_CLEAR_WORD1 (21779) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR1_DCC_BASE (21801) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR2_BASE (21820) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR2_PITCH (21835) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR2_SLICE (21851) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR2_VIEW (21867) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR2_INFO (21882) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR2_ATTRIB (21897) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR2_DCC_CONTROL (21914) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR2_CMASK (21936) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR2_CMASK_SLICE (21952) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR2_FMASK (21974) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR2_FMASK_SLICE (21990) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR2_CLEAR_WORD0 (22012) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR2_CLEAR_WORD1 (22034) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR2_DCC_BASE (22056) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR3_BASE (22075) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR3_PITCH (22090) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR3_SLICE (22106) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR3_VIEW (22122) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR3_INFO (22137) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR3_ATTRIB (22152) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR3_DCC_CONTROL (22169) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR3_CMASK (22191) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR3_CMASK_SLICE (22207) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR3_FMASK (22229) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR3_FMASK_SLICE (22245) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR3_CLEAR_WORD0 (22267) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR3_CLEAR_WORD1 (22289) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR3_DCC_BASE (22311) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR4_BASE (22330) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR4_PITCH (22345) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR4_SLICE (22361) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR4_VIEW (22377) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR4_INFO (22392) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR4_ATTRIB (22407) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR4_DCC_CONTROL (22424) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR4_CMASK (22446) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR4_CMASK_SLICE (22462) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR4_FMASK (22484) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR4_FMASK_SLICE (22500) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR4_CLEAR_WORD0 (22522) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR4_CLEAR_WORD1 (22544) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR4_DCC_BASE (22566) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR5_BASE (22585) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR5_PITCH (22600) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR5_SLICE (22616) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR5_VIEW (22632) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR5_INFO (22647) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR5_ATTRIB (22662) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR5_DCC_CONTROL (22679) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR5_CMASK (22701) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR5_CMASK_SLICE (22717) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR5_FMASK (22739) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR5_FMASK_SLICE (22755) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR5_CLEAR_WORD0 (22777) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR5_CLEAR_WORD1 (22799) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR5_DCC_BASE (22821) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR6_BASE (22840) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR6_PITCH (22855) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR6_SLICE (22871) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR6_VIEW (22887) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR6_INFO (22902) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR6_ATTRIB (22917) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR6_DCC_CONTROL (22934) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR6_CMASK (22956) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR6_CMASK_SLICE (22972) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR6_FMASK (22994) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR6_FMASK_SLICE (23010) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR6_CLEAR_WORD0 (23032) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR6_CLEAR_WORD1 (23054) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR6_DCC_BASE (23076) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR7_BASE (23095) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR7_PITCH (23110) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR7_SLICE (23126) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR7_VIEW (23142) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR7_INFO (23157) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR7_ATTRIB (23172) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR7_DCC_CONTROL (23189) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR7_CMASK (23211) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR7_CMASK_SLICE (23227) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR7_FMASK (23249) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR7_FMASK_SLICE (23265) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR7_CLEAR_WORD0 (23287) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR7_CLEAR_WORD1 (23309) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR7_DCC_BASE (23331) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_BASE_EXT (23350) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_BASE_EXT (23369) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_BASE_EXT (23388) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_BASE_EXT (23407) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_BASE_EXT (23426) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_BASE_EXT (23445) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_BASE_EXT (23464) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_BASE_EXT (23483) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_CMASK_BASE_EXT (23502) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_CMASK_BASE_EXT (23527) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_CMASK_BASE_EXT (23552) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_CMASK_BASE_EXT (23577) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_CMASK_BASE_EXT (23602) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_CMASK_BASE_EXT (23627) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_CMASK_BASE_EXT (23652) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_CMASK_BASE_EXT (23677) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_FMASK_BASE_EXT (23702) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_FMASK_BASE_EXT (23727) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_FMASK_BASE_EXT (23752) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_FMASK_BASE_EXT (23777) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_FMASK_BASE_EXT (23802) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_FMASK_BASE_EXT (23827) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_FMASK_BASE_EXT (23852) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_FMASK_BASE_EXT (23877) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_DCC_BASE_EXT (23902) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_DCC_BASE_EXT (23925) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_DCC_BASE_EXT (23948) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_DCC_BASE_EXT (23971) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_DCC_BASE_EXT (23994) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_DCC_BASE_EXT (24017) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_DCC_BASE_EXT (24040) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_DCC_BASE_EXT (24063) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR0_ATTRIB2 (24086) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR1_ATTRIB2 (24104) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR2_ATTRIB2 (24122) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR3_ATTRIB2 (24140) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR4_ATTRIB2 (24158) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR5_ATTRIB2 (24176) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR6_ATTRIB2 (24194) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR7_ATTRIB2 (24212) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR0_ATTRIB3 (24230) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR1_ATTRIB3 (24248) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR2_ATTRIB3 (24266) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR3_ATTRIB3 (24284) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR4_ATTRIB3 (24302) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR5_ATTRIB3 (24320) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR6_ATTRIB3 (24338) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR7_ATTRIB3 (24356) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_EOP_DONE_ADDR_LO (24374) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_EOP_DONE_ADDR_HI (24394) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* CP_EOP_DONE_DATA_LO (24414) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* CP_EOP_DONE_DATA_HI (24434) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'L', 'A', 'S', 'T', '_', 'F', 'E', 'N', 'C', 'E', '_', 'L', 'O', '\0', /* CP_EOP_LAST_FENCE_LO (24454) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'L', 'A', 'S', 'T', '_', 'F', 'E', 'N', 'C', 'E', '_', 'H', 'I', '\0', /* CP_EOP_LAST_FENCE_HI (24475) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_STREAM_OUT_ADDR_LO (24496, 24499) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_STREAM_OUT_ADDR_HI (24518, 24521) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT0_LO (24540) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT0_HI (24570) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT0_LO (24600) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT0_HI (24629) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT1_LO (24658) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT1_HI (24688) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT1_LO (24718) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT1_HI (24747) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT2_LO (24776) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT2_HI (24806) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT2_LO (24836) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT2_HI (24865) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT3_LO (24894) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT3_HI (24924) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT3_LO (24954) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT3_HI (24983) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_PIPE_STATS_ADDR_LO (25012, 25015) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_PIPE_STATS_ADDR_HI (25034, 25037) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'V', 'E', 'R', 'T', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_IAVERT_COUNT_LO (25056) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'V', 'E', 'R', 'T', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_IAVERT_COUNT_HI (25079, 25093) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_IAPRIM_COUNT_LO (25102) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_IAPRIM_COUNT_HI (25125) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_GSPRIM_COUNT_LO (25148) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_GSPRIM_COUNT_HI (25171) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'V', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_VSINVOC_COUNT_LO (25194) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'V', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_VSINVOC_COUNT_HI (25218) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_GSINVOC_COUNT_LO (25242) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_GSINVOC_COUNT_HI (25266) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'H', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_HSINVOC_COUNT_LO (25290) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'H', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_HSINVOC_COUNT_HI (25314) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'D', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_DSINVOC_COUNT_LO (25338) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'D', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_DSINVOC_COUNT_HI (25362) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_PA_CINVOC_COUNT_LO (25386) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_PA_CINVOC_COUNT_HI (25408) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_PA_CPRIM_COUNT_LO (25430) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_PA_CPRIM_COUNT_HI (25451) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', '\0', /* CP_SC_PSINVOC_COUNT0_LO (25472) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* CP_SC_PSINVOC_COUNT0_HI (25496) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', '\0', /* CP_SC_PSINVOC_COUNT1_LO (25520) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* CP_SC_PSINVOC_COUNT1_HI (25544) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'C', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_CSINVOC_COUNT_LO (25568) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'C', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_CSINVOC_COUNT_HI (25592) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_EOP_DONE_DOORBELL (25616) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_STREAM_OUT_DOORBELL (25637) */
	'C', 'P', '_', 'S', 'E', 'M', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_SEM_DOORBELL (25660) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_PIPE_STATS_CONTROL (25676) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_STREAM_OUT_CONTROL (25698) */
	'C', 'P', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* CP_STRMOUT_CNTL (25720) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '0', '\0', /* SCRATCH_REG0 (25736) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '1', '\0', /* SCRATCH_REG1 (25749) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '2', '\0', /* SCRATCH_REG2 (25762) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '3', '\0', /* SCRATCH_REG3 (25775) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '4', '\0', /* SCRATCH_REG4 (25788) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '5', '\0', /* SCRATCH_REG5 (25801) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '6', '\0', /* SCRATCH_REG6 (25814) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '7', '\0', /* SCRATCH_REG7 (25827) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_PIPE_STATS_DOORBELL (25840) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'D', 'I', 'D', '_', 'C', 'N', 'T', '\0', /* CP_APPEND_DDID_CNT (25863) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* CP_APPEND_DATA_HI (25882) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'C', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'H', 'I', '\0', /* CP_APPEND_LAST_CS_FENCE_HI (25900) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'P', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'H', 'I', '\0', /* CP_APPEND_LAST_PS_FENCE_HI (25927) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'U', 'M', 'S', 'K', '\0', /* SCRATCH_UMSK (25954) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'A', 'D', 'D', 'R', '\0', /* SCRATCH_ADDR (25967) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_PFP_ATOMIC_PREOP_LO (25980) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_PFP_ATOMIC_PREOP_HI (26003) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_PFP_GDS_ATOMIC0_PREOP_LO (26026) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_PFP_GDS_ATOMIC0_PREOP_HI (26054) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_PFP_GDS_ATOMIC1_PREOP_LO (26082) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_PFP_GDS_ATOMIC1_PREOP_HI (26110) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_APPEND_ADDR_LO (26138) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_APPEND_ADDR_HI (26156) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* CP_APPEND_DATA (26174) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'C', 'S', '_', 'F', 'E', 'N', 'C', 'E', '\0', /* CP_APPEND_LAST_CS_FENCE (26189) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'P', 'S', '_', 'F', 'E', 'N', 'C', 'E', '\0', /* CP_APPEND_LAST_PS_FENCE (26213) */
	'C', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_ATOMIC_PREOP_LO (26237) */
	'C', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_ATOMIC_PREOP_HI (26256) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_GDS_ATOMIC0_PREOP_LO (26275) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_GDS_ATOMIC0_PREOP_HI (26299) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_GDS_ATOMIC1_PREOP_LO (26323) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_GDS_ATOMIC1_PREOP_HI (26347) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_ME_MC_WADDR_LO (26371, 26374) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_ME_MC_WADDR_HI (26389, 26392) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* CP_ME_MC_WDATA_LO (26407) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* CP_ME_MC_WDATA_HI (26425) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'R', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_ME_MC_RADDR_LO (26443, 26446) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'R', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_ME_MC_RADDR_HI (26461, 26464) */
	'C', 'P', '_', 'S', 'E', 'M', '_', 'W', 'A', 'I', 'T', '_', 'T', 'I', 'M', 'E', 'R', '\0', /* CP_SEM_WAIT_TIMER (26479) */
	'C', 'P', '_', 'S', 'I', 'G', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_SIG_SEM_ADDR_LO (26497, 26504) */
	'C', 'P', '_', 'S', 'I', 'G', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_SIG_SEM_ADDR_HI (26516, 26523) */
	'C', 'P', '_', 'W', 'A', 'I', 'T', '_', 'R', 'E', 'G', '_', 'M', 'E', 'M', '_', 'T', 'I', 'M', 'E', 'O', 'U', 'T', '\0', /* CP_WAIT_REG_MEM_TIMEOUT (26535) */
	'C', 'P', '_', 'W', 'A', 'I', 'T', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_WAIT_SEM_ADDR_LO (26559) */
	'C', 'P', '_', 'W', 'A', 'I', 'T', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_WAIT_SEM_ADDR_HI (26579) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_DMA_PFP_CONTROL (26599) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_DMA_ME_CONTROL (26618) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_COHER_BASE_HI (26636) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'T', 'A', 'R', 'T', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* CP_COHER_START_DELAY (26653) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* CP_COHER_CNTL (26674) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* CP_COHER_SIZE (26688) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* CP_COHER_BASE (26702) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_COHER_STATUS (26716) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_ME_SRC_ADDR (26732, 26742) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_ME_SRC_ADDR_HI (26751, 26761) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_ME_DST_ADDR (26773, 26783) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_ME_DST_ADDR_HI (26792, 26802) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'O', 'M', 'M', 'A', 'N', 'D', '\0', /* CP_DMA_ME_COMMAND (26814, 26824) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_PFP_SRC_ADDR (26832) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_PFP_SRC_ADDR_HI (26852) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_PFP_DST_ADDR (26875) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_PFP_DST_ADDR_HI (26895) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'O', 'M', 'M', 'A', 'N', 'D', '\0', /* CP_DMA_PFP_COMMAND (26918) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* CP_DMA_CNTL (26937) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'R', 'E', 'A', 'D', '_', 'T', 'A', 'G', 'S', '\0', /* CP_DMA_READ_TAGS (26949) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', 'H', 'I', '\0', /* CP_COHER_SIZE_HI (26966) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'I', 'B', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_PFP_IB_CONTROL (26983, 26990) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_PFP_LOAD_CONTROL (27001) */
	'C', 'P', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* CP_SCRATCH_INDEX (27021) */
	'C', 'P', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'D', 'A', 'T', 'A', '\0', /* CP_SCRATCH_DATA (27038) */
	'C', 'P', '_', 'R', 'B', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_RB_OFFSET (27054, 27057) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_IB1_OFFSET (27067, 27070) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_IB2_OFFSET (27081, 27084) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'B', 'E', 'G', 'I', 'N', '\0', /* CP_IB1_PREAMBLE_BEGIN (27095, 27098) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'E', 'N', 'D', '\0', /* CP_IB1_PREAMBLE_END (27117, 27120) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'B', 'E', 'G', 'I', 'N', '\0', /* CP_IB2_PREAMBLE_BEGIN (27137, 27140) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'E', 'N', 'D', '\0', /* CP_IB2_PREAMBLE_END (27159, 27162) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_CE_IB1_OFFSET (27179) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_CE_IB2_OFFSET (27196) */
	'C', 'P', '_', 'C', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* CP_CE_COUNTER (27213) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_DMA_ME_CMD_ADDR_LO (27227) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_ME_CMD_ADDR_HI (27249) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_DMA_PFP_CMD_ADDR_LO (27271) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_PFP_CMD_ADDR_HI (27294) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_APPEND_CMD_ADDR_LO (27317) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_APPEND_CMD_ADDR_HI (27339) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_INIT_CMD_BUFSZ (27361) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB1_CMD_BUFSZ (27382) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB2_CMD_BUFSZ (27402) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB1_CMD_BUFSZ (27422) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB2_CMD_BUFSZ (27439) */
	'C', 'P', '_', 'S', 'T', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_ST_CMD_BUFSZ (27456) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_INIT_BASE_LO (27472, 27478) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_INIT_BASE_HI (27491, 27497) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_INIT_BUFSZ (27510, 27516) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_IB1_BASE_LO (27527, 27533) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_IB1_BASE_HI (27545, 27551) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB1_BUFSZ (27563, 27569) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_IB2_BASE_LO (27579, 27585) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_IB2_BASE_HI (27597, 27603) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB2_BUFSZ (27615, 27621) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_IB1_BASE_LO (27631) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_IB1_BASE_HI (27646) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB1_BUFSZ (27661) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_IB2_BASE_LO (27674) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_IB2_BASE_HI (27689) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB2_BUFSZ (27704) */
	'C', 'P', '_', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_ST_BASE_LO (27717, 27720) */
	'C', 'P', '_', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_ST_BASE_HI (27731, 27734) */
	'C', 'P', '_', 'S', 'T', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_ST_BUFSZ (27745, 27748) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'E', 'V', 'E', 'N', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* CP_EOP_DONE_EVENT_CNTL (27757) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'A', 'T', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* CP_EOP_DONE_DATA_CNTL (27780) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'C', 'N', 'T', 'X', '_', 'I', 'D', '\0', /* CP_EOP_DONE_CNTX_ID (27802, 27814) */
	'C', 'P', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_DB_BASE_LO (27822, 27825) */
	'C', 'P', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_DB_BASE_HI (27836, 27839) */
	'C', 'P', '_', 'D', 'B', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_DB_BUFSZ (27850, 27853) */
	'C', 'P', '_', 'D', 'B', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_DB_CMD_BUFSZ (27862) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_DB_BASE_LO (27878) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_DB_BASE_HI (27895) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_DB_BUFSZ (27912) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_DB_CMD_BUFSZ (27927) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'I', 'O', 'N', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_PFP_COMPLETION_STATUS (27946) */
	'C', 'P', '_', 'C', 'E', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'I', 'O', 'N', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_CE_COMPLETION_STATUS (27971) */
	'C', 'P', '_', 'P', 'R', 'E', 'D', '_', 'N', 'O', 'T', '_', 'V', 'I', 'S', 'I', 'B', 'L', 'E', '\0', /* CP_PRED_NOT_VISIBLE (27995, 28003) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* CP_PFP_METADATA_BASE_ADDR (28015) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_PFP_METADATA_BASE_ADDR_HI (28041) */
	'C', 'P', '_', 'C', 'E', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* CP_CE_METADATA_BASE_ADDR (28070) */
	'C', 'P', '_', 'C', 'E', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_CE_METADATA_BASE_ADDR_HI (28095) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'X', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DRAW_INDX_INDR_ADDR (28123) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'X', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DRAW_INDX_INDR_ADDR_HI (28146) */
	'C', 'P', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DISPATCH_INDR_ADDR (28172) */
	'C', 'P', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DISPATCH_INDR_ADDR_HI (28194) */
	'C', 'P', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* CP_INDEX_BASE_ADDR (28219) */
	'C', 'P', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_INDEX_BASE_ADDR_HI (28238) */
	'C', 'P', '_', 'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* CP_INDEX_TYPE (28260) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'B', 'K', 'U', 'P', '_', 'A', 'D', 'D', 'R', '\0', /* CP_GDS_BKUP_ADDR (28274) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'B', 'K', 'U', 'P', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_GDS_BKUP_ADDR_HI (28291) */
	'C', 'P', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_SAMPLE_STATUS (28311) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* CP_ME_COHER_CNTL (28328) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* CP_ME_COHER_SIZE (28345) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', 'H', 'I', '\0', /* CP_ME_COHER_SIZE_HI (28362) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* CP_ME_COHER_BASE (28382) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_ME_COHER_BASE_HI (28399) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_ME_COHER_STATUS (28419) */
	'R', 'L', 'C', '_', 'G', 'P', 'M', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', '_', '0', '\0', /* RLC_GPM_PERF_COUNT_0 (28438) */
	'R', 'L', 'C', '_', 'G', 'P', 'M', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', '_', '1', '\0', /* RLC_GPM_PERF_COUNT_1 (28459) */
	'G', 'R', 'B', 'M', '_', 'G', 'F', 'X', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* GRBM_GFX_INDEX (28480) */
	'V', 'G', 'T', '_', 'E', 'S', 'G', 'S', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_ESGS_RING_SIZE (28495) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_GSVS_RING_SIZE (28514) */
	'V', 'G', 'T', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_PRIMITIVE_TYPE (28533) */
	'V', 'G', 'T', '_', 'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_INDEX_TYPE (28552) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '0', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_0 (28567) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '1', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_1 (28600) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '2', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_2 (28633) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '3', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_3 (28666) */
	'G', 'E', '_', 'M', 'I', 'N', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* GE_MIN_VTX_INDX (28699) */
	'G', 'E', '_', 'I', 'N', 'D', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* GE_INDX_OFFSET (28715) */
	'G', 'E', '_', 'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'R', 'E', 'S', 'E', 'T', '_', 'E', 'N', '\0', /* GE_MULTI_PRIM_IB_RESET_EN (28730) */
	'V', 'G', 'T', '_', 'N', 'U', 'M', '_', 'I', 'N', 'D', 'I', 'C', 'E', 'S', '\0', /* VGT_NUM_INDICES (28756) */
	'V', 'G', 'T', '_', 'N', 'U', 'M', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', 'S', '\0', /* VGT_NUM_INSTANCES (28772) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_TF_RING_SIZE (28790) */
	'V', 'G', 'T', '_', 'H', 'S', '_', 'O', 'F', 'F', 'C', 'H', 'I', 'P', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* VGT_HS_OFFCHIP_PARAM (28807) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'M', 'E', 'M', 'O', 'R', 'Y', '_', 'B', 'A', 'S', 'E', '\0', /* VGT_TF_MEMORY_BASE (28828) */
	'G', 'E', '_', 'D', 'M', 'A', '_', 'F', 'I', 'R', 'S', 'T', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* GE_DMA_FIRST_INDEX (28847) */
	'W', 'D', '_', 'P', 'O', 'S', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '\0', /* WD_POS_BUF_BASE (28866) */
	'W', 'D', '_', 'P', 'O', 'S', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* WD_POS_BUF_BASE_HI (28882) */
	'W', 'D', '_', 'C', 'N', 'T', 'L', '_', 'S', 'B', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '\0', /* WD_CNTL_SB_BUF_BASE (28901) */
	'W', 'D', '_', 'C', 'N', 'T', 'L', '_', 'S', 'B', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* WD_CNTL_SB_BUF_BASE_HI (28921) */
	'W', 'D', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '\0', /* WD_INDEX_BUF_BASE (28944) */
	'W', 'D', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* WD_INDEX_BUF_BASE_HI (28962) */
	'I', 'A', '_', 'M', 'U', 'L', 'T', 'I', '_', 'V', 'G', 'T', '_', 'P', 'A', 'R', 'A', 'M', '_', 'P', 'I', 'P', 'E', 'D', '\0', /* IA_MULTI_VGT_PARAM_PIPED (28983) */
	'G', 'E', '_', 'M', 'A', 'X', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* GE_MAX_VTX_INDX (29008) */
	'V', 'G', 'T', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'B', 'A', 'S', 'E', '_', 'I', 'D', '\0', /* VGT_INSTANCE_BASE_ID (29024, 29039) */
	'G', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* GE_CNTL (29045) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '1', '\0', /* GE_USER_VGPR1 (29053) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '2', '\0', /* GE_USER_VGPR2 (29067) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '3', '\0', /* GE_USER_VGPR3 (29081) */
	'G', 'E', '_', 'S', 'T', 'E', 'R', 'E', 'O', '_', 'C', 'N', 'T', 'L', '\0', /* GE_STEREO_CNTL (29095) */
	'G', 'E', '_', 'P', 'C', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* GE_PC_ALLOC (29110) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'M', 'E', 'M', 'O', 'R', 'Y', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* VGT_TF_MEMORY_BASE_HI (29122) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '_', 'E', 'N', '\0', /* GE_USER_VGPR_EN (29144) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'V', 'A', 'L', 'U', 'E', '\0', /* PA_SU_LINE_STIPPLE_VALUE (29160, 29166, 29179) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* PA_SC_LINE_STIPPLE_STATE (29185) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'I', 'N', '_', '0', '\0', /* PA_SC_SCREEN_EXTENT_MIN_0 (29210) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'A', 'X', '_', '0', '\0', /* PA_SC_SCREEN_EXTENT_MAX_0 (29236) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'I', 'N', '_', '1', '\0', /* PA_SC_SCREEN_EXTENT_MIN_1 (29262) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'A', 'X', '_', '1', '\0', /* PA_SC_SCREEN_EXTENT_MAX_1 (29288) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', 'V', '_', 'E', 'N', '\0', /* PA_SC_P3D_TRAP_SCREEN_HV_EN (29314) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', '\0', /* PA_SC_P3D_TRAP_SCREEN_H (29342) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'V', '\0', /* PA_SC_P3D_TRAP_SCREEN_V (29366) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'C', 'C', 'U', 'R', 'R', 'E', 'N', 'C', 'E', '\0', /* PA_SC_P3D_TRAP_SCREEN_OCCURRENCE (29390) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PA_SC_P3D_TRAP_SCREEN_COUNT (29423) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', 'V', '_', 'E', 'N', '\0', /* PA_SC_HP3D_TRAP_SCREEN_HV_EN (29451) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', '\0', /* PA_SC_HP3D_TRAP_SCREEN_H (29480) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'V', '\0', /* PA_SC_HP3D_TRAP_SCREEN_V (29505) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'C', 'C', 'U', 'R', 'R', 'E', 'N', 'C', 'E', '\0', /* PA_SC_HP3D_TRAP_SCREEN_OCCURRENCE (29530) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PA_SC_HP3D_TRAP_SCREEN_COUNT (29564) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', 'V', '_', 'E', 'N', '\0', /* PA_SC_TRAP_SCREEN_HV_EN (29593) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', '\0', /* PA_SC_TRAP_SCREEN_H (29617) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'V', '\0', /* PA_SC_TRAP_SCREEN_V (29637) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'C', 'C', 'U', 'R', 'R', 'E', 'N', 'C', 'E', '\0', /* PA_SC_TRAP_SCREEN_OCCURRENCE (29657) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PA_SC_TRAP_SCREEN_COUNT (29686) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '0', '\0', /* SQ_THREAD_TRACE_USERDATA_0 (29710) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '1', '\0', /* SQ_THREAD_TRACE_USERDATA_1 (29737) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '2', '\0', /* SQ_THREAD_TRACE_USERDATA_2 (29764) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '3', '\0', /* SQ_THREAD_TRACE_USERDATA_3 (29791) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '4', '\0', /* SQ_THREAD_TRACE_USERDATA_4 (29818) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '5', '\0', /* SQ_THREAD_TRACE_USERDATA_5 (29845) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '6', '\0', /* SQ_THREAD_TRACE_USERDATA_6 (29872) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '7', '\0', /* SQ_THREAD_TRACE_USERDATA_7 (29899) */
	'S', 'Q', 'C', '_', 'C', 'A', 'C', 'H', 'E', 'S', '\0', /* SQC_CACHES (29926) */
	'S', 'Q', 'C', '_', 'W', 'R', 'I', 'T', 'E', 'B', 'A', 'C', 'K', '\0', /* SQC_WRITEBACK (29937, 29941) */
	'T', 'A', '_', 'C', 'S', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* TA_CS_BC_BASE_ADDR (29951) */
	'T', 'A', '_', 'C', 'S', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* TA_CS_BC_BASE_ADDR_HI (29970) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT0_LOW (29992) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT0_HI (30016) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT1_LOW (30039) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT1_HI (30063) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT2_LOW (30086) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT2_HI (30110) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT3_LOW (30133) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT3_HI (30157) */
	'D', 'B', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', 'W', '\0', /* DB_ZPASS_COUNT_LOW (30180) */
	'D', 'B', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* DB_ZPASS_COUNT_HI (30199) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_RD_ADDR (30217) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_RD_DATA (30229) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'B', 'U', 'R', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_RD_BURST_ADDR (30241) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'B', 'U', 'R', 'S', 'T', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* GDS_RD_BURST_COUNT (30259) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'B', 'U', 'R', 'S', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_RD_BURST_DATA (30278) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_WR_ADDR (30296) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_WR_DATA (30308) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'B', 'U', 'R', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_WR_BURST_ADDR (30320) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'B', 'U', 'R', 'S', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_WR_BURST_DATA (30338) */
	'G', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'E', '\0', /* GDS_WRITE_COMPLETE (30356, 30366) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'C', 'N', 'T', 'L', '\0', /* GDS_ATOM_CNTL (30375) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'E', '\0', /* GDS_ATOM_COMPLETE (30389) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'B', 'A', 'S', 'E', '\0', /* GDS_ATOM_BASE (30407) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'I', 'Z', 'E', '\0', /* GDS_ATOM_SIZE (30421) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'O', 'F', 'F', 'S', 'E', 'T', '0', '\0', /* GDS_ATOM_OFFSET0 (30435, 30444) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'O', 'F', 'F', 'S', 'E', 'T', '1', '\0', /* GDS_ATOM_OFFSET1 (30452, 30461) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'D', 'S', 'T', '\0', /* GDS_ATOM_DST (30469, 30478) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'O', 'P', '\0', /* GDS_ATOM_OP (30482) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '0', '\0', /* GDS_ATOM_SRC0 (30494, 30503) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '0', '_', 'U', '\0', /* GDS_ATOM_SRC0_U (30508) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '1', '\0', /* GDS_ATOM_SRC1 (30524) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '1', '_', 'U', '\0', /* GDS_ATOM_SRC1_U (30538) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '0', '\0', /* GDS_ATOM_READ0 (30554) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '0', '_', 'U', '\0', /* GDS_ATOM_READ0_U (30569) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '1', '\0', /* GDS_ATOM_READ1 (30586) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '1', '_', 'U', '\0', /* GDS_ATOM_READ1_U (30601) */
	'G', 'D', 'S', '_', 'G', 'W', 'S', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* GDS_GWS_RESOURCE_CNTL (30618) */
	'G', 'D', 'S', '_', 'G', 'W', 'S', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '\0', /* GDS_GWS_RESOURCE (30640, 30650) */
	'G', 'D', 'S', '_', 'G', 'W', 'S', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'C', 'N', 'T', '\0', /* GDS_GWS_RESOURCE_CNT (30657, 30665) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* GDS_OA_CNTL (30678) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* GDS_OA_COUNTER (30690) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '\0', /* GDS_OA_ADDRESS (30705, 30712) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'I', 'N', 'C', 'D', 'E', 'C', '\0', /* GDS_OA_INCDEC (30720, 30727) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* GDS_OA_RING_SIZE (30734) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_CONFIG_CNTL_REMAP (30751) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '1', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_CONFIG_CNTL_1_REMAP (30773) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '2', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_CONFIG_CNTL_2_REMAP (30797) */
	'S', 'P', 'I', '_', 'W', 'A', 'V', 'E', '_', 'L', 'I', 'M', 'I', 'T', '_', 'C', 'N', 'T', 'L', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_WAVE_LIMIT_CNTL_REMAP (30821) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CPG_PERFCOUNTER1_LO (30847) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CPG_PERFCOUNTER1_HI (30867) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CPG_PERFCOUNTER0_LO (30887) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CPG_PERFCOUNTER0_HI (30907) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CPC_PERFCOUNTER1_LO (30927, 30928) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CPC_PERFCOUNTER1_HI (30947, 30948) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CPC_PERFCOUNTER0_LO (30967, 30968) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CPC_PERFCOUNTER0_HI (30987, 30988) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CPF_PERFCOUNTER1_LO (31007) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CPF_PERFCOUNTER1_HI (31027) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CPF_PERFCOUNTER0_LO (31047) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CPF_PERFCOUNTER0_HI (31067) */
	'C', 'P', 'F', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'A', 'T', 'A', '\0', /* CPF_LATENCY_STATS_DATA (31087) */
	'C', 'P', 'G', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'A', 'T', 'A', '\0', /* CPG_LATENCY_STATS_DATA (31110) */
	'C', 'P', 'C', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'A', 'T', 'A', '\0', /* CPC_LATENCY_STATS_DATA (31133) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GRBM_PERFCOUNTER0_LO (31156) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER0_HI (31177) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GRBM_PERFCOUNTER1_LO (31198) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER1_HI (31219) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE0_PERFCOUNTER_LO (31240) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE0_PERFCOUNTER_HI (31264, 31273, 31277) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE1_PERFCOUNTER_LO (31288) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE1_PERFCOUNTER_HI (31312) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE2_PERFCOUNTER_LO (31336) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE2_PERFCOUNTER_HI (31360) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE3_PERFCOUNTER_LO (31384) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE3_PERFCOUNTER_HI (31408) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER0_LO (31432) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER0_HI (31451) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER1_LO (31470) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER1_HI (31489) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER2_LO (31508) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER2_HI (31527) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER3_LO (31546) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER3_HI (31565) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER4_LO (31584) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER4_HI (31603) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER5_LO (31622) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER5_HI (31641) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER6_LO (31660) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER6_HI (31679) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER7_LO (31698) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER7_HI (31717) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER8_LO (31736) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER8_HI (31755) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER9_LO (31774) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER9_HI (31793) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER10_LO (31812) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER10_HI (31832) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER11_LO (31852) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER11_HI (31872) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER0_LO (31892) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER0_HI (31914) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER1_LO (31936) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER1_HI (31958) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER2_LO (31980) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER2_HI (32002) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER3_LO (32024) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER3_HI (32046) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER0_LO (32068) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER0_HI (32090) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER1_LO (32112) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER1_HI (32134) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER2_LO (32156) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER2_HI (32178) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER3_LO (32200) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER3_HI (32222) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER4_LO (32244) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER4_HI (32266) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER5_LO (32288) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER5_HI (32310) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER6_LO (32332) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER6_HI (32354) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER7_LO (32376) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER7_HI (32398) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER0_HI (32420) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER0_LO (32440) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER1_HI (32460) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER1_LO (32480) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER2_HI (32500) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER2_LO (32520) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER3_HI (32540) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER3_LO (32560) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER4_HI (32580) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER4_LO (32600) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER5_HI (32620) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER5_LO (32640) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER0_LO (32660) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER0_HI (32679) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER1_LO (32698) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER1_HI (32717) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER2_LO (32736) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER2_HI (32755) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER3_LO (32774) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER3_HI (32793) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER4_LO (32812) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER4_HI (32831) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER5_LO (32850) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER5_HI (32869) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER6_LO (32888) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER6_HI (32907) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER7_LO (32926) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER7_HI (32945) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER8_LO (32964) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER8_HI (32983) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER9_LO (33002) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER9_HI (33021) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER10_LO (33040) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER10_HI (33060) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER11_LO (33080) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER11_HI (33100) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '2', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER12_LO (33120) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '2', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER12_HI (33140) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '3', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER13_LO (33160) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '3', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER13_HI (33180) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '4', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER14_LO (33200) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '4', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER14_HI (33220) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '5', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER15_LO (33240) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '5', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER15_HI (33260) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER0_LO (33280) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER0_HI (33299) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER1_LO (33318) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER1_HI (33337) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER2_LO (33356) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER2_HI (33375) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER3_LO (33394) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER3_HI (33413) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GCEA_PERFCOUNTER2_LO (33432) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GCEA_PERFCOUNTER2_HI (33453) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER0_LO (33474) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER0_HI (33494) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER1_LO (33514) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER1_HI (33534) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER2_LO (33554) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER2_HI (33574) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER3_LO (33594) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER3_HI (33614) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TA_PERFCOUNTER0_LO (33634) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TA_PERFCOUNTER0_HI (33653) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TA_PERFCOUNTER1_LO (33672) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TA_PERFCOUNTER1_HI (33691) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TD_PERFCOUNTER0_LO (33710) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TD_PERFCOUNTER0_HI (33729) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TD_PERFCOUNTER1_LO (33748) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TD_PERFCOUNTER1_HI (33767) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER0_LO (33786) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER0_HI (33806) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER1_LO (33826) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER1_HI (33846) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER2_LO (33866) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER2_HI (33886) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER3_LO (33906) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER3_HI (33926) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER0_LO (33946) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER0_HI (33967) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER1_LO (33988) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER1_HI (34009) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER2_LO (34030) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER2_HI (34051) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER3_LO (34072) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER3_HI (34093) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER0_LO (34114) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER0_HI (34135) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER1_LO (34156) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER1_HI (34177) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER2_LO (34198) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER2_HI (34219) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER3_LO (34240) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER3_HI (34261) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER0_LO (34282) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER0_HI (34303) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER1_LO (34324) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER1_HI (34345) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER2_LO (34366) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER2_HI (34387) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER3_LO (34408) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER3_HI (34429) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER0_LO (34450) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER0_HI (34470) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER1_LO (34490) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER1_HI (34510) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER2_LO (34530) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER2_HI (34550) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER3_LO (34570) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER3_HI (34590) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER0_LO (34610) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER0_HI (34631) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER1_LO (34652) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER1_HI (34673) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER2_LO (34694) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER2_HI (34715) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER3_LO (34736) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER3_HI (34757) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER0_LO (34778) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER0_HI (34797) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER1_LO (34816) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER1_HI (34835) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER2_LO (34854) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER2_HI (34873) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER3_LO (34892) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER3_HI (34911) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER0_LO (34930) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER0_HI (34949) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER1_LO (34968) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER1_HI (34987) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER2_LO (35006) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER2_HI (35025) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER3_LO (35044) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER3_HI (35063) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* RLC_PERFCOUNTER0_LO (35082) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* RLC_PERFCOUNTER0_HI (35102) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* RLC_PERFCOUNTER1_LO (35122) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* RLC_PERFCOUNTER1_HI (35142) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER0_LO (35162) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER0_HI (35182) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER1_LO (35202) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER1_HI (35222) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER2_LO (35242) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER2_HI (35262) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER3_LO (35282) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER3_HI (35302) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GC_ATC_L2_PERFCOUNTER_LO (35322, 35325) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GC_ATC_L2_PERFCOUNTER_HI (35347, 35350) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCMC_VM_L2_PERFCOUNTER_LO (35372, 35374) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCMC_VM_L2_PERFCOUNTER_HI (35398, 35400) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'L', 'O', '\0', /* GCVML2_PERFCOUNTER2_0_LO (35424) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'L', 'O', '\0', /* GCVML2_PERFCOUNTER2_1_LO (35449) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'H', 'I', '\0', /* GCVML2_PERFCOUNTER2_0_HI (35474) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'H', 'I', '\0', /* GCVML2_PERFCOUNTER2_1_HI (35499) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GC_ATC_L2_PERFCOUNTER2_LO (35524) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GC_ATC_L2_PERFCOUNTER2_HI (35550) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER0_LO (35576) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER0_HI (35598) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER1_LO (35620) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER1_HI (35642) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GCR_PERFCOUNTER0_LO (35664) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GCR_PERFCOUNTER0_HI (35684) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GCR_PERFCOUNTER1_LO (35704) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GCR_PERFCOUNTER1_HI (35724) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER0_LO (35744) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER0_HI (35766) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER1_LO (35788) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER1_HI (35810) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER2_LO (35832) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER2_HI (35854) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER3_LO (35876) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER3_HI (35898) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER4_LO (35920) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER4_HI (35942) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER5_LO (35964) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER5_HI (35986) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER6_LO (36008) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER6_HI (36030) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER7_LO (36052) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER7_HI (36074) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER0_LO (36096) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER0_HI (36117) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER1_LO (36138) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER1_HI (36159) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER2_LO (36180) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER2_HI (36201) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER3_LO (36222) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER3_HI (36243) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER0_LO (36264) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER0_HI (36284) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER1_LO (36304) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER1_HI (36324) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER2_LO (36344) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER2_HI (36364) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER3_LO (36384) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER3_HI (36404) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GUS_PERFCOUNTER2_LO (36424) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GUS_PERFCOUNTER2_HI (36444) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_PERFCOUNTER1_SELECT (36464) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CPG_PERFCOUNTER0_SELECT1 (36488) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_PERFCOUNTER0_SELECT (36513) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_PERFCOUNTER1_SELECT (36537, 36538) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CPC_PERFCOUNTER0_SELECT1 (36561, 36562) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_PERFCOUNTER1_SELECT (36586) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CPF_PERFCOUNTER0_SELECT1 (36610) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_PERFCOUNTER0_SELECT (36635) */
	'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* CP_PERFMON_CNTL (36659) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_PERFCOUNTER0_SELECT (36675, 36676) */
	'C', 'P', 'F', '_', 'T', 'C', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_TC_PERF_COUNTER_WINDOW_SELECT (36699) */
	'C', 'P', 'G', '_', 'T', 'C', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_TC_PERF_COUNTER_WINDOW_SELECT (36733) */
	'C', 'P', 'F', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_LATENCY_STATS_SELECT (36767, 36782) */
	'C', 'P', 'G', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_LATENCY_STATS_SELECT (36792) */
	'C', 'P', 'C', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_LATENCY_STATS_SELECT (36817) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'O', 'B', 'J', 'E', 'C', 'T', '\0', /* CP_DRAW_OBJECT (36842) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'O', 'B', 'J', 'E', 'C', 'T', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* CP_DRAW_OBJECT_COUNTER (36857) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'M', 'A', 'S', 'K', '_', 'H', 'I', '\0', /* CP_DRAW_WINDOW_MASK_HI (36880) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'H', 'I', '\0', /* CP_DRAW_WINDOW_HI (36903) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'L', 'O', '\0', /* CP_DRAW_WINDOW_LO (36921) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'C', 'N', 'T', 'L', '\0', /* CP_DRAW_WINDOW_CNTL (36939) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_PERFCOUNTER0_SELECT (36959) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_PERFCOUNTER1_SELECT (36984) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE0_PERFCOUNTER_SELECT (37009, 37018) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE1_PERFCOUNTER_SELECT (37037) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE2_PERFCOUNTER_SELECT (37065) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE3_PERFCOUNTER_SELECT (37093) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER0_SELECT_HI (37121) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER1_SELECT_HI (37149) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER0_SELECT (37177) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER0_SELECT1 (37200) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER1_SELECT (37224) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER1_SELECT1 (37247) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER2_SELECT (37271) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER2_SELECT1 (37294) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER3_SELECT (37318) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER3_SELECT1 (37341) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER4_SELECT (37365) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER5_SELECT (37388) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER6_SELECT (37411) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER7_SELECT (37434) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER8_SELECT (37457) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER9_SELECT (37480) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER10_SELECT (37503) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER11_SELECT (37527) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER0_SELECT (37551) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER0_SELECT1 (37577) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER1_SELECT (37604) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER1_SELECT1 (37630) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER2_SELECT (37657) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER2_SELECT1 (37683) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER3_SELECT (37710) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER3_SELECT1 (37736) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER0_SELECT (37763) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SC_PERFCOUNTER0_SELECT1 (37789) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER1_SELECT (37816) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER2_SELECT (37842) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER3_SELECT (37868) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER4_SELECT (37894) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER5_SELECT (37920) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER6_SELECT (37946) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER7_SELECT (37972) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER0_SELECT (37998) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER1_SELECT (38022) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER2_SELECT (38046) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER3_SELECT (38070) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER0_SELECT1 (38094) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER1_SELECT1 (38119) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER2_SELECT1 (38144) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER3_SELECT1 (38169) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER4_SELECT (38194) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER5_SELECT (38218) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'B', 'I', 'N', 'S', '\0', /* SPI_PERFCOUNTER_BINS (38242) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER0_SELECT (38263) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER1_SELECT (38286) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER2_SELECT (38309) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER3_SELECT (38332) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER4_SELECT (38355) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER5_SELECT (38378) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER6_SELECT (38401) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER7_SELECT (38424) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER8_SELECT (38447) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER9_SELECT (38470) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER10_SELECT (38493) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER11_SELECT (38517) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER12_SELECT (38541) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER13_SELECT (38565) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER14_SELECT (38589) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER15_SELECT (38613) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_PERFCOUNTER_CTRL (38637) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '2', '\0', /* SQ_PERFCOUNTER_CTRL2 (38657) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCEA_PERFCOUNTER2_SELECT (38678) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCEA_PERFCOUNTER2_SELECT1 (38703) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'M', 'O', 'D', 'E', '\0', /* GCEA_PERFCOUNTER2_MODE (38729) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER0_SELECT (38752) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER1_SELECT (38775) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER2_SELECT (38798) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER3_SELECT (38821) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SX_PERFCOUNTER0_SELECT1 (38844) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SX_PERFCOUNTER1_SELECT1 (38868) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER0_SELECT (38892) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER1_SELECT (38916) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER2_SELECT (38940) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER3_SELECT (38964) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER0_SELECT1 (38988) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TA_PERFCOUNTER0_SELECT (39013) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TA_PERFCOUNTER0_SELECT1 (39036) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TA_PERFCOUNTER1_SELECT (39060) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TD_PERFCOUNTER0_SELECT (39083) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TD_PERFCOUNTER0_SELECT1 (39106) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TD_PERFCOUNTER1_SELECT (39130) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER0_SELECT (39153) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCP_PERFCOUNTER0_SELECT1 (39177) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER1_SELECT (39202) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCP_PERFCOUNTER1_SELECT1 (39226) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER2_SELECT (39251) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER3_SELECT (39275) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER0_SELECT (39299) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2C_PERFCOUNTER0_SELECT1 (39324) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER1_SELECT (39350) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2C_PERFCOUNTER1_SELECT1 (39375) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER2_SELECT (39401) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER3_SELECT (39426) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER0_SELECT (39451) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2A_PERFCOUNTER0_SELECT1 (39476) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER1_SELECT (39502) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2A_PERFCOUNTER1_SELECT1 (39527) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER2_SELECT (39553) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER3_SELECT (39578) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER0_SELECT (39603) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1C_PERFCOUNTER0_SELECT1 (39628) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER1_SELECT (39654) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER2_SELECT (39679) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER3_SELECT (39704) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER0_SELECT (39729) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHC_PERFCOUNTER0_SELECT1 (39753) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER1_SELECT (39778) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER2_SELECT (39802) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER3_SELECT (39826) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER0_SELECT (39850) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHCG_PERFCOUNTER0_SELECT1 (39875) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER1_SELECT (39901) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER2_SELECT (39926) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER3_SELECT (39951) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* CB_PERFCOUNTER_FILTER (39976) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER0_SELECT (39998) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CB_PERFCOUNTER0_SELECT1 (40021) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER1_SELECT (40045) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER2_SELECT (40068) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER3_SELECT (40091) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER0_SELECT (40114) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* DB_PERFCOUNTER0_SELECT1 (40137) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER1_SELECT (40161) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* DB_PERFCOUNTER1_SELECT1 (40184) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER2_SELECT (40208) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER3_SELECT (40231) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_SPM_PERFMON_CNTL (40254) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'R', 'I', 'N', 'G', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* RLC_SPM_PERFMON_RING_BASE_LO (40275) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'R', 'I', 'N', 'G', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* RLC_SPM_PERFMON_RING_BASE_HI (40304, 40320) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_RING_SIZE (40333) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SEGMENT_SIZE (40359, 40367) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'I', 'N', 'G', '_', 'R', 'D', 'P', 'T', 'R', '\0', /* RLC_SPM_RING_RDPTR (40388) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* RLC_SPM_SEGMENT_THRESHOLD (40407, 40423) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_SE_MUXSEL_ADDR (40433) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_SE_MUXSEL_DATA (40456) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_GLOBAL_MUXSEL_ADDR (40479) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_GLOBAL_MUXSEL_DATA (40506) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'E', 'S', 'E', 'R', '_', 'S', 'T', 'A', 'R', 'T', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_DESER_START_SKEW (40533, 40541) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', 'S', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_GLOBALS_SAMPLE_SKEW (40558, 40566) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', 'S', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_GLOBALS_MUXSEL_SKEW (40586, 40594) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_SE_SAMPLE_SKEW (40614, 40622) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_SE_MUXSEL_SKEW (40637, 40645) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'B', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_GLB_SAMPLEDELAY_IND_ADDR (40660) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'B', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_GLB_SAMPLEDELAY_IND_DATA (40693) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_SE_SAMPLEDELAY_IND_ADDR (40726) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_SE_SAMPLEDELAY_IND_DATA (40758) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'I', 'N', 'G', '_', 'W', 'R', 'P', 'T', 'R', '\0', /* RLC_SPM_RING_WRPTR (40790) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_ACCUM_DATARAM_ADDR (40809) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_ACCUM_DATARAM_DATA (40836) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_ACCUM_CTRLRAM_ADDR (40863) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', 'R', 'A', 'M', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_ACCUM_CTRLRAM_DATA (40890) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* RLC_SPM_ACCUM_STATUS (40917) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', '\0', /* RLC_SPM_ACCUM_CTRL (40938) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'M', 'O', 'D', 'E', '\0', /* RLC_SPM_ACCUM_MODE (40957) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* RLC_SPM_ACCUM_THRESHOLD (40976) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '_', 'R', 'E', 'Q', 'U', 'E', 'S', 'T', 'E', 'D', '\0', /* RLC_SPM_ACCUM_SAMPLES_REQUESTED (41000) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'W', 'R', 'C', 'O', 'U', 'N', 'T', '\0', /* RLC_SPM_ACCUM_DATARAM_WRCOUNT (41032) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'E', '3', 'T', 'O', '0', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SE3TO0_SEGMENT_SIZE (41062) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'G', 'L', 'B', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_GLB_SEGMENT_SIZE (41098) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'V', 'I', 'R', 'T', '_', 'C', 'T', 'R', 'L', '\0', /* RLC_SPM_VIRT_CTRL (41131) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'V', 'I', 'R', 'T', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* RLC_SPM_VIRT_STATUS (41149) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_PERFMON_CNTL (41169) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RLC_PERFCOUNTER0_SELECT (41186) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RLC_PERFCOUNTER1_SELECT (41210) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_GPU_IOV_PERF_CNT_CNTL (41234) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'W', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_GPU_IOV_PERF_CNT_WR_ADDR (41260) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'W', 'R', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_GPU_IOV_PERF_CNT_WR_DATA (41289) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'R', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_GPU_IOV_PERF_CNT_RD_ADDR (41318) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'R', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_GPU_IOV_PERF_CNT_RD_DATA (41347) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'L', 'K', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_PERFMON_CLK_CNTL (41376) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'L', 'K', '_', 'C', 'N', 'T', 'L', '_', 'U', 'C', 'O', 'D', 'E', '\0', /* RLC_PERFMON_CLK_CNTL_UCODE (41397) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER0_SELECT (41424) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* RMI_PERFCOUNTER0_SELECT1 (41448) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER1_SELECT (41473) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER2_SELECT (41497) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* RMI_PERFCOUNTER2_SELECT1 (41521) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER3_SELECT (41546) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* RMI_PERF_COUNTER_CNTL (41570) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GC_ATC_L2_PERFCOUNTER0_CFG (41592, 41595) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GC_ATC_L2_PERFCOUNTER1_CFG (41619, 41622) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GC_ATC_L2_PERFCOUNTER_RSLT_CNTL (41646, 41649) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER0_CFG (41678, 41680) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER1_CFG (41706, 41708) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER2_CFG (41734, 41736) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER3_CFG (41762, 41764) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER4_CFG (41790, 41792) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER5_CFG (41818, 41820) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER6_CFG (41846, 41848) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER7_CFG (41874, 41876) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCMC_VM_L2_PERFCOUNTER_RSLT_CNTL (41902, 41904) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCVML2_PERFCOUNTER2_0_SELECT (41935) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCVML2_PERFCOUNTER2_1_SELECT (41964) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCVML2_PERFCOUNTER2_0_SELECT1 (41993) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCVML2_PERFCOUNTER2_1_SELECT1 (42023) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'M', 'O', 'D', 'E', '\0', /* GCVML2_PERFCOUNTER2_0_MODE (42053) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'M', 'O', 'D', 'E', '\0', /* GCVML2_PERFCOUNTER2_1_MODE (42080) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GC_ATC_L2_PERFCOUNTER2_SELECT (42107) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GC_ATC_L2_PERFCOUNTER2_SELECT1 (42137) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'M', 'O', 'D', 'E', '\0', /* GC_ATC_L2_PERFCOUNTER2_MODE (42168) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCR_PERFCOUNTER0_SELECT (42196) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCR_PERFCOUNTER0_SELECT1 (42220) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCR_PERFCOUNTER1_SELECT (42245) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER0_SELECT (42269) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER1_SELECT (42295) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER0_SELECT (42321) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER0_SELECT1 (42347) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER1_SELECT (42374) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER2_SELECT (42400) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER3_SELECT (42426) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER4_SELECT (42452) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER5_SELECT (42478) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER6_SELECT (42504) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER7_SELECT (42530) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER1_SELECT1 (42556) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER2_SELECT1 (42583) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER3_SELECT1 (42610) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER0_SELECT (42637) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1A_PERFCOUNTER0_SELECT1 (42662) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER1_SELECT (42688) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER2_SELECT (42713) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER3_SELECT (42738) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER0_SELECT (42763) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHA_PERFCOUNTER0_SELECT1 (42787) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER1_SELECT (42812) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER2_SELECT (42836) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER3_SELECT (42860) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GUS_PERFCOUNTER2_SELECT (42884) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GUS_PERFCOUNTER2_SELECT1 (42908) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'M', 'O', 'D', 'E', '\0', /* GUS_PERFCOUNTER2_MODE (42933) */
	'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* DST_ADDR_LO (42955) */
	'I', 'B', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* IB_BASE_LO (42967) */
	'I', 'B', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* IB_BASE_HI (42978) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CP_DMA_WORD0 (42989) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CP_DMA_WORD1 (43002) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '2', '\0', /* CP_DMA_WORD2 (43015) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '3', '\0', /* CP_DMA_WORD3 (43028) */
	'R', 'E', 'L', 'E', 'A', 'S', 'E', '_', 'M', 'E', 'M', '_', 'O', 'P', '\0', /* RELEASE_MEM_OP (43041) */
	'D', 'M', 'A', '_', 'D', 'A', 'T', 'A', '_', 'W', 'O', 'R', 'D', '0', '\0', /* DMA_DATA_WORD0 (43056) */
	'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* SRC_ADDR_LO (43071) */
	'G', 'C', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* GCR_CNTL (43083) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* SQ_WAVE_ACTIVE (43092) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'V', 'A', 'L', 'I', 'D', '_', 'A', 'N', 'D', '_', 'I', 'D', 'L', 'E', '\0', /* SQ_WAVE_VALID_AND_IDLE (43107, 43125) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'Y', 'C', 'L', 'E', 'S', '\0', /* SQ_WAVE_SHADER_CYCLES (43130, 43145) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'P', 'R', 'I', 'V', '_', 'V', 'I', 'O', 'L', 'A', 'T', 'I', 'O', 'N', '_', 'A', 'D', 'D', 'R', '\0', /* CP_CPC_PRIV_VIOLATION_ADDR (43152, 43159) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '2', '\0', /* SQ_THREAD_TRACE_STATUS2 (43179) */
	'S', 'H', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '0', '\0', /* SH_RESERVED_REG0 (43203) */
	'S', 'H', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '1', '\0', /* SH_RESERVED_REG1 (43220) */
	'D', 'B', '_', 'V', 'R', 'S', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* DB_VRS_OVERRIDE_CNTL (43237) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '0', '\0', /* CONTEXT_RESERVED_REG0 (43258) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '1', '\0', /* CONTEXT_RESERVED_REG1 (43280) */
	'S', 'X', '_', 'P', 'S', '_', 'D', 'O', 'W', 'N', 'C', 'O', 'N', 'V', 'E', 'R', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* SX_PS_DOWNCONVERT_CONTROL (43302) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'R', 'S', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_VRS_CNTL (43328) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '_', 'A', 'T', 'O', 'M', 'I', 'C', '\0', /* SCRATCH_REG_ATOMIC (43343) */
	'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '0', '\0', /* UCONFIG_RESERVED_REG0 (43362) */
	'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '1', '\0', /* UCONFIG_RESERVED_REG1 (43384) */
	'C', 'P', '_', 'C', 'E', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_CE_ATOMIC_PREOP_LO (43406) */
	'C', 'P', '_', 'C', 'E', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_CE_ATOMIC_PREOP_HI (43428) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_CE_GDS_ATOMIC0_PREOP_LO (43450) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_CE_GDS_ATOMIC0_PREOP_HI (43477) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_CE_GDS_ATOMIC1_PREOP_LO (43504) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_CE_GDS_ATOMIC1_PREOP_HI (43531) */
	'G', 'E', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '\0', /* GE_VRS_RATE (43558, 43561) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER0_LO (43570) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER0_HI (43590) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER1_LO (43610) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER1_HI (43630) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER2_LO (43650) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER2_HI (43670) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER3_LO (43690) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER3_HI (43710) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER0_LO (43730) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER0_HI (43755) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER1_LO (43780) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER1_HI (43805) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER2_LO (43830) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER2_HI (43855) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER3_LO (43880) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER3_HI (43905) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER0_LO (43930) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER0_HI (43953) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER1_LO (43976) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER1_HI (43999) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER2_LO (44022) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER2_HI (44045) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER3_LO (44068) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER3_HI (44091) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCEA_PERFCOUNTER_LO (44114) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCEA_PERFCOUNTER_HI (44134) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCUTCL2_PERFCOUNTER_LO (44154) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCUTCL2_PERFCOUNTER_HI (44177) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GUS_PERFCOUNTER_LO (44200) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GUS_PERFCOUNTER_HI (44219) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA0_PERFCNT_PERFCOUNTER_LO (44238) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA0_PERFCNT_PERFCOUNTER_HI (44267) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA0_PERFCOUNTER0_LO (44296) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA0_PERFCOUNTER0_HI (44318) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA0_PERFCOUNTER1_LO (44340) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA0_PERFCOUNTER1_HI (44362) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA1_PERFCNT_PERFCOUNTER_LO (44384) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA1_PERFCNT_PERFCOUNTER_HI (44413) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA1_PERFCOUNTER0_LO (44442) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA1_PERFCOUNTER0_HI (44464) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA1_PERFCOUNTER1_LO (44486) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA1_PERFCOUNTER1_HI (44508) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA2_PERFCNT_PERFCOUNTER_LO (44530) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA2_PERFCNT_PERFCOUNTER_HI (44559) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA2_PERFCOUNTER0_LO (44588) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA2_PERFCOUNTER0_HI (44610) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA2_PERFCOUNTER1_LO (44632) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA2_PERFCOUNTER1_HI (44654) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA3_PERFCNT_PERFCOUNTER_LO (44676) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA3_PERFCNT_PERFCOUNTER_HI (44705) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA3_PERFCOUNTER0_LO (44734) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA3_PERFCOUNTER0_HI (44756) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA3_PERFCOUNTER1_LO (44778) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA3_PERFCOUNTER1_HI (44800) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER0_SELECT (44822) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER0_SELECT1 (44846) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER1_SELECT (44871) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER1_SELECT1 (44895) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER2_SELECT (44920) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER2_SELECT1 (44944) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER3_SELECT (44969) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER3_SELECT1 (44993) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER0_SELECT (45018) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER0_SELECT1 (45047) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER1_SELECT (45077) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER1_SELECT1 (45106) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER2_SELECT (45136) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER2_SELECT1 (45165) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER3_SELECT (45195) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER3_SELECT1 (45224) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER0_SELECT (45254) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER0_SELECT1 (45281) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER1_SELECT (45309) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER1_SELECT1 (45336) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER2_SELECT (45364) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER2_SELECT1 (45391) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER3_SELECT (45419) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER3_SELECT1 (45446) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCEA_PERFCOUNTER0_CFG (45474) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCEA_PERFCOUNTER1_CFG (45496) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCEA_PERFCOUNTER_RSLT_CNTL (45518) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER1_SELECT1 (45545) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER2_SELECT1 (45570) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER3_SELECT1 (45595) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'W', 'A', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SWA_SEGMENT_SIZE (45620) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'F', 'X', 'C', 'L', 'O', 'C', 'K', '_', 'H', 'I', 'G', 'H', 'C', 'O', 'U', 'N', 'T', '\0', /* RLC_SPM_GFXCLOCK_HIGHCOUNT (45653) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'F', 'X', 'C', 'L', 'O', 'C', 'K', '_', 'L', 'O', 'W', 'C', 'O', 'U', 'N', 'T', '\0', /* RLC_SPM_GFXCLOCK_LOWCOUNT (45680) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'W', 'A', '_', 'S', 'E', '3', 'T', 'O', '0', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SWA_SE3TO0_SEGMENT_SIZE (45706) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RLC_SPM_GLOBAL_MUXSEL_ADDR_OFFSET (45746) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RLC_SPM_SE_MUXSEL_ADDR_OFFSET (45780) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'W', 'A', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_ACCUM_SWA_DATARAM_ADDR (45810) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'W', 'A', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_ACCUM_SWA_DATARAM_DATA (45841) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RLC_SPM_ACCUM_CTRLRAM_ADDR_OFFSET (45872) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'W', 'A', '_', 'G', 'L', 'B', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SWA_GLB_SEGMENT_SIZE (45906) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', '3', '2', 'B', 'I', 'T', 'C', 'N', 'T', 'R', 'S', '_', 'R', 'E', 'G', 'I', 'O', 'N', 'S', '\0', /* RLC_SPM_ACCUM_DATARAM_32BITCNTRS_REGIONS (45943) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER0_CFG (45984) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER1_CFG (46009) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER2_CFG (46034) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER3_CFG (46059) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCUTCL2_PERFCOUNTER_RSLT_CNTL (46084) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GUS_PERFCOUNTER0_CFG (46114) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GUS_PERFCOUNTER1_CFG (46135) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GUS_PERFCOUNTER_RSLT_CNTL (46156) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA0_PERFCNT_PERFCOUNTER0_CFG (46182) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA0_PERFCNT_PERFCOUNTER1_CFG (46213) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL (46244) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA0_PERFCNT_MISC_CNTL (46280) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA0_PERFCOUNTER0_SELECT (46304) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA0_PERFCOUNTER0_SELECT1 (46330) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA0_PERFCOUNTER1_SELECT (46357) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA0_PERFCOUNTER1_SELECT1 (46383) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA1_PERFCNT_PERFCOUNTER0_CFG (46410) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA1_PERFCNT_PERFCOUNTER1_CFG (46441) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL (46472) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA1_PERFCNT_MISC_CNTL (46508) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA1_PERFCOUNTER0_SELECT (46532) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA1_PERFCOUNTER0_SELECT1 (46558) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA1_PERFCOUNTER1_SELECT (46585) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA1_PERFCOUNTER1_SELECT1 (46611) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA2_PERFCNT_PERFCOUNTER0_CFG (46638) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA2_PERFCNT_PERFCOUNTER1_CFG (46669) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA2_PERFCNT_PERFCOUNTER_RSLT_CNTL (46700) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA2_PERFCNT_MISC_CNTL (46736) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA2_PERFCOUNTER0_SELECT (46760) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA2_PERFCOUNTER0_SELECT1 (46786) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA2_PERFCOUNTER1_SELECT (46813) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA2_PERFCOUNTER1_SELECT1 (46839) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA3_PERFCNT_PERFCOUNTER0_CFG (46866) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA3_PERFCNT_PERFCOUNTER1_CFG (46897) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA3_PERFCNT_PERFCOUNTER_RSLT_CNTL (46928) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA3_PERFCNT_MISC_CNTL (46964) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA3_PERFCOUNTER0_SELECT (46988) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA3_PERFCOUNTER0_SELECT1 (47014) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA3_PERFCOUNTER1_SELECT (47041) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA3_PERFCOUNTER1_SELECT1 (47067) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '4', '\0', /* GRBM_STATUS_SE4 (47094) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '5', '\0', /* GRBM_STATUS_SE5 (47110) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CPC_DEBUG_CNTL (47126) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* CP_CPC_DEBUG_DATA (47144, 47151) */
	'G', 'U', 'S', '_', 'I', 'O', '_', 'R', 'D', '_', 'C', 'O', 'M', 'B', 'I', 'N', 'E', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* GUS_IO_RD_COMBINE_FLUSH (47162) */
	'G', 'U', 'S', '_', 'I', 'O', '_', 'R', 'D', '_', 'P', 'R', 'I', '_', 'A', 'G', 'E', '_', 'R', 'A', 'T', 'E', '\0', /* GUS_IO_RD_PRI_AGE_RATE (47186) */
	'G', 'U', 'S', '_', 'I', 'O', '_', 'W', 'R', '_', 'P', 'R', 'I', '_', 'A', 'G', 'E', '_', 'R', 'A', 'T', 'E', '\0', /* GUS_IO_WR_PRI_AGE_RATE (47209) */
	'G', 'U', 'S', '_', 'I', 'O', '_', 'R', 'D', '_', 'P', 'R', 'I', '_', 'A', 'G', 'E', '_', 'C', 'O', 'E', 'F', 'F', '\0', /* GUS_IO_RD_PRI_AGE_COEFF (47232) */
	'G', 'U', 'S', '_', 'I', 'O', '_', 'W', 'R', '_', 'P', 'R', 'I', '_', 'A', 'G', 'E', '_', 'C', 'O', 'E', 'F', 'F', '\0', /* GUS_IO_WR_PRI_AGE_COEFF (47256) */
	'G', 'U', 'S', '_', 'D', 'R', 'A', 'M', '_', 'P', 'R', 'I', '_', 'Q', 'U', 'A', 'N', 'T', '1', '_', 'P', 'R', 'I', '2', '\0', /* GUS_DRAM_PRI_QUANT1_PRI2 (47280) */
	'G', 'U', 'S', '_', 'D', 'R', 'A', 'M', '_', 'P', 'R', 'I', '_', 'Q', 'U', 'A', 'N', 'T', '1', '_', 'P', 'R', 'I', '3', '\0', /* GUS_DRAM_PRI_QUANT1_PRI3 (47305) */
	'G', 'U', 'S', '_', 'D', 'R', 'A', 'M', '_', 'P', 'R', 'I', '_', 'Q', 'U', 'A', 'N', 'T', '1', '_', 'P', 'R', 'I', '4', '\0', /* GUS_DRAM_PRI_QUANT1_PRI4 (47330) */
	'G', 'U', 'S', '_', 'D', 'R', 'A', 'M', '_', 'P', 'R', 'I', '_', 'Q', 'U', 'A', 'N', 'T', '1', '_', 'P', 'R', 'I', '5', '\0', /* GUS_DRAM_PRI_QUANT1_PRI5 (47355) */
	'G', 'U', 'S', '_', 'D', 'R', 'A', 'M', '_', 'G', 'R', 'O', 'U', 'P', '_', 'B', 'U', 'R', 'S', 'T', '\0', /* GUS_DRAM_GROUP_BURST (47380) */
	'G', 'U', 'S', '_', 'S', 'D', 'P', '_', 'T', 'A', 'G', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '1', '\0', /* GUS_SDP_TAG_RESERVE1 (47401) */
	'G', 'U', 'S', '_', 'S', 'D', 'P', '_', 'V', 'C', 'C', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '0', '\0', /* GUS_SDP_VCC_RESERVE0 (47422) */
	'G', 'U', 'S', '_', 'S', 'D', 'P', '_', 'V', 'C', 'C', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '1', '\0', /* GUS_SDP_VCC_RESERVE1 (47443) */
	'G', 'U', 'S', '_', 'S', 'D', 'P', '_', 'V', 'C', 'D', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '0', '\0', /* GUS_SDP_VCD_RESERVE0 (47464) */
	'G', 'U', 'S', '_', 'S', 'D', 'P', '_', 'V', 'C', 'D', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '1', '\0', /* GUS_SDP_VCD_RESERVE1 (47485) */
	'G', 'U', 'S', '_', 'S', 'D', 'P', '_', 'R', 'E', 'Q', '_', 'C', 'N', 'T', 'L', '\0', /* GUS_SDP_REQ_CNTL (47506) */
	'G', 'U', 'S', '_', 'M', 'I', 'S', 'C', '\0', /* GUS_MISC (47523) */
	'G', 'U', 'S', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'A', 'M', 'P', 'L', 'I', 'N', 'G', '\0', /* GUS_LATENCY_SAMPLING (47532) */
	'G', 'U', 'S', '_', 'E', 'R', 'R', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* GUS_ERR_STATUS (47553) */
	'G', 'U', 'S', '_', 'M', 'I', 'S', 'C', '2', '\0', /* GUS_MISC2 (47568) */
	'G', 'U', 'S', '_', 'S', 'D', 'P', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* GUS_SDP_ENABLE (47578) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'C', 'H', '0', '_', 'C', 'M', 'D', '_', 'I', 'N', '\0', /* GUS_L1_CH0_CMD_IN (47593) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'C', 'H', '0', '_', 'C', 'M', 'D', '_', 'O', 'U', 'T', '\0', /* GUS_L1_CH0_CMD_OUT (47611) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'C', 'H', '0', '_', 'D', 'A', 'T', 'A', '_', 'I', 'N', '\0', /* GUS_L1_CH0_DATA_IN (47630) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'C', 'H', '0', '_', 'D', 'A', 'T', 'A', '_', 'O', 'U', 'T', '\0', /* GUS_L1_CH0_DATA_OUT (47649) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'C', 'H', '0', '_', 'D', 'A', 'T', 'A', '_', 'U', '_', 'I', 'N', '\0', /* GUS_L1_CH0_DATA_U_IN (47669) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'C', 'H', '0', '_', 'D', 'A', 'T', 'A', '_', 'U', '_', 'O', 'U', 'T', '\0', /* GUS_L1_CH0_DATA_U_OUT (47690) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'C', 'H', '1', '_', 'C', 'M', 'D', '_', 'I', 'N', '\0', /* GUS_L1_CH1_CMD_IN (47712) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'C', 'H', '1', '_', 'C', 'M', 'D', '_', 'O', 'U', 'T', '\0', /* GUS_L1_CH1_CMD_OUT (47730) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'C', 'H', '1', '_', 'D', 'A', 'T', 'A', '_', 'I', 'N', '\0', /* GUS_L1_CH1_DATA_IN (47749) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'C', 'H', '1', '_', 'D', 'A', 'T', 'A', '_', 'O', 'U', 'T', '\0', /* GUS_L1_CH1_DATA_OUT (47768) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'C', 'H', '1', '_', 'D', 'A', 'T', 'A', '_', 'U', '_', 'I', 'N', '\0', /* GUS_L1_CH1_DATA_U_IN (47788) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'C', 'H', '1', '_', 'D', 'A', 'T', 'A', '_', 'U', '_', 'O', 'U', 'T', '\0', /* GUS_L1_CH1_DATA_U_OUT (47809) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '0', '_', 'C', 'M', 'D', '_', 'I', 'N', '\0', /* GUS_L1_SA0_CMD_IN (47831) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '0', '_', 'C', 'M', 'D', '_', 'O', 'U', 'T', '\0', /* GUS_L1_SA0_CMD_OUT (47849) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '0', '_', 'D', 'A', 'T', 'A', '_', 'I', 'N', '\0', /* GUS_L1_SA0_DATA_IN (47868) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '0', '_', 'D', 'A', 'T', 'A', '_', 'O', 'U', 'T', '\0', /* GUS_L1_SA0_DATA_OUT (47887) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '0', '_', 'D', 'A', 'T', 'A', '_', 'U', '_', 'I', 'N', '\0', /* GUS_L1_SA0_DATA_U_IN (47907) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '0', '_', 'D', 'A', 'T', 'A', '_', 'U', '_', 'O', 'U', 'T', '\0', /* GUS_L1_SA0_DATA_U_OUT (47928) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '1', '_', 'C', 'M', 'D', '_', 'I', 'N', '\0', /* GUS_L1_SA1_CMD_IN (47950) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '1', '_', 'C', 'M', 'D', '_', 'O', 'U', 'T', '\0', /* GUS_L1_SA1_CMD_OUT (47968) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '1', '_', 'D', 'A', 'T', 'A', '_', 'I', 'N', '\0', /* GUS_L1_SA1_DATA_IN (47987) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '1', '_', 'D', 'A', 'T', 'A', '_', 'O', 'U', 'T', '\0', /* GUS_L1_SA1_DATA_OUT (48006) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '1', '_', 'D', 'A', 'T', 'A', '_', 'U', '_', 'I', 'N', '\0', /* GUS_L1_SA1_DATA_U_IN (48026) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '1', '_', 'D', 'A', 'T', 'A', '_', 'U', '_', 'O', 'U', 'T', '\0', /* GUS_L1_SA1_DATA_U_OUT (48047) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '2', '_', 'C', 'M', 'D', '_', 'I', 'N', '\0', /* GUS_L1_SA2_CMD_IN (48069) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '2', '_', 'C', 'M', 'D', '_', 'O', 'U', 'T', '\0', /* GUS_L1_SA2_CMD_OUT (48087) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '2', '_', 'D', 'A', 'T', 'A', '_', 'I', 'N', '\0', /* GUS_L1_SA2_DATA_IN (48106) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '2', '_', 'D', 'A', 'T', 'A', '_', 'O', 'U', 'T', '\0', /* GUS_L1_SA2_DATA_OUT (48125) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '2', '_', 'D', 'A', 'T', 'A', '_', 'U', '_', 'I', 'N', '\0', /* GUS_L1_SA2_DATA_U_IN (48145) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '2', '_', 'D', 'A', 'T', 'A', '_', 'U', '_', 'O', 'U', 'T', '\0', /* GUS_L1_SA2_DATA_U_OUT (48166) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '3', '_', 'C', 'M', 'D', '_', 'I', 'N', '\0', /* GUS_L1_SA3_CMD_IN (48188) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '3', '_', 'C', 'M', 'D', '_', 'O', 'U', 'T', '\0', /* GUS_L1_SA3_CMD_OUT (48206) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '3', '_', 'D', 'A', 'T', 'A', '_', 'I', 'N', '\0', /* GUS_L1_SA3_DATA_IN (48225) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '3', '_', 'D', 'A', 'T', 'A', '_', 'O', 'U', 'T', '\0', /* GUS_L1_SA3_DATA_OUT (48244) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '3', '_', 'D', 'A', 'T', 'A', '_', 'U', '_', 'I', 'N', '\0', /* GUS_L1_SA3_DATA_U_IN (48264) */
	'G', 'U', 'S', '_', 'L', '1', '_', 'S', 'A', '3', '_', 'D', 'A', 'T', 'A', '_', 'U', '_', 'O', 'U', 'T', '\0', /* GUS_L1_SA3_DATA_U_OUT (48285) */
	'G', 'U', 'S', '_', 'M', 'I', 'S', 'C', '3', '\0', /* GUS_MISC3 (48307) */
	'G', 'U', 'S', '_', 'W', 'R', 'R', 'S', 'P', '_', 'F', 'I', 'F', 'O', '_', 'C', 'N', 'T', 'L', '\0', /* GUS_WRRSP_FIFO_CNTL (48317) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'G', 'S', '_', 'M', 'E', 'S', 'H', 'L', 'E', 'T', '_', 'D', 'I', 'M', '\0', /* SPI_SHADER_GS_MESHLET_DIM (48337, 48359) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'G', 'S', '_', 'M', 'E', 'S', 'H', 'L', 'E', 'T', '_', 'E', 'X', 'P', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* SPI_SHADER_GS_MESHLET_EXP_ALLOC (48363) */
	'G', 'L', '1', 'C', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* GL1C_STATUS (48395) */
	'G', 'L', '1', 'C', '_', 'U', 'T', 'C', 'L', '0', '_', 'C', 'N', 'T', 'L', '2', '\0', /* GL1C_UTCL0_CNTL2 (48407) */
	'G', 'L', '1', 'C', '_', 'U', 'T', 'C', 'L', '0', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* GL1C_UTCL0_STATUS (48424) */
	'G', 'L', '1', 'C', '_', 'U', 'T', 'C', 'L', '0', '_', 'R', 'E', 'T', 'R', 'Y', '\0', /* GL1C_UTCL0_RETRY (48442) */
	'C', 'H', '_', 'A', 'R', 'B', '_', 'C', 'T', 'R', 'L', '\0', /* CH_ARB_CTRL (48459) */
	'C', 'H', '_', 'D', 'R', 'A', 'M', '_', 'B', 'U', 'R', 'S', 'T', '_', 'M', 'A', 'S', 'K', '\0', /* CH_DRAM_BURST_MASK (48471) */
	'C', 'H', '_', 'A', 'R', 'B', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CH_ARB_STATUS (48490) */
	'C', 'H', '_', 'D', 'R', 'A', 'M', '_', 'B', 'U', 'R', 'S', 'T', '_', 'C', 'T', 'R', 'L', '\0', /* CH_DRAM_BURST_CTRL (48504) */
	'C', 'H', 'A', '_', 'C', 'H', 'C', '_', 'C', 'R', 'E', 'D', 'I', 'T', 'S', '\0', /* CHA_CHC_CREDITS (48523) */
	'C', 'H', 'A', '_', 'C', 'L', 'I', 'E', 'N', 'T', '_', 'F', 'R', 'E', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* CHA_CLIENT_FREE_DELAY (48539) */
	'C', 'H', 'I', '_', 'C', 'H', 'R', '_', 'R', 'E', 'P', '_', 'F', 'G', 'C', 'G', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* CHI_CHR_REP_FGCG_OVERRIDE (48561) */
	'C', 'H', '_', 'V', 'C', '5', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* CH_VC5_ENABLE (48587) */
	'C', 'H', 'C', '_', 'C', 'T', 'R', 'L', '\0', /* CHC_CTRL (48601) */
	'C', 'H', 'C', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CHC_STATUS (48610) */
	'C', 'H', 'C', 'G', '_', 'C', 'T', 'R', 'L', '\0', /* CHCG_CTRL (48621) */
	'C', 'H', 'C', 'G', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CHCG_STATUS (48631) */
	'G', 'L', '2', 'A', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', 'C', 'T', 'R', 'L', '\0', /* GL2A_PRIORITY_CTRL (48643) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '4', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE4 (48662) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '5', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE5 (48693) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '6', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE6 (48724) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '7', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE7 (48755) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'T', 'E', 'R', 'L', 'E', 'A', 'V', 'E', '\0', /* COMPUTE_DISPATCH_INTERLEAVE (48786, 48803) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_VRS_OVERRIDE_CNTL (48814) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'F', 'E', 'E', 'D', 'B', 'A', 'C', 'K', '_', 'B', 'A', 'S', 'E', '\0', /* PA_SC_VRS_RATE_FEEDBACK_BASE (48838) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'F', 'E', 'E', 'D', 'B', 'A', 'C', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* PA_SC_VRS_RATE_FEEDBACK_BASE_EXT (48867) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'F', 'E', 'E', 'D', 'B', 'A', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '_', 'X', 'Y', '\0', /* PA_SC_VRS_RATE_FEEDBACK_SIZE_XY (48900) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'C', 'A', 'C', 'H', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_VRS_RATE_CACHE_CNTL (48932) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* PA_SC_VRS_RATE_BASE (48958) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* PA_SC_VRS_RATE_BASE_EXT (48978) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'S', 'I', 'Z', 'E', '_', 'X', 'Y', '\0', /* PA_SC_VRS_RATE_SIZE_XY (49002) */
	'C', 'B', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_FDCC_CONTROL (49025) */
	'P', 'A', '_', 'R', 'A', 'T', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_RATE_CNTL (49041) */
	'S', 'P', 'I', '_', 'G', 'F', 'X', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* SPI_GFX_SCRATCH_BASE_LO (49054) */
	'S', 'P', 'I', '_', 'G', 'F', 'X', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* SPI_GFX_SCRATCH_BASE_HI (49078) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'C', 'N', 'T', 'L', '_', '2', '\0', /* PA_SC_BINNER_CNTL_2 (49102) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR0_FDCC_CONTROL (49122) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR1_FDCC_CONTROL (49145) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR2_FDCC_CONTROL (49168) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR3_FDCC_CONTROL (49191) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR4_FDCC_CONTROL (49214) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR5_FDCC_CONTROL (49237) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR6_FDCC_CONTROL (49260) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR7_FDCC_CONTROL (49283) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'A', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_ASINVOC_COUNT_LO (49306) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'A', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_ASINVOC_COUNT_HI (49330) */
	'C', 'P', '_', 'P', 'A', '_', 'M', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_PA_MSPRIM_COUNT_LO (49354) */
	'C', 'P', '_', 'P', 'A', '_', 'M', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_PA_MSPRIM_COUNT_HI (49376) */
	'C', 'P', '_', 'G', 'E', '_', 'M', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_GE_MSINVOC_COUNT_LO (49398) */
	'C', 'P', '_', 'G', 'E', '_', 'M', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_GE_MSINVOC_COUNT_HI (49421) */
	'G', 'E', '_', 'G', 'S', '_', 'F', 'A', 'S', 'T', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'W', 'G', '_', 'D', 'I', 'M', '\0', /* GE_GS_FAST_LAUNCH_WG_DIM (49444) */
	'G', 'E', '_', 'G', 'S', '_', 'F', 'A', 'S', 'T', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'W', 'G', '_', 'D', 'I', 'M', '_', '1', '\0', /* GE_GS_FAST_LAUNCH_WG_DIM_1 (49469) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'W', 'O', 'R', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '0', '\0', /* GDS_STRMOUT_DWORDS_WRITTEN_0 (49496) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'W', 'O', 'R', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '1', '\0', /* GDS_STRMOUT_DWORDS_WRITTEN_1 (49525) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'W', 'O', 'R', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '2', '\0', /* GDS_STRMOUT_DWORDS_WRITTEN_2 (49554) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'W', 'O', 'R', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '3', '\0', /* GDS_STRMOUT_DWORDS_WRITTEN_3 (49583) */
	'G', 'D', 'S', '_', 'G', 'S', '_', '0', '\0', /* GDS_GS_0 (49612) */
	'G', 'D', 'S', '_', 'G', 'S', '_', '1', '\0', /* GDS_GS_1 (49621) */
	'G', 'D', 'S', '_', 'G', 'S', '_', '2', '\0', /* GDS_GS_2 (49630) */
	'G', 'D', 'S', '_', 'G', 'S', '_', '3', '\0', /* GDS_GS_3 (49639) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '0', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_0_LO (49648) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '0', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_0_HI (49678) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '0', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_0_LO (49708) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '0', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_0_HI (49739) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '1', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_1_LO (49770) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '1', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_1_HI (49800) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '1', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_1_LO (49830) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '1', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_1_HI (49861) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '2', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_2_LO (49892) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '2', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_2_HI (49922) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '2', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_2_LO (49952) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '2', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_2_HI (49983) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '3', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_3_LO (50014) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '3', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_3_HI (50044) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '3', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_3_LO (50074) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '3', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_3_HI (50105) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* SPI_CONFIG_CNTL_1 (50136) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '2', '\0', /* SPI_CONFIG_CNTL_2 (50154) */
	'S', 'P', 'I', '_', 'W', 'A', 'V', 'E', '_', 'L', 'I', 'M', 'I', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_WAVE_LIMIT_CNTL (50172) */
	'S', 'P', 'I', '_', 'G', 'S', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '_', 'C', 'N', 'T', 'L', '1', '\0', /* SPI_GS_THROTTLE_CNTL1 (50192) */
	'S', 'P', 'I', '_', 'G', 'S', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '_', 'C', 'N', 'T', 'L', '2', '\0', /* SPI_GS_THROTTLE_CNTL2 (50214) */
	'S', 'P', 'I', '_', 'A', 'T', 'T', 'R', 'I', 'B', 'U', 'T', 'E', '_', 'R', 'I', 'N', 'G', '_', 'B', 'A', 'S', 'E', '\0', /* SPI_ATTRIBUTE_RING_BASE (50236) */
	'S', 'P', 'I', '_', 'A', 'T', 'T', 'R', 'I', 'B', 'U', 'T', 'E', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* SPI_ATTRIBUTE_RING_SIZE (50260) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '4', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE4_PERFCOUNTER_LO (50284) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '4', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE4_PERFCOUNTER_HI (50308) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '5', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE5_PERFCOUNTER_LO (50332) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '5', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE5_PERFCOUNTER_HI (50356) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '6', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE6_PERFCOUNTER_LO (50380) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '6', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE6_PERFCOUNTER_HI (50404) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PC_PERFCOUNTER2_HI (50428) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PC_PERFCOUNTER2_LO (50447) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PC_PERFCOUNTER3_HI (50466) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PC_PERFCOUNTER3_LO (50485) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER0_LO (50504) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER0_HI (50524) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER1_LO (50544) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER1_HI (50564) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER2_LO (50584) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER2_HI (50604) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER3_LO (50624) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER3_HI (50644) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER4_LO (50664) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER4_HI (50684) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER5_LO (50704) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER5_HI (50724) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER6_LO (50744) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER6_HI (50764) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER7_LO (50784) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER7_HI (50804) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* TCP_PERFCOUNTER_FILTER (50824) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'F', 'I', 'L', 'T', 'E', 'R', '2', '\0', /* TCP_PERFCOUNTER_FILTER2 (50847) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'E', 'N', '\0', /* TCP_PERFCOUNTER_FILTER_EN (50871) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER2_LO (50897) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER2_HI (50919) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER3_LO (50941) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER3_HI (50963) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL1H_PERFCOUNTER0_LO (50985) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL1H_PERFCOUNTER0_HI (51006) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL1H_PERFCOUNTER1_LO (51027) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL1H_PERFCOUNTER1_HI (51048) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL1H_PERFCOUNTER2_LO (51069) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL1H_PERFCOUNTER2_HI (51090) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL1H_PERFCOUNTER3_LO (51111) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL1H_PERFCOUNTER3_HI (51132) */
	'C', 'P', 'C', '_', 'T', 'C', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_TC_PERF_COUNTER_WINDOW_SELECT (51153) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '4', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE4_PERFCOUNTER_SELECT (51187) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '5', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE5_PERFCOUNTER_SELECT (51215) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '6', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE6_PERFCOUNTER_SELECT (51243) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PC_PERFCOUNTER2_SELECT (51271) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PC_PERFCOUNTER3_SELECT (51294) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PC_PERFCOUNTER1_SELECT1 (51317) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PC_PERFCOUNTER2_SELECT1 (51341) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PC_PERFCOUNTER3_SELECT1 (51365) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER0_SELECT (51389) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER1_SELECT (51413) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER2_SELECT (51437) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER3_SELECT (51461) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER4_SELECT (51485) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER5_SELECT (51509) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER6_SELECT (51533) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER7_SELECT (51557) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '\0', /* SQG_PERFCOUNTER_CTRL (51581) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '2', '\0', /* SQG_PERFCOUNTER_CTRL2 (51602) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'F', 'I', 'N', 'I', 'S', 'H', '\0', /* SQG_PERF_SAMPLE_FINISH (51624) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'A', 'U', 'S', 'E', '\0', /* RLC_SPM_PAUSE (51647, 51655) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* RLC_SPM_STATUS (51661) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'M', 'O', 'D', 'E', '\0', /* RLC_SPM_MODE (51676, 51680) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* RLC_SPM_RSPM_REQ_DATA_LO (51689) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* RLC_SPM_RSPM_REQ_DATA_HI (51714) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'O', 'P', '\0', /* RLC_SPM_RSPM_REQ_OP (51739) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_RSPM_RET_DATA (51759) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'T', '_', 'O', 'P', '\0', /* RLC_SPM_RSPM_RET_OP (51781) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* RLC_SPM_SE_RSPM_REQ_DATA_LO (51801) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* RLC_SPM_SE_RSPM_REQ_DATA_HI (51829) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'O', 'P', '\0', /* RLC_SPM_SE_RSPM_REQ_OP (51857) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_SE_RSPM_RET_DATA (51880) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'T', '_', 'O', 'P', '\0', /* RLC_SPM_SE_RSPM_RET_OP (51905) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'C', 'M', 'D', '\0', /* RLC_SPM_RSPM_CMD (51928, 51941) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'C', 'M', 'D', '_', 'A', 'C', 'K', '\0', /* RLC_SPM_RSPM_CMD_ACK (51945) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'P', 'A', 'R', 'E', '\0', /* RLC_SPM_SPARE (51966, 51974) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER2_SELECT (51980) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER3_SELECT (52006) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1H_PERFCOUNTER0_SELECT (52032) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1H_PERFCOUNTER0_SELECT1 (52057) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1H_PERFCOUNTER1_SELECT (52083) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1H_PERFCOUNTER2_SELECT (52108) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1H_PERFCOUNTER3_SELECT (52133) */
	'A', 'C', 'Q', 'U', 'I', 'R', 'E', '_', 'M', 'E', 'M', '_', 'P', 'W', 'S', '_', '2', '\0', /* ACQUIRE_MEM_PWS_2 (52158) */
	'A', 'C', 'Q', 'U', 'I', 'R', 'E', '_', 'M', 'E', 'M', '_', 'P', 'W', 'S', '_', '7', '\0', /* ACQUIRE_MEM_PWS_7 (52176) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '\0', /* SQ_WAVE_HW_ID (52194) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'N', 'S', 'T', '_', 'D', 'W', '1', '\0', /* SQ_WAVE_INST_DW1 (52208) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'D', 'B', 'G', '0', '\0', /* SQ_WAVE_IB_DBG0 (52225) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'B', 'A', '_', 'L', 'O', '\0', /* SQ_WAVE_TBA_LO (52241) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'B', 'A', '_', 'H', 'I', '\0', /* SQ_WAVE_TBA_HI (52256) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'M', 'A', '_', 'L', 'O', '\0', /* SQ_WAVE_TMA_LO (52271) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'M', 'A', '_', 'H', 'I', '\0', /* SQ_WAVE_TMA_HI (52286) */
	'S', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '2', '\0', /* SRBM_STATUS2 (52301) */
	'S', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* SRBM_STATUS (52314) */
	'S', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '3', '\0', /* SRBM_STATUS3 (52326) */
	'G', 'R', 'B', 'M', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_CNTL (52339) */
	'G', 'R', 'B', 'M', '_', 'S', 'K', 'E', 'W', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_SKEW_CNTL (52349) */
	'G', 'R', 'B', 'M', '_', 'P', 'W', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_PWR_CNTL (52364) */
	'G', 'R', 'B', 'M', '_', 'S', 'O', 'F', 'T', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* GRBM_SOFT_RESET (52378) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_DEBUG_CNTL (52394) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* GRBM_DEBUG_DATA (52410) */
	'G', 'R', 'B', 'M', '_', 'G', 'F', 'X', '_', 'C', 'L', 'K', 'E', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_GFX_CLKEN_CNTL (52426) */
	'G', 'R', 'B', 'M', '_', 'W', 'A', 'I', 'T', '_', 'I', 'D', 'L', 'E', '_', 'C', 'L', 'O', 'C', 'K', 'S', '\0', /* GRBM_WAIT_IDLE_CLOCKS (52446, 52451) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '\0', /* GRBM_DEBUG (52468) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '_', 'S', 'N', 'A', 'P', 'S', 'H', 'O', 'T', '\0', /* GRBM_DEBUG_SNAPSHOT (52479) */
	'G', 'R', 'B', 'M', '_', 'R', 'E', 'A', 'D', '_', 'E', 'R', 'R', 'O', 'R', '\0', /* GRBM_READ_ERROR (52499, 52504) */
	'G', 'R', 'B', 'M', '_', 'I', 'N', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_INT_CNTL (52515) */
	'D', 'E', 'B', 'U', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* DEBUG_INDEX (52529) */
	'G', 'R', 'B', 'M', '_', 'N', 'O', 'W', 'H', 'E', 'R', 'E', '\0', /* GRBM_NOWHERE (52541) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '0', '\0', /* GRBM_SCRATCH_REG0 (52554) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '1', '\0', /* GRBM_SCRATCH_REG1 (52572) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '2', '\0', /* GRBM_SCRATCH_REG2 (52590) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '3', '\0', /* GRBM_SCRATCH_REG3 (52608) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '4', '\0', /* GRBM_SCRATCH_REG4 (52626) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '5', '\0', /* GRBM_SCRATCH_REG5 (52644) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '6', '\0', /* GRBM_SCRATCH_REG6 (52662) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '7', '\0', /* GRBM_SCRATCH_REG7 (52680) */
	'S', 'Q', '_', 'I', 'N', 'T', 'E', 'R', 'R', 'U', 'P', 'T', '_', 'W', 'O', 'R', 'D', '_', 'A', 'U', 'T', 'O', '\0', /* SQ_INTERRUPT_WORD_AUTO (52698) */
	'C', 'P', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '3', '\0', /* CP_STALLED_STAT3 (52721) */
	'C', 'P', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '1', '\0', /* CP_STALLED_STAT1 (52738) */
	'C', 'P', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '2', '\0', /* CP_STALLED_STAT2 (52755) */
	'C', 'P', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '\0', /* CP_BUSY_STAT (52772) */
	'C', 'P', '_', 'S', 'T', 'A', 'T', '\0', /* CP_STAT (52785) */
	'C', 'P', '_', 'M', 'E', '_', 'H', 'E', 'A', 'D', 'E', 'R', '_', 'D', 'U', 'M', 'P', '\0', /* CP_ME_HEADER_DUMP (52793) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'H', 'E', 'A', 'D', 'E', 'R', '_', 'D', 'U', 'M', 'P', '\0', /* CP_PFP_HEADER_DUMP (52811) */
	'C', 'P', '_', 'G', 'R', 'B', 'M', '_', 'F', 'R', 'E', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_GRBM_FREE_COUNT (52830) */
	'C', 'P', '_', 'C', 'E', '_', 'H', 'E', 'A', 'D', 'E', 'R', '_', 'D', 'U', 'M', 'P', '\0', /* CP_CE_HEADER_DUMP (52849) */
	'C', 'P', '_', 'M', 'C', '_', 'P', 'A', 'C', 'K', '_', 'D', 'E', 'L', 'A', 'Y', '_', 'C', 'N', 'T', '\0', /* CP_MC_PACK_DELAY_CNT (52867, 52873) */
	'C', 'P', '_', 'C', 'S', 'F', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CSF_STAT (52888) */
	'C', 'P', '_', 'C', 'S', 'F', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CSF_CNTL (52900) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* CP_ME_CNTL (52912) */
	'C', 'P', '_', 'C', 'N', 'T', 'X', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CNTX_STAT (52923) */
	'C', 'P', '_', 'M', 'E', '_', 'P', 'R', 'E', 'E', 'M', 'P', 'T', 'I', 'O', 'N', '\0', /* CP_ME_PREEMPTION (52936) */
	'C', 'P', '_', 'R', 'B', '2', '_', 'R', 'P', 'T', 'R', '\0', /* CP_RB2_RPTR (52953) */
	'C', 'P', '_', 'R', 'B', '1', '_', 'R', 'P', 'T', 'R', '\0', /* CP_RB1_RPTR (52965) */
	'C', 'P', '_', 'R', 'B', '0', '_', 'R', 'P', 'T', 'R', '\0', /* CP_RB0_RPTR (52977) */
	'C', 'P', '_', 'R', 'B', '_', 'W', 'P', 'T', 'R', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* CP_RB_WPTR_DELAY (52989) */
	'C', 'P', '_', 'R', 'B', '_', 'W', 'P', 'T', 'R', '_', 'P', 'O', 'L', 'L', '_', 'C', 'N', 'T', 'L', '\0', /* CP_RB_WPTR_POLL_CNTL (53006) */
	'C', 'P', '_', 'R', 'O', 'Q', '1', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_ROQ1_THRESHOLDS (53027) */
	'C', 'P', '_', 'R', 'O', 'Q', '2', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_ROQ2_THRESHOLDS (53046) */
	'C', 'P', '_', 'S', 'T', 'Q', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_STQ_THRESHOLDS (53065) */
	'C', 'P', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_QUEUE_THRESHOLDS (53083) */
	'C', 'P', '_', 'M', 'E', 'Q', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_MEQ_THRESHOLDS (53103) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_ROQ_AVAIL (53121) */
	'C', 'P', '_', 'S', 'T', 'Q', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_STQ_AVAIL (53134) */
	'C', 'P', '_', 'R', 'O', 'Q', '2', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_ROQ2_AVAIL (53147) */
	'C', 'P', '_', 'M', 'E', 'Q', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_MEQ_AVAIL (53161) */
	'C', 'P', '_', 'C', 'M', 'D', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* CP_CMD_INDEX (53174, 53177) */
	'C', 'P', '_', 'C', 'M', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* CP_CMD_DATA (53187) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'R', 'B', '_', 'S', 'T', 'A', 'T', '\0', /* CP_ROQ_RB_STAT (53199) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'I', 'B', '1', '_', 'S', 'T', 'A', 'T', '\0', /* CP_ROQ_IB1_STAT (53214) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'I', 'B', '2', '_', 'S', 'T', 'A', 'T', '\0', /* CP_ROQ_IB2_STAT (53230) */
	'C', 'P', '_', 'S', 'T', 'Q', '_', 'S', 'T', 'A', 'T', '\0', /* CP_STQ_STAT (53246) */
	'C', 'P', '_', 'M', 'E', 'Q', '_', 'S', 'T', 'A', 'T', '\0', /* CP_MEQ_STAT (53258) */
	'C', 'P', '_', 'C', 'E', 'Q', '1', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_CEQ1_AVAIL (53270) */
	'C', 'P', '_', 'C', 'E', 'Q', '2', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_CEQ2_AVAIL (53284) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'O', 'Q', '_', 'R', 'B', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CE_ROQ_RB_STAT (53298) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'O', 'Q', '_', 'I', 'B', '1', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CE_ROQ_IB1_STAT (53316) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'O', 'Q', '_', 'I', 'B', '2', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CE_ROQ_IB2_STAT (53335) */
	'C', 'P', '_', 'I', 'N', 'T', '_', 'S', 'T', 'A', 'T', '_', 'D', 'E', 'B', 'U', 'G', '\0', /* CP_INT_STAT_DEBUG (53354) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER0_SELECT (53372) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER1_SELECT (53395) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER2_SELECT (53418) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER3_SELECT (53441) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER0_LO (53464) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER0_HI (53483) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER1_LO (53502) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER1_HI (53521) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER2_LO (53540) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER2_HI (53559) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER3_LO (53578) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER3_HI (53597) */
	'V', 'G', 'T', '_', 'V', 'T', 'X', '_', 'V', 'E', 'C', 'T', '_', 'E', 'J', 'E', 'C', 'T', '_', 'R', 'E', 'G', '\0', /* VGT_VTX_VECT_EJECT_REG (53616) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'D', 'A', 'T', 'A', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_DMA_DATA_FIFO_DEPTH (53639, 53643) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'R', 'E', 'Q', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_DMA_REQ_FIFO_DEPTH (53663, 53667) */
	'V', 'G', 'T', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'I', 'T', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_DRAW_INIT_FIFO_DEPTH (53686, 53690) */
	'V', 'G', 'T', '_', 'L', 'A', 'S', 'T', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* VGT_LAST_COPY_STATE (53711) */
	'V', 'G', 'T', '_', 'C', 'A', 'C', 'H', 'E', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', 'A', 'T', 'I', 'O', 'N', '\0', /* VGT_CACHE_INVALIDATION (53731, 53735) */
	'V', 'G', 'T', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', 'S', '\0', /* VGT_FIFO_DEPTHS (53754) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', 'E', 'X', '_', 'R', 'E', 'U', 'S', 'E', '\0', /* VGT_GS_VERTEX_REUSE (53770) */
	'V', 'G', 'T', '_', 'M', 'C', '_', 'L', 'A', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_MC_LAT_CNTL (53790) */
	'I', 'A', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* IA_CNTL_STATUS (53806) */
	'V', 'G', 'T', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_DEBUG_CNTL (53821) */
	'V', 'G', 'T', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* VGT_DEBUG_DATA (53836) */
	'I', 'A', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* IA_DEBUG_CNTL (53851) */
	'I', 'A', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* IA_DEBUG_DATA (53865) */
	'V', 'G', 'T', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* VGT_CNTL_STATUS (53879) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'I', 'D', '_', 'M', 'A', 'S', 'K', '\0', /* VGT_PERFCOUNTER_SEID_MASK (53895) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER0_SELECT (53921) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER1_SELECT (53945) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER2_SELECT (53969) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER3_SELECT (53993) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER0_LO (54017) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER0_HI (54037) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER1_LO (54057) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER1_HI (54077) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER2_LO (54097) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER2_HI (54117) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER3_LO (54137) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER3_HI (54157) */
	'C', 'G', 'T', 'T', '_', 'V', 'G', 'T', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_VGT_CLK_CTRL (54177) */
	'I', 'A', '_', 'V', 'M', 'I', 'D', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* IA_VMID_OVERRIDE (54195) */
	'C', 'G', 'T', 'T', '_', 'I', 'A', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_IA_CLK_CTRL (54212) */
	'V', 'G', 'T', '_', 'S', 'Y', 'S', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_SYS_CONFIG (54229) */
	'C', 'C', '_', 'G', 'C', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'A', 'R', 'R', 'A', 'Y', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* CC_GC_SHADER_ARRAY_CONFIG (54244) */
	'G', 'C', '_', 'U', 'S', 'E', 'R', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'A', 'R', 'R', 'A', 'Y', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* GC_USER_SHADER_ARRAY_CONFIG (54270) */
	'P', 'A', '_', 'S', 'U', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_DEBUG_CNTL (54298) */
	'P', 'A', '_', 'S', 'U', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* PA_SU_DEBUG_DATA (54315) */
	'P', 'A', '_', 'C', 'L', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* PA_CL_CNTL_STATUS (54332) */
	'P', 'A', '_', 'C', 'L', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* PA_CL_ENHANCE (54350) */
	'C', 'G', 'T', 'T', '_', 'P', 'A', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_PA_CLK_CTRL (54364) */
	'P', 'A', '_', 'S', 'U', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* PA_SU_CNTL_STATUS (54381) */
	'P', 'A', '_', 'S', 'C', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_FIFO_DEPTH_CNTL (54399) */
	'P', 'A', '_', 'S', 'C', '_', 'F', 'O', 'R', 'C', 'E', '_', 'E', 'O', 'V', '_', 'M', 'A', 'X', '_', 'C', 'N', 'T', 'S', '\0', /* PA_SC_FORCE_EOV_MAX_CNTS (54421) */
	'C', 'G', 'T', 'T', '_', 'S', 'C', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_SC_CLK_CTRL (54446) */
	'P', 'A', '_', 'S', 'C', '_', 'F', 'I', 'F', 'O', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_SC_FIFO_SIZE (54463) */
	'P', 'A', '_', 'S', 'C', '_', 'I', 'F', '_', 'F', 'I', 'F', 'O', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_SC_IF_FIFO_SIZE (54479) */
	'P', 'A', '_', 'S', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_DEBUG_CNTL (54498) */
	'P', 'A', '_', 'S', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* PA_SC_DEBUG_DATA (54515) */
	'P', 'A', '_', 'S', 'C', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* PA_SC_ENHANCE (54532) */
	'S', 'Q', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* SQ_CONFIG (54546) */
	'S', 'Q', 'C', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* SQC_CONFIG (54556) */
	'S', 'Q', '_', 'R', 'A', 'N', 'D', 'O', 'M', '_', 'W', 'A', 'V', 'E', '_', 'P', 'R', 'I', '\0', /* SQ_RANDOM_WAVE_PRI (54567) */
	'S', 'Q', '_', 'R', 'E', 'G', '_', 'C', 'R', 'E', 'D', 'I', 'T', 'S', '\0', /* SQ_REG_CREDITS (54586) */
	'S', 'Q', '_', 'F', 'I', 'F', 'O', '_', 'S', 'I', 'Z', 'E', 'S', '\0', /* SQ_FIFO_SIZES (54601) */
	'C', 'C', '_', 'S', 'Q', 'C', '_', 'B', 'A', 'N', 'K', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* CC_SQC_BANK_DISABLE (54615) */
	'U', 'S', 'E', 'R', '_', 'S', 'Q', 'C', '_', 'B', 'A', 'N', 'K', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* USER_SQC_BANK_DISABLE (54635) */
	'S', 'Q', '_', 'D', 'E', 'B', 'U', 'G', '_', 'S', 'T', 'S', '_', 'G', 'L', 'O', 'B', 'A', 'L', '\0', /* SQ_DEBUG_STS_GLOBAL (54657) */
	'S', 'Q', '_', 'A', 'L', 'U', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_ALU_CLK_CTRL (54677) */
	'S', 'Q', '_', 'T', 'E', 'X', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_TEX_CLK_CTRL (54693) */
	'C', 'G', 'T', 'T', '_', 'S', 'Q', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_SQ_CLK_CTRL (54709) */
	'C', 'G', 'T', 'T', '_', 'S', 'Q', 'G', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_SQG_CLK_CTRL (54726) */
	'S', 'Q', '_', 'I', 'N', 'D', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SQ_IND_INDEX (54744) */
	'S', 'Q', '_', 'I', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* SQ_IND_DATA (54757) */
	'S', 'Q', '_', 'T', 'I', 'M', 'E', '_', 'H', 'I', '\0', /* SQ_TIME_HI (54769) */
	'S', 'Q', '_', 'T', 'I', 'M', 'E', '_', 'L', 'O', '\0', /* SQ_TIME_LO (54780) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* SQ_THREAD_TRACE_BASE (54791) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'I', 'Z', 'E', '\0', /* SQ_THREAD_TRACE_SIZE (54812) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'P', 'E', 'R', 'F', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_THREAD_TRACE_PERF_MASK (54833) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* SQ_THREAD_TRACE_MODE (54859) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_CNTR (54880) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'H', 'I', 'W', 'A', 'T', 'E', 'R', '\0', /* SQ_THREAD_TRACE_HIWATER (54901, 54917) */
	'S', 'Q', '_', 'P', 'O', 'W', 'E', 'R', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '\0', /* SQ_POWER_THROTTLE (54925) */
	'S', 'Q', '_', 'P', 'O', 'W', 'E', 'R', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '2', '\0', /* SQ_POWER_THROTTLE2 (54943) */
	'S', 'Q', '_', 'L', 'B', '_', 'C', 'T', 'R', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_LB_CTR_CTRL (54962) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'A', 'L', 'U', '_', 'C', 'Y', 'C', 'L', 'E', 'S', '\0', /* SQ_LB_DATA_ALU_CYCLES (54977) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'T', 'E', 'X', '_', 'C', 'Y', 'C', 'L', 'E', 'S', '\0', /* SQ_LB_DATA_TEX_CYCLES (54999) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'A', 'L', 'U', '_', 'S', 'T', 'A', 'L', 'L', 'S', '\0', /* SQ_LB_DATA_ALU_STALLS (55021) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'T', 'E', 'X', '_', 'S', 'T', 'A', 'L', 'L', 'S', '\0', /* SQ_LB_DATA_TEX_STALLS (55043) */
	'S', 'Q', 'C', '_', 'S', 'E', 'C', 'D', 'E', 'D', '_', 'C', 'N', 'T', '\0', /* SQC_SECDED_CNT (55065) */
	'S', 'Q', '_', 'S', 'E', 'C', '_', 'C', 'N', 'T', '\0', /* SQ_SEC_CNT (55080) */
	'S', 'Q', '_', 'D', 'E', 'D', '_', 'C', 'N', 'T', '\0', /* SQ_DED_CNT (55091) */
	'S', 'Q', '_', 'D', 'E', 'D', '_', 'I', 'N', 'F', 'O', '\0', /* SQ_DED_INFO (55102) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'P', 'S', '\0', /* SPI_SHADER_TBA_LO_PS (55114) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'P', 'S', '\0', /* SPI_SHADER_TBA_HI_PS (55135) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'P', 'S', '\0', /* SPI_SHADER_TMA_LO_PS (55156) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'P', 'S', '\0', /* SPI_SHADER_TMA_HI_PS (55177) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'V', 'S', '\0', /* SPI_SHADER_TBA_LO_VS (55198) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'V', 'S', '\0', /* SPI_SHADER_TBA_HI_VS (55219) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'V', 'S', '\0', /* SPI_SHADER_TMA_LO_VS (55240) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'V', 'S', '\0', /* SPI_SHADER_TMA_HI_VS (55261) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_TBA_LO_GS (55282) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_TBA_HI_GS (55303) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_TMA_LO_GS (55324) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_TMA_HI_GS (55345) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'E', 'S', '\0', /* SPI_SHADER_TBA_LO_ES (55366) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'E', 'S', '\0', /* SPI_SHADER_TBA_HI_ES (55387) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'E', 'S', '\0', /* SPI_SHADER_TMA_LO_ES (55408) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'E', 'S', '\0', /* SPI_SHADER_TMA_HI_ES (55429) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_TBA_LO_HS (55450) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_TBA_HI_HS (55471) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_TMA_LO_HS (55492) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_TMA_HI_HS (55513) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'L', 'S', '\0', /* SPI_SHADER_TBA_LO_LS (55534) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'L', 'S', '\0', /* SPI_SHADER_TBA_HI_LS (55555) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'L', 'S', '\0', /* SPI_SHADER_TMA_LO_LS (55576) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'L', 'S', '\0', /* SPI_SHADER_TMA_HI_LS (55597) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'M', 'A', 'X', '_', 'W', 'A', 'V', 'E', '_', 'I', 'D', '\0', /* COMPUTE_MAX_WAVE_ID (55618, 55626, 55630) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'B', 'A', '_', 'L', 'O', '\0', /* COMPUTE_TBA_LO (55638) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'B', 'A', '_', 'H', 'I', '\0', /* COMPUTE_TBA_HI (55653) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'M', 'A', '_', 'L', 'O', '\0', /* COMPUTE_TMA_LO (55668) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'M', 'A', '_', 'H', 'I', '\0', /* COMPUTE_TMA_HI (55683) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '0', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE0 (55698) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '1', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE1 (55729) */
	'S', 'D', 'M', 'A', '0', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'R', 'E', 'G', '\0', /* SDMA0_STATUS_REG (55760) */
	'S', 'D', 'M', 'A', '1', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'R', 'E', 'G', '\0', /* SDMA1_STATUS_REG (55777) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'I', 'N', 'F', 'O', '\0', /* DB_DEPTH_INFO (55794) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'S', 'I', 'Z', 'E', '\0', /* DB_DEPTH_SIZE (55808) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* DB_DEPTH_SLICE (55822) */
	'C', 'P', '_', 'R', 'I', 'N', 'G', 'I', 'D', '\0', /* CP_RINGID (55837, 55840) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'M', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CPC_MC_CNTL (55847) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'A', 'S', 'E', '2', '\0', /* SQ_THREAD_TRACE_BASE2 (55862) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'T', 'O', 'K', 'E', 'N', '_', 'M', 'A', 'S', 'K', '2', '\0', /* SQ_THREAD_TRACE_TOKEN_MASK2 (55884) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '2', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE2 (55912) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '3', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE3 (55943) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER0_LO (55974) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER0_HI (55993) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER1_LO (56012) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER1_HI (56031) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER2_LO (56050) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER2_HI (56069) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER3_LO (56088) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER3_HI (56107) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER0_LO (56126) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER0_HI (56146) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER1_LO (56166) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER1_HI (56186) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER2_LO (56206) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER2_HI (56226) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER3_LO (56246) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER3_HI (56266) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER0_LO (56286) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER0_HI (56306) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER1_LO (56326) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER1_HI (56346) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER2_LO (56366) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER2_HI (56386) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER3_LO (56406) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER3_HI (56426) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER0_LO (56446) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER0_HI (56466) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER1_LO (56486) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER1_HI (56506) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER2_LO (56526) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER2_HI (56546) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER3_LO (56566) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER3_HI (56586) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER0_SELECT (56606) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER1_SELECT (56629) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER2_SELECT (56652) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER3_SELECT (56675) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* IA_PERFCOUNTER0_SELECT1 (56698) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* VGT_PERFCOUNTER0_SELECT1 (56722) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* VGT_PERFCOUNTER1_SELECT1 (56747) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_PERFCOUNTER_MASK (56772) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER0_SELECT (56792) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCC_PERFCOUNTER0_SELECT1 (56816) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER1_SELECT (56841) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCC_PERFCOUNTER1_SELECT1 (56865) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER2_SELECT (56890) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER3_SELECT (56914) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER0_SELECT (56938) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCA_PERFCOUNTER0_SELECT1 (56962) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER1_SELECT (56987) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCA_PERFCOUNTER1_SELECT1 (57011) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER2_SELECT (57036) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER3_SELECT (57060) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER0_SELECT (57084) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCS_PERFCOUNTER0_SELECT1 (57108) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER1_SELECT (57133) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER2_SELECT (57157) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER3_SELECT (57181) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CPG_PERFMON_SAMPLE_DELAY (57205, 57217) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CPC_PERFMON_SAMPLE_DELAY (57238) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CPF_PERFMON_SAMPLE_DELAY (57271) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'B', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CB_PERFMON_SAMPLE_DELAY (57304) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'B', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_DB_PERFMON_SAMPLE_DELAY (57336) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_PA_PERFMON_SAMPLE_DELAY (57368) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_GDS_PERFMON_SAMPLE_DELAY (57400) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'I', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_IA_PERFMON_SAMPLE_DELAY (57433) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SC_PERFMON_SAMPLE_DELAY (57465) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCC_PERFMON_SAMPLE_DELAY (57497) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCA_PERFMON_SAMPLE_DELAY (57530) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCP_PERFMON_SAMPLE_DELAY (57563) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TA_PERFMON_SAMPLE_DELAY (57596) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'D', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TD_PERFMON_SAMPLE_DELAY (57628) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_VGT_PERFMON_SAMPLE_DELAY (57660) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SPI_PERFMON_SAMPLE_DELAY (57693) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SQG_PERFMON_SAMPLE_DELAY (57726) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCS_PERFMON_SAMPLE_DELAY (57759) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'X', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SX_PERFMON_SAMPLE_DELAY (57792) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'B', 'R', '0', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_DBR0_PERFMON_SAMPLE_DELAY (57824) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'B', 'R', '1', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_DBR1_PERFMON_SAMPLE_DELAY (57858) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'B', 'R', '0', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CBR0_PERFMON_SAMPLE_DELAY (57892) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'B', 'R', '1', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CBR1_PERFMON_SAMPLE_DELAY (57926) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'W', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* COMPUTE_WAVE_RESTORE_CONTROL (57960) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'B', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_CE_RB_OFFSET (57989) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_ES_16 (58005) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_ES_17 (58032) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_ES_18 (58059) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_ES_19 (58086) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_ES_20 (58113) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_ES_21 (58140) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_ES_22 (58167) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_ES_23 (58194) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_ES_24 (58221) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_ES_25 (58248) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_ES_26 (58275) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_ES_27 (58302) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_ES_28 (58329) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_ES_29 (58356) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_ES_30 (58383) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_ES_31 (58410) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_LS_16 (58437) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_LS_17 (58464) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_LS_18 (58491) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_LS_19 (58518) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_LS_20 (58545) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_LS_21 (58572) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_LS_22 (58599) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_LS_23 (58626) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_LS_24 (58653) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_LS_25 (58680) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_LS_26 (58707) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_LS_27 (58734) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_LS_28 (58761) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_LS_29 (58788) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_LS_30 (58815) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_LS_31 (58842) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_0 (58869) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_1 (58899) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '\0', /* SPI_SHADER_USER_DATA_COMMON_2 (58929) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '3', '\0', /* SPI_SHADER_USER_DATA_COMMON_3 (58959) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '4', '\0', /* SPI_SHADER_USER_DATA_COMMON_4 (58989) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '5', '\0', /* SPI_SHADER_USER_DATA_COMMON_5 (59019) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '6', '\0', /* SPI_SHADER_USER_DATA_COMMON_6 (59049) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '7', '\0', /* SPI_SHADER_USER_DATA_COMMON_7 (59079) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '8', '\0', /* SPI_SHADER_USER_DATA_COMMON_8 (59109) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '9', '\0', /* SPI_SHADER_USER_DATA_COMMON_9 (59139) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_10 (59169) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_11 (59200) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_COMMON_12 (59231) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_COMMON_13 (59262) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_COMMON_14 (59293) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_COMMON_15 (59324) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_COMMON_16 (59355) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_COMMON_17 (59386) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_COMMON_18 (59417) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_COMMON_19 (59448) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_20 (59479) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_21 (59510) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_COMMON_22 (59541) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_COMMON_23 (59572) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_COMMON_24 (59603) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_COMMON_25 (59634) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_COMMON_26 (59665) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_COMMON_27 (59696) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_COMMON_28 (59727) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_COMMON_29 (59758) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_30 (59789) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_31 (59820) */
	'D', 'B', '_', 'Z', '_', 'I', 'N', 'F', 'O', '2', '\0', /* DB_Z_INFO2 (59851) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'F', 'O', '2', '\0', /* DB_STENCIL_INFO2 (59862) */
	'C', 'B', '_', 'M', 'R', 'T', '0', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT0_EPITCH (59879, 59887) */
	'C', 'B', '_', 'M', 'R', 'T', '1', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT1_EPITCH (59894) */
	'C', 'B', '_', 'M', 'R', 'T', '2', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT2_EPITCH (59909) */
	'C', 'B', '_', 'M', 'R', 'T', '3', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT3_EPITCH (59924) */
	'C', 'B', '_', 'M', 'R', 'T', '4', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT4_EPITCH (59939) */
	'C', 'B', '_', 'M', 'R', 'T', '5', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT5_EPITCH (59954) */
	'C', 'B', '_', 'M', 'R', 'T', '6', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT6_EPITCH (59969) */
	'C', 'B', '_', 'M', 'R', 'T', '7', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT7_EPITCH (59984) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'M', 'A', 'X', '_', 'P', 'R', 'I', 'M', 'S', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'O', 'U', 'P', '\0', /* VGT_GS_MAX_PRIMS_PER_SUBGROUP (59999, 60006) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* CP_APPEND_DATA_LO (60029) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'C', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'L', 'O', '\0', /* CP_APPEND_LAST_CS_FENCE_LO (60047) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'P', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'L', 'O', '\0', /* CP_APPEND_LAST_PS_FENCE_LO (60074) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_RMI_PERFMON_SAMPLE_DELAY (60101) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '_', 'M', 'A', 'X', '\0', /* RLC_SPM_PERFMON_SAMPLE_DELAY_MAX (60134, 60161) */
	'F', 'P', '_', 'R', 'O', 'U', 'N', 'D', '\0', /* FP_ROUND (60167) */
	'F', 'P', '_', 'D', 'E', 'N', 'O', 'R', 'M', '\0', /* FP_DENORM (60176) */
	'D', 'X', '1', '0', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* DX10_CLAMP (60186) */
	'I', 'E', 'E', 'E', '\0', /* IEEE (60197) */
	'L', 'O', 'D', '_', 'C', 'L', 'A', 'M', 'P', 'E', 'D', '\0', /* LOD_CLAMPED (60202) */
	'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* INVALID (60214, 60216) */
	'I', 'N', 'P', 'U', 'T', '_', 'D', 'E', 'N', 'O', 'R', 'M', 'A', 'L', '\0', /* INPUT_DENORMAL (60222) */
	'D', 'I', 'V', 'I', 'D', 'E', '_', 'B', 'Y', '_', 'Z', 'E', 'R', 'O', '\0', /* DIVIDE_BY_ZERO (60237) */
	'O', 'V', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* OVERFLOW (60252) */
	'U', 'N', 'D', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* UNDERFLOW (60261) */
	'I', 'N', 'E', 'X', 'A', 'C', 'T', '\0', /* INEXACT (60271, 60273) */
	'I', 'N', 'T', '_', 'D', 'I', 'V', 'I', 'D', 'E', '_', 'B', 'Y', '_', 'Z', 'E', 'R', 'O', '\0', /* INT_DIVIDE_BY_ZERO (60279) */
	'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'W', 'A', 'T', 'C', 'H', '\0', /* ADDRESS_WATCH (60298) */
	'M', 'E', 'M', 'O', 'R', 'Y', '_', 'V', 'I', 'O', 'L', 'A', 'T', 'I', 'O', 'N', '\0', /* MEMORY_VIOLATION (60312) */
	'E', 'X', 'C', 'P', '_', 'E', 'N', '\0', /* EXCP_EN (60329) */
	'F', 'P', '1', '6', '_', 'O', 'V', 'F', 'L', '\0', /* FP16_OVFL (60337) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'P', 'E', 'R', 'F', '\0', /* DISABLE_PERF (60347) */
	'V', 'S', 'K', 'I', 'P', '\0', /* VSKIP (60360) */
	'C', 'S', 'P', '\0', /* CSP (60366) */
	'S', 'C', 'C', '\0', /* SCC (60370) */
	'S', 'P', 'I', '_', 'P', 'R', 'I', 'O', '\0', /* SPI_PRIO (60374) */
	'U', 'S', 'E', 'R', '_', 'P', 'R', 'I', 'O', '\0', /* USER_PRIO (60383) */
	'P', 'R', 'I', 'V', '\0', /* PRIV (60393) */
	'T', 'R', 'A', 'P', '_', 'E', 'N', '\0', /* TRAP_EN (60398) */
	'T', 'T', 'R', 'A', 'C', 'E', '_', 'E', 'N', '\0', /* TTRACE_EN (60406) */
	'E', 'X', 'P', 'O', 'R', 'T', '_', 'R', 'D', 'Y', '\0', /* EXPORT_RDY (60416) */
	'E', 'X', 'E', 'C', 'Z', '\0', /* EXECZ (60427) */
	'V', 'C', 'C', 'Z', '\0', /* VCCZ (60433) */
	'I', 'N', '_', 'T', 'G', '\0', /* IN_TG (60438) */
	'I', 'N', '_', 'B', 'A', 'R', 'R', 'I', 'E', 'R', '\0', /* IN_BARRIER (60444) */
	'H', 'A', 'L', 'T', '\0', /* HALT (60455) */
	'T', 'R', 'A', 'P', '\0', /* TRAP (60460) */
	'T', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'I', 'M', 'D', '_', 'E', 'N', '\0', /* TTRACE_SIMD_EN (60465, 60472) */
	'E', 'C', 'C', '_', 'E', 'R', 'R', '\0', /* ECC_ERR (60480) */
	'S', 'K', 'I', 'P', '_', 'E', 'X', 'P', 'O', 'R', 'T', '\0', /* SKIP_EXPORT (60488) */
	'P', 'E', 'R', 'F', '_', 'E', 'N', '\0', /* PERF_EN (60500) */
	'F', 'A', 'T', 'A', 'L', '_', 'H', 'A', 'L', 'T', '\0', /* FATAL_HALT (60508) */
	'M', 'U', 'S', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '\0', /* MUST_EXPORT (60519) */
	'E', 'X', 'C', 'P', '\0', /* EXCP (60531) */
	'S', 'A', 'V', 'E', 'C', 'T', 'X', '\0', /* SAVECTX (60536) */
	'I', 'L', 'L', 'E', 'G', 'A', 'L', '_', 'I', 'N', 'S', 'T', '\0', /* ILLEGAL_INST (60544) */
	'E', 'X', 'C', 'P', '_', 'H', 'I', '\0', /* EXCP_HI (60557) */
	'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'O', 'B', '\0', /* BUFFER_OOB (60565) */
	'E', 'X', 'C', 'P', '_', 'C', 'Y', 'C', 'L', 'E', '\0', /* EXCP_CYCLE (60576) */
	'E', 'X', 'C', 'P', '_', 'G', 'R', 'O', 'U', 'P', '_', 'M', 'A', 'S', 'K', '\0', /* EXCP_GROUP_MASK (60587) */
	'E', 'X', 'C', 'P', '_', 'W', 'A', 'V', 'E', '6', '4', 'H', 'I', '\0', /* EXCP_WAVE64HI (60603, 60608) */
	'X', 'N', 'A', 'C', 'K', '_', 'E', 'R', 'R', 'O', 'R', '\0', /* XNACK_ERROR (60617) */
	'D', 'P', '_', 'R', 'A', 'T', 'E', '\0', /* DP_RATE (60629) */
	'S', 'I', 'M', 'D', '_', 'I', 'D', '\0', /* SIMD_ID (60637) */
	'P', 'I', 'P', 'E', '_', 'I', 'D', '\0', /* PIPE_ID (60645) */
	'C', 'U', '_', 'I', 'D', '\0', /* CU_ID (60653) */
	'S', 'H', '_', 'I', 'D', '\0', /* SH_ID (60659) */
	'W', 'A', 'V', 'E', '_', 'I', 'D', '_', 'M', 'S', 'B', '\0', /* WAVE_ID_MSB (60665) */
	'T', 'G', '_', 'I', 'D', '\0', /* TG_ID (60677) */
	'V', 'M', '_', 'I', 'D', '\0', /* VM_ID (60683) */
	'Q', 'U', 'E', 'U', 'E', '_', 'I', 'D', '\0', /* QUEUE_ID (60689) */
	'S', 'T', 'A', 'T', 'E', '_', 'I', 'D', '\0', /* STATE_ID (60698) */
	'M', 'E', '_', 'I', 'D', '\0', /* ME_ID (60707) */
	'V', 'G', 'P', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* VGPR_BASE (60713) */
	'V', 'G', 'P', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* VGPR_SIZE (60723) */
	'S', 'G', 'P', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* SGPR_BASE (60733) */
	'S', 'G', 'P', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* SGPR_SIZE (60743) */
	'L', 'D', 'S', '_', 'B', 'A', 'S', 'E', '\0', /* LDS_BASE (60753) */
	'L', 'D', 'S', '_', 'S', 'I', 'Z', 'E', '\0', /* LDS_SIZE (60762) */
	'V', 'G', 'P', 'R', '_', 'S', 'H', 'A', 'R', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '\0', /* VGPR_SHARED_SIZE (60771) */
	'V', 'M', '_', 'C', 'N', 'T', '\0', /* VM_CNT (60788) */
	'E', 'X', 'P', '_', 'C', 'N', 'T', '\0', /* EXP_CNT (60795) */
	'L', 'G', 'K', 'M', '_', 'C', 'N', 'T', '_', 'B', 'I', 'T', '4', '\0', /* LGKM_CNT_BIT4 (60803) */
	'L', 'G', 'K', 'M', '_', 'C', 'N', 'T', '\0', /* LGKM_CNT (60817) */
	'V', 'A', 'L', 'U', '_', 'C', 'N', 'T', '\0', /* VALU_CNT (60826) */
	'F', 'I', 'R', 'S', 'T', '_', 'R', 'E', 'P', 'L', 'A', 'Y', '\0', /* FIRST_REPLAY (60835) */
	'R', 'C', 'N', 'T', '\0', /* RCNT (60848) */
	'V', 'M', '_', 'C', 'N', 'T', '_', 'H', 'I', '\0', /* VM_CNT_HI (60853) */
	'L', 'G', 'K', 'M', '_', 'C', 'N', 'T', '_', 'B', 'I', 'T', '5', '\0', /* LGKM_CNT_BIT5 (60863) */
	'R', 'E', 'P', 'L', 'A', 'Y', '_', 'W', '6', '4', 'H', '\0', /* REPLAY_W64H (60877) */
	'V', 'S', '_', 'C', 'N', 'T', '\0', /* VS_CNT (60889) */
	'X', 'N', 'A', 'C', 'K', '\0', /* XNACK (60896) */
	'T', 'A', '_', 'N', 'E', 'E', 'D', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* TA_NEED_RESET (60902) */
	'X', 'N', 'A', 'C', 'K', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* XNACK_OVERRIDE (60916) */
	'X', 'C', 'N', 'T', '\0', /* XCNT (60931) */
	'Q', 'C', 'N', 'T', '\0', /* QCNT (60936) */
	'W', 'A', 'V', 'E', '_', 'I', 'D', 'L', 'E', '\0', /* WAVE_IDLE (60941) */
	'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', '\0', /* MISC_CNT (60951) */
	'W', 'G', 'P', '_', 'I', 'D', '\0', /* WGP_ID (60960) */
	'S', 'A', '_', 'I', 'D', '\0', /* SA_ID (60967) */
	'W', 'G', '_', 'I', 'D', '\0', /* WG_ID (60973) */
	'C', 'O', 'M', 'P', 'A', 'T', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* COMPAT_LEVEL (60979) */
	'P', 'O', 'P', 'S', '_', 'E', 'N', '\0', /* POPS_EN (60992, 60994) */
	'P', 'O', 'P', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'R', '_', 'I', 'D', '\0', /* POPS_PACKER_ID (61000) */
	'D', 'E', 'P', '_', 'M', 'O', 'D', 'E', '\0', /* DEP_MODE (61015) */
	'I', 'N', 'S', 'T', '_', 'P', 'R', 'E', 'F', 'E', 'T', 'C', 'H', '\0', /* INST_PREFETCH (61024) */
	'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* RESOURCE_OVERRIDE (61038) */
	'M', 'E', 'M', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* MEM_ORDER (61056) */
	'F', 'W', 'D', '_', 'P', 'R', 'O', 'G', 'R', 'E', 'S', 'S', '\0', /* FWD_PROGRESS (61066) */
	'W', 'A', 'V', 'E', '6', '4', '\0', /* WAVE64 (61079) */
	'S', 'U', 'B', 'V', '_', 'L', 'O', 'O', 'P', '\0', /* SUBV_LOOP (61086) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '1', '_', 'C', 'M', 'D', 'F', 'I', 'F', 'O', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* ME0PIPE1_CMDFIFO_AVAIL (61096) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '1', '_', 'C', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE1_CF_RQ_PENDING (61119) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '1', '_', 'P', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE1_PF_RQ_PENDING (61142) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE0_RQ_PENDING (61165) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE1_RQ_PENDING (61185) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE2_RQ_PENDING (61205) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '3', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE3_RQ_PENDING (61225) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE0_RQ_PENDING (61245) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE1_RQ_PENDING (61265) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE2_RQ_PENDING (61285) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '3', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE3_RQ_PENDING (61305) */
	'R', 'L', 'C', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* RLC_RQ_PENDING (61325) */
	'U', 'T', 'C', 'L', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* UTCL2_BUSY (61340, 61346) */
	'E', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* EA_BUSY (61351) */
	'R', 'M', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* RMI_BUSY (61359) */
	'U', 'T', 'C', 'L', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* UTCL2_RQ_PENDING (61368) */
	'C', 'P', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* CPF_RQ_PENDING (61385) */
	'E', 'A', '_', 'L', 'I', 'N', 'K', '_', 'B', 'U', 'S', 'Y', '\0', /* EA_LINK_BUSY (61400) */
	'S', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* SDMA_BUSY (61413, 61414) */
	'S', 'D', 'M', 'A', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* SDMA0_RQ_PENDING (61423) */
	'S', 'D', 'M', 'A', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* SDMA1_RQ_PENDING (61440) */
	'R', 'L', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* RLC_BUSY (61457) */
	'T', 'C', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* TCP_BUSY (61466, 61467) */
	'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_BUSY (61475) */
	'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* CPC_BUSY (61484, 61485) */
	'C', 'P', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* CPG_BUSY (61493) */
	'C', 'P', 'A', 'X', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* CPAXI_BUSY (61502) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '0', '_', 'C', 'M', 'D', 'F', 'I', 'F', 'O', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* ME0PIPE0_CMDFIFO_AVAIL (61513) */
	'R', 'S', 'M', 'U', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* RSMU_RQ_PENDING (61536, 61537) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '0', '_', 'C', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE0_CF_RQ_PENDING (61552) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '0', '_', 'P', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE0_PF_RQ_PENDING (61575) */
	'G', 'D', 'S', '_', 'D', 'M', 'A', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GDS_DMA_RQ_PENDING (61598) */
	'D', 'B', '_', 'C', 'L', 'E', 'A', 'N', '\0', /* DB_CLEAN (61617) */
	'C', 'B', '_', 'C', 'L', 'E', 'A', 'N', '\0', /* CB_CLEAN (61626) */
	'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* TA_BUSY (61635) */
	'G', 'D', 'S', '_', 'B', 'U', 'S', 'Y', '\0', /* GDS_BUSY (61643) */
	'G', 'E', '_', 'B', 'U', 'S', 'Y', '_', 'N', 'O', '_', 'D', 'M', 'A', '\0', /* GE_BUSY_NO_DMA (61652) */
	'S', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* SX_BUSY (61667) */
	'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* GE_BUSY (61675) */
	'S', 'P', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* SPI_BUSY (61683) */
	'B', 'C', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* BCI_BUSY (61692) */
	'S', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* SC_BUSY (61701) */
	'P', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* PA_BUSY (61709) */
	'D', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* DB_BUSY (61717) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', 'E', 'N', 'C', 'Y', '_', 'B', 'U', 'S', 'Y', '\0', /* CP_COHERENCY_BUSY (61725) */
	'C', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* CB_BUSY (61743) */
	'G', 'U', 'I', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* GUI_ACTIVE (61751) */
	'U', 'T', 'C', 'L', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* UTCL1_BUSY (61762) */
	'G', 'L', '1', 'C', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* GL1CC_BUSY (61773) */
	'G', 'R', 'B', 'M', '_', 'R', 'L', 'C', '_', 'I', 'N', 'T', 'R', '_', 'C', 'R', 'E', 'D', 'I', 'T', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GRBM_RLC_INTR_CREDIT_PENDING (61784) */
	'G', 'R', 'B', 'M', '_', 'U', 'T', 'C', 'L', '2', '_', 'I', 'N', 'T', 'R', '_', 'C', 'R', 'E', 'D', 'I', 'T', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GRBM_UTCL2_INTR_CREDIT_PENDING (61813) */
	'G', 'R', 'B', 'M', '_', 'C', 'P', 'F', '_', 'I', 'N', 'T', 'R', '_', 'C', 'R', 'E', 'D', 'I', 'T', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GRBM_CPF_INTR_CREDIT_PENDING (61844) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE0_RQ_PENDING (61873) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE1_RQ_PENDING (61893) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE2_RQ_PENDING (61913) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '3', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE3_RQ_PENDING (61933) */
	'P', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* PH_BUSY (61953) */
	'C', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* CH_BUSY (61961) */
	'G', 'L', '2', 'C', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* GL2CC_BUSY (61969) */
	'G', 'U', 'S', '_', 'L', 'I', 'N', 'K', '_', 'B', 'U', 'S', 'Y', '\0', /* GUS_LINK_BUSY (61980) */
	'G', 'U', 'S', '_', 'B', 'U', 'S', 'Y', '\0', /* GUS_BUSY (61994) */
	'P', 'M', 'M', '_', 'B', 'U', 'S', 'Y', '\0', /* PMM_BUSY (62003) */
	'M', 'E', 'C', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_BUSY (62012) */
	'M', 'E', 'C', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_BUSY (62022) */
	'D', 'C', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* DC0_BUSY (62032) */
	'D', 'C', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* DC1_BUSY (62041) */
	'R', 'C', 'I', 'U', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU1_BUSY (62050) */
	'R', 'C', 'I', 'U', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU2_BUSY (62061) */
	'R', 'O', 'Q', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ1_BUSY (62072) */
	'R', 'O', 'Q', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ2_BUSY (62082) */
	'T', 'C', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* TCIU_BUSY (62092) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'A', 'M', '_', 'B', 'U', 'S', 'Y', '\0', /* SCRATCH_RAM_BUSY (62102) */
	'Q', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* QU_BUSY (62119) */
	'U', 'T', 'C', 'L', '2', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* UTCL2IU_BUSY (62127) */
	'S', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* SAVE_RESTORE_BUSY (62140) */
	'G', 'C', 'R', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* GCRIU_BUSY (62158) */
	'M', 'E', 'S', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_BUSY (62169) */
	'M', 'E', 'S', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'A', 'M', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_SCRATCH_RAM_BUSY (62178) */
	'R', 'C', 'I', 'U', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU3_BUSY (62199) */
	'M', 'E', 'S', '_', 'I', 'N', 'S', 'T', 'R', 'U', 'C', 'T', 'I', 'O', 'N', '_', 'C', 'A', 'C', 'H', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_INSTRUCTION_CACHE_BUSY (62210) */
	'C', 'P', 'G', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* CPG_CPC_BUSY (62237) */
	'C', 'P', 'F', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_CPC_BUSY (62250) */
	'M', 'E', 'C', '1', '_', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_LOAD_BUSY (62263) */
	'M', 'E', 'C', '1', '_', 'S', 'E', 'M', 'A', 'P', 'O', 'H', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_SEMAPOHRE_BUSY (62278) */
	'M', 'E', 'C', '1', '_', 'M', 'U', 'T', 'E', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_MUTEX_BUSY (62298) */
	'M', 'E', 'C', '1', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_MESSAGE_BUSY (62314) */
	'M', 'E', 'C', '1', '_', 'E', 'O', 'P', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_EOP_QUEUE_BUSY (62332) */
	'M', 'E', 'C', '1', '_', 'I', 'Q', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_IQ_QUEUE_BUSY (62352) */
	'M', 'E', 'C', '1', '_', 'I', 'B', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_IB_QUEUE_BUSY (62371) */
	'M', 'E', 'C', '1', '_', 'T', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_TC_BUSY (62390, 62395) */
	'M', 'E', 'C', '1', '_', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_DMA_BUSY (62403) */
	'M', 'E', 'C', '1', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'F', 'L', 'U', 'S', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PARTIAL_FLUSH_BUSY (62417) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE0_BUSY (62441) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE1_BUSY (62457) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE2_BUSY (62473) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE3_BUSY (62489) */
	'M', 'E', 'C', '2', '_', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_LOAD_BUSY (62505) */
	'M', 'E', 'C', '2', '_', 'S', 'E', 'M', 'A', 'P', 'O', 'H', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_SEMAPOHRE_BUSY (62520) */
	'M', 'E', 'C', '2', '_', 'M', 'U', 'T', 'E', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_MUTEX_BUSY (62540) */
	'M', 'E', 'C', '2', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_MESSAGE_BUSY (62556) */
	'M', 'E', 'C', '2', '_', 'E', 'O', 'P', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_EOP_QUEUE_BUSY (62574) */
	'M', 'E', 'C', '2', '_', 'I', 'Q', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_IQ_QUEUE_BUSY (62594) */
	'M', 'E', 'C', '2', '_', 'I', 'B', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_IB_QUEUE_BUSY (62613) */
	'M', 'E', 'C', '2', '_', 'T', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_TC_BUSY (62632) */
	'M', 'E', 'C', '2', '_', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_DMA_BUSY (62645) */
	'M', 'E', 'C', '2', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'F', 'L', 'U', 'S', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PARTIAL_FLUSH_BUSY (62659) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE0_BUSY (62683) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE1_BUSY (62699) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE2_BUSY (62715) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE3_BUSY (62731) */
	'R', 'C', 'I', 'U', '_', 'T', 'X', '_', 'F', 'R', 'E', 'E', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* RCIU_TX_FREE_STALL (62747) */
	'R', 'C', 'I', 'U', '_', 'P', 'R', 'I', 'V', '_', 'V', 'I', 'O', 'L', 'A', 'T', 'I', 'O', 'N', '\0', /* RCIU_PRIV_VIOLATION (62766) */
	'T', 'C', 'I', 'U', '_', 'T', 'X', '_', 'F', 'R', 'E', 'E', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* TCIU_TX_FREE_STALL (62786) */
	'M', 'E', 'C', '1', '_', 'D', 'E', 'C', 'O', 'D', 'I', 'N', 'G', '_', 'P', 'A', 'C', 'K', 'E', 'T', '\0', /* MEC1_DECODING_PACKET (62805) */
	'M', 'E', 'C', '1', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '\0', /* MEC1_WAIT_ON_RCIU (62826) */
	'M', 'E', 'C', '1', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '_', 'R', 'E', 'A', 'D', '\0', /* MEC1_WAIT_ON_RCIU_READ (62844) */
	'M', 'E', 'C', '1', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'O', 'Q', '_', 'D', 'A', 'T', 'A', '\0', /* MEC1_WAIT_ON_ROQ_DATA (62867) */
	'M', 'E', 'C', '2', '_', 'D', 'E', 'C', 'O', 'D', 'I', 'N', 'G', '_', 'P', 'A', 'C', 'K', 'E', 'T', '\0', /* MEC2_DECODING_PACKET (62889) */
	'M', 'E', 'C', '2', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '\0', /* MEC2_WAIT_ON_RCIU (62910) */
	'M', 'E', 'C', '2', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '_', 'R', 'E', 'A', 'D', '\0', /* MEC2_WAIT_ON_RCIU_READ (62928) */
	'M', 'E', 'C', '2', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'O', 'Q', '_', 'D', 'A', 'T', 'A', '\0', /* MEC2_WAIT_ON_ROQ_DATA (62951) */
	'U', 'T', 'C', 'L', '2', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* UTCL2IU_WAITING_ON_FREE (62973) */
	'U', 'T', 'C', 'L', '2', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'A', 'G', 'S', '\0', /* UTCL2IU_WAITING_ON_TAGS (62997) */
	'U', 'T', 'C', 'L', '1', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'R', 'A', 'N', 'S', '\0', /* UTCL1_WAITING_ON_TRANS (63021) */
	'G', 'C', 'R', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* GCRIU_WAITING_ON_FREE (63044) */
	'P', 'O', 'S', 'T', '_', 'W', 'P', 'T', 'R', '_', 'G', 'F', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* POST_WPTR_GFX_BUSY (63066) */
	'C', 'S', 'F', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_BUSY (63085) */
	'R', 'O', 'Q', '_', 'A', 'L', 'I', 'G', 'N', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_ALIGN_BUSY (63094) */
	'R', 'O', 'Q', '_', 'R', 'I', 'N', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_RING_BUSY (63109) */
	'R', 'O', 'Q', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_INDIRECT1_BUSY (63123) */
	'R', 'O', 'Q', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_INDIRECT2_BUSY (63142) */
	'R', 'O', 'Q', '_', 'S', 'T', 'A', 'T', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_STATE_BUSY (63161) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'R', 'I', 'N', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_RING_BUSY (63176) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_INDIRECT1_BUSY (63193) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_INDIRECT2_BUSY (63215) */
	'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* SEMAPHORE_BUSY (63237) */
	'I', 'N', 'T', 'E', 'R', 'R', 'U', 'P', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* INTERRUPT_BUSY (63252) */
	'H', 'Q', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_BUSY (63267) */
	'P', 'R', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* PRT_BUSY (63276) */
	'R', 'C', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU_BUSY (63285) */
	'R', 'C', 'I', 'U', '_', 'G', 'F', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU_GFX_BUSY (63295) */
	'R', 'C', 'I', 'U', '_', 'C', 'M', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU_CMP_BUSY (63309) */
	'R', 'O', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_DATA_BUSY (63323) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_DATA_BUSY (63337) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_BUSY (63354) */
	'C', 'P', 'F', '_', 'G', 'F', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_GFX_BUSY (63367) */
	'C', 'P', 'F', '_', 'C', 'M', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_CMP_BUSY (63380) */
	'G', 'R', 'B', 'M', '_', 'C', 'P', 'F', '_', 'S', 'T', 'A', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* GRBM_CPF_STAT_BUSY (63393) */
	'C', 'P', 'C', '_', 'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '\0', /* CPC_CPF_BUSY (63412) */
	'R', 'E', 'G', '_', 'B', 'U', 'S', '_', 'F', 'I', 'F', 'O', '_', 'B', 'U', 'S', 'Y', '\0', /* REG_BUS_FIFO_BUSY (63425) */
	'C', 'S', 'F', '_', 'R', 'I', 'N', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_RING_BUSY (63443) */
	'C', 'S', 'F', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_INDIRECT1_BUSY (63457) */
	'C', 'S', 'F', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_INDIRECT2_BUSY (63476) */
	'C', 'S', 'F', '_', 'S', 'T', 'A', 'T', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_STATE_BUSY (63495) */
	'C', 'S', 'F', '_', 'C', 'E', '_', 'I', 'N', 'D', 'R', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_CE_INDR1_BUSY (63510) */
	'C', 'S', 'F', '_', 'C', 'E', '_', 'I', 'N', 'D', 'R', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_CE_INDR2_BUSY (63528) */
	'C', 'S', 'F', '_', 'A', 'R', 'B', 'I', 'T', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_ARBITER_BUSY (63546) */
	'C', 'S', 'F', '_', 'I', 'N', 'P', 'U', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_INPUT_BUSY (63563) */
	'C', 'S', 'F', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_DATA_BUSY (63578) */
	'C', 'S', 'F', '_', 'C', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_CE_DATA_BUSY (63592) */
	'H', 'P', 'D', '_', 'P', 'R', 'O', 'C', 'E', 'S', 'S', 'I', 'N', 'G', '_', 'E', 'O', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* HPD_PROCESSING_EOP_BUSY (63609) */
	'H', 'Q', 'D', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_DISPATCH_BUSY (63633) */
	'H', 'Q', 'D', '_', 'I', 'Q', '_', 'T', 'I', 'M', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IQ_TIMER_BUSY (63651) */
	'H', 'Q', 'D', '_', 'D', 'M', 'A', '_', 'O', 'F', 'F', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_DMA_OFFLOAD_BUSY (63669) */
	'H', 'Q', 'D', '_', 'W', 'A', 'I', 'T', '_', 'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_WAIT_SEMAPHORE_BUSY (63690) */
	'H', 'Q', 'D', '_', 'S', 'I', 'G', 'N', 'A', 'L', '_', 'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_SIGNAL_SEMAPHORE_BUSY (63714) */
	'H', 'Q', 'D', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_MESSAGE_BUSY (63740) */
	'H', 'Q', 'D', '_', 'P', 'Q', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_PQ_FETCHER_BUSY (63757) */
	'H', 'Q', 'D', '_', 'I', 'B', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IB_FETCHER_BUSY (63777) */
	'H', 'Q', 'D', '_', 'I', 'Q', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IQ_FETCHER_BUSY (63797) */
	'H', 'Q', 'D', '_', 'E', 'O', 'P', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_EOP_FETCHER_BUSY (63817) */
	'H', 'Q', 'D', '_', 'C', 'O', 'N', 'S', 'U', 'M', 'E', 'D', '_', 'R', 'P', 'T', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_CONSUMED_RPTR_BUSY (63838) */
	'H', 'Q', 'D', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'A', 'R', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_FETCHER_ARB_BUSY (63861) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'A', 'L', 'I', 'G', 'N', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_ALIGN_BUSY (63882) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'E', 'O', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_EOP_BUSY (63901) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'I', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_IQ_BUSY (63918) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_PQ_BUSY (63934) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'I', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_IB_BUSY (63950) */
	'H', 'Q', 'D', '_', 'W', 'P', 'T', 'R', '_', 'P', 'O', 'L', 'L', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_WPTR_POLL_BUSY (63966) */
	'H', 'Q', 'D', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_PQ_BUSY (63985) */
	'H', 'Q', 'D', '_', 'I', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IB_BUSY (63997) */
	'R', 'I', 'N', 'G', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* RING_FETCHING_DATA (64009) */
	'I', 'N', 'D', 'R', '1', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* INDR1_FETCHING_DATA (64028) */
	'I', 'N', 'D', 'R', '2', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* INDR2_FETCHING_DATA (64048) */
	'S', 'T', 'A', 'T', 'E', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* STATE_FETCHING_DATA (64068) */
	'T', 'C', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* TCIU_WAITING_ON_FREE (64088) */
	'T', 'C', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'A', 'G', 'S', '\0', /* TCIU_WAITING_ON_TAGS (64109) */
	'G', 'F', 'X', '_', 'U', 'T', 'C', 'L', '1', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'R', 'A', 'N', 'S', '\0', /* GFX_UTCL1_WAITING_ON_TRANS (64130) */
	'C', 'M', 'P', '_', 'U', 'T', 'C', 'L', '1', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'R', 'A', 'N', 'S', '\0', /* CMP_UTCL1_WAITING_ON_TRANS (64157) */
	'R', 'C', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* RCIU_WAITING_ON_FREE (64184) */
	'D', 'A', 'T', 'A', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* DATA_FETCHING_DATA (64205) */
	'G', 'C', 'R', 'I', 'U', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* GCRIU_WAIT_ON_FREE (64224) */
	'M', 'E', 'S', '_', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_LOAD_BUSY (64243) */
	'M', 'E', 'S', '_', 'M', 'U', 'T', 'E', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_MUTEX_BUSY (64257) */
	'M', 'E', 'S', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_MESSAGE_BUSY (64272) */
	'M', 'E', 'S', '_', 'T', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_TC_BUSY (64289) */
	'M', 'E', 'S', '_', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_DMA_BUSY (64301) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE0_BUSY (64314) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE1_BUSY (64329) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE2_BUSY (64344) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE3_BUSY (64359) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'E', 'X', '_', '6', '4', 'B', 'I', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* SCRATCH_INDEX_64BIT_MODE (64374) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_DISPATCH_BUSY (64399) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'D', 'M', 'A', '_', 'O', 'F', 'F', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_DMA_OFFLOAD_BUSY (64421) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_MESSAGE_BUSY (64446) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'P', 'Q', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_PQ_FETCHER_BUSY (64467) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'C', 'O', 'N', 'S', 'U', 'M', 'E', 'D', '_', 'R', 'P', 'T', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_CONSUMED_RPTR_BUSY (64491) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'A', 'R', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_FETCHER_ARB_BUSY (64518) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'A', 'L', 'I', 'G', 'N', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_ROQ_ALIGN_BUSY (64543) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_ROQ_PQ_BUSY (64566) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_PQ_BUSY (64586) */
	'B', 'U', 'F', 'F', 'E', 'R', '_', 'I', 'D', '\0', /* BUFFER_ID (64602) */
	'S', 'I', 'M', 'D', '_', 'S', 'E', 'L', '\0', /* SIMD_SEL (64612) */
	'W', 'G', 'P', '_', 'S', 'E', 'L', '\0', /* WGP_SEL (64621) */
	'S', 'A', '_', 'S', 'E', 'L', '\0', /* SA_SEL (64629) */
	'W', 'T', 'Y', 'P', 'E', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '\0', /* WTYPE_INCLUDE (64636) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'V', 'M', 'E', 'M', 'E', 'X', 'E', 'C', '\0', /* TOKEN_EXCLUDE_VMEMEXEC (64650) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'A', 'L', 'U', 'E', 'X', 'E', 'C', '\0', /* TOKEN_EXCLUDE_ALUEXEC (64673) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'V', 'A', 'L', 'U', 'I', 'N', 'S', 'T', '\0', /* TOKEN_EXCLUDE_VALUINST (64695) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'W', 'A', 'V', 'E', 'R', 'D', 'Y', '\0', /* TOKEN_EXCLUDE_WAVERDY (64718) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'I', 'M', 'M', 'E', 'D', '1', '\0', /* TOKEN_EXCLUDE_IMMED1 (64740) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'I', 'M', 'M', 'E', 'D', 'I', 'A', 'T', 'E', '\0', /* TOKEN_EXCLUDE_IMMEDIATE (64761, 64775) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'R', 'E', 'G', '\0', /* TOKEN_EXCLUDE_REG (64785) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'E', 'V', 'E', 'N', 'T', '\0', /* TOKEN_EXCLUDE_EVENT (64803) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'I', 'N', 'S', 'T', '\0', /* TOKEN_EXCLUDE_INST (64823) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'U', 'T', 'I', 'L', 'C', 'T', 'R', '\0', /* TOKEN_EXCLUDE_UTILCTR (64842) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'W', 'A', 'V', 'E', 'A', 'L', 'L', 'O', 'C', '\0', /* TOKEN_EXCLUDE_WAVEALLOC (64864) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'P', 'E', 'R', 'F', '\0', /* TOKEN_EXCLUDE_PERF (64888) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '\0', /* TOKEN_EXCLUDE (64907) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'S', 'Q', 'D', 'E', 'C', '\0', /* REG_INCLUDE_SQDEC (64921) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'S', 'H', 'D', 'E', 'C', '\0', /* REG_INCLUDE_SHDEC (64939) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'G', 'F', 'X', 'U', 'D', 'E', 'C', '\0', /* REG_INCLUDE_GFXUDEC (64957) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'C', 'O', 'M', 'P', '\0', /* REG_INCLUDE_COMP (64977) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '\0', /* REG_INCLUDE_CONTEXT (64994) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* REG_INCLUDE_CONFIG (65014) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'O', 'T', 'H', 'E', 'R', '\0', /* REG_INCLUDE_OTHER (65033) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'R', 'E', 'A', 'D', 'S', '\0', /* REG_INCLUDE_READS (65051) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '\0', /* REG_INCLUDE (65069) */
	'I', 'N', 'S', 'T', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '\0', /* INST_EXCLUDE (65081) */
	'R', 'E', 'G', '_', 'D', 'E', 'T', 'A', 'I', 'L', '_', 'A', 'L', 'L', '\0', /* REG_DETAIL_ALL (65094) */
	'A', 'L', 'L', '_', 'V', 'M', 'I', 'D', '\0', /* ALL_VMID (65109) */
	'C', 'H', '_', 'P', 'E', 'R', 'F', '_', 'E', 'N', '\0', /* CH_PERF_EN (65118) */
	'I', 'N', 'T', 'E', 'R', 'R', 'U', 'P', 'T', '_', 'E', 'N', '\0', /* INTERRUPT_EN (65129) */
	'D', 'O', 'U', 'B', 'L', 'E', '_', 'B', 'U', 'F', 'F', 'E', 'R', '\0', /* DOUBLE_BUFFER (65142, 65149) */
	'R', 'E', 'G', '_', 'S', 'T', 'A', 'L', 'L', '_', 'E', 'N', '\0', /* REG_STALL_EN (65156) */
	'S', 'P', 'I', '_', 'S', 'T', 'A', 'L', 'L', '_', 'E', 'N', '\0', /* SPI_STALL_EN (65169) */
	'S', 'Q', '_', 'S', 'T', 'A', 'L', 'L', '_', 'E', 'N', '\0', /* SQ_STALL_EN (65182) */
	'R', 'E', 'G', '_', 'D', 'R', 'O', 'P', '_', 'O', 'N', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* REG_DROP_ON_STALL (65194) */
	'U', 'T', 'I', 'L', '_', 'T', 'I', 'M', 'E', 'R', '\0', /* UTIL_TIMER (65212) */
	'W', 'A', 'V', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* WAVESTART_MODE (65223) */
	'R', 'T', '_', 'F', 'R', 'E', 'Q', '\0', /* RT_FREQ (65238) */
	'S', 'Y', 'N', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'M', 'A', 'R', 'K', 'E', 'R', 'S', '\0', /* SYNC_COUNT_MARKERS (65246) */
	'S', 'Y', 'N', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'D', 'R', 'A', 'W', 'S', '\0', /* SYNC_COUNT_DRAWS (65265) */
	'C', 'A', 'P', 'T', 'U', 'R', 'E', '_', 'A', 'L', 'L', '\0', /* CAPTURE_ALL (65282) */
	'D', 'R', 'A', 'W', '_', 'E', 'V', 'E', 'N', 'T', '_', 'E', 'N', '\0', /* DRAW_EVENT_EN (65294) */
	'F', 'I', 'N', 'I', 'S', 'H', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* FINISH_PENDING (65308) */
	'F', 'I', 'N', 'I', 'S', 'H', '_', 'D', 'O', 'N', 'E', '\0', /* FINISH_DONE (65323, 65330) */
	'U', 'T', 'C', '_', 'E', 'R', 'R', '\0', /* UTC_ERR (65335) */
	'E', 'V', 'E', 'N', 'T', '_', 'C', 'N', 'T', 'R', '_', 'O', 'V', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* EVENT_CNTR_OVERFLOW (65343) */
	'E', 'V', 'E', 'N', 'T', '_', 'C', 'N', 'T', 'R', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* EVENT_CNTR_STALL (65363) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'M', 'R', 'T', '\0', /* SQ_EXP_MRT (65380) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'M', 'R', 'T', 'Z', '\0', /* SQ_EXP_MRTZ (65391) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'N', 'U', 'L', 'L', '\0', /* SQ_EXP_NULL (65403) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'P', 'O', 'S', '\0', /* SQ_EXP_POS (65415) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'P', 'R', 'I', 'M', '\0', /* SQ_EXP_PRIM (65426) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* SQ_EXP_PARAM (65438) */
	'T', 'G', 'T', '\0', /* TGT (65451) */
	'C', 'O', 'M', 'P', 'R', '\0', /* COMPR (65455) */
	'V', 'M', '\0', /* VM (65461) */
	'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'H', 'I', '\0', /* BASE_ADDRESS_HI (65464, 65469) */
	'C', 'A', 'C', 'H', 'E', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '\0', /* CACHE_SWIZZLE (65480) */
	'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SWIZZLE_ENABLE (65494) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'X', '\0', /* DST_SEL_X (65509) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'Y', '\0', /* DST_SEL_Y (65519) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'Z', '\0', /* DST_SEL_Z (65529) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'W', '\0', /* DST_SEL_W (65539) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* GFX10_FORMAT_INVALID (65549) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_UNORM (65570) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_SNORM (65591) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_USCALED (65612) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_SSCALED (65635) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_UINT (65658) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_SINT (65678) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_UNORM (65698) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_SNORM (65720) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_USCALED (65742) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_SSCALED (65766) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_UINT (65790) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_SINT (65811) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_16_FLOAT (65832) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_UNORM (65854) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_SNORM (65877) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_USCALED (65900) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_SSCALED (65925) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_UINT (65950) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_SINT (65972) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_UINT (65994) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_SINT (66015) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_FLOAT (66036) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_UNORM (66058) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_SNORM (66083) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_USCALED (66108) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_SSCALED (66135) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_UINT (66162) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_SINT (66186) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_16_16_FLOAT (66210) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_11_11_UNORM (66235) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_11_11_SNORM (66263) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_11_11_USCALED (66291) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_11_11_SSCALED (66321) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_11_11_UINT (66351) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_11_11_SINT (66378) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_10_11_11_FLOAT (66405) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_11_11_10_UNORM (66433) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_11_11_10_SNORM (66461) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_11_11_10_USCALED (66489) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_11_11_10_SSCALED (66519) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_11_11_10_UINT (66549) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_11_11_10_SINT (66576) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_11_11_10_FLOAT (66603) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_10_10_2_UNORM (66631) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_10_10_2_SNORM (66661) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_10_10_2_USCALED (66691) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_10_10_2_SSCALED (66723) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_10_10_2_UINT (66755) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_10_10_2_SINT (66784) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_2_10_10_10_UNORM (66813) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_2_10_10_10_SNORM (66843) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_2_10_10_10_USCALED (66873) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_2_10_10_10_SSCALED (66905) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_2_10_10_10_UINT (66937) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_2_10_10_10_SINT (66966) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_8_8_UNORM (66995) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_8_8_SNORM (67022) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_8_8_USCALED (67049) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_8_8_SSCALED (67078) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_8_8_UINT (67107) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_8_8_SINT (67133) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_UINT (67159) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_SINT (67183) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_32_FLOAT (67207) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_16_16_UNORM (67232) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_16_16_SNORM (67263) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_16_16_USCALED (67294) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_16_16_SSCALED (67327) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_16_16_UINT (67360) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_16_16_SINT (67390) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_16_16_16_16_FLOAT (67420) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_UINT (67451) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_SINT (67478) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_32_32_FLOAT (67505) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_32_UINT (67533) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_32_SINT (67563) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_32_32_32_FLOAT (67593) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_8_SRGB (67624) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_8_8_SRGB (67644) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_8_8_8_8_SRGB (67666) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '6', 'E', '4', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_6E4_FLOAT (67692) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '5', '_', '9', '_', '9', '_', '9', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_5_9_9_9_FLOAT (67715) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '5', '_', '6', '_', '5', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_5_6_5_UNORM (67742) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '_', '5', '_', '5', '_', '5', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_1_5_5_5_UNORM (67767) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '5', '_', '5', '_', '5', '_', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_5_5_5_1_UNORM (67794) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '4', '_', '4', '_', '4', '_', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_4_4_4_4_UNORM (67821) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '4', '_', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_4_4_UNORM (67848) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_1_UNORM (67871) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '_', 'R', 'E', 'V', 'E', 'R', 'S', 'E', 'D', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_1_REVERSED_UNORM (67892) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* GFX10_FORMAT_32_FLOAT_CLAMP (67922) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '2', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_24_UNORM (67950) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '2', '4', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_24_UINT (67974) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '4', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_24_8_UNORM (67997) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '4', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_24_8_UINT (68021) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'X', '2', '4', '_', '8', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_X24_8_32_UINT (68044) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'X', '2', '4', '_', '8', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_X24_8_32_FLOAT (68071) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_GB_GR_UNORM (68099) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_GB_GR_SNORM (68124) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_GB_GR_UINT (68149) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_GB_GR_SRGB (68173) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BG_RG_UNORM (68197) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BG_RG_SNORM (68222) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_BG_RG_UINT (68247) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BG_RG_SRGB (68271) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '2', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK8_S2_F1 (68295) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '4', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK8_S4_F1 (68321) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '8', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK8_S8_F1 (68347) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '2', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK8_S2_F2 (68373) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '4', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK8_S4_F2 (68399) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '4', '_', 'F', '4', '\0', /* GFX10_FORMAT_FMASK8_S4_F4 (68425) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '1', '6', '_', 'S', '1', '6', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK16_S16_F1 (68451) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '1', '6', '_', 'S', '8', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK16_S8_F2 (68479) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '3', '2', '_', 'S', '1', '6', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK32_S16_F2 (68506) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '3', '2', '_', 'S', '8', '_', 'F', '4', '\0', /* GFX10_FORMAT_FMASK32_S8_F4 (68534) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '3', '2', '_', 'S', '8', '_', 'F', '8', '\0', /* GFX10_FORMAT_FMASK32_S8_F8 (68561) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '6', '4', '_', 'S', '1', '6', '_', 'F', '4', '\0', /* GFX10_FORMAT_FMASK64_S16_F4 (68588) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '6', '4', '_', 'S', '1', '6', '_', 'F', '8', '\0', /* GFX10_FORMAT_FMASK64_S16_F8 (68616) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC1_UNORM (68644) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '1', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC1_SRGB (68667) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '2', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC2_UNORM (68689) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '2', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC2_SRGB (68712) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '3', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC3_UNORM (68734) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '3', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC3_SRGB (68757) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC4_UNORM (68779) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '4', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC4_SNORM (68802) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '5', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC5_UNORM (68825) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '5', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC5_SNORM (68848) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '6', '_', 'U', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_BC6_UFLOAT (68871) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '6', '_', 'S', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_BC6_SFLOAT (68895) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '7', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC7_UNORM (68919) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '7', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC7_SRGB (68942) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_8_UNORM (68964) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_8_UINT (68988) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_8_8_UNORM (69011) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_8_8_UINT (69037) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_8_8_8_8_UNORM (69062) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_8_8_8_8_UINT (69092) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', 'V', 'Y', 'U', 'Y', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_VYUY8_UNORM (69121) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', 'V', 'Y', 'U', 'Y', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_VYUY8_UINT (69149) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_10_11_11_UNORM (69176) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_11_11_UINT (69207) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_2_10_10_10_UNORM (69237) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_2_10_10_10_UINT (69270) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_16_16_16_16_UNORM (69302) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_16_16_16_16_UINT (69336) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_10_IN_16_UNORM (69369) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_IN_16_UINT (69400) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_UNORM (69430) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_UINT (69464) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', ' ', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_16_16_UNORM  (69497) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_16_16_UINT (69538) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '7', 'E', '3', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_7E3_FLOAT (69577) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_YCBCR_UNORM (69600) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_YCBCR_SNORM (69625) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_YCBCR_USCALED (69650) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_YCBCR_SSCALED (69677) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_YCBCR_UINT (69704) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_YCBCR_SINT (69728) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_YCBCR_SRGB (69752) */
	'I', 'N', 'D', 'E', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '\0', /* INDEX_STRIDE (69776) */
	'A', 'D', 'D', '_', 'T', 'I', 'D', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* ADD_TID_ENABLE (69789) */
	'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* RESOURCE_LEVEL (69804) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'S', 'T', 'R', 'U', 'C', 'T', 'U', 'R', 'E', 'D', '_', 'W', 'I', 'T', 'H', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* OOB_SELECT_STRUCTURED_WITH_OFFSET (69819) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'S', 'T', 'R', 'U', 'C', 'T', 'U', 'R', 'E', 'D', '\0', /* OOB_SELECT_STRUCTURED (69853) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', 'D', '\0', /* OOB_SELECT_DISABLED (69875) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'R', 'A', 'W', '\0', /* OOB_SELECT_RAW (69895, 69906) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* OOB_SELECT (69910) */
	'C', 'L', 'A', 'M', 'P', '_', 'X', '\0', /* CLAMP_X (69921) */
	'C', 'L', 'A', 'M', 'P', '_', 'Y', '\0', /* CLAMP_Y (69929) */
	'C', 'L', 'A', 'M', 'P', '_', 'Z', '\0', /* CLAMP_Z (69937) */
	'M', 'A', 'X', '_', 'A', 'N', 'I', 'S', 'O', '_', 'R', 'A', 'T', 'I', 'O', '\0', /* MAX_ANISO_RATIO (69945) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'M', 'P', 'A', 'R', 'E', '_', 'F', 'U', 'N', 'C', '\0', /* DEPTH_COMPARE_FUNC (69961) */
	'F', 'O', 'R', 'C', 'E', '_', 'U', 'N', 'N', 'O', 'R', 'M', 'A', 'L', 'I', 'Z', 'E', 'D', '\0', /* FORCE_UNNORMALIZED (69980) */
	'A', 'N', 'I', 'S', 'O', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* ANISO_THRESHOLD (69999) */
	'M', 'C', '_', 'C', 'O', 'O', 'R', 'D', '_', 'T', 'R', 'U', 'N', 'C', '\0', /* MC_COORD_TRUNC (70015) */
	'F', 'O', 'R', 'C', 'E', '_', 'D', 'E', 'G', 'A', 'M', 'M', 'A', '\0', /* FORCE_DEGAMMA (70030) */
	'A', 'N', 'I', 'S', 'O', '_', 'B', 'I', 'A', 'S', '\0', /* ANISO_BIAS (70044) */
	'T', 'R', 'U', 'N', 'C', '_', 'C', 'O', 'O', 'R', 'D', '\0', /* TRUNC_COORD (70055) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'U', 'B', 'E', '_', 'W', 'R', 'A', 'P', '\0', /* DISABLE_CUBE_WRAP (70067, 70080) */
	'F', 'I', 'L', 'T', 'E', 'R', '_', 'M', 'O', 'D', 'E', '\0', /* FILTER_MODE (70085) */
	'S', 'K', 'I', 'P', '_', 'D', 'E', 'G', 'A', 'M', 'M', 'A', '\0', /* SKIP_DEGAMMA (70097) */
	'M', 'I', 'N', '_', 'L', 'O', 'D', '\0', /* MIN_LOD (70110) */
	'M', 'A', 'X', '_', 'L', 'O', 'D', '\0', /* MAX_LOD (70118) */
	'P', 'E', 'R', 'F', '_', 'M', 'I', 'P', '\0', /* PERF_MIP (70126) */
	'P', 'E', 'R', 'F', '_', 'Z', '\0', /* PERF_Z (70135) */
	'L', 'O', 'D', '_', 'B', 'I', 'A', 'S', '\0', /* LOD_BIAS (70142) */
	'B', 'O', 'R', 'D', 'E', 'R', '_', 'C', 'O', 'L', 'O', 'R', '_', 'P', 'T', 'R', '\0', /* BORDER_COLOR_PTR (70151) */
	'B', 'O', 'R', 'D', 'E', 'R', '_', 'C', 'O', 'L', 'O', 'R', '_', 'T', 'Y', 'P', 'E', '\0', /* BORDER_COLOR_TYPE (70168) */
	'L', 'O', 'D', '_', 'B', 'I', 'A', 'S', '_', 'S', 'E', 'C', '\0', /* LOD_BIAS_SEC (70186) */
	'X', 'Y', '_', 'M', 'A', 'G', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* XY_MAG_FILTER (70199) */
	'X', 'Y', '_', 'M', 'I', 'N', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* XY_MIN_FILTER (70213) */
	'Z', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* Z_FILTER (70227) */
	'M', 'I', 'P', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* MIP_FILTER (70236) */
	'M', 'I', 'P', '_', 'P', 'O', 'I', 'N', 'T', '_', 'P', 'R', 'E', 'C', 'L', 'A', 'M', 'P', '\0', /* MIP_POINT_PRECLAMP (70247) */
	'A', 'N', 'I', 'S', 'O', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* ANISO_OVERRIDE (70266) */
	'B', 'L', 'E', 'N', 'D', '_', 'Z', 'E', 'R', 'O', '_', 'P', 'R', 'T', '\0', /* BLEND_ZERO_PRT (70281) */
	'D', 'E', 'R', 'I', 'V', '_', 'A', 'D', 'J', 'U', 'S', 'T', '_', 'E', 'N', '\0', /* DERIV_ADJUST_EN (70296) */
	'G', 'P', 'R', '_', 'W', 'R', 'I', 'T', 'E', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '\0', /* GPR_WRITE_PRIORITY (70312, 70322) */
	'E', 'X', 'P', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* EXP_PRIORITY_ORDER (70331) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'S', 'Q', 'G', '_', 'T', 'O', 'P', '_', 'E', 'V', 'E', 'N', 'T', 'S', '\0', /* ENABLE_SQG_TOP_EVENTS (70350) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'S', 'Q', 'G', '_', 'B', 'O', 'P', '_', 'E', 'V', 'E', 'N', 'T', 'S', '\0', /* ENABLE_SQG_BOP_EVENTS (70372) */
	'R', 'S', 'R', 'C', '_', 'M', 'G', 'M', 'T', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* RSRC_MGMT_RESET (70394) */
	'T', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'A', 'L', 'L', '_', 'A', 'L', 'L', '\0', /* TTRACE_STALL_ALL (70410) */
	'A', 'L', 'L', 'O', 'C', '_', 'A', 'R', 'B', '_', 'L', 'R', 'U', '_', 'E', 'N', 'A', '\0', /* ALLOC_ARB_LRU_ENA (70427) */
	'E', 'X', 'P', '_', 'A', 'R', 'B', '_', 'L', 'R', 'U', '_', 'E', 'N', 'A', '\0', /* EXP_ARB_LRU_ENA (70445) */
	'P', 'S', '_', 'P', 'K', 'R', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', 'C', 'N', 'T', 'L', '\0', /* PS_PKR_PRIORITY_CNTL (70461) */
	'N', 'U', 'M', '_', 'P', 'I', 'P', 'E', 'S', '\0', /* NUM_PIPES (70482) */
	'P', 'I', 'P', 'E', '_', 'I', 'N', 'T', 'E', 'R', 'L', 'E', 'A', 'V', 'E', '_', 'S', 'I', 'Z', 'E', '\0', /* PIPE_INTERLEAVE_SIZE (70492) */
	'M', 'A', 'X', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'E', 'D', '_', 'F', 'R', 'A', 'G', 'S', '\0', /* MAX_COMPRESSED_FRAGS (70513) */
	'N', 'U', 'M', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'E', 'N', 'G', 'I', 'N', 'E', 'S', '\0', /* NUM_SHADER_ENGINES (70534) */
	'N', 'U', 'M', '_', 'R', 'B', '_', 'P', 'E', 'R', '_', 'S', 'E', '\0', /* NUM_RB_PER_SE (70553) */
	'A', 'R', 'R', 'A', 'Y', '_', 'L', 'I', 'N', 'E', 'A', 'R', '_', 'G', 'E', 'N', 'E', 'R', 'A', 'L', '\0', /* ARRAY_LINEAR_GENERAL (70567, 70573) */
	'A', 'R', 'R', 'A', 'Y', '_', 'L', 'I', 'N', 'E', 'A', 'R', '_', 'A', 'L', 'I', 'G', 'N', 'E', 'D', '\0', /* ARRAY_LINEAR_ALIGNED (70588) */
	'A', 'R', 'R', 'A', 'Y', '_', '1', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_1D_TILED_THIN1 (70609) */
	'A', 'R', 'R', 'A', 'Y', '_', '1', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_1D_TILED_THICK (70630) */
	'A', 'R', 'R', 'A', 'Y', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_2D_TILED_THIN1 (70651) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_PRT_TILED_THIN1 (70672) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_PRT_2D_TILED_THIN1 (70694) */
	'A', 'R', 'R', 'A', 'Y', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_2D_TILED_THICK (70719) */
	'A', 'R', 'R', 'A', 'Y', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'X', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_2D_TILED_XTHICK (70740) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_PRT_TILED_THICK (70762) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_PRT_2D_TILED_THICK (70784) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_PRT_3D_TILED_THIN1 (70809) */
	'A', 'R', 'R', 'A', 'Y', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_3D_TILED_THIN1 (70834) */
	'A', 'R', 'R', 'A', 'Y', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_3D_TILED_THICK (70855) */
	'A', 'R', 'R', 'A', 'Y', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'X', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_3D_TILED_XTHICK (70876) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_PRT_3D_TILED_THICK (70898) */
	'A', 'R', 'R', 'A', 'Y', '_', 'M', 'O', 'D', 'E', '\0', /* ARRAY_MODE (70923) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '\0', /* ADDR_SURF_P2 (70934) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '0', '\0', /* ADDR_SURF_P2_RESERVED0 (70947) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '1', '\0', /* ADDR_SURF_P2_RESERVED1 (70970, 70983) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '2', '\0', /* ADDR_SURF_P2_RESERVED2 (70993, 71006) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P4_8x16 (71016) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P4_16x16 (71034) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '1', '6', 'x', '3', '2', '\0', /* ADDR_SURF_P4_16x32 (71053) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '3', '2', 'x', '3', '2', '\0', /* ADDR_SURF_P4_32x32 (71072) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '1', '6', 'x', '1', '6', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P8_16x16_8x16 (71091) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '1', '6', 'x', '3', '2', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P8_16x32_8x16 (71115) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '3', '2', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P8_32x32_8x16 (71139) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '1', '6', 'x', '3', '2', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P8_16x32_16x16 (71163) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '3', '2', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P8_32x32_16x16 (71188) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '3', '2', '_', '1', '6', 'x', '3', '2', '\0', /* ADDR_SURF_P8_32x32_16x32 (71213) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '6', '4', '_', '3', '2', 'x', '3', '2', '\0', /* ADDR_SURF_P8_32x64_32x32 (71238) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '0', '\0', /* ADDR_SURF_P8_RESERVED0 (71263) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '1', '6', '_', '3', '2', 'x', '3', '2', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P16_32x32_8x16 (71286) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '1', '6', '_', '3', '2', 'x', '3', '2', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P16_32x32_16x16 (71311) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '1', '6', '\0', /* ADDR_SURF_P16 (71337) */
	'P', 'I', 'P', 'E', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* PIPE_CONFIG (71351) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '6', '4', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_64B (71363) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '1', '2', '8', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_128B (71388) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '2', '5', '6', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_256B (71414) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '5', '1', '2', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_512B (71440) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '1', 'K', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_1KB (71466) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '2', 'K', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_2KB (71491) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '4', 'K', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_4KB (71516) */
	'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '\0', /* TILE_SPLIT (71541) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'D', 'I', 'S', 'P', 'L', 'A', 'Y', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_DISPLAY_MICRO_TILING (71552) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'H', 'I', 'N', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_THIN_MICRO_TILING (71583) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'D', 'E', 'P', 'T', 'H', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_DEPTH_MICRO_TILING (71611) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'R', 'O', 'T', 'A', 'T', 'E', 'D', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_ROTATED_MICRO_TILING (71640) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'H', 'I', 'C', 'K', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_THICK_MICRO_TILING (71671) */
	'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '_', 'N', 'E', 'W', '\0', /* MICRO_TILE_MODE_NEW (71700) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '\0', /* SAMPLE_SPLIT (71720) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '1', '\0', /* ADDR_SURF_BANK_WIDTH_1 (71733) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '2', '\0', /* ADDR_SURF_BANK_WIDTH_2 (71756) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '4', '\0', /* ADDR_SURF_BANK_WIDTH_4 (71779) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '8', '\0', /* ADDR_SURF_BANK_WIDTH_8 (71802) */
	'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '\0', /* BANK_WIDTH (71825, 71830) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '1', '\0', /* ADDR_SURF_BANK_HEIGHT_1 (71836) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '2', '\0', /* ADDR_SURF_BANK_HEIGHT_2 (71860) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '4', '\0', /* ADDR_SURF_BANK_HEIGHT_4 (71884) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '8', '\0', /* ADDR_SURF_BANK_HEIGHT_8 (71908) */
	'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '\0', /* BANK_HEIGHT (71932, 71937) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '1', '\0', /* ADDR_SURF_MACRO_ASPECT_1 (71944) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '2', '\0', /* ADDR_SURF_MACRO_ASPECT_2 (71969) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '4', '\0', /* ADDR_SURF_MACRO_ASPECT_4 (71994) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '8', '\0', /* ADDR_SURF_MACRO_ASPECT_8 (72019) */
	'M', 'A', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'E', '_', 'A', 'S', 'P', 'E', 'C', 'T', '\0', /* MACRO_TILE_ASPECT (72044) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '2', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_2_BANK (72062) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '4', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_4_BANK (72079) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '8', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_8_BANK (72096) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '1', '6', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_16_BANK (72113) */
	'N', 'U', 'M', '_', 'B', 'A', 'N', 'K', 'S', '\0', /* NUM_BANKS (72131) */
	'W', 'I', 'D', 'T', 'H', '_', 'L', 'O', '\0', /* WIDTH_LO (72141) */
	'W', 'I', 'D', 'T', 'H', '_', 'H', 'I', '\0', /* WIDTH_HI (72150) */
	'B', 'A', 'S', 'E', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* BASE_LEVEL (72159) */
	'L', 'A', 'S', 'T', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* LAST_LEVEL (72170) */
	'S', 'W', '_', 'M', 'O', 'D', 'E', '\0', /* SW_MODE (72181) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'X', 'Y', 'Z', 'W', '\0', /* BC_SWIZZLE_XYZW (72189) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'X', 'W', 'Y', 'Z', '\0', /* BC_SWIZZLE_XWYZ (72205) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'W', 'Z', 'Y', 'X', '\0', /* BC_SWIZZLE_WZYX (72221) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'W', 'X', 'Y', 'Z', '\0', /* BC_SWIZZLE_WXYZ (72237) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'Z', 'Y', 'X', 'W', '\0', /* BC_SWIZZLE_ZYXW (72253) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'Y', 'X', 'W', 'Z', '\0', /* BC_SWIZZLE_YXWZ (72269) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '\0', /* BC_SWIZZLE (72285) */
	'B', 'A', 'S', 'E', '_', 'A', 'R', 'R', 'A', 'Y', '\0', /* BASE_ARRAY (72296) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* ARRAY_PITCH (72307) */
	'M', 'A', 'X', '_', 'M', 'I', 'P', '\0', /* MAX_MIP (72319) */
	'M', 'I', 'N', '_', 'L', 'O', 'D', '_', 'W', 'A', 'R', 'N', '\0', /* MIN_LOD_WARN (72327) */
	'P', 'E', 'R', 'F', '_', 'M', 'O', 'D', '\0', /* PERF_MOD (72340) */
	'C', 'O', 'R', 'N', 'E', 'R', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* CORNER_SAMPLES (72349) */
	'L', 'O', 'D', '_', 'H', 'D', 'W', '_', 'C', 'N', 'T', '_', 'E', 'N', '\0', /* LOD_HDW_CNT_EN (72364) */
	'P', 'R', 'T', '_', 'D', 'E', 'F', 'A', 'U', 'L', 'T', '\0', /* PRT_DEFAULT (72379) */
	'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'B', 'A', 'N', 'K', '_', 'I', 'D', '\0', /* COUNTER_BANK_ID (72391) */
	'I', 'T', 'E', 'R', 'A', 'T', 'E', '_', '2', '5', '6', '\0', /* ITERATE_256 (72407) */
	'M', 'A', 'X', '_', 'U', 'N', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'E', 'D', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '\0', /* MAX_UNCOMPRESSED_BLOCK_SIZE (72419) */
	'M', 'A', 'X', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'E', 'D', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '\0', /* MAX_COMPRESSED_BLOCK_SIZE (72447) */
	'M', 'E', 'T', 'A', '_', 'P', 'I', 'P', 'E', '_', 'A', 'L', 'I', 'G', 'N', 'E', 'D', '\0', /* META_PIPE_ALIGNED (72473, 72478) */
	'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* WRITE_COMPRESS_ENABLE (72491) */
	'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'I', 'O', 'N', '_', 'E', 'N', '\0', /* COMPRESSION_EN (72513) */
	'A', 'L', 'P', 'H', 'A', '_', 'I', 'S', '_', 'O', 'N', '_', 'M', 'S', 'B', '\0', /* ALPHA_IS_ON_MSB (72528) */
	'C', 'O', 'L', 'O', 'R', '_', 'T', 'R', 'A', 'N', 'S', 'F', 'O', 'R', 'M', '\0', /* COLOR_TRANSFORM (72544) */
	'M', 'E', 'T', 'A', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'L', 'O', '\0', /* META_DATA_ADDRESS_LO (72560) */
	'C', 'U', '_', 'E', 'N', '\0', /* CU_EN (72581) */
	'W', 'A', 'V', 'E', '_', 'L', 'I', 'M', 'I', 'T', '\0', /* WAVE_LIMIT (72587, 72592) */
	'L', 'O', 'C', 'K', '_', 'L', 'O', 'W', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* LOCK_LOW_THRESHOLD (72598) */
	'M', 'E', 'M', '_', 'B', 'A', 'S', 'E', '\0', /* MEM_BASE (72617) */
	'V', 'G', 'P', 'R', 'S', '\0', /* VGPRS (72626) */
	'S', 'G', 'P', 'R', 'S', '\0', /* SGPRS (72632) */
	'F', 'P', '_', '3', '2', '_', 'R', 'O', 'U', 'N', 'D', '_', 'T', 'O', 'W', 'A', 'R', 'D', 'S', '_', 'Z', 'E', 'R', 'O', '\0', /* FP_32_ROUND_TOWARDS_ZERO (72638) */
	'F', 'P', '_', '1', '6', '_', '6', '4', '_', 'R', 'O', 'U', 'N', 'D', '_', 'T', 'O', 'W', 'A', 'R', 'D', 'S', '_', 'Z', 'E', 'R', 'O', '\0', /* FP_16_64_ROUND_TOWARDS_ZERO (72663) */
	'F', 'P', '_', '3', '2', '_', 'D', 'E', 'N', 'O', 'R', 'M', 'S', '\0', /* FP_32_DENORMS (72691) */
	'F', 'P', '_', '1', '6', '_', '6', '4', '_', 'D', 'E', 'N', 'O', 'R', 'M', 'S', '\0', /* FP_16_64_DENORMS (72705) */
	'F', 'L', 'O', 'A', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* FLOAT_MODE (72722) */
	'I', 'E', 'E', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* IEEE_MODE (72733) */
	'C', 'U', '_', 'G', 'R', 'O', 'U', 'P', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* CU_GROUP_DISABLE (72743) */
	'M', 'E', 'M', '_', 'O', 'R', 'D', 'E', 'R', 'E', 'D', '\0', /* MEM_ORDERED (72760) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'E', 'N', '\0', /* SCRATCH_EN (72772) */
	'U', 'S', 'E', 'R', '_', 'S', 'G', 'P', 'R', '\0', /* USER_SGPR (72783) */
	'T', 'R', 'A', 'P', '_', 'P', 'R', 'E', 'S', 'E', 'N', 'T', '\0', /* TRAP_PRESENT (72793) */
	'W', 'A', 'V', 'E', '_', 'C', 'N', 'T', '_', 'E', 'N', '\0', /* WAVE_CNT_EN (72806) */
	'E', 'X', 'T', 'R', 'A', '_', 'L', 'D', 'S', '_', 'S', 'I', 'Z', 'E', '\0', /* EXTRA_LDS_SIZE (72818) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'L', 'L', 'I', 'S', 'I', 'O', 'N', '_', 'W', 'A', 'V', 'E', 'I', 'D', '\0', /* LOAD_COLLISION_WAVEID (72833) */
	'L', 'O', 'A', 'D', '_', 'I', 'N', 'T', 'R', 'A', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'L', 'L', 'I', 'S', 'I', 'O', 'N', '\0', /* LOAD_INTRAWAVE_COLLISION (72855) */
	'U', 'S', 'E', 'R', '_', 'S', 'G', 'P', 'R', '_', 'M', 'S', 'B', '\0', /* USER_SGPR_MSB (72880) */
	'S', 'H', 'A', 'R', 'E', 'D', '_', 'V', 'G', 'P', 'R', '_', 'C', 'N', 'T', '\0', /* SHARED_VGPR_CNT (72894) */
	'S', 'O', 'F', 'T', '_', 'G', 'R', 'O', 'U', 'P', 'I', 'N', 'G', '_', 'E', 'N', '\0', /* SOFT_GROUPING_EN (72910) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'O', 'F', '_', 'R', 'E', 'Q', 'U', 'E', 'S', 'T', 'S', '_', 'P', 'E', 'R', '_', 'C', 'U', '\0', /* NUMBER_OF_REQUESTS_PER_CU (72927) */
	'S', 'O', 'F', 'T', '_', 'G', 'R', 'O', 'U', 'P', 'I', 'N', 'G', '_', 'A', 'L', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '_', 'T', 'I', 'M', 'E', 'O', 'U', 'T', '\0', /* SOFT_GROUPING_ALLOCATION_TIMEOUT (72953) */
	'H', 'A', 'R', 'D', '_', 'L', 'O', 'C', 'K', '_', 'H', 'Y', 'S', 'T', 'E', 'R', 'E', 'S', 'I', 'S', '\0', /* HARD_LOCK_HYSTERESIS (72986) */
	'H', 'A', 'R', 'D', '_', 'L', 'O', 'C', 'K', '_', 'L', 'O', 'W', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* HARD_LOCK_LOW_THRESHOLD (73007) */
	'P', 'R', 'O', 'D', 'U', 'C', 'E', 'R', '_', 'R', 'E', 'Q', 'U', 'E', 'S', 'T', '_', 'L', 'O', 'C', 'K', 'O', 'U', 'T', '\0', /* PRODUCER_REQUEST_LOCKOUT (73031) */
	'G', 'L', 'O', 'B', 'A', 'L', '_', 'S', 'C', 'A', 'N', 'N', 'I', 'N', 'G', '_', 'E', 'N', '\0', /* GLOBAL_SCANNING_EN (73056) */
	'A', 'L', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '_', 'R', 'A', 'T', 'E', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'I', 'N', 'G', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* ALLOCATION_RATE_THROTTLING_THRESHOLD (73075) */
	'T', 'O', 'T', 'A', 'L', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TOTAL_WAVE_COUNT_HIER_SELECT (73112) */
	'P', 'E', 'R', '_', 'T', 'Y', 'P', 'E', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PER_TYPE_WAVE_COUNT_HIER_SELECT (73141) */
	'G', 'R', 'O', 'U', 'P', '_', 'U', 'P', 'D', 'A', 'T', 'E', '_', 'E', 'N', '\0', /* GROUP_UPDATE_EN (73173) */
	'T', 'O', 'T', 'A', 'L', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'C', 'O', 'E', 'F', 'F', 'I', 'C', 'I', 'E', 'N', 'T', '\0', /* TOTAL_WAVE_COUNT_COEFFICIENT (73189) */
	'P', 'E', 'R', '_', 'T', 'Y', 'P', 'E', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'C', 'O', 'E', 'F', 'F', 'I', 'C', 'I', 'E', 'N', 'T', '\0', /* PER_TYPE_WAVE_COUNT_COEFFICIENT (73218) */
	'C', 'O', 'N', 'T', 'R', 'I', 'B', 'U', 'T', 'I', 'O', 'N', '\0', /* CONTRIBUTION (73250) */
	'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* VGPR_COMP_CNT (73263) */
	'C', 'U', '_', 'G', 'R', 'O', 'U', 'P', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* CU_GROUP_ENABLE (73277) */
	'O', 'C', '_', 'L', 'D', 'S', '_', 'E', 'N', '\0', /* OC_LDS_EN (73293) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '0', '_', 'E', 'N', '\0', /* SO_BASE0_EN (73303) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '1', '_', 'E', 'N', '\0', /* SO_BASE1_EN (73315) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '2', '_', 'E', 'N', '\0', /* SO_BASE2_EN (73327) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '3', '_', 'E', 'N', '\0', /* SO_BASE3_EN (73339) */
	'S', 'O', '_', 'E', 'N', '\0', /* SO_EN (73351) */
	'P', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', '\0', /* PC_BASE_EN (73357) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'D', 'R', 'A', 'W', '_', 'E', 'N', '\0', /* DISPATCH_DRAW_EN (73368) */
	'S', 'K', 'I', 'P', '_', 'U', 'S', 'G', 'P', 'R', '0', '\0', /* SKIP_USGPR0 (73385) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'L', 'A', 'T', 'E', '_', 'A', 'L', 'L', 'O', 'C', '_', 'G', 'S', '\0', /* SPI_SHADER_LATE_ALLOC_GS (73397) */
	'G', 'R', 'O', 'U', 'P', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* GROUP_FIFO_DEPTH (73422) */
	'W', 'G', 'P', '_', 'M', 'O', 'D', 'E', '\0', /* WGP_MODE (73439) */
	'G', 'S', '_', 'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* GS_VGPR_COMP_CNT (73448) */
	'E', 'S', '_', 'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* ES_VGPR_COMP_CNT (73465) */
	'L', 'S', '_', 'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* LS_VGPR_COMP_CNT (73482) */
	'T', 'G', '_', 'S', 'I', 'Z', 'E', '_', 'E', 'N', '\0', /* TG_SIZE_EN (73499) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'E', 'N', '\0', /* COMPUTE_SHADER_EN (73510) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'T', 'G', '_', 'E', 'N', '\0', /* PARTIAL_TG_EN (73528) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'A', 'T', '_', '0', '0', '0', '\0', /* FORCE_START_AT_000 (73542) */
	'O', 'R', 'D', 'E', 'R', 'E', 'D', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'E', 'N', 'B', 'L', '\0', /* ORDERED_APPEND_ENBL (73561) */
	'O', 'R', 'D', 'E', 'R', 'E', 'D', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'M', 'O', 'D', 'E', '\0', /* ORDERED_APPEND_MODE (73581) */
	'U', 'S', 'E', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'D', 'I', 'M', 'E', 'N', 'S', 'I', 'O', 'N', 'S', '\0', /* USE_THREAD_DIMENSIONS (73601) */
	'O', 'R', 'D', 'E', 'R', '_', 'M', 'O', 'D', 'E', '\0', /* ORDER_MODE (73623) */
	'S', 'C', 'A', 'L', 'A', 'R', '_', 'L', '1', '_', 'I', 'N', 'V', '_', 'V', 'O', 'L', '\0', /* SCALAR_L1_INV_VOL (73634, 73648) */
	'V', 'E', 'C', 'T', 'O', 'R', '_', 'L', '1', '_', 'I', 'N', 'V', '_', 'V', 'O', 'L', '\0', /* VECTOR_L1_INV_VOL (73652) */
	'T', 'U', 'N', 'N', 'E', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TUNNEL_ENABLE (73670) */
	'R', 'E', 'S', 'T', 'O', 'R', 'E', '\0', /* RESTORE (73684) */
	'C', 'S', '_', 'W', '3', '2', '_', 'E', 'N', '\0', /* CS_W32_EN (73692) */
	'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'F', 'U', 'L', 'L', '\0', /* NUM_THREAD_FULL (73702, 73713) */
	'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '\0', /* NUM_THREAD_PARTIAL (73718) */
	'B', 'U', 'L', 'K', 'Y', '\0', /* BULKY (73737) */
	'T', 'G', 'I', 'D', '_', 'X', '_', 'E', 'N', '\0', /* TGID_X_EN (73743) */
	'T', 'G', 'I', 'D', '_', 'Y', '_', 'E', 'N', '\0', /* TGID_Y_EN (73753) */
	'T', 'G', 'I', 'D', '_', 'Z', '_', 'E', 'N', '\0', /* TGID_Z_EN (73763) */
	'T', 'I', 'D', 'I', 'G', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* TIDIG_COMP_CNT (73773) */
	'E', 'X', 'C', 'P', '_', 'E', 'N', '_', 'M', 'S', 'B', '\0', /* EXCP_EN_MSB (73788) */
	'W', 'A', 'V', 'E', 'S', '_', 'P', 'E', 'R', '_', 'S', 'H', '\0', /* WAVES_PER_SH (73800) */
	'T', 'G', '_', 'P', 'E', 'R', '_', 'C', 'U', '\0', /* TG_PER_CU (73813) */
	'L', 'O', 'C', 'K', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* LOCK_THRESHOLD (73823) */
	'S', 'I', 'M', 'D', '_', 'D', 'E', 'S', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SIMD_DEST_CNTL (73838) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'I', 'M', 'D', '_', 'D', 'I', 'S', 'T', '\0', /* FORCE_SIMD_DIST (73853) */
	'C', 'U', '_', 'G', 'R', 'O', 'U', 'P', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CU_GROUP_COUNT (73869) */
	'W', 'A', 'V', 'E', 'S', '\0', /* WAVES (73884) */
	'W', 'A', 'V', 'E', 'S', 'I', 'Z', 'E', '\0', /* WAVESIZE (73890) */
	'S', 'E', 'N', 'D', '_', 'S', 'E', 'I', 'D', '\0', /* SEND_SEID (73899) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '3', '\0', /* RESERVED3 (73909) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '4', '\0', /* RESERVED4 (73919) */
	'W', 'A', 'V', 'E', '_', 'I', 'D', '_', 'B', 'A', 'S', 'E', '\0', /* WAVE_ID_BASE (73929) */
	'D', 'E', 'D', 'I', 'C', 'A', 'T', 'E', 'D', '_', 'P', 'R', 'E', 'A', 'L', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'L', 'I', 'M', 'I', 'T', '\0', /* DEDICATED_PREALLOCATION_BUFFER_LIMIT (73942) */
	'P', 'A', 'Y', 'L', 'O', 'A', 'D', '\0', /* PAYLOAD (73979, 73982) */
	'I', 'S', '_', 'E', 'V', 'E', 'N', 'T', '\0', /* IS_EVENT (73987) */
	'I', 'S', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* IS_STATE (73996) */
	'O', 'F', 'F', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* OFF_DELAY (74005) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'L', 'E', 'A', 'R', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DEPTH_CLEAR_ENABLE (74015) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'L', 'E', 'A', 'R', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* STENCIL_CLEAR_ENABLE (74034) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'P', 'Y', '\0', /* DEPTH_COPY (74055) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'O', 'P', 'Y', '\0', /* STENCIL_COPY (74066) */
	'R', 'E', 'S', 'U', 'M', 'M', 'A', 'R', 'I', 'Z', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* RESUMMARIZE_ENABLE (74079) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* STENCIL_COMPRESS_DISABLE (74098) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* DEPTH_COMPRESS_DISABLE (74123) */
	'C', 'O', 'P', 'Y', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '\0', /* COPY_CENTROID (74146) */
	'C', 'O', 'P', 'Y', '_', 'S', 'A', 'M', 'P', 'L', 'E', '\0', /* COPY_SAMPLE (74160) */
	'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DECOMPRESS_ENABLE (74172) */
	'Z', 'P', 'A', 'S', 'S', '_', 'I', 'N', 'C', 'R', 'E', 'M', 'E', 'N', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* ZPASS_INCREMENT_DISABLE (74190) */
	'P', 'E', 'R', 'F', 'E', 'C', 'T', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', 'S', '\0', /* PERFECT_ZPASS_COUNTS (74214) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'N', 'S', 'E', 'R', 'V', 'A', 'T', 'I', 'V', 'E', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', 'S', '\0', /* DISABLE_CONSERVATIVE_ZPASS_COUNTS (74235) */
	'E', 'N', 'H', 'A', 'N', 'C', 'E', 'D', '_', 'C', 'O', 'N', 'S', 'E', 'R', 'V', 'A', 'T', 'I', 'V', 'E', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', 'S', '\0', /* ENHANCED_CONSERVATIVE_ZPASS_COUNTS (74269) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'R', 'A', 'T', 'E', '\0', /* SAMPLE_RATE (74304) */
	'Z', 'P', 'A', 'S', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* ZPASS_ENABLE (74316) */
	'Z', 'F', 'A', 'I', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* ZFAIL_ENABLE (74329) */
	'S', 'F', 'A', 'I', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SFAIL_ENABLE (74342) */
	'D', 'B', 'F', 'A', 'I', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DBFAIL_ENABLE (74355) */
	'S', 'L', 'I', 'C', 'E', '_', 'E', 'V', 'E', 'N', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SLICE_EVEN_ENABLE (74369) */
	'S', 'L', 'I', 'C', 'E', '_', 'O', 'D', 'D', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SLICE_ODD_ENABLE (74387) */
	'S', 'L', 'I', 'C', 'E', '_', 'S', 'T', 'A', 'R', 'T', '\0', /* SLICE_START (74404, 74410) */
	'S', 'L', 'I', 'C', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'H', 'I', '\0', /* SLICE_START_HI (74416) */
	'S', 'L', 'I', 'C', 'E', '_', 'M', 'A', 'X', '\0', /* SLICE_MAX (74431) */
	'Z', '_', 'R', 'E', 'A', 'D', '_', 'O', 'N', 'L', 'Y', '\0', /* Z_READ_ONLY (74441) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '_', 'O', 'N', 'L', 'Y', '\0', /* STENCIL_READ_ONLY (74453) */
	'M', 'I', 'P', 'I', 'D', '\0', /* MIPID (74471) */
	'S', 'L', 'I', 'C', 'E', '_', 'M', 'A', 'X', '_', 'H', 'I', '\0', /* SLICE_MAX_HI (74477) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'F', 'F', '\0', /* FORCE_OFF (74490) */
	'F', 'O', 'R', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* FORCE_ENABLE (74500) */
	'F', 'O', 'R', 'C', 'E', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* FORCE_DISABLE (74513) */
	'F', 'O', 'R', 'C', 'E', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '\0', /* FORCE_RESERVED (74527) */
	'F', 'O', 'R', 'C', 'E', '_', 'H', 'I', 'Z', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* FORCE_HIZ_ENABLE (74542, 74550) */
	'F', 'O', 'R', 'C', 'E', '_', 'H', 'I', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '0', '\0', /* FORCE_HIS_ENABLE0 (74559, 74569) */
	'F', 'O', 'R', 'C', 'E', '_', 'H', 'I', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '1', '\0', /* FORCE_HIS_ENABLE1 (74577, 74587) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'Z', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* FORCE_SHADER_Z_ORDER (74595, 74608) */
	'F', 'A', 'S', 'T', '_', 'Z', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* FAST_Z_DISABLE (74616) */
	'F', 'A', 'S', 'T', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* FAST_STENCIL_DISABLE (74631) */
	'N', 'O', 'O', 'P', '_', 'C', 'U', 'L', 'L', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* NOOP_CULL_DISABLE (74652) */
	'F', 'O', 'R', 'C', 'E', '_', 'C', 'O', 'L', 'O', 'R', '_', 'K', 'I', 'L', 'L', '\0', /* FORCE_COLOR_KILL (74670, 74682) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'R', 'E', 'A', 'D', '\0', /* FORCE_Z_READ (74687) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '\0', /* FORCE_STENCIL_READ (74700) */
	'F', 'O', 'R', 'C', 'E', '_', 'F', 'U', 'L', 'L', '_', 'Z', '_', 'R', 'A', 'N', 'G', 'E', '\0', /* FORCE_FULL_Z_RANGE (74719) */
	'F', 'O', 'R', 'C', 'E', '_', 'Q', 'C', '_', 'S', 'M', 'A', 'S', 'K', '_', 'C', 'O', 'N', 'F', 'L', 'I', 'C', 'T', '\0', /* FORCE_QC_SMASK_CONFLICT (74738) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'V', 'I', 'E', 'W', 'P', 'O', 'R', 'T', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* DISABLE_VIEWPORT_CLAMP (74762) */
	'I', 'G', 'N', 'O', 'R', 'E', '_', 'S', 'C', '_', 'Z', 'R', 'A', 'N', 'G', 'E', '\0', /* IGNORE_SC_ZRANGE (74785) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'F', 'U', 'L', 'L', 'Y', '_', 'C', 'O', 'V', 'E', 'R', 'E', 'D', '\0', /* DISABLE_FULLY_COVERED (74802) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'O', 'F', 'F', '\0', /* FORCE_SUMM_OFF (74824) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'M', 'I', 'N', 'Z', '\0', /* FORCE_SUMM_MINZ (74839) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'M', 'A', 'X', 'Z', '\0', /* FORCE_SUMM_MAXZ (74855) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'B', 'O', 'T', 'H', '\0', /* FORCE_SUMM_BOTH (74871) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'L', 'I', 'M', 'I', 'T', '_', 'S', 'U', 'M', 'M', '\0', /* FORCE_Z_LIMIT_SUMM (74887) */
	'M', 'A', 'X', '_', 'T', 'I', 'L', 'E', 'S', '_', 'I', 'N', '_', 'D', 'T', 'T', '\0', /* MAX_TILES_IN_DTT (74906) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'T', 'I', 'L', 'E', '_', 'R', 'A', 'T', 'E', '_', 'T', 'I', 'L', 'E', 'S', '\0', /* DISABLE_TILE_RATE_TILES (74923) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'D', 'I', 'R', 'T', 'Y', '\0', /* FORCE_Z_DIRTY (74947, 74955) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'D', 'I', 'R', 'T', 'Y', '\0', /* FORCE_STENCIL_DIRTY (74961) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* FORCE_Z_VALID (74981) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* FORCE_STENCIL_VALID (74995) */
	'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'I', 'O', 'N', '\0', /* PRESERVE_COMPRESSION (75015, 75024) */
	'P', 'S', 'L', 'C', '_', 'A', 'U', 'T', 'O', '\0', /* PSLC_AUTO (75036) */
	'P', 'S', 'L', 'C', '_', 'O', 'N', '_', 'H', 'A', 'N', 'G', '_', 'O', 'N', 'L', 'Y', '\0', /* PSLC_ON_HANG_ONLY (75046) */
	'P', 'S', 'L', 'C', '_', 'A', 'S', 'A', 'P', '\0', /* PSLC_ASAP (75064) */
	'P', 'S', 'L', 'C', '_', 'C', 'O', 'U', 'N', 'T', 'D', 'O', 'W', 'N', '\0', /* PSLC_COUNTDOWN (75074) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'S', 'Q', 'U', 'A', 'D', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PARTIAL_SQUAD_LAUNCH_CONTROL (75089) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'S', 'Q', 'U', 'A', 'D', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'C', 'O', 'U', 'N', 'T', 'D', 'O', 'W', 'N', '\0', /* PARTIAL_SQUAD_LAUNCH_COUNTDOWN (75118) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'Z', 'M', 'A', 'S', 'K', '_', 'E', 'X', 'P', 'C', 'L', 'E', 'A', 'R', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '\0', /* DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION (75149) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'S', 'M', 'E', 'M', '_', 'E', 'X', 'P', 'C', 'L', 'E', 'A', 'R', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '\0', /* DISABLE_SMEM_EXPCLEAR_OPTIMIZATION (75185) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'N', '_', 'V', 'A', 'L', 'I', 'D', 'A', 'T', 'I', 'O', 'N', '\0', /* DISABLE_COLOR_ON_VALIDATION (75220) */
	'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'Z', '_', 'O', 'N', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* DECOMPRESS_Z_ON_FLUSH (75248) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'R', 'E', 'G', '_', 'S', 'N', 'O', 'O', 'P', '\0', /* DISABLE_REG_SNOOP (75270) */
	'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'H', 'I', 'E', 'R', '_', 'D', 'E', 'P', 'T', 'H', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* DEPTH_BOUNDS_HIER_DEPTH_DISABLE (75288) */
	'S', 'E', 'P', 'A', 'R', 'A', 'T', 'E', '_', 'H', 'I', 'Z', 'S', '_', 'F', 'U', 'N', 'C', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SEPARATE_HIZS_FUNC_ENABLE (75320) */
	'F', 'R', 'A', 'G', '_', 'N', 'E', 'V', 'E', 'R', '\0', /* FRAG_NEVER (75346) */
	'F', 'R', 'A', 'G', '_', 'L', 'E', 'S', 'S', '\0', /* FRAG_LESS (75357) */
	'F', 'R', 'A', 'G', '_', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_EQUAL (75367) */
	'F', 'R', 'A', 'G', '_', 'L', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_LEQUAL (75378) */
	'F', 'R', 'A', 'G', '_', 'G', 'R', 'E', 'A', 'T', 'E', 'R', '\0', /* FRAG_GREATER (75390) */
	'F', 'R', 'A', 'G', '_', 'N', 'O', 'T', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_NOTEQUAL (75403) */
	'F', 'R', 'A', 'G', '_', 'G', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_GEQUAL (75417) */
	'F', 'R', 'A', 'G', '_', 'A', 'L', 'W', 'A', 'Y', 'S', '\0', /* FRAG_ALWAYS (75429, 75434) */
	'H', 'I', 'Z', '_', 'Z', 'F', 'U', 'N', 'C', '\0', /* HIZ_ZFUNC (75441, 75445) */
	'H', 'I', 'S', '_', 'S', 'F', 'U', 'N', 'C', '_', 'F', 'F', '\0', /* HIS_SFUNC_FF (75451) */
	'H', 'I', 'S', '_', 'S', 'F', 'U', 'N', 'C', '_', 'B', 'F', '\0', /* HIS_SFUNC_BF (75464) */
	'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'Z', 'R', 'A', 'N', 'G', 'E', '\0', /* PRESERVE_ZRANGE (75477) */
	'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'S', 'R', 'E', 'S', 'U', 'L', 'T', 'S', '\0', /* PRESERVE_SRESULTS (75493) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'F', 'A', 'S', 'T', '_', 'P', 'A', 'S', 'S', '\0', /* DISABLE_FAST_PASS (75511) */
	'A', 'L', 'L', 'O', 'W', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'R', 'E', 'S', '_', 'H', 'I', 'E', 'R', '_', 'K', 'I', 'L', 'L', '\0', /* ALLOW_PARTIAL_RES_HIER_KILL (75529) */
	'X', '_', 'M', 'A', 'X', '\0', /* X_MAX (75557) */
	'T', 'L', '_', 'X', '\0', /* TL_X (75563) */
	'T', 'L', '_', 'Y', '\0', /* TL_Y (75568) */
	'B', 'R', '_', 'X', '\0', /* BR_X (75573) */
	'B', 'R', '_', 'Y', '\0', /* BR_Y (75578) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'N', '\0', /* FORCE_ON (75583) */
	'P', 'U', 'N', 'C', 'H', 'O', 'U', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* PUNCHOUT_MODE (75592) */
	'P', 'O', 'P', 'S', '_', 'D', 'R', 'A', 'I', 'N', '_', 'P', 'S', '_', 'O', 'N', '_', 'O', 'V', 'E', 'R', 'L', 'A', 'P', '\0', /* POPS_DRAIN_PS_ON_OVERLAP (75606) */
	'D', 'I', 'S', 'A', 'L', 'L', 'O', 'W', '_', 'O', 'V', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* DISALLOW_OVERFLOW (75631) */
	'F', 'I', 'E', 'L', 'D', '_', '1', '\0', /* FIELD_1 (75649) */
	'F', 'I', 'E', 'L', 'D', '_', '2', '\0', /* FIELD_2 (75657) */
	'F', 'I', 'E', 'L', 'D', '_', '3', '\0', /* FIELD_3 (75665) */
	'F', 'I', 'E', 'L', 'D', '_', '4', '\0', /* FIELD_4 (75673) */
	'F', 'I', 'E', 'L', 'D', '_', '5', '\0', /* FIELD_5 (75681) */
	'F', 'I', 'E', 'L', 'D', '_', '6', '\0', /* FIELD_6 (75689) */
	'F', 'I', 'E', 'L', 'D', '_', '7', '\0', /* FIELD_7 (75697) */
	'Z', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* Z_INVALID (75705) */
	'Z', '_', '1', '6', '\0', /* Z_16 (75715) */
	'Z', '_', '2', '4', '\0', /* Z_24 (75720) */
	'Z', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* Z_32_FLOAT (75725) */
	'N', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* NUM_SAMPLES (75736) */
	'F', 'A', 'U', 'L', 'T', '_', 'Z', 'E', 'R', 'O', '\0', /* FAULT_ZERO (75748) */
	'F', 'A', 'U', 'L', 'T', '_', 'O', 'N', 'E', '\0', /* FAULT_ONE (75759) */
	'F', 'A', 'U', 'L', 'T', '_', 'F', 'A', 'I', 'L', '\0', /* FAULT_FAIL (75769) */
	'F', 'A', 'U', 'L', 'T', '_', 'P', 'A', 'S', 'S', '\0', /* FAULT_PASS (75780) */
	'F', 'A', 'U', 'L', 'T', '_', 'B', 'E', 'H', 'A', 'V', 'I', 'O', 'R', '\0', /* FAULT_BEHAVIOR (75791) */
	'I', 'T', 'E', 'R', 'A', 'T', 'E', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* ITERATE_FLUSH (75806) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', 'L', 'Y', '_', 'R', 'E', 'S', 'I', 'D', 'E', 'N', 'T', '\0', /* PARTIALLY_RESIDENT (75820) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'F', 'I', 'E', 'L', 'D', '_', '1', '\0', /* RESERVED_FIELD_1 (75839) */
	'M', 'A', 'X', 'M', 'I', 'P', '\0', /* MAXMIP (75856) */
	'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'O', 'N', '_', 'N', '_', 'Z', 'P', 'L', 'A', 'N', 'E', 'S', '\0', /* DECOMPRESS_ON_N_ZPLANES (75863) */
	'A', 'L', 'L', 'O', 'W', '_', 'E', 'X', 'P', 'C', 'L', 'E', 'A', 'R', '\0', /* ALLOW_EXPCLEAR (75887) */
	'R', 'E', 'A', 'D', '_', 'S', 'I', 'Z', 'E', '\0', /* READ_SIZE (75902) */
	'T', 'I', 'L', 'E', '_', 'S', 'U', 'R', 'F', 'A', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TILE_SURFACE_ENABLE (75912) */
	'Z', 'R', 'A', 'N', 'G', 'E', '_', 'P', 'R', 'E', 'C', 'I', 'S', 'I', 'O', 'N', '\0', /* ZRANGE_PRECISION (75932) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* STENCIL_INVALID (75949) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', '8', '\0', /* STENCIL_8 (75965) */
	'T', 'I', 'L', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* TILE_STENCIL_DISABLE (75975) */
	'C', 'A', 'C', 'H', 'E', '_', 'L', 'R', 'U', '_', 'W', 'R', '\0', /* CACHE_LRU_WR (75996) */
	'C', 'A', 'C', 'H', 'E', '_', 'S', 'T', 'R', 'E', 'A', 'M', '\0', /* CACHE_STREAM (76009) */
	'C', 'A', 'C', 'H', 'E', '_', 'B', 'Y', 'P', 'A', 'S', 'S', '\0', /* CACHE_BYPASS (76022) */
	'U', 'N', 'C', 'A', 'C', 'H', 'E', 'D', '_', 'W', 'R', '\0', /* UNCACHED_WR (76035) */
	'Z', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* Z_WR_POLICY (76047) */
	'S', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* S_WR_POLICY (76059) */
	'H', 'T', 'I', 'L', 'E', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* HTILE_WR_POLICY (76071) */
	'Z', 'P', 'C', 'P', 'S', 'D', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* ZPCPSD_WR_POLICY (76087) */
	'C', 'A', 'C', 'H', 'E', '_', 'L', 'R', 'U', '_', 'R', 'D', '\0', /* CACHE_LRU_RD (76104) */
	'C', 'A', 'C', 'H', 'E', '_', 'N', 'O', 'A', '\0', /* CACHE_NOA (76117) */
	'U', 'N', 'C', 'A', 'C', 'H', 'E', 'D', '_', 'R', 'D', '\0', /* UNCACHED_RD (76127) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'D', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* RESERVED_RDPOLICY (76139) */
	'Z', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* Z_RD_POLICY (76157) */
	'S', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* S_RD_POLICY (76169) */
	'H', 'T', 'I', 'L', 'E', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* HTILE_RD_POLICY (76181) */
	'Z', '_', 'B', 'I', 'G', '_', 'P', 'A', 'G', 'E', '\0', /* Z_BIG_PAGE (76197, 76199) */
	'S', '_', 'B', 'I', 'G', '_', 'P', 'A', 'G', 'E', '\0', /* S_BIG_PAGE (76208) */
	'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '2', '5', '6', 'B', '\0', /* DEST_BASE_HI_256B (76219) */
	'W', 'I', 'N', 'D', 'O', 'W', '_', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* WINDOW_X_OFFSET (76237) */
	'W', 'I', 'N', 'D', 'O', 'W', '_', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* WINDOW_Y_OFFSET (76253, 76260) */
	'W', 'I', 'N', 'D', 'O', 'W', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* WINDOW_OFFSET_DISABLE (76269) */
	'I', 'N', '_', '2', '0', '\0', /* IN_20 (76291) */
	'I', 'N', '_', '2', '1', '\0', /* IN_21 (76297) */
	'I', 'N', '_', '2', '1', '0', '\0', /* IN_210 (76303) */
	'I', 'N', '_', '3', '0', '\0', /* IN_30 (76310) */
	'I', 'N', '_', '3', '1', '\0', /* IN_31 (76316) */
	'I', 'N', '_', '3', '1', '0', '\0', /* IN_310 (76322) */
	'I', 'N', '_', '3', '2', '\0', /* IN_32 (76329) */
	'I', 'N', '_', '3', '2', '0', '\0', /* IN_320 (76335) */
	'I', 'N', '_', '3', '2', '1', '\0', /* IN_321 (76342) */
	'I', 'N', '_', '3', '2', '1', '0', '\0', /* IN_3210 (76349) */
	'C', 'L', 'I', 'P', '_', 'R', 'U', 'L', 'E', '\0', /* CLIP_RULE (76357) */
	'E', 'R', '_', 'T', 'R', 'I', '\0', /* ER_TRI (76367) */
	'E', 'R', '_', 'P', 'O', 'I', 'N', 'T', '\0', /* ER_POINT (76374) */
	'E', 'R', '_', 'R', 'E', 'C', 'T', '\0', /* ER_RECT (76383) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'L', 'R', '\0', /* ER_LINE_LR (76391) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'R', 'L', '\0', /* ER_LINE_RL (76402) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'T', 'B', '\0', /* ER_LINE_TB (76413) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'B', 'T', '\0', /* ER_LINE_BT (76424) */
	'H', 'W', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'X', '\0', /* HW_SCREEN_OFFSET_X (76435) */
	'H', 'W', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'Y', '\0', /* HW_SCREEN_OFFSET_Y (76454) */
	'T', 'A', 'R', 'G', 'E', 'T', '0', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET0_ENABLE (76473) */
	'T', 'A', 'R', 'G', 'E', 'T', '1', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET1_ENABLE (76488) */
	'T', 'A', 'R', 'G', 'E', 'T', '2', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET2_ENABLE (76503) */
	'T', 'A', 'R', 'G', 'E', 'T', '3', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET3_ENABLE (76518) */
	'T', 'A', 'R', 'G', 'E', 'T', '4', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET4_ENABLE (76533) */
	'T', 'A', 'R', 'G', 'E', 'T', '5', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET5_ENABLE (76548) */
	'T', 'A', 'R', 'G', 'E', 'T', '6', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET6_ENABLE (76563) */
	'T', 'A', 'R', 'G', 'E', 'T', '7', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET7_ENABLE (76578) */
	'O', 'U', 'T', 'P', 'U', 'T', '0', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT0_ENABLE (76593) */
	'O', 'U', 'T', 'P', 'U', 'T', '1', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT1_ENABLE (76608) */
	'O', 'U', 'T', 'P', 'U', 'T', '2', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT2_ENABLE (76623) */
	'O', 'U', 'T', 'P', 'U', 'T', '3', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT3_ENABLE (76638) */
	'O', 'U', 'T', 'P', 'U', 'T', '4', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT4_ENABLE (76653) */
	'O', 'U', 'T', 'P', 'U', 'T', '5', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT5_ENABLE (76668) */
	'O', 'U', 'T', 'P', 'U', 'T', '6', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT6_ENABLE (76683) */
	'O', 'U', 'T', 'P', 'U', 'T', '7', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT7_ENABLE (76698) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_RB_MAP_0 (76713) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_RB_MAP_1 (76736) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_RB_MAP_2 (76759) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_RB_MAP_3 (76782) */
	'R', 'B', '_', 'M', 'A', 'P', '_', 'P', 'K', 'R', '0', '\0', /* RB_MAP_PKR0 (76805) */
	'R', 'B', '_', 'M', 'A', 'P', '_', 'P', 'K', 'R', '1', '\0', /* RB_MAP_PKR1 (76817) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '0', '\0', /* RASTER_CONFIG_RB_XSEL2_0 (76829) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '1', '\0', /* RASTER_CONFIG_RB_XSEL2_1 (76854) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '2', '\0', /* RASTER_CONFIG_RB_XSEL2_2 (76879) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '3', '\0', /* RASTER_CONFIG_RB_XSEL2_3 (76904) */
	'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '\0', /* RB_XSEL2 (76929) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_RB_XSEL_0 (76938) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_RB_XSEL_1 (76962) */
	'R', 'B', '_', 'X', 'S', 'E', 'L', '\0', /* RB_XSEL (76986) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'Y', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_RB_YSEL_0 (76994) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'Y', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_RB_YSEL_1 (77018) */
	'R', 'B', '_', 'Y', 'S', 'E', 'L', '\0', /* RB_YSEL (77042) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_PKR_MAP_0 (77050) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_PKR_MAP_1 (77074) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_PKR_MAP_2 (77098) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_PKR_MAP_3 (77122) */
	'P', 'K', 'R', '_', 'M', 'A', 'P', '\0', /* PKR_MAP (77146) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_PKR_XSEL_0 (77154) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_PKR_XSEL_1 (77179) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '2', '\0', /* RASTER_CONFIG_PKR_XSEL_2 (77204) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '3', '\0', /* RASTER_CONFIG_PKR_XSEL_3 (77229) */
	'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '\0', /* PKR_XSEL (77254) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_PKR_YSEL_0 (77263) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_PKR_YSEL_1 (77288) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '2', '\0', /* RASTER_CONFIG_PKR_YSEL_2 (77313) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '3', '\0', /* RASTER_CONFIG_PKR_YSEL_3 (77338) */
	'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '\0', /* PKR_YSEL (77363) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '0', '\0', /* RASTER_CONFIG_PKR_XSEL2_0 (77372) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '1', '\0', /* RASTER_CONFIG_PKR_XSEL2_1 (77398) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '2', '\0', /* RASTER_CONFIG_PKR_XSEL2_2 (77424) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '3', '\0', /* RASTER_CONFIG_PKR_XSEL2_3 (77450) */
	'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '\0', /* PKR_XSEL2 (77476) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_SC_MAP_0 (77486) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_SC_MAP_1 (77509) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_SC_MAP_2 (77532) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_SC_MAP_3 (77555) */
	'S', 'C', '_', 'M', 'A', 'P', '\0', /* SC_MAP (77578) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_8_WIDE_TILE (77585) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_16_WIDE_TILE (77619) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_32_WIDE_TILE (77654) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_64_WIDE_TILE (77689) */
	'S', 'C', '_', 'X', 'S', 'E', 'L', '\0', /* SC_XSEL (77724) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_8_WIDE_TILE (77732) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_16_WIDE_TILE (77766) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_32_WIDE_TILE (77801) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_64_WIDE_TILE (77836) */
	'S', 'C', '_', 'Y', 'S', 'E', 'L', '\0', /* SC_YSEL (77871) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_SE_MAP_0 (77879) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_SE_MAP_1 (77902) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_SE_MAP_2 (77925) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_SE_MAP_3 (77948) */
	'S', 'E', '_', 'M', 'A', 'P', '\0', /* SE_MAP (77971) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_8_WIDE_TILE (77978) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_16_WIDE_TILE (78012) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_32_WIDE_TILE (78047) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_64_WIDE_TILE (78082) */
	'S', 'E', '_', 'X', 'S', 'E', 'L', '\0', /* SE_XSEL (78117) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_8_WIDE_TILE (78125) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_16_WIDE_TILE (78159) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_32_WIDE_TILE (78194) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_64_WIDE_TILE (78229) */
	'S', 'E', '_', 'Y', 'S', 'E', 'L', '\0', /* SE_YSEL (78264) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_SE_PAIR_MAP_0 (78272) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_SE_PAIR_MAP_1 (78300) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_SE_PAIR_MAP_2 (78328) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_SE_PAIR_MAP_3 (78356) */
	'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '\0', /* SE_PAIR_MAP (78384) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_XSEL_8_WIDE_TILE (78396) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_XSEL_16_WIDE_TILE (78435) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_XSEL_32_WIDE_TILE (78475) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_XSEL_64_WIDE_TILE (78515) */
	'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '\0', /* SE_PAIR_XSEL (78555) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'Y', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_YSEL_8_WIDE_TILE (78568) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'Y', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_YSEL_16_WIDE_TILE (78607) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'Y', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_YSEL_32_WIDE_TILE (78647) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'Y', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_YSEL_64_WIDE_TILE (78687) */
	'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'Y', 'S', 'E', 'L', '\0', /* SE_PAIR_YSEL (78727) */
	'N', 'U', 'M', '_', 'S', 'E', '\0', /* NUM_SE (78740) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'S', 'R', 'B', 'S', 'L', '_', 'D', 'B', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'E', 'D', '_', 'P', 'A', 'C', 'K', 'I', 'N', 'G', '\0', /* DISABLE_SRBSL_DB_OPTIMIZED_PACKING (78747) */
	'N', 'U', 'M', '_', 'S', 'C', '\0', /* NUM_SC (78782) */
	'N', 'U', 'M', '_', 'R', 'B', '_', 'P', 'E', 'R', '_', 'S', 'C', '\0', /* NUM_RB_PER_SC (78789) */
	'N', 'U', 'M', '_', 'P', 'A', 'C', 'K', 'E', 'R', '_', 'P', 'E', 'R', '_', 'S', 'C', '\0', /* NUM_PACKER_PER_SC (78803) */
	'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* PERFMON_ENABLE (78821) */
	'L', 'E', 'F', 'T', '_', 'Q', 'T', 'R', '\0', /* LEFT_QTR (78836) */
	'L', 'E', 'F', 'T', '_', 'H', 'A', 'L', 'F', '\0', /* LEFT_HALF (78845) */
	'R', 'I', 'G', 'H', 'T', '_', 'H', 'A', 'L', 'F', '\0', /* RIGHT_HALF (78855) */
	'R', 'I', 'G', 'H', 'T', '_', 'Q', 'T', 'R', '\0', /* RIGHT_QTR (78866) */
	'T', 'O', 'P', '_', 'Q', 'T', 'R', '\0', /* TOP_QTR (78876) */
	'T', 'O', 'P', '_', 'H', 'A', 'L', 'F', '\0', /* TOP_HALF (78884) */
	'B', 'O', 'T', '_', 'H', 'A', 'L', 'F', '\0', /* BOT_HALF (78893) */
	'B', 'O', 'T', '_', 'Q', 'T', 'R', '\0', /* BOT_QTR (78902) */
	'C', 'M', 'A', 'S', 'K', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* CMASK_WR_POLICY (78910) */
	'F', 'M', 'A', 'S', 'K', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* FMASK_WR_POLICY (78926) */
	'D', 'C', 'C', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* DCC_WR_POLICY (78942) */
	'C', 'O', 'L', 'O', 'R', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* COLOR_WR_POLICY (78956) */
	'C', 'M', 'A', 'S', 'K', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* CMASK_RD_POLICY (78972) */
	'F', 'M', 'A', 'S', 'K', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* FMASK_RD_POLICY (78988) */
	'D', 'C', 'C', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* DCC_RD_POLICY (79004) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* COLOR_RD_POLICY (79018) */
	'F', 'M', 'A', 'S', 'K', '_', 'B', 'I', 'G', '_', 'P', 'A', 'G', 'E', '\0', /* FMASK_BIG_PAGE (79034) */
	'C', 'O', 'L', 'O', 'R', '_', 'B', 'I', 'G', '_', 'P', 'A', 'G', 'E', '\0', /* COLOR_BIG_PAGE (79049) */
	'O', 'V', 'E', 'R', 'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'M', 'B', 'I', 'N', 'E', 'R', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* OVERWRITE_COMBINER_DISABLE (79064) */
	'O', 'V', 'E', 'R', 'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'M', 'B', 'I', 'N', 'E', 'R', '_', 'W', 'A', 'T', 'E', 'R', 'M', 'A', 'R', 'K', '\0', /* OVERWRITE_COMBINER_WATERMARK (79091) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'E', 'N', 'C', 'O', 'D', 'E', '_', 'A', 'C', '0', '1', '\0', /* DISABLE_CONSTANT_ENCODE_AC01 (79120) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'E', 'N', 'C', 'O', 'D', 'E', '_', 'S', 'I', 'N', 'G', 'L', 'E', '\0', /* DISABLE_CONSTANT_ENCODE_SINGLE (79149) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'E', 'N', 'C', 'O', 'D', 'E', '_', 'R', 'E', 'G', '\0', /* DISABLE_CONSTANT_ENCODE_REG (79180) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'E', 'L', 'I', 'M', 'F', 'C', '_', 'S', 'K', 'I', 'P', '_', 'O', 'F', '_', 'A', 'C', '0', '1', '\0', /* DISABLE_ELIMFC_SKIP_OF_AC01 (79208) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'E', 'L', 'I', 'M', 'F', 'C', '_', 'S', 'K', 'I', 'P', '_', 'O', 'F', '_', 'S', 'I', 'N', 'G', 'L', 'E', '\0', /* DISABLE_ELIMFC_SKIP_OF_SINGLE (79236) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'E', 'L', 'I', 'M', 'F', 'C', '_', 'S', 'K', 'I', 'P', '_', 'O', 'F', '_', 'R', 'E', 'G', '\0', /* ENABLE_ELIMFC_SKIP_OF_REG (79266) */
	'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COVERAGE_OUT_ENABLE (79292) */
	'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'M', 'R', 'T', '\0', /* COVERAGE_OUT_MRT (79312) */
	'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'C', 'H', 'A', 'N', 'N', 'E', 'L', '\0', /* COVERAGE_OUT_CHANNEL (79329) */
	'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* COVERAGE_OUT_SAMPLES (79350) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'K', 'E', 'E', 'P', '\0', /* STENCIL_KEEP (79371) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'Z', 'E', 'R', 'O', '\0', /* STENCIL_ZERO (79384) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'O', 'N', 'E', 'S', '\0', /* STENCIL_ONES (79397) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'P', 'L', 'A', 'C', 'E', '_', 'T', 'E', 'S', 'T', '\0', /* STENCIL_REPLACE_TEST (79410) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'P', 'L', 'A', 'C', 'E', '_', 'O', 'P', '\0', /* STENCIL_REPLACE_OP (79431) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'A', 'D', 'D', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* STENCIL_ADD_CLAMP (79450) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'S', 'U', 'B', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* STENCIL_SUB_CLAMP (79468) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'V', 'E', 'R', 'T', '\0', /* STENCIL_INVERT (79486) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'A', 'D', 'D', '_', 'W', 'R', 'A', 'P', '\0', /* STENCIL_ADD_WRAP (79501) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'S', 'U', 'B', '_', 'W', 'R', 'A', 'P', '\0', /* STENCIL_SUB_WRAP (79518) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'A', 'N', 'D', '\0', /* STENCIL_AND (79535) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'O', 'R', '\0', /* STENCIL_OR (79547) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'X', 'O', 'R', '\0', /* STENCIL_XOR (79558) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'N', 'A', 'N', 'D', '\0', /* STENCIL_NAND (79570) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'N', 'O', 'R', '\0', /* STENCIL_NOR (79583) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'X', 'N', 'O', 'R', '\0', /* STENCIL_XNOR (79595) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'F', 'A', 'I', 'L', '\0', /* STENCILFAIL (79608) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'Z', 'P', 'A', 'S', 'S', '\0', /* STENCILZPASS (79620) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'Z', 'F', 'A', 'I', 'L', '\0', /* STENCILZFAIL (79633) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'F', 'A', 'I', 'L', '_', 'B', 'F', '\0', /* STENCILFAIL_BF (79646) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'Z', 'P', 'A', 'S', 'S', '_', 'B', 'F', '\0', /* STENCILZPASS_BF (79661) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'Z', 'F', 'A', 'I', 'L', '_', 'B', 'F', '\0', /* STENCILZFAIL_BF (79677) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'T', 'E', 'S', 'T', 'V', 'A', 'L', '\0', /* STENCILTESTVAL (79693) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'M', 'A', 'S', 'K', '\0', /* STENCILMASK (79708) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'W', 'R', 'I', 'T', 'E', 'M', 'A', 'S', 'K', '\0', /* STENCILWRITEMASK (79720) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'O', 'P', 'V', 'A', 'L', '\0', /* STENCILOPVAL (79737) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'T', 'E', 'S', 'T', 'V', 'A', 'L', '_', 'B', 'F', '\0', /* STENCILTESTVAL_BF (79750) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'M', 'A', 'S', 'K', '_', 'B', 'F', '\0', /* STENCILMASK_BF (79768) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'W', 'R', 'I', 'T', 'E', 'M', 'A', 'S', 'K', '_', 'B', 'F', '\0', /* STENCILWRITEMASK_BF (79783) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'O', 'P', 'V', 'A', 'L', '_', 'B', 'F', '\0', /* STENCILOPVAL_BF (79803) */
	'D', 'E', 'F', 'A', 'U', 'L', 'T', '_', 'V', 'A', 'L', '\0', /* DEFAULT_VAL (79819) */
	'F', 'L', 'A', 'T', '_', 'S', 'H', 'A', 'D', 'E', '\0', /* FLAT_SHADE (79831) */
	'C', 'Y', 'L', '_', 'W', 'R', 'A', 'P', '\0', /* CYL_WRAP (79842) */
	'P', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'T', 'E', 'X', '\0', /* PT_SPRITE_TEX (79851) */
	'D', 'U', 'P', '\0', /* DUP (79865) */
	'F', 'P', '1', '6', '_', 'I', 'N', 'T', 'E', 'R', 'P', '_', 'M', 'O', 'D', 'E', '\0', /* FP16_INTERP_MODE (79869) */
	'U', 'S', 'E', '_', 'D', 'E', 'F', 'A', 'U', 'L', 'T', '_', 'A', 'T', 'T', 'R', '1', '\0', /* USE_DEFAULT_ATTR1 (79886) */
	'D', 'E', 'F', 'A', 'U', 'L', 'T', '_', 'V', 'A', 'L', '_', 'A', 'T', 'T', 'R', '1', '\0', /* DEFAULT_VAL_ATTR1 (79904) */
	'P', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'T', 'E', 'X', '_', 'A', 'T', 'T', 'R', '1', '\0', /* PT_SPRITE_TEX_ATTR1 (79922) */
	'A', 'T', 'T', 'R', '0', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* ATTR0_VALID (79942) */
	'A', 'T', 'T', 'R', '1', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* ATTR1_VALID (79954) */
	'V', 'S', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* VS_EXPORT_COUNT (79966) */
	'V', 'S', '_', 'H', 'A', 'L', 'F', '_', 'P', 'A', 'C', 'K', '\0', /* VS_HALF_PACK (79982) */
	'N', 'O', '_', 'P', 'C', '_', 'E', 'X', 'P', 'O', 'R', 'T', '\0', /* NO_PC_EXPORT (79995) */
	'P', 'E', 'R', 'S', 'P', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'E', 'N', 'A', '\0', /* PERSP_SAMPLE_ENA (80008) */
	'P', 'E', 'R', 'S', 'P', '_', 'C', 'E', 'N', 'T', 'E', 'R', '_', 'E', 'N', 'A', '\0', /* PERSP_CENTER_ENA (80025) */
	'P', 'E', 'R', 'S', 'P', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'E', 'N', 'A', '\0', /* PERSP_CENTROID_ENA (80042) */
	'P', 'E', 'R', 'S', 'P', '_', 'P', 'U', 'L', 'L', '_', 'M', 'O', 'D', 'E', 'L', '_', 'E', 'N', 'A', '\0', /* PERSP_PULL_MODEL_ENA (80061) */
	'L', 'I', 'N', 'E', 'A', 'R', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'E', 'N', 'A', '\0', /* LINEAR_SAMPLE_ENA (80082) */
	'L', 'I', 'N', 'E', 'A', 'R', '_', 'C', 'E', 'N', 'T', 'E', 'R', '_', 'E', 'N', 'A', '\0', /* LINEAR_CENTER_ENA (80100) */
	'L', 'I', 'N', 'E', 'A', 'R', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'E', 'N', 'A', '\0', /* LINEAR_CENTROID_ENA (80118) */
	'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'T', 'E', 'X', '_', 'E', 'N', 'A', '\0', /* LINE_STIPPLE_TEX_ENA (80138) */
	'P', 'O', 'S', '_', 'X', '_', 'F', 'L', 'O', 'A', 'T', '_', 'E', 'N', 'A', '\0', /* POS_X_FLOAT_ENA (80159) */
	'P', 'O', 'S', '_', 'Y', '_', 'F', 'L', 'O', 'A', 'T', '_', 'E', 'N', 'A', '\0', /* POS_Y_FLOAT_ENA (80175) */
	'P', 'O', 'S', '_', 'Z', '_', 'F', 'L', 'O', 'A', 'T', '_', 'E', 'N', 'A', '\0', /* POS_Z_FLOAT_ENA (80191) */
	'P', 'O', 'S', '_', 'W', '_', 'F', 'L', 'O', 'A', 'T', '_', 'E', 'N', 'A', '\0', /* POS_W_FLOAT_ENA (80207) */
	'F', 'R', 'O', 'N', 'T', '_', 'F', 'A', 'C', 'E', '_', 'E', 'N', 'A', '\0', /* FRONT_FACE_ENA (80223) */
	'A', 'N', 'C', 'I', 'L', 'L', 'A', 'R', 'Y', '_', 'E', 'N', 'A', '\0', /* ANCILLARY_ENA (80238) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'E', 'N', 'A', '\0', /* SAMPLE_COVERAGE_ENA (80252) */
	'P', 'O', 'S', '_', 'F', 'I', 'X', 'E', 'D', '_', 'P', 'T', '_', 'E', 'N', 'A', '\0', /* POS_FIXED_PT_ENA (80272) */
	'F', 'L', 'A', 'T', '_', 'S', 'H', 'A', 'D', 'E', '_', 'E', 'N', 'A', '\0', /* FLAT_SHADE_ENA (80289) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'E', 'N', 'A', '\0', /* PNT_SPRITE_ENA (80304) */
	'S', 'P', 'I', '_', 'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'S', 'E', 'L', '_', '0', '\0', /* SPI_PNT_SPRITE_SEL_0 (80319) */
	'S', 'P', 'I', '_', 'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'S', 'E', 'L', '_', '1', '\0', /* SPI_PNT_SPRITE_SEL_1 (80340) */
	'S', 'P', 'I', '_', 'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'S', 'E', 'L', '_', 'S', '\0', /* SPI_PNT_SPRITE_SEL_S (80361) */
	'S', 'P', 'I', '_', 'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'S', 'E', 'L', '_', 'T', '\0', /* SPI_PNT_SPRITE_SEL_T (80382) */
	'S', 'P', 'I', '_', 'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'S', 'E', 'L', '_', 'N', 'O', 'N', 'E', '\0', /* SPI_PNT_SPRITE_SEL_NONE (80403, 80422) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'O', 'V', 'R', 'D', '_', 'X', '\0', /* PNT_SPRITE_OVRD_X (80427) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'O', 'V', 'R', 'D', '_', 'Y', '\0', /* PNT_SPRITE_OVRD_Y (80445) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'O', 'V', 'R', 'D', '_', 'Z', '\0', /* PNT_SPRITE_OVRD_Z (80463) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'O', 'V', 'R', 'D', '_', 'W', '\0', /* PNT_SPRITE_OVRD_W (80481) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'T', 'O', 'P', '_', '1', '\0', /* PNT_SPRITE_TOP_1 (80499) */
	'N', 'U', 'M', '_', 'I', 'N', 'T', 'E', 'R', 'P', '\0', /* NUM_INTERP (80516) */
	'P', 'A', 'R', 'A', 'M', '_', 'G', 'E', 'N', '\0', /* PARAM_GEN (80527) */
	'O', 'F', 'F', 'C', 'H', 'I', 'P', '_', 'P', 'A', 'R', 'A', 'M', '_', 'E', 'N', '\0', /* OFFCHIP_PARAM_EN (80537) */
	'L', 'A', 'T', 'E', '_', 'P', 'C', '_', 'D', 'E', 'A', 'L', 'L', 'O', 'C', '\0', /* LATE_PC_DEALLOC (80554) */
	'B', 'C', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'E', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* BC_OPTIMIZE_DISABLE (80570) */
	'P', 'S', '_', 'W', '3', '2', '_', 'E', 'N', '\0', /* PS_W32_EN (80590) */
	'P', 'E', 'R', 'S', 'P', '_', 'C', 'E', 'N', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* PERSP_CENTER_CNTL (80600) */
	'P', 'E', 'R', 'S', 'P', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'C', 'N', 'T', 'L', '\0', /* PERSP_CENTROID_CNTL (80618) */
	'L', 'I', 'N', 'E', 'A', 'R', '_', 'C', 'E', 'N', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* LINEAR_CENTER_CNTL (80638) */
	'L', 'I', 'N', 'E', 'A', 'R', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'C', 'N', 'T', 'L', '\0', /* LINEAR_CENTROID_CNTL (80657) */
	'P', 'O', 'S', '_', 'F', 'L', 'O', 'A', 'T', '_', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '\0', /* POS_FLOAT_LOCATION (80678) */
	'P', 'O', 'S', '_', 'F', 'L', 'O', 'A', 'T', '_', 'U', 'L', 'C', '\0', /* POS_FLOAT_ULC (80697) */
	'F', 'R', 'O', 'N', 'T', '_', 'F', 'A', 'C', 'E', '_', 'A', 'L', 'L', '_', 'B', 'I', 'T', 'S', '\0', /* FRONT_FACE_ALL_BITS (80711) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'N', 'O', 'N', 'E', '\0', /* SPI_SHADER_NONE (80731) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '1', 'C', 'O', 'M', 'P', '\0', /* SPI_SHADER_1COMP (80747) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '2', 'C', 'O', 'M', 'P', '\0', /* SPI_SHADER_2COMP (80764) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '4', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '\0', /* SPI_SHADER_4COMPRESS (80781) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '4', 'C', 'O', 'M', 'P', '\0', /* SPI_SHADER_4COMP (80802) */
	'I', 'D', 'X', '0', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* IDX0_EXPORT_FORMAT (80819) */
	'P', 'O', 'S', '0', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* POS0_EXPORT_FORMAT (80838) */
	'P', 'O', 'S', '1', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* POS1_EXPORT_FORMAT (80857) */
	'P', 'O', 'S', '2', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* POS2_EXPORT_FORMAT (80876) */
	'P', 'O', 'S', '3', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* POS3_EXPORT_FORMAT (80895) */
	'P', 'O', 'S', '4', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* POS4_EXPORT_FORMAT (80914) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'Z', 'E', 'R', 'O', '\0', /* SPI_SHADER_ZERO (80933) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '3', '2', '_', 'R', '\0', /* SPI_SHADER_32_R (80949) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '3', '2', '_', 'G', 'R', '\0', /* SPI_SHADER_32_GR (80965) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '3', '2', '_', 'A', 'R', '\0', /* SPI_SHADER_32_AR (80982) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'F', 'P', '1', '6', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_FP16_ABGR (80999) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'N', 'O', 'R', 'M', '1', '6', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_UNORM16_ABGR (81020) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'S', 'N', 'O', 'R', 'M', '1', '6', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_SNORM16_ABGR (81044) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'I', 'N', 'T', '1', '6', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_UINT16_ABGR (81068) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'S', 'I', 'N', 'T', '1', '6', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_SINT16_ABGR (81091) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '3', '2', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_32_ABGR (81114) */
	'Z', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* Z_EXPORT_FORMAT (81133) */
	'C', 'O', 'L', '0', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL0_EXPORT_FORMAT (81149) */
	'C', 'O', 'L', '1', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL1_EXPORT_FORMAT (81168) */
	'C', 'O', 'L', '2', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL2_EXPORT_FORMAT (81187) */
	'C', 'O', 'L', '3', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL3_EXPORT_FORMAT (81206) */
	'C', 'O', 'L', '4', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL4_EXPORT_FORMAT (81225) */
	'C', 'O', 'L', '5', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL5_EXPORT_FORMAT (81244) */
	'C', 'O', 'L', '6', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL6_EXPORT_FORMAT (81263) */
	'C', 'O', 'L', '7', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL7_EXPORT_FORMAT (81282) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'N', 'O', '_', 'C', 'O', 'N', 'V', 'E', 'R', 'S', 'I', 'O', 'N', '\0', /* SX_RT_EXPORT_NO_CONVERSION (81301) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '3', '2', '_', 'R', '\0', /* SX_RT_EXPORT_32_R (81328) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '3', '2', '_', 'A', '\0', /* SX_RT_EXPORT_32_A (81346) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '\0', /* SX_RT_EXPORT_10_11_11 (81364) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '\0', /* SX_RT_EXPORT_2_10_10_10 (81386) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '\0', /* SX_RT_EXPORT_8_8_8_8 (81410) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '5', '_', '6', '_', '5', '\0', /* SX_RT_EXPORT_5_6_5 (81431) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '1', '_', '5', '_', '5', '_', '5', '\0', /* SX_RT_EXPORT_1_5_5_5 (81450) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '4', '_', '4', '_', '4', '_', '4', '\0', /* SX_RT_EXPORT_4_4_4_4 (81471) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '1', '6', '_', '1', '6', '_', 'G', 'R', '\0', /* SX_RT_EXPORT_16_16_GR (81492) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '1', '6', '_', '1', '6', '_', 'A', 'R', '\0', /* SX_RT_EXPORT_16_16_AR (81514) */
	'M', 'R', 'T', '0', '\0', /* MRT0 (81536) */
	'M', 'R', 'T', '1', '\0', /* MRT1 (81541) */
	'M', 'R', 'T', '2', '\0', /* MRT2 (81546) */
	'M', 'R', 'T', '3', '\0', /* MRT3 (81551) */
	'M', 'R', 'T', '4', '\0', /* MRT4 (81556) */
	'M', 'R', 'T', '5', '\0', /* MRT5 (81561) */
	'M', 'R', 'T', '6', '\0', /* MRT6 (81566) */
	'M', 'R', 'T', '7', '\0', /* MRT7 (81571) */
	'1', '1', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* 11BIT_FORMAT (81576) */
	'1', '0', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* 10BIT_FORMAT (81589) */
	'8', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* 8BIT_FORMAT (81602) */
	'6', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* 6BIT_FORMAT (81614) */
	'5', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* 5BIT_FORMAT (81626) */
	'4', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* 4BIT_FORMAT (81638) */
	'M', 'R', 'T', '0', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT0_EPSILON (81650) */
	'M', 'R', 'T', '1', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT1_EPSILON (81663) */
	'M', 'R', 'T', '2', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT2_EPSILON (81676) */
	'M', 'R', 'T', '3', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT3_EPSILON (81689) */
	'M', 'R', 'T', '4', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT4_EPSILON (81702) */
	'M', 'R', 'T', '5', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT5_EPSILON (81715) */
	'M', 'R', 'T', '6', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT6_EPSILON (81728) */
	'M', 'R', 'T', '7', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT7_EPSILON (81741) */
	'M', 'R', 'T', '0', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT0_COLOR_OPT_DISABLE (81754) */
	'M', 'R', 'T', '0', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT0_ALPHA_OPT_DISABLE (81777) */
	'M', 'R', 'T', '1', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT1_COLOR_OPT_DISABLE (81800) */
	'M', 'R', 'T', '1', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT1_ALPHA_OPT_DISABLE (81823) */
	'M', 'R', 'T', '2', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT2_COLOR_OPT_DISABLE (81846) */
	'M', 'R', 'T', '2', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT2_ALPHA_OPT_DISABLE (81869) */
	'M', 'R', 'T', '3', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT3_COLOR_OPT_DISABLE (81892) */
	'M', 'R', 'T', '3', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT3_ALPHA_OPT_DISABLE (81915) */
	'M', 'R', 'T', '4', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT4_COLOR_OPT_DISABLE (81938) */
	'M', 'R', 'T', '4', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT4_ALPHA_OPT_DISABLE (81961) */
	'M', 'R', 'T', '5', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT5_COLOR_OPT_DISABLE (81984) */
	'M', 'R', 'T', '5', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT5_ALPHA_OPT_DISABLE (82007) */
	'M', 'R', 'T', '6', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT6_COLOR_OPT_DISABLE (82030) */
	'M', 'R', 'T', '6', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT6_ALPHA_OPT_DISABLE (82053) */
	'M', 'R', 'T', '7', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT7_COLOR_OPT_DISABLE (82076) */
	'M', 'R', 'T', '7', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT7_ALPHA_OPT_DISABLE (82099) */
	'P', 'I', 'X', 'E', 'N', '_', 'Z', 'E', 'R', 'O', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* PIXEN_ZERO_OPT_DISABLE (82122) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'N', 'O', 'N', 'E', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'A', 'L', 'L', '\0', /* BLEND_OPT_PRESERVE_NONE_IGNORE_ALL (82145) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'A', 'L', 'L', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'N', 'O', 'N', 'E', '\0', /* BLEND_OPT_PRESERVE_ALL_IGNORE_NONE (82180) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'C', '1', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'C', '0', '\0', /* BLEND_OPT_PRESERVE_C1_IGNORE_C0 (82215) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'C', '0', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'C', '1', '\0', /* BLEND_OPT_PRESERVE_C0_IGNORE_C1 (82247) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'A', '1', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'A', '0', '\0', /* BLEND_OPT_PRESERVE_A1_IGNORE_A0 (82279) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'A', '0', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'A', '1', '\0', /* BLEND_OPT_PRESERVE_A0_IGNORE_A1 (82311) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'N', 'O', 'N', 'E', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'A', '0', '\0', /* BLEND_OPT_PRESERVE_NONE_IGNORE_A0 (82343) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'N', 'O', 'N', 'E', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'N', 'O', 'N', 'E', '\0', /* BLEND_OPT_PRESERVE_NONE_IGNORE_NONE (82377) */
	'C', 'O', 'L', 'O', 'R', '_', 'S', 'R', 'C', '_', 'O', 'P', 'T', '\0', /* COLOR_SRC_OPT (82413) */
	'C', 'O', 'L', 'O', 'R', '_', 'D', 'S', 'T', '_', 'O', 'P', 'T', '\0', /* COLOR_DST_OPT (82427) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'N', 'O', 'N', 'E', '\0', /* OPT_COMB_NONE (82441) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'A', 'D', 'D', '\0', /* OPT_COMB_ADD (82455) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'S', 'U', 'B', 'T', 'R', 'A', 'C', 'T', '\0', /* OPT_COMB_SUBTRACT (82468) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'M', 'I', 'N', '\0', /* OPT_COMB_MIN (82486) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'M', 'A', 'X', '\0', /* OPT_COMB_MAX (82499) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'R', 'E', 'V', 'S', 'U', 'B', 'T', 'R', 'A', 'C', 'T', '\0', /* OPT_COMB_REVSUBTRACT (82512) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', 'D', '\0', /* OPT_COMB_BLEND_DISABLED (82533) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'S', 'A', 'F', 'E', '_', 'A', 'D', 'D', '\0', /* OPT_COMB_SAFE_ADD (82557) */
	'C', 'O', 'L', 'O', 'R', '_', 'C', 'O', 'M', 'B', '_', 'F', 'C', 'N', '\0', /* COLOR_COMB_FCN (82575) */
	'A', 'L', 'P', 'H', 'A', '_', 'S', 'R', 'C', '_', 'O', 'P', 'T', '\0', /* ALPHA_SRC_OPT (82590) */
	'A', 'L', 'P', 'H', 'A', '_', 'D', 'S', 'T', '_', 'O', 'P', 'T', '\0', /* ALPHA_DST_OPT (82604) */
	'A', 'L', 'P', 'H', 'A', '_', 'C', 'O', 'M', 'B', '_', 'F', 'C', 'N', '\0', /* ALPHA_COMB_FCN (82618) */
	'B', 'L', 'E', 'N', 'D', '_', 'Z', 'E', 'R', 'O', '\0', /* BLEND_ZERO (82633) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '\0', /* BLEND_ONE (82644) */
	'B', 'L', 'E', 'N', 'D', '_', 'S', 'R', 'C', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_SRC_COLOR (82654) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'S', 'R', 'C', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_ONE_MINUS_SRC_COLOR (82670) */
	'B', 'L', 'E', 'N', 'D', '_', 'S', 'R', 'C', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_SRC_ALPHA (82696) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'S', 'R', 'C', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_ONE_MINUS_SRC_ALPHA (82712) */
	'B', 'L', 'E', 'N', 'D', '_', 'D', 'S', 'T', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_DST_ALPHA (82738) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'D', 'S', 'T', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_ONE_MINUS_DST_ALPHA (82754) */
	'B', 'L', 'E', 'N', 'D', '_', 'D', 'S', 'T', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_DST_COLOR (82780) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'D', 'S', 'T', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_ONE_MINUS_DST_COLOR (82796) */
	'B', 'L', 'E', 'N', 'D', '_', 'S', 'R', 'C', '_', 'A', 'L', 'P', 'H', 'A', '_', 'S', 'A', 'T', 'U', 'R', 'A', 'T', 'E', '\0', /* BLEND_SRC_ALPHA_SATURATE (82822) */
	'B', 'L', 'E', 'N', 'D', '_', 'B', 'O', 'T', 'H', '_', 'S', 'R', 'C', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_BOTH_SRC_ALPHA (82847) */
	'B', 'L', 'E', 'N', 'D', '_', 'B', 'O', 'T', 'H', '_', 'I', 'N', 'V', '_', 'S', 'R', 'C', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_BOTH_INV_SRC_ALPHA (82868) */
	'B', 'L', 'E', 'N', 'D', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_CONSTANT_COLOR (82893) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_ONE_MINUS_CONSTANT_COLOR (82914) */
	'B', 'L', 'E', 'N', 'D', '_', 'S', 'R', 'C', '1', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_SRC1_COLOR (82945) */
	'B', 'L', 'E', 'N', 'D', '_', 'I', 'N', 'V', '_', 'S', 'R', 'C', '1', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_INV_SRC1_COLOR (82962) */
	'B', 'L', 'E', 'N', 'D', '_', 'S', 'R', 'C', '1', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_SRC1_ALPHA (82983) */
	'B', 'L', 'E', 'N', 'D', '_', 'I', 'N', 'V', '_', 'S', 'R', 'C', '1', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_INV_SRC1_ALPHA (83000) */
	'B', 'L', 'E', 'N', 'D', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_CONSTANT_ALPHA (83021) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_ONE_MINUS_CONSTANT_ALPHA (83042) */
	'C', 'O', 'L', 'O', 'R', '_', 'S', 'R', 'C', 'B', 'L', 'E', 'N', 'D', '\0', /* COLOR_SRCBLEND (83073) */
	'C', 'O', 'M', 'B', '_', 'D', 'S', 'T', '_', 'P', 'L', 'U', 'S', '_', 'S', 'R', 'C', '\0', /* COMB_DST_PLUS_SRC (83088) */
	'C', 'O', 'M', 'B', '_', 'S', 'R', 'C', '_', 'M', 'I', 'N', 'U', 'S', '_', 'D', 'S', 'T', '\0', /* COMB_SRC_MINUS_DST (83106) */
	'C', 'O', 'M', 'B', '_', 'M', 'I', 'N', '_', 'D', 'S', 'T', '_', 'S', 'R', 'C', '\0', /* COMB_MIN_DST_SRC (83125) */
	'C', 'O', 'M', 'B', '_', 'M', 'A', 'X', '_', 'D', 'S', 'T', '_', 'S', 'R', 'C', '\0', /* COMB_MAX_DST_SRC (83142) */
	'C', 'O', 'M', 'B', '_', 'D', 'S', 'T', '_', 'M', 'I', 'N', 'U', 'S', '_', 'S', 'R', 'C', '\0', /* COMB_DST_MINUS_SRC (83159) */
	'C', 'O', 'L', 'O', 'R', '_', 'D', 'E', 'S', 'T', 'B', 'L', 'E', 'N', 'D', '\0', /* COLOR_DESTBLEND (83178) */
	'A', 'L', 'P', 'H', 'A', '_', 'S', 'R', 'C', 'B', 'L', 'E', 'N', 'D', '\0', /* ALPHA_SRCBLEND (83194) */
	'A', 'L', 'P', 'H', 'A', '_', 'D', 'E', 'S', 'T', 'B', 'L', 'E', 'N', 'D', '\0', /* ALPHA_DESTBLEND (83209) */
	'S', 'E', 'P', 'A', 'R', 'A', 'T', 'E', '_', 'A', 'L', 'P', 'H', 'A', '_', 'B', 'L', 'E', 'N', 'D', '\0', /* SEPARATE_ALPHA_BLEND (83225) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'R', 'O', 'P', '3', '\0', /* DISABLE_ROP3 (83246, 83254) */
	'S', 'R', 'C', '_', 'S', 'T', 'A', 'T', 'E', '_', 'I', 'D', '\0', /* SRC_STATE_ID (83259) */
	'D', 'I', '_', 'S', 'R', 'C', '_', 'S', 'E', 'L', '_', 'D', 'M', 'A', '\0', /* DI_SRC_SEL_DMA (83272) */
	'D', 'I', '_', 'S', 'R', 'C', '_', 'S', 'E', 'L', '_', 'I', 'M', 'M', 'E', 'D', 'I', 'A', 'T', 'E', '\0', /* DI_SRC_SEL_IMMEDIATE (83287) */
	'D', 'I', '_', 'S', 'R', 'C', '_', 'S', 'E', 'L', '_', 'A', 'U', 'T', 'O', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* DI_SRC_SEL_AUTO_INDEX (83308) */
	'D', 'I', '_', 'S', 'R', 'C', '_', 'S', 'E', 'L', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '\0', /* DI_SRC_SEL_RESERVED (83330) */
	'S', 'O', 'U', 'R', 'C', 'E', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SOURCE_SELECT (83350) */
	'D', 'I', '_', 'M', 'A', 'J', 'O', 'R', '_', 'M', 'O', 'D', 'E', '_', '0', '\0', /* DI_MAJOR_MODE_0 (83364) */
	'D', 'I', '_', 'M', 'A', 'J', 'O', 'R', '_', 'M', 'O', 'D', 'E', '_', '1', '\0', /* DI_MAJOR_MODE_1 (83380) */
	'M', 'A', 'J', 'O', 'R', '_', 'M', 'O', 'D', 'E', '\0', /* MAJOR_MODE (83396) */
	'S', 'P', 'R', 'I', 'T', 'E', '_', 'E', 'N', '_', 'R', '6', 'X', 'X', '\0', /* SPRITE_EN_R6XX (83407) */
	'N', 'O', 'T', '_', 'E', 'O', 'P', '\0', /* NOT_EOP (83422) */
	'U', 'S', 'E', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '\0', /* USE_OPAQUE (83430) */
	'U', 'N', 'R', 'O', 'L', 'L', 'E', 'D', '_', 'I', 'N', 'S', 'T', '\0', /* UNROLLED_INST (83441) */
	'G', 'R', 'B', 'M', '_', 'S', 'K', 'E', 'W', '_', 'N', 'O', '_', 'D', 'E', 'C', '\0', /* GRBM_SKEW_NO_DEC (83455) */
	'R', 'E', 'G', '_', 'R', 'T', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* REG_RT_INDEX (83472) */
	'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'L', 'O', 'W', '\0', /* ADDRESS_LOW (83485) */
	'M', 'A', 'X', '_', 'V', 'E', 'R', 'T', 'S', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'O', 'U', 'P', '\0', /* MAX_VERTS_PER_SUBGROUP (83497) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* STENCIL_ENABLE (83520) */
	'Z', '_', 'W', 'R', 'I', 'T', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* Z_WRITE_ENABLE (83535) */
	'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DEPTH_BOUNDS_ENABLE (83550) */
	'B', 'A', 'C', 'K', 'F', 'A', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* BACKFACE_ENABLE (83570) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'F', 'U', 'N', 'C', '\0', /* STENCILFUNC (83586) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'F', 'U', 'N', 'C', '_', 'B', 'F', '\0', /* STENCILFUNC_BF (83598) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'L', 'O', 'R', '_', 'W', 'R', 'I', 'T', 'E', 'S', '_', 'O', 'N', '_', 'D', 'E', 'P', 'T', 'H', '_', 'F', 'A', 'I', 'L', '\0', /* ENABLE_COLOR_WRITES_ON_DEPTH_FAIL (83613) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'L', 'O', 'R', '_', 'W', 'R', 'I', 'T', 'E', 'S', '_', 'O', 'N', '_', 'D', 'E', 'P', 'T', 'H', '_', 'P', 'A', 'S', 'S', '\0', /* DISABLE_COLOR_WRITES_ON_DEPTH_PASS (83647) */
	'M', 'A', 'X', '_', 'A', 'N', 'C', 'H', 'O', 'R', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* MAX_ANCHOR_SAMPLES (83682) */
	'P', 'S', '_', 'I', 'T', 'E', 'R', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* PS_ITER_SAMPLES (83701) */
	'M', 'A', 'S', 'K', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'N', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* MASK_EXPORT_NUM_SAMPLES (83717) */
	'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '_', 'N', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* ALPHA_TO_MASK_NUM_SAMPLES (83741) */
	'H', 'I', 'G', 'H', '_', 'Q', 'U', 'A', 'L', 'I', 'T', 'Y', '_', 'I', 'N', 'T', 'E', 'R', 'S', 'E', 'C', 'T', 'I', 'O', 'N', 'S', '\0', /* HIGH_QUALITY_INTERSECTIONS (83767) */
	'I', 'N', 'C', 'O', 'H', 'E', 'R', 'E', 'N', 'T', '_', 'E', 'Q', 'A', 'A