#!/bin/perl
# bn_prime.pl

$num=2048;
$num=$ARGV[0] if ($#ARGV >= 0);

push(@primes,2);
$p=1;
loop: while ($#primes < $num-1)
	{
	$p+=2;
	$s=int(sqrt($p));

	for ($i=0; defined($primes[$i]) && $primes[$i]<=$s; $i++)
		{
		next loop if (($p%$primes[$i]) == 0);
		}
	push(@primes,$p);
	}

# print <<"EOF";
# /* Auto generated by bn_prime.pl */
# /* Copyright (C) 1995-1997 Eric Young (eay\@mincom.oz.au).
#  * All rights reserved.
#  * Copyright remains Eric Young's, and as such any Copyright notices in
#  * the code are not to be removed.
#  * See the COPYRIGHT file in the SSLeay distribution for more details.
#  */
#
# EOF

printf("/*\t\$" . "OpenBSD" . "\$ */\n");
print <<\EOF;
/*
 * Public domain, generated by bn_prime.pl.
 */

EOF

print "#include \"bn_prime.h\"\n\n";
print "const uint16_t primes[NUMPRIMES] = {";
for ($i=0; $i <= $#primes; $i++)
	{
	if ((($i%8) == 0)) {
		printf("\n\t")
	} else {
		printf(" ");
	}
	printf("%5d,",$primes[$i]);
	}
print "\n};\n";
