# !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
# This file is machine-generated by lib/unicore/mktables from the Unicode
# database, Version 14.0.0.  Any changes made here will be lost!

sub TODO_FAILING_BREAKS { 0 }

use strict;
use warnings;

use feature 'signatures';

no warnings 'experimental::uniprop_wildcards';

# Test qr/\X/ and the \p{} regular expression constructs.  This file is
# constructed by mktables from the tables it generates, so if mktables is
# buggy, this won't necessarily catch those bugs.  Tests are generated for all
# feasible properties; a few aren't currently feasible; see
# is_code_point_usable() in mktables for details.

# Standard test packages are not used because this manipulates SIG_WARN.  It
# exits 0 if every non-skipped test succeeded; -1 if any failed.

my $Tests = 0;
my $Fails = 0;

# loc_tools.pl requires this function to be defined
sub ok($pass, @msg) {
    print "not " unless $pass;
    print "ok ";
    print ++$Tests;
    print " - ", join "", @msg if @msg;
    print "\n";
}

sub Expect($expected, $ord, $regex, $warning_type='') {
    my $line   = (caller)[2];

    # Convert the code point to hex form
    my $string = sprintf "\"\\x{%04X}\"", $ord;

    my @tests = "";

    # The first time through, use all warnings.  If the input should generate
    # a warning, add another time through with them turned off
    push @tests, "no warnings '$warning_type';" if $warning_type;

    foreach my $no_warnings (@tests) {

        # Store any warning messages instead of outputting them
        local $SIG{__WARN__} = $SIG{__WARN__};
        my $warning_message;
        $SIG{__WARN__} = sub { $warning_message = $_[0] };

        $Tests++;

        # A string eval is needed because of the 'no warnings'.
        # Assumes no parentheses in the regular expression
        my $result = eval "$no_warnings
                            my \$RegObj = qr($regex);
                            $string =~ \$RegObj ? 1 : 0";
        if (not defined $result) {
            print "not ok $Tests - couldn't compile /$regex/; line $line: $@\n";
            $Fails++;
        }
        elsif ($result ^ $expected) {
            print "not ok $Tests - expected $expected but got $result for $string =~ qr/$regex/; line $line\n";
            $Fails++;
        }
        elsif ($warning_message) {
            if (! $warning_type || ($warning_type && $no_warnings)) {
                print "not ok $Tests - for qr/$regex/ did not expect warning message '$warning_message'; line $line\n";
                $Fails++;
            }
            else {
                print "ok $Tests - expected and got a warning message for qr/$regex/; line $line\n";
            }
        }
        elsif ($warning_type && ! $no_warnings) {
            print "not ok $Tests - for qr/$regex/ expected a $warning_type warning message, but got none; line $line\n";
            $Fails++;
        }
        else {
            print "ok $Tests - got $result for $string =~ qr/$regex/; line $line\n";
        }
    }
    return;
}

sub Error($regex) {
    $Tests++;
    if (eval { 'x' =~ qr/$regex/; 1 }) {
        $Fails++;
        my $line = (caller)[2];
        print "not ok $Tests - re compiled ok, but expected error for qr/$regex/; line $line: $@\n";
    }
    else {
        my $line = (caller)[2];
        print "ok $Tests - got and expected error for qr/$regex/; line $line\n";
    }
    return;
}

# Break test files (e.g. GCBTest.txt) character that break allowed here
my $breakable_utf8 = my $breakable = chr(utf8::unicode_to_native(0xF7));
utf8::upgrade($breakable_utf8);

# Break test files (e.g. GCBTest.txt) character that indicates can't break
# here
my $nobreak_utf8 = my $nobreak = chr(utf8::unicode_to_native(0xD7));
utf8::upgrade($nobreak_utf8);

my $are_ctype_locales_available;
my $utf8_locale;
chdir 't' if -d 't';
eval { require "./loc_tools.pl" };
if (defined &locales_enabled) {
    $are_ctype_locales_available = locales_enabled('LC_CTYPE');
    if ($are_ctype_locales_available) {
        $utf8_locale = &find_utf8_ctype_locale;
    }
}

# Eval'd so can run on versions earlier than the property is available in
my $WB_Extend_or_Format_re = eval 'qr/[\p{WB=Extend}\p{WB=Format}\p{WB=ZWJ}]/';
if (! defined $WB_Extend_or_Format_re) {
    $WB_Extend_or_Format_re = eval 'qr/[\p{WB=Extend}\p{WB=Format}]/';
}

sub _test_break($template, $break_type) {
    # Test various break property matches.  The 2nd parameter gives the
    # property name.  The input is a line from auxiliary/*Test.txt for the
    # given property.  Each such line is a sequence of Unicode (not native)
    # code points given by their hex numbers, separated by the two characters
    # defined just before this subroutine that indicate that either there can
    # or cannot be a break between the adjacent code points.  All these are
    # tested.
    #
    # For the gcb property extra tests are made.  if there isn't a break, that
    # means the sequence forms an extended grapheme cluster, which means that
    # \X should match the whole thing.  If there is a break, \X should stop
    # there.  This is all converted by this routine into a match: $string =~
    # /(\X)/, Each \X should match the next cluster; and that is what is
    # checked.

    my $line   = (caller 1)[2];   # Line number
    my $comment = "";

    if ($template =~ / ( .*? ) \s* \# (.*) /x) {
        $template = $1;
        $comment = $2;

        # Replace leading spaces with a single one.
        $comment =~ s/ ^ \s* / # /x;
    }

    # The line contains characters above the ASCII range, but in Latin1.  It
    # may or may not be in utf8, and if it is, it may or may not know it.  So,
    # convert these characters to 8 bits.  If knows is in utf8, simply
    # downgrade.
    if (utf8::is_utf8($template)) {
        utf8::downgrade($template);
    } else {

        # Otherwise, if it is in utf8, but doesn't know it, the next lines
        # convert the two problematic characters to their 8-bit equivalents.
        # If it isn't in utf8, they don't harm anything.
        use bytes;
        $template =~ s/$nobreak_utf8/$nobreak/g;
        $template =~ s/$breakable_utf8/$breakable/g;
    }

    # Perl customizes wb.  So change the official tests accordingly
    if ($break_type eq 'wb' && $WB_Extend_or_Format_re) {

        # Split into elements that alternate between code point and
        # break/no-break
        my @line = split / +/, $template;

        # Look at each code point and its following one
        for (my $i = 1; $i <  @line - 1 - 1; $i+=2) {

            # The customization only involves changing some breaks to
            # non-breaks.
            next if $line[$i+1] =~ /$nobreak/;

            my $lhs = chr utf8::unicode_to_native(hex $line[$i]);
            my $rhs = chr utf8::unicode_to_native(hex $line[$i+2]);

            # And it only affects adjacent space characters.
            next if $lhs !~ /\s/u;

            # But, we want to make sure to test spaces followed by a Extend
            # or Format.
            next if $rhs !~ /\s|$WB_Extend_or_Format_re/;

            # To test the customization, add some white-space before this to
            # create a span.  The $lhs white space may or may not be bound to
            # that span, and also with the $rhs.  If the $rhs is a binding
            # character, the $lhs is bound to it and not to the span, unless
            # $lhs is vertical space.  In all other cases, the $lhs is bound
            # to the span.  If the $rhs is white space, it is bound to the
            # $lhs
            my $bound;
            my $span;
            if ($rhs =~ /$WB_Extend_or_Format_re/) {
                if ($lhs =~ /\v/) {
                    $bound = $breakable;
                    $span = $nobreak;
                }
                else {
                    $bound = $nobreak;
                    $span = $breakable;
                }
            }
            else {
                $span = $nobreak;
                $bound = $nobreak;
            }

            splice @line, $i, 0, ( '0020', $nobreak, '0020', $span);
            $i += 4;
            $line[$i+1] = $bound;
        }
        $template = join " ", @line;
    }

    # The input is just the break/no-break symbols and sequences of Unicode
    # code points as hex digits separated by spaces for legibility. e.g.:
    # ÷ 0020 × 0308 ÷ 0020 ÷
    # Convert to native \x format
    $template =~ s/ \s* ( [[:xdigit:]]+ ) \s* /sprintf("\\x{%02X}", utf8::unicode_to_native(hex $1))/gex;
    $template =~ s/ \s* //gx;   # Probably the line above removed all spaces;
                                # but be sure

    # Make a copy of the input with the symbols replaced by \b{} and \B{} as
    # appropriate
    my $break_pattern = $template =~ s/ $breakable /\\b{$break_type}/grx;
    $break_pattern =~ s/ $nobreak /\\B{$break_type}/gx;

    my $display_string = $template =~ s/[$breakable$nobreak]//gr;
    my $string = eval "\"$display_string\"";

    # The remaining massaging of the input is for the \X tests.  Get rid of
    # the leading and trailing breakables
    $template =~ s/^ \s* $breakable \s* //x;
    $template =~ s/ \s* $breakable \s* $ //x;

    # Delete no-breaks
    $template =~ s/ \s* $nobreak \s* //xg;

    # Split the input into segments that are breakable between them.
    my @should_display = split /\s*$breakable\s*/, $template;
    my @should_match = map { eval "\"$_\"" } @should_display;

    # If a string can be represented in both non-ut8 and utf8, test both cases
    my $display_upgrade = "";
    UPGRADE:
    for my $to_upgrade (0 .. 1) {

        if ($to_upgrade) {

            # If already in utf8, would just be a repeat
            next UPGRADE if utf8::is_utf8($string);

            utf8::upgrade($string);
            $display_upgrade = " (utf8-upgraded)";
        }

        my @modifiers = qw(a aa d u i);
        if ($are_ctype_locales_available) {
            push @modifiers, "l$utf8_locale" if defined $utf8_locale;

            # The /l modifier has C after it to indicate the locale to try
            push @modifiers, "lC";
        }

        # Test for each of the regex modifiers.
        for my $modifier (@modifiers) {
            my $display_locale = "";

            # For /l, set the locale to what it says to.
            if ($modifier =~ / ^ l (.*) /x) {
                my $locale = $1;
                $display_locale = "(locale = $locale)";
                POSIX::setlocale(POSIX::LC_CTYPE(), $locale);
                $modifier = 'l';
            }

            no warnings qw(locale regexp surrogate);
            my $pattern = "(?$modifier:$break_pattern)";

            # Actually do the test
            my $matched_text;
            my $matched = $string =~ qr/$pattern/;
            if ($matched) {
                $matched_text = "matched";
            }
            else {
                $matched_text = "failed to match";
                print "not ";

                if (TODO_FAILING_BREAKS) {
                    $comment = " # $comment" unless $comment =~ / ^ \s* \# /x;
                    $comment =~ s/#/# TODO/;
                }
            }
            print "ok ", ++$Tests, " - \"$display_string\" $matched_text /$pattern/$display_upgrade; line $line $display_locale$comment\n";

            # Only print the comment on the first use of this line
            $comment = "";

            # Repeat with the first \B{} in the pattern.  This makes sure the
            # code in regexec.c:find_byclass() for \B gets executed
            if ($pattern =~ / ( .*? : ) .* ( \\B\{ .* ) /x) {
                my $B_pattern = "$1$2";
                $matched = $string =~ qr/$B_pattern/;
                print "not " unless $matched;
                $matched_text = ($matched) ? "matched" : "failed to match";
                print "ok ", ++$Tests, " - \"$display_string\" $matched_text /$B_pattern/$display_upgrade; line $line $display_locale";
                print " # TODO" if TODO_FAILING_BREAKS && ! $matched;
                print "\n";
            }
        }

        next if $break_type ne 'gcb';

        # Finally, do the \X match.
        my @matches = $string =~ /(\X)/g;

        # Look through each matched cluster to verify that it matches what we
        # expect.
        my $min = (@matches < @should_match) ? @matches : @should_match;
        for my $i (0 .. $min - 1) {
            $Tests++;
            if ($matches[$i] eq $should_match[$i]) {
                print "ok $Tests - ";
                if ($i == 0) {
                    print "In \"$display_string\" =~ /(\\X)/g, \\X #1";
                } else {
                    print "And \\X #", $i + 1,
                }
                print " correctly matched $should_display[$i]; line $line\n";
            } else {
                $matches[$i] = join("", map { sprintf "\\x{%04X}", ord $_ }
                                                    split "", $matches[$i]);
                print "not ok $Tests -";
                print " # TODO" if TODO_FAILING_BREAKS;
                print " In \"$display_string\" =~ /(\\X)/g, \\X #",
                    $i + 1,
                    " should have matched $should_display[$i]",
                    " but instead matched $matches[$i]",
                    ".  Abandoning rest of line $line\n";
                next UPGRADE;
            }
        }

        # And the number of matches should equal the number of expected matches.
        $Tests++;
        if (@matches == @should_match) {
            print "ok $Tests - Nothing was left over; line $line\n";
        } else {
            print "not ok $Tests - There were ", scalar @should_match, " \\X matches expected, but got ", scalar @matches, " instead; line $line";
            print " # TODO" if TODO_FAILING_BREAKS;
            print "\n";
        }
    }

    return;
}

sub Test_GCB($t) {
    _test_break($t, 'gcb');
}

sub Test_LB($t) {
    _test_break($t, 'lb');
}

sub Test_SB($t) {
    _test_break($t, 'sb');
}

sub Test_WB($t) {
    _test_break($t, 'wb');
}

sub Finished() {
    print "1..$Tests\n";
    exit($Fails ? -1 : 0);
}

if (!$::TESTCHUNK or $::TESTCHUNK == 1) {
    Error('\p{Script=InGreek}');    # Bug #69018
    Test_GCB("1100 $nobreak 1161");  # Bug #70940
    Expect(0, 0x2028, '\p{Print}', ""); # Bug # 71722
    Expect(0, 0x2029, '\p{Print}', ""); # Bug # 71722
    Expect(1, 0xFF10, '\p{XDigit}', ""); # Bug # 71726
    Error('\p{InKana}');    # 'Kana' is not a block so InKana shouldn't compile
    Expect(1, 0xB6, '\p{In=V1_1}', ""); # Didn't use to work
    Expect(1, 0x3A2,'\p{In=NA}', "");   # Didn't use to work
    
    # Make sure this gets tested; it was not part of the official test suite at
    # the time this was added.  Note that this is as it would appear in the
    # official suite, and gets modified to check for the perl tailoring by
    # Test_WB()
    Test_WB("$breakable 0020 $breakable 0020 $breakable 0308 $breakable");
    Test_LB("$nobreak 200B $nobreak 0020 $nobreak 0020 $breakable 2060 $breakable");
    Expect(1, ord(" "), '\p{gc=:(?aa)s:}', "");     # /aa is valid
    Expect(1, ord(" "), '\p{gc=:(?-s)s:}', "");     # /-s is valid
    ;
    Error('\p{_perllb}');
    Error('\P{_perllb}');
    Error('\p{_perlscx}');
    Error('\P{_perlscx}');
    Error('\p{age}');
    Error('\P{age}');
    Error('\p{Age=_V1_1/a/}');
    Error('\P{Age=_V1_1/a/}');
    Expect(1, 65533, '\p{Age=:\AV1_1\z:}', "");;
    Expect(0, 65536, '\p{Age=:\AV1_1\z:}', "");;
    Expect(1, 65533, '\p{Age=v11}', "");
    Expect(0, 65533, '\p{^Age=v11}', "");
    Expect(0, 65533, '\P{Age=v11}', "");
    Expect(1, 65533, '\P{^Age=v11}', "");
    Expect(0, 65536, '\p{Age=v11}', "");
    Expect(1, 65536, '\p{^Age=v11}', "");
    Expect(1, 65536, '\P{Age=v11}', "");
    Expect(0, 65536, '\P{^Age=v11}', "");
    Expect(1, 65533, '\p{Age=:\Av11\z:}', "");;
    Expect(0, 65536, '\p{Age=:\Av11\z:}', "");;
    Expect(1, 65533, '\p{Age=	v1_1}', "");
    Expect(0, 65533, '\p{^Age=	v1_1}', "");
    Expect(0, 65533, '\P{Age=	v1_1}', "");
    Expect(1, 65533, '\P{^Age=	v1_1}', "");
    Expect(0, 65536, '\p{Age=	v1_1}', "");
    Expect(1, 65536, '\p{^Age=	v1_1}', "");
    Expect(1, 65536, '\P{Age=	v1_1}', "");
    Expect(0, 65536, '\P{^Age=	v1_1}', "");
    Error('\p{Is_Age=:=	 000000001.1}');
    Error('\P{Is_Age=:=	 000000001.1}');
    Expect(1, 65533, '\p{Is_Age=+0_1.1}', "");
    Expect(0, 65533, '\p{^Is_Age=+0_1.1}', "");
    Expect(0, 65533, '\P{Is_Age=+0_1.1}', "");
    Expect(1, 65533, '\P{^Is_Age=+0_1.1}', "");
    Expect(0, 65536, '\p{Is_Age=+0_1.1}', "");
    Expect(1, 65536, '\p{^Is_Age=+0_1.1}', "");
    Expect(1, 65536, '\P{Is_Age=+0_1.1}', "");
    Expect(0, 65536, '\P{^Is_Age=+0_1.1}', "");
    Error('\p{Age=		v10_0:=}');
    Error('\P{Age=		v10_0:=}');
    Expect(1, 191456, '\p{Age=:\AV10_0\z:}', "");;
    Expect(0, 191457, '\p{Age=:\AV10_0\z:}', "");;
    Expect(1, 191456, '\p{Age=v100}', "");
    Expect(0, 191456, '\p{^Age=v100}', "");
    Expect(0, 191456, '\P{Age=v100}', "");
    Expect(1, 191456, '\P{^Age=v100}', "");
    Expect(0, 191457, '\p{Age=v100}', "");
    Expect(1, 191457, '\p{^Age=v100}', "");
    Expect(1, 191457, '\P{Age=v100}', "");
    Expect(0, 191457, '\P{^Age=v100}', "");
    Expect(1, 191456, '\p{Age=:\Av100\z:}', "");;
    Expect(0, 191457, '\p{Age=:\Av100\z:}', "");;
    Expect(1, 191456, '\p{Age=	-V10_0}', "");
    Expect(0, 191456, '\p{^Age=	-V10_0}', "");
    Expect(0, 191456, '\P{Age=	-V10_0}', "");
    Expect(1, 191456, '\P{^Age=	-V10_0}', "");
    Expect(0, 191457, '\p{Age=	-V10_0}', "");
    Expect(1, 191457, '\p{^Age=	-V10_0}', "");
    Expect(1, 191457, '\P{Age=	-V10_0}', "");
    Expect(0, 191457, '\P{^Age=	-V10_0}', "");
    Error('\p{Is_Age:   __0_0_0_0_0_0_0010.0/a/}');
    Error('\P{Is_Age:   __0_0_0_0_0_0_0010.0/a/}');
    Expect(1, 191456, '\p{Is_Age=0000010.0}', "");
    Expect(0, 191456, '\p{^Is_Age=0000010.0}', "");
    Expect(0, 191456, '\P{Is_Age=0000010.0}', "");
    Expect(1, 191456, '\P{^Is_Age=0000010.0}', "");
    Expect(0, 191457, '\p{Is_Age=0000010.0}', "");
    Expect(1, 191457, '\p{^Is_Age=0000010.0}', "");
    Expect(1, 191457, '\P{Is_Age=0000010.0}', "");
    Expect(0, 191457, '\P{^Is_Age=0000010.0}', "");
    Error('\p{Age=/a/V11_0}');
    Error('\P{Age=/a/V11_0}');
    Expect(1, 129645, '\p{Age=:\AV11_0\z:}', "");;
    Expect(0, 129646, '\p{Age=:\AV11_0\z:}', "");;
    Expect(1, 129645, '\p{Age=v110}', "");
    Expect(0, 129645, '\p{^Age=v110}', "");
    Expect(0, 129645, '\P{Age=v110}', "");
    Expect(1, 129645, '\P{^Age=v110}', "");
    Expect(0, 129646, '\p{Age=v110}', "");
    Expect(1, 129646, '\p{^Age=v110}', "");
    Expect(1, 129646, '\P{Age=v110}', "");
    Expect(0, 129646, '\P{^Age=v110}', "");
    Expect(1, 129645, '\p{Age=:\Av110\z:}', "");;
    Expect(0, 129646, '\p{Age=:\Av110\z:}', "");;
    Expect(1, 129645, '\p{Age= _V11_0}', "");
    Expect(0, 129645, '\p{^Age= _V11_0}', "");
    Expect(0, 129645, '\P{Age= _V11_0}', "");
    Expect(1, 129645, '\P{^Age= _V11_0}', "");
    Expect(0, 129646, '\p{Age= _V11_0}', "");
    Expect(1, 129646, '\p{^Age= _V11_0}', "");
    Expect(1, 129646, '\P{Age= _V11_0}', "");
    Expect(0, 129646, '\P{^Age= _V11_0}', "");
    Error('\p{Is_Age=_ +0000011.0:=}');
    Error('\P{Is_Age=_ +0000011.0:=}');
    Expect(1, 129645, '\p{Is_Age=1_1.0}', "");
    Expect(0, 129645, '\p{^Is_Age=1_1.0}', "");
    Expect(0, 129645, '\P{Is_Age=1_1.0}', "");
    Expect(1, 129645, '\P{^Is_Age=1_1.0}', "");
    Expect(0, 129646, '\p{Is_Age=1_1.0}', "");
    Expect(1, 129646, '\p{^Is_Age=1_1.0}', "");
    Expect(1, 129646, '\P{Is_Age=1_1.0}', "");
    Expect(0, 129646, '\P{^Is_Age=1_1.0}', "");
    Error('\p{Age= V12_0:=}');
    Error('\P{Age= V12_0:=}');
    Expect(1, 129685, '\p{Age=:\AV12_0\z:}', "");;
    Expect(0, 129686, '\p{Age=:\AV12_0\z:}', "");;
    Expect(1, 129685, '\p{Age=v120}', "");
    Expect(0, 129685, '\p{^Age=v120}', "");
    Expect(0, 129685, '\P{Age=v120}', "");
    Expect(1, 129685, '\P{^Age=v120}', "");
    Expect(0, 129686, '\p{Age=v120}', "");
    Expect(1, 129686, '\p{^Age=v120}', "");
    Expect(1, 129686, '\P{Age=v120}', "");
    Expect(0, 129686, '\P{^Age=v120}', "");
    Expect(1, 129685, '\p{Age=:\Av120\z:}', "");;
    Expect(0, 129686, '\p{Age=:\Av120\z:}', "");;
    Expect(1, 129685, '\p{Age= _V12_0}', "");
    Expect(0, 129685, '\p{^Age= _V12_0}', "");
    Expect(0, 129685, '\P{Age= _V12_0}', "");
    Expect(1, 129685, '\P{^Age= _V12_0}', "");
    Expect(0, 129686, '\p{Age= _V12_0}', "");
    Expect(1, 129686, '\p{^Age= _V12_0}', "");
    Expect(1, 129686, '\P{Age= _V12_0}', "");
    Expect(0, 129686, '\P{^Age= _V12_0}', "");
    Error('\p{Is_Age=/a/		0000000012.0}');
    Error('\P{Is_Age=/a/		0000000012.0}');
    Expect(1, 129685, '\p{Is_Age=00_00_01_2.0}', "");
    Expect(0, 129685, '\p{^Is_Age=00_00_01_2.0}', "");
    Expect(0, 129685, '\P{Is_Age=00_00_01_2.0}', "");
    Expect(1, 129685, '\P{^Is_Age=00_00_01_2.0}', "");
    Expect(0, 129686, '\p{Is_Age=00_00_01_2.0}', "");
    Expect(1, 129686, '\p{^Is_Age=00_00_01_2.0}', "");
    Expect(1, 129686, '\P{Is_Age=00_00_01_2.0}', "");
    Expect(0, 129686, '\P{^Is_Age=00_00_01_2.0}', "");
    Error('\p{Age=_V12_1/a/}');
    Error('\P{Age=_V12_1/a/}');
    Expect(1, 13055, '\p{Age=:\AV12_1\z:}', "");;
    Expect(0, 13056, '\p{Age=:\AV12_1\z:}', "");;
    Expect(1, 13055, '\p{Age=v121}', "");
    Expect(0, 13055, '\p{^Age=v121}', "");
    Expect(0, 13055, '\P{Age=v121}', "");
    Expect(1, 13055, '\P{^Age=v121}', "");
    Expect(0, 13056, '\p{Age=v121}', "");
    Expect(1, 13056, '\p{^Age=v121}', "");
    Expect(1, 13056, '\P{Age=v121}', "");
    Expect(0, 13056, '\P{^Age=v121}', "");
    Expect(1, 13055, '\p{Age=:\Av121\z:}', "");;
    Expect(0, 13056, '\p{Age=:\Av121\z:}', "");;
    Expect(1, 13055, '\p{Age= 	V12_1}', "");
    Expect(0, 13055, '\p{^Age= 	V12_1}', "");
    Expect(0, 13055, '\P{Age= 	V12_1}', "");
    Expect(1, 13055, '\P{^Age= 	V12_1}', "");
    Expect(0, 13056, '\p{Age= 	V12_1}', "");
    Expect(1, 13056, '\p{^Age= 	V12_1}', "");
    Expect(1, 13056, '\P{Age= 	V12_1}', "");
    Expect(0, 13056, '\P{^Age= 	V12_1}', "");
    Error('\p{Is_Age=:=-+012.1}');
    Error('\P{Is_Age=:=-+012.1}');
    Expect(1, 13055, '\p{Is_Age=000000012.1}', "");
    Expect(0, 13055, '\p{^Is_Age=000000012.1}', "");
    Expect(0, 13055, '\P{Is_Age=000000012.1}', "");
    Expect(1, 13055, '\P{^Is_Age=000000012.1}', "");
    Expect(0, 13056, '\p{Is_Age=000000012.1}', "");
    Expect(1, 13056, '\p{^Is_Age=000000012.1}', "");
    Expect(1, 13056, '\P{Is_Age=000000012.1}', "");
    Expect(0, 13056, '\P{^Is_Age=000000012.1}', "");
    Error('\p{Age=--V13_0/a/}');
    Error('\P{Age=--V13_0/a/}');
    Expect(1, 201546, '\p{Age=:\AV13_0\z:}', "");;
    Expect(0, 201547, '\p{Age=:\AV13_0\z:}', "");;
    Expect(1, 201546, '\p{Age=v130}', "");
    Expect(0, 201546, '\p{^Age=v130}', "");
    Expect(0, 201546, '\P{Age=v130}', "");
    Expect(1, 201546, '\P{^Age=v130}', "");
    Expect(0, 201547, '\p{Age=v130}', "");
    Expect(1, 201547, '\p{^Age=v130}', "");
    Expect(1, 201547, '\P{Age=v130}', "");
    Expect(0, 201547, '\P{^Age=v130}', "");
    Expect(1, 201546, '\p{Age=:\Av130\z:}', "");;
    Expect(0, 201547, '\p{Age=:\Av130\z:}', "");;
    Expect(1, 201546, '\p{Age= V13_0}', "");
    Expect(0, 201546, '\p{^Age= V13_0}', "");
    Expect(0, 201546, '\P{Age= V13_0}', "");
    Expect(1, 201546, '\P{^Age= V13_0}', "");
    Expect(0, 201547, '\p{Age= V13_0}', "");
    Expect(1, 201547, '\p{^Age= V13_0}', "");
    Expect(1, 201547, '\P{Age= V13_0}', "");
    Expect(0, 201547, '\P{^Age= V13_0}', "");
    Error('\p{Is_Age=	01_3.0/a/}');
    Error('\P{Is_Age=	01_3.0/a/}');
    Expect(1, 201546, '\p{Is_Age=+00000013.0}', "");
    Expect(0, 201546, '\p{^Is_Age=+00000013.0}', "");
    Expect(0, 201546, '\P{Is_Age=+00000013.0}', "");
    Expect(1, 201546, '\P{^Is_Age=+00000013.0}', "");
    Expect(0, 201547, '\p{Is_Age=+00000013.0}', "");
    Expect(1, 201547, '\p{^Is_Age=+00000013.0}', "");
    Expect(1, 201547, '\P{Is_Age=+00000013.0}', "");
    Expect(0, 201547, '\P{^Is_Age=+00000013.0}', "");
    Error('\p{Age=	V14_0/a/}');
    Error('\P{Age=	V14_0/a/}');
    Expect(1, 177976, '\p{Age=:\AV14_0\z:}', "");;
    Expect(0, 177977, '\p{Age=:\AV14_0\z:}', "");;
    Expect(1, 177976, '\p{Age=v140}', "");
    Expect(0, 177976, '\p{^Age=v140}', "");
    Expect(0, 177976, '\P{Age=v140}', "");
    Expect(1, 177976, '\P{^Age=v140}', "");
    Expect(0, 177977, '\p{Age=v140}', "");
    Expect(1, 177977, '\p{^Age=v140}', "");
    Expect(1, 177977, '\P{Age=v140}', "");
    Expect(0, 177977, '\P{^Age=v140}', "");
    Expect(1, 177976, '\p{Age=:\Av140\z:}', "");;
    Expect(0, 177977, '\p{Age=:\Av140\z:}', "");;
    Expect(1, 177976, '\p{Age=  V14_0}', "");
    Expect(0, 177976, '\p{^Age=  V14_0}', "");
    Expect(0, 177976, '\P{Age=  V14_0}', "");
    Expect(1, 177976, '\P{^Age=  V14_0}', "");
    Expect(0, 177977, '\p{Age=  V14_0}', "");
    Expect(1, 177977, '\p{^Age=  V14_0}', "");
    Expect(1, 177977, '\P{Age=  V14_0}', "");
    Expect(0, 177977, '\P{^Age=  V14_0}', "");
    Error('\p{Is_Age=:=	-+00000014.0}');
    Error('\P{Is_Age=:=	-+00000014.0}');
    Expect(1, 177976, '\p{Is_Age=0_0_0_0_0014.0}', "");
    Expect(0, 177976, '\p{^Is_Age=0_0_0_0_0014.0}', "");
    Expect(0, 177976, '\P{Is_Age=0_0_0_0_0014.0}', "");
    Expect(1, 177976, '\P{^Is_Age=0_0_0_0_0014.0}', "");
    Expect(0, 177977, '\p{Is_Age=0_0_0_0_0014.0}', "");
    Expect(1, 177977, '\p{^Is_Age=0_0_0_0_0014.0}', "");
    Expect(1, 177977, '\P{Is_Age=0_0_0_0_0014.0}', "");
    Expect(0, 177977, '\P{^Is_Age=0_0_0_0_0014.0}', "");
    Error('\p{Age= :=V2_0}');
    Error('\P{Age= :=V2_0}');
    Expect(1, 983040, '\p{Age=:\AV2_0\z:}', "");;
    Expect(0, 983037, '\p{Age=:\AV2_0\z:}', "");;
    Expect(1, 983040, '\p{Age=v20}', "");
    Expect(0, 983040, '\p{^Age=v20}', "");
    Expect(0, 983040, '\P{Age=v20}', "");
    Expect(1, 983040, '\P{^Age=v20}', "");
    Expect(0, 983037, '\p{Age=v20}', "");
    Expect(1, 983037, '\p{^Age=v20}', "");
    Expect(1, 983037, '\P{Age=v20}', "");
    Expect(0, 983037, '\P{^Age=v20}', "");
    Expect(1, 983040, '\p{Age=:\Av20\z:}', "");;
    Expect(0, 983037, '\p{Age=:\Av20\z:}', "");;
    Expect(1, 983040, '\p{Age=V2_0}', "");
    Expect(0, 983040, '\p{^Age=V2_0}', "");
    Expect(0, 983040, '\P{Age=V2_0}', "");
    Expect(1, 983040, '\P{^Age=V2_0}', "");
    Expect(0, 983037, '\p{Age=V2_0}', "");
    Expect(1, 983037, '\p{^Age=V2_0}', "");
    Expect(1, 983037, '\P{Age=V2_0}', "");
    Expect(0, 983037, '\P{^Age=V2_0}', "");
    Error('\p{Is_Age=/a/ -+0000002.0}');
    Error('\P{Is_Age=/a/ -+0000002.0}');
    Expect(1, 983040, '\p{Is_Age=2.0}', "");
    Expect(0, 983040, '\p{^Is_Age=2.0}', "");
    Expect(0, 983040, '\P{Is_Age=2.0}', "");
    Expect(1, 983040, '\P{^Is_Age=2.0}', "");
    Expect(0, 983037, '\p{Is_Age=2.0}', "");
    Expect(1, 983037, '\p{^Is_Age=2.0}', "");
    Expect(1, 983037, '\P{Is_Age=2.0}', "");
    Expect(0, 983037, '\P{^Is_Age=2.0}', "");
    Error('\p{Age: := _V2_1}');
    Error('\P{Age: := _V2_1}');
    Expect(1, 65532, '\p{Age=:\AV2_1\z:}', "");;
    Expect(0, 65533, '\p{Age=:\AV2_1\z:}', "");;
    Expect(1, 65532, '\p{Age=v21}', "");
    Expect(0, 65532, '\p{^Age=v21}', "");
    Expect(0, 65532, '\P{Age=v21}', "");
    Expect(1, 65532, '\P{^Age=v21}', "");
    Expect(0, 65533, '\p{Age=v21}', "");
    Expect(1, 65533, '\p{^Age=v21}', "");
    Expect(1, 65533, '\P{Age=v21}', "");
    Expect(0, 65533, '\P{^Age=v21}', "");
    Expect(1, 65532, '\p{Age=:\Av21\z:}', "");;
    Expect(0, 65533, '\p{Age=:\Av21\z:}', "");;
    Expect(1, 65532, '\p{Age=	_V2_1}', "");
    Expect(0, 65532, '\p{^Age=	_V2_1}', "");
    Expect(0, 65532, '\P{Age=	_V2_1}', "");
    Expect(1, 65532, '\P{^Age=	_V2_1}', "");
    Expect(0, 65533, '\p{Age=	_V2_1}', "");
    Expect(1, 65533, '\p{^Age=	_V2_1}', "");
    Expect(1, 65533, '\P{Age=	_V2_1}', "");
    Expect(0, 65533, '\P{^Age=	_V2_1}', "");
    Error('\p{Is_Age=:=  002.1}');
    Error('\P{Is_Age=:=  002.1}');
    Expect(1, 65532, '\p{Is_Age=+002.1}', "");
    Expect(0, 65532, '\p{^Is_Age=+002.1}', "");
    Expect(0, 65532, '\P{Is_Age=+002.1}', "");
    Expect(1, 65532, '\P{^Is_Age=+002.1}', "");
    Expect(0, 65533, '\p{Is_Age=+002.1}', "");
    Expect(1, 65533, '\p{^Is_Age=+002.1}', "");
    Expect(1, 65533, '\P{Is_Age=+002.1}', "");
    Expect(0, 65533, '\P{^Is_Age=+002.1}', "");
    Error('\p{Age=-/a/v3_0}');
    Error('\P{Age=-/a/v3_0}');
    Expect(1, 65531, '\p{Age=:\AV3_0\z:}', "");;
    Expect(0, 65532, '\p{Age=:\AV3_0\z:}', "");;
    Expect(1, 65531, '\p{Age=v30}', "");
    Expect(0, 65531, '\p{^Age=v30}', "");
    Expect(0, 65531, '\P{Age=v30}', "");
    Expect(1, 65531, '\P{^Age=v30}', "");
    Expect(0, 65532, '\p{Age=v30}', "");
    Expect(1, 65532, '\p{^Age=v30}', "");
    Expect(1, 65532, '\P{Age=v30}', "");
    Expect(0, 65532, '\P{^Age=v30}', "");
    Expect(1, 65531, '\p{Age=:\Av30\z:}', "");;
    Expect(0, 65532, '\p{Age=:\Av30\z:}', "");;
    Expect(1, 65531, '\p{Age=	V3_0}', "");
    Expect(0, 65531, '\p{^Age=	V3_0}', "");
    Expect(0, 65531, '\P{Age=	V3_0}', "");
    Expect(1, 65531, '\P{^Age=	V3_0}', "");
    Expect(0, 65532, '\p{Age=	V3_0}', "");
    Expect(1, 65532, '\p{^Age=	V3_0}', "");
    Expect(1, 65532, '\P{Age=	V3_0}', "");
    Expect(0, 65532, '\P{^Age=	V3_0}', "");
    Error('\p{Is_Age=:= 3.0}');
    Error('\P{Is_Age=:= 3.0}');
    Expect(1, 65531, '\p{Is_Age=3.0}', "");
    Expect(0, 65531, '\p{^Is_Age=3.0}', "");
    Expect(0, 65531, '\P{Is_Age=3.0}', "");
    Expect(1, 65531, '\P{^Is_Age=3.0}', "");
    Expect(0, 65532, '\p{Is_Age=3.0}', "");
    Expect(1, 65532, '\p{^Is_Age=3.0}', "");
    Expect(1, 65532, '\P{Is_Age=3.0}', "");
    Expect(0, 65532, '\P{^Is_Age=3.0}', "");
    Error('\p{Age=-/a/V3_1}');
    Error('\P{Age=-/a/V3_1}');
    Expect(1, 917631, '\p{Age=:\AV3_1\z:}', "");;
    Expect(0, 917632, '\p{Age=:\AV3_1\z:}', "");;
    Expect(1, 917631, '\p{Age=v31}', "");
    Expect(0, 917631, '\p{^Age=v31}', "");
    Expect(0, 917631, '\P{Age=v31}', "");
    Expect(1, 917631, '\P{^Age=v31}', "");
    Expect(0, 917632, '\p{Age=v31}', "");
    Expect(1, 917632, '\p{^Age=v31}', "");
    Expect(1, 917632, '\P{Age=v31}', "");
    Expect(0, 917632, '\P{^Age=v31}', "");
    Expect(1, 917631, '\p{Age=:\Av31\z:}', "");;
    Expect(0, 917632, '\p{Age=:\Av31\z:}', "");;
    Expect(1, 917631, '\p{Age=		V3_1}', "");
    Expect(0, 917631, '\p{^Age=		V3_1}', "");
    Expect(0, 917631, '\P{Age=		V3_1}', "");
    Expect(1, 917631, '\P{^Age=		V3_1}', "");
    Expect(0, 917632, '\p{Age=		V3_1}', "");
    Expect(1, 917632, '\p{^Age=		V3_1}', "");
    Expect(1, 917632, '\P{Age=		V3_1}', "");
    Expect(0, 917632, '\P{^Age=		V3_1}', "");
    Error('\p{Is_Age=:=- 0003.1}');
    Error('\P{Is_Age=:=- 0003.1}');
    Expect(1, 917631, '\p{Is_Age=+000003.1}', "");
    Expect(0, 917631, '\p{^Is_Age=+000003.1}', "");
    Expect(0, 917631, '\P{Is_Age=+000003.1}', "");
    Expect(1, 917631, '\P{^Is_Age=+000003.1}', "");
    Expect(0, 917632, '\p{Is_Age=+000003.1}', "");
    Expect(1, 917632, '\p{^Is_Age=+000003.1}', "");
    Expect(1, 917632, '\P{Is_Age=+000003.1}', "");
    Expect(0, 917632, '\P{^Is_Age=+000003.1}', "");
    Error('\p{Age=/a/__V3_2}');
    Error('\P{Age=/a/__V3_2}');
    Expect(1, 65376, '\p{Age=:\AV3_2\z:}', "");;
    Expect(0, 65377, '\p{Age=:\AV3_2\z:}', "");;
    Expect(1, 65376, '\p{Age=v32}', "");
    Expect(0, 65376, '\p{^Age=v32}', "");
    Expect(0, 65376, '\P{Age=v32}', "");
    Expect(1, 65376, '\P{^Age=v32}', "");
    Expect(0, 65377, '\p{Age=v32}', "");
    Expect(1, 65377, '\p{^Age=v32}', "");
    Expect(1, 65377, '\P{Age=v32}', "");
    Expect(0, 65377, '\P{^Age=v32}', "");
    Expect(1, 65376, '\p{Age=:\Av32\z:}', "");;
    Expect(0, 65377, '\p{Age=:\Av32\z:}', "");;
    Expect(1, 65376, '\p{Age=_	v3_2}', "");
    Expect(0, 65376, '\p{^Age=_	v3_2}', "");
    Expect(0, 65376, '\P{Age=_	v3_2}', "");
    Expect(1, 65376, '\P{^Age=_	v3_2}', "");
    Expect(0, 65377, '\p{Age=_	v3_2}', "");
    Expect(1, 65377, '\p{^Age=_	v3_2}', "");
    Expect(1, 65377, '\P{Age=_	v3_2}', "");
    Expect(0, 65377, '\P{^Age=_	v3_2}', "");
    Error('\p{Is_Age=:=-	0_0_03.2}');
    Error('\P{Is_Age=:=-	0_0_03.2}');
    Expect(1, 65376, '\p{Is_Age=+0000_3.2}', "");
    Expect(0, 65376, '\p{^Is_Age=+0000_3.2}', "");
    Expect(0, 65376, '\P{Is_Age=+0000_3.2}', "");
    Expect(1, 65376, '\P{^Is_Age=+0000_3.2}', "");
    Expect(0, 65377, '\p{Is_Age=+0000_3.2}', "");
    Expect(1, 65377, '\p{^Is_Age=+0000_3.2}', "");
    Expect(1, 65377, '\P{Is_Age=+0000_3.2}', "");
    Expect(0, 65377, '\P{^Is_Age=+0000_3.2}', "");
    Error('\p{Age=:=V4_0}');
    Error('\P{Age=:=V4_0}');
    Expect(1, 917999, '\p{Age=:\AV4_0\z:}', "");;
    Expect(0, 918000, '\p{Age=:\AV4_0\z:}', "");;
    Expect(1, 917999, '\p{Age:	v40}', "");
    Expect(0, 917999, '\p{^Age:	v40}', "");
    Expect(0, 917999, '\P{Age:	v40}', "");
    Expect(1, 917999, '\P{^Age:	v40}', "");
    Expect(0, 918000, '\p{Age:	v40}', "");
    Expect(1, 918000, '\p{^Age:	v40}', "");
    Expect(1, 918000, '\P{Age:	v40}', "");
    Expect(0, 918000, '\P{^Age:	v40}', "");
    Expect(1, 917999, '\p{Age=:\Av40\z:}', "");;
    Expect(0, 918000, '\p{Age=:\Av40\z:}', "");;
    Expect(1, 917999, '\p{Age= -v4_0}', "");
    Expect(0, 917999, '\p{^Age= -v4_0}', "");
    Expect(0, 917999, '\P{Age= -v4_0}', "");
    Expect(1, 917999, '\P{^Age= -v4_0}', "");
    Expect(0, 918000, '\p{Age= -v4_0}', "");
    Expect(1, 918000, '\p{^Age= -v4_0}', "");
    Expect(1, 918000, '\P{Age= -v4_0}', "");
    Expect(0, 918000, '\P{^Age= -v4_0}', "");
    Error('\p{Is_Age=_0_4.0:=}');
    Error('\P{Is_Age=_0_4.0:=}');
    Expect(1, 917999, '\p{Is_Age=+00004.0}', "");
    Expect(0, 917999, '\p{^Is_Age=+00004.0}', "");
    Expect(0, 917999, '\P{Is_Age=+00004.0}', "");
    Expect(1, 917999, '\P{^Is_Age=+00004.0}', "");
    Expect(0, 918000, '\p{Is_Age=+00004.0}', "");
    Expect(1, 918000, '\p{^Is_Age=+00004.0}', "");
    Expect(1, 918000, '\P{Is_Age=+00004.0}', "");
    Expect(0, 918000, '\P{^Is_Age=+00004.0}', "");
    Error('\p{Age=:=_V4_1}');
    Error('\P{Age=:=_V4_1}');
    Expect(1, 120485, '\p{Age=:\AV4_1\z:}', "");;
    Expect(0, 120486, '\p{Age=:\AV4_1\z:}', "");;
    Expect(1, 120485, '\p{Age:	v41}', "");
    Expect(0, 120485, '\p{^Age:	v41}', "");
    Expect(0, 120485, '\P{Age:	v41}', "");
    Expect(1, 120485, '\P{^Age:	v41}', "");
    Expect(0, 120486, '\p{Age:	v41}', "");
    Expect(1, 120486, '\p{^Age:	v41}', "");
    Expect(1, 120486, '\P{Age:	v41}', "");
    Expect(0, 120486, '\P{^Age:	v41}', "");
    Expect(1, 120485, '\p{Age=:\Av41\z:}', "");;
    Expect(0, 120486, '\p{Age=:\Av41\z:}', "");;
    Expect(1, 120485, '\p{Age=		v4_1}', "");
    Expect(0, 120485, '\p{^Age=		v4_1}', "");
    Expect(0, 120485, '\P{Age=		v4_1}', "");
    Expect(1, 120485, '\P{^Age=		v4_1}', "");
    Expect(0, 120486, '\p{Age=		v4_1}', "");
    Expect(1, 120486, '\p{^Age=		v4_1}', "");
    Expect(1, 120486, '\P{Age=		v4_1}', "");
    Expect(0, 120486, '\P{^Age=		v4_1}', "");
    Error('\p{Is_Age=:=00_4.1}');
    Error('\P{Is_Age=:=00_4.1}');
    Expect(1, 120485, '\p{Is_Age=00_00_4.1}', "");
    Expect(0, 120485, '\p{^Is_Age=00_00_4.1}', "");
    Expect(0, 120485, '\P{Is_Age=00_00_4.1}', "");
    Expect(1, 120485, '\P{^Is_Age=00_00_4.1}', "");
    Expect(0, 120486, '\p{Is_Age=00_00_4.1}', "");
    Expect(1, 120486, '\p{^Is_Age=00_00_4.1}', "");
    Expect(1, 120486, '\P{Is_Age=00_00_4.1}', "");
    Expect(0, 120486, '\P{^Is_Age=00_00_4.1}', "");
    Error('\p{Age:/a/_V5_0}');
    Error('\P{Age:/a/_V5_0}');
    Expect(1, 120779, '\p{Age=:\AV5_0\z:}', "");;
    Expect(0, 120780, '\p{Age=:\AV5_0\z:}', "");;
    Expect(1, 120779, '\p{Age=v50}', "");
    Expect(0, 120779, '\p{^Age=v50}', "");
    Expect(0, 120779, '\P{Age=v50}', "");
    Expect(1, 120779, '\P{^Age=v50}', "");
    Expect(0, 120780, '\p{Age=v50}', "");
    Expect(1, 120780, '\p{^Age=v50}', "");
    Expect(1, 120780, '\P{Age=v50}', "");
    Expect(0, 120780, '\P{^Age=v50}', "");
    Expect(1, 120779, '\p{Age=:\Av50\z:}', "");;
    Expect(0, 120780, '\p{Age=:\Av50\z:}', "");;
    Expect(1, 120779, '\p{Age=	-V5_0}', "");
    Expect(0, 120779, '\p{^Age=	-V5_0}', "");
    Expect(0, 120779, '\P{Age=	-V5_0}', "");
    Expect(1, 120779, '\P{^Age=	-V5_0}', "");
    Expect(0, 120780, '\p{Age=	-V5_0}', "");
    Expect(1, 120780, '\p{^Age=	-V5_0}', "");
    Expect(1, 120780, '\P{Age=	-V5_0}', "");
    Expect(0, 120780, '\P{^Age=	-V5_0}', "");
    Error('\p{Is_Age=/a/-_+0_5.0}');
    Error('\P{Is_Age=/a/-_+0_5.0}');
    Expect(1, 120779, '\p{Is_Age=+00_00_00_005.0}', "");
    Expect(0, 120779, '\p{^Is_Age=+00_00_00_005.0}', "");
    Expect(0, 120779, '\P{Is_Age=+00_00_00_005.0}', "");
    Expect(1, 120779, '\P{^Is_Age=+00_00_00_005.0}', "");
    Expect(0, 120780, '\p{Is_Age=+00_00_00_005.0}', "");
    Expect(1, 120780, '\p{^Is_Age=+00_00_00_005.0}', "");
    Expect(1, 120780, '\P{Is_Age=+00_00_00_005.0}', "");
    Expect(0, 120780, '\P{^Is_Age=+00_00_00_005.0}', "");
    Error('\p{Age=V5_1:=}');
    Error('\P{Age=V5_1:=}');
    Expect(1, 127123, '\p{Age=:\AV5_1\z:}', "");;
    Expect(0, 127124, '\p{Age=:\AV5_1\z:}', "");;
    Expect(1, 127123, '\p{Age=v51}', "");
    Expect(0, 127123, '\p{^Age=v51}', "");
    Expect(0, 127123, '\P{Age=v51}', "");
    Expect(1, 127123, '\P{^Age=v51}', "");
    Expect(0, 127124, '\p{Age=v51}', "");
    Expect(1, 127124, '\p{^Age=v51}', "");
    Expect(1, 127124, '\P{Age=v51}', "");
    Expect(0, 127124, '\P{^Age=v51}', "");
    Expect(1, 127123, '\p{Age=:\Av51\z:}', "");;
    Expect(0, 127124, '\p{Age=:\Av51\z:}', "");;
    Expect(1, 127123, '\p{Age=	V5_1}', "");
    Expect(0, 127123, '\p{^Age=	V5_1}', "");
    Expect(0, 127123, '\P{Age=	V5_1}', "");
    Expect(1, 127123, '\P{^Age=	V5_1}', "");
    Expect(0, 127124, '\p{Age=	V5_1}', "");
    Expect(1, 127124, '\p{^Age=	V5_1}', "");
    Expect(1, 127124, '\P{Age=	V5_1}', "");
    Expect(0, 127124, '\P{^Age=	V5_1}', "");
    Error('\p{Is_Age=/a/		5.1}');
    Error('\P{Is_Age=/a/		5.1}');
    Expect(1, 127123, '\p{Is_Age=0_0_0_05.1}', "");
    Expect(0, 127123, '\p{^Is_Age=0_0_0_05.1}', "");
    Expect(0, 127123, '\P{Is_Age=0_0_0_05.1}', "");
    Expect(1, 127123, '\P{^Is_Age=0_0_0_05.1}', "");
    Expect(0, 127124, '\p{Is_Age=0_0_0_05.1}', "");
    Expect(1, 127124, '\p{^Is_Age=0_0_0_05.1}', "");
    Expect(1, 127124, '\P{Is_Age=0_0_0_05.1}', "");
    Expect(0, 127124, '\P{^Is_Age=0_0_0_05.1}', "");
    Error('\p{Age=	:=V5_2}');
    Error('\P{Age=	:=V5_2}');
    Expect(1, 177972, '\p{Age=:\AV5_2\z:}', "");;
    Expect(0, 177973, '\p{Age=:\AV5_2\z:}', "");;
    Expect(1, 177972, '\p{Age: v52}', "");
    Expect(0, 177972, '\p{^Age: v52}', "");
    Expect(0, 177972, '\P{Age: v52}', "");
    Expect(1, 177972, '\P{^Age: v52}', "");
    Expect(0, 177973, '\p{Age: v52}', "");
    Expect(1, 177973, '\p{^Age: v52}', "");
    Expect(1, 177973, '\P{Age: v52}', "");
    Expect(0, 177973, '\P{^Age: v52}', "");
    Expect(1, 177972, '\p{Age=:\Av52\z:}', "");;
    Expect(0, 177973, '\p{Age=:\Av52\z:}', "");;
    Expect(1, 177972, '\p{Age= _V5_2}', "");
    Expect(0, 177972, '\p{^Age= _V5_2}', "");
    Expect(0, 177972, '\P{Age= _V5_2}', "");
    Expect(1, 177972, '\P{^Age= _V5_2}', "");
    Expect(0, 177973, '\p{Age= _V5_2}', "");
    Expect(1, 177973, '\p{^Age= _V5_2}', "");
    Expect(1, 177973, '\P{Age= _V5_2}', "");
    Expect(0, 177973, '\P{^Age= _V5_2}', "");
    Error('\p{Is_Age=_+000005.2:=}');
    Error('\P{Is_Age=_+000005.2:=}');
    Expect(1, 177972, '\p{Is_Age=+0000000005.2}', "");
    Expect(0, 177972, '\p{^Is_Age=+0000000005.2}', "");
    Expect(0, 177972, '\P{Is_Age=+0000000005.2}', "");
    Expect(1, 177972, '\P{^Is_Age=+0000000005.2}', "");
    Expect(0, 177973, '\p{Is_Age=+0000000005.2}', "");
    Expect(1, 177973, '\p{^Is_Age=+0000000005.2}', "");
    Expect(1, 177973, '\P{Is_Age=+0000000005.2}', "");
    Expect(0, 177973, '\P{^Is_Age=+0000000005.2}', "");
    Error('\p{Age:		/a/V6_0}');
    Error('\P{Age:		/a/V6_0}');
    Expect(1, 178205, '\p{Age=:\AV6_0\z:}', "");;
    Expect(0, 178206, '\p{Age=:\AV6_0\z:}', "");;
    Expect(1, 178205, '\p{Age=v60}', "");
    Expect(0, 178205, '\p{^Age=v60}', "");
    Expect(0, 178205, '\P{Age=v60}', "");
    Expect(1, 178205, '\P{^Age=v60}', "");
    Expect(0, 178206, '\p{Age=v60}', "");
    Expect(1, 178206, '\p{^Age=v60}', "");
    Expect(1, 178206, '\P{Age=v60}', "");
    Expect(0, 178206, '\P{^Age=v60}', "");
    Expect(1, 178205, '\p{Age=:\Av60\z:}', "");;
    Expect(0, 178206, '\p{Age=:\Av60\z:}', "");;
    Expect(1, 178205, '\p{Age=_ v6_0}', "");
    Expect(0, 178205, '\p{^Age=_ v6_0}', "");
    Expect(0, 178205, '\P{Age=_ v6_0}', "");
    Expect(1, 178205, '\P{^Age=_ v6_0}', "");
    Expect(0, 178206, '\p{Age=_ v6_0}', "");
    Expect(1, 178206, '\p{^Age=_ v6_0}', "");
    Expect(1, 178206, '\P{Age=_ v6_0}', "");
    Expect(0, 178206, '\P{^Age=_ v6_0}', "");
    Error('\p{Is_Age=- +00_6.0:=}');
    Error('\P{Is_Age=- +00_6.0:=}');
    Expect(1, 178205, '\p{Is_Age:	0_6.0}', "");
    Expect(0, 178205, '\p{^Is_Age:	0_6.0}', "");
    Expect(0, 178205, '\P{Is_Age:	0_6.0}', "");
    Expect(1, 178205, '\P{^Is_Age:	0_6.0}', "");
    Expect(0, 178206, '\p{Is_Age:	0_6.0}', "");
    Expect(1, 178206, '\p{^Is_Age:	0_6.0}', "");
    Expect(1, 178206, '\P{Is_Age:	0_6.0}', "");
    Expect(0, 178206, '\P{^Is_Age:	0_6.0}', "");
    Error('\p{Age=/a/V6_1}');
    Error('\P{Age=/a/V6_1}');
    Expect(1, 128564, '\p{Age=:\AV6_1\z:}', "");;
    Expect(0, 128565, '\p{Age=:\AV6_1\z:}', "");;
    Expect(1, 128564, '\p{Age=v61}', "");
    Expect(0, 128564, '\p{^Age=v61}', "");
    Expect(0, 128564, '\P{Age=v61}', "");
    Expect(1, 128564, '\P{^Age=v61}', "");
    Expect(0, 128565, '\p{Age=v61}', "");
    Expect(1, 128565, '\p{^Age=v61}', "");
    Expect(1, 128565, '\P{Age=v61}', "");
    Expect(0, 128565, '\P{^Age=v61}', "");
    Expect(1, 128564, '\p{Age=:\Av61\z:}', "");;
    Expect(0, 128565, '\p{Age=:\Av61\z:}', "");;
    Expect(1, 128564, '\p{Age=_V6_1}', "");
    Expect(0, 128564, '\p{^Age=_V6_1}', "");
    Expect(0, 128564, '\P{Age=_V6_1}', "");
    Expect(1, 128564, '\P{^Age=_V6_1}', "");
    Expect(0, 128565, '\p{Age=_V6_1}', "");
    Expect(1, 128565, '\p{^Age=_V6_1}', "");
    Expect(1, 128565, '\P{Age=_V6_1}', "");
    Expect(0, 128565, '\P{^Age=_V6_1}', "");
    Error('\p{Is_Age= 00000000_6.1:=}');
    Error('\P{Is_Age= 00000000_6.1:=}');
    Expect(1, 128564, '\p{Is_Age=+0_6.1}', "");
    Expect(0, 128564, '\p{^Is_Age=+0_6.1}', "");
    Expect(0, 128564, '\P{Is_Age=+0_6.1}', "");
    Expect(1, 128564, '\P{^Is_Age=+0_6.1}', "");
    Expect(0, 128565, '\p{Is_Age=+0_6.1}', "");
    Expect(1, 128565, '\p{^Is_Age=+0_6.1}', "");
    Expect(1, 128565, '\P{Is_Age=+0_6.1}', "");
    Expect(0, 128565, '\P{^Is_Age=+0_6.1}', "");
    Error('\p{Age=:=_v6_2}');
    Error('\P{Age=:=_v6_2}');
    Expect(1, 8378, '\p{Age=:\AV6_2\z:}', "");;
    Expect(0, 8379, '\p{Age=:\AV6_2\z:}', "");;
    Expect(1, 8378, '\p{Age=v62}', "");
    Expect(0, 8378, '\p{^Age=v62}', "");
    Expect(0, 8378, '\P{Age=v62}', "");
    Expect(1, 8378, '\P{^Age=v62}', "");
    Expect(0, 8379, '\p{Age=v62}', "");
    Expect(1, 8379, '\p{^Age=v62}', "");
    Expect(1, 8379, '\P{Age=v62}', "");
    Expect(0, 8379, '\P{^Age=v62}', "");
    Expect(1, 8378, '\p{Age=:\Av62\z:}', "");;
    Expect(0, 8379, '\p{Age=:\Av62\z:}', "");;
    Expect(1, 8378, '\p{Age=-V6_2}', "");
    Expect(0, 8378, '\p{^Age=-V6_2}', "");
    Expect(0, 8378, '\P{Age=-V6_2}', "");
    Expect(1, 8378, '\P{^Age=-V6_2}', "");
    Expect(0, 8379, '\p{Age=-V6_2}', "");
    Expect(1, 8379, '\p{^Age=-V6_2}', "");
    Expect(1, 8379, '\P{Age=-V6_2}', "");
    Expect(0, 8379, '\P{^Age=-V6_2}', "");
    Error('\p{Is_Age=_	0_6.2/a/}');
    Error('\P{Is_Age=_	0_6.2/a/}');
    Expect(1, 8378, '\p{Is_Age=00_00_00_00_6.2}', "");
    Expect(0, 8378, '\p{^Is_Age=00_00_00_00_6.2}', "");
    Expect(0, 8378, '\P{Is_Age=00_00_00_00_6.2}', "");
    Expect(1, 8378, '\P{^Is_Age=00_00_00_00_6.2}', "");
    Expect(0, 8379, '\p{Is_Age=00_00_00_00_6.2}', "");
    Expect(1, 8379, '\p{^Is_Age=00_00_00_00_6.2}', "");
    Expect(1, 8379, '\P{Is_Age=00_00_00_00_6.2}', "");
    Expect(0, 8379, '\P{^Is_Age=00_00_00_00_6.2}', "");
    Error('\p{Age=-	v6_3/a/}');
    Error('\P{Age=-	v6_3/a/}');
    Expect(1, 8297, '\p{Age=:\AV6_3\z:}', "");;
    Expect(0, 8298, '\p{Age=:\AV6_3\z:}', "");;
    Expect(1, 8297, '\p{Age=v63}', "");
    Expect(0, 8297, '\p{^Age=v63}', "");
    Expect(0, 8297, '\P{Age=v63}', "");
    Expect(1, 8297, '\P{^Age=v63}', "");
    Expect(0, 8298, '\p{Age=v63}', "");
    Expect(1, 8298, '\p{^Age=v63}', "");
    Expect(1, 8298, '\P{Age=v63}', "");
    Expect(0, 8298, '\P{^Age=v63}', "");
    Expect(1, 8297, '\p{Age=:\Av63\z:}', "");;
    Expect(0, 8298, '\p{Age=:\Av63\z:}', "");;
    Expect(1, 8297, '\p{Age=  V6_3}', "");
    Expect(0, 8297, '\p{^Age=  V6_3}', "");
    Expect(0, 8297, '\P{Age=  V6_3}', "");
    Expect(1, 8297, '\P{^Age=  V6_3}', "");
    Expect(0, 8298, '\p{Age=  V6_3}', "");
    Expect(1, 8298, '\p{^Age=  V6_3}', "");
    Expect(1, 8298, '\P{Age=  V6_3}', "");
    Expect(0, 8298, '\P{^Age=  V6_3}', "");
    Error('\p{Is_Age=_/a/006.3}');
    Error('\P{Is_Age=_/a/006.3}');
    Expect(1, 8297, '\p{Is_Age=00000000_6.3}', "");
    Expect(0, 8297, '\p{^Is_Age=00000000_6.3}', "");
    Expect(0, 8297, '\P{Is_Age=00000000_6.3}', "");
    Expect(1, 8297, '\P{^Is_Age=00000000_6.3}', "");
    Expect(0, 8298, '\p{Is_Age=00000000_6.3}', "");
    Expect(1, 8298, '\p{^Is_Age=00000000_6.3}', "");
    Expect(1, 8298, '\P{Is_Age=00000000_6.3}', "");
    Expect(0, 8298, '\P{^Is_Age=00000000_6.3}', "");
    Error('\p{Age=/a/- V7_0}');
    Error('\P{Age=/a/- V7_0}');
    Expect(1, 129197, '\p{Age=:\AV7_0\z:}', "");;
    Expect(0, 129198, '\p{Age=:\AV7_0\z:}', "");;
    Expect(1, 129197, '\p{Age=v70}', "");
    Expect(0, 129197, '\p{^Age=v70}', "");
    Expect(0, 129197, '\P{Age=v70}', "");
    Expect(1, 129197, '\P{^Age=v70}', "");
    Expect(0, 129198, '\p{Age=v70}', "");
    Expect(1, 129198, '\p{^Age=v70}', "");
    Expect(1, 129198, '\P{Age=v70}', "");
    Expect(0, 129198, '\P{^Age=v70}', "");
    Expect(1, 129197, '\p{Age=:\Av70\z:}', "");;
    Expect(0, 129198, '\p{Age=:\Av70\z:}', "");;
    Expect(1, 129197, '\p{Age=_	v7_0}', "");
    Expect(0, 129197, '\p{^Age=_	v7_0}', "");
    Expect(0, 129197, '\P{Age=_	v7_0}', "");
    Expect(1, 129197, '\P{^Age=_	v7_0}', "");
    Expect(0, 129198, '\p{Age=_	v7_0}', "");
    Expect(1, 129198, '\p{^Age=_	v7_0}', "");
    Expect(1, 129198, '\P{Age=_	v7_0}', "");
    Expect(0, 129198, '\P{^Age=_	v7_0}', "");
    Error('\p{Is_Age=:= _0000007.0}');
    Error('\P{Is_Age=:= _0000007.0}');
    Expect(1, 129197, '\p{Is_Age=+0000_0000_07.0}', "");
    Expect(0, 129197, '\p{^Is_Age=+0000_0000_07.0}', "");
    Expect(0, 129197, '\P{Is_Age=+0000_0000_07.0}', "");
    Expect(1, 129197, '\P{^Is_Age=+0000_0000_07.0}', "");
    Expect(0, 129198, '\p{Is_Age=+0000_0000_07.0}', "");
    Expect(1, 129198, '\p{^Is_Age=+0000_0000_07.0}', "");
    Expect(1, 129198, '\P{Is_Age=+0000_0000_07.0}', "");
    Expect(0, 129198, '\P{^Is_Age=+0000_0000_07.0}', "");
    Error('\p{Age= /a/v8_0}');
    Error('\P{Age= /a/v8_0}');
    Expect(1, 183969, '\p{Age=:\AV8_0\z:}', "");;
    Expect(0, 183970, '\p{Age=:\AV8_0\z:}', "");;
    Expect(1, 183969, '\p{Age=v80}', "");
    Expect(0, 183969, '\p{^Age=v80}', "");
    Expect(0, 183969, '\P{Age=v80}', "");
    Expect(1, 183969, '\P{^Age=v80}', "");
    Expect(0, 183970, '\p{Age=v80}', "");
    Expect(1, 183970, '\p{^Age=v80}', "");
    Expect(1, 183970, '\P{Age=v80}', "");
    Expect(0, 183970, '\P{^Age=v80}', "");
    Expect(1, 183969, '\p{Age=:\Av80\z:}', "");;
    Expect(0, 183970, '\p{Age=:\Av80\z:}', "");;
    Expect(1, 183969, '\p{Age=	 V8_0}', "");
    Expect(0, 183969, '\p{^Age=	 V8_0}', "");
    Expect(0, 183969, '\P{Age=	 V8_0}', "");
    Expect(1, 183969, '\P{^Age=	 V8_0}', "");
    Expect(0, 183970, '\p{Age=	 V8_0}', "");
    Expect(1, 183970, '\p{^Age=	 V8_0}', "");
    Expect(1, 183970, '\P{Age=	 V8_0}', "");
    Expect(0, 183970, '\P{^Age=	 V8_0}', "");
    Error('\p{Is_Age= :=0008.0}');
    Error('\P{Is_Age= :=0008.0}');
    Expect(1, 183969, '\p{Is_Age=00000008.0}', "");
    Expect(0, 183969, '\p{^Is_Age=00000008.0}', "");
    Expect(0, 183969, '\P{Is_Age=00000008.0}', "");
    Expect(1, 183969, '\P{^Is_Age=00000008.0}', "");
    Expect(0, 183970, '\p{Is_Age=00000008.0}', "");
    Expect(1, 183970, '\p{^Is_Age=00000008.0}', "");
    Expect(1, 183970, '\P{Is_Age=00000008.0}', "");
    Expect(0, 183970, '\P{^Is_Age=00000008.0}', "");
    Error('\p{Age=	/a/V9_0}');
    Error('\P{Age=	/a/V9_0}');
    Expect(1, 129425, '\p{Age=:\AV9_0\z:}', "");;
    Expect(0, 129426, '\p{Age=:\AV9_0\z:}', "");;
    Expect(1, 129425, '\p{Age=v90}', "");
    Expect(0, 129425, '\p{^Age=v90}', "");
    Expect(0, 129425, '\P{Age=v90}', "");
    Expect(1, 129425, '\P{^Age=v90}', "");
    Expect(0, 129426, '\p{Age=v90}', "");
    Expect(1, 129426, '\p{^Age=v90}', "");
    Expect(1, 129426, '\P{Age=v90}', "");
    Expect(0, 129426, '\P{^Age=v90}', "");
    Expect(1, 129425, '\p{Age=:\Av90\z:}', "");;
    Expect(0, 129426, '\p{Age=:\Av90\z:}', "");;
    Expect(1, 129425, '\p{Age=_v9_0}', "");
    Expect(0, 129425, '\p{^Age=_v9_0}', "");
    Expect(0, 129425, '\P{Age=_v9_0}', "");
    Expect(1, 129425, '\P{^Age=_v9_0}', "");
    Expect(0, 129426, '\p{Age=_v9_0}', "");
    Expect(1, 129426, '\p{^Age=_v9_0}', "");
    Expect(1, 129426, '\P{Age=_v9_0}', "");
    Expect(0, 129426, '\P{^Age=_v9_0}', "");
    Error('\p{Is_Age=:=	_+009.0}');
    Error('\P{Is_Age=:=	_+009.0}');
    Expect(1, 129425, '\p{Is_Age=0_0_0_0_009.0}', "");
    Expect(0, 129425, '\p{^Is_Age=0_0_0_0_009.0}', "");
    Expect(0, 129425, '\P{Is_Age=0_0_0_0_009.0}', "");
    Expect(1, 129425, '\P{^Is_Age=0_0_0_0_009.0}', "");
    Expect(0, 129426, '\p{Is_Age=0_0_0_0_009.0}', "");
    Expect(1, 129426, '\p{^Is_Age=0_0_0_0_009.0}', "");
    Expect(1, 129426, '\P{Is_Age=0_0_0_0_009.0}', "");
    Expect(0, 129426, '\P{^Is_Age=0_0_0_0_009.0}', "");
    Error('\p{Age=_/a/Unassigned}');
    Error('\P{Age=_/a/Unassigned}');
    Expect(1, 983037, '\p{Age=:\AUnassigned\z:}', "");;
    Expect(0, 983040, '\p{Age=:\AUnassigned\z:}', "");;
    Expect(1, 983037, '\p{Age=unassigned}', "");
    Expect(0, 983037, '\p{^Age=unassigned}', "");
    Expect(0, 983037, '\P{Age=unassigned}', "");
    Expect(1, 983037, '\P{^Age=unassigned}', "");
    Expect(0, 983040, '\p{Age=unassigned}', "");
    Expect(1, 983040, '\p{^Age=unassigned}', "");
    Expect(1, 983040, '\P{Age=unassigned}', "");
    Expect(0, 983040, '\P{^Age=unassigned}', "");
    Expect(1, 983037, '\p{Age=:\Aunassigned\z:}', "");;
    Expect(0, 983040, '\p{Age=:\Aunassigned\z:}', "");;
    Expect(1, 983037, '\p{Age=- Unassigned}', "");
    Expect(0, 983037, '\p{^Age=- Unassigned}', "");
    Expect(0, 983037, '\P{Age=- Unassigned}', "");
    Expect(1, 983037, '\P{^Age=- Unassigned}', "");
    Expect(0, 983040, '\p{Age=- Unassigned}', "");
    Expect(1, 983040, '\p{^Age=- Unassigned}', "");
    Expect(1, 983040, '\P{Age=- Unassigned}', "");
    Expect(0, 983040, '\P{^Age=- Unassigned}', "");
    Error('\p{Is_Age=/a/NA}');
    Error('\P{Is_Age=/a/NA}');
    Expect(1, 983037, '\p{Is_Age=na}', "");
    Expect(0, 983037, '\p{^Is_Age=na}', "");
    Expect(0, 983037, '\P{Is_Age=na}', "");
    Expect(1, 983037, '\P{^Is_Age=na}', "");
    Expect(0, 983040, '\p{Is_Age=na}', "");
    Expect(1, 983040, '\p{^Is_Age=na}', "");
    Expect(1, 983040, '\P{Is_Age=na}', "");
    Expect(0, 983040, '\P{^Is_Age=na}', "");
    Expect(1, 983037, '\p{Is_Age:	 NA}', "");
    Expect(0, 983037, '\p{^Is_Age:	 NA}', "");
    Expect(0, 983037, '\P{Is_Age:	 NA}', "");
    Expect(1, 983037, '\P{^Is_Age:	 NA}', "");
    Expect(0, 983040, '\p{Is_Age:	 NA}', "");
    Expect(1, 983040, '\p{^Is_Age:	 NA}', "");
    Expect(1, 983040, '\P{Is_Age:	 NA}', "");
    Expect(0, 983040, '\P{^Is_Age:	 NA}', "");
    Error('\p{ASCII_Hex_Digit=-No/a/}');
    Error('\P{ASCII_Hex_Digit=-No/a/}');
    Expect(1, 103, '\p{ASCII_Hex_Digit=:\ANo\z:}', "");;
    Expect(0, 102, '\p{ASCII_Hex_Digit=:\ANo\z:}', "");;
    Expect(1, 103, '\p{ASCII_Hex_Digit=no}', "");
    Expect(0, 103, '\p{^ASCII_Hex_Digit=no}', "");
    Expect(0, 103, '\P{ASCII_Hex_Digit=no}', "");
    Expect(1, 103, '\P{^ASCII_Hex_Digit=no}', "");
    Expect(0, 102, '\p{ASCII_Hex_Digit=no}', "");
    Expect(1, 102, '\p{^ASCII_Hex_Digit=no}', "");
    Expect(1, 102, '\P{ASCII_Hex_Digit=no}', "");
    Expect(0, 102, '\P{^ASCII_Hex_Digit=no}', "");
    Expect(1, 103, '\p{ASCII_Hex_Digit=:\Ano\z:}', "");;
    Expect(0, 102, '\p{ASCII_Hex_Digit=:\Ano\z:}', "");;
    Expect(1, 103, '\p{ASCII_Hex_Digit=  no}', "");
    Expect(0, 103, '\p{^ASCII_Hex_Digit=  no}', "");
    Expect(0, 103, '\P{ASCII_Hex_Digit=  no}', "");
    Expect(1, 103, '\P{^ASCII_Hex_Digit=  no}', "");
    Expect(0, 102, '\p{ASCII_Hex_Digit=  no}', "");
    Expect(1, 102, '\p{^ASCII_Hex_Digit=  no}', "");
    Expect(1, 102, '\P{ASCII_Hex_Digit=  no}', "");
    Expect(0, 102, '\P{^ASCII_Hex_Digit=  no}', "");
    Error('\p{AHex=:= 	N}');
    Error('\P{AHex=:= 	N}');
    Expect(1, 103, '\p{AHex=:\AN\z:}', "");;
    Expect(0, 102, '\p{AHex=:\AN\z:}', "");;
    Expect(1, 103, '\p{AHex=n}', "");
    Expect(0, 103, '\p{^AHex=n}', "");
    Expect(0, 103, '\P{AHex=n}', "");
    Expect(1, 103, '\P{^AHex=n}', "");
    Expect(0, 102, '\p{AHex=n}', "");
    Expect(1, 102, '\p{^AHex=n}', "");
    Expect(1, 102, '\P{AHex=n}', "");
    Expect(0, 102, '\P{^AHex=n}', "");
    Expect(1, 103, '\p{AHex=:\An\z:}', "");;
    Expect(0, 102, '\p{AHex=:\An\z:}', "");;
    Expect(1, 103, '\p{AHex= _N}', "");
    Expect(0, 103, '\p{^AHex= _N}', "");
    Expect(0, 103, '\P{AHex= _N}', "");
    Expect(1, 103, '\P{^AHex= _N}', "");
    Expect(0, 102, '\p{AHex= _N}', "");
    Expect(1, 102, '\p{^AHex= _N}', "");
    Expect(1, 102, '\P{AHex= _N}', "");
    Expect(0, 102, '\P{^AHex= _N}', "");
    Error('\p{Is_ASCII_Hex_Digit=_f:=}');
    Error('\P{Is_ASCII_Hex_Digit=_f:=}');
    Expect(1, 103, '\p{Is_ASCII_Hex_Digit=f}', "");
    Expect(0, 103, '\p{^Is_ASCII_Hex_Digit=f}', "");
    Expect(0, 103, '\P{Is_ASCII_Hex_Digit=f}', "");
    Expect(1, 103, '\P{^Is_ASCII_Hex_Digit=f}', "");
    Expect(0, 102, '\p{Is_ASCII_Hex_Digit=f}', "");
    Expect(1, 102, '\p{^Is_ASCII_Hex_Digit=f}', "");
    Expect(1, 102, '\P{Is_ASCII_Hex_Digit=f}', "");
    Expect(0, 102, '\P{^Is_ASCII_Hex_Digit=f}', "");
    Expect(1, 103, '\p{Is_ASCII_Hex_Digit=	-F}', "");
    Expect(0, 103, '\p{^Is_ASCII_Hex_Digit=	-F}', "");
    Expect(0, 103, '\P{Is_ASCII_Hex_Digit=	-F}', "");
    Expect(1, 103, '\P{^Is_ASCII_Hex_Digit=	-F}', "");
    Expect(0, 102, '\p{Is_ASCII_Hex_Digit=	-F}', "");
    Expect(1, 102, '\p{^Is_ASCII_Hex_Digit=	-F}', "");
    Expect(1, 102, '\P{Is_ASCII_Hex_Digit=	-F}', "");
    Expect(0, 102, '\P{^Is_ASCII_Hex_Digit=	-F}', "");
    Error('\p{Is_AHex=		FALSE/a/}');
    Error('\P{Is_AHex=		FALSE/a/}');
    Expect(1, 103, '\p{Is_AHex=false}', "");
    Expect(0, 103, '\p{^Is_AHex=false}', "");
    Expect(0, 103, '\P{Is_AHex=false}', "");
    Expect(1, 103, '\P{^Is_AHex=false}', "");
    Expect(0, 102, '\p{Is_AHex=false}', "");
    Expect(1, 102, '\p{^Is_AHex=false}', "");
    Expect(1, 102, '\P{Is_AHex=false}', "");
    Expect(0, 102, '\P{^Is_AHex=false}', "");
    Expect(1, 103, '\p{Is_AHex=	_False}', "");
    Expect(0, 103, '\p{^Is_AHex=	_False}', "");
    Expect(0, 103, '\P{Is_AHex=	_False}', "");
    Expect(1, 103, '\P{^Is_AHex=	_False}', "");
    Expect(0, 102, '\p{Is_AHex=	_False}', "");
    Expect(1, 102, '\p{^Is_AHex=	_False}', "");
    Expect(1, 102, '\P{Is_AHex=	_False}', "");
    Expect(0, 102, '\P{^Is_AHex=	_False}', "");
    Error('\p{ASCII_Hex_Digit=	/a/Yes}');
    Error('\P{ASCII_Hex_Digit=	/a/Yes}');
    Expect(1, 102, '\p{ASCII_Hex_Digit=:\AYes\z:}', "");;
    Expect(0, 103, '\p{ASCII_Hex_Digit=:\AYes\z:}', "");;
    Expect(1, 102, '\p{ASCII_Hex_Digit=yes}', "");
    Expect(0, 102, '\p{^ASCII_Hex_Digit=yes}', "");
    Expect(0, 102, '\P{ASCII_Hex_Digit=yes}', "");
    Expect(1, 102, '\P{^ASCII_Hex_Digit=yes}', "");
    Expect(0, 103, '\p{ASCII_Hex_Digit=yes}', "");
    Expect(1, 103, '\p{^ASCII_Hex_Digit=yes}', "");
    Expect(1, 103, '\P{ASCII_Hex_Digit=yes}', "");
    Expect(0, 103, '\P{^ASCII_Hex_Digit=yes}', "");
    Expect(1, 102, '\p{ASCII_Hex_Digit=:\Ayes\z:}', "");;
    Expect(0, 103, '\p{ASCII_Hex_Digit=:\Ayes\z:}', "");;
    Expect(1, 102, '\p{ASCII_Hex_Digit= 	yes}', "");
    Expect(0, 102, '\p{^ASCII_Hex_Digit= 	yes}', "");
    Expect(0, 102, '\P{ASCII_Hex_Digit= 	yes}', "");
    Expect(1, 102, '\P{^ASCII_Hex_Digit= 	yes}', "");
    Expect(0, 103, '\p{ASCII_Hex_Digit= 	yes}', "");
    Expect(1, 103, '\p{^ASCII_Hex_Digit= 	yes}', "");
    Expect(1, 103, '\P{ASCII_Hex_Digit= 	yes}', "");
    Expect(0, 103, '\P{^ASCII_Hex_Digit= 	yes}', "");
    Error('\p{AHex=/a/  Y}');
    Error('\P{AHex=/a/  Y}');
    Expect(1, 102, '\p{AHex=:\AY\z:}', "");;
    Expect(0, 103, '\p{AHex=:\AY\z:}', "");;
    Expect(1, 102, '\p{AHex=y}', "");
    Expect(0, 102, '\p{^AHex=y}', "");
    Expect(0, 102, '\P{AHex=y}', "");
    Expect(1, 102, '\P{^AHex=y}', "");
    Expect(0, 103, '\p{AHex=y}', "");
    Expect(1, 103, '\p{^AHex=y}', "");
    Expect(1, 103, '\P{AHex=y}', "");
    Expect(0, 103, '\P{^AHex=y}', "");
    Expect(1, 102, '\p{AHex=:\Ay\z:}', "");;
    Expect(0, 103, '\p{AHex=:\Ay\z:}', "");;
    Expect(1, 102, '\p{AHex=_y}', "");
    Expect(0, 102, '\p{^AHex=_y}', "");
    Expect(0, 102, '\P{AHex=_y}', "");
    Expect(1, 102, '\P{^AHex=_y}', "");
    Expect(0, 103, '\p{AHex=_y}', "");
    Expect(1, 103, '\p{^AHex=_y}', "");
    Expect(1, 103, '\P{AHex=_y}', "");
    Expect(0, 103, '\P{^AHex=_y}', "");
    Error('\p{Is_ASCII_Hex_Digit=-/a/T}');
    Error('\P{Is_ASCII_Hex_Digit=-/a/T}');
    Expect(1, 102, '\p{Is_ASCII_Hex_Digit=t}', "");
    Expect(0, 102, '\p{^Is_ASCII_Hex_Digit=t}', "");
    Expect(0, 102, '\P{Is_ASCII_Hex_Digit=t}', "");
    Expect(1, 102, '\P{^Is_ASCII_Hex_Digit=t}', "");
    Expect(0, 103, '\p{Is_ASCII_Hex_Digit=t}', "");
    Expect(1, 103, '\p{^Is_ASCII_Hex_Digit=t}', "");
    Expect(1, 103, '\P{Is_ASCII_Hex_Digit=t}', "");
    Expect(0, 103, '\P{^Is_ASCII_Hex_Digit=t}', "");
    Expect(1, 102, '\p{Is_ASCII_Hex_Digit=	t}', "");
    Expect(0, 102, '\p{^Is_ASCII_Hex_Digit=	t}', "");
    Expect(0, 102, '\P{Is_ASCII_Hex_Digit=	t}', "");
    Expect(1, 102, '\P{^Is_ASCII_Hex_Digit=	t}', "");
    Expect(0, 103, '\p{Is_ASCII_Hex_Digit=	t}', "");
    Expect(1, 103, '\p{^Is_ASCII_Hex_Digit=	t}', "");
    Expect(1, 103, '\P{Is_ASCII_Hex_Digit=	t}', "");
    Expect(0, 103, '\P{^Is_ASCII_Hex_Digit=	t}', "");
    Error('\p{Is_AHex=/a/--True}');
    Error('\P{Is_AHex=/a/--True}');
    Expect(1, 102, '\p{Is_AHex=true}', "");
    Expect(0, 102, '\p{^Is_AHex=true}', "");
    Expect(0, 102, '\P{Is_AHex=true}', "");
    Expect(1, 102, '\P{^Is_AHex=true}', "");
    Expect(0, 103, '\p{Is_AHex=true}', "");
    Expect(1, 103, '\p{^Is_AHex=true}', "");
    Expect(1, 103, '\P{Is_AHex=true}', "");
    Expect(0, 103, '\P{^Is_AHex=true}', "");
    Expect(1, 102, '\p{Is_AHex=	_true}', "");
    Expect(0, 102, '\p{^Is_AHex=	_true}', "");
    Expect(0, 102, '\P{Is_AHex=	_true}', "");
    Expect(1, 102, '\P{^Is_AHex=	_true}', "");
    Expect(0, 103, '\p{Is_AHex=	_true}', "");
    Expect(1, 103, '\p{^Is_AHex=	_true}', "");
    Expect(1, 103, '\P{Is_AHex=	_true}', "");
    Expect(0, 103, '\P{^Is_AHex=	_true}', "");
    Error('\p{Alphabetic= No:=}');
    Error('\P{Alphabetic= No:=}');
    Expect(1, 201547, '\p{Alphabetic=:\ANo\z:}', "");;
    Expect(0, 201546, '\p{Alphabetic=:\ANo\z:}', "");;
    Expect(1, 201547, '\p{Alphabetic=no}', "");
    Expect(0, 201547, '\p{^Alphabetic=no}', "");
    Expect(0, 201547, '\P{Alphabetic=no}', "");
    Expect(1, 201547, '\P{^Alphabetic=no}', "");
    Expect(0, 201546, '\p{Alphabetic=no}', "");
    Expect(1, 201546, '\p{^Alphabetic=no}', "");
    Expect(1, 201546, '\P{Alphabetic=no}', "");
    Expect(0, 201546, '\P{^Alphabetic=no}', "");
    Expect(1, 201547, '\p{Alphabetic=:\Ano\z:}', "");;
    Expect(0, 201546, '\p{Alphabetic=:\Ano\z:}', "");;
    Expect(1, 201547, '\p{Alphabetic=-no}', "");
    Expect(0, 201547, '\p{^Alphabetic=-no}', "");
    Expect(0, 201547, '\P{Alphabetic=-no}', "");
    Expect(1, 201547, '\P{^Alphabetic=-no}', "");
    Expect(0, 201546, '\p{Alphabetic=-no}', "");
    Expect(1, 201546, '\p{^Alphabetic=-no}', "");
    Expect(1, 201546, '\P{Alphabetic=-no}', "");
    Expect(0, 201546, '\P{^Alphabetic=-no}', "");
    Error('\p{Alpha=	N:=}');
    Error('\P{Alpha=	N:=}');
    Expect(1, 201547, '\p{Alpha=:\AN\z:}', "");;
    Expect(0, 201546, '\p{Alpha=:\AN\z:}', "");;
    Expect(1, 201547, '\p{Alpha=n}', "");
    Expect(0, 201547, '\p{^Alpha=n}', "");
    Expect(0, 201547, '\P{Alpha=n}', "");
    Expect(1, 201547, '\P{^Alpha=n}', "");
    Expect(0, 201546, '\p{Alpha=n}', "");
    Expect(1, 201546, '\p{^Alpha=n}', "");
    Expect(1, 201546, '\P{Alpha=n}', "");
    Expect(0, 201546, '\P{^Alpha=n}', "");
    Expect(1, 201547, '\p{Alpha=:\An\z:}', "");;
    Expect(0, 201546, '\p{Alpha=:\An\z:}', "");;
    Expect(1, 201547, '\p{Alpha=-n}', "");
    Expect(0, 201547, '\p{^Alpha=-n}', "");
    Expect(0, 201547, '\P{Alpha=-n}', "");
    Expect(1, 201547, '\P{^Alpha=-n}', "");
    Expect(0, 201546, '\p{Alpha=-n}', "");
    Expect(1, 201546, '\p{^Alpha=-n}', "");
    Expect(1, 201546, '\P{Alpha=-n}', "");
    Expect(0, 201546, '\P{^Alpha=-n}', "");
    Error('\p{Is_Alphabetic=/a/F}');
    Error('\P{Is_Alphabetic=/a/F}');
    Expect(1, 201547, '\p{Is_Alphabetic=f}', "");
    Expect(0, 201547, '\p{^Is_Alphabetic=f}', "");
    Expect(0, 201547, '\P{Is_Alphabetic=f}', "");
    Expect(1, 201547, '\P{^Is_Alphabetic=f}', "");
    Expect(0, 201546, '\p{Is_Alphabetic=f}', "");
    Expect(1, 201546, '\p{^Is_Alphabetic=f}', "");
    Expect(1, 201546, '\P{Is_Alphabetic=f}', "");
    Expect(0, 201546, '\P{^Is_Alphabetic=f}', "");
    Expect(1, 201547, '\p{Is_Alphabetic=_	F}', "");
    Expect(0, 201547, '\p{^Is_Alphabetic=_	F}', "");
    Expect(0, 201547, '\P{Is_Alphabetic=_	F}', "");
    Expect(1, 201547, '\P{^Is_Alphabetic=_	F}', "");
    Expect(0, 201546, '\p{Is_Alphabetic=_	F}', "");
    Expect(1, 201546, '\p{^Is_Alphabetic=_	F}', "");
    Expect(1, 201546, '\P{Is_Alphabetic=_	F}', "");
    Expect(0, 201546, '\P{^Is_Alphabetic=_	F}', "");
    Error('\p{Is_Alpha=/a/_False}');
    Error('\P{Is_Alpha=/a/_False}');
    Expect(1, 201547, '\p{Is_Alpha=false}', "");
    Expect(0, 201547, '\p{^Is_Alpha=false}', "");
    Expect(0, 201547, '\P{Is_Alpha=false}', "");
    Expect(1, 201547, '\P{^Is_Alpha=false}', "");
    Expect(0, 201546, '\p{Is_Alpha=false}', "");
    Expect(1, 201546, '\p{^Is_Alpha=false}', "");
    Expect(1, 201546, '\P{Is_Alpha=false}', "");
    Expect(0, 201546, '\P{^Is_Alpha=false}', "");
    Expect(1, 201547, '\p{Is_Alpha=	FALSE}', "");
    Expect(0, 201547, '\p{^Is_Alpha=	FALSE}', "");
    Expect(0, 201547, '\P{Is_Alpha=	FALSE}', "");
    Expect(1, 201547, '\P{^Is_Alpha=	FALSE}', "");
    Expect(0, 201546, '\p{Is_Alpha=	FALSE}', "");
    Expect(1, 201546, '\p{^Is_Alpha=	FALSE}', "");
    Expect(1, 201546, '\P{Is_Alpha=	FALSE}', "");
    Expect(0, 201546, '\P{^Is_Alpha=	FALSE}', "");
    Error('\p{Alphabetic=/a/__Yes}');
    Error('\P{Alphabetic=/a/__Yes}');
    Expect(1, 201546, '\p{Alphabetic=:\AYes\z:}', "");;
    Expect(0, 201547, '\p{Alphabetic=:\AYes\z:}', "");;
    Expect(1, 201546, '\p{Alphabetic=yes}', "");
    Expect(0, 201546, '\p{^Alphabetic=yes}', "");
    Expect(0, 201546, '\P{Alphabetic=yes}', "");
    Expect(1, 201546, '\P{^Alphabetic=yes}', "");
    Expect(0, 201547, '\p{Alphabetic=yes}', "");
    Expect(1, 201547, '\p{^Alphabetic=yes}', "");
    Expect(1, 201547, '\P{Alphabetic=yes}', "");
    Expect(0, 201547, '\P{^Alphabetic=yes}', "");
    Expect(1, 201546, '\p{Alphabetic=:\Ayes\z:}', "");;
    Expect(0, 201547, '\p{Alphabetic=:\Ayes\z:}', "");;
    Expect(1, 201546, '\p{Alphabetic= -Yes}', "");
    Expect(0, 201546, '\p{^Alphabetic= -Yes}', "");
    Expect(0, 201546, '\P{Alphabetic= -Yes}', "");
    Expect(1, 201546, '\P{^Alphabetic= -Yes}', "");
    Expect(0, 201547, '\p{Alphabetic= -Yes}', "");
    Expect(1, 201547, '\p{^Alphabetic= -Yes}', "");
    Expect(1, 201547, '\P{Alphabetic= -Yes}', "");
    Expect(0, 201547, '\P{^Alphabetic= -Yes}', "");
    Error('\p{Alpha=	/a/Y}');
    Error('\P{Alpha=	/a/Y}');
    Expect(1, 201546, '\p{Alpha=:\AY\z:}', "");;
    Expect(0, 201547, '\p{Alpha=:\AY\z:}', "");;
    Expect(1, 201546, '\p{Alpha:   y}', "");
    Expect(0, 201546, '\p{^Alpha:   y}', "");
    Expect(0, 201546, '\P{Alpha:   y}', "");
    Expect(1, 201546, '\P{^Alpha:   y}', "");
    Expect(0, 201547, '\p{Alpha:   y}', "");
    Expect(1, 201547, '\p{^Alpha:   y}', "");
    Expect(1, 201547, '\P{Alpha:   y}', "");
    Expect(0, 201547, '\P{^Alpha:   y}', "");
    Expect(1, 201546, '\p{Alpha=:\Ay\z:}', "");;
    Expect(0, 201547, '\p{Alpha=:\Ay\z:}', "");;
    Expect(1, 201546, '\p{Alpha: 		Y}', "");
    Expect(0, 201546, '\p{^Alpha: 		Y}', "");
    Expect(0, 201546, '\P{Alpha: 		Y}', "");
    Expect(1, 201546, '\P{^Alpha: 		Y}', "");
    Expect(0, 201547, '\p{Alpha: 		Y}', "");
    Expect(1, 201547, '\p{^Alpha: 		Y}', "");
    Expect(1, 201547, '\P{Alpha: 		Y}', "");
    Expect(0, 201547, '\P{^Alpha: 		Y}', "");
    Error('\p{Is_Alphabetic=/a/-	T}');
    Error('\P{Is_Alphabetic=/a/-	T}');
    Expect(1, 201546, '\p{Is_Alphabetic: t}', "");
    Expect(0, 201546, '\p{^Is_Alphabetic: t}', "");
    Expect(0, 201546, '\P{Is_Alphabetic: t}', "");
    Expect(1, 201546, '\P{^Is_Alphabetic: t}', "");
    Expect(0, 201547, '\p{Is_Alphabetic: t}', "");
    Expect(1, 201547, '\p{^Is_Alphabetic: t}', "");
    Expect(1, 201547, '\P{Is_Alphabetic: t}', "");
    Expect(0, 201547, '\P{^Is_Alphabetic: t}', "");
    Expect(1, 201546, '\p{Is_Alphabetic: --T}', "");
    Expect(0, 201546, '\p{^Is_Alphabetic: --T}', "");
    Expect(0, 201546, '\P{Is_Alphabetic: --T}', "");
    Expect(1, 201546, '\P{^Is_Alphabetic: --T}', "");
    Expect(0, 201547, '\p{Is_Alphabetic: --T}', "");
    Expect(1, 201547, '\p{^Is_Alphabetic: --T}', "");
    Expect(1, 201547, '\P{Is_Alphabetic: --T}', "");
    Expect(0, 201547, '\P{^Is_Alphabetic: --T}', "");
    Error('\p{Is_Alpha=--True/a/}');
    Error('\P{Is_Alpha=--True/a/}');
    Expect(1, 201546, '\p{Is_Alpha=true}', "");
    Expect(0, 201546, '\p{^Is_Alpha=true}', "");
    Expect(0, 201546, '\P{Is_Alpha=true}', "");
    Expect(1, 201546, '\P{^Is_Alpha=true}', "");
    Expect(0, 201547, '\p{Is_Alpha=true}', "");
    Expect(1, 201547, '\p{^Is_Alpha=true}', "");
    Expect(1, 201547, '\P{Is_Alpha=true}', "");
    Expect(0, 201547, '\P{^Is_Alpha=true}', "");
    Expect(1, 201546, '\p{Is_Alpha=		True}', "");
    Expect(0, 201546, '\p{^Is_Alpha=		True}', "");
    Expect(0, 201546, '\P{Is_Alpha=		True}', "");
    Expect(1, 201546, '\P{^Is_Alpha=		True}', "");
    Expect(0, 201547, '\p{Is_Alpha=		True}', "");
    Expect(1, 201547, '\p{^Is_Alpha=		True}', "");
    Expect(1, 201547, '\P{Is_Alpha=		True}', "");
    Expect(0, 201547, '\P{^Is_Alpha=		True}', "");
    Error('\p{bidiclass}');
    Error('\P{bidiclass}');
    Error('\p{bc}');
    Error('\P{bc}');
    Error('\p{Bidi_Class=	Arabic_LETTER/a/}');
    Error('\P{Bidi_Class=	Arabic_LETTER/a/}');
    Expect(1, 126719, '\p{Bidi_Class=:\AArabic_Letter\z:}', "");;
    Expect(0, 126720, '\p{Bidi_Class=:\AArabic_Letter\z:}', "");;
    Expect(1, 126719, '\p{Bidi_Class=arabicletter}', "");
    Expect(0, 126719, '\p{^Bidi_Class=arabicletter}', "");
    Expect(0, 126719, '\P{Bidi_Class=arabicletter}', "");
    Expect(1, 126719, '\P{^Bidi_Class=arabicletter}', "");
    Expect(0, 126720, '\p{Bidi_Class=arabicletter}', "");
    Expect(1, 126720, '\p{^Bidi_Class=arabicletter}', "");
    Expect(1, 126720, '\P{Bidi_Class=arabicletter}', "");
    Expect(0, 126720, '\P{^Bidi_Class=arabicletter}', "");
    Expect(1, 126719, '\p{Bidi_Class=:\Aarabicletter\z:}', "");;
    Expect(0, 126720, '\p{Bidi_Class=:\Aarabicletter\z:}', "");;
    Expect(1, 126719, '\p{Bidi_Class=-	Arabic_Letter}', "");
    Expect(0, 126719, '\p{^Bidi_Class=-	Arabic_Letter}', "");
    Expect(0, 126719, '\P{Bidi_Class=-	Arabic_Letter}', "");
    Expect(1, 126719, '\P{^Bidi_Class=-	Arabic_Letter}', "");
    Expect(0, 126720, '\p{Bidi_Class=-	Arabic_Letter}', "");
    Expect(1, 126720, '\p{^Bidi_Class=-	Arabic_Letter}', "");
    Expect(1, 126720, '\P{Bidi_Class=-	Arabic_Letter}', "");
    Expect(0, 126720, '\P{^Bidi_Class=-	Arabic_Letter}', "");
    Error('\p{Bc=_/a/AL}');
    Error('\P{Bc=_/a/AL}');
    Expect(1, 126719, '\p{Bc=:\AAL\z:}', "");;
    Expect(0, 126720, '\p{Bc=:\AAL\z:}', "");;
    Expect(1, 126719, '\p{Bc=al}', "");
    Expect(0, 126719, '\p{^Bc=al}', "");
    Expect(0, 126719, '\P{Bc=al}', "");
    Expect(1, 126719, '\P{^Bc=al}', "");
    Expect(0, 126720, '\p{Bc=al}', "");
    Expect(1, 126720, '\p{^Bc=al}', "");
    Expect(1, 126720, '\P{Bc=al}', "");
    Expect(0, 126720, '\P{^Bc=al}', "");
    Expect(1, 126719, '\p{Bc=:\Aal\z:}', "");;
    Expect(0, 126720, '\p{Bc=:\Aal\z:}', "");;
    Expect(1, 126719, '\p{Bc= 	al}', "");
    Expect(0, 126719, '\p{^Bc= 	al}', "");
    Expect(0, 126719, '\P{Bc= 	al}', "");
    Expect(1, 126719, '\P{^Bc= 	al}', "");
    Expect(0, 126720, '\p{Bc= 	al}', "");
    Expect(1, 126720, '\p{^Bc= 	al}', "");
    Expect(1, 126720, '\P{Bc= 	al}', "");
    Expect(0, 126720, '\P{^Bc= 	al}', "");
    Error('\p{Is_Bidi_Class=:=  ARABIC_letter}');
    Error('\P{Is_Bidi_Class=:=  ARABIC_letter}');
    Expect(1, 126719, '\p{Is_Bidi_Class=arabicletter}', "");
    Expect(0, 126719, '\p{^Is_Bidi_Class=arabicletter}', "");
    Expect(0, 126719, '\P{Is_Bidi_Class=arabicletter}', "");
    Expect(1, 126719, '\P{^Is_Bidi_Class=arabicletter}', "");
    Expect(0, 126720, '\p{Is_Bidi_Class=arabicletter}', "");
    Expect(1, 126720, '\p{^Is_Bidi_Class=arabicletter}', "");
    Expect(1, 126720, '\P{Is_Bidi_Class=arabicletter}', "");
    Expect(0, 126720, '\P{^Is_Bidi_Class=arabicletter}', "");
    Expect(1, 126719, '\p{Is_Bidi_Class=- Arabic_Letter}', "");
    Expect(0, 126719, '\p{^Is_Bidi_Class=- Arabic_Letter}', "");
    Expect(0, 126719, '\P{Is_Bidi_Class=- Arabic_Letter}', "");
    Expect(1, 126719, '\P{^Is_Bidi_Class=- Arabic_Letter}', "");
    Expect(0, 126720, '\p{Is_Bidi_Class=- Arabic_Letter}', "");
    Expect(1, 126720, '\p{^Is_Bidi_Class=- Arabic_Letter}', "");
    Expect(1, 126720, '\P{Is_Bidi_Class=- Arabic_Letter}', "");
    Expect(0, 126720, '\P{^Is_Bidi_Class=- Arabic_Letter}', "");
    Error('\p{Is_Bc=	 AL/a/}');
    Error('\P{Is_Bc=	 AL/a/}');
    Expect(1, 126719, '\p{Is_Bc: al}', "");
    Expect(0, 126719, '\p{^Is_Bc: al}', "");
    Expect(0, 126719, '\P{Is_Bc: al}', "");
    Expect(1, 126719, '\P{^Is_Bc: al}', "");
    Expect(0, 126720, '\p{Is_Bc: al}', "");
    Expect(1, 126720, '\p{^Is_Bc: al}', "");
    Expect(1, 126720, '\P{Is_Bc: al}', "");
    Expect(0, 126720, '\P{^Is_Bc: al}', "");
    Expect(1, 126719, '\p{Is_Bc= _AL}', "");
    Expect(0, 126719, '\p{^Is_Bc= _AL}', "");
    Expect(0, 126719, '\P{Is_Bc= _AL}', "");
    Expect(1, 126719, '\P{^Is_Bc= _AL}', "");
    Expect(0, 126720, '\p{Is_Bc= _AL}', "");
    Expect(1, 126720, '\p{^Is_Bc= _AL}', "");
    Expect(1, 126720, '\P{Is_Bc= _AL}', "");
    Expect(0, 126720, '\P{^Is_Bc= _AL}', "");
    Error('\p{Bidi_Class= -Arabic_Number:=}');
    Error('\P{Bidi_Class= -Arabic_Number:=}');
    Expect(1, 69246, '\p{Bidi_Class=:\AArabic_Number\z:}', "");;
    Expect(0, 69247, '\p{Bidi_Class=:\AArabic_Number\z:}', "");;
    Expect(1, 69246, '\p{Bidi_Class=arabicnumber}', "");
    Expect(0, 69246, '\p{^Bidi_Class=arabicnumber}', "");
    Expect(0, 69246, '\P{Bidi_Class=arabicnumber}', "");
    Expect(1, 69246, '\P{^Bidi_Class=arabicnumber}', "");
    Expect(0, 69247, '\p{Bidi_Class=arabicnumber}', "");
    Expect(1, 69247, '\p{^Bidi_Class=arabicnumber}', "");
    Expect(1, 69247, '\P{Bidi_Class=arabicnumber}', "");
    Expect(0, 69247, '\P{^Bidi_Class=arabicnumber}', "");
    Expect(1, 69246, '\p{Bidi_Class=:\Aarabicnumber\z:}', "");;
    Expect(0, 69247, '\p{Bidi_Class=:\Aarabicnumber\z:}', "");;
    Expect(1, 69246, '\p{Bidi_Class= _Arabic_Number}', "");
    Expect(0, 69246, '\p{^Bidi_Class= _Arabic_Number}', "");
    Expect(0, 69246, '\P{Bidi_Class= _Arabic_Number}', "");
    Expect(1, 69246, '\P{^Bidi_Class= _Arabic_Number}', "");
    Expect(0, 69247, '\p{Bidi_Class= _Arabic_Number}', "");
    Expect(1, 69247, '\p{^Bidi_Class= _Arabic_Number}', "");
    Expect(1, 69247, '\P{Bidi_Class= _Arabic_Number}', "");
    Expect(0, 69247, '\P{^Bidi_Class= _Arabic_Number}', "");
    Error('\p{Bc=:=-_AN}');
    Error('\P{Bc=:=-_AN}');
    Expect(1, 69246, '\p{Bc=:\AAN\z:}', "");;
    Expect(0, 69247, '\p{Bc=:\AAN\z:}', "");;
    Expect(1, 69246, '\p{Bc=an}', "");
    Expect(0, 69246, '\p{^Bc=an}', "");
    Expect(0, 69246, '\P{Bc=an}', "");
    Expect(1, 69246, '\P{^Bc=an}', "");
    Expect(0, 69247, '\p{Bc=an}', "");
    Expect(1, 69247, '\p{^Bc=an}', "");
    Expect(1, 69247, '\P{Bc=an}', "");
    Expect(0, 69247, '\P{^Bc=an}', "");
    Expect(1, 69246, '\p{Bc=:\Aan\z:}', "");;
    Expect(0, 69247, '\p{Bc=:\Aan\z:}', "");;
    Expect(1, 69246, '\p{Bc=_an}', "");
    Expect(0, 69246, '\p{^Bc=_an}', "");
    Expect(0, 69246, '\P{Bc=_an}', "");
    Expect(1, 69246, '\P{^Bc=_an}', "");
    Expect(0, 69247, '\p{Bc=_an}', "");
    Expect(1, 69247, '\p{^Bc=_an}', "");
    Expect(1, 69247, '\P{Bc=_an}', "");
    Expect(0, 69247, '\P{^Bc=_an}', "");
    Error('\p{Is_Bidi_Class=	-arabic_NUMBER:=}');
    Error('\P{Is_Bidi_Class=	-arabic_NUMBER:=}');
    Expect(1, 69246, '\p{Is_Bidi_Class=arabicnumber}', "");
    Expect(0, 69246, '\p{^Is_Bidi_Class=arabicnumber}', "");
    Expect(0, 69246, '\P{Is_Bidi_Class=arabicnumber}', "");
    Expect(1, 69246, '\P{^Is_Bidi_Class=arabicnumber}', "");
    Expect(0, 69247, '\p{Is_Bidi_Class=arabicnumber}', "");
    Expect(1, 69247, '\p{^Is_Bidi_Class=arabicnumber}', "");
    Expect(1, 69247, '\P{Is_Bidi_Class=arabicnumber}', "");
    Expect(0, 69247, '\P{^Is_Bidi_Class=arabicnumber}', "");
    Expect(1, 69246, '\p{Is_Bidi_Class=arabic_Number}', "");
    Expect(0, 69246, '\p{^Is_Bidi_Class=arabic_Number}', "");
    Expect(0, 69246, '\P{Is_Bidi_Class=arabic_Number}', "");
    Expect(1, 69246, '\P{^Is_Bidi_Class=arabic_Number}', "");
    Expect(0, 69247, '\p{Is_Bidi_Class=arabic_Number}', "");
    Expect(1, 69247, '\p{^Is_Bidi_Class=arabic_Number}', "");
    Expect(1, 69247, '\P{Is_Bidi_Class=arabic_Number}', "");
    Expect(0, 69247, '\P{^Is_Bidi_Class=arabic_Number}', "");
    Error('\p{Is_Bc=_an/a/}');
    Error('\P{Is_Bc=_an/a/}');
    Expect(1, 69246, '\p{Is_Bc=an}', "");
    Expect(0, 69246, '\p{^Is_Bc=an}', "");
    Expect(0, 69246, '\P{Is_Bc=an}', "");
    Expect(1, 69246, '\P{^Is_Bc=an}', "");
    Expect(0, 69247, '\p{Is_Bc=an}', "");
    Expect(1, 69247, '\p{^Is_Bc=an}', "");
    Expect(1, 69247, '\P{Is_Bc=an}', "");
    Expect(0, 69247, '\P{^Is_Bc=an}', "");
    Expect(1, 69246, '\p{Is_Bc= _AN}', "");
    Expect(0, 69246, '\p{^Is_Bc= _AN}', "");
    Expect(0, 69246, '\P{Is_Bc= _AN}', "");
    Expect(1, 69246, '\P{^Is_Bc= _AN}', "");
    Expect(0, 69247, '\p{Is_Bc= _AN}', "");
    Expect(1, 69247, '\p{^Is_Bc= _AN}', "");
    Expect(1, 69247, '\P{Is_Bc= _AN}', "");
    Expect(0, 69247, '\P{^Is_Bc= _AN}', "");
    Error('\p{Bidi_Class=	 Paragraph_SEPARATOR/a/}');
    Error('\P{Bidi_Class=	 Paragraph_SEPARATOR/a/}');
    Expect(1, 8233, '\p{Bidi_Class=:\AParagraph_Separator\z:}', "");;
    Expect(0, 8234, '\p{Bidi_Class=:\AParagraph_Separator\z:}', "");;
    Expect(1, 8233, '\p{Bidi_Class=paragraphseparator}', "");
    Expect(0, 8233, '\p{^Bidi_Class=paragraphseparator}', "");
    Expect(0, 8233, '\P{Bidi_Class=paragraphseparator}', "");
    Expect(1, 8233, '\P{^Bidi_Class=paragraphseparator}', "");
    Expect(0, 8234, '\p{Bidi_Class=paragraphseparator}', "");
    Expect(1, 8234, '\p{^Bidi_Class=paragraphseparator}', "");
    Expect(1, 8234, '\P{Bidi_Class=paragraphseparator}', "");
    Expect(0, 8234, '\P{^Bidi_Class=paragraphseparator}', "");
    Expect(1, 8233, '\p{Bidi_Class=:\Aparagraphseparator\z:}', "");;
    Expect(0, 8234, '\p{Bidi_Class=:\Aparagraphseparator\z:}', "");;
    Expect(1, 8233, '\p{Bidi_Class=_Paragraph_Separator}', "");
    Expect(0, 8233, '\p{^Bidi_Class=_Paragraph_Separator}', "");
    Expect(0, 8233, '\P{Bidi_Class=_Paragraph_Separator}', "");
    Expect(1, 8233, '\P{^Bidi_Class=_Paragraph_Separator}', "");
    Expect(0, 8234, '\p{Bidi_Class=_Paragraph_Separator}', "");
    Expect(1, 8234, '\p{^Bidi_Class=_Paragraph_Separator}', "");
    Expect(1, 8234, '\P{Bidi_Class=_Paragraph_Separator}', "");
    Expect(0, 8234, '\P{^Bidi_Class=_Paragraph_Separator}', "");
    Error('\p{Bc: B:=}');
    Error('\P{Bc: B:=}');
    Expect(1, 8233, '\p{Bc=:\AB\z:}', "");;
    Expect(0, 8234, '\p{Bc=:\AB\z:}', "");;
    Expect(1, 8233, '\p{Bc=b}', "");
    Expect(0, 8233, '\p{^Bc=b}', "");
    Expect(0, 8233, '\P{Bc=b}', "");
    Expect(1, 8233, '\P{^Bc=b}', "");
    Expect(0, 8234, '\p{Bc=b}', "");
    Expect(1, 8234, '\p{^Bc=b}', "");
    Expect(1, 8234, '\P{Bc=b}', "");
    Expect(0, 8234, '\P{^Bc=b}', "");
    Expect(1, 8233, '\p{Bc=:\Ab\z:}', "");;
    Expect(0, 8234, '\p{Bc=:\Ab\z:}', "");;
    Expect(1, 8233, '\p{Bc=-b}', "");
    Expect(0, 8233, '\p{^Bc=-b}', "");
    Expect(0, 8233, '\P{Bc=-b}', "");
    Expect(1, 8233, '\P{^Bc=-b}', "");
    Expect(0, 8234, '\p{Bc=-b}', "");
    Expect(1, 8234, '\p{^Bc=-b}', "");
    Expect(1, 8234, '\P{Bc=-b}', "");
    Expect(0, 8234, '\P{^Bc=-b}', "");
    Error('\p{Is_Bidi_Class=:=-PARAGRAPH_Separator}');
    Error('\P{Is_Bidi_Class=:=-PARAGRAPH_Separator}');
    Expect(1, 8233, '\p{Is_Bidi_Class=paragraphseparator}', "");
    Expect(0, 8233, '\p{^Is_Bidi_Class=paragraphseparator}', "");
    Expect(0, 8233, '\P{Is_Bidi_Class=paragraphseparator}', "");
    Expect(1, 8233, '\P{^Is_Bidi_Class=paragraphseparator}', "");
    Expect(0, 8234, '\p{Is_Bidi_Class=paragraphseparator}', "");
    Expect(1, 8234, '\p{^Is_Bidi_Class=paragraphseparator}', "");
    Expect(1, 8234, '\P{Is_Bidi_Class=paragraphseparator}', "");
    Expect(0, 8234, '\P{^Is_Bidi_Class=paragraphseparator}', "");
    Expect(1, 8233, '\p{Is_Bidi_Class=_Paragraph_Separator}', "");
    Expect(0, 8233, '\p{^Is_Bidi_Class=_Paragraph_Separator}', "");
    Expect(0, 8233, '\P{Is_Bidi_Class=_Paragraph_Separator}', "");
    Expect(1, 8233, '\P{^Is_Bidi_Class=_Paragraph_Separator}', "");
    Expect(0, 8234, '\p{Is_Bidi_Class=_Paragraph_Separator}', "");
    Expect(1, 8234, '\p{^Is_Bidi_Class=_Paragraph_Separator}', "");
    Expect(1, 8234, '\P{Is_Bidi_Class=_Paragraph_Separator}', "");
    Expect(0, 8234, '\P{^Is_Bidi_Class=_Paragraph_Separator}', "");
    Error('\p{Is_Bc=/a/--b}');
    Error('\P{Is_Bc=/a/--b}');
    Expect(1, 8233, '\p{Is_Bc=b}', "");
    Expect(0, 8233, '\p{^Is_Bc=b}', "");
    Expect(0, 8233, '\P{Is_Bc=b}', "");
    Expect(1, 8233, '\P{^Is_Bc=b}', "");
    Expect(0, 8234, '\p{Is_Bc=b}', "");
    Expect(1, 8234, '\p{^Is_Bc=b}', "");
    Expect(1, 8234, '\P{Is_Bc=b}', "");
    Expect(0, 8234, '\P{^Is_Bc=b}', "");
    Expect(1, 8233, '\p{Is_Bc=-b}', "");
    Expect(0, 8233, '\p{^Is_Bc=-b}', "");
    Expect(0, 8233, '\P{Is_Bc=-b}', "");
    Expect(1, 8233, '\P{^Is_Bc=-b}', "");
    Expect(0, 8234, '\p{Is_Bc=-b}', "");
    Expect(1, 8234, '\p{^Is_Bc=-b}', "");
    Expect(1, 8234, '\P{Is_Bc=-b}', "");
    Expect(0, 8234, '\P{^Is_Bc=-b}', "");
    Error('\p{Bidi_Class=	:=Boundary_Neutral}');
    Error('\P{Bidi_Class=	:=Boundary_Neutral}');
    Expect(1, 921599, '\p{Bidi_Class=:\ABoundary_Neutral\z:}', "");;
    Expect(0, 1114109, '\p{Bidi_Class=:\ABoundary_Neutral\z:}', "");;
    Expect(1, 921599, '\p{Bidi_Class=boundaryneutral}', "");
    Expect(0, 921599, '\p{^Bidi_Class=boundaryneutral}', "");
    Expect(0, 921599, '\P{Bidi_Class=boundaryneutral}', "");
    Expect(1, 921599, '\P{^Bidi_Class=boundaryneutral}', "");
    Expect(0, 1114109, '\p{Bidi_Class=boundaryneutral}', "");
    Expect(1, 1114109, '\p{^Bidi_Class=boundaryneutral}', "");
    Expect(1, 1114109, '\P{Bidi_Class=boundaryneutral}', "");
    Expect(0, 1114109, '\P{^Bidi_Class=boundaryneutral}', "");
    Expect(1, 921599, '\p{Bidi_Class=:\Aboundaryneutral\z:}', "");;
    Expect(0, 1114109, '\p{Bidi_Class=:\Aboundaryneutral\z:}', "");;
    Expect(1, 921599, '\p{Bidi_Class=	 Boundary_neutral}', "");
    Expect(0, 921599, '\p{^Bidi_Class=	 Boundary_neutral}', "");
    Expect(0, 921599, '\P{Bidi_Class=	 Boundary_neutral}', "");
    Expect(1, 921599, '\P{^Bidi_Class=	 Boundary_neutral}', "");
    Expect(0, 1114109, '\p{Bidi_Class=	 Boundary_neutral}', "");
    Expect(1, 1114109, '\p{^Bidi_Class=	 Boundary_neutral}', "");
    Expect(1, 1114109, '\P{Bidi_Class=	 Boundary_neutral}', "");
    Expect(0, 1114109, '\P{^Bidi_Class=	 Boundary_neutral}', "");
    Error('\p{Bc=_/a/BN}');
    Error('\P{Bc=_/a/BN}');
    Expect(1, 921599, '\p{Bc=:\ABN\z:}', "");;
    Expect(0, 1114109, '\p{Bc=:\ABN\z:}', "");;
    Expect(1, 921599, '\p{Bc=bn}', "");
    Expect(0, 921599, '\p{^Bc=bn}', "");
    Expect(0, 921599, '\P{Bc=bn}', "");
    Expect(1, 921599, '\P{^Bc=bn}', "");
    Expect(0, 1114109, '\p{Bc=bn}', "");
    Expect(1, 1114109, '\p{^Bc=bn}', "");
    Expect(1, 1114109, '\P{Bc=bn}', "");
    Expect(0, 1114109, '\P{^Bc=bn}', "");
    Expect(1, 921599, '\p{Bc=:\Abn\z:}', "");;
    Expect(0, 1114109, '\p{Bc=:\Abn\z:}', "");;
    Expect(1, 921599, '\p{Bc=		BN}', "");
    Expect(0, 921599, '\p{^Bc=		BN}', "");
    Expect(0, 921599, '\P{Bc=		BN}', "");
    Expect(1, 921599, '\P{^Bc=		BN}', "");
    Expect(0, 1114109, '\p{Bc=		BN}', "");
    Expect(1, 1114109, '\p{^Bc=		BN}', "");
    Expect(1, 1114109, '\P{Bc=		BN}', "");
    Expect(0, 1114109, '\P{^Bc=		BN}', "");
    Error('\p{Is_Bidi_Class=/a/	boundary_Neutral}');
    Error('\P{Is_Bidi_Class=/a/	boundary_Neutral}');
    Expect(1, 921599, '\p{Is_Bidi_Class:   boundaryneutral}', "");
    Expect(0, 921599, '\p{^Is_Bidi_Class:   boundaryneutral}', "");
    Expect(0, 921599, '\P{Is_Bidi_Class:   boundaryneutral}', "");
    Expect(1, 921599, '\P{^Is_Bidi_Class:   boundaryneutral}', "");
    Expect(0, 1114109, '\p{Is_Bidi_Class:   boundaryneutral}', "");
    Expect(1, 1114109, '\p{^Is_Bidi_Class:   boundaryneutral}', "");
    Expect(1, 1114109, '\P{Is_Bidi_Class:   boundaryneutral}', "");
    Expect(0, 1114109, '\P{^Is_Bidi_Class:   boundaryneutral}', "");
    Expect(1, 921599, '\p{Is_Bidi_Class=	Boundary_Neutral}', "");
    Expect(0, 921599, '\p{^Is_Bidi_Class=	Boundary_Neutral}', "");
    Expect(0, 921599, '\P{Is_Bidi_Class=	Boundary_Neutral}', "");
    Expect(1, 921599, '\P{^Is_Bidi_Class=	Boundary_Neutral}', "");
    Expect(0, 1114109, '\p{Is_Bidi_Class=	Boundary_Neutral}', "");
    Expect(1, 1114109, '\p{^Is_Bidi_Class=	Boundary_Neutral}', "");
    Expect(1, 1114109, '\P{Is_Bidi_Class=	Boundary_Neutral}', "");
    Expect(0, 1114109, '\P{^Is_Bidi_Class=	Boundary_Neutral}', "");
    Error('\p{Is_Bc=-BN:=}');
    Error('\P{Is_Bc=-BN:=}');
    Expect(1, 921599, '\p{Is_Bc=bn}', "");
    Expect(0, 921599, '\p{^Is_Bc=bn}', "");
    Expect(0, 921599, '\P{Is_Bc=bn}', "");
    Expect(1, 921599, '\P{^Is_Bc=bn}', "");
    Expect(0, 1114109, '\p{Is_Bc=bn}', "");
    Expect(1, 1114109, '\p{^Is_Bc=bn}', "");
    Expect(1, 1114109, '\P{Is_Bc=bn}', "");
    Expect(0, 1114109, '\P{^Is_Bc=bn}', "");
    Expect(1, 921599, '\p{Is_Bc= bn}', "");
    Expect(0, 921599, '\p{^Is_Bc= bn}', "");
    Expect(0, 921599, '\P{Is_Bc= bn}', "");
    Expect(1, 921599, '\P{^Is_Bc= bn}', "");
    Expect(0, 1114109, '\p{Is_Bc= bn}', "");
    Expect(1, 1114109, '\p{^Is_Bc= bn}', "");
    Expect(1, 1114109, '\P{Is_Bc= bn}', "");
    Expect(0, 1114109, '\P{^Is_Bc= bn}', "");
    Error('\p{Bidi_Class=-/a/Common_separator}');
    Error('\P{Bidi_Class=-/a/Common_separator}');
    Expect(1, 65306, '\p{Bidi_Class=:\ACommon_Separator\z:}', "");;
    Expect(0, 65307, '\p{Bidi_Class=:\ACommon_Separator\z:}', "");;
    Expect(1, 65306, '\p{Bidi_Class=commonseparator}', "");
    Expect(0, 65306, '\p{^Bidi_Class=commonseparator}', "");
    Expect(0, 65306, '\P{Bidi_Class=commonseparator}', "");
    Expect(1, 65306, '\P{^Bidi_Class=commonseparator}', "");
    Expect(0, 65307, '\p{Bidi_Class=commonseparator}', "");
    Expect(1, 65307, '\p{^Bidi_Class=commonseparator}', "");
    Expect(1, 65307, '\P{Bidi_Class=commonseparator}', "");
    Expect(0, 65307, '\P{^Bidi_Class=commonseparator}', "");
    Expect(1, 65306, '\p{Bidi_Class=:\Acommonseparator\z:}', "");;
    Expect(0, 65307, '\p{Bidi_Class=:\Acommonseparator\z:}', "");;
    Expect(1, 65306, '\p{Bidi_Class=__common_Separator}', "");
    Expect(0, 65306, '\p{^Bidi_Class=__common_Separator}', "");
    Expect(0, 65306, '\P{Bidi_Class=__common_Separator}', "");
    Expect(1, 65306, '\P{^Bidi_Class=__common_Separator}', "");
    Expect(0, 65307, '\p{Bidi_Class=__common_Separator}', "");
    Expect(1, 65307, '\p{^Bidi_Class=__common_Separator}', "");
    Expect(1, 65307, '\P{Bidi_Class=__common_Separator}', "");
    Expect(0, 65307, '\P{^Bidi_Class=__common_Separator}', "");
    Error('\p{Bc=/a/cs}');
    Error('\P{Bc=/a/cs}');
    Expect(1, 65306, '\p{Bc=:\ACS\z:}', "");;
    Expect(0, 65307, '\p{Bc=:\ACS\z:}', "");;
    Expect(1, 65306, '\p{Bc=cs}', "");
    Expect(0, 65306, '\p{^Bc=cs}', "");
    Expect(0, 65306, '\P{Bc=cs}', "");
    Expect(1, 65306, '\P{^Bc=cs}', "");
    Expect(0, 65307, '\p{Bc=cs}', "");
    Expect(1, 65307, '\p{^Bc=cs}', "");
    Expect(1, 65307, '\P{Bc=cs}', "");
    Expect(0, 65307, '\P{^Bc=cs}', "");
    Expect(1, 65306, '\p{Bc=:\Acs\z:}', "");;
    Expect(0, 65307, '\p{Bc=:\Acs\z:}', "");;
    Expect(1, 65306, '\p{Bc=_ CS}', "");
    Expect(0, 65306, '\p{^Bc=_ CS}', "");
    Expect(0, 65306, '\P{Bc=_ CS}', "");
    Expect(1, 65306, '\P{^Bc=_ CS}', "");
    Expect(0, 65307, '\p{Bc=_ CS}', "");
    Expect(1, 65307, '\p{^Bc=_ CS}', "");
    Expect(1, 65307, '\P{Bc=_ CS}', "");
    Expect(0, 65307, '\P{^Bc=_ CS}', "");
    Error('\p{Is_Bidi_Class=_COMMON_Separator/a/}');
    Error('\P{Is_Bidi_Class=_COMMON_Separator/a/}');
    Expect(1, 65306, '\p{Is_Bidi_Class=commonseparator}', "");
    Expect(0, 65306, '\p{^Is_Bidi_Class=commonseparator}', "");
    Expect(0, 65306, '\P{Is_Bidi_Class=commonseparator}', "");
    Expect(1, 65306, '\P{^Is_Bidi_Class=commonseparator}', "");
    Expect(0, 65307, '\p{Is_Bidi_Class=commonseparator}', "");
    Expect(1, 65307, '\p{^Is_Bidi_Class=commonseparator}', "");
    Expect(1, 65307, '\P{Is_Bidi_Class=commonseparator}', "");
    Expect(0, 65307, '\P{^Is_Bidi_Class=commonseparator}', "");
    Expect(1, 65306, '\p{Is_Bidi_Class=-	common_Separator}', "");
    Expect(0, 65306, '\p{^Is_Bidi_Class=-	common_Separator}', "");
    Expect(0, 65306, '\P{Is_Bidi_Class=-	common_Separator}', "");
    Expect(1, 65306, '\P{^Is_Bidi_Class=-	common_Separator}', "");
    Expect(0, 65307, '\p{Is_Bidi_Class=-	common_Separator}', "");
    Expect(1, 65307, '\p{^Is_Bidi_Class=-	common_Separator}', "");
    Expect(1, 65307, '\P{Is_Bidi_Class=-	common_Separator}', "");
    Expect(0, 65307, '\P{^Is_Bidi_Class=-	common_Separator}', "");
    Error('\p{Is_Bc=_-cs:=}');
    Error('\P{Is_Bc=_-cs:=}');
    Expect(1, 65306, '\p{Is_Bc=cs}', "");
    Expect(0, 65306, '\p{^Is_Bc=cs}', "");
    Expect(0, 65306, '\P{Is_Bc=cs}', "");
    Expect(1, 65306, '\P{^Is_Bc=cs}', "");
    Expect(0, 65307, '\p{Is_Bc=cs}', "");
    Expect(1, 65307, '\p{^Is_Bc=cs}', "");
    Expect(1, 65307, '\P{Is_Bc=cs}', "");
    Expect(0, 65307, '\P{^Is_Bc=cs}', "");
    Expect(1, 65306, '\p{Is_Bc=		cs}', "");
    Expect(0, 65306, '\p{^Is_Bc=		cs}', "");
    Expect(0, 65306, '\P{Is_Bc=		cs}', "");
    Expect(1, 65306, '\P{^Is_Bc=		cs}', "");
    Expect(0, 65307, '\p{Is_Bc=		cs}', "");
    Expect(1, 65307, '\p{^Is_Bc=		cs}', "");
    Expect(1, 65307, '\P{Is_Bc=		cs}', "");
    Expect(0, 65307, '\P{^Is_Bc=		cs}', "");
    Error('\p{Bidi_Class:-/a/European_Number}');
    Error('\P{Bidi_Class:-/a/European_Number}');
    Expect(1, 130041, '\p{Bidi_Class=:\AEuropean_Number\z:}', "");;
    Expect(0, 130042, '\p{Bidi_Class=:\AEuropean_Number\z:}', "");;
    Expect(1, 130041, '\p{Bidi_Class=europeannumber}', "");
    Expect(0, 130041, '\p{^Bidi_Class=europeannumber}', "");
    Expect(0, 130041, '\P{Bidi_Class=europeannumber}', "");
    Expect(1, 130041, '\P{^Bidi_Class=europeannumber}', "");
    Expect(0, 130042, '\p{Bidi_Class=europeannumber}', "");
    Expect(1, 130042, '\p{^Bidi_Class=europeannumber}', "");
    Expect(1, 130042, '\P{Bidi_Class=europeannumber}', "");
    Expect(0, 130042, '\P{^Bidi_Class=europeannumber}', "");
    Expect(1, 130041, '\p{Bidi_Class=:\Aeuropeannumber\z:}', "");;
    Expect(0, 130042, '\p{Bidi_Class=:\Aeuropeannumber\z:}', "");;
    Expect(1, 130041, '\p{Bidi_Class=	-EUROPEAN_Number}', "");
    Expect(0, 130041, '\p{^Bidi_Class=	-EUROPEAN_Number}', "");
    Expect(0, 130041, '\P{Bidi_Class=	-EUROPEAN_Number}', "");
    Expect(1, 130041, '\P{^Bidi_Class=	-EUROPEAN_Number}', "");
    Expect(0, 130042, '\p{Bidi_Class=	-EUROPEAN_Number}', "");
    Expect(1, 130042, '\p{^Bidi_Class=	-EUROPEAN_Number}', "");
    Expect(1, 130042, '\P{Bidi_Class=	-EUROPEAN_Number}', "");
    Expect(0, 130042, '\P{^Bidi_Class=	-EUROPEAN_Number}', "");
    Error('\p{Bc:		:=en}');
    Error('\P{Bc:		:=en}');
    Expect(1, 130041, '\p{Bc=:\AEN\z:}', "");;
    Expect(0, 130042, '\p{Bc=:\AEN\z:}', "");;
    Expect(1, 130041, '\p{Bc=en}', "");
    Expect(0, 130041, '\p{^Bc=en}', "");
    Expect(0, 130041, '\P{Bc=en}', "");
    Expect(1, 130041, '\P{^Bc=en}', "");
    Expect(0, 130042, '\p{Bc=en}', "");
    Expect(1, 130042, '\p{^Bc=en}', "");
    Expect(1, 130042, '\P{Bc=en}', "");
    Expect(0, 130042, '\P{^Bc=en}', "");
    Expect(1, 130041, '\p{Bc=:\Aen\z:}', "");;
    Expect(0, 130042, '\p{Bc=:\Aen\z:}', "");;
    Expect(1, 130041, '\p{Bc=-_EN}', "");
    Expect(0, 130041, '\p{^Bc=-_EN}', "");
    Expect(0, 130041, '\P{Bc=-_EN}', "");
    Expect(1, 130041, '\P{^Bc=-_EN}', "");
    Expect(0, 130042, '\p{Bc=-_EN}', "");
    Expect(1, 130042, '\p{^Bc=-_EN}', "");
    Expect(1, 130042, '\P{Bc=-_EN}', "");
    Expect(0, 130042, '\P{^Bc=-_EN}', "");
    Error('\p{Is_Bidi_Class::=		European_number}');
    Error('\P{Is_Bidi_Class::=		European_number}');
    Expect(1, 130041, '\p{Is_Bidi_Class=europeannumber}', "");
    Expect(0, 130041, '\p{^Is_Bidi_Class=europeannumber}', "");
    Expect(0, 130041, '\P{Is_Bidi_Class=europeannumber}', "");
    Expect(1, 130041, '\P{^Is_Bidi_Class=europeannumber}', "");
    Expect(0, 130042, '\p{Is_Bidi_Class=europeannumber}', "");
    Expect(1, 130042, '\p{^Is_Bidi_Class=europeannumber}', "");
    Expect(1, 130042, '\P{Is_Bidi_Class=europeannumber}', "");
    Expect(0, 130042, '\P{^Is_Bidi_Class=europeannumber}', "");
    Expect(1, 130041, '\p{Is_Bidi_Class=- EUROPEAN_NUMBER}', "");
    Expect(0, 130041, '\p{^Is_Bidi_Class=- EUROPEAN_NUMBER}', "");
    Expect(0, 130041, '\P{Is_Bidi_Class=- EUROPEAN_NUMBER}', "");
    Expect(1, 130041, '\P{^Is_Bidi_Class=- EUROPEAN_NUMBER}', "");
    Expect(0, 130042, '\p{Is_Bidi_Class=- EUROPEAN_NUMBER}', "");
    Expect(1, 130042, '\p{^Is_Bidi_Class=- EUROPEAN_NUMBER}', "");
    Expect(1, 130042, '\P{Is_Bidi_Class=- EUROPEAN_NUMBER}', "");
    Expect(0, 130042, '\P{^Is_Bidi_Class=- EUROPEAN_NUMBER}', "");
    Error('\p{Is_Bc=	:=EN}');
    Error('\P{Is_Bc=	:=EN}');
    Expect(1, 130041, '\p{Is_Bc=en}', "");
    Expect(0, 130041, '\p{^Is_Bc=en}', "");
    Expect(0, 130041, '\P{Is_Bc=en}', "");
    Expect(1, 130041, '\P{^Is_Bc=en}', "");
    Expect(0, 130042, '\p{Is_Bc=en}', "");
    Expect(1, 130042, '\p{^Is_Bc=en}', "");
    Expect(1, 130042, '\P{Is_Bc=en}', "");
    Expect(0, 130042, '\P{^Is_Bc=en}', "");
    Expect(1, 130041, '\p{Is_Bc=-EN}', "");
    Expect(0, 130041, '\p{^Is_Bc=-EN}', "");
    Expect(0, 130041, '\P{Is_Bc=-EN}', "");
    Expect(1, 130041, '\P{^Is_Bc=-EN}', "");
    Expect(0, 130042, '\p{Is_Bc=-EN}', "");
    Expect(1, 130042, '\p{^Is_Bc=-EN}', "");
    Expect(1, 130042, '\P{Is_Bc=-EN}', "");
    Expect(0, 130042, '\P{^Is_Bc=-EN}', "");
    Error('\p{Bidi_Class=:= 	european_separator}');
    Error('\P{Bidi_Class=:= 	european_separator}');
    Expect(1, 65293, '\p{Bidi_Class=:\AEuropean_Separator\z:}', "");;
    Expect(0, 65294, '\p{Bidi_Class=:\AEuropean_Separator\z:}', "");;
    Expect(1, 65293, '\p{Bidi_Class=europeanseparator}', "");
    Expect(0, 65293, '\p{^Bidi_Class=europeanseparator}', "");
    Expect(0, 65293, '\P{Bidi_Class=europeanseparator}', "");
    Expect(1, 65293, '\P{^Bidi_Class=europeanseparator}', "");
    Expect(0, 65294, '\p{Bidi_Class=europeanseparator}', "");
    Expect(1, 65294, '\p{^Bidi_Class=europeanseparator}', "");
    Expect(1, 65294, '\P{Bidi_Class=europeanseparator}', "");
    Expect(0, 65294, '\P{^Bidi_Class=europeanseparator}', "");
    Expect(1, 65293, '\p{Bidi_Class=:\Aeuropeanseparator\z:}', "");;
    Expect(0, 65294, '\p{Bidi_Class=:\Aeuropeanseparator\z:}', "");;
    Expect(1, 65293, '\p{Bidi_Class=_ european_Separator}', "");
    Expect(0, 65293, '\p{^Bidi_Class=_ european_Separator}', "");
    Expect(0, 65293, '\P{Bidi_Class=_ european_Separator}', "");
    Expect(1, 65293, '\P{^Bidi_Class=_ european_Separator}', "");
    Expect(0, 65294, '\p{Bidi_Class=_ european_Separator}', "");
    Expect(1, 65294, '\p{^Bidi_Class=_ european_Separator}', "");
    Expect(1, 65294, '\P{Bidi_Class=_ european_Separator}', "");
    Expect(0, 65294, '\P{^Bidi_Class=_ european_Separator}', "");
    Error('\p{Bc=-:=ES}');
    Error('\P{Bc=-:=ES}');
    Expect(1, 65293, '\p{Bc=:\AES\z:}', "");;
    Expect(0, 65294, '\p{Bc=:\AES\z:}', "");;
    Expect(1, 65293, '\p{Bc=es}', "");
    Expect(0, 65293, '\p{^Bc=es}', "");
    Expect(0, 65293, '\P{Bc=es}', "");
    Expect(1, 65293, '\P{^Bc=es}', "");
    Expect(0, 65294, '\p{Bc=es}', "");
    Expect(1, 65294, '\p{^Bc=es}', "");
    Expect(1, 65294, '\P{Bc=es}', "");
    Expect(0, 65294, '\P{^Bc=es}', "");
    Expect(1, 65293, '\p{Bc=:\Aes\z:}', "");;
    Expect(0, 65294, '\p{Bc=:\Aes\z:}', "");;
    Expect(1, 65293, '\p{Bc:-ES}', "");
    Expect(0, 65293, '\p{^Bc:-ES}', "");
    Expect(0, 65293, '\P{Bc:-ES}', "");
    Expect(1, 65293, '\P{^Bc:-ES}', "");
    Expect(0, 65294, '\p{Bc:-ES}', "");
    Expect(1, 65294, '\p{^Bc:-ES}', "");
    Expect(1, 65294, '\P{Bc:-ES}', "");
    Expect(0, 65294, '\P{^Bc:-ES}', "");
    Error('\p{Is_Bidi_Class=/a/--European_Separator}');
    Error('\P{Is_Bidi_Class=/a/--European_Separator}');
    Expect(1, 65293, '\p{Is_Bidi_Class=europeanseparator}', "");
    Expect(0, 65293, '\p{^Is_Bidi_Class=europeanseparator}', "");
    Expect(0, 65293, '\P{Is_Bidi_Class=europeanseparator}', "");
    Expect(1, 65293, '\P{^Is_Bidi_Class=europeanseparator}', "");
    Expect(0, 65294, '\p{Is_Bidi_Class=europeanseparator}', "");
    Expect(1, 65294, '\p{^Is_Bidi_Class=europeanseparator}', "");
    Expect(1, 65294, '\P{Is_Bidi_Class=europeanseparator}', "");
    Expect(0, 65294, '\P{^Is_Bidi_Class=europeanseparator}', "");
    Expect(1, 65293, '\p{Is_Bidi_Class=_European_Separator}', "");
    Expect(0, 65293, '\p{^Is_Bidi_Class=_European_Separator}', "");
    Expect(0, 65293, '\P{Is_Bidi_Class=_European_Separator}', "");
    Expect(1, 65293, '\P{^Is_Bidi_Class=_European_Separator}', "");
    Expect(0, 65294, '\p{Is_Bidi_Class=_European_Separator}', "");
    Expect(1, 65294, '\p{^Is_Bidi_Class=_European_Separator}', "");
    Expect(1, 65294, '\P{Is_Bidi_Class=_European_Separator}', "");
    Expect(0, 65294, '\P{^Is_Bidi_Class=_European_Separator}', "");
    Error('\p{Is_Bc= ES/a/}');
    Error('\P{Is_Bc= ES/a/}');
    Expect(1, 65293, '\p{Is_Bc=es}', "");
    Expect(0, 65293, '\p{^Is_Bc=es}', "");
    Expect(0, 65293, '\P{Is_Bc=es}', "");
    Expect(1, 65293, '\P{^Is_Bc=es}', "");
    Expect(0, 65294, '\p{Is_Bc=es}', "");
    Expect(1, 65294, '\p{^Is_Bc=es}', "");
    Expect(1, 65294, '\P{Is_Bc=es}', "");
    Expect(0, 65294, '\P{^Is_Bc=es}', "");
    Expect(1, 65293, '\p{Is_Bc=_ES}', "");
    Expect(0, 65293, '\p{^Is_Bc=_ES}', "");
    Expect(0, 65293, '\P{Is_Bc=_ES}', "");
    Expect(1, 65293, '\P{^Is_Bc=_ES}', "");
    Expect(0, 65294, '\p{Is_Bc=_ES}', "");
    Expect(1, 65294, '\p{^Is_Bc=_ES}', "");
    Expect(1, 65294, '\P{Is_Bc=_ES}', "");
    Expect(0, 65294, '\P{^Is_Bc=_ES}', "");
    Error('\p{Bidi_Class=- European_Terminator/a/}');
    Error('\P{Bidi_Class=- European_Terminator/a/}');
    Expect(1, 123647, '\p{Bidi_Class=:\AEuropean_Terminator\z:}', "");;
    Expect(0, 123648, '\p{Bidi_Class=:\AEuropean_Terminator\z:}', "");;
    Expect(1, 123647, '\p{Bidi_Class=europeanterminator}', "");
    Expect(0, 123647, '\p{^Bidi_Class=europeanterminator}', "");
    Expect(0, 123647, '\P{Bidi_Class=europeanterminator}', "");
    Expect(1, 123647, '\P{^Bidi_Class=europeanterminator}', "");
    Expect(0, 123648, '\p{Bidi_Class=europeanterminator}', "");
    Expect(1, 123648, '\p{^Bidi_Class=europeanterminator}', "");
    Expect(1, 123648, '\P{Bidi_Class=europeanterminator}', "");
    Expect(0, 123648, '\P{^Bidi_Class=europeanterminator}', "");
    Expect(1, 123647, '\p{Bidi_Class=:\Aeuropeanterminator\z:}', "");;
    Expect(0, 123648, '\p{Bidi_Class=:\Aeuropeanterminator\z:}', "");;
    Expect(1, 123647, '\p{Bidi_Class:   	-EUROPEAN_Terminator}', "");
    Expect(0, 123647, '\p{^Bidi_Class:   	-EUROPEAN_Terminator}', "");
    Expect(0, 123647, '\P{Bidi_Class:   	-EUROPEAN_Terminator}', "");
    Expect(1, 123647, '\P{^Bidi_Class:   	-EUROPEAN_Terminator}', "");
    Expect(0, 123648, '\p{Bidi_Class:   	-EUROPEAN_Terminator}', "");
    Expect(1, 123648, '\p{^Bidi_Class:   	-EUROPEAN_Terminator}', "");
    Expect(1, 123648, '\P{Bidi_Class:   	-EUROPEAN_Terminator}', "");
    Expect(0, 123648, '\P{^Bidi_Class:   	-EUROPEAN_Terminator}', "");
    Error('\p{Bc=-/a/ET}');
    Error('\P{Bc=-/a/ET}');
    Expect(1, 123647, '\p{Bc=:\AET\z:}', "");;
    Expect(0, 123648, '\p{Bc=:\AET\z:}', "");;
    Expect(1, 123647, '\p{Bc=et}', "");
    Expect(0, 123647, '\p{^Bc=et}', "");
    Expect(0, 123647, '\P{Bc=et}', "");
    Expect(1, 123647, '\P{^Bc=et}', "");
    Expect(0, 123648, '\p{Bc=et}', "");
    Expect(1, 123648, '\p{^Bc=et}', "");
    Expect(1, 123648, '\P{Bc=et}', "");
    Expect(0, 123648, '\P{^Bc=et}', "");
    Expect(1, 123647, '\p{Bc=:\Aet\z:}', "");;
    Expect(0, 123648, '\p{Bc=:\Aet\z:}', "");;
    Expect(1, 123647, '\p{Bc=- ET}', "");
    Expect(0, 123647, '\p{^Bc=- ET}', "");
    Expect(0, 123647, '\P{Bc=- ET}', "");
    Expect(1, 123647, '\P{^Bc=- ET}', "");
    Expect(0, 123648, '\p{Bc=- ET}', "");
    Expect(1, 123648, '\p{^Bc=- ET}', "");
    Expect(1, 123648, '\P{Bc=- ET}', "");
    Expect(0, 123648, '\P{^Bc=- ET}', "");
    Error('\p{Is_Bidi_Class=_European_TERMINATOR:=}');
    Error('\P{Is_Bidi_Class=_European_TERMINATOR:=}');
    Expect(1, 123647, '\p{Is_Bidi_Class=europeanterminator}', "");
    Expect(0, 123647, '\p{^Is_Bidi_Class=europeanterminator}', "");
    Expect(0, 123647, '\P{Is_Bidi_Class=europeanterminator}', "");
    Expect(1, 123647, '\P{^Is_Bidi_Class=europeanterminator}', "");
    Expect(0, 123648, '\p{Is_Bidi_Class=europeanterminator}', "");
    Expect(1, 123648, '\p{^Is_Bidi_Class=europeanterminator}', "");
    Expect(1, 123648, '\P{Is_Bidi_Class=europeanterminator}', "");
    Expect(0, 123648, '\P{^Is_Bidi_Class=europeanterminator}', "");
    Expect(1, 123647, '\p{Is_Bidi_Class:	_	European_Terminator}', "");
    Expect(0, 123647, '\p{^Is_Bidi_Class:	_	European_Terminator}', "");
    Expect(0, 123647, '\P{Is_Bidi_Class:	_	European_Terminator}', "");
    Expect(1, 123647, '\P{^Is_Bidi_Class:	_	European_Terminator}', "");
    Expect(0, 123648, '\p{Is_Bidi_Class:	_	European_Terminator}', "");
    Expect(1, 123648, '\p{^Is_Bidi_Class:	_	European_Terminator}', "");
    Expect(1, 123648, '\P{Is_Bidi_Class:	_	European_Terminator}', "");
    Expect(0, 123648, '\P{^Is_Bidi_Class:	_	European_Terminator}', "");
    Error('\p{Is_Bc=:=__ET}');
    Error('\P{Is_Bc=:=__ET}');
    Expect(1, 123647, '\p{Is_Bc=et}', "");
    Expect(0, 123647, '\p{^Is_Bc=et}', "");
    Expect(0, 123647, '\P{Is_Bc=et}', "");
    Expect(1, 123647, '\P{^Is_Bc=et}', "");
    Expect(0, 123648, '\p{Is_Bc=et}', "");
    Expect(1, 123648, '\p{^Is_Bc=et}', "");
    Expect(1, 123648, '\P{Is_Bc=et}', "");
    Expect(0, 123648, '\P{^Is_Bc=et}', "");
    Expect(1, 123647, '\p{Is_Bc=-ET}', "");
    Expect(0, 123647, '\p{^Is_Bc=-ET}', "");
    Expect(0, 123647, '\P{Is_Bc=-ET}', "");
    Expect(1, 123647, '\P{^Is_Bc=-ET}', "");
    Expect(0, 123648, '\p{Is_Bc=-ET}', "");
    Expect(1, 123648, '\p{^Is_Bc=-ET}', "");
    Expect(1, 123648, '\P{Is_Bc=-ET}', "");
    Expect(0, 123648, '\P{^Is_Bc=-ET}', "");
    Error('\p{Bidi_Class=	-First_strong_ISOLATE:=}');
    Error('\P{Bidi_Class=	-First_strong_ISOLATE:=}');
    Expect(1, 8296, '\p{Bidi_Class=:\AFirst_Strong_Isolate\z:}', "");;
    Expect(0, 8297, '\p{Bidi_Class=:\AFirst_Strong_Isolate\z:}', "");;
    Expect(1, 8296, '\p{Bidi_Class=firststrongisolate}', "");
    Expect(0, 8296, '\p{^Bidi_Class=firststrongisolate}', "");
    Expect(0, 8296, '\P{Bidi_Class=firststrongisolate}', "");
    Expect(1, 8296, '\P{^Bidi_Class=firststrongisolate}', "");
    Expect(0, 8297, '\p{Bidi_Class=firststrongisolate}', "");
    Expect(1, 8297, '\p{^Bidi_Class=firststrongisolate}', "");
    Expect(1, 8297, '\P{Bidi_Class=firststrongisolate}', "");
    Expect(0, 8297, '\P{^Bidi_Class=firststrongisolate}', "");
    Expect(1, 8296, '\p{Bidi_Class=:\Afirststrongisolate\z:}', "");;
    Expect(0, 8297, '\p{Bidi_Class=:\Afirststrongisolate\z:}', "");;
    Expect(1, 8296, '\p{Bidi_Class=First_Strong_Isolate}', "");
    Expect(0, 8296, '\p{^Bidi_Class=First_Strong_Isolate}', "");
    Expect(0, 8296, '\P{Bidi_Class=First_Strong_Isolate}', "");
    Expect(1, 8296, '\P{^Bidi_Class=First_Strong_Isolate}', "");
    Expect(0, 8297, '\p{Bidi_Class=First_Strong_Isolate}', "");
    Expect(1, 8297, '\p{^Bidi_Class=First_Strong_Isolate}', "");
    Expect(1, 8297, '\P{Bidi_Class=First_Strong_Isolate}', "");
    Expect(0, 8297, '\P{^Bidi_Class=First_Strong_Isolate}', "");
    Error('\p{Bc=/a/		FSI}');
    Error('\P{Bc=/a/		FSI}');
    Expect(1, 8296, '\p{Bc=:\AFSI\z:}', "");;
    Expect(0, 8297, '\p{Bc=:\AFSI\z:}', "");;
    Expect(1, 8296, '\p{Bc=fsi}', "");
    Expect(0, 8296, '\p{^Bc=fsi}', "");
    Expect(0, 8296, '\P{Bc=fsi}', "");
    Expect(1, 8296, '\P{^Bc=fsi}', "");
    Expect(0, 8297, '\p{Bc=fsi}', "");
    Expect(1, 8297, '\p{^Bc=fsi}', "");
    Expect(1, 8297, '\P{Bc=fsi}', "");
    Expect(0, 8297, '\P{^Bc=fsi}', "");
    Expect(1, 8296, '\p{Bc=:\Afsi\z:}', "");;
    Expect(0, 8297, '\p{Bc=:\Afsi\z:}', "");;
    Expect(1, 8296, '\p{Bc=__FSI}', "");
    Expect(0, 8296, '\p{^Bc=__FSI}', "");
    Expect(0, 8296, '\P{Bc=__FSI}', "");
    Expect(1, 8296, '\P{^Bc=__FSI}', "");
    Expect(0, 8297, '\p{Bc=__FSI}', "");
    Expect(1, 8297, '\p{^Bc=__FSI}', "");
    Expect(1, 8297, '\P{Bc=__FSI}', "");
    Expect(0, 8297, '\P{^Bc=__FSI}', "");
    Error('\p{Is_Bidi_Class=-:=First_strong_isolate}');
    Error('\P{Is_Bidi_Class=-:=First_strong_isolate}');
    Expect(1, 8296, '\p{Is_Bidi_Class=firststrongisolate}', "");
    Expect(0, 8296, '\p{^Is_Bidi_Class=firststrongisolate}', "");
    Expect(0, 8296, '\P{Is_Bidi_Class=firststrongisolate}', "");
    Expect(1, 8296, '\P{^Is_Bidi_Class=firststrongisolate}', "");
    Expect(0, 8297, '\p{Is_Bidi_Class=firststrongisolate}', "");
    Expect(1, 8297, '\p{^Is_Bidi_Class=firststrongisolate}', "");
    Expect(1, 8297, '\P{Is_Bidi_Class=firststrongisolate}', "");
    Expect(0, 8297, '\P{^Is_Bidi_Class=firststrongisolate}', "");
    Expect(1, 8296, '\p{Is_Bidi_Class=  First_STRONG_Isolate}', "");
    Expect(0, 8296, '\p{^Is_Bidi_Class=  First_STRONG_Isolate}', "");
    Expect(0, 8296, '\P{Is_Bidi_Class=  First_STRONG_Isolate}', "");
    Expect(1, 8296, '\P{^Is_Bidi_Class=  First_STRONG_Isolate}', "");
    Expect(0, 8297, '\p{Is_Bidi_Class=  First_STRONG_Isolate}', "");
    Expect(1, 8297, '\p{^Is_Bidi_Class=  First_STRONG_Isolate}', "");
    Expect(1, 8297, '\P{Is_Bidi_Class=  First_STRONG_Isolate}', "");
    Expect(0, 8297, '\P{^Is_Bidi_Class=  First_STRONG_Isolate}', "");
    Error('\p{Is_Bc: _ fsi/a/}');
    Error('\P{Is_Bc: _ fsi/a/}');
    Expect(1, 8296, '\p{Is_Bc=fsi}', "");
    Expect(0, 8296, '\p{^Is_Bc=fsi}', "");
    Expect(0, 8296, '\P{Is_Bc=fsi}', "");
    Expect(1, 8296, '\P{^Is_Bc=fsi}', "");
    Expect(0, 8297, '\p{Is_Bc=fsi}', "");
    Expect(1, 8297, '\p{^Is_Bc=fsi}', "");
    Expect(1, 8297, '\P{Is_Bc=fsi}', "");
    Expect(0, 8297, '\P{^Is_Bc=fsi}', "");
    Expect(1, 8296, '\p{Is_Bc=		FSI}', "");
    Expect(0, 8296, '\p{^Is_Bc=		FSI}', "");
    Expect(0, 8296, '\P{Is_Bc=		FSI}', "");
    Expect(1, 8296, '\P{^Is_Bc=		FSI}', "");
    Expect(0, 8297, '\p{Is_Bc=		FSI}', "");
    Expect(1, 8297, '\p{^Is_Bc=		FSI}', "");
    Expect(1, 8297, '\P{Is_Bc=		FSI}', "");
    Expect(0, 8297, '\P{^Is_Bc=		FSI}', "");
    Error('\p{Bidi_Class= :=LEFT_TO_RIGHT}');
    Error('\P{Bidi_Class= :=LEFT_TO_RIGHT}');
    Expect(1, 1114109, '\p{Bidi_Class=:\ALeft_To_Right\z:}', "");;
    Expect(0, 921599, '\p{Bidi_Class=:\ALeft_To_Right\z:}', "");;
    Expect(1, 1114109, '\p{Bidi_Class=lefttoright}', "");
    Expect(0, 1114109, '\p{^Bidi_Class=lefttoright}', "");
    Expect(0, 1114109, '\P{Bidi_Class=lefttoright}', "");
    Expect(1, 1114109, '\P{^Bidi_Class=lefttoright}', "");
    Expect(0, 921599, '\p{Bidi_Class=lefttoright}', "");
    Expect(1, 921599, '\p{^Bidi_Class=lefttoright}', "");
    Expect(1, 921599, '\P{Bidi_Class=lefttoright}', "");
    Expect(0, 921599, '\P{^Bidi_Class=lefttoright}', "");
    Expect(1, 1114109, '\p{Bidi_Class=:\Alefttoright\z:}', "");;
    Expect(0, 921599, '\p{Bidi_Class=:\Alefttoright\z:}', "");;
    Expect(1, 1114109, '\p{Bidi_Class=_	LEFT_To_Right}', "");
    Expect(0, 1114109, '\p{^Bidi_Class=_	LEFT_To_Right}', "");
    Expect(0, 1114109, '\P{Bidi_Class=_	LEFT_To_Right}', "");
    Expect(1, 1114109, '\P{^Bidi_Class=_	LEFT_To_Right}', "");
    Expect(0, 921599, '\p{Bidi_Class=_	LEFT_To_Right}', "");
    Expect(1, 921599, '\p{^Bidi_Class=_	LEFT_To_Right}', "");
    Expect(1, 921599, '\P{Bidi_Class=_	LEFT_To_Right}', "");
    Expect(0, 921599, '\P{^Bidi_Class=_	LEFT_To_Right}', "");
    Error('\p{Bc: 	l:=}');
    Error('\P{Bc: 	l:=}');
    Expect(1, 1114109, '\p{Bc=:\AL\z:}', "");;
    Expect(0, 921599, '\p{Bc=:\AL\z:}', "");;
    Expect(1, 1114109, '\p{Bc: l}', "");
    Expect(0, 1114109, '\p{^Bc: l}', "");
    Expect(0, 1114109, '\P{Bc: l}', "");
    Expect(1, 1114109, '\P{^Bc: l}', "");
    Expect(0, 921599, '\p{Bc: l}', "");
    Expect(1, 921599, '\p{^Bc: l}', "");
    Expect(1, 921599, '\P{Bc: l}', "");
    Expect(0, 921599, '\P{^Bc: l}', "");
    Expect(1, 1114109, '\p{Bc=:\Al\z:}', "");;
    Expect(0, 921599, '\p{Bc=:\Al\z:}', "");;
    Expect(1, 1114109, '\p{Bc=  l}', "");
    Expect(0, 1114109, '\p{^Bc=  l}', "");
    Expect(0, 1114109, '\P{Bc=  l}', "");
    Expect(1, 1114109, '\P{^Bc=  l}', "");
    Expect(0, 921599, '\p{Bc=  l}', "");
    Expect(1, 921599, '\p{^Bc=  l}', "");
    Expect(1, 921599, '\P{Bc=  l}', "");
    Expect(0, 921599, '\P{^Bc=  l}', "");
    Error('\p{Is_Bidi_Class=-left_To_right/a/}');
    Error('\P{Is_Bidi_Class=-left_To_right/a/}');
    Expect(1, 1114109, '\p{Is_Bidi_Class=lefttoright}', "");
    Expect(0, 1114109, '\p{^Is_Bidi_Class=lefttoright}', "");
    Expect(0, 1114109, '\P{Is_Bidi_Class=lefttoright}', "");
    Expect(1, 1114109, '\P{^Is_Bidi_Class=lefttoright}', "");
    Expect(0, 921599, '\p{Is_Bidi_Class=lefttoright}', "");
    Expect(1, 921599, '\p{^Is_Bidi_Class=lefttoright}', "");
    Expect(1, 921599, '\P{Is_Bidi_Class=lefttoright}', "");
    Expect(0, 921599, '\P{^Is_Bidi_Class=lefttoright}', "");
    Expect(1, 1114109, '\p{Is_Bidi_Class=--LEFT_To_RIGHT}', "");
    Expect(0, 1114109, '\p{^Is_Bidi_Class=--LEFT_To_RIGHT}', "");
    Expect(0, 1114109, '\P{Is_Bidi_Class=--LEFT_To_RIGHT}', "");
    Expect(1, 1114109, '\P{^Is_Bidi_Class=--LEFT_To_RIGHT}', "");
    Expect(0, 921599, '\p{Is_Bidi_Class=--LEFT_To_RIGHT}', "");
    Expect(1, 921599, '\p{^Is_Bidi_Class=--LEFT_To_RIGHT}', "");
    Expect(1, 921599, '\P{Is_Bidi_Class=--LEFT_To_RIGHT}', "");
    Expect(0, 921599, '\P{^Is_Bidi_Class=--LEFT_To_RIGHT}', "");
    Error('\p{Is_Bc:	-L:=}');
    Error('\P{Is_Bc:	-L:=}');
    Expect(1, 1114109, '\p{Is_Bc=l}', "");
    Expect(0, 1114109, '\p{^Is_Bc=l}', "");
    Expect(0, 1114109, '\P{Is_Bc=l}', "");
    Expect(1, 1114109, '\P{^Is_Bc=l}', "");
    Expect(0, 921599, '\p{Is_Bc=l}', "");
    Expect(1, 921599, '\p{^Is_Bc=l}', "");
    Expect(1, 921599, '\P{Is_Bc=l}', "");
    Expect(0, 921599, '\P{^Is_Bc=l}', "");
    Expect(1, 1114109, '\p{Is_Bc=--L}', "");
    Expect(0, 1114109, '\p{^Is_Bc=--L}', "");
    Expect(0, 1114109, '\P{Is_Bc=--L}', "");
    Expect(1, 1114109, '\P{^Is_Bc=--L}', "");
    Expect(0, 921599, '\p{Is_Bc=--L}', "");
    Expect(1, 921599, '\p{^Is_Bc=--L}', "");
    Expect(1, 921599, '\P{Is_Bc=--L}', "");
    Expect(0, 921599, '\P{^Is_Bc=--L}', "");
    Error('\p{Bidi_Class= 	Left_To_Right_Embedding:=}');
    Error('\P{Bidi_Class= 	Left_To_Right_Embedding:=}');
    Expect(1, 8234, '\p{Bidi_Class=:\ALeft_To_Right_Embedding\z:}', "");;
    Expect(0, 8235, '\p{Bidi_Class=:\ALeft_To_Right_Embedding\z:}', "");;
    Expect(1, 8234, '\p{Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8234, '\p{^Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8234, '\P{Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8234, '\P{^Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8235, '\p{Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8235, '\p{^Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8235, '\P{Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8235, '\P{^Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8234, '\p{Bidi_Class=:\Alefttorightembedding\z:}', "");;
    Expect(0, 8235, '\p{Bidi_Class=:\Alefttorightembedding\z:}', "");;
    Expect(1, 8234, '\p{Bidi_Class=  LEFT_To_Right_EMBEDDING}', "");
    Expect(0, 8234, '\p{^Bidi_Class=  LEFT_To_Right_EMBEDDING}', "");
    Expect(0, 8234, '\P{Bidi_Class=  LEFT_To_Right_EMBEDDING}', "");
    Expect(1, 8234, '\P{^Bidi_Class=  LEFT_To_Right_EMBEDDING}', "");
    Expect(0, 8235, '\p{Bidi_Class=  LEFT_To_Right_EMBEDDING}', "");
    Expect(1, 8235, '\p{^Bidi_Class=  LEFT_To_Right_EMBEDDING}', "");
    Expect(1, 8235, '\P{Bidi_Class=  LEFT_To_Right_EMBEDDING}', "");
    Expect(0, 8235, '\P{^Bidi_Class=  LEFT_To_Right_EMBEDDING}', "");
    Error('\p{Bc=--LRE:=}');
    Error('\P{Bc=--LRE:=}');
    Expect(1, 8234, '\p{Bc=:\ALRE\z:}', "");;
    Expect(0, 8235, '\p{Bc=:\ALRE\z:}', "");;
    Expect(1, 8234, '\p{Bc:lre}', "");
    Expect(0, 8234, '\p{^Bc:lre}', "");
    Expect(0, 8234, '\P{Bc:lre}', "");
    Expect(1, 8234, '\P{^Bc:lre}', "");
    Expect(0, 8235, '\p{Bc:lre}', "");
    Expect(1, 8235, '\p{^Bc:lre}', "");
    Expect(1, 8235, '\P{Bc:lre}', "");
    Expect(0, 8235, '\P{^Bc:lre}', "");
    Expect(1, 8234, '\p{Bc=:\Alre\z:}', "");;
    Expect(0, 8235, '\p{Bc=:\Alre\z:}', "");;
    Expect(1, 8234, '\p{Bc=--lre}', "");
    Expect(0, 8234, '\p{^Bc=--lre}', "");
    Expect(0, 8234, '\P{Bc=--lre}', "");
    Expect(1, 8234, '\P{^Bc=--lre}', "");
    Expect(0, 8235, '\p{Bc=--lre}', "");
    Expect(1, 8235, '\p{^Bc=--lre}', "");
    Expect(1, 8235, '\P{Bc=--lre}', "");
    Expect(0, 8235, '\P{^Bc=--lre}', "");
    Error('\p{Is_Bidi_Class=:=  LEFT_to_RIGHT_Embedding}');
    Error('\P{Is_Bidi_Class=:=  LEFT_to_RIGHT_Embedding}');
    Expect(1, 8234, '\p{Is_Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8234, '\p{^Is_Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8234, '\P{Is_Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8234, '\P{^Is_Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8235, '\p{Is_Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8235, '\p{^Is_Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8235, '\P{Is_Bidi_Class=lefttorightembedding}', "");
    Expect(0, 8235, '\P{^Is_Bidi_Class=lefttorightembedding}', "");
    Expect(1, 8234, '\p{Is_Bidi_Class:		LEFT_TO_Right_embedding}', "");
    Expect(0, 8234, '\p{^Is_Bidi_Class:		LEFT_TO_Right_embedding}', "");
    Expect(0, 8234, '\P{Is_Bidi_Class:		LEFT_TO_Right_embedding}', "");
    Expect(1, 8234, '\P{^Is_Bidi_Class:		LEFT_TO_Right_embedding}', "");
    Expect(0, 8235, '\p{Is_Bidi_Class:		LEFT_TO_Right_embedding}', "");
    Expect(1, 8235, '\p{^Is_Bidi_Class:		LEFT_TO_Right_embedding}', "");
    Expect(1, 8235, '\P{Is_Bidi_Class:		LEFT_TO_Right_embedding}', "");
    Expect(0, 8235, '\P{^Is_Bidi_Class:		LEFT_TO_Right_embedding}', "");
    Error('\p{Is_Bc=/a/lre}');
    Error('\P{Is_Bc=/a/lre}');
    Expect(1, 8234, '\p{Is_Bc=lre}', "");
    Expect(0, 8234, '\p{^Is_Bc=lre}', "");
    Expect(0, 8234, '\P{Is_Bc=lre}', "");
    Expect(1, 8234, '\P{^Is_Bc=lre}', "");
    Expect(0, 8235, '\p{Is_Bc=lre}', "");
    Expect(1, 8235, '\p{^Is_Bc=lre}', "");
    Expect(1, 8235, '\P{Is_Bc=lre}', "");
    Expect(0, 8235, '\P{^Is_Bc=lre}', "");
    Expect(1, 8234, '\p{Is_Bc=__LRE}', "");
    Expect(0, 8234, '\p{^Is_Bc=__LRE}', "");
    Expect(0, 8234, '\P{Is_Bc=__LRE}', "");
    Expect(1, 8234, '\P{^Is_Bc=__LRE}', "");
    Expect(0, 8235, '\p{Is_Bc=__LRE}', "");
    Expect(1, 8235, '\p{^Is_Bc=__LRE}', "");
    Expect(1, 8235, '\P{Is_Bc=__LRE}', "");
    Expect(0, 8235, '\P{^Is_Bc=__LRE}', "");
    Error('\p{Bidi_Class=_:=Left_To_right_Isolate}');
    Error('\P{Bidi_Class=_:=Left_To_right_Isolate}');
    Expect(1, 8294, '\p{Bidi_Class=:\ALeft_To_Right_Isolate\z:}', "");;
    Expect(0, 8295, '\p{Bidi_Class=:\ALeft_To_Right_Isolate\z:}', "");;
    Expect(1, 8294, '\p{Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8294, '\p{^Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8294, '\P{Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8294, '\P{^Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8295, '\p{Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8295, '\p{^Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8295, '\P{Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8295, '\P{^Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8294, '\p{Bidi_Class=:\Alefttorightisolate\z:}', "");;
    Expect(0, 8295, '\p{Bidi_Class=:\Alefttorightisolate\z:}', "");;
    Expect(1, 8294, '\p{Bidi_Class=--left_To_right_ISOLATE}', "");
    Expect(0, 8294, '\p{^Bidi_Class=--left_To_right_ISOLATE}', "");
    Expect(0, 8294, '\P{Bidi_Class=--left_To_right_ISOLATE}', "");
    Expect(1, 8294, '\P{^Bidi_Class=--left_To_right_ISOLATE}', "");
    Expect(0, 8295, '\p{Bidi_Class=--left_To_right_ISOLATE}', "");
    Expect(1, 8295, '\p{^Bidi_Class=--left_To_right_ISOLATE}', "");
    Expect(1, 8295, '\P{Bidi_Class=--left_To_right_ISOLATE}', "");
    Expect(0, 8295, '\P{^Bidi_Class=--left_To_right_ISOLATE}', "");
    Error('\p{Bc: -:=LRI}');
    Error('\P{Bc: -:=LRI}');
    Expect(1, 8294, '\p{Bc=:\ALRI\z:}', "");;
    Expect(0, 8295, '\p{Bc=:\ALRI\z:}', "");;
    Expect(1, 8294, '\p{Bc=lri}', "");
    Expect(0, 8294, '\p{^Bc=lri}', "");
    Expect(0, 8294, '\P{Bc=lri}', "");
    Expect(1, 8294, '\P{^Bc=lri}', "");
    Expect(0, 8295, '\p{Bc=lri}', "");
    Expect(1, 8295, '\p{^Bc=lri}', "");
    Expect(1, 8295, '\P{Bc=lri}', "");
    Expect(0, 8295, '\P{^Bc=lri}', "");
    Expect(1, 8294, '\p{Bc=:\Alri\z:}', "");;
    Expect(0, 8295, '\p{Bc=:\Alri\z:}', "");;
    Expect(1, 8294, '\p{Bc=LRI}', "");
    Expect(0, 8294, '\p{^Bc=LRI}', "");
    Expect(0, 8294, '\P{Bc=LRI}', "");
    Expect(1, 8294, '\P{^Bc=LRI}', "");
    Expect(0, 8295, '\p{Bc=LRI}', "");
    Expect(1, 8295, '\p{^Bc=LRI}', "");
    Expect(1, 8295, '\P{Bc=LRI}', "");
    Expect(0, 8295, '\P{^Bc=LRI}', "");
    Error('\p{Is_Bidi_Class=:= -left_To_RIGHT_Isolate}');
    Error('\P{Is_Bidi_Class=:= -left_To_RIGHT_Isolate}');
    Expect(1, 8294, '\p{Is_Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8294, '\p{^Is_Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8294, '\P{Is_Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8294, '\P{^Is_Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8295, '\p{Is_Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8295, '\p{^Is_Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8295, '\P{Is_Bidi_Class=lefttorightisolate}', "");
    Expect(0, 8295, '\P{^Is_Bidi_Class=lefttorightisolate}', "");
    Expect(1, 8294, '\p{Is_Bidi_Class=	left_To_right_isolate}', "");
    Expect(0, 8294, '\p{^Is_Bidi_Class=	left_To_right_isolate}', "");
    Expect(0, 8294, '\P{Is_Bidi_Class=	left_To_right_isolate}', "");
    Expect(1, 8294, '\P{^Is_Bidi_Class=	left_To_right_isolate}', "");
    Expect(0, 8295, '\p{Is_Bidi_Class=	left_To_right_isolate}', "");
    Expect(1, 8295, '\p{^Is_Bidi_Class=	left_To_right_isolate}', "");
    Expect(1, 8295, '\P{Is_Bidi_Class=	left_To_right_isolate}', "");
    Expect(0, 8295, '\P{^Is_Bidi_Class=	left_To_right_isolate}', "");
    Error('\p{Is_Bc=-/a/LRI}');
    Error('\P{Is_Bc=-/a/LRI}');
    Expect(1, 8294, '\p{Is_Bc=lri}', "");
    Expect(0, 8294, '\p{^Is_Bc=lri}', "");
    Expect(0, 8294, '\P{Is_Bc=lri}', "");
    Expect(1, 8294, '\P{^Is_Bc=lri}', "");
    Expect(0, 8295, '\p{Is_Bc=lri}', "");
    Expect(1, 8295, '\p{^Is_Bc=lri}', "");
    Expect(1, 8295, '\P{Is_Bc=lri}', "");
    Expect(0, 8295, '\P{^Is_Bc=lri}', "");
    Expect(1, 8294, '\p{Is_Bc:    -LRI}', "");
    Expect(0, 8294, '\p{^Is_Bc:    -LRI}', "");
    Expect(0, 8294, '\P{Is_Bc:    -LRI}', "");
    Expect(1, 8294, '\P{^Is_Bc:    -LRI}', "");
    Expect(0, 8295, '\p{Is_Bc:    -LRI}', "");
    Expect(1, 8295, '\p{^Is_Bc:    -LRI}', "");
    Expect(1, 8295, '\P{Is_Bc:    -LRI}', "");
    Expect(0, 8295, '\P{^Is_Bc:    -LRI}', "");
    Error('\p{Bidi_Class=_:=Left_TO_Right_override}');
    Error('\P{Bidi_Class=_:=Left_TO_Right_override}');
    Expect(1, 8237, '\p{Bidi_Class=:\ALeft_To_Right_Override\z:}', "");;
    Expect(0, 8238, '\p{Bidi_Class=:\ALeft_To_Right_Override\z:}', "");;
    Expect(1, 8237, '\p{Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8237, '\p{^Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8237, '\P{Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8237, '\P{^Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8238, '\p{Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8238, '\p{^Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8238, '\P{Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8238, '\P{^Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8237, '\p{Bidi_Class=:\Alefttorightoverride\z:}', "");;
    Expect(0, 8238, '\p{Bidi_Class=:\Alefttorightoverride\z:}', "");;
    Expect(1, 8237, '\p{Bidi_Class= Left_To_Right_override}', "");
    Expect(0, 8237, '\p{^Bidi_Class= Left_To_Right_override}', "");
    Expect(0, 8237, '\P{Bidi_Class= Left_To_Right_override}', "");
    Expect(1, 8237, '\P{^Bidi_Class= Left_To_Right_override}', "");
    Expect(0, 8238, '\p{Bidi_Class= Left_To_Right_override}', "");
    Expect(1, 8238, '\p{^Bidi_Class= Left_To_Right_override}', "");
    Expect(1, 8238, '\P{Bidi_Class= Left_To_Right_override}', "");
    Expect(0, 8238, '\P{^Bidi_Class= Left_To_Right_override}', "");
    Error('\p{Bc=/a/__LRO}');
    Error('\P{Bc=/a/__LRO}');
    Expect(1, 8237, '\p{Bc=:\ALRO\z:}', "");;
    Expect(0, 8238, '\p{Bc=:\ALRO\z:}', "");;
    Expect(1, 8237, '\p{Bc=lro}', "");
    Expect(0, 8237, '\p{^Bc=lro}', "");
    Expect(0, 8237, '\P{Bc=lro}', "");
    Expect(1, 8237, '\P{^Bc=lro}', "");
    Expect(0, 8238, '\p{Bc=lro}', "");
    Expect(1, 8238, '\p{^Bc=lro}', "");
    Expect(1, 8238, '\P{Bc=lro}', "");
    Expect(0, 8238, '\P{^Bc=lro}', "");
    Expect(1, 8237, '\p{Bc=:\Alro\z:}', "");;
    Expect(0, 8238, '\p{Bc=:\Alro\z:}', "");;
    Expect(1, 8237, '\p{Bc=- LRO}', "");
    Expect(0, 8237, '\p{^Bc=- LRO}', "");
    Expect(0, 8237, '\P{Bc=- LRO}', "");
    Expect(1, 8237, '\P{^Bc=- LRO}', "");
    Expect(0, 8238, '\p{Bc=- LRO}', "");
    Expect(1, 8238, '\p{^Bc=- LRO}', "");
    Expect(1, 8238, '\P{Bc=- LRO}', "");
    Expect(0, 8238, '\P{^Bc=- LRO}', "");
    Error('\p{Is_Bidi_Class=	/a/Left_To_Right_Override}');
    Error('\P{Is_Bidi_Class=	/a/Left_To_Right_Override}');
    Expect(1, 8237, '\p{Is_Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8237, '\p{^Is_Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8237, '\P{Is_Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8237, '\P{^Is_Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8238, '\p{Is_Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8238, '\p{^Is_Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8238, '\P{Is_Bidi_Class=lefttorightoverride}', "");
    Expect(0, 8238, '\P{^Is_Bidi_Class=lefttorightoverride}', "");
    Expect(1, 8237, '\p{Is_Bidi_Class=	left_TO_RIGHT_Override}', "");
    Expect(0, 8237, '\p{^Is_Bidi_Class=	left_TO_RIGHT_Override}', "");
    Expect(0, 8237, '\P{Is_Bidi_Class=	left_TO_RIGHT_Override}', "");
    Expect(1, 8237, '\P{^Is_Bidi_Class=	left_TO_RIGHT_Override}', "");
    Expect(0, 8238, '\p{Is_Bidi_Class=	left_TO_RIGHT_Override}', "");
    Expect(1, 8238, '\p{^Is_Bidi_Class=	left_TO_RIGHT_Override}', "");
    Expect(1, 8238, '\P{Is_Bidi_Class=	left_TO_RIGHT_Override}', "");
    Expect(0, 8238, '\P{^Is_Bidi_Class=	left_TO_RIGHT_Override}', "");
    Error('\p{Is_Bc=_/a/LRO}');
    Error('\P{Is_Bc=_/a/LRO}');
    Expect(1, 8237, '\p{Is_Bc=lro}', "");
    Expect(0, 8237, '\p{^Is_Bc=lro}', "");
    Expect(0, 8237, '\P{Is_Bc=lro}', "");
    Expect(1, 8237, '\P{^Is_Bc=lro}', "");
    Expect(0, 8238, '\p{Is_Bc=lro}', "");
    Expect(1, 8238, '\p{^Is_Bc=lro}', "");
    Expect(1, 8238, '\P{Is_Bc=lro}', "");
    Expect(0, 8238, '\P{^Is_Bc=lro}', "");
    Expect(1, 8237, '\p{Is_Bc=_-LRO}', "");
    Expect(0, 8237, '\p{^Is_Bc=_-LRO}', "");
    Expect(0, 8237, '\P{Is_Bc=_-LRO}', "");
    Expect(1, 8237, '\P{^Is_Bc=_-LRO}', "");
    Expect(0, 8238, '\p{Is_Bc=_-LRO}', "");
    Expect(1, 8238, '\p{^Is_Bc=_-LRO}', "");
    Expect(1, 8238, '\P{Is_Bc=_-LRO}', "");
    Expect(0, 8238, '\P{^Is_Bc=_-LRO}', "");
    Error('\p{Bidi_Class:    :=NONSPACING_mark}');
    Error('\P{Bidi_Class:    :=NONSPACING_mark}');
    Expect(1, 917999, '\p{Bidi_Class=:\ANonspacing_Mark\z:}', "");;
    Expect(0, 918000, '\p{Bidi_Class=:\ANonspacing_Mark\z:}', "");;
    Expect(1, 917999, '\p{Bidi_Class=nonspacingmark}', "");
    Expect(0, 917999, '\p{^Bidi_Class=nonspacingmark}', "");
    Expect(0, 917999, '\P{Bidi_Class=nonspacingmark}', "");
    Expect(1, 917999, '\P{^Bidi_Class=nonspacingmark}', "");
    Expect(0, 918000, '\p{Bidi_Class=nonspacingmark}', "");
    Expect(1, 918000, '\p{^Bidi_Class=nonspacingmark}', "");
    Expect(1, 918000, '\P{Bidi_Class=nonspacingmark}', "");
    Expect(0, 918000, '\P{^Bidi_Class=nonspacingmark}', "");
    Expect(1, 917999, '\p{Bidi_Class=:\Anonspacingmark\z:}', "");;
    Expect(0, 918000, '\p{Bidi_Class=:\Anonspacingmark\z:}', "");;
    Expect(1, 917999, '\p{Bidi_Class=		nonspacing_Mark}', "");
    Expect(0, 917999, '\p{^Bidi_Class=		nonspacing_Mark}', "");
    Expect(0, 917999, '\P{Bidi_Class=		nonspacing_Mark}', "");
    Expect(1, 917999, '\P{^Bidi_Class=		nonspacing_Mark}', "");
    Expect(0, 918000, '\p{Bidi_Class=		nonspacing_Mark}', "");
    Expect(1, 918000, '\p{^Bidi_Class=		nonspacing_Mark}', "");
    Expect(1, 918000, '\P{Bidi_Class=		nonspacing_Mark}', "");
    Expect(0, 918000, '\P{^Bidi_Class=		nonspacing_Mark}', "");
    Error('\p{Bc=/a/NSM}');
    Error('\P{Bc=/a/NSM}');
    Expect(1, 917999, '\p{Bc=:\ANSM\z:}', "");;
    Expect(0, 918000, '\p{Bc=:\ANSM\z:}', "");;
    Expect(1, 917999, '\p{Bc=nsm}', "");
    Expect(0, 917999, '\p{^Bc=nsm}', "");
    Expect(0, 917999, '\P{Bc=nsm}', "");
    Expect(1, 917999, '\P{^Bc=nsm}', "");
    Expect(0, 918000, '\p{Bc=nsm}', "");
    Expect(1, 918000, '\p{^Bc=nsm}', "");
    Expect(1, 918000, '\P{Bc=nsm}', "");
    Expect(0, 918000, '\P{^Bc=nsm}', "");
    Expect(1, 917999, '\p{Bc=:\Ansm\z:}', "");;
    Expect(0, 918000, '\p{Bc=:\Ansm\z:}', "");;
    Expect(1, 917999, '\p{Bc=  NSM}', "");
    Expect(0, 917999, '\p{^Bc=  NSM}', "");
    Expect(0, 917999, '\P{Bc=  NSM}', "");
    Expect(1, 917999, '\P{^Bc=  NSM}', "");
    Expect(0, 918000, '\p{Bc=  NSM}', "");
    Expect(1, 918000, '\p{^Bc=  NSM}', "");
    Expect(1, 918000, '\P{Bc=  NSM}', "");
    Expect(0, 918000, '\P{^Bc=  NSM}', "");
    Error('\p{Is_Bidi_Class=:=	-NONSPACING_Mark}');
    Error('\P{Is_Bidi_Class=:=	-NONSPACING_Mark}');
    Expect(1, 917999, '\p{Is_Bidi_Class:	nonspacingmark}', "");
    Expect(0, 917999, '\p{^Is_Bidi_Class:	nonspacingmark}', "");
    Expect(0, 917999, '\P{Is_Bidi_Class:	nonspacingmark}', "");
    Expect(1, 917999, '\P{^Is_Bidi_Class:	nonspacingmark}', "");
    Expect(0, 918000, '\p{Is_Bidi_Class:	nonspacingmark}', "");
    Expect(1, 918000, '\p{^Is_Bidi_Class:	nonspacingmark}', "");
    Expect(1, 918000, '\P{Is_Bidi_Class:	nonspacingmark}', "");
    Expect(0, 918000, '\P{^Is_Bidi_Class:	nonspacingmark}', "");
    Expect(1, 917999, '\p{Is_Bidi_Class= _NONSPACING_mark}', "");
    Expect(0, 917999, '\p{^Is_Bidi_Class= _NONSPACING_mark}', "");
    Expect(0, 917999, '\P{Is_Bidi_Class= _NONSPACING_mark}', "");
    Expect(1, 917999, '\P{^Is_Bidi_Class= _NONSPACING_mark}', "");
    Expect(0, 918000, '\p{Is_Bidi_Class= _NONSPACING_mark}', "");
    Expect(1, 918000, '\p{^Is_Bidi_Class= _NONSPACING_mark}', "");
    Expect(1, 918000, '\P{Is_Bidi_Class= _NONSPACING_mark}', "");
    Expect(0, 918000, '\P{^Is_Bidi_Class= _NONSPACING_mark}', "");
    Error('\p{Is_Bc=-:=nsm}');
    Error('\P{Is_Bc=-:=nsm}');
    Expect(1, 917999, '\p{Is_Bc=nsm}', "");
    Expect(0, 917999, '\p{^Is_Bc=nsm}', "");
    Expect(0, 917999, '\P{Is_Bc=nsm}', "");
    Expect(1, 917999, '\P{^Is_Bc=nsm}', "");
    Expect(0, 918000, '\p{Is_Bc=nsm}', "");
    Expect(1, 918000, '\p{^Is_Bc=nsm}', "");
    Expect(1, 918000, '\P{Is_Bc=nsm}', "");
    Expect(0, 918000, '\P{^Is_Bc=nsm}', "");
    Expect(1, 917999, '\p{Is_Bc:		NSM}', "");
    Expect(0, 917999, '\p{^Is_Bc:		NSM}', "");
    Expect(0, 917999, '\P{Is_Bc:		NSM}', "");
    Expect(1, 917999, '\P{^Is_Bc:		NSM}', "");
    Expect(0, 918000, '\p{Is_Bc:		NSM}', "");
    Expect(1, 918000, '\p{^Is_Bc:		NSM}', "");
    Expect(1, 918000, '\P{Is_Bc:		NSM}', "");
    Expect(0, 918000, '\P{^Is_Bc:		NSM}', "");
    Error('\p{Bidi_Class=/a/ OTHER_neutral}');
    Error('\P{Bidi_Class=/a/ OTHER_neutral}');
    Expect(1, 129994, '\p{Bidi_Class=:\AOther_Neutral\z:}', "");;
    Expect(0, 129995, '\p{Bidi_Class=:\AOther_Neutral\z:}', "");;
    Expect(1, 129994, '\p{Bidi_Class:   otherneutral}', "");
    Expect(0, 129994, '\p{^Bidi_Class:   otherneutral}', "");
    Expect(0, 129994, '\P{Bidi_Class:   otherneutral}', "");
    Expect(1, 129994, '\P{^Bidi_Class:   otherneutral}', "");
    Expect(0, 129995, '\p{Bidi_Class:   otherneutral}', "");
    Expect(1, 129995, '\p{^Bidi_Class:   otherneutral}', "");
    Expect(1, 129995, '\P{Bidi_Class:   otherneutral}', "");
    Expect(0, 129995, '\P{^Bidi_Class:   otherneutral}', "");
    Expect(1, 129994, '\p{Bidi_Class=:\Aotherneutral\z:}', "");;
    Expect(0, 129995, '\p{Bidi_Class=:\Aotherneutral\z:}', "");;
    Expect(1, 129994, '\p{Bidi_Class=	 Other_Neutral}', "");
    Expect(0, 129994, '\p{^Bidi_Class=	 Other_Neutral}', "");
    Expect(0, 129994, '\P{Bidi_Class=	 Other_Neutral}', "");
    Expect(1, 129994, '\P{^Bidi_Class=	 Other_Neutral}', "");
    Expect(0, 129995, '\p{Bidi_Class=	 Other_Neutral}', "");
    Expect(1, 129995, '\p{^Bidi_Class=	 Other_Neutral}', "");
    Expect(1, 129995, '\P{Bidi_Class=	 Other_Neutral}', "");
    Expect(0, 129995, '\P{^Bidi_Class=	 Other_Neutral}', "");
    Error('\p{Bc= :=ON}');
    Error('\P{Bc= :=ON}');
    Expect(1, 129994, '\p{Bc=:\AON\z:}', "");;
    Expect(0, 129995, '\p{Bc=:\AON\z:}', "");;
    Expect(1, 129994, '\p{Bc=on}', "");
    Expect(0, 129994, '\p{^Bc=on}', "");
    Expect(0, 129994, '\P{Bc=on}', "");
    Expect(1, 129994, '\P{^Bc=on}', "");
    Expect(0, 129995, '\p{Bc=on}', "");
    Expect(1, 129995, '\p{^Bc=on}', "");
    Expect(1, 129995, '\P{Bc=on}', "");
    Expect(0, 129995, '\P{^Bc=on}', "");
    Expect(1, 129994, '\p{Bc=:\Aon\z:}', "");;
    Expect(0, 129995, '\p{Bc=:\Aon\z:}', "");;
    Expect(1, 129994, '\p{Bc=_ON}', "");
    Expect(0, 129994, '\p{^Bc=_ON}', "");
    Expect(0, 129994, '\P{Bc=_ON}', "");
    Expect(1, 129994, '\P{^Bc=_ON}', "");
    Expect(0, 129995, '\p{Bc=_ON}', "");
    Expect(1, 129995, '\p{^Bc=_ON}', "");
    Expect(1, 129995, '\P{Bc=_ON}', "");
    Expect(0, 129995, '\P{^Bc=_ON}', "");
    Error('\p{Is_Bidi_Class=--other_Neutral/a/}');
    Error('\P{Is_Bidi_Class=--other_Neutral/a/}');
    Expect(1, 129994, '\p{Is_Bidi_Class=otherneutral}', "");
    Expect(0, 129994, '\p{^Is_Bidi_Class=otherneutral}', "");
    Expect(0, 129994, '\P{Is_Bidi_Class=otherneutral}', "");
    Expect(1, 129994, '\P{^Is_Bidi_Class=otherneutral}', "");
    Expect(0, 129995, '\p{Is_Bidi_Class=otherneutral}', "");
    Expect(1, 129995, '\p{^Is_Bidi_Class=otherneutral}', "");
    Expect(1, 129995, '\P{Is_Bidi_Class=otherneutral}', "");
    Expect(0, 129995, '\P{^Is_Bidi_Class=otherneutral}', "");
    Expect(1, 129994, '\p{Is_Bidi_Class=	 Other_NEUTRAL}', "");
    Expect(0, 129994, '\p{^Is_Bidi_Class=	 Other_NEUTRAL}', "");
    Expect(0, 129994, '\P{Is_Bidi_Class=	 Other_NEUTRAL}', "");
    Expect(1, 129994, '\P{^Is_Bidi_Class=	 Other_NEUTRAL}', "");
    Expect(0, 129995, '\p{Is_Bidi_Class=	 Other_NEUTRAL}', "");
    Expect(1, 129995, '\p{^Is_Bidi_Class=	 Other_NEUTRAL}', "");
    Expect(1, 129995, '\P{Is_Bidi_Class=	 Other_NEUTRAL}', "");
    Expect(0, 129995, '\P{^Is_Bidi_Class=	 Other_NEUTRAL}', "");
    Error('\p{Is_Bc=  ON:=}');
    Error('\P{Is_Bc=  ON:=}');
    Expect(1, 129994, '\p{Is_Bc=on}', "");
    Expect(0, 129994, '\p{^Is_Bc=on}', "");
    Expect(0, 129994, '\P{Is_Bc=on}', "");
    Expect(1, 129994, '\P{^Is_Bc=on}', "");
    Expect(0, 129995, '\p{Is_Bc=on}', "");
    Expect(1, 129995, '\p{^Is_Bc=on}', "");
    Expect(1, 129995, '\P{Is_Bc=on}', "");
    Expect(0, 129995, '\P{^Is_Bc=on}', "");
    Expect(1, 129994, '\p{Is_Bc=_-on}', "");
    Expect(0, 129994, '\p{^Is_Bc=_-on}', "");
    Expect(0, 129994, '\P{Is_Bc=_-on}', "");
    Expect(1, 129994, '\P{^Is_Bc=_-on}', "");
    Expect(0, 129995, '\p{Is_Bc=_-on}', "");
    Expect(1, 129995, '\p{^Is_Bc=_-on}', "");
    Expect(1, 129995, '\P{Is_Bc=_-on}', "");
    Expect(0, 129995, '\P{^Is_Bc=_-on}', "");
    Error('\p{Bidi_Class=:=POP_directional_Format}');
    Error('\P{Bidi_Class=:=POP_directional_Format}');
    Expect(1, 8236, '\p{Bidi_Class=:\APop_Directional_Format\z:}', "");;
    Expect(0, 8237, '\p{Bidi_Class=:\APop_Directional_Format\z:}', "");;
    Expect(1, 8236, '\p{Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8236, '\p{^Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8236, '\P{Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8236, '\P{^Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8237, '\p{Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8237, '\p{^Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8237, '\P{Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8237, '\P{^Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8236, '\p{Bidi_Class=:\Apopdirectionalformat\z:}', "");;
    Expect(0, 8237, '\p{Bidi_Class=:\Apopdirectionalformat\z:}', "");;
    Expect(1, 8236, '\p{Bidi_Class=_-pop_directional_Format}', "");
    Expect(0, 8236, '\p{^Bidi_Class=_-pop_directional_Format}', "");
    Expect(0, 8236, '\P{Bidi_Class=_-pop_directional_Format}', "");
    Expect(1, 8236, '\P{^Bidi_Class=_-pop_directional_Format}', "");
    Expect(0, 8237, '\p{Bidi_Class=_-pop_directional_Format}', "");
    Expect(1, 8237, '\p{^Bidi_Class=_-pop_directional_Format}', "");
    Expect(1, 8237, '\P{Bidi_Class=_-pop_directional_Format}', "");
    Expect(0, 8237, '\P{^Bidi_Class=_-pop_directional_Format}', "");
    Error('\p{Bc=	_pdf:=}');
    Error('\P{Bc=	_pdf:=}');
    Expect(1, 8236, '\p{Bc=:\APDF\z:}', "");;
    Expect(0, 8237, '\p{Bc=:\APDF\z:}', "");;
    Expect(1, 8236, '\p{Bc=pdf}', "");
    Expect(0, 8236, '\p{^Bc=pdf}', "");
    Expect(0, 8236, '\P{Bc=pdf}', "");
    Expect(1, 8236, '\P{^Bc=pdf}', "");
    Expect(0, 8237, '\p{Bc=pdf}', "");
    Expect(1, 8237, '\p{^Bc=pdf}', "");
    Expect(1, 8237, '\P{Bc=pdf}', "");
    Expect(0, 8237, '\P{^Bc=pdf}', "");
    Expect(1, 8236, '\p{Bc=:\Apdf\z:}', "");;
    Expect(0, 8237, '\p{Bc=:\Apdf\z:}', "");;
    Expect(1, 8236, '\p{Bc= 	PDF}', "");
    Expect(0, 8236, '\p{^Bc= 	PDF}', "");
    Expect(0, 8236, '\P{Bc= 	PDF}', "");
    Expect(1, 8236, '\P{^Bc= 	PDF}', "");
    Expect(0, 8237, '\p{Bc= 	PDF}', "");
    Expect(1, 8237, '\p{^Bc= 	PDF}', "");
    Expect(1, 8237, '\P{Bc= 	PDF}', "");
    Expect(0, 8237, '\P{^Bc= 	PDF}', "");
    Error('\p{Is_Bidi_Class= /a/pop_DIRECTIONAL_Format}');
    Error('\P{Is_Bidi_Class= /a/pop_DIRECTIONAL_Format}');
    Expect(1, 8236, '\p{Is_Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8236, '\p{^Is_Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8236, '\P{Is_Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8236, '\P{^Is_Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8237, '\p{Is_Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8237, '\p{^Is_Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8237, '\P{Is_Bidi_Class=popdirectionalformat}', "");
    Expect(0, 8237, '\P{^Is_Bidi_Class=popdirectionalformat}', "");
    Expect(1, 8236, '\p{Is_Bidi_Class=Pop_Directional_Format}', "");
    Expect(0, 8236, '\p{^Is_Bidi_Class=Pop_Directional_Format}', "");
    Expect(0, 8236, '\P{Is_Bidi_Class=Pop_Directional_Format}', "");
    Expect(1, 8236, '\P{^Is_Bidi_Class=Pop_Directional_Format}', "");
    Expect(0, 8237, '\p{Is_Bidi_Class=Pop_Directional_Format}', "");
    Expect(1, 8237, '\p{^Is_Bidi_Class=Pop_Directional_Format}', "");
    Expect(1, 8237, '\P{Is_Bidi_Class=Pop_Directional_Format}', "");
    Expect(0, 8237, '\P{^Is_Bidi_Class=Pop_Directional_Format}', "");
    Error('\p{Is_Bc=:=_ PDF}');
    Error('\P{Is_Bc=:=_ PDF}');
    Expect(1, 8236, '\p{Is_Bc=pdf}', "");
    Expect(0, 8236, '\p{^Is_Bc=pdf}', "");
    Expect(0, 8236, '\P{Is_Bc=pdf}', "");
    Expect(1, 8236, '\P{^Is_Bc=pdf}', "");
    Expect(0, 8237, '\p{Is_Bc=pdf}', "");
    Expect(1, 8237, '\p{^Is_Bc=pdf}', "");
    Expect(1, 8237, '\P{Is_Bc=pdf}', "");
    Expect(0, 8237, '\P{^Is_Bc=pdf}', "");
    Expect(1, 8236, '\p{Is_Bc= -PDF}', "");
    Expect(0, 8236, '\p{^Is_Bc= -PDF}', "");
    Expect(0, 8236, '\P{Is_Bc= -PDF}', "");
    Expect(1, 8236, '\P{^Is_Bc= -PDF}', "");
    Expect(0, 8237, '\p{Is_Bc= -PDF}', "");
    Expect(1, 8237, '\p{^Is_Bc= -PDF}', "");
    Expect(1, 8237, '\P{Is_Bc= -PDF}', "");
    Expect(0, 8237, '\P{^Is_Bc= -PDF}', "");
    Error('\p{Bidi_Class= pop_DIRECTIONAL_Isolate/a/}');
    Error('\P{Bidi_Class= pop_DIRECTIONAL_Isolate/a/}');
    Expect(1, 8297, '\p{Bidi_Class=:\APop_Directional_Isolate\z:}', "");;
    Expect(0, 8298, '\p{Bidi_Class=:\APop_Directional_Isolate\z:}', "");;
    Expect(1, 8297, '\p{Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8297, '\p{^Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8297, '\P{Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8297, '\P{^Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8298, '\p{Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8298, '\p{^Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8298, '\P{Bidi_Class=popdirectionalisolate}', "");
    Expect(0, 8298, '\P{^Bidi_Class=popdirectionalisolate}', "");
    Expect(1, 8297, '\p{Bidi_Class=:\Apopdirectionalisolate\z:}', "");;
    Expect(0, 8298, '\p{Bidi_Class=:\Apopdirectionalisolate\z:}', "");;
    Expect(1, 8297, '\p{Bidi_Class=		POP_Directional_isolate}', "");
    Expect(0, 8297, '\p{^Bidi_Class=		POP_Directional_isolate}', "");
    Expect(0, 8297, '\P{Bidi_Class=		POP_Directional_isolate}', "");
    Expect(1, 8297, '\P{^Bidi_Class=		POP_Directional_isolate}', "");
    Expect(0, 8298, '\p{Bidi_Class=		POP_Directional_isolate}', "");
    Expect(1, 8298, '\p{^Bidi_Class=		POP_Directional_isolate}', "");
    Expect(1, 8298, '\P{Bidi_Class=		POP_Directional_isolate}', "");
    Expect(0, 8298, '\P{^Bidi_Class=		POP_Directional_isolate}', "");
    Error('\p{Bc=:=-_PDI}');
    Error('\P{Bc=:=-_PDI}');
    Expect(1, 8297, '\p{Bc=:\APDI\z:}', "");;
    Expect(0, 8298, '\p{Bc=:\APDI\z:}', "");;
    Expect(1, 8297, '\p{Bc=pdi}', "");
    Expect(0, 8297, '\p{^Bc=pdi}', "");
    Expect(0, 8297, '\P{Bc=pdi}', "");
    Expect(1, 8297, '\P{^Bc=pdi}', "");
    Expect(0, 8298, '\p{Bc=pdi}', "");
    Expect(1, 8298, '\p{^Bc=pdi}', "");
    Expect(1, 8298, '\P{Bc=pdi}', "");
    Expect(0, 8298, '\P{^Bc=pdi}', "");
    Expect(1, 8297, '\p{Bc=:\Apdi\z:}', "");;
    Expect(0, 8298, '\p{Bc=:\Apdi\z:}', "");;
    Expect(1, 8297, '\p{Bc= -pdi}', "");
    Expect(0, 8297, '\p{^Bc= -pdi}', "");
    Expect(0, 8297, '\P{Bc= -pdi}', "");
    Expect(1, 8297, '\P{^Bc= -pdi}', "");
    Expect(0, 8298, '\p{Bc= -pdi}', "");
    Expect(1, 8298, '\p{^Bc= -pdi}', "");
    Expect(1, 8298, '\P{Bc= -pdi}', "");
    Expect(0, 8298, '\P{^Bc= -pdi}', "");
    Error('\p{Is_Bidi_Class=-/a/pop_directional_Isolate}');
    Error('\P{Is_Bidi_Class=-/a/pop_directional_Isolate}');
    Expect(1, 8297, '\p{Is_Bidi_Class: popdirectionalisolate}', "");
    Expect(0, 8297, '\p{^Is_Bidi_Class: popdirectionalisolate}', "");
    Expect(0, 8297, '\P{Is_Bidi_Class: popdirectionalisolate}', "");
    Expect(1, 8297, '\P{^Is_Bidi_Class: popdirectionalisolate}', "");
    Expect(0, 8298, '\p{Is_Bidi_Class: popdirectionalisolate}', "");
    Expect(1, 8298, '\p{^Is_Bidi_Class: popdirectionalisolate}', "");
    Expect(1, 8298, '\P{Is_Bidi_Class: popdirectionalisolate}', "");
    Expect(0, 8298, '\P{^Is_Bidi_Class: popdirectionalisolate}', "");
    Expect(1, 8297, '\p{Is_Bidi_Class=		pop_Directional_ISOLATE}', "");
    Expect(0, 8297, '\p{^Is_Bidi_Class=		pop_Directional_ISOLATE}', "");
    Expect(0, 8297, '\P{Is_Bidi_Class=		pop_Directional_ISOLATE}', "");
    Expect(1, 8297, '\P{^Is_Bidi_Class=		pop_Directional_ISOLATE}', "");
    Expect(0, 8298, '\p{Is_Bidi_Class=		pop_Directional_ISOLATE}', "");
    Expect(1, 8298, '\p{^Is_Bidi_Class=		pop_Directional_ISOLATE}', "");
    Expect(1, 8298, '\P{Is_Bidi_Class=		pop_Directional_ISOLATE}', "");
    Expect(0, 8298, '\P{^Is_Bidi_Class=		pop_Directional_ISOLATE}', "");
    Error('\p{Is_Bc=-_PDI:=}');
    Error('\P{Is_Bc=-_PDI:=}');
    Expect(1, 8297, '\p{Is_Bc: pdi}', "");
    Expect(0, 8297, '\p{^Is_Bc: pdi}', "");
    Expect(0, 8297, '\P{Is_Bc: pdi}', "");
    Expect(1, 8297, '\P{^Is_Bc: pdi}', "");
    Expect(0, 8298, '\p{Is_Bc: pdi}', "");
    Expect(1, 8298, '\p{^Is_Bc: pdi}', "");
    Expect(1, 8298, '\P{Is_Bc: pdi}', "");
    Expect(0, 8298, '\P{^Is_Bc: pdi}', "");
    Expect(1, 8297, '\p{Is_Bc=	-PDI}', "");
    Expect(0, 8297, '\p{^Is_Bc=	-PDI}', "");
    Expect(0, 8297, '\P{Is_Bc=	-PDI}', "");
    Expect(1, 8297, '\P{^Is_Bc=	-PDI}', "");
    Expect(0, 8298, '\p{Is_Bc=	-PDI}', "");
    Expect(1, 8298, '\p{^Is_Bc=	-PDI}', "");
    Expect(1, 8298, '\P{Is_Bc=	-PDI}', "");
    Expect(0, 8298, '\P{^Is_Bc=	-PDI}', "");
    Error('\p{Bidi_Class:	-Right_To_Left/a/}');
    Error('\P{Bidi_Class:	-Right_To_Left/a/}');
    Expect(1, 126975, '\p{Bidi_Class=:\ARight_To_Left\z:}', "");;
    Expect(0, 126976, '\p{Bidi_Class=:\ARight_To_Left\z:}', "");;
    Expect(1, 126975, '\p{Bidi_Class=righttoleft}', "");
    Expect(0, 126975, '\p{^Bidi_Class=righttoleft}', "");
    Expect(0, 126975, '\P{Bidi_Class=righttoleft}', "");
    Expect(1, 126975, '\P{^Bidi_Class=righttoleft}', "");
    Expect(0, 126976, '\p{Bidi_Class=righttoleft}', "");
    Expect(1, 126976, '\p{^Bidi_Class=righttoleft}', "");
    Expect(1, 126976, '\P{Bidi_Class=righttoleft}', "");
    Expect(0, 126976, '\P{^Bidi_Class=righttoleft}', "");
    Expect(1, 126975, '\p{Bidi_Class=:\Arighttoleft\z:}', "");;
    Expect(0, 126976, '\p{Bidi_Class=:\Arighttoleft\z:}', "");;
    Expect(1, 126975, '\p{Bidi_Class=  right_TO_LEFT}', "");
    Expect(0, 126975, '\p{^Bidi_Class=  right_TO_LEFT}', "");
    Expect(0, 126975, '\P{Bidi_Class=  right_TO_LEFT}', "");
    Expect(1, 126975, '\P{^Bidi_Class=  right_TO_LEFT}', "");
    Expect(0, 126976, '\p{Bidi_Class=  right_TO_LEFT}', "");
    Expect(1, 126976, '\p{^Bidi_Class=  right_TO_LEFT}', "");
    Expect(1, 126976, '\P{Bidi_Class=  right_TO_LEFT}', "");
    Expect(0, 126976, '\P{^Bidi_Class=  right_TO_LEFT}', "");
    Error('\p{Bc=_ R/a/}');
    Error('\P{Bc=_ R/a/}');
    Expect(1, 126975, '\p{Bc=:\AR\z:}', "");;
    Expect(0, 126976, '\p{Bc=:\AR\z:}', "");;
    Expect(1, 126975, '\p{Bc=r}', "");
    Expect(0, 126975, '\p{^Bc=r}', "");
    Expect(0, 126975, '\P{Bc=r}', "");
    Expect(1, 126975, '\P{^Bc=r}', "");
    Expect(0, 126976, '\p{Bc=r}', "");
    Expect(1, 126976, '\p{^Bc=r}', "");
    Expect(1, 126976, '\P{Bc=r}', "");
    Expect(0, 126976, '\P{^Bc=r}', "");
    Expect(1, 126975, '\p{Bc=:\Ar\z:}', "");;
    Expect(0, 126976, '\p{Bc=:\Ar\z:}', "");;
    Expect(1, 126975, '\p{Bc: 	R}', "");
    Expect(0, 126975, '\p{^Bc: 	R}', "");
    Expect(0, 126975, '\P{Bc: 	R}', "");
    Expect(1, 126975, '\P{^Bc: 	R}', "");
    Expect(0, 126976, '\p{Bc: 	R}', "");
    Expect(1, 126976, '\p{^Bc: 	R}', "");
    Expect(1, 126976, '\P{Bc: 	R}', "");
    Expect(0, 126976, '\P{^Bc: 	R}', "");
    Error('\p{Is_Bidi_Class=/a/_right_TO_Left}');
    Error('\P{Is_Bidi_Class=/a/_right_TO_Left}');
    Expect(1, 126975, '\p{Is_Bidi_Class=righttoleft}', "");
    Expect(0, 126975, '\p{^Is_Bidi_Class=righttoleft}', "");
    Expect(0, 126975, '\P{Is_Bidi_Class=righttoleft}', "");
    Expect(1, 126975, '\P{^Is_Bidi_Class=righttoleft}', "");
    Expect(0, 126976, '\p{Is_Bidi_Class=righttoleft}', "");
    Expect(1, 126976, '\p{^Is_Bidi_Class=righttoleft}', "");
    Expect(1, 126976, '\P{Is_Bidi_Class=righttoleft}', "");
    Expect(0, 126976, '\P{^Is_Bidi_Class=righttoleft}', "");
    Expect(1, 126975, '\p{Is_Bidi_Class=-Right_To_Left}', "");
    Expect(0, 126975, '\p{^Is_Bidi_Class=-Right_To_Left}', "");
    Expect(0, 126975, '\P{Is_Bidi_Class=-Right_To_Left}', "");
    Expect(1, 126975, '\P{^Is_Bidi_Class=-Right_To_Left}', "");
    Expect(0, 126976, '\p{Is_Bidi_Class=-Right_To_Left}', "");
    Expect(1, 126976, '\p{^Is_Bidi_Class=-Right_To_Left}', "");
    Expect(1, 126976, '\P{Is_Bidi_Class=-Right_To_Left}', "");
    Expect(0, 126976, '\P{^Is_Bidi_Class=-Right_To_Left}', "");
    Error('\p{Is_Bc=-:=R}');
    Error('\P{Is_Bc=-:=R}');
    Expect(1, 126975, '\p{Is_Bc=r}', "");
    Expect(0, 126975, '\p{^Is_Bc=r}', "");
    Expect(0, 126975, '\P{Is_Bc=r}', "");
    Expect(1, 126975, '\P{^Is_Bc=r}', "");
    Expect(0, 126976, '\p{Is_Bc=r}', "");
    Expect(1, 126976, '\p{^Is_Bc=r}', "");
    Expect(1, 126976, '\P{Is_Bc=r}', "");
    Expect(0, 126976, '\P{^Is_Bc=r}', "");
    Expect(1, 126975, '\p{Is_Bc= R}', "");
    Expect(0, 126975, '\p{^Is_Bc= R}', "");
    Expect(0, 126975, '\P{Is_Bc= R}', "");
    Expect(1, 126975, '\P{^Is_Bc= R}', "");
    Expect(0, 126976, '\p{Is_Bc= R}', "");
    Expect(1, 126976, '\p{^Is_Bc= R}', "");
    Expect(1, 126976, '\P{Is_Bc= R}', "");
    Expect(0, 126976, '\P{^Is_Bc= R}', "");
    Error('\p{Bidi_Class=_Right_To_Left_Embedding:=}');
    Error('\P{Bidi_Class=_Right_To_Left_Embedding:=}');
    Expect(1, 8235, '\p{Bidi_Class=:\ARight_To_Left_Embedding\z:}', "");;
    Expect(0, 8236, '\p{Bidi_Class=:\ARight_To_Left_Embedding\z:}', "");;
    Expect(1, 8235, '\p{Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8235, '\p{^Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8235, '\P{Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8235, '\P{^Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8236, '\p{Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8236, '\p{^Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8236, '\P{Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8236, '\P{^Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8235, '\p{Bidi_Class=:\Arighttoleftembedding\z:}', "");;
    Expect(0, 8236, '\p{Bidi_Class=:\Arighttoleftembedding\z:}', "");;
    Expect(1, 8235, '\p{Bidi_Class=--right_to_LEFT_embedding}', "");
    Expect(0, 8235, '\p{^Bidi_Class=--right_to_LEFT_embedding}', "");
    Expect(0, 8235, '\P{Bidi_Class=--right_to_LEFT_embedding}', "");
    Expect(1, 8235, '\P{^Bidi_Class=--right_to_LEFT_embedding}', "");
    Expect(0, 8236, '\p{Bidi_Class=--right_to_LEFT_embedding}', "");
    Expect(1, 8236, '\p{^Bidi_Class=--right_to_LEFT_embedding}', "");
    Expect(1, 8236, '\P{Bidi_Class=--right_to_LEFT_embedding}', "");
    Expect(0, 8236, '\P{^Bidi_Class=--right_to_LEFT_embedding}', "");
    Error('\p{Bc=	RLE:=}');
    Error('\P{Bc=	RLE:=}');
    Expect(1, 8235, '\p{Bc=:\ARLE\z:}', "");;
    Expect(0, 8236, '\p{Bc=:\ARLE\z:}', "");;
    Expect(1, 8235, '\p{Bc=rle}', "");
    Expect(0, 8235, '\p{^Bc=rle}', "");
    Expect(0, 8235, '\P{Bc=rle}', "");
    Expect(1, 8235, '\P{^Bc=rle}', "");
    Expect(0, 8236, '\p{Bc=rle}', "");
    Expect(1, 8236, '\p{^Bc=rle}', "");
    Expect(1, 8236, '\P{Bc=rle}', "");
    Expect(0, 8236, '\P{^Bc=rle}', "");
    Expect(1, 8235, '\p{Bc=:\Arle\z:}', "");;
    Expect(0, 8236, '\p{Bc=:\Arle\z:}', "");;
    Expect(1, 8235, '\p{Bc=--RLE}', "");
    Expect(0, 8235, '\p{^Bc=--RLE}', "");
    Expect(0, 8235, '\P{Bc=--RLE}', "");
    Expect(1, 8235, '\P{^Bc=--RLE}', "");
    Expect(0, 8236, '\p{Bc=--RLE}', "");
    Expect(1, 8236, '\p{^Bc=--RLE}', "");
    Expect(1, 8236, '\P{Bc=--RLE}', "");
    Expect(0, 8236, '\P{^Bc=--RLE}', "");
    Error('\p{Is_Bidi_Class=_ Right_To_Left_embedding:=}');
    Error('\P{Is_Bidi_Class=_ Right_To_Left_embedding:=}');
    Expect(1, 8235, '\p{Is_Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8235, '\p{^Is_Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8235, '\P{Is_Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8235, '\P{^Is_Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8236, '\p{Is_Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8236, '\p{^Is_Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8236, '\P{Is_Bidi_Class=righttoleftembedding}', "");
    Expect(0, 8236, '\P{^Is_Bidi_Class=righttoleftembedding}', "");
    Expect(1, 8235, '\p{Is_Bidi_Class=_	Right_To_LEFT_Embedding}', "");
    Expect(0, 8235, '\p{^Is_Bidi_Class=_	Right_To_LEFT_Embedding}', "");
    Expect(0, 8235, '\P{Is_Bidi_Class=_	Right_To_LEFT_Embedding}', "");
    Expect(1, 8235, '\P{^Is_Bidi_Class=_	Right_To_LEFT_Embedding}', "");
    Expect(0, 8236, '\p{Is_Bidi_Class=_	Right_To_LEFT_Embedding}', "");
    Expect(1, 8236, '\p{^Is_Bidi_Class=_	Right_To_LEFT_Embedding}', "");
    Expect(1, 8236, '\P{Is_Bidi_Class=_	Right_To_LEFT_Embedding}', "");
    Expect(0, 8236, '\P{^Is_Bidi_Class=_	Right_To_LEFT_Embedding}', "");
    Error('\p{Is_Bc=	RLE/a/}');
    Error('\P{Is_Bc=	RLE/a/}');
    Expect(1, 8235, '\p{Is_Bc=rle}', "");
    Expect(0, 8235, '\p{^Is_Bc=rle}', "");
    Expect(0, 8235, '\P{Is_Bc=rle}', "");
    Expect(1, 8235, '\P{^Is_Bc=rle}', "");
    Expect(0, 8236, '\p{Is_Bc=rle}', "");
    Expect(1, 8236, '\p{^Is_Bc=rle}', "");
    Expect(1, 8236, '\P{Is_Bc=rle}', "");
    Expect(0, 8236, '\P{^Is_Bc=rle}', "");
    Expect(1, 8235, '\p{Is_Bc= 	RLE}', "");
    Expect(0, 8235, '\p{^Is_Bc= 	RLE}', "");
    Expect(0, 8235, '\P{Is_Bc= 	RLE}', "");
    Expect(1, 8235, '\P{^Is_Bc= 	RLE}', "");
    Expect(0, 8236, '\p{Is_Bc= 	RLE}', "");
    Expect(1, 8236, '\p{^Is_Bc= 	RLE}', "");
    Expect(1, 8236, '\P{Is_Bc= 	RLE}', "");
    Expect(0, 8236, '\P{^Is_Bc= 	RLE}', "");
    Error('\p{Bidi_Class=/a/ RIGHT_TO_LEFT_isolate}');
    Error('\P{Bidi_Class=/a/ RIGHT_TO_LEFT_isolate}');
    Expect(1, 8295, '\p{Bidi_Class=:\ARight_To_Left_Isolate\z:}', "");;
    Expect(0, 8296, '\p{Bidi_Class=:\ARight_To_Left_Isolate\z:}', "");;
    Expect(1, 8295, '\p{Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8295, '\p{^Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8295, '\P{Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8295, '\P{^Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8296, '\p{Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8296, '\p{^Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8296, '\P{Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8296, '\P{^Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8295, '\p{Bidi_Class=:\Arighttoleftisolate\z:}', "");;
    Expect(0, 8296, '\p{Bidi_Class=:\Arighttoleftisolate\z:}', "");;
    Expect(1, 8295, '\p{Bidi_Class=_ RIGHT_To_Left_Isolate}', "");
    Expect(0, 8295, '\p{^Bidi_Class=_ RIGHT_To_Left_Isolate}', "");
    Expect(0, 8295, '\P{Bidi_Class=_ RIGHT_To_Left_Isolate}', "");
    Expect(1, 8295, '\P{^Bidi_Class=_ RIGHT_To_Left_Isolate}', "");
    Expect(0, 8296, '\p{Bidi_Class=_ RIGHT_To_Left_Isolate}', "");
    Expect(1, 8296, '\p{^Bidi_Class=_ RIGHT_To_Left_Isolate}', "");
    Expect(1, 8296, '\P{Bidi_Class=_ RIGHT_To_Left_Isolate}', "");
    Expect(0, 8296, '\P{^Bidi_Class=_ RIGHT_To_Left_Isolate}', "");
    Error('\p{Bc=-_rli:=}');
    Error('\P{Bc=-_rli:=}');
    Expect(1, 8295, '\p{Bc=:\ARLI\z:}', "");;
    Expect(0, 8296, '\p{Bc=:\ARLI\z:}', "");;
    Expect(1, 8295, '\p{Bc=rli}', "");
    Expect(0, 8295, '\p{^Bc=rli}', "");
    Expect(0, 8295, '\P{Bc=rli}', "");
    Expect(1, 8295, '\P{^Bc=rli}', "");
    Expect(0, 8296, '\p{Bc=rli}', "");
    Expect(1, 8296, '\p{^Bc=rli}', "");
    Expect(1, 8296, '\P{Bc=rli}', "");
    Expect(0, 8296, '\P{^Bc=rli}', "");
    Expect(1, 8295, '\p{Bc=:\Arli\z:}', "");;
    Expect(0, 8296, '\p{Bc=:\Arli\z:}', "");;
    Expect(1, 8295, '\p{Bc: -rli}', "");
    Expect(0, 8295, '\p{^Bc: -rli}', "");
    Expect(0, 8295, '\P{Bc: -rli}', "");
    Expect(1, 8295, '\P{^Bc: -rli}', "");
    Expect(0, 8296, '\p{Bc: -rli}', "");
    Expect(1, 8296, '\p{^Bc: -rli}', "");
    Expect(1, 8296, '\P{Bc: -rli}', "");
    Expect(0, 8296, '\P{^Bc: -rli}', "");
    Error('\p{Is_Bidi_Class=RIGHT_to_LEFT_Isolate/a/}');
    Error('\P{Is_Bidi_Class=RIGHT_to_LEFT_Isolate/a/}');
    Expect(1, 8295, '\p{Is_Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8295, '\p{^Is_Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8295, '\P{Is_Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8295, '\P{^Is_Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8296, '\p{Is_Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8296, '\p{^Is_Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8296, '\P{Is_Bidi_Class=righttoleftisolate}', "");
    Expect(0, 8296, '\P{^Is_Bidi_Class=righttoleftisolate}', "");
    Expect(1, 8295, '\p{Is_Bidi_Class=_	right_to_Left_isolate}', "");
    Expect(0, 8295, '\p{^Is_Bidi_Class=_	right_to_Left_isolate}', "");
    Expect(0, 8295, '\P{Is_Bidi_Class=_	right_to_Left_isolate}', "");
    Expect(1, 8295, '\P{^Is_Bidi_Class=_	right_to_Left_isolate}', "");
    Expect(0, 8296, '\p{Is_Bidi_Class=_	right_to_Left_isolate}', "");
    Expect(1, 8296, '\p{^Is_Bidi_Class=_	right_to_Left_isolate}', "");
    Expect(1, 8296, '\P{Is_Bidi_Class=_	right_to_Left_isolate}', "");
    Expect(0, 8296, '\P{^Is_Bidi_Class=_	right_to_Left_isolate}', "");
    Error('\p{Is_Bc=/a/ 	RLI}');
    Error('\P{Is_Bc=/a/ 	RLI}');
    Expect(1, 8295, '\p{Is_Bc=rli}', "");
    Expect(0, 8295, '\p{^Is_Bc=rli}', "");
    Expect(0, 8295, '\P{Is_Bc=rli}', "");
    Expect(1, 8295, '\P{^Is_Bc=rli}', "");
    Expect(0, 8296, '\p{Is_Bc=rli}', "");
    Expect(1, 8296, '\p{^Is_Bc=rli}', "");
    Expect(1, 8296, '\P{Is_Bc=rli}', "");
    Expect(0, 8296, '\P{^Is_Bc=rli}', "");
    Expect(1, 8295, '\p{Is_Bc:	RLI}', "");
    Expect(0, 8295, '\p{^Is_Bc:	RLI}', "");
    Expect(0, 8295, '\P{Is_Bc:	RLI}', "");
    Expect(1, 8295, '\P{^Is_Bc:	RLI}', "");
    Expect(0, 8296, '\p{Is_Bc:	RLI}', "");
    Expect(1, 8296, '\p{^Is_Bc:	RLI}', "");
    Expect(1, 8296, '\P{Is_Bc:	RLI}', "");
    Expect(0, 8296, '\P{^Is_Bc:	RLI}', "");
    Error('\p{Bidi_Class=/a/	Right_TO_LEFT_Override}');
    Error('\P{Bidi_Class=/a/	Right_TO_LEFT_Override}');
    Expect(1, 8238, '\p{Bidi_Class=:\ARight_To_Left_Override\z:}', "");;
    Expect(0, 8239, '\p{Bidi_Class=:\ARight_To_Left_Override\z:}', "");;
    Expect(1, 8238, '\p{Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8238, '\p{^Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8238, '\P{Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8238, '\P{^Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8239, '\p{Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8239, '\p{^Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8239, '\P{Bidi_Class=righttoleftoverride}', "");
    Expect(0, 8239, '\P{^Bidi_Class=righttoleftoverride}', "");
    Expect(1, 8238, '\p{Bidi_Class=:\Arighttoleftoverride\z:}', "");;
    Expect(0, 8239, '\p{Bidi_Class=:\Arighttoleftoverride\z:}', "");;
    Expect(1, 8238, '\p{Bidi_Class=  Right_TO_Left_override}', "");
    Expect(0, 8238, '\p{^Bidi_Class=  Right_TO_Left_override}', "");
    Expect(0, 8238, '\P{Bidi_Class=  Right_TO_Left_override}', "");
    Expect(1, 8238, '\P{^Bidi_Class=  Right_TO_Left_override}', "");
    Expect(0, 8239, '\p{Bidi_Class=  Right_TO_Left_override}', "");
    Expect(1, 8239, '\p{^Bidi_Class=  Right_TO_Left_override}', "");
    Expect(1, 8239, '\P{Bidi_Class=  Right_TO_Left_override}', "");
    Expect(0, 8239, '\P{^Bidi_Class=  Right_TO_Left_override}', "");
    Error('\p{Bc= -RLO/a/}');
    Error('\P{Bc= -RLO/a/}');
    Expect(1, 8238, '\p{Bc=:\ARLO\z:}', "");;
    Expect(0, 8239, '\p{Bc=:\ARLO\z:}', "");;
    Expect(1, 8238, '\p{Bc=rlo}', "");
    Expect(0, 8238, '\p{^Bc=rlo}', "");
    Expect(0, 8238, '\P{Bc=rlo}', "");
    Expect(1, 8238, '\P{^Bc=rlo}', "");
    Expect(0, 8239, '\p{Bc=rlo}', "");
    Expect(1, 8239, '\p{^Bc=rlo}', "");
    Expect(1, 8239, '\P{Bc=rlo}', "");
    Expect(0, 8239, '\P{^Bc=rlo}', "");
    Expect(1, 8238, '\p{Bc=:\Arlo\z:}', "");;
    Expect(0, 8239, '\p{Bc=:\Arlo\z:}', "");;
    Expect(1, 8238, '\p{Bc= rlo}', "");
    Expect(0, 8238, '\p{^Bc= rlo}', "");
    Expect(0, 8238, '\P{Bc= rlo}', "");
    Expect(1, 8238, '\P{^Bc= rlo}', "");
    Expect(0, 8239, '\p{Bc= rlo}', "");
    Expect(1, 8239, '\p{^Bc= rlo}', "");
    Expect(1, 8239, '\P{Bc= rlo}', "");
    Expect(0, 8239, '\P{^Bc= rlo}', "");
    Error('\p{Is_Bidi_Class= 	RIGHT_To_LEFT_OVERRIDE/a/}');
    Error('\P{Is_Bidi_Class= 	RIGHT_To_LEFT_OVERRIDE/a/}');
    Expect(1, 8238, '\p{Is_Bidi_Class:righttoleftoverride}', "");
    Expect(0, 8238, '\p{^Is_Bidi_Class:righttoleftoverride}', "");
    Expect(0, 8238, '\P{Is_Bidi_Class:righttoleftoverride}', "");
    Expect(1, 8238, '\P{^Is_Bidi_Class:righttoleftoverride}', "");
    Expect(0, 8239, '\p{Is_Bidi_Class:righttoleftoverride}', "");
    Expect(1, 8239, '\p{^Is_Bidi_Class:righttoleftoverride}', "");
    Expect(1, 8239, '\P{Is_Bidi_Class:righttoleftoverride}', "");
    Expect(0, 8239, '\P{^Is_Bidi_Class:righttoleftoverride}', "");
    Expect(1, 8238, '\p{Is_Bidi_Class=  RIGHT_to_Left_Override}', "");
    Expect(0, 8238, '\p{^Is_Bidi_Class=  RIGHT_to_Left_Override}', "");
    Expect(0, 8238, '\P{Is_Bidi_Class=  RIGHT_to_Left_Override}', "");
    Expect(1, 8238, '\P{^Is_Bidi_Class=  RIGHT_to_Left_Override}', "");
    Expect(0, 8239, '\p{Is_Bidi_Class=  RIGHT_to_Left_Override}', "");
    Expect(1, 8239, '\p{^Is_Bidi_Class=  RIGHT_to_Left_Override}', "");
    Expect(1, 8239, '\P{Is_Bidi_Class=  RIGHT_to_Left_Override}', "");
    Expect(0, 8239, '\P{^Is_Bidi_Class=  RIGHT_to_Left_Override}', "");
    Error('\p{Is_Bc=:=	-rlo}');
    Error('\P{Is_Bc=:=	-rlo}');
    Expect(1, 8238, '\p{Is_Bc=rlo}', "");
    Expect(0, 8238, '\p{^Is_Bc=rlo}', "");
    Expect(0, 8238, '\P{Is_Bc=rlo}', "");
    Expect(1, 8238, '\P{^Is_Bc=rlo}', "");
    Expect(0, 8239, '\p{Is_Bc=rlo}', "");
    Expect(1, 8239, '\p{^Is_Bc=rlo}', "");
    Expect(1, 8239, '\P{Is_Bc=rlo}', "");
    Expect(0, 8239, '\P{^Is_Bc=rlo}', "");
    Expect(1, 8238, '\p{Is_Bc=-	RLO}', "");
    Expect(0, 8238, '\p{^Is_Bc=-	RLO}', "");
    Expect(0, 8238, '\P{Is_Bc=-	RLO}', "");
    Expect(1, 8238, '\P{^Is_Bc=-	RLO}', "");
    Expect(0, 8239, '\p{Is_Bc=-	RLO}', "");
    Expect(1, 8239, '\p{^Is_Bc=-	RLO}', "");
    Expect(1, 8239, '\P{Is_Bc=-	RLO}', "");
    Expect(0, 8239, '\P{^Is_Bc=-	RLO}', "");
    Error('\p{Bidi_Class= Segment_separator/a/}');
    Error('\P{Bidi_Class= Segment_separator/a/}');
    Expect(1, 31, '\p{Bidi_Class=:\ASegment_Separator\z:}', "");;
    Expect(0, 32, '\p{Bidi_Class=:\ASegment_Separator\z:}', "");;
    Expect(1, 31, '\p{Bidi_Class=segmentseparator}', "");
    Expect(0, 31, '\p{^Bidi_Class=segmentseparator}', "");
    Expect(0, 31, '\P{Bidi_Class=segmentseparator}', "");
    Expect(1, 31, '\P{^Bidi_Class=segmentseparator}', "");
    Expect(0, 32, '\p{Bidi_Class=segmentseparator}', "");
    Expect(1, 32, '\p{^Bidi_Class=segmentseparator}', "");
    Expect(1, 32, '\P{Bidi_Class=segmentseparator}', "");
    Expect(0, 32, '\P{^Bidi_Class=segmentseparator}', "");
    Expect(1, 31, '\p{Bidi_Class=:\Asegmentseparator\z:}', "");;
    Expect(0, 32, '\p{Bidi_Class=:\Asegmentseparator\z:}', "");;
    Expect(1, 31, '\p{Bidi_Class=	SEGMENT_Separator}', "");
    Expect(0, 31, '\p{^Bidi_Class=	SEGMENT_Separator}', "");
    Expect(0, 31, '\P{Bidi_Class=	SEGMENT_Separator}', "");
    Expect(1, 31, '\P{^Bidi_Class=	SEGMENT_Separator}', "");
    Expect(0, 32, '\p{Bidi_Class=	SEGMENT_Separator}', "");
    Expect(1, 32, '\p{^Bidi_Class=	SEGMENT_Separator}', "");
    Expect(1, 32, '\P{Bidi_Class=	SEGMENT_Separator}', "");
    Expect(0, 32, '\P{^Bidi_Class=	SEGMENT_Separator}', "");
    Error('\p{Bc=/a/-	S}');
    Error('\P{Bc=/a/-	S}');
    Expect(1, 31, '\p{Bc=:\AS\z:}', "");;
    Expect(0, 32, '\p{Bc=:\AS\z:}', "");;
    Expect(1, 31, '\p{Bc=s}', "");
    Expect(0, 31, '\p{^Bc=s}', "");
    Expect(0, 31, '\P{Bc=s}', "");
    Expect(1, 31, '\P{^Bc=s}', "");
    Expect(0, 32, '\p{Bc=s}', "");
    Expect(1, 32, '\p{^Bc=s}', "");
    Expect(1, 32, '\P{Bc=s}', "");
    Expect(0, 32, '\P{^Bc=s}', "");
    Expect(1, 31, '\p{Bc=:\As\z:}', "");;
    Expect(0, 32, '\p{Bc=:\As\z:}', "");;
    Expect(1, 31, '\p{Bc=-s}', "");
    Expect(0, 31, '\p{^Bc=-s}', "");
    Expect(0, 31, '\P{Bc=-s}', "");
    Expect(1, 31, '\P{^Bc=-s}', "");
    Expect(0, 32, '\p{Bc=-s}', "");
    Expect(1, 32, '\p{^Bc=-s}', "");
    Expect(1, 32, '\P{Bc=-s}', "");
    Expect(0, 32, '\P{^Bc=-s}', "");
    Error('\p{Is_Bidi_Class=	_Segment_Separator:=}');
    Error('\P{Is_Bidi_Class=	_Segment_Separator:=}');
    Expect(1, 31, '\p{Is_Bidi_Class=segmentseparator}', "");
    Expect(0, 31, '\p{^Is_Bidi_Class=segmentseparator}', "");
    Expect(0, 31, '\P{Is_Bidi_Class=segmentseparator}', "");
    Expect(1, 31, '\P{^Is_Bidi_Class=segmentseparator}', "");
    Expect(0, 32, '\p{Is_Bidi_Class=segmentseparator}', "");
    Expect(1, 32, '\p{^Is_Bidi_Class=segmentseparator}', "");
    Expect(1, 32, '\P{Is_Bidi_Class=segmentseparator}', "");
    Expect(0, 32, '\P{^Is_Bidi_Class=segmentseparator}', "");
    Expect(1, 31, '\p{Is_Bidi_Class=  Segment_Separator}', "");
    Expect(0, 31, '\p{^Is_Bidi_Class=  Segment_Separator}', "");
    Expect(0, 31, '\P{Is_Bidi_Class=  Segment_Separator}', "");
    Expect(1, 31, '\P{^Is_Bidi_Class=  Segment_Separator}', "");
    Expect(0, 32, '\p{Is_Bidi_Class=  Segment_Separator}', "");
    Expect(1, 32, '\p{^Is_Bidi_Class=  Segment_Separator}', "");
    Expect(1, 32, '\P{Is_Bidi_Class=  Segment_Separator}', "");
    Expect(0, 32, '\P{^Is_Bidi_Class=  Segment_Separator}', "");
    Error('\p{Is_Bc=-:=S}');
    Error('\P{Is_Bc=-:=S}');
    Expect(1, 31, '\p{Is_Bc=s}', "");
    Expect(0, 31, '\p{^Is_Bc=s}', "");
    Expect(0, 31, '\P{Is_Bc=s}', "");
    Expect(1, 31, '\P{^Is_Bc=s}', "");
    Expect(0, 32, '\p{Is_Bc=s}', "");
    Expect(1, 32, '\p{^Is_Bc=s}', "");
    Expect(1, 32, '\P{Is_Bc=s}', "");
    Expect(0, 32, '\P{^Is_Bc=s}', "");
    Expect(1, 31, '\p{Is_Bc=_S}', "");
    Expect(0, 31, '\p{^Is_Bc=_S}', "");
    Expect(0, 31, '\P{Is_Bc=_S}', "");
    Expect(1, 31, '\P{^Is_Bc=_S}', "");
    Expect(0, 32, '\p{Is_Bc=_S}', "");
    Expect(1, 32, '\p{^Is_Bc=_S}', "");
    Expect(1, 32, '\P{Is_Bc=_S}', "");
    Expect(0, 32, '\P{^Is_Bc=_S}', "");
    Error('\p{Bidi_Class=/a/- White_Space}');
    Error('\P{Bidi_Class=/a/- White_Space}');
    Expect(1, 12288, '\p{Bidi_Class=:\AWhite_Space\z:}', "");;
    Expect(0, 12289, '\p{Bidi_Class=:\AWhite_Space\z:}', "");;
    Expect(1, 12288, '\p{Bidi_Class=whitespace}', "");
    Expect(0, 12288, '\p{^Bidi_Class=whitespace}', "");
    Expect(0, 12288, '\P{Bidi_Class=whitespace}', "");
    Expect(1, 12288, '\P{^Bidi_Class=whitespace}', "");
    Expect(0, 12289, '\p{Bidi_Class=whitespace}', "");
    Expect(1, 12289, '\p{^Bidi_Class=whitespace}', "");
    Expect(1, 12289, '\P{Bidi_Class=whitespace}', "");
    Expect(0, 12289, '\P{^Bidi_Class=whitespace}', "");
    Expect(1, 12288, '\p{Bidi_Class=:\Awhitespace\z:}', "");;
    Expect(0, 12289, '\p{Bidi_Class=:\Awhitespace\z:}', "");;
    Expect(1, 12288, '\p{Bidi_Class= _White_Space}', "");
    Expect(0, 12288, '\p{^Bidi_Class= _White_Space}', "");
    Expect(0, 12288, '\P{Bidi_Class= _White_Space}', "");
    Expect(1, 12288, '\P{^Bidi_Class= _White_Space}', "");
    Expect(0, 12289, '\p{Bidi_Class= _White_Space}', "");
    Expect(1, 12289, '\p{^Bidi_Class= _White_Space}', "");
    Expect(1, 12289, '\P{Bidi_Class= _White_Space}', "");
    Expect(0, 12289, '\P{^Bidi_Class= _White_Space}', "");
    Error('\p{Bc=--ws:=}');
    Error('\P{Bc=--ws:=}');
    Expect(1, 12288, '\p{Bc=:\AWS\z:}', "");;
    Expect(0, 12289, '\p{Bc=:\AWS\z:}', "");;
    Expect(1, 12288, '\p{Bc=ws}', "");
    Expect(0, 12288, '\p{^Bc=ws}', "");
    Expect(0, 12288, '\P{Bc=ws}', "");
    Expect(1, 12288, '\P{^Bc=ws}', "");
    Expect(0, 12289, '\p{Bc=ws}', "");
    Expect(1, 12289, '\p{^Bc=ws}', "");
    Expect(1, 12289, '\P{Bc=ws}', "");
    Expect(0, 12289, '\P{^Bc=ws}', "");
    Expect(1, 12288, '\p{Bc=:\Aws\z:}', "");;
    Expect(0, 12289, '\p{Bc=:\Aws\z:}', "");;
    Expect(1, 12288, '\p{Bc=WS}', "");
    Expect(0, 12288, '\p{^Bc=WS}', "");
    Expect(0, 12288, '\P{Bc=WS}', "");
    Expect(1, 12288, '\P{^Bc=WS}', "");
    Expect(0, 12289, '\p{Bc=WS}', "");
    Expect(1, 12289, '\p{^Bc=WS}', "");
    Expect(1, 12289, '\P{Bc=WS}', "");
    Expect(0, 12289, '\P{^Bc=WS}', "");
    Error('\p{Is_Bidi_Class=:= WHITE_Space}');
    Error('\P{Is_Bidi_Class=:= WHITE_Space}');
    Expect(1, 12288, '\p{Is_Bidi_Class=whitespace}', "");
    Expect(0, 12288, '\p{^Is_Bidi_Class=whitespace}', "");
    Expect(0, 12288, '\P{Is_Bidi_Class=whitespace}', "");
    Expect(1, 12288, '\P{^Is_Bidi_Class=whitespace}', "");
    Expect(0, 12289, '\p{Is_Bidi_Class=whitespace}', "");
    Expect(1, 12289, '\p{^Is_Bidi_Class=whitespace}', "");
    Expect(1, 12289, '\P{Is_Bidi_Class=whitespace}', "");
    Expect(0, 12289, '\P{^Is_Bidi_Class=whitespace}', "");
    Expect(1, 12288, '\p{Is_Bidi_Class=_white_Space}', "");
    Expect(0, 12288, '\p{^Is_Bidi_Class=_white_Space}', "");
    Expect(0, 12288, '\P{Is_Bidi_Class=_white_Space}', "");
    Expect(1, 12288, '\P{^Is_Bidi_Class=_white_Space}', "");
    Expect(0, 12289, '\p{Is_Bidi_Class=_white_Space}', "");
    Expect(1, 12289, '\p{^Is_Bidi_Class=_white_Space}', "");
    Expect(1, 12289, '\P{Is_Bidi_Class=_white_Space}', "");
    Expect(0, 12289, '\P{^Is_Bidi_Class=_white_Space}', "");
    Error('\p{Is_Bc= /a/ws}');
    Error('\P{Is_Bc= /a/ws}');
    Expect(1, 12288, '\p{Is_Bc=ws}', "");
    Expect(0, 12288, '\p{^Is_Bc=ws}', "");
    Expect(0, 12288, '\P{Is_Bc=ws}', "");
    Expect(1, 12288, '\P{^Is_Bc=ws}', "");
    Expect(0, 12289, '\p{Is_Bc=ws}', "");
    Expect(1, 12289, '\p{^Is_Bc=ws}', "");
    Expect(1, 12289, '\P{Is_Bc=ws}', "");
    Expect(0, 12289, '\P{^Is_Bc=ws}', "");
    Expect(1, 12288, '\p{Is_Bc=	_WS}', "");
    Expect(0, 12288, '\p{^Is_Bc=	_WS}', "");
    Expect(0, 12288, '\P{Is_Bc=	_WS}', "");
    Expect(1, 12288, '\P{^Is_Bc=	_WS}', "");
    Expect(0, 12289, '\p{Is_Bc=	_WS}', "");
    Expect(1, 12289, '\p{^Is_Bc=	_WS}', "");
    Expect(1, 12289, '\P{Is_Bc=	_WS}', "");
    Expect(0, 12289, '\P{^Is_Bc=	_WS}', "");
    Error('\p{Bidi_Control=	/a/NO}');
    Error('\P{Bidi_Control=	/a/NO}');
    Expect(1, 8298, '\p{Bidi_Control=:\ANo\z:}', "");;
    Expect(0, 8297, '\p{Bidi_Control=:\ANo\z:}', "");;
    Expect(1, 8298, '\p{Bidi_Control=no}', "");
    Expect(0, 8298, '\p{^Bidi_Control=no}', "");
    Expect(0, 8298, '\P{Bidi_Control=no}', "");
    Expect(1, 8298, '\P{^Bidi_Control=no}', "");
    Expect(0, 8297, '\p{Bidi_Control=no}', "");
    Expect(1, 8297, '\p{^Bidi_Control=no}', "");
    Expect(1, 8297, '\P{Bidi_Control=no}', "");
    Expect(0, 8297, '\P{^Bidi_Control=no}', "");
    Expect(1, 8298, '\p{Bidi_Control=:\Ano\z:}', "");;
    Expect(0, 8297, '\p{Bidi_Control=:\Ano\z:}', "");;
    Expect(1, 8298, '\p{Bidi_Control:--NO}', "");
    Expect(0, 8298, '\p{^Bidi_Control:--NO}', "");
    Expect(0, 8298, '\P{Bidi_Control:--NO}', "");
    Expect(1, 8298, '\P{^Bidi_Control:--NO}', "");
    Expect(0, 8297, '\p{Bidi_Control:--NO}', "");
    Expect(1, 8297, '\p{^Bidi_Control:--NO}', "");
    Expect(1, 8297, '\P{Bidi_Control:--NO}', "");
    Expect(0, 8297, '\P{^Bidi_Control:--NO}', "");
    Error('\p{Bidi_C=_/a/N}');
    Error('\P{Bidi_C=_/a/N}');
    Expect(1, 8298, '\p{Bidi_C=:\AN\z:}', "");;
    Expect(0, 8297, '\p{Bidi_C=:\AN\z:}', "");;
    Expect(1, 8298, '\p{Bidi_C: n}', "");
    Expect(0, 8298, '\p{^Bidi_C: n}', "");
    Expect(0, 8298, '\P{Bidi_C: n}', "");
    Expect(1, 8298, '\P{^Bidi_C: n}', "");
    Expect(0, 8297, '\p{Bidi_C: n}', "");
    Expect(1, 8297, '\p{^Bidi_C: n}', "");
    Expect(1, 8297, '\P{Bidi_C: n}', "");
    Expect(0, 8297, '\P{^Bidi_C: n}', "");
    Expect(1, 8298, '\p{Bidi_C=:\An\z:}', "");;
    Expect(0, 8297, '\p{Bidi_C=:\An\z:}', "");;
    Expect(1, 8298, '\p{Bidi_C=_ n}', "");
    Expect(0, 8298, '\p{^Bidi_C=_ n}', "");
    Expect(0, 8298, '\P{Bidi_C=_ n}', "");
    Expect(1, 8298, '\P{^Bidi_C=_ n}', "");
    Expect(0, 8297, '\p{Bidi_C=_ n}', "");
    Expect(1, 8297, '\p{^Bidi_C=_ n}', "");
    Expect(1, 8297, '\P{Bidi_C=_ n}', "");
    Expect(0, 8297, '\P{^Bidi_C=_ n}', "");
    Error('\p{Is_Bidi_Control=_F/a/}');
    Error('\P{Is_Bidi_Control=_F/a/}');
    Expect(1, 8298, '\p{Is_Bidi_Control=f}', "");
    Expect(0, 8298, '\p{^Is_Bidi_Control=f}', "");
    Expect(0, 8298, '\P{Is_Bidi_Control=f}', "");
    Expect(1, 8298, '\P{^Is_Bidi_Control=f}', "");
    Expect(0, 8297, '\p{Is_Bidi_Control=f}', "");
    Expect(1, 8297, '\p{^Is_Bidi_Control=f}', "");
    Expect(1, 8297, '\P{Is_Bidi_Control=f}', "");
    Expect(0, 8297, '\P{^Is_Bidi_Control=f}', "");
    Expect(1, 8298, '\p{Is_Bidi_Control=-_F}', "");
    Expect(0, 8298, '\p{^Is_Bidi_Control=-_F}', "");
    Expect(0, 8298, '\P{Is_Bidi_Control=-_F}', "");
    Expect(1, 8298, '\P{^Is_Bidi_Control=-_F}', "");
    Expect(0, 8297, '\p{Is_Bidi_Control=-_F}', "");
    Expect(1, 8297, '\p{^Is_Bidi_Control=-_F}', "");
    Expect(1, 8297, '\P{Is_Bidi_Control=-_F}', "");
    Expect(0, 8297, '\P{^Is_Bidi_Control=-_F}', "");
    Error('\p{Is_Bidi_C=:=  false}');
    Error('\P{Is_Bidi_C=:=  false}');
    Expect(1, 8298, '\p{Is_Bidi_C=false}', "");
    Expect(0, 8298, '\p{^Is_Bidi_C=false}', "");
    Expect(0, 8298, '\P{Is_Bidi_C=false}', "");
    Expect(1, 8298, '\P{^Is_Bidi_C=false}', "");
    Expect(0, 8297, '\p{Is_Bidi_C=false}', "");
    Expect(1, 8297, '\p{^Is_Bidi_C=false}', "");
    Expect(1, 8297, '\P{Is_Bidi_C=false}', "");
    Expect(0, 8297, '\P{^Is_Bidi_C=false}', "");
    Expect(1, 8298, '\p{Is_Bidi_C=_	False}', "");
    Expect(0, 8298, '\p{^Is_Bidi_C=_	False}', "");
    Expect(0, 8298, '\P{Is_Bidi_C=_	False}', "");
    Expect(1, 8298, '\P{^Is_Bidi_C=_	False}', "");
    Expect(0, 8297, '\p{Is_Bidi_C=_	False}', "");
    Expect(1, 8297, '\p{^Is_Bidi_C=_	False}', "");
    Expect(1, 8297, '\P{Is_Bidi_C=_	False}', "");
    Expect(0, 8297, '\P{^Is_Bidi_C=_	False}', "");
    Error('\p{Bidi_Control=/a/-	Yes}');
    Error('\P{Bidi_Control=/a/-	Yes}');
    Expect(1, 8297, '\p{Bidi_Control=:\AYes\z:}', "");;
    Expect(0, 8298, '\p{Bidi_Control=:\AYes\z:}', "");;
    Expect(1, 8297, '\p{Bidi_Control=yes}', "");
    Expect(0, 8297, '\p{^Bidi_Control=yes}', "");
    Expect(0, 8297, '\P{Bidi_Control=yes}', "");
    Expect(1, 8297, '\P{^Bidi_Control=yes}', "");
    Expect(0, 8298, '\p{Bidi_Control=yes}', "");
    Expect(1, 8298, '\p{^Bidi_Control=yes}', "");
    Expect(1, 8298, '\P{Bidi_Control=yes}', "");
    Expect(0, 8298, '\P{^Bidi_Control=yes}', "");
    Expect(1, 8297, '\p{Bidi_Control=:\Ayes\z:}', "");;
    Expect(0, 8298, '\p{Bidi_Control=:\Ayes\z:}', "");;
    Expect(1, 8297, '\p{Bidi_Control=Yes}', "");
    Expect(0, 8297, '\p{^Bidi_Control=Yes}', "");
    Expect(0, 8297, '\P{Bidi_Control=Yes}', "");
    Expect(1, 8297, '\P{^Bidi_Control=Yes}', "");
    Expect(0, 8298, '\p{Bidi_Control=Yes}', "");
    Expect(1, 8298, '\p{^Bidi_Control=Yes}', "");
    Expect(1, 8298, '\P{Bidi_Control=Yes}', "");
    Expect(0, 8298, '\P{^Bidi_Control=Yes}', "");
    Error('\p{Bidi_C=:=y}');
    Error('\P{Bidi_C=:=y}');
    Expect(1, 8297, '\p{Bidi_C=:\AY\z:}', "");;
    Expect(0, 8298, '\p{Bidi_C=:\AY\z:}', "");;
    Expect(1, 8297, '\p{Bidi_C=y}', "");
    Expect(0, 8297, '\p{^Bidi_C=y}', "");
    Expect(0, 8297, '\P{Bidi_C=y}', "");
    Expect(1, 8297, '\P{^Bidi_C=y}', "");
    Expect(0, 8298, '\p{Bidi_C=y}', "");
    Expect(1, 8298, '\p{^Bidi_C=y}', "");
    Expect(1, 8298, '\P{Bidi_C=y}', "");
    Expect(0, 8298, '\P{^Bidi_C=y}', "");
    Expect(1, 8297, '\p{Bidi_C=:\Ay\z:}', "");;
    Expect(0, 8298, '\p{Bidi_C=:\Ay\z:}', "");;
    Expect(1, 8297, '\p{Bidi_C:	 _Y}', "");
    Expect(0, 8297, '\p{^Bidi_C:	 _Y}', "");
    Expect(0, 8297, '\P{Bidi_C:	 _Y}', "");
    Expect(1, 8297, '\P{^Bidi_C:	 _Y}', "");
    Expect(0, 8298, '\p{Bidi_C:	 _Y}', "");
    Expect(1, 8298, '\p{^Bidi_C:	 _Y}', "");
    Expect(1, 8298, '\P{Bidi_C:	 _Y}', "");
    Expect(0, 8298, '\P{^Bidi_C:	 _Y}', "");
    Error('\p{Is_Bidi_Control=:=T}');
    Error('\P{Is_Bidi_Control=:=T}');
    Expect(1, 8297, '\p{Is_Bidi_Control=t}', "");
    Expect(0, 8297, '\p{^Is_Bidi_Control=t}', "");
    Expect(0, 8297, '\P{Is_Bidi_Control=t}', "");
    Expect(1, 8297, '\P{^Is_Bidi_Control=t}', "");
    Expect(0, 8298, '\p{Is_Bidi_Control=t}', "");
    Expect(1, 8298, '\p{^Is_Bidi_Control=t}', "");
    Expect(1, 8298, '\P{Is_Bidi_Control=t}', "");
    Expect(0, 8298, '\P{^Is_Bidi_Control=t}', "");
    Expect(1, 8297, '\p{Is_Bidi_Control=	 T}', "");
    Expect(0, 8297, '\p{^Is_Bidi_Control=	 T}', "");
    Expect(0, 8297, '\P{Is_Bidi_Control=	 T}', "");
    Expect(1, 8297, '\P{^Is_Bidi_Control=	 T}', "");
    Expect(0, 8298, '\p{Is_Bidi_Control=	 T}', "");
    Expect(1, 8298, '\p{^Is_Bidi_Control=	 T}', "");
    Expect(1, 8298, '\P{Is_Bidi_Control=	 T}', "");
    Expect(0, 8298, '\P{^Is_Bidi_Control=	 T}', "");
    Error('\p{Is_Bidi_C=True/a/}');
    Error('\P{Is_Bidi_C=True/a/}');
    Expect(1, 8297, '\p{Is_Bidi_C=true}', "");
    Expect(0, 8297, '\p{^Is_Bidi_C=true}', "");
    Expect(0, 8297, '\P{Is_Bidi_C=true}', "");
    Expect(1, 8297, '\P{^Is_Bidi_C=true}', "");
    Expect(0, 8298, '\p{Is_Bidi_C=true}', "");
    Expect(1, 8298, '\p{^Is_Bidi_C=true}', "");
    Expect(1, 8298, '\P{Is_Bidi_C=true}', "");
    Expect(0, 8298, '\P{^Is_Bidi_C=true}', "");
    Expect(1, 8297, '\p{Is_Bidi_C=__TRUE}', "");
    Expect(0, 8297, '\p{^Is_Bidi_C=__TRUE}', "");
    Expect(0, 8297, '\P{Is_Bidi_C=__TRUE}', "");
    Expect(1, 8297, '\P{^Is_Bidi_C=__TRUE}', "");
    Expect(0, 8298, '\p{Is_Bidi_C=__TRUE}', "");
    Expect(1, 8298, '\p{^Is_Bidi_C=__TRUE}', "");
    Expect(1, 8298, '\P{Is_Bidi_C=__TRUE}', "");
    Expect(0, 8298, '\P{^Is_Bidi_C=__TRUE}', "");
    Error('\p{Bidi_Mirrored=/a/_no}');
    Error('\P{Bidi_Mirrored=/a/_no}');
    Expect(1, 120772, '\p{Bidi_Mirrored=:\ANo\z:}', "");;
    Expect(0, 120771, '\p{Bidi_Mirrored=:\ANo\z:}', "");;
    Expect(1, 120772, '\p{Bidi_Mirrored=no}', "");
    Expect(0, 120772, '\p{^Bidi_Mirrored=no}', "");
    Expect(0, 120772, '\P{Bidi_Mirrored=no}', "");
    Expect(1, 120772, '\P{^Bidi_Mirrored=no}', "");
    Expect(0, 120771, '\p{Bidi_Mirrored=no}', "");
    Expect(1, 120771, '\p{^Bidi_Mirrored=no}', "");
    Expect(1, 120771, '\P{Bidi_Mirrored=no}', "");
    Expect(0, 120771, '\P{^Bidi_Mirrored=no}', "");
    Expect(1, 120772, '\p{Bidi_Mirrored=:\Ano\z:}', "");;
    Expect(0, 120771, '\p{Bidi_Mirrored=:\Ano\z:}', "");;
    Expect(1, 120772, '\p{Bidi_Mirrored=-_No}', "");
    Expect(0, 120772, '\p{^Bidi_Mirrored=-_No}', "");
    Expect(0, 120772, '\P{Bidi_Mirrored=-_No}', "");
    Expect(1, 120772, '\P{^Bidi_Mirrored=-_No}', "");
    Expect(0, 120771, '\p{Bidi_Mirrored=-_No}', "");
    Expect(1, 120771, '\p{^Bidi_Mirrored=-_No}', "");
    Expect(1, 120771, '\P{Bidi_Mirrored=-_No}', "");
    Expect(0, 120771, '\P{^Bidi_Mirrored=-_No}', "");
    Error('\p{Bidi_M=:=N}');
    Error('\P{Bidi_M=:=N}');
    Expect(1, 120772, '\p{Bidi_M=:\AN\z:}', "");;
    Expect(0, 120771, '\p{Bidi_M=:\AN\z:}', "");;
    Expect(1, 120772, '\p{Bidi_M=n}', "");
    Expect(0, 120772, '\p{^Bidi_M=n}', "");
    Expect(0, 120772, '\P{Bidi_M=n}', "");
    Expect(1, 120772, '\P{^Bidi_M=n}', "");
    Expect(0, 120771, '\p{Bidi_M=n}', "");
    Expect(1, 120771, '\p{^Bidi_M=n}', "");
    Expect(1, 120771, '\P{Bidi_M=n}', "");
    Expect(0, 120771, '\P{^Bidi_M=n}', "");
    Expect(1, 120772, '\p{Bidi_M=:\An\z:}', "");;
    Expect(0, 120771, '\p{Bidi_M=:\An\z:}', "");;
    Expect(1, 120772, '\p{Bidi_M=-_N}', "");
    Expect(0, 120772, '\p{^Bidi_M=-_N}', "");
    Expect(0, 120772, '\P{Bidi_M=-_N}', "");
    Expect(1, 120772, '\P{^Bidi_M=-_N}', "");
    Expect(0, 120771, '\p{Bidi_M=-_N}', "");
    Expect(1, 120771, '\p{^Bidi_M=-_N}', "");
    Expect(1, 120771, '\P{Bidi_M=-_N}', "");
    Expect(0, 120771, '\P{^Bidi_M=-_N}', "");
    Error('\p{Is_Bidi_Mirrored=/a/	F}');
    Error('\P{Is_Bidi_Mirrored=/a/	F}');
    Expect(1, 120772, '\p{Is_Bidi_Mirrored:	f}', "");
    Expect(0, 120772, '\p{^Is_Bidi_Mirrored:	f}', "");
    Expect(0, 120772, '\P{Is_Bidi_Mirrored:	f}', "");
    Expect(1, 120772, '\P{^Is_Bidi_Mirrored:	f}', "");
    Expect(0, 120771, '\p{Is_Bidi_Mirrored:	f}', "");
    Expect(1, 120771, '\p{^Is_Bidi_Mirrored:	f}', "");
    Expect(1, 120771, '\P{Is_Bidi_Mirrored:	f}', "");
    Expect(0, 120771, '\P{^Is_Bidi_Mirrored:	f}', "");
    Expect(1, 120772, '\p{Is_Bidi_Mirrored= f}', "");
    Expect(0, 120772, '\p{^Is_Bidi_Mirrored= f}', "");
    Expect(0, 120772, '\P{Is_Bidi_Mirrored= f}', "");
    Expect(1, 120772, '\P{^Is_Bidi_Mirrored= f}', "");
    Expect(0, 120771, '\p{Is_Bidi_Mirrored= f}', "");
    Expect(1, 120771, '\p{^Is_Bidi_Mirrored= f}', "");
    Expect(1, 120771, '\P{Is_Bidi_Mirrored= f}', "");
    Expect(0, 120771, '\P{^Is_Bidi_Mirrored= f}', "");
    Error('\p{Is_Bidi_M=_False:=}');
    Error('\P{Is_Bidi_M=_False:=}');
    Expect(1, 120772, '\p{Is_Bidi_M=false}', "");
    Expect(0, 120772, '\p{^Is_Bidi_M=false}', "");
    Expect(0, 120772, '\P{Is_Bidi_M=false}', "");
    Expect(1, 120772, '\P{^Is_Bidi_M=false}', "");
    Expect(0, 120771, '\p{Is_Bidi_M=false}', "");
    Expect(1, 120771, '\p{^Is_Bidi_M=false}', "");
    Expect(1, 120771, '\P{Is_Bidi_M=false}', "");
    Expect(0, 120771, '\P{^Is_Bidi_M=false}', "");
    Expect(1, 120772, '\p{Is_Bidi_M=_False}', "");
    Expect(0, 120772, '\p{^Is_Bidi_M=_False}', "");
    Expect(0, 120772, '\P{Is_Bidi_M=_False}', "");
    Expect(1, 120772, '\P{^Is_Bidi_M=_False}', "");
    Expect(0, 120771, '\p{Is_Bidi_M=_False}', "");
    Expect(1, 120771, '\p{^Is_Bidi_M=_False}', "");
    Expect(1, 120771, '\P{Is_Bidi_M=_False}', "");
    Expect(0, 120771, '\P{^Is_Bidi_M=_False}', "");
    Error('\p{Bidi_Mirrored=/a/	Yes}');
    Error('\P{Bidi_Mirrored=/a/	Yes}');
    Expect(1, 120771, '\p{Bidi_Mirrored=:\AYes\z:}', "");;
    Expect(0, 120772, '\p{Bidi_Mirrored=:\AYes\z:}', "");;
    Expect(1, 120771, '\p{Bidi_Mirrored=yes}', "");
    Expect(0, 120771, '\p{^Bidi_Mirrored=yes}', "");
    Expect(0, 120771, '\P{Bidi_Mirrored=yes}', "");
    Expect(1, 120771, '\P{^Bidi_Mirrored=yes}', "");
    Expect(0, 120772, '\p{Bidi_Mirrored=yes}', "");
    Expect(1, 120772, '\p{^Bidi_Mirrored=yes}', "");
    Expect(1, 120772, '\P{Bidi_Mirrored=yes}', "");
    Expect(0, 120772, '\P{^Bidi_Mirrored=yes}', "");
    Expect(1, 120771, '\p{Bidi_Mirrored=:\Ayes\z:}', "");;
    Expect(0, 120772, '\p{Bidi_Mirrored=:\Ayes\z:}', "");;
    Expect(1, 120771, '\p{Bidi_Mirrored=_YES}', "");
    Expect(0, 120771, '\p{^Bidi_Mirrored=_YES}', "");
    Expect(0, 120771, '\P{Bidi_Mirrored=_YES}', "");
    Expect(1, 120771, '\P{^Bidi_Mirrored=_YES}', "");
    Expect(0, 120772, '\p{Bidi_Mirrored=_YES}', "");
    Expect(1, 120772, '\p{^Bidi_Mirrored=_YES}', "");
    Expect(1, 120772, '\P{Bidi_Mirrored=_YES}', "");
    Expect(0, 120772, '\P{^Bidi_Mirrored=_YES}', "");
    Error('\p{Bidi_M=-	Y/a/}');
    Error('\P{Bidi_M=-	Y/a/}');
    Expect(1, 120771, '\p{Bidi_M=:\AY\z:}', "");;
    Expect(0, 120772, '\p{Bidi_M=:\AY\z:}', "");;
    Expect(1, 120771, '\p{Bidi_M=y}', "");
    Expect(0, 120771, '\p{^Bidi_M=y}', "");
    Expect(0, 120771, '\P{Bidi_M=y}', "");
    Expect(1, 120771, '\P{^Bidi_M=y}', "");
    Expect(0, 120772, '\p{Bidi_M=y}', "");
    Expect(1, 120772, '\p{^Bidi_M=y}', "");
    Expect(1, 120772, '\P{Bidi_M=y}', "");
    Expect(0, 120772, '\P{^Bidi_M=y}', "");
    Expect(1, 120771, '\p{Bidi_M=:\Ay\z:}', "");;
    Expect(0, 120772, '\p{Bidi_M=:\Ay\z:}', "");;
    Expect(1, 120771, '\p{Bidi_M=_Y}', "");
    Expect(0, 120771, '\p{^Bidi_M=_Y}', "");
    Expect(0, 120771, '\P{Bidi_M=_Y}', "");
    Expect(1, 120771, '\P{^Bidi_M=_Y}', "");
    Expect(0, 120772, '\p{Bidi_M=_Y}', "");
    Expect(1, 120772, '\p{^Bidi_M=_Y}', "");
    Expect(1, 120772, '\P{Bidi_M=_Y}', "");
    Expect(0, 120772, '\P{^Bidi_M=_Y}', "");
    Error('\p{Is_Bidi_Mirrored:	/a/--T}');
    Error('\P{Is_Bidi_Mirrored:	/a/--T}');
    Expect(1, 120771, '\p{Is_Bidi_Mirrored=t}', "");
    Expect(0, 120771, '\p{^Is_Bidi_Mirrored=t}', "");
    Expect(0, 120771, '\P{Is_Bidi_Mirrored=t}', "");
    Expect(1, 120771, '\P{^Is_Bidi_Mirrored=t}', "");
    Expect(0, 120772, '\p{Is_Bidi_Mirrored=t}', "");
    Expect(1, 120772, '\p{^Is_Bidi_Mirrored=t}', "");
    Expect(1, 120772, '\P{Is_Bidi_Mirrored=t}', "");
    Expect(0, 120772, '\P{^Is_Bidi_Mirrored=t}', "");
    Expect(1, 120771, '\p{Is_Bidi_Mirrored= 	T}', "");
    Expect(0, 120771, '\p{^Is_Bidi_Mirrored= 	T}', "");
    Expect(0, 120771, '\P{Is_Bidi_Mirrored= 	T}', "");
    Expect(1, 120771, '\P{^Is_Bidi_Mirrored= 	T}', "");
    Expect(0, 120772, '\p{Is_Bidi_Mirrored= 	T}', "");
    Expect(1, 120772, '\p{^Is_Bidi_Mirrored= 	T}', "");
    Expect(1, 120772, '\P{Is_Bidi_Mirrored= 	T}', "");
    Expect(0, 120772, '\P{^Is_Bidi_Mirrored= 	T}', "");
    Error('\p{Is_Bidi_M=	:=True}');
    Error('\P{Is_Bidi_M=	:=True}');
    Expect(1, 120771, '\p{Is_Bidi_M=true}', "");
    Expect(0, 120771, '\p{^Is_Bidi_M=true}', "");
    Expect(0, 120771, '\P{Is_Bidi_M=true}', "");
    Expect(1, 120771, '\P{^Is_Bidi_M=true}', "");
    Expect(0, 120772, '\p{Is_Bidi_M=true}', "");
    Expect(1, 120772, '\p{^Is_Bidi_M=true}', "");
    Expect(1, 120772, '\P{Is_Bidi_M=true}', "");
    Expect(0, 120772, '\P{^Is_Bidi_M=true}', "");
    Expect(1, 120771, '\p{Is_Bidi_M=-True}', "");
    Expect(0, 120771, '\p{^Is_Bidi_M=-True}', "");
    Expect(0, 120771, '\P{Is_Bidi_M=-True}', "");
    Expect(1, 120771, '\P{^Is_Bidi_M=-True}', "");
    Expect(0, 120772, '\p{Is_Bidi_M=-True}', "");
    Expect(1, 120772, '\p{^Is_Bidi_M=-True}', "");
    Expect(1, 120772, '\P{Is_Bidi_M=-True}', "");
    Expect(0, 120772, '\P{^Is_Bidi_M=-True}', "");
    Error('\p{block}');
    Error('\P{block}');
    Error('\p{blk}');
    Error('\P{blk}');
    Error('\p{Block=:=-_Adlam}');
    Error('\P{Block=:=-_Adlam}');
    Expect(1, 125279, '\p{Block=:\AAdlam\z:}', "");;
    Expect(0, 125280, '\p{Block=:\AAdlam\z:}', "");;
    Expect(1, 125279, '\p{Block=adlam}', "");
    Expect(0, 125279, '\p{^Block=adlam}', "");
    Expect(0, 125279, '\P{Block=adlam}', "");
    Expect(1, 125279, '\P{^Block=adlam}', "");
    Expect(0, 125280, '\p{Block=adlam}', "");
    Expect(1, 125280, '\p{^Block=adlam}', "");
    Expect(1, 125280, '\P{Block=adlam}', "");
    Expect(0, 125280, '\P{^Block=adlam}', "");
    Expect(1, 125279, '\p{Block=:\Aadlam\z:}', "");;
    Expect(0, 125280, '\p{Block=:\Aadlam\z:}', "");;
    Expect(1, 125279, '\p{Block=	-Adlam}', "");
    Expect(0, 125279, '\p{^Block=	-Adlam}', "");
    Expect(0, 125279, '\P{Block=	-Adlam}', "");
    Expect(1, 125279, '\P{^Block=	-Adlam}', "");
    Expect(0, 125280, '\p{Block=	-Adlam}', "");
    Expect(1, 125280, '\p{^Block=	-Adlam}', "");
    Expect(1, 125280, '\P{Block=	-Adlam}', "");
    Expect(0, 125280, '\P{^Block=	-Adlam}', "");
    Error('\p{Blk=_/a/Adlam}');
    Error('\P{Blk=_/a/Adlam}');
    Expect(1, 125279, '\p{Blk=:\AAdlam\z:}', "");;
    Expect(0, 125280, '\p{Blk=:\AAdlam\z:}', "");;
    Expect(1, 125279, '\p{Blk=adlam}', "");
    Expect(0, 125279, '\p{^Blk=adlam}', "");
    Expect(0, 125279, '\P{Blk=adlam}', "");
    Expect(1, 125279, '\P{^Blk=adlam}', "");
    Expect(0, 125280, '\p{Blk=adlam}', "");
    Expect(1, 125280, '\p{^Blk=adlam}', "");
    Expect(1, 125280, '\P{Blk=adlam}', "");
    Expect(0, 125280, '\P{^Blk=adlam}', "");
    Expect(1, 125279, '\p{Blk=:\Aadlam\z:}', "");;
    Expect(0, 125280, '\p{Blk=:\Aadlam\z:}', "");;
    Expect(1, 125279, '\p{Blk:   --Adlam}', "");
    Expect(0, 125279, '\p{^Blk:   --Adlam}', "");
    Expect(0, 125279, '\P{Blk:   --Adlam}', "");
    Expect(1, 125279, '\P{^Blk:   --Adlam}', "");
    Expect(0, 125280, '\p{Blk:   --Adlam}', "");
    Expect(1, 125280, '\p{^Blk:   --Adlam}', "");
    Expect(1, 125280, '\P{Blk:   --Adlam}', "");
    Expect(0, 125280, '\P{^Blk:   --Adlam}', "");
    Error('\p{Is_Block=/a/	-Adlam}');
    Error('\P{Is_Block=/a/	-Adlam}');
    Expect(1, 125279, '\p{Is_Block=adlam}', "");
    Expect(0, 125279, '\p{^Is_Block=adlam}', "");
    Expect(0, 125279, '\P{Is_Block=adlam}', "");
    Expect(1, 125279, '\P{^Is_Block=adlam}', "");
    Expect(0, 125280, '\p{Is_Block=adlam}', "");
    Expect(1, 125280, '\p{^Is_Block=adlam}', "");
    Expect(1, 125280, '\P{Is_Block=adlam}', "");
    Expect(0, 125280, '\P{^Is_Block=adlam}', "");
    Expect(1, 125279, '\p{Is_Block=_	adlam}', "");
    Expect(0, 125279, '\p{^Is_Block=_	adlam}', "");
    Expect(0, 125279, '\P{Is_Block=_	adlam}', "");
    Expect(1, 125279, '\P{^Is_Block=_	adlam}', "");
    Expect(0, 125280, '\p{Is_Block=_	adlam}', "");
    Expect(1, 125280, '\p{^Is_Block=_	adlam}', "");
    Expect(1, 125280, '\P{Is_Block=_	adlam}', "");
    Expect(0, 125280, '\P{^Is_Block=_	adlam}', "");
    Error('\p{Is_Blk=/a/Adlam}');
    Error('\P{Is_Blk=/a/Adlam}');
    Expect(1, 125279, '\p{Is_Blk=adlam}', "");
    Expect(0, 125279, '\p{^Is_Blk=adlam}', "");
    Expect(0, 125279, '\P{Is_Blk=adlam}', "");
    Expect(1, 125279, '\P{^Is_Blk=adlam}', "");
    Expect(0, 125280, '\p{Is_Blk=adlam}', "");
    Expect(1, 125280, '\p{^Is_Blk=adlam}', "");
    Expect(1, 125280, '\P{Is_Blk=adlam}', "");
    Expect(0, 125280, '\P{^Is_Blk=adlam}', "");
    Expect(1, 125279, '\p{Is_Blk:	 -Adlam}', "");
    Expect(0, 125279, '\p{^Is_Blk:	 -Adlam}', "");
    Expect(0, 125279, '\P{Is_Blk:	 -Adlam}', "");
    Expect(1, 125279, '\P{^Is_Blk:	 -Adlam}', "");
    Expect(0, 125280, '\p{Is_Blk:	 -Adlam}', "");
    Expect(1, 125280, '\p{^Is_Blk:	 -Adlam}', "");
    Expect(1, 125280, '\P{Is_Blk:	 -Adlam}', "");
    Expect(0, 125280, '\P{^Is_Blk:	 -Adlam}', "");
    Error('\p{Block:   -/a/aegean_numbers}');
    Error('\P{Block:   -/a/aegean_numbers}');
    Expect(1, 65855, '\p{Block=:\AAegean_Numbers\z:}', "");;
    Expect(0, 65856, '\p{Block=:\AAegean_Numbers\z:}', "");;
    Expect(1, 65855, '\p{Block=aegeannumbers}', "");
    Expect(0, 65855, '\p{^Block=aegeannumbers}', "");
    Expect(0, 65855, '\P{Block=aegeannumbers}', "");
    Expect(1, 65855, '\P{^Block=aegeannumbers}', "");
    Expect(0, 65856, '\p{Block=aegeannumbers}', "");
    Expect(1, 65856, '\p{^Block=aegeannumbers}', "");
    Expect(1, 65856, '\P{Block=aegeannumbers}', "");
    Expect(0, 65856, '\P{^Block=aegeannumbers}', "");
    Expect(1, 65855, '\p{Block=:\Aaegeannumbers\z:}', "");;
    Expect(0, 65856, '\p{Block=:\Aaegeannumbers\z:}', "");;
    Expect(1, 65855, '\p{Block=_	Aegean_Numbers}', "");
    Expect(0, 65855, '\p{^Block=_	Aegean_Numbers}', "");
    Expect(0, 65855, '\P{Block=_	Aegean_Numbers}', "");
    Expect(1, 65855, '\P{^Block=_	Aegean_Numbers}', "");
    Expect(0, 65856, '\p{Block=_	Aegean_Numbers}', "");
    Expect(1, 65856, '\p{^Block=_	Aegean_Numbers}', "");
    Expect(1, 65856, '\P{Block=_	Aegean_Numbers}', "");
    Expect(0, 65856, '\P{^Block=_	Aegean_Numbers}', "");
    Error('\p{Blk=/a/aegean_Numbers}');
    Error('\P{Blk=/a/aegean_Numbers}');
    Expect(1, 65855, '\p{Blk=:\AAegean_Numbers\z:}', "");;
    Expect(0, 65856, '\p{Blk=:\AAegean_Numbers\z:}', "");;
    Expect(1, 65855, '\p{Blk=aegeannumbers}', "");
    Expect(0, 65855, '\p{^Blk=aegeannumbers}', "");
    Expect(0, 65855, '\P{Blk=aegeannumbers}', "");
    Expect(1, 65855, '\P{^Blk=aegeannumbers}', "");
    Expect(0, 65856, '\p{Blk=aegeannumbers}', "");
    Expect(1, 65856, '\p{^Blk=aegeannumbers}', "");
    Expect(1, 65856, '\P{Blk=aegeannumbers}', "");
    Expect(0, 65856, '\P{^Blk=aegeannumbers}', "");
    Expect(1, 65855, '\p{Blk=:\Aaegeannumbers\z:}', "");;
    Expect(0, 65856, '\p{Blk=:\Aaegeannumbers\z:}', "");;
    Expect(1, 65855, '\p{Blk=	Aegean_Numbers}', "");
    Expect(0, 65855, '\p{^Blk=	Aegean_Numbers}', "");
    Expect(0, 65855, '\P{Blk=	Aegean_Numbers}', "");
    Expect(1, 65855, '\P{^Blk=	Aegean_Numbers}', "");
    Expect(0, 65856, '\p{Blk=	Aegean_Numbers}', "");
    Expect(1, 65856, '\p{^Blk=	Aegean_Numbers}', "");
    Expect(1, 65856, '\P{Blk=	Aegean_Numbers}', "");
    Expect(0, 65856, '\P{^Blk=	Aegean_Numbers}', "");
    Error('\p{Is_Block=/a/__aegean_Numbers}');
    Error('\P{Is_Block=/a/__aegean_Numbers}');
    Expect(1, 65855, '\p{Is_Block=aegeannumbers}', "");
    Expect(0, 65855, '\p{^Is_Block=aegeannumbers}', "");
    Expect(0, 65855, '\P{Is_Block=aegeannumbers}', "");
    Expect(1, 65855, '\P{^Is_Block=aegeannumbers}', "");
    Expect(0, 65856, '\p{Is_Block=aegeannumbers}', "");
    Expect(1, 65856, '\p{^Is_Block=aegeannumbers}', "");
    Expect(1, 65856, '\P{Is_Block=aegeannumbers}', "");
    Expect(0, 65856, '\P{^Is_Block=aegeannumbers}', "");
    Expect(1, 65855, '\p{Is_Block=--AEGEAN_NUMBERS}', "");
    Expect(0, 65855, '\p{^Is_Block=--AEGEAN_NUMBERS}', "");
    Expect(0, 65855, '\P{Is_Block=--AEGEAN_NUMBERS}', "");
    Expect(1, 65855, '\P{^Is_Block=--AEGEAN_NUMBERS}', "");
    Expect(0, 65856, '\p{Is_Block=--AEGEAN_NUMBERS}', "");
    Expect(1, 65856, '\p{^Is_Block=--AEGEAN_NUMBERS}', "");
    Expect(1, 65856, '\P{Is_Block=--AEGEAN_NUMBERS}', "");
    Expect(0, 65856, '\P{^Is_Block=--AEGEAN_NUMBERS}', "");
    Error('\p{Is_Blk=:=	-Aegean_NUMBERS}');
    Error('\P{Is_Blk=:=	-Aegean_NUMBERS}');
    Expect(1, 65855, '\p{Is_Blk=aegeannumbers}', "");
    Expect(0, 65855, '\p{^Is_Blk=aegeannumbers}', "");
    Expect(0, 65855, '\P{Is_Blk=aegeannumbers}', "");
    Expect(1, 65855, '\P{^Is_Blk=aegeannumbers}', "");
    Expect(0, 65856, '\p{Is_Blk=aegeannumbers}', "");
    Expect(1, 65856, '\p{^Is_Blk=aegeannumbers}', "");
    Expect(1, 65856, '\P{Is_Blk=aegeannumbers}', "");
    Expect(0, 65856, '\P{^Is_Blk=aegeannumbers}', "");
    Expect(1, 65855, '\p{Is_Blk=	Aegean_numbers}', "");
    Expect(0, 65855, '\p{^Is_Blk=	Aegean_numbers}', "");
    Expect(0, 65855, '\P{Is_Blk=	Aegean_numbers}', "");
    Expect(1, 65855, '\P{^Is_Blk=	Aegean_numbers}', "");
    Expect(0, 65856, '\p{Is_Blk=	Aegean_numbers}', "");
    Expect(1, 65856, '\p{^Is_Blk=	Aegean_numbers}', "");
    Expect(1, 65856, '\P{Is_Blk=	Aegean_numbers}', "");
    Expect(0, 65856, '\P{^Is_Blk=	Aegean_numbers}', "");
    Error('\p{Block=		Ahom:=}');
    Error('\P{Block=		Ahom:=}');
    Expect(1, 71503, '\p{Block=:\AAhom\z:}', "");;
    Expect(0, 71504, '\p{Block=:\AAhom\z:}', "");;
    Expect(1, 71503, '\p{Block=ahom}', "");
    Expect(0, 71503, '\p{^Block=ahom}', "");
    Expect(0, 71503, '\P{Block=ahom}', "");
    Expect(1, 71503, '\P{^Block=ahom}', "");
    Expect(0, 71504, '\p{Block=ahom}', "");
    Expect(1, 71504, '\p{^Block=ahom}', "");
    Expect(1, 71504, '\P{Block=ahom}', "");
    Expect(0, 71504, '\P{^Block=ahom}', "");
    Expect(1, 71503, '\p{Block=:\Aahom\z:}', "");;
    Expect(0, 71504, '\p{Block=:\Aahom\z:}', "");;
    Expect(1, 71503, '\p{Block=_-AHOM}', "");
    Expect(0, 71503, '\p{^Block=_-AHOM}', "");
    Expect(0, 71503, '\P{Block=_-AHOM}', "");
    Expect(1, 71503, '\P{^Block=_-AHOM}', "");
    Expect(0, 71504, '\p{Block=_-AHOM}', "");
    Expect(1, 71504, '\p{^Block=_-AHOM}', "");
    Expect(1, 71504, '\P{Block=_-AHOM}', "");
    Expect(0, 71504, '\P{^Block=_-AHOM}', "");
    Error('\p{Blk=/a/	-Ahom}');
    Error('\P{Blk=/a/	-Ahom}');
    Expect(1, 71503, '\p{Blk=:\AAhom\z:}', "");;
    Expect(0, 71504, '\p{Blk=:\AAhom\z:}', "");;
    Expect(1, 71503, '\p{Blk=ahom}', "");
    Expect(0, 71503, '\p{^Blk=ahom}', "");
    Expect(0, 71503, '\P{Blk=ahom}', "");
    Expect(1, 71503, '\P{^Blk=ahom}', "");
    Expect(0, 71504, '\p{Blk=ahom}', "");
    Expect(1, 71504, '\p{^Blk=ahom}', "");
    Expect(1, 71504, '\P{Blk=ahom}', "");
    Expect(0, 71504, '\P{^Blk=ahom}', "");
    Expect(1, 71503, '\p{Blk=:\Aahom\z:}', "");;
    Expect(0, 71504, '\p{Blk=:\Aahom\z:}', "");;
    Expect(1, 71503, '\p{Blk=_ ahom}', "");
    Expect(0, 71503, '\p{^Blk=_ ahom}', "");
    Expect(0, 71503, '\P{Blk=_ ahom}', "");
    Expect(1, 71503, '\P{^Blk=_ ahom}', "");
    Expect(0, 71504, '\p{Blk=_ ahom}', "");
    Expect(1, 71504, '\p{^Blk=_ ahom}', "");
    Expect(1, 71504, '\P{Blk=_ ahom}', "");
    Expect(0, 71504, '\P{^Blk=_ ahom}', "");
    Error('\p{Is_Block=:= _Ahom}');
    Error('\P{Is_Block=:= _Ahom}');
    Expect(1, 71503, '\p{Is_Block=ahom}', "");
    Expect(0, 71503, '\p{^Is_Block=ahom}', "");
    Expect(0, 71503, '\P{Is_Block=ahom}', "");
    Expect(1, 71503, '\P{^Is_Block=ahom}', "");
    Expect(0, 71504, '\p{Is_Block=ahom}', "");
    Expect(1, 71504, '\p{^Is_Block=ahom}', "");
    Expect(1, 71504, '\P{Is_Block=ahom}', "");
    Expect(0, 71504, '\P{^Is_Block=ahom}', "");
    Expect(1, 71503, '\p{Is_Block:   --Ahom}', "");
    Expect(0, 71503, '\p{^Is_Block:   --Ahom}', "");
    Expect(0, 71503, '\P{Is_Block:   --Ahom}', "");
    Expect(1, 71503, '\P{^Is_Block:   --Ahom}', "");
    Expect(0, 71504, '\p{Is_Block:   --Ahom}', "");
    Expect(1, 71504, '\p{^Is_Block:   --Ahom}', "");
    Expect(1, 71504, '\P{Is_Block:   --Ahom}', "");
    Expect(0, 71504, '\P{^Is_Block:   --Ahom}', "");
    Error('\p{Is_Blk= /a/AHOM}');
    Error('\P{Is_Blk= /a/AHOM}');
    Expect(1, 71503, '\p{Is_Blk=ahom}', "");
    Expect(0, 71503, '\p{^Is_Blk=ahom}', "");
    Expect(0, 71503, '\P{Is_Blk=ahom}', "");
    Expect(1, 71503, '\P{^Is_Blk=ahom}', "");
    Expect(0, 71504, '\p{Is_Blk=ahom}', "");
    Expect(1, 71504, '\p{^Is_Blk=ahom}', "");
    Expect(1, 71504, '\P{Is_Blk=ahom}', "");
    Expect(0, 71504, '\P{^Is_Blk=ahom}', "");
    Expect(1, 71503, '\p{Is_Blk= Ahom}', "");
    Expect(0, 71503, '\p{^Is_Blk= Ahom}', "");
    Expect(0, 71503, '\P{Is_Blk= Ahom}', "");
    Expect(1, 71503, '\P{^Is_Blk= Ahom}', "");
    Expect(0, 71504, '\p{Is_Blk= Ahom}', "");
    Expect(1, 71504, '\p{^Is_Blk= Ahom}', "");
    Expect(1, 71504, '\P{Is_Blk= Ahom}', "");
    Expect(0, 71504, '\P{^Is_Blk= Ahom}', "");
    Error('\p{Block=/a/	alchemical_SYMBOLS}');
    Error('\P{Block=/a/	alchemical_SYMBOLS}');
    Expect(1, 128895, '\p{Block=:\AAlchemical_Symbols\z:}', "");;
    Expect(0, 128896, '\p{Block=:\AAlchemical_Symbols\z:}', "");;
    Expect(1, 128895, '\p{Block=alchemicalsymbols}', "");
    Expect(0, 128895, '\p{^Block=alchemicalsymbols}', "");
    Expect(0, 128895, '\P{Block=alchemicalsymbols}', "");
    Expect(1, 128895, '\P{^Block=alchemicalsymbols}', "");
    Expect(0, 128896, '\p{Block=alchemicalsymbols}', "");
    Expect(1, 128896, '\p{^Block=alchemicalsymbols}', "");
    Expect(1, 128896, '\P{Block=alchemicalsymbols}', "");
    Expect(0, 128896, '\P{^Block=alchemicalsymbols}', "");
    Expect(1, 128895, '\p{Block=:\Aalchemicalsymbols\z:}', "");;
    Expect(0, 128896, '\p{Block=:\Aalchemicalsymbols\z:}', "");;
    Expect(1, 128895, '\p{Block=_ ALCHEMICAL_Symbols}', "");
    Expect(0, 128895, '\p{^Block=_ ALCHEMICAL_Symbols}', "");
    Expect(0, 128895, '\P{Block=_ ALCHEMICAL_Symbols}', "");
    Expect(1, 128895, '\P{^Block=_ ALCHEMICAL_Symbols}', "");
    Expect(0, 128896, '\p{Block=_ ALCHEMICAL_Symbols}', "");
    Expect(1, 128896, '\p{^Block=_ ALCHEMICAL_Symbols}', "");
    Expect(1, 128896, '\P{Block=_ ALCHEMICAL_Symbols}', "");
    Expect(0, 128896, '\P{^Block=_ ALCHEMICAL_Symbols}', "");
    Error('\p{Blk::=alchemical}');
    Error('\P{Blk::=alchemical}');
    Expect(1, 128895, '\p{Blk=:\AAlchemical\z:}', "");;
    Expect(0, 128896, '\p{Blk=:\AAlchemical\z:}', "");;
    Expect(1, 128895, '\p{Blk=alchemical}', "");
    Expect(0, 128895, '\p{^Blk=alchemical}', "");
    Expect(0, 128895, '\P{Blk=alchemical}', "");
    Expect(1, 128895, '\P{^Blk=alchemical}', "");
    Expect(0, 128896, '\p{Blk=alchemical}', "");
    Expect(1, 128896, '\p{^Blk=alchemical}', "");
    Expect(1, 128896, '\P{Blk=alchemical}', "");
    Expect(0, 128896, '\P{^Blk=alchemical}', "");
    Expect(1, 128895, '\p{Blk=:\Aalchemical\z:}', "");;
    Expect(0, 128896, '\p{Blk=:\Aalchemical\z:}', "");;
    Expect(1, 128895, '\p{Blk=-Alchemical}', "");
    Expect(0, 128895, '\p{^Blk=-Alchemical}', "");
    Expect(0, 128895, '\P{Blk=-Alchemical}', "");
    Expect(1, 128895, '\P{^Blk=-Alchemical}', "");
    Expect(0, 128896, '\p{Blk=-Alchemical}', "");
    Expect(1, 128896, '\p{^Blk=-Alchemical}', "");
    Expect(1, 128896, '\P{Blk=-Alchemical}', "");
    Expect(0, 128896, '\P{^Blk=-Alchemical}', "");
    Error('\p{Is_Block=:=	_alchemical_SYMBOLS}');
    Error('\P{Is_Block=:=	_alchemical_SYMBOLS}');
    Expect(1, 128895, '\p{Is_Block=alchemicalsymbols}', "");
    Expect(0, 128895, '\p{^Is_Block=alchemicalsymbols}', "");
    Expect(0, 128895, '\P{Is_Block=alchemicalsymbols}', "");
    Expect(1, 128895, '\P{^Is_Block=alchemicalsymbols}', "");
    Expect(0, 128896, '\p{Is_Block=alchemicalsymbols}', "");
    Expect(1, 128896, '\p{^Is_Block=alchemicalsymbols}', "");
    Expect(1, 128896, '\P{Is_Block=alchemicalsymbols}', "");
    Expect(0, 128896, '\P{^Is_Block=alchemicalsymbols}', "");
    Expect(1, 128895, '\p{Is_Block= Alchemical_SYMBOLS}', "");
    Expect(0, 128895, '\p{^Is_Block= Alchemical_SYMBOLS}', "");
    Expect(0, 128895, '\P{Is_Block= Alchemical_SYMBOLS}', "");
    Expect(1, 128895, '\P{^Is_Block= Alchemical_SYMBOLS}', "");
    Expect(0, 128896, '\p{Is_Block= Alchemical_SYMBOLS}', "");
    Expect(1, 128896, '\p{^Is_Block= Alchemical_SYMBOLS}', "");
    Expect(1, 128896, '\P{Is_Block= Alchemical_SYMBOLS}', "");
    Expect(0, 128896, '\P{^Is_Block= Alchemical_SYMBOLS}', "");
    Error('\p{Is_Blk=- alchemical:=}');
    Error('\P{Is_Blk=- alchemical:=}');
    Expect(1, 128895, '\p{Is_Blk=alchemical}', "");
    Expect(0, 128895, '\p{^Is_Blk=alchemical}', "");
    Expect(0, 128895, '\P{Is_Blk=alchemical}', "");
    Expect(1, 128895, '\P{^Is_Blk=alchemical}', "");
    Expect(0, 128896, '\p{Is_Blk=alchemical}', "");
    Expect(1, 128896, '\p{^Is_Blk=alchemical}', "");
    Expect(1, 128896, '\P{Is_Blk=alchemical}', "");
    Expect(0, 128896, '\P{^Is_Blk=alchemical}', "");
    Expect(1, 128895, '\p{Is_Blk=	-Alchemical}', "");
    Expect(0, 128895, '\p{^Is_Blk=	-Alchemical}', "");
    Expect(0, 128895, '\P{Is_Blk=	-Alchemical}', "");
    Expect(1, 128895, '\P{^Is_Blk=	-Alchemical}', "");
    Expect(0, 128896, '\p{Is_Blk=	-Alchemical}', "");
    Expect(1, 128896, '\p{^Is_Blk=	-Alchemical}', "");
    Expect(1, 128896, '\P{Is_Blk=	-Alchemical}', "");
    Expect(0, 128896, '\P{^Is_Blk=	-Alchemical}', "");
    Error('\p{Block=	/a/Alphabetic_Presentation_Forms}');
    Error('\P{Block=	/a/Alphabetic_Presentation_Forms}');
    Expect(1, 64335, '\p{Block=:\AAlphabetic_Presentation_Forms\z:}', "");;
    Expect(0, 64336, '\p{Block=:\AAlphabetic_Presentation_Forms\z:}', "");;
    Expect(1, 64335, '\p{Block=alphabeticpresentationforms}', "");
    Expect(0, 64335, '\p{^Block=alphabeticpresentationforms}', "");
    Expect(0, 64335, '\P{Block=alphabeticpresentationforms}', "");
    Expect(1, 64335, '\P{^Block=alphabeticpresentationforms}', "");
    Expect(0, 64336, '\p{Block=alphabeticpresentationforms}', "");
    Expect(1, 64336, '\p{^Block=alphabeticpresentationforms}', "");
    Expect(1, 64336, '\P{Block=alphabeticpresentationforms}', "");
    Expect(0, 64336, '\P{^Block=alphabeticpresentationforms}', "");
    Expect(1, 64335, '\p{Block=:\Aalphabeticpresentationforms\z:}', "");;
    Expect(0, 64336, '\p{Block=:\Aalphabeticpresentationforms\z:}', "");;
    Expect(1, 64335, '\p{Block=	 Alphabetic_Presentation_Forms}', "");
    Expect(0, 64335, '\p{^Block=	 Alphabetic_Presentation_Forms}', "");
    Expect(0, 64335, '\P{Block=	 Alphabetic_Presentation_Forms}', "");
    Expect(1, 64335, '\P{^Block=	 Alphabetic_Presentation_Forms}', "");
    Expect(0, 64336, '\p{Block=	 Alphabetic_Presentation_Forms}', "");
    Expect(1, 64336, '\p{^Block=	 Alphabetic_Presentation_Forms}', "");
    Expect(1, 64336, '\P{Block=	 Alphabetic_Presentation_Forms}', "");
    Expect(0, 64336, '\P{^Block=	 Alphabetic_Presentation_Forms}', "");
    Error('\p{Blk=-Alphabetic_PF/a/}');
    Error('\P{Blk=-Alphabetic_PF/a/}');
    Expect(1, 64335, '\p{Blk=:\AAlphabetic_PF\z:}', "");;
    Expect(0, 64336, '\p{Blk=:\AAlphabetic_PF\z:}', "");;
    Expect(1, 64335, '\p{Blk=alphabeticpf}', "");
    Expect(0, 64335, '\p{^Blk=alphabeticpf}', "");
    Expect(0, 64335, '\P{Blk=alphabeticpf}', "");
    Expect(1, 64335, '\P{^Blk=alphabeticpf}', "");
    Expect(0, 64336, '\p{Blk=alphabeticpf}', "");
    Expect(1, 64336, '\p{^Blk=alphabeticpf}', "");
    Expect(1, 64336, '\P{Blk=alphabeticpf}', "");
    Expect(0, 64336, '\P{^Blk=alphabeticpf}', "");
    Expect(1, 64335, '\p{Blk=:\Aalphabeticpf\z:}', "");;
    Expect(0, 64336, '\p{Blk=:\Aalphabeticpf\z:}', "");;
    Expect(1, 64335, '\p{Blk=__Alphabetic_PF}', "");
    Expect(0, 64335, '\p{^Blk=__Alphabetic_PF}', "");
    Expect(0, 64335, '\P{Blk=__Alphabetic_PF}', "");
    Expect(1, 64335, '\P{^Blk=__Alphabetic_PF}', "");
    Expect(0, 64336, '\p{Blk=__Alphabetic_PF}', "");
    Expect(1, 64336, '\p{^Blk=__Alphabetic_PF}', "");
    Expect(1, 64336, '\P{Blk=__Alphabetic_PF}', "");
    Expect(0, 64336, '\P{^Blk=__Alphabetic_PF}', "");
    Error('\p{Is_Block=:=  alphabetic_Presentation_Forms}');
    Error('\P{Is_Block=:=  alphabetic_Presentation_Forms}');
    Expect(1, 64335, '\p{Is_Block=alphabeticpresentationforms}', "");
    Expect(0, 64335, '\p{^Is_Block=alphabeticpresentationforms}', "");
    Expect(0, 64335, '\P{Is_Block=alphabeticpresentationforms}', "");
    Expect(1, 64335, '\P{^Is_Block=alphabeticpresentationforms}', "");
    Expect(0, 64336, '\p{Is_Block=alphabeticpresentationforms}', "");
    Expect(1, 64336, '\p{^Is_Block=alphabeticpresentationforms}', "");
    Expect(1, 64336, '\P{Is_Block=alphabeticpresentationforms}', "");
    Expect(0, 64336, '\P{^Is_Block=alphabeticpresentationforms}', "");
    Expect(1, 64335, '\p{Is_Block=	_ALPHABETIC_PRESENTATION_forms}', "");
    Expect(0, 64335, '\p{^Is_Block=	_ALPHABETIC_PRESENTATION_forms}', "");
    Expect(0, 64335, '\P{Is_Block=	_ALPHABETIC_PRESENTATION_forms}', "");
    Expect(1, 64335, '\P{^Is_Block=	_ALPHABETIC_PRESENTATION_forms}', "");
    Expect(0, 64336, '\p{Is_Block=	_ALPHABETIC_PRESENTATION_forms}', "");
    Expect(1, 64336, '\p{^Is_Block=	_ALPHABETIC_PRESENTATION_forms}', "");
    Expect(1, 64336, '\P{Is_Block=	_ALPHABETIC_PRESENTATION_forms}', "");
    Expect(0, 64336, '\P{^Is_Block=	_ALPHABETIC_PRESENTATION_forms}', "");
    Error('\p{Is_Blk=_:=ALPHABETIC_PF}');
    Error('\P{Is_Blk=_:=ALPHABETIC_PF}');
    Expect(1, 64335, '\p{Is_Blk=alphabeticpf}', "");
    Expect(0, 64335, '\p{^Is_Blk=alphabeticpf}', "");
    Expect(0, 64335, '\P{Is_Blk=alphabeticpf}', "");
    Expect(1, 64335, '\P{^Is_Blk=alphabeticpf}', "");
    Expect(0, 64336, '\p{Is_Blk=alphabeticpf}', "");
    Expect(1, 64336, '\p{^Is_Blk=alphabeticpf}', "");
    Expect(1, 64336, '\P{Is_Blk=alphabeticpf}', "");
    Expect(0, 64336, '\P{^Is_Blk=alphabeticpf}', "");
    Expect(1, 64335, '\p{Is_Blk=_	Alphabetic_PF}', "");
    Expect(0, 64335, '\p{^Is_Blk=_	Alphabetic_PF}', "");
    Expect(0, 64335, '\P{Is_Blk=_	Alphabetic_PF}', "");
    Expect(1, 64335, '\P{^Is_Blk=_	Alphabetic_PF}', "");
    Expect(0, 64336, '\p{Is_Blk=_	Alphabetic_PF}', "");
    Expect(1, 64336, '\p{^Is_Blk=_	Alphabetic_PF}', "");
    Expect(1, 64336, '\P{Is_Blk=_	Alphabetic_PF}', "");
    Expect(0, 64336, '\P{^Is_Blk=_	Alphabetic_PF}', "");
    Error('\p{Block:/a/ -Anatolian_Hieroglyphs}');
    Error('\P{Block:/a/ -Anatolian_Hieroglyphs}');
    Expect(1, 83583, '\p{Block=:\AAnatolian_Hieroglyphs\z:}', "");;
    Expect(0, 83584, '\p{Block=:\AAnatolian_Hieroglyphs\z:}', "");;
    Expect(1, 83583, '\p{Block=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\p{^Block=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\P{Block=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\P{^Block=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\p{Block=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\p{^Block=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\P{Block=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\P{^Block=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\p{Block=:\Aanatolianhieroglyphs\z:}', "");;
    Expect(0, 83584, '\p{Block=:\Aanatolianhieroglyphs\z:}', "");;
    Expect(1, 83583, '\p{Block=_Anatolian_hieroglyphs}', "");
    Expect(0, 83583, '\p{^Block=_Anatolian_hieroglyphs}', "");
    Expect(0, 83583, '\P{Block=_Anatolian_hieroglyphs}', "");
    Expect(1, 83583, '\P{^Block=_Anatolian_hieroglyphs}', "");
    Expect(0, 83584, '\p{Block=_Anatolian_hieroglyphs}', "");
    Expect(1, 83584, '\p{^Block=_Anatolian_hieroglyphs}', "");
    Expect(1, 83584, '\P{Block=_Anatolian_hieroglyphs}', "");
    Expect(0, 83584, '\P{^Block=_Anatolian_hieroglyphs}', "");
    Error('\p{Blk:		/a/anatolian_Hieroglyphs}');
    Error('\P{Blk:		/a/anatolian_Hieroglyphs}');
    Expect(1, 83583, '\p{Blk=:\AAnatolian_Hieroglyphs\z:}', "");;
    Expect(0, 83584, '\p{Blk=:\AAnatolian_Hieroglyphs\z:}', "");;
    Expect(1, 83583, '\p{Blk=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\p{^Blk=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\P{Blk=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\P{^Blk=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\p{Blk=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\p{^Blk=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\P{Blk=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\P{^Blk=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\p{Blk=:\Aanatolianhieroglyphs\z:}', "");;
    Expect(0, 83584, '\p{Blk=:\Aanatolianhieroglyphs\z:}', "");;
    Expect(1, 83583, '\p{Blk=	_Anatolian_Hieroglyphs}', "");
    Expect(0, 83583, '\p{^Blk=	_Anatolian_Hieroglyphs}', "");
    Expect(0, 83583, '\P{Blk=	_Anatolian_Hieroglyphs}', "");
    Expect(1, 83583, '\P{^Blk=	_Anatolian_Hieroglyphs}', "");
    Expect(0, 83584, '\p{Blk=	_Anatolian_Hieroglyphs}', "");
    Expect(1, 83584, '\p{^Blk=	_Anatolian_Hieroglyphs}', "");
    Expect(1, 83584, '\P{Blk=	_Anatolian_Hieroglyphs}', "");
    Expect(0, 83584, '\P{^Blk=	_Anatolian_Hieroglyphs}', "");
    Error('\p{Is_Block=_:=Anatolian_Hieroglyphs}');
    Error('\P{Is_Block=_:=Anatolian_Hieroglyphs}');
    Expect(1, 83583, '\p{Is_Block=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\p{^Is_Block=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\P{Is_Block=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\P{^Is_Block=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\p{Is_Block=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\p{^Is_Block=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\P{Is_Block=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\P{^Is_Block=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\p{Is_Block=	_ANATOLIAN_Hieroglyphs}', "");
    Expect(0, 83583, '\p{^Is_Block=	_ANATOLIAN_Hieroglyphs}', "");
    Expect(0, 83583, '\P{Is_Block=	_ANATOLIAN_Hieroglyphs}', "");
    Expect(1, 83583, '\P{^Is_Block=	_ANATOLIAN_Hieroglyphs}', "");
    Expect(0, 83584, '\p{Is_Block=	_ANATOLIAN_Hieroglyphs}', "");
    Expect(1, 83584, '\p{^Is_Block=	_ANATOLIAN_Hieroglyphs}', "");
    Expect(1, 83584, '\P{Is_Block=	_ANATOLIAN_Hieroglyphs}', "");
    Expect(0, 83584, '\P{^Is_Block=	_ANATOLIAN_Hieroglyphs}', "");
    Error('\p{Is_Blk= /a/ANATOLIAN_Hieroglyphs}');
    Error('\P{Is_Blk= /a/ANATOLIAN_Hieroglyphs}');
    Expect(1, 83583, '\p{Is_Blk=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\p{^Is_Blk=anatolianhieroglyphs}', "");
    Expect(0, 83583, '\P{Is_Blk=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\P{^Is_Blk=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\p{Is_Blk=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\p{^Is_Blk=anatolianhieroglyphs}', "");
    Expect(1, 83584, '\P{Is_Blk=anatolianhieroglyphs}', "");
    Expect(0, 83584, '\P{^Is_Blk=anatolianhieroglyphs}', "");
    Expect(1, 83583, '\p{Is_Blk=-_ANATOLIAN_hieroglyphs}', "");
    Expect(0, 83583, '\p{^Is_Blk=-_ANATOLIAN_hieroglyphs}', "");
    Expect(0, 83583, '\P{Is_Blk=-_ANATOLIAN_hieroglyphs}', "");
    Expect(1, 83583, '\P{^Is_Blk=-_ANATOLIAN_hieroglyphs}', "");
    Expect(0, 83584, '\p{Is_Blk=-_ANATOLIAN_hieroglyphs}', "");
    Expect(1, 83584, '\p{^Is_Blk=-_ANATOLIAN_hieroglyphs}', "");
    Expect(1, 83584, '\P{Is_Blk=-_ANATOLIAN_hieroglyphs}', "");
    Expect(0, 83584, '\P{^Is_Blk=-_ANATOLIAN_hieroglyphs}', "");
    Error('\p{Block= -Ancient_Greek_musical_Notation:=}');
    Error('\P{Block= -Ancient_Greek_musical_Notation:=}');
    Expect(1, 119375, '\p{Block=:\AAncient_Greek_Musical_Notation\z:}', "");;
    Expect(0, 119376, '\p{Block=:\AAncient_Greek_Musical_Notation\z:}', "");;
    Expect(1, 119375, '\p{Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119375, '\p{^Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119375, '\P{Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119375, '\P{^Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119376, '\p{Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119376, '\p{^Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119376, '\P{Block=ancientgreekmusicalnotation}', "");
    Expect(0, 119376, '\P{^Block=ancientgreekmusicalnotation}', "");
    Expect(1, 119375, '\p{Block=:\Aancientgreekmusicalnotation\z:}', "");;
    Expect(0, 119376, '\p{Block=:\Aancientgreekmusicalnotation\z:}', "");;
    Expect(1, 119375, '\p{Block=__ANCIENT_greek_musical_Notation}', "");
    Expect(0, 119375, '\p{^Block=__ANCIENT_greek_musical_Notation}', "");
    Expect(0, 119375, '\P{Block=__ANCIENT_greek_musical_Notation}', "");
    Expect(1, 119375, '\P{^Block=__ANCIENT_greek_musical_Notation}', "");
    Expect(0, 119376, '\p{Block=__ANCIENT_greek_musical_Notation}', "");
    Expect(1, 119376, '\p{^Block=__ANCIENT_greek_musical_Notation}', "");
    Expect(1, 119376, '\P{Block=__ANCIENT_greek_musical_Notation}', "");
    Expect(0, 119376, '\P{^Block=__ANCIENT_greek_musical_Notation}', "");
    Error('\p{Blk=/a/_-ancient_Greek_MUSIC}');
    Error('\P{Blk=/a/_-ancient_Greek_MUSIC}');
    Expect(1, 119375, '\p{Blk=:\AAncient_Greek_Music\z:}', "");;
    Expect(0, 119376, '\p{Blk=:\AAncient_Greek_Music\z:}', "");;
    Expect(1, 119375, '\p{Blk=ancientgreekmusic}', "");
    Expect(0, 119375, '\p{^Blk=ancientgreekmusic}', "");
    Expect(0, 119375, '\P{Blk=ancientgreekmusic}', "");
    Expect(1, 119375, '\P{^Blk=ancientgreekmusic}', "");
    Expect(0, 119376, '\p{Blk=ancientgreekmusic}', "");
    Expect(1, 119376, '\p{^Blk=ancientgreekmusic}', "");
    Expect(1, 119376, '\P{Blk=ancientgreekmusic}', "");
    Expect(0, 119376, '\P{^Blk=ancientgreekmusic}', "");
    Expect(1, 119375, '\p{Blk=:\Aancientgreekmusic\z:}', "");;
    Expect(0, 119376, '\p{Blk=:\Aancientgreekmusic\z:}', "");;
    Expect(1, 119375, '\p{Blk=	_Ancient_greek_Music}', "");
    Expect(0, 119375, '\p{^Blk=	_Ancient_greek_Music}', "");
    Expect(0, 119375, '\P{Blk=	_Ancient_greek_Music}', "");
    Expect(1, 119375, '\P{^Blk=	_Ancient_greek_Music}', "");
    Expect(0, 119376, '\p{Blk=	_Ancient_greek_Music}', "");
    Expect(1, 119376, '\p{^Blk=	_Ancient_greek_Music}', "");
    Expect(1, 119376, '\P{Blk=	_Ancient_greek_Music}', "");
    Expect(0, 119376, '\P{^Blk=	_Ancient_greek_Music}', "");
    Error('\p{Is_Block=/a/-ANCIENT_greek_Musical_Notation}');
    Error('\P{Is_Block=/a/-ANCIENT_greek_Musical_Notation}');
    Expect(1, 119375, '\p{Is_Block: ancientgreekmusicalnotation}', "");
    Expect(0, 119375, '\p{^Is_Block: ancientgreekmusicalnotation}', "");
    Expect(0, 119375, '\P{Is_Block: ancientgreekmusicalnotation}', "");
    Expect(1, 119375, '\P{^Is_Block: ancientgreekmusicalnotation}', "");
    Expect(0, 119376, '\p{Is_Block: ancientgreekmusicalnotation}', "");
    Expect(1, 119376, '\p{^Is_Block: ancientgreekmusicalnotation}', "");
    Expect(1, 119376, '\P{Is_Block: ancientgreekmusicalnotation}', "");
    Expect(0, 119376, '\P{^Is_Block: ancientgreekmusicalnotation}', "");
    Expect(1, 119375, '\p{Is_Block=_Ancient_Greek_Musical_NOTATION}', "");
    Expect(0, 119375, '\p{^Is_Block=_Ancient_Greek_Musical_NOTATION}', "");
    Expect(0, 119375, '\P{Is_Block=_Ancient_Greek_Musical_NOTATION}', "");
    Expect(1, 119375, '\P{^Is_Block=_Ancient_Greek_Musical_NOTATION}', "");
    Expect(0, 119376, '\p{Is_Block=_Ancient_Greek_Musical_NOTATION}', "");
    Expect(1, 119376, '\p{^Is_Block=_Ancient_Greek_Musical_NOTATION}', "");
    Expect(1, 119376, '\P{Is_Block=_Ancient_Greek_Musical_NOTATION}', "");
    Expect(0, 119376, '\P{^Is_Block=_Ancient_Greek_Musical_NOTATION}', "");
    Error('\p{Is_Blk=__Ancient_Greek_MUSIC/a/}');
    Error('\P{Is_Blk=__Ancient_Greek_MUSIC/a/}');
    Expect(1, 119375, '\p{Is_Blk=ancientgreekmusic}', "");
    Expect(0, 119375, '\p{^Is_Blk=ancientgreekmusic}', "");
    Expect(0, 119375, '\P{Is_Blk=ancientgreekmusic}', "");
    Expect(1, 119375, '\P{^Is_Blk=ancientgreekmusic}', "");
    Expect(0, 119376, '\p{Is_Blk=ancientgreekmusic}', "");
    Expect(1, 119376, '\p{^Is_Blk=ancientgreekmusic}', "");
    Expect(1, 119376, '\P{Is_Blk=ancientgreekmusic}', "");
    Expect(0, 119376, '\P{^Is_Blk=ancientgreekmusic}', "");
    Expect(1, 119375, '\p{Is_Blk= ancient_Greek_Music}', "");
    Expect(0, 119375, '\p{^Is_Blk= ancient_Greek_Music}', "");
    Expect(0, 119375, '\P{Is_Blk= ancient_Greek_Music}', "");
    Expect(1, 119375, '\P{^Is_Blk= ancient_Greek_Music}', "");
    Expect(0, 119376, '\p{Is_Blk= ancient_Greek_Music}', "");
    Expect(1, 119376, '\p{^Is_Blk= ancient_Greek_Music}', "");
    Expect(1, 119376, '\P{Is_Blk= ancient_Greek_Music}', "");
    Expect(0, 119376, '\P{^Is_Blk= ancient_Greek_Music}', "");
    Error('\p{Block:   _ancient_Greek_Numbers:=}');
    Error('\P{Block:   _ancient_Greek_Numbers:=}');
    Expect(1, 65935, '\p{Block=:\AAncient_Greek_Numbers\z:}', "");;
    Expect(0, 65936, '\p{Block=:\AAncient_Greek_Numbers\z:}', "");;
    Expect(1, 65935, '\p{Block=ancientgreeknumbers}', "");
    Expect(0, 65935, '\p{^Block=ancientgreeknumbers}', "");
    Expect(0, 65935, '\P{Block=ancientgreeknumbers}', "");
    Expect(1, 65935, '\P{^Block=ancientgreeknumbers}', "");
    Expect(0, 65936, '\p{Block=ancientgreeknumbers}', "");
    Expect(1, 65936, '\p{^Block=ancientgreeknumbers}', "");
    Expect(1, 65936, '\P{Block=ancientgreeknumbers}', "");
    Expect(0, 65936, '\P{^Block=ancientgreeknumbers}', "");
    Expect(1, 65935, '\p{Block=:\Aancientgreeknumbers\z:}', "");;
    Expect(0, 65936, '\p{Block=:\Aancientgreeknumbers\z:}', "");;
    Expect(1, 65935, '\p{Block=	Ancient_greek_numbers}', "");
    Expect(0, 65935, '\p{^Block=	Ancient_greek_numbers}', "");
    Expect(0, 65935, '\P{Block=	Ancient_greek_numbers}', "");
    Expect(1, 65935, '\P{^Block=	Ancient_greek_numbers}', "");
    Expect(0, 65936, '\p{Block=	Ancient_greek_numbers}', "");
    Expect(1, 65936, '\p{^Block=	Ancient_greek_numbers}', "");
    Expect(1, 65936, '\P{Block=	Ancient_greek_numbers}', "");
    Expect(0, 65936, '\P{^Block=	Ancient_greek_numbers}', "");
    Error('\p{Blk=/a/ -ancient_Greek_Numbers}');
    Error('\P{Blk=/a/ -ancient_Greek_Numbers}');
    Expect(1, 65935, '\p{Blk=:\AAncient_Greek_Numbers\z:}', "");;
    Expect(0, 65936, '\p{Blk=:\AAncient_Greek_Numbers\z:}', "");;
    Expect(1, 65935, '\p{Blk: ancientgreeknumbers}', "");
    Expect(0, 65935, '\p{^Blk: ancientgreeknumbers}', "");
    Expect(0, 65935, '\P{Blk: ancientgreeknumbers}', "");
    Expect(1, 65935, '\P{^Blk: ancientgreeknumbers}', "");
    Expect(0, 65936, '\p{Blk: ancientgreeknumbers}', "");
    Expect(1, 65936, '\p{^Blk: ancientgreeknumbers}', "");
    Expect(1, 65936, '\P{Blk: ancientgreeknumbers}', "");
    Expect(0, 65936, '\P{^Blk: ancientgreeknumbers}', "");
    Expect(1, 65935, '\p{Blk=:\Aancientgreeknumbers\z:}', "");;
    Expect(0, 65936, '\p{Blk=:\Aancientgreeknumbers\z:}', "");;
    Expect(1, 65935, '\p{Blk= ANCIENT_GREEK_numbers}', "");
    Expect(0, 65935, '\p{^Blk= ANCIENT_GREEK_numbers}', "");
    Expect(0, 65935, '\P{Blk= ANCIENT_GREEK_numbers}', "");
    Expect(1, 65935, '\P{^Blk= ANCIENT_GREEK_numbers}', "");
    Expect(0, 65936, '\p{Blk= ANCIENT_GREEK_numbers}', "");
    Expect(1, 65936, '\p{^Blk= ANCIENT_GREEK_numbers}', "");
    Expect(1, 65936, '\P{Blk= ANCIENT_GREEK_numbers}', "");
    Expect(0, 65936, '\P{^Blk= ANCIENT_GREEK_numbers}', "");
    Error('\p{Is_Block= :=ancient_Greek_Numbers}');
    Error('\P{Is_Block= :=ancient_Greek_Numbers}');
    Expect(1, 65935, '\p{Is_Block=ancientgreeknumbers}', "");
    Expect(0, 65935, '\p{^Is_Block=ancientgreeknumbers}', "");
    Expect(0, 65935, '\P{Is_Block=ancientgreeknumbers}', "");
    Expect(1, 65935, '\P{^Is_Block=ancientgreeknumbers}', "");
    Expect(0, 65936, '\p{Is_Block=ancientgreeknumbers}', "");
    Expect(1, 65936, '\p{^Is_Block=ancientgreeknumbers}', "");
    Expect(1, 65936, '\P{Is_Block=ancientgreeknumbers}', "");
    Expect(0, 65936, '\P{^Is_Block=ancientgreeknumbers}', "");
    Expect(1, 65935, '\p{Is_Block=-_ancient_GREEK_numbers}', "");
    Expect(0, 65935, '\p{^Is_Block=-_ancient_GREEK_numbers}', "");
    Expect(0, 65935, '\P{Is_Block=-_ancient_GREEK_numbers}', "");
    Expect(1, 65935, '\P{^Is_Block=-_ancient_GREEK_numbers}', "");
    Expect(0, 65936, '\p{Is_Block=-_ancient_GREEK_numbers}', "");
    Expect(1, 65936, '\p{^Is_Block=-_ancient_GREEK_numbers}', "");
    Expect(1, 65936, '\P{Is_Block=-_ancient_GREEK_numbers}', "");
    Expect(0, 65936, '\P{^Is_Block=-_ancient_GREEK_numbers}', "");
    Error('\p{Is_Blk=	/a/Ancient_Greek_numbers}');
    Error('\P{Is_Blk=	/a/Ancient_Greek_numbers}');
    Expect(1, 65935, '\p{Is_Blk:   ancientgreeknumbers}', "");
    Expect(0, 65935, '\p{^Is_Blk:   ancientgreeknumbers}', "");
    Expect(0, 65935, '\P{Is_Blk:   ancientgreeknumbers}', "");
    Expect(1, 65935, '\P{^Is_Blk:   ancientgreeknumbers}', "");
    Expect(0, 65936, '\p{Is_Blk:   ancientgreeknumbers}', "");
    Expect(1, 65936, '\p{^Is_Blk:   ancientgreeknumbers}', "");
    Expect(1, 65936, '\P{Is_Blk:   ancientgreeknumbers}', "");
    Expect(0, 65936, '\P{^Is_Blk:   ancientgreeknumbers}', "");
    Expect(1, 65935, '\p{Is_Blk=_ancient_greek_Numbers}', "");
    Expect(0, 65935, '\p{^Is_Blk=_ancient_greek_Numbers}', "");
    Expect(0, 65935, '\P{Is_Blk=_ancient_greek_Numbers}', "");
    Expect(1, 65935, '\P{^Is_Blk=_ancient_greek_Numbers}', "");
    Expect(0, 65936, '\p{Is_Blk=_ancient_greek_Numbers}', "");
    Expect(1, 65936, '\p{^Is_Blk=_ancient_greek_Numbers}', "");
    Expect(1, 65936, '\P{Is_Blk=_ancient_greek_Numbers}', "");
    Expect(0, 65936, '\P{^Is_Blk=_ancient_greek_Numbers}', "");
    Error('\p{Block=:=-Ancient_symbols}');
    Error('\P{Block=:=-Ancient_symbols}');
    Expect(1, 65999, '\p{Block=:\AAncient_Symbols\z:}', "");;
    Expect(0, 66000, '\p{Block=:\AAncient_Symbols\z:}', "");;
    Expect(1, 65999, '\p{Block:	ancientsymbols}', "");
    Expect(0, 65999, '\p{^Block:	ancientsymbols}', "");
    Expect(0, 65999, '\P{Block:	ancientsymbols}', "");
    Expect(1, 65999, '\P{^Block:	ancientsymbols}', "");
    Expect(0, 66000, '\p{Block:	ancientsymbols}', "");
    Expect(1, 66000, '\p{^Block:	ancientsymbols}', "");
    Expect(1, 66000, '\P{Block:	ancientsymbols}', "");
    Expect(0, 66000, '\P{^Block:	ancientsymbols}', "");
    Expect(1, 65999, '\p{Block=:\Aancientsymbols\z:}', "");;
    Expect(0, 66000, '\p{Block=:\Aancientsymbols\z:}', "");;
    Expect(1, 65999, '\p{Block= Ancient_Symbols}', "");
    Expect(0, 65999, '\p{^Block= Ancient_Symbols}', "");
    Expect(0, 65999, '\P{Block= Ancient_Symbols}', "");
    Expect(1, 65999, '\P{^Block= Ancient_Symbols}', "");
    Expect(0, 66000, '\p{Block= Ancient_Symbols}', "");
    Expect(1, 66000, '\p{^Block= Ancient_Symbols}', "");
    Expect(1, 66000, '\P{Block= Ancient_Symbols}', "");
    Expect(0, 66000, '\P{^Block= Ancient_Symbols}', "");
    Error('\p{Blk=	:=ANCIENT_Symbols}');
    Error('\P{Blk=	:=ANCIENT_Symbols}');
    Expect(1, 65999, '\p{Blk=:\AAncient_Symbols\z:}', "");;
    Expect(0, 66000, '\p{Blk=:\AAncient_Symbols\z:}', "");;
    Expect(1, 65999, '\p{Blk=ancientsymbols}', "");
    Expect(0, 65999, '\p{^Blk=ancientsymbols}', "");
    Expect(0, 65999, '\P{Blk=ancientsymbols}', "");
    Expect(1, 65999, '\P{^Blk=ancientsymbols}', "");
    Expect(0, 66000, '\p{Blk=ancientsymbols}', "");
    Expect(1, 66000, '\p{^Blk=ancientsymbols}', "");
    Expect(1, 66000, '\P{Blk=ancientsymbols}', "");
    Expect(0, 66000, '\P{^Blk=ancientsymbols}', "");
    Expect(1, 65999, '\p{Blk=:\Aancientsymbols\z:}', "");;
    Expect(0, 66000, '\p{Blk=:\Aancientsymbols\z:}', "");;
    Expect(1, 65999, '\p{Blk=	_Ancient_Symbols}', "");
    Expect(0, 65999, '\p{^Blk=	_Ancient_Symbols}', "");
    Expect(0, 65999, '\P{Blk=	_Ancient_Symbols}', "");
    Expect(1, 65999, '\P{^Blk=	_Ancient_Symbols}', "");
    Expect(0, 66000, '\p{Blk=	_Ancient_Symbols}', "");
    Expect(1, 66000, '\p{^Blk=	_Ancient_Symbols}', "");
    Expect(1, 66000, '\P{Blk=	_Ancient_Symbols}', "");
    Expect(0, 66000, '\P{^Blk=	_Ancient_Symbols}', "");
    Error('\p{Is_Block= /a/Ancient_SYMBOLS}');
    Error('\P{Is_Block= /a/Ancient_SYMBOLS}');
    Expect(1, 65999, '\p{Is_Block=ancientsymbols}', "");
    Expect(0, 65999, '\p{^Is_Block=ancientsymbols}', "");
    Expect(0, 65999, '\P{Is_Block=ancientsymbols}', "");
    Expect(1, 65999, '\P{^Is_Block=ancientsymbols}', "");
    Expect(0, 66000, '\p{Is_Block=ancientsymbols}', "");
    Expect(1, 66000, '\p{^Is_Block=ancientsymbols}', "");
    Expect(1, 66000, '\P{Is_Block=ancientsymbols}', "");
    Expect(0, 66000, '\P{^Is_Block=ancientsymbols}', "");
    Expect(1, 65999, '\p{Is_Block=ancient_symbols}', "");
    Expect(0, 65999, '\p{^Is_Block=ancient_symbols}', "");
    Expect(0, 65999, '\P{Is_Block=ancient_symbols}', "");
    Expect(1, 65999, '\P{^Is_Block=ancient_symbols}', "");
    Expect(0, 66000, '\p{Is_Block=ancient_symbols}', "");
    Expect(1, 66000, '\p{^Is_Block=ancient_symbols}', "");
    Expect(1, 66000, '\P{Is_Block=ancient_symbols}', "");
    Expect(0, 66000, '\P{^Is_Block=ancient_symbols}', "");
    Error('\p{Is_Blk:   /a/	Ancient_Symbols}');
    Error('\P{Is_Blk:   /a/	Ancient_Symbols}');
    Expect(1, 65999, '\p{Is_Blk=ancientsymbols}', "");
    Expect(0, 65999, '\p{^Is_Blk=ancientsymbols}', "");
    Expect(0, 65999, '\P{Is_Blk=ancientsymbols}', "");
    Expect(1, 65999, '\P{^Is_Blk=ancientsymbols}', "");
    Expect(0, 66000, '\p{Is_Blk=ancientsymbols}', "");
    Expect(1, 66000, '\p{^Is_Blk=ancientsymbols}', "");
    Expect(1, 66000, '\P{Is_Blk=ancientsymbols}', "");
    Expect(0, 66000, '\P{^Is_Blk=ancientsymbols}', "");
    Expect(1, 65999, '\p{Is_Blk=	_Ancient_Symbols}', "");
    Expect(0, 65999, '\p{^Is_Blk=	_Ancient_Symbols}', "");
    Expect(0, 65999, '\P{Is_Blk=	_Ancient_Symbols}', "");
    Expect(1, 65999, '\P{^Is_Blk=	_Ancient_Symbols}', "");
    Expect(0, 66000, '\p{Is_Blk=	_Ancient_Symbols}', "");
    Expect(1, 66000, '\p{^Is_Blk=	_Ancient_Symbols}', "");
    Expect(1, 66000, '\P{Is_Blk=	_Ancient_Symbols}', "");
    Expect(0, 66000, '\P{^Is_Blk=	_Ancient_Symbols}', "");
    Error('\p{Block=/a/	-Arabic}');
    Error('\P{Block=/a/	-Arabic}');
    Expect(1, 1791, '\p{Block=:\AArabic\z:}', "");;
    Expect(0, 1792, '\p{Block=:\AArabic\z:}', "");;
    Expect(1, 1791, '\p{Block=arabic}', "");
    Expect(0, 1791, '\p{^Block=arabic}', "");
    Expect(0, 1791, '\P{Block=arabic}', "");
    Expect(1, 1791, '\P{^Block=arabic}', "");
    Expect(0, 1792, '\p{Block=arabic}', "");
    Expect(1, 1792, '\p{^Block=arabic}', "");
    Expect(1, 1792, '\P{Block=arabic}', "");
    Expect(0, 1792, '\P{^Block=arabic}', "");
    Expect(1, 1791, '\p{Block=:\Aarabic\z:}', "");;
    Expect(0, 1792, '\p{Block=:\Aarabic\z:}', "");;
    Expect(1, 1791, '\p{Block= 	Arabic}', "");
    Expect(0, 1791, '\p{^Block= 	Arabic}', "");
    Expect(0, 1791, '\P{Block= 	Arabic}', "");
    Expect(1, 1791, '\P{^Block= 	Arabic}', "");
    Expect(0, 1792, '\p{Block= 	Arabic}', "");
    Expect(1, 1792, '\p{^Block= 	Arabic}', "");
    Expect(1, 1792, '\P{Block= 	Arabic}', "");
    Expect(0, 1792, '\P{^Block= 	Arabic}', "");
    Error('\p{Blk:   /a/__arabic}');
    Error('\P{Blk:   /a/__arabic}');
    Expect(1, 1791, '\p{Blk=:\AArabic\z:}', "");;
    Expect(0, 1792, '\p{Blk=:\AArabic\z:}', "");;
    Expect(1, 1791, '\p{Blk=arabic}', "");
    Expect(0, 1791, '\p{^Blk=arabic}', "");
    Expect(0, 1791, '\P{Blk=arabic}', "");
    Expect(1, 1791, '\P{^Blk=arabic}', "");
    Expect(0, 1792, '\p{Blk=arabic}', "");
    Expect(1, 1792, '\p{^Blk=arabic}', "");
    Expect(1, 1792, '\P{Blk=arabic}', "");
    Expect(0, 1792, '\P{^Blk=arabic}', "");
    Expect(1, 1791, '\p{Blk=:\Aarabic\z:}', "");;
    Expect(0, 1792, '\p{Blk=:\Aarabic\z:}', "");;
    Expect(1, 1791, '\p{Blk=_ Arabic}', "");
    Expect(0, 1791, '\p{^Blk=_ Arabic}', "");
    Expect(0, 1791, '\P{Blk=_ Arabic}', "");
    Expect(1, 1791, '\P{^Blk=_ Arabic}', "");
    Expect(0, 1792, '\p{Blk=_ Arabic}', "");
    Expect(1, 1792, '\p{^Blk=_ Arabic}', "");
    Expect(1, 1792, '\P{Blk=_ Arabic}', "");
    Expect(0, 1792, '\P{^Blk=_ Arabic}', "");
    Error('\p{Is_Block=:=-_Arabic}');
    Error('\P{Is_Block=:=-_Arabic}');
    Expect(1, 1791, '\p{Is_Block=arabic}', "");
    Expect(0, 1791, '\p{^Is_Block=arabic}', "");
    Expect(0, 1791, '\P{Is_Block=arabic}', "");
    Expect(1, 1791, '\P{^Is_Block=arabic}', "");
    Expect(0, 1792, '\p{Is_Block=arabic}', "");
    Expect(1, 1792, '\p{^Is_Block=arabic}', "");
    Expect(1, 1792, '\P{Is_Block=arabic}', "");
    Expect(0, 1792, '\P{^Is_Block=arabic}', "");
    Expect(1, 1791, '\p{Is_Block=_arabic}', "");
    Expect(0, 1791, '\p{^Is_Block=_arabic}', "");
    Expect(0, 1791, '\P{Is_Block=_arabic}', "");
    Expect(1, 1791, '\P{^Is_Block=_arabic}', "");
    Expect(0, 1792, '\p{Is_Block=_arabic}', "");
    Expect(1, 1792, '\p{^Is_Block=_arabic}', "");
    Expect(1, 1792, '\P{Is_Block=_arabic}', "");
    Expect(0, 1792, '\P{^Is_Block=_arabic}', "");
    Error('\p{Is_Blk=_:=arabic}');
    Error('\P{Is_Blk=_:=arabic}');
    Expect(1, 1791, '\p{Is_Blk=arabic}', "");
    Expect(0, 1791, '\p{^Is_Blk=arabic}', "");
    Expect(0, 1791, '\P{Is_Blk=arabic}', "");
    Expect(1, 1791, '\P{^Is_Blk=arabic}', "");
    Expect(0, 1792, '\p{Is_Blk=arabic}', "");
    Expect(1, 1792, '\p{^Is_Blk=arabic}', "");
    Expect(1, 1792, '\P{Is_Blk=arabic}', "");
    Expect(0, 1792, '\P{^Is_Blk=arabic}', "");
    Expect(1, 1791, '\p{Is_Blk:	-	Arabic}', "");
    Expect(0, 1791, '\p{^Is_Blk:	-	Arabic}', "");
    Expect(0, 1791, '\P{Is_Blk:	-	Arabic}', "");
    Expect(1, 1791, '\P{^Is_Blk:	-	Arabic}', "");
    Expect(0, 1792, '\p{Is_Blk:	-	Arabic}', "");
    Expect(1, 1792, '\p{^Is_Blk:	-	Arabic}', "");
    Expect(1, 1792, '\P{Is_Blk:	-	Arabic}', "");
    Expect(0, 1792, '\P{^Is_Blk:	-	Arabic}', "");
    Error('\p{Block=_:=arabic_EXTENDED_A}');
    Error('\P{Block=_:=arabic_EXTENDED_A}');
    Expect(1, 2303, '\p{Block=:\AArabic_Extended_A\z:}', "");;
    Expect(0, 2304, '\p{Block=:\AArabic_Extended_A\z:}', "");;
    Expect(1, 2303, '\p{Block=arabicextendeda}', "");
    Expect(0, 2303, '\p{^Block=arabicextendeda}', "");
    Expect(0, 2303, '\P{Block=arabicextendeda}', "");
    Expect(1, 2303, '\P{^Block=arabicextendeda}', "");
    Expect(0, 2304, '\p{Block=arabicextendeda}', "");
    Expect(1, 2304, '\p{^Block=arabicextendeda}', "");
    Expect(1, 2304, '\P{Block=arabicextendeda}', "");
    Expect(0, 2304, '\P{^Block=arabicextendeda}', "");
    Expect(1, 2303, '\p{Block=:\Aarabicextendeda\z:}', "");;
    Expect(0, 2304, '\p{Block=:\Aarabicextendeda\z:}', "");;
    Expect(1, 2303, '\p{Block=-ARABIC_EXTENDED_A}', "");
    Expect(0, 2303, '\p{^Block=-ARABIC_EXTENDED_A}', "");
    Expect(0, 2303, '\P{Block=-ARABIC_EXTENDED_A}', "");
    Expect(1, 2303, '\P{^Block=-ARABIC_EXTENDED_A}', "");
    Expect(0, 2304, '\p{Block=-ARABIC_EXTENDED_A}', "");
    Expect(1, 2304, '\p{^Block=-ARABIC_EXTENDED_A}', "");
    Expect(1, 2304, '\P{Block=-ARABIC_EXTENDED_A}', "");
    Expect(0, 2304, '\P{^Block=-ARABIC_EXTENDED_A}', "");
    Error('\p{Blk:--Arabic_EXT_A/a/}');
    Error('\P{Blk:--Arabic_EXT_A/a/}');
    Expect(1, 2303, '\p{Blk=:\AArabic_Ext_A\z:}', "");;
    Expect(0, 2304, '\p{Blk=:\AArabic_Ext_A\z:}', "");;
    Expect(1, 2303, '\p{Blk=arabicexta}', "");
    Expect(0, 2303, '\p{^Blk=arabicexta}', "");
    Expect(0, 2303, '\P{Blk=arabicexta}', "");
    Expect(1, 2303, '\P{^Blk=arabicexta}', "");
    Expect(0, 2304, '\p{Blk=arabicexta}', "");
    Expect(1, 2304, '\p{^Blk=arabicexta}', "");
    Expect(1, 2304, '\P{Blk=arabicexta}', "");
    Expect(0, 2304, '\P{^Blk=arabicexta}', "");
    Expect(1, 2303, '\p{Blk=:\Aarabicexta\z:}', "");;
    Expect(0, 2304, '\p{Blk=:\Aarabicexta\z:}', "");;
    Expect(1, 2303, '\p{Blk=--arabic_Ext_A}', "");
    Expect(0, 2303, '\p{^Blk=--arabic_Ext_A}', "");
    Expect(0, 2303, '\P{Blk=--arabic_Ext_A}', "");
    Expect(1, 2303, '\P{^Blk=--arabic_Ext_A}', "");
    Expect(0, 2304, '\p{Blk=--arabic_Ext_A}', "");
    Expect(1, 2304, '\p{^Blk=--arabic_Ext_A}', "");
    Expect(1, 2304, '\P{Blk=--arabic_Ext_A}', "");
    Expect(0, 2304, '\P{^Blk=--arabic_Ext_A}', "");
    Error('\p{Is_Block=_:=Arabic_Extended_a}');
    Error('\P{Is_Block=_:=Arabic_Extended_a}');
    Expect(1, 2303, '\p{Is_Block=arabicextendeda}', "");
    Expect(0, 2303, '\p{^Is_Block=arabicextendeda}', "");
    Expect(0, 2303, '\P{Is_Block=arabicextendeda}', "");
    Expect(1, 2303, '\P{^Is_Block=arabicextendeda}', "");
    Expect(0, 2304, '\p{Is_Block=arabicextendeda}', "");
    Expect(1, 2304, '\p{^Is_Block=arabicextendeda}', "");
    Expect(1, 2304, '\P{Is_Block=arabicextendeda}', "");
    Expect(0, 2304, '\P{^Is_Block=arabicextendeda}', "");
    Expect(1, 2303, '\p{Is_Block=__arabic_Extended_A}', "");
    Expect(0, 2303, '\p{^Is_Block=__arabic_Extended_A}', "");
    Expect(0, 2303, '\P{Is_Block=__arabic_Extended_A}', "");
    Expect(1, 2303, '\P{^Is_Block=__arabic_Extended_A}', "");
    Expect(0, 2304, '\p{Is_Block=__arabic_Extended_A}', "");
    Expect(1, 2304, '\p{^Is_Block=__arabic_Extended_A}', "");
    Expect(1, 2304, '\P{Is_Block=__arabic_Extended_A}', "");
    Expect(0, 2304, '\P{^Is_Block=__arabic_Extended_A}', "");
    Error('\p{Is_Blk=_-Arabic_Ext_A:=}');
    Error('\P{Is_Blk=_-Arabic_Ext_A:=}');
    Expect(1, 2303, '\p{Is_Blk=arabicexta}', "");
    Expect(0, 2303, '\p{^Is_Blk=arabicexta}', "");
    Expect(0, 2303, '\P{Is_Blk=arabicexta}', "");
    Expect(1, 2303, '\P{^Is_Blk=arabicexta}', "");
    Expect(0, 2304, '\p{Is_Blk=arabicexta}', "");
    Expect(1, 2304, '\p{^Is_Blk=arabicexta}', "");
    Expect(1, 2304, '\P{Is_Blk=arabicexta}', "");
    Expect(0, 2304, '\P{^Is_Blk=arabicexta}', "");
    Expect(1, 2303, '\p{Is_Blk=	_arabic_Ext_A}', "");
    Expect(0, 2303, '\p{^Is_Blk=	_arabic_Ext_A}', "");
    Expect(0, 2303, '\P{Is_Blk=	_arabic_Ext_A}', "");
    Expect(1, 2303, '\P{^Is_Blk=	_arabic_Ext_A}', "");
    Expect(0, 2304, '\p{Is_Blk=	_arabic_Ext_A}', "");
    Expect(1, 2304, '\p{^Is_Blk=	_arabic_Ext_A}', "");
    Expect(1, 2304, '\P{Is_Blk=	_arabic_Ext_A}', "");
    Expect(0, 2304, '\P{^Is_Blk=	_arabic_Ext_A}', "");
    Error('\p{Block=_-ARABIC_Extended_b:=}');
    Error('\P{Block=_-ARABIC_Extended_b:=}');
    Expect(1, 2207, '\p{Block=:\AArabic_Extended_B\z:}', "");;
    Expect(0, 2208, '\p{Block=:\AArabic_Extended_B\z:}', "");;
    Expect(1, 2207, '\p{Block=arabicextendedb}', "");
    Expect(0, 2207, '\p{^Block=arabicextendedb}', "");
    Expect(0, 2207, '\P{Block=arabicextendedb}', "");
    Expect(1, 2207, '\P{^Block=arabicextendedb}', "");
    Expect(0, 2208, '\p{Block=arabicextendedb}', "");
    Expect(1, 2208, '\p{^Block=arabicextendedb}', "");
    Expect(1, 2208, '\P{Block=arabicextendedb}', "");
    Expect(0, 2208, '\P{^Block=arabicextendedb}', "");
    Expect(1, 2207, '\p{Block=:\Aarabicextendedb\z:}', "");;
    Expect(0, 2208, '\p{Block=:\Aarabicextendedb\z:}', "");;
    Expect(1, 2207, '\p{Block=	_Arabic_Extended_B}', "");
    Expect(0, 2207, '\p{^Block=	_Arabic_Extended_B}', "");
    Expect(0, 2207, '\P{Block=	_Arabic_Extended_B}', "");
    Expect(1, 2207, '\P{^Block=	_Arabic_Extended_B}', "");
    Expect(0, 2208, '\p{Block=	_Arabic_Extended_B}', "");
    Expect(1, 2208, '\p{^Block=	_Arabic_Extended_B}', "");
    Expect(1, 2208, '\P{Block=	_Arabic_Extended_B}', "");
    Expect(0, 2208, '\P{^Block=	_Arabic_Extended_B}', "");
    Error('\p{Blk=__ARABIC_EXT_B/a/}');
    Error('\P{Blk=__ARABIC_EXT_B/a/}');
    Expect(1, 2207, '\p{Blk=:\AArabic_Ext_B\z:}', "");;
    Expect(0, 2208, '\p{Blk=:\AArabic_Ext_B\z:}', "");;
    Expect(1, 2207, '\p{Blk=arabicextb}', "");
    Expect(0, 2207, '\p{^Blk=arabicextb}', "");
    Expect(0, 2207, '\P{Blk=arabicextb}', "");
    Expect(1, 2207, '\P{^Blk=arabicextb}', "");
    Expect(0, 2208, '\p{Blk=arabicextb}', "");
    Expect(1, 2208, '\p{^Blk=arabicextb}', "");
    Expect(1, 2208, '\P{Blk=arabicextb}', "");
    Expect(0, 2208, '\P{^Blk=arabicextb}', "");
    Expect(1, 2207, '\p{Blk=:\Aarabicextb\z:}', "");;
    Expect(0, 2208, '\p{Blk=:\Aarabicextb\z:}', "");;
    Expect(1, 2207, '\p{Blk:   	 Arabic_EXT_B}', "");
    Expect(0, 2207, '\p{^Blk:   	 Arabic_EXT_B}', "");
    Expect(0, 2207, '\P{Blk:   	 Arabic_EXT_B}', "");
    Expect(1, 2207, '\P{^Blk:   	 Arabic_EXT_B}', "");
    Expect(0, 2208, '\p{Blk:   	 Arabic_EXT_B}', "");
    Expect(1, 2208, '\p{^Blk:   	 Arabic_EXT_B}', "");
    Expect(1, 2208, '\P{Blk:   	 Arabic_EXT_B}', "");
    Expect(0, 2208, '\P{^Blk:   	 Arabic_EXT_B}', "");
    Error('\p{Is_Block=- arabic_Extended_b/a/}');
    Error('\P{Is_Block=- arabic_Extended_b/a/}');
    Expect(1, 2207, '\p{Is_Block:arabicextendedb}', "");
    Expect(0, 2207, '\p{^Is_Block:arabicextendedb}', "");
    Expect(0, 2207, '\P{Is_Block:arabicextendedb}', "");
    Expect(1, 2207, '\P{^Is_Block:arabicextendedb}', "");
    Expect(0, 2208, '\p{Is_Block:arabicextendedb}', "");
    Expect(1, 2208, '\p{^Is_Block:arabicextendedb}', "");
    Expect(1, 2208, '\P{Is_Block:arabicextendedb}', "");
    Expect(0, 2208, '\P{^Is_Block:arabicextendedb}', "");
    Expect(1, 2207, '\p{Is_Block:	 -Arabic_Extended_B}', "");
    Expect(0, 2207, '\p{^Is_Block:	 -Arabic_Extended_B}', "");
    Expect(0, 2207, '\P{Is_Block:	 -Arabic_Extended_B}', "");
    Expect(1, 2207, '\P{^Is_Block:	 -Arabic_Extended_B}', "");
    Expect(0, 2208, '\p{Is_Block:	 -Arabic_Extended_B}', "");
    Expect(1, 2208, '\p{^Is_Block:	 -Arabic_Extended_B}', "");
    Expect(1, 2208, '\P{Is_Block:	 -Arabic_Extended_B}', "");
    Expect(0, 2208, '\P{^Is_Block:	 -Arabic_Extended_B}', "");
    Error('\p{Is_Blk=/a/arabic_Ext_B}');
    Error('\P{Is_Blk=/a/arabic_Ext_B}');
    Expect(1, 2207, '\p{Is_Blk=arabicextb}', "");
    Expect(0, 2207, '\p{^Is_Blk=arabicextb}', "");
    Expect(0, 2207, '\P{Is_Blk=arabicextb}', "");
    Expect(1, 2207, '\P{^Is_Blk=arabicextb}', "");
    Expect(0, 2208, '\p{Is_Blk=arabicextb}', "");
    Expect(1, 2208, '\p{^Is_Blk=arabicextb}', "");
    Expect(1, 2208, '\P{Is_Blk=arabicextb}', "");
    Expect(0, 2208, '\P{^Is_Blk=arabicextb}', "");
    Expect(1, 2207, '\p{Is_Blk:		-ARABIC_Ext_B}', "");
    Expect(0, 2207, '\p{^Is_Blk:		-ARABIC_Ext_B}', "");
    Expect(0, 2207, '\P{Is_Blk:		-ARABIC_Ext_B}', "");
    Expect(1, 2207, '\P{^Is_Blk:		-ARABIC_Ext_B}', "");
    Expect(0, 2208, '\p{Is_Blk:		-ARABIC_Ext_B}', "");
    Expect(1, 2208, '\p{^Is_Blk:		-ARABIC_Ext_B}', "");
    Expect(1, 2208, '\P{Is_Blk:		-ARABIC_Ext_B}', "");
    Expect(0, 2208, '\P{^Is_Blk:		-ARABIC_Ext_B}', "");
    Error('\p{Block:    /a/ARABIC_MATHEMATICAL_Alphabetic_symbols}');
    Error('\P{Block:    /a/ARABIC_MATHEMATICAL_Alphabetic_symbols}');
    Expect(1, 126719, '\p{Block=:\AArabic_Mathematical_Alphabetic_Symbols\z:}', "");;
    Expect(0, 126720, '\p{Block=:\AArabic_Mathematical_Alphabetic_Symbols\z:}', "");;
    Expect(1, 126719, '\p{Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126719, '\p{^Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126719, '\P{Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126719, '\P{^Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126720, '\p{Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126720, '\p{^Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126720, '\P{Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126720, '\P{^Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126719, '\p{Block=:\Aarabicmathematicalalphabeticsymbols\z:}', "");;
    Expect(0, 126720, '\p{Block=:\Aarabicmathematicalalphabeticsymbols\z:}', "");;
    Expect(1, 126719, '\p{Block:   	-ARABIC_Mathematical_ALPHABETIC_symbols}', "");
    Expect(0, 126719, '\p{^Block:   	-ARABIC_Mathematical_ALPHABETIC_symbols}', "");
    Expect(0, 126719, '\P{Block:   	-ARABIC_Mathematical_ALPHABETIC_symbols}', "");
    Expect(1, 126719, '\P{^Block:   	-ARABIC_Mathematical_ALPHABETIC_symbols}', "");
    Expect(0, 126720, '\p{Block:   	-ARABIC_Mathematical_ALPHABETIC_symbols}', "");
    Expect(1, 126720, '\p{^Block:   	-ARABIC_Mathematical_ALPHABETIC_symbols}', "");
    Expect(1, 126720, '\P{Block:   	-ARABIC_Mathematical_ALPHABETIC_symbols}', "");
    Expect(0, 126720, '\P{^Block:   	-ARABIC_Mathematical_ALPHABETIC_symbols}', "");
    Error('\p{Blk=/a/	_Arabic_math}');
    Error('\P{Blk=/a/	_Arabic_math}');
    Expect(1, 126719, '\p{Blk=:\AArabic_Math\z:}', "");;
    Expect(0, 126720, '\p{Blk=:\AArabic_Math\z:}', "");;
    Expect(1, 126719, '\p{Blk=arabicmath}', "");
    Expect(0, 126719, '\p{^Blk=arabicmath}', "");
    Expect(0, 126719, '\P{Blk=arabicmath}', "");
    Expect(1, 126719, '\P{^Blk=arabicmath}', "");
    Expect(0, 126720, '\p{Blk=arabicmath}', "");
    Expect(1, 126720, '\p{^Blk=arabicmath}', "");
    Expect(1, 126720, '\P{Blk=arabicmath}', "");
    Expect(0, 126720, '\P{^Blk=arabicmath}', "");
    Expect(1, 126719, '\p{Blk=:\Aarabicmath\z:}', "");;
    Expect(0, 126720, '\p{Blk=:\Aarabicmath\z:}', "");;
    Expect(1, 126719, '\p{Blk=_	Arabic_Math}', "");
    Expect(0, 126719, '\p{^Blk=_	Arabic_Math}', "");
    Expect(0, 126719, '\P{Blk=_	Arabic_Math}', "");
    Expect(1, 126719, '\P{^Blk=_	Arabic_Math}', "");
    Expect(0, 126720, '\p{Blk=_	Arabic_Math}', "");
    Expect(1, 126720, '\p{^Blk=_	Arabic_Math}', "");
    Expect(1, 126720, '\P{Blk=_	Arabic_Math}', "");
    Expect(0, 126720, '\P{^Blk=_	Arabic_Math}', "");
    Error('\p{Is_Block=:=-_Arabic_Mathematical_alphabetic_Symbols}');
    Error('\P{Is_Block=:=-_Arabic_Mathematical_alphabetic_Symbols}');
    Expect(1, 126719, '\p{Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126719, '\p{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126719, '\P{Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126719, '\P{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126720, '\p{Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126720, '\p{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126720, '\P{Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(0, 126720, '\P{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
    Expect(1, 126719, '\p{Is_Block=- Arabic_MATHEMATICAL_Alphabetic_Symbols}', "");
    Expect(0, 126719, '\p{^Is_Block=- Arabic_MATHEMATICAL_Alphabetic_Symbols}', "");
    Expect(0, 126719, '\P{Is_Block=- Arabic_MATHEMATICAL_Alphabetic_Symbols}', "");
    Expect(1, 126719, '\P{^Is_Block=- Arabic_MATHEMATICAL_Alphabetic_Symbols}', "");
    Expect(0, 126720, '\p{Is_Block=- Arabic_MATHEMATICAL_Alphabetic_Symbols}', "");
    Expect(1, 126720, '\p{^Is_Block=- Arabic_MATHEMATICAL_Alphabetic_Symbols}', "");
    Expect(1, 126720, '\P{Is_Block=- Arabic_MATHEMATICAL_Alphabetic_Symbols}', "");
    Expect(0, 126720, '\P{^Is_Block=- Arabic_MATHEMATICAL_Alphabetic_Symbols}', "");
    Error('\p{Is_Blk=:=	-ARABIC_Math}');
    Error('\P{Is_Blk=:=	-ARABIC_Math}');
    Expect(1, 126719, '\p{Is_Blk=arabicmath}', "");
    Expect(0, 126719, '\p{^Is_Blk=arabicmath}', "");
    Expect(0, 126719, '\P{Is_Blk=arabicmath}', "");
    Expect(1, 126719, '\P{^Is_Blk=arabicmath}', "");
    Expect(0, 126720, '\p{Is_Blk=arabicmath}', "");
    Expect(1, 126720, '\p{^Is_Blk=arabicmath}', "");
    Expect(1, 126720, '\P{Is_Blk=arabicmath}', "");
    Expect(0, 126720, '\P{^Is_Blk=arabicmath}', "");
    Expect(1, 126719, '\p{Is_Blk=__arabic_Math}', "");
    Expect(0, 126719, '\p{^Is_Blk=__arabic_Math}', "");
    Expect(0, 126719, '\P{Is_Blk=__arabic_Math}', "");
    Expect(1, 126719, '\P{^Is_Blk=__arabic_Math}', "");
    Expect(0, 126720, '\p{Is_Blk=__arabic_Math}', "");
    Expect(1, 126720, '\p{^Is_Blk=__arabic_Math}', "");
    Expect(1, 126720, '\P{Is_Blk=__arabic_Math}', "");
    Expect(0, 126720, '\P{^Is_Blk=__arabic_Math}', "");
    Error('\p{Block=/a/Arabic_Presentation_FORMS_A}');
    Error('\P{Block=/a/Arabic_Presentation_FORMS_A}');
    Expect(1, 65023, '\p{Block=:\AArabic_Presentation_Forms_A\z:}', "");;
    Expect(0, 65024, '\p{Block=:\AArabic_Presentation_Forms_A\z:}', "");;
    Expect(1, 65023, '\p{Block=arabicpresentationformsa}', "");
    Expect(0, 65023, '\p{^Block=arabicpresentationformsa}', "");
    Expect(0, 65023, '\P{Block=arabicpresentationformsa}', "");
    Expect(1, 65023, '\P{^Block=arabicpresentationformsa}', "");
    Expect(0, 65024, '\p{Block=arabicpresentationformsa}', "");
    Expect(1, 65024, '\p{^Block=arabicpresentationformsa}', "");
    Expect(1, 65024, '\P{Block=arabicpresentationformsa}', "");
    Expect(0, 65024, '\P{^Block=arabicpresentationformsa}', "");
    Expect(1, 65023, '\p{Block=:\Aarabicpresentationformsa\z:}', "");;
    Expect(0, 65024, '\p{Block=:\Aarabicpresentationformsa\z:}', "");;
    Expect(1, 65023, '\p{Block:	-_ARABIC_presentation_Forms_a}', "");
    Expect(0, 65023, '\p{^Block:	-_ARABIC_presentation_Forms_a}', "");
    Expect(0, 65023, '\P{Block:	-_ARABIC_presentation_Forms_a}', "");
    Expect(1, 65023, '\P{^Block:	-_ARABIC_presentation_Forms_a}', "");
    Expect(0, 65024, '\p{Block:	-_ARABIC_presentation_Forms_a}', "");
    Expect(1, 65024, '\p{^Block:	-_ARABIC_presentation_Forms_a}', "");
    Expect(1, 65024, '\P{Block:	-_ARABIC_presentation_Forms_a}', "");
    Expect(0, 65024, '\P{^Block:	-_ARABIC_presentation_Forms_a}', "");
    Error('\p{Blk:	-Arabic_PF_A:=}');
    Error('\P{Blk:	-Arabic_PF_A:=}');
    Expect(1, 65023, '\p{Blk=:\AArabic_PF_A\z:}', "");;
    Expect(0, 65024, '\p{Blk=:\AArabic_PF_A\z:}', "");;
    Expect(1, 65023, '\p{Blk=arabicpfa}', "");
    Expect(0, 65023, '\p{^Blk=arabicpfa}', "");
    Expect(0, 65023, '\P{Blk=arabicpfa}', "");
    Expect(1, 65023, '\P{^Blk=arabicpfa}', "");
    Expect(0, 65024, '\p{Blk=arabicpfa}', "");
    Expect(1, 65024, '\p{^Blk=arabicpfa}', "");
    Expect(1, 65024, '\P{Blk=arabicpfa}', "");
    Expect(0, 65024, '\P{^Blk=arabicpfa}', "");
    Expect(1, 65023, '\p{Blk=:\Aarabicpfa\z:}', "");;
    Expect(0, 65024, '\p{Blk=:\Aarabicpfa\z:}', "");;
    Expect(1, 65023, '\p{Blk=_-Arabic_PF_A}', "");
    Expect(0, 65023, '\p{^Blk=_-Arabic_PF_A}', "");
    Expect(0, 65023, '\P{Blk=_-Arabic_PF_A}', "");
    Expect(1, 65023, '\P{^Blk=_-Arabic_PF_A}', "");
    Expect(0, 65024, '\p{Blk=_-Arabic_PF_A}', "");
    Expect(1, 65024, '\p{^Blk=_-Arabic_PF_A}', "");
    Expect(1, 65024, '\P{Blk=_-Arabic_PF_A}', "");
    Expect(0, 65024, '\P{^Blk=_-Arabic_PF_A}', "");
    Error('\p{Is_Block=/a/-ARABIC_presentation_forms_a}');
    Error('\P{Is_Block=/a/-ARABIC_presentation_forms_a}');
    Expect(1, 65023, '\p{Is_Block=arabicpresentationformsa}', "");
    Expect(0, 65023, '\p{^Is_Block=arabicpresentationformsa}', "");
    Expect(0, 65023, '\P{Is_Block=arabicpresentationformsa}', "");
    Expect(1, 65023, '\P{^Is_Block=arabicpresentationformsa}', "");
    Expect(0, 65024, '\p{Is_Block=arabicpresentationformsa}', "");
    Expect(1, 65024, '\p{^Is_Block=arabicpresentationformsa}', "");
    Expect(1, 65024, '\P{Is_Block=arabicpresentationformsa}', "");
    Expect(0, 65024, '\P{^Is_Block=arabicpresentationformsa}', "");
    Expect(1, 65023, '\p{Is_Block=	-arabic_PRESENTATION_FORMS_A}', "");
    Expect(0, 65023, '\p{^Is_Block=	-arabic_PRESENTATION_FORMS_A}', "");
    Expect(0, 65023, '\P{Is_Block=	-arabic_PRESENTATION_FORMS_A}', "");
    Expect(1, 65023, '\P{^Is_Block=	-arabic_PRESENTATION_FORMS_A}', "");
    Expect(0, 65024, '\p{Is_Block=	-arabic_PRESENTATION_FORMS_A}', "");
    Expect(1, 65024, '\p{^Is_Block=	-arabic_PRESENTATION_FORMS_A}', "");
    Expect(1, 65024, '\P{Is_Block=	-arabic_PRESENTATION_FORMS_A}', "");
    Expect(0, 65024, '\P{^Is_Block=	-arabic_PRESENTATION_FORMS_A}', "");
    Error('\p{Is_Blk=	/a/Arabic_PF_A}');
    Error('\P{Is_Blk=	/a/Arabic_PF_A}');
    Expect(1, 65023, '\p{Is_Blk=arabicpfa}', "");
    Expect(0, 65023, '\p{^Is_Blk=arabicpfa}', "");
    Expect(0, 65023, '\P{Is_Blk=arabicpfa}', "");
    Expect(1, 65023, '\P{^Is_Blk=arabicpfa}', "");
    Expect(0, 65024, '\p{Is_Blk=arabicpfa}', "");
    Expect(1, 65024, '\p{^Is_Blk=arabicpfa}', "");
    Expect(1, 65024, '\P{Is_Blk=arabicpfa}', "");
    Expect(0, 65024, '\P{^Is_Blk=arabicpfa}', "");
    Expect(1, 65023, '\p{Is_Blk=--Arabic_PF_A}', "");
    Expect(0, 65023, '\p{^Is_Blk=--Arabic_PF_A}', "");
    Expect(0, 65023, '\P{Is_Blk=--Arabic_PF_A}', "");
    Expect(1, 65023, '\P{^Is_Blk=--Arabic_PF_A}', "");
    Expect(0, 65024, '\p{Is_Blk=--Arabic_PF_A}', "");
    Expect(1, 65024, '\p{^Is_Blk=--Arabic_PF_A}', "");
    Expect(1, 65024, '\P{Is_Blk=--Arabic_PF_A}', "");
    Expect(0, 65024, '\P{^Is_Blk=--Arabic_PF_A}', "");
    Error('\p{Block=--ARABIC_Presentation_FORMS_B:=}');
    Error('\P{Block=--ARABIC_Presentation_FORMS_B:=}');
    Expect(1, 65279, '\p{Block=:\AArabic_Presentation_Forms_B\z:}', "");;
    Expect(0, 65280, '\p{Block=:\AArabic_Presentation_Forms_B\z:}', "");;
    Expect(1, 65279, '\p{Block=arabicpresentationformsb}', "");
    Expect(0, 65279, '\p{^Block=arabicpresentationformsb}', "");
    Expect(0, 65279, '\P{Block=arabicpresentationformsb}', "");
    Expect(1, 65279, '\P{^Block=arabicpresentationformsb}', "");
    Expect(0, 65280, '\p{Block=arabicpresentationformsb}', "");
    Expect(1, 65280, '\p{^Block=arabicpresentationformsb}', "");
    Expect(1, 65280, '\P{Block=arabicpresentationformsb}', "");
    Expect(0, 65280, '\P{^Block=arabicpresentationformsb}', "");
    Expect(1, 65279, '\p{Block=:\Aarabicpresentationformsb\z:}', "");;
    Expect(0, 65280, '\p{Block=:\Aarabicpresentationformsb\z:}', "");;
    Expect(1, 65279, '\p{Block=_	Arabic_presentation_FORMS_B}', "");
    Expect(0, 65279, '\p{^Block=_	Arabic_presentation_FORMS_B}', "");
    Expect(0, 65279, '\P{Block=_	Arabic_presentation_FORMS_B}', "");
    Expect(1, 65279, '\P{^Block=_	Arabic_presentation_FORMS_B}', "");
    Expect(0, 65280, '\p{Block=_	Arabic_presentation_FORMS_B}', "");
    Expect(1, 65280, '\p{^Block=_	Arabic_presentation_FORMS_B}', "");
    Expect(1, 65280, '\P{Block=_	Arabic_presentation_FORMS_B}', "");
    Expect(0, 65280, '\P{^Block=_	Arabic_presentation_FORMS_B}', "");
    Error('\p{Blk=:=  Arabic_PF_b}');
    Error('\P{Blk=:=  Arabic_PF_b}');
    Expect(1, 65279, '\p{Blk=:\AArabic_PF_B\z:}', "");;
    Expect(0, 65280, '\p{Blk=:\AArabic_PF_B\z:}', "");;
    Expect(1, 65279, '\p{Blk=arabicpfb}', "");
    Expect(0, 65279, '\p{^Blk=arabicpfb}', "");
    Expect(0, 65279, '\P{Blk=arabicpfb}', "");
    Expect(1, 65279, '\P{^Blk=arabicpfb}', "");
    Expect(0, 65280, '\p{Blk=arabicpfb}', "");
    Expect(1, 65280, '\p{^Blk=arabicpfb}', "");
    Expect(1, 65280, '\P{Blk=arabicpfb}', "");
    Expect(0, 65280, '\P{^Blk=arabicpfb}', "");
    Expect(1, 65279, '\p{Blk=:\Aarabicpfb\z:}', "");;
    Expect(0, 65280, '\p{Blk=:\Aarabicpfb\z:}', "");;
    Expect(1, 65279, '\p{Blk=_	Arabic_PF_B}', "");
    Expect(0, 65279, '\p{^Blk=_	Arabic_PF_B}', "");
    Expect(0, 65279, '\P{Blk=_	Arabic_PF_B}', "");
    Expect(1, 65279, '\P{^Blk=_	Arabic_PF_B}', "");
    Expect(0, 65280, '\p{Blk=_	Arabic_PF_B}', "");
    Expect(1, 65280, '\p{^Blk=_	Arabic_PF_B}', "");
    Expect(1, 65280, '\P{Blk=_	Arabic_PF_B}', "");
    Expect(0, 65280, '\P{^Blk=_	Arabic_PF_B}', "");
    Error('\p{Is_Block=:=	ARABIC_PRESENTATION_Forms_B}');
    Error('\P{Is_Block=:=	ARABIC_PRESENTATION_Forms_B}');
    Expect(1, 65279, '\p{Is_Block=arabicpresentationformsb}', "");
    Expect(0, 65279, '\p{^Is_Block=arabicpresentationformsb}', "");
    Expect(0, 65279, '\P{Is_Block=arabicpresentationformsb}', "");
    Expect(1, 65279, '\P{^Is_Block=arabicpresentationformsb}', "");
    Expect(0, 65280, '\p{Is_Block=arabicpresentationformsb}', "");
    Expect(1, 65280, '\p{^Is_Block=arabicpresentationformsb}', "");
    Expect(1, 65280, '\P{Is_Block=arabicpresentationformsb}', "");
    Expect(0, 65280, '\P{^Is_Block=arabicpresentationformsb}', "");
    Expect(1, 65279, '\p{Is_Block=- ARABIC_PRESENTATION_forms_B}', "");
    Expect(0, 65279, '\p{^Is_Block=- ARABIC_PRESENTATION_forms_B}', "");
    Expect(0, 65279, '\P{Is_Block=- ARABIC_PRESENTATION_forms_B}', "");
    Expect(1, 65279, '\P{^Is_Block=- ARABIC_PRESENTATION_forms_B}', "");
    Expect(0, 65280, '\p{Is_Block=- ARABIC_PRESENTATION_forms_B}', "");
    Expect(1, 65280, '\p{^Is_Block=- ARABIC_PRESENTATION_forms_B}', "");
    Expect(1, 65280, '\P{Is_Block=- ARABIC_PRESENTATION_forms_B}', "");
    Expect(0, 65280, '\P{^Is_Block=- ARABIC_PRESENTATION_forms_B}', "");
    Error('\p{Is_Blk=	/a/arabic_PF_B}');
    Error('\P{Is_Blk=	/a/arabic_PF_B}');
    Expect(1, 65279, '\p{Is_Blk=arabicpfb}', "");
    Expect(0, 65279, '\p{^Is_Blk=arabicpfb}', "");
    Expect(0, 65279, '\P{Is_Blk=arabicpfb}', "");
    Expect(1, 65279, '\P{^Is_Blk=arabicpfb}', "");
    Expect(0, 65280, '\p{Is_Blk=arabicpfb}', "");
    Expect(1, 65280, '\p{^Is_Blk=arabicpfb}', "");
    Expect(1, 65280, '\P{Is_Blk=arabicpfb}', "");
    Expect(0, 65280, '\P{^Is_Blk=arabicpfb}', "");
    Expect(1, 65279, '\p{Is_Blk=_ ARABIC_PF_B}', "");
    Expect(0, 65279, '\p{^Is_Blk=_ ARABIC_PF_B}', "");
    Expect(0, 65279, '\P{Is_Blk=_ ARABIC_PF_B}', "");
    Expect(1, 65279, '\P{^Is_Blk=_ ARABIC_PF_B}', "");
    Expect(0, 65280, '\p{Is_Blk=_ ARABIC_PF_B}', "");
    Expect(1, 65280, '\p{^Is_Blk=_ ARABIC_PF_B}', "");
    Expect(1, 65280, '\P{Is_Blk=_ ARABIC_PF_B}', "");
    Expect(0, 65280, '\P{^Is_Blk=_ ARABIC_PF_B}', "");
    Error('\p{Block=:=	 Arabic_Supplement}');
    Error('\P{Block=:=	 Arabic_Supplement}');
    Expect(1, 1919, '\p{Block=:\AArabic_Supplement\z:}', "");;
    Expect(0, 1920, '\p{Block=:\AArabic_Supplement\z:}', "");;
    Expect(1, 1919, '\p{Block=arabicsupplement}', "");
    Expect(0, 1919, '\p{^Block=arabicsupplement}', "");
    Expect(0, 1919, '\P{Block=arabicsupplement}', "");
    Expect(1, 1919, '\P{^Block=arabicsupplement}', "");
    Expect(0, 1920, '\p{Block=arabicsupplement}', "");
    Expect(1, 1920, '\p{^Block=arabicsupplement}', "");
    Expect(1, 1920, '\P{Block=arabicsupplement}', "");
    Expect(0, 1920, '\P{^Block=arabicsupplement}', "");
    Expect(1, 1919, '\p{Block=:\Aarabicsupplement\z:}', "");;
    Expect(0, 1920, '\p{Block=:\Aarabicsupplement\z:}', "");;
    Expect(1, 1919, '\p{Block= _Arabic_supplement}', "");
    Expect(0, 1919, '\p{^Block= _Arabic_supplement}', "");
    Expect(0, 1919, '\P{Block= _Arabic_supplement}', "");
    Expect(1, 1919, '\P{^Block= _Arabic_supplement}', "");
    Expect(0, 1920, '\p{Block= _Arabic_supplement}', "");
    Expect(1, 1920, '\p{^Block= _Arabic_supplement}', "");
    Expect(1, 1920, '\P{Block= _Arabic_supplement}', "");
    Expect(0, 1920, '\P{^Block= _Arabic_supplement}', "");
    Error('\p{Blk=:=	-Arabic_Sup}');
    Error('\P{Blk=:=	-Arabic_Sup}');
    Expect(1, 1919, '\p{Blk=:\AArabic_Sup\z:}', "");;
    Expect(0, 1920, '\p{Blk=:\AArabic_Sup\z:}', "");;
    Expect(1, 1919, '\p{Blk=arabicsup}', "");
    Expect(0, 1919, '\p{^Blk=arabicsup}', "");
    Expect(0, 1919, '\P{Blk=arabicsup}', "");
    Expect(1, 1919, '\P{^Blk=arabicsup}', "");
    Expect(0, 1920, '\p{Blk=arabicsup}', "");
    Expect(1, 1920, '\p{^Blk=arabicsup}', "");
    Expect(1, 1920, '\P{Blk=arabicsup}', "");
    Expect(0, 1920, '\P{^Blk=arabicsup}', "");
    Expect(1, 1919, '\p{Blk=:\Aarabicsup\z:}', "");;
    Expect(0, 1920, '\p{Blk=:\Aarabicsup\z:}', "");;
    Expect(1, 1919, '\p{Blk=_ Arabic_sup}', "");
    Expect(0, 1919, '\p{^Blk=_ Arabic_sup}', "");
    Expect(0, 1919, '\P{Blk=_ Arabic_sup}', "");
    Expect(1, 1919, '\P{^Blk=_ Arabic_sup}', "");
    Expect(0, 1920, '\p{Blk=_ Arabic_sup}', "");
    Expect(1, 1920, '\p{^Blk=_ Arabic_sup}', "");
    Expect(1, 1920, '\P{Blk=_ Arabic_sup}', "");
    Expect(0, 1920, '\P{^Blk=_ Arabic_sup}', "");
    Error('\p{Is_Block=_	arabic_SUPPLEMENT/a/}');
    Error('\P{Is_Block=_	arabic_SUPPLEMENT/a/}');
    Expect(1, 1919, '\p{Is_Block=arabicsupplement}', "");
    Expect(0, 1919, '\p{^Is_Block=arabicsupplement}', "");
    Expect(0, 1919, '\P{Is_Block=arabicsupplement}', "");
    Expect(1, 1919, '\P{^Is_Block=arabicsupplement}', "");
    Expect(0, 1920, '\p{Is_Block=arabicsupplement}', "");
    Expect(1, 1920, '\p{^Is_Block=arabicsupplement}', "");
    Expect(1, 1920, '\P{Is_Block=arabicsupplement}', "");
    Expect(0, 1920, '\P{^Is_Block=arabicsupplement}', "");
    Expect(1, 1919, '\p{Is_Block=arabic_Supplement}', "");
    Expect(0, 1919, '\p{^Is_Block=arabic_Supplement}', "");
    Expect(0, 1919, '\P{Is_Block=arabic_Supplement}', "");
    Expect(1, 1919, '\P{^Is_Block=arabic_Supplement}', "");
    Expect(0, 1920, '\p{Is_Block=arabic_Supplement}', "");
    Expect(1, 1920, '\p{^Is_Block=arabic_Supplement}', "");
    Expect(1, 1920, '\P{Is_Block=arabic_Supplement}', "");
    Expect(0, 1920, '\P{^Is_Block=arabic_Supplement}', "");
    Error('\p{Is_Blk=/a/ -ARABIC_sup}');
    Error('\P{Is_Blk=/a/ -ARABIC_sup}');
    Expect(1, 1919, '\p{Is_Blk=arabicsup}', "");
    Expect(0, 1919, '\p{^Is_Blk=arabicsup}', "");
    Expect(0, 1919, '\P{Is_Blk=arabicsup}', "");
    Expect(1, 1919, '\P{^Is_Blk=arabicsup}', "");
    Expect(0, 1920, '\p{Is_Blk=arabicsup}', "");
    Expect(1, 1920, '\p{^Is_Blk=arabicsup}', "");
    Expect(1, 1920, '\P{Is_Blk=arabicsup}', "");
    Expect(0, 1920, '\P{^Is_Blk=arabicsup}', "");
    Expect(1, 1919, '\p{Is_Blk=-_ARABIC_Sup}', "");
    Expect(0, 1919, '\p{^Is_Blk=-_ARABIC_Sup}', "");
    Expect(0, 1919, '\P{Is_Blk=-_ARABIC_Sup}', "");
    Expect(1, 1919, '\P{^Is_Blk=-_ARABIC_Sup}', "");
    Expect(0, 1920, '\p{Is_Blk=-_ARABIC_Sup}', "");
    Expect(1, 1920, '\p{^Is_Blk=-_ARABIC_Sup}', "");
    Expect(1, 1920, '\P{Is_Blk=-_ARABIC_Sup}', "");
    Expect(0, 1920, '\P{^Is_Blk=-_ARABIC_Sup}', "");
    Error('\p{Block=:= armenian}');
    Error('\P{Block=:= armenian}');
    Expect(1, 1423, '\p{Block=:\AArmenian\z:}', "");;
    Expect(0, 1424, '\p{Block=:\AArmenian\z:}', "");;
    Expect(1, 1423, '\p{Block:   armenian}', "");
    Expect(0, 1423, '\p{^Block:   armenian}', "");
    Expect(0, 1423, '\P{Block:   armenian}', "");
    Expect(1, 1423, '\P{^Block:   armenian}', "");
    Expect(0, 1424, '\p{Block:   armenian}', "");
    Expect(1, 1424, '\p{^Block:   armenian}', "");
    Expect(1, 1424, '\P{Block:   armenian}', "");
    Expect(0, 1424, '\P{^Block:   armenian}', "");
    Expect(1, 1423, '\p{Block=:\Aarmenian\z:}', "");;
    Expect(0, 1424, '\p{Block=:\Aarmenian\z:}', "");;
    Expect(1, 1423, '\p{Block=	_Armenian}', "");
    Expect(0, 1423, '\p{^Block=	_Armenian}', "");
    Expect(0, 1423, '\P{Block=	_Armenian}', "");
    Expect(1, 1423, '\P{^Block=	_Armenian}', "");
    Expect(0, 1424, '\p{Block=	_Armenian}', "");
    Expect(1, 1424, '\p{^Block=	_Armenian}', "");
    Expect(1, 1424, '\P{Block=	_Armenian}', "");
    Expect(0, 1424, '\P{^Block=	_Armenian}', "");
    Error('\p{Blk=_:=Armenian}');
    Error('\P{Blk=_:=Armenian}');
    Expect(1, 1423, '\p{Blk=:\AArmenian\z:}', "");;
    Expect(0, 1424, '\p{Blk=:\AArmenian\z:}', "");;
    Expect(1, 1423, '\p{Blk=armenian}', "");
    Expect(0, 1423, '\p{^Blk=armenian}', "");
    Expect(0, 1423, '\P{Blk=armenian}', "");
    Expect(1, 1423, '\P{^Blk=armenian}', "");
    Expect(0, 1424, '\p{Blk=armenian}', "");
    Expect(1, 1424, '\p{^Blk=armenian}', "");
    Expect(1, 1424, '\P{Blk=armenian}', "");
    Expect(0, 1424, '\P{^Blk=armenian}', "");
    Expect(1, 1423, '\p{Blk=:\Aarmenian\z:}', "");;
    Expect(0, 1424, '\p{Blk=:\Aarmenian\z:}', "");;
    Expect(1, 1423, '\p{Blk=- Armenian}', "");
    Expect(0, 1423, '\p{^Blk=- Armenian}', "");
    Expect(0, 1423, '\P{Blk=- Armenian}', "");
    Expect(1, 1423, '\P{^Blk=- Armenian}', "");
    Expect(0, 1424, '\p{Blk=- Armenian}', "");
    Expect(1, 1424, '\p{^Blk=- Armenian}', "");
    Expect(1, 1424, '\P{Blk=- Armenian}', "");
    Expect(0, 1424, '\P{^Blk=- Armenian}', "");
    Error('\p{Is_Block= :=armenian}');
    Error('\P{Is_Block= :=armenian}');
    Expect(1, 1423, '\p{Is_Block=armenian}', "");
    Expect(0, 1423, '\p{^Is_Block=armenian}', "");
    Expect(0, 1423, '\P{Is_Block=armenian}', "");
    Expect(1, 1423, '\P{^Is_Block=armenian}', "");
    Expect(0, 1424, '\p{Is_Block=armenian}', "");
    Expect(1, 1424, '\p{^Is_Block=armenian}', "");
    Expect(1, 1424, '\P{Is_Block=armenian}', "");
    Expect(0, 1424, '\P{^Is_Block=armenian}', "");
    Expect(1, 1423, '\p{Is_Block=_	Armenian}', "");
    Expect(0, 1423, '\p{^Is_Block=_	Armenian}', "");
    Expect(0, 1423, '\P{Is_Block=_	Armenian}', "");
    Expect(1, 1423, '\P{^Is_Block=_	Armenian}', "");
    Expect(0, 1424, '\p{Is_Block=_	Armenian}', "");
    Expect(1, 1424, '\p{^Is_Block=_	Armenian}', "");
    Expect(1, 1424, '\P{Is_Block=_	Armenian}', "");
    Expect(0, 1424, '\P{^Is_Block=_	Armenian}', "");
    Error('\p{Is_Blk=-_Armenian/a/}');
    Error('\P{Is_Blk=-_Armenian/a/}');
    Expect(1, 1423, '\p{Is_Blk=armenian}', "");
    Expect(0, 1423, '\p{^Is_Blk=armenian}', "");
    Expect(0, 1423, '\P{Is_Blk=armenian}', "");
    Expect(1, 1423, '\P{^Is_Blk=armenian}', "");
    Expect(0, 1424, '\p{Is_Blk=armenian}', "");
    Expect(1, 1424, '\p{^Is_Blk=armenian}', "");
    Expect(1, 1424, '\P{Is_Blk=armenian}', "");
    Expect(0, 1424, '\P{^Is_Blk=armenian}', "");
    Expect(1, 1423, '\p{Is_Blk=_	ARMENIAN}', "");
    Expect(0, 1423, '\p{^Is_Blk=_	ARMENIAN}', "");
    Expect(0, 1423, '\P{Is_Blk=_	ARMENIAN}', "");
    Expect(1, 1423, '\P{^Is_Blk=_	ARMENIAN}', "");
    Expect(0, 1424, '\p{Is_Blk=_	ARMENIAN}', "");
    Expect(1, 1424, '\p{^Is_Blk=_	ARMENIAN}', "");
    Expect(1, 1424, '\P{Is_Blk=_	ARMENIAN}', "");
    Expect(0, 1424, '\P{^Is_Blk=_	ARMENIAN}', "");
    Error('\p{Block=-/a/arrows}');
    Error('\P{Block=-/a/arrows}');
    Expect(1, 8703, '\p{Block=:\AArrows\z:}', "");;
    Expect(0, 8704, '\p{Block=:\AArrows\z:}', "");;
    Expect(1, 8703, '\p{Block=arrows}', "");
    Expect(0, 8703, '\p{^Block=arrows}', "");
    Expect(0, 8703, '\P{Block=arrows}', "");
    Expect(1, 8703, '\P{^Block=arrows}', "");
    Expect(0, 8704, '\p{Block=arrows}', "");
    Expect(1, 8704, '\p{^Block=arrows}', "");
    Expect(1, 8704, '\P{Block=arrows}', "");
    Expect(0, 8704, '\P{^Block=arrows}', "");
    Expect(1, 8703, '\p{Block=:\Aarrows\z:}', "");;
    Expect(0, 8704, '\p{Block=:\Aarrows\z:}', "");;
    Expect(1, 8703, '\p{Block=- ARROWS}', "");
    Expect(0, 8703, '\p{^Block=- ARROWS}', "");
    Expect(0, 8703, '\P{Block=- ARROWS}', "");
    Expect(1, 8703, '\P{^Block=- ARROWS}', "");
    Expect(0, 8704, '\p{Block=- ARROWS}', "");
    Expect(1, 8704, '\p{^Block=- ARROWS}', "");
    Expect(1, 8704, '\P{Block=- ARROWS}', "");
    Expect(0, 8704, '\P{^Block=- ARROWS}', "");
    Error('\p{Blk=_Arrows:=}');
    Error('\P{Blk=_Arrows:=}');
    Expect(1, 8703, '\p{Blk=:\AArrows\z:}', "");;
    Expect(0, 8704, '\p{Blk=:\AArrows\z:}', "");;
    Expect(1, 8703, '\p{Blk=arrows}', "");
    Expect(0, 8703, '\p{^Blk=arrows}', "");
    Expect(0, 8703, '\P{Blk=arrows}', "");
    Expect(1, 8703, '\P{^Blk=arrows}', "");
    Expect(0, 8704, '\p{Blk=arrows}', "");
    Expect(1, 8704, '\p{^Blk=arrows}', "");
    Expect(1, 8704, '\P{Blk=arrows}', "");
    Expect(0, 8704, '\P{^Blk=arrows}', "");
    Expect(1, 8703, '\p{Blk=:\Aarrows\z:}', "");;
    Expect(0, 8704, '\p{Blk=:\Aarrows\z:}', "");;
    Expect(1, 8703, '\p{Blk=_ Arrows}', "");
    Expect(0, 8703, '\p{^Blk=_ Arrows}', "");
    Expect(0, 8703, '\P{Blk=_ Arrows}', "");
    Expect(1, 8703, '\P{^Blk=_ Arrows}', "");
    Expect(0, 8704, '\p{Blk=_ Arrows}', "");
    Expect(1, 8704, '\p{^Blk=_ Arrows}', "");
    Expect(1, 8704, '\P{Blk=_ Arrows}', "");
    Expect(0, 8704, '\P{^Blk=_ Arrows}', "");
    Error('\p{Is_Block:   :=_ Arrows}');
    Error('\P{Is_Block:   :=_ Arrows}');
    Expect(1, 8703, '\p{Is_Block=arrows}', "");
    Expect(0, 8703, '\p{^Is_Block=arrows}', "");
    Expect(0, 8703, '\P{Is_Block=arrows}', "");
    Expect(1, 8703, '\P{^Is_Block=arrows}', "");
    Expect(0, 8704, '\p{Is_Block=arrows}', "");
    Expect(1, 8704, '\p{^Is_Block=arrows}', "");
    Expect(1, 8704, '\P{Is_Block=arrows}', "");
    Expect(0, 8704, '\P{^Is_Block=arrows}', "");
    Expect(1, 8703, '\p{Is_Block=_ARROWS}', "");
    Expect(0, 8703, '\p{^Is_Block=_ARROWS}', "");
    Expect(0, 8703, '\P{Is_Block=_ARROWS}', "");
    Expect(1, 8703, '\P{^Is_Block=_ARROWS}', "");
    Expect(0, 8704, '\p{Is_Block=_ARROWS}', "");
    Expect(1, 8704, '\p{^Is_Block=_ARROWS}', "");
    Expect(1, 8704, '\P{Is_Block=_ARROWS}', "");
    Expect(0, 8704, '\P{^Is_Block=_ARROWS}', "");
    Error('\p{Is_Blk= -ARROWS:=}');
    Error('\P{Is_Blk= -ARROWS:=}');
    Expect(1, 8703, '\p{Is_Blk=arrows}', "");
    Expect(0, 8703, '\p{^Is_Blk=arrows}', "");
    Expect(0, 8703, '\P{Is_Blk=arrows}', "");
    Expect(1, 8703, '\P{^Is_Blk=arrows}', "");
    Expect(0, 8704, '\p{Is_Blk=arrows}', "");
    Expect(1, 8704, '\p{^Is_Blk=arrows}', "");
    Expect(1, 8704, '\P{Is_Blk=arrows}', "");
    Expect(0, 8704, '\P{^Is_Blk=arrows}', "");
    Expect(1, 8703, '\p{Is_Blk=	 Arrows}', "");
    Expect(0, 8703, '\p{^Is_Blk=	 Arrows}', "");
    Expect(0, 8703, '\P{Is_Blk=	 Arrows}', "");
    Expect(1, 8703, '\P{^Is_Blk=	 Arrows}', "");
    Expect(0, 8704, '\p{Is_Blk=	 Arrows}', "");
    Expect(1, 8704, '\p{^Is_Blk=	 Arrows}', "");
    Expect(1, 8704, '\P{Is_Blk=	 Arrows}', "");
    Expect(0, 8704, '\P{^Is_Blk=	 Arrows}', "");
    Error('\p{Block::=basic_LATIN}');
    Error('\P{Block::=basic_LATIN}');
    Expect(1, 127, '\p{Block=:\ABasic_Latin\z:}', "");;
    Expect(0, 128, '\p{Block=:\ABasic_Latin\z:}', "");;
    Expect(1, 127, '\p{Block=basiclatin}', "");
    Expect(0, 127, '\p{^Block=basiclatin}', "");
    Expect(0, 127, '\P{Block=basiclatin}', "");
    Expect(1, 127, '\P{^Block=basiclatin}', "");
    Expect(0, 128, '\p{Block=basiclatin}', "");
    Expect(1, 128, '\p{^Block=basiclatin}', "");
    Expect(1, 128, '\P{Block=basiclatin}', "");
    Expect(0, 128, '\P{^Block=basiclatin}', "");
    Expect(1, 127, '\p{Block=:\Abasiclatin\z:}', "");;
    Expect(0, 128, '\p{Block=:\Abasiclatin\z:}', "");;
    Expect(1, 127, '\p{Block=_	Basic_Latin}', "");
    Expect(0, 127, '\p{^Block=_	Basic_Latin}', "");
    Expect(0, 127, '\P{Block=_	Basic_Latin}', "");
    Expect(1, 127, '\P{^Block=_	Basic_Latin}', "");
    Expect(0, 128, '\p{Block=_	Basic_Latin}', "");
    Expect(1, 128, '\p{^Block=_	Basic_Latin}', "");
    Expect(1, 128, '\P{Block=_	Basic_Latin}', "");
    Expect(0, 128, '\P{^Block=_	Basic_Latin}', "");
    Error('\p{Blk:		 ascii:=}');
    Error('\P{Blk:		 ascii:=}');
    Expect(1, 127, '\p{Blk=:\AASCII\z:}', "");;
    Expect(0, 128, '\p{Blk=:\AASCII\z:}', "");;
    Expect(1, 127, '\p{Blk=ascii}', "");
    Expect(0, 127, '\p{^Blk=ascii}', "");
    Expect(0, 127, '\P{Blk=ascii}', "");
    Expect(1, 127, '\P{^Blk=ascii}', "");
    Expect(0, 128, '\p{Blk=ascii}', "");
    Expect(1, 128, '\p{^Blk=ascii}', "");
    Expect(1, 128, '\P{Blk=ascii}', "");
    Expect(0, 128, '\P{^Blk=ascii}', "");
    Expect(1, 127, '\p{Blk=:\Aascii\z:}', "");;
    Expect(0, 128, '\p{Blk=:\Aascii\z:}', "");;
    Expect(1, 127, '\p{Blk= _ascii}', "");
    Expect(0, 127, '\p{^Blk= _ascii}', "");
    Expect(0, 127, '\P{Blk= _ascii}', "");
    Expect(1, 127, '\P{^Blk= _ascii}', "");
    Expect(0, 128, '\p{Blk= _ascii}', "");
    Expect(1, 128, '\p{^Blk= _ascii}', "");
    Expect(1, 128, '\P{Blk= _ascii}', "");
    Expect(0, 128, '\P{^Blk= _ascii}', "");
    Error('\p{Is_Block:  :=Basic_Latin}');
    Error('\P{Is_Block:  :=Basic_Latin}');
    Expect(1, 127, '\p{Is_Block=basiclatin}', "");
    Expect(0, 127, '\p{^Is_Block=basiclatin}', "");
    Expect(0, 127, '\P{Is_Block=basiclatin}', "");
    Expect(1, 127, '\P{^Is_Block=basiclatin}', "");
    Expect(0, 128, '\p{Is_Block=basiclatin}', "");
    Expect(1, 128, '\p{^Is_Block=basiclatin}', "");
    Expect(1, 128, '\P{Is_Block=basiclatin}', "");
    Expect(0, 128, '\P{^Is_Block=basiclatin}', "");
    Expect(1, 127, '\p{Is_Block=-Basic_LATIN}', "");
    Expect(0, 127, '\p{^Is_Block=-Basic_LATIN}', "");
    Expect(0, 127, '\P{Is_Block=-Basic_LATIN}', "");
    Expect(1, 127, '\P{^Is_Block=-Basic_LATIN}', "");
    Expect(0, 128, '\p{Is_Block=-Basic_LATIN}', "");
    Expect(1, 128, '\p{^Is_Block=-Basic_LATIN}', "");
    Expect(1, 128, '\P{Is_Block=-Basic_LATIN}', "");
    Expect(0, 128, '\P{^Is_Block=-Basic_LATIN}', "");
    Error('\p{Is_Blk=_	ascii:=}');
    Error('\P{Is_Blk=_	ascii:=}');
    Expect(1, 127, '\p{Is_Blk=ascii}', "");
    Expect(0, 127, '\p{^Is_Blk=ascii}', "");
    Expect(0, 127, '\P{Is_Blk=ascii}', "");
    Expect(1, 127, '\P{^Is_Blk=ascii}', "");
    Expect(0, 128, '\p{Is_Blk=ascii}', "");
    Expect(1, 128, '\p{^Is_Blk=ascii}', "");
    Expect(1, 128, '\P{Is_Blk=ascii}', "");
    Expect(0, 128, '\P{^Is_Blk=ascii}', "");
    Expect(1, 127, '\p{Is_Blk=	 ASCII}', "");
    Expect(0, 127, '\p{^Is_Blk=	 ASCII}', "");
    Expect(0, 127, '\P{Is_Blk=	 ASCII}', "");
    Expect(1, 127, '\P{^Is_Blk=	 ASCII}', "");
    Expect(0, 128, '\p{Is_Blk=	 ASCII}', "");
    Expect(1, 128, '\p{^Is_Blk=	 ASCII}', "");
    Expect(1, 128, '\P{Is_Blk=	 ASCII}', "");
    Expect(0, 128, '\P{^Is_Blk=	 ASCII}', "");
    Error('\p{Block= /a/AVESTAN}');
    Error('\P{Block= /a/AVESTAN}');
    Expect(1, 68415, '\p{Block=:\AAvestan\z:}', "");;
    Expect(0, 68416, '\p{Block=:\AAvestan\z:}', "");;
    Expect(1, 68415, '\p{Block=avestan}', "");
    Expect(0, 68415, '\p{^Block=avestan}', "");
    Expect(0, 68415, '\P{Block=avestan}', "");
    Expect(1, 68415, '\P{^Block=avestan}', "");
    Expect(0, 68416, '\p{Block=avestan}', "");
    Expect(1, 68416, '\p{^Block=avestan}', "");
    Expect(1, 68416, '\P{Block=avestan}', "");
    Expect(0, 68416, '\P{^Block=avestan}', "");
    Expect(1, 68415, '\p{Block=:\Aavestan\z:}', "");;
    Expect(0, 68416, '\p{Block=:\Aavestan\z:}', "");;
    Expect(1, 68415, '\p{Block=__Avestan}', "");
    Expect(0, 68415, '\p{^Block=__Avestan}', "");
    Expect(0, 68415, '\P{Block=__Avestan}', "");
    Expect(1, 68415, '\P{^Block=__Avestan}', "");
    Expect(0, 68416, '\p{Block=__Avestan}', "");
    Expect(1, 68416, '\p{^Block=__Avestan}', "");
    Expect(1, 68416, '\P{Block=__Avestan}', "");
    Expect(0, 68416, '\P{^Block=__Avestan}', "");
    Error('\p{Blk=:=_ Avestan}');
    Error('\P{Blk=:=_ Avestan}');
    Expect(1, 68415, '\p{Blk=:\AAvestan\z:}', "");;
    Expect(0, 68416, '\p{Blk=:\AAvestan\z:}', "");;
    Expect(1, 68415, '\p{Blk=avestan}', "");
    Expect(0, 68415, '\p{^Blk=avestan}', "");
    Expect(0, 68415, '\P{Blk=avestan}', "");
    Expect(1, 68415, '\P{^Blk=avestan}', "");
    Expect(0, 68416, '\p{Blk=avestan}', "");
    Expect(1, 68416, '\p{^Blk=avestan}', "");
    Expect(1, 68416, '\P{Blk=avestan}', "");
    Expect(0, 68416, '\P{^Blk=avestan}', "");
    Expect(1, 68415, '\p{Blk=:\Aavestan\z:}', "");;
    Expect(0, 68416, '\p{Blk=:\Aavestan\z:}', "");;
    Expect(1, 68415, '\p{Blk=	_avestan}', "");
    Expect(0, 68415, '\p{^Blk=	_avestan}', "");
    Expect(0, 68415, '\P{Blk=	_avestan}', "");
    Expect(1, 68415, '\P{^Blk=	_avestan}', "");
    Expect(0, 68416, '\p{Blk=	_avestan}', "");
    Expect(1, 68416, '\p{^Blk=	_avestan}', "");
    Expect(1, 68416, '\P{Blk=	_avestan}', "");
    Expect(0, 68416, '\P{^Blk=	_avestan}', "");
    Error('\p{Is_Block=	:=Avestan}');
    Error('\P{Is_Block=	:=Avestan}');
    Expect(1, 68415, '\p{Is_Block=avestan}', "");
    Expect(0, 68415, '\p{^Is_Block=avestan}', "");
    Expect(0, 68415, '\P{Is_Block=avestan}', "");
    Expect(1, 68415, '\P{^Is_Block=avestan}', "");
    Expect(0, 68416, '\p{Is_Block=avestan}', "");
    Expect(1, 68416, '\p{^Is_Block=avestan}', "");
    Expect(1, 68416, '\P{Is_Block=avestan}', "");
    Expect(0, 68416, '\P{^Is_Block=avestan}', "");
    Expect(1, 68415, '\p{Is_Block=-_Avestan}', "");
    Expect(0, 68415, '\p{^Is_Block=-_Avestan}', "");
    Expect(0, 68415, '\P{Is_Block=-_Avestan}', "");
    Expect(1, 68415, '\P{^Is_Block=-_Avestan}', "");
    Expect(0, 68416, '\p{Is_Block=-_Avestan}', "");
    Expect(1, 68416, '\p{^Is_Block=-_Avestan}', "");
    Expect(1, 68416, '\P{Is_Block=-_Avestan}', "");
    Expect(0, 68416, '\P{^Is_Block=-_Avestan}', "");
    Error('\p{Is_Blk=/a/-_AVESTAN}');
    Error('\P{Is_Blk=/a/-_AVESTAN}');
    Expect(1, 68415, '\p{Is_Blk:avestan}', "");
    Expect(0, 68415, '\p{^Is_Blk:avestan}', "");
    Expect(0, 68415, '\P{Is_Blk:avestan}', "");
    Expect(1, 68415, '\P{^Is_Blk:avestan}', "");
    Expect(0, 68416, '\p{Is_Blk:avestan}', "");
    Expect(1, 68416, '\p{^Is_Blk:avestan}', "");
    Expect(1, 68416, '\P{Is_Blk:avestan}', "");
    Expect(0, 68416, '\P{^Is_Blk:avestan}', "");
    Expect(1, 68415, '\p{Is_Blk= Avestan}', "");
    Expect(0, 68415, '\p{^Is_Blk= Avestan}', "");
    Expect(0, 68415, '\P{Is_Blk= Avestan}', "");
    Expect(1, 68415, '\P{^Is_Blk= Avestan}', "");
    Expect(0, 68416, '\p{Is_Blk= Avestan}', "");
    Expect(1, 68416, '\p{^Is_Blk= Avestan}', "");
    Expect(1, 68416, '\P{Is_Blk= Avestan}', "");
    Expect(0, 68416, '\P{^Is_Blk= Avestan}', "");
    Error('\p{Block=-	Balinese:=}');
    Error('\P{Block=-	Balinese:=}');
    Expect(1, 7039, '\p{Block=:\ABalinese\z:}', "");;
    Expect(0, 7040, '\p{Block=:\ABalinese\z:}', "");;
    Expect(1, 7039, '\p{Block=balinese}', "");
    Expect(0, 7039, '\p{^Block=balinese}', "");
    Expect(0, 7039, '\P{Block=balinese}', "");
    Expect(1, 7039, '\P{^Block=balinese}', "");
    Expect(0, 7040, '\p{Block=balinese}', "");
    Expect(1, 7040, '\p{^Block=balinese}', "");
    Expect(1, 7040, '\P{Block=balinese}', "");
    Expect(0, 7040, '\P{^Block=balinese}', "");
    Expect(1, 7039, '\p{Block=:\Abalinese\z:}', "");;
    Expect(0, 7040, '\p{Block=:\Abalinese\z:}', "");;
    Expect(1, 7039, '\p{Block=_ Balinese}', "");
    Expect(0, 7039, '\p{^Block=_ Balinese}', "");
    Expect(0, 7039, '\P{Block=_ Balinese}', "");
    Expect(1, 7039, '\P{^Block=_ Balinese}', "");
    Expect(0, 7040, '\p{Block=_ Balinese}', "");
    Expect(1, 7040, '\p{^Block=_ Balinese}', "");
    Expect(1, 7040, '\P{Block=_ Balinese}', "");
    Expect(0, 7040, '\P{^Block=_ Balinese}', "");
    Error('\p{Blk=	:=Balinese}');
    Error('\P{Blk=	:=Balinese}');
    Expect(1, 7039, '\p{Blk=:\ABalinese\z:}', "");;
    Expect(0, 7040, '\p{Blk=:\ABalinese\z:}', "");;
    Expect(1, 7039, '\p{Blk=balinese}', "");
    Expect(0, 7039, '\p{^Blk=balinese}', "");
    Expect(0, 7039, '\P{Blk=balinese}', "");
    Expect(1, 7039, '\P{^Blk=balinese}', "");
    Expect(0, 7040, '\p{Blk=balinese}', "");
    Expect(1, 7040, '\p{^Blk=balinese}', "");
    Expect(1, 7040, '\P{Blk=balinese}', "");
    Expect(0, 7040, '\P{^Blk=balinese}', "");
    Expect(1, 7039, '\p{Blk=:\Abalinese\z:}', "");;
    Expect(0, 7040, '\p{Blk=:\Abalinese\z:}', "");;
    Expect(1, 7039, '\p{Blk=	_balinese}', "");
    Expect(0, 7039, '\p{^Blk=	_balinese}', "");
    Expect(0, 7039, '\P{Blk=	_balinese}', "");
    Expect(1, 7039, '\P{^Blk=	_balinese}', "");
    Expect(0, 7040, '\p{Blk=	_balinese}', "");
    Expect(1, 7040, '\p{^Blk=	_balinese}', "");
    Expect(1, 7040, '\P{Blk=	_balinese}', "");
    Expect(0, 7040, '\P{^Blk=	_balinese}', "");
    Error('\p{Is_Block= :=BALINESE}');
    Error('\P{Is_Block= :=BALINESE}');
    Expect(1, 7039, '\p{Is_Block=balinese}', "");
    Expect(0, 7039, '\p{^Is_Block=balinese}', "");
    Expect(0, 7039, '\P{Is_Block=balinese}', "");
    Expect(1, 7039, '\P{^Is_Block=balinese}', "");
    Expect(0, 7040, '\p{Is_Block=balinese}', "");
    Expect(1, 7040, '\p{^Is_Block=balinese}', "");
    Expect(1, 7040, '\P{Is_Block=balinese}', "");
    Expect(0, 7040, '\P{^Is_Block=balinese}', "");
    Expect(1, 7039, '\p{Is_Block= BALINESE}', "");
    Expect(0, 7039, '\p{^Is_Block= BALINESE}', "");
    Expect(0, 7039, '\P{Is_Block= BALINESE}', "");
    Expect(1, 7039, '\P{^Is_Block= BALINESE}', "");
    Expect(0, 7040, '\p{Is_Block= BALINESE}', "");
    Expect(1, 7040, '\p{^Is_Block= BALINESE}', "");
    Expect(1, 7040, '\P{Is_Block= BALINESE}', "");
    Expect(0, 7040, '\P{^Is_Block= BALINESE}', "");
    Error('\p{Is_Blk=/a/ Balinese}');
    Error('\P{Is_Blk=/a/ Balinese}');
    Expect(1, 7039, '\p{Is_Blk=balinese}', "");
    Expect(0, 7039, '\p{^Is_Blk=balinese}', "");
    Expect(0, 7039, '\P{Is_Blk=balinese}', "");
    Expect(1, 7039, '\P{^Is_Blk=balinese}', "");
    Expect(0, 7040, '\p{Is_Blk=balinese}', "");
    Expect(1, 7040, '\p{^Is_Blk=balinese}', "");
    Expect(1, 7040, '\P{Is_Blk=balinese}', "");
    Expect(0, 7040, '\P{^Is_Blk=balinese}', "");
    Expect(1, 7039, '\p{Is_Blk=_-BALINESE}', "");
    Expect(0, 7039, '\p{^Is_Blk=_-BALINESE}', "");
    Expect(0, 7039, '\P{Is_Blk=_-BALINESE}', "");
    Expect(1, 7039, '\P{^Is_Blk=_-BALINESE}', "");
    Expect(0, 7040, '\p{Is_Blk=_-BALINESE}', "");
    Expect(1, 7040, '\p{^Is_Blk=_-BALINESE}', "");
    Expect(1, 7040, '\P{Is_Blk=_-BALINESE}', "");
    Expect(0, 7040, '\P{^Is_Blk=_-BALINESE}', "");
    Error('\p{Block=/a/		bamum}');
    Error('\P{Block=/a/		bamum}');
    Expect(1, 42751, '\p{Block=:\ABamum\z:}', "");;
    Expect(0, 42752, '\p{Block=:\ABamum\z:}', "");;
    Expect(1, 42751, '\p{Block:   bamum}', "");
    Expect(0, 42751, '\p{^Block:   bamum}', "");
    Expect(0, 42751, '\P{Block:   bamum}', "");
    Expect(1, 42751, '\P{^Block:   bamum}', "");
    Expect(0, 42752, '\p{Block:   bamum}', "");
    Expect(1, 42752, '\p{^Block:   bamum}', "");
    Expect(1, 42752, '\P{Block:   bamum}', "");
    Expect(0, 42752, '\P{^Block:   bamum}', "");
    Expect(1, 42751, '\p{Block=:\Abamum\z:}', "");;
    Expect(0, 42752, '\p{Block=:\Abamum\z:}', "");;
    Expect(1, 42751, '\p{Block:    	Bamum}', "");
    Expect(0, 42751, '\p{^Block:    	Bamum}', "");
    Expect(0, 42751, '\P{Block:    	Bamum}', "");
    Expect(1, 42751, '\P{^Block:    	Bamum}', "");
    Expect(0, 42752, '\p{Block:    	Bamum}', "");
    Expect(1, 42752, '\p{^Block:    	Bamum}', "");
    Expect(1, 42752, '\P{Block:    	Bamum}', "");
    Expect(0, 42752, '\P{^Block:    	Bamum}', "");
    Error('\p{Blk:	-/a/Bamum}');
    Error('\P{Blk:	-/a/Bamum}');
    Expect(1, 42751, '\p{Blk=:\ABamum\z:}', "");;
    Expect(0, 42752, '\p{Blk=:\ABamum\z:}', "");;
    Expect(1, 42751, '\p{Blk=bamum}', "");
    Expect(0, 42751, '\p{^Blk=bamum}', "");
    Expect(0, 42751, '\P{Blk=bamum}', "");
    Expect(1, 42751, '\P{^Blk=bamum}', "");
    Expect(0, 42752, '\p{Blk=bamum}', "");
    Expect(1, 42752, '\p{^Blk=bamum}', "");
    Expect(1, 42752, '\P{Blk=bamum}', "");
    Expect(0, 42752, '\P{^Blk=bamum}', "");
    Expect(1, 42751, '\p{Blk=:\Abamum\z:}', "");;
    Expect(0, 42752, '\p{Blk=:\Abamum\z:}', "");;
    Expect(1, 42751, '\p{Blk=	Bamum}', "");
    Expect(0, 42751, '\p{^Blk=	Bamum}', "");
    Expect(0, 42751, '\P{Blk=	Bamum}', "");
    Expect(1, 42751, '\P{^Blk=	Bamum}', "");
    Expect(0, 42752, '\p{Blk=	Bamum}', "");
    Expect(1, 42752, '\p{^Blk=	Bamum}', "");
    Expect(1, 42752, '\P{Blk=	Bamum}', "");
    Expect(0, 42752, '\P{^Blk=	Bamum}', "");
    Error('\p{Is_Block=:=_	Bamum}');
    Error('\P{Is_Block=:=_	Bamum}');
    Expect(1, 42751, '\p{Is_Block=bamum}', "");
    Expect(0, 42751, '\p{^Is_Block=bamum}', "");
    Expect(0, 42751, '\P{Is_Block=bamum}', "");
    Expect(1, 42751, '\P{^Is_Block=bamum}', "");
    Expect(0, 42752, '\p{Is_Block=bamum}', "");
    Expect(1, 42752, '\p{^Is_Block=bamum}', "");
    Expect(1, 42752, '\P{Is_Block=bamum}', "");
    Expect(0, 42752, '\P{^Is_Block=bamum}', "");
    Expect(1, 42751, '\p{Is_Block: bamum}', "");
    Expect(0, 42751, '\p{^Is_Block: bamum}', "");
    Expect(0, 42751, '\P{Is_Block: bamum}', "");
    Expect(1, 42751, '\P{^Is_Block: bamum}', "");
    Expect(0, 42752, '\p{Is_Block: bamum}', "");
    Expect(1, 42752, '\p{^Is_Block: bamum}', "");
    Expect(1, 42752, '\P{Is_Block: bamum}', "");
    Expect(0, 42752, '\P{^Is_Block: bamum}', "");
    Error('\p{Is_Blk=--BAMUM/a/}');
    Error('\P{Is_Blk=--BAMUM/a/}');
    Expect(1, 42751, '\p{Is_Blk=bamum}', "");
    Expect(0, 42751, '\p{^Is_Blk=bamum}', "");
    Expect(0, 42751, '\P{Is_Blk=bamum}', "");
    Expect(1, 42751, '\P{^Is_Blk=bamum}', "");
    Expect(0, 42752, '\p{Is_Blk=bamum}', "");
    Expect(1, 42752, '\p{^Is_Blk=bamum}', "");
    Expect(1, 42752, '\P{Is_Blk=bamum}', "");
    Expect(0, 42752, '\P{^Is_Blk=bamum}', "");
    Expect(1, 42751, '\p{Is_Blk=-BAMUM}', "");
    Expect(0, 42751, '\p{^Is_Blk=-BAMUM}', "");
    Expect(0, 42751, '\P{Is_Blk=-BAMUM}', "");
    Expect(1, 42751, '\P{^Is_Blk=-BAMUM}', "");
    Expect(0, 42752, '\p{Is_Blk=-BAMUM}', "");
    Expect(1, 42752, '\p{^Is_Blk=-BAMUM}', "");
    Expect(1, 42752, '\P{Is_Blk=-BAMUM}', "");
    Expect(0, 42752, '\P{^Is_Blk=-BAMUM}', "");
    Error('\p{Block=-Bamum_supplement:=}');
    Error('\P{Block=-Bamum_supplement:=}');
    Expect(1, 92735, '\p{Block=:\ABamum_Supplement\z:}', "");;
    Expect(0, 92736, '\p{Block=:\ABamum_Supplement\z:}', "");;
    Expect(1, 92735, '\p{Block=bamumsupplement}', "");
    Expect(0, 92735, '\p{^Block=bamumsupplement}', "");
    Expect(0, 92735, '\P{Block=bamumsupplement}', "");
    Expect(1, 92735, '\P{^Block=bamumsupplement}', "");
    Expect(0, 92736, '\p{Block=bamumsupplement}', "");
    Expect(1, 92736, '\p{^Block=bamumsupplement}', "");
    Expect(1, 92736, '\P{Block=bamumsupplement}', "");
    Expect(0, 92736, '\P{^Block=bamumsupplement}', "");
    Expect(1, 92735, '\p{Block=:\Abamumsupplement\z:}', "");;
    Expect(0, 92736, '\p{Block=:\Abamumsupplement\z:}', "");;
    Expect(1, 92735, '\p{Block:  Bamum_Supplement}', "");
    Expect(0, 92735, '\p{^Block:  Bamum_Supplement}', "");
    Expect(0, 92735, '\P{Block:  Bamum_Supplement}', "");
    Expect(1, 92735, '\P{^Block:  Bamum_Supplement}', "");
    Expect(0, 92736, '\p{Block:  Bamum_Supplement}', "");
    Expect(1, 92736, '\p{^Block:  Bamum_Supplement}', "");
    Expect(1, 92736, '\P{Block:  Bamum_Supplement}', "");
    Expect(0, 92736, '\P{^Block:  Bamum_Supplement}', "");
    Error('\p{Blk= /a/Bamum_Sup}');
    Error('\P{Blk= /a/Bamum_Sup}');
    Expect(1, 92735, '\p{Blk=:\ABamum_Sup\z:}', "");;
    Expect(0, 92736, '\p{Blk=:\ABamum_Sup\z:}', "");;
    Expect(1, 92735, '\p{Blk=bamumsup}', "");
    Expect(0, 92735, '\p{^Blk=bamumsup}', "");
    Expect(0, 92735, '\P{Blk=bamumsup}', "");
    Expect(1, 92735, '\P{^Blk=bamumsup}', "");
    Expect(0, 92736, '\p{Blk=bamumsup}', "");
    Expect(1, 92736, '\p{^Blk=bamumsup}', "");
    Expect(1, 92736, '\P{Blk=bamumsup}', "");
    Expect(0, 92736, '\P{^Blk=bamumsup}', "");
    Expect(1, 92735, '\p{Blk=:\Abamumsup\z:}', "");;
    Expect(0, 92736, '\p{Blk=:\Abamumsup\z:}', "");;
    Expect(1, 92735, '\p{Blk=_-bamum_SUP}', "");
    Expect(0, 92735, '\p{^Blk=_-bamum_SUP}', "");
    Expect(0, 92735, '\P{Blk=_-bamum_SUP}', "");
    Expect(1, 92735, '\P{^Blk=_-bamum_SUP}', "");
    Expect(0, 92736, '\p{Blk=_-bamum_SUP}', "");
    Expect(1, 92736, '\p{^Blk=_-bamum_SUP}', "");
    Expect(1, 92736, '\P{Blk=_-bamum_SUP}', "");
    Expect(0, 92736, '\P{^Blk=_-bamum_SUP}', "");
    Error('\p{Is_Block=:=	-bamum_SUPPLEMENT}');
    Error('\P{Is_Block=:=	-bamum_SUPPLEMENT}');
    Expect(1, 92735, '\p{Is_Block:	bamumsupplement}', "");
    Expect(0, 92735, '\p{^Is_Block:	bamumsupplement}', "");
    Expect(0, 92735, '\P{Is_Block:	bamumsupplement}', "");
    Expect(1, 92735, '\P{^Is_Block:	bamumsupplement}', "");
    Expect(0, 92736, '\p{Is_Block:	bamumsupplement}', "");
    Expect(1, 92736, '\p{^Is_Block:	bamumsupplement}', "");
    Expect(1, 92736, '\P{Is_Block:	bamumsupplement}', "");
    Expect(0, 92736, '\P{^Is_Block:	bamumsupplement}', "");
    Expect(1, 92735, '\p{Is_Block=	 Bamum_Supplement}', "");
    Expect(0, 92735, '\p{^Is_Block=	 Bamum_Supplement}', "");
    Expect(0, 92735, '\P{Is_Block=	 Bamum_Supplement}', "");
    Expect(1, 92735, '\P{^Is_Block=	 Bamum_Supplement}', "");
    Expect(0, 92736, '\p{Is_Block=	 Bamum_Supplement}', "");
    Expect(1, 92736, '\p{^Is_Block=	 Bamum_Supplement}', "");
    Expect(1, 92736, '\P{Is_Block=	 Bamum_Supplement}', "");
    Expect(0, 92736, '\P{^Is_Block=	 Bamum_Supplement}', "");
    Error('\p{Is_Blk:	:= BAMUM_Sup}');
    Error('\P{Is_Blk:	:= BAMUM_Sup}');
    Expect(1, 92735, '\p{Is_Blk:	bamumsup}', "");
    Expect(0, 92735, '\p{^Is_Blk:	bamumsup}', "");
    Expect(0, 92735, '\P{Is_Blk:	bamumsup}', "");
    Expect(1, 92735, '\P{^Is_Blk:	bamumsup}', "");
    Expect(0, 92736, '\p{Is_Blk:	bamumsup}', "");
    Expect(1, 92736, '\p{^Is_Blk:	bamumsup}', "");
    Expect(1, 92736, '\P{Is_Blk:	bamumsup}', "");
    Expect(0, 92736, '\P{^Is_Blk:	bamumsup}', "");
    Expect(1, 92735, '\p{Is_Blk= _BAMUM_Sup}', "");
    Expect(0, 92735, '\p{^Is_Blk= _BAMUM_Sup}', "");
    Expect(0, 92735, '\P{Is_Blk= _BAMUM_Sup}', "");
    Expect(1, 92735, '\P{^Is_Blk= _BAMUM_Sup}', "");
    Expect(0, 92736, '\p{Is_Blk= _BAMUM_Sup}', "");
    Expect(1, 92736, '\p{^Is_Blk= _BAMUM_Sup}', "");
    Expect(1, 92736, '\P{Is_Blk= _BAMUM_Sup}', "");
    Expect(0, 92736, '\P{^Is_Blk= _BAMUM_Sup}', "");
    Error('\p{Block= _bassa_VAH/a/}');
    Error('\P{Block= _bassa_VAH/a/}');
    Expect(1, 92927, '\p{Block=:\ABassa_Vah\z:}', "");;
    Expect(0, 92928, '\p{Block=:\ABassa_Vah\z:}', "");;
    Expect(1, 92927, '\p{Block=bassavah}', "");
    Expect(0, 92927, '\p{^Block=bassavah}', "");
    Expect(0, 92927, '\P{Block=bassavah}', "");
    Expect(1, 92927, '\P{^Block=bassavah}', "");
    Expect(0, 92928, '\p{Block=bassavah}', "");
    Expect(1, 92928, '\p{^Block=bassavah}', "");
    Expect(1, 92928, '\P{Block=bassavah}', "");
    Expect(0, 92928, '\P{^Block=bassavah}', "");
    Expect(1, 92927, '\p{Block=:\Abassavah\z:}', "");;
    Expect(0, 92928, '\p{Block=:\Abassavah\z:}', "");;
    Expect(1, 92927, '\p{Block= bassa_VAH}', "");
    Expect(0, 92927, '\p{^Block= bassa_VAH}', "");
    Expect(0, 92927, '\P{Block= bassa_VAH}', "");
    Expect(1, 92927, '\P{^Block= bassa_VAH}', "");
    Expect(0, 92928, '\p{Block= bassa_VAH}', "");
    Expect(1, 92928, '\p{^Block= bassa_VAH}', "");
    Expect(1, 92928, '\P{Block= bassa_VAH}', "");
    Expect(0, 92928, '\P{^Block= bassa_VAH}', "");
    Error('\p{Blk=-BASSA_vah/a/}');
    Error('\P{Blk=-BASSA_vah/a/}');
    Expect(1, 92927, '\p{Blk=:\ABassa_Vah\z:}', "");;
    Expect(0, 92928, '\p{Blk=:\ABassa_Vah\z:}', "");;
    Expect(1, 92927, '\p{Blk=bassavah}', "");
    Expect(0, 92927, '\p{^Blk=bassavah}', "");
    Expect(0, 92927, '\P{Blk=bassavah}', "");
    Expect(1, 92927, '\P{^Blk=bassavah}', "");
    Expect(0, 92928, '\p{Blk=bassavah}', "");
    Expect(1, 92928, '\p{^Blk=bassavah}', "");
    Expect(1, 92928, '\P{Blk=bassavah}', "");
    Expect(0, 92928, '\P{^Blk=bassavah}', "");
    Expect(1, 92927, '\p{Blk=:\Abassavah\z:}', "");;
    Expect(0, 92928, '\p{Blk=:\Abassavah\z:}', "");;
    Expect(1, 92927, '\p{Blk:  -Bassa_Vah}', "");
    Expect(0, 92927, '\p{^Blk:  -Bassa_Vah}', "");
    Expect(0, 92927, '\P{Blk:  -Bassa_Vah}', "");
    Expect(1, 92927, '\P{^Blk:  -Bassa_Vah}', "");
    Expect(0, 92928, '\p{Blk:  -Bassa_Vah}', "");
    Expect(1, 92928, '\p{^Blk:  -Bassa_Vah}', "");
    Expect(1, 92928, '\P{Blk:  -Bassa_Vah}', "");
    Expect(0, 92928, '\P{^Blk:  -Bassa_Vah}', "");
    Error('\p{Is_Block=	:=BASSA_VAH}');
    Error('\P{Is_Block=	:=BASSA_VAH}');
    Expect(1, 92927, '\p{Is_Block=bassavah}', "");
    Expect(0, 92927, '\p{^Is_Block=bassavah}', "");
    Expect(0, 92927, '\P{Is_Block=bassavah}', "");
    Expect(1, 92927, '\P{^Is_Block=bassavah}', "");
    Expect(0, 92928, '\p{Is_Block=bassavah}', "");
    Expect(1, 92928, '\p{^Is_Block=bassavah}', "");
    Expect(1, 92928, '\P{Is_Block=bassavah}', "");
    Expect(0, 92928, '\P{^Is_Block=bassavah}', "");
    Expect(1, 92927, '\p{Is_Block=	_bassa_vah}', "");
    Expect(0, 92927, '\p{^Is_Block=	_bassa_vah}', "");
    Expect(0, 92927, '\P{Is_Block=	_bassa_vah}', "");
    Expect(1, 92927, '\P{^Is_Block=	_bassa_vah}', "");
    Expect(0, 92928, '\p{Is_Block=	_bassa_vah}', "");
    Expect(1, 92928, '\p{^Is_Block=	_bassa_vah}', "");
    Expect(1, 92928, '\P{Is_Block=	_bassa_vah}', "");
    Expect(0, 92928, '\P{^Is_Block=	_bassa_vah}', "");
    Error('\p{Is_Blk=:=_BASSA_Vah}');
    Error('\P{Is_Blk=:=_BASSA_Vah}');
    Expect(1, 92927, '\p{Is_Blk=bassavah}', "");
    Expect(0, 92927, '\p{^Is_Blk=bassavah}', "");
    Expect(0, 92927, '\P{Is_Blk=bassavah}', "");
    Expect(1, 92927, '\P{^Is_Blk=bassavah}', "");
    Expect(0, 92928, '\p{Is_Blk=bassavah}', "");
    Expect(1, 92928, '\p{^Is_Blk=bassavah}', "");
    Expect(1, 92928, '\P{Is_Blk=bassavah}', "");
    Expect(0, 92928, '\P{^Is_Blk=bassavah}', "");
    Expect(1, 92927, '\p{Is_Blk= -bassa_Vah}', "");
    Expect(0, 92927, '\p{^Is_Blk= -bassa_Vah}', "");
    Expect(0, 92927, '\P{Is_Blk= -bassa_Vah}', "");
    Expect(1, 92927, '\P{^Is_Blk= -bassa_Vah}', "");
    Expect(0, 92928, '\p{Is_Blk= -bassa_Vah}', "");
    Expect(1, 92928, '\p{^Is_Blk= -bassa_Vah}', "");
    Expect(1, 92928, '\P{Is_Blk= -bassa_Vah}', "");
    Expect(0, 92928, '\P{^Is_Blk= -bassa_Vah}', "");
    Error('\p{Block=/a/BATAK}');
    Error('\P{Block=/a/BATAK}');
    Expect(1, 7167, '\p{Block=:\ABatak\z:}', "");;
    Expect(0, 7168, '\p{Block=:\ABatak\z:}', "");;
    Expect(1, 7167, '\p{Block=batak}', "");
    Expect(0, 7167, '\p{^Block=batak}', "");
    Expect(0, 7167, '\P{Block=batak}', "");
    Expect(1, 7167, '\P{^Block=batak}', "");
    Expect(0, 7168, '\p{Block=batak}', "");
    Expect(1, 7168, '\p{^Block=batak}', "");
    Expect(1, 7168, '\P{Block=batak}', "");
    Expect(0, 7168, '\P{^Block=batak}', "");
    Expect(1, 7167, '\p{Block=:\Abatak\z:}', "");;
    Expect(0, 7168, '\p{Block=:\Abatak\z:}', "");;
    Expect(1, 7167, '\p{Block= 	batak}', "");
    Expect(0, 7167, '\p{^Block= 	batak}', "");
    Expect(0, 7167, '\P{Block= 	batak}', "");
    Expect(1, 7167, '\P{^Block= 	batak}', "");
    Expect(0, 7168, '\p{Block= 	batak}', "");
    Expect(1, 7168, '\p{^Block= 	batak}', "");
    Expect(1, 7168, '\P{Block= 	batak}', "");
    Expect(0, 7168, '\P{^Block= 	batak}', "");
    Error('\p{Blk=_/a/BATAK}');
    Error('\P{Blk=_/a/BATAK}');
    Expect(1, 7167, '\p{Blk=:\ABatak\z:}', "");;
    Expect(0, 7168, '\p{Blk=:\ABatak\z:}', "");;
    Expect(1, 7167, '\p{Blk=batak}', "");
    Expect(0, 7167, '\p{^Blk=batak}', "");
    Expect(0, 7167, '\P{Blk=batak}', "");
    Expect(1, 7167, '\P{^Blk=batak}', "");
    Expect(0, 7168, '\p{Blk=batak}', "");
    Expect(1, 7168, '\p{^Blk=batak}', "");
    Expect(1, 7168, '\P{Blk=batak}', "");
    Expect(0, 7168, '\P{^Blk=batak}', "");
    Expect(1, 7167, '\p{Blk=:\Abatak\z:}', "");;
    Expect(0, 7168, '\p{Blk=:\Abatak\z:}', "");;
    Error('\p{Is_Block=_/a/Batak}');
    Error('\P{Is_Block=_/a/Batak}');
    Expect(1, 7167, '\p{Is_Block=batak}', "");
    Expect(0, 7167, '\p{^Is_Block=batak}', "");
    Expect(0, 7167, '\P{Is_Block=batak}', "");
    Expect(1, 7167, '\P{^Is_Block=batak}', "");
    Expect(0, 7168, '\p{Is_Block=batak}', "");
    Expect(1, 7168, '\p{^Is_Block=batak}', "");
    Expect(1, 7168, '\P{Is_Block=batak}', "");
    Expect(0, 7168, '\P{^Is_Block=batak}', "");
    Expect(1, 7167, '\p{Is_Block=	_batak}', "");
    Expect(0, 7167, '\p{^Is_Block=	_batak}', "");
    Expect(0, 7167, '\P{Is_Block=	_batak}', "");
    Expect(1, 7167, '\P{^Is_Block=	_batak}', "");
    Expect(0, 7168, '\p{Is_Block=	_batak}', "");
    Expect(1, 7168, '\p{^Is_Block=	_batak}', "");
    Expect(1, 7168, '\P{Is_Block=	_batak}', "");
    Expect(0, 7168, '\P{^Is_Block=	_batak}', "");
    Error('\p{Is_Blk=- BATAK/a/}');
    Error('\P{Is_Blk=- BATAK/a/}');
    Expect(1, 7167, '\p{Is_Blk:   batak}', "");
    Expect(0, 7167, '\p{^Is_Blk:   batak}', "");
    Expect(0, 7167, '\P{Is_Blk:   batak}', "");
    Expect(1, 7167, '\P{^Is_Blk:   batak}', "");
    Expect(0, 7168, '\p{Is_Blk:   batak}', "");
    Expect(1, 7168, '\p{^Is_Blk:   batak}', "");
    Expect(1, 7168, '\P{Is_Blk:   batak}', "");
    Expect(0, 7168, '\P{^Is_Blk:   batak}', "");
    Expect(1, 7167, '\p{Is_Blk=- Batak}', "");
    Expect(0, 7167, '\p{^Is_Blk=- Batak}', "");
    Expect(0, 7167, '\P{Is_Blk=- Batak}', "");
    Expect(1, 7167, '\P{^Is_Blk=- Batak}', "");
    Expect(0, 7168, '\p{Is_Blk=- Batak}', "");
    Expect(1, 7168, '\p{^Is_Blk=- Batak}', "");
    Expect(1, 7168, '\P{Is_Blk=- Batak}', "");
    Expect(0, 7168, '\P{^Is_Blk=- Batak}', "");
    Error('\p{Block=/a/bengali}');
    Error('\P{Block=/a/bengali}');
    Expect(1, 2559, '\p{Block=:\ABengali\z:}', "");;
    Expect(0, 2560, '\p{Block=:\ABengali\z:}', "");;
    Expect(1, 2559, '\p{Block=bengali}', "");
    Expect(0, 2559, '\p{^Block=bengali}', "");
    Expect(0, 2559, '\P{Block=bengali}', "");
    Expect(1, 2559, '\P{^Block=bengali}', "");
    Expect(0, 2560, '\p{Block=bengali}', "");
    Expect(1, 2560, '\p{^Block=bengali}', "");
    Expect(1, 2560, '\P{Block=bengali}', "");
    Expect(0, 2560, '\P{^Block=bengali}', "");
    Expect(1, 2559, '\p{Block=:\Abengali\z:}', "");;
    Expect(0, 2560, '\p{Block=:\Abengali\z:}', "");;
    Expect(1, 2559, '\p{Block=	_Bengali}', "");
    Expect(0, 2559, '\p{^Block=	_Bengali}', "");
    Expect(0, 2559, '\P{Block=	_Bengali}', "");
    Expect(1, 2559, '\P{^Block=	_Bengali}', "");
    Expect(0, 2560, '\p{Block=	_Bengali}', "");
    Expect(1, 2560, '\p{^Block=	_Bengali}', "");
    Expect(1, 2560, '\P{Block=	_Bengali}', "");
    Expect(0, 2560, '\P{^Block=	_Bengali}', "");
    Error('\p{Blk=:=_	Bengali}');
    Error('\P{Blk=:=_	Bengali}');
    Expect(1, 2559, '\p{Blk=:\ABengali\z:}', "");;
    Expect(0, 2560, '\p{Blk=:\ABengali\z:}', "");;
    Expect(1, 2559, '\p{Blk=bengali}', "");
    Expect(0, 2559, '\p{^Blk=bengali}', "");
    Expect(0, 2559, '\P{Blk=bengali}', "");
    Expect(1, 2559, '\P{^Blk=bengali}', "");
    Expect(0, 2560, '\p{Blk=bengali}', "");
    Expect(1, 2560, '\p{^Blk=bengali}', "");
    Expect(1, 2560, '\P{Blk=bengali}', "");
    Expect(0, 2560, '\P{^Blk=bengali}', "");
    Expect(1, 2559, '\p{Blk=:\Abengali\z:}', "");;
    Expect(0, 2560, '\p{Blk=:\Abengali\z:}', "");;
    Expect(1, 2559, '\p{Blk=  Bengali}', "");
    Expect(0, 2559, '\p{^Blk=  Bengali}', "");
    Expect(0, 2559, '\P{Blk=  Bengali}', "");
    Expect(1, 2559, '\P{^Blk=  Bengali}', "");
    Expect(0, 2560, '\p{Blk=  Bengali}', "");
    Expect(1, 2560, '\p{^Blk=  Bengali}', "");
    Expect(1, 2560, '\P{Blk=  Bengali}', "");
    Expect(0, 2560, '\P{^Blk=  Bengali}', "");
    Error('\p{Is_Block=	:=BENGALI}');
    Error('\P{Is_Block=	:=BENGALI}');
    Expect(1, 2559, '\p{Is_Block=bengali}', "");
    Expect(0, 2559, '\p{^Is_Block=bengali}', "");
    Expect(0, 2559, '\P{Is_Block=bengali}', "");
    Expect(1, 2559, '\P{^Is_Block=bengali}', "");
    Expect(0, 2560, '\p{Is_Block=bengali}', "");
    Expect(1, 2560, '\p{^Is_Block=bengali}', "");
    Expect(1, 2560, '\P{Is_Block=bengali}', "");
    Expect(0, 2560, '\P{^Is_Block=bengali}', "");
    Expect(1, 2559, '\p{Is_Block=	bengali}', "");
    Expect(0, 2559, '\p{^Is_Block=	bengali}', "");
    Expect(0, 2559, '\P{Is_Block=	bengali}', "");
    Expect(1, 2559, '\P{^Is_Block=	bengali}', "");
    Expect(0, 2560, '\p{Is_Block=	bengali}', "");
    Expect(1, 2560, '\p{^Is_Block=	bengali}', "");
    Expect(1, 2560, '\P{Is_Block=	bengali}', "");
    Expect(0, 2560, '\P{^Is_Block=	bengali}', "");
    Error('\p{Is_Blk=Bengali/a/}');
    Error('\P{Is_Blk=Bengali/a/}');
    Expect(1, 2559, '\p{Is_Blk=bengali}', "");
    Expect(0, 2559, '\p{^Is_Blk=bengali}', "");
    Expect(0, 2559, '\P{Is_Blk=bengali}', "");
    Expect(1, 2559, '\P{^Is_Blk=bengali}', "");
    Expect(0, 2560, '\p{Is_Blk=bengali}', "");
    Expect(1, 2560, '\p{^Is_Blk=bengali}', "");
    Expect(1, 2560, '\P{Is_Blk=bengali}', "");
    Expect(0, 2560, '\P{^Is_Blk=bengali}', "");
    Expect(1, 2559, '\p{Is_Blk=-	Bengali}', "");
    Expect(0, 2559, '\p{^Is_Blk=-	Bengali}', "");
    Expect(0, 2559, '\P{Is_Blk=-	Bengali}', "");
    Expect(1, 2559, '\P{^Is_Blk=-	Bengali}', "");
    Expect(0, 2560, '\p{Is_Blk=-	Bengali}', "");
    Expect(1, 2560, '\p{^Is_Blk=-	Bengali}', "");
    Expect(1, 2560, '\P{Is_Blk=-	Bengali}', "");
    Expect(0, 2560, '\P{^Is_Blk=-	Bengali}', "");
    Error('\p{Block=	_Bhaiksuki:=}');
    Error('\P{Block=	_Bhaiksuki:=}');
    Expect(1, 72815, '\p{Block=:\ABhaiksuki\z:}', "");;
    Expect(0, 72816, '\p{Block=:\ABhaiksuki\z:}', "");;
    Expect(1, 72815, '\p{Block=bhaiksuki}', "");
    Expect(0, 72815, '\p{^Block=bhaiksuki}', "");
    Expect(0, 72815, '\P{Block=bhaiksuki}', "");
    Expect(1, 72815, '\P{^Block=bhaiksuki}', "");
    Expect(0, 72816, '\p{Block=bhaiksuki}', "");
    Expect(1, 72816, '\p{^Block=bhaiksuki}', "");
    Expect(1, 72816, '\P{Block=bhaiksuki}', "");
    Expect(0, 72816, '\P{^Block=bhaiksuki}', "");
    Expect(1, 72815, '\p{Block=:\Abhaiksuki\z:}', "");;
    Expect(0, 72816, '\p{Block=:\Abhaiksuki\z:}', "");;
    Expect(1, 72815, '\p{Block= 	bhaiksuki}', "");
    Expect(0, 72815, '\p{^Block= 	bhaiksuki}', "");
    Expect(0, 72815, '\P{Block= 	bhaiksuki}', "");
    Expect(1, 72815, '\P{^Block= 	bhaiksuki}', "");
    Expect(0, 72816, '\p{Block= 	bhaiksuki}', "");
    Expect(1, 72816, '\p{^Block= 	bhaiksuki}', "");
    Expect(1, 72816, '\P{Block= 	bhaiksuki}', "");
    Expect(0, 72816, '\P{^Block= 	bhaiksuki}', "");
    Error('\p{Blk:	:= 	Bhaiksuki}');
    Error('\P{Blk:	:= 	Bhaiksuki}');
    Expect(1, 72815, '\p{Blk=:\ABhaiksuki\z:}', "");;
    Expect(0, 72816, '\p{Blk=:\ABhaiksuki\z:}', "");;
    Expect(1, 72815, '\p{Blk=bhaiksuki}', "");
    Expect(0, 72815, '\p{^Blk=bhaiksuki}', "");
    Expect(0, 72815, '\P{Blk=bhaiksuki}', "");
    Expect(1, 72815, '\P{^Blk=bhaiksuki}', "");
    Expect(0, 72816, '\p{Blk=bhaiksuki}', "");
    Expect(1, 72816, '\p{^Blk=bhaiksuki}', "");
    Expect(1, 72816, '\P{Blk=bhaiksuki}', "");
    Expect(0, 72816, '\P{^Blk=bhaiksuki}', "");
    Expect(1, 72815, '\p{Blk=:\Abhaiksuki\z:}', "");;
    Expect(0, 72816, '\p{Blk=:\Abhaiksuki\z:}', "");;
    Expect(1, 72815, '\p{Blk=Bhaiksuki}', "");
    Expect(0, 72815, '\p{^Blk=Bhaiksuki}', "");
    Expect(0, 72815, '\P{Blk=Bhaiksuki}', "");
    Expect(1, 72815, '\P{^Blk=Bhaiksuki}', "");
    Expect(0, 72816, '\p{Blk=Bhaiksuki}', "");
    Expect(1, 72816, '\p{^Blk=Bhaiksuki}', "");
    Expect(1, 72816, '\P{Blk=Bhaiksuki}', "");
    Expect(0, 72816, '\P{^Blk=Bhaiksuki}', "");
    Error('\p{Is_Block=:=_-Bhaiksuki}');
    Error('\P{Is_Block=:=_-Bhaiksuki}');
    Expect(1, 72815, '\p{Is_Block=bhaiksuki}', "");
    Expect(0, 72815, '\p{^Is_Block=bhaiksuki}', "");
    Expect(0, 72815, '\P{Is_Block=bhaiksuki}', "");
    Expect(1, 72815, '\P{^Is_Block=bhaiksuki}', "");
    Expect(0, 72816, '\p{Is_Block=bhaiksuki}', "");
    Expect(1, 72816, '\p{^Is_Block=bhaiksuki}', "");
    Expect(1, 72816, '\P{Is_Block=bhaiksuki}', "");
    Expect(0, 72816, '\P{^Is_Block=bhaiksuki}', "");
    Expect(1, 72815, '\p{Is_Block=--Bhaiksuki}', "");
    Expect(0, 72815, '\p{^Is_Block=--Bhaiksuki}', "");
    Expect(0, 72815, '\P{Is_Block=--Bhaiksuki}', "");
    Expect(1, 72815, '\P{^Is_Block=--Bhaiksuki}', "");
    Expect(0, 72816, '\p{Is_Block=--Bhaiksuki}', "");
    Expect(1, 72816, '\p{^Is_Block=--Bhaiksuki}', "");
    Expect(1, 72816, '\P{Is_Block=--Bhaiksuki}', "");
    Expect(0, 72816, '\P{^Is_Block=--Bhaiksuki}', "");
    Error('\p{Is_Blk=_bhaiksuki/a/}');
    Error('\P{Is_Blk=_bhaiksuki/a/}');
    Expect(1, 72815, '\p{Is_Blk=bhaiksuki}', "");
    Expect(0, 72815, '\p{^Is_Blk=bhaiksuki}', "");
    Expect(0, 72815, '\P{Is_Blk=bhaiksuki}', "");
    Expect(1, 72815, '\P{^Is_Blk=bhaiksuki}', "");
    Expect(0, 72816, '\p{Is_Blk=bhaiksuki}', "");
    Expect(1, 72816, '\p{^Is_Blk=bhaiksuki}', "");
    Expect(1, 72816, '\P{Is_Blk=bhaiksuki}', "");
    Expect(0, 72816, '\P{^Is_Blk=bhaiksuki}', "");
    Expect(1, 72815, '\p{Is_Blk=	Bhaiksuki}', "");
    Expect(0, 72815, '\p{^Is_Blk=	Bhaiksuki}', "");
    Expect(0, 72815, '\P{Is_Blk=	Bhaiksuki}', "");
    Expect(1, 72815, '\P{^Is_Blk=	Bhaiksuki}', "");
    Expect(0, 72816, '\p{Is_Blk=	Bhaiksuki}', "");
    Expect(1, 72816, '\p{^Is_Blk=	Bhaiksuki}', "");
    Expect(1, 72816, '\P{Is_Blk=	Bhaiksuki}', "");
    Expect(0, 72816, '\P{^Is_Blk=	Bhaiksuki}', "");
    Error('\p{Block=:=  Block_Elements}');
    Error('\P{Block=:=  Block_Elements}');
    Expect(1, 9631, '\p{Block=:\ABlock_Elements\z:}', "");;
    Expect(0, 9632, '\p{Block=:\ABlock_Elements\z:}', "");;
    Expect(1, 9631, '\p{Block=blockelements}', "");
    Expect(0, 9631, '\p{^Block=blockelements}', "");
    Expect(0, 9631, '\P{Block=blockelements}', "");
    Expect(1, 9631, '\P{^Block=blockelements}', "");
    Expect(0, 9632, '\p{Block=blockelements}', "");
    Expect(1, 9632, '\p{^Block=blockelements}', "");
    Expect(1, 9632, '\P{Block=blockelements}', "");
    Expect(0, 9632, '\P{^Block=blockelements}', "");
    Expect(1, 9631, '\p{Block=:\Ablockelements\z:}', "");;
    Expect(0, 9632, '\p{Block=:\Ablockelements\z:}', "");;
    Expect(1, 9631, '\p{Block=_BLOCK_Elements}', "");
    Expect(0, 9631, '\p{^Block=_BLOCK_Elements}', "");
    Expect(0, 9631, '\P{Block=_BLOCK_Elements}', "");
    Expect(1, 9631, '\P{^Block=_BLOCK_Elements}', "");
    Expect(0, 9632, '\p{Block=_BLOCK_Elements}', "");
    Expect(1, 9632, '\p{^Block=_BLOCK_Elements}', "");
    Expect(1, 9632, '\P{Block=_BLOCK_Elements}', "");
    Expect(0, 9632, '\P{^Block=_BLOCK_Elements}', "");
    Error('\p{Blk=	:=block_elements}');
    Error('\P{Blk=	:=block_elements}');
    Expect(1, 9631, '\p{Blk=:\ABlock_Elements\z:}', "");;
    Expect(0, 9632, '\p{Blk=:\ABlock_Elements\z:}', "");;
    Expect(1, 9631, '\p{Blk=blockelements}', "");
    Expect(0, 9631, '\p{^Blk=blockelements}', "");
    Expect(0, 9631, '\P{Blk=blockelements}', "");
    Expect(1, 9631, '\P{^Blk=blockelements}', "");
    Expect(0, 9632, '\p{Blk=blockelements}', "");
    Expect(1, 9632, '\p{^Blk=blockelements}', "");
    Expect(1, 9632, '\P{Blk=blockelements}', "");
    Expect(0, 9632, '\P{^Blk=blockelements}', "");
    Expect(1, 9631, '\p{Blk=:\Ablockelements\z:}', "");;
    Expect(0, 9632, '\p{Blk=:\Ablockelements\z:}', "");;
    Expect(1, 9631, '\p{Blk=- block_elements}', "");
    Expect(0, 9631, '\p{^Blk=- block_elements}', "");
    Expect(0, 9631, '\P{Blk=- block_elements}', "");
    Expect(1, 9631, '\P{^Blk=- block_elements}', "");
    Expect(0, 9632, '\p{Blk=- block_elements}', "");
    Expect(1, 9632, '\p{^Blk=- block_elements}', "");
    Expect(1, 9632, '\P{Blk=- block_elements}', "");
    Expect(0, 9632, '\P{^Blk=- block_elements}', "");
    Error('\p{Is_Block=_:=Block_elements}');
    Error('\P{Is_Block=_:=Block_elements}');
    Expect(1, 9631, '\p{Is_Block=blockelements}', "");
    Expect(0, 9631, '\p{^Is_Block=blockelements}', "");
    Expect(0, 9631, '\P{Is_Block=blockelements}', "");
    Expect(1, 9631, '\P{^Is_Block=blockelements}', "");
    Expect(0, 9632, '\p{Is_Block=blockelements}', "");
    Expect(1, 9632, '\p{^Is_Block=blockelements}', "");
    Expect(1, 9632, '\P{Is_Block=blockelements}', "");
    Expect(0, 9632, '\P{^Is_Block=blockelements}', "");
    Expect(1, 9631, '\p{Is_Block:   	block_Elements}', "");
    Expect(0, 9631, '\p{^Is_Block:   	block_Elements}', "");
    Expect(0, 9631, '\P{Is_Block:   	block_Elements}', "");
    Expect(1, 9631, '\P{^Is_Block:   	block_Elements}', "");
    Expect(0, 9632, '\p{Is_Block:   	block_Elements}', "");
    Expect(1, 9632, '\p{^Is_Block:   	block_Elements}', "");
    Expect(1, 9632, '\P{Is_Block:   	block_Elements}', "");
    Expect(0, 9632, '\P{^Is_Block:   	block_Elements}', "");
    Error('\p{Is_Blk=	_BLOCK_ELEMENTS:=}');
    Error('\P{Is_Blk=	_BLOCK_ELEMENTS:=}');
    Expect(1, 9631, '\p{Is_Blk=blockelements}', "");
    Expect(0, 9631, '\p{^Is_Blk=blockelements}', "");
    Expect(0, 9631, '\P{Is_Blk=blockelements}', "");
    Expect(1, 9631, '\P{^Is_Blk=blockelements}', "");
    Expect(0, 9632, '\p{Is_Blk=blockelements}', "");
    Expect(1, 9632, '\p{^Is_Blk=blockelements}', "");
    Expect(1, 9632, '\P{Is_Blk=blockelements}', "");
    Expect(0, 9632, '\P{^Is_Blk=blockelements}', "");
    Expect(1, 9631, '\p{Is_Blk= Block_elements}', "");
    Expect(0, 9631, '\p{^Is_Blk= Block_elements}', "");
    Expect(0, 9631, '\P{Is_Blk= Block_elements}', "");
    Expect(1, 9631, '\P{^Is_Blk= Block_elements}', "");
    Expect(0, 9632, '\p{Is_Blk= Block_elements}', "");
    Expect(1, 9632, '\p{^Is_Blk= Block_elements}', "");
    Expect(1, 9632, '\P{Is_Blk= Block_elements}', "");
    Expect(0, 9632, '\P{^Is_Blk= Block_elements}', "");
    Error('\p{Block:   :=		Bopomofo}');
    Error('\P{Block:   :=		Bopomofo}');
    Expect(1, 12591, '\p{Block=:\ABopomofo\z:}', "");;
    Expect(0, 12592, '\p{Block=:\ABopomofo\z:}', "");;
    Expect(1, 12591, '\p{Block=bopomofo}', "");
    Expect(0, 12591, '\p{^Block=bopomofo}', "");
    Expect(0, 12591, '\P{Block=bopomofo}', "");
    Expect(1, 12591, '\P{^Block=bopomofo}', "");
    Expect(0, 12592, '\p{Block=bopomofo}', "");
    Expect(1, 12592, '\p{^Block=bopomofo}', "");
    Expect(1, 12592, '\P{Block=bopomofo}', "");
    Expect(0, 12592, '\P{^Block=bopomofo}', "");
    Expect(1, 12591, '\p{Block=:\Abopomofo\z:}', "");;
    Expect(0, 12592, '\p{Block=:\Abopomofo\z:}', "");;
    Expect(1, 12591, '\p{Block= 	BOPOMOFO}', "");
    Expect(0, 12591, '\p{^Block= 	BOPOMOFO}', "");
    Expect(0, 12591, '\P{Block= 	BOPOMOFO}', "");
    Expect(1, 12591, '\P{^Block= 	BOPOMOFO}', "");
    Expect(0, 12592, '\p{Block= 	BOPOMOFO}', "");
    Expect(1, 12592, '\p{^Block= 	BOPOMOFO}', "");
    Expect(1, 12592, '\P{Block= 	BOPOMOFO}', "");
    Expect(0, 12592, '\P{^Block= 	BOPOMOFO}', "");
    Error('\p{Blk=/a/_-bopomofo}');
    Error('\P{Blk=/a/_-bopomofo}');
    Expect(1, 12591, '\p{Blk=:\ABopomofo\z:}', "");;
    Expect(0, 12592, '\p{Blk=:\ABopomofo\z:}', "");;
    Expect(1, 12591, '\p{Blk=bopomofo}', "");
    Expect(0, 12591, '\p{^Blk=bopomofo}', "");
    Expect(0, 12591, '\P{Blk=bopomofo}', "");
    Expect(1, 12591, '\P{^Blk=bopomofo}', "");
    Expect(0, 12592, '\p{Blk=bopomofo}', "");
    Expect(1, 12592, '\p{^Blk=bopomofo}', "");
    Expect(1, 12592, '\P{Blk=bopomofo}', "");
    Expect(0, 12592, '\P{^Blk=bopomofo}', "");
    Expect(1, 12591, '\p{Blk=:\Abopomofo\z:}', "");;
    Expect(0, 12592, '\p{Blk=:\Abopomofo\z:}', "");;
    Expect(1, 12591, '\p{Blk=	bopomofo}', "");
    Expect(0, 12591, '\p{^Blk=	bopomofo}', "");
    Expect(0, 12591, '\P{Blk=	bopomofo}', "");
    Expect(1, 12591, '\P{^Blk=	bopomofo}', "");
    Expect(0, 12592, '\p{Blk=	bopomofo}', "");
    Expect(1, 12592, '\p{^Blk=	bopomofo}', "");
    Expect(1, 12592, '\P{Blk=	bopomofo}', "");
    Expect(0, 12592, '\P{^Blk=	bopomofo}', "");
    Error('\p{Is_Block:   /a/	Bopomofo}');
    Error('\P{Is_Block:   /a/	Bopomofo}');
    Expect(1, 12591, '\p{Is_Block:   bopomofo}', "");
    Expect(0, 12591, '\p{^Is_Block:   bopomofo}', "");
    Expect(0, 12591, '\P{Is_Block:   bopomofo}', "");
    Expect(1, 12591, '\P{^Is_Block:   bopomofo}', "");
    Expect(0, 12592, '\p{Is_Block:   bopomofo}', "");
    Expect(1, 12592, '\p{^Is_Block:   bopomofo}', "");
    Expect(1, 12592, '\P{Is_Block:   bopomofo}', "");
    Expect(0, 12592, '\P{^Is_Block:   bopomofo}', "");
    Expect(1, 12591, '\p{Is_Block=_ BOPOMOFO}', "");
    Expect(0, 12591, '\p{^Is_Block=_ BOPOMOFO}', "");
    Expect(0, 12591, '\P{Is_Block=_ BOPOMOFO}', "");
    Expect(1, 12591, '\P{^Is_Block=_ BOPOMOFO}', "");
    Expect(0, 12592, '\p{Is_Block=_ BOPOMOFO}', "");
    Expect(1, 12592, '\p{^Is_Block=_ BOPOMOFO}', "");
    Expect(1, 12592, '\P{Is_Block=_ BOPOMOFO}', "");
    Expect(0, 12592, '\P{^Is_Block=_ BOPOMOFO}', "");
    Error('\p{Is_Blk=/a/--bopomofo}');
    Error('\P{Is_Blk=/a/--bopomofo}');
    Expect(1, 12591, '\p{Is_Blk:	bopomofo}', "");
    Expect(0, 12591, '\p{^Is_Blk:	bopomofo}', "");
    Expect(0, 12591, '\P{Is_Blk:	bopomofo}', "");
    Expect(1, 12591, '\P{^Is_Blk:	bopomofo}', "");
    Expect(0, 12592, '\p{Is_Blk:	bopomofo}', "");
    Expect(1, 12592, '\p{^Is_Blk:	bopomofo}', "");
    Expect(1, 12592, '\P{Is_Blk:	bopomofo}', "");
    Expect(0, 12592, '\P{^Is_Blk:	bopomofo}', "");
    Expect(1, 12591, '\p{Is_Blk=__Bopomofo}', "");
    Expect(0, 12591, '\p{^Is_Blk=__Bopomofo}', "");
    Expect(0, 12591, '\P{Is_Blk=__Bopomofo}', "");
    Expect(1, 12591, '\P{^Is_Blk=__Bopomofo}', "");
    Expect(0, 12592, '\p{Is_Blk=__Bopomofo}', "");
    Expect(1, 12592, '\p{^Is_Blk=__Bopomofo}', "");
    Expect(1, 12592, '\P{Is_Blk=__Bopomofo}', "");
    Expect(0, 12592, '\P{^Is_Blk=__Bopomofo}', "");
    Error('\p{Block=/a/- Bopomofo_Extended}');
    Error('\P{Block=/a/- Bopomofo_Extended}');
    Expect(1, 12735, '\p{Block=:\ABopomofo_Extended\z:}', "");;
    Expect(0, 12736, '\p{Block=:\ABopomofo_Extended\z:}', "");;
    Expect(1, 12735, '\p{Block=bopomofoextended}', "");
    Expect(0, 12735, '\p{^Block=bopomofoextended}', "");
    Expect(0, 12735, '\P{Block=bopomofoextended}', "");
    Expect(1, 12735, '\P{^Block=bopomofoextended}', "");
    Expect(0, 12736, '\p{Block=bopomofoextended}', "");
    Expect(1, 12736, '\p{^Block=bopomofoextended}', "");
    Expect(1, 12736, '\P{Block=bopomofoextended}', "");
    Expect(0, 12736, '\P{^Block=bopomofoextended}', "");
    Expect(1, 12735, '\p{Block=:\Abopomofoextended\z:}', "");;
    Expect(0, 12736, '\p{Block=:\Abopomofoextended\z:}', "");;
    Expect(1, 12735, '\p{Block=-_Bopomofo_Extended}', "");
    Expect(0, 12735, '\p{^Block=-_Bopomofo_Extended}', "");
    Expect(0, 12735, '\P{Block=-_Bopomofo_Extended}', "");
    Expect(1, 12735, '\P{^Block=-_Bopomofo_Extended}', "");
    Expect(0, 12736, '\p{Block=-_Bopomofo_Extended}', "");
    Expect(1, 12736, '\p{^Block=-_Bopomofo_Extended}', "");
    Expect(1, 12736, '\P{Block=-_Bopomofo_Extended}', "");
    Expect(0, 12736, '\P{^Block=-_Bopomofo_Extended}', "");
    Error('\p{Blk=_-bopomofo_ext/a/}');
    Error('\P{Blk=_-bopomofo_ext/a/}');
    Expect(1, 12735, '\p{Blk=:\ABopomofo_Ext\z:}', "");;
    Expect(0, 12736, '\p{Blk=:\ABopomofo_Ext\z:}', "");;
    Expect(1, 12735, '\p{Blk=bopomofoext}', "");
    Expect(0, 12735, '\p{^Blk=bopomofoext}', "");
    Expect(0, 12735, '\P{Blk=bopomofoext}', "");
    Expect(1, 12735, '\P{^Blk=bopomofoext}', "");
    Expect(0, 12736, '\p{Blk=bopomofoext}', "");
    Expect(1, 12736, '\p{^Blk=bopomofoext}', "");
    Expect(1, 12736, '\P{Blk=bopomofoext}', "");
    Expect(0, 12736, '\P{^Blk=bopomofoext}', "");
    Expect(1, 12735, '\p{Blk=:\Abopomofoext\z:}', "");;
    Expect(0, 12736, '\p{Blk=:\Abopomofoext\z:}', "");;
    Expect(1, 12735, '\p{Blk= Bopomofo_Ext}', "");
    Expect(0, 12735, '\p{^Blk= Bopomofo_Ext}', "");
    Expect(0, 12735, '\P{Blk= Bopomofo_Ext}', "");
    Expect(1, 12735, '\P{^Blk= Bopomofo_Ext}', "");
    Expect(0, 12736, '\p{Blk= Bopomofo_Ext}', "");
    Expect(1, 12736, '\p{^Blk= Bopomofo_Ext}', "");
    Expect(1, 12736, '\P{Blk= Bopomofo_Ext}', "");
    Expect(0, 12736, '\P{^Blk= Bopomofo_Ext}', "");
    Error('\p{Is_Block=:=-Bopomofo_Extended}');
    Error('\P{Is_Block=:=-Bopomofo_Extended}');
    Expect(1, 12735, '\p{Is_Block:	bopomofoextended}', "");
    Expect(0, 12735, '\p{^Is_Block:	bopomofoextended}', "");
    Expect(0, 12735, '\P{Is_Block:	bopomofoextended}', "");
    Expect(1, 12735, '\P{^Is_Block:	bopomofoextended}', "");
    Expect(0, 12736, '\p{Is_Block:	bopomofoextended}', "");
    Expect(1, 12736, '\p{^Is_Block:	bopomofoextended}', "");
    Expect(1, 12736, '\P{Is_Block:	bopomofoextended}', "");
    Expect(0, 12736, '\P{^Is_Block:	bopomofoextended}', "");
    Expect(1, 12735, '\p{Is_Block= _bopomofo_Extended}', "");
    Expect(0, 12735, '\p{^Is_Block= _bopomofo_Extended}', "");
    Expect(0, 12735, '\P{Is_Block= _bopomofo_Extended}', "");
    Expect(1, 12735, '\P{^Is_Block= _bopomofo_Extended}', "");
    Expect(0, 12736, '\p{Is_Block= _bopomofo_Extended}', "");
    Expect(1, 12736, '\p{^Is_Block= _bopomofo_Extended}', "");
    Expect(1, 12736, '\P{Is_Block= _bopomofo_Extended}', "");
    Expect(0, 12736, '\P{^Is_Block= _bopomofo_Extended}', "");
    Error('\p{Is_Blk=:=_bopomofo_ext}');
    Error('\P{Is_Blk=:=_bopomofo_ext}');
    Expect(1, 12735, '\p{Is_Blk=bopomofoext}', "");
    Expect(0, 12735, '\p{^Is_Blk=bopomofoext}', "");
    Expect(0, 12735, '\P{Is_Blk=bopomofoext}', "");
    Expect(1, 12735, '\P{^Is_Blk=bopomofoext}', "");
    Expect(0, 12736, '\p{Is_Blk=bopomofoext}', "");
    Expect(1, 12736, '\p{^Is_Blk=bopomofoext}', "");
    Expect(1, 12736, '\P{Is_Blk=bopomofoext}', "");
    Expect(0, 12736, '\P{^Is_Blk=bopomofoext}', "");
    Expect(1, 12735, '\p{Is_Blk=-BOPOMOFO_Ext}', "");
    Expect(0, 12735, '\p{^Is_Blk=-BOPOMOFO_Ext}', "");
    Expect(0, 12735, '\P{Is_Blk=-BOPOMOFO_Ext}', "");
    Expect(1, 12735, '\P{^Is_Blk=-BOPOMOFO_Ext}', "");
    Expect(0, 12736, '\p{Is_Blk=-BOPOMOFO_Ext}', "");
    Expect(1, 12736, '\p{^Is_Blk=-BOPOMOFO_Ext}', "");
    Expect(1, 12736, '\P{Is_Blk=-BOPOMOFO_Ext}', "");
    Expect(0, 12736, '\P{^Is_Blk=-BOPOMOFO_Ext}', "");
    Error('\p{Block=/a/ 	Box_DRAWING}');
    Error('\P{Block=/a/ 	Box_DRAWING}');
    Expect(1, 9599, '\p{Block=:\ABox_Drawing\z:}', "");;
    Expect(0, 9600, '\p{Block=:\ABox_Drawing\z:}', "");;
    Expect(1, 9599, '\p{Block=boxdrawing}', "");
    Expect(0, 9599, '\p{^Block=boxdrawing}', "");
    Expect(0, 9599, '\P{Block=boxdrawing}', "");
    Expect(1, 9599, '\P{^Block=boxdrawing}', "");
    Expect(0, 9600, '\p{Block=boxdrawing}', "");
    Expect(1, 9600, '\p{^Block=boxdrawing}', "");
    Expect(1, 9600, '\P{Block=boxdrawing}', "");
    Expect(0, 9600, '\P{^Block=boxdrawing}', "");
    Expect(1, 9599, '\p{Block=:\Aboxdrawing\z:}', "");;
    Expect(0, 9600, '\p{Block=:\Aboxdrawing\z:}', "");;
    Expect(1, 9599, '\p{Block=	Box_drawing}', "");
    Expect(0, 9599, '\p{^Block=	Box_drawing}', "");
    Expect(0, 9599, '\P{Block=	Box_drawing}', "");
    Expect(1, 9599, '\P{^Block=	Box_drawing}', "");
    Expect(0, 9600, '\p{Block=	Box_drawing}', "");
    Expect(1, 9600, '\p{^Block=	Box_drawing}', "");
    Expect(1, 9600, '\P{Block=	Box_drawing}', "");
    Expect(0, 9600, '\P{^Block=	Box_drawing}', "");
    Error('\p{Blk:-	Box_DRAWING/a/}');
    Error('\P{Blk:-	Box_DRAWING/a/}');
    Expect(1, 9599, '\p{Blk=:\ABox_Drawing\z:}', "");;
    Expect(0, 9600, '\p{Blk=:\ABox_Drawing\z:}', "");;
    Expect(1, 9599, '\p{Blk=boxdrawing}', "");
    Expect(0, 9599, '\p{^Blk=boxdrawing}', "");
    Expect(0, 9599, '\P{Blk=boxdrawing}', "");
    Expect(1, 9599, '\P{^Blk=boxdrawing}', "");
    Expect(0, 9600, '\p{Blk=boxdrawing}', "");
    Expect(1, 9600, '\p{^Blk=boxdrawing}', "");
    Expect(1, 9600, '\P{Blk=boxdrawing}', "");
    Expect(0, 9600, '\P{^Blk=boxdrawing}', "");
    Expect(1, 9599, '\p{Blk=:\Aboxdrawing\z:}', "");;
    Expect(0, 9600, '\p{Blk=:\Aboxdrawing\z:}', "");;
    Expect(1, 9599, '\p{Blk=	-Box_DRAWING}', "");
    Expect(0, 9599, '\p{^Blk=	-Box_DRAWING}', "");
    Expect(0, 9599, '\P{Blk=	-Box_DRAWING}', "");
    Expect(1, 9599, '\P{^Blk=	-Box_DRAWING}', "");
    Expect(0, 9600, '\p{Blk=	-Box_DRAWING}', "");
    Expect(1, 9600, '\p{^Blk=	-Box_DRAWING}', "");
    Expect(1, 9600, '\P{Blk=	-Box_DRAWING}', "");
    Expect(0, 9600, '\P{^Blk=	-Box_DRAWING}', "");
    Error('\p{Is_Block=:=	_BOX_drawing}');
    Error('\P{Is_Block=:=	_BOX_drawing}');
    Expect(1, 9599, '\p{Is_Block=boxdrawing}', "");
    Expect(0, 9599, '\p{^Is_Block=boxdrawing}', "");
    Expect(0, 9599, '\P{Is_Block=boxdrawing}', "");
    Expect(1, 9599, '\P{^Is_Block=boxdrawing}', "");
    Expect(0, 9600, '\p{Is_Block=boxdrawing}', "");
    Expect(1, 9600, '\p{^Is_Block=boxdrawing}', "");
    Expect(1, 9600, '\P{Is_Block=boxdrawing}', "");
    Expect(0, 9600, '\P{^Is_Block=boxdrawing}', "");
    Expect(1, 9599, '\p{Is_Block:-box_Drawing}', "");
    Expect(0, 9599, '\p{^Is_Block:-box_Drawing}', "");
    Expect(0, 9599, '\P{Is_Block:-box_Drawing}', "");
    Expect(1, 9599, '\P{^Is_Block:-box_Drawing}', "");
    Expect(0, 9600, '\p{Is_Block:-box_Drawing}', "");
    Expect(1, 9600, '\p{^Is_Block:-box_Drawing}', "");
    Expect(1, 9600, '\P{Is_Block:-box_Drawing}', "");
    Expect(0, 9600, '\P{^Is_Block:-box_Drawing}', "");
    Error('\p{Is_Blk=/a/-_box_Drawing}');
    Error('\P{Is_Blk=/a/-_box_Drawing}');
    Expect(1, 9599, '\p{Is_Blk=boxdrawing}', "");
    Expect(0, 9599, '\p{^Is_Blk=boxdrawing}', "");
    Expect(0, 9599, '\P{Is_Blk=boxdrawing}', "");
    Expect(1, 9599, '\P{^Is_Blk=boxdrawing}', "");
    Expect(0, 9600, '\p{Is_Blk=boxdrawing}', "");
    Expect(1, 9600, '\p{^Is_Blk=boxdrawing}', "");
    Expect(1, 9600, '\P{Is_Blk=boxdrawing}', "");
    Expect(0, 9600, '\P{^Is_Blk=boxdrawing}', "");
    Expect(1, 9599, '\p{Is_Blk=  Box_Drawing}', "");
    Expect(0, 9599, '\p{^Is_Blk=  Box_Drawing}', "");
    Expect(0, 9599, '\P{Is_Blk=  Box_Drawing}', "");
    Expect(1, 9599, '\P{^Is_Blk=  Box_Drawing}', "");
    Expect(0, 9600, '\p{Is_Blk=  Box_Drawing}', "");
    Expect(1, 9600, '\p{^Is_Blk=  Box_Drawing}', "");
    Expect(1, 9600, '\P{Is_Blk=  Box_Drawing}', "");
    Expect(0, 9600, '\P{^Is_Blk=  Box_Drawing}', "");
    Error('\p{Block=/a/-Brahmi}');
    Error('\P{Block=/a/-Brahmi}');
    Expect(1, 69759, '\p{Block=:\ABrahmi\z:}', "");;
    Expect(0, 69760, '\p{Block=:\ABrahmi\z:}', "");;
    Expect(1, 69759, '\p{Block=brahmi}', "");
    Expect(0, 69759, '\p{^Block=brahmi}', "");
    Expect(0, 69759, '\P{Block=brahmi}', "");
    Expect(1, 69759, '\P{^Block=brahmi}', "");
    Expect(0, 69760, '\p{Block=brahmi}', "");
    Expect(1, 69760, '\p{^Block=brahmi}', "");
    Expect(1, 69760, '\P{Block=brahmi}', "");
    Expect(0, 69760, '\P{^Block=brahmi}', "");
    Expect(1, 69759, '\p{Block=:\Abrahmi\z:}', "");;
    Expect(0, 69760, '\p{Block=:\Abrahmi\z:}', "");;
    Expect(1, 69759, '\p{Block:   -brahmi}', "");
    Expect(0, 69759, '\p{^Block:   -brahmi}', "");
    Expect(0, 69759, '\P{Block:   -brahmi}', "");
    Expect(1, 69759, '\P{^Block:   -brahmi}', "");
    Expect(0, 69760, '\p{Block:   -brahmi}', "");
    Expect(1, 69760, '\p{^Block:   -brahmi}', "");
    Expect(1, 69760, '\P{Block:   -brahmi}', "");
    Expect(0, 69760, '\P{^Block:   -brahmi}', "");
    Error('\p{Blk= _Brahmi/a/}');
    Error('\P{Blk= _Brahmi/a/}');
    Expect(1, 69759, '\p{Blk=:\ABrahmi\z:}', "");;
    Expect(0, 69760, '\p{Blk=:\ABrahmi\z:}', "");;
    Expect(1, 69759, '\p{Blk=brahmi}', "");
    Expect(0, 69759, '\p{^Blk=brahmi}', "");
    Expect(0, 69759, '\P{Blk=brahmi}', "");
    Expect(1, 69759, '\P{^Blk=brahmi}', "");
    Expect(0, 69760, '\p{Blk=brahmi}', "");
    Expect(1, 69760, '\p{^Blk=brahmi}', "");
    Expect(1, 69760, '\P{Blk=brahmi}', "");
    Expect(0, 69760, '\P{^Blk=brahmi}', "");
    Expect(1, 69759, '\p{Blk=:\Abrahmi\z:}', "");;
    Expect(0, 69760, '\p{Blk=:\Abrahmi\z:}', "");;
    Expect(1, 69759, '\p{Blk: --brahmi}', "");
    Expect(0, 69759, '\p{^Blk: --brahmi}', "");
    Expect(0, 69759, '\P{Blk: --brahmi}', "");
    Expect(1, 69759, '\P{^Blk: --brahmi}', "");
    Expect(0, 69760, '\p{Blk: --brahmi}', "");
    Expect(1, 69760, '\p{^Blk: --brahmi}', "");
    Expect(1, 69760, '\P{Blk: --brahmi}', "");
    Expect(0, 69760, '\P{^Blk: --brahmi}', "");
    Error('\p{Is_Block=:=brahmi}');
    Error('\P{Is_Block=:=brahmi}');
    Expect(1, 69759, '\p{Is_Block=brahmi}', "");
    Expect(0, 69759, '\p{^Is_Block=brahmi}', "");
    Expect(0, 69759, '\P{Is_Block=brahmi}', "");
    Expect(1, 69759, '\P{^Is_Block=brahmi}', "");
    Expect(0, 69760, '\p{Is_Block=brahmi}', "");
    Expect(1, 69760, '\p{^Is_Block=brahmi}', "");
    Expect(1, 69760, '\P{Is_Block=brahmi}', "");
    Expect(0, 69760, '\P{^Is_Block=brahmi}', "");
    Expect(1, 69759, '\p{Is_Block=_brahmi}', "");
    Expect(0, 69759, '\p{^Is_Block=_brahmi}', "");
    Expect(0, 69759, '\P{Is_Block=_brahmi}', "");
    Expect(1, 69759, '\P{^Is_Block=_brahmi}', "");
    Expect(0, 69760, '\p{Is_Block=_brahmi}', "");
    Expect(1, 69760, '\p{^Is_Block=_brahmi}', "");
    Expect(1, 69760, '\P{Is_Block=_brahmi}', "");
    Expect(0, 69760, '\P{^Is_Block=_brahmi}', "");
    Error('\p{Is_Blk=:=-brahmi}');
    Error('\P{Is_Blk=:=-brahmi}');
    Expect(1, 69759, '\p{Is_Blk=brahmi}', "");
    Expect(0, 69759, '\p{^Is_Blk=brahmi}', "");
    Expect(0, 69759, '\P{Is_Blk=brahmi}', "");
    Expect(1, 69759, '\P{^Is_Blk=brahmi}', "");
    Expect(0, 69760, '\p{Is_Blk=brahmi}', "");
    Expect(1, 69760, '\p{^Is_Blk=brahmi}', "");
    Expect(1, 69760, '\P{Is_Blk=brahmi}', "");
    Expect(0, 69760, '\P{^Is_Blk=brahmi}', "");
    Expect(1, 69759, '\p{Is_Blk=-	Brahmi}', "");
    Expect(0, 69759, '\p{^Is_Blk=-	Brahmi}', "");
    Expect(0, 69759, '\P{Is_Blk=-	Brahmi}', "");
    Expect(1, 69759, '\P{^Is_Blk=-	Brahmi}', "");
    Expect(0, 69760, '\p{Is_Blk=-	Brahmi}', "");
    Expect(1, 69760, '\p{^Is_Blk=-	Brahmi}', "");
    Expect(1, 69760, '\P{Is_Blk=-	Brahmi}', "");
    Expect(0, 69760, '\P{^Is_Blk=-	Brahmi}', "");
    Error('\p{Block=-_Braille_Patterns:=}');
    Error('\P{Block=-_Braille_Patterns:=}');
    Expect(1, 10495, '\p{Block=:\ABraille_Patterns\z:}', "");;
    Expect(0, 10496, '\p{Block=:\ABraille_Patterns\z:}', "");;
    Expect(1, 10495, '\p{Block=braillepatterns}', "");
    Expect(0, 10495, '\p{^Block=braillepatterns}', "");
    Expect(0, 10495, '\P{Block=braillepatterns}', "");
    Expect(1, 10495, '\P{^Block=braillepatterns}', "");
    Expect(0, 10496, '\p{Block=braillepatterns}', "");
    Expect(1, 10496, '\p{^Block=braillepatterns}', "");
    Expect(1, 10496, '\P{Block=braillepatterns}', "");
    Expect(0, 10496, '\P{^Block=braillepatterns}', "");
    Expect(1, 10495, '\p{Block=:\Abraillepatterns\z:}', "");;
    Expect(0, 10496, '\p{Block=:\Abraillepatterns\z:}', "");;
    Expect(1, 10495, '\p{Block= Braille_Patterns}', "");
    Expect(0, 10495, '\p{^Block= Braille_Patterns}', "");
    Expect(0, 10495, '\P{Block= Braille_Patterns}', "");
    Expect(1, 10495, '\P{^Block= Braille_Patterns}', "");
    Expect(0, 10496, '\p{Block= Braille_Patterns}', "");
    Expect(1, 10496, '\p{^Block= Braille_Patterns}', "");
    Expect(1, 10496, '\P{Block= Braille_Patterns}', "");
    Expect(0, 10496, '\P{^Block= Braille_Patterns}', "");
    Error('\p{Blk=:=		BRAILLE}');
    Error('\P{Blk=:=		BRAILLE}');
    Expect(1, 10495, '\p{Blk=:\ABraille\z:}', "");;
    Expect(0, 10496, '\p{Blk=:\ABraille\z:}', "");;
    Expect(1, 10495, '\p{Blk=braille}', "");
    Expect(0, 10495, '\p{^Blk=braille}', "");
    Expect(0, 10495, '\P{Blk=braille}', "");
    Expect(1, 10495, '\P{^Blk=braille}', "");
    Expect(0, 10496, '\p{Blk=braille}', "");
    Expect(1, 10496, '\p{^Blk=braille}', "");
    Expect(1, 10496, '\P{Blk=braille}', "");
    Expect(0, 10496, '\P{^Blk=braille}', "");
    Expect(1, 10495, '\p{Blk=:\Abraille\z:}', "");;
    Expect(0, 10496, '\p{Blk=:\Abraille\z:}', "");;
    Expect(1, 10495, '\p{Blk=	Braille}', "");
    Expect(0, 10495, '\p{^Blk=	Braille}', "");
    Expect(0, 10495, '\P{Blk=	Braille}', "");
    Expect(1, 10495, '\P{^Blk=	Braille}', "");
    Expect(0, 10496, '\p{Blk=	Braille}', "");
    Expect(1, 10496, '\p{^Blk=	Braille}', "");
    Expect(1, 10496, '\P{Blk=	Braille}', "");
    Expect(0, 10496, '\P{^Blk=	Braille}', "");
    Error('\p{Is_Block=-:=Braille_PATTERNS}');
    Error('\P{Is_Block=-:=Braille_PATTERNS}');
    Expect(1, 10495, '\p{Is_Block=braillepatterns}', "");
    Expect(0, 10495, '\p{^Is_Block=braillepatterns}', "");
    Expect(0, 10495, '\P{Is_Block=braillepatterns}', "");
    Expect(1, 10495, '\P{^Is_Block=braillepatterns}', "");
    Expect(0, 10496, '\p{Is_Block=braillepatterns}', "");
    Expect(1, 10496, '\p{^Is_Block=braillepatterns}', "");
    Expect(1, 10496, '\P{Is_Block=braillepatterns}', "");
    Expect(0, 10496, '\P{^Is_Block=braillepatterns}', "");
    Expect(1, 10495, '\p{Is_Block=BRAILLE_Patterns}', "");
    Expect(0, 10495, '\p{^Is_Block=BRAILLE_Patterns}', "");
    Expect(0, 10495, '\P{Is_Block=BRAILLE_Patterns}', "");
    Expect(1, 10495, '\P{^Is_Block=BRAILLE_Patterns}', "");
    Expect(0, 10496, '\p{Is_Block=BRAILLE_Patterns}', "");
    Expect(1, 10496, '\p{^Is_Block=BRAILLE_Patterns}', "");
    Expect(1, 10496, '\P{Is_Block=BRAILLE_Patterns}', "");
    Expect(0, 10496, '\P{^Is_Block=BRAILLE_Patterns}', "");
    Error('\p{Is_Blk:  :=Braille}');
    Error('\P{Is_Blk:  :=Braille}');
    Expect(1, 10495, '\p{Is_Blk=braille}', "");
    Expect(0, 10495, '\p{^Is_Blk=braille}', "");
    Expect(0, 10495, '\P{Is_Blk=braille}', "");
    Expect(1, 10495, '\P{^Is_Blk=braille}', "");
    Expect(0, 10496, '\p{Is_Blk=braille}', "");
    Expect(1, 10496, '\p{^Is_Blk=braille}', "");
    Expect(1, 10496, '\P{Is_Blk=braille}', "");
    Expect(0, 10496, '\P{^Is_Blk=braille}', "");
    Expect(1, 10495, '\p{Is_Blk=-_Braille}', "");
    Expect(0, 10495, '\p{^Is_Blk=-_Braille}', "");
    Expect(0, 10495, '\P{Is_Blk=-_Braille}', "");
    Expect(1, 10495, '\P{^Is_Blk=-_Braille}', "");
    Expect(0, 10496, '\p{Is_Blk=-_Braille}', "");
    Expect(1, 10496, '\p{^Is_Blk=-_Braille}', "");
    Expect(1, 10496, '\P{Is_Blk=-_Braille}', "");
    Expect(0, 10496, '\P{^Is_Blk=-_Braille}', "");
    Error('\p{Block=:=Buginese}');
    Error('\P{Block=:=Buginese}');
    Expect(1, 6687, '\p{Block=:\ABuginese\z:}', "");;
    Expect(0, 6688, '\p{Block=:\ABuginese\z:}', "");;
    Expect(1, 6687, '\p{Block=buginese}', "");
    Expect(0, 6687, '\p{^Block=buginese}', "");
    Expect(0, 6687, '\P{Block=buginese}', "");
    Expect(1, 6687, '\P{^Block=buginese}', "");
    Expect(0, 6688, '\p{Block=buginese}', "");
    Expect(1, 6688, '\p{^Block=buginese}', "");
    Expect(1, 6688, '\P{Block=buginese}', "");
    Expect(0, 6688, '\P{^Block=buginese}', "");
    Expect(1, 6687, '\p{Block=:\Abuginese\z:}', "");;
    Expect(0, 6688, '\p{Block=:\Abuginese\z:}', "");;
    Expect(1, 6687, '\p{Block: buginese}', "");
    Expect(0, 6687, '\p{^Block: buginese}', "");
    Expect(0, 6687, '\P{Block: buginese}', "");
    Expect(1, 6687, '\P{^Block: buginese}', "");
    Expect(0, 6688, '\p{Block: buginese}', "");
    Expect(1, 6688, '\p{^Block: buginese}', "");
    Expect(1, 6688, '\P{Block: buginese}', "");
    Expect(0, 6688, '\P{^Block: buginese}', "");
    Error('\p{Blk=/a/	Buginese}');
    Error('\P{Blk=/a/	Buginese}');
    Expect(1, 6687, '\p{Blk=:\ABuginese\z:}', "");;
    Expect(0, 6688, '\p{Blk=:\ABuginese\z:}', "");;
    Expect(1, 6687, '\p{Blk=buginese}', "");
    Expect(0, 6687, '\p{^Blk=buginese}', "");
    Expect(0, 6687, '\P{Blk=buginese}', "");
    Expect(1, 6687, '\P{^Blk=buginese}', "");
    Expect(0, 6688, '\p{Blk=buginese}', "");
    Expect(1, 6688, '\p{^Blk=buginese}', "");
    Expect(1, 6688, '\P{Blk=buginese}', "");
    Expect(0, 6688, '\P{^Blk=buginese}', "");
    Expect(1, 6687, '\p{Blk=:\Abuginese\z:}', "");;
    Expect(0, 6688, '\p{Blk=:\Abuginese\z:}', "");;
    Expect(1, 6687, '\p{Blk:   	 Buginese}', "");
    Expect(0, 6687, '\p{^Blk:   	 Buginese}', "");
    Expect(0, 6687, '\P{Blk:   	 Buginese}', "");
    Expect(1, 6687, '\P{^Blk:   	 Buginese}', "");
    Expect(0, 6688, '\p{Blk:   	 Buginese}', "");
    Expect(1, 6688, '\p{^Blk:   	 Buginese}', "");
    Expect(1, 6688, '\P{Blk:   	 Buginese}', "");
    Expect(0, 6688, '\P{^Blk:   	 Buginese}', "");
    Error('\p{Is_Block= Buginese:=}');
    Error('\P{Is_Block= Buginese:=}');
    Expect(1, 6687, '\p{Is_Block=buginese}', "");
    Expect(0, 6687, '\p{^Is_Block=buginese}', "");
    Expect(0, 6687, '\P{Is_Block=buginese}', "");
    Expect(1, 6687, '\P{^Is_Block=buginese}', "");
    Expect(0, 6688, '\p{Is_Block=buginese}', "");
    Expect(1, 6688, '\p{^Is_Block=buginese}', "");
    Expect(1, 6688, '\P{Is_Block=buginese}', "");
    Expect(0, 6688, '\P{^Is_Block=buginese}', "");
    Expect(1, 6687, '\p{Is_Block=	-Buginese}', "");
    Expect(0, 6687, '\p{^Is_Block=	-Buginese}', "");
    Expect(0, 6687, '\P{Is_Block=	-Buginese}', "");
    Expect(1, 6687, '\P{^Is_Block=	-Buginese}', "");
    Expect(0, 6688, '\p{Is_Block=	-Buginese}', "");
    Expect(1, 6688, '\p{^Is_Block=	-Buginese}', "");
    Expect(1, 6688, '\P{Is_Block=	-Buginese}', "");
    Expect(0, 6688, '\P{^Is_Block=	-Buginese}', "");
    Error('\p{Is_Blk=-:=buginese}');
    Error('\P{Is_Blk=-:=buginese}');
    Expect(1, 6687, '\p{Is_Blk=buginese}', "");
    Expect(0, 6687, '\p{^Is_Blk=buginese}', "");
    Expect(0, 6687, '\P{Is_Blk=buginese}', "");
    Expect(1, 6687, '\P{^Is_Blk=buginese}', "");
    Expect(0, 6688, '\p{Is_Blk=buginese}', "");
    Expect(1, 6688, '\p{^Is_Blk=buginese}', "");
    Expect(1, 6688, '\P{Is_Blk=buginese}', "");
    Expect(0, 6688, '\P{^Is_Blk=buginese}', "");
    Expect(1, 6687, '\p{Is_Blk=_-Buginese}', "");
    Expect(0, 6687, '\p{^Is_Blk=_-Buginese}', "");
    Expect(0, 6687, '\P{Is_Blk=_-Buginese}', "");
    Expect(1, 6687, '\P{^Is_Blk=_-Buginese}', "");
    Expect(0, 6688, '\p{Is_Blk=_-Buginese}', "");
    Expect(1, 6688, '\p{^Is_Blk=_-Buginese}', "");
    Expect(1, 6688, '\P{Is_Blk=_-Buginese}', "");
    Expect(0, 6688, '\P{^Is_Blk=_-Buginese}', "");
    Error('\p{Block=/a/	-Buhid}');
    Error('\P{Block=/a/	-Buhid}');
    Expect(1, 5983, '\p{Block=:\ABuhid\z:}', "");;
    Expect(0, 5984, '\p{Block=:\ABuhid\z:}', "");;
    Expect(1, 5983, '\p{Block=buhid}', "");
    Expect(0, 5983, '\p{^Block=buhid}', "");
    Expect(0, 5983, '\P{Block=buhid}', "");
    Expect(1, 5983, '\P{^Block=buhid}', "");
    Expect(0, 5984, '\p{Block=buhid}', "");
    Expect(1, 5984, '\p{^Block=buhid}', "");
    Expect(1, 5984, '\P{Block=buhid}', "");
    Expect(0, 5984, '\P{^Block=buhid}', "");
    Expect(1, 5983, '\p{Block=:\Abuhid\z:}', "");;
    Expect(0, 5984, '\p{Block=:\Abuhid\z:}', "");;
    Expect(1, 5983, '\p{Block=_	BUHID}', "");
    Expect(0, 5983, '\p{^Block=_	BUHID}', "");
    Expect(0, 5983, '\P{Block=_	BUHID}', "");
    Expect(1, 5983, '\P{^Block=_	BUHID}', "");
    Expect(0, 5984, '\p{Block=_	BUHID}', "");
    Expect(1, 5984, '\p{^Block=_	BUHID}', "");
    Expect(1, 5984, '\P{Block=_	BUHID}', "");
    Expect(0, 5984, '\P{^Block=_	BUHID}', "");
    Error('\p{Blk=_:=Buhid}');
    Error('\P{Blk=_:=Buhid}');
    Expect(1, 5983, '\p{Blk=:\ABuhid\z:}', "");;
    Expect(0, 5984, '\p{Blk=:\ABuhid\z:}', "");;
    Expect(1, 5983, '\p{Blk=buhid}', "");
    Expect(0, 5983, '\p{^Blk=buhid}', "");
    Expect(0, 5983, '\P{Blk=buhid}', "");
    Expect(1, 5983, '\P{^Blk=buhid}', "");
    Expect(0, 5984, '\p{Blk=buhid}', "");
    Expect(1, 5984, '\p{^Blk=buhid}', "");
    Expect(1, 5984, '\P{Blk=buhid}', "");
    Expect(0, 5984, '\P{^Blk=buhid}', "");
    Expect(1, 5983, '\p{Blk=:\Abuhid\z:}', "");;
    Expect(0, 5984, '\p{Blk=:\Abuhid\z:}', "");;
    Expect(1, 5983, '\p{Blk=_	Buhid}', "");
    Expect(0, 5983, '\p{^Blk=_	Buhid}', "");
    Expect(0, 5983, '\P{Blk=_	Buhid}', "");
    Expect(1, 5983, '\P{^Blk=_	Buhid}', "");
    Expect(0, 5984, '\p{Blk=_	Buhid}', "");
    Expect(1, 5984, '\p{^Blk=_	Buhid}', "");
    Expect(1, 5984, '\P{Blk=_	Buhid}', "");
    Expect(0, 5984, '\P{^Blk=_	Buhid}', "");
    Error('\p{Is_Block=_:=buhid}');
    Error('\P{Is_Block=_:=buhid}');
    Expect(1, 5983, '\p{Is_Block=buhid}', "");
    Expect(0, 5983, '\p{^Is_Block=buhid}', "");
    Expect(0, 5983, '\P{Is_Block=buhid}', "");
    Expect(1, 5983, '\P{^Is_Block=buhid}', "");
    Expect(0, 5984, '\p{Is_Block=buhid}', "");
    Expect(1, 5984, '\p{^Is_Block=buhid}', "");
    Expect(1, 5984, '\P{Is_Block=buhid}', "");
    Expect(0, 5984, '\P{^Is_Block=buhid}', "");
    Expect(1, 5983, '\p{Is_Block=-_BUHID}', "");
    Expect(0, 5983, '\p{^Is_Block=-_BUHID}', "");
    Expect(0, 5983, '\P{Is_Block=-_BUHID}', "");
    Expect(1, 5983, '\P{^Is_Block=-_BUHID}', "");
    Expect(0, 5984, '\p{Is_Block=-_BUHID}', "");
    Expect(1, 5984, '\p{^Is_Block=-_BUHID}', "");
    Expect(1, 5984, '\P{Is_Block=-_BUHID}', "");
    Expect(0, 5984, '\P{^Is_Block=-_BUHID}', "");
    Error('\p{Is_Blk=	:=buhid}');
    Error('\P{Is_Blk=	:=buhid}');
    Expect(1, 5983, '\p{Is_Blk=buhid}', "");
    Expect(0, 5983, '\p{^Is_Blk=buhid}', "");
    Expect(0, 5983, '\P{Is_Blk=buhid}', "");
    Expect(1, 5983, '\P{^Is_Blk=buhid}', "");
    Expect(0, 5984, '\p{Is_Blk=buhid}', "");
    Expect(1, 5984, '\p{^Is_Blk=buhid}', "");
    Expect(1, 5984, '\P{Is_Blk=buhid}', "");
    Expect(0, 5984, '\P{^Is_Blk=buhid}', "");
    Expect(1, 5983, '\p{Is_Blk= BUHID}', "");
    Expect(0, 5983, '\p{^Is_Blk= BUHID}', "");
    Expect(0, 5983, '\P{Is_Blk= BUHID}', "");
    Expect(1, 5983, '\P{^Is_Blk= BUHID}', "");
    Expect(0, 5984, '\p{Is_Blk= BUHID}', "");
    Expect(1, 5984, '\p{^Is_Blk= BUHID}', "");
    Expect(1, 5984, '\P{Is_Blk= BUHID}', "");
    Expect(0, 5984, '\P{^Is_Blk= BUHID}', "");
    Error('\p{Block=:= _Byzantine_Musical_symbols}');
    Error('\P{Block=:= _Byzantine_Musical_symbols}');
    Expect(1, 119039, '\p{Block=:\AByzantine_Musical_Symbols\z:}', "");;
    Expect(0, 119040, '\p{Block=:\AByzantine_Musical_Symbols\z:}', "");;
    Expect(1, 119039, '\p{Block=byzantinemusicalsymbols}', "");
    Expect(0, 119039, '\p{^Block=byzantinemusicalsymbols}', "");
    Expect(0, 119039, '\P{Block=byzantinemusicalsymbols}', "");
    Expect(1, 119039, '\P{^Block=byzantinemusicalsymbols}', "");
    Expect(0, 119040, '\p{Block=byzantinemusicalsymbols}', "");
    Expect(1, 119040, '\p{^Block=byzantinemusicalsymbols}', "");
    Expect(1, 119040, '\P{Block=byzantinemusicalsymbols}', "");
    Expect(0, 119040, '\P{^Block=byzantinemusicalsymbols}', "");
    Expect(1, 119039, '\p{Block=:\Abyzantinemusicalsymbols\z:}', "");;
    Expect(0, 119040, '\p{Block=:\Abyzantinemusicalsymbols\z:}', "");;
    Expect(1, 119039, '\p{Block= BYZANTINE_Musical_Symbols}', "");
    Expect(0, 119039, '\p{^Block= BYZANTINE_Musical_Symbols}', "");
    Expect(0, 119039, '\P{Block= BYZANTINE_Musical_Symbols}', "");
    Expect(1, 119039, '\P{^Block= BYZANTINE_Musical_Symbols}', "");
    Expect(0, 119040, '\p{Block= BYZANTINE_Musical_Symbols}', "");
    Expect(1, 119040, '\p{^Block= BYZANTINE_Musical_Symbols}', "");
    Expect(1, 119040, '\P{Block= BYZANTINE_Musical_Symbols}', "");
    Expect(0, 119040, '\P{^Block= BYZANTINE_Musical_Symbols}', "");
    Error('\p{Blk=_:=Byzantine_Music}');
    Error('\P{Blk=_:=Byzantine_Music}');
    Expect(1, 119039, '\p{Blk=:\AByzantine_Music\z:}', "");;
    Expect(0, 119040, '\p{Blk=:\AByzantine_Music\z:}', "");;
    Expect(1, 119039, '\p{Blk=byzantinemusic}', "");
    Expect(0, 119039, '\p{^Blk=byzantinemusic}', "");
    Expect(0, 119039, '\P{Blk=byzantinemusic}', "");
    Expect(1, 119039, '\P{^Blk=byzantinemusic}', "");
    Expect(0, 119040, '\p{Blk=byzantinemusic}', "");
    Expect(1, 119040, '\p{^Blk=byzantinemusic}', "");
    Expect(1, 119040, '\P{Blk=byzantinemusic}', "");
    Expect(0, 119040, '\P{^Blk=byzantinemusic}', "");
    Expect(1, 119039, '\p{Blk=:\Abyzantinemusic\z:}', "");;
    Expect(0, 119040, '\p{Blk=:\Abyzantinemusic\z:}', "");;
    Expect(1, 119039, '\p{Blk=- Byzantine_Music}', "");
    Expect(0, 119039, '\p{^Blk=- Byzantine_Music}', "");
    Expect(0, 119039, '\P{Blk=- Byzantine_Music}', "");
    Expect(1, 119039, '\P{^Blk=- Byzantine_Music}', "");
    Expect(0, 119040, '\p{Blk=- Byzantine_Music}', "");
    Expect(1, 119040, '\p{^Blk=- Byzantine_Music}', "");
    Expect(1, 119040, '\P{Blk=- Byzantine_Music}', "");
    Expect(0, 119040, '\P{^Blk=- Byzantine_Music}', "");
    Error('\p{Is_Block=/a/ -Byzantine_musical_SYMBOLS}');
    Error('\P{Is_Block=/a/ -Byzantine_musical_SYMBOLS}');
    Expect(1, 119039, '\p{Is_Block=byzantinemusicalsymbols}', "");
    Expect(0, 119039, '\p{^Is_Block=byzantinemusicalsymbols}', "");
    Expect(0, 119039, '\P{Is_Block=byzantinemusicalsymbols}', "");
    Expect(1, 119039, '\P{^Is_Block=byzantinemusicalsymbols}', "");
    Expect(0, 119040, '\p{Is_Block=byzantinemusicalsymbols}', "");
    Expect(1, 119040, '\p{^Is_Block=byzantinemusicalsymbols}', "");
    Expect(1, 119040, '\P{Is_Block=byzantinemusicalsymbols}', "");
    Expect(0, 119040, '\P{^Is_Block=byzantinemusicalsymbols}', "");
    Expect(1, 119039, '\p{Is_Block= 	Byzantine_MUSICAL_symbols}', "");
    Expect(0, 119039, '\p{^Is_Block= 	Byzantine_MUSICAL_symbols}', "");
    Expect(0, 119039, '\P{Is_Block= 	Byzantine_MUSICAL_symbols}', "");
    Expect(1, 119039, '\P{^Is_Block= 	Byzantine_MUSICAL_symbols}', "");
    Expect(0, 119040, '\p{Is_Block= 	Byzantine_MUSICAL_symbols}', "");
    Expect(1, 119040, '\p{^Is_Block= 	Byzantine_MUSICAL_symbols}', "");
    Expect(1, 119040, '\P{Is_Block= 	Byzantine_MUSICAL_symbols}', "");
    Expect(0, 119040, '\P{^Is_Block= 	Byzantine_MUSICAL_symbols}', "");
    Error('\p{Is_Blk=		BYZANTINE_Music/a/}');
    Error('\P{Is_Blk=		BYZANTINE_Music/a/}');
    Expect(1, 119039, '\p{Is_Blk=byzantinemusic}', "");
    Expect(0, 119039, '\p{^Is_Blk=byzantinemusic}', "");
    Expect(0, 119039, '\P{Is_Blk=byzantinemusic}', "");
    Expect(1, 119039, '\P{^Is_Blk=byzantinemusic}', "");
    Expect(0, 119040, '\p{Is_Blk=byzantinemusic}', "");
    Expect(1, 119040, '\p{^Is_Blk=byzantinemusic}', "");
    Expect(1, 119040, '\P{Is_Blk=byzantinemusic}', "");
    Expect(0, 119040, '\P{^Is_Blk=byzantinemusic}', "");
    Expect(1, 119039, '\p{Is_Blk:_-BYZANTINE_Music}', "");
    Expect(0, 119039, '\p{^Is_Blk:_-BYZANTINE_Music}', "");
    Expect(0, 119039, '\P{Is_Blk:_-BYZANTINE_Music}', "");
    Expect(1, 119039, '\P{^Is_Blk:_-BYZANTINE_Music}', "");
    Expect(0, 119040, '\p{Is_Blk:_-BYZANTINE_Music}', "");
    Expect(1, 119040, '\p{^Is_Blk:_-BYZANTINE_Music}', "");
    Expect(1, 119040, '\P{Is_Blk:_-BYZANTINE_Music}', "");
    Expect(0, 119040, '\P{^Is_Blk:_-BYZANTINE_Music}', "");
    Error('\p{Block:-	CARIAN/a/}');
    Error('\P{Block:-	CARIAN/a/}');
    Expect(1, 66271, '\p{Block=:\ACarian\z:}', "");;
    Expect(0, 66272, '\p{Block=:\ACarian\z:}', "");;
    Expect(1, 66271, '\p{Block=carian}', "");
    Expect(0, 66271, '\p{^Block=carian}', "");
    Expect(0, 66271, '\P{Block=carian}', "");
    Expect(1, 66271, '\P{^Block=carian}', "");
    Expect(0, 66272, '\p{Block=carian}', "");
    Expect(1, 66272, '\p{^Block=carian}', "");
    Expect(1, 66272, '\P{Block=carian}', "");
    Expect(0, 66272, '\P{^Block=carian}', "");
    Expect(1, 66271, '\p{Block=:\Acarian\z:}', "");;
    Expect(0, 66272, '\p{Block=:\Acarian\z:}', "");;
    Expect(1, 66271, '\p{Block=-CARIAN}', "");
    Expect(0, 66271, '\p{^Block=-CARIAN}', "");
    Expect(0, 66271, '\P{Block=-CARIAN}', "");
    Expect(1, 66271, '\P{^Block=-CARIAN}', "");
    Expect(0, 66272, '\p{Block=-CARIAN}', "");
    Expect(1, 66272, '\p{^Block=-CARIAN}', "");
    Expect(1, 66272, '\P{Block=-CARIAN}', "");
    Expect(0, 66272, '\P{^Block=-CARIAN}', "");
    Error('\p{Blk=-/a/carian}');
    Error('\P{Blk=-/a/carian}');
    Expect(1, 66271, '\p{Blk=:\ACarian\z:}', "");;
    Expect(0, 66272, '\p{Blk=:\ACarian\z:}', "");;
    Expect(1, 66271, '\p{Blk=carian}', "");
    Expect(0, 66271, '\p{^Blk=carian}', "");
    Expect(0, 66271, '\P{Blk=carian}', "");
    Expect(1, 66271, '\P{^Blk=carian}', "");
    Expect(0, 66272, '\p{Blk=carian}', "");
    Expect(1, 66272, '\p{^Blk=carian}', "");
    Expect(1, 66272, '\P{Blk=carian}', "");
    Expect(0, 66272, '\P{^Blk=carian}', "");
    Expect(1, 66271, '\p{Blk=:\Acarian\z:}', "");;
    Expect(0, 66272, '\p{Blk=:\Acarian\z:}', "");;
    Expect(1, 66271, '\p{Blk= -carian}', "");
    Expect(0, 66271, '\p{^Blk= -carian}', "");
    Expect(0, 66271, '\P{Blk= -carian}', "");
    Expect(1, 66271, '\P{^Blk= -carian}', "");
    Expect(0, 66272, '\p{Blk= -carian}', "");
    Expect(1, 66272, '\p{^Blk= -carian}', "");
    Expect(1, 66272, '\P{Blk= -carian}', "");
    Expect(0, 66272, '\P{^Blk= -carian}', "");
    Error('\p{Is_Block=-	CARIAN/a/}');
    Error('\P{Is_Block=-	CARIAN/a/}');
    Expect(1, 66271, '\p{Is_Block:	carian}', "");
    Expect(0, 66271, '\p{^Is_Block:	carian}', "");
    Expect(0, 66271, '\P{Is_Block:	carian}', "");
    Expect(1, 66271, '\P{^Is_Block:	carian}', "");
    Expect(0, 66272, '\p{Is_Block:	carian}', "");
    Expect(1, 66272, '\p{^Is_Block:	carian}', "");
    Expect(1, 66272, '\P{Is_Block:	carian}', "");
    Expect(0, 66272, '\P{^Is_Block:	carian}', "");
    Expect(1, 66271, '\p{Is_Block=	-Carian}', "");
    Expect(0, 66271, '\p{^Is_Block=	-Carian}', "");
    Expect(0, 66271, '\P{Is_Block=	-Carian}', "");
    Expect(1, 66271, '\P{^Is_Block=	-Carian}', "");
    Expect(0, 66272, '\p{Is_Block=	-Carian}', "");
    Expect(1, 66272, '\p{^Is_Block=	-Carian}', "");
    Expect(1, 66272, '\P{Is_Block=	-Carian}', "");
    Expect(0, 66272, '\P{^Is_Block=	-Carian}', "");
    Error('\p{Is_Blk= Carian:=}');
    Error('\P{Is_Blk= Carian:=}');
    Expect(1, 66271, '\p{Is_Blk:   carian}', "");
    Expect(0, 66271, '\p{^Is_Blk:   carian}', "");
    Expect(0, 66271, '\P{Is_Blk:   carian}', "");
    Expect(1, 66271, '\P{^Is_Blk:   carian}', "");
    Expect(0, 66272, '\p{Is_Blk:   carian}', "");
    Expect(1, 66272, '\p{^Is_Blk:   carian}', "");
    Expect(1, 66272, '\P{Is_Blk:   carian}', "");
    Expect(0, 66272, '\P{^Is_Blk:   carian}', "");
    Expect(1, 66271, '\p{Is_Blk= 	carian}', "");
    Expect(0, 66271, '\p{^Is_Blk= 	carian}', "");
    Expect(0, 66271, '\P{Is_Blk= 	carian}', "");
    Expect(1, 66271, '\P{^Is_Blk= 	carian}', "");
    Expect(0, 66272, '\p{Is_Blk= 	carian}', "");
    Expect(1, 66272, '\p{^Is_Blk= 	carian}', "");
    Expect(1, 66272, '\P{Is_Blk= 	carian}', "");
    Expect(0, 66272, '\P{^Is_Blk= 	carian}', "");
    Error('\p{Block:   :=_Caucasian_Albanian}');
    Error('\P{Block:   :=_Caucasian_Albanian}');
    Expect(1, 66927, '\p{Block=:\ACaucasian_Albanian\z:}', "");;
    Expect(0, 66928, '\p{Block=:\ACaucasian_Albanian\z:}', "");;
    Expect(1, 66927, '\p{Block=caucasianalbanian}', "");
    Expect(0, 66927, '\p{^Block=caucasianalbanian}', "");
    Expect(0, 66927, '\P{Block=caucasianalbanian}', "");
    Expect(1, 66927, '\P{^Block=caucasianalbanian}', "");
    Expect(0, 66928, '\p{Block=caucasianalbanian}', "");
    Expect(1, 66928, '\p{^Block=caucasianalbanian}', "");
    Expect(1, 66928, '\P{Block=caucasianalbanian}', "");
    Expect(0, 66928, '\P{^Block=caucasianalbanian}', "");
    Expect(1, 66927, '\p{Block=:\Acaucasianalbanian\z:}', "");;
    Expect(0, 66928, '\p{Block=:\Acaucasianalbanian\z:}', "");;
    Expect(1, 66927, '\p{Block=	CAUCASIAN_ALBANIAN}', "");
    Expect(0, 66927, '\p{^Block=	CAUCASIAN_ALBANIAN}', "");
    Expect(0, 66927, '\P{Block=	CAUCASIAN_ALBANIAN}', "");
    Expect(1, 66927, '\P{^Block=	CAUCASIAN_ALBANIAN}', "");
    Expect(0, 66928, '\p{Block=	CAUCASIAN_ALBANIAN}', "");
    Expect(1, 66928, '\p{^Block=	CAUCASIAN_ALBANIAN}', "");
    Expect(1, 66928, '\P{Block=	CAUCASIAN_ALBANIAN}', "");
    Expect(0, 66928, '\P{^Block=	CAUCASIAN_ALBANIAN}', "");
    Error('\p{Blk=/a/	-caucasian_ALBANIAN}');
    Error('\P{Blk=/a/	-caucasian_ALBANIAN}');
    Expect(1, 66927, '\p{Blk=:\ACaucasian_Albanian\z:}', "");;
    Expect(0, 66928, '\p{Blk=:\ACaucasian_Albanian\z:}', "");;
    Expect(1, 66927, '\p{Blk=caucasianalbanian}', "");
    Expect(0, 66927, '\p{^Blk=caucasianalbanian}', "");
    Expect(0, 66927, '\P{Blk=caucasianalbanian}', "");
    Expect(1, 66927, '\P{^Blk=caucasianalbanian}', "");
    Expect(0, 66928, '\p{Blk=caucasianalbanian}', "");
    Expect(1, 66928, '\p{^Blk=caucasianalbanian}', "");
    Expect(1, 66928, '\P{Blk=caucasianalbanian}', "");
    Expect(0, 66928, '\P{^Blk=caucasianalbanian}', "");
    Expect(1, 66927, '\p{Blk=:\Acaucasianalbanian\z:}', "");;
    Expect(0, 66928, '\p{Blk=:\Acaucasianalbanian\z:}', "");;
    Expect(1, 66927, '\p{Blk=-	CAUCASIAN_albanian}', "");
    Expect(0, 66927, '\p{^Blk=-	CAUCASIAN_albanian}', "");
    Expect(0, 66927, '\P{Blk=-	CAUCASIAN_albanian}', "");
    Expect(1, 66927, '\P{^Blk=-	CAUCASIAN_albanian}', "");
    Expect(0, 66928, '\p{Blk=-	CAUCASIAN_albanian}', "");
    Expect(1, 66928, '\p{^Blk=-	CAUCASIAN_albanian}', "");
    Expect(1, 66928, '\P{Blk=-	CAUCASIAN_albanian}', "");
    Expect(0, 66928, '\P{^Blk=-	CAUCASIAN_albanian}', "");
    Error('\p{Is_Block=/a/ _caucasian_ALBANIAN}');
    Error('\P{Is_Block=/a/ _caucasian_ALBANIAN}');
    Expect(1, 66927, '\p{Is_Block:   caucasianalbanian}', "");
    Expect(0, 66927, '\p{^Is_Block:   caucasianalbanian}', "");
    Expect(0, 66927, '\P{Is_Block:   caucasianalbanian}', "");
    Expect(1, 66927, '\P{^Is_Block:   caucasianalbanian}', "");
    Expect(0, 66928, '\p{Is_Block:   caucasianalbanian}', "");
    Expect(1, 66928, '\p{^Is_Block:   caucasianalbanian}', "");
    Expect(1, 66928, '\P{Is_Block:   caucasianalbanian}', "");
    Expect(0, 66928, '\P{^Is_Block:   caucasianalbanian}', "");
    Expect(1, 66927, '\p{Is_Block=	 Caucasian_albanian}', "");
    Expect(0, 66927, '\p{^Is_Block=	 Caucasian_albanian}', "");
    Expect(0, 66927, '\P{Is_Block=	 Caucasian_albanian}', "");
    Expect(1, 66927, '\P{^Is_Block=	 Caucasian_albanian}', "");
    Expect(0, 66928, '\p{Is_Block=	 Caucasian_albanian}', "");
    Expect(1, 66928, '\p{^Is_Block=	 Caucasian_albanian}', "");
    Expect(1, 66928, '\P{Is_Block=	 Caucasian_albanian}', "");
    Expect(0, 66928, '\P{^Is_Block=	 Caucasian_albanian}', "");
    Error('\p{Is_Blk= /a/Caucasian_ALBANIAN}');
    Error('\P{Is_Blk= /a/Caucasian_ALBANIAN}');
    Expect(1, 66927, '\p{Is_Blk=caucasianalbanian}', "");
    Expect(0, 66927, '\p{^Is_Blk=caucasianalbanian}', "");
    Expect(0, 66927, '\P{Is_Blk=caucasianalbanian}', "");
    Expect(1, 66927, '\P{^Is_Blk=caucasianalbanian}', "");
    Expect(0, 66928, '\p{Is_Blk=caucasianalbanian}', "");
    Expect(1, 66928, '\p{^Is_Blk=caucasianalbanian}', "");
    Expect(1, 66928, '\P{Is_Blk=caucasianalbanian}', "");
    Expect(0, 66928, '\P{^Is_Blk=caucasianalbanian}', "");
    Expect(1, 66927, '\p{Is_Blk= Caucasian_albanian}', "");
    Expect(0, 66927, '\p{^Is_Blk= Caucasian_albanian}', "");
    Expect(0, 66927, '\P{Is_Blk= Caucasian_albanian}', "");
    Expect(1, 66927, '\P{^Is_Blk= Caucasian_albanian}', "");
    Expect(0, 66928, '\p{Is_Blk= Caucasian_albanian}', "");
    Expect(1, 66928, '\p{^Is_Blk= Caucasian_albanian}', "");
    Expect(1, 66928, '\P{Is_Blk= Caucasian_albanian}', "");
    Expect(0, 66928, '\P{^Is_Blk= Caucasian_albanian}', "");
    Error('\p{Block=--Chakma/a/}');
    Error('\P{Block=--Chakma/a/}');
    Expect(1, 69967, '\p{Block=:\AChakma\z:}', "");;
    Expect(0, 69968, '\p{Block=:\AChakma\z:}', "");;
    Expect(1, 69967, '\p{Block=chakma}', "");
    Expect(0, 69967, '\p{^Block=chakma}', "");
    Expect(0, 69967, '\P{Block=chakma}', "");
    Expect(1, 69967, '\P{^Block=chakma}', "");
    Expect(0, 69968, '\p{Block=chakma}', "");
    Expect(1, 69968, '\p{^Block=chakma}', "");
    Expect(1, 69968, '\P{Block=chakma}', "");
    Expect(0, 69968, '\P{^Block=chakma}', "");
    Expect(1, 69967, '\p{Block=:\Achakma\z:}', "");;
    Expect(0, 69968, '\p{Block=:\Achakma\z:}', "");;
    Expect(1, 69967, '\p{Block=-Chakma}', "");
    Expect(0, 69967, '\p{^Block=-Chakma}', "");
    Expect(0, 69967, '\P{Block=-Chakma}', "");
    Expect(1, 69967, '\P{^Block=-Chakma}', "");
    Expect(0, 69968, '\p{Block=-Chakma}', "");
    Expect(1, 69968, '\p{^Block=-Chakma}', "");
    Expect(1, 69968, '\P{Block=-Chakma}', "");
    Expect(0, 69968, '\P{^Block=-Chakma}', "");
    Error('\p{Blk=/a/CHAKMA}');
    Error('\P{Blk=/a/CHAKMA}');
    Expect(1, 69967, '\p{Blk=:\AChakma\z:}', "");;
    Expect(0, 69968, '\p{Blk=:\AChakma\z:}', "");;
    Expect(1, 69967, '\p{Blk=chakma}', "");
    Expect(0, 69967, '\p{^Blk=chakma}', "");
    Expect(0, 69967, '\P{Blk=chakma}', "");
    Expect(1, 69967, '\P{^Blk=chakma}', "");
    Expect(0, 69968, '\p{Blk=chakma}', "");
    Expect(1, 69968, '\p{^Blk=chakma}', "");
    Expect(1, 69968, '\P{Blk=chakma}', "");
    Expect(0, 69968, '\P{^Blk=chakma}', "");
    Expect(1, 69967, '\p{Blk=:\Achakma\z:}', "");;
    Expect(0, 69968, '\p{Blk=:\Achakma\z:}', "");;
    Expect(1, 69967, '\p{Blk= Chakma}', "");
    Expect(0, 69967, '\p{^Blk= Chakma}', "");
    Expect(0, 69967, '\P{Blk= Chakma}', "");
    Expect(1, 69967, '\P{^Blk= Chakma}', "");
    Expect(0, 69968, '\p{Blk= Chakma}', "");
    Expect(1, 69968, '\p{^Blk= Chakma}', "");
    Expect(1, 69968, '\P{Blk= Chakma}', "");
    Expect(0, 69968, '\P{^Blk= Chakma}', "");
    Error('\p{Is_Block=/a/Chakma}');
    Error('\P{Is_Block=/a/Chakma}');
    Expect(1, 69967, '\p{Is_Block=chakma}', "");
    Expect(0, 69967, '\p{^Is_Block=chakma}', "");
    Expect(0, 69967, '\P{Is_Block=chakma}', "");
    Expect(1, 69967, '\P{^Is_Block=chakma}', "");
    Expect(0, 69968, '\p{Is_Block=chakma}', "");
    Expect(1, 69968, '\p{^Is_Block=chakma}', "");
    Expect(1, 69968, '\P{Is_Block=chakma}', "");
    Expect(0, 69968, '\P{^Is_Block=chakma}', "");
    Expect(1, 69967, '\p{Is_Block=-CHAKMA}', "");
    Expect(0, 69967, '\p{^Is_Block=-CHAKMA}', "");
    Expect(0, 69967, '\P{Is_Block=-CHAKMA}', "");
    Expect(1, 69967, '\P{^Is_Block=-CHAKMA}', "");
    Expect(0, 69968, '\p{Is_Block=-CHAKMA}', "");
    Expect(1, 69968, '\p{^Is_Block=-CHAKMA}', "");
    Expect(1, 69968, '\P{Is_Block=-CHAKMA}', "");
    Expect(0, 69968, '\P{^Is_Block=-CHAKMA}', "");
    Error('\p{Is_Blk=:=_Chakma}');
    Error('\P{Is_Blk=:=_Chakma}');
    Expect(1, 69967, '\p{Is_Blk=chakma}', "");
    Expect(0, 69967, '\p{^Is_Blk=chakma}', "");
    Expect(0, 69967, '\P{Is_Blk=chakma}', "");
    Expect(1, 69967, '\P{^Is_Blk=chakma}', "");
    Expect(0, 69968, '\p{Is_Blk=chakma}', "");
    Expect(1, 69968, '\p{^Is_Blk=chakma}', "");
    Expect(1, 69968, '\P{Is_Blk=chakma}', "");
    Expect(0, 69968, '\P{^Is_Blk=chakma}', "");
    Expect(1, 69967, '\p{Is_Blk=-	Chakma}', "");
    Expect(0, 69967, '\p{^Is_Blk=-	Chakma}', "");
    Expect(0, 69967, '\P{Is_Blk=-	Chakma}', "");
    Expect(1, 69967, '\P{^Is_Blk=-	Chakma}', "");
    Expect(0, 69968, '\p{Is_Blk=-	Chakma}', "");
    Expect(1, 69968, '\p{^Is_Blk=-	Chakma}', "");
    Expect(1, 69968, '\P{Is_Blk=-	Chakma}', "");
    Expect(0, 69968, '\P{^Is_Blk=-	Chakma}', "");
    Error('\p{Block=/a/_Cham}');
    Error('\P{Block=/a/_Cham}');
    Expect(1, 43615, '\p{Block=:\ACham\z:}', "");;
    Expect(0, 43616, '\p{Block=:\ACham\z:}', "");;
    Expect(1, 43615, '\p{Block=cham}', "");
    Expect(0, 43615, '\p{^Block=cham}', "");
    Expect(0, 43615, '\P{Block=cham}', "");
    Expect(1, 43615, '\P{^Block=cham}', "");
    Expect(0, 43616, '\p{Block=cham}', "");
    Expect(1, 43616, '\p{^Block=cham}', "");
    Expect(1, 43616, '\P{Block=cham}', "");
    Expect(0, 43616, '\P{^Block=cham}', "");
    Expect(1, 43615, '\p{Block=:\Acham\z:}', "");;
    Expect(0, 43616, '\p{Block=:\Acham\z:}', "");;
    Expect(1, 43615, '\p{Block=_Cham}', "");
    Expect(0, 43615, '\p{^Block=_Cham}', "");
    Expect(0, 43615, '\P{Block=_Cham}', "");
    Expect(1, 43615, '\P{^Block=_Cham}', "");
    Expect(0, 43616, '\p{Block=_Cham}', "");
    Expect(1, 43616, '\p{^Block=_Cham}', "");
    Expect(1, 43616, '\P{Block=_Cham}', "");
    Expect(0, 43616, '\P{^Block=_Cham}', "");
    Error('\p{Blk=/a/-	CHAM}');
    Error('\P{Blk=/a/-	CHAM}');
    Expect(1, 43615, '\p{Blk=:\ACham\z:}', "");;
    Expect(0, 43616, '\p{Blk=:\ACham\z:}', "");;
    Expect(1, 43615, '\p{Blk=cham}', "");
    Expect(0, 43615, '\p{^Blk=cham}', "");
    Expect(0, 43615, '\P{Blk=cham}', "");
    Expect(1, 43615, '\P{^Blk=cham}', "");
    Expect(0, 43616, '\p{Blk=cham}', "");
    Expect(1, 43616, '\p{^Blk=cham}', "");
    Expect(1, 43616, '\P{Blk=cham}', "");
    Expect(0, 43616, '\P{^Blk=cham}', "");
    Expect(1, 43615, '\p{Blk=:\Acham\z:}', "");;
    Expect(0, 43616, '\p{Blk=:\Acham\z:}', "");;
    Expect(1, 43615, '\p{Blk=_	cham}', "");
    Expect(0, 43615, '\p{^Blk=_	cham}', "");
    Expect(0, 43615, '\P{Blk=_	cham}', "");
    Expect(1, 43615, '\P{^Blk=_	cham}', "");
    Expect(0, 43616, '\p{Blk=_	cham}', "");
    Expect(1, 43616, '\p{^Blk=_	cham}', "");
    Expect(1, 43616, '\P{Blk=_	cham}', "");
    Expect(0, 43616, '\P{^Blk=_	cham}', "");
    Error('\p{Is_Block=	CHAM/a/}');
    Error('\P{Is_Block=	CHAM/a/}');
    Expect(1, 43615, '\p{Is_Block=cham}', "");
    Expect(0, 43615, '\p{^Is_Block=cham}', "");
    Expect(0, 43615, '\P{Is_Block=cham}', "");
    Expect(1, 43615, '\P{^Is_Block=cham}', "");
    Expect(0, 43616, '\p{Is_Block=cham}', "");
    Expect(1, 43616, '\p{^Is_Block=cham}', "");
    Expect(1, 43616, '\P{Is_Block=cham}', "");
    Expect(0, 43616, '\P{^Is_Block=cham}', "");
    Expect(1, 43615, '\p{Is_Block: _ Cham}', "");
    Expect(0, 43615, '\p{^Is_Block: _ Cham}', "");
    Expect(0, 43615, '\P{Is_Block: _ Cham}', "");
    Expect(1, 43615, '\P{^Is_Block: _ Cham}', "");
    Expect(0, 43616, '\p{Is_Block: _ Cham}', "");
    Expect(1, 43616, '\p{^Is_Block: _ Cham}', "");
    Expect(1, 43616, '\P{Is_Block: _ Cham}', "");
    Expect(0, 43616, '\P{^Is_Block: _ Cham}', "");
    Error('\p{Is_Blk=:=CHAM}');
    Error('\P{Is_Blk=:=CHAM}');
    Expect(1, 43615, '\p{Is_Blk=cham}', "");
    Expect(0, 43615, '\p{^Is_Blk=cham}', "");
    Expect(0, 43615, '\P{Is_Blk=cham}', "");
    Expect(1, 43615, '\P{^Is_Blk=cham}', "");
    Expect(0, 43616, '\p{Is_Blk=cham}', "");
    Expect(1, 43616, '\p{^Is_Blk=cham}', "");
    Expect(1, 43616, '\P{Is_Blk=cham}', "");
    Expect(0, 43616, '\P{^Is_Blk=cham}', "");
    Expect(1, 43615, '\p{Is_Blk: Cham}', "");
    Expect(0, 43615, '\p{^Is_Blk: Cham}', "");
    Expect(0, 43615, '\P{Is_Blk: Cham}', "");
    Expect(1, 43615, '\P{^Is_Blk: Cham}', "");
    Expect(0, 43616, '\p{Is_Blk: Cham}', "");
    Expect(1, 43616, '\p{^Is_Blk: Cham}', "");
    Expect(1, 43616, '\P{Is_Blk: Cham}', "");
    Expect(0, 43616, '\P{^Is_Blk: Cham}', "");
    Error('\p{Block=_:=CHEROKEE}');
    Error('\P{Block=_:=CHEROKEE}');
    Expect(1, 5119, '\p{Block=:\ACherokee\z:}', "");;
    Expect(0, 5120, '\p{Block=:\ACherokee\z:}', "");;
    Expect(1, 5119, '\p{Block=cherokee}', "");
    Expect(0, 5119, '\p{^Block=cherokee}', "");
    Expect(0, 5119, '\P{Block=cherokee}', "");
    Expect(1, 5119, '\P{^Block=cherokee}', "");
    Expect(0, 5120, '\p{Block=cherokee}', "");
    Expect(1, 5120, '\p{^Block=cherokee}', "");
    Expect(1, 5120, '\P{Block=cherokee}', "");
    Expect(0, 5120, '\P{^Block=cherokee}', "");
    Expect(1, 5119, '\p{Block=:\Acherokee\z:}', "");;
    Expect(0, 5120, '\p{Block=:\Acherokee\z:}', "");;
    Expect(1, 5119, '\p{Block=_Cherokee}', "");
    Expect(0, 5119, '\p{^Block=_Cherokee}', "");
    Expect(0, 5119, '\P{Block=_Cherokee}', "");
    Expect(1, 5119, '\P{^Block=_Cherokee}', "");
    Expect(0, 5120, '\p{Block=_Cherokee}', "");
    Expect(1, 5120, '\p{^Block=_Cherokee}', "");
    Expect(1, 5120, '\P{Block=_Cherokee}', "");
    Expect(0, 5120, '\P{^Block=_Cherokee}', "");
    Error('\p{Blk=	Cherokee/a/}');
    Error('\P{Blk=	Cherokee/a/}');
    Expect(1, 5119, '\p{Blk=:\ACherokee\z:}', "");;
    Expect(0, 5120, '\p{Blk=:\ACherokee\z:}', "");;
    Expect(1, 5119, '\p{Blk=cherokee}', "");
    Expect(0, 5119, '\p{^Blk=cherokee}', "");
    Expect(0, 5119, '\P{Blk=cherokee}', "");
    Expect(1, 5119, '\P{^Blk=cherokee}', "");
    Expect(0, 5120, '\p{Blk=cherokee}', "");
    Expect(1, 5120, '\p{^Blk=cherokee}', "");
    Expect(1, 5120, '\P{Blk=cherokee}', "");
    Expect(0, 5120, '\P{^Blk=cherokee}', "");
    Expect(1, 5119, '\p{Blk=:\Acherokee\z:}', "");;
    Expect(0, 5120, '\p{Blk=:\Acherokee\z:}', "");;
    Expect(1, 5119, '\p{Blk: 		Cherokee}', "");
    Expect(0, 5119, '\p{^Blk: 		Cherokee}', "");
    Expect(0, 5119, '\P{Blk: 		Cherokee}', "");
    Expect(1, 5119, '\P{^Blk: 		Cherokee}', "");
    Expect(0, 5120, '\p{Blk: 		Cherokee}', "");
    Expect(1, 5120, '\p{^Blk: 		Cherokee}', "");
    Expect(1, 5120, '\P{Blk: 		Cherokee}', "");
    Expect(0, 5120, '\P{^Blk: 		Cherokee}', "");
    Error('\p{Is_Block=/a/ -cherokee}');
    Error('\P{Is_Block=/a/ -cherokee}');
    Expect(1, 5119, '\p{Is_Block=cherokee}', "");
    Expect(0, 5119, '\p{^Is_Block=cherokee}', "");
    Expect(0, 5119, '\P{Is_Block=cherokee}', "");
    Expect(1, 5119, '\P{^Is_Block=cherokee}', "");
    Expect(0, 5120, '\p{Is_Block=cherokee}', "");
    Expect(1, 5120, '\p{^Is_Block=cherokee}', "");
    Expect(1, 5120, '\P{Is_Block=cherokee}', "");
    Expect(0, 5120, '\P{^Is_Block=cherokee}', "");
    Expect(1, 5119, '\p{Is_Block: Cherokee}', "");
    Expect(0, 5119, '\p{^Is_Block: Cherokee}', "");
    Expect(0, 5119, '\P{Is_Block: Cherokee}', "");
    Expect(1, 5119, '\P{^Is_Block: Cherokee}', "");
    Expect(0, 5120, '\p{Is_Block: Cherokee}', "");
    Expect(1, 5120, '\p{^Is_Block: Cherokee}', "");
    Expect(1, 5120, '\P{Is_Block: Cherokee}', "");
    Expect(0, 5120, '\P{^Is_Block: Cherokee}', "");
    Error('\p{Is_Blk=	:=Cherokee}');
    Error('\P{Is_Blk=	:=Cherokee}');
    Expect(1, 5119, '\p{Is_Blk:   cherokee}', "");
    Expect(0, 5119, '\p{^Is_Blk:   cherokee}', "");
    Expect(0, 5119, '\P{Is_Blk:   cherokee}', "");
    Expect(1, 5119, '\P{^Is_Blk:   cherokee}', "");
    Expect(0, 5120, '\p{Is_Blk:   cherokee}', "");
    Expect(1, 5120, '\p{^Is_Blk:   cherokee}', "");
    Expect(1, 5120, '\P{Is_Blk:   cherokee}', "");
    Expect(0, 5120, '\P{^Is_Blk:   cherokee}', "");
    Expect(1, 5119, '\p{Is_Blk=- Cherokee}', "");
    Expect(0, 5119, '\p{^Is_Blk=- Cherokee}', "");
    Expect(0, 5119, '\P{Is_Blk=- Cherokee}', "");
    Expect(1, 5119, '\P{^Is_Blk=- Cherokee}', "");
    Expect(0, 5120, '\p{Is_Blk=- Cherokee}', "");
    Expect(1, 5120, '\p{^Is_Blk=- Cherokee}', "");
    Expect(1, 5120, '\P{Is_Blk=- Cherokee}', "");
    Expect(0, 5120, '\P{^Is_Blk=- Cherokee}', "");
    Error('\p{Block:    -Cherokee_Supplement:=}');
    Error('\P{Block:    -Cherokee_Supplement:=}');
    Expect(1, 43967, '\p{Block=:\ACherokee_Supplement\z:}', "");;
    Expect(0, 43968, '\p{Block=:\ACherokee_Supplement\z:}', "");;
    Expect(1, 43967, '\p{Block=cherokeesupplement}', "");
    Expect(0, 43967, '\p{^Block=cherokeesupplement}', "");
    Expect(0, 43967, '\P{Block=cherokeesupplement}', "");
    Expect(1, 43967, '\P{^Block=cherokeesupplement}', "");
    Expect(0, 43968, '\p{Block=cherokeesupplement}', "");
    Expect(1, 43968, '\p{^Block=cherokeesupplement}', "");
    Expect(1, 43968, '\P{Block=cherokeesupplement}', "");
    Expect(0, 43968, '\P{^Block=cherokeesupplement}', "");
    Expect(1, 43967, '\p{Block=:\Acherokeesupplement\z:}', "");;
    Expect(0, 43968, '\p{Block=:\Acherokeesupplement\z:}', "");;
    Expect(1, 43967, '\p{Block=_	cherokee_SUPPLEMENT}', "");
    Expect(0, 43967, '\p{^Block=_	cherokee_SUPPLEMENT}', "");
    Expect(0, 43967, '\P{Block=_	cherokee_SUPPLEMENT}', "");
    Expect(1, 43967, '\P{^Block=_	cherokee_SUPPLEMENT}', "");
    Expect(0, 43968, '\p{Block=_	cherokee_SUPPLEMENT}', "");
    Expect(1, 43968, '\p{^Block=_	cherokee_SUPPLEMENT}', "");
    Expect(1, 43968, '\P{Block=_	cherokee_SUPPLEMENT}', "");
    Expect(0, 43968, '\P{^Block=_	cherokee_SUPPLEMENT}', "");
    Error('\p{Blk=/a/_cherokee_Sup}');
    Error('\P{Blk=/a/_cherokee_Sup}');
    Expect(1, 43967, '\p{Blk=:\ACherokee_Sup\z:}', "");;
    Expect(0, 43968, '\p{Blk=:\ACherokee_Sup\z:}', "");;
    Expect(1, 43967, '\p{Blk=cherokeesup}', "");
    Expect(0, 43967, '\p{^Blk=cherokeesup}', "");
    Expect(0, 43967, '\P{Blk=cherokeesup}', "");
    Expect(1, 43967, '\P{^Blk=cherokeesup}', "");
    Expect(0, 43968, '\p{Blk=cherokeesup}', "");
    Expect(1, 43968, '\p{^Blk=cherokeesup}', "");
    Expect(1, 43968, '\P{Blk=cherokeesup}', "");
    Expect(0, 43968, '\P{^Blk=cherokeesup}', "");
    Expect(1, 43967, '\p{Blk=:\Acherokeesup\z:}', "");;
    Expect(0, 43968, '\p{Blk=:\Acherokeesup\z:}', "");;
    Expect(1, 43967, '\p{Blk=	_cherokee_SUP}', "");
    Expect(0, 43967, '\p{^Blk=	_cherokee_SUP}', "");
    Expect(0, 43967, '\P{Blk=	_cherokee_SUP}', "");
    Expect(1, 43967, '\P{^Blk=	_cherokee_SUP}', "");
    Expect(0, 43968, '\p{Blk=	_cherokee_SUP}', "");
    Expect(1, 43968, '\p{^Blk=	_cherokee_SUP}', "");
    Expect(1, 43968, '\P{Blk=	_cherokee_SUP}', "");
    Expect(0, 43968, '\P{^Blk=	_cherokee_SUP}', "");
    Error('\p{Is_Block=:= cherokee_Supplement}');
    Error('\P{Is_Block=:= cherokee_Supplement}');
    Expect(1, 43967, '\p{Is_Block=cherokeesupplement}', "");
    Expect(0, 43967, '\p{^Is_Block=cherokeesupplement}', "");
    Expect(0, 43967, '\P{Is_Block=cherokeesupplement}', "");
    Expect(1, 43967, '\P{^Is_Block=cherokeesupplement}', "");
    Expect(0, 43968, '\p{Is_Block=cherokeesupplement}', "");
    Expect(1, 43968, '\p{^Is_Block=cherokeesupplement}', "");
    Expect(1, 43968, '\P{Is_Block=cherokeesupplement}', "");
    Expect(0, 43968, '\P{^Is_Block=cherokeesupplement}', "");
    Expect(1, 43967, '\p{Is_Block= cherokee_Supplement}', "");
    Expect(0, 43967, '\p{^Is_Block= cherokee_Supplement}', "");
    Expect(0, 43967, '\P{Is_Block= cherokee_Supplement}', "");
    Expect(1, 43967, '\P{^Is_Block= cherokee_Supplement}', "");
    Expect(0, 43968, '\p{Is_Block= cherokee_Supplement}', "");
    Expect(1, 43968, '\p{^Is_Block= cherokee_Supplement}', "");
    Expect(1, 43968, '\P{Is_Block= cherokee_Supplement}', "");
    Expect(0, 43968, '\P{^Is_Block= cherokee_Supplement}', "");
    Error('\p{Is_Blk: 		CHEROKEE_SUP/a/}');
    Error('\P{Is_Blk: 		CHEROKEE_SUP/a/}');
    Expect(1, 43967, '\p{Is_Blk=cherokeesup}', "");
    Expect(0, 43967, '\p{^Is_Blk=cherokeesup}', "");
    Expect(0, 43967, '\P{Is_Blk=cherokeesup}', "");
    Expect(1, 43967, '\P{^Is_Blk=cherokeesup}', "");
    Expect(0, 43968, '\p{Is_Blk=cherokeesup}', "");
    Expect(1, 43968, '\p{^Is_Blk=cherokeesup}', "");
    Expect(1, 43968, '\P{Is_Blk=cherokeesup}', "");
    Expect(0, 43968, '\P{^Is_Blk=cherokeesup}', "");
    Expect(1, 43967, '\p{Is_Blk=		CHEROKEE_Sup}', "");
    Expect(0, 43967, '\p{^Is_Blk=		CHEROKEE_Sup}', "");
    Expect(0, 43967, '\P{Is_Blk=		CHEROKEE_Sup}', "");
    Expect(1, 43967, '\P{^Is_Blk=		CHEROKEE_Sup}', "");
    Expect(0, 43968, '\p{Is_Blk=		CHEROKEE_Sup}', "");
    Expect(1, 43968, '\p{^Is_Blk=		CHEROKEE_Sup}', "");
    Expect(1, 43968, '\P{Is_Blk=		CHEROKEE_Sup}', "");
    Expect(0, 43968, '\P{^Is_Blk=		CHEROKEE_Sup}', "");
    Error('\p{Block=/a/-Chess_Symbols}');
    Error('\P{Block=/a/-Chess_Symbols}');
    Expect(1, 129647, '\p{Block=:\AChess_Symbols\z:}', "");;
    Expect(0, 129648, '\p{Block=:\AChess_Symbols\z:}', "");;
    Expect(1, 129647, '\p{Block=chesssymbols}', "");
    Expect(0, 129647, '\p{^Block=chesssymbols}', "");
    Expect(0, 129647, '\P{Block=chesssymbols}', "");
    Expect(1, 129647, '\P{^Block=chesssymbols}', "");
    Expect(0, 129648, '\p{Block=chesssymbols}', "");
    Expect(1, 129648, '\p{^Block=chesssymbols}', "");
    Expect(1, 129648, '\P{Block=chesssymbols}', "");
    Expect(0, 129648, '\P{^Block=chesssymbols}', "");
    Expect(1, 129647, '\p{Block=:\Achesssymbols\z:}', "");;
    Expect(0, 129648, '\p{Block=:\Achesssymbols\z:}', "");;
    Expect(1, 129647, '\p{Block=- Chess_symbols}', "");
    Expect(0, 129647, '\p{^Block=- Chess_symbols}', "");
    Expect(0, 129647, '\P{Block=- Chess_symbols}', "");
    Expect(1, 129647, '\P{^Block=- Chess_symbols}', "");
    Expect(0, 129648, '\p{Block=- Chess_symbols}', "");
    Expect(1, 129648, '\p{^Block=- Chess_symbols}', "");
    Expect(1, 129648, '\P{Block=- Chess_symbols}', "");
    Expect(0, 129648, '\P{^Block=- Chess_symbols}', "");
    Error('\p{Blk=		Chess_Symbols:=}');
    Error('\P{Blk=		Chess_Symbols:=}');
    Expect(1, 129647, '\p{Blk=:\AChess_Symbols\z:}', "");;
    Expect(0, 129648, '\p{Blk=:\AChess_Symbols\z:}', "");;
    Expect(1, 129647, '\p{Blk: chesssymbols}', "");
    Expect(0, 129647, '\p{^Blk: chesssymbols}', "");
    Expect(0, 129647, '\P{Blk: chesssymbols}', "");
    Expect(1, 129647, '\P{^Blk: chesssymbols}', "");
    Expect(0, 129648, '\p{Blk: chesssymbols}', "");
    Expect(1, 129648, '\p{^Blk: chesssymbols}', "");
    Expect(1, 129648, '\P{Blk: chesssymbols}', "");
    Expect(0, 129648, '\P{^Blk: chesssymbols}', "");
    Expect(1, 129647, '\p{Blk=:\Achesssymbols\z:}', "");;
    Expect(0, 129648, '\p{Blk=:\Achesssymbols\z:}', "");;
    Expect(1, 129647, '\p{Blk=-	CHESS_Symbols}', "");
    Expect(0, 129647, '\p{^Blk=-	CHESS_Symbols}', "");
    Expect(0, 129647, '\P{Blk=-	CHESS_Symbols}', "");
    Expect(1, 129647, '\P{^Blk=-	CHESS_Symbols}', "");
    Expect(0, 129648, '\p{Blk=-	CHESS_Symbols}', "");
    Expect(1, 129648, '\p{^Blk=-	CHESS_Symbols}', "");
    Expect(1, 129648, '\P{Blk=-	CHESS_Symbols}', "");
    Expect(0, 129648, '\P{^Blk=-	CHESS_Symbols}', "");
    Error('\p{Is_Block=:= -Chess_symbols}');
    Error('\P{Is_Block=:= -Chess_symbols}');
    Expect(1, 129647, '\p{Is_Block:	chesssymbols}', "");
    Expect(0, 129647, '\p{^Is_Block:	chesssymbols}', "");
    Expect(0, 129647, '\P{Is_Block:	chesssymbols}', "");
    Expect(1, 129647, '\P{^Is_Block:	chesssymbols}', "");
    Expect(0, 129648, '\p{Is_Block:	chesssymbols}', "");
    Expect(1, 129648, '\p{^Is_Block:	chesssymbols}', "");
    Expect(1, 129648, '\P{Is_Block:	chesssymbols}', "");
    Expect(0, 129648, '\P{^Is_Block:	chesssymbols}', "");
    Expect(1, 129647, '\p{Is_Block=_ Chess_SYMBOLS}', "");
    Expect(0, 129647, '\p{^Is_Block=_ Chess_SYMBOLS}', "");
    Expect(0, 129647, '\P{Is_Block=_ Chess_SYMBOLS}', "");
    Expect(1, 129647, '\P{^Is_Block=_ Chess_SYMBOLS}', "");
    Expect(0, 129648, '\p{Is_Block=_ Chess_SYMBOLS}', "");
    Expect(1, 129648, '\p{^Is_Block=_ Chess_SYMBOLS}', "");
    Expect(1, 129648, '\P{Is_Block=_ Chess_SYMBOLS}', "");
    Expect(0, 129648, '\P{^Is_Block=_ Chess_SYMBOLS}', "");
    Error('\p{Is_Blk:   	 chess_SYMBOLS:=}');
    Error('\P{Is_Blk:   	 chess_SYMBOLS:=}');
    Expect(1, 129647, '\p{Is_Blk=chesssymbols}', "");
    Expect(0, 129647, '\p{^Is_Blk=chesssymbols}', "");
    Expect(0, 129647, '\P{Is_Blk=chesssymbols}', "");
    Expect(1, 129647, '\P{^Is_Blk=chesssymbols}', "");
    Expect(0, 129648, '\p{Is_Blk=chesssymbols}', "");
    Expect(1, 129648, '\p{^Is_Blk=chesssymbols}', "");
    Expect(1, 129648, '\P{Is_Blk=chesssymbols}', "");
    Expect(0, 129648, '\P{^Is_Blk=chesssymbols}', "");
    Expect(1, 129647, '\p{Is_Blk=-CHESS_Symbols}', "");
    Expect(0, 129647, '\p{^Is_Blk=-CHESS_Symbols}', "");
    Expect(0, 129647, '\P{Is_Blk=-CHESS_Symbols}', "");
    Expect(1, 129647, '\P{^Is_Blk=-CHESS_Symbols}', "");
    Expect(0, 129648, '\p{Is_Blk=-CHESS_Symbols}', "");
    Expect(1, 129648, '\p{^Is_Blk=-CHESS_Symbols}', "");
    Expect(1, 129648, '\P{Is_Blk=-CHESS_Symbols}', "");
    Expect(0, 129648, '\P{^Is_Blk=-CHESS_Symbols}', "");
    Error('\p{Block=:=- CHORASMIAN}');
    Error('\P{Block=:=- CHORASMIAN}');
    Expect(1, 69599, '\p{Block=:\AChorasmian\z:}', "");;
    Expect(0, 69600, '\p{Block=:\AChorasmian\z:}', "");;
    Expect(1, 69599, '\p{Block=chorasmian}', "");
    Expect(0, 69599, '\p{^Block=chorasmian}', "");
    Expect(0, 69599, '\P{Block=chorasmian}', "");
    Expect(1, 69599, '\P{^Block=chorasmian}', "");
    Expect(0, 69600, '\p{Block=chorasmian}', "");
    Expect(1, 69600, '\p{^Block=chorasmian}', "");
    Expect(1, 69600, '\P{Block=chorasmian}', "");
    Expect(0, 69600, '\P{^Block=chorasmian}', "");
    Expect(1, 69599, '\p{Block=:\Achorasmian\z:}', "");;
    Expect(0, 69600, '\p{Block=:\Achorasmian\z:}', "");;
    Expect(1, 69599, '\p{Block=-_CHORASMIAN}', "");
    Expect(0, 69599, '\p{^Block=-_CHORASMIAN}', "");
    Expect(0, 69599, '\P{Block=-_CHORASMIAN}', "");
    Expect(1, 69599, '\P{^Block=-_CHORASMIAN}', "");
    Expect(0, 69600, '\p{Block=-_CHORASMIAN}', "");
    Expect(1, 69600, '\p{^Block=-_CHORASMIAN}', "");
    Expect(1, 69600, '\P{Block=-_CHORASMIAN}', "");
    Expect(0, 69600, '\P{^Block=-_CHORASMIAN}', "");
    Error('\p{Blk= :=CHORASMIAN}');
    Error('\P{Blk= :=CHORASMIAN}');
    Expect(1, 69599, '\p{Blk=:\AChorasmian\z:}', "");;
    Expect(0, 69600, '\p{Blk=:\AChorasmian\z:}', "");;
    Expect(1, 69599, '\p{Blk=chorasmian}', "");
    Expect(0, 69599, '\p{^Blk=chorasmian}', "");
    Expect(0, 69599, '\P{Blk=chorasmian}', "");
    Expect(1, 69599, '\P{^Blk=chorasmian}', "");
    Expect(0, 69600, '\p{Blk=chorasmian}', "");
    Expect(1, 69600, '\p{^Blk=chorasmian}', "");
    Expect(1, 69600, '\P{Blk=chorasmian}', "");
    Expect(0, 69600, '\P{^Blk=chorasmian}', "");
    Expect(1, 69599, '\p{Blk=:\Achorasmian\z:}', "");;
    Expect(0, 69600, '\p{Blk=:\Achorasmian\z:}', "");;
    Expect(1, 69599, '\p{Blk=-_CHORASMIAN}', "");
    Expect(0, 69599, '\p{^Blk=-_CHORASMIAN}', "");
    Expect(0, 69599, '\P{Blk=-_CHORASMIAN}', "");
    Expect(1, 69599, '\P{^Blk=-_CHORASMIAN}', "");
    Expect(0, 69600, '\p{Blk=-_CHORASMIAN}', "");
    Expect(1, 69600, '\p{^Blk=-_CHORASMIAN}', "");
    Expect(1, 69600, '\P{Blk=-_CHORASMIAN}', "");
    Expect(0, 69600, '\P{^Blk=-_CHORASMIAN}', "");
    Error('\p{Is_Block: /a/chorasmian}');
    Error('\P{Is_Block: /a/chorasmian}');
    Expect(1, 69599, '\p{Is_Block=chorasmian}', "");
    Expect(0, 69599, '\p{^Is_Block=chorasmian}', "");
    Expect(0, 69599, '\P{Is_Block=chorasmian}', "");
    Expect(1, 69599, '\P{^Is_Block=chorasmian}', "");
    Expect(0, 69600, '\p{Is_Block=chorasmian}', "");
    Expect(1, 69600, '\p{^Is_Block=chorasmian}', "");
    Expect(1, 69600, '\P{Is_Block=chorasmian}', "");
    Expect(0, 69600, '\P{^Is_Block=chorasmian}', "");
    Expect(1, 69599, '\p{Is_Block=_ Chorasmian}', "");
    Expect(0, 69599, '\p{^Is_Block=_ Chorasmian}', "");
    Expect(0, 69599, '\P{Is_Block=_ Chorasmian}', "");
    Expect(1, 69599, '\P{^Is_Block=_ Chorasmian}', "");
    Expect(0, 69600, '\p{Is_Block=_ Chorasmian}', "");
    Expect(1, 69600, '\p{^Is_Block=_ Chorasmian}', "");
    Expect(1, 69600, '\P{Is_Block=_ Chorasmian}', "");
    Expect(0, 69600, '\P{^Is_Block=_ Chorasmian}', "");
    Error('\p{Is_Blk=/a/ -Chorasmian}');
    Error('\P{Is_Blk=/a/ -Chorasmian}');
    Expect(1, 69599, '\p{Is_Blk:	chorasmian}', "");
    Expect(0, 69599, '\p{^Is_Blk:	chorasmian}', "");
    Expect(0, 69599, '\P{Is_Blk:	chorasmian}', "");
    Expect(1, 69599, '\P{^Is_Blk:	chorasmian}', "");
    Expect(0, 69600, '\p{Is_Blk:	chorasmian}', "");
    Expect(1, 69600, '\p{^Is_Blk:	chorasmian}', "");
    Expect(1, 69600, '\P{Is_Blk:	chorasmian}', "");
    Expect(0, 69600, '\P{^Is_Blk:	chorasmian}', "");
    Expect(1, 69599, '\p{Is_Blk= _chorasmian}', "");
    Expect(0, 69599, '\p{^Is_Blk= _chorasmian}', "");
    Expect(0, 69599, '\P{Is_Blk= _chorasmian}', "");
    Expect(1, 69599, '\P{^Is_Blk= _chorasmian}', "");
    Expect(0, 69600, '\p{Is_Blk= _chorasmian}', "");
    Expect(1, 69600, '\p{^Is_Blk= _chorasmian}', "");
    Expect(1, 69600, '\P{Is_Blk= _chorasmian}', "");
    Expect(0, 69600, '\P{^Is_Blk= _chorasmian}', "");
    Error('\p{Block=_/a/CJK_Unified_ideographs}');
    Error('\P{Block=_/a/CJK_Unified_ideographs}');
    Expect(1, 40959, '\p{Block=:\ACJK_Unified_Ideographs\z:}', "");;
    Expect(0, 40960, '\p{Block=:\ACJK_Unified_Ideographs\z:}', "");;
    Expect(1, 40959, '\p{Block=cjkunifiedideographs}', "");
    Expect(0, 40959, '\p{^Block=cjkunifiedideographs}', "");
    Expect(0, 40959, '\P{Block=cjkunifiedideographs}', "");
    Expect(1, 40959, '\P{^Block=cjkunifiedideographs}', "");
    Expect(0, 40960, '\p{Block=cjkunifiedideographs}', "");
    Expect(1, 40960, '\p{^Block=cjkunifiedideographs}', "");
    Expect(1, 40960, '\P{Block=cjkunifiedideographs}', "");
    Expect(0, 40960, '\P{^Block=cjkunifiedideographs}', "");
    Expect(1, 40959, '\p{Block=:\Acjkunifiedideographs\z:}', "");;
    Expect(0, 40960, '\p{Block=:\Acjkunifiedideographs\z:}', "");;
    Expect(1, 40959, '\p{Block=_	cjk_UNIFIED_Ideographs}', "");
    Expect(0, 40959, '\p{^Block=_	cjk_UNIFIED_Ideographs}', "");
    Expect(0, 40959, '\P{Block=_	cjk_UNIFIED_Ideographs}', "");
    Expect(1, 40959, '\P{^Block=_	cjk_UNIFIED_Ideographs}', "");
    Expect(0, 40960, '\p{Block=_	cjk_UNIFIED_Ideographs}', "");
    Expect(1, 40960, '\p{^Block=_	cjk_UNIFIED_Ideographs}', "");
    Expect(1, 40960, '\P{Block=_	cjk_UNIFIED_Ideographs}', "");
    Expect(0, 40960, '\P{^Block=_	cjk_UNIFIED_Ideographs}', "");
    Error('\p{Blk=:= -CJK}');
    Error('\P{Blk=:= -CJK}');
    Expect(1, 40959, '\p{Blk=:\ACJK\z:}', "");;
    Expect(0, 40960, '\p{Blk=:\ACJK\z:}', "");;
    Expect(1, 40959, '\p{Blk=cjk}', "");
    Expect(0, 40959, '\p{^Blk=cjk}', "");
    Expect(0, 40959, '\P{Blk=cjk}', "");
    Expect(1, 40959, '\P{^Blk=cjk}', "");
    Expect(0, 40960, '\p{Blk=cjk}', "");
    Expect(1, 40960, '\p{^Blk=cjk}', "");
    Expect(1, 40960, '\P{Blk=cjk}', "");
    Expect(0, 40960, '\P{^Blk=cjk}', "");
    Expect(1, 40959, '\p{Blk=:\Acjk\z:}', "");;
    Expect(0, 40960, '\p{Blk=:\Acjk\z:}', "");;
    Expect(1, 40959, '\p{Blk=_ CJK}', "");
    Expect(0, 40959, '\p{^Blk=_ CJK}', "");
    Expect(0, 40959, '\P{Blk=_ CJK}', "");
    Expect(1, 40959, '\P{^Blk=_ CJK}', "");
    Expect(0, 40960, '\p{Blk=_ CJK}', "");
    Expect(1, 40960, '\p{^Blk=_ CJK}', "");
    Expect(1, 40960, '\P{Blk=_ CJK}', "");
    Expect(0, 40960, '\P{^Blk=_ CJK}', "");
    Error('\p{Is_Block=	/a/CJK_UNIFIED_ideographs}');
    Error('\P{Is_Block=	/a/CJK_UNIFIED_ideographs}');
    Expect(1, 40959, '\p{Is_Block:cjkunifiedideographs}', "");
    Expect(0, 40959, '\p{^Is_Block:cjkunifiedideographs}', "");
    Expect(0, 40959, '\P{Is_Block:cjkunifiedideographs}', "");
    Expect(1, 40959, '\P{^Is_Block:cjkunifiedideographs}', "");
    Expect(0, 40960, '\p{Is_Block:cjkunifiedideographs}', "");
    Expect(1, 40960, '\p{^Is_Block:cjkunifiedideographs}', "");
    Expect(1, 40960, '\P{Is_Block:cjkunifiedideographs}', "");
    Expect(0, 40960, '\P{^Is_Block:cjkunifiedideographs}', "");
    Expect(1, 40959, '\p{Is_Block=_ cjk_Unified_Ideographs}', "");
    Expect(0, 40959, '\p{^Is_Block=_ cjk_Unified_Ideographs}', "");
    Expect(0, 40959, '\P{Is_Block=_ cjk_Unified_Ideographs}', "");
    Expect(1, 40959, '\P{^Is_Block=_ cjk_Unified_Ideographs}', "");
    Expect(0, 40960, '\p{Is_Block=_ cjk_Unified_Ideographs}', "");
    Expect(1, 40960, '\p{^Is_Block=_ cjk_Unified_Ideographs}', "");
    Expect(1, 40960, '\P{Is_Block=_ cjk_Unified_Ideographs}', "");
    Expect(0, 40960, '\P{^Is_Block=_ cjk_Unified_Ideographs}', "");
    Error('\p{Is_Blk=_	CJK:=}');
    Error('\P{Is_Blk=_	CJK:=}');
    Expect(1, 40959, '\p{Is_Blk: cjk}', "");
    Expect(0, 40959, '\p{^Is_Blk: cjk}', "");
    Expect(0, 40959, '\P{Is_Blk: cjk}', "");
    Expect(1, 40959, '\P{^Is_Blk: cjk}', "");
    Expect(0, 40960, '\p{Is_Blk: cjk}', "");
    Expect(1, 40960, '\p{^Is_Blk: cjk}', "");
    Expect(1, 40960, '\P{Is_Blk: cjk}', "");
    Expect(0, 40960, '\P{^Is_Blk: cjk}', "");
    Expect(1, 40959, '\p{Is_Blk:   	_CJK}', "");
    Expect(0, 40959, '\p{^Is_Blk:   	_CJK}', "");
    Expect(0, 40959, '\P{Is_Blk:   	_CJK}', "");
    Expect(1, 40959, '\P{^Is_Blk:   	_CJK}', "");
    Expect(0, 40960, '\p{Is_Blk:   	_CJK}', "");
    Expect(1, 40960, '\p{^Is_Blk:   	_CJK}', "");
    Expect(1, 40960, '\P{Is_Blk:   	_CJK}', "");
    Expect(0, 40960, '\P{^Is_Blk:   	_CJK}', "");
    Error('\p{Block=/a/cjk_COMPATIBILITY}');
    Error('\P{Block=/a/cjk_COMPATIBILITY}');
    Expect(1, 13311, '\p{Block=:\ACJK_Compatibility\z:}', "");;
    Expect(0, 13312, '\p{Block=:\ACJK_Compatibility\z:}', "");;
    Expect(1, 13311, '\p{Block=cjkcompatibility}', "");
    Expect(0, 13311, '\p{^Block=cjkcompatibility}', "");
    Expect(0, 13311, '\P{Block=cjkcompatibility}', "");
    Expect(1, 13311, '\P{^Block=cjkcompatibility}', "");
    Expect(0, 13312, '\p{Block=cjkcompatibility}', "");
    Expect(1, 13312, '\p{^Block=cjkcompatibility}', "");
    Expect(1, 13312, '\P{Block=cjkcompatibility}', "");
    Expect(0, 13312, '\P{^Block=cjkcompatibility}', "");
    Expect(1, 13311, '\p{Block=:\Acjkcompatibility\z:}', "");;
    Expect(0, 13312, '\p{Block=:\Acjkcompatibility\z:}', "");;
    Expect(1, 13311, '\p{Block=	CJK_Compatibility}', "");
    Expect(0, 13311, '\p{^Block=	CJK_Compatibility}', "");
    Expect(0, 13311, '\P{Block=	CJK_Compatibility}', "");
    Expect(1, 13311, '\P{^Block=	CJK_Compatibility}', "");
    Expect(0, 13312, '\p{Block=	CJK_Compatibility}', "");
    Expect(1, 13312, '\p{^Block=	CJK_Compatibility}', "");
    Expect(1, 13312, '\P{Block=	CJK_Compatibility}', "");
    Expect(0, 13312, '\P{^Block=	CJK_Compatibility}', "");
    Error('\p{Blk=:=cjk_COMPAT}');
    Error('\P{Blk=:=cjk_COMPAT}');
    Expect(1, 13311, '\p{Blk=:\ACJK_Compat\z:}', "");;
    Expect(0, 13312, '\p{Blk=:\ACJK_Compat\z:}', "");;
    Expect(1, 13311, '\p{Blk=cjkcompat}', "");
    Expect(0, 13311, '\p{^Blk=cjkcompat}', "");
    Expect(0, 13311, '\P{Blk=cjkcompat}', "");
    Expect(1, 13311, '\P{^Blk=cjkcompat}', "");
    Expect(0, 13312, '\p{Blk=cjkcompat}', "");
    Expect(1, 13312, '\p{^Blk=cjkcompat}', "");
    Expect(1, 13312, '\P{Blk=cjkcompat}', "");
    Expect(0, 13312, '\P{^Blk=cjkcompat}', "");
    Expect(1, 13311, '\p{Blk=:\Acjkcompat\z:}', "");;
    Expect(0, 13312, '\p{Blk=:\Acjkcompat\z:}', "");;
    Expect(1, 13311, '\p{Blk=-	CJK_compat}', "");
    Expect(0, 13311, '\p{^Blk=-	CJK_compat}', "");
    Expect(0, 13311, '\P{Blk=-	CJK_compat}', "");
    Expect(1, 13311, '\P{^Blk=-	CJK_compat}', "");
    Expect(0, 13312, '\p{Blk=-	CJK_compat}', "");
    Expect(1, 13312, '\p{^Blk=-	CJK_compat}', "");
    Expect(1, 13312, '\P{Blk=-	CJK_compat}', "");
    Expect(0, 13312, '\P{^Blk=-	CJK_compat}', "");
    Error('\p{Is_Block:	:=_-CJK_compatibility}');
    Error('\P{Is_Block:	:=_-CJK_compatibility}');
    Expect(1, 13311, '\p{Is_Block=cjkcompatibility}', "");
    Expect(0, 13311, '\p{^Is_Block=cjkcompatibility}', "");
    Expect(0, 13311, '\P{Is_Block=cjkcompatibility}', "");
    Expect(1, 13311, '\P{^Is_Block=cjkcompatibility}', "");
    Expect(0, 13312, '\p{Is_Block=cjkcompatibility}', "");
    Expect(1, 13312, '\p{^Is_Block=cjkcompatibility}', "");
    Expect(1, 13312, '\P{Is_Block=cjkcompatibility}', "");
    Expect(0, 13312, '\P{^Is_Block=cjkcompatibility}', "");
    Expect(1, 13311, '\p{Is_Block= cjk_COMPATIBILITY}', "");
    Expect(0, 13311, '\p{^Is_Block= cjk_COMPATIBILITY}', "");
    Expect(0, 13311, '\P{Is_Block= cjk_COMPATIBILITY}', "");
    Expect(1, 13311, '\P{^Is_Block= cjk_COMPATIBILITY}', "");
    Expect(0, 13312, '\p{Is_Block= cjk_COMPATIBILITY}', "");
    Expect(1, 13312, '\p{^Is_Block= cjk_COMPATIBILITY}', "");
    Expect(1, 13312, '\P{Is_Block= cjk_COMPATIBILITY}', "");
    Expect(0, 13312, '\P{^Is_Block= cjk_COMPATIBILITY}', "");
    Error('\p{Is_Blk=	 CJK_compat:=}');
    Error('\P{Is_Blk=	 CJK_compat:=}');
    Expect(1, 13311, '\p{Is_Blk: cjkcompat}', "");
    Expect(0, 13311, '\p{^Is_Blk: cjkcompat}', "");
    Expect(0, 13311, '\P{Is_Blk: cjkcompat}', "");
    Expect(1, 13311, '\P{^Is_Blk: cjkcompat}', "");
    Expect(0, 13312, '\p{Is_Blk: cjkcompat}', "");
    Expect(1, 13312, '\p{^Is_Blk: cjkcompat}', "");
    Expect(1, 13312, '\P{Is_Blk: cjkcompat}', "");
    Expect(0, 13312, '\P{^Is_Blk: cjkcompat}', "");
    Expect(1, 13311, '\p{Is_Blk=		CJK_COMPAT}', "");
    Expect(0, 13311, '\p{^Is_Blk=		CJK_COMPAT}', "");
    Expect(0, 13311, '\P{Is_Blk=		CJK_COMPAT}', "");
    Expect(1, 13311, '\P{^Is_Blk=		CJK_COMPAT}', "");
    Expect(0, 13312, '\p{Is_Blk=		CJK_COMPAT}', "");
    Expect(1, 13312, '\p{^Is_Blk=		CJK_COMPAT}', "");
    Expect(1, 13312, '\P{Is_Blk=		CJK_COMPAT}', "");
    Expect(0, 13312, '\P{^Is_Blk=		CJK_COMPAT}', "");
    Error('\p{Block=-/a/cjk_COMPATIBILITY_FORMS}');
    Error('\P{Block=-/a/cjk_COMPATIBILITY_FORMS}');
    Expect(1, 65103, '\p{Block=:\ACJK_Compatibility_Forms\z:}', "");;
    Expect(0, 65104, '\p{Block=:\ACJK_Compatibility_Forms\z:}', "");;
    Expect(1, 65103, '\p{Block=cjkcompatibilityforms}', "");
    Expect(0, 65103, '\p{^Block=cjkcompatibilityforms}', "");
    Expect(0, 65103, '\P{Block=cjkcompatibilityforms}', "");
    Expect(1, 65103, '\P{^Block=cjkcompatibilityforms}', "");
    Expect(0, 65104, '\p{Block=cjkcompatibilityforms}', "");
    Expect(1, 65104, '\p{^Block=cjkcompatibilityforms}', "");
    Expect(1, 65104, '\P{Block=cjkcompatibilityforms}', "");
    Expect(0, 65104, '\P{^Block=cjkcompatibilityforms}', "");
    Expect(1, 65103, '\p{Block=:\Acjkcompatibilityforms\z:}', "");;
    Expect(0, 65104, '\p{Block=:\Acjkcompatibilityforms\z:}', "");;
    Expect(1, 65103, '\p{Block=	-CJK_Compatibility_Forms}', "");
    Expect(0, 65103, '\p{^Block=	-CJK_Compatibility_Forms}', "");
    Expect(0, 65103, '\P{Block=	-CJK_Compatibility_Forms}', "");
    Expect(1, 65103, '\P{^Block=	-CJK_Compatibility_Forms}', "");
    Expect(0, 65104, '\p{Block=	-CJK_Compatibility_Forms}', "");
    Expect(1, 65104, '\p{^Block=	-CJK_Compatibility_Forms}', "");
    Expect(1, 65104, '\P{Block=	-CJK_Compatibility_Forms}', "");
    Expect(0, 65104, '\P{^Block=	-CJK_Compatibility_Forms}', "");
    Error('\p{Blk=--cjk_compat_FORMS:=}');
    Error('\P{Blk=--cjk_compat_FORMS:=}');
    Expect(1, 65103, '\p{Blk=:\ACJK_Compat_Forms\z:}', "");;
    Expect(0, 65104, '\p{Blk=:\ACJK_Compat_Forms\z:}', "");;
    Expect(1, 65103, '\p{Blk=cjkcompatforms}', "");
    Expect(0, 65103, '\p{^Blk=cjkcompatforms}', "");
    Expect(0, 65103, '\P{Blk=cjkcompatforms}', "");
    Expect(1, 65103, '\P{^Blk=cjkcompatforms}', "");
    Expect(0, 65104, '\p{Blk=cjkcompatforms}', "");
    Expect(1, 65104, '\p{^Blk=cjkcompatforms}', "");
    Expect(1, 65104, '\P{Blk=cjkcompatforms}', "");
    Expect(0, 65104, '\P{^Blk=cjkcompatforms}', "");
    Expect(1, 65103, '\p{Blk=:\Acjkcompatforms\z:}', "");;
    Expect(0, 65104, '\p{Blk=:\Acjkcompatforms\z:}', "");;
    Expect(1, 65103, '\p{Blk= _CJK_compat_Forms}', "");
    Expect(0, 65103, '\p{^Blk= _CJK_compat_Forms}', "");
    Expect(0, 65103, '\P{Blk= _CJK_compat_Forms}', "");
    Expect(1, 65103, '\P{^Blk= _CJK_compat_Forms}', "");
    Expect(0, 65104, '\p{Blk= _CJK_compat_Forms}', "");
    Expect(1, 65104, '\p{^Blk= _CJK_compat_Forms}', "");
    Expect(1, 65104, '\P{Blk= _CJK_compat_Forms}', "");
    Expect(0, 65104, '\P{^Blk= _CJK_compat_Forms}', "");
    Error('\p{Is_Block=/a/cjk_Compatibility_Forms}');
    Error('\P{Is_Block=/a/cjk_Compatibility_Forms}');
    Expect(1, 65103, '\p{Is_Block=cjkcompatibilityforms}', "");
    Expect(0, 65103, '\p{^Is_Block=cjkcompatibilityforms}', "");
    Expect(0, 65103, '\P{Is_Block=cjkcompatibilityforms}', "");
    Expect(1, 65103, '\P{^Is_Block=cjkcompatibilityforms}', "");
    Expect(0, 65104, '\p{Is_Block=cjkcompatibilityforms}', "");
    Expect(1, 65104, '\p{^Is_Block=cjkcompatibilityforms}', "");
    Expect(1, 65104, '\P{Is_Block=cjkcompatibilityforms}', "");
    Expect(0, 65104, '\P{^Is_Block=cjkcompatibilityforms}', "");
    Expect(1, 65103, '\p{Is_Block=		CJK_compatibility_forms}', "");
    Expect(0, 65103, '\p{^Is_Block=		CJK_compatibility_forms}', "");
    Expect(0, 65103, '\P{Is_Block=		CJK_compatibility_forms}', "");
    Expect(1, 65103, '\P{^Is_Block=		CJK_compatibility_forms}', "");
    Expect(0, 65104, '\p{Is_Block=		CJK_compatibility_forms}', "");
    Expect(1, 65104, '\p{^Is_Block=		CJK_compatibility_forms}', "");
    Expect(1, 65104, '\P{Is_Block=		CJK_compatibility_forms}', "");
    Expect(0, 65104, '\P{^Is_Block=		CJK_compatibility_forms}', "");
    Error('\p{Is_Blk=	/a/CJK_Compat_Forms}');
    Error('\P{Is_Blk=	/a/CJK_Compat_Forms}');
    Expect(1, 65103, '\p{Is_Blk=cjkcompatforms}', "");
    Expect(0, 65103, '\p{^Is_Blk=cjkcompatforms}', "");
    Expect(0, 65103, '\P{Is_Blk=cjkcompatforms}', "");
    Expect(1, 65103, '\P{^Is_Blk=cjkcompatforms}', "");
    Expect(0, 65104, '\p{Is_Blk=cjkcompatforms}', "");
    Expect(1, 65104, '\p{^Is_Blk=cjkcompatforms}', "");
    Expect(1, 65104, '\P{Is_Blk=cjkcompatforms}', "");
    Expect(0, 65104, '\P{^Is_Blk=cjkcompatforms}', "");
    Expect(1, 65103, '\p{Is_Blk=	-CJK_Compat_FORMS}', "");
    Expect(0, 65103, '\p{^Is_Blk=	-CJK_Compat_FORMS}', "");
    Expect(0, 65103, '\P{Is_Blk=	-CJK_Compat_FORMS}', "");
    Expect(1, 65103, '\P{^Is_Blk=	-CJK_Compat_FORMS}', "");
    Expect(0, 65104, '\p{Is_Blk=	-CJK_Compat_FORMS}', "");
    Expect(1, 65104, '\p{^Is_Blk=	-CJK_Compat_FORMS}', "");
    Expect(1, 65104, '\P{Is_Blk=	-CJK_Compat_FORMS}', "");
    Expect(0, 65104, '\P{^Is_Blk=	-CJK_Compat_FORMS}', "");
    Error('\p{Block=	-CJK_Compatibility_IDEOGRAPHS:=}');
    Error('\P{Block=	-CJK_Compatibility_IDEOGRAPHS:=}');
    Expect(1, 64255, '\p{Block=:\ACJK_Compatibility_Ideographs\z:}', "");;
    Expect(0, 64256, '\p{Block=:\ACJK_Compatibility_Ideographs\z:}', "");;
    Expect(1, 64255, '\p{Block=cjkcompatibilityideographs}', "");
    Expect(0, 64255, '\p{^Block=cjkcompatibilityideographs}', "");
    Expect(0, 64255, '\P{Block=cjkcompatibilityideographs}', "");
    Expect(1, 64255, '\P{^Block=cjkcompatibilityideographs}', "");
    Expect(0, 64256, '\p{Block=cjkcompatibilityideographs}', "");
    Expect(1, 64256, '\p{^Block=cjkcompatibilityideographs}', "");
    Expect(1, 64256, '\P{Block=cjkcompatibilityideographs}', "");
    Expect(0, 64256, '\P{^Block=cjkcompatibilityideographs}', "");
    Expect(1, 64255, '\p{Block=:\Acjkcompatibilityideographs\z:}', "");;
    Expect(0, 64256, '\p{Block=:\Acjkcompatibilityideographs\z:}', "");;
    Expect(1, 64255, '\p{Block=_	CJK_Compatibility_Ideographs}', "");
    Expect(0, 64255, '\p{^Block=_	CJK_Compatibility_Ideographs}', "");
    Expect(0, 64255, '\P{Block=_	CJK_Compatibility_Ideographs}', "");
    Expect(1, 64255, '\P{^Block=_	CJK_Compatibility_Ideographs}', "");
    Expect(0, 64256, '\p{Block=_	CJK_Compatibility_Ideographs}', "");
    Expect(1, 64256, '\p{^Block=_	CJK_Compatibility_Ideographs}', "");
    Expect(1, 64256, '\P{Block=_	CJK_Compatibility_Ideographs}', "");
    Expect(0, 64256, '\P{^Block=_	CJK_Compatibility_Ideographs}', "");
    Error('\p{Blk=:=	 CJK_COMPAT_IDEOGRAPHS}');
    Error('\P{Blk=:=	 CJK_COMPAT_IDEOGRAPHS}');
    Expect(1, 64255, '\p{Blk=:\ACJK_Compat_Ideographs\z:}', "");;
    Expect(0, 64256, '\p{Blk=:\ACJK_Compat_Ideographs\z:}', "");;
    Expect(1, 64255, '\p{Blk=cjkcompatideographs}', "");
    Expect(0, 64255, '\p{^Blk=cjkcompatideographs}', "");
    Expect(0, 64255, '\P{Blk=cjkcompatideographs}', "");
    Expect(1, 64255, '\P{^Blk=cjkcompatideographs}', "");
    Expect(0, 64256, '\p{Blk=cjkcompatideographs}', "");
    Expect(1, 64256, '\p{^Blk=cjkcompatideographs}', "");
    Expect(1, 64256, '\P{Blk=cjkcompatideographs}', "");
    Expect(0, 64256, '\P{^Blk=cjkcompatideographs}', "");
    Expect(1, 64255, '\p{Blk=:\Acjkcompatideographs\z:}', "");;
    Expect(0, 64256, '\p{Blk=:\Acjkcompatideographs\z:}', "");;
    Expect(1, 64255, '\p{Blk=		CJK_Compat_Ideographs}', "");
    Expect(0, 64255, '\p{^Blk=		CJK_Compat_Ideographs}', "");
    Expect(0, 64255, '\P{Blk=		CJK_Compat_Ideographs}', "");
    Expect(1, 64255, '\P{^Blk=		CJK_Compat_Ideographs}', "");
    Expect(0, 64256, '\p{Blk=		CJK_Compat_Ideographs}', "");
    Expect(1, 64256, '\p{^Blk=		CJK_Compat_Ideographs}', "");
    Expect(1, 64256, '\P{Blk=		CJK_Compat_Ideographs}', "");
    Expect(0, 64256, '\P{^Blk=		CJK_Compat_Ideographs}', "");
    Error('\p{Is_Block=	cjk_Compatibility_Ideographs/a/}');
    Error('\P{Is_Block=	cjk_Compatibility_Ideographs/a/}');
    Expect(1, 64255, '\p{Is_Block=cjkcompatibilityideographs}', "");
    Expect(0, 64255, '\p{^Is_Block=cjkcompatibilityideographs}', "");
    Expect(0, 64255, '\P{Is_Block=cjkcompatibilityideographs}', "");
    Expect(1, 64255, '\P{^Is_Block=cjkcompatibilityideographs}', "");
    Expect(0, 64256, '\p{Is_Block=cjkcompatibilityideographs}', "");
    Expect(1, 64256, '\p{^Is_Block=cjkcompatibilityideographs}', "");
    Expect(1, 64256, '\P{Is_Block=cjkcompatibilityideographs}', "");
    Expect(0, 64256, '\P{^Is_Block=cjkcompatibilityideographs}', "");
    Expect(1, 64255, '\p{Is_Block=		CJK_COMPATIBILITY_IDEOGRAPHS}', "");
    Expect(0, 64255, '\p{^Is_Block=		CJK_COMPATIBILITY_IDEOGRAPHS}', "");
    Expect(0, 64255, '\P{Is_Block=		CJK_COMPATIBILITY_IDEOGRAPHS}', "");
    Expect(1, 64255, '\P{^Is_Block=		CJK_COMPATIBILITY_IDEOGRAPHS}', "");
    Expect(0, 64256, '\p{Is_Block=		CJK_COMPATIBILITY_IDEOGRAPHS}', "");
    Expect(1, 64256, '\p{^Is_Block=		CJK_COMPATIBILITY_IDEOGRAPHS}', "");
    Expect(1, 64256, '\P{Is_Block=		CJK_COMPATIBILITY_IDEOGRAPHS}', "");
    Expect(0, 64256, '\P{^Is_Block=		CJK_COMPATIBILITY_IDEOGRAPHS}', "");
    Error('\p{Is_Blk=:=_-CJK_Compat_IDEOGRAPHS}');
    Error('\P{Is_Blk=:=_-CJK_Compat_IDEOGRAPHS}');
    Expect(1, 64255, '\p{Is_Blk=cjkcompatideographs}', "");
    Expect(0, 64255, '\p{^Is_Blk=cjkcompatideographs}', "");
    Expect(0, 64255, '\P{Is_Blk=cjkcompatideographs}', "");
    Expect(1, 64255, '\P{^Is_Blk=cjkcompatideographs}', "");
    Expect(0, 64256, '\p{Is_Blk=cjkcompatideographs}', "");
    Expect(1, 64256, '\p{^Is_Blk=cjkcompatideographs}', "");
    Expect(1, 64256, '\P{Is_Blk=cjkcompatideographs}', "");
    Expect(0, 64256, '\P{^Is_Blk=cjkcompatideographs}', "");
    Expect(1, 64255, '\p{Is_Blk:_cjk_compat_Ideographs}', "");
    Expect(0, 64255, '\p{^Is_Blk:_cjk_compat_Ideographs}', "");
    Expect(0, 64255, '\P{Is_Blk:_cjk_compat_Ideographs}', "");
    Expect(1, 64255, '\P{^Is_Blk:_cjk_compat_Ideographs}', "");
    Expect(0, 64256, '\p{Is_Blk:_cjk_compat_Ideographs}', "");
    Expect(1, 64256, '\p{^Is_Blk:_cjk_compat_Ideographs}', "");
    Expect(1, 64256, '\P{Is_Blk:_cjk_compat_Ideographs}', "");
    Expect(0, 64256, '\P{^Is_Blk:_cjk_compat_Ideographs}', "");
    Error('\p{Block:   - CJK_COMPATIBILITY_IDEOGRAPHS_supplement/a/}');
    Error('\P{Block:   - CJK_COMPATIBILITY_IDEOGRAPHS_supplement/a/}');
    Expect(1, 195103, '\p{Block=:\ACJK_Compatibility_Ideographs_Supplement\z:}', "");;
    Expect(0, 195104, '\p{Block=:\ACJK_Compatibility_Ideographs_Supplement\z:}', "");;
    Expect(1, 195103, '\p{Block: cjkcompatibilityideographssupplement}', "");
    Expect(0, 195103, '\p{^Block: cjkcompatibilityideographssupplement}', "");
    Expect(0, 195103, '\P{Block: cjkcompatibilityideographssupplement}', "");
    Expect(1, 195103, '\P{^Block: cjkcompatibilityideographssupplement}', "");
    Expect(0, 195104, '\p{Block: cjkcompatibilityideographssupplement}', "");
    Expect(1, 195104, '\p{^Block: cjkcompatibilityideographssupplement}', "");
    Expect(1, 195104, '\P{Block: cjkcompatibilityideographssupplement}', "");
    Expect(0, 195104, '\P{^Block: cjkcompatibilityideographssupplement}', "");
    Expect(1, 195103, '\p{Block=:\Acjkcompatibilityideographssupplement\z:}', "");;
    Expect(0, 195104, '\p{Block=:\Acjkcompatibilityideographssupplement\z:}', "");;
    Expect(1, 195103, '\p{Block=	CJK_compatibility_IDEOGRAPHS_supplement}', "");
    Expect(0, 195103, '\p{^Block=	CJK_compatibility_IDEOGRAPHS_supplement}', "");
    Expect(0, 195103, '\P{Block=	CJK_compatibility_IDEOGRAPHS_supplement}', "");
    Expect(1, 195103, '\P{^Block=	CJK_compatibility_IDEOGRAPHS_supplement}', "");
    Expect(0, 195104, '\p{Block=	CJK_compatibility_IDEOGRAPHS_supplement}', "");
    Expect(1, 195104, '\p{^Block=	CJK_compatibility_IDEOGRAPHS_supplement}', "");
    Expect(1, 195104, '\P{Block=	CJK_compatibility_IDEOGRAPHS_supplement}', "");
    Expect(0, 195104, '\P{^Block=	CJK_compatibility_IDEOGRAPHS_supplement}', "");
    Error('\p{Blk=_	cjk_compat_IDEOGRAPHS_sup/a/}');
    Error('\P{Blk=_	cjk_compat_IDEOGRAPHS_sup/a/}');
    Expect(1, 195103, '\p{Blk=:\ACJK_Compat_Ideographs_Sup\z:}', "");;
    Expect(0, 195104, '\p{Blk=:\ACJK_Compat_Ideographs_Sup\z:}', "");;
    Expect(1, 195103, '\p{Blk=cjkcompatideographssup}', "");
    Expect(0, 195103, '\p{^Blk=cjkcompatideographssup}', "");
    Expect(0, 195103, '\P{Blk=cjkcompatideographssup}', "");
    Expect(1, 195103, '\P{^Blk=cjkcompatideographssup}', "");
    Expect(0, 195104, '\p{Blk=cjkcompatideographssup}', "");
    Expect(1, 195104, '\p{^Blk=cjkcompatideographssup}', "");
    Expect(1, 195104, '\P{Blk=cjkcompatideographssup}', "");
    Expect(0, 195104, '\P{^Blk=cjkcompatideographssup}', "");
    Expect(1, 195103, '\p{Blk=:\Acjkcompatideographssup\z:}', "");;
    Expect(0, 195104, '\p{Blk=:\Acjkcompatideographssup\z:}', "");;
    Expect(1, 195103, '\p{Blk=  CJK_compat_ideographs_sup}', "");
    Expect(0, 195103, '\p{^Blk=  CJK_compat_ideographs_sup}', "");
    Expect(0, 195103, '\P{Blk=  CJK_compat_ideographs_sup}', "");
    Expect(1, 195103, '\P{^Blk=  CJK_compat_ideographs_sup}', "");
    Expect(0, 195104, '\p{Blk=  CJK_compat_ideographs_sup}', "");
    Expect(1, 195104, '\p{^Blk=  CJK_compat_ideographs_sup}', "");
    Expect(1, 195104, '\P{Blk=  CJK_compat_ideographs_sup}', "");
    Expect(0, 195104, '\P{^Blk=  CJK_compat_ideographs_sup}', "");
    Error('\p{Is_Block=-/a/CJK_compatibility_ideographs_SUPPLEMENT}');
    Error('\P{Is_Block=-/a/CJK_compatibility_ideographs_SUPPLEMENT}');
    Expect(1, 195103, '\p{Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195103, '\p{^Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195103, '\P{Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195103, '\P{^Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195104, '\p{Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195104, '\p{^Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195104, '\P{Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(0, 195104, '\P{^Is_Block=cjkcompatibilityideographssupplement}', "");
    Expect(1, 195103, '\p{Is_Block=CJK_Compatibility_Ideographs_Supplement}', "");
    Expect(0, 195103, '\p{^Is_Block=CJK_Compatibility_Ideographs_Supplement}', "");
    Expect(0, 195103, '\P{Is_Block=CJK_Compatibility_Ideographs_Supplement}', "");
    Expect(1, 195103, '\P{^Is_Block=CJK_Compatibility_Ideographs_Supplement}', "");
    Expect(0, 195104, '\p{Is_Block=CJK_Compatibility_Ideographs_Supplement}', "");
    Expect(1, 195104, '\p{^Is_Block=CJK_Compatibility_Ideographs_Supplement}', "");
    Expect(1, 195104, '\P{Is_Block=CJK_Compatibility_Ideographs_Supplement}', "");
    Expect(0, 195104, '\P{^Is_Block=CJK_Compatibility_Ideographs_Supplement}', "");
    Error('\p{Is_Blk= -cjk_Compat_IDEOGRAPHS_Sup/a/}');
    Error('\P{Is_Blk= -cjk_Compat_IDEOGRAPHS_Sup/a/}');
    Expect(1, 195103, '\p{Is_Blk=cjkcompatideographssup}', "");
    Expect(0, 195103, '\p{^Is_Blk=cjkcompatideographssup}', "");
    Expect(0, 195103, '\P{Is_Blk=cjkcompatideographssup}', "");
    Expect(1, 195103, '\P{^Is_Blk=cjkcompatideographssup}', "");
    Expect(0, 195104, '\p{Is_Blk=cjkcompatideographssup}', "");
    Expect(1, 195104, '\p{^Is_Blk=cjkcompatideographssup}', "");
    Expect(1, 195104, '\P{Is_Blk=cjkcompatideographssup}', "");
    Expect(0, 195104, '\P{^Is_Blk=cjkcompatideographssup}', "");
    Expect(1, 195103, '\p{Is_Blk=- CJK_COMPAT_Ideographs_SUP}', "");
    Expect(0, 195103, '\p{^Is_Blk=- CJK_COMPAT_Ideographs_SUP}', "");
    Expect(0, 195103, '\P{Is_Blk=- CJK_COMPAT_Ideographs_SUP}', "");
    Expect(1, 195103, '\P{^Is_Blk=- CJK_COMPAT_Ideographs_SUP}', "");
    Expect(0, 195104, '\p{Is_Blk=- CJK_COMPAT_Ideographs_SUP}', "");
    Expect(1, 195104, '\p{^Is_Blk=- CJK_COMPAT_Ideographs_SUP}', "");
    Expect(1, 195104, '\P{Is_Blk=- CJK_COMPAT_Ideographs_SUP}', "");
    Expect(0, 195104, '\P{^Is_Blk=- CJK_COMPAT_Ideographs_SUP}', "");
    Error('\p{Block=/a/	_CJK_UNIFIED_ideographs_extension_A}');
    Error('\P{Block=/a/	_CJK_UNIFIED_ideographs_extension_A}');
    Expect(1, 19903, '\p{Block=:\ACJK_Unified_Ideographs_Extension_A\z:}', "");;
    Expect(0, 19904, '\p{Block=:\ACJK_Unified_Ideographs_Extension_A\z:}', "");;
    Expect(1, 19903, '\p{Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19903, '\p{^Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19903, '\P{Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19903, '\P{^Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19904, '\p{Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19904, '\p{^Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19904, '\P{Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19904, '\P{^Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19903, '\p{Block=:\Acjkunifiedideographsextensiona\z:}', "");;
    Expect(0, 19904, '\p{Block=:\Acjkunifiedideographsextensiona\z:}', "");;
    Expect(1, 19903, '\p{Block=- CJK_UNIFIED_Ideographs_extension_a}', "");
    Expect(0, 19903, '\p{^Block=- CJK_UNIFIED_Ideographs_extension_a}', "");
    Expect(0, 19903, '\P{Block=- CJK_UNIFIED_Ideographs_extension_a}', "");
    Expect(1, 19903, '\P{^Block=- CJK_UNIFIED_Ideographs_extension_a}', "");
    Expect(0, 19904, '\p{Block=- CJK_UNIFIED_Ideographs_extension_a}', "");
    Expect(1, 19904, '\p{^Block=- CJK_UNIFIED_Ideographs_extension_a}', "");
    Expect(1, 19904, '\P{Block=- CJK_UNIFIED_Ideographs_extension_a}', "");
    Expect(0, 19904, '\P{^Block=- CJK_UNIFIED_Ideographs_extension_a}', "");
    Error('\p{Blk=/a/_CJK_EXT_A}');
    Error('\P{Blk=/a/_CJK_EXT_A}');
    Expect(1, 19903, '\p{Blk=:\ACJK_Ext_A\z:}', "");;
    Expect(0, 19904, '\p{Blk=:\ACJK_Ext_A\z:}', "");;
    Expect(1, 19903, '\p{Blk:   cjkexta}', "");
    Expect(0, 19903, '\p{^Blk:   cjkexta}', "");
    Expect(0, 19903, '\P{Blk:   cjkexta}', "");
    Expect(1, 19903, '\P{^Blk:   cjkexta}', "");
    Expect(0, 19904, '\p{Blk:   cjkexta}', "");
    Expect(1, 19904, '\p{^Blk:   cjkexta}', "");
    Expect(1, 19904, '\P{Blk:   cjkexta}', "");
    Expect(0, 19904, '\P{^Blk:   cjkexta}', "");
    Expect(1, 19903, '\p{Blk=:\Acjkexta\z:}', "");;
    Expect(0, 19904, '\p{Blk=:\Acjkexta\z:}', "");;
    Expect(1, 19903, '\p{Blk=- cjk_EXT_a}', "");
    Expect(0, 19903, '\p{^Blk=- cjk_EXT_a}', "");
    Expect(0, 19903, '\P{Blk=- cjk_EXT_a}', "");
    Expect(1, 19903, '\P{^Blk=- cjk_EXT_a}', "");
    Expect(0, 19904, '\p{Blk=- cjk_EXT_a}', "");
    Expect(1, 19904, '\p{^Blk=- cjk_EXT_a}', "");
    Expect(1, 19904, '\P{Blk=- cjk_EXT_a}', "");
    Expect(0, 19904, '\P{^Blk=- cjk_EXT_a}', "");
    Error('\p{Is_Block=__CJK_UNIFIED_Ideographs_EXTENSION_A/a/}');
    Error('\P{Is_Block=__CJK_UNIFIED_Ideographs_EXTENSION_A/a/}');
    Expect(1, 19903, '\p{Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19903, '\p{^Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19903, '\P{Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19903, '\P{^Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19904, '\p{Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19904, '\p{^Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19904, '\P{Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(0, 19904, '\P{^Is_Block=cjkunifiedideographsextensiona}', "");
    Expect(1, 19903, '\p{Is_Block=-CJK_unified_Ideographs_EXTENSION_a}', "");
    Expect(0, 19903, '\p{^Is_Block=-CJK_unified_Ideographs_EXTENSION_a}', "");
    Expect(0, 19903, '\P{Is_Block=-CJK_unified_Ideographs_EXTENSION_a}', "");
    Expect(1, 19903, '\P{^Is_Block=-CJK_unified_Ideographs_EXTENSION_a}', "");
    Expect(0, 19904, '\p{Is_Block=-CJK_unified_Ideographs_EXTENSION_a}', "");
    Expect(1, 19904, '\p{^Is_Block=-CJK_unified_Ideographs_EXTENSION_a}', "");
    Expect(1, 19904, '\P{Is_Block=-CJK_unified_Ideographs_EXTENSION_a}', "");
    Expect(0, 19904, '\P{^Is_Block=-CJK_unified_Ideographs_EXTENSION_a}', "");
    Error('\p{Is_Blk=-/a/CJK_ext_a}');
    Error('\P{Is_Blk=-/a/CJK_ext_a}');
    Expect(1, 19903, '\p{Is_Blk=cjkexta}', "");
    Expect(0, 19903, '\p{^Is_Blk=cjkexta}', "");
    Expect(0, 19903, '\P{Is_Blk=cjkexta}', "");
    Expect(1, 19903, '\P{^Is_Blk=cjkexta}', "");
    Expect(0, 19904, '\p{Is_Blk=cjkexta}', "");
    Expect(1, 19904, '\p{^Is_Blk=cjkexta}', "");
    Expect(1, 19904, '\P{Is_Blk=cjkexta}', "");
    Expect(0, 19904, '\P{^Is_Blk=cjkexta}', "");
    Expect(1, 19903, '\p{Is_Blk=	 cjk_ext_a}', "");
    Expect(0, 19903, '\p{^Is_Blk=	 cjk_ext_a}', "");
    Expect(0, 19903, '\P{Is_Blk=	 cjk_ext_a}', "");
    Expect(1, 19903, '\P{^Is_Blk=	 cjk_ext_a}', "");
    Expect(0, 19904, '\p{Is_Blk=	 cjk_ext_a}', "");
    Expect(1, 19904, '\p{^Is_Blk=	 cjk_ext_a}', "");
    Expect(1, 19904, '\P{Is_Blk=	 cjk_ext_a}', "");
    Expect(0, 19904, '\P{^Is_Blk=	 cjk_ext_a}', "");
    Error('\p{Block=:=	_cjk_Unified_IDEOGRAPHS_EXTENSION_B}');
    Error('\P{Block=:=	_cjk_Unified_IDEOGRAPHS_EXTENSION_B}');
    Expect(1, 173791, '\p{Block=:\ACJK_Unified_Ideographs_Extension_B\z:}', "");;
    Expect(0, 173792, '\p{Block=:\ACJK_Unified_Ideographs_Extension_B\z:}', "");;
    Expect(1, 173791, '\p{Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173791, '\p{^Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173791, '\P{Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173791, '\P{^Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173792, '\p{Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173792, '\p{^Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173792, '\P{Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173792, '\P{^Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173791, '\p{Block=:\Acjkunifiedideographsextensionb\z:}', "");;
    Expect(0, 173792, '\p{Block=:\Acjkunifiedideographsextensionb\z:}', "");;
    Expect(1, 173791, '\p{Block=-_CJK_Unified_Ideographs_Extension_B}', "");
    Expect(0, 173791, '\p{^Block=-_CJK_Unified_Ideographs_Extension_B}', "");
    Expect(0, 173791, '\P{Block=-_CJK_Unified_Ideographs_Extension_B}', "");
    Expect(1, 173791, '\P{^Block=-_CJK_Unified_Ideographs_Extension_B}', "");
    Expect(0, 173792, '\p{Block=-_CJK_Unified_Ideographs_Extension_B}', "");
    Expect(1, 173792, '\p{^Block=-_CJK_Unified_Ideographs_Extension_B}', "");
    Expect(1, 173792, '\P{Block=-_CJK_Unified_Ideographs_Extension_B}', "");
    Expect(0, 173792, '\P{^Block=-_CJK_Unified_Ideographs_Extension_B}', "");
    Error('\p{Blk=	-CJK_EXT_b/a/}');
    Error('\P{Blk=	-CJK_EXT_b/a/}');
    Expect(1, 173791, '\p{Blk=:\ACJK_Ext_B\z:}', "");;
    Expect(0, 173792, '\p{Blk=:\ACJK_Ext_B\z:}', "");;
    Expect(1, 173791, '\p{Blk=cjkextb}', "");
    Expect(0, 173791, '\p{^Blk=cjkextb}', "");
    Expect(0, 173791, '\P{Blk=cjkextb}', "");
    Expect(1, 173791, '\P{^Blk=cjkextb}', "");
    Expect(0, 173792, '\p{Blk=cjkextb}', "");
    Expect(1, 173792, '\p{^Blk=cjkextb}', "");
    Expect(1, 173792, '\P{Blk=cjkextb}', "");
    Expect(0, 173792, '\P{^Blk=cjkextb}', "");
    Expect(1, 173791, '\p{Blk=:\Acjkextb\z:}', "");;
    Expect(0, 173792, '\p{Blk=:\Acjkextb\z:}', "");;
    Expect(1, 173791, '\p{Blk: _	CJK_Ext_B}', "");
    Expect(0, 173791, '\p{^Blk: _	CJK_Ext_B}', "");
    Expect(0, 173791, '\P{Blk: _	CJK_Ext_B}', "");
    Expect(1, 173791, '\P{^Blk: _	CJK_Ext_B}', "");
    Expect(0, 173792, '\p{Blk: _	CJK_Ext_B}', "");
    Expect(1, 173792, '\p{^Blk: _	CJK_Ext_B}', "");
    Expect(1, 173792, '\P{Blk: _	CJK_Ext_B}', "");
    Expect(0, 173792, '\P{^Blk: _	CJK_Ext_B}', "");
    Error('\p{Is_Block=/a/- CJK_unified_Ideographs_EXTENSION_B}');
    Error('\P{Is_Block=/a/- CJK_unified_Ideographs_EXTENSION_B}');
    Expect(1, 173791, '\p{Is_Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173791, '\p{^Is_Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173791, '\P{Is_Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173791, '\P{^Is_Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173792, '\p{Is_Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173792, '\p{^Is_Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173792, '\P{Is_Block=cjkunifiedideographsextensionb}', "");
    Expect(0, 173792, '\P{^Is_Block=cjkunifiedideographsextensionb}', "");
    Expect(1, 173791, '\p{Is_Block=_ CJK_Unified_Ideographs_Extension_B}', "");
    Expect(0, 173791, '\p{^Is_Block=_ CJK_Unified_Ideographs_Extension_B}', "");
    Expect(0, 173791, '\P{Is_Block=_ CJK_Unified_Ideographs_Extension_B}', "");
    Expect(1, 173791, '\P{^Is_Block=_ CJK_Unified_Ideographs_Extension_B}', "");
    Expect(0, 173792, '\p{Is_Block=_ CJK_Unified_Ideographs_Extension_B}', "");
    Expect(1, 173792, '\p{^Is_Block=_ CJK_Unified_Ideographs_Extension_B}', "");
    Expect(1, 173792, '\P{Is_Block=_ CJK_Unified_Ideographs_Extension_B}', "");
    Expect(0, 173792, '\P{^Is_Block=_ CJK_Unified_Ideographs_Extension_B}', "");
    Error('\p{Is_Blk=	CJK_EXT_B:=}');
    Error('\P{Is_Blk=	CJK_EXT_B:=}');
    Expect(1, 173791, '\p{Is_Blk=cjkextb}', "");
    Expect(0, 173791, '\p{^Is_Blk=cjkextb}', "");
    Expect(0, 173791, '\P{Is_Blk=cjkextb}', "");
    Expect(1, 173791, '\P{^Is_Blk=cjkextb}', "");
    Expect(0, 173792, '\p{Is_Blk=cjkextb}', "");
    Expect(1, 173792, '\p{^Is_Blk=cjkextb}', "");
    Expect(1, 173792, '\P{Is_Blk=cjkextb}', "");
    Expect(0, 173792, '\P{^Is_Blk=cjkextb}', "");
    Expect(1, 173791, '\p{Is_Blk=	_CJK_EXT_B}', "");
    Expect(0, 173791, '\p{^Is_Blk=	_CJK_EXT_B}', "");
    Expect(0, 173791, '\P{Is_Blk=	_CJK_EXT_B}', "");
    Expect(1, 173791, '\P{^Is_Blk=	_CJK_EXT_B}', "");
    Expect(0, 173792, '\p{Is_Blk=	_CJK_EXT_B}', "");
    Expect(1, 173792, '\p{^Is_Blk=	_CJK_EXT_B}', "");
    Expect(1, 173792, '\P{Is_Blk=	_CJK_EXT_B}', "");
    Expect(0, 173792, '\P{^Is_Blk=	_CJK_EXT_B}', "");
    Error('\p{Block=	/a/CJK_UNIFIED_Ideographs_extension_C}');
    Error('\P{Block=	/a/CJK_UNIFIED_Ideographs_extension_C}');
    Expect(1, 177983, '\p{Block=:\ACJK_Unified_Ideographs_Extension_C\z:}', "");;
    Expect(0, 177984, '\p{Block=:\ACJK_Unified_Ideographs_Extension_C\z:}', "");;
    Expect(1, 177983, '\p{Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177983, '\p{^Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177983, '\P{Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177983, '\P{^Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177984, '\p{Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177984, '\p{^Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177984, '\P{Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177984, '\P{^Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177983, '\p{Block=:\Acjkunifiedideographsextensionc\z:}', "");;
    Expect(0, 177984, '\p{Block=:\Acjkunifiedideographsextensionc\z:}', "");;
    Expect(1, 177983, '\p{Block=CJK_unified_IDEOGRAPHS_Extension_C}', "");
    Expect(0, 177983, '\p{^Block=CJK_unified_IDEOGRAPHS_Extension_C}', "");
    Expect(0, 177983, '\P{Block=CJK_unified_IDEOGRAPHS_Extension_C}', "");
    Expect(1, 177983, '\P{^Block=CJK_unified_IDEOGRAPHS_Extension_C}', "");
    Expect(0, 177984, '\p{Block=CJK_unified_IDEOGRAPHS_Extension_C}', "");
    Expect(1, 177984, '\p{^Block=CJK_unified_IDEOGRAPHS_Extension_C}', "");
    Expect(1, 177984, '\P{Block=CJK_unified_IDEOGRAPHS_Extension_C}', "");
    Expect(0, 177984, '\P{^Block=CJK_unified_IDEOGRAPHS_Extension_C}', "");
    Error('\p{Blk=CJK_EXT_C:=}');
    Error('\P{Blk=CJK_EXT_C:=}');
    Expect(1, 177983, '\p{Blk=:\ACJK_Ext_C\z:}', "");;
    Expect(0, 177984, '\p{Blk=:\ACJK_Ext_C\z:}', "");;
    Expect(1, 177983, '\p{Blk=cjkextc}', "");
    Expect(0, 177983, '\p{^Blk=cjkextc}', "");
    Expect(0, 177983, '\P{Blk=cjkextc}', "");
    Expect(1, 177983, '\P{^Blk=cjkextc}', "");
    Expect(0, 177984, '\p{Blk=cjkextc}', "");
    Expect(1, 177984, '\p{^Blk=cjkextc}', "");
    Expect(1, 177984, '\P{Blk=cjkextc}', "");
    Expect(0, 177984, '\P{^Blk=cjkextc}', "");
    Expect(1, 177983, '\p{Blk=:\Acjkextc\z:}', "");;
    Expect(0, 177984, '\p{Blk=:\Acjkextc\z:}', "");;
    Expect(1, 177983, '\p{Blk=-CJK_EXT_c}', "");
    Expect(0, 177983, '\p{^Blk=-CJK_EXT_c}', "");
    Expect(0, 177983, '\P{Blk=-CJK_EXT_c}', "");
    Expect(1, 177983, '\P{^Blk=-CJK_EXT_c}', "");
    Expect(0, 177984, '\p{Blk=-CJK_EXT_c}', "");
    Expect(1, 177984, '\p{^Blk=-CJK_EXT_c}', "");
    Expect(1, 177984, '\P{Blk=-CJK_EXT_c}', "");
    Expect(0, 177984, '\P{^Blk=-CJK_EXT_c}', "");
    Error('\p{Is_Block=:= 	cjk_Unified_IDEOGRAPHS_extension_C}');
    Error('\P{Is_Block=:= 	cjk_Unified_IDEOGRAPHS_extension_C}');
    Expect(1, 177983, '\p{Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177983, '\p{^Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177983, '\P{Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177983, '\P{^Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177984, '\p{Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177984, '\p{^Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177984, '\P{Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(0, 177984, '\P{^Is_Block=cjkunifiedideographsextensionc}', "");
    Expect(1, 177983, '\p{Is_Block=	CJK_UNIFIED_IDEOGRAPHS_Extension_c}', "");
    Expect(0, 177983, '\p{^Is_Block=	CJK_UNIFIED_IDEOGRAPHS_Extension_c}', "");
    Expect(0, 177983, '\P{Is_Block=	CJK_UNIFIED_IDEOGRAPHS_Extension_c}', "");
    Expect(1, 177983, '\P{^Is_Block=	CJK_UNIFIED_IDEOGRAPHS_Extension_c}', "");
    Expect(0, 177984, '\p{Is_Block=	CJK_UNIFIED_IDEOGRAPHS_Extension_c}', "");
    Expect(1, 177984, '\p{^Is_Block=	CJK_UNIFIED_IDEOGRAPHS_Extension_c}', "");
    Expect(1, 177984, '\P{Is_Block=	CJK_UNIFIED_IDEOGRAPHS_Extension_c}', "");
    Expect(0, 177984, '\P{^Is_Block=	CJK_UNIFIED_IDEOGRAPHS_Extension_c}', "");
    Error('\p{Is_Blk=/a/	 CJK_EXT_C}');
    Error('\P{Is_Blk=/a/	 CJK_EXT_C}');
    Expect(1, 177983, '\p{Is_Blk=cjkextc}', "");
    Expect(0, 177983, '\p{^Is_Blk=cjkextc}', "");
    Expect(0, 177983, '\P{Is_Blk=cjkextc}', "");
    Expect(1, 177983, '\P{^Is_Blk=cjkextc}', "");
    Expect(0, 177984, '\p{Is_Blk=cjkextc}', "");
    Expect(1, 177984, '\p{^Is_Blk=cjkextc}', "");
    Expect(1, 177984, '\P{Is_Blk=cjkextc}', "");
    Expect(0, 177984, '\P{^Is_Blk=cjkextc}', "");
    Expect(1, 177983, '\p{Is_Blk=		cjk_Ext_C}', "");
    Expect(0, 177983, '\p{^Is_Blk=		cjk_Ext_C}', "");
    Expect(0, 177983, '\P{Is_Blk=		cjk_Ext_C}', "");
    Expect(1, 177983, '\P{^Is_Blk=		cjk_Ext_C}', "");
    Expect(0, 177984, '\p{Is_Blk=		cjk_Ext_C}', "");
    Expect(1, 177984, '\p{^Is_Blk=		cjk_Ext_C}', "");
    Expect(1, 177984, '\P{Is_Blk=		cjk_Ext_C}', "");
    Expect(0, 177984, '\P{^Is_Blk=		cjk_Ext_C}', "");
    Error('\p{Block=:=  CJK_Unified_IDEOGRAPHS_Extension_D}');
    Error('\P{Block=:=  CJK_Unified_IDEOGRAPHS_Extension_D}');
    Expect(1, 178207, '\p{Block=:\ACJK_Unified_Ideographs_Extension_D\z:}', "");;
    Expect(0, 178208, '\p{Block=:\ACJK_Unified_Ideographs_Extension_D\z:}', "");;
    Expect(1, 178207, '\p{Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178207, '\p{^Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178207, '\P{Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178207, '\P{^Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178208, '\p{Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178208, '\p{^Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178208, '\P{Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178208, '\P{^Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178207, '\p{Block=:\Acjkunifiedideographsextensiond\z:}', "");;
    Expect(0, 178208, '\p{Block=:\Acjkunifiedideographsextensiond\z:}', "");;
    Expect(1, 178207, '\p{Block=-_CJK_UNIFIED_ideographs_extension_D}', "");
    Expect(0, 178207, '\p{^Block=-_CJK_UNIFIED_ideographs_extension_D}', "");
    Expect(0, 178207, '\P{Block=-_CJK_UNIFIED_ideographs_extension_D}', "");
    Expect(1, 178207, '\P{^Block=-_CJK_UNIFIED_ideographs_extension_D}', "");
    Expect(0, 178208, '\p{Block=-_CJK_UNIFIED_ideographs_extension_D}', "");
    Expect(1, 178208, '\p{^Block=-_CJK_UNIFIED_ideographs_extension_D}', "");
    Expect(1, 178208, '\P{Block=-_CJK_UNIFIED_ideographs_extension_D}', "");
    Expect(0, 178208, '\P{^Block=-_CJK_UNIFIED_ideographs_extension_D}', "");
    Error('\p{Blk=:=	CJK_ext_D}');
    Error('\P{Blk=:=	CJK_ext_D}');
    Expect(1, 178207, '\p{Blk=:\ACJK_Ext_D\z:}', "");;
    Expect(0, 178208, '\p{Blk=:\ACJK_Ext_D\z:}', "");;
    Expect(1, 178207, '\p{Blk=cjkextd}', "");
    Expect(0, 178207, '\p{^Blk=cjkextd}', "");
    Expect(0, 178207, '\P{Blk=cjkextd}', "");
    Expect(1, 178207, '\P{^Blk=cjkextd}', "");
    Expect(0, 178208, '\p{Blk=cjkextd}', "");
    Expect(1, 178208, '\p{^Blk=cjkextd}', "");
    Expect(1, 178208, '\P{Blk=cjkextd}', "");
    Expect(0, 178208, '\P{^Blk=cjkextd}', "");
    Expect(1, 178207, '\p{Blk=:\Acjkextd\z:}', "");;
    Expect(0, 178208, '\p{Blk=:\Acjkextd\z:}', "");;
    Expect(1, 178207, '\p{Blk=	CJK_ext_D}', "");
    Expect(0, 178207, '\p{^Blk=	CJK_ext_D}', "");
    Expect(0, 178207, '\P{Blk=	CJK_ext_D}', "");
    Expect(1, 178207, '\P{^Blk=	CJK_ext_D}', "");
    Expect(0, 178208, '\p{Blk=	CJK_ext_D}', "");
    Expect(1, 178208, '\p{^Blk=	CJK_ext_D}', "");
    Expect(1, 178208, '\P{Blk=	CJK_ext_D}', "");
    Expect(0, 178208, '\P{^Blk=	CJK_ext_D}', "");
    Error('\p{Is_Block=--CJK_UNIFIED_Ideographs_Extension_D/a/}');
    Error('\P{Is_Block=--CJK_UNIFIED_Ideographs_Extension_D/a/}');
    Expect(1, 178207, '\p{Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178207, '\p{^Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178207, '\P{Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178207, '\P{^Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178208, '\p{Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178208, '\p{^Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178208, '\P{Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(0, 178208, '\P{^Is_Block=cjkunifiedideographsextensiond}', "");
    Expect(1, 178207, '\p{Is_Block=_CJK_unified_IDEOGRAPHS_extension_d}', "");
    Expect(0, 178207, '\p{^Is_Block=_CJK_unified_IDEOGRAPHS_extension_d}', "");
    Expect(0, 178207, '\P{Is_Block=_CJK_unified_IDEOGRAPHS_extension_d}', "");
    Expect(1, 178207, '\P{^Is_Block=_CJK_unified_IDEOGRAPHS_extension_d}', "");
    Expect(0, 178208, '\p{Is_Block=_CJK_unified_IDEOGRAPHS_extension_d}', "");
    Expect(1, 178208, '\p{^Is_Block=_CJK_unified_IDEOGRAPHS_extension_d}', "");
    Expect(1, 178208, '\P{Is_Block=_CJK_unified_IDEOGRAPHS_extension_d}', "");
    Expect(0, 178208, '\P{^Is_Block=_CJK_unified_IDEOGRAPHS_extension_d}', "");
    Error('\p{Is_Blk=	:=cjk_EXT_D}');
    Error('\P{Is_Blk=	:=cjk_EXT_D}');
    Expect(1, 178207, '\p{Is_Blk=cjkextd}', "");
    Expect(0, 178207, '\p{^Is_Blk=cjkextd}', "");
    Expect(0, 178207, '\P{Is_Blk=cjkextd}', "");
    Expect(1, 178207, '\P{^Is_Blk=cjkextd}', "");
    Expect(0, 178208, '\p{Is_Blk=cjkextd}', "");
    Expect(1, 178208, '\p{^Is_Blk=cjkextd}', "");
    Expect(1, 178208, '\P{Is_Blk=cjkextd}', "");
    Expect(0, 178208, '\P{^Is_Blk=cjkextd}', "");
    Expect(1, 178207, '\p{Is_Blk= -CJK_ext_D}', "");
    Expect(0, 178207, '\p{^Is_Blk= -CJK_ext_D}', "");
    Expect(0, 178207, '\P{Is_Blk= -CJK_ext_D}', "");
    Expect(1, 178207, '\P{^Is_Blk= -CJK_ext_D}', "");
    Expect(0, 178208, '\p{Is_Blk= -CJK_ext_D}', "");
    Expect(1, 178208, '\p{^Is_Blk= -CJK_ext_D}', "");
    Expect(1, 178208, '\P{Is_Blk= -CJK_ext_D}', "");
    Expect(0, 178208, '\P{^Is_Blk= -CJK_ext_D}', "");
    Error('\p{Block=	 CJK_Unified_ideographs_Extension_E/a/}');
    Error('\P{Block=	 CJK_Unified_ideographs_Extension_E/a/}');
    Expect(1, 183983, '\p{Block=:\ACJK_Unified_Ideographs_Extension_E\z:}', "");;
    Expect(0, 183984, '\p{Block=:\ACJK_Unified_Ideographs_Extension_E\z:}', "");;
    Expect(1, 183983, '\p{Block:cjkunifiedideographsextensione}', "");
    Expect(0, 183983, '\p{^Block:cjkunifiedideographsextensione}', "");
    Expect(0, 183983, '\P{Block:cjkunifiedideographsextensione}', "");
    Expect(1, 183983, '\P{^Block:cjkunifiedideographsextensione}', "");
    Expect(0, 183984, '\p{Block:cjkunifiedideographsextensione}', "");
    Expect(1, 183984, '\p{^Block:cjkunifiedideographsextensione}', "");
    Expect(1, 183984, '\P{Block:cjkunifiedideographsextensione}', "");
    Expect(0, 183984, '\P{^Block:cjkunifiedideographsextensione}', "");
    Expect(1, 183983, '\p{Block=:\Acjkunifiedideographsextensione\z:}', "");;
    Expect(0, 183984, '\p{Block=:\Acjkunifiedideographsextensione\z:}', "");;
    Expect(1, 183983, '\p{Block= 	cjk_Unified_ideographs_EXTENSION_E}', "");
    Expect(0, 183983, '\p{^Block= 	cjk_Unified_ideographs_EXTENSION_E}', "");
    Expect(0, 183983, '\P{Block= 	cjk_Unified_ideographs_EXTENSION_E}', "");
    Expect(1, 183983, '\P{^Block= 	cjk_Unified_ideographs_EXTENSION_E}', "");
    Expect(0, 183984, '\p{Block= 	cjk_Unified_ideographs_EXTENSION_E}', "");
    Expect(1, 183984, '\p{^Block= 	cjk_Unified_ideographs_EXTENSION_E}', "");
    Expect(1, 183984, '\P{Block= 	cjk_Unified_ideographs_EXTENSION_E}', "");
    Expect(0, 183984, '\P{^Block= 	cjk_Unified_ideographs_EXTENSION_E}', "");
    Error('\p{Blk=:=-	CJK_Ext_E}');
    Error('\P{Blk=:=-	CJK_Ext_E}');
    Expect(1, 183983, '\p{Blk=:\ACJK_Ext_E\z:}', "");;
    Expect(0, 183984, '\p{Blk=:\ACJK_Ext_E\z:}', "");;
    Expect(1, 183983, '\p{Blk=cjkexte}', "");
    Expect(0, 183983, '\p{^Blk=cjkexte}', "");
    Expect(0, 183983, '\P{Blk=cjkexte}', "");
    Expect(1, 183983, '\P{^Blk=cjkexte}', "");
    Expect(0, 183984, '\p{Blk=cjkexte}', "");
    Expect(1, 183984, '\p{^Blk=cjkexte}', "");
    Expect(1, 183984, '\P{Blk=cjkexte}', "");
    Expect(0, 183984, '\P{^Blk=cjkexte}', "");
    Expect(1, 183983, '\p{Blk=:\Acjkexte\z:}', "");;
    Expect(0, 183984, '\p{Blk=:\Acjkexte\z:}', "");;
    Expect(1, 183983, '\p{Blk=--cjk_ext_E}', "");
    Expect(0, 183983, '\p{^Blk=--cjk_ext_E}', "");
    Expect(0, 183983, '\P{Blk=--cjk_ext_E}', "");
    Expect(1, 183983, '\P{^Blk=--cjk_ext_E}', "");
    Expect(0, 183984, '\p{Blk=--cjk_ext_E}', "");
    Expect(1, 183984, '\p{^Blk=--cjk_ext_E}', "");
    Expect(1, 183984, '\P{Blk=--cjk_ext_E}', "");
    Expect(0, 183984, '\P{^Blk=--cjk_ext_E}', "");
    Error('\p{Is_Block=:= cjk_unified_Ideographs_Extension_E}');
    Error('\P{Is_Block=:= cjk_unified_Ideographs_Extension_E}');
    Expect(1, 183983, '\p{Is_Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183983, '\p{^Is_Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183983, '\P{Is_Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183983, '\P{^Is_Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183984, '\p{Is_Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183984, '\p{^Is_Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183984, '\P{Is_Block=cjkunifiedideographsextensione}', "");
    Expect(0, 183984, '\P{^Is_Block=cjkunifiedideographsextensione}', "");
    Expect(1, 183983, '\p{Is_Block=__CJK_Unified_Ideographs_EXTENSION_E}', "");
    Expect(0, 183983, '\p{^Is_Block=__CJK_Unified_Ideographs_EXTENSION_E}', "");
    Expect(0, 183983, '\P{Is_Block=__CJK_Unified_Ideographs_EXTENSION_E}', "");
    Expect(1, 183983, '\P{^Is_Block=__CJK_Unified_Ideographs_EXTENSION_E}', "");
    Expect(0, 183984, '\p{Is_Block=__CJK_Unified_Ideographs_EXTENSION_E}', "");
    Expect(1, 183984, '\p{^Is_Block=__CJK_Unified_Ideographs_EXTENSION_E}', "");
    Expect(1, 183984, '\P{Is_Block=__CJK_Unified_Ideographs_EXTENSION_E}', "");
    Expect(0, 183984, '\P{^Is_Block=__CJK_Unified_Ideographs_EXTENSION_E}', "");
    Error('\p{Is_Blk= 	CJK_EXT_E:=}');
    Error('\P{Is_Blk= 	CJK_EXT_E:=}');
    Expect(1, 183983, '\p{Is_Blk=cjkexte}', "");
    Expect(0, 183983, '\p{^Is_Blk=cjkexte}', "");
    Expect(0, 183983, '\P{Is_Blk=cjkexte}', "");
    Expect(1, 183983, '\P{^Is_Blk=cjkexte}', "");
    Expect(0, 183984, '\p{Is_Blk=cjkexte}', "");
    Expect(1, 183984, '\p{^Is_Blk=cjkexte}', "");
    Expect(1, 183984, '\P{Is_Blk=cjkexte}', "");
    Expect(0, 183984, '\P{^Is_Blk=cjkexte}', "");
    Expect(1, 183983, '\p{Is_Blk= 	CJK_Ext_E}', "");
    Expect(0, 183983, '\p{^Is_Blk= 	CJK_Ext_E}', "");
    Expect(0, 183983, '\P{Is_Blk= 	CJK_Ext_E}', "");
    Expect(1, 183983, '\P{^Is_Blk= 	CJK_Ext_E}', "");
    Expect(0, 183984, '\p{Is_Blk= 	CJK_Ext_E}', "");
    Expect(1, 183984, '\p{^Is_Blk= 	CJK_Ext_E}', "");
    Expect(1, 183984, '\P{Is_Blk= 	CJK_Ext_E}', "");
    Expect(0, 183984, '\P{^Is_Blk= 	CJK_Ext_E}', "");
    Error('\p{Block= CJK_Unified_Ideographs_Extension_F:=}');
    Error('\P{Block= CJK_Unified_Ideographs_Extension_F:=}');
    Expect(1, 191471, '\p{Block=:\ACJK_Unified_Ideographs_Extension_F\z:}', "");;
    Expect(0, 191472, '\p{Block=:\ACJK_Unified_Ideographs_Extension_F\z:}', "");;
    Expect(1, 191471, '\p{Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191471, '\p{^Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191471, '\P{Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191471, '\P{^Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191472, '\p{Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191472, '\p{^Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191472, '\P{Block=cjkunifiedideographsextensionf}', "");
    Expect(0, 191472, '\P{^Block=cjkunifiedideographsextensionf}', "");
    Expect(1, 191471, '\p{Block=:\Acjkunifiedideographsextensionf\z:}', "");;
    Expect(0, 191472, '\p{Block=:\Acjkunifiedideographsextensionf\z:}', "");;
    Expect(1, 191471, '\p{Block=_	CJK_Unified_Ideographs_extension_f}', "");
    Expect(0, 191471, '\p{^Block=_	CJK_Unified_Ideographs_extension_f}', "");
    Expect(0, 191471, '\P{Block=_	CJK_Unified_Ideographs_extension_f}', "");
    Expect(1, 191471, '\P{^Block=_	CJK_Unified_Ideographs_extension_f}', "");
    Expect(0, 191472, '\p{Block=_	CJK_Unified_Ideographs_extension_f}', "");
    Expect(1, 191472, '\p{^Block=_	CJK_Unified_Ideographs_extension_f}', "");
    Expect(1, 191472, '\P{Block=_	CJK_Unified_Ideographs_extension_f}', "");
    Expect(0, 191472, '\P{^Block=_	CJK_Unified_Ideographs_extension_f}', "");
    Error('\p{Blk=	:=cjk_EXT_f}');
    Error('\P{Blk=	:=cjk_EXT_f}');
    Expect(1, 191471, '\p{Blk=:\ACJK_Ext_F\z:}', "");;
    Expect(0, 191472, '\p{Blk=:\ACJK_Ext_F\z:}', "");;
    Expect(1, 191471, '\p{Blk=cjkextf}', "");
    Expect(0, 191471, '\p{^Blk=cjkextf}', "");
    Expect(0, 191471, '\P{Blk=cjkextf}', "");
    Expect(1, 191471, '\P{^Blk=cjkextf}', "");
    Expect(0, 191472, '\p{Blk=cjkextf}', "");
    Expect(1, 191472, '\p{^Blk=cjkextf}', "");
    Expect(1, 191472, '\P{Blk=cjkextf}', "");
    Expect(0, 191472, '\P{^Blk=cjkextf}', "");
    Expect(1, 191471, '\p{Blk=:\Acjkextf\z:}', "");;
    Expect(0, 191472, '\p{Blk=:\Acjkextf\z:}', "");;
    Expect(1, 191471, '\p{Blk=	CJK_ext_f}', "");
    Expect(0, 191471, '\p{^Blk=	CJK_ext_f}', "");
    Expect(0, 191471, '\P{Blk=	CJK_ext_f}', "");
    Expect(1, 191471, '\P{^Blk=	CJK_ext_f}', "");
    Expect(0, 191472, '\p{Blk=	CJK_ext_f}', "");
    Expect(1, 191472, '\p{^Blk=	CJK_ext_f}', "");
    Expect(1, 191472, '\P{Blk=	CJK_ext_f}', "");
    Expect(0, 191472, '\P{^Blk=	CJK_ext_f}', "");
    Error('\p{Is_Block=:=CJK_Unified_Ideographs_Extension_F}');
    Error('\P{Is_Block=:=CJK_Unified_Ideographs_Extension_F}');
    Expect(1, 191471, '\p{Is_Block: cjkunifiedideographsextensionf}', "");
    Expect(0, 191471, '\p{^Is_Block: cjkunifiedideographsextensionf}', "");
    Expect(0, 191471, '\P{Is_Block: cjkunifiedideographsextensionf}', "");
    Expect(1, 191471, '\P{^Is_Block: cjkunifiedideographsextensionf}', "");
    Expect(0, 191472, '\p{Is_Block: cjkunifiedideographsextensionf}', "");
    Expect(1, 191472, '\p{^Is_Block: cjkunifiedideographsextensionf}', "");
    Expect(1, 191472, '\P{Is_Block: cjkunifiedideographsextensionf}', "");
    Expect(0, 191472, '\P{^Is_Block: cjkunifiedideographsextensionf}', "");
    Expect(1, 191471, '\p{Is_Block=  cjk_Unified_Ideographs_extension_F}', "");
    Expect(0, 191471, '\p{^Is_Block=  cjk_Unified_Ideographs_extension_F}', "");
    Expect(0, 191471, '\P{Is_Block=  cjk_Unified_Ideographs_extension_F}', "");
    Expect(1, 191471, '\P{^Is_Block=  cjk_Unified_Ideographs_extension_F}', "");
    Expect(0, 191472, '\p{Is_Block=  cjk_Unified_Ideographs_extension_F}', "");
    Expect(1, 191472, '\p{^Is_Block=  cjk_Unified_Ideographs_extension_F}', "");
    Expect(1, 191472, '\P{Is_Block=  cjk_Unified_Ideographs_extension_F}', "");
    Expect(0, 191472, '\P{^Is_Block=  cjk_Unified_Ideographs_extension_F}', "");
    Error('\p{Is_Blk=_ cjk_EXT_F/a/}');
    Error('\P{Is_Blk=_ cjk_EXT_F/a/}');
    Expect(1, 191471, '\p{Is_Blk=cjkextf}', "");
    Expect(0, 191471, '\p{^Is_Blk=cjkextf}', "");
    Expect(0, 191471, '\P{Is_Blk=cjkextf}', "");
    Expect(1, 191471, '\P{^Is_Blk=cjkextf}', "");
    Expect(0, 191472, '\p{Is_Blk=cjkextf}', "");
    Expect(1, 191472, '\p{^Is_Blk=cjkextf}', "");
    Expect(1, 191472, '\P{Is_Blk=cjkextf}', "");
    Expect(0, 191472, '\P{^Is_Blk=cjkextf}', "");
    Expect(1, 191471, '\p{Is_Blk= CJK_EXT_F}', "");
    Expect(0, 191471, '\p{^Is_Blk= CJK_EXT_F}', "");
    Expect(0, 191471, '\P{Is_Blk= CJK_EXT_F}', "");
    Expect(1, 191471, '\P{^Is_Blk= CJK_EXT_F}', "");
    Expect(0, 191472, '\p{Is_Blk= CJK_EXT_F}', "");
    Expect(1, 191472, '\p{^Is_Blk= CJK_EXT_F}', "");
    Expect(1, 191472, '\P{Is_Blk= CJK_EXT_F}', "");
    Expect(0, 191472, '\P{^Is_Blk= CJK_EXT_F}', "");
    Error('\p{Block=__CJK_Unified_ideographs_Extension_G:=}');
    Error('\P{Block=__CJK_Unified_ideographs_Extension_G:=}');
    Expect(1, 201551, '\p{Block=:\ACJK_Unified_Ideographs_Extension_G\z:}', "");;
    Expect(0, 201552, '\p{Block=:\ACJK_Unified_Ideographs_Extension_G\z:}', "");;
    Expect(1, 201551, '\p{Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201551, '\p{^Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201551, '\P{Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201551, '\P{^Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201552, '\p{Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201552, '\p{^Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201552, '\P{Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201552, '\P{^Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201551, '\p{Block=:\Acjkunifiedideographsextensiong\z:}', "");;
    Expect(0, 201552, '\p{Block=:\Acjkunifiedideographsextensiong\z:}', "");;
    Expect(1, 201551, '\p{Block=--CJK_Unified_IDEOGRAPHS_extension_g}', "");
    Expect(0, 201551, '\p{^Block=--CJK_Unified_IDEOGRAPHS_extension_g}', "");
    Expect(0, 201551, '\P{Block=--CJK_Unified_IDEOGRAPHS_extension_g}', "");
    Expect(1, 201551, '\P{^Block=--CJK_Unified_IDEOGRAPHS_extension_g}', "");
    Expect(0, 201552, '\p{Block=--CJK_Unified_IDEOGRAPHS_extension_g}', "");
    Expect(1, 201552, '\p{^Block=--CJK_Unified_IDEOGRAPHS_extension_g}', "");
    Expect(1, 201552, '\P{Block=--CJK_Unified_IDEOGRAPHS_extension_g}', "");
    Expect(0, 201552, '\P{^Block=--CJK_Unified_IDEOGRAPHS_extension_g}', "");
    Error('\p{Blk=	 CJK_Ext_g/a/}');
    Error('\P{Blk=	 CJK_Ext_g/a/}');
    Expect(1, 201551, '\p{Blk=:\ACJK_Ext_G\z:}', "");;
    Expect(0, 201552, '\p{Blk=:\ACJK_Ext_G\z:}', "");;
    Expect(1, 201551, '\p{Blk=cjkextg}', "");
    Expect(0, 201551, '\p{^Blk=cjkextg}', "");
    Expect(0, 201551, '\P{Blk=cjkextg}', "");
    Expect(1, 201551, '\P{^Blk=cjkextg}', "");
    Expect(0, 201552, '\p{Blk=cjkextg}', "");
    Expect(1, 201552, '\p{^Blk=cjkextg}', "");
    Expect(1, 201552, '\P{Blk=cjkextg}', "");
    Expect(0, 201552, '\P{^Blk=cjkextg}', "");
    Expect(1, 201551, '\p{Blk=:\Acjkextg\z:}', "");;
    Expect(0, 201552, '\p{Blk=:\Acjkextg\z:}', "");;
    Expect(1, 201551, '\p{Blk=	 CJK_ext_G}', "");
    Expect(0, 201551, '\p{^Blk=	 CJK_ext_G}', "");
    Expect(0, 201551, '\P{Blk=	 CJK_ext_G}', "");
    Expect(1, 201551, '\P{^Blk=	 CJK_ext_G}', "");
    Expect(0, 201552, '\p{Blk=	 CJK_ext_G}', "");
    Expect(1, 201552, '\p{^Blk=	 CJK_ext_G}', "");
    Expect(1, 201552, '\P{Blk=	 CJK_ext_G}', "");
    Expect(0, 201552, '\P{^Blk=	 CJK_ext_G}', "");
    Error('\p{Is_Block=	_cjk_unified_Ideographs_EXTENSION_g:=}');
    Error('\P{Is_Block=	_cjk_unified_Ideographs_EXTENSION_g:=}');
    Expect(1, 201551, '\p{Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201551, '\p{^Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201551, '\P{Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201551, '\P{^Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201552, '\p{Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201552, '\p{^Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201552, '\P{Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(0, 201552, '\P{^Is_Block=cjkunifiedideographsextensiong}', "");
    Expect(1, 201551, '\p{Is_Block=_cjk_unified_Ideographs_EXTENSION_G}', "");
    Expect(0, 201551, '\p{^Is_Block=_cjk_unified_Ideographs_EXTENSION_G}', "");
    Expect(0, 201551, '\P{Is_Block=_cjk_unified_Ideographs_EXTENSION_G}', "");
    Expect(1, 201551, '\P{^Is_Block=_cjk_unified_Ideographs_EXTENSION_G}', "");
    Expect(0, 201552, '\p{Is_Block=_cjk_unified_Ideographs_EXTENSION_G}', "");
    Expect(1, 201552, '\p{^Is_Block=_cjk_unified_Ideographs_EXTENSION_G}', "");
    Expect(1, 201552, '\P{Is_Block=_cjk_unified_Ideographs_EXTENSION_G}', "");
    Expect(0, 201552, '\P{^Is_Block=_cjk_unified_Ideographs_EXTENSION_G}', "");
    Error('\p{Is_Blk=-CJK_EXT_G:=}');
    Error('\P{Is_Blk=-CJK_EXT_G:=}');
    Expect(1, 201551, '\p{Is_Blk=cjkextg}', "");
    Expect(0, 201551, '\p{^Is_Blk=cjkextg}', "");
    Expect(0, 201551, '\P{Is_Blk=cjkextg}', "");
    Expect(1, 201551, '\P{^Is_Blk=cjkextg}', "");
    Expect(0, 201552, '\p{Is_Blk=cjkextg}', "");
    Expect(1, 201552, '\p{^Is_Blk=cjkextg}', "");
    Expect(1, 201552, '\P{Is_Blk=cjkextg}', "");
    Expect(0, 201552, '\P{^Is_Blk=cjkextg}', "");
    Expect(1, 201551, '\p{Is_Blk=_CJK_Ext_G}', "");
    Expect(0, 201551, '\p{^Is_Blk=_CJK_Ext_G}', "");
    Expect(0, 201551, '\P{Is_Blk=_CJK_Ext_G}', "");
    Expect(1, 201551, '\P{^Is_Blk=_CJK_Ext_G}', "");
    Expect(0, 201552, '\p{Is_Blk=_CJK_Ext_G}', "");
    Expect(1, 201552, '\p{^Is_Blk=_CJK_Ext_G}', "");
    Expect(1, 201552, '\P{Is_Blk=_CJK_Ext_G}', "");
    Expect(0, 201552, '\P{^Is_Blk=_CJK_Ext_G}', "");
    Error('\p{Block=  CJK_radicals_Supplement:=}');
    Error('\P{Block=  CJK_radicals_Supplement:=}');
    Expect(1, 12031, '\p{Block=:\ACJK_Radicals_Supplement\z:}', "");;
    Expect(0, 12032, '\p{Block=:\ACJK_Radicals_Supplement\z:}', "");;
    Expect(1, 12031, '\p{Block=cjkradicalssupplement}', "");
    Expect(0, 12031, '\p{^Block=cjkradicalssupplement}', "");
    Expect(0, 12031, '\P{Block=cjkradicalssupplement}', "");
    Expect(1, 12031, '\P{^Block=cjkradicalssupplement}', "");
    Expect(0, 12032, '\p{Block=cjkradicalssupplement}', "");
    Expect(1, 12032, '\p{^Block=cjkradicalssupplement}', "");
    Expect(1, 12032, '\P{Block=cjkradicalssupplement}', "");
    Expect(0, 12032, '\P{^Block=cjkradicalssupplement}', "");
    Expect(1, 12031, '\p{Block=:\Acjkradicalssupplement\z:}', "");;
    Expect(0, 12032, '\p{Block=:\Acjkradicalssupplement\z:}', "");;
    Expect(1, 12031, '\p{Block=	CJK_RADICALS_supplement}', "");
    Expect(0, 12031, '\p{^Block=	CJK_RADICALS_supplement}', "");
    Expect(0, 12031, '\P{Block=	CJK_RADICALS_supplement}', "");
    Expect(1, 12031, '\P{^Block=	CJK_RADICALS_supplement}', "");
    Expect(0, 12032, '\p{Block=	CJK_RADICALS_supplement}', "");
    Expect(1, 12032, '\p{^Block=	CJK_RADICALS_supplement}', "");
    Expect(1, 12032, '\P{Block=	CJK_RADICALS_supplement}', "");
    Expect(0, 12032, '\P{^Block=	CJK_RADICALS_supplement}', "");
    Error('\p{Blk=/a/-CJK_RADICALS_Sup}');
    Error('\P{Blk=/a/-CJK_RADICALS_Sup}');
    Expect(1, 12031, '\p{Blk=:\ACJK_Radicals_Sup\z:}', "");;
    Expect(0, 12032, '\p{Blk=:\ACJK_Radicals_Sup\z:}', "");;
    Expect(1, 12031, '\p{Blk=cjkradicalssup}', "");
    Expect(0, 12031, '\p{^Blk=cjkradicalssup}', "");
    Expect(0, 12031, '\P{Blk=cjkradicalssup}', "");
    Expect(1, 12031, '\P{^Blk=cjkradicalssup}', "");
    Expect(0, 12032, '\p{Blk=cjkradicalssup}', "");
    Expect(1, 12032, '\p{^Blk=cjkradicalssup}', "");
    Expect(1, 12032, '\P{Blk=cjkradicalssup}', "");
    Expect(0, 12032, '\P{^Blk=cjkradicalssup}', "");
    Expect(1, 12031, '\p{Blk=:\Acjkradicalssup\z:}', "");;
    Expect(0, 12032, '\p{Blk=:\Acjkradicalssup\z:}', "");;
    Expect(1, 12031, '\p{Blk=	_CJK_RADICALS_Sup}', "");
    Expect(0, 12031, '\p{^Blk=	_CJK_RADICALS_Sup}', "");
    Expect(0, 12031, '\P{Blk=	_CJK_RADICALS_Sup}', "");
    Expect(1, 12031, '\P{^Blk=	_CJK_RADICALS_Sup}', "");
    Expect(0, 12032, '\p{Blk=	_CJK_RADICALS_Sup}', "");
    Expect(1, 12032, '\p{^Blk=	_CJK_RADICALS_Sup}', "");
    Expect(1, 12032, '\P{Blk=	_CJK_RADICALS_Sup}', "");
    Expect(0, 12032, '\P{^Blk=	_CJK_RADICALS_Sup}', "");
    Error('\p{Is_Block=	:=CJK_Radicals_supplement}');
    Error('\P{Is_Block=	:=CJK_Radicals_supplement}');
    Expect(1, 12031, '\p{Is_Block=cjkradicalssupplement}', "");
    Expect(0, 12031, '\p{^Is_Block=cjkradicalssupplement}', "");
    Expect(0, 12031, '\P{Is_Block=cjkradicalssupplement}', "");
    Expect(1, 12031, '\P{^Is_Block=cjkradicalssupplement}', "");
    Expect(0, 12032, '\p{Is_Block=cjkradicalssupplement}', "");
    Expect(1, 12032, '\p{^Is_Block=cjkradicalssupplement}', "");
    Expect(1, 12032, '\P{Is_Block=cjkradicalssupplement}', "");
    Expect(0, 12032, '\P{^Is_Block=cjkradicalssupplement}', "");
    Expect(1, 12031, '\p{Is_Block=_CJK_radicals_SUPPLEMENT}', "");
    Expect(0, 12031, '\p{^Is_Block=_CJK_radicals_SUPPLEMENT}', "");
    Expect(0, 12031, '\P{Is_Block=_CJK_radicals_SUPPLEMENT}', "");
    Expect(1, 12031, '\P{^Is_Block=_CJK_radicals_SUPPLEMENT}', "");
    Expect(0, 12032, '\p{Is_Block=_CJK_radicals_SUPPLEMENT}', "");
    Expect(1, 12032, '\p{^Is_Block=_CJK_radicals_SUPPLEMENT}', "");
    Expect(1, 12032, '\P{Is_Block=_CJK_radicals_SUPPLEMENT}', "");
    Expect(0, 12032, '\P{^Is_Block=_CJK_radicals_SUPPLEMENT}', "");
    Error('\p{Is_Blk:   	:=cjk_radicals_sup}');
    Error('\P{Is_Blk:   	:=cjk_radicals_sup}');
    Expect(1, 12031, '\p{Is_Blk=cjkradicalssup}', "");
    Expect(0, 12031, '\p{^Is_Blk=cjkradicalssup}', "");
    Expect(0, 12031, '\P{Is_Blk=cjkradicalssup}', "");
    Expect(1, 12031, '\P{^Is_Blk=cjkradicalssup}', "");
    Expect(0, 12032, '\p{Is_Blk=cjkradicalssup}', "");
    Expect(1, 12032, '\p{^Is_Blk=cjkradicalssup}', "");
    Expect(1, 12032, '\P{Is_Blk=cjkradicalssup}', "");
    Expect(0, 12032, '\P{^Is_Blk=cjkradicalssup}', "");
    Expect(1, 12031, '\p{Is_Blk=_CJK_RADICALS_Sup}', "");
    Expect(0, 12031, '\p{^Is_Blk=_CJK_RADICALS_Sup}', "");
    Expect(0, 12031, '\P{Is_Blk=_CJK_RADICALS_Sup}', "");
    Expect(1, 12031, '\P{^Is_Blk=_CJK_RADICALS_Sup}', "");
    Expect(0, 12032, '\p{Is_Blk=_CJK_RADICALS_Sup}', "");
    Expect(1, 12032, '\p{^Is_Blk=_CJK_RADICALS_Sup}', "");
    Expect(1, 12032, '\P{Is_Blk=_CJK_RADICALS_Sup}', "");
    Expect(0, 12032, '\P{^Is_Blk=_CJK_RADICALS_Sup}', "");
    Error('\p{Block=	/a/CJK_Strokes}');
    Error('\P{Block=	/a/CJK_Strokes}');
    Expect(1, 12783, '\p{Block=:\ACJK_Strokes\z:}', "");;
    Expect(0, 12784, '\p{Block=:\ACJK_Strokes\z:}', "");;
    Expect(1, 12783, '\p{Block=cjkstrokes}', "");
    Expect(0, 12783, '\p{^Block=cjkstrokes}', "");
    Expect(0, 12783, '\P{Block=cjkstrokes}', "");
    Expect(1, 12783, '\P{^Block=cjkstrokes}', "");
    Expect(0, 12784, '\p{Block=cjkstrokes}', "");
    Expect(1, 12784, '\p{^Block=cjkstrokes}', "");
    Expect(1, 12784, '\P{Block=cjkstrokes}', "");
    Expect(0, 12784, '\P{^Block=cjkstrokes}', "");
    Expect(1, 12783, '\p{Block=:\Acjkstrokes\z:}', "");;
    Expect(0, 12784, '\p{Block=:\Acjkstrokes\z:}', "");;
    Expect(1, 12783, '\p{Block=  CJK_strokes}', "");
    Expect(0, 12783, '\p{^Block=  CJK_strokes}', "");
    Expect(0, 12783, '\P{Block=  CJK_strokes}', "");
    Expect(1, 12783, '\P{^Block=  CJK_strokes}', "");
    Expect(0, 12784, '\p{Block=  CJK_strokes}', "");
    Expect(1, 12784, '\p{^Block=  CJK_strokes}', "");
    Expect(1, 12784, '\P{Block=  CJK_strokes}', "");
    Expect(0, 12784, '\P{^Block=  CJK_strokes}', "");
    Error('\p{Blk=/a/	_cjk_Strokes}');
    Error('\P{Blk=/a/	_cjk_Strokes}');
    Expect(1, 12783, '\p{Blk=:\ACJK_Strokes\z:}', "");;
    Expect(0, 12784, '\p{Blk=:\ACJK_Strokes\z:}', "");;
    Expect(1, 12783, '\p{Blk=cjkstrokes}', "");
    Expect(0, 12783, '\p{^Blk=cjkstrokes}', "");
    Expect(0, 12783, '\P{Blk=cjkstrokes}', "");
    Expect(1, 12783, '\P{^Blk=cjkstrokes}', "");
    Expect(0, 12784, '\p{Blk=cjkstrokes}', "");
    Expect(1, 12784, '\p{^Blk=cjkstrokes}', "");
    Expect(1, 12784, '\P{Blk=cjkstrokes}', "");
    Expect(0, 12784, '\P{^Blk=cjkstrokes}', "");
    Expect(1, 12783, '\p{Blk=:\Acjkstrokes\z:}', "");;
    Expect(0, 12784, '\p{Blk=:\Acjkstrokes\z:}', "");;
    Expect(1, 12783, '\p{Blk=CJK_Strokes}', "");
    Expect(0, 12783, '\p{^Blk=CJK_Strokes}', "");
    Expect(0, 12783, '\P{Blk=CJK_Strokes}', "");
    Expect(1, 12783, '\P{^Blk=CJK_Strokes}', "");
    Expect(0, 12784, '\p{Blk=CJK_Strokes}', "");
    Expect(1, 12784, '\p{^Blk=CJK_Strokes}', "");
    Expect(1, 12784, '\P{Blk=CJK_Strokes}', "");
    Expect(0, 12784, '\P{^Blk=CJK_Strokes}', "");
    Error('\p{Is_Block=	CJK_STROKES/a/}');
    Error('\P{Is_Block=	CJK_STROKES/a/}');
    Expect(1, 12783, '\p{Is_Block=cjkstrokes}', "");
    Expect(0, 12783, '\p{^Is_Block=cjkstrokes}', "");
    Expect(0, 12783, '\P{Is_Block=cjkstrokes}', "");
    Expect(1, 12783, '\P{^Is_Block=cjkstrokes}', "");
    Expect(0, 12784, '\p{Is_Block=cjkstrokes}', "");
    Expect(1, 12784, '\p{^Is_Block=cjkstrokes}', "");
    Expect(1, 12784, '\P{Is_Block=cjkstrokes}', "");
    Expect(0, 12784, '\P{^Is_Block=cjkstrokes}', "");
    Expect(1, 12783, '\p{Is_Block=-_cjk_Strokes}', "");
    Expect(0, 12783, '\p{^Is_Block=-_cjk_Strokes}', "");
    Expect(0, 12783, '\P{Is_Block=-_cjk_Strokes}', "");
    Expect(1, 12783, '\P{^Is_Block=-_cjk_Strokes}', "");
    Expect(0, 12784, '\p{Is_Block=-_cjk_Strokes}', "");
    Expect(1, 12784, '\p{^Is_Block=-_cjk_Strokes}', "");
    Expect(1, 12784, '\P{Is_Block=-_cjk_Strokes}', "");
    Expect(0, 12784, '\P{^Is_Block=-_cjk_Strokes}', "");
    Error('\p{Is_Blk=_-CJK_Strokes:=}');
    Error('\P{Is_Blk=_-CJK_Strokes:=}');
    Expect(1, 12783, '\p{Is_Blk=cjkstrokes}', "");
    Expect(0, 12783, '\p{^Is_Blk=cjkstrokes}', "");
    Expect(0, 12783, '\P{Is_Blk=cjkstrokes}', "");
    Expect(1, 12783, '\P{^Is_Blk=cjkstrokes}', "");
    Expect(0, 12784, '\p{Is_Blk=cjkstrokes}', "");
    Expect(1, 12784, '\p{^Is_Blk=cjkstrokes}', "");
    Expect(1, 12784, '\P{Is_Blk=cjkstrokes}', "");
    Expect(0, 12784, '\P{^Is_Blk=cjkstrokes}', "");
    Expect(1, 12783, '\p{Is_Blk= CJK_Strokes}', "");
    Expect(0, 12783, '\p{^Is_Blk= CJK_Strokes}', "");
    Expect(0, 12783, '\P{Is_Blk= CJK_Strokes}', "");
    Expect(1, 12783, '\P{^Is_Blk= CJK_Strokes}', "");
    Expect(0, 12784, '\p{Is_Blk= CJK_Strokes}', "");
    Expect(1, 12784, '\p{^Is_Blk= CJK_Strokes}', "");
    Expect(1, 12784, '\P{Is_Blk= CJK_Strokes}', "");
    Expect(0, 12784, '\P{^Is_Blk= CJK_Strokes}', "");
    Error('\p{Block=/a/- CJK_Symbols_AND_punctuation}');
    Error('\P{Block=/a/- CJK_Symbols_AND_punctuation}');
    Expect(1, 12351, '\p{Block=:\ACJK_Symbols_And_Punctuation\z:}', "");;
    Expect(0, 12352, '\p{Block=:\ACJK_Symbols_And_Punctuation\z:}', "");;
    Expect(1, 12351, '\p{Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12351, '\p{^Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12351, '\P{Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12351, '\P{^Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12352, '\p{Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12352, '\p{^Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12352, '\P{Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12352, '\P{^Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12351, '\p{Block=:\Acjksymbolsandpunctuation\z:}', "");;
    Expect(0, 12352, '\p{Block=:\Acjksymbolsandpunctuation\z:}', "");;
    Expect(1, 12351, '\p{Block=-CJK_symbols_AND_punctuation}', "");
    Expect(0, 12351, '\p{^Block=-CJK_symbols_AND_punctuation}', "");
    Expect(0, 12351, '\P{Block=-CJK_symbols_AND_punctuation}', "");
    Expect(1, 12351, '\P{^Block=-CJK_symbols_AND_punctuation}', "");
    Expect(0, 12352, '\p{Block=-CJK_symbols_AND_punctuation}', "");
    Expect(1, 12352, '\p{^Block=-CJK_symbols_AND_punctuation}', "");
    Expect(1, 12352, '\P{Block=-CJK_symbols_AND_punctuation}', "");
    Expect(0, 12352, '\P{^Block=-CJK_symbols_AND_punctuation}', "");
    Error('\p{Blk=-cjk_Symbols:=}');
    Error('\P{Blk=-cjk_Symbols:=}');
    Expect(1, 12351, '\p{Blk=:\ACJK_Symbols\z:}', "");;
    Expect(0, 12352, '\p{Blk=:\ACJK_Symbols\z:}', "");;
    Expect(1, 12351, '\p{Blk=cjksymbols}', "");
    Expect(0, 12351, '\p{^Blk=cjksymbols}', "");
    Expect(0, 12351, '\P{Blk=cjksymbols}', "");
    Expect(1, 12351, '\P{^Blk=cjksymbols}', "");
    Expect(0, 12352, '\p{Blk=cjksymbols}', "");
    Expect(1, 12352, '\p{^Blk=cjksymbols}', "");
    Expect(1, 12352, '\P{Blk=cjksymbols}', "");
    Expect(0, 12352, '\P{^Blk=cjksymbols}', "");
    Expect(1, 12351, '\p{Blk=:\Acjksymbols\z:}', "");;
    Expect(0, 12352, '\p{Blk=:\Acjksymbols\z:}', "");;
    Expect(1, 12351, '\p{Blk=-_cjk_symbols}', "");
    Expect(0, 12351, '\p{^Blk=-_cjk_symbols}', "");
    Expect(0, 12351, '\P{Blk=-_cjk_symbols}', "");
    Expect(1, 12351, '\P{^Blk=-_cjk_symbols}', "");
    Expect(0, 12352, '\p{Blk=-_cjk_symbols}', "");
    Expect(1, 12352, '\p{^Blk=-_cjk_symbols}', "");
    Expect(1, 12352, '\P{Blk=-_cjk_symbols}', "");
    Expect(0, 12352, '\P{^Blk=-_cjk_symbols}', "");
    Error('\p{Is_Block:/a/- cjk_Symbols_And_Punctuation}');
    Error('\P{Is_Block:/a/- cjk_Symbols_And_Punctuation}');
    Expect(1, 12351, '\p{Is_Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12351, '\p{^Is_Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12351, '\P{Is_Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12351, '\P{^Is_Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12352, '\p{Is_Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12352, '\p{^Is_Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12352, '\P{Is_Block=cjksymbolsandpunctuation}', "");
    Expect(0, 12352, '\P{^Is_Block=cjksymbolsandpunctuation}', "");
    Expect(1, 12351, '\p{Is_Block:   		CJK_Symbols_And_Punctuation}', "");
    Expect(0, 12351, '\p{^Is_Block:   		CJK_Symbols_And_Punctuation}', "");
    Expect(0, 12351, '\P{Is_Block:   		CJK_Symbols_And_Punctuation}', "");
    Expect(1, 12351, '\P{^Is_Block:   		CJK_Symbols_And_Punctuation}', "");
    Expect(0, 12352, '\p{Is_Block:   		CJK_Symbols_And_Punctuation}', "");
    Expect(1, 12352, '\p{^Is_Block:   		CJK_Symbols_And_Punctuation}', "");
    Expect(1, 12352, '\P{Is_Block:   		CJK_Symbols_And_Punctuation}', "");
    Expect(0, 12352, '\P{^Is_Block:   		CJK_Symbols_And_Punctuation}', "");
    Error('\p{Is_Blk=-CJK_Symbols:=}');
    Error('\P{Is_Blk=-CJK_Symbols:=}');
    Expect(1, 12351, '\p{Is_Blk=cjksymbols}', "");
    Expect(0, 12351, '\p{^Is_Blk=cjksymbols}', "");
    Expect(0, 12351, '\P{Is_Blk=cjksymbols}', "");
    Expect(1, 12351, '\P{^Is_Blk=cjksymbols}', "");
    Expect(0, 12352, '\p{Is_Blk=cjksymbols}', "");
    Expect(1, 12352, '\p{^Is_Blk=cjksymbols}', "");
    Expect(1, 12352, '\P{Is_Blk=cjksymbols}', "");
    Expect(0, 12352, '\P{^Is_Blk=cjksymbols}', "");
    Expect(1, 12351, '\p{Is_Blk=__cjk_Symbols}', "");
    Expect(0, 12351, '\p{^Is_Blk=__cjk_Symbols}', "");
    Expect(0, 12351, '\P{Is_Blk=__cjk_Symbols}', "");
    Expect(1, 12351, '\P{^Is_Blk=__cjk_Symbols}', "");
    Expect(0, 12352, '\p{Is_Blk=__cjk_Symbols}', "");
    Expect(1, 12352, '\p{^Is_Blk=__cjk_Symbols}', "");
    Expect(1, 12352, '\P{Is_Blk=__cjk_Symbols}', "");
    Expect(0, 12352, '\P{^Is_Blk=__cjk_Symbols}', "");
    Error('\p{Block:    HANGUL_COMPATIBILITY_JAMO:=}');
    Error('\P{Block:    HANGUL_COMPATIBILITY_JAMO:=}');
    Expect(1, 12687, '\p{Block=:\AHangul_Compatibility_Jamo\z:}', "");;
    Expect(0, 12688, '\p{Block=:\AHangul_Compatibility_Jamo\z:}', "");;
    Expect(1, 12687, '\p{Block=hangulcompatibilityjamo}', "");
    Expect(0, 12687, '\p{^Block=hangulcompatibilityjamo}', "");
    Expect(0, 12687, '\P{Block=hangulcompatibilityjamo}', "");
    Expect(1, 12687, '\P{^Block=hangulcompatibilityjamo}', "");
    Expect(0, 12688, '\p{Block=hangulcompatibilityjamo}', "");
    Expect(1, 12688, '\p{^Block=hangulcompatibilityjamo}', "");
    Expect(1, 12688, '\P{Block=hangulcompatibilityjamo}', "");
    Expect(0, 12688, '\P{^Block=hangulcompatibilityjamo}', "");
    Expect(1, 12687, '\p{Block=:\Ahangulcompatibilityjamo\z:}', "");;
    Expect(0, 12688, '\p{Block=:\Ahangulcompatibilityjamo\z:}', "");;
    Expect(1, 12687, '\p{Block=		hangul_Compatibility_Jamo}', "");
    Expect(0, 12687, '\p{^Block=		hangul_Compatibility_Jamo}', "");
    Expect(0, 12687, '\P{Block=		hangul_Compatibility_Jamo}', "");
    Expect(1, 12687, '\P{^Block=		hangul_Compatibility_Jamo}', "");
    Expect(0, 12688, '\p{Block=		hangul_Compatibility_Jamo}', "");
    Expect(1, 12688, '\p{^Block=		hangul_Compatibility_Jamo}', "");
    Expect(1, 12688, '\P{Block=		hangul_Compatibility_Jamo}', "");
    Expect(0, 12688, '\P{^Block=		hangul_Compatibility_Jamo}', "");
    Error('\p{Blk=_	Compat_Jamo:=}');
    Error('\P{Blk=_	Compat_Jamo:=}');
    Expect(1, 12687, '\p{Blk=:\ACompat_Jamo\z:}', "");;
    Expect(0, 12688, '\p{Blk=:\ACompat_Jamo\z:}', "");;
    Expect(1, 12687, '\p{Blk=compatjamo}', "");
    Expect(0, 12687, '\p{^Blk=compatjamo}', "");
    Expect(0, 12687, '\P{Blk=compatjamo}', "");
    Expect(1, 12687, '\P{^Blk=compatjamo}', "");
    Expect(0, 12688, '\p{Blk=compatjamo}', "");
    Expect(1, 12688, '\p{^Blk=compatjamo}', "");
    Expect(1, 12688, '\P{Blk=compatjamo}', "");
    Expect(0, 12688, '\P{^Blk=compatjamo}', "");
    Expect(1, 12687, '\p{Blk=:\Acompatjamo\z:}', "");;
    Expect(0, 12688, '\p{Blk=:\Acompatjamo\z:}', "");;
    Expect(1, 12687, '\p{Blk=_ COMPAT_JAMO}', "");
    Expect(0, 12687, '\p{^Blk=_ COMPAT_JAMO}', "");
    Expect(0, 12687, '\P{Blk=_ COMPAT_JAMO}', "");
    Expect(1, 12687, '\P{^Blk=_ COMPAT_JAMO}', "");
    Expect(0, 12688, '\p{Blk=_ COMPAT_JAMO}', "");
    Expect(1, 12688, '\p{^Blk=_ COMPAT_JAMO}', "");
    Expect(1, 12688, '\P{Blk=_ COMPAT_JAMO}', "");
    Expect(0, 12688, '\P{^Blk=_ COMPAT_JAMO}', "");
    Error('\p{Is_Block=:=Hangul_Compatibility_Jamo}');
    Error('\P{Is_Block=:=Hangul_Compatibility_Jamo}');
    Expect(1, 12687, '\p{Is_Block=hangulcompatibilityjamo}', "");
    Expect(0, 12687, '\p{^Is_Block=hangulcompatibilityjamo}', "");
    Expect(0, 12687, '\P{Is_Block=hangulcompatibilityjamo}', "");
    Expect(1, 12687, '\P{^Is_Block=hangulcompatibilityjamo}', "");
    Expect(0, 12688, '\p{Is_Block=hangulcompatibilityjamo}', "");
    Expect(1, 12688, '\p{^Is_Block=hangulcompatibilityjamo}', "");
    Expect(1, 12688, '\P{Is_Block=hangulcompatibilityjamo}', "");
    Expect(0, 12688, '\P{^Is_Block=hangulcompatibilityjamo}', "");
    Expect(1, 12687, '\p{Is_Block:   -hangul_compatibility_jamo}', "");
    Expect(0, 12687, '\p{^Is_Block:   -hangul_compatibility_jamo}', "");
    Expect(0, 12687, '\P{Is_Block:   -hangul_compatibility_jamo}', "");
    Expect(1, 12687, '\P{^Is_Block:   -hangul_compatibility_jamo}', "");
    Expect(0, 12688, '\p{Is_Block:   -hangul_compatibility_jamo}', "");
    Expect(1, 12688, '\p{^Is_Block:   -hangul_compatibility_jamo}', "");
    Expect(1, 12688, '\P{Is_Block:   -hangul_compatibility_jamo}', "");
    Expect(0, 12688, '\P{^Is_Block:   -hangul_compatibility_jamo}', "");
    Error('\p{Is_Blk=	:=Compat_Jamo}');
    Error('\P{Is_Blk=	:=Compat_Jamo}');
    Expect(1, 12687, '\p{Is_Blk=compatjamo}', "");
    Expect(0, 12687, '\p{^Is_Blk=compatjamo}', "");
    Expect(0, 12687, '\P{Is_Blk=compatjamo}', "");
    Expect(1, 12687, '\P{^Is_Blk=compatjamo}', "");
    Expect(0, 12688, '\p{Is_Blk=compatjamo}', "");
    Expect(1, 12688, '\p{^Is_Blk=compatjamo}', "");
    Expect(1, 12688, '\P{Is_Blk=compatjamo}', "");
    Expect(0, 12688, '\P{^Is_Blk=compatjamo}', "");
    Expect(1, 12687, '\p{Is_Blk=__COMPAT_Jamo}', "");
    Expect(0, 12687, '\p{^Is_Blk=__COMPAT_Jamo}', "");
    Expect(0, 12687, '\P{Is_Blk=__COMPAT_Jamo}', "");
    Expect(1, 12687, '\P{^Is_Blk=__COMPAT_Jamo}', "");
    Expect(0, 12688, '\p{Is_Blk=__COMPAT_Jamo}', "");
    Expect(1, 12688, '\p{^Is_Blk=__COMPAT_Jamo}', "");
    Expect(1, 12688, '\P{Is_Blk=__COMPAT_Jamo}', "");
    Expect(0, 12688, '\P{^Is_Blk=__COMPAT_Jamo}', "");
    Error('\p{Block=_/a/CONTROL_PICTURES}');
    Error('\P{Block=_/a/CONTROL_PICTURES}');
    Expect(1, 9279, '\p{Block=:\AControl_Pictures\z:}', "");;
    Expect(0, 9280, '\p{Block=:\AControl_Pictures\z:}', "");;
    Expect(1, 9279, '\p{Block: controlpictures}', "");
    Expect(0, 9279, '\p{^Block: controlpictures}', "");
    Expect(0, 9279, '\P{Block: controlpictures}', "");
    Expect(1, 9279, '\P{^Block: controlpictures}', "");
    Expect(0, 9280, '\p{Block: controlpictures}', "");
    Expect(1, 9280, '\p{^Block: controlpictures}', "");
    Expect(1, 9280, '\P{Block: controlpictures}', "");
    Expect(0, 9280, '\P{^Block: controlpictures}', "");
    Expect(1, 9279, '\p{Block=:\Acontrolpictures\z:}', "");;
    Expect(0, 9280, '\p{Block=:\Acontrolpictures\z:}', "");;
    Expect(1, 9279, '\p{Block=_ Control_PICTURES}', "");
    Expect(0, 9279, '\p{^Block=_ Control_PICTURES}', "");
    Expect(0, 9279, '\P{Block=_ Control_PICTURES}', "");
    Expect(1, 9279, '\P{^Block=_ Control_PICTURES}', "");
    Expect(0, 9280, '\p{Block=_ Control_PICTURES}', "");
    Expect(1, 9280, '\p{^Block=_ Control_PICTURES}', "");
    Expect(1, 9280, '\P{Block=_ Control_PICTURES}', "");
    Expect(0, 9280, '\P{^Block=_ Control_PICTURES}', "");
    Error('\p{Blk= :=Control_Pictures}');
    Error('\P{Blk= :=Control_Pictures}');
    Expect(1, 9279, '\p{Blk=:\AControl_Pictures\z:}', "");;
    Expect(0, 9280, '\p{Blk=:\AControl_Pictures\z:}', "");;
    Expect(1, 9279, '\p{Blk=controlpictures}', "");
    Expect(0, 9279, '\p{^Blk=controlpictures}', "");
    Expect(0, 9279, '\P{Blk=controlpictures}', "");
    Expect(1, 9279, '\P{^Blk=controlpictures}', "");
    Expect(0, 9280, '\p{Blk=controlpictures}', "");
    Expect(1, 9280, '\p{^Blk=controlpictures}', "");
    Expect(1, 9280, '\P{Blk=controlpictures}', "");
    Expect(0, 9280, '\P{^Blk=controlpictures}', "");
    Expect(1, 9279, '\p{Blk=:\Acontrolpictures\z:}', "");;
    Expect(0, 9280, '\p{Blk=:\Acontrolpictures\z:}', "");;
    Expect(1, 9279, '\p{Blk=  Control_Pictures}', "");
    Expect(0, 9279, '\p{^Blk=  Control_Pictures}', "");
    Expect(0, 9279, '\P{Blk=  Control_Pictures}', "");
    Expect(1, 9279, '\P{^Blk=  Control_Pictures}', "");
    Expect(0, 9280, '\p{Blk=  Control_Pictures}', "");
    Expect(1, 9280, '\p{^Blk=  Control_Pictures}', "");
    Expect(1, 9280, '\P{Blk=  Control_Pictures}', "");
    Expect(0, 9280, '\P{^Blk=  Control_Pictures}', "");
    Error('\p{Is_Block:   _-Control_pictures:=}');
    Error('\P{Is_Block:   _-Control_pictures:=}');
    Expect(1, 9279, '\p{Is_Block=controlpictures}', "");
    Expect(0, 9279, '\p{^Is_Block=controlpictures}', "");
    Expect(0, 9279, '\P{Is_Block=controlpictures}', "");
    Expect(1, 9279, '\P{^Is_Block=controlpictures}', "");
    Expect(0, 9280, '\p{Is_Block=controlpictures}', "");
    Expect(1, 9280, '\p{^Is_Block=controlpictures}', "");
    Expect(1, 9280, '\P{Is_Block=controlpictures}', "");
    Expect(0, 9280, '\P{^Is_Block=controlpictures}', "");
    Expect(1, 9279, '\p{Is_Block=	_Control_Pictures}', "");
    Expect(0, 9279, '\p{^Is_Block=	_Control_Pictures}', "");
    Expect(0, 9279, '\P{Is_Block=	_Control_Pictures}', "");
    Expect(1, 9279, '\P{^Is_Block=	_Control_Pictures}', "");
    Expect(0, 9280, '\p{Is_Block=	_Control_Pictures}', "");
    Expect(1, 9280, '\p{^Is_Block=	_Control_Pictures}', "");
    Expect(1, 9280, '\P{Is_Block=	_Control_Pictures}', "");
    Expect(0, 9280, '\P{^Is_Block=	_Control_Pictures}', "");
    Error('\p{Is_Blk:   /a/ Control_PICTURES}');
    Error('\P{Is_Blk:   /a/ Control_PICTURES}');
    Expect(1, 9279, '\p{Is_Blk=controlpictures}', "");
    Expect(0, 9279, '\p{^Is_Blk=controlpictures}', "");
    Expect(0, 9279, '\P{Is_Blk=controlpictures}', "");
    Expect(1, 9279, '\P{^Is_Blk=controlpictures}', "");
    Expect(0, 9280, '\p{Is_Blk=controlpictures}', "");
    Expect(1, 9280, '\p{^Is_Blk=controlpictures}', "");
    Expect(1, 9280, '\P{Is_Blk=controlpictures}', "");
    Expect(0, 9280, '\P{^Is_Blk=controlpictures}', "");
    Expect(1, 9279, '\p{Is_Blk=_Control_pictures}', "");
    Expect(0, 9279, '\p{^Is_Blk=_Control_pictures}', "");
    Expect(0, 9279, '\P{Is_Blk=_Control_pictures}', "");
    Expect(1, 9279, '\P{^Is_Blk=_Control_pictures}', "");
    Expect(0, 9280, '\p{Is_Blk=_Control_pictures}', "");
    Expect(1, 9280, '\p{^Is_Blk=_Control_pictures}', "");
    Expect(1, 9280, '\P{Is_Blk=_Control_pictures}', "");
    Expect(0, 9280, '\P{^Is_Blk=_Control_pictures}', "");
    Error('\p{Block=:= -Coptic}');
    Error('\P{Block=:= -Coptic}');
    Expect(1, 11519, '\p{Block=:\ACoptic\z:}', "");;
    Expect(0, 11520, '\p{Block=:\ACoptic\z:}', "");;
    Expect(1, 11519, '\p{Block=coptic}', "");
    Expect(0, 11519, '\p{^Block=coptic}', "");
    Expect(0, 11519, '\P{Block=coptic}', "");
    Expect(1, 11519, '\P{^Block=coptic}', "");
    Expect(0, 11520, '\p{Block=coptic}', "");
    Expect(1, 11520, '\p{^Block=coptic}', "");
    Expect(1, 11520, '\P{Block=coptic}', "");
    Expect(0, 11520, '\P{^Block=coptic}', "");
    Expect(1, 11519, '\p{Block=:\Acoptic\z:}', "");;
    Expect(0, 11520, '\p{Block=:\Acoptic\z:}', "");;
    Expect(1, 11519, '\p{Block=-_Coptic}', "");
    Expect(0, 11519, '\p{^Block=-_Coptic}', "");
    Expect(0, 11519, '\P{Block=-_Coptic}', "");
    Expect(1, 11519, '\P{^Block=-_Coptic}', "");
    Expect(0, 11520, '\p{Block=-_Coptic}', "");
    Expect(1, 11520, '\p{^Block=-_Coptic}', "");
    Expect(1, 11520, '\P{Block=-_Coptic}', "");
    Expect(0, 11520, '\P{^Block=-_Coptic}', "");
    Error('\p{Blk=/a/Coptic}');
    Error('\P{Blk=/a/Coptic}');
    Expect(1, 11519, '\p{Blk=:\ACoptic\z:}', "");;
    Expect(0, 11520, '\p{Blk=:\ACoptic\z:}', "");;
    Expect(1, 11519, '\p{Blk=coptic}', "");
    Expect(0, 11519, '\p{^Blk=coptic}', "");
    Expect(0, 11519, '\P{Blk=coptic}', "");
    Expect(1, 11519, '\P{^Blk=coptic}', "");
    Expect(0, 11520, '\p{Blk=coptic}', "");
    Expect(1, 11520, '\p{^Blk=coptic}', "");
    Expect(1, 11520, '\P{Blk=coptic}', "");
    Expect(0, 11520, '\P{^Blk=coptic}', "");
    Expect(1, 11519, '\p{Blk=:\Acoptic\z:}', "");;
    Expect(0, 11520, '\p{Blk=:\Acoptic\z:}', "");;
    Expect(1, 11519, '\p{Blk=  COPTIC}', "");
    Expect(0, 11519, '\p{^Blk=  COPTIC}', "");
    Expect(0, 11519, '\P{Blk=  COPTIC}', "");
    Expect(1, 11519, '\P{^Blk=  COPTIC}', "");
    Expect(0, 11520, '\p{Blk=  COPTIC}', "");
    Expect(1, 11520, '\p{^Blk=  COPTIC}', "");
    Expect(1, 11520, '\P{Blk=  COPTIC}', "");
    Expect(0, 11520, '\P{^Blk=  COPTIC}', "");
    Error('\p{Is_Block=/a/--coptic}');
    Error('\P{Is_Block=/a/--coptic}');
    Expect(1, 11519, '\p{Is_Block=coptic}', "");
    Expect(0, 11519, '\p{^Is_Block=coptic}', "");
    Expect(0, 11519, '\P{Is_Block=coptic}', "");
    Expect(1, 11519, '\P{^Is_Block=coptic}', "");
    Expect(0, 11520, '\p{Is_Block=coptic}', "");
    Expect(1, 11520, '\p{^Is_Block=coptic}', "");
    Expect(1, 11520, '\P{Is_Block=coptic}', "");
    Expect(0, 11520, '\P{^Is_Block=coptic}', "");
    Expect(1, 11519, '\p{Is_Block=- Coptic}', "");
    Expect(0, 11519, '\p{^Is_Block=- Coptic}', "");
    Expect(0, 11519, '\P{Is_Block=- Coptic}', "");
    Expect(1, 11519, '\P{^Is_Block=- Coptic}', "");
    Expect(0, 11520, '\p{Is_Block=- Coptic}', "");
    Expect(1, 11520, '\p{^Is_Block=- Coptic}', "");
    Expect(1, 11520, '\P{Is_Block=- Coptic}', "");
    Expect(0, 11520, '\P{^Is_Block=- Coptic}', "");
    Error('\p{Is_Blk=:=_	Coptic}');
    Error('\P{Is_Blk=:=_	Coptic}');
    Expect(1, 11519, '\p{Is_Blk=coptic}', "");
    Expect(0, 11519, '\p{^Is_Blk=coptic}', "");
    Expect(0, 11519, '\P{Is_Blk=coptic}', "");
    Expect(1, 11519, '\P{^Is_Blk=coptic}', "");
    Expect(0, 11520, '\p{Is_Blk=coptic}', "");
    Expect(1, 11520, '\p{^Is_Blk=coptic}', "");
    Expect(1, 11520, '\P{Is_Blk=coptic}', "");
    Expect(0, 11520, '\P{^Is_Blk=coptic}', "");
    Expect(1, 11519, '\p{Is_Blk=_COPTIC}', "");
    Expect(0, 11519, '\p{^Is_Blk=_COPTIC}', "");
    Expect(0, 11519, '\P{Is_Blk=_COPTIC}', "");
    Expect(1, 11519, '\P{^Is_Blk=_COPTIC}', "");
    Expect(0, 11520, '\p{Is_Blk=_COPTIC}', "");
    Expect(1, 11520, '\p{^Is_Blk=_COPTIC}', "");
    Expect(1, 11520, '\P{Is_Blk=_COPTIC}', "");
    Expect(0, 11520, '\P{^Is_Blk=_COPTIC}', "");
    Error('\p{Block=/a/	coptic_epact_NUMBERS}');
    Error('\P{Block=/a/	coptic_epact_NUMBERS}');
    Expect(1, 66303, '\p{Block=:\ACoptic_Epact_Numbers\z:}', "");;
    Expect(0, 66304, '\p{Block=:\ACoptic_Epact_Numbers\z:}', "");;
    Expect(1, 66303, '\p{Block=copticepactnumbers}', "");
    Expect(0, 66303, '\p{^Block=copticepactnumbers}', "");
    Expect(0, 66303, '\P{Block=copticepactnumbers}', "");
    Expect(1, 66303, '\P{^Block=copticepactnumbers}', "");
    Expect(0, 66304, '\p{Block=copticepactnumbers}', "");
    Expect(1, 66304, '\p{^Block=copticepactnumbers}', "");
    Expect(1, 66304, '\P{Block=copticepactnumbers}', "");
    Expect(0, 66304, '\P{^Block=copticepactnumbers}', "");
    Expect(1, 66303, '\p{Block=:\Acopticepactnumbers\z:}', "");;
    Expect(0, 66304, '\p{Block=:\Acopticepactnumbers\z:}', "");;
    Expect(1, 66303, '\p{Block=	coptic_Epact_NUMBERS}', "");
    Expect(0, 66303, '\p{^Block=	coptic_Epact_NUMBERS}', "");
    Expect(0, 66303, '\P{Block=	coptic_Epact_NUMBERS}', "");
    Expect(1, 66303, '\P{^Block=	coptic_Epact_NUMBERS}', "");
    Expect(0, 66304, '\p{Block=	coptic_Epact_NUMBERS}', "");
    Expect(1, 66304, '\p{^Block=	coptic_Epact_NUMBERS}', "");
    Expect(1, 66304, '\P{Block=	coptic_Epact_NUMBERS}', "");
    Expect(0, 66304, '\P{^Block=	coptic_Epact_NUMBERS}', "");
    Error('\p{Blk=/a/ COPTIC_epact_numbers}');
    Error('\P{Blk=/a/ COPTIC_epact_numbers}');
    Expect(1, 66303, '\p{Blk=:\ACoptic_Epact_Numbers\z:}', "");;
    Expect(0, 66304, '\p{Blk=:\ACoptic_Epact_Numbers\z:}', "");;
    Expect(1, 66303, '\p{Blk=copticepactnumbers}', "");
    Expect(0, 66303, '\p{^Blk=copticepactnumbers}', "");
    Expect(0, 66303, '\P{Blk=copticepactnumbers}', "");
    Expect(1, 66303, '\P{^Blk=copticepactnumbers}', "");
    Expect(0, 66304, '\p{Blk=copticepactnumbers}', "");
    Expect(1, 66304, '\p{^Blk=copticepactnumbers}', "");
    Expect(1, 66304, '\P{Blk=copticepactnumbers}', "");
    Expect(0, 66304, '\P{^Blk=copticepactnumbers}', "");
    Expect(1, 66303, '\p{Blk=:\Acopticepactnumbers\z:}', "");;
    Expect(0, 66304, '\p{Blk=:\Acopticepactnumbers\z:}', "");;
    Expect(1, 66303, '\p{Blk=-Coptic_epact_Numbers}', "");
    Expect(0, 66303, '\p{^Blk=-Coptic_epact_Numbers}', "");
    Expect(0, 66303, '\P{Blk=-Coptic_epact_Numbers}', "");
    Expect(1, 66303, '\P{^Blk=-Coptic_epact_Numbers}', "");
    Expect(0, 66304, '\p{Blk=-Coptic_epact_Numbers}', "");
    Expect(1, 66304, '\p{^Blk=-Coptic_epact_Numbers}', "");
    Expect(1, 66304, '\P{Blk=-Coptic_epact_Numbers}', "");
    Expect(0, 66304, '\P{^Blk=-Coptic_epact_Numbers}', "");
    Error('\p{Is_Block=:=	 coptic_Epact_Numbers}');
    Error('\P{Is_Block=:=	 coptic_Epact_Numbers}');
    Expect(1, 66303, '\p{Is_Block=copticepactnumbers}', "");
    Expect(0, 66303, '\p{^Is_Block=copticepactnumbers}', "");
    Expect(0, 66303, '\P{Is_Block=copticepactnumbers}', "");
    Expect(1, 66303, '\P{^Is_Block=copticepactnumbers}', "");
    Expect(0, 66304, '\p{Is_Block=copticepactnumbers}', "");
    Expect(1, 66304, '\p{^Is_Block=copticepactnumbers}', "");
    Expect(1, 66304, '\P{Is_Block=copticepactnumbers}', "");
    Expect(0, 66304, '\P{^Is_Block=copticepactnumbers}', "");
    Expect(1, 66303, '\p{Is_Block: _ coptic_Epact_Numbers}', "");
    Expect(0, 66303, '\p{^Is_Block: _ coptic_Epact_Numbers}', "");
    Expect(0, 66303, '\P{Is_Block: _ coptic_Epact_Numbers}', "");
    Expect(1, 66303, '\P{^Is_Block: _ coptic_Epact_Numbers}', "");
    Expect(0, 66304, '\p{Is_Block: _ coptic_Epact_Numbers}', "");
    Expect(1, 66304, '\p{^Is_Block: _ coptic_Epact_Numbers}', "");
    Expect(1, 66304, '\P{Is_Block: _ coptic_Epact_Numbers}', "");
    Expect(0, 66304, '\P{^Is_Block: _ coptic_Epact_Numbers}', "");
    Error('\p{Is_Blk=:=-coptic_Epact_NUMBERS}');
    Error('\P{Is_Blk=:=-coptic_Epact_NUMBERS}');
    Expect(1, 66303, '\p{Is_Blk=copticepactnumbers}', "");
    Expect(0, 66303, '\p{^Is_Blk=copticepactnumbers}', "");
    Expect(0, 66303, '\P{Is_Blk=copticepactnumbers}', "");
    Expect(1, 66303, '\P{^Is_Blk=copticepactnumbers}', "");
    Expect(0, 66304, '\p{Is_Blk=copticepactnumbers}', "");
    Expect(1, 66304, '\p{^Is_Blk=copticepactnumbers}', "");
    Expect(1, 66304, '\P{Is_Blk=copticepactnumbers}', "");
    Expect(0, 66304, '\P{^Is_Blk=copticepactnumbers}', "");
    Expect(1, 66303, '\p{Is_Blk=	Coptic_Epact_Numbers}', "");
    Expect(0, 66303, '\p{^Is_Blk=	Coptic_Epact_Numbers}', "");
    Expect(0, 66303, '\P{Is_Blk=	Coptic_Epact_Numbers}', "");
    Expect(1, 66303, '\P{^Is_Blk=	Coptic_Epact_Numbers}', "");
    Expect(0, 66304, '\p{Is_Blk=	Coptic_Epact_Numbers}', "");
    Expect(1, 66304, '\p{^Is_Blk=	Coptic_Epact_Numbers}', "");
    Expect(1, 66304, '\P{Is_Blk=	Coptic_Epact_Numbers}', "");
    Expect(0, 66304, '\P{^Is_Blk=	Coptic_Epact_Numbers}', "");
    Error('\p{Block=:=- COUNTING_Rod_NUMERALS}');
    Error('\P{Block=:=- COUNTING_Rod_NUMERALS}');
    Expect(1, 119679, '\p{Block=:\ACounting_Rod_Numerals\z:}', "");;
    Expect(0, 119680, '\p{Block=:\ACounting_Rod_Numerals\z:}', "");;
    Expect(1, 119679, '\p{Block=countingrodnumerals}', "");
    Expect(0, 119679, '\p{^Block=countingrodnumerals}', "");
    Expect(0, 119679, '\P{Block=countingrodnumerals}', "");
    Expect(1, 119679, '\P{^Block=countingrodnumerals}', "");
    Expect(0, 119680, '\p{Block=countingrodnumerals}', "");
    Expect(1, 119680, '\p{^Block=countingrodnumerals}', "");
    Expect(1, 119680, '\P{Block=countingrodnumerals}', "");
    Expect(0, 119680, '\P{^Block=countingrodnumerals}', "");
    Expect(1, 119679, '\p{Block=:\Acountingrodnumerals\z:}', "");;
    Expect(0, 119680, '\p{Block=:\Acountingrodnumerals\z:}', "");;
    Expect(1, 119679, '\p{Block=	-counting_ROD_NUMERALS}', "");
    Expect(0, 119679, '\p{^Block=	-counting_ROD_NUMERALS}', "");
    Expect(0, 119679, '\P{Block=	-counting_ROD_NUMERALS}', "");
    Expect(1, 119679, '\P{^Block=	-counting_ROD_NUMERALS}', "");
    Expect(0, 119680, '\p{Block=	-counting_ROD_NUMERALS}', "");
    Expect(1, 119680, '\p{^Block=	-counting_ROD_NUMERALS}', "");
    Expect(1, 119680, '\P{Block=	-counting_ROD_NUMERALS}', "");
    Expect(0, 119680, '\P{^Block=	-counting_ROD_NUMERALS}', "");
    Error('\p{Blk: -:=counting_rod}');
    Error('\P{Blk: -:=counting_rod}');
    Expect(1, 119679, '\p{Blk=:\ACounting_Rod\z:}', "");;
    Expect(0, 119680, '\p{Blk=:\ACounting_Rod\z:}', "");;
    Expect(1, 119679, '\p{Blk=countingrod}', "");
    Expect(0, 119679, '\p{^Blk=countingrod}', "");
    Expect(0, 119679, '\P{Blk=countingrod}', "");
    Expect(1, 119679, '\P{^Blk=countingrod}', "");
    Expect(0, 119680, '\p{Blk=countingrod}', "");
    Expect(1, 119680, '\p{^Blk=countingrod}', "");
    Expect(1, 119680, '\P{Blk=countingrod}', "");
    Expect(0, 119680, '\P{^Blk=countingrod}', "");
    Expect(1, 119679, '\p{Blk=:\Acountingrod\z:}', "");;
    Expect(0, 119680, '\p{Blk=:\Acountingrod\z:}', "");;
    Expect(1, 119679, '\p{Blk=__Counting_ROD}', "");
    Expect(0, 119679, '\p{^Blk=__Counting_ROD}', "");
    Expect(0, 119679, '\P{Blk=__Counting_ROD}', "");
    Expect(1, 119679, '\P{^Blk=__Counting_ROD}', "");
    Expect(0, 119680, '\p{Blk=__Counting_ROD}', "");
    Expect(1, 119680, '\p{^Blk=__Counting_ROD}', "");
    Expect(1, 119680, '\P{Blk=__Counting_ROD}', "");
    Expect(0, 119680, '\P{^Blk=__Counting_ROD}', "");
    Error('\p{Is_Block=	/a/Counting_Rod_numerals}');
    Error('\P{Is_Block=	/a/Counting_Rod_numerals}');
    Expect(1, 119679, '\p{Is_Block=countingrodnumerals}', "");
    Expect(0, 119679, '\p{^Is_Block=countingrodnumerals}', "");
    Expect(0, 119679, '\P{Is_Block=countingrodnumerals}', "");
    Expect(1, 119679, '\P{^Is_Block=countingrodnumerals}', "");
    Expect(0, 119680, '\p{Is_Block=countingrodnumerals}', "");
    Expect(1, 119680, '\p{^Is_Block=countingrodnumerals}', "");
    Expect(1, 119680, '\P{Is_Block=countingrodnumerals}', "");
    Expect(0, 119680, '\P{^Is_Block=countingrodnumerals}', "");
    Expect(1, 119679, '\p{Is_Block=		Counting_ROD_NUMERALS}', "");
    Expect(0, 119679, '\p{^Is_Block=		Counting_ROD_NUMERALS}', "");
    Expect(0, 119679, '\P{Is_Block=		Counting_ROD_NUMERALS}', "");
    Expect(1, 119679, '\P{^Is_Block=		Counting_ROD_NUMERALS}', "");
    Expect(0, 119680, '\p{Is_Block=		Counting_ROD_NUMERALS}', "");
    Expect(1, 119680, '\p{^Is_Block=		Counting_ROD_NUMERALS}', "");
    Expect(1, 119680, '\P{Is_Block=		Counting_ROD_NUMERALS}', "");
    Expect(0, 119680, '\P{^Is_Block=		Counting_ROD_NUMERALS}', "");
    Error('\p{Is_Blk= counting_Rod/a/}');
    Error('\P{Is_Blk= counting_Rod/a/}');
    Expect(1, 119679, '\p{Is_Blk=countingrod}', "");
    Expect(0, 119679, '\p{^Is_Blk=countingrod}', "");
    Expect(0, 119679, '\P{Is_Blk=countingrod}', "");
    Expect(1, 119679, '\P{^Is_Blk=countingrod}', "");
    Expect(0, 119680, '\p{Is_Blk=countingrod}', "");
    Expect(1, 119680, '\p{^Is_Blk=countingrod}', "");
    Expect(1, 119680, '\P{Is_Blk=countingrod}', "");
    Expect(0, 119680, '\P{^Is_Blk=countingrod}', "");
    Expect(1, 119679, '\p{Is_Blk=_counting_Rod}', "");
    Expect(0, 119679, '\p{^Is_Blk=_counting_Rod}', "");
    Expect(0, 119679, '\P{Is_Blk=_counting_Rod}', "");
    Expect(1, 119679, '\P{^Is_Blk=_counting_Rod}', "");
    Expect(0, 119680, '\p{Is_Blk=_counting_Rod}', "");
    Expect(1, 119680, '\p{^Is_Blk=_counting_Rod}', "");
    Expect(1, 119680, '\P{Is_Blk=_counting_Rod}', "");
    Expect(0, 119680, '\P{^Is_Blk=_counting_Rod}', "");
    Error('\p{Block= :=Cuneiform}');
    Error('\P{Block= :=Cuneiform}');
    Expect(1, 74751, '\p{Block=:\ACuneiform\z:}', "");;
    Expect(0, 74752, '\p{Block=:\ACuneiform\z:}', "");;
    Expect(1, 74751, '\p{Block=cuneiform}', "");
    Expect(0, 74751, '\p{^Block=cuneiform}', "");
    Expect(0, 74751, '\P{Block=cuneiform}', "");
    Expect(1, 74751, '\P{^Block=cuneiform}', "");
    Expect(0, 74752, '\p{Block=cuneiform}', "");
    Expect(1, 74752, '\p{^Block=cuneiform}', "");
    Expect(1, 74752, '\P{Block=cuneiform}', "");
    Expect(0, 74752, '\P{^Block=cuneiform}', "");
    Expect(1, 74751, '\p{Block=:\Acuneiform\z:}', "");;
    Expect(0, 74752, '\p{Block=:\Acuneiform\z:}', "");;
    Expect(1, 74751, '\p{Block=		Cuneiform}', "");
    Expect(0, 74751, '\p{^Block=		Cuneiform}', "");
    Expect(0, 74751, '\P{Block=		Cuneiform}', "");
    Expect(1, 74751, '\P{^Block=		Cuneiform}', "");
    Expect(0, 74752, '\p{Block=		Cuneiform}', "");
    Expect(1, 74752, '\p{^Block=		Cuneiform}', "");
    Expect(1, 74752, '\P{Block=		Cuneiform}', "");
    Expect(0, 74752, '\P{^Block=		Cuneiform}', "");
    Error('\p{Blk=-:=Cuneiform}');
    Error('\P{Blk=-:=Cuneiform}');
    Expect(1, 74751, '\p{Blk=:\ACuneiform\z:}', "");;
    Expect(0, 74752, '\p{Blk=:\ACuneiform\z:}', "");;
    Expect(1, 74751, '\p{Blk=cuneiform}', "");
    Expect(0, 74751, '\p{^Blk=cuneiform}', "");
    Expect(0, 74751, '\P{Blk=cuneiform}', "");
    Expect(1, 74751, '\P{^Blk=cuneiform}', "");
    Expect(0, 74752, '\p{Blk=cuneiform}', "");
    Expect(1, 74752, '\p{^Blk=cuneiform}', "");
    Expect(1, 74752, '\P{Blk=cuneiform}', "");
    Expect(0, 74752, '\P{^Blk=cuneiform}', "");
    Expect(1, 74751, '\p{Blk=:\Acuneiform\z:}', "");;
    Expect(0, 74752, '\p{Blk=:\Acuneiform\z:}', "");;
    Expect(1, 74751, '\p{Blk=-Cuneiform}', "");
    Expect(0, 74751, '\p{^Blk=-Cuneiform}', "");
    Expect(0, 74751, '\P{Blk=-Cuneiform}', "");
    Expect(1, 74751, '\P{^Blk=-Cuneiform}', "");
    Expect(0, 74752, '\p{Blk=-Cuneiform}', "");
    Expect(1, 74752, '\p{^Blk=-Cuneiform}', "");
    Expect(1, 74752, '\P{Blk=-Cuneiform}', "");
    Expect(0, 74752, '\P{^Blk=-Cuneiform}', "");
    Error('\p{Is_Block= _cuneiform/a/}');
    Error('\P{Is_Block= _cuneiform/a/}');
    Expect(1, 74751, '\p{Is_Block=cuneiform}', "");
    Expect(0, 74751, '\p{^Is_Block=cuneiform}', "");
    Expect(0, 74751, '\P{Is_Block=cuneiform}', "");
    Expect(1, 74751, '\P{^Is_Block=cuneiform}', "");
    Expect(0, 74752, '\p{Is_Block=cuneiform}', "");
    Expect(1, 74752, '\p{^Is_Block=cuneiform}', "");
    Expect(1, 74752, '\P{Is_Block=cuneiform}', "");
    Expect(0, 74752, '\P{^Is_Block=cuneiform}', "");
    Expect(1, 74751, '\p{Is_Block= -Cuneiform}', "");
    Expect(0, 74751, '\p{^Is_Block= -Cuneiform}', "");
    Expect(0, 74751, '\P{Is_Block= -Cuneiform}', "");
    Expect(1, 74751, '\P{^Is_Block= -Cuneiform}', "");
    Expect(0, 74752, '\p{Is_Block= -Cuneiform}', "");
    Expect(1, 74752, '\p{^Is_Block= -Cuneiform}', "");
    Expect(1, 74752, '\P{Is_Block= -Cuneiform}', "");
    Expect(0, 74752, '\P{^Is_Block= -Cuneiform}', "");
    Error('\p{Is_Blk=/a/-cuneiform}');
    Error('\P{Is_Blk=/a/-cuneiform}');
    Expect(1, 74751, '\p{Is_Blk=cuneiform}', "");
    Expect(0, 74751, '\p{^Is_Blk=cuneiform}', "");
    Expect(0, 74751, '\P{Is_Blk=cuneiform}', "");
    Expect(1, 74751, '\P{^Is_Blk=cuneiform}', "");
    Expect(0, 74752, '\p{Is_Blk=cuneiform}', "");
    Expect(1, 74752, '\p{^Is_Blk=cuneiform}', "");
    Expect(1, 74752, '\P{Is_Blk=cuneiform}', "");
    Expect(0, 74752, '\P{^Is_Blk=cuneiform}', "");
    Expect(1, 74751, '\p{Is_Blk=_-cuneiform}', "");
    Expect(0, 74751, '\p{^Is_Blk=_-cuneiform}', "");
    Expect(0, 74751, '\P{Is_Blk=_-cuneiform}', "");
    Expect(1, 74751, '\P{^Is_Blk=_-cuneiform}', "");
    Expect(0, 74752, '\p{Is_Blk=_-cuneiform}', "");
    Expect(1, 74752, '\p{^Is_Blk=_-cuneiform}', "");
    Expect(1, 74752, '\P{Is_Blk=_-cuneiform}', "");
    Expect(0, 74752, '\P{^Is_Blk=_-cuneiform}', "");
    Error('\p{Block= _cuneiform_NUMBERS_and_Punctuation/a/}');
    Error('\P{Block= _cuneiform_NUMBERS_and_Punctuation/a/}');
    Expect(1, 74879, '\p{Block=:\ACuneiform_Numbers_And_Punctuation\z:}', "");;
    Expect(0, 74880, '\p{Block=:\ACuneiform_Numbers_And_Punctuation\z:}', "");;
    Expect(1, 74879, '\p{Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74879, '\p{^Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74879, '\P{Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74879, '\P{^Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74880, '\p{Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74880, '\p{^Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74880, '\P{Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74880, '\P{^Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74879, '\p{Block=:\Acuneiformnumbersandpunctuation\z:}', "");;
    Expect(0, 74880, '\p{Block=:\Acuneiformnumbersandpunctuation\z:}', "");;
    Expect(1, 74879, '\p{Block=	-CUNEIFORM_NUMBERS_And_Punctuation}', "");
    Expect(0, 74879, '\p{^Block=	-CUNEIFORM_NUMBERS_And_Punctuation}', "");
    Expect(0, 74879, '\P{Block=	-CUNEIFORM_NUMBERS_And_Punctuation}', "");
    Expect(1, 74879, '\P{^Block=	-CUNEIFORM_NUMBERS_And_Punctuation}', "");
    Expect(0, 74880, '\p{Block=	-CUNEIFORM_NUMBERS_And_Punctuation}', "");
    Expect(1, 74880, '\p{^Block=	-CUNEIFORM_NUMBERS_And_Punctuation}', "");
    Expect(1, 74880, '\P{Block=	-CUNEIFORM_NUMBERS_And_Punctuation}', "");
    Expect(0, 74880, '\P{^Block=	-CUNEIFORM_NUMBERS_And_Punctuation}', "");
    Error('\p{Blk:   __Cuneiform_NUMBERS/a/}');
    Error('\P{Blk:   __Cuneiform_NUMBERS/a/}');
    Expect(1, 74879, '\p{Blk=:\ACuneiform_Numbers\z:}', "");;
    Expect(0, 74880, '\p{Blk=:\ACuneiform_Numbers\z:}', "");;
    Expect(1, 74879, '\p{Blk=cuneiformnumbers}', "");
    Expect(0, 74879, '\p{^Blk=cuneiformnumbers}', "");
    Expect(0, 74879, '\P{Blk=cuneiformnumbers}', "");
    Expect(1, 74879, '\P{^Blk=cuneiformnumbers}', "");
    Expect(0, 74880, '\p{Blk=cuneiformnumbers}', "");
    Expect(1, 74880, '\p{^Blk=cuneiformnumbers}', "");
    Expect(1, 74880, '\P{Blk=cuneiformnumbers}', "");
    Expect(0, 74880, '\P{^Blk=cuneiformnumbers}', "");
    Expect(1, 74879, '\p{Blk=:\Acuneiformnumbers\z:}', "");;
    Expect(0, 74880, '\p{Blk=:\Acuneiformnumbers\z:}', "");;
    Expect(1, 74879, '\p{Blk= CUNEIFORM_Numbers}', "");
    Expect(0, 74879, '\p{^Blk= CUNEIFORM_Numbers}', "");
    Expect(0, 74879, '\P{Blk= CUNEIFORM_Numbers}', "");
    Expect(1, 74879, '\P{^Blk= CUNEIFORM_Numbers}', "");
    Expect(0, 74880, '\p{Blk= CUNEIFORM_Numbers}', "");
    Expect(1, 74880, '\p{^Blk= CUNEIFORM_Numbers}', "");
    Expect(1, 74880, '\P{Blk= CUNEIFORM_Numbers}', "");
    Expect(0, 74880, '\P{^Blk= CUNEIFORM_Numbers}', "");
    Error('\p{Is_Block=:=-_CUNEIFORM_numbers_And_Punctuation}');
    Error('\P{Is_Block=:=-_CUNEIFORM_numbers_And_Punctuation}');
    Expect(1, 74879, '\p{Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74879, '\p{^Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74879, '\P{Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74879, '\P{^Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74880, '\p{Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74880, '\p{^Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74880, '\P{Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(0, 74880, '\P{^Is_Block=cuneiformnumbersandpunctuation}', "");
    Expect(1, 74879, '\p{Is_Block=_CUNEIFORM_Numbers_And_Punctuation}', "");
    Expect(0, 74879, '\p{^Is_Block=_CUNEIFORM_Numbers_And_Punctuation}', "");
    Expect(0, 74879, '\P{Is_Block=_CUNEIFORM_Numbers_And_Punctuation}', "");
    Expect(1, 74879, '\P{^Is_Block=_CUNEIFORM_Numbers_And_Punctuation}', "");
    Expect(0, 74880, '\p{Is_Block=_CUNEIFORM_Numbers_And_Punctuation}', "");
    Expect(1, 74880, '\p{^Is_Block=_CUNEIFORM_Numbers_And_Punctuation}', "");
    Expect(1, 74880, '\P{Is_Block=_CUNEIFORM_Numbers_And_Punctuation}', "");
    Expect(0, 74880, '\P{^Is_Block=_CUNEIFORM_Numbers_And_Punctuation}', "");
    Error('\p{Is_Blk=:=-CUNEIFORM_numbers}');
    Error('\P{Is_Blk=:=-CUNEIFORM_numbers}');
    Expect(1, 74879, '\p{Is_Blk=cuneiformnumbers}', "");
    Expect(0, 74879, '\p{^Is_Blk=cuneiformnumbers}', "");
    Expect(0, 74879, '\P{Is_Blk=cuneiformnumbers}', "");
    Expect(1, 74879, '\P{^Is_Blk=cuneiformnumbers}', "");
    Expect(0, 74880, '\p{Is_Blk=cuneiformnumbers}', "");
    Expect(1, 74880, '\p{^Is_Blk=cuneiformnumbers}', "");
    Expect(1, 74880, '\P{Is_Blk=cuneiformnumbers}', "");
    Expect(0, 74880, '\P{^Is_Blk=cuneiformnumbers}', "");
    Expect(1, 74879, '\p{Is_Blk=	Cuneiform_NUMBERS}', "");
    Expect(0, 74879, '\p{^Is_Blk=	Cuneiform_NUMBERS}', "");
    Expect(0, 74879, '\P{Is_Blk=	Cuneiform_NUMBERS}', "");
    Expect(1, 74879, '\P{^Is_Blk=	Cuneiform_NUMBERS}', "");
    Expect(0, 74880, '\p{Is_Blk=	Cuneiform_NUMBERS}', "");
    Expect(1, 74880, '\p{^Is_Blk=	Cuneiform_NUMBERS}', "");
    Expect(1, 74880, '\P{Is_Blk=	Cuneiform_NUMBERS}', "");
    Expect(0, 74880, '\P{^Is_Blk=	Cuneiform_NUMBERS}', "");
    Error('\p{Block=-/a/CURRENCY_Symbols}');
    Error('\P{Block=-/a/CURRENCY_Symbols}');
    Expect(1, 8399, '\p{Block=:\ACurrency_Symbols\z:}', "");;
    Expect(0, 8400, '\p{Block=:\ACurrency_Symbols\z:}', "");;
    Expect(1, 8399, '\p{Block=currencysymbols}', "");
    Expect(0, 8399, '\p{^Block=currencysymbols}', "");
    Expect(0, 8399, '\P{Block=currencysymbols}', "");
    Expect(1, 8399, '\P{^Block=currencysymbols}', "");
    Expect(0, 8400, '\p{Block=currencysymbols}', "");
    Expect(1, 8400, '\p{^Block=currencysymbols}', "");
    Expect(1, 8400, '\P{Block=currencysymbols}', "");
    Expect(0, 8400, '\P{^Block=currencysymbols}', "");
    Expect(1, 8399, '\p{Block=:\Acurrencysymbols\z:}', "");;
    Expect(0, 8400, '\p{Block=:\Acurrencysymbols\z:}', "");;
    Expect(1, 8399, '\p{Block=	-Currency_symbols}', "");
    Expect(0, 8399, '\p{^Block=	-Currency_symbols}', "");
    Expect(0, 8399, '\P{Block=	-Currency_symbols}', "");
    Expect(1, 8399, '\P{^Block=	-Currency_symbols}', "");
    Expect(0, 8400, '\p{Block=	-Currency_symbols}', "");
    Expect(1, 8400, '\p{^Block=	-Currency_symbols}', "");
    Expect(1, 8400, '\P{Block=	-Currency_symbols}', "");
    Expect(0, 8400, '\P{^Block=	-Currency_symbols}', "");
    Error('\p{Blk=__CURRENCY_SYMBOLS/a/}');
    Error('\P{Blk=__CURRENCY_SYMBOLS/a/}');
    Expect(1, 8399, '\p{Blk=:\ACurrency_Symbols\z:}', "");;
    Expect(0, 8400, '\p{Blk=:\ACurrency_Symbols\z:}', "");;
    Expect(1, 8399, '\p{Blk=currencysymbols}', "");
    Expect(0, 8399, '\p{^Blk=currencysymbols}', "");
    Expect(0, 8399, '\P{Blk=currencysymbols}', "");
    Expect(1, 8399, '\P{^Blk=currencysymbols}', "");
    Expect(0, 8400, '\p{Blk=currencysymbols}', "");
    Expect(1, 8400, '\p{^Blk=currencysymbols}', "");
    Expect(1, 8400, '\P{Blk=currencysymbols}', "");
    Expect(0, 8400, '\P{^Blk=currencysymbols}', "");
    Expect(1, 8399, '\p{Blk=:\Acurrencysymbols\z:}', "");;
    Expect(0, 8400, '\p{Blk=:\Acurrencysymbols\z:}', "");;
    Expect(1, 8399, '\p{Blk=_ Currency_symbols}', "");
    Expect(0, 8399, '\p{^Blk=_ Currency_symbols}', "");
    Expect(0, 8399, '\P{Blk=_ Currency_symbols}', "");
    Expect(1, 8399, '\P{^Blk=_ Currency_symbols}', "");
    Expect(0, 8400, '\p{Blk=_ Currency_symbols}', "");
    Expect(1, 8400, '\p{^Blk=_ Currency_symbols}', "");
    Expect(1, 8400, '\P{Blk=_ Currency_symbols}', "");
    Expect(0, 8400, '\P{^Blk=_ Currency_symbols}', "");
    Error('\p{Is_Block: CURRENCY_SYMBOLS/a/}');
    Error('\P{Is_Block: CURRENCY_SYMBOLS/a/}');
    Expect(1, 8399, '\p{Is_Block=currencysymbols}', "");
    Expect(0, 8399, '\p{^Is_Block=currencysymbols}', "");
    Expect(0, 8399, '\P{Is_Block=currencysymbols}', "");
    Expect(1, 8399, '\P{^Is_Block=currencysymbols}', "");
    Expect(0, 8400, '\p{Is_Block=currencysymbols}', "");
    Expect(1, 8400, '\p{^Is_Block=currencysymbols}', "");
    Expect(1, 8400, '\P{Is_Block=currencysymbols}', "");
    Expect(0, 8400, '\P{^Is_Block=currencysymbols}', "");
    Expect(1, 8399, '\p{Is_Block=_Currency_Symbols}', "");
    Expect(0, 8399, '\p{^Is_Block=_Currency_Symbols}', "");
    Expect(0, 8399, '\P{Is_Block=_Currency_Symbols}', "");
    Expect(1, 8399, '\P{^Is_Block=_Currency_Symbols}', "");
    Expect(0, 8400, '\p{Is_Block=_Currency_Symbols}', "");
    Expect(1, 8400, '\p{^Is_Block=_Currency_Symbols}', "");
    Expect(1, 8400, '\P{Is_Block=_Currency_Symbols}', "");
    Expect(0, 8400, '\P{^Is_Block=_Currency_Symbols}', "");
    Error('\p{Is_Blk=/a/-currency_Symbols}');
    Error('\P{Is_Blk=/a/-currency_Symbols}');
    Expect(1, 8399, '\p{Is_Blk=currencysymbols}', "");
    Expect(0, 8399, '\p{^Is_Blk=currencysymbols}', "");
    Expect(0, 8399, '\P{Is_Blk=currencysymbols}', "");
    Expect(1, 8399, '\P{^Is_Blk=currencysymbols}', "");
    Expect(0, 8400, '\p{Is_Blk=currencysymbols}', "");
    Expect(1, 8400, '\p{^Is_Blk=currencysymbols}', "");
    Expect(1, 8400, '\P{Is_Blk=currencysymbols}', "");
    Expect(0, 8400, '\P{^Is_Blk=currencysymbols}', "");
    Expect(1, 8399, '\p{Is_Blk=	-CURRENCY_Symbols}', "");
    Expect(0, 8399, '\p{^Is_Blk=	-CURRENCY_Symbols}', "");
    Expect(0, 8399, '\P{Is_Blk=	-CURRENCY_Symbols}', "");
    Expect(1, 8399, '\P{^Is_Blk=	-CURRENCY_Symbols}', "");
    Expect(0, 8400, '\p{Is_Blk=	-CURRENCY_Symbols}', "");
    Expect(1, 8400, '\p{^Is_Blk=	-CURRENCY_Symbols}', "");
    Expect(1, 8400, '\P{Is_Blk=	-CURRENCY_Symbols}', "");
    Expect(0, 8400, '\P{^Is_Blk=	-CURRENCY_Symbols}', "");
    Error('\p{Block:   :=_cypriot_syllabary}');
    Error('\P{Block:   :=_cypriot_syllabary}');
    Expect(1, 67647, '\p{Block=:\ACypriot_Syllabary\z:}', "");;
    Expect(0, 67648, '\p{Block=:\ACypriot_Syllabary\z:}', "");;
    Expect(1, 67647, '\p{Block=cypriotsyllabary}', "");
    Expect(0, 67647, '\p{^Block=cypriotsyllabary}', "");
    Expect(0, 67647, '\P{Block=cypriotsyllabary}', "");
    Expect(1, 67647, '\P{^Block=cypriotsyllabary}', "");
    Expect(0, 67648, '\p{Block=cypriotsyllabary}', "");
    Expect(1, 67648, '\p{^Block=cypriotsyllabary}', "");
    Expect(1, 67648, '\P{Block=cypriotsyllabary}', "");
    Expect(0, 67648, '\P{^Block=cypriotsyllabary}', "");
    Expect(1, 67647, '\p{Block=:\Acypriotsyllabary\z:}', "");;
    Expect(0, 67648, '\p{Block=:\Acypriotsyllabary\z:}', "");;
    Expect(1, 67647, '\p{Block=--cypriot_SYLLABARY}', "");
    Expect(0, 67647, '\p{^Block=--cypriot_SYLLABARY}', "");
    Expect(0, 67647, '\P{Block=--cypriot_SYLLABARY}', "");
    Expect(1, 67647, '\P{^Block=--cypriot_SYLLABARY}', "");
    Expect(0, 67648, '\p{Block=--cypriot_SYLLABARY}', "");
    Expect(1, 67648, '\p{^Block=--cypriot_SYLLABARY}', "");
    Expect(1, 67648, '\P{Block=--cypriot_SYLLABARY}', "");
    Expect(0, 67648, '\P{^Block=--cypriot_SYLLABARY}', "");
    Error('\p{Blk:-:=Cypriot_Syllabary}');
    Error('\P{Blk:-:=Cypriot_Syllabary}');
    Expect(1, 67647, '\p{Blk=:\ACypriot_Syllabary\z:}', "");;
    Expect(0, 67648, '\p{Blk=:\ACypriot_Syllabary\z:}', "");;
    Expect(1, 67647, '\p{Blk=cypriotsyllabary}', "");
    Expect(0, 67647, '\p{^Blk=cypriotsyllabary}', "");
    Expect(0, 67647, '\P{Blk=cypriotsyllabary}', "");
    Expect(1, 67647, '\P{^Blk=cypriotsyllabary}', "");
    Expect(0, 67648, '\p{Blk=cypriotsyllabary}', "");
    Expect(1, 67648, '\p{^Blk=cypriotsyllabary}', "");
    Expect(1, 67648, '\P{Blk=cypriotsyllabary}', "");
    Expect(0, 67648, '\P{^Blk=cypriotsyllabary}', "");
    Expect(1, 67647, '\p{Blk=:\Acypriotsyllabary\z:}', "");;
    Expect(0, 67648, '\p{Blk=:\Acypriotsyllabary\z:}', "");;
    Expect(1, 67647, '\p{Blk= _CYPRIOT_Syllabary}', "");
    Expect(0, 67647, '\p{^Blk= _CYPRIOT_Syllabary}', "");
    Expect(0, 67647, '\P{Blk= _CYPRIOT_Syllabary}', "");
    Expect(1, 67647, '\P{^Blk= _CYPRIOT_Syllabary}', "");
    Expect(0, 67648, '\p{Blk= _CYPRIOT_Syllabary}', "");
    Expect(1, 67648, '\p{^Blk= _CYPRIOT_Syllabary}', "");
    Expect(1, 67648, '\P{Blk= _CYPRIOT_Syllabary}', "");
    Expect(0, 67648, '\P{^Blk= _CYPRIOT_Syllabary}', "");
    Error('\p{Is_Block: Cypriot_syllabary:=}');
    Error('\P{Is_Block: Cypriot_syllabary:=}');
    Expect(1, 67647, '\p{Is_Block=cypriotsyllabary}', "");
    Expect(0, 67647, '\p{^Is_Block=cypriotsyllabary}', "");
    Expect(0, 67647, '\P{Is_Block=cypriotsyllabary}', "");
    Expect(1, 67647, '\P{^Is_Block=cypriotsyllabary}', "");
    Expect(0, 67648, '\p{Is_Block=cypriotsyllabary}', "");
    Expect(1, 67648, '\p{^Is_Block=cypriotsyllabary}', "");
    Expect(1, 67648, '\P{Is_Block=cypriotsyllabary}', "");
    Expect(0, 67648, '\P{^Is_Block=cypriotsyllabary}', "");
    Expect(1, 67647, '\p{Is_Block: _	Cypriot_Syllabary}', "");
    Expect(0, 67647, '\p{^Is_Block: _	Cypriot_Syllabary}', "");
    Expect(0, 67647, '\P{Is_Block: _	Cypriot_Syllabary}', "");
    Expect(1, 67647, '\P{^Is_Block: _	Cypriot_Syllabary}', "");
    Expect(0, 67648, '\p{Is_Block: _	Cypriot_Syllabary}', "");
    Expect(1, 67648, '\p{^Is_Block: _	Cypriot_Syllabary}', "");
    Expect(1, 67648, '\P{Is_Block: _	Cypriot_Syllabary}', "");
    Expect(0, 67648, '\P{^Is_Block: _	Cypriot_Syllabary}', "");
    Error('\p{Is_Blk=		Cypriot_Syllabary:=}');
    Error('\P{Is_Blk=		Cypriot_Syllabary:=}');
    Expect(1, 67647, '\p{Is_Blk=cypriotsyllabary}', "");
    Expect(0, 67647, '\p{^Is_Blk=cypriotsyllabary}', "");
    Expect(0, 67647, '\P{Is_Blk=cypriotsyllabary}', "");
    Expect(1, 67647, '\P{^Is_Blk=cypriotsyllabary}', "");
    Expect(0, 67648, '\p{Is_Blk=cypriotsyllabary}', "");
    Expect(1, 67648, '\p{^Is_Blk=cypriotsyllabary}', "");
    Expect(1, 67648, '\P{Is_Blk=cypriotsyllabary}', "");
    Expect(0, 67648, '\P{^Is_Blk=cypriotsyllabary}', "");
    Expect(1, 67647, '\p{Is_Blk= CYPRIOT_SYLLABARY}', "");
    Expect(0, 67647, '\p{^Is_Blk= CYPRIOT_SYLLABARY}', "");
    Expect(0, 67647, '\P{Is_Blk= CYPRIOT_SYLLABARY}', "");
    Expect(1, 67647, '\P{^Is_Blk= CYPRIOT_SYLLABARY}', "");
    Expect(0, 67648, '\p{Is_Blk= CYPRIOT_SYLLABARY}', "");
    Expect(1, 67648, '\p{^Is_Blk= CYPRIOT_SYLLABARY}', "");
    Expect(1, 67648, '\P{Is_Blk= CYPRIOT_SYLLABARY}', "");
    Expect(0, 67648, '\P{^Is_Blk= CYPRIOT_SYLLABARY}', "");
    Error('\p{Block=/a/-Cypro_Minoan}');
    Error('\P{Block=/a/-Cypro_Minoan}');
    Expect(1, 77823, '\p{Block=:\ACypro_Minoan\z:}', "");;
    Expect(0, 77824, '\p{Block=:\ACypro_Minoan\z:}', "");;
    Expect(1, 77823, '\p{Block=cyprominoan}', "");
    Expect(0, 77823, '\p{^Block=cyprominoan}', "");
    Expect(0, 77823, '\P{Block=cyprominoan}', "");
    Expect(1, 77823, '\P{^Block=cyprominoan}', "");
    Expect(0, 77824, '\p{Block=cyprominoan}', "");
    Expect(1, 77824, '\p{^Block=cyprominoan}', "");
    Expect(1, 77824, '\P{Block=cyprominoan}', "");
    Expect(0, 77824, '\P{^Block=cyprominoan}', "");
    Expect(1, 77823, '\p{Block=:\Acyprominoan\z:}', "");;
    Expect(0, 77824, '\p{Block=:\Acyprominoan\z:}', "");;
    Expect(1, 77823, '\p{Block=-_cypro_Minoan}', "");
    Expect(0, 77823, '\p{^Block=-_cypro_Minoan}', "");
    Expect(0, 77823, '\P{Block=-_cypro_Minoan}', "");
    Expect(1, 77823, '\P{^Block=-_cypro_Minoan}', "");
    Expect(0, 77824, '\p{Block=-_cypro_Minoan}', "");
    Expect(1, 77824, '\p{^Block=-_cypro_Minoan}', "");
    Expect(1, 77824, '\P{Block=-_cypro_Minoan}', "");
    Expect(0, 77824, '\P{^Block=-_cypro_Minoan}', "");
    Error('\p{Blk=cypro_minoan/a/}');
    Error('\P{Blk=cypro_minoan/a/}');
    Expect(1, 77823, '\p{Blk=:\ACypro_Minoan\z:}', "");;
    Expect(0, 77824, '\p{Blk=:\ACypro_Minoan\z:}', "");;
    Expect(1, 77823, '\p{Blk=cyprominoan}', "");
    Expect(0, 77823, '\p{^Blk=cyprominoan}', "");
    Expect(0, 77823, '\P{Blk=cyprominoan}', "");
    Expect(1, 77823, '\P{^Blk=cyprominoan}', "");
    Expect(0, 77824, '\p{Blk=cyprominoan}', "");
    Expect(1, 77824, '\p{^Blk=cyprominoan}', "");
    Expect(1, 77824, '\P{Blk=cyprominoan}', "");
    Expect(0, 77824, '\P{^Blk=cyprominoan}', "");
    Expect(1, 77823, '\p{Blk=:\Acyprominoan\z:}', "");;
    Expect(0, 77824, '\p{Blk=:\Acyprominoan\z:}', "");;
    Expect(1, 77823, '\p{Blk= 	CYPRO_Minoan}', "");
    Expect(0, 77823, '\p{^Blk= 	CYPRO_Minoan}', "");
    Expect(0, 77823, '\P{Blk= 	CYPRO_Minoan}', "");
    Expect(1, 77823, '\P{^Blk= 	CYPRO_Minoan}', "");
    Expect(0, 77824, '\p{Blk= 	CYPRO_Minoan}', "");
    Expect(1, 77824, '\p{^Blk= 	CYPRO_Minoan}', "");
    Expect(1, 77824, '\P{Blk= 	CYPRO_Minoan}', "");
    Expect(0, 77824, '\P{^Blk= 	CYPRO_Minoan}', "");
    Error('\p{Is_Block:   __Cypro_MINOAN:=}');
    Error('\P{Is_Block:   __Cypro_MINOAN:=}');
    Expect(1, 77823, '\p{Is_Block=cyprominoan}', "");
    Expect(0, 77823, '\p{^Is_Block=cyprominoan}', "");
    Expect(0, 77823, '\P{Is_Block=cyprominoan}', "");
    Expect(1, 77823, '\P{^Is_Block=cyprominoan}', "");
    Expect(0, 77824, '\p{Is_Block=cyprominoan}', "");
    Expect(1, 77824, '\p{^Is_Block=cyprominoan}', "");
    Expect(1, 77824, '\P{Is_Block=cyprominoan}', "");
    Expect(0, 77824, '\P{^Is_Block=cyprominoan}', "");
    Expect(1, 77823, '\p{Is_Block=_CYPRO_Minoan}', "");
    Expect(0, 77823, '\p{^Is_Block=_CYPRO_Minoan}', "");
    Expect(0, 77823, '\P{Is_Block=_CYPRO_Minoan}', "");
    Expect(1, 77823, '\P{^Is_Block=_CYPRO_Minoan}', "");
    Expect(0, 77824, '\p{Is_Block=_CYPRO_Minoan}', "");
    Expect(1, 77824, '\p{^Is_Block=_CYPRO_Minoan}', "");
    Expect(1, 77824, '\P{Is_Block=_CYPRO_Minoan}', "");
    Expect(0, 77824, '\P{^Is_Block=_CYPRO_Minoan}', "");
    Error('\p{Is_Blk= 	cypro_minoan/a/}');
    Error('\P{Is_Blk= 	cypro_minoan/a/}');
    Expect(1, 77823, '\p{Is_Blk=cyprominoan}', "");
    Expect(0, 77823, '\p{^Is_Blk=cyprominoan}', "");
    Expect(0, 77823, '\P{Is_Blk=cyprominoan}', "");
    Expect(1, 77823, '\P{^Is_Blk=cyprominoan}', "");
    Expect(0, 77824, '\p{Is_Blk=cyprominoan}', "");
    Expect(1, 77824, '\p{^Is_Blk=cyprominoan}', "");
    Expect(1, 77824, '\P{Is_Blk=cyprominoan}', "");
    Expect(0, 77824, '\P{^Is_Blk=cyprominoan}', "");
    Expect(1, 77823, '\p{Is_Blk=	Cypro_Minoan}', "");
    Expect(0, 77823, '\p{^Is_Blk=	Cypro_Minoan}', "");
    Expect(0, 77823, '\P{Is_Blk=	Cypro_Minoan}', "");
    Expect(1, 77823, '\P{^Is_Blk=	Cypro_Minoan}', "");
    Expect(0, 77824, '\p{Is_Blk=	Cypro_Minoan}', "");
    Expect(1, 77824, '\p{^Is_Blk=	Cypro_Minoan}', "");
    Expect(1, 77824, '\P{Is_Blk=	Cypro_Minoan}', "");
    Expect(0, 77824, '\P{^Is_Blk=	Cypro_Minoan}', "");
    Error('\p{Block=:=_Cyrillic}');
    Error('\P{Block=:=_Cyrillic}');
    Expect(1, 1279, '\p{Block=:\ACyrillic\z:}', "");;
    Expect(0, 1280, '\p{Block=:\ACyrillic\z:}', "");;
    Expect(1, 1279, '\p{Block=cyrillic}', "");
    Expect(0, 1279, '\p{^Block=cyrillic}', "");
    Expect(0, 1279, '\P{Block=cyrillic}', "");
    Expect(1, 1279, '\P{^Block=cyrillic}', "");
    Expect(0, 1280, '\p{Block=cyrillic}', "");
    Expect(1, 1280, '\p{^Block=cyrillic}', "");
    Expect(1, 1280, '\P{Block=cyrillic}', "");
    Expect(0, 1280, '\P{^Block=cyrillic}', "");
    Expect(1, 1279, '\p{Block=:\Acyrillic\z:}', "");;
    Expect(0, 1280, '\p{Block=:\Acyrillic\z:}', "");;
    Expect(1, 1279, '\p{Block=-_Cyrillic}', "");
    Expect(0, 1279, '\p{^Block=-_Cyrillic}', "");
    Expect(0, 1279, '\P{Block=-_Cyrillic}', "");
    Expect(1, 1279, '\P{^Block=-_Cyrillic}', "");
    Expect(0, 1280, '\p{Block=-_Cyrillic}', "");
    Expect(1, 1280, '\p{^Block=-_Cyrillic}', "");
    Expect(1, 1280, '\P{Block=-_Cyrillic}', "");
    Expect(0, 1280, '\P{^Block=-_Cyrillic}', "");
    Error('\p{Blk= Cyrillic/a/}');
    Error('\P{Blk= Cyrillic/a/}');
    Expect(1, 1279, '\p{Blk=:\ACyrillic\z:}', "");;
    Expect(0, 1280, '\p{Blk=:\ACyrillic\z:}', "");;
    Expect(1, 1279, '\p{Blk:cyrillic}', "");
    Expect(0, 1279, '\p{^Blk:cyrillic}', "");
    Expect(0, 1279, '\P{Blk:cyrillic}', "");
    Expect(1, 1279, '\P{^Blk:cyrillic}', "");
    Expect(0, 1280, '\p{Blk:cyrillic}', "");
    Expect(1, 1280, '\p{^Blk:cyrillic}', "");
    Expect(1, 1280, '\P{Blk:cyrillic}', "");
    Expect(0, 1280, '\P{^Blk:cyrillic}', "");
    Expect(1, 1279, '\p{Blk=:\Acyrillic\z:}', "");;
    Expect(0, 1280, '\p{Blk=:\Acyrillic\z:}', "");;
    Expect(1, 1279, '\p{Blk=-Cyrillic}', "");
    Expect(0, 1279, '\p{^Blk=-Cyrillic}', "");
    Expect(0, 1279, '\P{Blk=-Cyrillic}', "");
    Expect(1, 1279, '\P{^Blk=-Cyrillic}', "");
    Expect(0, 1280, '\p{Blk=-Cyrillic}', "");
    Expect(1, 1280, '\p{^Blk=-Cyrillic}', "");
    Expect(1, 1280, '\P{Blk=-Cyrillic}', "");
    Expect(0, 1280, '\P{^Blk=-Cyrillic}', "");
    Error('\p{Is_Block=		Cyrillic:=}');
    Error('\P{Is_Block=		Cyrillic:=}');
    Expect(1, 1279, '\p{Is_Block=cyrillic}', "");
    Expect(0, 1279, '\p{^Is_Block=cyrillic}', "");
    Expect(0, 1279, '\P{Is_Block=cyrillic}', "");
    Expect(1, 1279, '\P{^Is_Block=cyrillic}', "");
    Expect(0, 1280, '\p{Is_Block=cyrillic}', "");
    Expect(1, 1280, '\p{^Is_Block=cyrillic}', "");
    Expect(1, 1280, '\P{Is_Block=cyrillic}', "");
    Expect(0, 1280, '\P{^Is_Block=cyrillic}', "");
    Expect(1, 1279, '\p{Is_Block=	_CYRILLIC}', "");
    Expect(0, 1279, '\p{^Is_Block=	_CYRILLIC}', "");
    Expect(0, 1279, '\P{Is_Block=	_CYRILLIC}', "");
    Expect(1, 1279, '\P{^Is_Block=	_CYRILLIC}', "");
    Expect(0, 1280, '\p{Is_Block=	_CYRILLIC}', "");
    Expect(1, 1280, '\p{^Is_Block=	_CYRILLIC}', "");
    Expect(1, 1280, '\P{Is_Block=	_CYRILLIC}', "");
    Expect(0, 1280, '\P{^Is_Block=	_CYRILLIC}', "");
    Error('\p{Is_Blk=:=-Cyrillic}');
    Error('\P{Is_Blk=:=-Cyrillic}');
    Expect(1, 1279, '\p{Is_Blk=cyrillic}', "");
    Expect(0, 1279, '\p{^Is_Blk=cyrillic}', "");
    Expect(0, 1279, '\P{Is_Blk=cyrillic}', "");
    Expect(1, 1279, '\P{^Is_Blk=cyrillic}', "");
    Expect(0, 1280, '\p{Is_Blk=cyrillic}', "");
    Expect(1, 1280, '\p{^Is_Blk=cyrillic}', "");
    Expect(1, 1280, '\P{Is_Blk=cyrillic}', "");
    Expect(0, 1280, '\P{^Is_Blk=cyrillic}', "");
    Expect(1, 1279, '\p{Is_Blk=_	Cyrillic}', "");
    Expect(0, 1279, '\p{^Is_Blk=_	Cyrillic}', "");
    Expect(0, 1279, '\P{Is_Blk=_	Cyrillic}', "");
    Expect(1, 1279, '\P{^Is_Blk=_	Cyrillic}', "");
    Expect(0, 1280, '\p{Is_Blk=_	Cyrillic}', "");
    Expect(1, 1280, '\p{^Is_Blk=_	Cyrillic}', "");
    Expect(1, 1280, '\P{Is_Blk=_	Cyrillic}', "");
    Expect(0, 1280, '\P{^Is_Blk=_	Cyrillic}', "");
    Error('\p{Block= /a/Cyrillic_Extended_A}');
    Error('\P{Block= /a/Cyrillic_Extended_A}');
    Expect(1, 11775, '\p{Block=:\ACyrillic_Extended_A\z:}', "");;
    Expect(0, 11776, '\p{Block=:\ACyrillic_Extended_A\z:}', "");;
    Expect(1, 11775, '\p{Block=cyrillicextendeda}', "");
    Expect(0, 11775, '\p{^Block=cyrillicextendeda}', "");
    Expect(0, 11775, '\P{Block=cyrillicextendeda}', "");
    Expect(1, 11775, '\P{^Block=cyrillicextendeda}', "");
    Expect(0, 11776, '\p{Block=cyrillicextendeda}', "");
    Expect(1, 11776, '\p{^Block=cyrillicextendeda}', "");
    Expect(1, 11776, '\P{Block=cyrillicextendeda}', "");
    Expect(0, 11776, '\P{^Block=cyrillicextendeda}', "");
    Expect(1, 11775, '\p{Block=:\Acyrillicextendeda\z:}', "");;
    Expect(0, 11776, '\p{Block=:\Acyrillicextendeda\z:}', "");;
    Expect(1, 11775, '\p{Block=	Cyrillic_Extended_A}', "");
    Expect(0, 11775, '\p{^Block=	Cyrillic_Extended_A}', "");
    Expect(0, 11775, '\P{Block=	Cyrillic_Extended_A}', "");
    Expect(1, 11775, '\P{^Block=	Cyrillic_Extended_A}', "");
    Expect(0, 11776, '\p{Block=	Cyrillic_Extended_A}', "");
    Expect(1, 11776, '\p{^Block=	Cyrillic_Extended_A}', "");
    Expect(1, 11776, '\P{Block=	Cyrillic_Extended_A}', "");
    Expect(0, 11776, '\P{^Block=	Cyrillic_Extended_A}', "");
    Error('\p{Blk= CYRILLIC_EXT_A/a/}');
    Error('\P{Blk= CYRILLIC_EXT_A/a/}');
    Expect(1, 11775, '\p{Blk=:\ACyrillic_Ext_A\z:}', "");;
    Expect(0, 11776, '\p{Blk=:\ACyrillic_Ext_A\z:}', "");;
    Expect(1, 11775, '\p{Blk=cyrillicexta}', "");
    Expect(0, 11775, '\p{^Blk=cyrillicexta}', "");
    Expect(0, 11775, '\P{Blk=cyrillicexta}', "");
    Expect(1, 11775, '\P{^Blk=cyrillicexta}', "");
    Expect(0, 11776, '\p{Blk=cyrillicexta}', "");
    Expect(1, 11776, '\p{^Blk=cyrillicexta}', "");
    Expect(1, 11776, '\P{Blk=cyrillicexta}', "");
    Expect(0, 11776, '\P{^Blk=cyrillicexta}', "");
    Expect(1, 11775, '\p{Blk=:\Acyrillicexta\z:}', "");;
    Expect(0, 11776, '\p{Blk=:\Acyrillicexta\z:}', "");;
    Expect(1, 11775, '\p{Blk= _Cyrillic_Ext_A}', "");
    Expect(0, 11775, '\p{^Blk= _Cyrillic_Ext_A}', "");
    Expect(0, 11775, '\P{Blk= _Cyrillic_Ext_A}', "");
    Expect(1, 11775, '\P{^Blk= _Cyrillic_Ext_A}', "");
    Expect(0, 11776, '\p{Blk= _Cyrillic_Ext_A}', "");
    Expect(1, 11776, '\p{^Blk= _Cyrillic_Ext_A}', "");
    Expect(1, 11776, '\P{Blk= _Cyrillic_Ext_A}', "");
    Expect(0, 11776, '\P{^Blk= _Cyrillic_Ext_A}', "");
    Error('\p{Is_Block=_	cyrillic_Extended_A:=}');
    Error('\P{Is_Block=_	cyrillic_Extended_A:=}');
    Expect(1, 11775, '\p{Is_Block=cyrillicextendeda}', "");
    Expect(0, 11775, '\p{^Is_Block=cyrillicextendeda}', "");
    Expect(0, 11775, '\P{Is_Block=cyrillicextendeda}', "");
    Expect(1, 11775, '\P{^Is_Block=cyrillicextendeda}', "");
    Expect(0, 11776, '\p{Is_Block=cyrillicextendeda}', "");
    Expect(1, 11776, '\p{^Is_Block=cyrillicextendeda}', "");
    Expect(1, 11776, '\P{Is_Block=cyrillicextendeda}', "");
    Expect(0, 11776, '\P{^Is_Block=cyrillicextendeda}', "");
    Expect(1, 11775, '\p{Is_Block:	_ CYRILLIC_EXTENDED_a}', "");
    Expect(0, 11775, '\p{^Is_Block:	_ CYRILLIC_EXTENDED_a}', "");
    Expect(0, 11775, '\P{Is_Block:	_ CYRILLIC_EXTENDED_a}', "");
    Expect(1, 11775, '\P{^Is_Block:	_ CYRILLIC_EXTENDED_a}', "");
    Expect(0, 11776, '\p{Is_Block:	_ CYRILLIC_EXTENDED_a}', "");
    Expect(1, 11776, '\p{^Is_Block:	_ CYRILLIC_EXTENDED_a}', "");
    Expect(1, 11776, '\P{Is_Block:	_ CYRILLIC_EXTENDED_a}', "");
    Expect(0, 11776, '\P{^Is_Block:	_ CYRILLIC_EXTENDED_a}', "");
    Error('\p{Is_Blk:/a/CYRILLIC_ext_a}');
    Error('\P{Is_Blk:/a/CYRILLIC_ext_a}');
    Expect(1, 11775, '\p{Is_Blk=cyrillicexta}', "");
    Expect(0, 11775, '\p{^Is_Blk=cyrillicexta}', "");
    Expect(0, 11775, '\P{Is_Blk=cyrillicexta}', "");
    Expect(1, 11775, '\P{^Is_Blk=cyrillicexta}', "");
    Expect(0, 11776, '\p{Is_Blk=cyrillicexta}', "");
    Expect(1, 11776, '\p{^Is_Blk=cyrillicexta}', "");
    Expect(1, 11776, '\P{Is_Blk=cyrillicexta}', "");
    Expect(0, 11776, '\P{^Is_Blk=cyrillicexta}', "");
    Expect(1, 11775, '\p{Is_Blk:   -_Cyrillic_ext_A}', "");
    Expect(0, 11775, '\p{^Is_Blk:   -_Cyrillic_ext_A}', "");
    Expect(0, 11775, '\P{Is_Blk:   -_Cyrillic_ext_A}', "");
    Expect(1, 11775, '\P{^Is_Blk:   -_Cyrillic_ext_A}', "");
    Expect(0, 11776, '\p{Is_Blk:   -_Cyrillic_ext_A}', "");
    Expect(1, 11776, '\p{^Is_Blk:   -_Cyrillic_ext_A}', "");
    Expect(1, 11776, '\P{Is_Blk:   -_Cyrillic_ext_A}', "");
    Expect(0, 11776, '\P{^Is_Blk:   -_Cyrillic_ext_A}', "");
    Error('\p{Block=_/a/Cyrillic_Extended_b}');
    Error('\P{Block=_/a/Cyrillic_Extended_b}');
    Expect(1, 42655, '\p{Block=:\ACyrillic_Extended_B\z:}', "");;
    Expect(0, 42656, '\p{Block=:\ACyrillic_Extended_B\z:}', "");;
    Expect(1, 42655, '\p{Block=cyrillicextendedb}', "");
    Expect(0, 42655, '\p{^Block=cyrillicextendedb}', "");
    Expect(0, 42655, '\P{Block=cyrillicextendedb}', "");
    Expect(1, 42655, '\P{^Block=cyrillicextendedb}', "");
    Expect(0, 42656, '\p{Block=cyrillicextendedb}', "");
    Expect(1, 42656, '\p{^Block=cyrillicextendedb}', "");
    Expect(1, 42656, '\P{Block=cyrillicextendedb}', "");
    Expect(0, 42656, '\P{^Block=cyrillicextendedb}', "");
    Expect(1, 42655, '\p{Block=:\Acyrillicextendedb\z:}', "");;
    Expect(0, 42656, '\p{Block=:\Acyrillicextendedb\z:}', "");;
    Expect(1, 42655, '\p{Block=-	CYRILLIC_Extended_B}', "");
    Expect(0, 42655, '\p{^Block=-	CYRILLIC_Extended_B}', "");
    Expect(0, 42655, '\P{Block=-	CYRILLIC_Extended_B}', "");
    Expect(1, 42655, '\P{^Block=-	CYRILLIC_Extended_B}', "");
    Expect(0, 42656, '\p{Block=-	CYRILLIC_Extended_B}', "");
    Expect(1, 42656, '\p{^Block=-	CYRILLIC_Extended_B}', "");
    Expect(1, 42656, '\P{Block=-	CYRILLIC_Extended_B}', "");
    Expect(0, 42656, '\P{^Block=-	CYRILLIC_Extended_B}', "");
    Error('\p{Blk=	 CYRILLIC_EXT_B/a/}');
    Error('\P{Blk=	 CYRILLIC_EXT_B/a/}');
    Expect(1, 42655, '\p{Blk=:\ACyrillic_Ext_B\z:}', "");;
    Expect(0, 42656, '\p{Blk=:\ACyrillic_Ext_B\z:}', "");;
    Expect(1, 42655, '\p{Blk=cyrillicextb}', "");
    Expect(0, 42655, '\p{^Blk=cyrillicextb}', "");
    Expect(0, 42655, '\P{Blk=cyrillicextb}', "");
    Expect(1, 42655, '\P{^Blk=cyrillicextb}', "");
    Expect(0, 42656, '\p{Blk=cyrillicextb}', "");
    Expect(1, 42656, '\p{^Blk=cyrillicextb}', "");
    Expect(1, 42656, '\P{Blk=cyrillicextb}', "");
    Expect(0, 42656, '\P{^Blk=cyrillicextb}', "");
    Expect(1, 42655, '\p{Blk=:\Acyrillicextb\z:}', "");;
    Expect(0, 42656, '\p{Blk=:\Acyrillicextb\z:}', "");;
    Expect(1, 42655, '\p{Blk:   	 cyrillic_ext_B}', "");
    Expect(0, 42655, '\p{^Blk:   	 cyrillic_ext_B}', "");
    Expect(0, 42655, '\P{Blk:   	 cyrillic_ext_B}', "");
    Expect(1, 42655, '\P{^Blk:   	 cyrillic_ext_B}', "");
    Expect(0, 42656, '\p{Blk:   	 cyrillic_ext_B}', "");
    Expect(1, 42656, '\p{^Blk:   	 cyrillic_ext_B}', "");
    Expect(1, 42656, '\P{Blk:   	 cyrillic_ext_B}', "");
    Expect(0, 42656, '\P{^Blk:   	 cyrillic_ext_B}', "");
    Error('\p{Is_Block=/a/- cyrillic_Extended_B}');
    Error('\P{Is_Block=/a/- cyrillic_Extended_B}');
    Expect(1, 42655, '\p{Is_Block=cyrillicextendedb}', "");
    Expect(0, 42655, '\p{^Is_Block=cyrillicextendedb}', "");
    Expect(0, 42655, '\P{Is_Block=cyrillicextendedb}', "");
    Expect(1, 42655, '\P{^Is_Block=cyrillicextendedb}', "");
    Expect(0, 42656, '\p{Is_Block=cyrillicextendedb}', "");
    Expect(1, 42656, '\p{^Is_Block=cyrillicextendedb}', "");
    Expect(1, 42656, '\P{Is_Block=cyrillicextendedb}', "");
    Expect(0, 42656, '\P{^Is_Block=cyrillicextendedb}', "");
    Expect(1, 42655, '\p{Is_Block=	-cyrillic_extended_b}', "");
    Expect(0, 42655, '\p{^Is_Block=	-cyrillic_extended_b}', "");
    Expect(0, 42655, '\P{Is_Block=	-cyrillic_extended_b}', "");
    Expect(1, 42655, '\P{^Is_Block=	-cyrillic_extended_b}', "");
    Expect(0, 42656, '\p{Is_Block=	-cyrillic_extended_b}', "");
    Expect(1, 42656, '\p{^Is_Block=	-cyrillic_extended_b}', "");
    Expect(1, 42656, '\P{Is_Block=	-cyrillic_extended_b}', "");
    Expect(0, 42656, '\P{^Is_Block=	-cyrillic_extended_b}', "");
    Error('\p{Is_Blk=:=CYRILLIC_Ext_B}');
    Error('\P{Is_Blk=:=CYRILLIC_Ext_B}');
    Expect(1, 42655, '\p{Is_Blk=cyrillicextb}', "");
    Expect(0, 42655, '\p{^Is_Blk=cyrillicextb}', "");
    Expect(0, 42655, '\P{Is_Blk=cyrillicextb}', "");
    Expect(1, 42655, '\P{^Is_Blk=cyrillicextb}', "");
    Expect(0, 42656, '\p{Is_Blk=cyrillicextb}', "");
    Expect(1, 42656, '\p{^Is_Blk=cyrillicextb}', "");
    Expect(1, 42656, '\P{Is_Blk=cyrillicextb}', "");
    Expect(0, 42656, '\P{^Is_Blk=cyrillicextb}', "");
    Expect(1, 42655, '\p{Is_Blk=-_cyrillic_Ext_b}', "");
    Expect(0, 42655, '\p{^Is_Blk=-_cyrillic_Ext_b}', "");
    Expect(0, 42655, '\P{Is_Blk=-_cyrillic_Ext_b}', "");
    Expect(1, 42655, '\P{^Is_Blk=-_cyrillic_Ext_b}', "");
    Expect(0, 42656, '\p{Is_Blk=-_cyrillic_Ext_b}', "");
    Expect(1, 42656, '\p{^Is_Blk=-_cyrillic_Ext_b}', "");
    Expect(1, 42656, '\P{Is_Blk=-_cyrillic_Ext_b}', "");
    Expect(0, 42656, '\P{^Is_Blk=-_cyrillic_Ext_b}', "");
    Error('\p{Block=-/a/Cyrillic_EXTENDED_C}');
    Error('\P{Block=-/a/Cyrillic_EXTENDED_C}');
    Expect(1, 7311, '\p{Block=:\ACyrillic_Extended_C\z:}', "");;
    Expect(0, 7312, '\p{Block=:\ACyrillic_Extended_C\z:}', "");;
    Expect(1, 7311, '\p{Block=cyrillicextendedc}', "");
    Expect(0, 7311, '\p{^Block=cyrillicextendedc}', "");
    Expect(0, 7311, '\P{Block=cyrillicextendedc}', "");
    Expect(1, 7311, '\P{^Block=cyrillicextendedc}', "");
    Expect(0, 7312, '\p{Block=cyrillicextendedc}', "");
    Expect(1, 7312, '\p{^Block=cyrillicextendedc}', "");
    Expect(1, 7312, '\P{Block=cyrillicextendedc}', "");
    Expect(0, 7312, '\P{^Block=cyrillicextendedc}', "");
    Expect(1, 7311, '\p{Block=:\Acyrillicextendedc\z:}', "");;
    Expect(0, 7312, '\p{Block=:\Acyrillicextendedc\z:}', "");;
    Expect(1, 7311, '\p{Block=		Cyrillic_EXTENDED_c}', "");
    Expect(0, 7311, '\p{^Block=		Cyrillic_EXTENDED_c}', "");
    Expect(0, 7311, '\P{Block=		Cyrillic_EXTENDED_c}', "");
    Expect(1, 7311, '\P{^Block=		Cyrillic_EXTENDED_c}', "");
    Expect(0, 7312, '\p{Block=		Cyrillic_EXTENDED_c}', "");
    Expect(1, 7312, '\p{^Block=		Cyrillic_EXTENDED_c}', "");
    Expect(1, 7312, '\P{Block=		Cyrillic_EXTENDED_c}', "");
    Expect(0, 7312, '\P{^Block=		Cyrillic_EXTENDED_c}', "");
    Error('\p{Blk=  cyrillic_EXT_C:=}');
    Error('\P{Blk=  cyrillic_EXT_C:=}');
    Expect(1, 7311, '\p{Blk=:\ACyrillic_Ext_C\z:}', "");;
    Expect(0, 7312, '\p{Blk=:\ACyrillic_Ext_C\z:}', "");;
    Expect(1, 7311, '\p{Blk=cyrillicextc}', "");
    Expect(0, 7311, '\p{^Blk=cyrillicextc}', "");
    Expect(0, 7311, '\P{Blk=cyrillicextc}', "");
    Expect(1, 7311, '\P{^Blk=cyrillicextc}', "");
    Expect(0, 7312, '\p{Blk=cyrillicextc}', "");
    Expect(1, 7312, '\p{^Blk=cyrillicextc}', "");
    Expect(1, 7312, '\P{Blk=cyrillicextc}', "");
    Expect(0, 7312, '\P{^Blk=cyrillicextc}', "");
    Expect(1, 7311, '\p{Blk=:\Acyrillicextc\z:}', "");;
    Expect(0, 7312, '\p{Blk=:\Acyrillicextc\z:}', "");;
    Expect(1, 7311, '\p{Blk=__CYRILLIC_EXT_C}', "");
    Expect(0, 7311, '\p{^Blk=__CYRILLIC_EXT_C}', "");
    Expect(0, 7311, '\P{Blk=__CYRILLIC_EXT_C}', "");
    Expect(1, 7311, '\P{^Blk=__CYRILLIC_EXT_C}', "");
    Expect(0, 7312, '\p{Blk=__CYRILLIC_EXT_C}', "");
    Expect(1, 7312, '\p{^Blk=__CYRILLIC_EXT_C}', "");
    Expect(1, 7312, '\P{Blk=__CYRILLIC_EXT_C}', "");
    Expect(0, 7312, '\P{^Blk=__CYRILLIC_EXT_C}', "");
    Error('\p{Is_Block= 	Cyrillic_EXTENDED_c:=}');
    Error('\P{Is_Block= 	Cyrillic_EXTENDED_c:=}');
    Expect(1, 7311, '\p{Is_Block=cyrillicextendedc}', "");
    Expect(0, 7311, '\p{^Is_Block=cyrillicextendedc}', "");
    Expect(0, 7311, '\P{Is_Block=cyrillicextendedc}', "");
    Expect(1, 7311, '\P{^Is_Block=cyrillicextendedc}', "");
    Expect(0, 7312, '\p{Is_Block=cyrillicextendedc}', "");
    Expect(1, 7312, '\p{^Is_Block=cyrillicextendedc}', "");
    Expect(1, 7312, '\P{Is_Block=cyrillicextendedc}', "");
    Expect(0, 7312, '\P{^Is_Block=cyrillicextendedc}', "");
    Expect(1, 7311, '\p{Is_Block= Cyrillic_EXTENDED_C}', "");
    Expect(0, 7311, '\p{^Is_Block= Cyrillic_EXTENDED_C}', "");
    Expect(0, 7311, '\P{Is_Block= Cyrillic_EXTENDED_C}', "");
    Expect(1, 7311, '\P{^Is_Block= Cyrillic_EXTENDED_C}', "");
    Expect(0, 7312, '\p{Is_Block= Cyrillic_EXTENDED_C}', "");
    Expect(1, 7312, '\p{^Is_Block= Cyrillic_EXTENDED_C}', "");
    Expect(1, 7312, '\P{Is_Block= Cyrillic_EXTENDED_C}', "");
    Expect(0, 7312, '\P{^Is_Block= Cyrillic_EXTENDED_C}', "");
    Error('\p{Is_Blk= :=CYRILLIC_ext_C}');
    Error('\P{Is_Blk= :=CYRILLIC_ext_C}');
    Expect(1, 7311, '\p{Is_Blk:   cyrillicextc}', "");
    Expect(0, 7311, '\p{^Is_Blk:   cyrillicextc}', "");
    Expect(0, 7311, '\P{Is_Blk:   cyrillicextc}', "");
    Expect(1, 7311, '\P{^Is_Blk:   cyrillicextc}', "");
    Expect(0, 7312, '\p{Is_Blk:   cyrillicextc}', "");
    Expect(1, 7312, '\p{^Is_Blk:   cyrillicextc}', "");
    Expect(1, 7312, '\P{Is_Blk:   cyrillicextc}', "");
    Expect(0, 7312, '\P{^Is_Blk:   cyrillicextc}', "");
    Expect(1, 7311, '\p{Is_Blk=_-cyrillic_Ext_C}', "");
    Expect(0, 7311, '\p{^Is_Blk=_-cyrillic_Ext_C}', "");
    Expect(0, 7311, '\P{Is_Blk=_-cyrillic_Ext_C}', "");
    Expect(1, 7311, '\P{^Is_Blk=_-cyrillic_Ext_C}', "");
    Expect(0, 7312, '\p{Is_Blk=_-cyrillic_Ext_C}', "");
    Expect(1, 7312, '\p{^Is_Blk=_-cyrillic_Ext_C}', "");
    Expect(1, 7312, '\P{Is_Blk=_-cyrillic_Ext_C}', "");
    Expect(0, 7312, '\P{^Is_Blk=_-cyrillic_Ext_C}', "");
    Error('\p{Block:_Cyrillic_Supplement:=}');
    Error('\P{Block:_Cyrillic_Supplement:=}');
    Expect(1, 1327, '\p{Block=:\ACyrillic_Supplement\z:}', "");;
    Expect(0, 1328, '\p{Block=:\ACyrillic_Supplement\z:}', "");;
    Expect(1, 1327, '\p{Block=cyrillicsupplement}', "");
    Expect(0, 1327, '\p{^Block=cyrillicsupplement}', "");
    Expect(0, 1327, '\P{Block=cyrillicsupplement}', "");
    Expect(1, 1327, '\P{^Block=cyrillicsupplement}', "");
    Expect(0, 1328, '\p{Block=cyrillicsupplement}', "");
    Expect(1, 1328, '\p{^Block=cyrillicsupplement}', "");
    Expect(1, 1328, '\P{Block=cyrillicsupplement}', "");
    Expect(0, 1328, '\P{^Block=cyrillicsupplement}', "");
    Expect(1, 1327, '\p{Block=:\Acyrillicsupplement\z:}', "");;
    Expect(0, 1328, '\p{Block=:\Acyrillicsupplement\z:}', "");;
    Expect(1, 1327, '\p{Block=	 CYRILLIC_Supplement}', "");
    Expect(0, 1327, '\p{^Block=	 CYRILLIC_Supplement}', "");
    Expect(0, 1327, '\P{Block=	 CYRILLIC_Supplement}', "");
    Expect(1, 1327, '\P{^Block=	 CYRILLIC_Supplement}', "");
    Expect(0, 1328, '\p{Block=	 CYRILLIC_Supplement}', "");
    Expect(1, 1328, '\p{^Block=	 CYRILLIC_Supplement}', "");
    Expect(1, 1328, '\P{Block=	 CYRILLIC_Supplement}', "");
    Expect(0, 1328, '\P{^Block=	 CYRILLIC_Supplement}', "");
    Error('\p{Blk=/a/	-Cyrillic_Sup}');
    Error('\P{Blk=/a/	-Cyrillic_Sup}');
    Expect(1, 1327, '\p{Blk=:\ACyrillic_Sup\z:}', "");;
    Expect(0, 1328, '\p{Blk=:\ACyrillic_Sup\z:}', "");;
    Expect(1, 1327, '\p{Blk=cyrillicsup}', "");
    Expect(0, 1327, '\p{^Blk=cyrillicsup}', "");
    Expect(0, 1327, '\P{Blk=cyrillicsup}', "");
    Expect(1, 1327, '\P{^Blk=cyrillicsup}', "");
    Expect(0, 1328, '\p{Blk=cyrillicsup}', "");
    Expect(1, 1328, '\p{^Blk=cyrillicsup}', "");
    Expect(1, 1328, '\P{Blk=cyrillicsup}', "");
    Expect(0, 1328, '\P{^Blk=cyrillicsup}', "");
    Expect(1, 1327, '\p{Blk=:\Acyrillicsup\z:}', "");;
    Expect(0, 1328, '\p{Blk=:\Acyrillicsup\z:}', "");;
    Expect(1, 1327, '\p{Blk: 	cyrillic_Sup}', "");
    Expect(0, 1327, '\p{^Blk: 	cyrillic_Sup}', "");
    Expect(0, 1327, '\P{Blk: 	cyrillic_Sup}', "");
    Expect(1, 1327, '\P{^Blk: 	cyrillic_Sup}', "");
    Expect(0, 1328, '\p{Blk: 	cyrillic_Sup}', "");
    Expect(1, 1328, '\p{^Blk: 	cyrillic_Sup}', "");
    Expect(1, 1328, '\P{Blk: 	cyrillic_Sup}', "");
    Expect(0, 1328, '\P{^Blk: 	cyrillic_Sup}', "");
    Error('\p{Is_Block:-_cyrillic_Supplementary/a/}');
    Error('\P{Is_Block:-_cyrillic_Supplementary/a/}');
    Expect(1, 1327, '\p{Is_Block=cyrillicsupplementary}', "");
    Expect(0, 1327, '\p{^Is_Block=cyrillicsupplementary}', "");
    Expect(0, 1327, '\P{Is_Block=cyrillicsupplementary}', "");
    Expect(1, 1327, '\P{^Is_Block=cyrillicsupplementary}', "");
    Expect(0, 1328, '\p{Is_Block=cyrillicsupplementary}', "");
    Expect(1, 1328, '\p{^Is_Block=cyrillicsupplementary}', "");
    Expect(1, 1328, '\P{Is_Block=cyrillicsupplementary}', "");
    Expect(0, 1328, '\P{^Is_Block=cyrillicsupplementary}', "");
    Expect(1, 1327, '\p{Is_Block=- Cyrillic_Supplementary}', "");
    Expect(0, 1327, '\p{^Is_Block=- Cyrillic_Supplementary}', "");
    Expect(0, 1327, '\P{Is_Block=- Cyrillic_Supplementary}', "");
    Expect(1, 1327, '\P{^Is_Block=- Cyrillic_Supplementary}', "");
    Expect(0, 1328, '\p{Is_Block=- Cyrillic_Supplementary}', "");
    Expect(1, 1328, '\p{^Is_Block=- Cyrillic_Supplementary}', "");
    Expect(1, 1328, '\P{Is_Block=- Cyrillic_Supplementary}', "");
    Expect(0, 1328, '\P{^Is_Block=- Cyrillic_Supplementary}', "");
    Error('\p{Is_Blk=  cyrillic_SUPPLEMENT:=}');
    Error('\P{Is_Blk=  cyrillic_SUPPLEMENT:=}');
    Expect(1, 1327, '\p{Is_Blk=cyrillicsupplement}', "");
    Expect(0, 1327, '\p{^Is_Blk=cyrillicsupplement}', "");
    Expect(0, 1327, '\P{Is_Blk=cyrillicsupplement}', "");
    Expect(1, 1327, '\P{^Is_Blk=cyrillicsupplement}', "");
    Expect(0, 1328, '\p{Is_Blk=cyrillicsupplement}', "");
    Expect(1, 1328, '\p{^Is_Blk=cyrillicsupplement}', "");
    Expect(1, 1328, '\P{Is_Blk=cyrillicsupplement}', "");
    Expect(0, 1328, '\P{^Is_Blk=cyrillicsupplement}', "");
    Expect(1, 1327, '\p{Is_Blk=_-cyrillic_supplement}', "");
    Expect(0, 1327, '\p{^Is_Blk=_-cyrillic_supplement}', "");
    Expect(0, 1327, '\P{Is_Blk=_-cyrillic_supplement}', "");
    Expect(1, 1327, '\P{^Is_Blk=_-cyrillic_supplement}', "");
    Expect(0, 1328, '\p{Is_Blk=_-cyrillic_supplement}', "");
    Expect(1, 1328, '\p{^Is_Blk=_-cyrillic_supplement}', "");
    Expect(1, 1328, '\P{Is_Blk=_-cyrillic_supplement}', "");
    Expect(0, 1328, '\P{^Is_Blk=_-cyrillic_supplement}', "");
    Error('\p{Block=  deseret/a/}');
    Error('\P{Block=  deseret/a/}');
    Expect(1, 66639, '\p{Block=:\ADeseret\z:}', "");;
    Expect(0, 66640, '\p{Block=:\ADeseret\z:}', "");;
    Expect(1, 66639, '\p{Block=deseret}', "");
    Expect(0, 66639, '\p{^Block=deseret}', "");
    Expect(0, 66639, '\P{Block=deseret}', "");
    Expect(1, 66639, '\P{^Block=deseret}', "");
    Expect(0, 66640, '\p{Block=deseret}', "");
    Expect(1, 66640, '\p{^Block=deseret}', "");
    Expect(1, 66640, '\P{Block=deseret}', "");
    Expect(0, 66640, '\P{^Block=deseret}', "");
    Expect(1, 66639, '\p{Block=:\Adeseret\z:}', "");;
    Expect(0, 66640, '\p{Block=:\Adeseret\z:}', "");;
    Expect(1, 66639, '\p{Block=-Deseret}', "");
    Expect(0, 66639, '\p{^Block=-Deseret}', "");
    Expect(0, 66639, '\P{Block=-Deseret}', "");
    Expect(1, 66639, '\P{^Block=-Deseret}', "");
    Expect(0, 66640, '\p{Block=-Deseret}', "");
    Expect(1, 66640, '\p{^Block=-Deseret}', "");
    Expect(1, 66640, '\P{Block=-Deseret}', "");
    Expect(0, 66640, '\P{^Block=-Deseret}', "");
    Error('\p{Blk=:=__Deseret}');
    Error('\P{Blk=:=__Deseret}');
    Expect(1, 66639, '\p{Blk=:\ADeseret\z:}', "");;
    Expect(0, 66640, '\p{Blk=:\ADeseret\z:}', "");;
    Expect(1, 66639, '\p{Blk=deseret}', "");
    Expect(0, 66639, '\p{^Blk=deseret}', "");
    Expect(0, 66639, '\P{Blk=deseret}', "");
    Expect(1, 66639, '\P{^Blk=deseret}', "");
    Expect(0, 66640, '\p{Blk=deseret}', "");
    Expect(1, 66640, '\p{^Blk=deseret}', "");
    Expect(1, 66640, '\P{Blk=deseret}', "");
    Expect(0, 66640, '\P{^Blk=deseret}', "");
    Expect(1, 66639, '\p{Blk=:\Adeseret\z:}', "");;
    Expect(0, 66640, '\p{Blk=:\Adeseret\z:}', "");;
    Expect(1, 66639, '\p{Blk=-deseret}', "");
    Expect(0, 66639, '\p{^Blk=-deseret}', "");
    Expect(0, 66639, '\P{Blk=-deseret}', "");
    Expect(1, 66639, '\P{^Blk=-deseret}', "");
    Expect(0, 66640, '\p{Blk=-deseret}', "");
    Expect(1, 66640, '\p{^Blk=-deseret}', "");
    Expect(1, 66640, '\P{Blk=-deseret}', "");
    Expect(0, 66640, '\P{^Blk=-deseret}', "");
    Error('\p{Is_Block= deseret:=}');
    Error('\P{Is_Block= deseret:=}');
    Expect(1, 66639, '\p{Is_Block=deseret}', "");
    Expect(0, 66639, '\p{^Is_Block=deseret}', "");
    Expect(0, 66639, '\P{Is_Block=deseret}', "");
    Expect(1, 66639, '\P{^Is_Block=deseret}', "");
    Expect(0, 66640, '\p{Is_Block=deseret}', "");
    Expect(1, 66640, '\p{^Is_Block=deseret}', "");
    Expect(1, 66640, '\P{Is_Block=deseret}', "");
    Expect(0, 66640, '\P{^Is_Block=deseret}', "");
    Expect(1, 66639, '\p{Is_Block=	DESERET}', "");
    Expect(0, 66639, '\p{^Is_Block=	DESERET}', "");
    Expect(0, 66639, '\P{Is_Block=	DESERET}', "");
    Expect(1, 66639, '\P{^Is_Block=	DESERET}', "");
    Expect(0, 66640, '\p{Is_Block=	DESERET}', "");
    Expect(1, 66640, '\p{^Is_Block=	DESERET}', "");
    Expect(1, 66640, '\P{Is_Block=	DESERET}', "");
    Expect(0, 66640, '\P{^Is_Block=	DESERET}', "");
    Error('\p{Is_Blk=-:=Deseret}');
    Error('\P{Is_Blk=-:=Deseret}');
    Expect(1, 66639, '\p{Is_Blk=deseret}', "");
    Expect(0, 66639, '\p{^Is_Blk=deseret}', "");
    Expect(0, 66639, '\P{Is_Blk=deseret}', "");
    Expect(1, 66639, '\P{^Is_Blk=deseret}', "");
    Expect(0, 66640, '\p{Is_Blk=deseret}', "");
    Expect(1, 66640, '\p{^Is_Blk=deseret}', "");
    Expect(1, 66640, '\P{Is_Blk=deseret}', "");
    Expect(0, 66640, '\P{^Is_Blk=deseret}', "");
    Expect(1, 66639, '\p{Is_Blk:   -Deseret}', "");
    Expect(0, 66639, '\p{^Is_Blk:   -Deseret}', "");
    Expect(0, 66639, '\P{Is_Blk:   -Deseret}', "");
    Expect(1, 66639, '\P{^Is_Blk:   -Deseret}', "");
    Expect(0, 66640, '\p{Is_Blk:   -Deseret}', "");
    Expect(1, 66640, '\p{^Is_Blk:   -Deseret}', "");
    Expect(1, 66640, '\P{Is_Blk:   -Deseret}', "");
    Expect(0, 66640, '\P{^Is_Blk:   -Deseret}', "");
    Error('\p{Block=_Devanagari:=}');
    Error('\P{Block=_Devanagari:=}');
    Expect(1, 2431, '\p{Block=:\ADevanagari\z:}', "");;
    Expect(0, 2432, '\p{Block=:\ADevanagari\z:}', "");;
    Expect(1, 2431, '\p{Block=devanagari}', "");
    Expect(0, 2431, '\p{^Block=devanagari}', "");
    Expect(0, 2431, '\P{Block=devanagari}', "");
    Expect(1, 2431, '\P{^Block=devanagari}', "");
    Expect(0, 2432, '\p{Block=devanagari}', "");
    Expect(1, 2432, '\p{^Block=devanagari}', "");
    Expect(1, 2432, '\P{Block=devanagari}', "");
    Expect(0, 2432, '\P{^Block=devanagari}', "");
    Expect(1, 2431, '\p{Block=:\Adevanagari\z:}', "");;
    Expect(0, 2432, '\p{Block=:\Adevanagari\z:}', "");;
    Expect(1, 2431, '\p{Block=		devanagari}', "");
    Expect(0, 2431, '\p{^Block=		devanagari}', "");
    Expect(0, 2431, '\P{Block=		devanagari}', "");
    Expect(1, 2431, '\P{^Block=		devanagari}', "");
    Expect(0, 2432, '\p{Block=		devanagari}', "");
    Expect(1, 2432, '\p{^Block=		devanagari}', "");
    Expect(1, 2432, '\P{Block=		devanagari}', "");
    Expect(0, 2432, '\P{^Block=		devanagari}', "");
    Error('\p{Blk=	:=Devanagari}');
    Error('\P{Blk=	:=Devanagari}');
    Expect(1, 2431, '\p{Blk=:\ADevanagari\z:}', "");;
    Expect(0, 2432, '\p{Blk=:\ADevanagari\z:}', "");;
    Expect(1, 2431, '\p{Blk=devanagari}', "");
    Expect(0, 2431, '\p{^Blk=devanagari}', "");
    Expect(0, 2431, '\P{Blk=devanagari}', "");
    Expect(1, 2431, '\P{^Blk=devanagari}', "");
    Expect(0, 2432, '\p{Blk=devanagari}', "");
    Expect(1, 2432, '\p{^Blk=devanagari}', "");
    Expect(1, 2432, '\P{Blk=devanagari}', "");
    Expect(0, 2432, '\P{^Blk=devanagari}', "");
    Expect(1, 2431, '\p{Blk=:\Adevanagari\z:}', "");;
    Expect(0, 2432, '\p{Blk=:\Adevanagari\z:}', "");;
    Expect(1, 2431, '\p{Blk= DEVANAGARI}', "");
    Expect(0, 2431, '\p{^Blk= DEVANAGARI}', "");
    Expect(0, 2431, '\P{Blk= DEVANAGARI}', "");
    Expect(1, 2431, '\P{^Blk= DEVANAGARI}', "");
    Expect(0, 2432, '\p{Blk= DEVANAGARI}', "");
    Expect(1, 2432, '\p{^Blk= DEVANAGARI}', "");
    Expect(1, 2432, '\P{Blk= DEVANAGARI}', "");
    Expect(0, 2432, '\P{^Blk= DEVANAGARI}', "");
    Error('\p{Is_Block=	/a/Devanagari}');
    Error('\P{Is_Block=	/a/Devanagari}');
    Expect(1, 2431, '\p{Is_Block=devanagari}', "");
    Expect(0, 2431, '\p{^Is_Block=devanagari}', "");
    Expect(0, 2431, '\P{Is_Block=devanagari}', "");
    Expect(1, 2431, '\P{^Is_Block=devanagari}', "");
    Expect(0, 2432, '\p{Is_Block=devanagari}', "");
    Expect(1, 2432, '\p{^Is_Block=devanagari}', "");
    Expect(1, 2432, '\P{Is_Block=devanagari}', "");
    Expect(0, 2432, '\P{^Is_Block=devanagari}', "");
    Expect(1, 2431, '\p{Is_Block=__DEVANAGARI}', "");
    Expect(0, 2431, '\p{^Is_Block=__DEVANAGARI}', "");
    Expect(0, 2431, '\P{Is_Block=__DEVANAGARI}', "");
    Expect(1, 2431, '\P{^Is_Block=__DEVANAGARI}', "");
    Expect(0, 2432, '\p{Is_Block=__DEVANAGARI}', "");
    Expect(1, 2432, '\p{^Is_Block=__DEVANAGARI}', "");
    Expect(1, 2432, '\P{Is_Block=__DEVANAGARI}', "");
    Expect(0, 2432, '\P{^Is_Block=__DEVANAGARI}', "");
    Error('\p{Is_Blk=	 devanagari:=}');
    Error('\P{Is_Blk=	 devanagari:=}');
    Expect(1, 2431, '\p{Is_Blk=devanagari}', "");
    Expect(0, 2431, '\p{^Is_Blk=devanagari}', "");
    Expect(0, 2431, '\P{Is_Blk=devanagari}', "");
    Expect(1, 2431, '\P{^Is_Blk=devanagari}', "");
    Expect(0, 2432, '\p{Is_Blk=devanagari}', "");
    Expect(1, 2432, '\p{^Is_Blk=devanagari}', "");
    Expect(1, 2432, '\P{Is_Blk=devanagari}', "");
    Expect(0, 2432, '\P{^Is_Blk=devanagari}', "");
    Expect(1, 2431, '\p{Is_Blk: _ DEVANAGARI}', "");
    Expect(0, 2431, '\p{^Is_Blk: _ DEVANAGARI}', "");
    Expect(0, 2431, '\P{Is_Blk: _ DEVANAGARI}', "");
    Expect(1, 2431, '\P{^Is_Blk: _ DEVANAGARI}', "");
    Expect(0, 2432, '\p{Is_Blk: _ DEVANAGARI}', "");
    Expect(1, 2432, '\p{^Is_Blk: _ DEVANAGARI}', "");
    Expect(1, 2432, '\P{Is_Blk: _ DEVANAGARI}', "");
    Expect(0, 2432, '\P{^Is_Blk: _ DEVANAGARI}', "");
    Error('\p{Block=	:=DEVANAGARI_extended}');
    Error('\P{Block=	:=DEVANAGARI_extended}');
    Expect(1, 43263, '\p{Block=:\ADevanagari_Extended\z:}', "");;
    Expect(0, 43264, '\p{Block=:\ADevanagari_Extended\z:}', "");;
    Expect(1, 43263, '\p{Block=devanagariextended}', "");
    Expect(0, 43263, '\p{^Block=devanagariextended}', "");
    Expect(0, 43263, '\P{Block=devanagariextended}', "");
    Expect(1, 43263, '\P{^Block=devanagariextended}', "");
    Expect(0, 43264, '\p{Block=devanagariextended}', "");
    Expect(1, 43264, '\p{^Block=devanagariextended}', "");
    Expect(1, 43264, '\P{Block=devanagariextended}', "");
    Expect(0, 43264, '\P{^Block=devanagariextended}', "");
    Expect(1, 43263, '\p{Block=:\Adevanagariextended\z:}', "");;
    Expect(0, 43264, '\p{Block=:\Adevanagariextended\z:}', "");;
    Expect(1, 43263, '\p{Block:-_Devanagari_EXTENDED}', "");
    Expect(0, 43263, '\p{^Block:-_Devanagari_EXTENDED}', "");
    Expect(0, 43263, '\P{Block:-_Devanagari_EXTENDED}', "");
    Expect(1, 43263, '\P{^Block:-_Devanagari_EXTENDED}', "");
    Expect(0, 43264, '\p{Block:-_Devanagari_EXTENDED}', "");
    Expect(1, 43264, '\p{^Block:-_Devanagari_EXTENDED}', "");
    Expect(1, 43264, '\P{Block:-_Devanagari_EXTENDED}', "");
    Expect(0, 43264, '\P{^Block:-_Devanagari_EXTENDED}', "");
    Error('\p{Blk: 	-DEVANAGARI_Ext/a/}');
    Error('\P{Blk: 	-DEVANAGARI_Ext/a/}');
    Expect(1, 43263, '\p{Blk=:\ADevanagari_Ext\z:}', "");;
    Expect(0, 43264, '\p{Blk=:\ADevanagari_Ext\z:}', "");;
    Expect(1, 43263, '\p{Blk=devanagariext}', "");
    Expect(0, 43263, '\p{^Blk=devanagariext}', "");
    Expect(0, 43263, '\P{Blk=devanagariext}', "");
    Expect(1, 43263, '\P{^Blk=devanagariext}', "");
    Expect(0, 43264, '\p{Blk=devanagariext}', "");
    Expect(1, 43264, '\p{^Blk=devanagariext}', "");
    Expect(1, 43264, '\P{Blk=devanagariext}', "");
    Expect(0, 43264, '\P{^Blk=devanagariext}', "");
    Expect(1, 43263, '\p{Blk=:\Adevanagariext\z:}', "");;
    Expect(0, 43264, '\p{Blk=:\Adevanagariext\z:}', "");;
    Expect(1, 43263, '\p{Blk=_ DEVANAGARI_Ext}', "");
    Expect(0, 43263, '\p{^Blk=_ DEVANAGARI_Ext}', "");
    Expect(0, 43263, '\P{Blk=_ DEVANAGARI_Ext}', "");
    Expect(1, 43263, '\P{^Blk=_ DEVANAGARI_Ext}', "");
    Expect(0, 43264, '\p{Blk=_ DEVANAGARI_Ext}', "");
    Expect(1, 43264, '\p{^Blk=_ DEVANAGARI_Ext}', "");
    Expect(1, 43264, '\P{Blk=_ DEVANAGARI_Ext}', "");
    Expect(0, 43264, '\P{^Blk=_ DEVANAGARI_Ext}', "");
    Error('\p{Is_Block=:= -Devanagari_extended}');
    Error('\P{Is_Block=:= -Devanagari_extended}');
    Expect(1, 43263, '\p{Is_Block=devanagariextended}', "");
    Expect(0, 43263, '\p{^Is_Block=devanagariextended}', "");
    Expect(0, 43263, '\P{Is_Block=devanagariextended}', "");
    Expect(1, 43263, '\P{^Is_Block=devanagariextended}', "");
    Expect(0, 43264, '\p{Is_Block=devanagariextended}', "");
    Expect(1, 43264, '\p{^Is_Block=devanagariextended}', "");
    Expect(1, 43264, '\P{Is_Block=devanagariextended}', "");
    Expect(0, 43264, '\P{^Is_Block=devanagariextended}', "");
    Expect(1, 43263, '\p{Is_Block=  Devanagari_Extended}', "");
    Expect(0, 43263, '\p{^Is_Block=  Devanagari_Extended}', "");
    Expect(0, 43263, '\P{Is_Block=  Devanagari_Extended}', "");
    Expect(1, 43263, '\P{^Is_Block=  Devanagari_Extended}', "");
    Expect(0, 43264, '\p{Is_Block=  Devanagari_Extended}', "");
    Expect(1, 43264, '\p{^Is_Block=  Devanagari_Extended}', "");
    Expect(1, 43264, '\P{Is_Block=  Devanagari_Extended}', "");
    Expect(0, 43264, '\P{^Is_Block=  Devanagari_Extended}', "");
    Error('\p{Is_Blk: :=Devanagari_Ext}');
    Error('\P{Is_Blk: :=Devanagari_Ext}');
    Expect(1, 43263, '\p{Is_Blk=devanagariext}', "");
    Expect(0, 43263, '\p{^Is_Blk=devanagariext}', "");
    Expect(0, 43263, '\P{Is_Blk=devanagariext}', "");
    Expect(1, 43263, '\P{^Is_Blk=devanagariext}', "");
    Expect(0, 43264, '\p{Is_Blk=devanagariext}', "");
    Expect(1, 43264, '\p{^Is_Blk=devanagariext}', "");
    Expect(1, 43264, '\P{Is_Blk=devanagariext}', "");
    Expect(0, 43264, '\P{^Is_Blk=devanagariext}', "");
    Expect(1, 43263, '\p{Is_Blk=	Devanagari_EXT}', "");
    Expect(0, 43263, '\p{^Is_Blk=	Devanagari_EXT}', "");
    Expect(0, 43263, '\P{Is_Blk=	Devanagari_EXT}', "");
    Expect(1, 43263, '\P{^Is_Blk=	Devanagari_EXT}', "");
    Expect(0, 43264, '\p{Is_Blk=	Devanagari_EXT}', "");
    Expect(1, 43264, '\p{^Is_Blk=	Devanagari_EXT}', "");
    Expect(1, 43264, '\P{Is_Blk=	Devanagari_EXT}', "");
    Expect(0, 43264, '\P{^Is_Blk=	Devanagari_EXT}', "");
    Error('\p{Block:/a/	 COMBINING_DIACRITICAL_MARKS}');
    Error('\P{Block:/a/	 COMBINING_DIACRITICAL_MARKS}');
    Expect(1, 879, '\p{Block=:\ACombining_Diacritical_Marks\z:}', "");;
    Expect(0, 880, '\p{Block=:\ACombining_Diacritical_Marks\z:}', "");;
    Expect(1, 879, '\p{Block=combiningdiacriticalmarks}', "");
    Expect(0, 879, '\p{^Block=combiningdiacriticalmarks}', "");
    Expect(0, 879, '\P{Block=combiningdiacriticalmarks}', "");
    Expect(1, 879, '\P{^Block=combiningdiacriticalmarks}', "");
    Expect(0, 880, '\p{Block=combiningdiacriticalmarks}', "");
    Expect(1, 880, '\p{^Block=combiningdiacriticalmarks}', "");
    Expect(1, 880, '\P{Block=combiningdiacriticalmarks}', "");
    Expect(0, 880, '\P{^Block=combiningdiacriticalmarks}', "");
    Expect(1, 879, '\p{Block=:\Acombiningdiacriticalmarks\z:}', "");;
    Expect(0, 880, '\p{Block=:\Acombiningdiacriticalmarks\z:}', "");;
    Expect(1, 879, '\p{Block=  combining_DIACRITICAL_MARKS}', "");
    Expect(0, 879, '\p{^Block=  combining_DIACRITICAL_MARKS}', "");
    Expect(0, 879, '\P{Block=  combining_DIACRITICAL_MARKS}', "");
    Expect(1, 879, '\P{^Block=  combining_DIACRITICAL_MARKS}', "");
    Expect(0, 880, '\p{Block=  combining_DIACRITICAL_MARKS}', "");
    Expect(1, 880, '\p{^Block=  combining_DIACRITICAL_MARKS}', "");
    Expect(1, 880, '\P{Block=  combining_DIACRITICAL_MARKS}', "");
    Expect(0, 880, '\P{^Block=  combining_DIACRITICAL_MARKS}', "");
    Error('\p{Blk=:=Diacriticals}');
    Error('\P{Blk=:=Diacriticals}');
    Expect(1, 879, '\p{Blk=:\ADiacriticals\z:}', "");;
    Expect(0, 880, '\p{Blk=:\ADiacriticals\z:}', "");;
    Expect(1, 879, '\p{Blk=diacriticals}', "");
    Expect(0, 879, '\p{^Blk=diacriticals}', "");
    Expect(0, 879, '\P{Blk=diacriticals}', "");
    Expect(1, 879, '\P{^Blk=diacriticals}', "");
    Expect(0, 880, '\p{Blk=diacriticals}', "");
    Expect(1, 880, '\p{^Blk=diacriticals}', "");
    Expect(1, 880, '\P{Blk=diacriticals}', "");
    Expect(0, 880, '\P{^Blk=diacriticals}', "");
    Expect(1, 879, '\p{Blk=:\Adiacriticals\z:}', "");;
    Expect(0, 880, '\p{Blk=:\Adiacriticals\z:}', "");;
    Expect(1, 879, '\p{Blk=_diacriticals}', "");
    Expect(0, 879, '\p{^Blk=_diacriticals}', "");
    Expect(0, 879, '\P{Blk=_diacriticals}', "");
    Expect(1, 879, '\P{^Blk=_diacriticals}', "");
    Expect(0, 880, '\p{Blk=_diacriticals}', "");
    Expect(1, 880, '\p{^Blk=_diacriticals}', "");
    Expect(1, 880, '\P{Blk=_diacriticals}', "");
    Expect(0, 880, '\P{^Blk=_diacriticals}', "");
    Error('\p{Is_Block=/a/Combining_Diacritical_Marks}');
    Error('\P{Is_Block=/a/Combining_Diacritical_Marks}');
    Expect(1, 879, '\p{Is_Block=combiningdiacriticalmarks}', "");
    Expect(0, 879, '\p{^Is_Block=combiningdiacriticalmarks}', "");
    Expect(0, 879, '\P{Is_Block=combiningdiacriticalmarks}', "");
    Expect(1, 879, '\P{^Is_Block=combiningdiacriticalmarks}', "");
    Expect(0, 880, '\p{Is_Block=combiningdiacriticalmarks}', "");
    Expect(1, 880, '\p{^Is_Block=combiningdiacriticalmarks}', "");
    Expect(1, 880, '\P{Is_Block=combiningdiacriticalmarks}', "");
    Expect(0, 880, '\P{^Is_Block=combiningdiacriticalmarks}', "");
    Expect(1, 879, '\p{Is_Block: -COMBINING_diacritical_marks}', "");
    Expect(0, 879, '\p{^Is_Block: -COMBINING_diacritical_marks}', "");
    Expect(0, 879, '\P{Is_Block: -COMBINING_diacritical_marks}', "");
    Expect(1, 879, '\P{^Is_Block: -COMBINING_diacritical_marks}', "");
    Expect(0, 880, '\p{Is_Block: -COMBINING_diacritical_marks}', "");
    Expect(1, 880, '\p{^Is_Block: -COMBINING_diacritical_marks}', "");
    Expect(1, 880, '\P{Is_Block: -COMBINING_diacritical_marks}', "");
    Expect(0, 880, '\P{^Is_Block: -COMBINING_diacritical_marks}', "");
    Error('\p{Is_Blk=/a/diacriticals}');
    Error('\P{Is_Blk=/a/diacriticals}');
    Expect(1, 879, '\p{Is_Blk=diacriticals}', "");
    Expect(0, 879, '\p{^Is_Blk=diacriticals}', "");
    Expect(0, 879, '\P{Is_Blk=diacriticals}', "");
    Expect(1, 879, '\P{^Is_Blk=diacriticals}', "");
    Expect(0, 880, '\p{Is_Blk=diacriticals}', "");
    Expect(1, 880, '\p{^Is_Blk=diacriticals}', "");
    Expect(1, 880, '\P{Is_Blk=diacriticals}', "");
    Expect(0, 880, '\P{^Is_Blk=diacriticals}', "");
    Expect(1, 879, '\p{Is_Blk= 	Diacriticals}', "");
    Expect(0, 879, '\p{^Is_Blk= 	Diacriticals}', "");
    Expect(0, 879, '\P{Is_Blk= 	Diacriticals}', "");
    Expect(1, 879, '\P{^Is_Blk= 	Diacriticals}', "");
    Expect(0, 880, '\p{Is_Blk= 	Diacriticals}', "");
    Expect(1, 880, '\p{^Is_Blk= 	Diacriticals}', "");
    Expect(1, 880, '\P{Is_Blk= 	Diacriticals}', "");
    Expect(0, 880, '\P{^Is_Blk= 	Diacriticals}', "");
    Error('\p{Block=_-COMBINING_Diacritical_Marks_Extended/a/}');
    Error('\P{Block=_-COMBINING_Diacritical_Marks_Extended/a/}');
    Expect(1, 6911, '\p{Block=:\ACombining_Diacritical_Marks_Extended\z:}', "");;
    Expect(0, 6912, '\p{Block=:\ACombining_Diacritical_Marks_Extended\z:}', "");;
    Expect(1, 6911, '\p{Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6911, '\p{^Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6911, '\P{Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6911, '\P{^Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6912, '\p{Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6912, '\p{^Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6912, '\P{Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6912, '\P{^Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6911, '\p{Block=:\Acombiningdiacriticalmarksextended\z:}', "");;
    Expect(0, 6912, '\p{Block=:\Acombiningdiacriticalmarksextended\z:}', "");;
    Expect(1, 6911, '\p{Block= combining_Diacritical_MARKS_extended}', "");
    Expect(0, 6911, '\p{^Block= combining_Diacritical_MARKS_extended}', "");
    Expect(0, 6911, '\P{Block= combining_Diacritical_MARKS_extended}', "");
    Expect(1, 6911, '\P{^Block= combining_Diacritical_MARKS_extended}', "");
    Expect(0, 6912, '\p{Block= combining_Diacritical_MARKS_extended}', "");
    Expect(1, 6912, '\p{^Block= combining_Diacritical_MARKS_extended}', "");
    Expect(1, 6912, '\P{Block= combining_Diacritical_MARKS_extended}', "");
    Expect(0, 6912, '\P{^Block= combining_Diacritical_MARKS_extended}', "");
    Error('\p{Blk=/a/-Diacriticals_ext}');
    Error('\P{Blk=/a/-Diacriticals_ext}');
    Expect(1, 6911, '\p{Blk=:\ADiacriticals_Ext\z:}', "");;
    Expect(0, 6912, '\p{Blk=:\ADiacriticals_Ext\z:}', "");;
    Expect(1, 6911, '\p{Blk:   diacriticalsext}', "");
    Expect(0, 6911, '\p{^Blk:   diacriticalsext}', "");
    Expect(0, 6911, '\P{Blk:   diacriticalsext}', "");
    Expect(1, 6911, '\P{^Blk:   diacriticalsext}', "");
    Expect(0, 6912, '\p{Blk:   diacriticalsext}', "");
    Expect(1, 6912, '\p{^Blk:   diacriticalsext}', "");
    Expect(1, 6912, '\P{Blk:   diacriticalsext}', "");
    Expect(0, 6912, '\P{^Blk:   diacriticalsext}', "");
    Expect(1, 6911, '\p{Blk=:\Adiacriticalsext\z:}', "");;
    Expect(0, 6912, '\p{Blk=:\Adiacriticalsext\z:}', "");;
    Expect(1, 6911, '\p{Blk=  Diacriticals_EXT}', "");
    Expect(0, 6911, '\p{^Blk=  Diacriticals_EXT}', "");
    Expect(0, 6911, '\P{Blk=  Diacriticals_EXT}', "");
    Expect(1, 6911, '\P{^Blk=  Diacriticals_EXT}', "");
    Expect(0, 6912, '\p{Blk=  Diacriticals_EXT}', "");
    Expect(1, 6912, '\p{^Blk=  Diacriticals_EXT}', "");
    Expect(1, 6912, '\P{Blk=  Diacriticals_EXT}', "");
    Expect(0, 6912, '\P{^Blk=  Diacriticals_EXT}', "");
    Error('\p{Is_Block=/a/_	Combining_diacritical_Marks_Extended}');
    Error('\P{Is_Block=/a/_	Combining_diacritical_Marks_Extended}');
    Expect(1, 6911, '\p{Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6911, '\p{^Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6911, '\P{Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6911, '\P{^Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6912, '\p{Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6912, '\p{^Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6912, '\P{Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(0, 6912, '\P{^Is_Block=combiningdiacriticalmarksextended}', "");
    Expect(1, 6911, '\p{Is_Block=- combining_diacritical_MARKS_extended}', "");
    Expect(0, 6911, '\p{^Is_Block=- combining_diacritical_MARKS_extended}', "");
    Expect(0, 6911, '\P{Is_Block=- combining_diacritical_MARKS_extended}', "");
    Expect(1, 6911, '\P{^Is_Block=- combining_diacritical_MARKS_extended}', "");
    Expect(0, 6912, '\p{Is_Block=- combining_diacritical_MARKS_extended}', "");
    Expect(1, 6912, '\p{^Is_Block=- combining_diacritical_MARKS_extended}', "");
    Expect(1, 6912, '\P{Is_Block=- combining_diacritical_MARKS_extended}', "");
    Expect(0, 6912, '\P{^Is_Block=- combining_diacritical_MARKS_extended}', "");
    Error('\p{Is_Blk=:=diacriticals_Ext}');
    Error('\P{Is_Blk=:=diacriticals_Ext}');
    Expect(1, 6911, '\p{Is_Blk=diacriticalsext}', "");
    Expect(0, 6911, '\p{^Is_Blk=diacriticalsext}', "");
    Expect(0, 6911, '\P{Is_Blk=diacriticalsext}', "");
    Expect(1, 6911, '\P{^Is_Blk=diacriticalsext}', "");
    Expect(0, 6912, '\p{Is_Blk=diacriticalsext}', "");
    Expect(1, 6912, '\p{^Is_Blk=diacriticalsext}', "");
    Expect(1, 6912, '\P{Is_Blk=diacriticalsext}', "");
    Expect(0, 6912, '\P{^Is_Blk=diacriticalsext}', "");
    Expect(1, 6911, '\p{Is_Blk=Diacriticals_Ext}', "");
    Expect(0, 6911, '\p{^Is_Blk=Diacriticals_Ext}', "");
    Expect(0, 6911, '\P{Is_Blk=Diacriticals_Ext}', "");
    Expect(1, 6911, '\P{^Is_Blk=Diacriticals_Ext}', "");
    Expect(0, 6912, '\p{Is_Blk=Diacriticals_Ext}', "");
    Expect(1, 6912, '\p{^Is_Blk=Diacriticals_Ext}', "");
    Expect(1, 6912, '\P{Is_Blk=Diacriticals_Ext}', "");
    Expect(0, 6912, '\P{^Is_Blk=Diacriticals_Ext}', "");
    Error('\p{Block: :=Combining_DIACRITICAL_Marks_for_Symbols}');
    Error('\P{Block: :=Combining_DIACRITICAL_Marks_for_Symbols}');
    Expect(1, 8447, '\p{Block=:\ACombining_Diacritical_Marks_For_Symbols\z:}', "");;
    Expect(0, 8448, '\p{Block=:\ACombining_Diacritical_Marks_For_Symbols\z:}', "");;
    Expect(1, 8447, '\p{Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8447, '\p{^Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8447, '\P{Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8447, '\P{^Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8448, '\p{Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8448, '\p{^Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8448, '\P{Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8448, '\P{^Block=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8447, '\p{Block=:\Acombiningdiacriticalmarksforsymbols\z:}', "");;
    Expect(0, 8448, '\p{Block=:\Acombiningdiacriticalmarksforsymbols\z:}', "");;
    Expect(1, 8447, '\p{Block=-Combining_DIACRITICAL_MARKS_FOR_Symbols}', "");
    Expect(0, 8447, '\p{^Block=-Combining_DIACRITICAL_MARKS_FOR_Symbols}', "");
    Expect(0, 8447, '\P{Block=-Combining_DIACRITICAL_MARKS_FOR_Symbols}', "");
    Expect(1, 8447, '\P{^Block=-Combining_DIACRITICAL_MARKS_FOR_Symbols}', "");
    Expect(0, 8448, '\p{Block=-Combining_DIACRITICAL_MARKS_FOR_Symbols}', "");
    Expect(1, 8448, '\p{^Block=-Combining_DIACRITICAL_MARKS_FOR_Symbols}', "");
    Expect(1, 8448, '\P{Block=-Combining_DIACRITICAL_MARKS_FOR_Symbols}', "");
    Expect(0, 8448, '\P{^Block=-Combining_DIACRITICAL_MARKS_FOR_Symbols}', "");
    Error('\p{Blk=/a/ Diacriticals_For_Symbols}');
    Error('\P{Blk=/a/ Diacriticals_For_Symbols}');
    Expect(1, 8447, '\p{Blk=:\ADiacriticals_For_Symbols\z:}', "");;
    Expect(0, 8448, '\p{Blk=:\ADiacriticals_For_Symbols\z:}', "");;
    Expect(1, 8447, '\p{Blk=diacriticalsforsymbols}', "");
    Expect(0, 8447, '\p{^Blk=diacriticalsforsymbols}', "");
    Expect(0, 8447, '\P{Blk=diacriticalsforsymbols}', "");
    Expect(1, 8447, '\P{^Blk=diacriticalsforsymbols}', "");
    Expect(0, 8448, '\p{Blk=diacriticalsforsymbols}', "");
    Expect(1, 8448, '\p{^Blk=diacriticalsforsymbols}', "");
    Expect(1, 8448, '\P{Blk=diacriticalsforsymbols}', "");
    Expect(0, 8448, '\P{^Blk=diacriticalsforsymbols}', "");
    Expect(1, 8447, '\p{Blk=:\Adiacriticalsforsymbols\z:}', "");;
    Expect(0, 8448, '\p{Blk=:\Adiacriticalsforsymbols\z:}', "");;
    Expect(1, 8447, '\p{Blk=	Diacriticals_for_Symbols}', "");
    Expect(0, 8447, '\p{^Blk=	Diacriticals_for_Symbols}', "");
    Expect(0, 8447, '\P{Blk=	Diacriticals_for_Symbols}', "");
    Expect(1, 8447, '\P{^Blk=	Diacriticals_for_Symbols}', "");
    Expect(0, 8448, '\p{Blk=	Diacriticals_for_Symbols}', "");
    Expect(1, 8448, '\p{^Blk=	Diacriticals_for_Symbols}', "");
    Expect(1, 8448, '\P{Blk=	Diacriticals_for_Symbols}', "");
    Expect(0, 8448, '\P{^Blk=	Diacriticals_for_Symbols}', "");
    Error('\p{Is_Block=/a/-Combining_Marks_FOR_Symbols}');
    Error('\P{Is_Block=/a/-Combining_Marks_FOR_Symbols}');
    Expect(1, 8447, '\p{Is_Block=combiningmarksforsymbols}', "");
    Expect(0, 8447, '\p{^Is_Block=combiningmarksforsymbols}', "");
    Expect(0, 8447, '\P{Is_Block=combiningmarksforsymbols}', "");
    Expect(1, 8447, '\P{^Is_Block=combiningmarksforsymbols}', "");
    Expect(0, 8448, '\p{Is_Block=combiningmarksforsymbols}', "");
    Expect(1, 8448, '\p{^Is_Block=combiningmarksforsymbols}', "");
    Expect(1, 8448, '\P{Is_Block=combiningmarksforsymbols}', "");
    Expect(0, 8448, '\P{^Is_Block=combiningmarksforsymbols}', "");
    Expect(1, 8447, '\p{Is_Block= _combining_Marks_for_SYMBOLS}', "");
    Expect(0, 8447, '\p{^Is_Block= _combining_Marks_for_SYMBOLS}', "");
    Expect(0, 8447, '\P{Is_Block= _combining_Marks_for_SYMBOLS}', "");
    Expect(1, 8447, '\P{^Is_Block= _combining_Marks_for_SYMBOLS}', "");
    Expect(0, 8448, '\p{Is_Block= _combining_Marks_for_SYMBOLS}', "");
    Expect(1, 8448, '\p{^Is_Block= _combining_Marks_for_SYMBOLS}', "");
    Expect(1, 8448, '\P{Is_Block= _combining_Marks_for_SYMBOLS}', "");
    Expect(0, 8448, '\P{^Is_Block= _combining_Marks_for_SYMBOLS}', "");
    Error('\p{Is_Blk=-	Combining_Diacritical_Marks_FOR_Symbols/a/}');
    Error('\P{Is_Blk=-	Combining_Diacritical_Marks_FOR_Symbols/a/}');
    Expect(1, 8447, '\p{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8447, '\p{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8447, '\P{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8447, '\P{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8448, '\p{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8448, '\p{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8448, '\P{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(0, 8448, '\P{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
    Expect(1, 8447, '\p{Is_Blk=_combining_Diacritical_Marks_FOR_Symbols}', "");
    Expect(0, 8447, '\p{^Is_Blk=_combining_Diacritical_Marks_FOR_Symbols}', "");
    Expect(0, 8447, '\P{Is_Blk=_combining_Diacritical_Marks_FOR_Symbols}', "");
    Expect(1, 8447, '\P{^Is_Blk=_combining_Diacritical_Marks_FOR_Symbols}', "");
    Expect(0, 8448, '\p{Is_Blk=_combining_Diacritical_Marks_FOR_Symbols}', "");
    Expect(1, 8448, '\p{^Is_Blk=_combining_Diacritical_Marks_FOR_Symbols}', "");
    Expect(1, 8448, '\P{Is_Blk=_combining_Diacritical_Marks_FOR_Symbols}', "");
    Expect(0, 8448, '\P{^Is_Blk=_combining_Diacritical_Marks_FOR_Symbols}', "");
    Error('\p{Block:/a/  combining_Diacritical_MARKS_Supplement}');
    Error('\P{Block:/a/  combining_Diacritical_MARKS_Supplement}');
    Expect(1, 7679, '\p{Block=:\ACombining_Diacritical_Marks_Supplement\z:}', "");;
    Expect(0, 7680, '\p{Block=:\ACombining_Diacritical_Marks_Supplement\z:}', "");;
    Expect(1, 7679, '\p{Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7679, '\p{^Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7679, '\P{Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7679, '\P{^Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7680, '\p{Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7680, '\p{^Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7680, '\P{Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7680, '\P{^Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7679, '\p{Block=:\Acombiningdiacriticalmarkssupplement\z:}', "");;
    Expect(0, 7680, '\p{Block=:\Acombiningdiacriticalmarkssupplement\z:}', "");;
    Expect(1, 7679, '\p{Block=		Combining_diacritical_Marks_supplement}', "");
    Expect(0, 7679, '\p{^Block=		Combining_diacritical_Marks_supplement}', "");
    Expect(0, 7679, '\P{Block=		Combining_diacritical_Marks_supplement}', "");
    Expect(1, 7679, '\P{^Block=		Combining_diacritical_Marks_supplement}', "");
    Expect(0, 7680, '\p{Block=		Combining_diacritical_Marks_supplement}', "");
    Expect(1, 7680, '\p{^Block=		Combining_diacritical_Marks_supplement}', "");
    Expect(1, 7680, '\P{Block=		Combining_diacritical_Marks_supplement}', "");
    Expect(0, 7680, '\P{^Block=		Combining_diacritical_Marks_supplement}', "");
    Error('\p{Blk:   /a/-Diacriticals_SUP}');
    Error('\P{Blk:   /a/-Diacriticals_SUP}');
    Expect(1, 7679, '\p{Blk=:\ADiacriticals_Sup\z:}', "");;
    Expect(0, 7680, '\p{Blk=:\ADiacriticals_Sup\z:}', "");;
    Expect(1, 7679, '\p{Blk=diacriticalssup}', "");
    Expect(0, 7679, '\p{^Blk=diacriticalssup}', "");
    Expect(0, 7679, '\P{Blk=diacriticalssup}', "");
    Expect(1, 7679, '\P{^Blk=diacriticalssup}', "");
    Expect(0, 7680, '\p{Blk=diacriticalssup}', "");
    Expect(1, 7680, '\p{^Blk=diacriticalssup}', "");
    Expect(1, 7680, '\P{Blk=diacriticalssup}', "");
    Expect(0, 7680, '\P{^Blk=diacriticalssup}', "");
    Expect(1, 7679, '\p{Blk=:\Adiacriticalssup\z:}', "");;
    Expect(0, 7680, '\p{Blk=:\Adiacriticalssup\z:}', "");;
    Expect(1, 7679, '\p{Blk=- diacriticals_Sup}', "");
    Expect(0, 7679, '\p{^Blk=- diacriticals_Sup}', "");
    Expect(0, 7679, '\P{Blk=- diacriticals_Sup}', "");
    Expect(1, 7679, '\P{^Blk=- diacriticals_Sup}', "");
    Expect(0, 7680, '\p{Blk=- diacriticals_Sup}', "");
    Expect(1, 7680, '\p{^Blk=- diacriticals_Sup}', "");
    Expect(1, 7680, '\P{Blk=- diacriticals_Sup}', "");
    Expect(0, 7680, '\P{^Blk=- diacriticals_Sup}', "");
    Error('\p{Is_Block:   /a/Combining_Diacritical_Marks_Supplement}');
    Error('\P{Is_Block:   /a/Combining_Diacritical_Marks_Supplement}');
    Expect(1, 7679, '\p{Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7679, '\p{^Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7679, '\P{Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7679, '\P{^Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7680, '\p{Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7680, '\p{^Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7680, '\P{Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(0, 7680, '\P{^Is_Block=combiningdiacriticalmarkssupplement}', "");
    Expect(1, 7679, '\p{Is_Block=	 COMBINING_diacritical_Marks_Supplement}', "");
    Expect(0, 7679, '\p{^Is_Block=	 COMBINING_diacritical_Marks_Supplement}', "");
    Expect(0, 7679, '\P{Is_Block=	 COMBINING_diacritical_Marks_Supplement}', "");
    Expect(1, 7679, '\P{^Is_Block=	 COMBINING_diacritical_Marks_Supplement}', "");
    Expect(0, 7680, '\p{Is_Block=	 COMBINING_diacritical_Marks_Supplement}', "");
    Expect(1, 7680, '\p{^Is_Block=	 COMBINING_diacritical_Marks_Supplement}', "");
    Expect(1, 7680, '\P{Is_Block=	 COMBINING_diacritical_Marks_Supplement}', "");
    Expect(0, 7680, '\P{^Is_Block=	 COMBINING_diacritical_Marks_Supplement}', "");
    Error('\p{Is_Blk:   /a/_ Diacriticals_Sup}');
    Error('\P{Is_Blk:   /a/_ Diacriticals_Sup}');
    Expect(1, 7679, '\p{Is_Blk=diacriticalssup}', "");
    Expect(0, 7679, '\p{^Is_Blk=diacriticalssup}', "");
    Expect(0, 7679, '\P{Is_Blk=diacriticalssup}', "");
    Expect(1, 7679, '\P{^Is_Blk=diacriticalssup}', "");
    Expect(0, 7680, '\p{Is_Blk=diacriticalssup}', "");
    Expect(1, 7680, '\p{^Is_Blk=diacriticalssup}', "");
    Expect(1, 7680, '\P{Is_Blk=diacriticalssup}', "");
    Expect(0, 7680, '\P{^Is_Blk=diacriticalssup}', "");
    Expect(1, 7679, '\p{Is_Blk=  diacriticals_sup}', "");
    Expect(0, 7679, '\p{^Is_Blk=  diacriticals_sup}', "");
    Expect(0, 7679, '\P{Is_Blk=  diacriticals_sup}', "");
    Expect(1, 7679, '\P{^Is_Blk=  diacriticals_sup}', "");
    Expect(0, 7680, '\p{Is_Blk=  diacriticals_sup}', "");
    Expect(1, 7680, '\p{^Is_Blk=  diacriticals_sup}', "");
    Expect(1, 7680, '\P{Is_Blk=  diacriticals_sup}', "");
    Expect(0, 7680, '\P{^Is_Blk=  diacriticals_sup}', "");
    Error('\p{Block=-_Dingbats:=}');
    Error('\P{Block=-_Dingbats:=}');
    Expect(1, 10175, '\p{Block=:\ADingbats\z:}', "");;
    Expect(0, 10176, '\p{Block=:\ADingbats\z:}', "");;
    Expect(1, 10175, '\p{Block=dingbats}', "");
    Expect(0, 10175, '\p{^Block=dingbats}', "");
    Expect(0, 10175, '\P{Block=dingbats}', "");
    Expect(1, 10175, '\P{^Block=dingbats}', "");
    Expect(0, 10176, '\p{Block=dingbats}', "");
    Expect(1, 10176, '\p{^Block=dingbats}', "");
    Expect(1, 10176, '\P{Block=dingbats}', "");
    Expect(0, 10176, '\P{^Block=dingbats}', "");
    Expect(1, 10175, '\p{Block=:\Adingbats\z:}', "");;
    Expect(0, 10176, '\p{Block=:\Adingbats\z:}', "");;
    Expect(1, 10175, '\p{Block=- dingbats}', "");
    Expect(0, 10175, '\p{^Block=- dingbats}', "");
    Expect(0, 10175, '\P{Block=- dingbats}', "");
    Expect(1, 10175, '\P{^Block=- dingbats}', "");
    Expect(0, 10176, '\p{Block=- dingbats}', "");
    Expect(1, 10176, '\p{^Block=- dingbats}', "");
    Expect(1, 10176, '\P{Block=- dingbats}', "");
    Expect(0, 10176, '\P{^Block=- dingbats}', "");
    Error('\p{Blk=_	Dingbats:=}');
    Error('\P{Blk=_	Dingbats:=}');
    Expect(1, 10175, '\p{Blk=:\ADingbats\z:}', "");;
    Expect(0, 10176, '\p{Blk=:\ADingbats\z:}', "");;
    Expect(1, 10175, '\p{Blk=dingbats}', "");
    Expect(0, 10175, '\p{^Blk=dingbats}', "");
    Expect(0, 10175, '\P{Blk=dingbats}', "");
    Expect(1, 10175, '\P{^Blk=dingbats}', "");
    Expect(0, 10176, '\p{Blk=dingbats}', "");
    Expect(1, 10176, '\p{^Blk=dingbats}', "");
    Expect(1, 10176, '\P{Blk=dingbats}', "");
    Expect(0, 10176, '\P{^Blk=dingbats}', "");
    Expect(1, 10175, '\p{Blk=:\Adingbats\z:}', "");;
    Expect(0, 10176, '\p{Blk=:\Adingbats\z:}', "");;
    Expect(1, 10175, '\p{Blk=	DINGBATS}', "");
    Expect(0, 10175, '\p{^Blk=	DINGBATS}', "");
    Expect(0, 10175, '\P{Blk=	DINGBATS}', "");
    Expect(1, 10175, '\P{^Blk=	DINGBATS}', "");
    Expect(0, 10176, '\p{Blk=	DINGBATS}', "");
    Expect(1, 10176, '\p{^Blk=	DINGBATS}', "");
    Expect(1, 10176, '\P{Blk=	DINGBATS}', "");
    Expect(0, 10176, '\P{^Blk=	DINGBATS}', "");
    Error('\p{Is_Block:	 DINGBATS/a/}');
    Error('\P{Is_Block:	 DINGBATS/a/}');
    Expect(1, 10175, '\p{Is_Block:   dingbats}', "");
    Expect(0, 10175, '\p{^Is_Block:   dingbats}', "");
    Expect(0, 10175, '\P{Is_Block:   dingbats}', "");
    Expect(1, 10175, '\P{^Is_Block:   dingbats}', "");
    Expect(0, 10176, '\p{Is_Block:   dingbats}', "");
    Expect(1, 10176, '\p{^Is_Block:   dingbats}', "");
    Expect(1, 10176, '\P{Is_Block:   dingbats}', "");
    Expect(0, 10176, '\P{^Is_Block:   dingbats}', "");
    Expect(1, 10175, '\p{Is_Block=	 Dingbats}', "");
    Expect(0, 10175, '\p{^Is_Block=	 Dingbats}', "");
    Expect(0, 10175, '\P{Is_Block=	 Dingbats}', "");
    Expect(1, 10175, '\P{^Is_Block=	 Dingbats}', "");
    Expect(0, 10176, '\p{Is_Block=	 Dingbats}', "");
    Expect(1, 10176, '\p{^Is_Block=	 Dingbats}', "");
    Expect(1, 10176, '\P{Is_Block=	 Dingbats}', "");
    Expect(0, 10176, '\P{^Is_Block=	 Dingbats}', "");
    Error('\p{Is_Blk=	:=Dingbats}');
    Error('\P{Is_Blk=	:=Dingbats}');
    Expect(1, 10175, '\p{Is_Blk=dingbats}', "");
    Expect(0, 10175, '\p{^Is_Blk=dingbats}', "");
    Expect(0, 10175, '\P{Is_Blk=dingbats}', "");
    Expect(1, 10175, '\P{^Is_Blk=dingbats}', "");
    Expect(0, 10176, '\p{Is_Blk=dingbats}', "");
    Expect(1, 10176, '\p{^Is_Blk=dingbats}', "");
    Expect(1, 10176, '\P{Is_Blk=dingbats}', "");
    Expect(0, 10176, '\P{^Is_Blk=dingbats}', "");
    Expect(1, 10175, '\p{Is_Blk= DINGBATS}', "");
    Expect(0, 10175, '\p{^Is_Blk= DINGBATS}', "");
    Expect(0, 10175, '\P{Is_Blk= DINGBATS}', "");
    Expect(1, 10175, '\P{^Is_Blk= DINGBATS}', "");
    Expect(0, 10176, '\p{Is_Blk= DINGBATS}', "");
    Expect(1, 10176, '\p{^Is_Blk= DINGBATS}', "");
    Expect(1, 10176, '\P{Is_Blk= DINGBATS}', "");
    Expect(0, 10176, '\P{^Is_Blk= DINGBATS}', "");
    Error('\p{Block=-/a/Dives_AKURU}');
    Error('\P{Block=-/a/Dives_AKURU}');
    Expect(1, 72031, '\p{Block=:\ADives_Akuru\z:}', "");;
    Expect(0, 72032, '\p{Block=:\ADives_Akuru\z:}', "");;
    Expect(1, 72031, '\p{Block=divesakuru}', "");
    Expect(0, 72031, '\p{^Block=divesakuru}', "");
    Expect(0, 72031, '\P{Block=divesakuru}', "");
    Expect(1, 72031, '\P{^Block=divesakuru}', "");
    Expect(0, 72032, '\p{Block=divesakuru}', "");
    Expect(1, 72032, '\p{^Block=divesakuru}', "");
    Expect(1, 72032, '\P{Block=divesakuru}', "");
    Expect(0, 72032, '\P{^Block=divesakuru}', "");
    Expect(1, 72031, '\p{Block=:\Adivesakuru\z:}', "");;
    Expect(0, 72032, '\p{Block=:\Adivesakuru\z:}', "");;
    Expect(1, 72031, '\p{Block=-	dives_AKURU}', "");
    Expect(0, 72031, '\p{^Block=-	dives_AKURU}', "");
    Expect(0, 72031, '\P{Block=-	dives_AKURU}', "");
    Expect(1, 72031, '\P{^Block=-	dives_AKURU}', "");
    Expect(0, 72032, '\p{Block=-	dives_AKURU}', "");
    Expect(1, 72032, '\p{^Block=-	dives_AKURU}', "");
    Expect(1, 72032, '\P{Block=-	dives_AKURU}', "");
    Expect(0, 72032, '\P{^Block=-	dives_AKURU}', "");
    Error('\p{Blk=_/a/Dives_akuru}');
    Error('\P{Blk=_/a/Dives_akuru}');
    Expect(1, 72031, '\p{Blk=:\ADives_Akuru\z:}', "");;
    Expect(0, 72032, '\p{Blk=:\ADives_Akuru\z:}', "");;
    Expect(1, 72031, '\p{Blk=divesakuru}', "");
    Expect(0, 72031, '\p{^Blk=divesakuru}', "");
    Expect(0, 72031, '\P{Blk=divesakuru}', "");
    Expect(1, 72031, '\P{^Blk=divesakuru}', "");
    Expect(0, 72032, '\p{Blk=divesakuru}', "");
    Expect(1, 72032, '\p{^Blk=divesakuru}', "");
    Expect(1, 72032, '\P{Blk=divesakuru}', "");
    Expect(0, 72032, '\P{^Blk=divesakuru}', "");
    Expect(1, 72031, '\p{Blk=:\Adivesakuru\z:}', "");;
    Expect(0, 72032, '\p{Blk=:\Adivesakuru\z:}', "");;
    Expect(1, 72031, '\p{Blk= Dives_Akuru}', "");
    Expect(0, 72031, '\p{^Blk= Dives_Akuru}', "");
    Expect(0, 72031, '\P{Blk= Dives_Akuru}', "");
    Expect(1, 72031, '\P{^Blk= Dives_Akuru}', "");
    Expect(0, 72032, '\p{Blk= Dives_Akuru}', "");
    Expect(1, 72032, '\p{^Blk= Dives_Akuru}', "");
    Expect(1, 72032, '\P{Blk= Dives_Akuru}', "");
    Expect(0, 72032, '\P{^Blk= Dives_Akuru}', "");
    Error('\p{Is_Block=-/a/DIVES_akuru}');
    Error('\P{Is_Block=-/a/DIVES_akuru}');
    Expect(1, 72031, '\p{Is_Block=divesakuru}', "");
    Expect(0, 72031, '\p{^Is_Block=divesakuru}', "");
    Expect(0, 72031, '\P{Is_Block=divesakuru}', "");
    Expect(1, 72031, '\P{^Is_Block=divesakuru}', "");
    Expect(0, 72032, '\p{Is_Block=divesakuru}', "");
    Expect(1, 72032, '\p{^Is_Block=divesakuru}', "");
    Expect(1, 72032, '\P{Is_Block=divesakuru}', "");
    Expect(0, 72032, '\P{^Is_Block=divesakuru}', "");
    Expect(1, 72031, '\p{Is_Block=	Dives_Akuru}', "");
    Expect(0, 72031, '\p{^Is_Block=	Dives_Akuru}', "");
    Expect(0, 72031, '\P{Is_Block=	Dives_Akuru}', "");
    Expect(1, 72031, '\P{^Is_Block=	Dives_Akuru}', "");
    Expect(0, 72032, '\p{Is_Block=	Dives_Akuru}', "");
    Expect(1, 72032, '\p{^Is_Block=	Dives_Akuru}', "");
    Expect(1, 72032, '\P{Is_Block=	Dives_Akuru}', "");
    Expect(0, 72032, '\P{^Is_Block=	Dives_Akuru}', "");
    Error('\p{Is_Blk=:=_DIVES_Akuru}');
    Error('\P{Is_Blk=:=_DIVES_Akuru}');
    Expect(1, 72031, '\p{Is_Blk=divesakuru}', "");
    Expect(0, 72031, '\p{^Is_Blk=divesakuru}', "");
    Expect(0, 72031, '\P{Is_Blk=divesakuru}', "");
    Expect(1, 72031, '\P{^Is_Blk=divesakuru}', "");
    Expect(0, 72032, '\p{Is_Blk=divesakuru}', "");
    Expect(1, 72032, '\p{^Is_Blk=divesakuru}', "");
    Expect(1, 72032, '\P{Is_Blk=divesakuru}', "");
    Expect(0, 72032, '\P{^Is_Blk=divesakuru}', "");
    Expect(1, 72031, '\p{Is_Blk: DIVES_Akuru}', "");
    Expect(0, 72031, '\p{^Is_Blk: DIVES_Akuru}', "");
    Expect(0, 72031, '\P{Is_Blk: DIVES_Akuru}', "");
    Expect(1, 72031, '\P{^Is_Blk: DIVES_Akuru}', "");
    Expect(0, 72032, '\p{Is_Blk: DIVES_Akuru}', "");
    Expect(1, 72032, '\p{^Is_Blk: DIVES_Akuru}', "");
    Expect(1, 72032, '\P{Is_Blk: DIVES_Akuru}', "");
    Expect(0, 72032, '\P{^Is_Blk: DIVES_Akuru}', "");
    Error('\p{Block=:=  Dogra}');
    Error('\P{Block=:=  Dogra}');
    Expect(1, 71759, '\p{Block=:\ADogra\z:}', "");;
    Expect(0, 71760, '\p{Block=:\ADogra\z:}', "");;
    Expect(1, 71759, '\p{Block=dogra}', "");
    Expect(0, 71759, '\p{^Block=dogra}', "");
    Expect(0, 71759, '\P{Block=dogra}', "");
    Expect(1, 71759, '\P{^Block=dogra}', "");
    Expect(0, 71760, '\p{Block=dogra}', "");
    Expect(1, 71760, '\p{^Block=dogra}', "");
    Expect(1, 71760, '\P{Block=dogra}', "");
    Expect(0, 71760, '\P{^Block=dogra}', "");
    Expect(1, 71759, '\p{Block=:\Adogra\z:}', "");;
    Expect(0, 71760, '\p{Block=:\Adogra\z:}', "");;
    Expect(1, 71759, '\p{Block: _-DOGRA}', "");
    Expect(0, 71759, '\p{^Block: _-DOGRA}', "");
    Expect(0, 71759, '\P{Block: _-DOGRA}', "");
    Expect(1, 71759, '\P{^Block: _-DOGRA}', "");
    Expect(0, 71760, '\p{Block: _-DOGRA}', "");
    Expect(1, 71760, '\p{^Block: _-DOGRA}', "");
    Expect(1, 71760, '\P{Block: _-DOGRA}', "");
    Expect(0, 71760, '\P{^Block: _-DOGRA}', "");
    Error('\p{Blk=:=Dogra}');
    Error('\P{Blk=:=Dogra}');
    Expect(1, 71759, '\p{Blk=:\ADogra\z:}', "");;
    Expect(0, 71760, '\p{Blk=:\ADogra\z:}', "");;
    Expect(1, 71759, '\p{Blk=dogra}', "");
    Expect(0, 71759, '\p{^Blk=dogra}', "");
    Expect(0, 71759, '\P{Blk=dogra}', "");
    Expect(1, 71759, '\P{^Blk=dogra}', "");
    Expect(0, 71760, '\p{Blk=dogra}', "");
    Expect(1, 71760, '\p{^Blk=dogra}', "");
    Expect(1, 71760, '\P{Blk=dogra}', "");
    Expect(0, 71760, '\P{^Blk=dogra}', "");
    Expect(1, 71759, '\p{Blk=:\Adogra\z:}', "");;
    Expect(0, 71760, '\p{Blk=:\Adogra\z:}', "");;
    Expect(1, 71759, '\p{Blk=		Dogra}', "");
    Expect(0, 71759, '\p{^Blk=		Dogra}', "");
    Expect(0, 71759, '\P{Blk=		Dogra}', "");
    Expect(1, 71759, '\P{^Blk=		Dogra}', "");
    Expect(0, 71760, '\p{Blk=		Dogra}', "");
    Expect(1, 71760, '\p{^Blk=		Dogra}', "");
    Expect(1, 71760, '\P{Blk=		Dogra}', "");
    Expect(0, 71760, '\P{^Blk=		Dogra}', "");
    Error('\p{Is_Block= /a/Dogra}');
    Error('\P{Is_Block= /a/Dogra}');
    Expect(1, 71759, '\p{Is_Block=dogra}', "");
    Expect(0, 71759, '\p{^Is_Block=dogra}', "");
    Expect(0, 71759, '\P{Is_Block=dogra}', "");
    Expect(1, 71759, '\P{^Is_Block=dogra}', "");
    Expect(0, 71760, '\p{Is_Block=dogra}', "");
    Expect(1, 71760, '\p{^Is_Block=dogra}', "");
    Expect(1, 71760, '\P{Is_Block=dogra}', "");
    Expect(0, 71760, '\P{^Is_Block=dogra}', "");
    Expect(1, 71759, '\p{Is_Block=- Dogra}', "");
    Expect(0, 71759, '\p{^Is_Block=- Dogra}', "");
    Expect(0, 71759, '\P{Is_Block=- Dogra}', "");
    Expect(1, 71759, '\P{^Is_Block=- Dogra}', "");
    Expect(0, 71760, '\p{Is_Block=- Dogra}', "");
    Expect(1, 71760, '\p{^Is_Block=- Dogra}', "");
    Expect(1, 71760, '\P{Is_Block=- Dogra}', "");
    Expect(0, 71760, '\P{^Is_Block=- Dogra}', "");
    Error('\p{Is_Blk=	-DOGRA:=}');
    Error('\P{Is_Blk=	-DOGRA:=}');
    Expect(1, 71759, '\p{Is_Blk=dogra}', "");
    Expect(0, 71759, '\p{^Is_Blk=dogra}', "");
    Expect(0, 71759, '\P{Is_Blk=dogra}', "");
    Expect(1, 71759, '\P{^Is_Blk=dogra}', "");
    Expect(0, 71760, '\p{Is_Blk=dogra}', "");
    Expect(1, 71760, '\p{^Is_Blk=dogra}', "");
    Expect(1, 71760, '\P{Is_Blk=dogra}', "");
    Expect(0, 71760, '\P{^Is_Blk=dogra}', "");
    Expect(1, 71759, '\p{Is_Blk=_Dogra}', "");
    Expect(0, 71759, '\p{^Is_Blk=_Dogra}', "");
    Expect(0, 71759, '\P{Is_Blk=_Dogra}', "");
    Expect(1, 71759, '\P{^Is_Blk=_Dogra}', "");
    Expect(0, 71760, '\p{Is_Blk=_Dogra}', "");
    Expect(1, 71760, '\p{^Is_Blk=_Dogra}', "");
    Expect(1, 71760, '\P{Is_Blk=_Dogra}', "");
    Expect(0, 71760, '\P{^Is_Blk=_Dogra}', "");
    Error('\p{Block=	/a/DOMINO_TILES}');
    Error('\P{Block=	/a/DOMINO_TILES}');
    Expect(1, 127135, '\p{Block=:\ADomino_Tiles\z:}', "");;
    Expect(0, 127136, '\p{Block=:\ADomino_Tiles\z:}', "");;
    Expect(1, 127135, '\p{Block=dominotiles}', "");
    Expect(0, 127135, '\p{^Block=dominotiles}', "");
    Expect(0, 127135, '\P{Block=dominotiles}', "");
    Expect(1, 127135, '\P{^Block=dominotiles}', "");
    Expect(0, 127136, '\p{Block=dominotiles}', "");
    Expect(1, 127136, '\p{^Block=dominotiles}', "");
    Expect(1, 127136, '\P{Block=dominotiles}', "");
    Expect(0, 127136, '\P{^Block=dominotiles}', "");
    Expect(1, 127135, '\p{Block=:\Adominotiles\z:}', "");;
    Expect(0, 127136, '\p{Block=:\Adominotiles\z:}', "");;
    Expect(1, 127135, '\p{Block=	 Domino_Tiles}', "");
    Expect(0, 127135, '\p{^Block=	 Domino_Tiles}', "");
    Expect(0, 127135, '\P{Block=	 Domino_Tiles}', "");
    Expect(1, 127135, '\P{^Block=	 Domino_Tiles}', "");
    Expect(0, 127136, '\p{Block=	 Domino_Tiles}', "");
    Expect(1, 127136, '\p{^Block=	 Domino_Tiles}', "");
    Expect(1, 127136, '\P{Block=	 Domino_Tiles}', "");
    Expect(0, 127136, '\P{^Block=	 Domino_Tiles}', "");
    Error('\p{Blk=:=__Domino}');
    Error('\P{Blk=:=__Domino}');
    Expect(1, 127135, '\p{Blk=:\ADomino\z:}', "");;
    Expect(0, 127136, '\p{Blk=:\ADomino\z:}', "");;
    Expect(1, 127135, '\p{Blk: domino}', "");
    Expect(0, 127135, '\p{^Blk: domino}', "");
    Expect(0, 127135, '\P{Blk: domino}', "");
    Expect(1, 127135, '\P{^Blk: domino}', "");
    Expect(0, 127136, '\p{Blk: domino}', "");
    Expect(1, 127136, '\p{^Blk: domino}', "");
    Expect(1, 127136, '\P{Blk: domino}', "");
    Expect(0, 127136, '\P{^Blk: domino}', "");
    Expect(1, 127135, '\p{Blk=:\Adomino\z:}', "");;
    Expect(0, 127136, '\p{Blk=:\Adomino\z:}', "");;
    Expect(1, 127135, '\p{Blk= Domino}', "");
    Expect(0, 127135, '\p{^Blk= Domino}', "");
    Expect(0, 127135, '\P{Blk= Domino}', "");
    Expect(1, 127135, '\P{^Blk= Domino}', "");
    Expect(0, 127136, '\p{Blk= Domino}', "");
    Expect(1, 127136, '\p{^Blk= Domino}', "");
    Expect(1, 127136, '\P{Blk= Domino}', "");
    Expect(0, 127136, '\P{^Blk= Domino}', "");
    Error('\p{Is_Block: := -Domino_Tiles}');
    Error('\P{Is_Block: := -Domino_Tiles}');
    Expect(1, 127135, '\p{Is_Block=dominotiles}', "");
    Expect(0, 127135, '\p{^Is_Block=dominotiles}', "");
    Expect(0, 127135, '\P{Is_Block=dominotiles}', "");
    Expect(1, 127135, '\P{^Is_Block=dominotiles}', "");
    Expect(0, 127136, '\p{Is_Block=dominotiles}', "");
    Expect(1, 127136, '\p{^Is_Block=dominotiles}', "");
    Expect(1, 127136, '\P{Is_Block=dominotiles}', "");
    Expect(0, 127136, '\P{^Is_Block=dominotiles}', "");
    Expect(1, 127135, '\p{Is_Block= Domino_Tiles}', "");
    Expect(0, 127135, '\p{^Is_Block= Domino_Tiles}', "");
    Expect(0, 127135, '\P{Is_Block= Domino_Tiles}', "");
    Expect(1, 127135, '\P{^Is_Block= Domino_Tiles}', "");
    Expect(0, 127136, '\p{Is_Block= Domino_Tiles}', "");
    Expect(1, 127136, '\p{^Is_Block= Domino_Tiles}', "");
    Expect(1, 127136, '\P{Is_Block= Domino_Tiles}', "");
    Expect(0, 127136, '\P{^Is_Block= Domino_Tiles}', "");
    Error('\p{Is_Blk=-	DOMINO:=}');
    Error('\P{Is_Blk=-	DOMINO:=}');
    Expect(1, 127135, '\p{Is_Blk=domino}', "");
    Expect(0, 127135, '\p{^Is_Blk=domino}', "");
    Expect(0, 127135, '\P{Is_Blk=domino}', "");
    Expect(1, 127135, '\P{^Is_Blk=domino}', "");
    Expect(0, 127136, '\p{Is_Blk=domino}', "");
    Expect(1, 127136, '\p{^Is_Blk=domino}', "");
    Expect(1, 127136, '\P{Is_Blk=domino}', "");
    Expect(0, 127136, '\P{^Is_Blk=domino}', "");
    Expect(1, 127135, '\p{Is_Blk=-	DOMINO}', "");
    Expect(0, 127135, '\p{^Is_Blk=-	DOMINO}', "");
    Expect(0, 127135, '\P{Is_Blk=-	DOMINO}', "");
    Expect(1, 127135, '\P{^Is_Blk=-	DOMINO}', "");
    Expect(0, 127136, '\p{Is_Blk=-	DOMINO}', "");
    Expect(1, 127136, '\p{^Is_Blk=-	DOMINO}', "");
    Expect(1, 127136, '\P{Is_Blk=-	DOMINO}', "");
    Expect(0, 127136, '\P{^Is_Blk=-	DOMINO}', "");
    Error('\p{Block=_Duployan:=}');
    Error('\P{Block=_Duployan:=}');
    Expect(1, 113823, '\p{Block=:\ADuployan\z:}', "");;
    Expect(0, 113824, '\p{Block=:\ADuployan\z:}', "");;
    Expect(1, 113823, '\p{Block=duployan}', "");
    Expect(0, 113823, '\p{^Block=duployan}', "");
    Expect(0, 113823, '\P{Block=duployan}', "");
    Expect(1, 113823, '\P{^Block=duployan}', "");
    Expect(0, 113824, '\p{Block=duployan}', "");
    Expect(1, 113824, '\p{^Block=duployan}', "");
    Expect(1, 113824, '\P{Block=duployan}', "");
    Expect(0, 113824, '\P{^Block=duployan}', "");
    Expect(1, 113823, '\p{Block=:\Aduployan\z:}', "");;
    Expect(0, 113824, '\p{Block=:\Aduployan\z:}', "");;
    Expect(1, 113823, '\p{Block=-	duployan}', "");
    Expect(0, 113823, '\p{^Block=-	duployan}', "");
    Expect(0, 113823, '\P{Block=-	duployan}', "");
    Expect(1, 113823, '\P{^Block=-	duployan}', "");
    Expect(0, 113824, '\p{Block=-	duployan}', "");
    Expect(1, 113824, '\p{^Block=-	duployan}', "");
    Expect(1, 113824, '\P{Block=-	duployan}', "");
    Expect(0, 113824, '\P{^Block=-	duployan}', "");
    Error('\p{Blk=/a/ 	DUPLOYAN}');
    Error('\P{Blk=/a/ 	DUPLOYAN}');
    Expect(1, 113823, '\p{Blk=:\ADuployan\z:}', "");;
    Expect(0, 113824, '\p{Blk=:\ADuployan\z:}', "");;
    Expect(1, 113823, '\p{Blk=duployan}', "");
    Expect(0, 113823, '\p{^Blk=duployan}', "");
    Expect(0, 113823, '\P{Blk=duployan}', "");
    Expect(1, 113823, '\P{^Blk=duployan}', "");
    Expect(0, 113824, '\p{Blk=duployan}', "");
    Expect(1, 113824, '\p{^Blk=duployan}', "");
    Expect(1, 113824, '\P{Blk=duployan}', "");
    Expect(0, 113824, '\P{^Blk=duployan}', "");
    Expect(1, 113823, '\p{Blk=:\Aduployan\z:}', "");;
    Expect(0, 113824, '\p{Blk=:\Aduployan\z:}', "");;
    Expect(1, 113823, '\p{Blk=__Duployan}', "");
    Expect(0, 113823, '\p{^Blk=__Duployan}', "");
    Expect(0, 113823, '\P{Blk=__Duployan}', "");
    Expect(1, 113823, '\P{^Blk=__Duployan}', "");
    Expect(0, 113824, '\p{Blk=__Duployan}', "");
    Expect(1, 113824, '\p{^Blk=__Duployan}', "");
    Expect(1, 113824, '\P{Blk=__Duployan}', "");
    Expect(0, 113824, '\P{^Blk=__Duployan}', "");
    Error('\p{Is_Block=	/a/Duployan}');
    Error('\P{Is_Block=	/a/Duployan}');
    Expect(1, 113823, '\p{Is_Block=duployan}', "");
    Expect(0, 113823, '\p{^Is_Block=duployan}', "");
    Expect(0, 113823, '\P{Is_Block=duployan}', "");
    Expect(1, 113823, '\P{^Is_Block=duployan}', "");
    Expect(0, 113824, '\p{Is_Block=duployan}', "");
    Expect(1, 113824, '\p{^Is_Block=duployan}', "");
    Expect(1, 113824, '\P{Is_Block=duployan}', "");
    Expect(0, 113824, '\P{^Is_Block=duployan}', "");
    Expect(1, 113823, '\p{Is_Block=- Duployan}', "");
    Expect(0, 113823, '\p{^Is_Block=- Duployan}', "");
    Expect(0, 113823, '\P{Is_Block=- Duployan}', "");
    Expect(1, 113823, '\P{^Is_Block=- Duployan}', "");
    Expect(0, 113824, '\p{Is_Block=- Duployan}', "");
    Expect(1, 113824, '\p{^Is_Block=- Duployan}', "");
    Expect(1, 113824, '\P{Is_Block=- Duployan}', "");
    Expect(0, 113824, '\P{^Is_Block=- Duployan}', "");
    Error('\p{Is_Blk=_	Duployan/a/}');
    Error('\P{Is_Blk=_	Duployan/a/}');
    Expect(1, 113823, '\p{Is_Blk:   duployan}', "");
    Expect(0, 113823, '\p{^Is_Blk:   duployan}', "");
    Expect(0, 113823, '\P{Is_Blk:   duployan}', "");
    Expect(1, 113823, '\P{^Is_Blk:   duployan}', "");
    Expect(0, 113824, '\p{Is_Blk:   duployan}', "");
    Expect(1, 113824, '\p{^Is_Blk:   duployan}', "");
    Expect(1, 113824, '\P{Is_Blk:   duployan}', "");
    Expect(0, 113824, '\P{^Is_Blk:   duployan}', "");
    Expect(1, 113823, '\p{Is_Blk: -_duployan}', "");
    Expect(0, 113823, '\p{^Is_Blk: -_duployan}', "");
    Expect(0, 113823, '\P{Is_Blk: -_duployan}', "");
    Expect(1, 113823, '\P{^Is_Blk: -_duployan}', "");
    Expect(0, 113824, '\p{Is_Blk: -_duployan}', "");
    Expect(1, 113824, '\p{^Is_Blk: -_duployan}', "");
    Expect(1, 113824, '\P{Is_Blk: -_duployan}', "");
    Expect(0, 113824, '\P{^Is_Blk: -_duployan}', "");
    Error('\p{Block=	early_Dynastic_Cuneiform/a/}');
    Error('\P{Block=	early_Dynastic_Cuneiform/a/}');
    Expect(1, 75087, '\p{Block=:\AEarly_Dynastic_Cuneiform\z:}', "");;
    Expect(0, 75088, '\p{Block=:\AEarly_Dynastic_Cuneiform\z:}', "");;
    Expect(1, 75087, '\p{Block=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\p{^Block=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\P{Block=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\P{^Block=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\p{Block=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\p{^Block=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\P{Block=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\P{^Block=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\p{Block=:\Aearlydynasticcuneiform\z:}', "");;
    Expect(0, 75088, '\p{Block=:\Aearlydynasticcuneiform\z:}', "");;
    Expect(1, 75087, '\p{Block=--EARLY_Dynastic_Cuneiform}', "");
    Expect(0, 75087, '\p{^Block=--EARLY_Dynastic_Cuneiform}', "");
    Expect(0, 75087, '\P{Block=--EARLY_Dynastic_Cuneiform}', "");
    Expect(1, 75087, '\P{^Block=--EARLY_Dynastic_Cuneiform}', "");
    Expect(0, 75088, '\p{Block=--EARLY_Dynastic_Cuneiform}', "");
    Expect(1, 75088, '\p{^Block=--EARLY_Dynastic_Cuneiform}', "");
    Expect(1, 75088, '\P{Block=--EARLY_Dynastic_Cuneiform}', "");
    Expect(0, 75088, '\P{^Block=--EARLY_Dynastic_Cuneiform}', "");
    Error('\p{Blk=	Early_Dynastic_CUNEIFORM:=}');
    Error('\P{Blk=	Early_Dynastic_CUNEIFORM:=}');
    Expect(1, 75087, '\p{Blk=:\AEarly_Dynastic_Cuneiform\z:}', "");;
    Expect(0, 75088, '\p{Blk=:\AEarly_Dynastic_Cuneiform\z:}', "");;
    Expect(1, 75087, '\p{Blk=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\p{^Blk=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\P{Blk=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\P{^Blk=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\p{Blk=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\p{^Blk=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\P{Blk=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\P{^Blk=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\p{Blk=:\Aearlydynasticcuneiform\z:}', "");;
    Expect(0, 75088, '\p{Blk=:\Aearlydynasticcuneiform\z:}', "");;
    Expect(1, 75087, '\p{Blk=_EARLY_dynastic_cuneiform}', "");
    Expect(0, 75087, '\p{^Blk=_EARLY_dynastic_cuneiform}', "");
    Expect(0, 75087, '\P{Blk=_EARLY_dynastic_cuneiform}', "");
    Expect(1, 75087, '\P{^Blk=_EARLY_dynastic_cuneiform}', "");
    Expect(0, 75088, '\p{Blk=_EARLY_dynastic_cuneiform}', "");
    Expect(1, 75088, '\p{^Blk=_EARLY_dynastic_cuneiform}', "");
    Expect(1, 75088, '\P{Blk=_EARLY_dynastic_cuneiform}', "");
    Expect(0, 75088, '\P{^Blk=_EARLY_dynastic_cuneiform}', "");
    Error('\p{Is_Block:/a/ -Early_Dynastic_cuneiform}');
    Error('\P{Is_Block:/a/ -Early_Dynastic_cuneiform}');
    Expect(1, 75087, '\p{Is_Block=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\p{^Is_Block=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\P{Is_Block=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\P{^Is_Block=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\p{Is_Block=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\p{^Is_Block=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\P{Is_Block=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\P{^Is_Block=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\p{Is_Block=	 Early_DYNASTIC_Cuneiform}', "");
    Expect(0, 75087, '\p{^Is_Block=	 Early_DYNASTIC_Cuneiform}', "");
    Expect(0, 75087, '\P{Is_Block=	 Early_DYNASTIC_Cuneiform}', "");
    Expect(1, 75087, '\P{^Is_Block=	 Early_DYNASTIC_Cuneiform}', "");
    Expect(0, 75088, '\p{Is_Block=	 Early_DYNASTIC_Cuneiform}', "");
    Expect(1, 75088, '\p{^Is_Block=	 Early_DYNASTIC_Cuneiform}', "");
    Expect(1, 75088, '\P{Is_Block=	 Early_DYNASTIC_Cuneiform}', "");
    Expect(0, 75088, '\P{^Is_Block=	 Early_DYNASTIC_Cuneiform}', "");
    Error('\p{Is_Blk=-:=Early_Dynastic_CUNEIFORM}');
    Error('\P{Is_Blk=-:=Early_Dynastic_CUNEIFORM}');
    Expect(1, 75087, '\p{Is_Blk=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\p{^Is_Blk=earlydynasticcuneiform}', "");
    Expect(0, 75087, '\P{Is_Blk=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\P{^Is_Blk=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\p{Is_Blk=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\p{^Is_Blk=earlydynasticcuneiform}', "");
    Expect(1, 75088, '\P{Is_Blk=earlydynasticcuneiform}', "");
    Expect(0, 75088, '\P{^Is_Blk=earlydynasticcuneiform}', "");
    Expect(1, 75087, '\p{Is_Blk=-EARLY_Dynastic_Cuneiform}', "");
    Expect(0, 75087, '\p{^Is_Blk=-EARLY_Dynastic_Cuneiform}', "");
    Expect(0, 75087, '\P{Is_Blk=-EARLY_Dynastic_Cuneiform}', "");
    Expect(1, 75087, '\P{^Is_Blk=-EARLY_Dynastic_Cuneiform}', "");
    Expect(0, 75088, '\p{Is_Blk=-EARLY_Dynastic_Cuneiform}', "");
    Expect(1, 75088, '\p{^Is_Blk=-EARLY_Dynastic_Cuneiform}', "");
    Expect(1, 75088, '\P{Is_Blk=-EARLY_Dynastic_Cuneiform}', "");
    Expect(0, 75088, '\P{^Is_Blk=-EARLY_Dynastic_Cuneiform}', "");
    Error('\p{Block:_egyptian_HIEROGLYPH_FORMAT_Controls:=}');
    Error('\P{Block:_egyptian_HIEROGLYPH_FORMAT_Controls:=}');
    Expect(1, 78911, '\p{Block=:\AEgyptian_Hieroglyph_Format_Controls\z:}', "");;
    Expect(0, 78912, '\p{Block=:\AEgyptian_Hieroglyph_Format_Controls\z:}', "");;
    Expect(1, 78911, '\p{Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\p{^Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\P{Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\P{^Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\p{Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\p{^Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\P{Block=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\P{^Block=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\p{Block=:\Aegyptianhieroglyphformatcontrols\z:}', "");;
    Expect(0, 78912, '\p{Block=:\Aegyptianhieroglyphformatcontrols\z:}', "");;
    Expect(1, 78911, '\p{Block= -Egyptian_Hieroglyph_FORMAT_Controls}', "");
    Expect(0, 78911, '\p{^Block= -Egyptian_Hieroglyph_FORMAT_Controls}', "");
    Expect(0, 78911, '\P{Block= -Egyptian_Hieroglyph_FORMAT_Controls}', "");
    Expect(1, 78911, '\P{^Block= -Egyptian_Hieroglyph_FORMAT_Controls}', "");
    Expect(0, 78912, '\p{Block= -Egyptian_Hieroglyph_FORMAT_Controls}', "");
    Expect(1, 78912, '\p{^Block= -Egyptian_Hieroglyph_FORMAT_Controls}', "");
    Expect(1, 78912, '\P{Block= -Egyptian_Hieroglyph_FORMAT_Controls}', "");
    Expect(0, 78912, '\P{^Block= -Egyptian_Hieroglyph_FORMAT_Controls}', "");
    Error('\p{Blk=/a/--egyptian_Hieroglyph_Format_controls}');
    Error('\P{Blk=/a/--egyptian_Hieroglyph_Format_controls}');
    Expect(1, 78911, '\p{Blk=:\AEgyptian_Hieroglyph_Format_Controls\z:}', "");;
    Expect(0, 78912, '\p{Blk=:\AEgyptian_Hieroglyph_Format_Controls\z:}', "");;
    Expect(1, 78911, '\p{Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\p{^Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\P{Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\P{^Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\p{Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\p{^Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\P{Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\P{^Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\p{Blk=:\Aegyptianhieroglyphformatcontrols\z:}', "");;
    Expect(0, 78912, '\p{Blk=:\Aegyptianhieroglyphformatcontrols\z:}', "");;
    Expect(1, 78911, '\p{Blk=	 EGYPTIAN_Hieroglyph_FORMAT_CONTROLS}', "");
    Expect(0, 78911, '\p{^Blk=	 EGYPTIAN_Hieroglyph_FORMAT_CONTROLS}', "");
    Expect(0, 78911, '\P{Blk=	 EGYPTIAN_Hieroglyph_FORMAT_CONTROLS}', "");
    Expect(1, 78911, '\P{^Blk=	 EGYPTIAN_Hieroglyph_FORMAT_CONTROLS}', "");
    Expect(0, 78912, '\p{Blk=	 EGYPTIAN_Hieroglyph_FORMAT_CONTROLS}', "");
    Expect(1, 78912, '\p{^Blk=	 EGYPTIAN_Hieroglyph_FORMAT_CONTROLS}', "");
    Expect(1, 78912, '\P{Blk=	 EGYPTIAN_Hieroglyph_FORMAT_CONTROLS}', "");
    Expect(0, 78912, '\P{^Blk=	 EGYPTIAN_Hieroglyph_FORMAT_CONTROLS}', "");
    Error('\p{Is_Block=-	Egyptian_hieroglyph_format_controls/a/}');
    Error('\P{Is_Block=-	Egyptian_hieroglyph_format_controls/a/}');
    Expect(1, 78911, '\p{Is_Block:egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\p{^Is_Block:egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\P{Is_Block:egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\P{^Is_Block:egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\p{Is_Block:egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\p{^Is_Block:egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\P{Is_Block:egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\P{^Is_Block:egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\p{Is_Block= Egyptian_Hieroglyph_Format_controls}', "");
    Expect(0, 78911, '\p{^Is_Block= Egyptian_Hieroglyph_Format_controls}', "");
    Expect(0, 78911, '\P{Is_Block= Egyptian_Hieroglyph_Format_controls}', "");
    Expect(1, 78911, '\P{^Is_Block= Egyptian_Hieroglyph_Format_controls}', "");
    Expect(0, 78912, '\p{Is_Block= Egyptian_Hieroglyph_Format_controls}', "");
    Expect(1, 78912, '\p{^Is_Block= Egyptian_Hieroglyph_Format_controls}', "");
    Expect(1, 78912, '\P{Is_Block= Egyptian_Hieroglyph_Format_controls}', "");
    Expect(0, 78912, '\P{^Is_Block= Egyptian_Hieroglyph_Format_controls}', "");
    Error('\p{Is_Blk=:=egyptian_Hieroglyph_Format_Controls}');
    Error('\P{Is_Blk=:=egyptian_Hieroglyph_Format_Controls}');
    Expect(1, 78911, '\p{Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\p{^Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78911, '\P{Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\P{^Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\p{Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\p{^Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78912, '\P{Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(0, 78912, '\P{^Is_Blk=egyptianhieroglyphformatcontrols}', "");
    Expect(1, 78911, '\p{Is_Blk=-	EGYPTIAN_Hieroglyph_Format_Controls}', "");
    Expect(0, 78911, '\p{^Is_Blk=-	EGYPTIAN_Hieroglyph_Format_Controls}', "");
    Expect(0, 78911, '\P{Is_Blk=-	EGYPTIAN_Hieroglyph_Format_Controls}', "");
    Expect(1, 78911, '\P{^Is_Blk=-	EGYPTIAN_Hieroglyph_Format_Controls}', "");
    Expect(0, 78912, '\p{Is_Blk=-	EGYPTIAN_Hieroglyph_Format_Controls}', "");
    Expect(1, 78912, '\p{^Is_Blk=-	EGYPTIAN_Hieroglyph_Format_Controls}', "");
    Expect(1, 78912, '\P{Is_Blk=-	EGYPTIAN_Hieroglyph_Format_Controls}', "");
    Expect(0, 78912, '\P{^Is_Blk=-	EGYPTIAN_Hieroglyph_Format_Controls}', "");
    Error('\p{Block=:=EGYPTIAN_Hieroglyphs}');
    Error('\P{Block=:=EGYPTIAN_Hieroglyphs}');
    Expect(1, 78895, '\p{Block=:\AEgyptian_Hieroglyphs\z:}', "");;
    Expect(0, 78896, '\p{Block=:\AEgyptian_Hieroglyphs\z:}', "");;
    Expect(1, 78895, '\p{Block=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\p{^Block=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\P{Block=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\P{^Block=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\p{Block=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\p{^Block=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\P{Block=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\P{^Block=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\p{Block=:\Aegyptianhieroglyphs\z:}', "");;
    Expect(0, 78896, '\p{Block=:\Aegyptianhieroglyphs\z:}', "");;
    Expect(1, 78895, '\p{Block=		egyptian_HIEROGLYPHS}', "");
    Expect(0, 78895, '\p{^Block=		egyptian_HIEROGLYPHS}', "");
    Expect(0, 78895, '\P{Block=		egyptian_HIEROGLYPHS}', "");
    Expect(1, 78895, '\P{^Block=		egyptian_HIEROGLYPHS}', "");
    Expect(0, 78896, '\p{Block=		egyptian_HIEROGLYPHS}', "");
    Expect(1, 78896, '\p{^Block=		egyptian_HIEROGLYPHS}', "");
    Expect(1, 78896, '\P{Block=		egyptian_HIEROGLYPHS}', "");
    Expect(0, 78896, '\P{^Block=		egyptian_HIEROGLYPHS}', "");
    Error('\p{Blk=/a/_	Egyptian_Hieroglyphs}');
    Error('\P{Blk=/a/_	Egyptian_Hieroglyphs}');
    Expect(1, 78895, '\p{Blk=:\AEgyptian_Hieroglyphs\z:}', "");;
    Expect(0, 78896, '\p{Blk=:\AEgyptian_Hieroglyphs\z:}', "");;
    Expect(1, 78895, '\p{Blk=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\p{^Blk=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\P{Blk=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\P{^Blk=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\p{Blk=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\p{^Blk=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\P{Blk=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\P{^Blk=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\p{Blk=:\Aegyptianhieroglyphs\z:}', "");;
    Expect(0, 78896, '\p{Blk=:\Aegyptianhieroglyphs\z:}', "");;
    Expect(1, 78895, '\p{Blk=-_egyptian_hieroglyphs}', "");
    Expect(0, 78895, '\p{^Blk=-_egyptian_hieroglyphs}', "");
    Expect(0, 78895, '\P{Blk=-_egyptian_hieroglyphs}', "");
    Expect(1, 78895, '\P{^Blk=-_egyptian_hieroglyphs}', "");
    Expect(0, 78896, '\p{Blk=-_egyptian_hieroglyphs}', "");
    Expect(1, 78896, '\p{^Blk=-_egyptian_hieroglyphs}', "");
    Expect(1, 78896, '\P{Blk=-_egyptian_hieroglyphs}', "");
    Expect(0, 78896, '\P{^Blk=-_egyptian_hieroglyphs}', "");
    Error('\p{Is_Block=:=_Egyptian_Hieroglyphs}');
    Error('\P{Is_Block=:=_Egyptian_Hieroglyphs}');
    Expect(1, 78895, '\p{Is_Block=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\p{^Is_Block=egyptianhieroglyphs}', "");
    Expect(0, 78895, '\P{Is_Block=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\P{^Is_Block=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\p{Is_Block=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\p{^Is_Block=egyptianhieroglyphs}', "");
    Expect(1, 78896, '\P{Is_Block=egyptianhieroglyphs}', "");
    Expect(0, 78896, '\P{^Is_Block=egyptianhieroglyphs}', "");
    Expect(1, 78895, '\p{Is_Block= EGYPTIAN_Hieroglyphs}', "");
    Expect(0, 78895, '\p{^Is_Block= EGYPTIAN_Hieroglyphs}', "");
    Expect(0, 78895, '\P{Is_Block= EGYPTIAN_Hieroglyphs}', "");
    Expect(1, 78895, '\P{^Is_Block= EGYPTIAN_Hieroglyphs}', "");
    Expect(0, 78896, '\p{Is_Block= EGYPTIAN_Hieroglyphs}', "");
    Expect(1, 78896, '\p{^Is_Block= EGYPTIAN_Hieroglyphs}', "");
    Expect(1, 78896, '\P{Is_Block= EGYPTIAN_Hieroglyphs}', "");
    Expect(0, 78896, '\P{^Is_Block= EGYPTIAN_Hieroglyphs}', "");
    Error('\p{Is_Blk=:= -egyptian_HIEROGLYPHS}');
    Error('\P{Is_Blk=:= -egyptian_HIEROGLYPHS}');
    Expect(1, 78895, '\p{Is_Blk:   egyptianhieroglyphs}', "");
    Expect(0, 78895, '\p{^Is_Blk:   egyptianhieroglyphs}', "");
    Expect(0, 78895, '\P{Is_Blk:   egyptianhieroglyphs}', "");
    Expect(1, 78895, '\P{^Is_Blk:   egyptianhieroglyphs}', "");
    Expect(0, 78896, '\p{Is_Blk:   egyptianhieroglyphs}', "");
    Expect(1, 78896, '\p{^Is_Blk:   egyptianhieroglyphs}', "");
    Expect(1, 78896, '\P{Is_Blk:   egyptianhieroglyphs}', "");
    Expect(0, 78896, '\P{^Is_Blk:   egyptianhieroglyphs}', "");
    Expect(1, 78895, '\p{Is_Blk=- EGYPTIAN_Hieroglyphs}', "");
    Expect(0, 78895, '\p{^Is_Blk=- EGYPTIAN_Hieroglyphs}', "");
    Expect(0, 78895, '\P{Is_Blk=- EGYPTIAN_Hieroglyphs}', "");
    Expect(1, 78895, '\P{^Is_Blk=- EGYPTIAN_Hieroglyphs}', "");
    Expect(0, 78896, '\p{Is_Blk=- EGYPTIAN_Hieroglyphs}', "");
    Expect(1, 78896, '\p{^Is_Blk=- EGYPTIAN_Hieroglyphs}', "");
    Expect(1, 78896, '\P{Is_Blk=- EGYPTIAN_Hieroglyphs}', "");
    Expect(0, 78896, '\P{^Is_Blk=- EGYPTIAN_Hieroglyphs}', "");
    Error('\p{Block=_-Elbasan/a/}');
    Error('\P{Block=_-Elbasan/a/}');
    Expect(1, 66863, '\p{Block=:\AElbasan\z:}', "");;
    Expect(0, 66864, '\p{Block=:\AElbasan\z:}', "");;
    Expect(1, 66863, '\p{Block=elbasan}', "");
    Expect(0, 66863, '\p{^Block=elbasan}', "");
    Expect(0, 66863, '\P{Block=elbasan}', "");
    Expect(1, 66863, '\P{^Block=elbasan}', "");
    Expect(0, 66864, '\p{Block=elbasan}', "");
    Expect(1, 66864, '\p{^Block=elbasan}', "");
    Expect(1, 66864, '\P{Block=elbasan}', "");
    Expect(0, 66864, '\P{^Block=elbasan}', "");
    Expect(1, 66863, '\p{Block=:\Aelbasan\z:}', "");;
    Expect(0, 66864, '\p{Block=:\Aelbasan\z:}', "");;
    Expect(1, 66863, '\p{Block= -ELBASAN}', "");
    Expect(0, 66863, '\p{^Block= -ELBASAN}', "");
    Expect(0, 66863, '\P{Block= -ELBASAN}', "");
    Expect(1, 66863, '\P{^Block= -ELBASAN}', "");
    Expect(0, 66864, '\p{Block= -ELBASAN}', "");
    Expect(1, 66864, '\p{^Block= -ELBASAN}', "");
    Expect(1, 66864, '\P{Block= -ELBASAN}', "");
    Expect(0, 66864, '\P{^Block= -ELBASAN}', "");
    Error('\p{Blk=_:=Elbasan}');
    Error('\P{Blk=_:=Elbasan}');
    Expect(1, 66863, '\p{Blk=:\AElbasan\z:}', "");;
    Expect(0, 66864, '\p{Blk=:\AElbasan\z:}', "");;
    Expect(1, 66863, '\p{Blk=elbasan}', "");
    Expect(0, 66863, '\p{^Blk=elbasan}', "");
    Expect(0, 66863, '\P{Blk=elbasan}', "");
    Expect(1, 66863, '\P{^Blk=elbasan}', "");
    Expect(0, 66864, '\p{Blk=elbasan}', "");
    Expect(1, 66864, '\p{^Blk=elbasan}', "");
    Expect(1, 66864, '\P{Blk=elbasan}', "");
    Expect(0, 66864, '\P{^Blk=elbasan}', "");
    Expect(1, 66863, '\p{Blk=:\Aelbasan\z:}', "");;
    Expect(0, 66864, '\p{Blk=:\Aelbasan\z:}', "");;
    Expect(1, 66863, '\p{Blk=__elbasan}', "");
    Expect(0, 66863, '\p{^Blk=__elbasan}', "");
    Expect(0, 66863, '\P{Blk=__elbasan}', "");
    Expect(1, 66863, '\P{^Blk=__elbasan}', "");
    Expect(0, 66864, '\p{Blk=__elbasan}', "");
    Expect(1, 66864, '\p{^Blk=__elbasan}', "");
    Expect(1, 66864, '\P{Blk=__elbasan}', "");
    Expect(0, 66864, '\P{^Blk=__elbasan}', "");
    Error('\p{Is_Block=  Elbasan/a/}');
    Error('\P{Is_Block=  Elbasan/a/}');
    Expect(1, 66863, '\p{Is_Block=elbasan}', "");
    Expect(0, 66863, '\p{^Is_Block=elbasan}', "");
    Expect(0, 66863, '\P{Is_Block=elbasan}', "");
    Expect(1, 66863, '\P{^Is_Block=elbasan}', "");
    Expect(0, 66864, '\p{Is_Block=elbasan}', "");
    Expect(1, 66864, '\p{^Is_Block=elbasan}', "");
    Expect(1, 66864, '\P{Is_Block=elbasan}', "");
    Expect(0, 66864, '\P{^Is_Block=elbasan}', "");
    Expect(1, 66863, '\p{Is_Block= 	ELBASAN}', "");
    Expect(0, 66863, '\p{^Is_Block= 	ELBASAN}', "");
    Expect(0, 66863, '\P{Is_Block= 	ELBASAN}', "");
    Expect(1, 66863, '\P{^Is_Block= 	ELBASAN}', "");
    Expect(0, 66864, '\p{Is_Block= 	ELBASAN}', "");
    Expect(1, 66864, '\p{^Is_Block= 	ELBASAN}', "");
    Expect(1, 66864, '\P{Is_Block= 	ELBASAN}', "");
    Expect(0, 66864, '\P{^Is_Block= 	ELBASAN}', "");
    Error('\p{Is_Blk: -/a/Elbasan}');
    Error('\P{Is_Blk: -/a/Elbasan}');
    Expect(1, 66863, '\p{Is_Blk=elbasan}', "");
    Expect(0, 66863, '\p{^Is_Blk=elbasan}', "");
    Expect(0, 66863, '\P{Is_Blk=elbasan}', "");
    Expect(1, 66863, '\P{^Is_Blk=elbasan}', "");
    Expect(0, 66864, '\p{Is_Blk=elbasan}', "");
    Expect(1, 66864, '\p{^Is_Blk=elbasan}', "");
    Expect(1, 66864, '\P{Is_Blk=elbasan}', "");
    Expect(0, 66864, '\P{^Is_Blk=elbasan}', "");
    Expect(1, 66863, '\p{Is_Blk=	-Elbasan}', "");
    Expect(0, 66863, '\p{^Is_Blk=	-Elbasan}', "");
    Expect(0, 66863, '\P{Is_Blk=	-Elbasan}', "");
    Expect(1, 66863, '\P{^Is_Blk=	-Elbasan}', "");
    Expect(0, 66864, '\p{Is_Blk=	-Elbasan}', "");
    Expect(1, 66864, '\p{^Is_Blk=	-Elbasan}', "");
    Expect(1, 66864, '\P{Is_Blk=	-Elbasan}', "");
    Expect(0, 66864, '\P{^Is_Blk=	-Elbasan}', "");
    Error('\p{Block= :=Elymaic}');
    Error('\P{Block= :=Elymaic}');
    Expect(1, 69631, '\p{Block=:\AElymaic\z:}', "");;
    Expect(0, 69632, '\p{Block=:\AElymaic\z:}', "");;
    Expect(1, 69631, '\p{Block=elymaic}', "");
    Expect(0, 69631, '\p{^Block=elymaic}', "");
    Expect(0, 69631, '\P{Block=elymaic}', "");
    Expect(1, 69631, '\P{^Block=elymaic}', "");
    Expect(0, 69632, '\p{Block=elymaic}', "");
    Expect(1, 69632, '\p{^Block=elymaic}', "");
    Expect(1, 69632, '\P{Block=elymaic}', "");
    Expect(0, 69632, '\P{^Block=elymaic}', "");
    Expect(1, 69631, '\p{Block=:\Aelymaic\z:}', "");;
    Expect(0, 69632, '\p{Block=:\Aelymaic\z:}', "");;
    Expect(1, 69631, '\p{Block= Elymaic}', "");
    Expect(0, 69631, '\p{^Block= Elymaic}', "");
    Expect(0, 69631, '\P{Block= Elymaic}', "");
    Expect(1, 69631, '\P{^Block= Elymaic}', "");
    Expect(0, 69632, '\p{Block= Elymaic}', "");
    Expect(1, 69632, '\p{^Block= Elymaic}', "");
    Expect(1, 69632, '\P{Block= Elymaic}', "");
    Expect(0, 69632, '\P{^Block= Elymaic}', "");
    Error('\p{Blk:		Elymaic:=}');
    Error('\P{Blk:		Elymaic:=}');
    Expect(1, 69631, '\p{Blk=:\AElymaic\z:}', "");;
    Expect(0, 69632, '\p{Blk=:\AElymaic\z:}', "");;
    Expect(1, 69631, '\p{Blk=elymaic}', "");
    Expect(0, 69631, '\p{^Blk=elymaic}', "");
    Expect(0, 69631, '\P{Blk=elymaic}', "");
    Expect(1, 69631, '\P{^Blk=elymaic}', "");
    Expect(0, 69632, '\p{Blk=elymaic}', "");
    Expect(1, 69632, '\p{^Blk=elymaic}', "");
    Expect(1, 69632, '\P{Blk=elymaic}', "");
    Expect(0, 69632, '\P{^Blk=elymaic}', "");
    Expect(1, 69631, '\p{Blk=:\Aelymaic\z:}', "");;
    Expect(0, 69632, '\p{Blk=:\Aelymaic\z:}', "");;
    Expect(1, 69631, '\p{Blk=		ELYMAIC}', "");
    Expect(0, 69631, '\p{^Blk=		ELYMAIC}', "");
    Expect(0, 69631, '\P{Blk=		ELYMAIC}', "");
    Expect(1, 69631, '\P{^Blk=		ELYMAIC}', "");
    Expect(0, 69632, '\p{Blk=		ELYMAIC}', "");
    Expect(1, 69632, '\p{^Blk=		ELYMAIC}', "");
    Expect(1, 69632, '\P{Blk=		ELYMAIC}', "");
    Expect(0, 69632, '\P{^Blk=		ELYMAIC}', "");
    Error('\p{Is_Block=__Elymaic:=}');
    Error('\P{Is_Block=__Elymaic:=}');
    Expect(1, 69631, '\p{Is_Block=elymaic}', "");
    Expect(0, 69631, '\p{^Is_Block=elymaic}', "");
    Expect(0, 69631, '\P{Is_Block=elymaic}', "");
    Expect(1, 69631, '\P{^Is_Block=elymaic}', "");
    Expect(0, 69632, '\p{Is_Block=elymaic}', "");
    Expect(1, 69632, '\p{^Is_Block=elymaic}', "");
    Expect(1, 69632, '\P{Is_Block=elymaic}', "");
    Expect(0, 69632, '\P{^Is_Block=elymaic}', "");
    Expect(1, 69631, '\p{Is_Block= elymaic}', "");
    Expect(0, 69631, '\p{^Is_Block= elymaic}', "");
    Expect(0, 69631, '\P{Is_Block= elymaic}', "");
    Expect(1, 69631, '\P{^Is_Block= elymaic}', "");
    Expect(0, 69632, '\p{Is_Block= elymaic}', "");
    Expect(1, 69632, '\p{^Is_Block= elymaic}', "");
    Expect(1, 69632, '\P{Is_Block= elymaic}', "");
    Expect(0, 69632, '\P{^Is_Block= elymaic}', "");
    Error('\p{Is_Blk=Elymaic:=}');
    Error('\P{Is_Blk=Elymaic:=}');
    Expect(1, 69631, '\p{Is_Blk=elymaic}', "");
    Expect(0, 69631, '\p{^Is_Blk=elymaic}', "");
    Expect(0, 69631, '\P{Is_Blk=elymaic}', "");
    Expect(1, 69631, '\P{^Is_Blk=elymaic}', "");
    Expect(0, 69632, '\p{Is_Blk=elymaic}', "");
    Expect(1, 69632, '\p{^Is_Blk=elymaic}', "");
    Expect(1, 69632, '\P{Is_Blk=elymaic}', "");
    Expect(0, 69632, '\P{^Is_Blk=elymaic}', "");
    Expect(1, 69631, '\p{Is_Blk=__ELYMAIC}', "");
    Expect(0, 69631, '\p{^Is_Blk=__ELYMAIC}', "");
    Expect(0, 69631, '\P{Is_Blk=__ELYMAIC}', "");
    Expect(1, 69631, '\P{^Is_Blk=__ELYMAIC}', "");
    Expect(0, 69632, '\p{Is_Blk=__ELYMAIC}', "");
    Expect(1, 69632, '\p{^Is_Blk=__ELYMAIC}', "");
    Expect(1, 69632, '\P{Is_Blk=__ELYMAIC}', "");
    Expect(0, 69632, '\P{^Is_Blk=__ELYMAIC}', "");
    Error('\p{Block=:=_ emoticons}');
    Error('\P{Block=:=_ emoticons}');
    Expect(1, 128591, '\p{Block=:\AEmoticons\z:}', "");;
    Expect(0, 128592, '\p{Block=:\AEmoticons\z:}', "");;
    Expect(1, 128591, '\p{Block=emoticons}', "");
    Expect(0, 128591, '\p{^Block=emoticons}', "");
    Expect(0, 128591, '\P{Block=emoticons}', "");
    Expect(1, 128591, '\P{^Block=emoticons}', "");
    Expect(0, 128592, '\p{Block=emoticons}', "");
    Expect(1, 128592, '\p{^Block=emoticons}', "");
    Expect(1, 128592, '\P{Block=emoticons}', "");
    Expect(0, 128592, '\P{^Block=emoticons}', "");
    Expect(1, 128591, '\p{Block=:\Aemoticons\z:}', "");;
    Expect(0, 128592, '\p{Block=:\Aemoticons\z:}', "");;
    Expect(1, 128591, '\p{Block=_ Emoticons}', "");
    Expect(0, 128591, '\p{^Block=_ Emoticons}', "");
    Expect(0, 128591, '\P{Block=_ Emoticons}', "");
    Expect(1, 128591, '\P{^Block=_ Emoticons}', "");
    Expect(0, 128592, '\p{Block=_ Emoticons}', "");
    Expect(1, 128592, '\p{^Block=_ Emoticons}', "");
    Expect(1, 128592, '\P{Block=_ Emoticons}', "");
    Expect(0, 128592, '\P{^Block=_ Emoticons}', "");
    Error('\p{Blk=/a/-Emoticons}');
    Error('\P{Blk=/a/-Emoticons}');
    Expect(1, 128591, '\p{Blk=:\AEmoticons\z:}', "");;
    Expect(0, 128592, '\p{Blk=:\AEmoticons\z:}', "");;
    Expect(1, 128591, '\p{Blk=emoticons}', "");
    Expect(0, 128591, '\p{^Blk=emoticons}', "");
    Expect(0, 128591, '\P{Blk=emoticons}', "");
    Expect(1, 128591, '\P{^Blk=emoticons}', "");
    Expect(0, 128592, '\p{Blk=emoticons}', "");
    Expect(1, 128592, '\p{^Blk=emoticons}', "");
    Expect(1, 128592, '\P{Blk=emoticons}', "");
    Expect(0, 128592, '\P{^Blk=emoticons}', "");
    Expect(1, 128591, '\p{Blk=:\Aemoticons\z:}', "");;
    Expect(0, 128592, '\p{Blk=:\Aemoticons\z:}', "");;
    Expect(1, 128591, '\p{Blk=-emoticons}', "");
    Expect(0, 128591, '\p{^Blk=-emoticons}', "");
    Expect(0, 128591, '\P{Blk=-emoticons}', "");
    Expect(1, 128591, '\P{^Blk=-emoticons}', "");
    Expect(0, 128592, '\p{Blk=-emoticons}', "");
    Expect(1, 128592, '\p{^Blk=-emoticons}', "");
    Expect(1, 128592, '\P{Blk=-emoticons}', "");
    Expect(0, 128592, '\P{^Blk=-emoticons}', "");
    Error('\p{Is_Block=/a/ -emoticons}');
    Error('\P{Is_Block=/a/ -emoticons}');
    Expect(1, 128591, '\p{Is_Block=emoticons}', "");
    Expect(0, 128591, '\p{^Is_Block=emoticons}', "");
    Expect(0, 128591, '\P{Is_Block=emoticons}', "");
    Expect(1, 128591, '\P{^Is_Block=emoticons}', "");
    Expect(0, 128592, '\p{Is_Block=emoticons}', "");
    Expect(1, 128592, '\p{^Is_Block=emoticons}', "");
    Expect(1, 128592, '\P{Is_Block=emoticons}', "");
    Expect(0, 128592, '\P{^Is_Block=emoticons}', "");
    Expect(1, 128591, '\p{Is_Block=EMOTICONS}', "");
    Expect(0, 128591, '\p{^Is_Block=EMOTICONS}', "");
    Expect(0, 128591, '\P{Is_Block=EMOTICONS}', "");
    Expect(1, 128591, '\P{^Is_Block=EMOTICONS}', "");
    Expect(0, 128592, '\p{Is_Block=EMOTICONS}', "");
    Expect(1, 128592, '\p{^Is_Block=EMOTICONS}', "");
    Expect(1, 128592, '\P{Is_Block=EMOTICONS}', "");
    Expect(0, 128592, '\P{^Is_Block=EMOTICONS}', "");
    Error('\p{Is_Blk=-/a/Emoticons}');
    Error('\P{Is_Blk=-/a/Emoticons}');
    Expect(1, 128591, '\p{Is_Blk=emoticons}', "");
    Expect(0, 128591, '\p{^Is_Blk=emoticons}', "");
    Expect(0, 128591, '\P{Is_Blk=emoticons}', "");
    Expect(1, 128591, '\P{^Is_Blk=emoticons}', "");
    Expect(0, 128592, '\p{Is_Blk=emoticons}', "");
    Expect(1, 128592, '\p{^Is_Blk=emoticons}', "");
    Expect(1, 128592, '\P{Is_Blk=emoticons}', "");
    Expect(0, 128592, '\P{^Is_Blk=emoticons}', "");
    Expect(1, 128591, '\p{Is_Blk:   emoticons}', "");
    Expect(0, 128591, '\p{^Is_Blk:   emoticons}', "");
    Expect(0, 128591, '\P{Is_Blk:   emoticons}', "");
    Expect(1, 128591, '\P{^Is_Blk:   emoticons}', "");
    Expect(0, 128592, '\p{Is_Blk:   emoticons}', "");
    Expect(1, 128592, '\p{^Is_Blk:   emoticons}', "");
    Expect(1, 128592, '\P{Is_Blk:   emoticons}', "");
    Expect(0, 128592, '\P{^Is_Blk:   emoticons}', "");
    Error('\p{Block:   /a/ _Enclosed_Alphanumerics}');
    Error('\P{Block:   /a/ _Enclosed_Alphanumerics}');
    Expect(1, 9471, '\p{Block=:\AEnclosed_Alphanumerics\z:}', "");;
    Expect(0, 9472, '\p{Block=:\AEnclosed_Alphanumerics\z:}', "");;
    Expect(1, 9471, '\p{Block=enclosedalphanumerics}', "");
    Expect(0, 9471, '\p{^Block=enclosedalphanumerics}', "");
    Expect(0, 9471, '\P{Block=enclosedalphanumerics}', "");
    Expect(1, 9471, '\P{^Block=enclosedalphanumerics}', "");
    Expect(0, 9472, '\p{Block=enclosedalphanumerics}', "");
    Expect(1, 9472, '\p{^Block=enclosedalphanumerics}', "");
    Expect(1, 9472, '\P{Block=enclosedalphanumerics}', "");
    Expect(0, 9472, '\P{^Block=enclosedalphanumerics}', "");
    Expect(1, 9471, '\p{Block=:\Aenclosedalphanumerics\z:}', "");;
    Expect(0, 9472, '\p{Block=:\Aenclosedalphanumerics\z:}', "");;
    Expect(1, 9471, '\p{Block:	 enclosed_ALPHANUMERICS}', "");
    Expect(0, 9471, '\p{^Block:	 enclosed_ALPHANUMERICS}', "");
    Expect(0, 9471, '\P{Block:	 enclosed_ALPHANUMERICS}', "");
    Expect(1, 9471, '\P{^Block:	 enclosed_ALPHANUMERICS}', "");
    Expect(0, 9472, '\p{Block:	 enclosed_ALPHANUMERICS}', "");
    Expect(1, 9472, '\p{^Block:	 enclosed_ALPHANUMERICS}', "");
    Expect(1, 9472, '\P{Block:	 enclosed_ALPHANUMERICS}', "");
    Expect(0, 9472, '\P{^Block:	 enclosed_ALPHANUMERICS}', "");
    Error('\p{Blk=-/a/ENCLOSED_alphanum}');
    Error('\P{Blk=-/a/ENCLOSED_alphanum}');
    Expect(1, 9471, '\p{Blk=:\AEnclosed_Alphanum\z:}', "");;
    Expect(0, 9472, '\p{Blk=:\AEnclosed_Alphanum\z:}', "");;
    Expect(1, 9471, '\p{Blk=enclosedalphanum}', "");
    Expect(0, 9471, '\p{^Blk=enclosedalphanum}', "");
    Expect(0, 9471, '\P{Blk=enclosedalphanum}', "");
    Expect(1, 9471, '\P{^Blk=enclosedalphanum}', "");
    Expect(0, 9472, '\p{Blk=enclosedalphanum}', "");
    Expect(1, 9472, '\p{^Blk=enclosedalphanum}', "");
    Expect(1, 9472, '\P{Blk=enclosedalphanum}', "");
    Expect(0, 9472, '\P{^Blk=enclosedalphanum}', "");
    Expect(1, 9471, '\p{Blk=:\Aenclosedalphanum\z:}', "");;
    Expect(0, 9472, '\p{Blk=:\Aenclosedalphanum\z:}', "");;
    Expect(1, 9471, '\p{Blk=	_Enclosed_Alphanum}', "");
    Expect(0, 9471, '\p{^Blk=	_Enclosed_Alphanum}', "");
    Expect(0, 9471, '\P{Blk=	_Enclosed_Alphanum}', "");
    Expect(1, 9471, '\P{^Blk=	_Enclosed_Alphanum}', "");
    Expect(0, 9472, '\p{Blk=	_Enclosed_Alphanum}', "");
    Expect(1, 9472, '\p{^Blk=	_Enclosed_Alphanum}', "");
    Expect(1, 9472, '\P{Blk=	_Enclosed_Alphanum}', "");
    Expect(0, 9472, '\P{^Blk=	_Enclosed_Alphanum}', "");
    Error('\p{Is_Block= enclosed_ALPHANUMERICS/a/}');
    Error('\P{Is_Block= enclosed_ALPHANUMERICS/a/}');
    Expect(1, 9471, '\p{Is_Block=enclosedalphanumerics}', "");
    Expect(0, 9471, '\p{^Is_Block=enclosedalphanumerics}', "");
    Expect(0, 9471, '\P{Is_Block=enclosedalphanumerics}', "");
    Expect(1, 9471, '\P{^Is_Block=enclosedalphanumerics}', "");
    Expect(0, 9472, '\p{Is_Block=enclosedalphanumerics}', "");
    Expect(1, 9472, '\p{^Is_Block=enclosedalphanumerics}', "");
    Expect(1, 9472, '\P{Is_Block=enclosedalphanumerics}', "");
    Expect(0, 9472, '\P{^Is_Block=enclosedalphanumerics}', "");
    Expect(1, 9471, '\p{Is_Block=ENCLOSED_alphanumerics}', "");
    Expect(0, 9471, '\p{^Is_Block=ENCLOSED_alphanumerics}', "");
    Expect(0, 9471, '\P{Is_Block=ENCLOSED_alphanumerics}', "");
    Expect(1, 9471, '\P{^Is_Block=ENCLOSED_alphanumerics}', "");
    Expect(0, 9472, '\p{Is_Block=ENCLOSED_alphanumerics}', "");
    Expect(1, 9472, '\p{^Is_Block=ENCLOSED_alphanumerics}', "");
    Expect(1, 9472, '\P{Is_Block=ENCLOSED_alphanumerics}', "");
    Expect(0, 9472, '\P{^Is_Block=ENCLOSED_alphanumerics}', "");
    Error('\p{Is_Blk=	/a/ENCLOSED_Alphanum}');
    Error('\P{Is_Blk=	/a/ENCLOSED_Alphanum}');
    Expect(1, 9471, '\p{Is_Blk=enclosedalphanum}', "");
    Expect(0, 9471, '\p{^Is_Blk=enclosedalphanum}', "");
    Expect(0, 9471, '\P{Is_Blk=enclosedalphanum}', "");
    Expect(1, 9471, '\P{^Is_Blk=enclosedalphanum}', "");
    Expect(0, 9472, '\p{Is_Blk=enclosedalphanum}', "");
    Expect(1, 9472, '\p{^Is_Blk=enclosedalphanum}', "");
    Expect(1, 9472, '\P{Is_Blk=enclosedalphanum}', "");
    Expect(0, 9472, '\P{^Is_Blk=enclosedalphanum}', "");
    Expect(1, 9471, '\p{Is_Blk:   -_Enclosed_alphanum}', "");
    Expect(0, 9471, '\p{^Is_Blk:   -_Enclosed_alphanum}', "");
    Expect(0, 9471, '\P{Is_Blk:   -_Enclosed_alphanum}', "");
    Expect(1, 9471, '\P{^Is_Blk:   -_Enclosed_alphanum}', "");
    Expect(0, 9472, '\p{Is_Blk:   -_Enclosed_alphanum}', "");
    Expect(1, 9472, '\p{^Is_Blk:   -_Enclosed_alphanum}', "");
    Expect(1, 9472, '\P{Is_Blk:   -_Enclosed_alphanum}', "");
    Expect(0, 9472, '\P{^Is_Blk:   -_Enclosed_alphanum}', "");
    Error('\p{Block=/a/_	ENCLOSED_Alphanumeric_supplement}');
    Error('\P{Block=/a/_	ENCLOSED_Alphanumeric_supplement}');
    Expect(1, 127487, '\p{Block=:\AEnclosed_Alphanumeric_Supplement\z:}', "");;
    Expect(0, 127488, '\p{Block=:\AEnclosed_Alphanumeric_Supplement\z:}', "");;
    Expect(1, 127487, '\p{Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127487, '\p{^Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127487, '\P{Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127487, '\P{^Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127488, '\p{Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127488, '\p{^Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127488, '\P{Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127488, '\P{^Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127487, '\p{Block=:\Aenclosedalphanumericsupplement\z:}', "");;
    Expect(0, 127488, '\p{Block=:\Aenclosedalphanumericsupplement\z:}', "");;
    Expect(1, 127487, '\p{Block=_enclosed_Alphanumeric_supplement}', "");
    Expect(0, 127487, '\p{^Block=_enclosed_Alphanumeric_supplement}', "");
    Expect(0, 127487, '\P{Block=_enclosed_Alphanumeric_supplement}', "");
    Expect(1, 127487, '\P{^Block=_enclosed_Alphanumeric_supplement}', "");
    Expect(0, 127488, '\p{Block=_enclosed_Alphanumeric_supplement}', "");
    Expect(1, 127488, '\p{^Block=_enclosed_Alphanumeric_supplement}', "");
    Expect(1, 127488, '\P{Block=_enclosed_Alphanumeric_supplement}', "");
    Expect(0, 127488, '\P{^Block=_enclosed_Alphanumeric_supplement}', "");
    Error('\p{Blk=	:=Enclosed_alphanum_SUP}');
    Error('\P{Blk=	:=Enclosed_alphanum_SUP}');
    Expect(1, 127487, '\p{Blk=:\AEnclosed_Alphanum_Sup\z:}', "");;
    Expect(0, 127488, '\p{Blk=:\AEnclosed_Alphanum_Sup\z:}', "");;
    Expect(1, 127487, '\p{Blk=enclosedalphanumsup}', "");
    Expect(0, 127487, '\p{^Blk=enclosedalphanumsup}', "");
    Expect(0, 127487, '\P{Blk=enclosedalphanumsup}', "");
    Expect(1, 127487, '\P{^Blk=enclosedalphanumsup}', "");
    Expect(0, 127488, '\p{Blk=enclosedalphanumsup}', "");
    Expect(1, 127488, '\p{^Blk=enclosedalphanumsup}', "");
    Expect(1, 127488, '\P{Blk=enclosedalphanumsup}', "");
    Expect(0, 127488, '\P{^Blk=enclosedalphanumsup}', "");
    Expect(1, 127487, '\p{Blk=:\Aenclosedalphanumsup\z:}', "");;
    Expect(0, 127488, '\p{Blk=:\Aenclosedalphanumsup\z:}', "");;
    Expect(1, 127487, '\p{Blk=		Enclosed_alphanum_sup}', "");
    Expect(0, 127487, '\p{^Blk=		Enclosed_alphanum_sup}', "");
    Expect(0, 127487, '\P{Blk=		Enclosed_alphanum_sup}', "");
    Expect(1, 127487, '\P{^Blk=		Enclosed_alphanum_sup}', "");
    Expect(0, 127488, '\p{Blk=		Enclosed_alphanum_sup}', "");
    Expect(1, 127488, '\p{^Blk=		Enclosed_alphanum_sup}', "");
    Expect(1, 127488, '\P{Blk=		Enclosed_alphanum_sup}', "");
    Expect(0, 127488, '\P{^Blk=		Enclosed_alphanum_sup}', "");
    Error('\p{Is_Block=/a/  Enclosed_Alphanumeric_supplement}');
    Error('\P{Is_Block=/a/  Enclosed_Alphanumeric_supplement}');
    Expect(1, 127487, '\p{Is_Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127487, '\p{^Is_Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127487, '\P{Is_Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127487, '\P{^Is_Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127488, '\p{Is_Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127488, '\p{^Is_Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127488, '\P{Is_Block=enclosedalphanumericsupplement}', "");
    Expect(0, 127488, '\P{^Is_Block=enclosedalphanumericsupplement}', "");
    Expect(1, 127487, '\p{Is_Block=-Enclosed_Alphanumeric_supplement}', "");
    Expect(0, 127487, '\p{^Is_Block=-Enclosed_Alphanumeric_supplement}', "");
    Expect(0, 127487, '\P{Is_Block=-Enclosed_Alphanumeric_supplement}', "");
    Expect(1, 127487, '\P{^Is_Block=-Enclosed_Alphanumeric_supplement}', "");
    Expect(0, 127488, '\p{Is_Block=-Enclosed_Alphanumeric_supplement}', "");
    Expect(1, 127488, '\p{^Is_Block=-Enclosed_Alphanumeric_supplement}', "");
    Expect(1, 127488, '\P{Is_Block=-Enclosed_Alphanumeric_supplement}', "");
    Expect(0, 127488, '\P{^Is_Block=-Enclosed_Alphanumeric_supplement}', "");
    Error('\p{Is_Blk=:=  Enclosed_ALPHANUM_SUP}');
    Error('\P{Is_Blk=:=  Enclosed_ALPHANUM_SUP}');
    Expect(1, 127487, '\p{Is_Blk=enclosedalphanumsup}', "");
    Expect(0, 127487, '\p{^Is_Blk=enclosedalphanumsup}', "");
    Expect(0, 127487, '\P{Is_Blk=enclosedalphanumsup}', "");
    Expect(1, 127487, '\P{^Is_Blk=enclosedalphanumsup}', "");
    Expect(0, 127488, '\p{Is_Blk=enclosedalphanumsup}', "");
    Expect(1, 127488, '\p{^Is_Blk=enclosedalphanumsup}', "");
    Expect(1, 127488, '\P{Is_Blk=enclosedalphanumsup}', "");
    Expect(0, 127488, '\P{^Is_Blk=enclosedalphanumsup}', "");
    Expect(1, 127487, '\p{Is_Blk= -ENCLOSED_Alphanum_SUP}', "");
    Expect(0, 127487, '\p{^Is_Blk= -ENCLOSED_Alphanum_SUP}', "");
    Expect(0, 127487, '\P{Is_Blk= -ENCLOSED_Alphanum_SUP}', "");
    Expect(1, 127487, '\P{^Is_Blk= -ENCLOSED_Alphanum_SUP}', "");
    Expect(0, 127488, '\p{Is_Blk= -ENCLOSED_Alphanum_SUP}', "");
    Expect(1, 127488, '\p{^Is_Blk= -ENCLOSED_Alphanum_SUP}', "");
    Expect(1, 127488, '\P{Is_Blk= -ENCLOSED_Alphanum_SUP}', "");
    Expect(0, 127488, '\P{^Is_Blk= -ENCLOSED_Alphanum_SUP}', "");
    Error('\p{Block=_:=Enclosed_CJK_letters_And_months}');
    Error('\P{Block=_:=Enclosed_CJK_letters_And_months}');
    Expect(1, 13055, '\p{Block=:\AEnclosed_CJK_Letters_And_Months\z:}', "");;
    Expect(0, 13056, '\p{Block=:\AEnclosed_CJK_Letters_And_Months\z:}', "");;
    Expect(1, 13055, '\p{Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13055, '\p{^Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13055, '\P{Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13055, '\P{^Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13056, '\p{Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13056, '\p{^Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13056, '\P{Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13056, '\P{^Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13055, '\p{Block=:\Aenclosedcjklettersandmonths\z:}', "");;
    Expect(0, 13056, '\p{Block=:\Aenclosedcjklettersandmonths\z:}', "");;
    Expect(1, 13055, '\p{Block=  ENCLOSED_CJK_Letters_and_MONTHS}', "");
    Expect(0, 13055, '\p{^Block=  ENCLOSED_CJK_Letters_and_MONTHS}', "");
    Expect(0, 13055, '\P{Block=  ENCLOSED_CJK_Letters_and_MONTHS}', "");
    Expect(1, 13055, '\P{^Block=  ENCLOSED_CJK_Letters_and_MONTHS}', "");
    Expect(0, 13056, '\p{Block=  ENCLOSED_CJK_Letters_and_MONTHS}', "");
    Expect(1, 13056, '\p{^Block=  ENCLOSED_CJK_Letters_and_MONTHS}', "");
    Expect(1, 13056, '\P{Block=  ENCLOSED_CJK_Letters_and_MONTHS}', "");
    Expect(0, 13056, '\P{^Block=  ENCLOSED_CJK_Letters_and_MONTHS}', "");
    Error('\p{Blk=-:=Enclosed_cjk}');
    Error('\P{Blk=-:=Enclosed_cjk}');
    Expect(1, 13055, '\p{Blk=:\AEnclosed_CJK\z:}', "");;
    Expect(0, 13056, '\p{Blk=:\AEnclosed_CJK\z:}', "");;
    Expect(1, 13055, '\p{Blk=enclosedcjk}', "");
    Expect(0, 13055, '\p{^Blk=enclosedcjk}', "");
    Expect(0, 13055, '\P{Blk=enclosedcjk}', "");
    Expect(1, 13055, '\P{^Blk=enclosedcjk}', "");
    Expect(0, 13056, '\p{Blk=enclosedcjk}', "");
    Expect(1, 13056, '\p{^Blk=enclosedcjk}', "");
    Expect(1, 13056, '\P{Blk=enclosedcjk}', "");
    Expect(0, 13056, '\P{^Blk=enclosedcjk}', "");
    Expect(1, 13055, '\p{Blk=:\Aenclosedcjk\z:}', "");;
    Expect(0, 13056, '\p{Blk=:\Aenclosedcjk\z:}', "");;
    Expect(1, 13055, '\p{Blk=_Enclosed_CJK}', "");
    Expect(0, 13055, '\p{^Blk=_Enclosed_CJK}', "");
    Expect(0, 13055, '\P{Blk=_Enclosed_CJK}', "");
    Expect(1, 13055, '\P{^Blk=_Enclosed_CJK}', "");
    Expect(0, 13056, '\p{Blk=_Enclosed_CJK}', "");
    Expect(1, 13056, '\p{^Blk=_Enclosed_CJK}', "");
    Expect(1, 13056, '\P{Blk=_Enclosed_CJK}', "");
    Expect(0, 13056, '\P{^Blk=_Enclosed_CJK}', "");
    Error('\p{Is_Block=--enclosed_CJK_Letters_and_Months/a/}');
    Error('\P{Is_Block=--enclosed_CJK_Letters_and_Months/a/}');
    Expect(1, 13055, '\p{Is_Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13055, '\p{^Is_Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13055, '\P{Is_Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13055, '\P{^Is_Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13056, '\p{Is_Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13056, '\p{^Is_Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13056, '\P{Is_Block=enclosedcjklettersandmonths}', "");
    Expect(0, 13056, '\P{^Is_Block=enclosedcjklettersandmonths}', "");
    Expect(1, 13055, '\p{Is_Block:		-ENCLOSED_cjk_Letters_and_months}', "");
    Expect(0, 13055, '\p{^Is_Block:		-ENCLOSED_cjk_Letters_and_months}', "");
    Expect(0, 13055, '\P{Is_Block:		-ENCLOSED_cjk_Letters_and_months}', "");
    Expect(1, 13055, '\P{^Is_Block:		-ENCLOSED_cjk_Letters_and_months}', "");
    Expect(0, 13056, '\p{Is_Block:		-ENCLOSED_cjk_Letters_and_months}', "");
    Expect(1, 13056, '\p{^Is_Block:		-ENCLOSED_cjk_Letters_and_months}', "");
    Expect(1, 13056, '\P{Is_Block:		-ENCLOSED_cjk_Letters_and_months}', "");
    Expect(0, 13056, '\P{^Is_Block:		-ENCLOSED_cjk_Letters_and_months}', "");
    Error('\p{Is_Blk=:=-enclosed_CJK}');
    Error('\P{Is_Blk=:=-enclosed_CJK}');
    Expect(1, 13055, '\p{Is_Blk=enclosedcjk}', "");
    Expect(0, 13055, '\p{^Is_Blk=enclosedcjk}', "");
    Expect(0, 13055, '\P{Is_Blk=enclosedcjk}', "");
    Expect(1, 13055, '\P{^Is_Blk=enclosedcjk}', "");
    Expect(0, 13056, '\p{Is_Blk=enclosedcjk}', "");
    Expect(1, 13056, '\p{^Is_Blk=enclosedcjk}', "");
    Expect(1, 13056, '\P{Is_Blk=enclosedcjk}', "");
    Expect(0, 13056, '\P{^Is_Blk=enclosedcjk}', "");
    Expect(1, 13055, '\p{Is_Blk=_-enclosed_CJK}', "");
    Expect(0, 13055, '\p{^Is_Blk=_-enclosed_CJK}', "");
    Expect(0, 13055, '\P{Is_Blk=_-enclosed_CJK}', "");
    Expect(1, 13055, '\P{^Is_Blk=_-enclosed_CJK}', "");
    Expect(0, 13056, '\p{Is_Blk=_-enclosed_CJK}', "");
    Expect(1, 13056, '\p{^Is_Blk=_-enclosed_CJK}', "");
    Expect(1, 13056, '\P{Is_Blk=_-enclosed_CJK}', "");
    Expect(0, 13056, '\P{^Is_Blk=_-enclosed_CJK}', "");
    Error('\p{Block=:= _ENCLOSED_IDEOGRAPHIC_SUPPLEMENT}');
    Error('\P{Block=:= _ENCLOSED_IDEOGRAPHIC_SUPPLEMENT}');
    Expect(1, 127743, '\p{Block=:\AEnclosed_Ideographic_Supplement\z:}', "");;
    Expect(0, 127744, '\p{Block=:\AEnclosed_Ideographic_Supplement\z:}', "");;
    Expect(1, 127743, '\p{Block=enclosedideographicsupplement}', "");
    Expect(0, 127743, '\p{^Block=enclosedideographicsupplement}', "");
    Expect(0, 127743, '\P{Block=enclosedideographicsupplement}', "");
    Expect(1, 127743, '\P{^Block=enclosedideographicsupplement}', "");
    Expect(0, 127744, '\p{Block=enclosedideographicsupplement}', "");
    Expect(1, 127744, '\p{^Block=enclosedideographicsupplement}', "");
    Expect(1, 127744, '\P{Block=enclosedideographicsupplement}', "");
    Expect(0, 127744, '\P{^Block=enclosedideographicsupplement}', "");
    Expect(1, 127743, '\p{Block=:\Aenclosedideographicsupplement\z:}', "");;
    Expect(0, 127744, '\p{Block=:\Aenclosedideographicsupplement\z:}', "");;
    Expect(1, 127743, '\p{Block:    ENCLOSED_Ideographic_Supplement}', "");
    Expect(0, 127743, '\p{^Block:    ENCLOSED_Ideographic_Supplement}', "");
    Expect(0, 127743, '\P{Block:    ENCLOSED_Ideographic_Supplement}', "");
    Expect(1, 127743, '\P{^Block:    ENCLOSED_Ideographic_Supplement}', "");
    Expect(0, 127744, '\p{Block:    ENCLOSED_Ideographic_Supplement}', "");
    Expect(1, 127744, '\p{^Block:    ENCLOSED_Ideographic_Supplement}', "");
    Expect(1, 127744, '\P{Block:    ENCLOSED_Ideographic_Supplement}', "");
    Expect(0, 127744, '\P{^Block:    ENCLOSED_Ideographic_Supplement}', "");
    Error('\p{Blk=:= _ENCLOSED_Ideographic_Sup}');
    Error('\P{Blk=:= _ENCLOSED_Ideographic_Sup}');
    Expect(1, 127743, '\p{Blk=:\AEnclosed_Ideographic_Sup\z:}', "");;
    Expect(0, 127744, '\p{Blk=:\AEnclosed_Ideographic_Sup\z:}', "");;
    Expect(1, 127743, '\p{Blk=enclosedideographicsup}', "");
    Expect(0, 127743, '\p{^Blk=enclosedideographicsup}', "");
    Expect(0, 127743, '\P{Blk=enclosedideographicsup}', "");
    Expect(1, 127743, '\P{^Blk=enclosedideographicsup}', "");
    Expect(0, 127744, '\p{Blk=enclosedideographicsup}', "");
    Expect(1, 127744, '\p{^Blk=enclosedideographicsup}', "");
    Expect(1, 127744, '\P{Blk=enclosedideographicsup}', "");
    Expect(0, 127744, '\P{^Blk=enclosedideographicsup}', "");
    Expect(1, 127743, '\p{Blk=:\Aenclosedideographicsup\z:}', "");;
    Expect(0, 127744, '\p{Blk=:\Aenclosedideographicsup\z:}', "");;
    Expect(1, 127743, '\p{Blk=	ENCLOSED_Ideographic_Sup}', "");
    Expect(0, 127743, '\p{^Blk=	ENCLOSED_Ideographic_Sup}', "");
    Expect(0, 127743, '\P{Blk=	ENCLOSED_Ideographic_Sup}', "");
    Expect(1, 127743, '\P{^Blk=	ENCLOSED_Ideographic_Sup}', "");
    Expect(0, 127744, '\p{Blk=	ENCLOSED_Ideographic_Sup}', "");
    Expect(1, 127744, '\p{^Blk=	ENCLOSED_Ideographic_Sup}', "");
    Expect(1, 127744, '\P{Blk=	ENCLOSED_Ideographic_Sup}', "");
    Expect(0, 127744, '\P{^Blk=	ENCLOSED_Ideographic_Sup}', "");
    Error('\p{Is_Block::=	 ENCLOSED_Ideographic_SUPPLEMENT}');
    Error('\P{Is_Block::=	 ENCLOSED_Ideographic_SUPPLEMENT}');
    Expect(1, 127743, '\p{Is_Block: enclosedideographicsupplement}', "");
    Expect(0, 127743, '\p{^Is_Block: enclosedideographicsupplement}', "");
    Expect(0, 127743, '\P{Is_Block: enclosedideographicsupplement}', "");
    Expect(1, 127743, '\P{^Is_Block: enclosedideographicsupplement}', "");
    Expect(0, 127744, '\p{Is_Block: enclosedideographicsupplement}', "");
    Expect(1, 127744, '\p{^Is_Block: enclosedideographicsupplement}', "");
    Expect(1, 127744, '\P{Is_Block: enclosedideographicsupplement}', "");
    Expect(0, 127744, '\P{^Is_Block: enclosedideographicsupplement}', "");
    Expect(1, 127743, '\p{Is_Block=	Enclosed_ideographic_supplement}', "");
    Expect(0, 127743, '\p{^Is_Block=	Enclosed_ideographic_supplement}', "");
    Expect(0, 127743, '\P{Is_Block=	Enclosed_ideographic_supplement}', "");
    Expect(1, 127743, '\P{^Is_Block=	Enclosed_ideographic_supplement}', "");
    Expect(0, 127744, '\p{Is_Block=	Enclosed_ideographic_supplement}', "");
    Expect(1, 127744, '\p{^Is_Block=	Enclosed_ideographic_supplement}', "");
    Expect(1, 127744, '\P{Is_Block=	Enclosed_ideographic_supplement}', "");
    Expect(0, 127744, '\P{^Is_Block=	Enclosed_ideographic_supplement}', "");
    Error('\p{Is_Blk=/a/__enclosed_ideographic_Sup}');
    Error('\P{Is_Blk=/a/__enclosed_ideographic_Sup}');
    Expect(1, 127743, '\p{Is_Blk=enclosedideographicsup}', "");
    Expect(0, 127743, '\p{^Is_Blk=enclosedideographicsup}', "");
    Expect(0, 127743, '\P{Is_Blk=enclosedideographicsup}', "");
    Expect(1, 127743, '\P{^Is_Blk=enclosedideographicsup}', "");
    Expect(0, 127744, '\p{Is_Blk=enclosedideographicsup}', "");
    Expect(1, 127744, '\p{^Is_Blk=enclosedideographicsup}', "");
    Expect(1, 127744, '\P{Is_Blk=enclosedideographicsup}', "");
    Expect(0, 127744, '\P{^Is_Blk=enclosedideographicsup}', "");
    Expect(1, 127743, '\p{Is_Blk=-ENCLOSED_Ideographic_sup}', "");
    Expect(0, 127743, '\p{^Is_Blk=-ENCLOSED_Ideographic_sup}', "");
    Expect(0, 127743, '\P{Is_Blk=-ENCLOSED_Ideographic_sup}', "");
    Expect(1, 127743, '\P{^Is_Blk=-ENCLOSED_Ideographic_sup}', "");
    Expect(0, 127744, '\p{Is_Blk=-ENCLOSED_Ideographic_sup}', "");
    Expect(1, 127744, '\p{^Is_Blk=-ENCLOSED_Ideographic_sup}', "");
    Expect(1, 127744, '\P{Is_Blk=-ENCLOSED_Ideographic_sup}', "");
    Expect(0, 127744, '\P{^Is_Blk=-ENCLOSED_Ideographic_sup}', "");
    Error('\p{Block=/a/-Ethiopic}');
    Error('\P{Block=/a/-Ethiopic}');
    Expect(1, 4991, '\p{Block=:\AEthiopic\z:}', "");;
    Expect(0, 4992, '\p{Block=:\AEthiopic\z:}', "");;
    Expect(1, 4991, '\p{Block=ethiopic}', "");
    Expect(0, 4991, '\p{^Block=ethiopic}', "");
    Expect(0, 4991, '\P{Block=ethiopic}', "");
    Expect(1, 4991, '\P{^Block=ethiopic}', "");
    Expect(0, 4992, '\p{Block=ethiopic}', "");
    Expect(1, 4992, '\p{^Block=ethiopic}', "");
    Expect(1, 4992, '\P{Block=ethiopic}', "");
    Expect(0, 4992, '\P{^Block=ethiopic}', "");
    Expect(1, 4991, '\p{Block=:\Aethiopic\z:}', "");;
    Expect(0, 4992, '\p{Block=:\Aethiopic\z:}', "");;
    Expect(1, 4991, '\p{Block=-Ethiopic}', "");
    Expect(0, 4991, '\p{^Block=-Ethiopic}', "");
    Expect(0, 4991, '\P{Block=-Ethiopic}', "");
    Expect(1, 4991, '\P{^Block=-Ethiopic}', "");
    Expect(0, 4992, '\p{Block=-Ethiopic}', "");
    Expect(1, 4992, '\p{^Block=-Ethiopic}', "");
    Expect(1, 4992, '\P{Block=-Ethiopic}', "");
    Expect(0, 4992, '\P{^Block=-Ethiopic}', "");
    Error('\p{Blk=_/a/ethiopic}');
    Error('\P{Blk=_/a/ethiopic}');
    Expect(1, 4991, '\p{Blk=:\AEthiopic\z:}', "");;
    Expect(0, 4992, '\p{Blk=:\AEthiopic\z:}', "");;
    Expect(1, 4991, '\p{Blk=ethiopic}', "");
    Expect(0, 4991, '\p{^Blk=ethiopic}', "");
    Expect(0, 4991, '\P{Blk=ethiopic}', "");
    Expect(1, 4991, '\P{^Blk=ethiopic}', "");
    Expect(0, 4992, '\p{Blk=ethiopic}', "");
    Expect(1, 4992, '\p{^Blk=ethiopic}', "");
    Expect(1, 4992, '\P{Blk=ethiopic}', "");
    Expect(0, 4992, '\P{^Blk=ethiopic}', "");
    Expect(1, 4991, '\p{Blk=:\Aethiopic\z:}', "");;
    Expect(0, 4992, '\p{Blk=:\Aethiopic\z:}', "");;
    Expect(1, 4991, '\p{Blk=  ETHIOPIC}', "");
    Expect(0, 4991, '\p{^Blk=  ETHIOPIC}', "");
    Expect(0, 4991, '\P{Blk=  ETHIOPIC}', "");
    Expect(1, 4991, '\P{^Blk=  ETHIOPIC}', "");
    Expect(0, 4992, '\p{Blk=  ETHIOPIC}', "");
    Expect(1, 4992, '\p{^Blk=  ETHIOPIC}', "");
    Expect(1, 4992, '\P{Blk=  ETHIOPIC}', "");
    Expect(0, 4992, '\P{^Blk=  ETHIOPIC}', "");
    Error('\p{Is_Block=-Ethiopic:=}');
    Error('\P{Is_Block=-Ethiopic:=}');
    Expect(1, 4991, '\p{Is_Block=ethiopic}', "");
    Expect(0, 4991, '\p{^Is_Block=ethiopic}', "");
    Expect(0, 4991, '\P{Is_Block=ethiopic}', "");
    Expect(1, 4991, '\P{^Is_Block=ethiopic}', "");
    Expect(0, 4992, '\p{Is_Block=ethiopic}', "");
    Expect(1, 4992, '\p{^Is_Block=ethiopic}', "");
    Expect(1, 4992, '\P{Is_Block=ethiopic}', "");
    Expect(0, 4992, '\P{^Is_Block=ethiopic}', "");
    Expect(1, 4991, '\p{Is_Block=		Ethiopic}', "");
    Expect(0, 4991, '\p{^Is_Block=		Ethiopic}', "");
    Expect(0, 4991, '\P{Is_Block=		Ethiopic}', "");
    Expect(1, 4991, '\P{^Is_Block=		Ethiopic}', "");
    Expect(0, 4992, '\p{Is_Block=		Ethiopic}', "");
    Expect(1, 4992, '\p{^Is_Block=		Ethiopic}', "");
    Expect(1, 4992, '\P{Is_Block=		Ethiopic}', "");
    Expect(0, 4992, '\P{^Is_Block=		Ethiopic}', "");
    Error('\p{Is_Blk=/a/_Ethiopic}');
    Error('\P{Is_Blk=/a/_Ethiopic}');
    Expect(1, 4991, '\p{Is_Blk=ethiopic}', "");
    Expect(0, 4991, '\p{^Is_Blk=ethiopic}', "");
    Expect(0, 4991, '\P{Is_Blk=ethiopic}', "");
    Expect(1, 4991, '\P{^Is_Blk=ethiopic}', "");
    Expect(0, 4992, '\p{Is_Blk=ethiopic}', "");
    Expect(1, 4992, '\p{^Is_Blk=ethiopic}', "");
    Expect(1, 4992, '\P{Is_Blk=ethiopic}', "");
    Expect(0, 4992, '\P{^Is_Blk=ethiopic}', "");
    Expect(1, 4991, '\p{Is_Blk=_-Ethiopic}', "");
    Expect(0, 4991, '\p{^Is_Blk=_-Ethiopic}', "");
    Expect(0, 4991, '\P{Is_Blk=_-Ethiopic}', "");
    Expect(1, 4991, '\P{^Is_Blk=_-Ethiopic}', "");
    Expect(0, 4992, '\p{Is_Blk=_-Ethiopic}', "");
    Expect(1, 4992, '\p{^Is_Blk=_-Ethiopic}', "");
    Expect(1, 4992, '\P{Is_Blk=_-Ethiopic}', "");
    Expect(0, 4992, '\P{^Is_Blk=_-Ethiopic}', "");
    Error('\p{Block= /a/ethiopic_Extended}');
    Error('\P{Block= /a/ethiopic_Extended}');
    Expect(1, 11743, '\p{Block=:\AEthiopic_Extended\z:}', "");;
    Expect(0, 11744, '\p{Block=:\AEthiopic_Extended\z:}', "");;
    Expect(1, 11743, '\p{Block=ethiopicextended}', "");
    Expect(0, 11743, '\p{^Block=ethiopicextended}', "");
    Expect(0, 11743, '\P{Block=ethiopicextended}', "");
    Expect(1, 11743, '\P{^Block=ethiopicextended}', "");
    Expect(0, 11744, '\p{Block=ethiopicextended}', "");
    Expect(1, 11744, '\p{^Block=ethiopicextended}', "");
    Expect(1, 11744, '\P{Block=ethiopicextended}', "");
    Expect(0, 11744, '\P{^Block=ethiopicextended}', "");
    Expect(1, 11743, '\p{Block=:\Aethiopicextended\z:}', "");;
    Expect(0, 11744, '\p{Block=:\Aethiopicextended\z:}', "");;
    Expect(1, 11743, '\p{Block=-	ETHIOPIC_Extended}', "");
    Expect(0, 11743, '\p{^Block=-	ETHIOPIC_Extended}', "");
    Expect(0, 11743, '\P{Block=-	ETHIOPIC_Extended}', "");
    Expect(1, 11743, '\P{^Block=-	ETHIOPIC_Extended}', "");
    Expect(0, 11744, '\p{Block=-	ETHIOPIC_Extended}', "");
    Expect(1, 11744, '\p{^Block=-	ETHIOPIC_Extended}', "");
    Expect(1, 11744, '\P{Block=-	ETHIOPIC_Extended}', "");
    Expect(0, 11744, '\P{^Block=-	ETHIOPIC_Extended}', "");
    Error('\p{Blk=:=_ethiopic_Ext}');
    Error('\P{Blk=:=_ethiopic_Ext}');
    Expect(1, 11743, '\p{Blk=:\AEthiopic_Ext\z:}', "");;
    Expect(0, 11744, '\p{Blk=:\AEthiopic_Ext\z:}', "");;
    Expect(1, 11743, '\p{Blk=ethiopicext}', "");
    Expect(0, 11743, '\p{^Blk=ethiopicext}', "");
    Expect(0, 11743, '\P{Blk=ethiopicext}', "");
    Expect(1, 11743, '\P{^Blk=ethiopicext}', "");
    Expect(0, 11744, '\p{Blk=ethiopicext}', "");
    Expect(1, 11744, '\p{^Blk=ethiopicext}', "");
    Expect(1, 11744, '\P{Blk=ethiopicext}', "");
    Expect(0, 11744, '\P{^Blk=ethiopicext}', "");
    Expect(1, 11743, '\p{Blk=:\Aethiopicext\z:}', "");;
    Expect(0, 11744, '\p{Blk=:\Aethiopicext\z:}', "");;
    Expect(1, 11743, '\p{Blk=_ETHIOPIC_Ext}', "");
    Expect(0, 11743, '\p{^Blk=_ETHIOPIC_Ext}', "");
    Expect(0, 11743, '\P{Blk=_ETHIOPIC_Ext}', "");
    Expect(1, 11743, '\P{^Blk=_ETHIOPIC_Ext}', "");
    Expect(0, 11744, '\p{Blk=_ETHIOPIC_Ext}', "");
    Expect(1, 11744, '\p{^Blk=_ETHIOPIC_Ext}', "");
    Expect(1, 11744, '\P{Blk=_ETHIOPIC_Ext}', "");
    Expect(0, 11744, '\P{^Blk=_ETHIOPIC_Ext}', "");
    Error('\p{Is_Block=:=--ETHIOPIC_EXTENDED}');
    Error('\P{Is_Block=:=--ETHIOPIC_EXTENDED}');
    Expect(1, 11743, '\p{Is_Block=ethiopicextended}', "");
    Expect(0, 11743, '\p{^Is_Block=ethiopicextended}', "");
    Expect(0, 11743, '\P{Is_Block=ethiopicextended}', "");
    Expect(1, 11743, '\P{^Is_Block=ethiopicextended}', "");
    Expect(0, 11744, '\p{Is_Block=ethiopicextended}', "");
    Expect(1, 11744, '\p{^Is_Block=ethiopicextended}', "");
    Expect(1, 11744, '\P{Is_Block=ethiopicextended}', "");
    Expect(0, 11744, '\P{^Is_Block=ethiopicextended}', "");
    Expect(1, 11743, '\p{Is_Block:_Ethiopic_Extended}', "");
    Expect(0, 11743, '\p{^Is_Block:_Ethiopic_Extended}', "");
    Expect(0, 11743, '\P{Is_Block:_Ethiopic_Extended}', "");
    Expect(1, 11743, '\P{^Is_Block:_Ethiopic_Extended}', "");
    Expect(0, 11744, '\p{Is_Block:_Ethiopic_Extended}', "");
    Expect(1, 11744, '\p{^Is_Block:_Ethiopic_Extended}', "");
    Expect(1, 11744, '\P{Is_Block:_Ethiopic_Extended}', "");
    Expect(0, 11744, '\P{^Is_Block:_Ethiopic_Extended}', "");
    Error('\p{Is_Blk=_/a/ethiopic_Ext}');
    Error('\P{Is_Blk=_/a/ethiopic_Ext}');
    Expect(1, 11743, '\p{Is_Blk=ethiopicext}', "");
    Expect(0, 11743, '\p{^Is_Blk=ethiopicext}', "");
    Expect(0, 11743, '\P{Is_Blk=ethiopicext}', "");
    Expect(1, 11743, '\P{^Is_Blk=ethiopicext}', "");
    Expect(0, 11744, '\p{Is_Blk=ethiopicext}', "");
    Expect(1, 11744, '\p{^Is_Blk=ethiopicext}', "");
    Expect(1, 11744, '\P{Is_Blk=ethiopicext}', "");
    Expect(0, 11744, '\P{^Is_Blk=ethiopicext}', "");
    Expect(1, 11743, '\p{Is_Blk:-ethiopic_EXT}', "");
    Expect(0, 11743, '\p{^Is_Blk:-ethiopic_EXT}', "");
    Expect(0, 11743, '\P{Is_Blk:-ethiopic_EXT}', "");
    Expect(1, 11743, '\P{^Is_Blk:-ethiopic_EXT}', "");
    Expect(0, 11744, '\p{Is_Blk:-ethiopic_EXT}', "");
    Expect(1, 11744, '\p{^Is_Blk:-ethiopic_EXT}', "");
    Expect(1, 11744, '\P{Is_Blk:-ethiopic_EXT}', "");
    Expect(0, 11744, '\P{^Is_Blk:-ethiopic_EXT}', "");
    Error('\p{Block=/a/Ethiopic_EXTENDED_A}');
    Error('\P{Block=/a/Ethiopic_EXTENDED_A}');
    Expect(1, 43823, '\p{Block=:\AEthiopic_Extended_A\z:}', "");;
    Expect(0, 43824, '\p{Block=:\AEthiopic_Extended_A\z:}', "");;
    Expect(1, 43823, '\p{Block=ethiopicextendeda}', "");
    Expect(0, 43823, '\p{^Block=ethiopicextendeda}', "");
    Expect(0, 43823, '\P{Block=ethiopicextendeda}', "");
    Expect(1, 43823, '\P{^Block=ethiopicextendeda}', "");
    Expect(0, 43824, '\p{Block=ethiopicextendeda}', "");
    Expect(1, 43824, '\p{^Block=ethiopicextendeda}', "");
    Expect(1, 43824, '\P{Block=ethiopicextendeda}', "");
    Expect(0, 43824, '\P{^Block=ethiopicextendeda}', "");
    Expect(1, 43823, '\p{Block=:\Aethiopicextendeda\z:}', "");;
    Expect(0, 43824, '\p{Block=:\Aethiopicextendeda\z:}', "");;
    Expect(1, 43823, '\p{Block=-Ethiopic_extended_A}', "");
    Expect(0, 43823, '\p{^Block=-Ethiopic_extended_A}', "");
    Expect(0, 43823, '\P{Block=-Ethiopic_extended_A}', "");
    Expect(1, 43823, '\P{^Block=-Ethiopic_extended_A}', "");
    Expect(0, 43824, '\p{Block=-Ethiopic_extended_A}', "");
    Expect(1, 43824, '\p{^Block=-Ethiopic_extended_A}', "");
    Expect(1, 43824, '\P{Block=-Ethiopic_extended_A}', "");
    Expect(0, 43824, '\P{^Block=-Ethiopic_extended_A}', "");
    Error('\p{Blk=_:=Ethiopic_EXT_a}');
    Error('\P{Blk=_:=Ethiopic_EXT_a}');
    Expect(1, 43823, '\p{Blk=:\AEthiopic_Ext_A\z:}', "");;
    Expect(0, 43824, '\p{Blk=:\AEthiopic_Ext_A\z:}', "");;
    Expect(1, 43823, '\p{Blk=ethiopicexta}', "");
    Expect(0, 43823, '\p{^Blk=ethiopicexta}', "");
    Expect(0, 43823, '\P{Blk=ethiopicexta}', "");
    Expect(1, 43823, '\P{^Blk=ethiopicexta}', "");
    Expect(0, 43824, '\p{Blk=ethiopicexta}', "");
    Expect(1, 43824, '\p{^Blk=ethiopicexta}', "");
    Expect(1, 43824, '\P{Blk=ethiopicexta}', "");
    Expect(0, 43824, '\P{^Blk=ethiopicexta}', "");
    Expect(1, 43823, '\p{Blk=:\Aethiopicexta\z:}', "");;
    Expect(0, 43824, '\p{Blk=:\Aethiopicexta\z:}', "");;
    Expect(1, 43823, '\p{Blk=	-ethiopic_Ext_A}', "");
    Expect(0, 43823, '\p{^Blk=	-ethiopic_Ext_A}', "");
    Expect(0, 43823, '\P{Blk=	-ethiopic_Ext_A}', "");
    Expect(1, 43823, '\P{^Blk=	-ethiopic_Ext_A}', "");
    Expect(0, 43824, '\p{Blk=	-ethiopic_Ext_A}', "");
    Expect(1, 43824, '\p{^Blk=	-ethiopic_Ext_A}', "");
    Expect(1, 43824, '\P{Blk=	-ethiopic_Ext_A}', "");
    Expect(0, 43824, '\P{^Blk=	-ethiopic_Ext_A}', "");
    Error('\p{Is_Block=/a/ethiopic_Extended_A}');
    Error('\P{Is_Block=/a/ethiopic_Extended_A}');
    Expect(1, 43823, '\p{Is_Block=ethiopicextendeda}', "");
    Expect(0, 43823, '\p{^Is_Block=ethiopicextendeda}', "");
    Expect(0, 43823, '\P{Is_Block=ethiopicextendeda}', "");
    Expect(1, 43823, '\P{^Is_Block=ethiopicextendeda}', "");
    Expect(0, 43824, '\p{Is_Block=ethiopicextendeda}', "");
    Expect(1, 43824, '\p{^Is_Block=ethiopicextendeda}', "");
    Expect(1, 43824, '\P{Is_Block=ethiopicextendeda}', "");
    Expect(0, 43824, '\P{^Is_Block=ethiopicextendeda}', "");
    Expect(1, 43823, '\p{Is_Block: ETHIOPIC_Extended_A}', "");
    Expect(0, 43823, '\p{^Is_Block: ETHIOPIC_Extended_A}', "");
    Expect(0, 43823, '\P{Is_Block: ETHIOPIC_Extended_A}', "");
    Expect(1, 43823, '\P{^Is_Block: ETHIOPIC_Extended_A}', "");
    Expect(0, 43824, '\p{Is_Block: ETHIOPIC_Extended_A}', "");
    Expect(1, 43824, '\p{^Is_Block: ETHIOPIC_Extended_A}', "");
    Expect(1, 43824, '\P{Is_Block: ETHIOPIC_Extended_A}', "");
    Expect(0, 43824, '\P{^Is_Block: ETHIOPIC_Extended_A}', "");
    Error('\p{Is_Blk=_:=ETHIOPIC_ext_A}');
    Error('\P{Is_Blk=_:=ETHIOPIC_ext_A}');
    Expect(1, 43823, '\p{Is_Blk:   ethiopicexta}', "");
    Expect(0, 43823, '\p{^Is_Blk:   ethiopicexta}', "");
    Expect(0, 43823, '\P{Is_Blk:   ethiopicexta}', "");
    Expect(1, 43823, '\P{^Is_Blk:   ethiopicexta}', "");
    Expect(0, 43824, '\p{Is_Blk:   ethiopicexta}', "");
    Expect(1, 43824, '\p{^Is_Blk:   ethiopicexta}', "");
    Expect(1, 43824, '\P{Is_Blk:   ethiopicexta}', "");
    Expect(0, 43824, '\P{^Is_Blk:   ethiopicexta}', "");
    Expect(1, 43823, '\p{Is_Blk=_	ETHIOPIC_Ext_A}', "");
    Expect(0, 43823, '\p{^Is_Blk=_	ETHIOPIC_Ext_A}', "");
    Expect(0, 43823, '\P{Is_Blk=_	ETHIOPIC_Ext_A}', "");
    Expect(1, 43823, '\P{^Is_Blk=_	ETHIOPIC_Ext_A}', "");
    Expect(0, 43824, '\p{Is_Blk=_	ETHIOPIC_Ext_A}', "");
    Expect(1, 43824, '\p{^Is_Blk=_	ETHIOPIC_Ext_A}', "");
    Expect(1, 43824, '\P{Is_Blk=_	ETHIOPIC_Ext_A}', "");
    Expect(0, 43824, '\P{^Is_Blk=_	ETHIOPIC_Ext_A}', "");
    Error('\p{Block=	Ethiopic_Extended_B:=}');
    Error('\P{Block=	Ethiopic_Extended_B:=}');
    Expect(1, 124927, '\p{Block=:\AEthiopic_Extended_B\z:}', "");;
    Expect(0, 124928, '\p{Block=:\AEthiopic_Extended_B\z:}', "");;
    Expect(1, 124927, '\p{Block:   ethiopicextendedb}', "");
    Expect(0, 124927, '\p{^Block:   ethiopicextendedb}', "");
    Expect(0, 124927, '\P{Block:   ethiopicextendedb}', "");
    Expect(1, 124927, '\P{^Block:   ethiopicextendedb}', "");
    Expect(0, 124928, '\p{Block:   ethiopicextendedb}', "");
    Expect(1, 124928, '\p{^Block:   ethiopicextendedb}', "");
    Expect(1, 124928, '\P{Block:   ethiopicextendedb}', "");
    Expect(0, 124928, '\P{^Block:   ethiopicextendedb}', "");
    Expect(1, 124927, '\p{Block=:\Aethiopicextendedb\z:}', "");;
    Expect(0, 124928, '\p{Block=:\Aethiopicextendedb\z:}', "");;
    Expect(1, 124927, '\p{Block=		Ethiopic_EXTENDED_b}', "");
    Expect(0, 124927, '\p{^Block=		Ethiopic_EXTENDED_b}', "");
    Expect(0, 124927, '\P{Block=		Ethiopic_EXTENDED_b}', "");
    Expect(1, 124927, '\P{^Block=		Ethiopic_EXTENDED_b}', "");
    Expect(0, 124928, '\p{Block=		Ethiopic_EXTENDED_b}', "");
    Expect(1, 124928, '\p{^Block=		Ethiopic_EXTENDED_b}', "");
    Expect(1, 124928, '\P{Block=		Ethiopic_EXTENDED_b}', "");
    Expect(0, 124928, '\P{^Block=		Ethiopic_EXTENDED_b}', "");
    Error('\p{Blk=:=	 ethiopic_Ext_B}');
    Error('\P{Blk=:=	 ethiopic_Ext_B}');
    Expect(1, 124927, '\p{Blk=:\AEthiopic_Ext_B\z:}', "");;
    Expect(0, 124928, '\p{Blk=:\AEthiopic_Ext_B\z:}', "");;
    Expect(1, 124927, '\p{Blk=ethiopicextb}', "");
    Expect(0, 124927, '\p{^Blk=ethiopicextb}', "");
    Expect(0, 124927, '\P{Blk=ethiopicextb}', "");
    Expect(1, 124927, '\P{^Blk=ethiopicextb}', "");
    Expect(0, 124928, '\p{Blk=ethiopicextb}', "");
    Expect(1, 124928, '\p{^Blk=ethiopicextb}', "");
    Expect(1, 124928, '\P{Blk=ethiopicextb}', "");
    Expect(0, 124928, '\P{^Blk=ethiopicextb}', "");
    Expect(1, 124927, '\p{Blk=:\Aethiopicextb\z:}', "");;
    Expect(0, 124928, '\p{Blk=:\Aethiopicextb\z:}', "");;
    Expect(1, 124927, '\p{Blk: 	_Ethiopic_Ext_B}', "");
    Expect(0, 124927, '\p{^Blk: 	_Ethiopic_Ext_B}', "");
    Expect(0, 124927, '\P{Blk: 	_Ethiopic_Ext_B}', "");
    Expect(1, 124927, '\P{^Blk: 	_Ethiopic_Ext_B}', "");
    Expect(0, 124928, '\p{Blk: 	_Ethiopic_Ext_B}', "");
    Expect(1, 124928, '\p{^Blk: 	_Ethiopic_Ext_B}', "");
    Expect(1, 124928, '\P{Blk: 	_Ethiopic_Ext_B}', "");
    Expect(0, 124928, '\P{^Blk: 	_Ethiopic_Ext_B}', "");
    Error('\p{Is_Block=		Ethiopic_Extended_b/a/}');
    Error('\P{Is_Block=		Ethiopic_Extended_b/a/}');
    Expect(1, 124927, '\p{Is_Block=ethiopicextendedb}', "");
    Expect(0, 124927, '\p{^Is_Block=ethiopicextendedb}', "");
    Expect(0, 124927, '\P{Is_Block=ethiopicextendedb}', "");
    Expect(1, 124927, '\P{^Is_Block=ethiopicextendedb}', "");
    Expect(0, 124928, '\p{Is_Block=ethiopicextendedb}', "");
    Expect(1, 124928, '\p{^Is_Block=ethiopicextendedb}', "");
    Expect(1, 124928, '\P{Is_Block=ethiopicextendedb}', "");
    Expect(0, 124928, '\P{^Is_Block=ethiopicextendedb}', "");
    Expect(1, 124927, '\p{Is_Block=_Ethiopic_Extended_B}', "");
    Expect(0, 124927, '\p{^Is_Block=_Ethiopic_Extended_B}', "");
    Expect(0, 124927, '\P{Is_Block=_Ethiopic_Extended_B}', "");
    Expect(1, 124927, '\P{^Is_Block=_Ethiopic_Extended_B}', "");
    Expect(0, 124928, '\p{Is_Block=_Ethiopic_Extended_B}', "");
    Expect(1, 124928, '\p{^Is_Block=_Ethiopic_Extended_B}', "");
    Expect(1, 124928, '\P{Is_Block=_Ethiopic_Extended_B}', "");
    Expect(0, 124928, '\P{^Is_Block=_Ethiopic_Extended_B}', "");
    Error('\p{Is_Blk=/a/__ethiopic_Ext_B}');
    Error('\P{Is_Blk=/a/__ethiopic_Ext_B}');
    Expect(1, 124927, '\p{Is_Blk=ethiopicextb}', "");
    Expect(0, 124927, '\p{^Is_Blk=ethiopicextb}', "");
    Expect(0, 124927, '\P{Is_Blk=ethiopicextb}', "");
    Expect(1, 124927, '\P{^Is_Blk=ethiopicextb}', "");
    Expect(0, 124928, '\p{Is_Blk=ethiopicextb}', "");
    Expect(1, 124928, '\p{^Is_Blk=ethiopicextb}', "");
    Expect(1, 124928, '\P{Is_Blk=ethiopicextb}', "");
    Expect(0, 124928, '\P{^Is_Blk=ethiopicextb}', "");
    Expect(1, 124927, '\p{Is_Blk=-ethiopic_Ext_b}', "");
    Expect(0, 124927, '\p{^Is_Blk=-ethiopic_Ext_b}', "");
    Expect(0, 124927, '\P{Is_Blk=-ethiopic_Ext_b}', "");
    Expect(1, 124927, '\P{^Is_Blk=-ethiopic_Ext_b}', "");
    Expect(0, 124928, '\p{Is_Blk=-ethiopic_Ext_b}', "");
    Expect(1, 124928, '\p{^Is_Blk=-ethiopic_Ext_b}', "");
    Expect(1, 124928, '\P{Is_Blk=-ethiopic_Ext_b}', "");
    Expect(0, 124928, '\P{^Is_Blk=-ethiopic_Ext_b}', "");
    Error('\p{Block=:=-_Ethiopic_supplement}');
    Error('\P{Block=:=-_Ethiopic_supplement}');
    Expect(1, 5023, '\p{Block=:\AEthiopic_Supplement\z:}', "");;
    Expect(0, 5024, '\p{Block=:\AEthiopic_Supplement\z:}', "");;
    Expect(1, 5023, '\p{Block=ethiopicsupplement}', "");
    Expect(0, 5023, '\p{^Block=ethiopicsupplement}', "");
    Expect(0, 5023, '\P{Block=ethiopicsupplement}', "");
    Expect(1, 5023, '\P{^Block=ethiopicsupplement}', "");
    Expect(0, 5024, '\p{Block=ethiopicsupplement}', "");
    Expect(1, 5024, '\p{^Block=ethiopicsupplement}', "");
    Expect(1, 5024, '\P{Block=ethiopicsupplement}', "");
    Expect(0, 5024, '\P{^Block=ethiopicsupplement}', "");
    Expect(1, 5023, '\p{Block=:\Aethiopicsupplement\z:}', "");;
    Expect(0, 5024, '\p{Block=:\Aethiopicsupplement\z:}', "");;
    Expect(1, 5023, '\p{Block=__Ethiopic_Supplement}', "");
    Expect(0, 5023, '\p{^Block=__Ethiopic_Supplement}', "");
    Expect(0, 5023, '\P{Block=__Ethiopic_Supplement}', "");
    Expect(1, 5023, '\P{^Block=__Ethiopic_Supplement}', "");
    Expect(0, 5024, '\p{Block=__Ethiopic_Supplement}', "");
    Expect(1, 5024, '\p{^Block=__Ethiopic_Supplement}', "");
    Expect(1, 5024, '\P{Block=__Ethiopic_Supplement}', "");
    Expect(0, 5024, '\P{^Block=__Ethiopic_Supplement}', "");
    Error('\p{Blk=_Ethiopic_SUP:=}');
    Error('\P{Blk=_Ethiopic_SUP:=}');
    Expect(1, 5023, '\p{Blk=:\AEthiopic_Sup\z:}', "");;
    Expect(0, 5024, '\p{Blk=:\AEthiopic_Sup\z:}', "");;
    Expect(1, 5023, '\p{Blk=ethiopicsup}', "");
    Expect(0, 5023, '\p{^Blk=ethiopicsup}', "");
    Expect(0, 5023, '\P{Blk=ethiopicsup}', "");
    Expect(1, 5023, '\P{^Blk=ethiopicsup}', "");
    Expect(0, 5024, '\p{Blk=ethiopicsup}', "");
    Expect(1, 5024, '\p{^Blk=ethiopicsup}', "");
    Expect(1, 5024, '\P{Blk=ethiopicsup}', "");
    Expect(0, 5024, '\P{^Blk=ethiopicsup}', "");
    Expect(1, 5023, '\p{Blk=:\Aethiopicsup\z:}', "");;
    Expect(0, 5024, '\p{Blk=:\Aethiopicsup\z:}', "");;
    Expect(1, 5023, '\p{Blk=- Ethiopic_Sup}', "");
    Expect(0, 5023, '\p{^Blk=- Ethiopic_Sup}', "");
    Expect(0, 5023, '\P{Blk=- Ethiopic_Sup}', "");
    Expect(1, 5023, '\P{^Blk=- Ethiopic_Sup}', "");
    Expect(0, 5024, '\p{Blk=- Ethiopic_Sup}', "");
    Expect(1, 5024, '\p{^Blk=- Ethiopic_Sup}', "");
    Expect(1, 5024, '\P{Blk=- Ethiopic_Sup}', "");
    Expect(0, 5024, '\P{^Blk=- Ethiopic_Sup}', "");
    Error('\p{Is_Block=_/a/Ethiopic_Supplement}');
    Error('\P{Is_Block=_/a/Ethiopic_Supplement}');
    Expect(1, 5023, '\p{Is_Block: ethiopicsupplement}', "");
    Expect(0, 5023, '\p{^Is_Block: ethiopicsupplement}', "");
    Expect(0, 5023, '\P{Is_Block: ethiopicsupplement}', "");
    Expect(1, 5023, '\P{^Is_Block: ethiopicsupplement}', "");
    Expect(0, 5024, '\p{Is_Block: ethiopicsupplement}', "");
    Expect(1, 5024, '\p{^Is_Block: ethiopicsupplement}', "");
    Expect(1, 5024, '\P{Is_Block: ethiopicsupplement}', "");
    Expect(0, 5024, '\P{^Is_Block: ethiopicsupplement}', "");
    Expect(1, 5023, '\p{Is_Block=Ethiopic_Supplement}', "");
    Expect(0, 5023, '\p{^Is_Block=Ethiopic_Supplement}', "");
    Expect(0, 5023, '\P{Is_Block=Ethiopic_Supplement}', "");
    Expect(1, 5023, '\P{^Is_Block=Ethiopic_Supplement}', "");
    Expect(0, 5024, '\p{Is_Block=Ethiopic_Supplement}', "");
    Expect(1, 5024, '\p{^Is_Block=Ethiopic_Supplement}', "");
    Expect(1, 5024, '\P{Is_Block=Ethiopic_Supplement}', "");
    Expect(0, 5024, '\P{^Is_Block=Ethiopic_Supplement}', "");
    Error('\p{Is_Blk=_:=Ethiopic_Sup}');
    Error('\P{Is_Blk=_:=Ethiopic_Sup}');
    Expect(1, 5023, '\p{Is_Blk=ethiopicsup}', "");
    Expect(0, 5023, '\p{^Is_Blk=ethiopicsup}', "");
    Expect(0, 5023, '\P{Is_Blk=ethiopicsup}', "");
    Expect(1, 5023, '\P{^Is_Blk=ethiopicsup}', "");
    Expect(0, 5024, '\p{Is_Blk=ethiopicsup}', "");
    Expect(1, 5024, '\p{^Is_Blk=ethiopicsup}', "");
    Expect(1, 5024, '\P{Is_Blk=ethiopicsup}', "");
    Expect(0, 5024, '\P{^Is_Blk=ethiopicsup}', "");
    Expect(1, 5023, '\p{Is_Blk:		ethiopic_Sup}', "");
    Expect(0, 5023, '\p{^Is_Blk:		ethiopic_Sup}', "");
    Expect(0, 5023, '\P{Is_Blk:		ethiopic_Sup}', "");
    Expect(1, 5023, '\P{^Is_Blk:		ethiopic_Sup}', "");
    Expect(0, 5024, '\p{Is_Blk:		ethiopic_Sup}', "");
    Expect(1, 5024, '\p{^Is_Blk:		ethiopic_Sup}', "");
    Expect(1, 5024, '\P{Is_Blk:		ethiopic_Sup}', "");
    Expect(0, 5024, '\P{^Is_Blk:		ethiopic_Sup}', "");
    Error('\p{Block=:= 	Geometric_Shapes}');
    Error('\P{Block=:= 	Geometric_Shapes}');
    Expect(1, 9727, '\p{Block=:\AGeometric_Shapes\z:}', "");;
    Expect(0, 9728, '\p{Block=:\AGeometric_Shapes\z:}', "");;
    Expect(1, 9727, '\p{Block=geometricshapes}', "");
    Expect(0, 9727, '\p{^Block=geometricshapes}', "");
    Expect(0, 9727, '\P{Block=geometricshapes}', "");
    Expect(1, 9727, '\P{^Block=geometricshapes}', "");
    Expect(0, 9728, '\p{Block=geometricshapes}', "");
    Expect(1, 9728, '\p{^Block=geometricshapes}', "");
    Expect(1, 9728, '\P{Block=geometricshapes}', "");
    Expect(0, 9728, '\P{^Block=geometricshapes}', "");
    Expect(1, 9727, '\p{Block=:\Ageometricshapes\z:}', "");;
    Expect(0, 9728, '\p{Block=:\Ageometricshapes\z:}', "");;
    Expect(1, 9727, '\p{Block=	 geometric_shapes}', "");
    Expect(0, 9727, '\p{^Block=	 geometric_shapes}', "");
    Expect(0, 9727, '\P{Block=	 geometric_shapes}', "");
    Expect(1, 9727, '\P{^Block=	 geometric_shapes}', "");
    Expect(0, 9728, '\p{Block=	 geometric_shapes}', "");
    Expect(1, 9728, '\p{^Block=	 geometric_shapes}', "");
    Expect(1, 9728, '\P{Block=	 geometric_shapes}', "");
    Expect(0, 9728, '\P{^Block=	 geometric_shapes}', "");
    Error('\p{Blk=:=geometric_Shapes}');
    Error('\P{Blk=:=geometric_Shapes}');
    Expect(1, 9727, '\p{Blk=:\AGeometric_Shapes\z:}', "");;
    Expect(0, 9728, '\p{Blk=:\AGeometric_Shapes\z:}', "");;
    Expect(1, 9727, '\p{Blk=geometricshapes}', "");
    Expect(0, 9727, '\p{^Blk=geometricshapes}', "");
    Expect(0, 9727, '\P{Blk=geometricshapes}', "");
    Expect(1, 9727, '\P{^Blk=geometricshapes}', "");
    Expect(0, 9728, '\p{Blk=geometricshapes}', "");
    Expect(1, 9728, '\p{^Blk=geometricshapes}', "");
    Expect(1, 9728, '\P{Blk=geometricshapes}', "");
    Expect(0, 9728, '\P{^Blk=geometricshapes}', "");
    Expect(1, 9727, '\p{Blk=:\Ageometricshapes\z:}', "");;
    Expect(0, 9728, '\p{Blk=:\Ageometricshapes\z:}', "");;
    Expect(1, 9727, '\p{Blk=-_Geometric_Shapes}', "");
    Expect(0, 9727, '\p{^Blk=-_Geometric_Shapes}', "");
    Expect(0, 9727, '\P{Blk=-_Geometric_Shapes}', "");
    Expect(1, 9727, '\P{^Blk=-_Geometric_Shapes}', "");
    Expect(0, 9728, '\p{Blk=-_Geometric_Shapes}', "");
    Expect(1, 9728, '\p{^Blk=-_Geometric_Shapes}', "");
    Expect(1, 9728, '\P{Blk=-_Geometric_Shapes}', "");
    Expect(0, 9728, '\P{^Blk=-_Geometric_Shapes}', "");
    Error('\p{Is_Block=	_Geometric_SHAPES:=}');
    Error('\P{Is_Block=	_Geometric_SHAPES:=}');
    Expect(1, 9727, '\p{Is_Block=geometricshapes}', "");
    Expect(0, 9727, '\p{^Is_Block=geometricshapes}', "");
    Expect(0, 9727, '\P{Is_Block=geometricshapes}', "");
    Expect(1, 9727, '\P{^Is_Block=geometricshapes}', "");
    Expect(0, 9728, '\p{Is_Block=geometricshapes}', "");
    Expect(1, 9728, '\p{^Is_Block=geometricshapes}', "");
    Expect(1, 9728, '\P{Is_Block=geometricshapes}', "");
    Expect(0, 9728, '\P{^Is_Block=geometricshapes}', "");
    Expect(1, 9727, '\p{Is_Block= _Geometric_Shapes}', "");
    Expect(0, 9727, '\p{^Is_Block= _Geometric_Shapes}', "");
    Expect(0, 9727, '\P{Is_Block= _Geometric_Shapes}', "");
    Expect(1, 9727, '\P{^Is_Block= _Geometric_Shapes}', "");
    Expect(0, 9728, '\p{Is_Block= _Geometric_Shapes}', "");
    Expect(1, 9728, '\p{^Is_Block= _Geometric_Shapes}', "");
    Expect(1, 9728, '\P{Is_Block= _Geometric_Shapes}', "");
    Expect(0, 9728, '\P{^Is_Block= _Geometric_Shapes}', "");
    Error('\p{Is_Blk=_:=GEOMETRIC_Shapes}');
    Error('\P{Is_Blk=_:=GEOMETRIC_Shapes}');
    Expect(1, 9727, '\p{Is_Blk=geometricshapes}', "");
    Expect(0, 9727, '\p{^Is_Blk=geometricshapes}', "");
    Expect(0, 9727, '\P{Is_Blk=geometricshapes}', "");
    Expect(1, 9727, '\P{^Is_Blk=geometricshapes}', "");
    Expect(0, 9728, '\p{Is_Blk=geometricshapes}', "");
    Expect(1, 9728, '\p{^Is_Blk=geometricshapes}', "");
    Expect(1, 9728, '\P{Is_Blk=geometricshapes}', "");
    Expect(0, 9728, '\P{^Is_Blk=geometricshapes}', "");
    Expect(1, 9727, '\p{Is_Blk= GEOMETRIC_Shapes}', "");
    Expect(0, 9727, '\p{^Is_Blk= GEOMETRIC_Shapes}', "");
    Expect(0, 9727, '\P{Is_Blk= GEOMETRIC_Shapes}', "");
    Expect(1, 9727, '\P{^Is_Blk= GEOMETRIC_Shapes}', "");
    Expect(0, 9728, '\p{Is_Blk= GEOMETRIC_Shapes}', "");
    Expect(1, 9728, '\p{^Is_Blk= GEOMETRIC_Shapes}', "");
    Expect(1, 9728, '\P{Is_Blk= GEOMETRIC_Shapes}', "");
    Expect(0, 9728, '\P{^Is_Blk= GEOMETRIC_Shapes}', "");
    Error('\p{Block=:=Geometric_shapes_EXTENDED}');
    Error('\P{Block=:=Geometric_shapes_EXTENDED}');
    Expect(1, 129023, '\p{Block=:\AGeometric_Shapes_Extended\z:}', "");;
    Expect(0, 129024, '\p{Block=:\AGeometric_Shapes_Extended\z:}', "");;
    Expect(1, 129023, '\p{Block=geometricshapesextended}', "");
    Expect(0, 129023, '\p{^Block=geometricshapesextended}', "");
    Expect(0, 129023, '\P{Block=geometricshapesextended}', "");
    Expect(1, 129023, '\P{^Block=geometricshapesextended}', "");
    Expect(0, 129024, '\p{Block=geometricshapesextended}', "");
    Expect(1, 129024, '\p{^Block=geometricshapesextended}', "");
    Expect(1, 129024, '\P{Block=geometricshapesextended}', "");
    Expect(0, 129024, '\P{^Block=geometricshapesextended}', "");
    Expect(1, 129023, '\p{Block=:\Ageometricshapesextended\z:}', "");;
    Expect(0, 129024, '\p{Block=:\Ageometricshapesextended\z:}', "");;
    Expect(1, 129023, '\p{Block=__GEOMETRIC_SHAPES_Extended}', "");
    Expect(0, 129023, '\p{^Block=__GEOMETRIC_SHAPES_Extended}', "");
    Expect(0, 129023, '\P{Block=__GEOMETRIC_SHAPES_Extended}', "");
    Expect(1, 129023, '\P{^Block=__GEOMETRIC_SHAPES_Extended}', "");
    Expect(0, 129024, '\p{Block=__GEOMETRIC_SHAPES_Extended}', "");
    Expect(1, 129024, '\p{^Block=__GEOMETRIC_SHAPES_Extended}', "");
    Expect(1, 129024, '\P{Block=__GEOMETRIC_SHAPES_Extended}', "");
    Expect(0, 129024, '\P{^Block=__GEOMETRIC_SHAPES_Extended}', "");
    Error('\p{Blk=:=	Geometric_SHAPES_EXT}');
    Error('\P{Blk=:=	Geometric_SHAPES_EXT}');
    Expect(1, 129023, '\p{Blk=:\AGeometric_Shapes_Ext\z:}', "");;
    Expect(0, 129024, '\p{Blk=:\AGeometric_Shapes_Ext\z:}', "");;
    Expect(1, 129023, '\p{Blk=geometricshapesext}', "");
    Expect(0, 129023, '\p{^Blk=geometricshapesext}', "");
    Expect(0, 129023, '\P{Blk=geometricshapesext}', "");
    Expect(1, 129023, '\P{^Blk=geometricshapesext}', "");
    Expect(0, 129024, '\p{Blk=geometricshapesext}', "");
    Expect(1, 129024, '\p{^Blk=geometricshapesext}', "");
    Expect(1, 129024, '\P{Blk=geometricshapesext}', "");
    Expect(0, 129024, '\P{^Blk=geometricshapesext}', "");
    Expect(1, 129023, '\p{Blk=:\Ageometricshapesext\z:}', "");;
    Expect(0, 129024, '\p{Blk=:\Ageometricshapesext\z:}', "");;
    Expect(1, 129023, '\p{Blk=	Geometric_Shapes_Ext}', "");
    Expect(0, 129023, '\p{^Blk=	Geometric_Shapes_Ext}', "");
    Expect(0, 129023, '\P{Blk=	Geometric_Shapes_Ext}', "");
    Expect(1, 129023, '\P{^Blk=	Geometric_Shapes_Ext}', "");
    Expect(0, 129024, '\p{Blk=	Geometric_Shapes_Ext}', "");
    Expect(1, 129024, '\p{^Blk=	Geometric_Shapes_Ext}', "");
    Expect(1, 129024, '\P{Blk=	Geometric_Shapes_Ext}', "");
    Expect(0, 129024, '\P{^Blk=	Geometric_Shapes_Ext}', "");
    Error('\p{Is_Block=:=- GEOMETRIC_SHAPES_Extended}');
    Error('\P{Is_Block=:=- GEOMETRIC_SHAPES_Extended}');
    Expect(1, 129023, '\p{Is_Block=geometricshapesextended}', "");
    Expect(0, 129023, '\p{^Is_Block=geometricshapesextended}', "");
    Expect(0, 129023, '\P{Is_Block=geometricshapesextended}', "");
    Expect(1, 129023, '\P{^Is_Block=geometricshapesextended}', "");
    Expect(0, 129024, '\p{Is_Block=geometricshapesextended}', "");
    Expect(1, 129024, '\p{^Is_Block=geometricshapesextended}', "");
    Expect(1, 129024, '\P{Is_Block=geometricshapesextended}', "");
    Expect(0, 129024, '\P{^Is_Block=geometricshapesextended}', "");
    Expect(1, 129023, '\p{Is_Block=	 GEOMETRIC_Shapes_Extended}', "");
    Expect(0, 129023, '\p{^Is_Block=	 GEOMETRIC_Shapes_Extended}', "");
    Expect(0, 129023, '\P{Is_Block=	 GEOMETRIC_Shapes_Extended}', "");
    Expect(1, 129023, '\P{^Is_Block=	 GEOMETRIC_Shapes_Extended}', "");
    Expect(0, 129024, '\p{Is_Block=	 GEOMETRIC_Shapes_Extended}', "");
    Expect(1, 129024, '\p{^Is_Block=	 GEOMETRIC_Shapes_Extended}', "");
    Expect(1, 129024, '\P{Is_Block=	 GEOMETRIC_Shapes_Extended}', "");
    Expect(0, 129024, '\P{^Is_Block=	 GEOMETRIC_Shapes_Extended}', "");
    Error('\p{Is_Blk=_/a/GEOMETRIC_shapes_Ext}');
    Error('\P{Is_Blk=_/a/GEOMETRIC_shapes_Ext}');
    Expect(1, 129023, '\p{Is_Blk=geometricshapesext}', "");
    Expect(0, 129023, '\p{^Is_Blk=geometricshapesext}', "");
    Expect(0, 129023, '\P{Is_Blk=geometricshapesext}', "");
    Expect(1, 129023, '\P{^Is_Blk=geometricshapesext}', "");
    Expect(0, 129024, '\p{Is_Blk=geometricshapesext}', "");
    Expect(1, 129024, '\p{^Is_Blk=geometricshapesext}', "");
    Expect(1, 129024, '\P{Is_Blk=geometricshapesext}', "");
    Expect(0, 129024, '\P{^Is_Blk=geometricshapesext}', "");
    Expect(1, 129023, '\p{Is_Blk=	-Geometric_shapes_ext}', "");
    Expect(0, 129023, '\p{^Is_Blk=	-Geometric_shapes_ext}', "");
    Expect(0, 129023, '\P{Is_Blk=	-Geometric_shapes_ext}', "");
    Expect(1, 129023, '\P{^Is_Blk=	-Geometric_shapes_ext}', "");
    Expect(0, 129024, '\p{Is_Blk=	-Geometric_shapes_ext}', "");
    Expect(1, 129024, '\p{^Is_Blk=	-Geometric_shapes_ext}', "");
    Expect(1, 129024, '\P{Is_Blk=	-Geometric_shapes_ext}', "");
    Expect(0, 129024, '\P{^Is_Blk=	-Geometric_shapes_ext}', "");
    Error('\p{Block=	/a/Georgian}');
    Error('\P{Block=	/a/Georgian}');
    Expect(1, 4351, '\p{Block=:\AGeorgian\z:}', "");;
    Expect(0, 4352, '\p{Block=:\AGeorgian\z:}', "");;
    Expect(1, 4351, '\p{Block=georgian}', "");
    Expect(0, 4351, '\p{^Block=georgian}', "");
    Expect(0, 4351, '\P{Block=georgian}', "");
    Expect(1, 4351, '\P{^Block=georgian}', "");
    Expect(0, 4352, '\p{Block=georgian}', "");
    Expect(1, 4352, '\p{^Block=georgian}', "");
    Expect(1, 4352, '\P{Block=georgian}', "");
    Expect(0, 4352, '\P{^Block=georgian}', "");
    Expect(1, 4351, '\p{Block=:\Ageorgian\z:}', "");;
    Expect(0, 4352, '\p{Block=:\Ageorgian\z:}', "");;
    Expect(1, 4351, '\p{Block:  GEORGIAN}', "");
    Expect(0, 4351, '\p{^Block:  GEORGIAN}', "");
    Expect(0, 4351, '\P{Block:  GEORGIAN}', "");
    Expect(1, 4351, '\P{^Block:  GEORGIAN}', "");
    Expect(0, 4352, '\p{Block:  GEORGIAN}', "");
    Expect(1, 4352, '\p{^Block:  GEORGIAN}', "");
    Expect(1, 4352, '\P{Block:  GEORGIAN}', "");
    Expect(0, 4352, '\P{^Block:  GEORGIAN}', "");
    Error('\p{Blk:    :=GEORGIAN}');
    Error('\P{Blk:    :=GEORGIAN}');
    Expect(1, 4351, '\p{Blk=:\AGeorgian\z:}', "");;
    Expect(0, 4352, '\p{Blk=:\AGeorgian\z:}', "");;
    Expect(1, 4351, '\p{Blk=georgian}', "");
    Expect(0, 4351, '\p{^Blk=georgian}', "");
    Expect(0, 4351, '\P{Blk=georgian}', "");
    Expect(1, 4351, '\P{^Blk=georgian}', "");
    Expect(0, 4352, '\p{Blk=georgian}', "");
    Expect(1, 4352, '\p{^Blk=georgian}', "");
    Expect(1, 4352, '\P{Blk=georgian}', "");
    Expect(0, 4352, '\P{^Blk=georgian}', "");
    Expect(1, 4351, '\p{Blk=:\Ageorgian\z:}', "");;
    Expect(0, 4352, '\p{Blk=:\Ageorgian\z:}', "");;
    Expect(1, 4351, '\p{Blk=  georgian}', "");
    Expect(0, 4351, '\p{^Blk=  georgian}', "");
    Expect(0, 4351, '\P{Blk=  georgian}', "");
    Expect(1, 4351, '\P{^Blk=  georgian}', "");
    Expect(0, 4352, '\p{Blk=  georgian}', "");
    Expect(1, 4352, '\p{^Blk=  georgian}', "");
    Expect(1, 4352, '\P{Blk=  georgian}', "");
    Expect(0, 4352, '\P{^Blk=  georgian}', "");
    Error('\p{Is_Block:     GEORGIAN/a/}');
    Error('\P{Is_Block:     GEORGIAN/a/}');
    Expect(1, 4351, '\p{Is_Block=georgian}', "");
    Expect(0, 4351, '\p{^Is_Block=georgian}', "");
    Expect(0, 4351, '\P{Is_Block=georgian}', "");
    Expect(1, 4351, '\P{^Is_Block=georgian}', "");
    Expect(0, 4352, '\p{Is_Block=georgian}', "");
    Expect(1, 4352, '\p{^Is_Block=georgian}', "");
    Expect(1, 4352, '\P{Is_Block=georgian}', "");
    Expect(0, 4352, '\P{^Is_Block=georgian}', "");
    Expect(1, 4351, '\p{Is_Block=	-georgian}', "");
    Expect(0, 4351, '\p{^Is_Block=	-georgian}', "");
    Expect(0, 4351, '\P{Is_Block=	-georgian}', "");
    Expect(1, 4351, '\P{^Is_Block=	-georgian}', "");
    Expect(0, 4352, '\p{Is_Block=	-georgian}', "");
    Expect(1, 4352, '\p{^Is_Block=	-georgian}', "");
    Expect(1, 4352, '\P{Is_Block=	-georgian}', "");
    Expect(0, 4352, '\P{^Is_Block=	-georgian}', "");
    Error('\p{Is_Blk=__Georgian/a/}');
    Error('\P{Is_Blk=__Georgian/a/}');
    Expect(1, 4351, '\p{Is_Blk=georgian}', "");
    Expect(0, 4351, '\p{^Is_Blk=georgian}', "");
    Expect(0, 4351, '\P{Is_Blk=georgian}', "");
    Expect(1, 4351, '\P{^Is_Blk=georgian}', "");
    Expect(0, 4352, '\p{Is_Blk=georgian}', "");
    Expect(1, 4352, '\p{^Is_Blk=georgian}', "");
    Expect(1, 4352, '\P{Is_Blk=georgian}', "");
    Expect(0, 4352, '\P{^Is_Blk=georgian}', "");
    Expect(1, 4351, '\p{Is_Blk=	GEORGIAN}', "");
    Expect(0, 4351, '\p{^Is_Blk=	GEORGIAN}', "");
    Expect(0, 4351, '\P{Is_Blk=	GEORGIAN}', "");
    Expect(1, 4351, '\P{^Is_Blk=	GEORGIAN}', "");
    Expect(0, 4352, '\p{Is_Blk=	GEORGIAN}', "");
    Expect(1, 4352, '\p{^Is_Blk=	GEORGIAN}', "");
    Expect(1, 4352, '\P{Is_Blk=	GEORGIAN}', "");
    Expect(0, 4352, '\P{^Is_Blk=	GEORGIAN}', "");
    Error('\p{Block=:=__GEORGIAN_Extended}');
    Error('\P{Block=:=__GEORGIAN_Extended}');
    Expect(1, 7359, '\p{Block=:\AGeorgian_Extended\z:}', "");;
    Expect(0, 7360, '\p{Block=:\AGeorgian_Extended\z:}', "");;
    Expect(1, 7359, '\p{Block=georgianextended}', "");
    Expect(0, 7359, '\p{^Block=georgianextended}', "");
    Expect(0, 7359, '\P{Block=georgianextended}', "");
    Expect(1, 7359, '\P{^Block=georgianextended}', "");
    Expect(0, 7360, '\p{Block=georgianextended}', "");
    Expect(1, 7360, '\p{^Block=georgianextended}', "");
    Expect(1, 7360, '\P{Block=georgianextended}', "");
    Expect(0, 7360, '\P{^Block=georgianextended}', "");
    Expect(1, 7359, '\p{Block=:\Ageorgianextended\z:}', "");;
    Expect(0, 7360, '\p{Block=:\Ageorgianextended\z:}', "");;
    Expect(1, 7359, '\p{Block=- GEORGIAN_Extended}', "");
    Expect(0, 7359, '\p{^Block=- GEORGIAN_Extended}', "");
    Expect(0, 7359, '\P{Block=- GEORGIAN_Extended}', "");
    Expect(1, 7359, '\P{^Block=- GEORGIAN_Extended}', "");
    Expect(0, 7360, '\p{Block=- GEORGIAN_Extended}', "");
    Expect(1, 7360, '\p{^Block=- GEORGIAN_Extended}', "");
    Expect(1, 7360, '\P{Block=- GEORGIAN_Extended}', "");
    Expect(0, 7360, '\P{^Block=- GEORGIAN_Extended}', "");
    Error('\p{Blk=__Georgian_EXT:=}');
    Error('\P{Blk=__Georgian_EXT:=}');
    Expect(1, 7359, '\p{Blk=:\AGeorgian_Ext\z:}', "");;
    Expect(0, 7360, '\p{Blk=:\AGeorgian_Ext\z:}', "");;
    Expect(1, 7359, '\p{Blk=georgianext}', "");
    Expect(0, 7359, '\p{^Blk=georgianext}', "");
    Expect(0, 7359, '\P{Blk=georgianext}', "");
    Expect(1, 7359, '\P{^Blk=georgianext}', "");
    Expect(0, 7360, '\p{Blk=georgianext}', "");
    Expect(1, 7360, '\p{^Blk=georgianext}', "");
    Expect(1, 7360, '\P{Blk=georgianext}', "");
    Expect(0, 7360, '\P{^Blk=georgianext}', "");
    Expect(1, 7359, '\p{Blk=:\Ageorgianext\z:}', "");;
    Expect(0, 7360, '\p{Blk=:\Ageorgianext\z:}', "");;
    Expect(1, 7359, '\p{Blk= Georgian_Ext}', "");
    Expect(0, 7359, '\p{^Blk= Georgian_Ext}', "");
    Expect(0, 7359, '\P{Blk= Georgian_Ext}', "");
    Expect(1, 7359, '\P{^Blk= Georgian_Ext}', "");
    Expect(0, 7360, '\p{Blk= Georgian_Ext}', "");
    Expect(1, 7360, '\p{^Blk= Georgian_Ext}', "");
    Expect(1, 7360, '\P{Blk= Georgian_Ext}', "");
    Expect(0, 7360, '\P{^Blk= Georgian_Ext}', "");
    Error('\p{Is_Block: _/a/GEORGIAN_extended}');
    Error('\P{Is_Block: _/a/GEORGIAN_extended}');
    Expect(1, 7359, '\p{Is_Block=georgianextended}', "");
    Expect(0, 7359, '\p{^Is_Block=georgianextended}', "");
    Expect(0, 7359, '\P{Is_Block=georgianextended}', "");
    Expect(1, 7359, '\P{^Is_Block=georgianextended}', "");
    Expect(0, 7360, '\p{Is_Block=georgianextended}', "");
    Expect(1, 7360, '\p{^Is_Block=georgianextended}', "");
    Expect(1, 7360, '\P{Is_Block=georgianextended}', "");
    Expect(0, 7360, '\P{^Is_Block=georgianextended}', "");
    Expect(1, 7359, '\p{Is_Block=_ georgian_Extended}', "");
    Expect(0, 7359, '\p{^Is_Block=_ georgian_Extended}', "");
    Expect(0, 7359, '\P{Is_Block=_ georgian_Extended}', "");
    Expect(1, 7359, '\P{^Is_Block=_ georgian_Extended}', "");
    Expect(0, 7360, '\p{Is_Block=_ georgian_Extended}', "");
    Expect(1, 7360, '\p{^Is_Block=_ georgian_Extended}', "");
    Expect(1, 7360, '\P{Is_Block=_ georgian_Extended}', "");
    Expect(0, 7360, '\P{^Is_Block=_ georgian_Extended}', "");
    Error('\p{Is_Blk=:=	georgian_Ext}');
    Error('\P{Is_Blk=:=	georgian_Ext}');
    Expect(1, 7359, '\p{Is_Blk=georgianext}', "");
    Expect(0, 7359, '\p{^Is_Blk=georgianext}', "");
    Expect(0, 7359, '\P{Is_Blk=georgianext}', "");
    Expect(1, 7359, '\P{^Is_Blk=georgianext}', "");
    Expect(0, 7360, '\p{Is_Blk=georgianext}', "");
    Expect(1, 7360, '\p{^Is_Blk=georgianext}', "");
    Expect(1, 7360, '\P{Is_Blk=georgianext}', "");
    Expect(0, 7360, '\P{^Is_Blk=georgianext}', "");
    Expect(1, 7359, '\p{Is_Blk:-	georgian_Ext}', "");
    Expect(0, 7359, '\p{^Is_Blk:-	georgian_Ext}', "");
    Expect(0, 7359, '\P{Is_Blk:-	georgian_Ext}', "");
    Expect(1, 7359, '\P{^Is_Blk:-	georgian_Ext}', "");
    Expect(0, 7360, '\p{Is_Blk:-	georgian_Ext}', "");
    Expect(1, 7360, '\p{^Is_Blk:-	georgian_Ext}', "");
    Expect(1, 7360, '\P{Is_Blk:-	georgian_Ext}', "");
    Expect(0, 7360, '\P{^Is_Blk:-	georgian_Ext}', "");
    Error('\p{Block=	 Georgian_Supplement/a/}');
    Error('\P{Block=	 Georgian_Supplement/a/}');
    Expect(1, 11567, '\p{Block=:\AGeorgian_Supplement\z:}', "");;
    Expect(0, 11568, '\p{Block=:\AGeorgian_Supplement\z:}', "");;
    Expect(1, 11567, '\p{Block=georgiansupplement}', "");
    Expect(0, 11567, '\p{^Block=georgiansupplement}', "");
    Expect(0, 11567, '\P{Block=georgiansupplement}', "");
    Expect(1, 11567, '\P{^Block=georgiansupplement}', "");
    Expect(0, 11568, '\p{Block=georgiansupplement}', "");
    Expect(1, 11568, '\p{^Block=georgiansupplement}', "");
    Expect(1, 11568, '\P{Block=georgiansupplement}', "");
    Expect(0, 11568, '\P{^Block=georgiansupplement}', "");
    Expect(1, 11567, '\p{Block=:\Ageorgiansupplement\z:}', "");;
    Expect(0, 11568, '\p{Block=:\Ageorgiansupplement\z:}', "");;
    Expect(1, 11567, '\p{Block=	-Georgian_Supplement}', "");
    Expect(0, 11567, '\p{^Block=	-Georgian_Supplement}', "");
    Expect(0, 11567, '\P{Block=	-Georgian_Supplement}', "");
    Expect(1, 11567, '\P{^Block=	-Georgian_Supplement}', "");
    Expect(0, 11568, '\p{Block=	-Georgian_Supplement}', "");
    Expect(1, 11568, '\p{^Block=	-Georgian_Supplement}', "");
    Expect(1, 11568, '\P{Block=	-Georgian_Supplement}', "");
    Expect(0, 11568, '\P{^Block=	-Georgian_Supplement}', "");
    Error('\p{Blk=/a/_Georgian_Sup}');
    Error('\P{Blk=/a/_Georgian_Sup}');
    Expect(1, 11567, '\p{Blk=:\AGeorgian_Sup\z:}', "");;
    Expect(0, 11568, '\p{Blk=:\AGeorgian_Sup\z:}', "");;
    Expect(1, 11567, '\p{Blk=georgiansup}', "");
    Expect(0, 11567, '\p{^Blk=georgiansup}', "");
    Expect(0, 11567, '\P{Blk=georgiansup}', "");
    Expect(1, 11567, '\P{^Blk=georgiansup}', "");
    Expect(0, 11568, '\p{Blk=georgiansup}', "");
    Expect(1, 11568, '\p{^Blk=georgiansup}', "");
    Expect(1, 11568, '\P{Blk=georgiansup}', "");
    Expect(0, 11568, '\P{^Blk=georgiansup}', "");
    Expect(1, 11567, '\p{Blk=:\Ageorgiansup\z:}', "");;
    Expect(0, 11568, '\p{Blk=:\Ageorgiansup\z:}', "");;
    Expect(1, 11567, '\p{Blk=_-georgian_Sup}', "");
    Expect(0, 11567, '\p{^Blk=_-georgian_Sup}', "");
    Expect(0, 11567, '\P{Blk=_-georgian_Sup}', "");
    Expect(1, 11567, '\P{^Blk=_-georgian_Sup}', "");
    Expect(0, 11568, '\p{Blk=_-georgian_Sup}', "");
    Expect(1, 11568, '\p{^Blk=_-georgian_Sup}', "");
    Expect(1, 11568, '\P{Blk=_-georgian_Sup}', "");
    Expect(0, 11568, '\P{^Blk=_-georgian_Sup}', "");
    Error('\p{Is_Block=-_georgian_supplement/a/}');
    Error('\P{Is_Block=-_georgian_supplement/a/}');
    Expect(1, 11567, '\p{Is_Block=georgiansupplement}', "");
    Expect(0, 11567, '\p{^Is_Block=georgiansupplement}', "");
    Expect(0, 11567, '\P{Is_Block=georgiansupplement}', "");
    Expect(1, 11567, '\P{^Is_Block=georgiansupplement}', "");
    Expect(0, 11568, '\p{Is_Block=georgiansupplement}', "");
    Expect(1, 11568, '\p{^Is_Block=georgiansupplement}', "");
    Expect(1, 11568, '\P{Is_Block=georgiansupplement}', "");
    Expect(0, 11568, '\P{^Is_Block=georgiansupplement}', "");
    Expect(1, 11567, '\p{Is_Block=_georgian_supplement}', "");
    Expect(0, 11567, '\p{^Is_Block=_georgian_supplement}', "");
    Expect(0, 11567, '\P{Is_Block=_georgian_supplement}', "");
    Expect(1, 11567, '\P{^Is_Block=_georgian_supplement}', "");
    Expect(0, 11568, '\p{Is_Block=_georgian_supplement}', "");
    Expect(1, 11568, '\p{^Is_Block=_georgian_supplement}', "");
    Expect(1, 11568, '\P{Is_Block=_georgian_supplement}', "");
    Expect(0, 11568, '\P{^Is_Block=_georgian_supplement}', "");
    Error('\p{Is_Blk=/a/Georgian_sup}');
    Error('\P{Is_Blk=/a/Georgian_sup}');
    Expect(1, 11567, '\p{Is_Blk=georgiansup}', "");
    Expect(0, 11567, '\p{^Is_Blk=georgiansup}', "");
    Expect(0, 11567, '\P{Is_Blk=georgiansup}', "");
    Expect(1, 11567, '\P{^Is_Blk=georgiansup}', "");
    Expect(0, 11568, '\p{Is_Blk=georgiansup}', "");
    Expect(1, 11568, '\p{^Is_Blk=georgiansup}', "");
    Expect(1, 11568, '\P{Is_Blk=georgiansup}', "");
    Expect(0, 11568, '\P{^Is_Blk=georgiansup}', "");
    Expect(1, 11567, '\p{Is_Blk=__GEORGIAN_Sup}', "");
    Expect(0, 11567, '\p{^Is_Blk=__GEORGIAN_Sup}', "");
    Expect(0, 11567, '\P{Is_Blk=__GEORGIAN_Sup}', "");
    Expect(1, 11567, '\P{^Is_Blk=__GEORGIAN_Sup}', "");
    Expect(0, 11568, '\p{Is_Blk=__GEORGIAN_Sup}', "");
    Expect(1, 11568, '\p{^Is_Blk=__GEORGIAN_Sup}', "");
    Expect(1, 11568, '\P{Is_Blk=__GEORGIAN_Sup}', "");
    Expect(0, 11568, '\P{^Is_Blk=__GEORGIAN_Sup}', "");
    Error('\p{Block=-/a/glagolitic}');
    Error('\P{Block=-/a/glagolitic}');
    Expect(1, 11359, '\p{Block=:\AGlagolitic\z:}', "");;
    Expect(0, 11360, '\p{Block=:\AGlagolitic\z:}', "");;
    Expect(1, 11359, '\p{Block=glagolitic}', "");
    Expect(0, 11359, '\p{^Block=glagolitic}', "");
    Expect(0, 11359, '\P{Block=glagolitic}', "");
    Expect(1, 11359, '\P{^Block=glagolitic}', "");
    Expect(0, 11360, '\p{Block=glagolitic}', "");
    Expect(1, 11360, '\p{^Block=glagolitic}', "");
    Expect(1, 11360, '\P{Block=glagolitic}', "");
    Expect(0, 11360, '\P{^Block=glagolitic}', "");
    Expect(1, 11359, '\p{Block=:\Aglagolitic\z:}', "");;
    Expect(0, 11360, '\p{Block=:\Aglagolitic\z:}', "");;
    Expect(1, 11359, '\p{Block= _GLAGOLITIC}', "");
    Expect(0, 11359, '\p{^Block= _GLAGOLITIC}', "");
    Expect(0, 11359, '\P{Block= _GLAGOLITIC}', "");
    Expect(1, 11359, '\P{^Block= _GLAGOLITIC}', "");
    Expect(0, 11360, '\p{Block= _GLAGOLITIC}', "");
    Expect(1, 11360, '\p{^Block= _GLAGOLITIC}', "");
    Expect(1, 11360, '\P{Block= _GLAGOLITIC}', "");
    Expect(0, 11360, '\P{^Block= _GLAGOLITIC}', "");
    Error('\p{Blk=	/a/Glagolitic}');
    Error('\P{Blk=	/a/Glagolitic}');
    Expect(1, 11359, '\p{Blk=:\AGlagolitic\z:}', "");;
    Expect(0, 11360, '\p{Blk=:\AGlagolitic\z:}', "");;
    Expect(1, 11359, '\p{Blk=glagolitic}', "");
    Expect(0, 11359, '\p{^Blk=glagolitic}', "");
    Expect(0, 11359, '\P{Blk=glagolitic}', "");
    Expect(1, 11359, '\P{^Blk=glagolitic}', "");
    Expect(0, 11360, '\p{Blk=glagolitic}', "");
    Expect(1, 11360, '\p{^Blk=glagolitic}', "");
    Expect(1, 11360, '\P{Blk=glagolitic}', "");
    Expect(0, 11360, '\P{^Blk=glagolitic}', "");
    Expect(1, 11359, '\p{Blk=:\Aglagolitic\z:}', "");;
    Expect(0, 11360, '\p{Blk=:\Aglagolitic\z:}', "");;
    Expect(1, 11359, '\p{Blk=	Glagolitic}', "");
    Expect(0, 11359, '\p{^Blk=	Glagolitic}', "");
    Expect(0, 11359, '\P{Blk=	Glagolitic}', "");
    Expect(1, 11359, '\P{^Blk=	Glagolitic}', "");
    Expect(0, 11360, '\p{Blk=	Glagolitic}', "");
    Expect(1, 11360, '\p{^Blk=	Glagolitic}', "");
    Expect(1, 11360, '\P{Blk=	Glagolitic}', "");
    Expect(0, 11360, '\P{^Blk=	Glagolitic}', "");
    Error('\p{Is_Block=-/a/glagolitic}');
    Error('\P{Is_Block=-/a/glagolitic}');
    Expect(1, 11359, '\p{Is_Block=glagolitic}', "");
    Expect(0, 11359, '\p{^Is_Block=glagolitic}', "");
    Expect(0, 11359, '\P{Is_Block=glagolitic}', "");
    Expect(1, 11359, '\P{^Is_Block=glagolitic}', "");
    Expect(0, 11360, '\p{Is_Block=glagolitic}', "");
    Expect(1, 11360, '\p{^Is_Block=glagolitic}', "");
    Expect(1, 11360, '\P{Is_Block=glagolitic}', "");
    Expect(0, 11360, '\P{^Is_Block=glagolitic}', "");
    Expect(1, 11359, '\p{Is_Block=Glagolitic}', "");
    Expect(0, 11359, '\p{^Is_Block=Glagolitic}', "");
    Expect(0, 11359, '\P{Is_Block=Glagolitic}', "");
    Expect(1, 11359, '\P{^Is_Block=Glagolitic}', "");
    Expect(0, 11360, '\p{Is_Block=Glagolitic}', "");
    Expect(1, 11360, '\p{^Is_Block=Glagolitic}', "");
    Expect(1, 11360, '\P{Is_Block=Glagolitic}', "");
    Expect(0, 11360, '\P{^Is_Block=Glagolitic}', "");
    Error('\p{Is_Blk=/a/GLAGOLITIC}');
    Error('\P{Is_Blk=/a/GLAGOLITIC}');
    Expect(1, 11359, '\p{Is_Blk=glagolitic}', "");
    Expect(0, 11359, '\p{^Is_Blk=glagolitic}', "");
    Expect(0, 11359, '\P{Is_Blk=glagolitic}', "");
    Expect(1, 11359, '\P{^Is_Blk=glagolitic}', "");
    Expect(0, 11360, '\p{Is_Blk=glagolitic}', "");
    Expect(1, 11360, '\p{^Is_Blk=glagolitic}', "");
    Expect(1, 11360, '\P{Is_Blk=glagolitic}', "");
    Expect(0, 11360, '\P{^Is_Blk=glagolitic}', "");
    Expect(1, 11359, '\p{Is_Blk=_Glagolitic}', "");
    Expect(0, 11359, '\p{^Is_Blk=_Glagolitic}', "");
    Expect(0, 11359, '\P{Is_Blk=_Glagolitic}', "");
    Expect(1, 11359, '\P{^Is_Blk=_Glagolitic}', "");
    Expect(0, 11360, '\p{Is_Blk=_Glagolitic}', "");
    Expect(1, 11360, '\p{^Is_Blk=_Glagolitic}', "");
    Expect(1, 11360, '\P{Is_Blk=_Glagolitic}', "");
    Expect(0, 11360, '\P{^Is_Blk=_Glagolitic}', "");
    Error('\p{Block=_-glagolitic_Supplement/a/}');
    Error('\P{Block=_-glagolitic_Supplement/a/}');
    Expect(1, 122927, '\p{Block=:\AGlagolitic_Supplement\z:}', "");;
    Expect(0, 122928, '\p{Block=:\AGlagolitic_Supplement\z:}', "");;
    Expect(1, 122927, '\p{Block=glagoliticsupplement}', "");
    Expect(0, 122927, '\p{^Block=glagoliticsupplement}', "");
    Expect(0, 122927, '\P{Block=glagoliticsupplement}', "");
    Expect(1, 122927, '\P{^Block=glagoliticsupplement}', "");
    Expect(0, 122928, '\p{Block=glagoliticsupplement}', "");
    Expect(1, 122928, '\p{^Block=glagoliticsupplement}', "");
    Expect(1, 122928, '\P{Block=glagoliticsupplement}', "");
    Expect(0, 122928, '\P{^Block=glagoliticsupplement}', "");
    Expect(1, 122927, '\p{Block=:\Aglagoliticsupplement\z:}', "");;
    Expect(0, 122928, '\p{Block=:\Aglagoliticsupplement\z:}', "");;
    Expect(1, 122927, '\p{Block=glagolitic_supplement}', "");
    Expect(0, 122927, '\p{^Block=glagolitic_supplement}', "");
    Expect(0, 122927, '\P{Block=glagolitic_supplement}', "");
    Expect(1, 122927, '\P{^Block=glagolitic_supplement}', "");
    Expect(0, 122928, '\p{Block=glagolitic_supplement}', "");
    Expect(1, 122928, '\p{^Block=glagolitic_supplement}', "");
    Expect(1, 122928, '\P{Block=glagolitic_supplement}', "");
    Expect(0, 122928, '\P{^Block=glagolitic_supplement}', "");
    Error('\p{Blk= Glagolitic_Sup/a/}');
    Error('\P{Blk= Glagolitic_Sup/a/}');
    Expect(1, 122927, '\p{Blk=:\AGlagolitic_Sup\z:}', "");;
    Expect(0, 122928, '\p{Blk=:\AGlagolitic_Sup\z:}', "");;
    Expect(1, 122927, '\p{Blk=glagoliticsup}', "");
    Expect(0, 122927, '\p{^Blk=glagoliticsup}', "");
    Expect(0, 122927, '\P{Blk=glagoliticsup}', "");
    Expect(1, 122927, '\P{^Blk=glagoliticsup}', "");
    Expect(0, 122928, '\p{Blk=glagoliticsup}', "");
    Expect(1, 122928, '\p{^Blk=glagoliticsup}', "");
    Expect(1, 122928, '\P{Blk=glagoliticsup}', "");
    Expect(0, 122928, '\P{^Blk=glagoliticsup}', "");
    Expect(1, 122927, '\p{Blk=:\Aglagoliticsup\z:}', "");;
    Expect(0, 122928, '\p{Blk=:\Aglagoliticsup\z:}', "");;
    Expect(1, 122927, '\p{Blk=_-Glagolitic_Sup}', "");
    Expect(0, 122927, '\p{^Blk=_-Glagolitic_Sup}', "");
    Expect(0, 122927, '\P{Blk=_-Glagolitic_Sup}', "");
    Expect(1, 122927, '\P{^Blk=_-Glagolitic_Sup}', "");
    Expect(0, 122928, '\p{Blk=_-Glagolitic_Sup}', "");
    Expect(1, 122928, '\p{^Blk=_-Glagolitic_Sup}', "");
    Expect(1, 122928, '\P{Blk=_-Glagolitic_Sup}', "");
    Expect(0, 122928, '\P{^Blk=_-Glagolitic_Sup}', "");
    Error('\p{Is_Block=:=__glagolitic_Supplement}');
    Error('\P{Is_Block=:=__glagolitic_Supplement}');
    Expect(1, 122927, '\p{Is_Block=glagoliticsupplement}', "");
    Expect(0, 122927, '\p{^Is_Block=glagoliticsupplement}', "");
    Expect(0, 122927, '\P{Is_Block=glagoliticsupplement}', "");
    Expect(1, 122927, '\P{^Is_Block=glagoliticsupplement}', "");
    Expect(0, 122928, '\p{Is_Block=glagoliticsupplement}', "");
    Expect(1, 122928, '\p{^Is_Block=glagoliticsupplement}', "");
    Expect(1, 122928, '\P{Is_Block=glagoliticsupplement}', "");
    Expect(0, 122928, '\P{^Is_Block=glagoliticsupplement}', "");
    Expect(1, 122927, '\p{Is_Block=GLAGOLITIC_supplement}', "");
    Expect(0, 122927, '\p{^Is_Block=GLAGOLITIC_supplement}', "");
    Expect(0, 122927, '\P{Is_Block=GLAGOLITIC_supplement}', "");
    Expect(1, 122927, '\P{^Is_Block=GLAGOLITIC_supplement}', "");
    Expect(0, 122928, '\p{Is_Block=GLAGOLITIC_supplement}', "");
    Expect(1, 122928, '\p{^Is_Block=GLAGOLITIC_supplement}', "");
    Expect(1, 122928, '\P{Is_Block=GLAGOLITIC_supplement}', "");
    Expect(0, 122928, '\P{^Is_Block=GLAGOLITIC_supplement}', "");
    Error('\p{Is_Blk= GLAGOLITIC_Sup:=}');
    Error('\P{Is_Blk= GLAGOLITIC_Sup:=}');
    Expect(1, 122927, '\p{Is_Blk:glagoliticsup}', "");
    Expect(0, 122927, '\p{^Is_Blk:glagoliticsup}', "");
    Expect(0, 122927, '\P{Is_Blk:glagoliticsup}', "");
    Expect(1, 122927, '\P{^Is_Blk:glagoliticsup}', "");
    Expect(0, 122928, '\p{Is_Blk:glagoliticsup}', "");
    Expect(1, 122928, '\p{^Is_Blk:glagoliticsup}', "");
    Expect(1, 122928, '\P{Is_Blk:glagoliticsup}', "");
    Expect(0, 122928, '\P{^Is_Blk:glagoliticsup}', "");
    Expect(1, 122927, '\p{Is_Blk=_GLAGOLITIC_Sup}', "");
    Expect(0, 122927, '\p{^Is_Blk=_GLAGOLITIC_Sup}', "");
    Expect(0, 122927, '\P{Is_Blk=_GLAGOLITIC_Sup}', "");
    Expect(1, 122927, '\P{^Is_Blk=_GLAGOLITIC_Sup}', "");
    Expect(0, 122928, '\p{Is_Blk=_GLAGOLITIC_Sup}', "");
    Expect(1, 122928, '\p{^Is_Blk=_GLAGOLITIC_Sup}', "");
    Expect(1, 122928, '\P{Is_Blk=_GLAGOLITIC_Sup}', "");
    Expect(0, 122928, '\P{^Is_Blk=_GLAGOLITIC_Sup}', "");
    Error('\p{Block=-:=gothic}');
    Error('\P{Block=-:=gothic}');
    Expect(1, 66383, '\p{Block=:\AGothic\z:}', "");;
    Expect(0, 66384, '\p{Block=:\AGothic\z:}', "");;
    Expect(1, 66383, '\p{Block=gothic}', "");
    Expect(0, 66383, '\p{^Block=gothic}', "");
    Expect(0, 66383, '\P{Block=gothic}', "");
    Expect(1, 66383, '\P{^Block=gothic}', "");
    Expect(0, 66384, '\p{Block=gothic}', "");
    Expect(1, 66384, '\p{^Block=gothic}', "");
    Expect(1, 66384, '\P{Block=gothic}', "");
    Expect(0, 66384, '\P{^Block=gothic}', "");
    Expect(1, 66383, '\p{Block=:\Agothic\z:}', "");;
    Expect(0, 66384, '\p{Block=:\Agothic\z:}', "");;
    Expect(1, 66383, '\p{Block=	-Gothic}', "");
    Expect(0, 66383, '\p{^Block=	-Gothic}', "");
    Expect(0, 66383, '\P{Block=	-Gothic}', "");
    Expect(1, 66383, '\P{^Block=	-Gothic}', "");
    Expect(0, 66384, '\p{Block=	-Gothic}', "");
    Expect(1, 66384, '\p{^Block=	-Gothic}', "");
    Expect(1, 66384, '\P{Block=	-Gothic}', "");
    Expect(0, 66384, '\P{^Block=	-Gothic}', "");
    Error('\p{Blk=--GOTHIC:=}');
    Error('\P{Blk=--GOTHIC:=}');
    Expect(1, 66383, '\p{Blk=:\AGothic\z:}', "");;
    Expect(0, 66384, '\p{Blk=:\AGothic\z:}', "");;
    Expect(1, 66383, '\p{Blk=gothic}', "");
    Expect(0, 66383, '\p{^Blk=gothic}', "");
    Expect(0, 66383, '\P{Blk=gothic}', "");
    Expect(1, 66383, '\P{^Blk=gothic}', "");
    Expect(0, 66384, '\p{Blk=gothic}', "");
    Expect(1, 66384, '\p{^Blk=gothic}', "");
    Expect(1, 66384, '\P{Blk=gothic}', "");
    Expect(0, 66384, '\P{^Blk=gothic}', "");
    Expect(1, 66383, '\p{Blk=:\Agothic\z:}', "");;
    Expect(0, 66384, '\p{Blk=:\Agothic\z:}', "");;
    Expect(1, 66383, '\p{Blk= gothic}', "");
    Expect(0, 66383, '\p{^Blk= gothic}', "");
    Expect(0, 66383, '\P{Blk= gothic}', "");
    Expect(1, 66383, '\P{^Blk= gothic}', "");
    Expect(0, 66384, '\p{Blk= gothic}', "");
    Expect(1, 66384, '\p{^Blk= gothic}', "");
    Expect(1, 66384, '\P{Blk= gothic}', "");
    Expect(0, 66384, '\P{^Blk= gothic}', "");
    Error('\p{Is_Block=:=	-Gothic}');
    Error('\P{Is_Block=:=	-Gothic}');
    Expect(1, 66383, '\p{Is_Block=gothic}', "");
    Expect(0, 66383, '\p{^Is_Block=gothic}', "");
    Expect(0, 66383, '\P{Is_Block=gothic}', "");
    Expect(1, 66383, '\P{^Is_Block=gothic}', "");
    Expect(0, 66384, '\p{Is_Block=gothic}', "");
    Expect(1, 66384, '\p{^Is_Block=gothic}', "");
    Expect(1, 66384, '\P{Is_Block=gothic}', "");
    Expect(0, 66384, '\P{^Is_Block=gothic}', "");
    Expect(1, 66383, '\p{Is_Block=--gothic}', "");
    Expect(0, 66383, '\p{^Is_Block=--gothic}', "");
    Expect(0, 66383, '\P{Is_Block=--gothic}', "");
    Expect(1, 66383, '\P{^Is_Block=--gothic}', "");
    Expect(0, 66384, '\p{Is_Block=--gothic}', "");
    Expect(1, 66384, '\p{^Is_Block=--gothic}', "");
    Expect(1, 66384, '\P{Is_Block=--gothic}', "");
    Expect(0, 66384, '\P{^Is_Block=--gothic}', "");
    Error('\p{Is_Blk= _Gothic/a/}');
    Error('\P{Is_Blk= _Gothic/a/}');
    Expect(1, 66383, '\p{Is_Blk=gothic}', "");
    Expect(0, 66383, '\p{^Is_Blk=gothic}', "");
    Expect(0, 66383, '\P{Is_Blk=gothic}', "");
    Expect(1, 66383, '\P{^Is_Blk=gothic}', "");
    Expect(0, 66384, '\p{Is_Blk=gothic}', "");
    Expect(1, 66384, '\p{^Is_Blk=gothic}', "");
    Expect(1, 66384, '\P{Is_Blk=gothic}', "");
    Expect(0, 66384, '\P{^Is_Blk=gothic}', "");
    Expect(1, 66383, '\p{Is_Blk:		GOTHIC}', "");
    Expect(0, 66383, '\p{^Is_Blk:		GOTHIC}', "");
    Expect(0, 66383, '\P{Is_Blk:		GOTHIC}', "");
    Expect(1, 66383, '\P{^Is_Blk:		GOTHIC}', "");
    Expect(0, 66384, '\p{Is_Blk:		GOTHIC}', "");
    Expect(1, 66384, '\p{^Is_Blk:		GOTHIC}', "");
    Expect(1, 66384, '\P{Is_Blk:		GOTHIC}', "");
    Expect(0, 66384, '\P{^Is_Blk:		GOTHIC}', "");
    Error('\p{Block=/a/_Grantha}');
    Error('\P{Block=/a/_Grantha}');
    Expect(1, 70527, '\p{Block=:\AGrantha\z:}', "");;
    Expect(0, 70528, '\p{Block=:\AGrantha\z:}', "");;
    Expect(1, 70527, '\p{Block=grantha}', "");
    Expect(0, 70527, '\p{^Block=grantha}', "");
    Expect(0, 70527, '\P{Block=grantha}', "");
    Expect(1, 70527, '\P{^Block=grantha}', "");
    Expect(0, 70528, '\p{Block=grantha}', "");
    Expect(1, 70528, '\p{^Block=grantha}', "");
    Expect(1, 70528, '\P{Block=grantha}', "");
    Expect(0, 70528, '\P{^Block=grantha}', "");
    Expect(1, 70527, '\p{Block=:\Agrantha\z:}', "");;
    Expect(0, 70528, '\p{Block=:\Agrantha\z:}', "");;
    Expect(1, 70527, '\p{Block=	GRANTHA}', "");
    Expect(0, 70527, '\p{^Block=	GRANTHA}', "");
    Expect(0, 70527, '\P{Block=	GRANTHA}', "");
    Expect(1, 70527, '\P{^Block=	GRANTHA}', "");
    Expect(0, 70528, '\p{Block=	GRANTHA}', "");
    Expect(1, 70528, '\p{^Block=	GRANTHA}', "");
    Expect(1, 70528, '\P{Block=	GRANTHA}', "");
    Expect(0, 70528, '\P{^Block=	GRANTHA}', "");
    Error('\p{Blk=--GRANTHA:=}');
    Error('\P{Blk=--GRANTHA:=}');
    Expect(1, 70527, '\p{Blk=:\AGrantha\z:}', "");;
    Expect(0, 70528, '\p{Blk=:\AGrantha\z:}', "");;
    Expect(1, 70527, '\p{Blk=grantha}', "");
    Expect(0, 70527, '\p{^Blk=grantha}', "");
    Expect(0, 70527, '\P{Blk=grantha}', "");
    Expect(1, 70527, '\P{^Blk=grantha}', "");
    Expect(0, 70528, '\p{Blk=grantha}', "");
    Expect(1, 70528, '\p{^Blk=grantha}', "");
    Expect(1, 70528, '\P{Blk=grantha}', "");
    Expect(0, 70528, '\P{^Blk=grantha}', "");
    Expect(1, 70527, '\p{Blk=:\Agrantha\z:}', "");;
    Expect(0, 70528, '\p{Blk=:\Agrantha\z:}', "");;
    Expect(1, 70527, '\p{Blk= _GRANTHA}', "");
    Expect(0, 70527, '\p{^Blk= _GRANTHA}', "");
    Expect(0, 70527, '\P{Blk= _GRANTHA}', "");
    Expect(1, 70527, '\P{^Blk= _GRANTHA}', "");
    Expect(0, 70528, '\p{Blk= _GRANTHA}', "");
    Expect(1, 70528, '\p{^Blk= _GRANTHA}', "");
    Expect(1, 70528, '\P{Blk= _GRANTHA}', "");
    Expect(0, 70528, '\P{^Blk= _GRANTHA}', "");
    Error('\p{Is_Block:Grantha:=}');
    Error('\P{Is_Block:Grantha:=}');
    Expect(1, 70527, '\p{Is_Block:	grantha}', "");
    Expect(0, 70527, '\p{^Is_Block:	grantha}', "");
    Expect(0, 70527, '\P{Is_Block:	grantha}', "");
    Expect(1, 70527, '\P{^Is_Block:	grantha}', "");
    Expect(0, 70528, '\p{Is_Block:	grantha}', "");
    Expect(1, 70528, '\p{^Is_Block:	grantha}', "");
    Expect(1, 70528, '\P{Is_Block:	grantha}', "");
    Expect(0, 70528, '\P{^Is_Block:	grantha}', "");
    Expect(1, 70527, '\p{Is_Block=-Grantha}', "");
    Expect(0, 70527, '\p{^Is_Block=-Grantha}', "");
    Expect(0, 70527, '\P{Is_Block=-Grantha}', "");
    Expect(1, 70527, '\P{^Is_Block=-Grantha}', "");
    Expect(0, 70528, '\p{Is_Block=-Grantha}', "");
    Expect(1, 70528, '\p{^Is_Block=-Grantha}', "");
    Expect(1, 70528, '\P{Is_Block=-Grantha}', "");
    Expect(0, 70528, '\P{^Is_Block=-Grantha}', "");
    Error('\p{Is_Blk=-	Grantha/a/}');
    Error('\P{Is_Blk=-	Grantha/a/}');
    Expect(1, 70527, '\p{Is_Blk: grantha}', "");
    Expect(0, 70527, '\p{^Is_Blk: grantha}', "");
    Expect(0, 70527, '\P{Is_Blk: grantha}', "");
    Expect(1, 70527, '\P{^Is_Blk: grantha}', "");
    Expect(0, 70528, '\p{Is_Blk: grantha}', "");
    Expect(1, 70528, '\p{^Is_Blk: grantha}', "");
    Expect(1, 70528, '\P{Is_Blk: grantha}', "");
    Expect(0, 70528, '\P{^Is_Blk: grantha}', "");
    Expect(1, 70527, '\p{Is_Blk= Grantha}', "");
    Expect(0, 70527, '\p{^Is_Blk= Grantha}', "");
    Expect(0, 70527, '\P{Is_Blk= Grantha}', "");
    Expect(1, 70527, '\P{^Is_Blk= Grantha}', "");
    Expect(0, 70528, '\p{Is_Blk= Grantha}', "");
    Expect(1, 70528, '\p{^Is_Blk= Grantha}', "");
    Expect(1, 70528, '\P{Is_Blk= Grantha}', "");
    Expect(0, 70528, '\P{^Is_Blk= Grantha}', "");
    Error('\p{Block=/a/ GREEK_And_Coptic}');
    Error('\P{Block=/a/ GREEK_And_Coptic}');
    Expect(1, 1023, '\p{Block=:\AGreek_And_Coptic\z:}', "");;
    Expect(0, 1024, '\p{Block=:\AGreek_And_Coptic\z:}', "");;
    Expect(1, 1023, '\p{Block:greekandcoptic}', "");
    Expect(0, 1023, '\p{^Block:greekandcoptic}', "");
    Expect(0, 1023, '\P{Block:greekandcoptic}', "");
    Expect(1, 1023, '\P{^Block:greekandcoptic}', "");
    Expect(0, 1024, '\p{Block:greekandcoptic}', "");
    Expect(1, 1024, '\p{^Block:greekandcoptic}', "");
    Expect(1, 1024, '\P{Block:greekandcoptic}', "");
    Expect(0, 1024, '\P{^Block:greekandcoptic}', "");
    Expect(1, 1023, '\p{Block=:\Agreekandcoptic\z:}', "");;
    Expect(0, 1024, '\p{Block=:\Agreekandcoptic\z:}', "");;
    Expect(1, 1023, '\p{Block=_ GREEK_And_Coptic}', "");
    Expect(0, 1023, '\p{^Block=_ GREEK_And_Coptic}', "");
    Expect(0, 1023, '\P{Block=_ GREEK_And_Coptic}', "");
    Expect(1, 1023, '\P{^Block=_ GREEK_And_Coptic}', "");
    Expect(0, 1024, '\p{Block=_ GREEK_And_Coptic}', "");
    Expect(1, 1024, '\p{^Block=_ GREEK_And_Coptic}', "");
    Expect(1, 1024, '\P{Block=_ GREEK_And_Coptic}', "");
    Expect(0, 1024, '\P{^Block=_ GREEK_And_Coptic}', "");
    Error('\p{Blk=-_greek:=}');
    Error('\P{Blk=-_greek:=}');
    Expect(1, 1023, '\p{Blk=:\AGreek\z:}', "");;
    Expect(0, 1024, '\p{Blk=:\AGreek\z:}', "");;
    Expect(1, 1023, '\p{Blk=greek}', "");
    Expect(0, 1023, '\p{^Blk=greek}', "");
    Expect(0, 1023, '\P{Blk=greek}', "");
    Expect(1, 1023, '\P{^Blk=greek}', "");
    Expect(0, 1024, '\p{Blk=greek}', "");
    Expect(1, 1024, '\p{^Blk=greek}', "");
    Expect(1, 1024, '\P{Blk=greek}', "");
    Expect(0, 1024, '\P{^Blk=greek}', "");
    Expect(1, 1023, '\p{Blk=:\Agreek\z:}', "");;
    Expect(0, 1024, '\p{Blk=:\Agreek\z:}', "");;
    Expect(1, 1023, '\p{Blk=__Greek}', "");
    Expect(0, 1023, '\p{^Blk=__Greek}', "");
    Expect(0, 1023, '\P{Blk=__Greek}', "");
    Expect(1, 1023, '\P{^Blk=__Greek}', "");
    Expect(0, 1024, '\p{Blk=__Greek}', "");
    Expect(1, 1024, '\p{^Blk=__Greek}', "");
    Expect(1, 1024, '\P{Blk=__Greek}', "");
    Expect(0, 1024, '\P{^Blk=__Greek}', "");
    Error('\p{Is_Block=	_GREEK_And_Coptic:=}');
    Error('\P{Is_Block=	_GREEK_And_Coptic:=}');
    Expect(1, 1023, '\p{Is_Block:	greekandcoptic}', "");
    Expect(0, 1023, '\p{^Is_Block:	greekandcoptic}', "");
    Expect(0, 1023, '\P{Is_Block:	greekandcoptic}', "");
    Expect(1, 1023, '\P{^Is_Block:	greekandcoptic}', "");
    Expect(0, 1024, '\p{Is_Block:	greekandcoptic}', "");
    Expect(1, 1024, '\p{^Is_Block:	greekandcoptic}', "");
    Expect(1, 1024, '\P{Is_Block:	greekandcoptic}', "");
    Expect(0, 1024, '\P{^Is_Block:	greekandcoptic}', "");
    Expect(1, 1023, '\p{Is_Block=_GREEK_and_COPTIC}', "");
    Expect(0, 1023, '\p{^Is_Block=_GREEK_and_COPTIC}', "");
    Expect(0, 1023, '\P{Is_Block=_GREEK_and_COPTIC}', "");
    Expect(1, 1023, '\P{^Is_Block=_GREEK_and_COPTIC}', "");
    Expect(0, 1024, '\p{Is_Block=_GREEK_and_COPTIC}', "");
    Expect(1, 1024, '\p{^Is_Block=_GREEK_and_COPTIC}', "");
    Expect(1, 1024, '\P{Is_Block=_GREEK_and_COPTIC}', "");
    Expect(0, 1024, '\P{^Is_Block=_GREEK_and_COPTIC}', "");
    Error('\p{Is_Blk= :=Greek}');
    Error('\P{Is_Blk= :=Greek}');
    Expect(1, 1023, '\p{Is_Blk: greek}', "");
    Expect(0, 1023, '\p{^Is_Blk: greek}', "");
    Expect(0, 1023, '\P{Is_Blk: greek}', "");
    Expect(1, 1023, '\P{^Is_Blk: greek}', "");
    Expect(0, 1024, '\p{Is_Blk: greek}', "");
    Expect(1, 1024, '\p{^Is_Blk: greek}', "");
    Expect(1, 1024, '\P{Is_Blk: greek}', "");
    Expect(0, 1024, '\P{^Is_Blk: greek}', "");
    Expect(1, 1023, '\p{Is_Blk=- Greek}', "");
    Expect(0, 1023, '\p{^Is_Blk=- Greek}', "");
    Expect(0, 1023, '\P{Is_Blk=- Greek}', "");
    Expect(1, 1023, '\P{^Is_Blk=- Greek}', "");
    Expect(0, 1024, '\p{Is_Blk=- Greek}', "");
    Expect(1, 1024, '\p{^Is_Blk=- Greek}', "");
    Expect(1, 1024, '\P{Is_Blk=- Greek}', "");
    Expect(0, 1024, '\P{^Is_Blk=- Greek}', "");
    Error('\p{Block=--Greek_Extended:=}');
    Error('\P{Block=--Greek_Extended:=}');
    Expect(1, 8191, '\p{Block=:\AGreek_Extended\z:}', "");;
    Expect(0, 8192, '\p{Block=:\AGreek_Extended\z:}', "");;
    Expect(1, 8191, '\p{Block=greekextended}', "");
    Expect(0, 8191, '\p{^Block=greekextended}', "");
    Expect(0, 8191, '\P{Block=greekextended}', "");
    Expect(1, 8191, '\P{^Block=greekextended}', "");
    Expect(0, 8192, '\p{Block=greekextended}', "");
    Expect(1, 8192, '\p{^Block=greekextended}', "");
    Expect(1, 8192, '\P{Block=greekextended}', "");
    Expect(0, 8192, '\P{^Block=greekextended}', "");
    Expect(1, 8191, '\p{Block=:\Agreekextended\z:}', "");;
    Expect(0, 8192, '\p{Block=:\Agreekextended\z:}', "");;
    Expect(1, 8191, '\p{Block=-_Greek_Extended}', "");
    Expect(0, 8191, '\p{^Block=-_Greek_Extended}', "");
    Expect(0, 8191, '\P{Block=-_Greek_Extended}', "");
    Expect(1, 8191, '\P{^Block=-_Greek_Extended}', "");
    Expect(0, 8192, '\p{Block=-_Greek_Extended}', "");
    Expect(1, 8192, '\p{^Block=-_Greek_Extended}', "");
    Expect(1, 8192, '\P{Block=-_Greek_Extended}', "");
    Expect(0, 8192, '\P{^Block=-_Greek_Extended}', "");
    Error('\p{Blk= /a/GREEK_ext}');
    Error('\P{Blk= /a/GREEK_ext}');
    Expect(1, 8191, '\p{Blk=:\AGreek_Ext\z:}', "");;
    Expect(0, 8192, '\p{Blk=:\AGreek_Ext\z:}', "");;
    Expect(1, 8191, '\p{Blk=greekext}', "");
    Expect(0, 8191, '\p{^Blk=greekext}', "");
    Expect(0, 8191, '\P{Blk=greekext}', "");
    Expect(1, 8191, '\P{^Blk=greekext}', "");
    Expect(0, 8192, '\p{Blk=greekext}', "");
    Expect(1, 8192, '\p{^Blk=greekext}', "");
    Expect(1, 8192, '\P{Blk=greekext}', "");
    Expect(0, 8192, '\P{^Blk=greekext}', "");
    Expect(1, 8191, '\p{Blk=:\Agreekext\z:}', "");;
    Expect(0, 8192, '\p{Blk=:\Agreekext\z:}', "");;
    Expect(1, 8191, '\p{Blk=		GREEK_Ext}', "");
    Expect(0, 8191, '\p{^Blk=		GREEK_Ext}', "");
    Expect(0, 8191, '\P{Blk=		GREEK_Ext}', "");
    Expect(1, 8191, '\P{^Blk=		GREEK_Ext}', "");
    Expect(0, 8192, '\p{Blk=		GREEK_Ext}', "");
    Expect(1, 8192, '\p{^Blk=		GREEK_Ext}', "");
    Expect(1, 8192, '\P{Blk=		GREEK_Ext}', "");
    Expect(0, 8192, '\P{^Blk=		GREEK_Ext}', "");
    Error('\p{Is_Block=	/a/Greek_Extended}');
    Error('\P{Is_Block=	/a/Greek_Extended}');
    Expect(1, 8191, '\p{Is_Block=greekextended}', "");
    Expect(0, 8191, '\p{^Is_Block=greekextended}', "");
    Expect(0, 8191, '\P{Is_Block=greekextended}', "");
    Expect(1, 8191, '\P{^Is_Block=greekextended}', "");
    Expect(0, 8192, '\p{Is_Block=greekextended}', "");
    Expect(1, 8192, '\p{^Is_Block=greekextended}', "");
    Expect(1, 8192, '\P{Is_Block=greekextended}', "");
    Expect(0, 8192, '\P{^Is_Block=greekextended}', "");
    Expect(1, 8191, '\p{Is_Block= Greek_EXTENDED}', "");
    Expect(0, 8191, '\p{^Is_Block= Greek_EXTENDED}', "");
    Expect(0, 8191, '\P{Is_Block= Greek_EXTENDED}', "");
    Expect(1, 8191, '\P{^Is_Block= Greek_EXTENDED}', "");
    Expect(0, 8192, '\p{Is_Block= Greek_EXTENDED}', "");
    Expect(1, 8192, '\p{^Is_Block= Greek_EXTENDED}', "");
    Expect(1, 8192, '\P{Is_Block= Greek_EXTENDED}', "");
    Expect(0, 8192, '\P{^Is_Block= Greek_EXTENDED}', "");
    Error('\p{Is_Blk=:= Greek_ext}');
    Error('\P{Is_Blk=:= Greek_ext}');
    Expect(1, 8191, '\p{Is_Blk:greekext}', "");
    Expect(0, 8191, '\p{^Is_Blk:greekext}', "");
    Expect(0, 8191, '\P{Is_Blk:greekext}', "");
    Expect(1, 8191, '\P{^Is_Blk:greekext}', "");
    Expect(0, 8192, '\p{Is_Blk:greekext}', "");
    Expect(1, 8192, '\p{^Is_Blk:greekext}', "");
    Expect(1, 8192, '\P{Is_Blk:greekext}', "");
    Expect(0, 8192, '\P{^Is_Blk:greekext}', "");
    Expect(1, 8191, '\p{Is_Blk=	_Greek_Ext}', "");
    Expect(0, 8191, '\p{^Is_Blk=	_Greek_Ext}', "");
    Expect(0, 8191, '\P{Is_Blk=	_Greek_Ext}', "");
    Expect(1, 8191, '\P{^Is_Blk=	_Greek_Ext}', "");
    Expect(0, 8192, '\p{Is_Blk=	_Greek_Ext}', "");
    Expect(1, 8192, '\p{^Is_Blk=	_Greek_Ext}', "");
    Expect(1, 8192, '\P{Is_Blk=	_Greek_Ext}', "");
    Expect(0, 8192, '\P{^Is_Blk=	_Greek_Ext}', "");
    Error('\p{Block=/a/--gujarati}');
    Error('\P{Block=/a/--gujarati}');
    Expect(1, 2815, '\p{Block=:\AGujarati\z:}', "");;
    Expect(0, 2816, '\p{Block=:\AGujarati\z:}', "");;
    Expect(1, 2815, '\p{Block=gujarati}', "");
    Expect(0, 2815, '\p{^Block=gujarati}', "");
    Expect(0, 2815, '\P{Block=gujarati}', "");
    Expect(1, 2815, '\P{^Block=gujarati}', "");
    Expect(0, 2816, '\p{Block=gujarati}', "");
    Expect(1, 2816, '\p{^Block=gujarati}', "");
    Expect(1, 2816, '\P{Block=gujarati}', "");
    Expect(0, 2816, '\P{^Block=gujarati}', "");
    Expect(1, 2815, '\p{Block=:\Agujarati\z:}', "");;
    Expect(0, 2816, '\p{Block=:\Agujarati\z:}', "");;
    Expect(1, 2815, '\p{Block=	_gujarati}', "");
    Expect(0, 2815, '\p{^Block=	_gujarati}', "");
    Expect(0, 2815, '\P{Block=	_gujarati}', "");
    Expect(1, 2815, '\P{^Block=	_gujarati}', "");
    Expect(0, 2816, '\p{Block=	_gujarati}', "");
    Expect(1, 2816, '\p{^Block=	_gujarati}', "");
    Expect(1, 2816, '\P{Block=	_gujarati}', "");
    Expect(0, 2816, '\P{^Block=	_gujarati}', "");
    Error('\p{Blk=	 Gujarati/a/}');
    Error('\P{Blk=	 Gujarati/a/}');
    Expect(1, 2815, '\p{Blk=:\AGujarati\z:}', "");;
    Expect(0, 2816, '\p{Blk=:\AGujarati\z:}', "");;
    Expect(1, 2815, '\p{Blk=gujarati}', "");
    Expect(0, 2815, '\p{^Blk=gujarati}', "");
    Expect(0, 2815, '\P{Blk=gujarati}', "");
    Expect(1, 2815, '\P{^Blk=gujarati}', "");
    Expect(0, 2816, '\p{Blk=gujarati}', "");
    Expect(1, 2816, '\p{^Blk=gujarati}', "");
    Expect(1, 2816, '\P{Blk=gujarati}', "");
    Expect(0, 2816, '\P{^Blk=gujarati}', "");
    Expect(1, 2815, '\p{Blk=:\Agujarati\z:}', "");;
    Expect(0, 2816, '\p{Blk=:\Agujarati\z:}', "");;
    Expect(1, 2815, '\p{Blk=	Gujarati}', "");
    Expect(0, 2815, '\p{^Blk=	Gujarati}', "");
    Expect(0, 2815, '\P{Blk=	Gujarati}', "");
    Expect(1, 2815, '\P{^Blk=	Gujarati}', "");
    Expect(0, 2816, '\p{Blk=	Gujarati}', "");
    Expect(1, 2816, '\p{^Blk=	Gujarati}', "");
    Expect(1, 2816, '\P{Blk=	Gujarati}', "");
    Expect(0, 2816, '\P{^Blk=	Gujarati}', "");
    Error('\p{Is_Block=	gujarati:=}');
    Error('\P{Is_Block=	gujarati:=}');
    Expect(1, 2815, '\p{Is_Block=gujarati}', "");
    Expect(0, 2815, '\p{^Is_Block=gujarati}', "");
    Expect(0, 2815, '\P{Is_Block=gujarati}', "");
    Expect(1, 2815, '\P{^Is_Block=gujarati}', "");
    Expect(0, 2816, '\p{Is_Block=gujarati}', "");
    Expect(1, 2816, '\p{^Is_Block=gujarati}', "");
    Expect(1, 2816, '\P{Is_Block=gujarati}', "");
    Expect(0, 2816, '\P{^Is_Block=gujarati}', "");
    Expect(1, 2815, '\p{Is_Block= gujarati}', "");
    Expect(0, 2815, '\p{^Is_Block= gujarati}', "");
    Expect(0, 2815, '\P{Is_Block= gujarati}', "");
    Expect(1, 2815, '\P{^Is_Block= gujarati}', "");
    Expect(0, 2816, '\p{Is_Block= gujarati}', "");
    Expect(1, 2816, '\p{^Is_Block= gujarati}', "");
    Expect(1, 2816, '\P{Is_Block= gujarati}', "");
    Expect(0, 2816, '\P{^Is_Block= gujarati}', "");
    Error('\p{Is_Blk=/a/_ Gujarati}');
    Error('\P{Is_Blk=/a/_ Gujarati}');
    Expect(1, 2815, '\p{Is_Blk: gujarati}', "");
    Expect(0, 2815, '\p{^Is_Blk: gujarati}', "");
    Expect(0, 2815, '\P{Is_Blk: gujarati}', "");
    Expect(1, 2815, '\P{^Is_Blk: gujarati}', "");
    Expect(0, 2816, '\p{Is_Blk: gujarati}', "");
    Expect(1, 2816, '\p{^Is_Blk: gujarati}', "");
    Expect(1, 2816, '\P{Is_Blk: gujarati}', "");
    Expect(0, 2816, '\P{^Is_Blk: gujarati}', "");
    Expect(1, 2815, '\p{Is_Blk:     Gujarati}', "");
    Expect(0, 2815, '\p{^Is_Blk:     Gujarati}', "");
    Expect(0, 2815, '\P{Is_Blk:     Gujarati}', "");
    Expect(1, 2815, '\P{^Is_Blk:     Gujarati}', "");
    Expect(0, 2816, '\p{Is_Blk:     Gujarati}', "");
    Expect(1, 2816, '\p{^Is_Blk:     Gujarati}', "");
    Expect(1, 2816, '\P{Is_Blk:     Gujarati}', "");
    Expect(0, 2816, '\P{^Is_Blk:     Gujarati}', "");
    Error('\p{Block=:= Gunjala_gondi}');
    Error('\P{Block=:= Gunjala_gondi}');
    Expect(1, 73135, '\p{Block=:\AGunjala_Gondi\z:}', "");;
    Expect(0, 73136, '\p{Block=:\AGunjala_Gondi\z:}', "");;
    Expect(1, 73135, '\p{Block=gunjalagondi}', "");
    Expect(0, 73135, '\p{^Block=gunjalagondi}', "");
    Expect(0, 73135, '\P{Block=gunjalagondi}', "");
    Expect(1, 73135, '\P{^Block=gunjalagondi}', "");
    Expect(0, 73136, '\p{Block=gunjalagondi}', "");
    Expect(1, 73136, '\p{^Block=gunjalagondi}', "");
    Expect(1, 73136, '\P{Block=gunjalagondi}', "");
    Expect(0, 73136, '\P{^Block=gunjalagondi}', "");
    Expect(1, 73135, '\p{Block=:\Agunjalagondi\z:}', "");;
    Expect(0, 73136, '\p{Block=:\Agunjalagondi\z:}', "");;
    Expect(1, 73135, '\p{Block=_gunjala_GONDI}', "");
    Expect(0, 73135, '\p{^Block=_gunjala_GONDI}', "");
    Expect(0, 73135, '\P{Block=_gunjala_GONDI}', "");
    Expect(1, 73135, '\P{^Block=_gunjala_GONDI}', "");
    Expect(0, 73136, '\p{Block=_gunjala_GONDI}', "");
    Expect(1, 73136, '\p{^Block=_gunjala_GONDI}', "");
    Expect(1, 73136, '\P{Block=_gunjala_GONDI}', "");
    Expect(0, 73136, '\P{^Block=_gunjala_GONDI}', "");
    Error('\p{Blk=_	GUNJALA_Gondi:=}');
    Error('\P{Blk=_	GUNJALA_Gondi:=}');
    Expect(1, 73135, '\p{Blk=:\AGunjala_Gondi\z:}', "");;
    Expect(0, 73136, '\p{Blk=:\AGunjala_Gondi\z:}', "");;
    Expect(1, 73135, '\p{Blk=gunjalagondi}', "");
    Expect(0, 73135, '\p{^Blk=gunjalagondi}', "");
    Expect(0, 73135, '\P{Blk=gunjalagondi}', "");
    Expect(1, 73135, '\P{^Blk=gunjalagondi}', "");
    Expect(0, 73136, '\p{Blk=gunjalagondi}', "");
    Expect(1, 73136, '\p{^Blk=gunjalagondi}', "");
    Expect(1, 73136, '\P{Blk=gunjalagondi}', "");
    Expect(0, 73136, '\P{^Blk=gunjalagondi}', "");
    Expect(1, 73135, '\p{Blk=:\Agunjalagondi\z:}', "");;
    Expect(0, 73136, '\p{Blk=:\Agunjalagondi\z:}', "");;
    Expect(1, 73135, '\p{Blk= -GUNJALA_GONDI}', "");
    Expect(0, 73135, '\p{^Blk= -GUNJALA_GONDI}', "");
    Expect(0, 73135, '\P{Blk= -GUNJALA_GONDI}', "");
    Expect(1, 73135, '\P{^Blk= -GUNJALA_GONDI}', "");
    Expect(0, 73136, '\p{Blk= -GUNJALA_GONDI}', "");
    Expect(1, 73136, '\p{^Blk= -GUNJALA_GONDI}', "");
    Expect(1, 73136, '\P{Blk= -GUNJALA_GONDI}', "");
    Expect(0, 73136, '\P{^Blk= -GUNJALA_GONDI}', "");
    Error('\p{Is_Block=	Gunjala_Gondi:=}');
    Error('\P{Is_Block=	Gunjala_Gondi:=}');
    Expect(1, 73135, '\p{Is_Block=gunjalagondi}', "");
    Expect(0, 73135, '\p{^Is_Block=gunjalagondi}', "");
    Expect(0, 73135, '\P{Is_Block=gunjalagondi}', "");
    Expect(1, 73135, '\P{^Is_Block=gunjalagondi}', "");
    Expect(0, 73136, '\p{Is_Block=gunjalagondi}', "");
    Expect(1, 73136, '\p{^Is_Block=gunjalagondi}', "");
    Expect(1, 73136, '\P{Is_Block=gunjalagondi}', "");
    Expect(0, 73136, '\P{^Is_Block=gunjalagondi}', "");
    Expect(1, 73135, '\p{Is_Block=-	Gunjala_Gondi}', "");
    Expect(0, 73135, '\p{^Is_Block=-	Gunjala_Gondi}', "");
    Expect(0, 73135, '\P{Is_Block=-	Gunjala_Gondi}', "");
    Expect(1, 73135, '\P{^Is_Block=-	Gunjala_Gondi}', "");
    Expect(0, 73136, '\p{Is_Block=-	Gunjala_Gondi}', "");
    Expect(1, 73136, '\p{^Is_Block=-	Gunjala_Gondi}', "");
    Expect(1, 73136, '\P{Is_Block=-	Gunjala_Gondi}', "");
    Expect(0, 73136, '\P{^Is_Block=-	Gunjala_Gondi}', "");
    Error('\p{Is_Blk=/a/GUNJALA_gondi}');
    Error('\P{Is_Blk=/a/GUNJALA_gondi}');
    Expect(1, 73135, '\p{Is_Blk=gunjalagondi}', "");
    Expect(0, 73135, '\p{^Is_Blk=gunjalagondi}', "");
    Expect(0, 73135, '\P{Is_Blk=gunjalagondi}', "");
    Expect(1, 73135, '\P{^Is_Blk=gunjalagondi}', "");
    Expect(0, 73136, '\p{Is_Blk=gunjalagondi}', "");
    Expect(1, 73136, '\p{^Is_Blk=gunjalagondi}', "");
    Expect(1, 73136, '\P{Is_Blk=gunjalagondi}', "");
    Expect(0, 73136, '\P{^Is_Blk=gunjalagondi}', "");
    Expect(1, 73135, '\p{Is_Blk=	_gunjala_gondi}', "");
    Expect(0, 73135, '\p{^Is_Blk=	_gunjala_gondi}', "");
    Expect(0, 73135, '\P{Is_Blk=	_gunjala_gondi}', "");
    Expect(1, 73135, '\P{^Is_Blk=	_gunjala_gondi}', "");
    Expect(0, 73136, '\p{Is_Blk=	_gunjala_gondi}', "");
    Expect(1, 73136, '\p{^Is_Blk=	_gunjala_gondi}', "");
    Expect(1, 73136, '\P{Is_Blk=	_gunjala_gondi}', "");
    Expect(0, 73136, '\P{^Is_Blk=	_gunjala_gondi}', "");
    Error('\p{Block=/a/__Gurmukhi}');
    Error('\P{Block=/a/__Gurmukhi}');
    Expect(1, 2687, '\p{Block=:\AGurmukhi\z:}', "");;
    Expect(0, 2688, '\p{Block=:\AGurmukhi\z:}', "");;
    Expect(1, 2687, '\p{Block=gurmukhi}', "");
    Expect(0, 2687, '\p{^Block=gurmukhi}', "");
    Expect(0, 2687, '\P{Block=gurmukhi}', "");
    Expect(1, 2687, '\P{^Block=gurmukhi}', "");
    Expect(0, 2688, '\p{Block=gurmukhi}', "");
    Expect(1, 2688, '\p{^Block=gurmukhi}', "");
    Expect(1, 2688, '\P{Block=gurmukhi}', "");
    Expect(0, 2688, '\P{^Block=gurmukhi}', "");
    Expect(1, 2687, '\p{Block=:\Agurmukhi\z:}', "");;
    Expect(0, 2688, '\p{Block=:\Agurmukhi\z:}', "");;
    Expect(1, 2687, '\p{Block=-	Gurmukhi}', "");
    Expect(0, 2687, '\p{^Block=-	Gurmukhi}', "");
    Expect(0, 2687, '\P{Block=-	Gurmukhi}', "");
    Expect(1, 2687, '\P{^Block=-	Gurmukhi}', "");
    Expect(0, 2688, '\p{Block=-	Gurmukhi}', "");
    Expect(1, 2688, '\p{^Block=-	Gurmukhi}', "");
    Expect(1, 2688, '\P{Block=-	Gurmukhi}', "");
    Expect(0, 2688, '\P{^Block=-	Gurmukhi}', "");
    Error('\p{Blk=_Gurmukhi:=}');
    Error('\P{Blk=_Gurmukhi:=}');
    Expect(1, 2687, '\p{Blk=:\AGurmukhi\z:}', "");;
    Expect(0, 2688, '\p{Blk=:\AGurmukhi\z:}', "");;
    Expect(1, 2687, '\p{Blk=gurmukhi}', "");
    Expect(0, 2687, '\p{^Blk=gurmukhi}', "");
    Expect(0, 2687, '\P{Blk=gurmukhi}', "");
    Expect(1, 2687, '\P{^Blk=gurmukhi}', "");
    Expect(0, 2688, '\p{Blk=gurmukhi}', "");
    Expect(1, 2688, '\p{^Blk=gurmukhi}', "");
    Expect(1, 2688, '\P{Blk=gurmukhi}', "");
    Expect(0, 2688, '\P{^Blk=gurmukhi}', "");
    Expect(1, 2687, '\p{Blk=:\Agurmukhi\z:}', "");;
    Expect(0, 2688, '\p{Blk=:\Agurmukhi\z:}', "");;
    Expect(1, 2687, '\p{Blk=_gurmukhi}', "");
    Expect(0, 2687, '\p{^Blk=_gurmukhi}', "");
    Expect(0, 2687, '\P{Blk=_gurmukhi}', "");
    Expect(1, 2687, '\P{^Blk=_gurmukhi}', "");
    Expect(0, 2688, '\p{Blk=_gurmukhi}', "");
    Expect(1, 2688, '\p{^Blk=_gurmukhi}', "");
    Expect(1, 2688, '\P{Blk=_gurmukhi}', "");
    Expect(0, 2688, '\P{^Blk=_gurmukhi}', "");
    Error('\p{Is_Block=- GURMUKHI:=}');
    Error('\P{Is_Block=- GURMUKHI:=}');
    Expect(1, 2687, '\p{Is_Block=gurmukhi}', "");
    Expect(0, 2687, '\p{^Is_Block=gurmukhi}', "");
    Expect(0, 2687, '\P{Is_Block=gurmukhi}', "");
    Expect(1, 2687, '\P{^Is_Block=gurmukhi}', "");
    Expect(0, 2688, '\p{Is_Block=gurmukhi}', "");
    Expect(1, 2688, '\p{^Is_Block=gurmukhi}', "");
    Expect(1, 2688, '\P{Is_Block=gurmukhi}', "");
    Expect(0, 2688, '\P{^Is_Block=gurmukhi}', "");
    Expect(1, 2687, '\p{Is_Block=  gurmukhi}', "");
    Expect(0, 2687, '\p{^Is_Block=  gurmukhi}', "");
    Expect(0, 2687, '\P{Is_Block=  gurmukhi}', "");
    Expect(1, 2687, '\P{^Is_Block=  gurmukhi}', "");
    Expect(0, 2688, '\p{Is_Block=  gurmukhi}', "");
    Expect(1, 2688, '\p{^Is_Block=  gurmukhi}', "");
    Expect(1, 2688, '\P{Is_Block=  gurmukhi}', "");
    Expect(0, 2688, '\P{^Is_Block=  gurmukhi}', "");
    Error('\p{Is_Blk: _:=gurmukhi}');
    Error('\P{Is_Blk: _:=gurmukhi}');
    Expect(1, 2687, '\p{Is_Blk: gurmukhi}', "");
    Expect(0, 2687, '\p{^Is_Blk: gurmukhi}', "");
    Expect(0, 2687, '\P{Is_Blk: gurmukhi}', "");
    Expect(1, 2687, '\P{^Is_Blk: gurmukhi}', "");
    Expect(0, 2688, '\p{Is_Blk: gurmukhi}', "");
    Expect(1, 2688, '\p{^Is_Blk: gurmukhi}', "");
    Expect(1, 2688, '\P{Is_Blk: gurmukhi}', "");
    Expect(0, 2688, '\P{^Is_Blk: gurmukhi}', "");
    Expect(1, 2687, '\p{Is_Blk=-Gurmukhi}', "");
    Expect(0, 2687, '\p{^Is_Blk=-Gurmukhi}', "");
    Expect(0, 2687, '\P{Is_Blk=-Gurmukhi}', "");
    Expect(1, 2687, '\P{^Is_Blk=-Gurmukhi}', "");
    Expect(0, 2688, '\p{Is_Blk=-Gurmukhi}', "");
    Expect(1, 2688, '\p{^Is_Blk=-Gurmukhi}', "");
    Expect(1, 2688, '\P{Is_Blk=-Gurmukhi}', "");
    Expect(0, 2688, '\P{^Is_Blk=-Gurmukhi}', "");
    Error('\p{Block=:=__Halfwidth_And_Fullwidth_FORMS}');
    Error('\P{Block=:=__Halfwidth_And_Fullwidth_FORMS}');
    Expect(1, 65519, '\p{Block=:\AHalfwidth_And_Fullwidth_Forms\z:}', "");;
    Expect(0, 65520, '\p{Block=:\AHalfwidth_And_Fullwidth_Forms\z:}', "");;
    Expect(1, 65519, '\p{Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65519, '\p{^Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65519, '\P{Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65519, '\P{^Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65520, '\p{Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65520, '\p{^Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65520, '\P{Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65520, '\P{^Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65519, '\p{Block=:\Ahalfwidthandfullwidthforms\z:}', "");;
    Expect(0, 65520, '\p{Block=:\Ahalfwidthandfullwidthforms\z:}', "");;
    Expect(1, 65519, '\p{Block:  halfwidth_and_FULLWIDTH_forms}', "");
    Expect(0, 65519, '\p{^Block:  halfwidth_and_FULLWIDTH_forms}', "");
    Expect(0, 65519, '\P{Block:  halfwidth_and_FULLWIDTH_forms}', "");
    Expect(1, 65519, '\P{^Block:  halfwidth_and_FULLWIDTH_forms}', "");
    Expect(0, 65520, '\p{Block:  halfwidth_and_FULLWIDTH_forms}', "");
    Expect(1, 65520, '\p{^Block:  halfwidth_and_FULLWIDTH_forms}', "");
    Expect(1, 65520, '\P{Block:  halfwidth_and_FULLWIDTH_forms}', "");
    Expect(0, 65520, '\P{^Block:  halfwidth_and_FULLWIDTH_forms}', "");
    Error('\p{Blk=-HALF_and_full_Forms/a/}');
    Error('\P{Blk=-HALF_and_full_Forms/a/}');
    Expect(1, 65519, '\p{Blk=:\AHalf_And_Full_Forms\z:}', "");;
    Expect(0, 65520, '\p{Blk=:\AHalf_And_Full_Forms\z:}', "");;
    Expect(1, 65519, '\p{Blk=halfandfullforms}', "");
    Expect(0, 65519, '\p{^Blk=halfandfullforms}', "");
    Expect(0, 65519, '\P{Blk=halfandfullforms}', "");
    Expect(1, 65519, '\P{^Blk=halfandfullforms}', "");
    Expect(0, 65520, '\p{Blk=halfandfullforms}', "");
    Expect(1, 65520, '\p{^Blk=halfandfullforms}', "");
    Expect(1, 65520, '\P{Blk=halfandfullforms}', "");
    Expect(0, 65520, '\P{^Blk=halfandfullforms}', "");
    Expect(1, 65519, '\p{Blk=:\Ahalfandfullforms\z:}', "");;
    Expect(0, 65520, '\p{Blk=:\Ahalfandfullforms\z:}', "");;
    Expect(1, 65519, '\p{Blk= 	Half_AND_Full_Forms}', "");
    Expect(0, 65519, '\p{^Blk= 	Half_AND_Full_Forms}', "");
    Expect(0, 65519, '\P{Blk= 	Half_AND_Full_Forms}', "");
    Expect(1, 65519, '\P{^Blk= 	Half_AND_Full_Forms}', "");
    Expect(0, 65520, '\p{Blk= 	Half_AND_Full_Forms}', "");
    Expect(1, 65520, '\p{^Blk= 	Half_AND_Full_Forms}', "");
    Expect(1, 65520, '\P{Blk= 	Half_AND_Full_Forms}', "");
    Expect(0, 65520, '\P{^Blk= 	Half_AND_Full_Forms}', "");
    Error('\p{Is_Block=:=- halfwidth_and_Fullwidth_FORMS}');
    Error('\P{Is_Block=:=- halfwidth_and_Fullwidth_FORMS}');
    Expect(1, 65519, '\p{Is_Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65519, '\p{^Is_Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65519, '\P{Is_Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65519, '\P{^Is_Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65520, '\p{Is_Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65520, '\p{^Is_Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65520, '\P{Is_Block=halfwidthandfullwidthforms}', "");
    Expect(0, 65520, '\P{^Is_Block=halfwidthandfullwidthforms}', "");
    Expect(1, 65519, '\p{Is_Block= _HALFWIDTH_And_fullwidth_Forms}', "");
    Expect(0, 65519, '\p{^Is_Block= _HALFWIDTH_And_fullwidth_Forms}', "");
    Expect(0, 65519, '\P{Is_Block= _HALFWIDTH_And_fullwidth_Forms}', "");
    Expect(1, 65519, '\P{^Is_Block= _HALFWIDTH_And_fullwidth_Forms}', "");
    Expect(0, 65520, '\p{Is_Block= _HALFWIDTH_And_fullwidth_Forms}', "");
    Expect(1, 65520, '\p{^Is_Block= _HALFWIDTH_And_fullwidth_Forms}', "");
    Expect(1, 65520, '\P{Is_Block= _HALFWIDTH_And_fullwidth_Forms}', "");
    Expect(0, 65520, '\P{^Is_Block= _HALFWIDTH_And_fullwidth_Forms}', "");
    Error('\p{Is_Blk=	/a/Half_AND_Full_forms}');
    Error('\P{Is_Blk=	/a/Half_AND_Full_forms}');
    Expect(1, 65519, '\p{Is_Blk:   halfandfullforms}', "");
    Expect(0, 65519, '\p{^Is_Blk:   halfandfullforms}', "");
    Expect(0, 65519, '\P{Is_Blk:   halfandfullforms}', "");
    Expect(1, 65519, '\P{^Is_Blk:   halfandfullforms}', "");
    Expect(0, 65520, '\p{Is_Blk:   halfandfullforms}', "");
    Expect(1, 65520, '\p{^Is_Blk:   halfandfullforms}', "");
    Expect(1, 65520, '\P{Is_Blk:   halfandfullforms}', "");
    Expect(0, 65520, '\P{^Is_Blk:   halfandfullforms}', "");
    Expect(1, 65519, '\p{Is_Blk=-half_and_FULL_forms}', "");
    Expect(0, 65519, '\p{^Is_Blk=-half_and_FULL_forms}', "");
    Expect(0, 65519, '\P{Is_Blk=-half_and_FULL_forms}', "");
    Expect(1, 65519, '\P{^Is_Blk=-half_and_FULL_forms}', "");
    Expect(0, 65520, '\p{Is_Blk=-half_and_FULL_forms}', "");
    Expect(1, 65520, '\p{^Is_Blk=-half_and_FULL_forms}', "");
    Expect(1, 65520, '\P{Is_Blk=-half_and_FULL_forms}', "");
    Expect(0, 65520, '\P{^Is_Blk=-half_and_FULL_forms}', "");
    Error('\p{Block=:=	_Combining_Half_Marks}');
    Error('\P{Block=:=	_Combining_Half_Marks}');
    Expect(1, 65071, '\p{Block=:\ACombining_Half_Marks\z:}', "");;
    Expect(0, 65072, '\p{Block=:\ACombining_Half_Marks\z:}', "");;
    Expect(1, 65071, '\p{Block=combininghalfmarks}', "");
    Expect(0, 65071, '\p{^Block=combininghalfmarks}', "");
    Expect(0, 65071, '\P{Block=combininghalfmarks}', "");
    Expect(1, 65071, '\P{^Block=combininghalfmarks}', "");
    Expect(0, 65072, '\p{Block=combininghalfmarks}', "");
    Expect(1, 65072, '\p{^Block=combininghalfmarks}', "");
    Expect(1, 65072, '\P{Block=combininghalfmarks}', "");
    Expect(0, 65072, '\P{^Block=combininghalfmarks}', "");
    Expect(1, 65071, '\p{Block=:\Acombininghalfmarks\z:}', "");;
    Expect(0, 65072, '\p{Block=:\Acombininghalfmarks\z:}', "");;
    Expect(1, 65071, '\p{Block=	_COMBINING_half_Marks}', "");
    Expect(0, 65071, '\p{^Block=	_COMBINING_half_Marks}', "");
    Expect(0, 65071, '\P{Block=	_COMBINING_half_Marks}', "");
    Expect(1, 65071, '\P{^Block=	_COMBINING_half_Marks}', "");
    Expect(0, 65072, '\p{Block=	_COMBINING_half_Marks}', "");
    Expect(1, 65072, '\p{^Block=	_COMBINING_half_Marks}', "");
    Expect(1, 65072, '\P{Block=	_COMBINING_half_Marks}', "");
    Expect(0, 65072, '\P{^Block=	_COMBINING_half_Marks}', "");
    Error('\p{Blk=-	half_Marks:=}');
    Error('\P{Blk=-	half_Marks:=}');
    Expect(1, 65071, '\p{Blk=:\AHalf_Marks\z:}', "");;
    Expect(0, 65072, '\p{Blk=:\AHalf_Marks\z:}', "");;
    Expect(1, 65071, '\p{Blk=halfmarks}', "");
    Expect(0, 65071, '\p{^Blk=halfmarks}', "");
    Expect(0, 65071, '\P{Blk=halfmarks}', "");
    Expect(1, 65071, '\P{^Blk=halfmarks}', "");
    Expect(0, 65072, '\p{Blk=halfmarks}', "");
    Expect(1, 65072, '\p{^Blk=halfmarks}', "");
    Expect(1, 65072, '\P{Blk=halfmarks}', "");
    Expect(0, 65072, '\P{^Blk=halfmarks}', "");
    Expect(1, 65071, '\p{Blk=:\Ahalfmarks\z:}', "");;
    Expect(0, 65072, '\p{Blk=:\Ahalfmarks\z:}', "");;
    Expect(1, 65071, '\p{Blk=Half_MARKS}', "");
    Expect(0, 65071, '\p{^Blk=Half_MARKS}', "");
    Expect(0, 65071, '\P{Blk=Half_MARKS}', "");
    Expect(1, 65071, '\P{^Blk=Half_MARKS}', "");
    Expect(0, 65072, '\p{Blk=Half_MARKS}', "");
    Expect(1, 65072, '\p{^Blk=Half_MARKS}', "");
    Expect(1, 65072, '\P{Blk=Half_MARKS}', "");
    Expect(0, 65072, '\P{^Blk=Half_MARKS}', "");
    Error('\p{Is_Block=_combining_Half_MARKS:=}');
    Error('\P{Is_Block=_combining_Half_MARKS:=}');
    Expect(1, 65071, '\p{Is_Block: combininghalfmarks}', "");
    Expect(0, 65071, '\p{^Is_Block: combininghalfmarks}', "");
    Expect(0, 65071, '\P{Is_Block: combininghalfmarks}', "");
    Expect(1, 65071, '\P{^Is_Block: combininghalfmarks}', "");
    Expect(0, 65072, '\p{Is_Block: combininghalfmarks}', "");
    Expect(1, 65072, '\p{^Is_Block: combininghalfmarks}', "");
    Expect(1, 65072, '\P{Is_Block: combininghalfmarks}', "");
    Expect(0, 65072, '\P{^Is_Block: combininghalfmarks}', "");
    Expect(1, 65071, '\p{Is_Block=_-COMBINING_HALF_Marks}', "");
    Expect(0, 65071, '\p{^Is_Block=_-COMBINING_HALF_Marks}', "");
    Expect(0, 65071, '\P{Is_Block=_-COMBINING_HALF_Marks}', "");
    Expect(1, 65071, '\P{^Is_Block=_-COMBINING_HALF_Marks}', "");
    Expect(0, 65072, '\p{Is_Block=_-COMBINING_HALF_Marks}', "");
    Expect(1, 65072, '\p{^Is_Block=_-COMBINING_HALF_Marks}', "");
    Expect(1, 65072, '\P{Is_Block=_-COMBINING_HALF_Marks}', "");
    Expect(0, 65072, '\P{^Is_Block=_-COMBINING_HALF_Marks}', "");
    Error('\p{Is_Blk= /a/Half_Marks}');
    Error('\P{Is_Blk= /a/Half_Marks}');
    Expect(1, 65071, '\p{Is_Blk=halfmarks}', "");
    Expect(0, 65071, '\p{^Is_Blk=halfmarks}', "");
    Expect(0, 65071, '\P{Is_Blk=halfmarks}', "");
    Expect(1, 65071, '\P{^Is_Blk=halfmarks}', "");
    Expect(0, 65072, '\p{Is_Blk=halfmarks}', "");
    Expect(1, 65072, '\p{^Is_Blk=halfmarks}', "");
    Expect(1, 65072, '\P{Is_Blk=halfmarks}', "");
    Expect(0, 65072, '\P{^Is_Blk=halfmarks}', "");
    Expect(1, 65071, '\p{Is_Blk=-_Half_Marks}', "");
    Expect(0, 65071, '\p{^Is_Blk=-_Half_Marks}', "");
    Expect(0, 65071, '\P{Is_Blk=-_Half_Marks}', "");
    Expect(1, 65071, '\P{^Is_Blk=-_Half_Marks}', "");
    Expect(0, 65072, '\p{Is_Blk=-_Half_Marks}', "");
    Expect(1, 65072, '\p{^Is_Blk=-_Half_Marks}', "");
    Expect(1, 65072, '\P{Is_Blk=-_Half_Marks}', "");
    Expect(0, 65072, '\P{^Is_Blk=-_Half_Marks}', "");
    Error('\p{Block=/a/--Hangul_Syllables}');
    Error('\P{Block=/a/--Hangul_Syllables}');
    Expect(1, 55215, '\p{Block=:\AHangul_Syllables\z:}', "");;
    Expect(0, 55216, '\p{Block=:\AHangul_Syllables\z:}', "");;
    Expect(1, 55215, '\p{Block=hangulsyllables}', "");
    Expect(0, 55215, '\p{^Block=hangulsyllables}', "");
    Expect(0, 55215, '\P{Block=hangulsyllables}', "");
    Expect(1, 55215, '\P{^Block=hangulsyllables}', "");
    Expect(0, 55216, '\p{Block=hangulsyllables}', "");
    Expect(1, 55216, '\p{^Block=hangulsyllables}', "");
    Expect(1, 55216, '\P{Block=hangulsyllables}', "");
    Expect(0, 55216, '\P{^Block=hangulsyllables}', "");
    Expect(1, 55215, '\p{Block=:\Ahangulsyllables\z:}', "");;
    Expect(0, 55216, '\p{Block=:\Ahangulsyllables\z:}', "");;
    Expect(1, 55215, '\p{Block:   - Hangul_syllables}', "");
    Expect(0, 55215, '\p{^Block:   - Hangul_syllables}', "");
    Expect(0, 55215, '\P{Block:   - Hangul_syllables}', "");
    Expect(1, 55215, '\P{^Block:   - Hangul_syllables}', "");
    Expect(0, 55216, '\p{Block:   - Hangul_syllables}', "");
    Expect(1, 55216, '\p{^Block:   - Hangul_syllables}', "");
    Expect(1, 55216, '\P{Block:   - Hangul_syllables}', "");
    Expect(0, 55216, '\P{^Block:   - Hangul_syllables}', "");
    Error('\p{Blk=  Hangul:=}');
    Error('\P{Blk=  Hangul:=}');
    Expect(1, 55215, '\p{Blk=:\AHangul\z:}', "");;
    Expect(0, 55216, '\p{Blk=:\AHangul\z:}', "");;
    Expect(1, 55215, '\p{Blk=hangul}', "");
    Expect(0, 55215, '\p{^Blk=hangul}', "");
    Expect(0, 55215, '\P{Blk=hangul}', "");
    Expect(1, 55215, '\P{^Blk=hangul}', "");
    Expect(0, 55216, '\p{Blk=hangul}', "");
    Expect(1, 55216, '\p{^Blk=hangul}', "");
    Expect(1, 55216, '\P{Blk=hangul}', "");
    Expect(0, 55216, '\P{^Blk=hangul}', "");
    Expect(1, 55215, '\p{Blk=:\Ahangul\z:}', "");;
    Expect(0, 55216, '\p{Blk=:\Ahangul\z:}', "");;
    Expect(1, 55215, '\p{Blk=_-HANGUL}', "");
    Expect(0, 55215, '\p{^Blk=_-HANGUL}', "");
    Expect(0, 55215, '\P{Blk=_-HANGUL}', "");
    Expect(1, 55215, '\P{^Blk=_-HANGUL}', "");
    Expect(0, 55216, '\p{Blk=_-HANGUL}', "");
    Expect(1, 55216, '\p{^Blk=_-HANGUL}', "");
    Expect(1, 55216, '\P{Blk=_-HANGUL}', "");
    Expect(0, 55216, '\P{^Blk=_-HANGUL}', "");
    Error('\p{Is_Block=:=	_HANGUL_Syllables}');
    Error('\P{Is_Block=:=	_HANGUL_Syllables}');
    Expect(1, 55215, '\p{Is_Block=hangulsyllables}', "");
    Expect(0, 55215, '\p{^Is_Block=hangulsyllables}', "");
    Expect(0, 55215, '\P{Is_Block=hangulsyllables}', "");
    Expect(1, 55215, '\P{^Is_Block=hangulsyllables}', "");
    Expect(0, 55216, '\p{Is_Block=hangulsyllables}', "");
    Expect(1, 55216, '\p{^Is_Block=hangulsyllables}', "");
    Expect(1, 55216, '\P{Is_Block=hangulsyllables}', "");
    Expect(0, 55216, '\P{^Is_Block=hangulsyllables}', "");
    Expect(1, 55215, '\p{Is_Block: -HANGUL_SYLLABLES}', "");
    Expect(0, 55215, '\p{^Is_Block: -HANGUL_SYLLABLES}', "");
    Expect(0, 55215, '\P{Is_Block: -HANGUL_SYLLABLES}', "");
    Expect(1, 55215, '\P{^Is_Block: -HANGUL_SYLLABLES}', "");
    Expect(0, 55216, '\p{Is_Block: -HANGUL_SYLLABLES}', "");
    Expect(1, 55216, '\p{^Is_Block: -HANGUL_SYLLABLES}', "");
    Expect(1, 55216, '\P{Is_Block: -HANGUL_SYLLABLES}', "");
    Expect(0, 55216, '\P{^Is_Block: -HANGUL_SYLLABLES}', "");
    Error('\p{Is_Blk=-/a/HANGUL}');
    Error('\P{Is_Blk=-/a/HANGUL}');
    Expect(1, 55215, '\p{Is_Blk=hangul}', "");
    Expect(0, 55215, '\p{^Is_Blk=hangul}', "");
    Expect(0, 55215, '\P{Is_Blk=hangul}', "");
    Expect(1, 55215, '\P{^Is_Blk=hangul}', "");
    Expect(0, 55216, '\p{Is_Blk=hangul}', "");
    Expect(1, 55216, '\p{^Is_Blk=hangul}', "");
    Expect(1, 55216, '\P{Is_Blk=hangul}', "");
    Expect(0, 55216, '\P{^Is_Blk=hangul}', "");
    Expect(1, 55215, '\p{Is_Blk: __Hangul}', "");
    Expect(0, 55215, '\p{^Is_Blk: __Hangul}', "");
    Expect(0, 55215, '\P{Is_Blk: __Hangul}', "");
    Expect(1, 55215, '\P{^Is_Blk: __Hangul}', "");
    Expect(0, 55216, '\p{Is_Blk: __Hangul}', "");
    Expect(1, 55216, '\p{^Is_Blk: __Hangul}', "");
    Expect(1, 55216, '\P{Is_Blk: __Hangul}', "");
    Expect(0, 55216, '\P{^Is_Blk: __Hangul}', "");
    Error('\p{Block:/a/		Hanifi_Rohingya}');
    Error('\P{Block:/a/		Hanifi_Rohingya}');
    Expect(1, 68927, '\p{Block=:\AHanifi_Rohingya\z:}', "");;
    Expect(0, 68928, '\p{Block=:\AHanifi_Rohingya\z:}', "");;
    Expect(1, 68927, '\p{Block=hanifirohingya}', "");
    Expect(0, 68927, '\p{^Block=hanifirohingya}', "");
    Expect(0, 68927, '\P{Block=hanifirohingya}', "");
    Expect(1, 68927, '\P{^Block=hanifirohingya}', "");
    Expect(0, 68928, '\p{Block=hanifirohingya}', "");
    Expect(1, 68928, '\p{^Block=hanifirohingya}', "");
    Expect(1, 68928, '\P{Block=hanifirohingya}', "");
    Expect(0, 68928, '\P{^Block=hanifirohingya}', "");
    Expect(1, 68927, '\p{Block=:\Ahanifirohingya\z:}', "");;
    Expect(0, 68928, '\p{Block=:\Ahanifirohingya\z:}', "");;
    Expect(1, 68927, '\p{Block=_-Hanifi_Rohingya}', "");
    Expect(0, 68927, '\p{^Block=_-Hanifi_Rohingya}', "");
    Expect(0, 68927, '\P{Block=_-Hanifi_Rohingya}', "");
    Expect(1, 68927, '\P{^Block=_-Hanifi_Rohingya}', "");
    Expect(0, 68928, '\p{Block=_-Hanifi_Rohingya}', "");
    Expect(1, 68928, '\p{^Block=_-Hanifi_Rohingya}', "");
    Expect(1, 68928, '\P{Block=_-Hanifi_Rohingya}', "");
    Expect(0, 68928, '\P{^Block=_-Hanifi_Rohingya}', "");
    Error('\p{Blk=:=  Hanifi_Rohingya}');
    Error('\P{Blk=:=  Hanifi_Rohingya}');
    Expect(1, 68927, '\p{Blk=:\AHanifi_Rohingya\z:}', "");;
    Expect(0, 68928, '\p{Blk=:\AHanifi_Rohingya\z:}', "");;
    Expect(1, 68927, '\p{Blk=hanifirohingya}', "");
    Expect(0, 68927, '\p{^Blk=hanifirohingya}', "");
    Expect(0, 68927, '\P{Blk=hanifirohingya}', "");
    Expect(1, 68927, '\P{^Blk=hanifirohingya}', "");
    Expect(0, 68928, '\p{Blk=hanifirohingya}', "");
    Expect(1, 68928, '\p{^Blk=hanifirohingya}', "");
    Expect(1, 68928, '\P{Blk=hanifirohingya}', "");
    Expect(0, 68928, '\P{^Blk=hanifirohingya}', "");
    Expect(1, 68927, '\p{Blk=:\Ahanifirohingya\z:}', "");;
    Expect(0, 68928, '\p{Blk=:\Ahanifirohingya\z:}', "");;
    Expect(1, 68927, '\p{Blk=	-hanifi_Rohingya}', "");
    Expect(0, 68927, '\p{^Blk=	-hanifi_Rohingya}', "");
    Expect(0, 68927, '\P{Blk=	-hanifi_Rohingya}', "");
    Expect(1, 68927, '\P{^Blk=	-hanifi_Rohingya}', "");
    Expect(0, 68928, '\p{Blk=	-hanifi_Rohingya}', "");
    Expect(1, 68928, '\p{^Blk=	-hanifi_Rohingya}', "");
    Expect(1, 68928, '\P{Blk=	-hanifi_Rohingya}', "");
    Expect(0, 68928, '\P{^Blk=	-hanifi_Rohingya}', "");
    Error('\p{Is_Block:   	hanifi_Rohingya:=}');
    Error('\P{Is_Block:   	hanifi_Rohingya:=}');
    Expect(1, 68927, '\p{Is_Block:   hanifirohingya}', "");
    Expect(0, 68927, '\p{^Is_Block:   hanifirohingya}', "");
    Expect(0, 68927, '\P{Is_Block:   hanifirohingya}', "");
    Expect(1, 68927, '\P{^Is_Block:   hanifirohingya}', "");
    Expect(0, 68928, '\p{Is_Block:   hanifirohingya}', "");
    Expect(1, 68928, '\p{^Is_Block:   hanifirohingya}', "");
    Expect(1, 68928, '\P{Is_Block:   hanifirohingya}', "");
    Expect(0, 68928, '\P{^Is_Block:   hanifirohingya}', "");
    Expect(1, 68927, '\p{Is_Block=_hanifi_Rohingya}', "");
    Expect(0, 68927, '\p{^Is_Block=_hanifi_Rohingya}', "");
    Expect(0, 68927, '\P{Is_Block=_hanifi_Rohingya}', "");
    Expect(1, 68927, '\P{^Is_Block=_hanifi_Rohingya}', "");
    Expect(0, 68928, '\p{Is_Block=_hanifi_Rohingya}', "");
    Expect(1, 68928, '\p{^Is_Block=_hanifi_Rohingya}', "");
    Expect(1, 68928, '\P{Is_Block=_hanifi_Rohingya}', "");
    Expect(0, 68928, '\P{^Is_Block=_hanifi_Rohingya}', "");
    Error('\p{Is_Blk=/a/	-hanifi_Rohingya}');
    Error('\P{Is_Blk=/a/	-hanifi_Rohingya}');
    Expect(1, 68927, '\p{Is_Blk=hanifirohingya}', "");
    Expect(0, 68927, '\p{^Is_Blk=hanifirohingya}', "");
    Expect(0, 68927, '\P{Is_Blk=hanifirohingya}', "");
    Expect(1, 68927, '\P{^Is_Blk=hanifirohingya}', "");
    Expect(0, 68928, '\p{Is_Blk=hanifirohingya}', "");
    Expect(1, 68928, '\p{^Is_Blk=hanifirohingya}', "");
    Expect(1, 68928, '\P{Is_Blk=hanifirohingya}', "");
    Expect(0, 68928, '\P{^Is_Blk=hanifirohingya}', "");
    Expect(1, 68927, '\p{Is_Blk:- hanifi_Rohingya}', "");
    Expect(0, 68927, '\p{^Is_Blk:- hanifi_Rohingya}', "");
    Expect(0, 68927, '\P{Is_Blk:- hanifi_Rohingya}', "");
    Expect(1, 68927, '\P{^Is_Blk:- hanifi_Rohingya}', "");
    Expect(0, 68928, '\p{Is_Blk:- hanifi_Rohingya}', "");
    Expect(1, 68928, '\p{^Is_Blk:- hanifi_Rohingya}', "");
    Expect(1, 68928, '\P{Is_Blk:- hanifi_Rohingya}', "");
    Expect(0, 68928, '\P{^Is_Blk:- hanifi_Rohingya}', "");
    Error('\p{Block=- Hanunoo/a/}');
    Error('\P{Block=- Hanunoo/a/}');
    Expect(1, 5951, '\p{Block=:\AHanunoo\z:}', "");;
    Expect(0, 5952, '\p{Block=:\AHanunoo\z:}', "");;
    Expect(1, 5951, '\p{Block=hanunoo}', "");
    Expect(0, 5951, '\p{^Block=hanunoo}', "");
    Expect(0, 5951, '\P{Block=hanunoo}', "");
    Expect(1, 5951, '\P{^Block=hanunoo}', "");
    Expect(0, 5952, '\p{Block=hanunoo}', "");
    Expect(1, 5952, '\p{^Block=hanunoo}', "");
    Expect(1, 5952, '\P{Block=hanunoo}', "");
    Expect(0, 5952, '\P{^Block=hanunoo}', "");
    Expect(1, 5951, '\p{Block=:\Ahanunoo\z:}', "");;
    Expect(0, 5952, '\p{Block=:\Ahanunoo\z:}', "");;
    Expect(1, 5951, '\p{Block=_ HANUNOO}', "");
    Expect(0, 5951, '\p{^Block=_ HANUNOO}', "");
    Expect(0, 5951, '\P{Block=_ HANUNOO}', "");
    Expect(1, 5951, '\P{^Block=_ HANUNOO}', "");
    Expect(0, 5952, '\p{Block=_ HANUNOO}', "");
    Expect(1, 5952, '\p{^Block=_ HANUNOO}', "");
    Expect(1, 5952, '\P{Block=_ HANUNOO}', "");
    Expect(0, 5952, '\P{^Block=_ HANUNOO}', "");
    Error('\p{Blk=/a/ -Hanunoo}');
    Error('\P{Blk=/a/ -Hanunoo}');
    Expect(1, 5951, '\p{Blk=:\AHanunoo\z:}', "");;
    Expect(0, 5952, '\p{Blk=:\AHanunoo\z:}', "");;
    Expect(1, 5951, '\p{Blk=hanunoo}', "");
    Expect(0, 5951, '\p{^Blk=hanunoo}', "");
    Expect(0, 5951, '\P{Blk=hanunoo}', "");
    Expect(1, 5951, '\P{^Blk=hanunoo}', "");
    Expect(0, 5952, '\p{Blk=hanunoo}', "");
    Expect(1, 5952, '\p{^Blk=hanunoo}', "");
    Expect(1, 5952, '\P{Blk=hanunoo}', "");
    Expect(0, 5952, '\P{^Blk=hanunoo}', "");
    Expect(1, 5951, '\p{Blk=:\Ahanunoo\z:}', "");;
    Expect(0, 5952, '\p{Blk=:\Ahanunoo\z:}', "");;
    Expect(1, 5951, '\p{Blk=_-hanunoo}', "");
    Expect(0, 5951, '\p{^Blk=_-hanunoo}', "");
    Expect(0, 5951, '\P{Blk=_-hanunoo}', "");
    Expect(1, 5951, '\P{^Blk=_-hanunoo}', "");
    Expect(0, 5952, '\p{Blk=_-hanunoo}', "");
    Expect(1, 5952, '\p{^Blk=_-hanunoo}', "");
    Expect(1, 5952, '\P{Blk=_-hanunoo}', "");
    Expect(0, 5952, '\P{^Blk=_-hanunoo}', "");
    Error('\p{Is_Block=:=-	Hanunoo}');
    Error('\P{Is_Block=:=-	Hanunoo}');
    Expect(1, 5951, '\p{Is_Block:	hanunoo}', "");
    Expect(0, 5951, '\p{^Is_Block:	hanunoo}', "");
    Expect(0, 5951, '\P{Is_Block:	hanunoo}', "");
    Expect(1, 5951, '\P{^Is_Block:	hanunoo}', "");
    Expect(0, 5952, '\p{Is_Block:	hanunoo}', "");
    Expect(1, 5952, '\p{^Is_Block:	hanunoo}', "");
    Expect(1, 5952, '\P{Is_Block:	hanunoo}', "");
    Expect(0, 5952, '\P{^Is_Block:	hanunoo}', "");
    Expect(1, 5951, '\p{Is_Block:   -	Hanunoo}', "");
    Expect(0, 5951, '\p{^Is_Block:   -	Hanunoo}', "");
    Expect(0, 5951, '\P{Is_Block:   -	Hanunoo}', "");
    Expect(1, 5951, '\P{^Is_Block:   -	Hanunoo}', "");
    Expect(0, 5952, '\p{Is_Block:   -	Hanunoo}', "");
    Expect(1, 5952, '\p{^Is_Block:   -	Hanunoo}', "");
    Expect(1, 5952, '\P{Is_Block:   -	Hanunoo}', "");
    Expect(0, 5952, '\P{^Is_Block:   -	Hanunoo}', "");
    Error('\p{Is_Blk=-/a/Hanunoo}');
    Error('\P{Is_Blk=-/a/Hanunoo}');
    Expect(1, 5951, '\p{Is_Blk=hanunoo}', "");
    Expect(0, 5951, '\p{^Is_Blk=hanunoo}', "");
    Expect(0, 5951, '\P{Is_Blk=hanunoo}', "");
    Expect(1, 5951, '\P{^Is_Blk=hanunoo}', "");
    Expect(0, 5952, '\p{Is_Blk=hanunoo}', "");
    Expect(1, 5952, '\p{^Is_Blk=hanunoo}', "");
    Expect(1, 5952, '\P{Is_Blk=hanunoo}', "");
    Expect(0, 5952, '\P{^Is_Blk=hanunoo}', "");
    Expect(1, 5951, '\p{Is_Blk=_HANUNOO}', "");
    Expect(0, 5951, '\p{^Is_Blk=_HANUNOO}', "");
    Expect(0, 5951, '\P{Is_Blk=_HANUNOO}', "");
    Expect(1, 5951, '\P{^Is_Blk=_HANUNOO}', "");
    Expect(0, 5952, '\p{Is_Blk=_HANUNOO}', "");
    Expect(1, 5952, '\p{^Is_Blk=_HANUNOO}', "");
    Expect(1, 5952, '\P{Is_Blk=_HANUNOO}', "");
    Expect(0, 5952, '\P{^Is_Blk=_HANUNOO}', "");
    Error('\p{Block=:=_HATRAN}');
    Error('\P{Block=:=_HATRAN}');
    Expect(1, 67839, '\p{Block=:\AHatran\z:}', "");;
    Expect(0, 67840, '\p{Block=:\AHatran\z:}', "");;
    Expect(1, 67839, '\p{Block=hatran}', "");
    Expect(0, 67839, '\p{^Block=hatran}', "");
    Expect(0, 67839, '\P{Block=hatran}', "");
    Expect(1, 67839, '\P{^Block=hatran}', "");
    Expect(0, 67840, '\p{Block=hatran}', "");
    Expect(1, 67840, '\p{^Block=hatran}', "");
    Expect(1, 67840, '\P{Block=hatran}', "");
    Expect(0, 67840, '\P{^Block=hatran}', "");
    Expect(1, 67839, '\p{Block=:\Ahatran\z:}', "");;
    Expect(0, 67840, '\p{Block=:\Ahatran\z:}', "");;
    Expect(1, 67839, '\p{Block=--Hatran}', "");
    Expect(0, 67839, '\p{^Block=--Hatran}', "");
    Expect(0, 67839, '\P{Block=--Hatran}', "");
    Expect(1, 67839, '\P{^Block=--Hatran}', "");
    Expect(0, 67840, '\p{Block=--Hatran}', "");
    Expect(1, 67840, '\p{^Block=--Hatran}', "");
    Expect(1, 67840, '\P{Block=--Hatran}', "");
    Expect(0, 67840, '\P{^Block=--Hatran}', "");
    Error('\p{Blk: 	 hatran/a/}');
    Error('\P{Blk: 	 hatran/a/}');
    Expect(1, 67839, '\p{Blk=:\AHatran\z:}', "");;
    Expect(0, 67840, '\p{Blk=:\AHatran\z:}', "");;
    Expect(1, 67839, '\p{Blk=hatran}', "");
    Expect(0, 67839, '\p{^Blk=hatran}', "");
    Expect(0, 67839, '\P{Blk=hatran}', "");
    Expect(1, 67839, '\P{^Blk=hatran}', "");
    Expect(0, 67840, '\p{Blk=hatran}', "");
    Expect(1, 67840, '\p{^Blk=hatran}', "");
    Expect(1, 67840, '\P{Blk=hatran}', "");
    Expect(0, 67840, '\P{^Blk=hatran}', "");
    Expect(1, 67839, '\p{Blk=:\Ahatran\z:}', "");;
    Expect(0, 67840, '\p{Blk=:\Ahatran\z:}', "");;
    Expect(1, 67839, '\p{Blk=-Hatran}', "");
    Expect(0, 67839, '\p{^Blk=-Hatran}', "");
    Expect(0, 67839, '\P{Blk=-Hatran}', "");
    Expect(1, 67839, '\P{^Blk=-Hatran}', "");
    Expect(0, 67840, '\p{Blk=-Hatran}', "");
    Expect(1, 67840, '\p{^Blk=-Hatran}', "");
    Expect(1, 67840, '\P{Blk=-Hatran}', "");
    Expect(0, 67840, '\P{^Blk=-Hatran}', "");
    Error('\p{Is_Block=:=	hatran}');
    Error('\P{Is_Block=:=	hatran}');
    Expect(1, 67839, '\p{Is_Block=hatran}', "");
    Expect(0, 67839, '\p{^Is_Block=hatran}', "");
    Expect(0, 67839, '\P{Is_Block=hatran}', "");
    Expect(1, 67839, '\P{^Is_Block=hatran}', "");
    Expect(0, 67840, '\p{Is_Block=hatran}', "");
    Expect(1, 67840, '\p{^Is_Block=hatran}', "");
    Expect(1, 67840, '\P{Is_Block=hatran}', "");
    Expect(0, 67840, '\P{^Is_Block=hatran}', "");
    Expect(1, 67839, '\p{Is_Block=_hatran}', "");
    Expect(0, 67839, '\p{^Is_Block=_hatran}', "");
    Expect(0, 67839, '\P{Is_Block=_hatran}', "");
    Expect(1, 67839, '\P{^Is_Block=_hatran}', "");
    Expect(0, 67840, '\p{Is_Block=_hatran}', "");
    Expect(1, 67840, '\p{^Is_Block=_hatran}', "");
    Expect(1, 67840, '\P{Is_Block=_hatran}', "");
    Expect(0, 67840, '\P{^Is_Block=_hatran}', "");
    Error('\p{Is_Blk=-_HATRAN:=}');
    Error('\P{Is_Blk=-_HATRAN:=}');
    Expect(1, 67839, '\p{Is_Blk=hatran}', "");
    Expect(0, 67839, '\p{^Is_Blk=hatran}', "");
    Expect(0, 67839, '\P{Is_Blk=hatran}', "");
    Expect(1, 67839, '\P{^Is_Blk=hatran}', "");
    Expect(0, 67840, '\p{Is_Blk=hatran}', "");
    Expect(1, 67840, '\p{^Is_Blk=hatran}', "");
    Expect(1, 67840, '\P{Is_Blk=hatran}', "");
    Expect(0, 67840, '\P{^Is_Blk=hatran}', "");
    Expect(1, 67839, '\p{Is_Blk= 	HATRAN}', "");
    Expect(0, 67839, '\p{^Is_Blk= 	HATRAN}', "");
    Expect(0, 67839, '\P{Is_Blk= 	HATRAN}', "");
    Expect(1, 67839, '\P{^Is_Blk= 	HATRAN}', "");
    Expect(0, 67840, '\p{Is_Blk= 	HATRAN}', "");
    Expect(1, 67840, '\p{^Is_Blk= 	HATRAN}', "");
    Expect(1, 67840, '\P{Is_Blk= 	HATRAN}', "");
    Expect(0, 67840, '\P{^Is_Blk= 	HATRAN}', "");
    Error('\p{Block=/a/Hebrew}');
    Error('\P{Block=/a/Hebrew}');
    Expect(1, 1535, '\p{Block=:\AHebrew\z:}', "");;
    Expect(0, 1536, '\p{Block=:\AHebrew\z:}', "");;
    Expect(1, 1535, '\p{Block=hebrew}', "");
    Expect(0, 1535, '\p{^Block=hebrew}', "");
    Expect(0, 1535, '\P{Block=hebrew}', "");
    Expect(1, 1535, '\P{^Block=hebrew}', "");
    Expect(0, 1536, '\p{Block=hebrew}', "");
    Expect(1, 1536, '\p{^Block=hebrew}', "");
    Expect(1, 1536, '\P{Block=hebrew}', "");
    Expect(0, 1536, '\P{^Block=hebrew}', "");
    Expect(1, 1535, '\p{Block=:\Ahebrew\z:}', "");;
    Expect(0, 1536, '\p{Block=:\Ahebrew\z:}', "");;
    Expect(1, 1535, '\p{Block:	 -Hebrew}', "");
    Expect(0, 1535, '\p{^Block:	 -Hebrew}', "");
    Expect(0, 1535, '\P{Block:	 -Hebrew}', "");
    Expect(1, 1535, '\P{^Block:	 -Hebrew}', "");
    Expect(0, 1536, '\p{Block:	 -Hebrew}', "");
    Expect(1, 1536, '\p{^Block:	 -Hebrew}', "");
    Expect(1, 1536, '\P{Block:	 -Hebrew}', "");
    Expect(0, 1536, '\P{^Block:	 -Hebrew}', "");
    Error('\p{Blk=/a/_	Hebrew}');
    Error('\P{Blk=/a/_	Hebrew}');
    Expect(1, 1535, '\p{Blk=:\AHebrew\z:}', "");;
    Expect(0, 1536, '\p{Blk=:\AHebrew\z:}', "");;
    Expect(1, 1535, '\p{Blk=hebrew}', "");
    Expect(0, 1535, '\p{^Blk=hebrew}', "");
    Expect(0, 1535, '\P{Blk=hebrew}', "");
    Expect(1, 1535, '\P{^Blk=hebrew}', "");
    Expect(0, 1536, '\p{Blk=hebrew}', "");
    Expect(1, 1536, '\p{^Blk=hebrew}', "");
    Expect(1, 1536, '\P{Blk=hebrew}', "");
    Expect(0, 1536, '\P{^Blk=hebrew}', "");
    Expect(1, 1535, '\p{Blk=:\Ahebrew\z:}', "");;
    Expect(0, 1536, '\p{Blk=:\Ahebrew\z:}', "");;
    Expect(1, 1535, '\p{Blk=- HEBREW}', "");
    Expect(0, 1535, '\p{^Blk=- HEBREW}', "");
    Expect(0, 1535, '\P{Blk=- HEBREW}', "");
    Expect(1, 1535, '\P{^Blk=- HEBREW}', "");
    Expect(0, 1536, '\p{Blk=- HEBREW}', "");
    Expect(1, 1536, '\p{^Blk=- HEBREW}', "");
    Expect(1, 1536, '\P{Blk=- HEBREW}', "");
    Expect(0, 1536, '\P{^Blk=- HEBREW}', "");
    Error('\p{Is_Block=-:=Hebrew}');
    Error('\P{Is_Block=-:=Hebrew}');
    Expect(1, 1535, '\p{Is_Block=hebrew}', "");
    Expect(0, 1535, '\p{^Is_Block=hebrew}', "");
    Expect(0, 1535, '\P{Is_Block=hebrew}', "");
    Expect(1, 1535, '\P{^Is_Block=hebrew}', "");
    Expect(0, 1536, '\p{Is_Block=hebrew}', "");
    Expect(1, 1536, '\p{^Is_Block=hebrew}', "");
    Expect(1, 1536, '\P{Is_Block=hebrew}', "");
    Expect(0, 1536, '\P{^Is_Block=hebrew}', "");
    Expect(1, 1535, '\p{Is_Block=		Hebrew}', "");
    Expect(0, 1535, '\p{^Is_Block=		Hebrew}', "");
    Expect(0, 1535, '\P{Is_Block=		Hebrew}', "");
    Expect(1, 1535, '\P{^Is_Block=		Hebrew}', "");
    Expect(0, 1536, '\p{Is_Block=		Hebrew}', "");
    Expect(1, 1536, '\p{^Is_Block=		Hebrew}', "");
    Expect(1, 1536, '\P{Is_Block=		Hebrew}', "");
    Expect(0, 1536, '\P{^Is_Block=		Hebrew}', "");
    Error('\p{Is_Blk=Hebrew/a/}');
    Error('\P{Is_Blk=Hebrew/a/}');
    Expect(1, 1535, '\p{Is_Blk=hebrew}', "");
    Expect(0, 1535, '\p{^Is_Blk=hebrew}', "");
    Expect(0, 1535, '\P{Is_Blk=hebrew}', "");
    Expect(1, 1535, '\P{^Is_Blk=hebrew}', "");
    Expect(0, 1536, '\p{Is_Blk=hebrew}', "");
    Expect(1, 1536, '\p{^Is_Blk=hebrew}', "");
    Expect(1, 1536, '\P{Is_Blk=hebrew}', "");
    Expect(0, 1536, '\P{^Is_Blk=hebrew}', "");
    Expect(1, 1535, '\p{Is_Blk= Hebrew}', "");
    Expect(0, 1535, '\p{^Is_Blk= Hebrew}', "");
    Expect(0, 1535, '\P{Is_Blk= Hebrew}', "");
    Expect(1, 1535, '\P{^Is_Blk= Hebrew}', "");
    Expect(0, 1536, '\p{Is_Blk= Hebrew}', "");
    Expect(1, 1536, '\p{^Is_Blk= Hebrew}', "");
    Expect(1, 1536, '\P{Is_Blk= Hebrew}', "");
    Expect(0, 1536, '\P{^Is_Blk= Hebrew}', "");
    Error('\p{Block=high_Private_Use_Surrogates/a/}');
    Error('\P{Block=high_Private_Use_Surrogates/a/}');
    Expect(1, 56319, '\p{Block=:\AHigh_Private_Use_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\AHigh_Private_Use_Surrogates\z:}', "");;
    Expect(1, 56319, '\p{Block=highprivateusesurrogates}', "");
    Expect(0, 56319, '\p{^Block=highprivateusesurrogates}', "");
    Expect(0, 56319, '\P{Block=highprivateusesurrogates}', "");
    Expect(1, 56319, '\P{^Block=highprivateusesurrogates}', "");
    Expect(0, 57344, '\p{Block=highprivateusesurrogates}', "");
    Expect(1, 57344, '\p{^Block=highprivateusesurrogates}', "");
    Expect(1, 57344, '\P{Block=highprivateusesurrogates}', "");
    Expect(0, 57344, '\P{^Block=highprivateusesurrogates}', "");
    Expect(1, 56319, '\p{Block=:\Ahighprivateusesurrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\Ahighprivateusesurrogates\z:}', "");;
    Expect(1, 56319, '\p{Block: high_Private_Use_Surrogates}', "");
    Expect(0, 56319, '\p{^Block: high_Private_Use_Surrogates}', "");
    Expect(0, 56319, '\P{Block: high_Private_Use_Surrogates}', "");
    Expect(1, 56319, '\P{^Block: high_Private_Use_Surrogates}', "");
    Expect(0, 57344, '\p{Block: high_Private_Use_Surrogates}', "");
    Expect(1, 57344, '\p{^Block: high_Private_Use_Surrogates}', "");
    Expect(1, 57344, '\P{Block: high_Private_Use_Surrogates}', "");
    Expect(0, 57344, '\P{^Block: high_Private_Use_Surrogates}', "");
    Error('\p{Blk=_:=HIGH_PU_Surrogates}');
    Error('\P{Blk=_:=HIGH_PU_Surrogates}');
    Expect(1, 56319, '\p{Blk=:\AHigh_PU_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\AHigh_PU_Surrogates\z:}', "");;
    Expect(1, 56319, '\p{Blk=highpusurrogates}', "");
    Expect(0, 56319, '\p{^Blk=highpusurrogates}', "");
    Expect(0, 56319, '\P{Blk=highpusurrogates}', "");
    Expect(1, 56319, '\P{^Blk=highpusurrogates}', "");
    Expect(0, 57344, '\p{Blk=highpusurrogates}', "");
    Expect(1, 57344, '\p{^Blk=highpusurrogates}', "");
    Expect(1, 57344, '\P{Blk=highpusurrogates}', "");
    Expect(0, 57344, '\P{^Blk=highpusurrogates}', "");
    Expect(1, 56319, '\p{Blk=:\Ahighpusurrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\Ahighpusurrogates\z:}', "");;
    Expect(1, 56319, '\p{Blk=-	High_pu_Surrogates}', "");
    Expect(0, 56319, '\p{^Blk=-	High_pu_Surrogates}', "");
    Expect(0, 56319, '\P{Blk=-	High_pu_Surrogates}', "");
    Expect(1, 56319, '\P{^Blk=-	High_pu_Surrogates}', "");
    Expect(0, 57344, '\p{Blk=-	High_pu_Surrogates}', "");
    Expect(1, 57344, '\p{^Blk=-	High_pu_Surrogates}', "");
    Expect(1, 57344, '\P{Blk=-	High_pu_Surrogates}', "");
    Expect(0, 57344, '\P{^Blk=-	High_pu_Surrogates}', "");
    Error('\p{Is_Block=_	HIGH_Private_use_SURROGATES:=}');
    Error('\P{Is_Block=_	HIGH_Private_use_SURROGATES:=}');
    Expect(1, 56319, '\p{Is_Block: highprivateusesurrogates}', "");
    Expect(0, 56319, '\p{^Is_Block: highprivateusesurrogates}', "");
    Expect(0, 56319, '\P{Is_Block: highprivateusesurrogates}', "");
    Expect(1, 56319, '\P{^Is_Block: highprivateusesurrogates}', "");
    Expect(0, 57344, '\p{Is_Block: highprivateusesurrogates}', "");
    Expect(1, 57344, '\p{^Is_Block: highprivateusesurrogates}', "");
    Expect(1, 57344, '\P{Is_Block: highprivateusesurrogates}', "");
    Expect(0, 57344, '\P{^Is_Block: highprivateusesurrogates}', "");
    Expect(1, 56319, '\p{Is_Block= _High_Private_Use_SURROGATES}', "");
    Expect(0, 56319, '\p{^Is_Block= _High_Private_Use_SURROGATES}', "");
    Expect(0, 56319, '\P{Is_Block= _High_Private_Use_SURROGATES}', "");
    Expect(1, 56319, '\P{^Is_Block= _High_Private_Use_SURROGATES}', "");
    Expect(0, 57344, '\p{Is_Block= _High_Private_Use_SURROGATES}', "");
    Expect(1, 57344, '\p{^Is_Block= _High_Private_Use_SURROGATES}', "");
    Expect(1, 57344, '\P{Is_Block= _High_Private_Use_SURROGATES}', "");
    Expect(0, 57344, '\P{^Is_Block= _High_Private_Use_SURROGATES}', "");
    Error('\p{Is_Blk=/a/	-high_PU_SURROGATES}');
    Error('\P{Is_Blk=/a/	-high_PU_SURROGATES}');
    Expect(1, 56319, '\p{Is_Blk=highpusurrogates}', "");
    Expect(0, 56319, '\p{^Is_Blk=highpusurrogates}', "");
    Expect(0, 56319, '\P{Is_Blk=highpusurrogates}', "");
    Expect(1, 56319, '\P{^Is_Blk=highpusurrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=highpusurrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=highpusurrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=highpusurrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=highpusurrogates}', "");
    Expect(1, 56319, '\p{Is_Blk=-	HIGH_PU_Surrogates}', "");
    Expect(0, 56319, '\p{^Is_Blk=-	HIGH_PU_Surrogates}', "");
    Expect(0, 56319, '\P{Is_Blk=-	HIGH_PU_Surrogates}', "");
    Expect(1, 56319, '\P{^Is_Blk=-	HIGH_PU_Surrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=-	HIGH_PU_Surrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=-	HIGH_PU_Surrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=-	HIGH_PU_Surrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=-	HIGH_PU_Surrogates}', "");
    Error('\p{Block=_high_SURROGATES:=}');
    Error('\P{Block=_high_SURROGATES:=}');
    Expect(1, 56191, '\p{Block=:\AHigh_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\AHigh_Surrogates\z:}', "");;
    Expect(1, 56191, '\p{Block=highsurrogates}', "");
    Expect(0, 56191, '\p{^Block=highsurrogates}', "");
    Expect(0, 56191, '\P{Block=highsurrogates}', "");
    Expect(1, 56191, '\P{^Block=highsurrogates}', "");
    Expect(0, 57344, '\p{Block=highsurrogates}', "");
    Expect(1, 57344, '\p{^Block=highsurrogates}', "");
    Expect(1, 57344, '\P{Block=highsurrogates}', "");
    Expect(0, 57344, '\P{^Block=highsurrogates}', "");
    Expect(1, 56191, '\p{Block=:\Ahighsurrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\Ahighsurrogates\z:}', "");;
    Expect(1, 56191, '\p{Block= -High_surrogates}', "");
    Expect(0, 56191, '\p{^Block= -High_surrogates}', "");
    Expect(0, 56191, '\P{Block= -High_surrogates}', "");
    Expect(1, 56191, '\P{^Block= -High_surrogates}', "");
    Expect(0, 57344, '\p{Block= -High_surrogates}', "");
    Expect(1, 57344, '\p{^Block= -High_surrogates}', "");
    Expect(1, 57344, '\P{Block= -High_surrogates}', "");
    Expect(0, 57344, '\P{^Block= -High_surrogates}', "");
    Error('\p{Blk= /a/High_Surrogates}');
    Error('\P{Blk= /a/High_Surrogates}');
    Expect(1, 56191, '\p{Blk=:\AHigh_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\AHigh_Surrogates\z:}', "");;
    Expect(1, 56191, '\p{Blk=highsurrogates}', "");
    Expect(0, 56191, '\p{^Blk=highsurrogates}', "");
    Expect(0, 56191, '\P{Blk=highsurrogates}', "");
    Expect(1, 56191, '\P{^Blk=highsurrogates}', "");
    Expect(0, 57344, '\p{Blk=highsurrogates}', "");
    Expect(1, 57344, '\p{^Blk=highsurrogates}', "");
    Expect(1, 57344, '\P{Blk=highsurrogates}', "");
    Expect(0, 57344, '\P{^Blk=highsurrogates}', "");
    Expect(1, 56191, '\p{Blk=:\Ahighsurrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\Ahighsurrogates\z:}', "");;
    Expect(1, 56191, '\p{Blk=_-High_Surrogates}', "");
    Expect(0, 56191, '\p{^Blk=_-High_Surrogates}', "");
    Expect(0, 56191, '\P{Blk=_-High_Surrogates}', "");
    Expect(1, 56191, '\P{^Blk=_-High_Surrogates}', "");
    Expect(0, 57344, '\p{Blk=_-High_Surrogates}', "");
    Expect(1, 57344, '\p{^Blk=_-High_Surrogates}', "");
    Expect(1, 57344, '\P{Blk=_-High_Surrogates}', "");
    Expect(0, 57344, '\P{^Blk=_-High_Surrogates}', "");
    Error('\p{Is_Block=:=__high_SURROGATES}');
    Error('\P{Is_Block=:=__high_SURROGATES}');
    Expect(1, 56191, '\p{Is_Block=highsurrogates}', "");
    Expect(0, 56191, '\p{^Is_Block=highsurrogates}', "");
    Expect(0, 56191, '\P{Is_Block=highsurrogates}', "");
    Expect(1, 56191, '\P{^Is_Block=highsurrogates}', "");
    Expect(0, 57344, '\p{Is_Block=highsurrogates}', "");
    Expect(1, 57344, '\p{^Is_Block=highsurrogates}', "");
    Expect(1, 57344, '\P{Is_Block=highsurrogates}', "");
    Expect(0, 57344, '\P{^Is_Block=highsurrogates}', "");
    Expect(1, 56191, '\p{Is_Block= High_SURROGATES}', "");
    Expect(0, 56191, '\p{^Is_Block= High_SURROGATES}', "");
    Expect(0, 56191, '\P{Is_Block= High_SURROGATES}', "");
    Expect(1, 56191, '\P{^Is_Block= High_SURROGATES}', "");
    Expect(0, 57344, '\p{Is_Block= High_SURROGATES}', "");
    Expect(1, 57344, '\p{^Is_Block= High_SURROGATES}', "");
    Expect(1, 57344, '\P{Is_Block= High_SURROGATES}', "");
    Expect(0, 57344, '\P{^Is_Block= High_SURROGATES}', "");
    Error('\p{Is_Blk=:=_-High_Surrogates}');
    Error('\P{Is_Blk=:=_-High_Surrogates}');
    Expect(1, 56191, '\p{Is_Blk=highsurrogates}', "");
    Expect(0, 56191, '\p{^Is_Blk=highsurrogates}', "");
    Expect(0, 56191, '\P{Is_Blk=highsurrogates}', "");
    Expect(1, 56191, '\P{^Is_Blk=highsurrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=highsurrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=highsurrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=highsurrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=highsurrogates}', "");
    Expect(1, 56191, '\p{Is_Blk=_ high_Surrogates}', "");
    Expect(0, 56191, '\p{^Is_Blk=_ high_Surrogates}', "");
    Expect(0, 56191, '\P{Is_Blk=_ high_Surrogates}', "");
    Expect(1, 56191, '\P{^Is_Blk=_ high_Surrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=_ high_Surrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=_ high_Surrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=_ high_Surrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=_ high_Surrogates}', "");
    Error('\p{Block=/a/_-HIRAGANA}');
    Error('\P{Block=/a/_-HIRAGANA}');
    Expect(1, 12447, '\p{Block=:\AHiragana\z:}', "");;
    Expect(0, 12448, '\p{Block=:\AHiragana\z:}', "");;
    Expect(1, 12447, '\p{Block=hiragana}', "");
    Expect(0, 12447, '\p{^Block=hiragana}', "");
    Expect(0, 12447, '\P{Block=hiragana}', "");
    Expect(1, 12447, '\P{^Block=hiragana}', "");
    Expect(0, 12448, '\p{Block=hiragana}', "");
    Expect(1, 12448, '\p{^Block=hiragana}', "");
    Expect(1, 12448, '\P{Block=hiragana}', "");
    Expect(0, 12448, '\P{^Block=hiragana}', "");
    Expect(1, 12447, '\p{Block=:\Ahiragana\z:}', "");;
    Expect(0, 12448, '\p{Block=:\Ahiragana\z:}', "");;
    Expect(1, 12447, '\p{Block: - HIRAGANA}', "");
    Expect(0, 12447, '\p{^Block: - HIRAGANA}', "");
    Expect(0, 12447, '\P{Block: - HIRAGANA}', "");
    Expect(1, 12447, '\P{^Block: - HIRAGANA}', "");
    Expect(0, 12448, '\p{Block: - HIRAGANA}', "");
    Expect(1, 12448, '\p{^Block: - HIRAGANA}', "");
    Expect(1, 12448, '\P{Block: - HIRAGANA}', "");
    Expect(0, 12448, '\P{^Block: - HIRAGANA}', "");
    Error('\p{Blk=/a/- Hiragana}');
    Error('\P{Blk=/a/- Hiragana}');
    Expect(1, 12447, '\p{Blk=:\AHiragana\z:}', "");;
    Expect(0, 12448, '\p{Blk=:\AHiragana\z:}', "");;
    Expect(1, 12447, '\p{Blk=hiragana}', "");
    Expect(0, 12447, '\p{^Blk=hiragana}', "");
    Expect(0, 12447, '\P{Blk=hiragana}', "");
    Expect(1, 12447, '\P{^Blk=hiragana}', "");
    Expect(0, 12448, '\p{Blk=hiragana}', "");
    Expect(1, 12448, '\p{^Blk=hiragana}', "");
    Expect(1, 12448, '\P{Blk=hiragana}', "");
    Expect(0, 12448, '\P{^Blk=hiragana}', "");
    Expect(1, 12447, '\p{Blk=:\Ahiragana\z:}', "");;
    Expect(0, 12448, '\p{Blk=:\Ahiragana\z:}', "");;
    Expect(1, 12447, '\p{Blk= _Hiragana}', "");
    Expect(0, 12447, '\p{^Blk= _Hiragana}', "");
    Expect(0, 12447, '\P{Blk= _Hiragana}', "");
    Expect(1, 12447, '\P{^Blk= _Hiragana}', "");
    Expect(0, 12448, '\p{Blk= _Hiragana}', "");
    Expect(1, 12448, '\p{^Blk= _Hiragana}', "");
    Expect(1, 12448, '\P{Blk= _Hiragana}', "");
    Expect(0, 12448, '\P{^Blk= _Hiragana}', "");
    Error('\p{Is_Block=-	Hiragana:=}');
    Error('\P{Is_Block=-	Hiragana:=}');
    Expect(1, 12447, '\p{Is_Block=hiragana}', "");
    Expect(0, 12447, '\p{^Is_Block=hiragana}', "");
    Expect(0, 12447, '\P{Is_Block=hiragana}', "");
    Expect(1, 12447, '\P{^Is_Block=hiragana}', "");
    Expect(0, 12448, '\p{Is_Block=hiragana}', "");
    Expect(1, 12448, '\p{^Is_Block=hiragana}', "");
    Expect(1, 12448, '\P{Is_Block=hiragana}', "");
    Expect(0, 12448, '\P{^Is_Block=hiragana}', "");
    Expect(1, 12447, '\p{Is_Block: HIRAGANA}', "");
    Expect(0, 12447, '\p{^Is_Block: HIRAGANA}', "");
    Expect(0, 12447, '\P{Is_Block: HIRAGANA}', "");
    Expect(1, 12447, '\P{^Is_Block: HIRAGANA}', "");
    Expect(0, 12448, '\p{Is_Block: HIRAGANA}', "");
    Expect(1, 12448, '\p{^Is_Block: HIRAGANA}', "");
    Expect(1, 12448, '\P{Is_Block: HIRAGANA}', "");
    Expect(0, 12448, '\P{^Is_Block: HIRAGANA}', "");
    Error('\p{Is_Blk=-/a/Hiragana}');
    Error('\P{Is_Blk=-/a/Hiragana}');
    Expect(1, 12447, '\p{Is_Blk=hiragana}', "");
    Expect(0, 12447, '\p{^Is_Blk=hiragana}', "");
    Expect(0, 12447, '\P{Is_Blk=hiragana}', "");
    Expect(1, 12447, '\P{^Is_Blk=hiragana}', "");
    Expect(0, 12448, '\p{Is_Blk=hiragana}', "");
    Expect(1, 12448, '\p{^Is_Blk=hiragana}', "");
    Expect(1, 12448, '\P{Is_Blk=hiragana}', "");
    Expect(0, 12448, '\P{^Is_Blk=hiragana}', "");
    Expect(1, 12447, '\p{Is_Blk=- Hiragana}', "");
    Expect(0, 12447, '\p{^Is_Blk=- Hiragana}', "");
    Expect(0, 12447, '\P{Is_Blk=- Hiragana}', "");
    Expect(1, 12447, '\P{^Is_Blk=- Hiragana}', "");
    Expect(0, 12448, '\p{Is_Blk=- Hiragana}', "");
    Expect(1, 12448, '\p{^Is_Blk=- Hiragana}', "");
    Expect(1, 12448, '\P{Is_Blk=- Hiragana}', "");
    Expect(0, 12448, '\P{^Is_Blk=- Hiragana}', "");
    Error('\p{Block=_-IDEOGRAPHIC_DESCRIPTION_Characters:=}');
    Error('\P{Block=_-IDEOGRAPHIC_DESCRIPTION_Characters:=}');
    Expect(1, 12287, '\p{Block=:\AIdeographic_Description_Characters\z:}', "");;
    Expect(0, 12288, '\p{Block=:\AIdeographic_Description_Characters\z:}', "");;
    Expect(1, 12287, '\p{Block:	ideographicdescriptioncharacters}', "");
    Expect(0, 12287, '\p{^Block:	ideographicdescriptioncharacters}', "");
    Expect(0, 12287, '\P{Block:	ideographicdescriptioncharacters}', "");
    Expect(1, 12287, '\P{^Block:	ideographicdescriptioncharacters}', "");
    Expect(0, 12288, '\p{Block:	ideographicdescriptioncharacters}', "");
    Expect(1, 12288, '\p{^Block:	ideographicdescriptioncharacters}', "");
    Expect(1, 12288, '\P{Block:	ideographicdescriptioncharacters}', "");
    Expect(0, 12288, '\P{^Block:	ideographicdescriptioncharacters}', "");
    Expect(1, 12287, '\p{Block=:\Aideographicdescriptioncharacters\z:}', "");;
    Expect(0, 12288, '\p{Block=:\Aideographicdescriptioncharacters\z:}', "");;
    Expect(1, 12287, '\p{Block=	_ideographic_Description_Characters}', "");
    Expect(0, 12287, '\p{^Block=	_ideographic_Description_Characters}', "");
    Expect(0, 12287, '\P{Block=	_ideographic_Description_Characters}', "");
    Expect(1, 12287, '\P{^Block=	_ideographic_Description_Characters}', "");
    Expect(0, 12288, '\p{Block=	_ideographic_Description_Characters}', "");
    Expect(1, 12288, '\p{^Block=	_ideographic_Description_Characters}', "");
    Expect(1, 12288, '\P{Block=	_ideographic_Description_Characters}', "");
    Expect(0, 12288, '\P{^Block=	_ideographic_Description_Characters}', "");
    Error('\p{Blk=_IDC:=}');
    Error('\P{Blk=_IDC:=}');
    Expect(1, 12287, '\p{Blk=:\AIDC\z:}', "");;
    Expect(0, 12288, '\p{Blk=:\AIDC\z:}', "");;
    Expect(1, 12287, '\p{Blk=idc}', "");
    Expect(0, 12287, '\p{^Blk=idc}', "");
    Expect(0, 12287, '\P{Blk=idc}', "");
    Expect(1, 12287, '\P{^Blk=idc}', "");
    Expect(0, 12288, '\p{Blk=idc}', "");
    Expect(1, 12288, '\p{^Blk=idc}', "");
    Expect(1, 12288, '\P{Blk=idc}', "");
    Expect(0, 12288, '\P{^Blk=idc}', "");
    Expect(1, 12287, '\p{Blk=:\Aidc\z:}', "");;
    Expect(0, 12288, '\p{Blk=:\Aidc\z:}', "");;
    Expect(1, 12287, '\p{Blk= _idc}', "");
    Expect(0, 12287, '\p{^Blk= _idc}', "");
    Expect(0, 12287, '\P{Blk= _idc}', "");
    Expect(1, 12287, '\P{^Blk= _idc}', "");
    Expect(0, 12288, '\p{Blk= _idc}', "");
    Expect(1, 12288, '\p{^Blk= _idc}', "");
    Expect(1, 12288, '\P{Blk= _idc}', "");
    Expect(0, 12288, '\P{^Blk= _idc}', "");
    Error('\p{Is_Block=_Ideographic_Description_CHARACTERS/a/}');
    Error('\P{Is_Block=_Ideographic_Description_CHARACTERS/a/}');
    Expect(1, 12287, '\p{Is_Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12287, '\p{^Is_Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12287, '\P{Is_Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12287, '\P{^Is_Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12288, '\p{Is_Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12288, '\p{^Is_Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12288, '\P{Is_Block=ideographicdescriptioncharacters}', "");
    Expect(0, 12288, '\P{^Is_Block=ideographicdescriptioncharacters}', "");
    Expect(1, 12287, '\p{Is_Block= -Ideographic_DESCRIPTION_characters}', "");
    Expect(0, 12287, '\p{^Is_Block= -Ideographic_DESCRIPTION_characters}', "");
    Expect(0, 12287, '\P{Is_Block= -Ideographic_DESCRIPTION_characters}', "");
    Expect(1, 12287, '\P{^Is_Block= -Ideographic_DESCRIPTION_characters}', "");
    Expect(0, 12288, '\p{Is_Block= -Ideographic_DESCRIPTION_characters}', "");
    Expect(1, 12288, '\p{^Is_Block= -Ideographic_DESCRIPTION_characters}', "");
    Expect(1, 12288, '\P{Is_Block= -Ideographic_DESCRIPTION_characters}', "");
    Expect(0, 12288, '\P{^Is_Block= -Ideographic_DESCRIPTION_characters}', "");
    Error('\p{Is_Blk=	IDC:=}');
    Error('\P{Is_Blk=	IDC:=}');
    Expect(1, 12287, '\p{Is_Blk=idc}', "");
    Expect(0, 12287, '\p{^Is_Blk=idc}', "");
    Expect(0, 12287, '\P{Is_Blk=idc}', "");
    Expect(1, 12287, '\P{^Is_Blk=idc}', "");
    Expect(0, 12288, '\p{Is_Blk=idc}', "");
    Expect(1, 12288, '\p{^Is_Blk=idc}', "");
    Expect(1, 12288, '\P{Is_Blk=idc}', "");
    Expect(0, 12288, '\P{^Is_Blk=idc}', "");
    Expect(1, 12287, '\p{Is_Blk=__idc}', "");
    Expect(0, 12287, '\p{^Is_Blk=__idc}', "");
    Expect(0, 12287, '\P{Is_Blk=__idc}', "");
    Expect(1, 12287, '\P{^Is_Blk=__idc}', "");
    Expect(0, 12288, '\p{Is_Blk=__idc}', "");
    Expect(1, 12288, '\p{^Is_Blk=__idc}', "");
    Expect(1, 12288, '\P{Is_Blk=__idc}', "");
    Expect(0, 12288, '\P{^Is_Blk=__idc}', "");
    Error('\p{Block=-	Ideographic_SYMBOLS_AND_Punctuation:=}');
    Error('\P{Block=-	Ideographic_SYMBOLS_AND_Punctuation:=}');
    Expect(1, 94207, '\p{Block=:\AIdeographic_Symbols_And_Punctuation\z:}', "");;
    Expect(0, 94208, '\p{Block=:\AIdeographic_Symbols_And_Punctuation\z:}', "");;
    Expect(1, 94207, '\p{Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94207, '\p{^Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94207, '\P{Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94207, '\P{^Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94208, '\p{Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94208, '\p{^Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94208, '\P{Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94208, '\P{^Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94207, '\p{Block=:\Aideographicsymbolsandpunctuation\z:}', "");;
    Expect(0, 94208, '\p{Block=:\Aideographicsymbolsandpunctuation\z:}', "");;
    Expect(1, 94207, '\p{Block=-ideographic_Symbols_AND_Punctuation}', "");
    Expect(0, 94207, '\p{^Block=-ideographic_Symbols_AND_Punctuation}', "");
    Expect(0, 94207, '\P{Block=-ideographic_Symbols_AND_Punctuation}', "");
    Expect(1, 94207, '\P{^Block=-ideographic_Symbols_AND_Punctuation}', "");
    Expect(0, 94208, '\p{Block=-ideographic_Symbols_AND_Punctuation}', "");
    Expect(1, 94208, '\p{^Block=-ideographic_Symbols_AND_Punctuation}', "");
    Expect(1, 94208, '\P{Block=-ideographic_Symbols_AND_Punctuation}', "");
    Expect(0, 94208, '\P{^Block=-ideographic_Symbols_AND_Punctuation}', "");
    Error('\p{Blk= /a/Ideographic_Symbols}');
    Error('\P{Blk= /a/Ideographic_Symbols}');
    Expect(1, 94207, '\p{Blk=:\AIdeographic_Symbols\z:}', "");;
    Expect(0, 94208, '\p{Blk=:\AIdeographic_Symbols\z:}', "");;
    Expect(1, 94207, '\p{Blk:	ideographicsymbols}', "");
    Expect(0, 94207, '\p{^Blk:	ideographicsymbols}', "");
    Expect(0, 94207, '\P{Blk:	ideographicsymbols}', "");
    Expect(1, 94207, '\P{^Blk:	ideographicsymbols}', "");
    Expect(0, 94208, '\p{Blk:	ideographicsymbols}', "");
    Expect(1, 94208, '\p{^Blk:	ideographicsymbols}', "");
    Expect(1, 94208, '\P{Blk:	ideographicsymbols}', "");
    Expect(0, 94208, '\P{^Blk:	ideographicsymbols}', "");
    Expect(1, 94207, '\p{Blk=:\Aideographicsymbols\z:}', "");;
    Expect(0, 94208, '\p{Blk=:\Aideographicsymbols\z:}', "");;
    Expect(1, 94207, '\p{Blk=	IDEOGRAPHIC_Symbols}', "");
    Expect(0, 94207, '\p{^Blk=	IDEOGRAPHIC_Symbols}', "");
    Expect(0, 94207, '\P{Blk=	IDEOGRAPHIC_Symbols}', "");
    Expect(1, 94207, '\P{^Blk=	IDEOGRAPHIC_Symbols}', "");
    Expect(0, 94208, '\p{Blk=	IDEOGRAPHIC_Symbols}', "");
    Expect(1, 94208, '\p{^Blk=	IDEOGRAPHIC_Symbols}', "");
    Expect(1, 94208, '\P{Blk=	IDEOGRAPHIC_Symbols}', "");
    Expect(0, 94208, '\P{^Blk=	IDEOGRAPHIC_Symbols}', "");
    Error('\p{Is_Block=/a/	_IDEOGRAPHIC_Symbols_AND_punctuation}');
    Error('\P{Is_Block=/a/	_IDEOGRAPHIC_Symbols_AND_punctuation}');
    Expect(1, 94207, '\p{Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94207, '\p{^Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94207, '\P{Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94207, '\P{^Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94208, '\p{Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94208, '\p{^Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94208, '\P{Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(0, 94208, '\P{^Is_Block=ideographicsymbolsandpunctuation}', "");
    Expect(1, 94207, '\p{Is_Block= -ideographic_symbols_And_Punctuation}', "");
    Expect(0, 94207, '\p{^Is_Block= -ideographic_symbols_And_Punctuation}', "");
    Expect(0, 94207, '\P{Is_Block= -ideographic_symbols_And_Punctuation}', "");
    Expect(1, 94207, '\P{^Is_Block= -ideographic_symbols_And_Punctuation}', "");
    Expect(0, 94208, '\p{Is_Block= -ideographic_symbols_And_Punctuation}', "");
    Expect(1, 94208, '\p{^Is_Block= -ideographic_symbols_And_Punctuation}', "");
    Expect(1, 94208, '\P{Is_Block= -ideographic_symbols_And_Punctuation}', "");
    Expect(0, 94208, '\P{^Is_Block= -ideographic_symbols_And_Punctuation}', "");
    Error('\p{Is_Blk=-	IDEOGRAPHIC_SYMBOLS:=}');
    Error('\P{Is_Blk=-	IDEOGRAPHIC_SYMBOLS:=}');
    Expect(1, 94207, '\p{Is_Blk=ideographicsymbols}', "");
    Expect(0, 94207, '\p{^Is_Blk=ideographicsymbols}', "");
    Expect(0, 94207, '\P{Is_Blk=ideographicsymbols}', "");
    Expect(1, 94207, '\P{^Is_Blk=ideographicsymbols}', "");
    Expect(0, 94208, '\p{Is_Blk=ideographicsymbols}', "");
    Expect(1, 94208, '\p{^Is_Blk=ideographicsymbols}', "");
    Expect(1, 94208, '\P{Is_Blk=ideographicsymbols}', "");
    Expect(0, 94208, '\P{^Is_Blk=ideographicsymbols}', "");
    Expect(1, 94207, '\p{Is_Blk=_-Ideographic_symbols}', "");
    Expect(0, 94207, '\p{^Is_Blk=_-Ideographic_symbols}', "");
    Expect(0, 94207, '\P{Is_Blk=_-Ideographic_symbols}', "");
    Expect(1, 94207, '\P{^Is_Blk=_-Ideographic_symbols}', "");
    Expect(0, 94208, '\p{Is_Blk=_-Ideographic_symbols}', "");
    Expect(1, 94208, '\p{^Is_Blk=_-Ideographic_symbols}', "");
    Expect(1, 94208, '\P{Is_Blk=_-Ideographic_symbols}', "");
    Expect(0, 94208, '\P{^Is_Blk=_-Ideographic_symbols}', "");
    Error('\p{Block=IMPERIAL_ARAMAIC:=}');
    Error('\P{Block=IMPERIAL_ARAMAIC:=}');
    Expect(1, 67679, '\p{Block=:\AImperial_Aramaic\z:}', "");;
    Expect(0, 67680, '\p{Block=:\AImperial_Aramaic\z:}', "");;
    Expect(1, 67679, '\p{Block=imperialaramaic}', "");
    Expect(0, 67679, '\p{^Block=imperialaramaic}', "");
    Expect(0, 67679, '\P{Block=imperialaramaic}', "");
    Expect(1, 67679, '\P{^Block=imperialaramaic}', "");
    Expect(0, 67680, '\p{Block=imperialaramaic}', "");
    Expect(1, 67680, '\p{^Block=imperialaramaic}', "");
    Expect(1, 67680, '\P{Block=imperialaramaic}', "");
    Expect(0, 67680, '\P{^Block=imperialaramaic}', "");
    Expect(1, 67679, '\p{Block=:\Aimperialaramaic\z:}', "");;
    Expect(0, 67680, '\p{Block=:\Aimperialaramaic\z:}', "");;
    Expect(1, 67679, '\p{Block= Imperial_ARAMAIC}', "");
    Expect(0, 67679, '\p{^Block= Imperial_ARAMAIC}', "");
    Expect(0, 67679, '\P{Block= Imperial_ARAMAIC}', "");
    Expect(1, 67679, '\P{^Block= Imperial_ARAMAIC}', "");
    Expect(0, 67680, '\p{Block= Imperial_ARAMAIC}', "");
    Expect(1, 67680, '\p{^Block= Imperial_ARAMAIC}', "");
    Expect(1, 67680, '\P{Block= Imperial_ARAMAIC}', "");
    Expect(0, 67680, '\P{^Block= Imperial_ARAMAIC}', "");
    Error('\p{Blk= _imperial_aramaic/a/}');
    Error('\P{Blk= _imperial_aramaic/a/}');
    Expect(1, 67679, '\p{Blk=:\AImperial_Aramaic\z:}', "");;
    Expect(0, 67680, '\p{Blk=:\AImperial_Aramaic\z:}', "");;
    Expect(1, 67679, '\p{Blk=imperialaramaic}', "");
    Expect(0, 67679, '\p{^Blk=imperialaramaic}', "");
    Expect(0, 67679, '\P{Blk=imperialaramaic}', "");
    Expect(1, 67679, '\P{^Blk=imperialaramaic}', "");
    Expect(0, 67680, '\p{Blk=imperialaramaic}', "");
    Expect(1, 67680, '\p{^Blk=imperialaramaic}', "");
    Expect(1, 67680, '\P{Blk=imperialaramaic}', "");
    Expect(0, 67680, '\P{^Blk=imperialaramaic}', "");
    Expect(1, 67679, '\p{Blk=:\Aimperialaramaic\z:}', "");;
    Expect(0, 67680, '\p{Blk=:\Aimperialaramaic\z:}', "");;
    Expect(1, 67679, '\p{Blk= _IMPERIAL_aramaic}', "");
    Expect(0, 67679, '\p{^Blk= _IMPERIAL_aramaic}', "");
    Expect(0, 67679, '\P{Blk= _IMPERIAL_aramaic}', "");
    Expect(1, 67679, '\P{^Blk= _IMPERIAL_aramaic}', "");
    Expect(0, 67680, '\p{Blk= _IMPERIAL_aramaic}', "");
    Expect(1, 67680, '\p{^Blk= _IMPERIAL_aramaic}', "");
    Expect(1, 67680, '\P{Blk= _IMPERIAL_aramaic}', "");
    Expect(0, 67680, '\P{^Blk= _IMPERIAL_aramaic}', "");
    Error('\p{Is_Block=imperial_ARAMAIC:=}');
    Error('\P{Is_Block=imperial_ARAMAIC:=}');
    Expect(1, 67679, '\p{Is_Block=imperialaramaic}', "");
    Expect(0, 67679, '\p{^Is_Block=imperialaramaic}', "");
    Expect(0, 67679, '\P{Is_Block=imperialaramaic}', "");
    Expect(1, 67679, '\P{^Is_Block=imperialaramaic}', "");
    Expect(0, 67680, '\p{Is_Block=imperialaramaic}', "");
    Expect(1, 67680, '\p{^Is_Block=imperialaramaic}', "");
    Expect(1, 67680, '\P{Is_Block=imperialaramaic}', "");
    Expect(0, 67680, '\P{^Is_Block=imperialaramaic}', "");
    Expect(1, 67679, '\p{Is_Block=	imperial_ARAMAIC}', "");
    Expect(0, 67679, '\p{^Is_Block=	imperial_ARAMAIC}', "");
    Expect(0, 67679, '\P{Is_Block=	imperial_ARAMAIC}', "");
    Expect(1, 67679, '\P{^Is_Block=	imperial_ARAMAIC}', "");
    Expect(0, 67680, '\p{Is_Block=	imperial_ARAMAIC}', "");
    Expect(1, 67680, '\p{^Is_Block=	imperial_ARAMAIC}', "");
    Expect(1, 67680, '\P{Is_Block=	imperial_ARAMAIC}', "");
    Expect(0, 67680, '\P{^Is_Block=	imperial_ARAMAIC}', "");
    Error('\p{Is_Blk=/a/-imperial_aramaic}');
    Error('\P{Is_Blk=/a/-imperial_aramaic}');
    Expect(1, 67679, '\p{Is_Blk=imperialaramaic}', "");
    Expect(0, 67679, '\p{^Is_Blk=imperialaramaic}', "");
    Expect(0, 67679, '\P{Is_Blk=imperialaramaic}', "");
    Expect(1, 67679, '\P{^Is_Blk=imperialaramaic}', "");
    Expect(0, 67680, '\p{Is_Blk=imperialaramaic}', "");
    Expect(1, 67680, '\p{^Is_Blk=imperialaramaic}', "");
    Expect(1, 67680, '\P{Is_Blk=imperialaramaic}', "");
    Expect(0, 67680, '\P{^Is_Blk=imperialaramaic}', "");
    Expect(1, 67679, '\p{Is_Blk=Imperial_ARAMAIC}', "");
    Expect(0, 67679, '\p{^Is_Blk=Imperial_ARAMAIC}', "");
    Expect(0, 67679, '\P{Is_Blk=Imperial_ARAMAIC}', "");
    Expect(1, 67679, '\P{^Is_Blk=Imperial_ARAMAIC}', "");
    Expect(0, 67680, '\p{Is_Blk=Imperial_ARAMAIC}', "");
    Expect(1, 67680, '\p{^Is_Blk=Imperial_ARAMAIC}', "");
    Expect(1, 67680, '\P{Is_Blk=Imperial_ARAMAIC}', "");
    Expect(0, 67680, '\P{^Is_Blk=Imperial_ARAMAIC}', "");
    Error('\p{Block=-/a/common_INDIC_number_forms}');
    Error('\P{Block=-/a/common_INDIC_number_forms}');
    Expect(1, 43071, '\p{Block=:\ACommon_Indic_Number_Forms\z:}', "");;
    Expect(0, 43072, '\p{Block=:\ACommon_Indic_Number_Forms\z:}', "");;
    Expect(1, 43071, '\p{Block=commonindicnumberforms}', "");
    Expect(0, 43071, '\p{^Block=commonindicnumberforms}', "");
    Expect(0, 43071, '\P{Block=commonindicnumberforms}', "");
    Expect(1, 43071, '\P{^Block=commonindicnumberforms}', "");
    Expect(0, 43072, '\p{Block=commonindicnumberforms}', "");
    Expect(1, 43072, '\p{^Block=commonindicnumberforms}', "");
    Expect(1, 43072, '\P{Block=commonindicnumberforms}', "");
    Expect(0, 43072, '\P{^Block=commonindicnumberforms}', "");
    Expect(1, 43071, '\p{Block=:\Acommonindicnumberforms\z:}', "");;
    Expect(0, 43072, '\p{Block=:\Acommonindicnumberforms\z:}', "");;
    Expect(1, 43071, '\p{Block= common_Indic_Number_FORMS}', "");
    Expect(0, 43071, '\p{^Block= common_Indic_Number_FORMS}', "");
    Expect(0, 43071, '\P{Block= common_Indic_Number_FORMS}', "");
    Expect(1, 43071, '\P{^Block= common_Indic_Number_FORMS}', "");
    Expect(0, 43072, '\p{Block= common_Indic_Number_FORMS}', "");
    Expect(1, 43072, '\p{^Block= common_Indic_Number_FORMS}', "");
    Expect(1, 43072, '\P{Block= common_Indic_Number_FORMS}', "");
    Expect(0, 43072, '\P{^Block= common_Indic_Number_FORMS}', "");
    Error('\p{Blk=	:=INDIC_number_Forms}');
    Error('\P{Blk=	:=INDIC_number_Forms}');
    Expect(1, 43071, '\p{Blk=:\AIndic_Number_Forms\z:}', "");;
    Expect(0, 43072, '\p{Blk=:\AIndic_Number_Forms\z:}', "");;
    Expect(1, 43071, '\p{Blk=indicnumberforms}', "");
    Expect(0, 43071, '\p{^Blk=indicnumberforms}', "");
    Expect(0, 43071, '\P{Blk=indicnumberforms}', "");
    Expect(1, 43071, '\P{^Blk=indicnumberforms}', "");
    Expect(0, 43072, '\p{Blk=indicnumberforms}', "");
    Expect(1, 43072, '\p{^Blk=indicnumberforms}', "");
    Expect(1, 43072, '\P{Blk=indicnumberforms}', "");
    Expect(0, 43072, '\P{^Blk=indicnumberforms}', "");
    Expect(1, 43071, '\p{Blk=:\Aindicnumberforms\z:}', "");;
    Expect(0, 43072, '\p{Blk=:\Aindicnumberforms\z:}', "");;
    Expect(1, 43071, '\p{Blk=_	INDIC_NUMBER_forms}', "");
    Expect(0, 43071, '\p{^Blk=_	INDIC_NUMBER_forms}', "");
    Expect(0, 43071, '\P{Blk=_	INDIC_NUMBER_forms}', "");
    Expect(1, 43071, '\P{^Blk=_	INDIC_NUMBER_forms}', "");
    Expect(0, 43072, '\p{Blk=_	INDIC_NUMBER_forms}', "");
    Expect(1, 43072, '\p{^Blk=_	INDIC_NUMBER_forms}', "");
    Expect(1, 43072, '\P{Blk=_	INDIC_NUMBER_forms}', "");
    Expect(0, 43072, '\P{^Blk=_	INDIC_NUMBER_forms}', "");
    Error('\p{Is_Block=/a/COMMON_Indic_NUMBER_Forms}');
    Error('\P{Is_Block=/a/COMMON_Indic_NUMBER_Forms}');
    Expect(1, 43071, '\p{Is_Block: commonindicnumberforms}', "");
    Expect(0, 43071, '\p{^Is_Block: commonindicnumberforms}', "");
    Expect(0, 43071, '\P{Is_Block: commonindicnumberforms}', "");
    Expect(1, 43071, '\P{^Is_Block: commonindicnumberforms}', "");
    Expect(0, 43072, '\p{Is_Block: commonindicnumberforms}', "");
    Expect(1, 43072, '\p{^Is_Block: commonindicnumberforms}', "");
    Expect(1, 43072, '\P{Is_Block: commonindicnumberforms}', "");
    Expect(0, 43072, '\P{^Is_Block: commonindicnumberforms}', "");
    Expect(1, 43071, '\p{Is_Block:   -Common_Indic_NUMBER_Forms}', "");
    Expect(0, 43071, '\p{^Is_Block:   -Common_Indic_NUMBER_Forms}', "");
    Expect(0, 43071, '\P{Is_Block:   -Common_Indic_NUMBER_Forms}', "");
    Expect(1, 43071, '\P{^Is_Block:   -Common_Indic_NUMBER_Forms}', "");
    Expect(0, 43072, '\p{Is_Block:   -Common_Indic_NUMBER_Forms}', "");
    Expect(1, 43072, '\p{^Is_Block:   -Common_Indic_NUMBER_Forms}', "");
    Expect(1, 43072, '\P{Is_Block:   -Common_Indic_NUMBER_Forms}', "");
    Expect(0, 43072, '\P{^Is_Block:   -Common_Indic_NUMBER_Forms}', "");
    Error('\p{Is_Blk=/a/	 INDIC_NUMBER_FORMS}');
    Error('\P{Is_Blk=/a/	 INDIC_NUMBER_FORMS}');
    Expect(1, 43071, '\p{Is_Blk:   indicnumberforms}', "");
    Expect(0, 43071, '\p{^Is_Blk:   indicnumberforms}', "");
    Expect(0, 43071, '\P{Is_Blk:   indicnumberforms}', "");
    Expect(1, 43071, '\P{^Is_Blk:   indicnumberforms}', "");
    Expect(0, 43072, '\p{Is_Blk:   indicnumberforms}', "");
    Expect(1, 43072, '\p{^Is_Blk:   indicnumberforms}', "");
    Expect(1, 43072, '\P{Is_Blk:   indicnumberforms}', "");
    Expect(0, 43072, '\P{^Is_Blk:   indicnumberforms}', "");
    Expect(1, 43071, '\p{Is_Blk=_Indic_Number_Forms}', "");
    Expect(0, 43071, '\p{^Is_Blk=_Indic_Number_Forms}', "");
    Expect(0, 43071, '\P{Is_Blk=_Indic_Number_Forms}', "");
    Expect(1, 43071, '\P{^Is_Blk=_Indic_Number_Forms}', "");
    Expect(0, 43072, '\p{Is_Blk=_Indic_Number_Forms}', "");
    Expect(1, 43072, '\p{^Is_Blk=_Indic_Number_Forms}', "");
    Expect(1, 43072, '\P{Is_Blk=_Indic_Number_Forms}', "");
    Expect(0, 43072, '\P{^Is_Blk=_Indic_Number_Forms}', "");
    Error('\p{Block=_:=Indic_Siyaq_Numbers}');
    Error('\P{Block=_:=Indic_Siyaq_Numbers}');
    Expect(1, 126143, '\p{Block=:\AIndic_Siyaq_Numbers\z:}', "");;
    Expect(0, 126144, '\p{Block=:\AIndic_Siyaq_Numbers\z:}', "");;
    Expect(1, 126143, '\p{Block=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\p{^Block=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\P{Block=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\P{^Block=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\p{Block=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\p{^Block=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\P{Block=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\P{^Block=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\p{Block=:\Aindicsiyaqnumbers\z:}', "");;
    Expect(0, 126144, '\p{Block=:\Aindicsiyaqnumbers\z:}', "");;
    Expect(1, 126143, '\p{Block= Indic_SIYAQ_numbers}', "");
    Expect(0, 126143, '\p{^Block= Indic_SIYAQ_numbers}', "");
    Expect(0, 126143, '\P{Block= Indic_SIYAQ_numbers}', "");
    Expect(1, 126143, '\P{^Block= Indic_SIYAQ_numbers}', "");
    Expect(0, 126144, '\p{Block= Indic_SIYAQ_numbers}', "");
    Expect(1, 126144, '\p{^Block= Indic_SIYAQ_numbers}', "");
    Expect(1, 126144, '\P{Block= Indic_SIYAQ_numbers}', "");
    Expect(0, 126144, '\P{^Block= Indic_SIYAQ_numbers}', "");
    Error('\p{Blk=	:=INDIC_SIYAQ_Numbers}');
    Error('\P{Blk=	:=INDIC_SIYAQ_Numbers}');
    Expect(1, 126143, '\p{Blk=:\AIndic_Siyaq_Numbers\z:}', "");;
    Expect(0, 126144, '\p{Blk=:\AIndic_Siyaq_Numbers\z:}', "");;
    Expect(1, 126143, '\p{Blk=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\p{^Blk=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\P{Blk=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\P{^Blk=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\p{Blk=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\p{^Blk=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\P{Blk=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\P{^Blk=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\p{Blk=:\Aindicsiyaqnumbers\z:}', "");;
    Expect(0, 126144, '\p{Blk=:\Aindicsiyaqnumbers\z:}', "");;
    Expect(1, 126143, '\p{Blk=- indic_Siyaq_NUMBERS}', "");
    Expect(0, 126143, '\p{^Blk=- indic_Siyaq_NUMBERS}', "");
    Expect(0, 126143, '\P{Blk=- indic_Siyaq_NUMBERS}', "");
    Expect(1, 126143, '\P{^Blk=- indic_Siyaq_NUMBERS}', "");
    Expect(0, 126144, '\p{Blk=- indic_Siyaq_NUMBERS}', "");
    Expect(1, 126144, '\p{^Blk=- indic_Siyaq_NUMBERS}', "");
    Expect(1, 126144, '\P{Blk=- indic_Siyaq_NUMBERS}', "");
    Expect(0, 126144, '\P{^Blk=- indic_Siyaq_NUMBERS}', "");
    Error('\p{Is_Block=_/a/INDIC_siyaq_numbers}');
    Error('\P{Is_Block=_/a/INDIC_siyaq_numbers}');
    Expect(1, 126143, '\p{Is_Block=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\p{^Is_Block=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\P{Is_Block=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\P{^Is_Block=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\p{Is_Block=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\p{^Is_Block=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\P{Is_Block=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\P{^Is_Block=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\p{Is_Block= Indic_SIYAQ_NUMBERS}', "");
    Expect(0, 126143, '\p{^Is_Block= Indic_SIYAQ_NUMBERS}', "");
    Expect(0, 126143, '\P{Is_Block= Indic_SIYAQ_NUMBERS}', "");
    Expect(1, 126143, '\P{^Is_Block= Indic_SIYAQ_NUMBERS}', "");
    Expect(0, 126144, '\p{Is_Block= Indic_SIYAQ_NUMBERS}', "");
    Expect(1, 126144, '\p{^Is_Block= Indic_SIYAQ_NUMBERS}', "");
    Expect(1, 126144, '\P{Is_Block= Indic_SIYAQ_NUMBERS}', "");
    Expect(0, 126144, '\P{^Is_Block= Indic_SIYAQ_NUMBERS}', "");
    Error('\p{Is_Blk=__indic_siyaq_numbers:=}');
    Error('\P{Is_Blk=__indic_siyaq_numbers:=}');
    Expect(1, 126143, '\p{Is_Blk=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\p{^Is_Blk=indicsiyaqnumbers}', "");
    Expect(0, 126143, '\P{Is_Blk=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\P{^Is_Blk=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\p{Is_Blk=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\p{^Is_Blk=indicsiyaqnumbers}', "");
    Expect(1, 126144, '\P{Is_Blk=indicsiyaqnumbers}', "");
    Expect(0, 126144, '\P{^Is_Blk=indicsiyaqnumbers}', "");
    Expect(1, 126143, '\p{Is_Blk=-_Indic_SIYAQ_NUMBERS}', "");
    Expect(0, 126143, '\p{^Is_Blk=-_Indic_SIYAQ_NUMBERS}', "");
    Expect(0, 126143, '\P{Is_Blk=-_Indic_SIYAQ_NUMBERS}', "");
    Expect(1, 126143, '\P{^Is_Blk=-_Indic_SIYAQ_NUMBERS}', "");
    Expect(0, 126144, '\p{Is_Blk=-_Indic_SIYAQ_NUMBERS}', "");
    Expect(1, 126144, '\p{^Is_Blk=-_Indic_SIYAQ_NUMBERS}', "");
    Expect(1, 126144, '\P{Is_Blk=-_Indic_SIYAQ_NUMBERS}', "");
    Expect(0, 126144, '\P{^Is_Blk=-_Indic_SIYAQ_NUMBERS}', "");
    Error('\p{Block:/a/_inscriptional_pahlavi}');
    Error('\P{Block:/a/_inscriptional_pahlavi}');
    Expect(1, 68479, '\p{Block=:\AInscriptional_Pahlavi\z:}', "");;
    Expect(0, 68480, '\p{Block=:\AInscriptional_Pahlavi\z:}', "");;
    Expect(1, 68479, '\p{Block=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\p{^Block=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\P{Block=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\P{^Block=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\p{Block=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\p{^Block=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\P{Block=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\P{^Block=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\p{Block=:\Ainscriptionalpahlavi\z:}', "");;
    Expect(0, 68480, '\p{Block=:\Ainscriptionalpahlavi\z:}', "");;
    Expect(1, 68479, '\p{Block=	-INSCRIPTIONAL_pahlavi}', "");
    Expect(0, 68479, '\p{^Block=	-INSCRIPTIONAL_pahlavi}', "");
    Expect(0, 68479, '\P{Block=	-INSCRIPTIONAL_pahlavi}', "");
    Expect(1, 68479, '\P{^Block=	-INSCRIPTIONAL_pahlavi}', "");
    Expect(0, 68480, '\p{Block=	-INSCRIPTIONAL_pahlavi}', "");
    Expect(1, 68480, '\p{^Block=	-INSCRIPTIONAL_pahlavi}', "");
    Expect(1, 68480, '\P{Block=	-INSCRIPTIONAL_pahlavi}', "");
    Expect(0, 68480, '\P{^Block=	-INSCRIPTIONAL_pahlavi}', "");
    Error('\p{Blk=__Inscriptional_pahlavi/a/}');
    Error('\P{Blk=__Inscriptional_pahlavi/a/}');
    Expect(1, 68479, '\p{Blk=:\AInscriptional_Pahlavi\z:}', "");;
    Expect(0, 68480, '\p{Blk=:\AInscriptional_Pahlavi\z:}', "");;
    Expect(1, 68479, '\p{Blk=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\p{^Blk=inscriptionalpahlavi}', "");
    Expect(0, 68479, '\P{Blk=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\P{^Blk=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\p{Blk=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\p{^Blk=inscriptionalpahlavi}', "");
    Expect(1, 68480, '\P{Blk=inscriptionalpahlavi}', "");
    Expect(0, 68480, '\P{^Blk=inscriptionalpahlavi}', "");
    Expect(1, 68479, '\p{Blk=:\Ainscriptionalpahlavi\z:}', "");;
    Expect(0, 68480, '\p{Blk=:\Ainscriptionalpahlavi\z:}', "");;
    Expect(1, 68479, '\p{Blk=-Inscriptional_PAHLAVI}', "");
    Expect(0, 68479, '\p{^Blk=-Inscriptional_PAHLAVI}', "");
    Expect(0, 68479, '\P{Blk=-Inscriptional_PAHLAVI}', "");
    Expect(1, 68479, '\P{^Blk=-Inscriptional_PAHLAVI}', "");
    Expect(0, 68480, '\p{Blk=-Inscriptional_PAHLAVI}', "");
    Expect(1, 68480, '\p{^Blk=-Inscriptional_PAHLAVI}', "");
    Expect(1, 68480, '\P{Blk=-Inscriptional_PAHLAVI}', "");
    Expect(0, 68480, '\P{^Blk=-Inscriptional_PAHLAVI}', "");
    Error('\p{Is_Block= INSCRIPTIONAL_Pahlavi/a/}');
    Error('\P{Is_Block= INSCRIPTIONAL_Pahlavi/a/}');
    Expect(1, 68479, '\p{Is_Block:inscriptionalpahlavi}', "");
    Expect(0, 68479, '\p{^Is_Block:inscriptionalpahlavi}', "");
    Expect(0, 68479, '\P{Is_Block:inscriptionalpahlavi}', "");
    Expect(1, 68479, '\P{^Is_Block:inscriptionalpahlavi}', "");
    Expect(0, 68480, '\p{Is_Block:inscriptionalpahlavi}', "");
    Expect(1, 68480, '\p{^Is_Block:inscriptionalpahlavi}', "");
    Expect(1, 68480, '\P{Is_Block:inscriptionalpahlavi}', "");
    Expect(0, 68480, '\P{^Is_Block:inscriptionalpahlavi}', "");
    Expect(1, 68479, '\p{Is_Block=-INSCRIPTIONAL_PAHLAVI}', "");
    Expect(0, 68479, '\p{^Is_Block=-INSCRIPTIONAL_PAHLAVI}', "");
    Expect(0, 68479, '\P{Is_Block=-INSCRIPTIONAL_PAHLAVI}', "");
    Expect(1, 68479, '\P{^Is_Block=-INSCRIPTIONAL_PAHLAVI}', "");
    Expect(0, 68480, '\p{Is_Block=-INSCRIPTIONAL_PAHLAVI}', "");
    Expect(1, 68480, '\p{^Is_Block=-INSCRIPTIONAL_PAHLAVI}', "");
    Expect(1, 68480, '\P{Is_Block=-INSCRIPTIONAL_PAHLAVI}', "");
    Expect(0, 68480, '\P{^Is_Block=-INSCRIPTIONAL_PAHLAVI}', "");
    Error('\p{Is_Blk=:=-INSCRIPTIONAL_Pahlavi}');
    Error('\P{Is_Blk=:=-INSCRIPTIONAL_Pahlavi}');
    Expect(1, 68479, '\p{Is_Blk:inscriptionalpahlavi}', "");
    Expect(0, 68479, '\p{^Is_Blk:inscriptionalpahlavi}', "");
    Expect(0, 68479, '\P{Is_Blk:inscriptionalpahlavi}', "");
    Expect(1, 68479, '\P{^Is_Blk:inscriptionalpahlavi}', "");
    Expect(0, 68480, '\p{Is_Blk:inscriptionalpahlavi}', "");
    Expect(1, 68480, '\p{^Is_Blk:inscriptionalpahlavi}', "");
    Expect(1, 68480, '\P{Is_Blk:inscriptionalpahlavi}', "");
    Expect(0, 68480, '\P{^Is_Blk:inscriptionalpahlavi}', "");
    Expect(1, 68479, '\p{Is_Blk=		inscriptional_pahlavi}', "");
    Expect(0, 68479, '\p{^Is_Blk=		inscriptional_pahlavi}', "");
    Expect(0, 68479, '\P{Is_Blk=		inscriptional_pahlavi}', "");
    Expect(1, 68479, '\P{^Is_Blk=		inscriptional_pahlavi}', "");
    Expect(0, 68480, '\p{Is_Blk=		inscriptional_pahlavi}', "");
    Expect(1, 68480, '\p{^Is_Blk=		inscriptional_pahlavi}', "");
    Expect(1, 68480, '\P{Is_Blk=		inscriptional_pahlavi}', "");
    Expect(0, 68480, '\P{^Is_Blk=		inscriptional_pahlavi}', "");
    Error('\p{Block:		 Inscriptional_parthian:=}');
    Error('\P{Block:		 Inscriptional_parthian:=}');
    Expect(1, 68447, '\p{Block=:\AInscriptional_Parthian\z:}', "");;
    Expect(0, 68448, '\p{Block=:\AInscriptional_Parthian\z:}', "");;
    Expect(1, 68447, '\p{Block:	inscriptionalparthian}', "");
    Expect(0, 68447, '\p{^Block:	inscriptionalparthian}', "");
    Expect(0, 68447, '\P{Block:	inscriptionalparthian}', "");
    Expect(1, 68447, '\P{^Block:	inscriptionalparthian}', "");
    Expect(0, 68448, '\p{Block:	inscriptionalparthian}', "");
    Expect(1, 68448, '\p{^Block:	inscriptionalparthian}', "");
    Expect(1, 68448, '\P{Block:	inscriptionalparthian}', "");
    Expect(0, 68448, '\P{^Block:	inscriptionalparthian}', "");
    Expect(1, 68447, '\p{Block=:\Ainscriptionalparthian\z:}', "");;
    Expect(0, 68448, '\p{Block=:\Ainscriptionalparthian\z:}', "");;
    Expect(1, 68447, '\p{Block=-Inscriptional_PARTHIAN}', "");
    Expect(0, 68447, '\p{^Block=-Inscriptional_PARTHIAN}', "");
    Expect(0, 68447, '\P{Block=-Inscriptional_PARTHIAN}', "");
    Expect(1, 68447, '\P{^Block=-Inscriptional_PARTHIAN}', "");
    Expect(0, 68448, '\p{Block=-Inscriptional_PARTHIAN}', "");
    Expect(1, 68448, '\p{^Block=-Inscriptional_PARTHIAN}', "");
    Expect(1, 68448, '\P{Block=-Inscriptional_PARTHIAN}', "");
    Expect(0, 68448, '\P{^Block=-Inscriptional_PARTHIAN}', "");
    Error('\p{Blk=:=Inscriptional_parthian}');
    Error('\P{Blk=:=Inscriptional_parthian}');
    Expect(1, 68447, '\p{Blk=:\AInscriptional_Parthian\z:}', "");;
    Expect(0, 68448, '\p{Blk=:\AInscriptional_Parthian\z:}', "");;
    Expect(1, 68447, '\p{Blk=inscriptionalparthian}', "");
    Expect(0, 68447, '\p{^Blk=inscriptionalparthian}', "");
    Expect(0, 68447, '\P{Blk=inscriptionalparthian}', "");
    Expect(1, 68447, '\P{^Blk=inscriptionalparthian}', "");
    Expect(0, 68448, '\p{Blk=inscriptionalparthian}', "");
    Expect(1, 68448, '\p{^Blk=inscriptionalparthian}', "");
    Expect(1, 68448, '\P{Blk=inscriptionalparthian}', "");
    Expect(0, 68448, '\P{^Blk=inscriptionalparthian}', "");
    Expect(1, 68447, '\p{Blk=:\Ainscriptionalparthian\z:}', "");;
    Expect(0, 68448, '\p{Blk=:\Ainscriptionalparthian\z:}', "");;
    Expect(1, 68447, '\p{Blk=	 inscriptional_parthian}', "");
    Expect(0, 68447, '\p{^Blk=	 inscriptional_parthian}', "");
    Expect(0, 68447, '\P{Blk=	 inscriptional_parthian}', "");
    Expect(1, 68447, '\P{^Blk=	 inscriptional_parthian}', "");
    Expect(0, 68448, '\p{Blk=	 inscriptional_parthian}', "");
    Expect(1, 68448, '\p{^Blk=	 inscriptional_parthian}', "");
    Expect(1, 68448, '\P{Blk=	 inscriptional_parthian}', "");
    Expect(0, 68448, '\P{^Blk=	 inscriptional_parthian}', "");
    Error('\p{Is_Block=	 Inscriptional_PARTHIAN:=}');
    Error('\P{Is_Block=	 Inscriptional_PARTHIAN:=}');
    Expect(1, 68447, '\p{Is_Block=inscriptionalparthian}', "");
    Expect(0, 68447, '\p{^Is_Block=inscriptionalparthian}', "");
    Expect(0, 68447, '\P{Is_Block=inscriptionalparthian}', "");
    Expect(1, 68447, '\P{^Is_Block=inscriptionalparthian}', "");
    Expect(0, 68448, '\p{Is_Block=inscriptionalparthian}', "");
    Expect(1, 68448, '\p{^Is_Block=inscriptionalparthian}', "");
    Expect(1, 68448, '\P{Is_Block=inscriptionalparthian}', "");
    Expect(0, 68448, '\P{^Is_Block=inscriptionalparthian}', "");
    Expect(1, 68447, '\p{Is_Block=INSCRIPTIONAL_Parthian}', "");
    Expect(0, 68447, '\p{^Is_Block=INSCRIPTIONAL_Parthian}', "");
    Expect(0, 68447, '\P{Is_Block=INSCRIPTIONAL_Parthian}', "");
    Expect(1, 68447, '\P{^Is_Block=INSCRIPTIONAL_Parthian}', "");
    Expect(0, 68448, '\p{Is_Block=INSCRIPTIONAL_Parthian}', "");
    Expect(1, 68448, '\p{^Is_Block=INSCRIPTIONAL_Parthian}', "");
    Expect(1, 68448, '\P{Is_Block=INSCRIPTIONAL_Parthian}', "");
    Expect(0, 68448, '\P{^Is_Block=INSCRIPTIONAL_Parthian}', "");
    Error('\p{Is_Blk=/a/-	inscriptional_parthian}');
    Error('\P{Is_Blk=/a/-	inscriptional_parthian}');
    Expect(1, 68447, '\p{Is_Blk=inscriptionalparthian}', "");
    Expect(0, 68447, '\p{^Is_Blk=inscriptionalparthian}', "");
    Expect(0, 68447, '\P{Is_Blk=inscriptionalparthian}', "");
    Expect(1, 68447, '\P{^Is_Blk=inscriptionalparthian}', "");
    Expect(0, 68448, '\p{Is_Blk=inscriptionalparthian}', "");
    Expect(1, 68448, '\p{^Is_Blk=inscriptionalparthian}', "");
    Expect(1, 68448, '\P{Is_Blk=inscriptionalparthian}', "");
    Expect(0, 68448, '\P{^Is_Blk=inscriptionalparthian}', "");
    Expect(1, 68447, '\p{Is_Blk= 	inscriptional_Parthian}', "");
    Expect(0, 68447, '\p{^Is_Blk= 	inscriptional_Parthian}', "");
    Expect(0, 68447, '\P{Is_Blk= 	inscriptional_Parthian}', "");
    Expect(1, 68447, '\P{^Is_Blk= 	inscriptional_Parthian}', "");
    Expect(0, 68448, '\p{Is_Blk= 	inscriptional_Parthian}', "");
    Expect(1, 68448, '\p{^Is_Blk= 	inscriptional_Parthian}', "");
    Expect(1, 68448, '\P{Is_Blk= 	inscriptional_Parthian}', "");
    Expect(0, 68448, '\P{^Is_Blk= 	inscriptional_Parthian}', "");
    Error('\p{Block=-:=IPA_Extensions}');
    Error('\P{Block=-:=IPA_Extensions}');
    Expect(1, 687, '\p{Block=:\AIPA_Extensions\z:}', "");;
    Expect(0, 688, '\p{Block=:\AIPA_Extensions\z:}', "");;
    Expect(1, 687, '\p{Block=ipaextensions}', "");
    Expect(0, 687, '\p{^Block=ipaextensions}', "");
    Expect(0, 687, '\P{Block=ipaextensions}', "");
    Expect(1, 687, '\P{^Block=ipaextensions}', "");
    Expect(0, 688, '\p{Block=ipaextensions}', "");
    Expect(1, 688, '\p{^Block=ipaextensions}', "");
    Expect(1, 688, '\P{Block=ipaextensions}', "");
    Expect(0, 688, '\P{^Block=ipaextensions}', "");
    Expect(1, 687, '\p{Block=:\Aipaextensions\z:}', "");;
    Expect(0, 688, '\p{Block=:\Aipaextensions\z:}', "");;
    Expect(1, 687, '\p{Block=-IPA_Extensions}', "");
    Expect(0, 687, '\p{^Block=-IPA_Extensions}', "");
    Expect(0, 687, '\P{Block=-IPA_Extensions}', "");
    Expect(1, 687, '\P{^Block=-IPA_Extensions}', "");
    Expect(0, 688, '\p{Block=-IPA_Extensions}', "");
    Expect(1, 688, '\p{^Block=-IPA_Extensions}', "");
    Expect(1, 688, '\P{Block=-IPA_Extensions}', "");
    Expect(0, 688, '\P{^Block=-IPA_Extensions}', "");
    Error('\p{Blk=/a/-	IPA_EXT}');
    Error('\P{Blk=/a/-	IPA_EXT}');
    Expect(1, 687, '\p{Blk=:\AIPA_Ext\z:}', "");;
    Expect(0, 688, '\p{Blk=:\AIPA_Ext\z:}', "");;
    Expect(1, 687, '\p{Blk=ipaext}', "");
    Expect(0, 687, '\p{^Blk=ipaext}', "");
    Expect(0, 687, '\P{Blk=ipaext}', "");
    Expect(1, 687, '\P{^Blk=ipaext}', "");
    Expect(0, 688, '\p{Blk=ipaext}', "");
    Expect(1, 688, '\p{^Blk=ipaext}', "");
    Expect(1, 688, '\P{Blk=ipaext}', "");
    Expect(0, 688, '\P{^Blk=ipaext}', "");
    Expect(1, 687, '\p{Blk=:\Aipaext\z:}', "");;
    Expect(0, 688, '\p{Blk=:\Aipaext\z:}', "");;
    Expect(1, 687, '\p{Blk=-ipa_EXT}', "");
    Expect(0, 687, '\p{^Blk=-ipa_EXT}', "");
    Expect(0, 687, '\P{Blk=-ipa_EXT}', "");
    Expect(1, 687, '\P{^Blk=-ipa_EXT}', "");
    Expect(0, 688, '\p{Blk=-ipa_EXT}', "");
    Expect(1, 688, '\p{^Blk=-ipa_EXT}', "");
    Expect(1, 688, '\P{Blk=-ipa_EXT}', "");
    Expect(0, 688, '\P{^Blk=-ipa_EXT}', "");
    Error('\p{Is_Block=:=_-IPA_extensions}');
    Error('\P{Is_Block=:=_-IPA_extensions}');
    Expect(1, 687, '\p{Is_Block:   ipaextensions}', "");
    Expect(0, 687, '\p{^Is_Block:   ipaextensions}', "");
    Expect(0, 687, '\P{Is_Block:   ipaextensions}', "");
    Expect(1, 687, '\P{^Is_Block:   ipaextensions}', "");
    Expect(0, 688, '\p{Is_Block:   ipaextensions}', "");
    Expect(1, 688, '\p{^Is_Block:   ipaextensions}', "");
    Expect(1, 688, '\P{Is_Block:   ipaextensions}', "");
    Expect(0, 688, '\P{^Is_Block:   ipaextensions}', "");
    Expect(1, 687, '\p{Is_Block=	-IPA_extensions}', "");
    Expect(0, 687, '\p{^Is_Block=	-IPA_extensions}', "");
    Expect(0, 687, '\P{Is_Block=	-IPA_extensions}', "");
    Expect(1, 687, '\P{^Is_Block=	-IPA_extensions}', "");
    Expect(0, 688, '\p{Is_Block=	-IPA_extensions}', "");
    Expect(1, 688, '\p{^Is_Block=	-IPA_extensions}', "");
    Expect(1, 688, '\P{Is_Block=	-IPA_extensions}', "");
    Expect(0, 688, '\P{^Is_Block=	-IPA_extensions}', "");
    Error('\p{Is_Blk=/a/_IPA_Ext}');
    Error('\P{Is_Blk=/a/_IPA_Ext}');
    Expect(1, 687, '\p{Is_Blk=ipaext}', "");
    Expect(0, 687, '\p{^Is_Blk=ipaext}', "");
    Expect(0, 687, '\P{Is_Blk=ipaext}', "");
    Expect(1, 687, '\P{^Is_Blk=ipaext}', "");
    Expect(0, 688, '\p{Is_Blk=ipaext}', "");
    Expect(1, 688, '\p{^Is_Blk=ipaext}', "");
    Expect(1, 688, '\P{Is_Blk=ipaext}', "");
    Expect(0, 688, '\P{^Is_Blk=ipaext}', "");
    Expect(1, 687, '\p{Is_Blk=-	IPA_EXT}', "");
    Expect(0, 687, '\p{^Is_Blk=-	IPA_EXT}', "");
    Expect(0, 687, '\P{Is_Blk=-	IPA_EXT}', "");
    Expect(1, 687, '\P{^Is_Blk=-	IPA_EXT}', "");
    Expect(0, 688, '\p{Is_Blk=-	IPA_EXT}', "");
    Expect(1, 688, '\p{^Is_Blk=-	IPA_EXT}', "");
    Expect(1, 688, '\P{Is_Blk=-	IPA_EXT}', "");
    Expect(0, 688, '\P{^Is_Blk=-	IPA_EXT}', "");
    Error('\p{Block=:=	Hangul_Jamo}');
    Error('\P{Block=:=	Hangul_Jamo}');
    Expect(1, 4607, '\p{Block=:\AHangul_Jamo\z:}', "");;
    Expect(0, 4608, '\p{Block=:\AHangul_Jamo\z:}', "");;
    Expect(1, 4607, '\p{Block=hanguljamo}', "");
    Expect(0, 4607, '\p{^Block=hanguljamo}', "");
    Expect(0, 4607, '\P{Block=hanguljamo}', "");
    Expect(1, 4607, '\P{^Block=hanguljamo}', "");
    Expect(0, 4608, '\p{Block=hanguljamo}', "");
    Expect(1, 4608, '\p{^Block=hanguljamo}', "");
    Expect(1, 4608, '\P{Block=hanguljamo}', "");
    Expect(0, 4608, '\P{^Block=hanguljamo}', "");
    Expect(1, 4607, '\p{Block=:\Ahanguljamo\z:}', "");;
    Expect(0, 4608, '\p{Block=:\Ahanguljamo\z:}', "");;
    Expect(1, 4607, '\p{Block= _Hangul_jamo}', "");
    Expect(0, 4607, '\p{^Block= _Hangul_jamo}', "");
    Expect(0, 4607, '\P{Block= _Hangul_jamo}', "");
    Expect(1, 4607, '\P{^Block= _Hangul_jamo}', "");
    Expect(0, 4608, '\p{Block= _Hangul_jamo}', "");
    Expect(1, 4608, '\p{^Block= _Hangul_jamo}', "");
    Expect(1, 4608, '\P{Block= _Hangul_jamo}', "");
    Expect(0, 4608, '\P{^Block= _Hangul_jamo}', "");
    Error('\p{Blk=-/a/Jamo}');
    Error('\P{Blk=-/a/Jamo}');
    Expect(1, 4607, '\p{Blk=:\AJamo\z:}', "");;
    Expect(0, 4608, '\p{Blk=:\AJamo\z:}', "");;
    Expect(1, 4607, '\p{Blk=jamo}', "");
    Expect(0, 4607, '\p{^Blk=jamo}', "");
    Expect(0, 4607, '\P{Blk=jamo}', "");
    Expect(1, 4607, '\P{^Blk=jamo}', "");
    Expect(0, 4608, '\p{Blk=jamo}', "");
    Expect(1, 4608, '\p{^Blk=jamo}', "");
    Expect(1, 4608, '\P{Blk=jamo}', "");
    Expect(0, 4608, '\P{^Blk=jamo}', "");
    Expect(1, 4607, '\p{Blk=:\Ajamo\z:}', "");;
    Expect(0, 4608, '\p{Blk=:\Ajamo\z:}', "");;
    Expect(1, 4607, '\p{Blk= _Jamo}', "");
    Expect(0, 4607, '\p{^Blk= _Jamo}', "");
    Expect(0, 4607, '\P{Blk= _Jamo}', "");
    Expect(1, 4607, '\P{^Blk= _Jamo}', "");
    Expect(0, 4608, '\p{Blk= _Jamo}', "");
    Expect(1, 4608, '\p{^Blk= _Jamo}', "");
    Expect(1, 4608, '\P{Blk= _Jamo}', "");
    Expect(0, 4608, '\P{^Blk= _Jamo}', "");
    Error('\p{Is_Block= :=hangul_JAMO}');
    Error('\P{Is_Block= :=hangul_JAMO}');
    Expect(1, 4607, '\p{Is_Block=hanguljamo}', "");
    Expect(0, 4607, '\p{^Is_Block=hanguljamo}', "");
    Expect(0, 4607, '\P{Is_Block=hanguljamo}', "");
    Expect(1, 4607, '\P{^Is_Block=hanguljamo}', "");
    Expect(0, 4608, '\p{Is_Block=hanguljamo}', "");
    Expect(1, 4608, '\p{^Is_Block=hanguljamo}', "");
    Expect(1, 4608, '\P{Is_Block=hanguljamo}', "");
    Expect(0, 4608, '\P{^Is_Block=hanguljamo}', "");
    Expect(1, 4607, '\p{Is_Block=-_hangul_jamo}', "");
    Expect(0, 4607, '\p{^Is_Block=-_hangul_jamo}', "");
    Expect(0, 4607, '\P{Is_Block=-_hangul_jamo}', "");
    Expect(1, 4607, '\P{^Is_Block=-_hangul_jamo}', "");
    Expect(0, 4608, '\p{Is_Block=-_hangul_jamo}', "");
    Expect(1, 4608, '\p{^Is_Block=-_hangul_jamo}', "");
    Expect(1, 4608, '\P{Is_Block=-_hangul_jamo}', "");
    Expect(0, 4608, '\P{^Is_Block=-_hangul_jamo}', "");
    Error('\p{Is_Blk=	:=Jamo}');
    Error('\P{Is_Blk=	:=Jamo}');
    Expect(1, 4607, '\p{Is_Blk=jamo}', "");
    Expect(0, 4607, '\p{^Is_Blk=jamo}', "");
    Expect(0, 4607, '\P{Is_Blk=jamo}', "");
    Expect(1, 4607, '\P{^Is_Blk=jamo}', "");
    Expect(0, 4608, '\p{Is_Blk=jamo}', "");
    Expect(1, 4608, '\p{^Is_Blk=jamo}', "");
    Expect(1, 4608, '\P{Is_Blk=jamo}', "");
    Expect(0, 4608, '\P{^Is_Blk=jamo}', "");
    Expect(1, 4607, '\p{Is_Blk=_-Jamo}', "");
    Expect(0, 4607, '\p{^Is_Blk=_-Jamo}', "");
    Expect(0, 4607, '\P{Is_Blk=_-Jamo}', "");
    Expect(1, 4607, '\P{^Is_Blk=_-Jamo}', "");
    Expect(0, 4608, '\p{Is_Blk=_-Jamo}', "");
    Expect(1, 4608, '\p{^Is_Blk=_-Jamo}', "");
    Expect(1, 4608, '\P{Is_Blk=_-Jamo}', "");
    Expect(0, 4608, '\P{^Is_Blk=_-Jamo}', "");
    Error('\p{Block=-Hangul_Jamo_EXTENDED_A:=}');
    Error('\P{Block=-Hangul_Jamo_EXTENDED_A:=}');
    Expect(1, 43391, '\p{Block=:\AHangul_Jamo_Extended_A\z:}', "");;
    Expect(0, 43392, '\p{Block=:\AHangul_Jamo_Extended_A\z:}', "");;
    Expect(1, 43391, '\p{Block=hanguljamoextendeda}', "");
    Expect(0, 43391, '\p{^Block=hanguljamoextendeda}', "");
    Expect(0, 43391, '\P{Block=hanguljamoextendeda}', "");
    Expect(1, 43391, '\P{^Block=hanguljamoextendeda}', "");
    Expect(0, 43392, '\p{Block=hanguljamoextendeda}', "");
    Expect(1, 43392, '\p{^Block=hanguljamoextendeda}', "");
    Expect(1, 43392, '\P{Block=hanguljamoextendeda}', "");
    Expect(0, 43392, '\P{^Block=hanguljamoextendeda}', "");
    Expect(1, 43391, '\p{Block=:\Ahanguljamoextendeda\z:}', "");;
    Expect(0, 43392, '\p{Block=:\Ahanguljamoextendeda\z:}', "");;
    Expect(1, 43391, '\p{Block= _hangul_JAMO_extended_A}', "");
    Expect(0, 43391, '\p{^Block= _hangul_JAMO_extended_A}', "");
    Expect(0, 43391, '\P{Block= _hangul_JAMO_extended_A}', "");
    Expect(1, 43391, '\P{^Block= _hangul_JAMO_extended_A}', "");
    Expect(0, 43392, '\p{Block= _hangul_JAMO_extended_A}', "");
    Expect(1, 43392, '\p{^Block= _hangul_JAMO_extended_A}', "");
    Expect(1, 43392, '\P{Block= _hangul_JAMO_extended_A}', "");
    Expect(0, 43392, '\P{^Block= _hangul_JAMO_extended_A}', "");
    Error('\p{Blk=:=	JAMO_Ext_A}');
    Error('\P{Blk=:=	JAMO_Ext_A}');
    Expect(1, 43391, '\p{Blk=:\AJamo_Ext_A\z:}', "");;
    Expect(0, 43392, '\p{Blk=:\AJamo_Ext_A\z:}', "");;
    Expect(1, 43391, '\p{Blk=jamoexta}', "");
    Expect(0, 43391, '\p{^Blk=jamoexta}', "");
    Expect(0, 43391, '\P{Blk=jamoexta}', "");
    Expect(1, 43391, '\P{^Blk=jamoexta}', "");
    Expect(0, 43392, '\p{Blk=jamoexta}', "");
    Expect(1, 43392, '\p{^Blk=jamoexta}', "");
    Expect(1, 43392, '\P{Blk=jamoexta}', "");
    Expect(0, 43392, '\P{^Blk=jamoexta}', "");
    Expect(1, 43391, '\p{Blk=:\Ajamoexta\z:}', "");;
    Expect(0, 43392, '\p{Blk=:\Ajamoexta\z:}', "");;
    Expect(1, 43391, '\p{Blk=__Jamo_Ext_a}', "");
    Expect(0, 43391, '\p{^Blk=__Jamo_Ext_a}', "");
    Expect(0, 43391, '\P{Blk=__Jamo_Ext_a}', "");
    Expect(1, 43391, '\P{^Blk=__Jamo_Ext_a}', "");
    Expect(0, 43392, '\p{Blk=__Jamo_Ext_a}', "");
    Expect(1, 43392, '\p{^Blk=__Jamo_Ext_a}', "");
    Expect(1, 43392, '\P{Blk=__Jamo_Ext_a}', "");
    Expect(0, 43392, '\P{^Blk=__Jamo_Ext_a}', "");
    Error('\p{Is_Block=/a/Hangul_JAMO_Extended_A}');
    Error('\P{Is_Block=/a/Hangul_JAMO_Extended_A}');
    Expect(1, 43391, '\p{Is_Block=hanguljamoextendeda}', "");
    Expect(0, 43391, '\p{^Is_Block=hanguljamoextendeda}', "");
    Expect(0, 43391, '\P{Is_Block=hanguljamoextendeda}', "");
    Expect(1, 43391, '\P{^Is_Block=hanguljamoextendeda}', "");
    Expect(0, 43392, '\p{Is_Block=hanguljamoextendeda}', "");
    Expect(1, 43392, '\p{^Is_Block=hanguljamoextendeda}', "");
    Expect(1, 43392, '\P{Is_Block=hanguljamoextendeda}', "");
    Expect(0, 43392, '\P{^Is_Block=hanguljamoextendeda}', "");
    Expect(1, 43391, '\p{Is_Block=_	Hangul_jamo_Extended_A}', "");
    Expect(0, 43391, '\p{^Is_Block=_	Hangul_jamo_Extended_A}', "");
    Expect(0, 43391, '\P{Is_Block=_	Hangul_jamo_Extended_A}', "");
    Expect(1, 43391, '\P{^Is_Block=_	Hangul_jamo_Extended_A}', "");
    Expect(0, 43392, '\p{Is_Block=_	Hangul_jamo_Extended_A}', "");
    Expect(1, 43392, '\p{^Is_Block=_	Hangul_jamo_Extended_A}', "");
    Expect(1, 43392, '\P{Is_Block=_	Hangul_jamo_Extended_A}', "");
    Expect(0, 43392, '\P{^Is_Block=_	Hangul_jamo_Extended_A}', "");
    Error('\p{Is_Blk:-:=Jamo_EXT_A}');
    Error('\P{Is_Blk:-:=Jamo_EXT_A}');
    Expect(1, 43391, '\p{Is_Blk=jamoexta}', "");
    Expect(0, 43391, '\p{^Is_Blk=jamoexta}', "");
    Expect(0, 43391, '\P{Is_Blk=jamoexta}', "");
    Expect(1, 43391, '\P{^Is_Blk=jamoexta}', "");
    Expect(0, 43392, '\p{Is_Blk=jamoexta}', "");
    Expect(1, 43392, '\p{^Is_Blk=jamoexta}', "");
    Expect(1, 43392, '\P{Is_Blk=jamoexta}', "");
    Expect(0, 43392, '\P{^Is_Blk=jamoexta}', "");
    Expect(1, 43391, '\p{Is_Blk=		JAMO_ext_A}', "");
    Expect(0, 43391, '\p{^Is_Blk=		JAMO_ext_A}', "");
    Expect(0, 43391, '\P{Is_Blk=		JAMO_ext_A}', "");
    Expect(1, 43391, '\P{^Is_Blk=		JAMO_ext_A}', "");
    Expect(0, 43392, '\p{Is_Blk=		JAMO_ext_A}', "");
    Expect(1, 43392, '\p{^Is_Blk=		JAMO_ext_A}', "");
    Expect(1, 43392, '\P{Is_Blk=		JAMO_ext_A}', "");
    Expect(0, 43392, '\P{^Is_Blk=		JAMO_ext_A}', "");
    Error('\p{Block=-HANGUL_Jamo_extended_b/a/}');
    Error('\P{Block=-HANGUL_Jamo_extended_b/a/}');
    Expect(1, 55295, '\p{Block=:\AHangul_Jamo_Extended_B\z:}', "");;
    Expect(0, 57344, '\p{Block=:\AHangul_Jamo_Extended_B\z:}', "");;
    Expect(1, 55295, '\p{Block=hanguljamoextendedb}', "");
    Expect(0, 55295, '\p{^Block=hanguljamoextendedb}', "");
    Expect(0, 55295, '\P{Block=hanguljamoextendedb}', "");
    Expect(1, 55295, '\P{^Block=hanguljamoextendedb}', "");
    Expect(0, 57344, '\p{Block=hanguljamoextendedb}', "");
    Expect(1, 57344, '\p{^Block=hanguljamoextendedb}', "");
    Expect(1, 57344, '\P{Block=hanguljamoextendedb}', "");
    Expect(0, 57344, '\P{^Block=hanguljamoextendedb}', "");
    Expect(1, 55295, '\p{Block=:\Ahanguljamoextendedb\z:}', "");;
    Expect(0, 57344, '\p{Block=:\Ahanguljamoextendedb\z:}', "");;
    Expect(1, 55295, '\p{Block=_ hangul_JAMO_extended_B}', "");
    Expect(0, 55295, '\p{^Block=_ hangul_JAMO_extended_B}', "");
    Expect(0, 55295, '\P{Block=_ hangul_JAMO_extended_B}', "");
    Expect(1, 55295, '\P{^Block=_ hangul_JAMO_extended_B}', "");
    Expect(0, 57344, '\p{Block=_ hangul_JAMO_extended_B}', "");
    Expect(1, 57344, '\p{^Block=_ hangul_JAMO_extended_B}', "");
    Expect(1, 57344, '\P{Block=_ hangul_JAMO_extended_B}', "");
    Expect(0, 57344, '\P{^Block=_ hangul_JAMO_extended_B}', "");
    Error('\p{Blk=:=jamo_ext_B}');
    Error('\P{Blk=:=jamo_ext_B}');
    Expect(1, 55295, '\p{Blk=:\AJamo_Ext_B\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\AJamo_Ext_B\z:}', "");;
    Expect(1, 55295, '\p{Blk=jamoextb}', "");
    Expect(0, 55295, '\p{^Blk=jamoextb}', "");
    Expect(0, 55295, '\P{Blk=jamoextb}', "");
    Expect(1, 55295, '\P{^Blk=jamoextb}', "");
    Expect(0, 57344, '\p{Blk=jamoextb}', "");
    Expect(1, 57344, '\p{^Blk=jamoextb}', "");
    Expect(1, 57344, '\P{Blk=jamoextb}', "");
    Expect(0, 57344, '\P{^Blk=jamoextb}', "");
    Expect(1, 55295, '\p{Blk=:\Ajamoextb\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\Ajamoextb\z:}', "");;
    Expect(1, 55295, '\p{Blk=_Jamo_Ext_B}', "");
    Expect(0, 55295, '\p{^Blk=_Jamo_Ext_B}', "");
    Expect(0, 55295, '\P{Blk=_Jamo_Ext_B}', "");
    Expect(1, 55295, '\P{^Blk=_Jamo_Ext_B}', "");
    Expect(0, 57344, '\p{Blk=_Jamo_Ext_B}', "");
    Expect(1, 57344, '\p{^Blk=_Jamo_Ext_B}', "");
    Expect(1, 57344, '\P{Blk=_Jamo_Ext_B}', "");
    Expect(0, 57344, '\P{^Blk=_Jamo_Ext_B}', "");
    Error('\p{Is_Block=_Hangul_JAMO_EXTENDED_B/a/}');
    Error('\P{Is_Block=_Hangul_JAMO_EXTENDED_B/a/}');
    Expect(1, 55295, '\p{Is_Block:hanguljamoextendedb}', "");
    Expect(0, 55295, '\p{^Is_Block:hanguljamoextendedb}', "");
    Expect(0, 55295, '\P{Is_Block:hanguljamoextendedb}', "");
    Expect(1, 55295, '\P{^Is_Block:hanguljamoextendedb}', "");
    Expect(0, 57344, '\p{Is_Block:hanguljamoextendedb}', "");
    Expect(1, 57344, '\p{^Is_Block:hanguljamoextendedb}', "");
    Expect(1, 57344, '\P{Is_Block:hanguljamoextendedb}', "");
    Expect(0, 57344, '\P{^Is_Block:hanguljamoextendedb}', "");
    Expect(1, 55295, '\p{Is_Block=_hangul_Jamo_Extended_B}', "");
    Expect(0, 55295, '\p{^Is_Block=_hangul_Jamo_Extended_B}', "");
    Expect(0, 55295, '\P{Is_Block=_hangul_Jamo_Extended_B}', "");
    Expect(1, 55295, '\P{^Is_Block=_hangul_Jamo_Extended_B}', "");
    Expect(0, 57344, '\p{Is_Block=_hangul_Jamo_Extended_B}', "");
    Expect(1, 57344, '\p{^Is_Block=_hangul_Jamo_Extended_B}', "");
    Expect(1, 57344, '\P{Is_Block=_hangul_Jamo_Extended_B}', "");
    Expect(0, 57344, '\P{^Is_Block=_hangul_Jamo_Extended_B}', "");
    Error('\p{Is_Blk=:=- Jamo_EXT_b}');
    Error('\P{Is_Blk=:=- Jamo_EXT_b}');
    Expect(1, 55295, '\p{Is_Blk=jamoextb}', "");
    Expect(0, 55295, '\p{^Is_Blk=jamoextb}', "");
    Expect(0, 55295, '\P{Is_Blk=jamoextb}', "");
    Expect(1, 55295, '\P{^Is_Blk=jamoextb}', "");
    Expect(0, 57344, '\p{Is_Blk=jamoextb}', "");
    Expect(1, 57344, '\p{^Is_Blk=jamoextb}', "");
    Expect(1, 57344, '\P{Is_Blk=jamoextb}', "");
    Expect(0, 57344, '\P{^Is_Blk=jamoextb}', "");
    Expect(1, 55295, '\p{Is_Blk=-	jamo_ext_B}', "");
    Expect(0, 55295, '\p{^Is_Blk=-	jamo_ext_B}', "");
    Expect(0, 55295, '\P{Is_Blk=-	jamo_ext_B}', "");
    Expect(1, 55295, '\P{^Is_Blk=-	jamo_ext_B}', "");
    Expect(0, 57344, '\p{Is_Blk=-	jamo_ext_B}', "");
    Expect(1, 57344, '\p{^Is_Blk=-	jamo_ext_B}', "");
    Expect(1, 57344, '\P{Is_Blk=-	jamo_ext_B}', "");
    Expect(0, 57344, '\P{^Is_Blk=-	jamo_ext_B}', "");
    Error('\p{Block=:=	 Javanese}');
    Error('\P{Block=:=	 Javanese}');
    Expect(1, 43487, '\p{Block=:\AJavanese\z:}', "");;
    Expect(0, 43488, '\p{Block=:\AJavanese\z:}', "");;
    Expect(1, 43487, '\p{Block=javanese}', "");
    Expect(0, 43487, '\p{^Block=javanese}', "");
    Expect(0, 43487, '\P{Block=javanese}', "");
    Expect(1, 43487, '\P{^Block=javanese}', "");
    Expect(0, 43488, '\p{Block=javanese}', "");
    Expect(1, 43488, '\p{^Block=javanese}', "");
    Expect(1, 43488, '\P{Block=javanese}', "");
    Expect(0, 43488, '\P{^Block=javanese}', "");
    Expect(1, 43487, '\p{Block=:\Ajavanese\z:}', "");;
    Expect(0, 43488, '\p{Block=:\Ajavanese\z:}', "");;
    Expect(1, 43487, '\p{Block=-Javanese}', "");
    Expect(0, 43487, '\p{^Block=-Javanese}', "");
    Expect(0, 43487, '\P{Block=-Javanese}', "");
    Expect(1, 43487, '\P{^Block=-Javanese}', "");
    Expect(0, 43488, '\p{Block=-Javanese}', "");
    Expect(1, 43488, '\p{^Block=-Javanese}', "");
    Expect(1, 43488, '\P{Block=-Javanese}', "");
    Expect(0, 43488, '\P{^Block=-Javanese}', "");
    Error('\p{Blk:	:=javanese}');
    Error('\P{Blk:	:=javanese}');
    Expect(1, 43487, '\p{Blk=:\AJavanese\z:}', "");;
    Expect(0, 43488, '\p{Blk=:\AJavanese\z:}', "");;
    Expect(1, 43487, '\p{Blk=javanese}', "");
    Expect(0, 43487, '\p{^Blk=javanese}', "");
    Expect(0, 43487, '\P{Blk=javanese}', "");
    Expect(1, 43487, '\P{^Blk=javanese}', "");
    Expect(0, 43488, '\p{Blk=javanese}', "");
    Expect(1, 43488, '\p{^Blk=javanese}', "");
    Expect(1, 43488, '\P{Blk=javanese}', "");
    Expect(0, 43488, '\P{^Blk=javanese}', "");
    Expect(1, 43487, '\p{Blk=:\Ajavanese\z:}', "");;
    Expect(0, 43488, '\p{Blk=:\Ajavanese\z:}', "");;
    Expect(1, 43487, '\p{Blk=		JAVANESE}', "");
    Expect(0, 43487, '\p{^Blk=		JAVANESE}', "");
    Expect(0, 43487, '\P{Blk=		JAVANESE}', "");
    Expect(1, 43487, '\P{^Blk=		JAVANESE}', "");
    Expect(0, 43488, '\p{Blk=		JAVANESE}', "");
    Expect(1, 43488, '\p{^Blk=		JAVANESE}', "");
    Expect(1, 43488, '\P{Blk=		JAVANESE}', "");
    Expect(0, 43488, '\P{^Blk=		JAVANESE}', "");
    Error('\p{Is_Block=_Javanese:=}');
    Error('\P{Is_Block=_Javanese:=}');
    Expect(1, 43487, '\p{Is_Block=javanese}', "");
    Expect(0, 43487, '\p{^Is_Block=javanese}', "");
    Expect(0, 43487, '\P{Is_Block=javanese}', "");
    Expect(1, 43487, '\P{^Is_Block=javanese}', "");
    Expect(0, 43488, '\p{Is_Block=javanese}', "");
    Expect(1, 43488, '\p{^Is_Block=javanese}', "");
    Expect(1, 43488, '\P{Is_Block=javanese}', "");
    Expect(0, 43488, '\P{^Is_Block=javanese}', "");
    Expect(1, 43487, '\p{Is_Block=-Javanese}', "");
    Expect(0, 43487, '\p{^Is_Block=-Javanese}', "");
    Expect(0, 43487, '\P{Is_Block=-Javanese}', "");
    Expect(1, 43487, '\P{^Is_Block=-Javanese}', "");
    Expect(0, 43488, '\p{Is_Block=-Javanese}', "");
    Expect(1, 43488, '\p{^Is_Block=-Javanese}', "");
    Expect(1, 43488, '\P{Is_Block=-Javanese}', "");
    Expect(0, 43488, '\P{^Is_Block=-Javanese}', "");
    Error('\p{Is_Blk:   _/a/JAVANESE}');
    Error('\P{Is_Blk:   _/a/JAVANESE}');
    Expect(1, 43487, '\p{Is_Blk=javanese}', "");
    Expect(0, 43487, '\p{^Is_Blk=javanese}', "");
    Expect(0, 43487, '\P{Is_Blk=javanese}', "");
    Expect(1, 43487, '\P{^Is_Blk=javanese}', "");
    Expect(0, 43488, '\p{Is_Blk=javanese}', "");
    Expect(1, 43488, '\p{^Is_Blk=javanese}', "");
    Expect(1, 43488, '\P{Is_Blk=javanese}', "");
    Expect(0, 43488, '\P{^Is_Blk=javanese}', "");
    Expect(1, 43487, '\p{Is_Blk=_javanese}', "");
    Expect(0, 43487, '\p{^Is_Blk=_javanese}', "");
    Expect(0, 43487, '\P{Is_Blk=_javanese}', "");
    Expect(1, 43487, '\P{^Is_Blk=_javanese}', "");
    Expect(0, 43488, '\p{Is_Blk=_javanese}', "");
    Expect(1, 43488, '\p{^Is_Blk=_javanese}', "");
    Expect(1, 43488, '\P{Is_Blk=_javanese}', "");
    Expect(0, 43488, '\P{^Is_Blk=_javanese}', "");
    Error('\p{Block=/a/KAITHI}');
    Error('\P{Block=/a/KAITHI}');
    Expect(1, 69839, '\p{Block=:\AKaithi\z:}', "");;
    Expect(0, 69840, '\p{Block=:\AKaithi\z:}', "");;
    Expect(1, 69839, '\p{Block=kaithi}', "");
    Expect(0, 69839, '\p{^Block=kaithi}', "");
    Expect(0, 69839, '\P{Block=kaithi}', "");
    Expect(1, 69839, '\P{^Block=kaithi}', "");
    Expect(0, 69840, '\p{Block=kaithi}', "");
    Expect(1, 69840, '\p{^Block=kaithi}', "");
    Expect(1, 69840, '\P{Block=kaithi}', "");
    Expect(0, 69840, '\P{^Block=kaithi}', "");
    Expect(1, 69839, '\p{Block=:\Akaithi\z:}', "");;
    Expect(0, 69840, '\p{Block=:\Akaithi\z:}', "");;
    Expect(1, 69839, '\p{Block=- KAITHI}', "");
    Expect(0, 69839, '\p{^Block=- KAITHI}', "");
    Expect(0, 69839, '\P{Block=- KAITHI}', "");
    Expect(1, 69839, '\P{^Block=- KAITHI}', "");
    Expect(0, 69840, '\p{Block=- KAITHI}', "");
    Expect(1, 69840, '\p{^Block=- KAITHI}', "");
    Expect(1, 69840, '\P{Block=- KAITHI}', "");
    Expect(0, 69840, '\P{^Block=- KAITHI}', "");
    Error('\p{Blk=	:=Kaithi}');
    Error('\P{Blk=	:=Kaithi}');
    Expect(1, 69839, '\p{Blk=:\AKaithi\z:}', "");;
    Expect(0, 69840, '\p{Blk=:\AKaithi\z:}', "");;
    Expect(1, 69839, '\p{Blk=kaithi}', "");
    Expect(0, 69839, '\p{^Blk=kaithi}', "");
    Expect(0, 69839, '\P{Blk=kaithi}', "");
    Expect(1, 69839, '\P{^Blk=kaithi}', "");
    Expect(0, 69840, '\p{Blk=kaithi}', "");
    Expect(1, 69840, '\p{^Blk=kaithi}', "");
    Expect(1, 69840, '\P{Blk=kaithi}', "");
    Expect(0, 69840, '\P{^Blk=kaithi}', "");
    Expect(1, 69839, '\p{Blk=:\Akaithi\z:}', "");;
    Expect(0, 69840, '\p{Blk=:\Akaithi\z:}', "");;
    Expect(1, 69839, '\p{Blk= _Kaithi}', "");
    Expect(0, 69839, '\p{^Blk= _Kaithi}', "");
    Expect(0, 69839, '\P{Blk= _Kaithi}', "");
    Expect(1, 69839, '\P{^Blk= _Kaithi}', "");
    Expect(0, 69840, '\p{Blk= _Kaithi}', "");
    Expect(1, 69840, '\p{^Blk= _Kaithi}', "");
    Expect(1, 69840, '\P{Blk= _Kaithi}', "");
    Expect(0, 69840, '\P{^Blk= _Kaithi}', "");
    Error('\p{Is_Block=:=Kaithi}');
    Error('\P{Is_Block=:=Kaithi}');
    Expect(1, 69839, '\p{Is_Block=kaithi}', "");
    Expect(0, 69839, '\p{^Is_Block=kaithi}', "");
    Expect(0, 69839, '\P{Is_Block=kaithi}', "");
    Expect(1, 69839, '\P{^Is_Block=kaithi}', "");
    Expect(0, 69840, '\p{Is_Block=kaithi}', "");
    Expect(1, 69840, '\p{^Is_Block=kaithi}', "");
    Expect(1, 69840, '\P{Is_Block=kaithi}', "");
    Expect(0, 69840, '\P{^Is_Block=kaithi}', "");
    Expect(1, 69839, '\p{Is_Block=_	kaithi}', "");
    Expect(0, 69839, '\p{^Is_Block=_	kaithi}', "");
    Expect(0, 69839, '\P{Is_Block=_	kaithi}', "");
    Expect(1, 69839, '\P{^Is_Block=_	kaithi}', "");
    Expect(0, 69840, '\p{Is_Block=_	kaithi}', "");
    Expect(1, 69840, '\p{^Is_Block=_	kaithi}', "");
    Expect(1, 69840, '\P{Is_Block=_	kaithi}', "");
    Expect(0, 69840, '\P{^Is_Block=_	kaithi}', "");
    Error('\p{Is_Blk=-:=KAITHI}');
    Error('\P{Is_Blk=-:=KAITHI}');
    Expect(1, 69839, '\p{Is_Blk=kaithi}', "");
    Expect(0, 69839, '\p{^Is_Blk=kaithi}', "");
    Expect(0, 69839, '\P{Is_Blk=kaithi}', "");
    Expect(1, 69839, '\P{^Is_Blk=kaithi}', "");
    Expect(0, 69840, '\p{Is_Blk=kaithi}', "");
    Expect(1, 69840, '\p{^Is_Blk=kaithi}', "");
    Expect(1, 69840, '\P{Is_Blk=kaithi}', "");
    Expect(0, 69840, '\P{^Is_Blk=kaithi}', "");
    Expect(1, 69839, '\p{Is_Blk=_-KAITHI}', "");
    Expect(0, 69839, '\p{^Is_Blk=_-KAITHI}', "");
    Expect(0, 69839, '\P{Is_Blk=_-KAITHI}', "");
    Expect(1, 69839, '\P{^Is_Blk=_-KAITHI}', "");
    Expect(0, 69840, '\p{Is_Blk=_-KAITHI}', "");
    Expect(1, 69840, '\p{^Is_Blk=_-KAITHI}', "");
    Expect(1, 69840, '\P{Is_Blk=_-KAITHI}', "");
    Expect(0, 69840, '\P{^Is_Blk=_-KAITHI}', "");
    Error('\p{Block=_Kana_Extended_A/a/}');
    Error('\P{Block=_Kana_Extended_A/a/}');
    Expect(1, 110895, '\p{Block=:\AKana_Extended_A\z:}', "");;
    Expect(0, 110896, '\p{Block=:\AKana_Extended_A\z:}', "");;
    Expect(1, 110895, '\p{Block=kanaextendeda}', "");
    Expect(0, 110895, '\p{^Block=kanaextendeda}', "");
    Expect(0, 110895, '\P{Block=kanaextendeda}', "");
    Expect(1, 110895, '\P{^Block=kanaextendeda}', "");
    Expect(0, 110896, '\p{Block=kanaextendeda}', "");
    Expect(1, 110896, '\p{^Block=kanaextendeda}', "");
    Expect(1, 110896, '\P{Block=kanaextendeda}', "");
    Expect(0, 110896, '\P{^Block=kanaextendeda}', "");
    Expect(1, 110895, '\p{Block=:\Akanaextendeda\z:}', "");;
    Expect(0, 110896, '\p{Block=:\Akanaextendeda\z:}', "");;
    Expect(1, 110895, '\p{Block=_Kana_extended_A}', "");
    Expect(0, 110895, '\p{^Block=_Kana_extended_A}', "");
    Expect(0, 110895, '\P{Block=_Kana_extended_A}', "");
    Expect(1, 110895, '\P{^Block=_Kana_extended_A}', "");
    Expect(0, 110896, '\p{Block=_Kana_extended_A}', "");
    Expect(1, 110896, '\p{^Block=_Kana_extended_A}', "");
    Expect(1, 110896, '\P{Block=_Kana_extended_A}', "");
    Expect(0, 110896, '\P{^Block=_Kana_extended_A}', "");
    Error('\p{Blk=--Kana_EXT_A/a/}');
    Error('\P{Blk=--Kana_EXT_A/a/}');
    Expect(1, 110895, '\p{Blk=:\AKana_Ext_A\z:}', "");;
    Expect(0, 110896, '\p{Blk=:\AKana_Ext_A\z:}', "");;
    Expect(1, 110895, '\p{Blk=kanaexta}', "");
    Expect(0, 110895, '\p{^Blk=kanaexta}', "");
    Expect(0, 110895, '\P{Blk=kanaexta}', "");
    Expect(1, 110895, '\P{^Blk=kanaexta}', "");
    Expect(0, 110896, '\p{Blk=kanaexta}', "");
    Expect(1, 110896, '\p{^Blk=kanaexta}', "");
    Expect(1, 110896, '\P{Blk=kanaexta}', "");
    Expect(0, 110896, '\P{^Blk=kanaexta}', "");
    Expect(1, 110895, '\p{Blk=:\Akanaexta\z:}', "");;
    Expect(0, 110896, '\p{Blk=:\Akanaexta\z:}', "");;
    Expect(1, 110895, '\p{Blk=-Kana_ext_A}', "");
    Expect(0, 110895, '\p{^Blk=-Kana_ext_A}', "");
    Expect(0, 110895, '\P{Blk=-Kana_ext_A}', "");
    Expect(1, 110895, '\P{^Blk=-Kana_ext_A}', "");
    Expect(0, 110896, '\p{Blk=-Kana_ext_A}', "");
    Expect(1, 110896, '\p{^Blk=-Kana_ext_A}', "");
    Expect(1, 110896, '\P{Blk=-Kana_ext_A}', "");
    Expect(0, 110896, '\P{^Blk=-Kana_ext_A}', "");
    Error('\p{Is_Block=	/a/kana_extended_A}');
    Error('\P{Is_Block=	/a/kana_extended_A}');
    Expect(1, 110895, '\p{Is_Block=kanaextendeda}', "");
    Expect(0, 110895, '\p{^Is_Block=kanaextendeda}', "");
    Expect(0, 110895, '\P{Is_Block=kanaextendeda}', "");
    Expect(1, 110895, '\P{^Is_Block=kanaextendeda}', "");
    Expect(0, 110896, '\p{Is_Block=kanaextendeda}', "");
    Expect(1, 110896, '\p{^Is_Block=kanaextendeda}', "");
    Expect(1, 110896, '\P{Is_Block=kanaextendeda}', "");
    Expect(0, 110896, '\P{^Is_Block=kanaextendeda}', "");
    Expect(1, 110895, '\p{Is_Block=_KANA_Extended_A}', "");
    Expect(0, 110895, '\p{^Is_Block=_KANA_Extended_A}', "");
    Expect(0, 110895, '\P{Is_Block=_KANA_Extended_A}', "");
    Expect(1, 110895, '\P{^Is_Block=_KANA_Extended_A}', "");
    Expect(0, 110896, '\p{Is_Block=_KANA_Extended_A}', "");
    Expect(1, 110896, '\p{^Is_Block=_KANA_Extended_A}', "");
    Expect(1, 110896, '\P{Is_Block=_KANA_Extended_A}', "");
    Expect(0, 110896, '\P{^Is_Block=_KANA_Extended_A}', "");
    Error('\p{Is_Blk= /a/Kana_EXT_A}');
    Error('\P{Is_Blk= /a/Kana_EXT_A}');
    Expect(1, 110895, '\p{Is_Blk=kanaexta}', "");
    Expect(0, 110895, '\p{^Is_Blk=kanaexta}', "");
    Expect(0, 110895, '\P{Is_Blk=kanaexta}', "");
    Expect(1, 110895, '\P{^Is_Blk=kanaexta}', "");
    Expect(0, 110896, '\p{Is_Blk=kanaexta}', "");
    Expect(1, 110896, '\p{^Is_Blk=kanaexta}', "");
    Expect(1, 110896, '\P{Is_Blk=kanaexta}', "");
    Expect(0, 110896, '\P{^Is_Blk=kanaexta}', "");
    Expect(1, 110895, '\p{Is_Blk=	Kana_Ext_A}', "");
    Expect(0, 110895, '\p{^Is_Blk=	Kana_Ext_A}', "");
    Expect(0, 110895, '\P{Is_Blk=	Kana_Ext_A}', "");
    Expect(1, 110895, '\P{^Is_Blk=	Kana_Ext_A}', "");
    Expect(0, 110896, '\p{Is_Blk=	Kana_Ext_A}', "");
    Expect(1, 110896, '\p{^Is_Blk=	Kana_Ext_A}', "");
    Expect(1, 110896, '\P{Is_Blk=	Kana_Ext_A}', "");
    Expect(0, 110896, '\P{^Is_Blk=	Kana_Ext_A}', "");
    Error('\p{Block= 	kana_Extended_B/a/}');
    Error('\P{Block= 	kana_Extended_B/a/}');
    Expect(1, 110591, '\p{Block=:\AKana_Extended_B\z:}', "");;
    Expect(0, 110592, '\p{Block=:\AKana_Extended_B\z:}', "");;
    Expect(1, 110591, '\p{Block=kanaextendedb}', "");
    Expect(0, 110591, '\p{^Block=kanaextendedb}', "");
    Expect(0, 110591, '\P{Block=kanaextendedb}', "");
    Expect(1, 110591, '\P{^Block=kanaextendedb}', "");
    Expect(0, 110592, '\p{Block=kanaextendedb}', "");
    Expect(1, 110592, '\p{^Block=kanaextendedb}', "");
    Expect(1, 110592, '\P{Block=kanaextendedb}', "");
    Expect(0, 110592, '\P{^Block=kanaextendedb}', "");
    Expect(1, 110591, '\p{Block=:\Akanaextendedb\z:}', "");;
    Expect(0, 110592, '\p{Block=:\Akanaextendedb\z:}', "");;
    Expect(1, 110591, '\p{Block=- kana_EXTENDED_B}', "");
    Expect(0, 110591, '\p{^Block=- kana_EXTENDED_B}', "");
    Expect(0, 110591, '\P{Block=- kana_EXTENDED_B}', "");
    Expect(1, 110591, '\P{^Block=- kana_EXTENDED_B}', "");
    Expect(0, 110592, '\p{Block=- kana_EXTENDED_B}', "");
    Expect(1, 110592, '\p{^Block=- kana_EXTENDED_B}', "");
    Expect(1, 110592, '\P{Block=- kana_EXTENDED_B}', "");
    Expect(0, 110592, '\P{^Block=- kana_EXTENDED_B}', "");
    Error('\p{Blk=/a/		KANA_EXT_b}');
    Error('\P{Blk=/a/		KANA_EXT_b}');
    Expect(1, 110591, '\p{Blk=:\AKana_Ext_B\z:}', "");;
    Expect(0, 110592, '\p{Blk=:\AKana_Ext_B\z:}', "");;
    Expect(1, 110591, '\p{Blk: kanaextb}', "");
    Expect(0, 110591, '\p{^Blk: kanaextb}', "");
    Expect(0, 110591, '\P{Blk: kanaextb}', "");
    Expect(1, 110591, '\P{^Blk: kanaextb}', "");
    Expect(0, 110592, '\p{Blk: kanaextb}', "");
    Expect(1, 110592, '\p{^Blk: kanaextb}', "");
    Expect(1, 110592, '\P{Blk: kanaextb}', "");
    Expect(0, 110592, '\P{^Blk: kanaextb}', "");
    Expect(1, 110591, '\p{Blk=:\Akanaextb\z:}', "");;
    Expect(0, 110592, '\p{Blk=:\Akanaextb\z:}', "");;
    Expect(1, 110591, '\p{Blk=_Kana_Ext_B}', "");
    Expect(0, 110591, '\p{^Blk=_Kana_Ext_B}', "");
    Expect(0, 110591, '\P{Blk=_Kana_Ext_B}', "");
    Expect(1, 110591, '\P{^Blk=_Kana_Ext_B}', "");
    Expect(0, 110592, '\p{Blk=_Kana_Ext_B}', "");
    Expect(1, 110592, '\p{^Blk=_Kana_Ext_B}', "");
    Expect(1, 110592, '\P{Blk=_Kana_Ext_B}', "");
    Expect(0, 110592, '\P{^Blk=_Kana_Ext_B}', "");
    Error('\p{Is_Block=-KANA_EXTENDED_B:=}');
    Error('\P{Is_Block=-KANA_EXTENDED_B:=}');
    Expect(1, 110591, '\p{Is_Block=kanaextendedb}', "");
    Expect(0, 110591, '\p{^Is_Block=kanaextendedb}', "");
    Expect(0, 110591, '\P{Is_Block=kanaextendedb}', "");
    Expect(1, 110591, '\P{^Is_Block=kanaextendedb}', "");
    Expect(0, 110592, '\p{Is_Block=kanaextendedb}', "");
    Expect(1, 110592, '\p{^Is_Block=kanaextendedb}', "");
    Expect(1, 110592, '\P{Is_Block=kanaextendedb}', "");
    Expect(0, 110592, '\P{^Is_Block=kanaextendedb}', "");
    Expect(1, 110591, '\p{Is_Block=-_kana_EXTENDED_B}', "");
    Expect(0, 110591, '\p{^Is_Block=-_kana_EXTENDED_B}', "");
    Expect(0, 110591, '\P{Is_Block=-_kana_EXTENDED_B}', "");
    Expect(1, 110591, '\P{^Is_Block=-_kana_EXTENDED_B}', "");
    Expect(0, 110592, '\p{Is_Block=-_kana_EXTENDED_B}', "");
    Expect(1, 110592, '\p{^Is_Block=-_kana_EXTENDED_B}', "");
    Expect(1, 110592, '\P{Is_Block=-_kana_EXTENDED_B}', "");
    Expect(0, 110592, '\P{^Is_Block=-_kana_EXTENDED_B}', "");
    Error('\p{Is_Blk: Kana_EXT_B/a/}');
    Error('\P{Is_Blk: Kana_EXT_B/a/}');
    Expect(1, 110591, '\p{Is_Blk=kanaextb}', "");
    Expect(0, 110591, '\p{^Is_Blk=kanaextb}', "");
    Expect(0, 110591, '\P{Is_Blk=kanaextb}', "");
    Expect(1, 110591, '\P{^Is_Blk=kanaextb}', "");
    Expect(0, 110592, '\p{Is_Blk=kanaextb}', "");
    Expect(1, 110592, '\p{^Is_Blk=kanaextb}', "");
    Expect(1, 110592, '\P{Is_Blk=kanaextb}', "");
    Expect(0, 110592, '\P{^Is_Blk=kanaextb}', "");
    Expect(1, 110591, '\p{Is_Blk=- kana_Ext_B}', "");
    Expect(0, 110591, '\p{^Is_Blk=- kana_Ext_B}', "");
    Expect(0, 110591, '\P{Is_Blk=- kana_Ext_B}', "");
    Expect(1, 110591, '\P{^Is_Blk=- kana_Ext_B}', "");
    Expect(0, 110592, '\p{Is_Blk=- kana_Ext_B}', "");
    Expect(1, 110592, '\p{^Is_Blk=- kana_Ext_B}', "");
    Expect(1, 110592, '\P{Is_Blk=- kana_Ext_B}', "");
    Expect(0, 110592, '\P{^Is_Blk=- kana_Ext_B}', "");
    Error('\p{Block=		Kana_Supplement:=}');
    Error('\P{Block=		Kana_Supplement:=}');
    Expect(1, 110847, '\p{Block=:\AKana_Supplement\z:}', "");;
    Expect(0, 110848, '\p{Block=:\AKana_Supplement\z:}', "");;
    Expect(1, 110847, '\p{Block=kanasupplement}', "");
    Expect(0, 110847, '\p{^Block=kanasupplement}', "");
    Expect(0, 110847, '\P{Block=kanasupplement}', "");
    Expect(1, 110847, '\P{^Block=kanasupplement}', "");
    Expect(0, 110848, '\p{Block=kanasupplement}', "");
    Expect(1, 110848, '\p{^Block=kanasupplement}', "");
    Expect(1, 110848, '\P{Block=kanasupplement}', "");
    Expect(0, 110848, '\P{^Block=kanasupplement}', "");
    Expect(1, 110847, '\p{Block=:\Akanasupplement\z:}', "");;
    Expect(0, 110848, '\p{Block=:\Akanasupplement\z:}', "");;
    Expect(1, 110847, '\p{Block= 	Kana_Supplement}', "");
    Expect(0, 110847, '\p{^Block= 	Kana_Supplement}', "");
    Expect(0, 110847, '\P{Block= 	Kana_Supplement}', "");
    Expect(1, 110847, '\P{^Block= 	Kana_Supplement}', "");
    Expect(0, 110848, '\p{Block= 	Kana_Supplement}', "");
    Expect(1, 110848, '\p{^Block= 	Kana_Supplement}', "");
    Expect(1, 110848, '\P{Block= 	Kana_Supplement}', "");
    Expect(0, 110848, '\P{^Block= 	Kana_Supplement}', "");
    Error('\p{Blk=	:=kana_sup}');
    Error('\P{Blk=	:=kana_sup}');
    Expect(1, 110847, '\p{Blk=:\AKana_Sup\z:}', "");;
    Expect(0, 110848, '\p{Blk=:\AKana_Sup\z:}', "");;
    Expect(1, 110847, '\p{Blk=kanasup}', "");
    Expect(0, 110847, '\p{^Blk=kanasup}', "");
    Expect(0, 110847, '\P{Blk=kanasup}', "");
    Expect(1, 110847, '\P{^Blk=kanasup}', "");
    Expect(0, 110848, '\p{Blk=kanasup}', "");
    Expect(1, 110848, '\p{^Blk=kanasup}', "");
    Expect(1, 110848, '\P{Blk=kanasup}', "");
    Expect(0, 110848, '\P{^Blk=kanasup}', "");
    Expect(1, 110847, '\p{Blk=:\Akanasup\z:}', "");;
    Expect(0, 110848, '\p{Blk=:\Akanasup\z:}', "");;
    Expect(1, 110847, '\p{Blk= _KANA_SUP}', "");
    Expect(0, 110847, '\p{^Blk= _KANA_SUP}', "");
    Expect(0, 110847, '\P{Blk= _KANA_SUP}', "");
    Expect(1, 110847, '\P{^Blk= _KANA_SUP}', "");
    Expect(0, 110848, '\p{Blk= _KANA_SUP}', "");
    Expect(1, 110848, '\p{^Blk= _KANA_SUP}', "");
    Expect(1, 110848, '\P{Blk= _KANA_SUP}', "");
    Expect(0, 110848, '\P{^Blk= _KANA_SUP}', "");
    Error('\p{Is_Block=	-Kana_SUPPLEMENT:=}');
    Error('\P{Is_Block=	-Kana_SUPPLEMENT:=}');
    Expect(1, 110847, '\p{Is_Block=kanasupplement}', "");
    Expect(0, 110847, '\p{^Is_Block=kanasupplement}', "");
    Expect(0, 110847, '\P{Is_Block=kanasupplement}', "");
    Expect(1, 110847, '\P{^Is_Block=kanasupplement}', "");
    Expect(0, 110848, '\p{Is_Block=kanasupplement}', "");
    Expect(1, 110848, '\p{^Is_Block=kanasupplement}', "");
    Expect(1, 110848, '\P{Is_Block=kanasupplement}', "");
    Expect(0, 110848, '\P{^Is_Block=kanasupplement}', "");
    Expect(1, 110847, '\p{Is_Block=	-kana_SUPPLEMENT}', "");
    Expect(0, 110847, '\p{^Is_Block=	-kana_SUPPLEMENT}', "");
    Expect(0, 110847, '\P{Is_Block=	-kana_SUPPLEMENT}', "");
    Expect(1, 110847, '\P{^Is_Block=	-kana_SUPPLEMENT}', "");
    Expect(0, 110848, '\p{Is_Block=	-kana_SUPPLEMENT}', "");
    Expect(1, 110848, '\p{^Is_Block=	-kana_SUPPLEMENT}', "");
    Expect(1, 110848, '\P{Is_Block=	-kana_SUPPLEMENT}', "");
    Expect(0, 110848, '\P{^Is_Block=	-kana_SUPPLEMENT}', "");
    Error('\p{Is_Blk= :=kana_SUP}');
    Error('\P{Is_Blk= :=kana_SUP}');
    Expect(1, 110847, '\p{Is_Blk=kanasup}', "");
    Expect(0, 110847, '\p{^Is_Blk=kanasup}', "");
    Expect(0, 110847, '\P{Is_Blk=kanasup}', "");
    Expect(1, 110847, '\P{^Is_Blk=kanasup}', "");
    Expect(0, 110848, '\p{Is_Blk=kanasup}', "");
    Expect(1, 110848, '\p{^Is_Blk=kanasup}', "");
    Expect(1, 110848, '\P{Is_Blk=kanasup}', "");
    Expect(0, 110848, '\P{^Is_Blk=kanasup}', "");
    Expect(1, 110847, '\p{Is_Blk=	KANA_SUP}', "");
    Expect(0, 110847, '\p{^Is_Blk=	KANA_SUP}', "");
    Expect(0, 110847, '\P{Is_Blk=	KANA_SUP}', "");
    Expect(1, 110847, '\P{^Is_Blk=	KANA_SUP}', "");
    Expect(0, 110848, '\p{Is_Blk=	KANA_SUP}', "");
    Expect(1, 110848, '\p{^Is_Blk=	KANA_SUP}', "");
    Expect(1, 110848, '\P{Is_Blk=	KANA_SUP}', "");
    Expect(0, 110848, '\P{^Is_Blk=	KANA_SUP}', "");
    Error('\p{Block: :=	Kanbun}');
    Error('\P{Block: :=	Kanbun}');
    Expect(1, 12703, '\p{Block=:\AKanbun\z:}', "");;
    Expect(0, 12704, '\p{Block=:\AKanbun\z:}', "");;
    Expect(1, 12703, '\p{Block=kanbun}', "");
    Expect(0, 12703, '\p{^Block=kanbun}', "");
    Expect(0, 12703, '\P{Block=kanbun}', "");
    Expect(1, 12703, '\P{^Block=kanbun}', "");
    Expect(0, 12704, '\p{Block=kanbun}', "");
    Expect(1, 12704, '\p{^Block=kanbun}', "");
    Expect(1, 12704, '\P{Block=kanbun}', "");
    Expect(0, 12704, '\P{^Block=kanbun}', "");
    Expect(1, 12703, '\p{Block=:\Akanbun\z:}', "");;
    Expect(0, 12704, '\p{Block=:\Akanbun\z:}', "");;
    Expect(1, 12703, '\p{Block= 	Kanbun}', "");
    Expect(0, 12703, '\p{^Block= 	Kanbun}', "");
    Expect(0, 12703, '\P{Block= 	Kanbun}', "");
    Expect(1, 12703, '\P{^Block= 	Kanbun}', "");
    Expect(0, 12704, '\p{Block= 	Kanbun}', "");
    Expect(1, 12704, '\p{^Block= 	Kanbun}', "");
    Expect(1, 12704, '\P{Block= 	Kanbun}', "");
    Expect(0, 12704, '\P{^Block= 	Kanbun}', "");
    Error('\p{Blk= 	kanbun/a/}');
    Error('\P{Blk= 	kanbun/a/}');
    Expect(1, 12703, '\p{Blk=:\AKanbun\z:}', "");;
    Expect(0, 12704, '\p{Blk=:\AKanbun\z:}', "");;
    Expect(1, 12703, '\p{Blk=kanbun}', "");
    Expect(0, 12703, '\p{^Blk=kanbun}', "");
    Expect(0, 12703, '\P{Blk=kanbun}', "");
    Expect(1, 12703, '\P{^Blk=kanbun}', "");
    Expect(0, 12704, '\p{Blk=kanbun}', "");
    Expect(1, 12704, '\p{^Blk=kanbun}', "");
    Expect(1, 12704, '\P{Blk=kanbun}', "");
    Expect(0, 12704, '\P{^Blk=kanbun}', "");
    Expect(1, 12703, '\p{Blk=:\Akanbun\z:}', "");;
    Expect(0, 12704, '\p{Blk=:\Akanbun\z:}', "");;
    Expect(1, 12703, '\p{Blk=Kanbun}', "");
    Expect(0, 12703, '\p{^Blk=Kanbun}', "");
    Expect(0, 12703, '\P{Blk=Kanbun}', "");
    Expect(1, 12703, '\P{^Blk=Kanbun}', "");
    Expect(0, 12704, '\p{Blk=Kanbun}', "");
    Expect(1, 12704, '\p{^Blk=Kanbun}', "");
    Expect(1, 12704, '\P{Blk=Kanbun}', "");
    Expect(0, 12704, '\P{^Blk=Kanbun}', "");
    Error('\p{Is_Block=	 Kanbun:=}');
    Error('\P{Is_Block=	 Kanbun:=}');
    Expect(1, 12703, '\p{Is_Block=kanbun}', "");
    Expect(0, 12703, '\p{^Is_Block=kanbun}', "");
    Expect(0, 12703, '\P{Is_Block=kanbun}', "");
    Expect(1, 12703, '\P{^Is_Block=kanbun}', "");
    Expect(0, 12704, '\p{Is_Block=kanbun}', "");
    Expect(1, 12704, '\p{^Is_Block=kanbun}', "");
    Expect(1, 12704, '\P{Is_Block=kanbun}', "");
    Expect(0, 12704, '\P{^Is_Block=kanbun}', "");
    Expect(1, 12703, '\p{Is_Block=_ Kanbun}', "");
    Expect(0, 12703, '\p{^Is_Block=_ Kanbun}', "");
    Expect(0, 12703, '\P{Is_Block=_ Kanbun}', "");
    Expect(1, 12703, '\P{^Is_Block=_ Kanbun}', "");
    Expect(0, 12704, '\p{Is_Block=_ Kanbun}', "");
    Expect(1, 12704, '\p{^Is_Block=_ Kanbun}', "");
    Expect(1, 12704, '\P{Is_Block=_ Kanbun}', "");
    Expect(0, 12704, '\P{^Is_Block=_ Kanbun}', "");
    Error('\p{Is_Blk=/a/_ Kanbun}');
    Error('\P{Is_Blk=/a/_ Kanbun}');
    Expect(1, 12703, '\p{Is_Blk=kanbun}', "");
    Expect(0, 12703, '\p{^Is_Blk=kanbun}', "");
    Expect(0, 12703, '\P{Is_Blk=kanbun}', "");
    Expect(1, 12703, '\P{^Is_Blk=kanbun}', "");
    Expect(0, 12704, '\p{Is_Blk=kanbun}', "");
    Expect(1, 12704, '\p{^Is_Blk=kanbun}', "");
    Expect(1, 12704, '\P{Is_Blk=kanbun}', "");
    Expect(0, 12704, '\P{^Is_Blk=kanbun}', "");
    Expect(1, 12703, '\p{Is_Blk=	Kanbun}', "");
    Expect(0, 12703, '\p{^Is_Blk=	Kanbun}', "");
    Expect(0, 12703, '\P{Is_Blk=	Kanbun}', "");
    Expect(1, 12703, '\P{^Is_Blk=	Kanbun}', "");
    Expect(0, 12704, '\p{Is_Blk=	Kanbun}', "");
    Expect(1, 12704, '\p{^Is_Blk=	Kanbun}', "");
    Expect(1, 12704, '\P{Is_Blk=	Kanbun}', "");
    Expect(0, 12704, '\P{^Is_Blk=	Kanbun}', "");
    Error('\p{Block=:=__Kangxi_RADICALS}');
    Error('\P{Block=:=__Kangxi_RADICALS}');
    Expect(1, 12255, '\p{Block=:\AKangxi_Radicals\z:}', "");;
    Expect(0, 12256, '\p{Block=:\AKangxi_Radicals\z:}', "");;
    Expect(1, 12255, '\p{Block:   kangxiradicals}', "");
    Expect(0, 12255, '\p{^Block:   kangxiradicals}', "");
    Expect(0, 12255, '\P{Block:   kangxiradicals}', "");
    Expect(1, 12255, '\P{^Block:   kangxiradicals}', "");
    Expect(0, 12256, '\p{Block:   kangxiradicals}', "");
    Expect(1, 12256, '\p{^Block:   kangxiradicals}', "");
    Expect(1, 12256, '\P{Block:   kangxiradicals}', "");
    Expect(0, 12256, '\P{^Block:   kangxiradicals}', "");
    Expect(1, 12255, '\p{Block=:\Akangxiradicals\z:}', "");;
    Expect(0, 12256, '\p{Block=:\Akangxiradicals\z:}', "");;
    Expect(1, 12255, '\p{Block=-Kangxi_Radicals}', "");
    Expect(0, 12255, '\p{^Block=-Kangxi_Radicals}', "");
    Expect(0, 12255, '\P{Block=-Kangxi_Radicals}', "");
    Expect(1, 12255, '\P{^Block=-Kangxi_Radicals}', "");
    Expect(0, 12256, '\p{Block=-Kangxi_Radicals}', "");
    Expect(1, 12256, '\p{^Block=-Kangxi_Radicals}', "");
    Expect(1, 12256, '\P{Block=-Kangxi_Radicals}', "");
    Expect(0, 12256, '\P{^Block=-Kangxi_Radicals}', "");
    Error('\p{Blk=-:=kangxi}');
    Error('\P{Blk=-:=kangxi}');
    Expect(1, 12255, '\p{Blk=:\AKangxi\z:}', "");;
    Expect(0, 12256, '\p{Blk=:\AKangxi\z:}', "");;
    Expect(1, 12255, '\p{Blk=kangxi}', "");
    Expect(0, 12255, '\p{^Blk=kangxi}', "");
    Expect(0, 12255, '\P{Blk=kangxi}', "");
    Expect(1, 12255, '\P{^Blk=kangxi}', "");
    Expect(0, 12256, '\p{Blk=kangxi}', "");
    Expect(1, 12256, '\p{^Blk=kangxi}', "");
    Expect(1, 12256, '\P{Blk=kangxi}', "");
    Expect(0, 12256, '\P{^Blk=kangxi}', "");
    Expect(1, 12255, '\p{Blk=:\Akangxi\z:}', "");;
    Expect(0, 12256, '\p{Blk=:\Akangxi\z:}', "");;
    Expect(1, 12255, '\p{Blk=	_kangxi}', "");
    Expect(0, 12255, '\p{^Blk=	_kangxi}', "");
    Expect(0, 12255, '\P{Blk=	_kangxi}', "");
    Expect(1, 12255, '\P{^Blk=	_kangxi}', "");
    Expect(0, 12256, '\p{Blk=	_kangxi}', "");
    Expect(1, 12256, '\p{^Blk=	_kangxi}', "");
    Expect(1, 12256, '\P{Blk=	_kangxi}', "");
    Expect(0, 12256, '\P{^Blk=	_kangxi}', "");
    Error('\p{Is_Block= 	Kangxi_radicals:=}');
    Error('\P{Is_Block= 	Kangxi_radicals:=}');
    Expect(1, 12255, '\p{Is_Block=kangxiradicals}', "");
    Expect(0, 12255, '\p{^Is_Block=kangxiradicals}', "");
    Expect(0, 12255, '\P{Is_Block=kangxiradicals}', "");
    Expect(1, 12255, '\P{^Is_Block=kangxiradicals}', "");
    Expect(0, 12256, '\p{Is_Block=kangxiradicals}', "");
    Expect(1, 12256, '\p{^Is_Block=kangxiradicals}', "");
    Expect(1, 12256, '\P{Is_Block=kangxiradicals}', "");
    Expect(0, 12256, '\P{^Is_Block=kangxiradicals}', "");
    Expect(1, 12255, '\p{Is_Block=-kangxi_radicals}', "");
    Expect(0, 12255, '\p{^Is_Block=-kangxi_radicals}', "");
    Expect(0, 12255, '\P{Is_Block=-kangxi_radicals}', "");
    Expect(1, 12255, '\P{^Is_Block=-kangxi_radicals}', "");
    Expect(0, 12256, '\p{Is_Block=-kangxi_radicals}', "");
    Expect(1, 12256, '\p{^Is_Block=-kangxi_radicals}', "");
    Expect(1, 12256, '\P{Is_Block=-kangxi_radicals}', "");
    Expect(0, 12256, '\P{^Is_Block=-kangxi_radicals}', "");
    Error('\p{Is_Blk= _KANGXI/a/}');
    Error('\P{Is_Blk= _KANGXI/a/}');
    Expect(1, 12255, '\p{Is_Blk=kangxi}', "");
    Expect(0, 12255, '\p{^Is_Blk=kangxi}', "");
    Expect(0, 12255, '\P{Is_Blk=kangxi}', "");
    Expect(1, 12255, '\P{^Is_Blk=kangxi}', "");
    Expect(0, 12256, '\p{Is_Blk=kangxi}', "");
    Expect(1, 12256, '\p{^Is_Blk=kangxi}', "");
    Expect(1, 12256, '\P{Is_Blk=kangxi}', "");
    Expect(0, 12256, '\P{^Is_Blk=kangxi}', "");
    Expect(1, 12255, '\p{Is_Blk=	KANGXI}', "");
    Expect(0, 12255, '\p{^Is_Blk=	KANGXI}', "");
    Expect(0, 12255, '\P{Is_Blk=	KANGXI}', "");
    Expect(1, 12255, '\P{^Is_Blk=	KANGXI}', "");
    Expect(0, 12256, '\p{Is_Blk=	KANGXI}', "");
    Expect(1, 12256, '\p{^Is_Blk=	KANGXI}', "");
    Expect(1, 12256, '\P{Is_Blk=	KANGXI}', "");
    Expect(0, 12256, '\P{^Is_Blk=	KANGXI}', "");
    Error('\p{Block=/a/kannada}');
    Error('\P{Block=/a/kannada}');
    Expect(1, 3327, '\p{Block=:\AKannada\z:}', "");;
    Expect(0, 3328, '\p{Block=:\AKannada\z:}', "");;
    Expect(1, 3327, '\p{Block=kannada}', "");
    Expect(0, 3327, '\p{^Block=kannada}', "");
    Expect(0, 3327, '\P{Block=kannada}', "");
    Expect(1, 3327, '\P{^Block=kannada}', "");
    Expect(0, 3328, '\p{Block=kannada}', "");
    Expect(1, 3328, '\p{^Block=kannada}', "");
    Expect(1, 3328, '\P{Block=kannada}', "");
    Expect(0, 3328, '\P{^Block=kannada}', "");
    Expect(1, 3327, '\p{Block=:\Akannada\z:}', "");;
    Expect(0, 3328, '\p{Block=:\Akannada\z:}', "");;
    Expect(1, 3327, '\p{Block= -Kannada}', "");
    Expect(0, 3327, '\p{^Block= -Kannada}', "");
    Expect(0, 3327, '\P{Block= -Kannada}', "");
    Expect(1, 3327, '\P{^Block= -Kannada}', "");
    Expect(0, 3328, '\p{Block= -Kannada}', "");
    Expect(1, 3328, '\p{^Block= -Kannada}', "");
    Expect(1, 3328, '\P{Block= -Kannada}', "");
    Expect(0, 3328, '\P{^Block= -Kannada}', "");
    Error('\p{Blk=_Kannada:=}');
    Error('\P{Blk=_Kannada:=}');
    Expect(1, 3327, '\p{Blk=:\AKannada\z:}', "");;
    Expect(0, 3328, '\p{Blk=:\AKannada\z:}', "");;
    Expect(1, 3327, '\p{Blk=kannada}', "");
    Expect(0, 3327, '\p{^Blk=kannada}', "");
    Expect(0, 3327, '\P{Blk=kannada}', "");
    Expect(1, 3327, '\P{^Blk=kannada}', "");
    Expect(0, 3328, '\p{Blk=kannada}', "");
    Expect(1, 3328, '\p{^Blk=kannada}', "");
    Expect(1, 3328, '\P{Blk=kannada}', "");
    Expect(0, 3328, '\P{^Blk=kannada}', "");
    Expect(1, 3327, '\p{Blk=:\Akannada\z:}', "");;
    Expect(0, 3328, '\p{Blk=:\Akannada\z:}', "");;
    Expect(1, 3327, '\p{Blk=-	kannada}', "");
    Expect(0, 3327, '\p{^Blk=-	kannada}', "");
    Expect(0, 3327, '\P{Blk=-	kannada}', "");
    Expect(1, 3327, '\P{^Blk=-	kannada}', "");
    Expect(0, 3328, '\p{Blk=-	kannada}', "");
    Expect(1, 3328, '\p{^Blk=-	kannada}', "");
    Expect(1, 3328, '\P{Blk=-	kannada}', "");
    Expect(0, 3328, '\P{^Blk=-	kannada}', "");
    Error('\p{Is_Block=/a/ _KANNADA}');
    Error('\P{Is_Block=/a/ _KANNADA}');
    Expect(1, 3327, '\p{Is_Block=kannada}', "");
    Expect(0, 3327, '\p{^Is_Block=kannada}', "");
    Expect(0, 3327, '\P{Is_Block=kannada}', "");
    Expect(1, 3327, '\P{^Is_Block=kannada}', "");
    Expect(0, 3328, '\p{Is_Block=kannada}', "");
    Expect(1, 3328, '\p{^Is_Block=kannada}', "");
    Expect(1, 3328, '\P{Is_Block=kannada}', "");
    Expect(0, 3328, '\P{^Is_Block=kannada}', "");
    Expect(1, 3327, '\p{Is_Block=--KANNADA}', "");
    Expect(0, 3327, '\p{^Is_Block=--KANNADA}', "");
    Expect(0, 3327, '\P{Is_Block=--KANNADA}', "");
    Expect(1, 3327, '\P{^Is_Block=--KANNADA}', "");
    Expect(0, 3328, '\p{Is_Block=--KANNADA}', "");
    Expect(1, 3328, '\p{^Is_Block=--KANNADA}', "");
    Expect(1, 3328, '\P{Is_Block=--KANNADA}', "");
    Expect(0, 3328, '\P{^Is_Block=--KANNADA}', "");
    Error('\p{Is_Blk=	kannada/a/}');
    Error('\P{Is_Blk=	kannada/a/}');
    Expect(1, 3327, '\p{Is_Blk=kannada}', "");
    Expect(0, 3327, '\p{^Is_Blk=kannada}', "");
    Expect(0, 3327, '\P{Is_Blk=kannada}', "");
    Expect(1, 3327, '\P{^Is_Blk=kannada}', "");
    Expect(0, 3328, '\p{Is_Blk=kannada}', "");
    Expect(1, 3328, '\p{^Is_Blk=kannada}', "");
    Expect(1, 3328, '\P{Is_Blk=kannada}', "");
    Expect(0, 3328, '\P{^Is_Blk=kannada}', "");
    Expect(1, 3327, '\p{Is_Blk:	 	Kannada}', "");
    Expect(0, 3327, '\p{^Is_Blk:	 	Kannada}', "");
    Expect(0, 3327, '\P{Is_Blk:	 	Kannada}', "");
    Expect(1, 3327, '\P{^Is_Blk:	 	Kannada}', "");
    Expect(0, 3328, '\p{Is_Blk:	 	Kannada}', "");
    Expect(1, 3328, '\p{^Is_Blk:	 	Kannada}', "");
    Expect(1, 3328, '\P{Is_Blk:	 	Kannada}', "");
    Expect(0, 3328, '\P{^Is_Blk:	 	Kannada}', "");
    Error('\p{Block=/a/katakana}');
    Error('\P{Block=/a/katakana}');
    Expect(1, 12543, '\p{Block=:\AKatakana\z:}', "");;
    Expect(0, 12544, '\p{Block=:\AKatakana\z:}', "");;
    Expect(1, 12543, '\p{Block=katakana}', "");
    Expect(0, 12543, '\p{^Block=katakana}', "");
    Expect(0, 12543, '\P{Block=katakana}', "");
    Expect(1, 12543, '\P{^Block=katakana}', "");
    Expect(0, 12544, '\p{Block=katakana}', "");
    Expect(1, 12544, '\p{^Block=katakana}', "");
    Expect(1, 12544, '\P{Block=katakana}', "");
    Expect(0, 12544, '\P{^Block=katakana}', "");
    Expect(1, 12543, '\p{Block=:\Akatakana\z:}', "");;
    Expect(0, 12544, '\p{Block=:\Akatakana\z:}', "");;
    Expect(1, 12543, '\p{Block=	_Katakana}', "");
    Expect(0, 12543, '\p{^Block=	_Katakana}', "");
    Expect(0, 12543, '\P{Block=	_Katakana}', "");
    Expect(1, 12543, '\P{^Block=	_Katakana}', "");
    Expect(0, 12544, '\p{Block=	_Katakana}', "");
    Expect(1, 12544, '\p{^Block=	_Katakana}', "");
    Expect(1, 12544, '\P{Block=	_Katakana}', "");
    Expect(0, 12544, '\P{^Block=	_Katakana}', "");
    Error('\p{Blk=katakana:=}');
    Error('\P{Blk=katakana:=}');
    Expect(1, 12543, '\p{Blk=:\AKatakana\z:}', "");;
    Expect(0, 12544, '\p{Blk=:\AKatakana\z:}', "");;
    Expect(1, 12543, '\p{Blk=katakana}', "");
    Expect(0, 12543, '\p{^Blk=katakana}', "");
    Expect(0, 12543, '\P{Blk=katakana}', "");
    Expect(1, 12543, '\P{^Blk=katakana}', "");
    Expect(0, 12544, '\p{Blk=katakana}', "");
    Expect(1, 12544, '\p{^Blk=katakana}', "");
    Expect(1, 12544, '\P{Blk=katakana}', "");
    Expect(0, 12544, '\P{^Blk=katakana}', "");
    Expect(1, 12543, '\p{Blk=:\Akatakana\z:}', "");;
    Expect(0, 12544, '\p{Blk=:\Akatakana\z:}', "");;
    Expect(1, 12543, '\p{Blk=__Katakana}', "");
    Expect(0, 12543, '\p{^Blk=__Katakana}', "");
    Expect(0, 12543, '\P{Blk=__Katakana}', "");
    Expect(1, 12543, '\P{^Blk=__Katakana}', "");
    Expect(0, 12544, '\p{Blk=__Katakana}', "");
    Expect(1, 12544, '\p{^Blk=__Katakana}', "");
    Expect(1, 12544, '\P{Blk=__Katakana}', "");
    Expect(0, 12544, '\P{^Blk=__Katakana}', "");
    Error('\p{Is_Block=/a/  KATAKANA}');
    Error('\P{Is_Block=/a/  KATAKANA}');
    Expect(1, 12543, '\p{Is_Block=katakana}', "");
    Expect(0, 12543, '\p{^Is_Block=katakana}', "");
    Expect(0, 12543, '\P{Is_Block=katakana}', "");
    Expect(1, 12543, '\P{^Is_Block=katakana}', "");
    Expect(0, 12544, '\p{Is_Block=katakana}', "");
    Expect(1, 12544, '\p{^Is_Block=katakana}', "");
    Expect(1, 12544, '\P{Is_Block=katakana}', "");
    Expect(0, 12544, '\P{^Is_Block=katakana}', "");
    Expect(1, 12543, '\p{Is_Block=  Katakana}', "");
    Expect(0, 12543, '\p{^Is_Block=  Katakana}', "");
    Expect(0, 12543, '\P{Is_Block=  Katakana}', "");
    Expect(1, 12543, '\P{^Is_Block=  Katakana}', "");
    Expect(0, 12544, '\p{Is_Block=  Katakana}', "");
    Expect(1, 12544, '\p{^Is_Block=  Katakana}', "");
    Expect(1, 12544, '\P{Is_Block=  Katakana}', "");
    Expect(0, 12544, '\P{^Is_Block=  Katakana}', "");
    Error('\p{Is_Blk=- katakana:=}');
    Error('\P{Is_Blk=- katakana:=}');
    Expect(1, 12543, '\p{Is_Blk=katakana}', "");
    Expect(0, 12543, '\p{^Is_Blk=katakana}', "");
    Expect(0, 12543, '\P{Is_Blk=katakana}', "");
    Expect(1, 12543, '\P{^Is_Blk=katakana}', "");
    Expect(0, 12544, '\p{Is_Blk=katakana}', "");
    Expect(1, 12544, '\p{^Is_Blk=katakana}', "");
    Expect(1, 12544, '\P{Is_Blk=katakana}', "");
    Expect(0, 12544, '\P{^Is_Blk=katakana}', "");
    Expect(1, 12543, '\p{Is_Blk=	_Katakana}', "");
    Expect(0, 12543, '\p{^Is_Blk=	_Katakana}', "");
    Expect(0, 12543, '\P{Is_Blk=	_Katakana}', "");
    Expect(1, 12543, '\P{^Is_Blk=	_Katakana}', "");
    Expect(0, 12544, '\p{Is_Blk=	_Katakana}', "");
    Expect(1, 12544, '\p{^Is_Blk=	_Katakana}', "");
    Expect(1, 12544, '\P{Is_Blk=	_Katakana}', "");
    Expect(0, 12544, '\P{^Is_Blk=	_Katakana}', "");
    Error('\p{Block=:=_ Katakana_Phonetic_EXTENSIONS}');
    Error('\P{Block=:=_ Katakana_Phonetic_EXTENSIONS}');
    Expect(1, 12799, '\p{Block=:\AKatakana_Phonetic_Extensions\z:}', "");;
    Expect(0, 12800, '\p{Block=:\AKatakana_Phonetic_Extensions\z:}', "");;
    Expect(1, 12799, '\p{Block=katakanaphoneticextensions}', "");
    Expect(0, 12799, '\p{^Block=katakanaphoneticextensions}', "");
    Expect(0, 12799, '\P{Block=katakanaphoneticextensions}', "");
    Expect(1, 12799, '\P{^Block=katakanaphoneticextensions}', "");
    Expect(0, 12800, '\p{Block=katakanaphoneticextensions}', "");
    Expect(1, 12800, '\p{^Block=katakanaphoneticextensions}', "");
    Expect(1, 12800, '\P{Block=katakanaphoneticextensions}', "");
    Expect(0, 12800, '\P{^Block=katakanaphoneticextensions}', "");
    Expect(1, 12799, '\p{Block=:\Akatakanaphoneticextensions\z:}', "");;
    Expect(0, 12800, '\p{Block=:\Akatakanaphoneticextensions\z:}', "");;
    Expect(1, 12799, '\p{Block=-_KATAKANA_Phonetic_Extensions}', "");
    Expect(0, 12799, '\p{^Block=-_KATAKANA_Phonetic_Extensions}', "");
    Expect(0, 12799, '\P{Block=-_KATAKANA_Phonetic_Extensions}', "");
    Expect(1, 12799, '\P{^Block=-_KATAKANA_Phonetic_Extensions}', "");
    Expect(0, 12800, '\p{Block=-_KATAKANA_Phonetic_Extensions}', "");
    Expect(1, 12800, '\p{^Block=-_KATAKANA_Phonetic_Extensions}', "");
    Expect(1, 12800, '\P{Block=-_KATAKANA_Phonetic_Extensions}', "");
    Expect(0, 12800, '\P{^Block=-_KATAKANA_Phonetic_Extensions}', "");
    Error('\p{Blk=:=-_katakana_EXT}');
    Error('\P{Blk=:=-_katakana_EXT}');
    Expect(1, 12799, '\p{Blk=:\AKatakana_Ext\z:}', "");;
    Expect(0, 12800, '\p{Blk=:\AKatakana_Ext\z:}', "");;
    Expect(1, 12799, '\p{Blk=katakanaext}', "");
    Expect(0, 12799, '\p{^Blk=katakanaext}', "");
    Expect(0, 12799, '\P{Blk=katakanaext}', "");
    Expect(1, 12799, '\P{^Blk=katakanaext}', "");
    Expect(0, 12800, '\p{Blk=katakanaext}', "");
    Expect(1, 12800, '\p{^Blk=katakanaext}', "");
    Expect(1, 12800, '\P{Blk=katakanaext}', "");
    Expect(0, 12800, '\P{^Blk=katakanaext}', "");
    Expect(1, 12799, '\p{Blk=:\Akatakanaext\z:}', "");;
    Expect(0, 12800, '\p{Blk=:\Akatakanaext\z:}', "");;
    Expect(1, 12799, '\p{Blk=	KATAKANA_Ext}', "");
    Expect(0, 12799, '\p{^Blk=	KATAKANA_Ext}', "");
    Expect(0, 12799, '\P{Blk=	KATAKANA_Ext}', "");
    Expect(1, 12799, '\P{^Blk=	KATAKANA_Ext}', "");
    Expect(0, 12800, '\p{Blk=	KATAKANA_Ext}', "");
    Expect(1, 12800, '\p{^Blk=	KATAKANA_Ext}', "");
    Expect(1, 12800, '\P{Blk=	KATAKANA_Ext}', "");
    Expect(0, 12800, '\P{^Blk=	KATAKANA_Ext}', "");
    Error('\p{Is_Block=:=- KATAKANA_phonetic_Extensions}');
    Error('\P{Is_Block=:=- KATAKANA_phonetic_Extensions}');
    Expect(1, 12799, '\p{Is_Block=katakanaphoneticextensions}', "");
    Expect(0, 12799, '\p{^Is_Block=katakanaphoneticextensions}', "");
    Expect(0, 12799, '\P{Is_Block=katakanaphoneticextensions}', "");
    Expect(1, 12799, '\P{^Is_Block=katakanaphoneticextensions}', "");
    Expect(0, 12800, '\p{Is_Block=katakanaphoneticextensions}', "");
    Expect(1, 12800, '\p{^Is_Block=katakanaphoneticextensions}', "");
    Expect(1, 12800, '\P{Is_Block=katakanaphoneticextensions}', "");
    Expect(0, 12800, '\P{^Is_Block=katakanaphoneticextensions}', "");
    Expect(1, 12799, '\p{Is_Block=--Katakana_Phonetic_Extensions}', "");
    Expect(0, 12799, '\p{^Is_Block=--Katakana_Phonetic_Extensions}', "");
    Expect(0, 12799, '\P{Is_Block=--Katakana_Phonetic_Extensions}', "");
    Expect(1, 12799, '\P{^Is_Block=--Katakana_Phonetic_Extensions}', "");
    Expect(0, 12800, '\p{Is_Block=--Katakana_Phonetic_Extensions}', "");
    Expect(1, 12800, '\p{^Is_Block=--Katakana_Phonetic_Extensions}', "");
    Expect(1, 12800, '\P{Is_Block=--Katakana_Phonetic_Extensions}', "");
    Expect(0, 12800, '\P{^Is_Block=--Katakana_Phonetic_Extensions}', "");
    Error('\p{Is_Blk=	-Katakana_EXT:=}');
    Error('\P{Is_Blk=	-Katakana_EXT:=}');
    Expect(1, 12799, '\p{Is_Blk=katakanaext}', "");
    Expect(0, 12799, '\p{^Is_Blk=katakanaext}', "");
    Expect(0, 12799, '\P{Is_Blk=katakanaext}', "");
    Expect(1, 12799, '\P{^Is_Blk=katakanaext}', "");
    Expect(0, 12800, '\p{Is_Blk=katakanaext}', "");
    Expect(1, 12800, '\p{^Is_Blk=katakanaext}', "");
    Expect(1, 12800, '\P{Is_Blk=katakanaext}', "");
    Expect(0, 12800, '\P{^Is_Blk=katakanaext}', "");
    Expect(1, 12799, '\p{Is_Blk= _KATAKANA_Ext}', "");
    Expect(0, 12799, '\p{^Is_Blk= _KATAKANA_Ext}', "");
    Expect(0, 12799, '\P{Is_Blk= _KATAKANA_Ext}', "");
    Expect(1, 12799, '\P{^Is_Blk= _KATAKANA_Ext}', "");
    Expect(0, 12800, '\p{Is_Blk= _KATAKANA_Ext}', "");
    Expect(1, 12800, '\p{^Is_Blk= _KATAKANA_Ext}', "");
    Expect(1, 12800, '\P{Is_Blk= _KATAKANA_Ext}', "");
    Expect(0, 12800, '\P{^Is_Blk= _KATAKANA_Ext}', "");
    Error('\p{Block= :=kayah_Li}');
    Error('\P{Block= :=kayah_Li}');
    Expect(1, 43311, '\p{Block=:\AKayah_Li\z:}', "");;
    Expect(0, 43312, '\p{Block=:\AKayah_Li\z:}', "");;
    Expect(1, 43311, '\p{Block=kayahli}', "");
    Expect(0, 43311, '\p{^Block=kayahli}', "");
    Expect(0, 43311, '\P{Block=kayahli}', "");
    Expect(1, 43311, '\P{^Block=kayahli}', "");
    Expect(0, 43312, '\p{Block=kayahli}', "");
    Expect(1, 43312, '\p{^Block=kayahli}', "");
    Expect(1, 43312, '\P{Block=kayahli}', "");
    Expect(0, 43312, '\P{^Block=kayahli}', "");
    Expect(1, 43311, '\p{Block=:\Akayahli\z:}', "");;
    Expect(0, 43312, '\p{Block=:\Akayahli\z:}', "");;
    Expect(1, 43311, '\p{Block=	_Kayah_li}', "");
    Expect(0, 43311, '\p{^Block=	_Kayah_li}', "");
    Expect(0, 43311, '\P{Block=	_Kayah_li}', "");
    Expect(1, 43311, '\P{^Block=	_Kayah_li}', "");
    Expect(0, 43312, '\p{Block=	_Kayah_li}', "");
    Expect(1, 43312, '\p{^Block=	_Kayah_li}', "");
    Expect(1, 43312, '\P{Block=	_Kayah_li}', "");
    Expect(0, 43312, '\P{^Block=	_Kayah_li}', "");
    Error('\p{Blk= Kayah_Li/a/}');
    Error('\P{Blk= Kayah_Li/a/}');
    Expect(1, 43311, '\p{Blk=:\AKayah_Li\z:}', "");;
    Expect(0, 43312, '\p{Blk=:\AKayah_Li\z:}', "");;
    Expect(1, 43311, '\p{Blk=kayahli}', "");
    Expect(0, 43311, '\p{^Blk=kayahli}', "");
    Expect(0, 43311, '\P{Blk=kayahli}', "");
    Expect(1, 43311, '\P{^Blk=kayahli}', "");
    Expect(0, 43312, '\p{Blk=kayahli}', "");
    Expect(1, 43312, '\p{^Blk=kayahli}', "");
    Expect(1, 43312, '\P{Blk=kayahli}', "");
    Expect(0, 43312, '\P{^Blk=kayahli}', "");
    Expect(1, 43311, '\p{Blk=:\Akayahli\z:}', "");;
    Expect(0, 43312, '\p{Blk=:\Akayahli\z:}', "");;
    Expect(1, 43311, '\p{Blk=_-kayah_Li}', "");
    Expect(0, 43311, '\p{^Blk=_-kayah_Li}', "");
    Expect(0, 43311, '\P{Blk=_-kayah_Li}', "");
    Expect(1, 43311, '\P{^Blk=_-kayah_Li}', "");
    Expect(0, 43312, '\p{Blk=_-kayah_Li}', "");
    Expect(1, 43312, '\p{^Blk=_-kayah_Li}', "");
    Expect(1, 43312, '\P{Blk=_-kayah_Li}', "");
    Expect(0, 43312, '\P{^Blk=_-kayah_Li}', "");
    Error('\p{Is_Block=:= -Kayah_li}');
    Error('\P{Is_Block=:= -Kayah_li}');
    Expect(1, 43311, '\p{Is_Block=kayahli}', "");
    Expect(0, 43311, '\p{^Is_Block=kayahli}', "");
    Expect(0, 43311, '\P{Is_Block=kayahli}', "");
    Expect(1, 43311, '\P{^Is_Block=kayahli}', "");
    Expect(0, 43312, '\p{Is_Block=kayahli}', "");
    Expect(1, 43312, '\p{^Is_Block=kayahli}', "");
    Expect(1, 43312, '\P{Is_Block=kayahli}', "");
    Expect(0, 43312, '\P{^Is_Block=kayahli}', "");
    Expect(1, 43311, '\p{Is_Block=	 Kayah_LI}', "");
    Expect(0, 43311, '\p{^Is_Block=	 Kayah_LI}', "");
    Expect(0, 43311, '\P{Is_Block=	 Kayah_LI}', "");
    Expect(1, 43311, '\P{^Is_Block=	 Kayah_LI}', "");
    Expect(0, 43312, '\p{Is_Block=	 Kayah_LI}', "");
    Expect(1, 43312, '\p{^Is_Block=	 Kayah_LI}', "");
    Expect(1, 43312, '\P{Is_Block=	 Kayah_LI}', "");
    Expect(0, 43312, '\P{^Is_Block=	 Kayah_LI}', "");
    Error('\p{Is_Blk= _KAYAH_LI:=}');
    Error('\P{Is_Blk= _KAYAH_LI:=}');
    Expect(1, 43311, '\p{Is_Blk=kayahli}', "");
    Expect(0, 43311, '\p{^Is_Blk=kayahli}', "");
    Expect(0, 43311, '\P{Is_Blk=kayahli}', "");
    Expect(1, 43311, '\P{^Is_Blk=kayahli}', "");
    Expect(0, 43312, '\p{Is_Blk=kayahli}', "");
    Expect(1, 43312, '\p{^Is_Blk=kayahli}', "");
    Expect(1, 43312, '\P{Is_Blk=kayahli}', "");
    Expect(0, 43312, '\P{^Is_Blk=kayahli}', "");
    Expect(1, 43311, '\p{Is_Blk=_Kayah_li}', "");
    Expect(0, 43311, '\p{^Is_Blk=_Kayah_li}', "");
    Expect(0, 43311, '\P{Is_Blk=_Kayah_li}', "");
    Expect(1, 43311, '\P{^Is_Blk=_Kayah_li}', "");
    Expect(0, 43312, '\p{Is_Blk=_Kayah_li}', "");
    Expect(1, 43312, '\p{^Is_Blk=_Kayah_li}', "");
    Expect(1, 43312, '\P{Is_Blk=_Kayah_li}', "");
    Expect(0, 43312, '\P{^Is_Blk=_Kayah_li}', "");
    Error('\p{Block= Kharoshthi/a/}');
    Error('\P{Block= Kharoshthi/a/}');
    Expect(1, 68191, '\p{Block=:\AKharoshthi\z:}', "");;
    Expect(0, 68192, '\p{Block=:\AKharoshthi\z:}', "");;
    Expect(1, 68191, '\p{Block=kharoshthi}', "");
    Expect(0, 68191, '\p{^Block=kharoshthi}', "");
    Expect(0, 68191, '\P{Block=kharoshthi}', "");
    Expect(1, 68191, '\P{^Block=kharoshthi}', "");
    Expect(0, 68192, '\p{Block=kharoshthi}', "");
    Expect(1, 68192, '\p{^Block=kharoshthi}', "");
    Expect(1, 68192, '\P{Block=kharoshthi}', "");
    Expect(0, 68192, '\P{^Block=kharoshthi}', "");
    Expect(1, 68191, '\p{Block=:\Akharoshthi\z:}', "");;
    Expect(0, 68192, '\p{Block=:\Akharoshthi\z:}', "");;
    Expect(1, 68191, '\p{Block:   -	Kharoshthi}', "");
    Expect(0, 68191, '\p{^Block:   -	Kharoshthi}', "");
    Expect(0, 68191, '\P{Block:   -	Kharoshthi}', "");
    Expect(1, 68191, '\P{^Block:   -	Kharoshthi}', "");
    Expect(0, 68192, '\p{Block:   -	Kharoshthi}', "");
    Expect(1, 68192, '\p{^Block:   -	Kharoshthi}', "");
    Expect(1, 68192, '\P{Block:   -	Kharoshthi}', "");
    Expect(0, 68192, '\P{^Block:   -	Kharoshthi}', "");
    Error('\p{Blk=:=-	kharoshthi}');
    Error('\P{Blk=:=-	kharoshthi}');
    Expect(1, 68191, '\p{Blk=:\AKharoshthi\z:}', "");;
    Expect(0, 68192, '\p{Blk=:\AKharoshthi\z:}', "");;
    Expect(1, 68191, '\p{Blk=kharoshthi}', "");
    Expect(0, 68191, '\p{^Blk=kharoshthi}', "");
    Expect(0, 68191, '\P{Blk=kharoshthi}', "");
    Expect(1, 68191, '\P{^Blk=kharoshthi}', "");
    Expect(0, 68192, '\p{Blk=kharoshthi}', "");
    Expect(1, 68192, '\p{^Blk=kharoshthi}', "");
    Expect(1, 68192, '\P{Blk=kharoshthi}', "");
    Expect(0, 68192, '\P{^Blk=kharoshthi}', "");
    Expect(1, 68191, '\p{Blk=:\Akharoshthi\z:}', "");;
    Expect(0, 68192, '\p{Blk=:\Akharoshthi\z:}', "");;
    Expect(1, 68191, '\p{Blk=_	kharoshthi}', "");
    Expect(0, 68191, '\p{^Blk=_	kharoshthi}', "");
    Expect(0, 68191, '\P{Blk=_	kharoshthi}', "");
    Expect(1, 68191, '\P{^Blk=_	kharoshthi}', "");
    Expect(0, 68192, '\p{Blk=_	kharoshthi}', "");
    Expect(1, 68192, '\p{^Blk=_	kharoshthi}', "");
    Expect(1, 68192, '\P{Blk=_	kharoshthi}', "");
    Expect(0, 68192, '\P{^Blk=_	kharoshthi}', "");
    Error('\p{Is_Block=/a/  kharoshthi}');
    Error('\P{Is_Block=/a/  kharoshthi}');
    Expect(1, 68191, '\p{Is_Block=kharoshthi}', "");
    Expect(0, 68191, '\p{^Is_Block=kharoshthi}', "");
    Expect(0, 68191, '\P{Is_Block=kharoshthi}', "");
    Expect(1, 68191, '\P{^Is_Block=kharoshthi}', "");
    Expect(0, 68192, '\p{Is_Block=kharoshthi}', "");
    Expect(1, 68192, '\p{^Is_Block=kharoshthi}', "");
    Expect(1, 68192, '\P{Is_Block=kharoshthi}', "");
    Expect(0, 68192, '\P{^Is_Block=kharoshthi}', "");
    Expect(1, 68191, '\p{Is_Block=- KHAROSHTHI}', "");
    Expect(0, 68191, '\p{^Is_Block=- KHAROSHTHI}', "");
    Expect(0, 68191, '\P{Is_Block=- KHAROSHTHI}', "");
    Expect(1, 68191, '\P{^Is_Block=- KHAROSHTHI}', "");
    Expect(0, 68192, '\p{Is_Block=- KHAROSHTHI}', "");
    Expect(1, 68192, '\p{^Is_Block=- KHAROSHTHI}', "");
    Expect(1, 68192, '\P{Is_Block=- KHAROSHTHI}', "");
    Expect(0, 68192, '\P{^Is_Block=- KHAROSHTHI}', "");
    Error('\p{Is_Blk=	:=KHAROSHTHI}');
    Error('\P{Is_Blk=	:=KHAROSHTHI}');
    Expect(1, 68191, '\p{Is_Blk=kharoshthi}', "");
    Expect(0, 68191, '\p{^Is_Blk=kharoshthi}', "");
    Expect(0, 68191, '\P{Is_Blk=kharoshthi}', "");
    Expect(1, 68191, '\P{^Is_Blk=kharoshthi}', "");
    Expect(0, 68192, '\p{Is_Blk=kharoshthi}', "");
    Expect(1, 68192, '\p{^Is_Blk=kharoshthi}', "");
    Expect(1, 68192, '\P{Is_Blk=kharoshthi}', "");
    Expect(0, 68192, '\P{^Is_Blk=kharoshthi}', "");
    Expect(1, 68191, '\p{Is_Blk=	 Kharoshthi}', "");
    Expect(0, 68191, '\p{^Is_Blk=	 Kharoshthi}', "");
    Expect(0, 68191, '\P{Is_Blk=	 Kharoshthi}', "");
    Expect(1, 68191, '\P{^Is_Blk=	 Kharoshthi}', "");
    Expect(0, 68192, '\p{Is_Blk=	 Kharoshthi}', "");
    Expect(1, 68192, '\p{^Is_Blk=	 Kharoshthi}', "");
    Expect(1, 68192, '\P{Is_Blk=	 Kharoshthi}', "");
    Expect(0, 68192, '\P{^Is_Blk=	 Kharoshthi}', "");
    Error('\p{Block=_/a/Khitan_Small_Script}');
    Error('\P{Block=_/a/Khitan_Small_Script}');
    Expect(1, 101631, '\p{Block=:\AKhitan_Small_Script\z:}', "");;
    Expect(0, 101632, '\p{Block=:\AKhitan_Small_Script\z:}', "");;
    Expect(1, 101631, '\p{Block=khitansmallscript}', "");
    Expect(0, 101631, '\p{^Block=khitansmallscript}', "");
    Expect(0, 101631, '\P{Block=khitansmallscript}', "");
    Expect(1, 101631, '\P{^Block=khitansmallscript}', "");
    Expect(0, 101632, '\p{Block=khitansmallscript}', "");
    Expect(1, 101632, '\p{^Block=khitansmallscript}', "");
    Expect(1, 101632, '\P{Block=khitansmallscript}', "");
    Expect(0, 101632, '\P{^Block=khitansmallscript}', "");
    Expect(1, 101631, '\p{Block=:\Akhitansmallscript\z:}', "");;
    Expect(0, 101632, '\p{Block=:\Akhitansmallscript\z:}', "");;
    Expect(1, 101631, '\p{Block=-KHITAN_SMALL_SCRIPT}', "");
    Expect(0, 101631, '\p{^Block=-KHITAN_SMALL_SCRIPT}', "");
    Expect(0, 101631, '\P{Block=-KHITAN_SMALL_SCRIPT}', "");
    Expect(1, 101631, '\P{^Block=-KHITAN_SMALL_SCRIPT}', "");
    Expect(0, 101632, '\p{Block=-KHITAN_SMALL_SCRIPT}', "");
    Expect(1, 101632, '\p{^Block=-KHITAN_SMALL_SCRIPT}', "");
    Expect(1, 101632, '\P{Block=-KHITAN_SMALL_SCRIPT}', "");
    Expect(0, 101632, '\P{^Block=-KHITAN_SMALL_SCRIPT}', "");
    Error('\p{Blk=-	KHITAN_small_SCRIPT/a/}');
    Error('\P{Blk=-	KHITAN_small_SCRIPT/a/}');
    Expect(1, 101631, '\p{Blk=:\AKhitan_Small_Script\z:}', "");;
    Expect(0, 101632, '\p{Blk=:\AKhitan_Small_Script\z:}', "");;
    Expect(1, 101631, '\p{Blk=khitansmallscript}', "");
    Expect(0, 101631, '\p{^Blk=khitansmallscript}', "");
    Expect(0, 101631, '\P{Blk=khitansmallscript}', "");
    Expect(1, 101631, '\P{^Blk=khitansmallscript}', "");
    Expect(0, 101632, '\p{Blk=khitansmallscript}', "");
    Expect(1, 101632, '\p{^Blk=khitansmallscript}', "");
    Expect(1, 101632, '\P{Blk=khitansmallscript}', "");
    Expect(0, 101632, '\P{^Blk=khitansmallscript}', "");
    Expect(1, 101631, '\p{Blk=:\Akhitansmallscript\z:}', "");;
    Expect(0, 101632, '\p{Blk=:\Akhitansmallscript\z:}', "");;
    Expect(1, 101631, '\p{Blk=-_KHITAN_SMALL_SCRIPT}', "");
    Expect(0, 101631, '\p{^Blk=-_KHITAN_SMALL_SCRIPT}', "");
    Expect(0, 101631, '\P{Blk=-_KHITAN_SMALL_SCRIPT}', "");
    Expect(1, 101631, '\P{^Blk=-_KHITAN_SMALL_SCRIPT}', "");
    Expect(0, 101632, '\p{Blk=-_KHITAN_SMALL_SCRIPT}', "");
    Expect(1, 101632, '\p{^Blk=-_KHITAN_SMALL_SCRIPT}', "");
    Expect(1, 101632, '\P{Blk=-_KHITAN_SMALL_SCRIPT}', "");
    Expect(0, 101632, '\P{^Blk=-_KHITAN_SMALL_SCRIPT}', "");
    Error('\p{Is_Block=:=KHITAN_Small_Script}');
    Error('\P{Is_Block=:=KHITAN_Small_Script}');
    Expect(1, 101631, '\p{Is_Block=khitansmallscript}', "");
    Expect(0, 101631, '\p{^Is_Block=khitansmallscript}', "");
    Expect(0, 101631, '\P{Is_Block=khitansmallscript}', "");
    Expect(1, 101631, '\P{^Is_Block=khitansmallscript}', "");
    Expect(0, 101632, '\p{Is_Block=khitansmallscript}', "");
    Expect(1, 101632, '\p{^Is_Block=khitansmallscript}', "");
    Expect(1, 101632, '\P{Is_Block=khitansmallscript}', "");
    Expect(0, 101632, '\P{^Is_Block=khitansmallscript}', "");
    Expect(1, 101631, '\p{Is_Block=-khitan_small_SCRIPT}', "");
    Expect(0, 101631, '\p{^Is_Block=-khitan_small_SCRIPT}', "");
    Expect(0, 101631, '\P{Is_Block=-khitan_small_SCRIPT}', "");
    Expect(1, 101631, '\P{^Is_Block=-khitan_small_SCRIPT}', "");
    Expect(0, 101632, '\p{Is_Block=-khitan_small_SCRIPT}', "");
    Expect(1, 101632, '\p{^Is_Block=-khitan_small_SCRIPT}', "");
    Expect(1, 101632, '\P{Is_Block=-khitan_small_SCRIPT}', "");
    Expect(0, 101632, '\P{^Is_Block=-khitan_small_SCRIPT}', "");
    Error('\p{Is_Blk=:=_ khitan_SMALL_Script}');
    Error('\P{Is_Blk=:=_ khitan_SMALL_Script}');
    Expect(1, 101631, '\p{Is_Blk: khitansmallscript}', "");
    Expect(0, 101631, '\p{^Is_Blk: khitansmallscript}', "");
    Expect(0, 101631, '\P{Is_Blk: khitansmallscript}', "");
    Expect(1, 101631, '\P{^Is_Blk: khitansmallscript}', "");
    Expect(0, 101632, '\p{Is_Blk: khitansmallscript}', "");
    Expect(1, 101632, '\p{^Is_Blk: khitansmallscript}', "");
    Expect(1, 101632, '\P{Is_Blk: khitansmallscript}', "");
    Expect(0, 101632, '\P{^Is_Blk: khitansmallscript}', "");
    Expect(1, 101631, '\p{Is_Blk= Khitan_Small_Script}', "");
    Expect(0, 101631, '\p{^Is_Blk= Khitan_Small_Script}', "");
    Expect(0, 101631, '\P{Is_Blk= Khitan_Small_Script}', "");
    Expect(1, 101631, '\P{^Is_Blk= Khitan_Small_Script}', "");
    Expect(0, 101632, '\p{Is_Blk= Khitan_Small_Script}', "");
    Expect(1, 101632, '\p{^Is_Blk= Khitan_Small_Script}', "");
    Expect(1, 101632, '\P{Is_Blk= Khitan_Small_Script}', "");
    Expect(0, 101632, '\P{^Is_Blk= Khitan_Small_Script}', "");
    Error('\p{Block=_khmer/a/}');
    Error('\P{Block=_khmer/a/}');
    Expect(1, 6143, '\p{Block=:\AKhmer\z:}', "");;
    Expect(0, 6144, '\p{Block=:\AKhmer\z:}', "");;
    Expect(1, 6143, '\p{Block=khmer}', "");
    Expect(0, 6143, '\p{^Block=khmer}', "");
    Expect(0, 6143, '\P{Block=khmer}', "");
    Expect(1, 6143, '\P{^Block=khmer}', "");
    Expect(0, 6144, '\p{Block=khmer}', "");
    Expect(1, 6144, '\p{^Block=khmer}', "");
    Expect(1, 6144, '\P{Block=khmer}', "");
    Expect(0, 6144, '\P{^Block=khmer}', "");
    Expect(1, 6143, '\p{Block=:\Akhmer\z:}', "");;
    Expect(0, 6144, '\p{Block=:\Akhmer\z:}', "");;
    Expect(1, 6143, '\p{Block=	-Khmer}', "");
    Expect(0, 6143, '\p{^Block=	-Khmer}', "");
    Expect(0, 6143, '\P{Block=	-Khmer}', "");
    Expect(1, 6143, '\P{^Block=	-Khmer}', "");
    Expect(0, 6144, '\p{Block=	-Khmer}', "");
    Expect(1, 6144, '\p{^Block=	-Khmer}', "");
    Expect(1, 6144, '\P{Block=	-Khmer}', "");
    Expect(0, 6144, '\P{^Block=	-Khmer}', "");
    Error('\p{Blk=/a/khmer}');
    Error('\P{Blk=/a/khmer}');
    Expect(1, 6143, '\p{Blk=:\AKhmer\z:}', "");;
    Expect(0, 6144, '\p{Blk=:\AKhmer\z:}', "");;
    Expect(1, 6143, '\p{Blk=khmer}', "");
    Expect(0, 6143, '\p{^Blk=khmer}', "");
    Expect(0, 6143, '\P{Blk=khmer}', "");
    Expect(1, 6143, '\P{^Blk=khmer}', "");
    Expect(0, 6144, '\p{Blk=khmer}', "");
    Expect(1, 6144, '\p{^Blk=khmer}', "");
    Expect(1, 6144, '\P{Blk=khmer}', "");
    Expect(0, 6144, '\P{^Blk=khmer}', "");
    Expect(1, 6143, '\p{Blk=:\Akhmer\z:}', "");;
    Expect(0, 6144, '\p{Blk=:\Akhmer\z:}', "");;
    Expect(1, 6143, '\p{Blk=	KHMER}', "");
    Expect(0, 6143, '\p{^Blk=	KHMER}', "");
    Expect(0, 6143, '\P{Blk=	KHMER}', "");
    Expect(1, 6143, '\P{^Blk=	KHMER}', "");
    Expect(0, 6144, '\p{Blk=	KHMER}', "");
    Expect(1, 6144, '\p{^Blk=	KHMER}', "");
    Expect(1, 6144, '\P{Blk=	KHMER}', "");
    Expect(0, 6144, '\P{^Blk=	KHMER}', "");
    Error('\p{Is_Block:	:= khmer}');
    Error('\P{Is_Block:	:= khmer}');
    Expect(1, 6143, '\p{Is_Block=khmer}', "");
    Expect(0, 6143, '\p{^Is_Block=khmer}', "");
    Expect(0, 6143, '\P{Is_Block=khmer}', "");
    Expect(1, 6143, '\P{^Is_Block=khmer}', "");
    Expect(0, 6144, '\p{Is_Block=khmer}', "");
    Expect(1, 6144, '\p{^Is_Block=khmer}', "");
    Expect(1, 6144, '\P{Is_Block=khmer}', "");
    Expect(0, 6144, '\P{^Is_Block=khmer}', "");
    Expect(1, 6143, '\p{Is_Block=	Khmer}', "");
    Expect(0, 6143, '\p{^Is_Block=	Khmer}', "");
    Expect(0, 6143, '\P{Is_Block=	Khmer}', "");
    Expect(1, 6143, '\P{^Is_Block=	Khmer}', "");
    Expect(0, 6144, '\p{Is_Block=	Khmer}', "");
    Expect(1, 6144, '\p{^Is_Block=	Khmer}', "");
    Expect(1, 6144, '\P{Is_Block=	Khmer}', "");
    Expect(0, 6144, '\P{^Is_Block=	Khmer}', "");
    Error('\p{Is_Blk:  /a/khmer}');
    Error('\P{Is_Blk:  /a/khmer}');
    Expect(1, 6143, '\p{Is_Blk=khmer}', "");
    Expect(0, 6143, '\p{^Is_Blk=khmer}', "");
    Expect(0, 6143, '\P{Is_Blk=khmer}', "");
    Expect(1, 6143, '\P{^Is_Blk=khmer}', "");
    Expect(0, 6144, '\p{Is_Blk=khmer}', "");
    Expect(1, 6144, '\p{^Is_Blk=khmer}', "");
    Expect(1, 6144, '\P{Is_Blk=khmer}', "");
    Expect(0, 6144, '\P{^Is_Blk=khmer}', "");
    Expect(1, 6143, '\p{Is_Blk= KHMER}', "");
    Expect(0, 6143, '\p{^Is_Blk= KHMER}', "");
    Expect(0, 6143, '\P{Is_Blk= KHMER}', "");
    Expect(1, 6143, '\P{^Is_Blk= KHMER}', "");
    Expect(0, 6144, '\p{Is_Blk= KHMER}', "");
    Expect(1, 6144, '\p{^Is_Blk= KHMER}', "");
    Expect(1, 6144, '\P{Is_Blk= KHMER}', "");
    Expect(0, 6144, '\P{^Is_Blk= KHMER}', "");
    Error('\p{Block=-:=khmer_Symbols}');
    Error('\P{Block=-:=khmer_Symbols}');
    Expect(1, 6655, '\p{Block=:\AKhmer_Symbols\z:}', "");;
    Expect(0, 6656, '\p{Block=:\AKhmer_Symbols\z:}', "");;
    Expect(1, 6655, '\p{Block=khmersymbols}', "");
    Expect(0, 6655, '\p{^Block=khmersymbols}', "");
    Expect(0, 6655, '\P{Block=khmersymbols}', "");
    Expect(1, 6655, '\P{^Block=khmersymbols}', "");
    Expect(0, 6656, '\p{Block=khmersymbols}', "");
    Expect(1, 6656, '\p{^Block=khmersymbols}', "");
    Expect(1, 6656, '\P{Block=khmersymbols}', "");
    Expect(0, 6656, '\P{^Block=khmersymbols}', "");
    Expect(1, 6655, '\p{Block=:\Akhmersymbols\z:}', "");;
    Expect(0, 6656, '\p{Block=:\Akhmersymbols\z:}', "");;
    Expect(1, 6655, '\p{Block=_ KHMER_SYMBOLS}', "");
    Expect(0, 6655, '\p{^Block=_ KHMER_SYMBOLS}', "");
    Expect(0, 6655, '\P{Block=_ KHMER_SYMBOLS}', "");
    Expect(1, 6655, '\P{^Block=_ KHMER_SYMBOLS}', "");
    Expect(0, 6656, '\p{Block=_ KHMER_SYMBOLS}', "");
    Expect(1, 6656, '\p{^Block=_ KHMER_SYMBOLS}', "");
    Expect(1, 6656, '\P{Block=_ KHMER_SYMBOLS}', "");
    Expect(0, 6656, '\P{^Block=_ KHMER_SYMBOLS}', "");
    Error('\p{Blk=:=		Khmer_Symbols}');
    Error('\P{Blk=:=		Khmer_Symbols}');
    Expect(1, 6655, '\p{Blk=:\AKhmer_Symbols\z:}', "");;
    Expect(0, 6656, '\p{Blk=:\AKhmer_Symbols\z:}', "");;
    Expect(1, 6655, '\p{Blk=khmersymbols}', "");
    Expect(0, 6655, '\p{^Blk=khmersymbols}', "");
    Expect(0, 6655, '\P{Blk=khmersymbols}', "");
    Expect(1, 6655, '\P{^Blk=khmersymbols}', "");
    Expect(0, 6656, '\p{Blk=khmersymbols}', "");
    Expect(1, 6656, '\p{^Blk=khmersymbols}', "");
    Expect(1, 6656, '\P{Blk=khmersymbols}', "");
    Expect(0, 6656, '\P{^Blk=khmersymbols}', "");
    Expect(1, 6655, '\p{Blk=:\Akhmersymbols\z:}', "");;
    Expect(0, 6656, '\p{Blk=:\Akhmersymbols\z:}', "");;
    Expect(1, 6655, '\p{Blk=_-Khmer_Symbols}', "");
    Expect(0, 6655, '\p{^Blk=_-Khmer_Symbols}', "");
    Expect(0, 6655, '\P{Blk=_-Khmer_Symbols}', "");
    Expect(1, 6655, '\P{^Blk=_-Khmer_Symbols}', "");
    Expect(0, 6656, '\p{Blk=_-Khmer_Symbols}', "");
    Expect(1, 6656, '\p{^Blk=_-Khmer_Symbols}', "");
    Expect(1, 6656, '\P{Blk=_-Khmer_Symbols}', "");
    Expect(0, 6656, '\P{^Blk=_-Khmer_Symbols}', "");
    Error('\p{Is_Block=	:=khmer_SYMBOLS}');
    Error('\P{Is_Block=	:=khmer_SYMBOLS}');
    Expect(1, 6655, '\p{Is_Block=khmersymbols}', "");
    Expect(0, 6655, '\p{^Is_Block=khmersymbols}', "");
    Expect(0, 6655, '\P{Is_Block=khmersymbols}', "");
    Expect(1, 6655, '\P{^Is_Block=khmersymbols}', "");
    Expect(0, 6656, '\p{Is_Block=khmersymbols}', "");
    Expect(1, 6656, '\p{^Is_Block=khmersymbols}', "");
    Expect(1, 6656, '\P{Is_Block=khmersymbols}', "");
    Expect(0, 6656, '\P{^Is_Block=khmersymbols}', "");
    Expect(1, 6655, '\p{Is_Block= Khmer_SYMBOLS}', "");
    Expect(0, 6655, '\p{^Is_Block= Khmer_SYMBOLS}', "");
    Expect(0, 6655, '\P{Is_Block= Khmer_SYMBOLS}', "");
    Expect(1, 6655, '\P{^Is_Block= Khmer_SYMBOLS}', "");
    Expect(0, 6656, '\p{Is_Block= Khmer_SYMBOLS}', "");
    Expect(1, 6656, '\p{^Is_Block= Khmer_SYMBOLS}', "");
    Expect(1, 6656, '\P{Is_Block= Khmer_SYMBOLS}', "");
    Expect(0, 6656, '\P{^Is_Block= Khmer_SYMBOLS}', "");
    Error('\p{Is_Blk= /a/Khmer_symbols}');
    Error('\P{Is_Blk= /a/Khmer_symbols}');
    Expect(1, 6655, '\p{Is_Blk=khmersymbols}', "");
    Expect(0, 6655, '\p{^Is_Blk=khmersymbols}', "");
    Expect(0, 6655, '\P{Is_Blk=khmersymbols}', "");
    Expect(1, 6655, '\P{^Is_Blk=khmersymbols}', "");
    Expect(0, 6656, '\p{Is_Blk=khmersymbols}', "");
    Expect(1, 6656, '\p{^Is_Blk=khmersymbols}', "");
    Expect(1, 6656, '\P{Is_Blk=khmersymbols}', "");
    Expect(0, 6656, '\P{^Is_Blk=khmersymbols}', "");
    Expect(1, 6655, '\p{Is_Blk=__KHMER_symbols}', "");
    Expect(0, 6655, '\p{^Is_Blk=__KHMER_symbols}', "");
    Expect(0, 6655, '\P{Is_Blk=__KHMER_symbols}', "");
    Expect(1, 6655, '\P{^Is_Blk=__KHMER_symbols}', "");
    Expect(0, 6656, '\p{Is_Blk=__KHMER_symbols}', "");
    Expect(1, 6656, '\p{^Is_Blk=__KHMER_symbols}', "");
    Expect(1, 6656, '\P{Is_Blk=__KHMER_symbols}', "");
    Expect(0, 6656, '\P{^Is_Blk=__KHMER_symbols}', "");
    Error('\p{Block=_:=Khojki}');
    Error('\P{Block=_:=Khojki}');
    Expect(1, 70223, '\p{Block=:\AKhojki\z:}', "");;
    Expect(0, 70224, '\p{Block=:\AKhojki\z:}', "");;
    Expect(1, 70223, '\p{Block=khojki}', "");
    Expect(0, 70223, '\p{^Block=khojki}', "");
    Expect(0, 70223, '\P{Block=khojki}', "");
    Expect(1, 70223, '\P{^Block=khojki}', "");
    Expect(0, 70224, '\p{Block=khojki}', "");
    Expect(1, 70224, '\p{^Block=khojki}', "");
    Expect(1, 70224, '\P{Block=khojki}', "");
    Expect(0, 70224, '\P{^Block=khojki}', "");
    Expect(1, 70223, '\p{Block=:\Akhojki\z:}', "");;
    Expect(0, 70224, '\p{Block=:\Akhojki\z:}', "");;
    Expect(1, 70223, '\p{Block=  Khojki}', "");
    Expect(0, 70223, '\p{^Block=  Khojki}', "");
    Expect(0, 70223, '\P{Block=  Khojki}', "");
    Expect(1, 70223, '\P{^Block=  Khojki}', "");
    Expect(0, 70224, '\p{Block=  Khojki}', "");
    Expect(1, 70224, '\p{^Block=  Khojki}', "");
    Expect(1, 70224, '\P{Block=  Khojki}', "");
    Expect(0, 70224, '\P{^Block=  Khojki}', "");
    Error('\p{Blk:   /a/  Khojki}');
    Error('\P{Blk:   /a/  Khojki}');
    Expect(1, 70223, '\p{Blk=:\AKhojki\z:}', "");;
    Expect(0, 70224, '\p{Blk=:\AKhojki\z:}', "");;
    Expect(1, 70223, '\p{Blk=khojki}', "");
    Expect(0, 70223, '\p{^Blk=khojki}', "");
    Expect(0, 70223, '\P{Blk=khojki}', "");
    Expect(1, 70223, '\P{^Blk=khojki}', "");
    Expect(0, 70224, '\p{Blk=khojki}', "");
    Expect(1, 70224, '\p{^Blk=khojki}', "");
    Expect(1, 70224, '\P{Blk=khojki}', "");
    Expect(0, 70224, '\P{^Blk=khojki}', "");
    Expect(1, 70223, '\p{Blk=:\Akhojki\z:}', "");;
    Expect(0, 70224, '\p{Blk=:\Akhojki\z:}', "");;
    Expect(1, 70223, '\p{Blk=- khojki}', "");
    Expect(0, 70223, '\p{^Blk=- khojki}', "");
    Expect(0, 70223, '\P{Blk=- khojki}', "");
    Expect(1, 70223, '\P{^Blk=- khojki}', "");
    Expect(0, 70224, '\p{Blk=- khojki}', "");
    Expect(1, 70224, '\p{^Blk=- khojki}', "");
    Expect(1, 70224, '\P{Blk=- khojki}', "");
    Expect(0, 70224, '\P{^Blk=- khojki}', "");
    Error('\p{Is_Block= -Khojki:=}');
    Error('\P{Is_Block= -Khojki:=}');
    Expect(1, 70223, '\p{Is_Block=khojki}', "");
    Expect(0, 70223, '\p{^Is_Block=khojki}', "");
    Expect(0, 70223, '\P{Is_Block=khojki}', "");
    Expect(1, 70223, '\P{^Is_Block=khojki}', "");
    Expect(0, 70224, '\p{Is_Block=khojki}', "");
    Expect(1, 70224, '\p{^Is_Block=khojki}', "");
    Expect(1, 70224, '\P{Is_Block=khojki}', "");
    Expect(0, 70224, '\P{^Is_Block=khojki}', "");
    Expect(1, 70223, '\p{Is_Block=		Khojki}', "");
    Expect(0, 70223, '\p{^Is_Block=		Khojki}', "");
    Expect(0, 70223, '\P{Is_Block=		Khojki}', "");
    Expect(1, 70223, '\P{^Is_Block=		Khojki}', "");
    Expect(0, 70224, '\p{Is_Block=		Khojki}', "");
    Expect(1, 70224, '\p{^Is_Block=		Khojki}', "");
    Expect(1, 70224, '\P{Is_Block=		Khojki}', "");
    Expect(0, 70224, '\P{^Is_Block=		Khojki}', "");
    Error('\p{Is_Blk=/a/khojki}');
    Error('\P{Is_Blk=/a/khojki}');
    Expect(1, 70223, '\p{Is_Blk=khojki}', "");
    Expect(0, 70223, '\p{^Is_Blk=khojki}', "");
    Expect(0, 70223, '\P{Is_Blk=khojki}', "");
    Expect(1, 70223, '\P{^Is_Blk=khojki}', "");
    Expect(0, 70224, '\p{Is_Blk=khojki}', "");
    Expect(1, 70224, '\p{^Is_Blk=khojki}', "");
    Expect(1, 70224, '\P{Is_Blk=khojki}', "");
    Expect(0, 70224, '\P{^Is_Blk=khojki}', "");
    Expect(1, 70223, '\p{Is_Blk= 	khojki}', "");
    Expect(0, 70223, '\p{^Is_Blk= 	khojki}', "");
    Expect(0, 70223, '\P{Is_Blk= 	khojki}', "");
    Expect(1, 70223, '\P{^Is_Blk= 	khojki}', "");
    Expect(0, 70224, '\p{Is_Blk= 	khojki}', "");
    Expect(1, 70224, '\p{^Is_Blk= 	khojki}', "");
    Expect(1, 70224, '\P{Is_Blk= 	khojki}', "");
    Expect(0, 70224, '\P{^Is_Blk= 	khojki}', "");
    Error('\p{Block= KHUDAWADI:=}');
    Error('\P{Block= KHUDAWADI:=}');
    Expect(1, 70399, '\p{Block=:\AKhudawadi\z:}', "");;
    Expect(0, 70400, '\p{Block=:\AKhudawadi\z:}', "");;
    Expect(1, 70399, '\p{Block=khudawadi}', "");
    Expect(0, 70399, '\p{^Block=khudawadi}', "");
    Expect(0, 70399, '\P{Block=khudawadi}', "");
    Expect(1, 70399, '\P{^Block=khudawadi}', "");
    Expect(0, 70400, '\p{Block=khudawadi}', "");
    Expect(1, 70400, '\p{^Block=khudawadi}', "");
    Expect(1, 70400, '\P{Block=khudawadi}', "");
    Expect(0, 70400, '\P{^Block=khudawadi}', "");
    Expect(1, 70399, '\p{Block=:\Akhudawadi\z:}', "");;
    Expect(0, 70400, '\p{Block=:\Akhudawadi\z:}', "");;
    Expect(1, 70399, '\p{Block= -KHUDAWADI}', "");
    Expect(0, 70399, '\p{^Block= -KHUDAWADI}', "");
    Expect(0, 70399, '\P{Block= -KHUDAWADI}', "");
    Expect(1, 70399, '\P{^Block= -KHUDAWADI}', "");
    Expect(0, 70400, '\p{Block= -KHUDAWADI}', "");
    Expect(1, 70400, '\p{^Block= -KHUDAWADI}', "");
    Expect(1, 70400, '\P{Block= -KHUDAWADI}', "");
    Expect(0, 70400, '\P{^Block= -KHUDAWADI}', "");
    Error('\p{Blk= :=KHUDAWADI}');
    Error('\P{Blk= :=KHUDAWADI}');
    Expect(1, 70399, '\p{Blk=:\AKhudawadi\z:}', "");;
    Expect(0, 70400, '\p{Blk=:\AKhudawadi\z:}', "");;
    Expect(1, 70399, '\p{Blk=khudawadi}', "");
    Expect(0, 70399, '\p{^Blk=khudawadi}', "");
    Expect(0, 70399, '\P{Blk=khudawadi}', "");
    Expect(1, 70399, '\P{^Blk=khudawadi}', "");
    Expect(0, 70400, '\p{Blk=khudawadi}', "");
    Expect(1, 70400, '\p{^Blk=khudawadi}', "");
    Expect(1, 70400, '\P{Blk=khudawadi}', "");
    Expect(0, 70400, '\P{^Blk=khudawadi}', "");
    Expect(1, 70399, '\p{Blk=:\Akhudawadi\z:}', "");;
    Expect(0, 70400, '\p{Blk=:\Akhudawadi\z:}', "");;
    Expect(1, 70399, '\p{Blk=-KHUDAWADI}', "");
    Expect(0, 70399, '\p{^Blk=-KHUDAWADI}', "");
    Expect(0, 70399, '\P{Blk=-KHUDAWADI}', "");
    Expect(1, 70399, '\P{^Blk=-KHUDAWADI}', "");
    Expect(0, 70400, '\p{Blk=-KHUDAWADI}', "");
    Expect(1, 70400, '\p{^Blk=-KHUDAWADI}', "");
    Expect(1, 70400, '\P{Blk=-KHUDAWADI}', "");
    Expect(0, 70400, '\P{^Blk=-KHUDAWADI}', "");
    Error('\p{Is_Block=__Khudawadi:=}');
    Error('\P{Is_Block=__Khudawadi:=}');
    Expect(1, 70399, '\p{Is_Block=khudawadi}', "");
    Expect(0, 70399, '\p{^Is_Block=khudawadi}', "");
    Expect(0, 70399, '\P{Is_Block=khudawadi}', "");
    Expect(1, 70399, '\P{^Is_Block=khudawadi}', "");
    Expect(0, 70400, '\p{Is_Block=khudawadi}', "");
    Expect(1, 70400, '\p{^Is_Block=khudawadi}', "");
    Expect(1, 70400, '\P{Is_Block=khudawadi}', "");
    Expect(0, 70400, '\P{^Is_Block=khudawadi}', "");
    Expect(1, 70399, '\p{Is_Block:   _khudawadi}', "");
    Expect(0, 70399, '\p{^Is_Block:   _khudawadi}', "");
    Expect(0, 70399, '\P{Is_Block:   _khudawadi}', "");
    Expect(1, 70399, '\P{^Is_Block:   _khudawadi}', "");
    Expect(0, 70400, '\p{Is_Block:   _khudawadi}', "");
    Expect(1, 70400, '\p{^Is_Block:   _khudawadi}', "");
    Expect(1, 70400, '\P{Is_Block:   _khudawadi}', "");
    Expect(0, 70400, '\P{^Is_Block:   _khudawadi}', "");
    Error('\p{Is_Blk=	-KHUDAWADI:=}');
    Error('\P{Is_Blk=	-KHUDAWADI:=}');
    Expect(1, 70399, '\p{Is_Blk=khudawadi}', "");
    Expect(0, 70399, '\p{^Is_Blk=khudawadi}', "");
    Expect(0, 70399, '\P{Is_Blk=khudawadi}', "");
    Expect(1, 70399, '\P{^Is_Blk=khudawadi}', "");
    Expect(0, 70400, '\p{Is_Blk=khudawadi}', "");
    Expect(1, 70400, '\p{^Is_Blk=khudawadi}', "");
    Expect(1, 70400, '\P{Is_Blk=khudawadi}', "");
    Expect(0, 70400, '\P{^Is_Blk=khudawadi}', "");
    Expect(1, 70399, '\p{Is_Blk=  KHUDAWADI}', "");
    Expect(0, 70399, '\p{^Is_Blk=  KHUDAWADI}', "");
    Expect(0, 70399, '\P{Is_Blk=  KHUDAWADI}', "");
    Expect(1, 70399, '\P{^Is_Blk=  KHUDAWADI}', "");
    Expect(0, 70400, '\p{Is_Blk=  KHUDAWADI}', "");
    Expect(1, 70400, '\p{^Is_Blk=  KHUDAWADI}', "");
    Expect(1, 70400, '\P{Is_Blk=  KHUDAWADI}', "");
    Expect(0, 70400, '\P{^Is_Blk=  KHUDAWADI}', "");
    Error('\p{Block:	:=lao}');
    Error('\P{Block:	:=lao}');
    Expect(1, 3839, '\p{Block=:\ALao\z:}', "");;
    Expect(0, 3840, '\p{Block=:\ALao\z:}', "");;
    Expect(1, 3839, '\p{Block=lao}', "");
    Expect(0, 3839, '\p{^Block=lao}', "");
    Expect(0, 3839, '\P{Block=lao}', "");
    Expect(1, 3839, '\P{^Block=lao}', "");
    Expect(0, 3840, '\p{Block=lao}', "");
    Expect(1, 3840, '\p{^Block=lao}', "");
    Expect(1, 3840, '\P{Block=lao}', "");
    Expect(0, 3840, '\P{^Block=lao}', "");
    Expect(1, 3839, '\p{Block=:\Alao\z:}', "");;
    Expect(0, 3840, '\p{Block=:\Alao\z:}', "");;
    Expect(1, 3839, '\p{Block:			Lao}', "");
    Expect(0, 3839, '\p{^Block:			Lao}', "");
    Expect(0, 3839, '\P{Block:			Lao}', "");
    Expect(1, 3839, '\P{^Block:			Lao}', "");
    Expect(0, 3840, '\p{Block:			Lao}', "");
    Expect(1, 3840, '\p{^Block:			Lao}', "");
    Expect(1, 3840, '\P{Block:			Lao}', "");
    Expect(0, 3840, '\P{^Block:			Lao}', "");
    Error('\p{Blk=-:=Lao}');
    Error('\P{Blk=-:=Lao}');
    Expect(1, 3839, '\p{Blk=:\ALao\z:}', "");;
    Expect(0, 3840, '\p{Blk=:\ALao\z:}', "");;
    Expect(1, 3839, '\p{Blk=lao}', "");
    Expect(0, 3839, '\p{^Blk=lao}', "");
    Expect(0, 3839, '\P{Blk=lao}', "");
    Expect(1, 3839, '\P{^Blk=lao}', "");
    Expect(0, 3840, '\p{Blk=lao}', "");
    Expect(1, 3840, '\p{^Blk=lao}', "");
    Expect(1, 3840, '\P{Blk=lao}', "");
    Expect(0, 3840, '\P{^Blk=lao}', "");
    Expect(1, 3839, '\p{Blk=:\Alao\z:}', "");;
    Expect(0, 3840, '\p{Blk=:\Alao\z:}', "");;
    Expect(1, 3839, '\p{Blk=  Lao}', "");
    Expect(0, 3839, '\p{^Blk=  Lao}', "");
    Expect(0, 3839, '\P{Blk=  Lao}', "");
    Expect(1, 3839, '\P{^Blk=  Lao}', "");
    Expect(0, 3840, '\p{Blk=  Lao}', "");
    Expect(1, 3840, '\p{^Blk=  Lao}', "");
    Expect(1, 3840, '\P{Blk=  Lao}', "");
    Expect(0, 3840, '\P{^Blk=  Lao}', "");
    Error('\p{Is_Block=-/a/lao}');
    Error('\P{Is_Block=-/a/lao}');
    Expect(1, 3839, '\p{Is_Block=lao}', "");
    Expect(0, 3839, '\p{^Is_Block=lao}', "");
    Expect(0, 3839, '\P{Is_Block=lao}', "");
    Expect(1, 3839, '\P{^Is_Block=lao}', "");
    Expect(0, 3840, '\p{Is_Block=lao}', "");
    Expect(1, 3840, '\p{^Is_Block=lao}', "");
    Expect(1, 3840, '\P{Is_Block=lao}', "");
    Expect(0, 3840, '\P{^Is_Block=lao}', "");
    Expect(1, 3839, '\p{Is_Block=	-lao}', "");
    Expect(0, 3839, '\p{^Is_Block=	-lao}', "");
    Expect(0, 3839, '\P{Is_Block=	-lao}', "");
    Expect(1, 3839, '\P{^Is_Block=	-lao}', "");
    Expect(0, 3840, '\p{Is_Block=	-lao}', "");
    Expect(1, 3840, '\p{^Is_Block=	-lao}', "");
    Expect(1, 3840, '\P{Is_Block=	-lao}', "");
    Expect(0, 3840, '\P{^Is_Block=	-lao}', "");
    Error('\p{Is_Blk=--Lao:=}');
    Error('\P{Is_Blk=--Lao:=}');
    Expect(1, 3839, '\p{Is_Blk=lao}', "");
    Expect(0, 3839, '\p{^Is_Blk=lao}', "");
    Expect(0, 3839, '\P{Is_Blk=lao}', "");
    Expect(1, 3839, '\P{^Is_Blk=lao}', "");
    Expect(0, 3840, '\p{Is_Blk=lao}', "");
    Expect(1, 3840, '\p{^Is_Blk=lao}', "");
    Expect(1, 3840, '\P{Is_Blk=lao}', "");
    Expect(0, 3840, '\P{^Is_Blk=lao}', "");
    Expect(1, 3839, '\p{Is_Blk=_lao}', "");
    Expect(0, 3839, '\p{^Is_Blk=_lao}', "");
    Expect(0, 3839, '\P{Is_Blk=_lao}', "");
    Expect(1, 3839, '\P{^Is_Blk=_lao}', "");
    Expect(0, 3840, '\p{Is_Blk=_lao}', "");
    Expect(1, 3840, '\p{^Is_Blk=_lao}', "");
    Expect(1, 3840, '\P{Is_Blk=_lao}', "");
    Expect(0, 3840, '\P{^Is_Blk=_lao}', "");
    Error('\p{Block=/a/-Latin_1_SUPPLEMENT}');
    Error('\P{Block=/a/-Latin_1_SUPPLEMENT}');
    Expect(1, 255, '\p{Block=:\ALatin_1_Supplement\z:}', "");;
    Expect(0, 256, '\p{Block=:\ALatin_1_Supplement\z:}', "");;
    Expect(1, 255, '\p{Block=latin1supplement}', "");
    Expect(0, 255, '\p{^Block=latin1supplement}', "");
    Expect(0, 255, '\P{Block=latin1supplement}', "");
    Expect(1, 255, '\P{^Block=latin1supplement}', "");
    Expect(0, 256, '\p{Block=latin1supplement}', "");
    Expect(1, 256, '\p{^Block=latin1supplement}', "");
    Expect(1, 256, '\P{Block=latin1supplement}', "");
    Expect(0, 256, '\P{^Block=latin1supplement}', "");
    Expect(1, 255, '\p{Block=:\Alatin1supplement\z:}', "");;
    Expect(0, 256, '\p{Block=:\Alatin1supplement\z:}', "");;
    Expect(1, 255, '\p{Block=-	LATIN_1_Supplement}', "");
    Expect(0, 255, '\p{^Block=-	LATIN_1_Supplement}', "");
    Expect(0, 255, '\P{Block=-	LATIN_1_Supplement}', "");
    Expect(1, 255, '\P{^Block=-	LATIN_1_Supplement}', "");
    Expect(0, 256, '\p{Block=-	LATIN_1_Supplement}', "");
    Expect(1, 256, '\p{^Block=-	LATIN_1_Supplement}', "");
    Expect(1, 256, '\P{Block=-	LATIN_1_Supplement}', "");
    Expect(0, 256, '\P{^Block=-	LATIN_1_Supplement}', "");
    Error('\p{Blk=_-latin_1_Sup/a/}');
    Error('\P{Blk=_-latin_1_Sup/a/}');
    Expect(1, 255, '\p{Blk=:\ALatin_1_Sup\z:}', "");;
    Expect(0, 256, '\p{Blk=:\ALatin_1_Sup\z:}', "");;
    Expect(1, 255, '\p{Blk=latin1sup}', "");
    Expect(0, 255, '\p{^Blk=latin1sup}', "");
    Expect(0, 255, '\P{Blk=latin1sup}', "");
    Expect(1, 255, '\P{^Blk=latin1sup}', "");
    Expect(0, 256, '\p{Blk=latin1sup}', "");
    Expect(1, 256, '\p{^Blk=latin1sup}', "");
    Expect(1, 256, '\P{Blk=latin1sup}', "");
    Expect(0, 256, '\P{^Blk=latin1sup}', "");
    Expect(1, 255, '\p{Blk=:\Alatin1sup\z:}', "");;
    Expect(0, 256, '\p{Blk=:\Alatin1sup\z:}', "");;
    Expect(1, 255, '\p{Blk=_latin_1_SUP}', "");
    Expect(0, 255, '\p{^Blk=_latin_1_SUP}', "");
    Expect(0, 255, '\P{Blk=_latin_1_SUP}', "");
    Expect(1, 255, '\P{^Blk=_latin_1_SUP}', "");
    Expect(0, 256, '\p{Blk=_latin_1_SUP}', "");
    Expect(1, 256, '\p{^Blk=_latin_1_SUP}', "");
    Expect(1, 256, '\P{Blk=_latin_1_SUP}', "");
    Expect(0, 256, '\P{^Blk=_latin_1_SUP}', "");
    Error('\p{Is_Block=:=Latin_1}');
    Error('\P{Is_Block=:=Latin_1}');
    Expect(1, 255, '\p{Is_Block=latin1}', "");
    Expect(0, 255, '\p{^Is_Block=latin1}', "");
    Expect(0, 255, '\P{Is_Block=latin1}', "");
    Expect(1, 255, '\P{^Is_Block=latin1}', "");
    Expect(0, 256, '\p{Is_Block=latin1}', "");
    Expect(1, 256, '\p{^Is_Block=latin1}', "");
    Expect(1, 256, '\P{Is_Block=latin1}', "");
    Expect(0, 256, '\P{^Is_Block=latin1}', "");
    Expect(1, 255, '\p{Is_Block=	 Latin_1}', "");
    Expect(0, 255, '\p{^Is_Block=	 Latin_1}', "");
    Expect(0, 255, '\P{Is_Block=	 Latin_1}', "");
    Expect(1, 255, '\P{^Is_Block=	 Latin_1}', "");
    Expect(0, 256, '\p{Is_Block=	 Latin_1}', "");
    Expect(1, 256, '\p{^Is_Block=	 Latin_1}', "");
    Expect(1, 256, '\P{Is_Block=	 Latin_1}', "");
    Expect(0, 256, '\P{^Is_Block=	 Latin_1}', "");
    Error('\p{Is_Blk=  Latin_1_SUPPLEMENT/a/}');
    Error('\P{Is_Blk=  Latin_1_SUPPLEMENT/a/}');
    Expect(1, 255, '\p{Is_Blk=latin1supplement}', "");
    Expect(0, 255, '\p{^Is_Blk=latin1supplement}', "");
    Expect(0, 255, '\P{Is_Blk=latin1supplement}', "");
    Expect(1, 255, '\P{^Is_Blk=latin1supplement}', "");
    Expect(0, 256, '\p{Is_Blk=latin1supplement}', "");
    Expect(1, 256, '\p{^Is_Blk=latin1supplement}', "");
    Expect(1, 256, '\P{Is_Blk=latin1supplement}', "");
    Expect(0, 256, '\P{^Is_Blk=latin1supplement}', "");
    Expect(1, 255, '\p{Is_Blk=_Latin_1_SUPPLEMENT}', "");
    Expect(0, 255, '\p{^Is_Blk=_Latin_1_SUPPLEMENT}', "");
    Expect(0, 255, '\P{Is_Blk=_Latin_1_SUPPLEMENT}', "");
    Expect(1, 255, '\P{^Is_Blk=_Latin_1_SUPPLEMENT}', "");
    Expect(0, 256, '\p{Is_Blk=_Latin_1_SUPPLEMENT}', "");
    Expect(1, 256, '\p{^Is_Blk=_Latin_1_SUPPLEMENT}', "");
    Expect(1, 256, '\P{Is_Blk=_Latin_1_SUPPLEMENT}', "");
    Expect(0, 256, '\P{^Is_Blk=_Latin_1_SUPPLEMENT}', "");
    Error('\p{Block=/a/-_latin_extended_a}');
    Error('\P{Block=/a/-_latin_extended_a}');
    Expect(1, 383, '\p{Block=:\ALatin_Extended_A\z:}', "");;
    Expect(0, 384, '\p{Block=:\ALatin_Extended_A\z:}', "");;
    Expect(1, 383, '\p{Block=latinextendeda}', "");
    Expect(0, 383, '\p{^Block=latinextendeda}', "");
    Expect(0, 383, '\P{Block=latinextendeda}', "");
    Expect(1, 383, '\P{^Block=latinextendeda}', "");
    Expect(0, 384, '\p{Block=latinextendeda}', "");
    Expect(1, 384, '\p{^Block=latinextendeda}', "");
    Expect(1, 384, '\P{Block=latinextendeda}', "");
    Expect(0, 384, '\P{^Block=latinextendeda}', "");
    Expect(1, 383, '\p{Block=:\Alatinextendeda\z:}', "");;
    Expect(0, 384, '\p{Block=:\Alatinextendeda\z:}', "");;
    Expect(1, 383, '\p{Block= 	latin_extended_A}', "");
    Expect(0, 383, '\p{^Block= 	latin_extended_A}', "");
    Expect(0, 383, '\P{Block= 	latin_extended_A}', "");
    Expect(1, 383, '\P{^Block= 	latin_extended_A}', "");
    Expect(0, 384, '\p{Block= 	latin_extended_A}', "");
    Expect(1, 384, '\p{^Block= 	latin_extended_A}', "");
    Expect(1, 384, '\P{Block= 	latin_extended_A}', "");
    Expect(0, 384, '\P{^Block= 	latin_extended_A}', "");
    Error('\p{Blk=-latin_Ext_A:=}');
    Error('\P{Blk=-latin_Ext_A:=}');
    Expect(1, 383, '\p{Blk=:\ALatin_Ext_A\z:}', "");;
    Expect(0, 384, '\p{Blk=:\ALatin_Ext_A\z:}', "");;
    Expect(1, 383, '\p{Blk=latinexta}', "");
    Expect(0, 383, '\p{^Blk=latinexta}', "");
    Expect(0, 383, '\P{Blk=latinexta}', "");
    Expect(1, 383, '\P{^Blk=latinexta}', "");
    Expect(0, 384, '\p{Blk=latinexta}', "");
    Expect(1, 384, '\p{^Blk=latinexta}', "");
    Expect(1, 384, '\P{Blk=latinexta}', "");
    Expect(0, 384, '\P{^Blk=latinexta}', "");
    Expect(1, 383, '\p{Blk=:\Alatinexta\z:}', "");;
    Expect(0, 384, '\p{Blk=:\Alatinexta\z:}', "");;
    Expect(1, 383, '\p{Blk=	Latin_EXT_A}', "");
    Expect(0, 383, '\p{^Blk=	Latin_EXT_A}', "");
    Expect(0, 383, '\P{Blk=	Latin_EXT_A}', "");
    Expect(1, 383, '\P{^Blk=	Latin_EXT_A}', "");
    Expect(0, 384, '\p{Blk=	Latin_EXT_A}', "");
    Expect(1, 384, '\p{^Blk=	Latin_EXT_A}', "");
    Expect(1, 384, '\P{Blk=	Latin_EXT_A}', "");
    Expect(0, 384, '\P{^Blk=	Latin_EXT_A}', "");
    Error('\p{Is_Block=:=_-latin_EXTENDED_A}');
    Error('\P{Is_Block=:=_-latin_EXTENDED_A}');
    Expect(1, 383, '\p{Is_Block=latinextendeda}', "");
    Expect(0, 383, '\p{^Is_Block=latinextendeda}', "");
    Expect(0, 383, '\P{Is_Block=latinextendeda}', "");
    Expect(1, 383, '\P{^Is_Block=latinextendeda}', "");
    Expect(0, 384, '\p{Is_Block=latinextendeda}', "");
    Expect(1, 384, '\p{^Is_Block=latinextendeda}', "");
    Expect(1, 384, '\P{Is_Block=latinextendeda}', "");
    Expect(0, 384, '\P{^Is_Block=latinextendeda}', "");
    Expect(1, 383, '\p{Is_Block=__LATIN_Extended_A}', "");
    Expect(0, 383, '\p{^Is_Block=__LATIN_Extended_A}', "");
    Expect(0, 383, '\P{Is_Block=__LATIN_Extended_A}', "");
    Expect(1, 383, '\P{^Is_Block=__LATIN_Extended_A}', "");
    Expect(0, 384, '\p{Is_Block=__LATIN_Extended_A}', "");
    Expect(1, 384, '\p{^Is_Block=__LATIN_Extended_A}', "");
    Expect(1, 384, '\P{Is_Block=__LATIN_Extended_A}', "");
    Expect(0, 384, '\P{^Is_Block=__LATIN_Extended_A}', "");
    Error('\p{Is_Blk=_-latin_EXT_A/a/}');
    Error('\P{Is_Blk=_-latin_EXT_A/a/}');
    Expect(1, 383, '\p{Is_Blk=latinexta}', "");
    Expect(0, 383, '\p{^Is_Blk=latinexta}', "");
    Expect(0, 383, '\P{Is_Blk=latinexta}', "");
    Expect(1, 383, '\P{^Is_Blk=latinexta}', "");
    Expect(0, 384, '\p{Is_Blk=latinexta}', "");
    Expect(1, 384, '\p{^Is_Blk=latinexta}', "");
    Expect(1, 384, '\P{Is_Blk=latinexta}', "");
    Expect(0, 384, '\P{^Is_Blk=latinexta}', "");
    Expect(1, 383, '\p{Is_Blk:  latin_Ext_A}', "");
    Expect(0, 383, '\p{^Is_Blk:  latin_Ext_A}', "");
    Expect(0, 383, '\P{Is_Blk:  latin_Ext_A}', "");
    Expect(1, 383, '\P{^Is_Blk:  latin_Ext_A}', "");
    Expect(0, 384, '\p{Is_Blk:  latin_Ext_A}', "");
    Expect(1, 384, '\p{^Is_Blk:  latin_Ext_A}', "");
    Expect(1, 384, '\P{Is_Blk:  latin_Ext_A}', "");
    Expect(0, 384, '\P{^Is_Blk:  latin_Ext_A}', "");
    Error('\p{Block=	 Latin_EXTENDED_Additional:=}');
    Error('\P{Block=	 Latin_EXTENDED_Additional:=}');
    Expect(1, 7935, '\p{Block=:\ALatin_Extended_Additional\z:}', "");;
    Expect(0, 7936, '\p{Block=:\ALatin_Extended_Additional\z:}', "");;
    Expect(1, 7935, '\p{Block=latinextendedadditional}', "");
    Expect(0, 7935, '\p{^Block=latinextendedadditional}', "");
    Expect(0, 7935, '\P{Block=latinextendedadditional}', "");
    Expect(1, 7935, '\P{^Block=latinextendedadditional}', "");
    Expect(0, 7936, '\p{Block=latinextendedadditional}', "");
    Expect(1, 7936, '\p{^Block=latinextendedadditional}', "");
    Expect(1, 7936, '\P{Block=latinextendedadditional}', "");
    Expect(0, 7936, '\P{^Block=latinextendedadditional}', "");
    Expect(1, 7935, '\p{Block=:\Alatinextendedadditional\z:}', "");;
    Expect(0, 7936, '\p{Block=:\Alatinextendedadditional\z:}', "");;
    Expect(1, 7935, '\p{Block= Latin_EXTENDED_Additional}', "");
    Expect(0, 7935, '\p{^Block= Latin_EXTENDED_Additional}', "");
    Expect(0, 7935, '\P{Block= Latin_EXTENDED_Additional}', "");
    Expect(1, 7935, '\P{^Block= Latin_EXTENDED_Additional}', "");
    Expect(0, 7936, '\p{Block= Latin_EXTENDED_Additional}', "");
    Expect(1, 7936, '\p{^Block= Latin_EXTENDED_Additional}', "");
    Expect(1, 7936, '\P{Block= Latin_EXTENDED_Additional}', "");
    Expect(0, 7936, '\P{^Block= Latin_EXTENDED_Additional}', "");
    Error('\p{Blk:   	Latin_EXT_ADDITIONAL:=}');
    Error('\P{Blk:   	Latin_EXT_ADDITIONAL:=}');
    Expect(1, 7935, '\p{Blk=:\ALatin_Ext_Additional\z:}', "");;
    Expect(0, 7936, '\p{Blk=:\ALatin_Ext_Additional\z:}', "");;
    Expect(1, 7935, '\p{Blk=latinextadditional}', "");
    Expect(0, 7935, '\p{^Blk=latinextadditional}', "");
    Expect(0, 7935, '\P{Blk=latinextadditional}', "");
    Expect(1, 7935, '\P{^Blk=latinextadditional}', "");
    Expect(0, 7936, '\p{Blk=latinextadditional}', "");
    Expect(1, 7936, '\p{^Blk=latinextadditional}', "");
    Expect(1, 7936, '\P{Blk=latinextadditional}', "");
    Expect(0, 7936, '\P{^Blk=latinextadditional}', "");
    Expect(1, 7935, '\p{Blk=:\Alatinextadditional\z:}', "");;
    Expect(0, 7936, '\p{Blk=:\Alatinextadditional\z:}', "");;
    Expect(1, 7935, '\p{Blk=__LATIN_Ext_additional}', "");
    Expect(0, 7935, '\p{^Blk=__LATIN_Ext_additional}', "");
    Expect(0, 7935, '\P{Blk=__LATIN_Ext_additional}', "");
    Expect(1, 7935, '\P{^Blk=__LATIN_Ext_additional}', "");
    Expect(0, 7936, '\p{Blk=__LATIN_Ext_additional}', "");
    Expect(1, 7936, '\p{^Blk=__LATIN_Ext_additional}', "");
    Expect(1, 7936, '\P{Blk=__LATIN_Ext_additional}', "");
    Expect(0, 7936, '\P{^Blk=__LATIN_Ext_additional}', "");
    Error('\p{Is_Block=/a/	-Latin_Extended_ADDITIONAL}');
    Error('\P{Is_Block=/a/	-Latin_Extended_ADDITIONAL}');
    Expect(1, 7935, '\p{Is_Block:latinextendedadditional}', "");
    Expect(0, 7935, '\p{^Is_Block:latinextendedadditional}', "");
    Expect(0, 7935, '\P{Is_Block:latinextendedadditional}', "");
    Expect(1, 7935, '\P{^Is_Block:latinextendedadditional}', "");
    Expect(0, 7936, '\p{Is_Block:latinextendedadditional}', "");
    Expect(1, 7936, '\p{^Is_Block:latinextendedadditional}', "");
    Expect(1, 7936, '\P{Is_Block:latinextendedadditional}', "");
    Expect(0, 7936, '\P{^Is_Block:latinextendedadditional}', "");
    Expect(1, 7935, '\p{Is_Block= -latin_extended_ADDITIONAL}', "");
    Expect(0, 7935, '\p{^Is_Block= -latin_extended_ADDITIONAL}', "");
    Expect(0, 7935, '\P{Is_Block= -latin_extended_ADDITIONAL}', "");
    Expect(1, 7935, '\P{^Is_Block= -latin_extended_ADDITIONAL}', "");
    Expect(0, 7936, '\p{Is_Block= -latin_extended_ADDITIONAL}', "");
    Expect(1, 7936, '\p{^Is_Block= -latin_extended_ADDITIONAL}', "");
    Expect(1, 7936, '\P{Is_Block= -latin_extended_ADDITIONAL}', "");
    Expect(0, 7936, '\P{^Is_Block= -latin_extended_ADDITIONAL}', "");
    Error('\p{Is_Blk=:=- latin_ext_ADDITIONAL}');
    Error('\P{Is_Blk=:=- latin_ext_ADDITIONAL}');
    Expect(1, 7935, '\p{Is_Blk: latinextadditional}', "");
    Expect(0, 7935, '\p{^Is_Blk: latinextadditional}', "");
    Expect(0, 7935, '\P{Is_Blk: latinextadditional}', "");
    Expect(1, 7935, '\P{^Is_Blk: latinextadditional}', "");
    Expect(0, 7936, '\p{Is_Blk: latinextadditional}', "");
    Expect(1, 7936, '\p{^Is_Blk: latinextadditional}', "");
    Expect(1, 7936, '\P{Is_Blk: latinextadditional}', "");
    Expect(0, 7936, '\P{^Is_Blk: latinextadditional}', "");
    Expect(1, 7935, '\p{Is_Blk=-latin_ext_Additional}', "");
    Expect(0, 7935, '\p{^Is_Blk=-latin_ext_Additional}', "");
    Expect(0, 7935, '\P{Is_Blk=-latin_ext_Additional}', "");
    Expect(1, 7935, '\P{^Is_Blk=-latin_ext_Additional}', "");
    Expect(0, 7936, '\p{Is_Blk=-latin_ext_Additional}', "");
    Expect(1, 7936, '\p{^Is_Blk=-latin_ext_Additional}', "");
    Expect(1, 7936, '\P{Is_Blk=-latin_ext_Additional}', "");
    Expect(0, 7936, '\P{^Is_Blk=-latin_ext_Additional}', "");
    Error('\p{Block=-LATIN_Extended_B:=}');
    Error('\P{Block=-LATIN_Extended_B:=}');
    Expect(1, 591, '\p{Block=:\ALatin_Extended_B\z:}', "");;
    Expect(0, 592, '\p{Block=:\ALatin_Extended_B\z:}', "");;
    Expect(1, 591, '\p{Block=latinextendedb}', "");
    Expect(0, 591, '\p{^Block=latinextendedb}', "");
    Expect(0, 591, '\P{Block=latinextendedb}', "");
    Expect(1, 591, '\P{^Block=latinextendedb}', "");
    Expect(0, 592, '\p{Block=latinextendedb}', "");
    Expect(1, 592, '\p{^Block=latinextendedb}', "");
    Expect(1, 592, '\P{Block=latinextendedb}', "");
    Expect(0, 592, '\P{^Block=latinextendedb}', "");
    Expect(1, 591, '\p{Block=:\Alatinextendedb\z:}', "");;
    Expect(0, 592, '\p{Block=:\Alatinextendedb\z:}', "");;
    Expect(1, 591, '\p{Block=Latin_Extended_b}', "");
    Expect(0, 591, '\p{^Block=Latin_Extended_b}', "");
    Expect(0, 591, '\P{Block=Latin_Extended_b}', "");
    Expect(1, 591, '\P{^Block=Latin_Extended_b}', "");
    Expect(0, 592, '\p{Block=Latin_Extended_b}', "");
    Expect(1, 592, '\p{^Block=Latin_Extended_b}', "");
    Expect(1, 592, '\P{Block=Latin_Extended_b}', "");
    Expect(0, 592, '\P{^Block=Latin_Extended_b}', "");
    Error('\p{Blk=-Latin_EXT_B/a/}');
    Error('\P{Blk=-Latin_EXT_B/a/}');
    Expect(1, 591, '\p{Blk=:\ALatin_Ext_B\z:}', "");;
    Expect(0, 592, '\p{Blk=:\ALatin_Ext_B\z:}', "");;
    Expect(1, 591, '\p{Blk=latinextb}', "");
    Expect(0, 591, '\p{^Blk=latinextb}', "");
    Expect(0, 591, '\P{Blk=latinextb}', "");
    Expect(1, 591, '\P{^Blk=latinextb}', "");
    Expect(0, 592, '\p{Blk=latinextb}', "");
    Expect(1, 592, '\p{^Blk=latinextb}', "");
    Expect(1, 592, '\P{Blk=latinextb}', "");
    Expect(0, 592, '\P{^Blk=latinextb}', "");
    Expect(1, 591, '\p{Blk=:\Alatinextb\z:}', "");;
    Expect(0, 592, '\p{Blk=:\Alatinextb\z:}', "");;
    Expect(1, 591, '\p{Blk=_ latin_ext_B}', "");
    Expect(0, 591, '\p{^Blk=_ latin_ext_B}', "");
    Expect(0, 591, '\P{Blk=_ latin_ext_B}', "");
    Expect(1, 591, '\P{^Blk=_ latin_ext_B}', "");
    Expect(0, 592, '\p{Blk=_ latin_ext_B}', "");
    Expect(1, 592, '\p{^Blk=_ latin_ext_B}', "");
    Expect(1, 592, '\P{Blk=_ latin_ext_B}', "");
    Expect(0, 592, '\P{^Blk=_ latin_ext_B}', "");
    Error('\p{Is_Block:	-latin_extended_B/a/}');
    Error('\P{Is_Block:	-latin_extended_B/a/}');
    Expect(1, 591, '\p{Is_Block=latinextendedb}', "");
    Expect(0, 591, '\p{^Is_Block=latinextendedb}', "");
    Expect(0, 591, '\P{Is_Block=latinextendedb}', "");
    Expect(1, 591, '\P{^Is_Block=latinextendedb}', "");
    Expect(0, 592, '\p{Is_Block=latinextendedb}', "");
    Expect(1, 592, '\p{^Is_Block=latinextendedb}', "");
    Expect(1, 592, '\P{Is_Block=latinextendedb}', "");
    Expect(0, 592, '\P{^Is_Block=latinextendedb}', "");
    Expect(1, 591, '\p{Is_Block:   Latin_Extended_b}', "");
    Expect(0, 591, '\p{^Is_Block:   Latin_Extended_b}', "");
    Expect(0, 591, '\P{Is_Block:   Latin_Extended_b}', "");
    Expect(1, 591, '\P{^Is_Block:   Latin_Extended_b}', "");
    Expect(0, 592, '\p{Is_Block:   Latin_Extended_b}', "");
    Expect(1, 592, '\p{^Is_Block:   Latin_Extended_b}', "");
    Expect(1, 592, '\P{Is_Block:   Latin_Extended_b}', "");
    Expect(0, 592, '\P{^Is_Block:   Latin_Extended_b}', "");
    Error('\p{Is_Blk=-:=LATIN_ext_b}');
    Error('\P{Is_Blk=-:=LATIN_ext_b}');
    Expect(1, 591, '\p{Is_Blk=latinextb}', "");
    Expect(0, 591, '\p{^Is_Blk=latinextb}', "");
    Expect(0, 591, '\P{Is_Blk=latinextb}', "");
    Expect(1, 591, '\P{^Is_Blk=latinextb}', "");
    Expect(0, 592, '\p{Is_Blk=latinextb}', "");
    Expect(1, 592, '\p{^Is_Blk=latinextb}', "");
    Expect(1, 592, '\P{Is_Blk=latinextb}', "");
    Expect(0, 592, '\P{^Is_Blk=latinextb}', "");
    Expect(1, 591, '\p{Is_Blk=_Latin_EXT_B}', "");
    Expect(0, 591, '\p{^Is_Blk=_Latin_EXT_B}', "");
    Expect(0, 591, '\P{Is_Blk=_Latin_EXT_B}', "");
    Expect(1, 591, '\P{^Is_Blk=_Latin_EXT_B}', "");
    Expect(0, 592, '\p{Is_Blk=_Latin_EXT_B}', "");
    Expect(1, 592, '\p{^Is_Blk=_Latin_EXT_B}', "");
    Expect(1, 592, '\P{Is_Blk=_Latin_EXT_B}', "");
    Expect(0, 592, '\P{^Is_Blk=_Latin_EXT_B}', "");
    Error('\p{Block=-/a/Latin_Extended_C}');
    Error('\P{Block=-/a/Latin_Extended_C}');
    Expect(1, 11391, '\p{Block=:\ALatin_Extended_C\z:}', "");;
    Expect(0, 11392, '\p{Block=:\ALatin_Extended_C\z:}', "");;
    Expect(1, 11391, '\p{Block=latinextendedc}', "");
    Expect(0, 11391, '\p{^Block=latinextendedc}', "");
    Expect(0, 11391, '\P{Block=latinextendedc}', "");
    Expect(1, 11391, '\P{^Block=latinextendedc}', "");
    Expect(0, 11392, '\p{Block=latinextendedc}', "");
    Expect(1, 11392, '\p{^Block=latinextendedc}', "");
    Expect(1, 11392, '\P{Block=latinextendedc}', "");
    Expect(0, 11392, '\P{^Block=latinextendedc}', "");
    Expect(1, 11391, '\p{Block=:\Alatinextendedc\z:}', "");;
    Expect(0, 11392, '\p{Block=:\Alatinextendedc\z:}', "");;
    Expect(1, 11391, '\p{Block= _Latin_extended_C}', "");
    Expect(0, 11391, '\p{^Block= _Latin_extended_C}', "");
    Expect(0, 11391, '\P{Block= _Latin_extended_C}', "");
    Expect(1, 11391, '\P{^Block= _Latin_extended_C}', "");
    Expect(0, 11392, '\p{Block= _Latin_extended_C}', "");
    Expect(1, 11392, '\p{^Block= _Latin_extended_C}', "");
    Expect(1, 11392, '\P{Block= _Latin_extended_C}', "");
    Expect(0, 11392, '\P{^Block= _Latin_extended_C}', "");
    Error('\p{Blk=/a/	_Latin_Ext_C}');
    Error('\P{Blk=/a/	_Latin_Ext_C}');
    Expect(1, 11391, '\p{Blk=:\ALatin_Ext_C\z:}', "");;
    Expect(0, 11392, '\p{Blk=:\ALatin_Ext_C\z:}', "");;
    Expect(1, 11391, '\p{Blk: latinextc}', "");
    Expect(0, 11391, '\p{^Blk: latinextc}', "");
    Expect(0, 11391, '\P{Blk: latinextc}', "");
    Expect(1, 11391, '\P{^Blk: latinextc}', "");
    Expect(0, 11392, '\p{Blk: latinextc}', "");
    Expect(1, 11392, '\p{^Blk: latinextc}', "");
    Expect(1, 11392, '\P{Blk: latinextc}', "");
    Expect(0, 11392, '\P{^Blk: latinextc}', "");
    Expect(1, 11391, '\p{Blk=:\Alatinextc\z:}', "");;
    Expect(0, 11392, '\p{Blk=:\Alatinextc\z:}', "");;
    Expect(1, 11391, '\p{Blk= 	LATIN_EXT_C}', "");
    Expect(0, 11391, '\p{^Blk= 	LATIN_EXT_C}', "");
    Expect(0, 11391, '\P{Blk= 	LATIN_EXT_C}', "");
    Expect(1, 11391, '\P{^Blk= 	LATIN_EXT_C}', "");
    Expect(0, 11392, '\p{Blk= 	LATIN_EXT_C}', "");
    Expect(1, 11392, '\p{^Blk= 	LATIN_EXT_C}', "");
    Expect(1, 11392, '\P{Blk= 	LATIN_EXT_C}', "");
    Expect(0, 11392, '\P{^Blk= 	LATIN_EXT_C}', "");
    Error('\p{Is_Block=	:=latin_Extended_C}');
    Error('\P{Is_Block=	:=latin_Extended_C}');
    Expect(1, 11391, '\p{Is_Block=latinextendedc}', "");
    Expect(0, 11391, '\p{^Is_Block=latinextendedc}', "");
    Expect(0, 11391, '\P{Is_Block=latinextendedc}', "");
    Expect(1, 11391, '\P{^Is_Block=latinextendedc}', "");
    Expect(0, 11392, '\p{Is_Block=latinextendedc}', "");
    Expect(1, 11392, '\p{^Is_Block=latinextendedc}', "");
    Expect(1, 11392, '\P{Is_Block=latinextendedc}', "");
    Expect(0, 11392, '\P{^Is_Block=latinextendedc}', "");
    Expect(1, 11391, '\p{Is_Block=-	Latin_extended_C}', "");
    Expect(0, 11391, '\p{^Is_Block=-	Latin_extended_C}', "");
    Expect(0, 11391, '\P{Is_Block=-	Latin_extended_C}', "");
    Expect(1, 11391, '\P{^Is_Block=-	Latin_extended_C}', "");
    Expect(0, 11392, '\p{Is_Block=-	Latin_extended_C}', "");
    Expect(1, 11392, '\p{^Is_Block=-	Latin_extended_C}', "");
    Expect(1, 11392, '\P{Is_Block=-	Latin_extended_C}', "");
    Expect(0, 11392, '\P{^Is_Block=-	Latin_extended_C}', "");
    Error('\p{Is_Blk=:=	-latin_ext_C}');
    Error('\P{Is_Blk=:=	-latin_ext_C}');
    Expect(1, 11391, '\p{Is_Blk=latinextc}', "");
    Expect(0, 11391, '\p{^Is_Blk=latinextc}', "");
    Expect(0, 11391, '\P{Is_Blk=latinextc}', "");
    Expect(1, 11391, '\P{^Is_Blk=latinextc}', "");
    Expect(0, 11392, '\p{Is_Blk=latinextc}', "");
    Expect(1, 11392, '\p{^Is_Blk=latinextc}', "");
    Expect(1, 11392, '\P{Is_Blk=latinextc}', "");
    Expect(0, 11392, '\P{^Is_Blk=latinextc}', "");
    Expect(1, 11391, '\p{Is_Blk=	latin_Ext_C}', "");
    Expect(0, 11391, '\p{^Is_Blk=	latin_Ext_C}', "");
    Expect(0, 11391, '\P{Is_Blk=	latin_Ext_C}', "");
    Expect(1, 11391, '\P{^Is_Blk=	latin_Ext_C}', "");
    Expect(0, 11392, '\p{Is_Blk=	latin_Ext_C}', "");
    Expect(1, 11392, '\p{^Is_Blk=	latin_Ext_C}', "");
    Expect(1, 11392, '\P{Is_Blk=	latin_Ext_C}', "");
    Expect(0, 11392, '\P{^Is_Blk=	latin_Ext_C}', "");
    Error('\p{Block=/a/__latin_Extended_D}');
    Error('\P{Block=/a/__latin_Extended_D}');
    Expect(1, 43007, '\p{Block=:\ALatin_Extended_D\z:}', "");;
    Expect(0, 43008, '\p{Block=:\ALatin_Extended_D\z:}', "");;
    Expect(1, 43007, '\p{Block=latinextendedd}', "");
    Expect(0, 43007, '\p{^Block=latinextendedd}', "");
    Expect(0, 43007, '\P{Block=latinextendedd}', "");
    Expect(1, 43007, '\P{^Block=latinextendedd}', "");
    Expect(0, 43008, '\p{Block=latinextendedd}', "");
    Expect(1, 43008, '\p{^Block=latinextendedd}', "");
    Expect(1, 43008, '\P{Block=latinextendedd}', "");
    Expect(0, 43008, '\P{^Block=latinextendedd}', "");
    Expect(1, 43007, '\p{Block=:\Alatinextendedd\z:}', "");;
    Expect(0, 43008, '\p{Block=:\Alatinextendedd\z:}', "");;
    Expect(1, 43007, '\p{Block=-	Latin_Extended_D}', "");
    Expect(0, 43007, '\p{^Block=-	Latin_Extended_D}', "");
    Expect(0, 43007, '\P{Block=-	Latin_Extended_D}', "");
    Expect(1, 43007, '\P{^Block=-	Latin_Extended_D}', "");
    Expect(0, 43008, '\p{Block=-	Latin_Extended_D}', "");
    Expect(1, 43008, '\p{^Block=-	Latin_Extended_D}', "");
    Expect(1, 43008, '\P{Block=-	Latin_Extended_D}', "");
    Expect(0, 43008, '\P{^Block=-	Latin_Extended_D}', "");
    Error('\p{Blk= :=Latin_Ext_d}');
    Error('\P{Blk= :=Latin_Ext_d}');
    Expect(1, 43007, '\p{Blk=:\ALatin_Ext_D\z:}', "");;
    Expect(0, 43008, '\p{Blk=:\ALatin_Ext_D\z:}', "");;
    Expect(1, 43007, '\p{Blk=latinextd}', "");
    Expect(0, 43007, '\p{^Blk=latinextd}', "");
    Expect(0, 43007, '\P{Blk=latinextd}', "");
    Expect(1, 43007, '\P{^Blk=latinextd}', "");
    Expect(0, 43008, '\p{Blk=latinextd}', "");
    Expect(1, 43008, '\p{^Blk=latinextd}', "");
    Expect(1, 43008, '\P{Blk=latinextd}', "");
    Expect(0, 43008, '\P{^Blk=latinextd}', "");
    Expect(1, 43007, '\p{Blk=:\Alatinextd\z:}', "");;
    Expect(0, 43008, '\p{Blk=:\Alatinextd\z:}', "");;
    Expect(1, 43007, '\p{Blk=__Latin_ext_D}', "");
    Expect(0, 43007, '\p{^Blk=__Latin_ext_D}', "");
    Expect(0, 43007, '\P{Blk=__Latin_ext_D}', "");
    Expect(1, 43007, '\P{^Blk=__Latin_ext_D}', "");
    Expect(0, 43008, '\p{Blk=__Latin_ext_D}', "");
    Expect(1, 43008, '\p{^Blk=__Latin_ext_D}', "");
    Expect(1, 43008, '\P{Blk=__Latin_ext_D}', "");
    Expect(0, 43008, '\P{^Blk=__Latin_ext_D}', "");
    Error('\p{Is_Block=_:=LATIN_Extended_d}');
    Error('\P{Is_Block=_:=LATIN_Extended_d}');
    Expect(1, 43007, '\p{Is_Block=latinextendedd}', "");
    Expect(0, 43007, '\p{^Is_Block=latinextendedd}', "");
    Expect(0, 43007, '\P{Is_Block=latinextendedd}', "");
    Expect(1, 43007, '\P{^Is_Block=latinextendedd}', "");
    Expect(0, 43008, '\p{Is_Block=latinextendedd}', "");
    Expect(1, 43008, '\p{^Is_Block=latinextendedd}', "");
    Expect(1, 43008, '\P{Is_Block=latinextendedd}', "");
    Expect(0, 43008, '\P{^Is_Block=latinextendedd}', "");
    Expect(1, 43007, '\p{Is_Block=-Latin_Extended_D}', "");
    Expect(0, 43007, '\p{^Is_Block=-Latin_Extended_D}', "");
    Expect(0, 43007, '\P{Is_Block=-Latin_Extended_D}', "");
    Expect(1, 43007, '\P{^Is_Block=-Latin_Extended_D}', "");
    Expect(0, 43008, '\p{Is_Block=-Latin_Extended_D}', "");
    Expect(1, 43008, '\p{^Is_Block=-Latin_Extended_D}', "");
    Expect(1, 43008, '\P{Is_Block=-Latin_Extended_D}', "");
    Expect(0, 43008, '\P{^Is_Block=-Latin_Extended_D}', "");
    Error('\p{Is_Blk: LATIN_ext_D/a/}');
    Error('\P{Is_Blk: LATIN_ext_D/a/}');
    Expect(1, 43007, '\p{Is_Blk=latinextd}', "");
    Expect(0, 43007, '\p{^Is_Blk=latinextd}', "");
    Expect(0, 43007, '\P{Is_Blk=latinextd}', "");
    Expect(1, 43007, '\P{^Is_Blk=latinextd}', "");
    Expect(0, 43008, '\p{Is_Blk=latinextd}', "");
    Expect(1, 43008, '\p{^Is_Blk=latinextd}', "");
    Expect(1, 43008, '\P{Is_Blk=latinextd}', "");
    Expect(0, 43008, '\P{^Is_Blk=latinextd}', "");
    Expect(1, 43007, '\p{Is_Blk=	-LATIN_Ext_D}', "");
    Expect(0, 43007, '\p{^Is_Blk=	-LATIN_Ext_D}', "");
    Expect(0, 43007, '\P{Is_Blk=	-LATIN_Ext_D}', "");
    Expect(1, 43007, '\P{^Is_Blk=	-LATIN_Ext_D}', "");
    Expect(0, 43008, '\p{Is_Blk=	-LATIN_Ext_D}', "");
    Expect(1, 43008, '\p{^Is_Blk=	-LATIN_Ext_D}', "");
    Expect(1, 43008, '\P{Is_Blk=	-LATIN_Ext_D}', "");
    Expect(0, 43008, '\P{^Is_Blk=	-LATIN_Ext_D}', "");
    Error('\p{Block=:=latin_extended_e}');
    Error('\P{Block=:=latin_extended_e}');
    Expect(1, 43887, '\p{Block=:\ALatin_Extended_E\z:}', "");;
    Expect(0, 43888, '\p{Block=:\ALatin_Extended_E\z:}', "");;
    Expect(1, 43887, '\p{Block: latinextendede}', "");
    Expect(0, 43887, '\p{^Block: latinextendede}', "");
    Expect(0, 43887, '\P{Block: latinextendede}', "");
    Expect(1, 43887, '\P{^Block: latinextendede}', "");
    Expect(0, 43888, '\p{Block: latinextendede}', "");
    Expect(1, 43888, '\p{^Block: latinextendede}', "");
    Expect(1, 43888, '\P{Block: latinextendede}', "");
    Expect(0, 43888, '\P{^Block: latinextendede}', "");
    Expect(1, 43887, '\p{Block=:\Alatinextendede\z:}', "");;
    Expect(0, 43888, '\p{Block=:\Alatinextendede\z:}', "");;
    Expect(1, 43887, '\p{Block=_-Latin_Extended_E}', "");
    Expect(0, 43887, '\p{^Block=_-Latin_Extended_E}', "");
    Expect(0, 43887, '\P{Block=_-Latin_Extended_E}', "");
    Expect(1, 43887, '\P{^Block=_-Latin_Extended_E}', "");
    Expect(0, 43888, '\p{Block=_-Latin_Extended_E}', "");
    Expect(1, 43888, '\p{^Block=_-Latin_Extended_E}', "");
    Expect(1, 43888, '\P{Block=_-Latin_Extended_E}', "");
    Expect(0, 43888, '\P{^Block=_-Latin_Extended_E}', "");
    Error('\p{Blk:		/a/LATIN_EXT_E}');
    Error('\P{Blk:		/a/LATIN_EXT_E}');
    Expect(1, 43887, '\p{Blk=:\ALatin_Ext_E\z:}', "");;
    Expect(0, 43888, '\p{Blk=:\ALatin_Ext_E\z:}', "");;
    Expect(1, 43887, '\p{Blk=latinexte}', "");
    Expect(0, 43887, '\p{^Blk=latinexte}', "");
    Expect(0, 43887, '\P{Blk=latinexte}', "");
    Expect(1, 43887, '\P{^Blk=latinexte}', "");
    Expect(0, 43888, '\p{Blk=latinexte}', "");
    Expect(1, 43888, '\p{^Blk=latinexte}', "");
    Expect(1, 43888, '\P{Blk=latinexte}', "");
    Expect(0, 43888, '\P{^Blk=latinexte}', "");
    Expect(1, 43887, '\p{Blk=:\Alatinexte\z:}', "");;
    Expect(0, 43888, '\p{Blk=:\Alatinexte\z:}', "");;
    Expect(1, 43887, '\p{Blk=  Latin_ext_E}', "");
    Expect(0, 43887, '\p{^Blk=  Latin_ext_E}', "");
    Expect(0, 43887, '\P{Blk=  Latin_ext_E}', "");
    Expect(1, 43887, '\P{^Blk=  Latin_ext_E}', "");
    Expect(0, 43888, '\p{Blk=  Latin_ext_E}', "");
    Expect(1, 43888, '\p{^Blk=  Latin_ext_E}', "");
    Expect(1, 43888, '\P{Blk=  Latin_ext_E}', "");
    Expect(0, 43888, '\P{^Blk=  Latin_ext_E}', "");
    Error('\p{Is_Block= 	Latin_Extended_E:=}');
    Error('\P{Is_Block= 	Latin_Extended_E:=}');
    Expect(1, 43887, '\p{Is_Block=latinextendede}', "");
    Expect(0, 43887, '\p{^Is_Block=latinextendede}', "");
    Expect(0, 43887, '\P{Is_Block=latinextendede}', "");
    Expect(1, 43887, '\P{^Is_Block=latinextendede}', "");
    Expect(0, 43888, '\p{Is_Block=latinextendede}', "");
    Expect(1, 43888, '\p{^Is_Block=latinextendede}', "");
    Expect(1, 43888, '\P{Is_Block=latinextendede}', "");
    Expect(0, 43888, '\P{^Is_Block=latinextendede}', "");
    Expect(1, 43887, '\p{Is_Block=_-LATIN_extended_E}', "");
    Expect(0, 43887, '\p{^Is_Block=_-LATIN_extended_E}', "");
    Expect(0, 43887, '\P{Is_Block=_-LATIN_extended_E}', "");
    Expect(1, 43887, '\P{^Is_Block=_-LATIN_extended_E}', "");
    Expect(0, 43888, '\p{Is_Block=_-LATIN_extended_E}', "");
    Expect(1, 43888, '\p{^Is_Block=_-LATIN_extended_E}', "");
    Expect(1, 43888, '\P{Is_Block=_-LATIN_extended_E}', "");
    Expect(0, 43888, '\P{^Is_Block=_-LATIN_extended_E}', "");
    Error('\p{Is_Blk=-/a/Latin_EXT_E}');
    Error('\P{Is_Blk=-/a/Latin_EXT_E}');
    Expect(1, 43887, '\p{Is_Blk=latinexte}', "");
    Expect(0, 43887, '\p{^Is_Blk=latinexte}', "");
    Expect(0, 43887, '\P{Is_Blk=latinexte}', "");
    Expect(1, 43887, '\P{^Is_Blk=latinexte}', "");
    Expect(0, 43888, '\p{Is_Blk=latinexte}', "");
    Expect(1, 43888, '\p{^Is_Blk=latinexte}', "");
    Expect(1, 43888, '\P{Is_Blk=latinexte}', "");
    Expect(0, 43888, '\P{^Is_Blk=latinexte}', "");
    Expect(1, 43887, '\p{Is_Blk=_ Latin_EXT_E}', "");
    Expect(0, 43887, '\p{^Is_Blk=_ Latin_EXT_E}', "");
    Expect(0, 43887, '\P{Is_Blk=_ Latin_EXT_E}', "");
    Expect(1, 43887, '\P{^Is_Blk=_ Latin_EXT_E}', "");
    Expect(0, 43888, '\p{Is_Blk=_ Latin_EXT_E}', "");
    Expect(1, 43888, '\p{^Is_Blk=_ Latin_EXT_E}', "");
    Expect(1, 43888, '\P{Is_Blk=_ Latin_EXT_E}', "");
    Expect(0, 43888, '\P{^Is_Blk=_ Latin_EXT_E}', "");
    Error('\p{Block=:=-_Latin_Extended_F}');
    Error('\P{Block=:=-_Latin_Extended_F}');
    Expect(1, 67519, '\p{Block=:\ALatin_Extended_F\z:}', "");;
    Expect(0, 67520, '\p{Block=:\ALatin_Extended_F\z:}', "");;
    Expect(1, 67519, '\p{Block=latinextendedf}', "");
    Expect(0, 67519, '\p{^Block=latinextendedf}', "");
    Expect(0, 67519, '\P{Block=latinextendedf}', "");
    Expect(1, 67519, '\P{^Block=latinextendedf}', "");
    Expect(0, 67520, '\p{Block=latinextendedf}', "");
    Expect(1, 67520, '\p{^Block=latinextendedf}', "");
    Expect(1, 67520, '\P{Block=latinextendedf}', "");
    Expect(0, 67520, '\P{^Block=latinextendedf}', "");
    Expect(1, 67519, '\p{Block=:\Alatinextendedf\z:}', "");;
    Expect(0, 67520, '\p{Block=:\Alatinextendedf\z:}', "");;
    Expect(1, 67519, '\p{Block=_LATIN_EXTENDED_F}', "");
    Expect(0, 67519, '\p{^Block=_LATIN_EXTENDED_F}', "");
    Expect(0, 67519, '\P{Block=_LATIN_EXTENDED_F}', "");
    Expect(1, 67519, '\P{^Block=_LATIN_EXTENDED_F}', "");
    Expect(0, 67520, '\p{Block=_LATIN_EXTENDED_F}', "");
    Expect(1, 67520, '\p{^Block=_LATIN_EXTENDED_F}', "");
    Expect(1, 67520, '\P{Block=_LATIN_EXTENDED_F}', "");
    Expect(0, 67520, '\P{^Block=_LATIN_EXTENDED_F}', "");
    Error('\p{Blk: /a/- LATIN_Ext_f}');
    Error('\P{Blk: /a/- LATIN_Ext_f}');
    Expect(1, 67519, '\p{Blk=:\ALatin_Ext_F\z:}', "");;
    Expect(0, 67520, '\p{Blk=:\ALatin_Ext_F\z:}', "");;
    Expect(1, 67519, '\p{Blk=latinextf}', "");
    Expect(0, 67519, '\p{^Blk=latinextf}', "");
    Expect(0, 67519, '\P{Blk=latinextf}', "");
    Expect(1, 67519, '\P{^Blk=latinextf}', "");
    Expect(0, 67520, '\p{Blk=latinextf}', "");
    Expect(1, 67520, '\p{^Blk=latinextf}', "");
    Expect(1, 67520, '\P{Blk=latinextf}', "");
    Expect(0, 67520, '\P{^Blk=latinextf}', "");
    Expect(1, 67519, '\p{Blk=:\Alatinextf\z:}', "");;
    Expect(0, 67520, '\p{Blk=:\Alatinextf\z:}', "");;
    Expect(1, 67519, '\p{Blk= Latin_EXT_F}', "");
    Expect(0, 67519, '\p{^Blk= Latin_EXT_F}', "");
    Expect(0, 67519, '\P{Blk= Latin_EXT_F}', "");
    Expect(1, 67519, '\P{^Blk= Latin_EXT_F}', "");
    Expect(0, 67520, '\p{Blk= Latin_EXT_F}', "");
    Expect(1, 67520, '\p{^Blk= Latin_EXT_F}', "");
    Expect(1, 67520, '\P{Blk= Latin_EXT_F}', "");
    Expect(0, 67520, '\P{^Blk= Latin_EXT_F}', "");
    Error('\p{Is_Block=	-Latin_Extended_f:=}');
    Error('\P{Is_Block=	-Latin_Extended_f:=}');
    Expect(1, 67519, '\p{Is_Block=latinextendedf}', "");
    Expect(0, 67519, '\p{^Is_Block=latinextendedf}', "");
    Expect(0, 67519, '\P{Is_Block=latinextendedf}', "");
    Expect(1, 67519, '\P{^Is_Block=latinextendedf}', "");
    Expect(0, 67520, '\p{Is_Block=latinextendedf}', "");
    Expect(1, 67520, '\p{^Is_Block=latinextendedf}', "");
    Expect(1, 67520, '\P{Is_Block=latinextendedf}', "");
    Expect(0, 67520, '\P{^Is_Block=latinextendedf}', "");
    Expect(1, 67519, '\p{Is_Block=	-LATIN_extended_F}', "");
    Expect(0, 67519, '\p{^Is_Block=	-LATIN_extended_F}', "");
    Expect(0, 67519, '\P{Is_Block=	-LATIN_extended_F}', "");
    Expect(1, 67519, '\P{^Is_Block=	-LATIN_extended_F}', "");
    Expect(0, 67520, '\p{Is_Block=	-LATIN_extended_F}', "");
    Expect(1, 67520, '\p{^Is_Block=	-LATIN_extended_F}', "");
    Expect(1, 67520, '\P{Is_Block=	-LATIN_extended_F}', "");
    Expect(0, 67520, '\P{^Is_Block=	-LATIN_extended_F}', "");
    Error('\p{Is_Blk=-:=latin_EXT_F}');
    Error('\P{Is_Blk=-:=latin_EXT_F}');
    Expect(1, 67519, '\p{Is_Blk=latinextf}', "");
    Expect(0, 67519, '\p{^Is_Blk=latinextf}', "");
    Expect(0, 67519, '\P{Is_Blk=latinextf}', "");
    Expect(1, 67519, '\P{^Is_Blk=latinextf}', "");
    Expect(0, 67520, '\p{Is_Blk=latinextf}', "");
    Expect(1, 67520, '\p{^Is_Blk=latinextf}', "");
    Expect(1, 67520, '\P{Is_Blk=latinextf}', "");
    Expect(0, 67520, '\P{^Is_Blk=latinextf}', "");
    Expect(1, 67519, '\p{Is_Blk=__latin_Ext_F}', "");
    Expect(0, 67519, '\p{^Is_Blk=__latin_Ext_F}', "");
    Expect(0, 67519, '\P{Is_Blk=__latin_Ext_F}', "");
    Expect(1, 67519, '\P{^Is_Blk=__latin_Ext_F}', "");
    Expect(0, 67520, '\p{Is_Blk=__latin_Ext_F}', "");
    Expect(1, 67520, '\p{^Is_Blk=__latin_Ext_F}', "");
    Expect(1, 67520, '\P{Is_Blk=__latin_Ext_F}', "");
    Expect(0, 67520, '\P{^Is_Blk=__latin_Ext_F}', "");
    Error('\p{Block=_:=Latin_extended_G}');
    Error('\P{Block=_:=Latin_extended_G}');
    Expect(1, 122879, '\p{Block=:\ALatin_Extended_G\z:}', "");;
    Expect(0, 122880, '\p{Block=:\ALatin_Extended_G\z:}', "");;
    Expect(1, 122879, '\p{Block=latinextendedg}', "");
    Expect(0, 122879, '\p{^Block=latinextendedg}', "");
    Expect(0, 122879, '\P{Block=latinextendedg}', "");
    Expect(1, 122879, '\P{^Block=latinextendedg}', "");
    Expect(0, 122880, '\p{Block=latinextendedg}', "");
    Expect(1, 122880, '\p{^Block=latinextendedg}', "");
    Expect(1, 122880, '\P{Block=latinextendedg}', "");
    Expect(0, 122880, '\P{^Block=latinextendedg}', "");
    Expect(1, 122879, '\p{Block=:\Alatinextendedg\z:}', "");;
    Expect(0, 122880, '\p{Block=:\Alatinextendedg\z:}', "");;
    Expect(1, 122879, '\p{Block=-	LATIN_extended_g}', "");
    Expect(0, 122879, '\p{^Block=-	LATIN_extended_g}', "");
    Expect(0, 122879, '\P{Block=-	LATIN_extended_g}', "");
    Expect(1, 122879, '\P{^Block=-	LATIN_extended_g}', "");
    Expect(0, 122880, '\p{Block=-	LATIN_extended_g}', "");
    Expect(1, 122880, '\p{^Block=-	LATIN_extended_g}', "");
    Expect(1, 122880, '\P{Block=-	LATIN_extended_g}', "");
    Expect(0, 122880, '\P{^Block=-	LATIN_extended_g}', "");
    Error('\p{Blk=/a/	-latin_EXT_G}');
    Error('\P{Blk=/a/	-latin_EXT_G}');
    Expect(1, 122879, '\p{Blk=:\ALatin_Ext_G\z:}', "");;
    Expect(0, 122880, '\p{Blk=:\ALatin_Ext_G\z:}', "");;
    Expect(1, 122879, '\p{Blk=latinextg}', "");
    Expect(0, 122879, '\p{^Blk=latinextg}', "");
    Expect(0, 122879, '\P{Blk=latinextg}', "");
    Expect(1, 122879, '\P{^Blk=latinextg}', "");
    Expect(0, 122880, '\p{Blk=latinextg}', "");
    Expect(1, 122880, '\p{^Blk=latinextg}', "");
    Expect(1, 122880, '\P{Blk=latinextg}', "");
    Expect(0, 122880, '\P{^Blk=latinextg}', "");
    Expect(1, 122879, '\p{Blk=:\Alatinextg\z:}', "");;
    Expect(0, 122880, '\p{Blk=:\Alatinextg\z:}', "");;
    Expect(1, 122879, '\p{Blk=	Latin_Ext_G}', "");
    Expect(0, 122879, '\p{^Blk=	Latin_Ext_G}', "");
    Expect(0, 122879, '\P{Blk=	Latin_Ext_G}', "");
    Expect(1, 122879, '\P{^Blk=	Latin_Ext_G}', "");
    Expect(0, 122880, '\p{Blk=	Latin_Ext_G}', "");
    Expect(1, 122880, '\p{^Blk=	Latin_Ext_G}', "");
    Expect(1, 122880, '\P{Blk=	Latin_Ext_G}', "");
    Expect(0, 122880, '\P{^Blk=	Latin_Ext_G}', "");
    Error('\p{Is_Block=-/a/LATIN_extended_G}');
    Error('\P{Is_Block=-/a/LATIN_extended_G}');
    Expect(1, 122879, '\p{Is_Block=latinextendedg}', "");
    Expect(0, 122879, '\p{^Is_Block=latinextendedg}', "");
    Expect(0, 122879, '\P{Is_Block=latinextendedg}', "");
    Expect(1, 122879, '\P{^Is_Block=latinextendedg}', "");
    Expect(0, 122880, '\p{Is_Block=latinextendedg}', "");
    Expect(1, 122880, '\p{^Is_Block=latinextendedg}', "");
    Expect(1, 122880, '\P{Is_Block=latinextendedg}', "");
    Expect(0, 122880, '\P{^Is_Block=latinextendedg}', "");
    Expect(1, 122879, '\p{Is_Block= LATIN_Extended_g}', "");
    Expect(0, 122879, '\p{^Is_Block= LATIN_Extended_g}', "");
    Expect(0, 122879, '\P{Is_Block= LATIN_Extended_g}', "");
    Expect(1, 122879, '\P{^Is_Block= LATIN_Extended_g}', "");
    Expect(0, 122880, '\p{Is_Block= LATIN_Extended_g}', "");
    Expect(1, 122880, '\p{^Is_Block= LATIN_Extended_g}', "");
    Expect(1, 122880, '\P{Is_Block= LATIN_Extended_g}', "");
    Expect(0, 122880, '\P{^Is_Block= LATIN_Extended_g}', "");
    Error('\p{Is_Blk=-/a/Latin_EXT_G}');
    Error('\P{Is_Blk=-/a/Latin_EXT_G}');
    Expect(1, 122879, '\p{Is_Blk=latinextg}', "");
    Expect(0, 122879, '\p{^Is_Blk=latinextg}', "");
    Expect(0, 122879, '\P{Is_Blk=latinextg}', "");
    Expect(1, 122879, '\P{^Is_Blk=latinextg}', "");
    Expect(0, 122880, '\p{Is_Blk=latinextg}', "");
    Expect(1, 122880, '\p{^Is_Blk=latinextg}', "");
    Expect(1, 122880, '\P{Is_Blk=latinextg}', "");
    Expect(0, 122880, '\P{^Is_Blk=latinextg}', "");
    Expect(1, 122879, '\p{Is_Blk=	_LATIN_Ext_G}', "");
    Expect(0, 122879, '\p{^Is_Blk=	_LATIN_Ext_G}', "");
    Expect(0, 122879, '\P{Is_Blk=	_LATIN_Ext_G}', "");
    Expect(1, 122879, '\P{^Is_Blk=	_LATIN_Ext_G}', "");
    Expect(0, 122880, '\p{Is_Blk=	_LATIN_Ext_G}', "");
    Expect(1, 122880, '\p{^Is_Blk=	_LATIN_Ext_G}', "");
    Expect(1, 122880, '\P{Is_Blk=	_LATIN_Ext_G}', "");
    Expect(0, 122880, '\P{^Is_Blk=	_LATIN_Ext_G}', "");
    Error('\p{Block: _	LEPCHA:=}');
    Error('\P{Block: _	LEPCHA:=}');
    Expect(1, 7247, '\p{Block=:\ALepcha\z:}', "");;
    Expect(0, 7248, '\p{Block=:\ALepcha\z:}', "");;
    Expect(1, 7247, '\p{Block=lepcha}', "");
    Expect(0, 7247, '\p{^Block=lepcha}', "");
    Expect(0, 7247, '\P{Block=lepcha}', "");
    Expect(1, 7247, '\P{^Block=lepcha}', "");
    Expect(0, 7248, '\p{Block=lepcha}', "");
    Expect(1, 7248, '\p{^Block=lepcha}', "");
    Expect(1, 7248, '\P{Block=lepcha}', "");
    Expect(0, 7248, '\P{^Block=lepcha}', "");
    Expect(1, 7247, '\p{Block=:\Alepcha\z:}', "");;
    Expect(0, 7248, '\p{Block=:\Alepcha\z:}', "");;
    Expect(1, 7247, '\p{Block=_-Lepcha}', "");
    Expect(0, 7247, '\p{^Block=_-Lepcha}', "");
    Expect(0, 7247, '\P{Block=_-Lepcha}', "");
    Expect(1, 7247, '\P{^Block=_-Lepcha}', "");
    Expect(0, 7248, '\p{Block=_-Lepcha}', "");
    Expect(1, 7248, '\p{^Block=_-Lepcha}', "");
    Expect(1, 7248, '\P{Block=_-Lepcha}', "");
    Expect(0, 7248, '\P{^Block=_-Lepcha}', "");
    Error('\p{Blk=:=__lepcha}');
    Error('\P{Blk=:=__lepcha}');
    Expect(1, 7247, '\p{Blk=:\ALepcha\z:}', "");;
    Expect(0, 7248, '\p{Blk=:\ALepcha\z:}', "");;
    Expect(1, 7247, '\p{Blk=lepcha}', "");
    Expect(0, 7247, '\p{^Blk=lepcha}', "");
    Expect(0, 7247, '\P{Blk=lepcha}', "");
    Expect(1, 7247, '\P{^Blk=lepcha}', "");
    Expect(0, 7248, '\p{Blk=lepcha}', "");
    Expect(1, 7248, '\p{^Blk=lepcha}', "");
    Expect(1, 7248, '\P{Blk=lepcha}', "");
    Expect(0, 7248, '\P{^Blk=lepcha}', "");
    Expect(1, 7247, '\p{Blk=:\Alepcha\z:}', "");;
    Expect(0, 7248, '\p{Blk=:\Alepcha\z:}', "");;
    Expect(1, 7247, '\p{Blk= Lepcha}', "");
    Expect(0, 7247, '\p{^Blk= Lepcha}', "");
    Expect(0, 7247, '\P{Blk= Lepcha}', "");
    Expect(1, 7247, '\P{^Blk= Lepcha}', "");
    Expect(0, 7248, '\p{Blk= Lepcha}', "");
    Expect(1, 7248, '\p{^Blk= Lepcha}', "");
    Expect(1, 7248, '\P{Blk= Lepcha}', "");
    Expect(0, 7248, '\P{^Blk= Lepcha}', "");
    Error('\p{Is_Block=	_Lepcha:=}');
    Error('\P{Is_Block=	_Lepcha:=}');
    Expect(1, 7247, '\p{Is_Block=lepcha}', "");
    Expect(0, 7247, '\p{^Is_Block=lepcha}', "");
    Expect(0, 7247, '\P{Is_Block=lepcha}', "");
    Expect(1, 7247, '\P{^Is_Block=lepcha}', "");
    Expect(0, 7248, '\p{Is_Block=lepcha}', "");
    Expect(1, 7248, '\p{^Is_Block=lepcha}', "");
    Expect(1, 7248, '\P{Is_Block=lepcha}', "");
    Expect(0, 7248, '\P{^Is_Block=lepcha}', "");
    Expect(1, 7247, '\p{Is_Block: 	 Lepcha}', "");
    Expect(0, 7247, '\p{^Is_Block: 	 Lepcha}', "");
    Expect(0, 7247, '\P{Is_Block: 	 Lepcha}', "");
    Expect(1, 7247, '\P{^Is_Block: 	 Lepcha}', "");
    Expect(0, 7248, '\p{Is_Block: 	 Lepcha}', "");
    Expect(1, 7248, '\p{^Is_Block: 	 Lepcha}', "");
    Expect(1, 7248, '\P{Is_Block: 	 Lepcha}', "");
    Expect(0, 7248, '\P{^Is_Block: 	 Lepcha}', "");
    Error('\p{Is_Blk= :=Lepcha}');
    Error('\P{Is_Blk= :=Lepcha}');
    Expect(1, 7247, '\p{Is_Blk=lepcha}', "");
    Expect(0, 7247, '\p{^Is_Blk=lepcha}', "");
    Expect(0, 7247, '\P{Is_Blk=lepcha}', "");
    Expect(1, 7247, '\P{^Is_Blk=lepcha}', "");
    Expect(0, 7248, '\p{Is_Blk=lepcha}', "");
    Expect(1, 7248, '\p{^Is_Blk=lepcha}', "");
    Expect(1, 7248, '\P{Is_Blk=lepcha}', "");
    Expect(0, 7248, '\P{^Is_Blk=lepcha}', "");
    Expect(1, 7247, '\p{Is_Blk= 	Lepcha}', "");
    Expect(0, 7247, '\p{^Is_Blk= 	Lepcha}', "");
    Expect(0, 7247, '\P{Is_Blk= 	Lepcha}', "");
    Expect(1, 7247, '\P{^Is_Blk= 	Lepcha}', "");
    Expect(0, 7248, '\p{Is_Blk= 	Lepcha}', "");
    Expect(1, 7248, '\p{^Is_Blk= 	Lepcha}', "");
    Expect(1, 7248, '\P{Is_Blk= 	Lepcha}', "");
    Expect(0, 7248, '\P{^Is_Blk= 	Lepcha}', "");
    Error('\p{Block=-LETTERLIKE_Symbols:=}');
    Error('\P{Block=-LETTERLIKE_Symbols:=}');
    Expect(1, 8527, '\p{Block=:\ALetterlike_Symbols\z:}', "");;
    Expect(0, 8528, '\p{Block=:\ALetterlike_Symbols\z:}', "");;
    Expect(1, 8527, '\p{Block=letterlikesymbols}', "");
    Expect(0, 8527, '\p{^Block=letterlikesymbols}', "");
    Expect(0, 8527, '\P{Block=letterlikesymbols}', "");
    Expect(1, 8527, '\P{^Block=letterlikesymbols}', "");
    Expect(0, 8528, '\p{Block=letterlikesymbols}', "");
    Expect(1, 8528, '\p{^Block=letterlikesymbols}', "");
    Expect(1, 8528, '\P{Block=letterlikesymbols}', "");
    Expect(0, 8528, '\P{^Block=letterlikesymbols}', "");
    Expect(1, 8527, '\p{Block=:\Aletterlikesymbols\z:}', "");;
    Expect(0, 8528, '\p{Block=:\Aletterlikesymbols\z:}', "");;
    Expect(1, 8527, '\p{Block:   _Letterlike_symbols}', "");
    Expect(0, 8527, '\p{^Block:   _Letterlike_symbols}', "");
    Expect(0, 8527, '\P{Block:   _Letterlike_symbols}', "");
    Expect(1, 8527, '\P{^Block:   _Letterlike_symbols}', "");
    Expect(0, 8528, '\p{Block:   _Letterlike_symbols}', "");
    Expect(1, 8528, '\p{^Block:   _Letterlike_symbols}', "");
    Expect(1, 8528, '\P{Block:   _Letterlike_symbols}', "");
    Expect(0, 8528, '\P{^Block:   _Letterlike_symbols}', "");
    Error('\p{Blk:   /a/__LETTERLIKE_Symbols}');
    Error('\P{Blk:   /a/__LETTERLIKE_Symbols}');
    Expect(1, 8527, '\p{Blk=:\ALetterlike_Symbols\z:}', "");;
    Expect(0, 8528, '\p{Blk=:\ALetterlike_Symbols\z:}', "");;
    Expect(1, 8527, '\p{Blk=letterlikesymbols}', "");
    Expect(0, 8527, '\p{^Blk=letterlikesymbols}', "");
    Expect(0, 8527, '\P{Blk=letterlikesymbols}', "");
    Expect(1, 8527, '\P{^Blk=letterlikesymbols}', "");
    Expect(0, 8528, '\p{Blk=letterlikesymbols}', "");
    Expect(1, 8528, '\p{^Blk=letterlikesymbols}', "");
    Expect(1, 8528, '\P{Blk=letterlikesymbols}', "");
    Expect(0, 8528, '\P{^Blk=letterlikesymbols}', "");
    Expect(1, 8527, '\p{Blk=:\Aletterlikesymbols\z:}', "");;
    Expect(0, 8528, '\p{Blk=:\Aletterlikesymbols\z:}', "");;
    Expect(1, 8527, '\p{Blk=-LETTERLIKE_Symbols}', "");
    Expect(0, 8527, '\p{^Blk=-LETTERLIKE_Symbols}', "");
    Expect(0, 8527, '\P{Blk=-LETTERLIKE_Symbols}', "");
    Expect(1, 8527, '\P{^Blk=-LETTERLIKE_Symbols}', "");
    Expect(0, 8528, '\p{Blk=-LETTERLIKE_Symbols}', "");
    Expect(1, 8528, '\p{^Blk=-LETTERLIKE_Symbols}', "");
    Expect(1, 8528, '\P{Blk=-LETTERLIKE_Symbols}', "");
    Expect(0, 8528, '\P{^Blk=-LETTERLIKE_Symbols}', "");
    Error('\p{Is_Block= :=LETTERLIKE_Symbols}');
    Error('\P{Is_Block= :=LETTERLIKE_Symbols}');
    Expect(1, 8527, '\p{Is_Block=letterlikesymbols}', "");
    Expect(0, 8527, '\p{^Is_Block=letterlikesymbols}', "");
    Expect(0, 8527, '\P{Is_Block=letterlikesymbols}', "");
    Expect(1, 8527, '\P{^Is_Block=letterlikesymbols}', "");
    Expect(0, 8528, '\p{Is_Block=letterlikesymbols}', "");
    Expect(1, 8528, '\p{^Is_Block=letterlikesymbols}', "");
    Expect(1, 8528, '\P{Is_Block=letterlikesymbols}', "");
    Expect(0, 8528, '\P{^Is_Block=letterlikesymbols}', "");
    Expect(1, 8527, '\p{Is_Block=-_letterlike_Symbols}', "");
    Expect(0, 8527, '\p{^Is_Block=-_letterlike_Symbols}', "");
    Expect(0, 8527, '\P{Is_Block=-_letterlike_Symbols}', "");
    Expect(1, 8527, '\P{^Is_Block=-_letterlike_Symbols}', "");
    Expect(0, 8528, '\p{Is_Block=-_letterlike_Symbols}', "");
    Expect(1, 8528, '\p{^Is_Block=-_letterlike_Symbols}', "");
    Expect(1, 8528, '\P{Is_Block=-_letterlike_Symbols}', "");
    Expect(0, 8528, '\P{^Is_Block=-_letterlike_Symbols}', "");
    Error('\p{Is_Blk=	:=Letterlike_Symbols}');
    Error('\P{Is_Blk=	:=Letterlike_Symbols}');
    Expect(1, 8527, '\p{Is_Blk=letterlikesymbols}', "");
    Expect(0, 8527, '\p{^Is_Blk=letterlikesymbols}', "");
    Expect(0, 8527, '\P{Is_Blk=letterlikesymbols}', "");
    Expect(1, 8527, '\P{^Is_Blk=letterlikesymbols}', "");
    Expect(0, 8528, '\p{Is_Blk=letterlikesymbols}', "");
    Expect(1, 8528, '\p{^Is_Blk=letterlikesymbols}', "");
    Expect(1, 8528, '\P{Is_Blk=letterlikesymbols}', "");
    Expect(0, 8528, '\P{^Is_Blk=letterlikesymbols}', "");
    Expect(1, 8527, '\p{Is_Blk=-	Letterlike_symbols}', "");
    Expect(0, 8527, '\p{^Is_Blk=-	Letterlike_symbols}', "");
    Expect(0, 8527, '\P{Is_Blk=-	Letterlike_symbols}', "");
    Expect(1, 8527, '\P{^Is_Blk=-	Letterlike_symbols}', "");
    Expect(0, 8528, '\p{Is_Blk=-	Letterlike_symbols}', "");
    Expect(1, 8528, '\p{^Is_Blk=-	Letterlike_symbols}', "");
    Expect(1, 8528, '\P{Is_Blk=-	Letterlike_symbols}', "");
    Expect(0, 8528, '\P{^Is_Blk=-	Letterlike_symbols}', "");
    Error('\p{Block=/a/_LIMBU}');
    Error('\P{Block=/a/_LIMBU}');
    Expect(1, 6479, '\p{Block=:\ALimbu\z:}', "");;
    Expect(0, 6480, '\p{Block=:\ALimbu\z:}', "");;
    Expect(1, 6479, '\p{Block=limbu}', "");
    Expect(0, 6479, '\p{^Block=limbu}', "");
    Expect(0, 6479, '\P{Block=limbu}', "");
    Expect(1, 6479, '\P{^Block=limbu}', "");
    Expect(0, 6480, '\p{Block=limbu}', "");
    Expect(1, 6480, '\p{^Block=limbu}', "");
    Expect(1, 6480, '\P{Block=limbu}', "");
    Expect(0, 6480, '\P{^Block=limbu}', "");
    Expect(1, 6479, '\p{Block=:\Alimbu\z:}', "");;
    Expect(0, 6480, '\p{Block=:\Alimbu\z:}', "");;
    Expect(1, 6479, '\p{Block=_-LIMBU}', "");
    Expect(0, 6479, '\p{^Block=_-LIMBU}', "");
    Expect(0, 6479, '\P{Block=_-LIMBU}', "");
    Expect(1, 6479, '\P{^Block=_-LIMBU}', "");
    Expect(0, 6480, '\p{Block=_-LIMBU}', "");
    Expect(1, 6480, '\p{^Block=_-LIMBU}', "");
    Expect(1, 6480, '\P{Block=_-LIMBU}', "");
    Expect(0, 6480, '\P{^Block=_-LIMBU}', "");
    Error('\p{Blk=:=		Limbu}');
    Error('\P{Blk=:=		Limbu}');
    Expect(1, 6479, '\p{Blk=:\ALimbu\z:}', "");;
    Expect(0, 6480, '\p{Blk=:\ALimbu\z:}', "");;
    Expect(1, 6479, '\p{Blk=limbu}', "");
    Expect(0, 6479, '\p{^Blk=limbu}', "");
    Expect(0, 6479, '\P{Blk=limbu}', "");
    Expect(1, 6479, '\P{^Blk=limbu}', "");
    Expect(0, 6480, '\p{Blk=limbu}', "");
    Expect(1, 6480, '\p{^Blk=limbu}', "");
    Expect(1, 6480, '\P{Blk=limbu}', "");
    Expect(0, 6480, '\P{^Blk=limbu}', "");
    Expect(1, 6479, '\p{Blk=:\Alimbu\z:}', "");;
    Expect(0, 6480, '\p{Blk=:\Alimbu\z:}', "");;
    Expect(1, 6479, '\p{Blk:-limbu}', "");
    Expect(0, 6479, '\p{^Blk:-limbu}', "");
    Expect(0, 6479, '\P{Blk:-limbu}', "");
    Expect(1, 6479, '\P{^Blk:-limbu}', "");
    Expect(0, 6480, '\p{Blk:-limbu}', "");
    Expect(1, 6480, '\p{^Blk:-limbu}', "");
    Expect(1, 6480, '\P{Blk:-limbu}', "");
    Expect(0, 6480, '\P{^Blk:-limbu}', "");
    Error('\p{Is_Block=:=_Limbu}');
    Error('\P{Is_Block=:=_Limbu}');
    Expect(1, 6479, '\p{Is_Block=limbu}', "");
    Expect(0, 6479, '\p{^Is_Block=limbu}', "");
    Expect(0, 6479, '\P{Is_Block=limbu}', "");
    Expect(1, 6479, '\P{^Is_Block=limbu}', "");
    Expect(0, 6480, '\p{Is_Block=limbu}', "");
    Expect(1, 6480, '\p{^Is_Block=limbu}', "");
    Expect(1, 6480, '\P{Is_Block=limbu}', "");
    Expect(0, 6480, '\P{^Is_Block=limbu}', "");
    Error('\p{Is_Blk=:=	Limbu}');
    Error('\P{Is_Blk=:=	Limbu}');
    Expect(1, 6479, '\p{Is_Blk=limbu}', "");
    Expect(0, 6479, '\p{^Is_Blk=limbu}', "");
    Expect(0, 6479, '\P{Is_Blk=limbu}', "");
    Expect(1, 6479, '\P{^Is_Blk=limbu}', "");
    Expect(0, 6480, '\p{Is_Blk=limbu}', "");
    Expect(1, 6480, '\p{^Is_Blk=limbu}', "");
    Expect(1, 6480, '\P{Is_Blk=limbu}', "");
    Expect(0, 6480, '\P{^Is_Blk=limbu}', "");
    Expect(1, 6479, '\p{Is_Blk=	Limbu}', "");
    Expect(0, 6479, '\p{^Is_Blk=	Limbu}', "");
    Expect(0, 6479, '\P{Is_Blk=	Limbu}', "");
    Expect(1, 6479, '\P{^Is_Blk=	Limbu}', "");
    Expect(0, 6480, '\p{Is_Blk=	Limbu}', "");
    Expect(1, 6480, '\p{^Is_Blk=	Limbu}', "");
    Expect(1, 6480, '\P{Is_Blk=	Limbu}', "");
    Expect(0, 6480, '\P{^Is_Blk=	Limbu}', "");
    Error('\p{Block=:=  Linear_a}');
    Error('\P{Block=:=  Linear_a}');
    Expect(1, 67455, '\p{Block=:\ALinear_A\z:}', "");;
    Expect(0, 67456, '\p{Block=:\ALinear_A\z:}', "");;
    Expect(1, 67455, '\p{Block=lineara}', "");
    Expect(0, 67455, '\p{^Block=lineara}', "");
    Expect(0, 67455, '\P{Block=lineara}', "");
    Expect(1, 67455, '\P{^Block=lineara}', "");
    Expect(0, 67456, '\p{Block=lineara}', "");
    Expect(1, 67456, '\p{^Block=lineara}', "");
    Expect(1, 67456, '\P{Block=lineara}', "");
    Expect(0, 67456, '\P{^Block=lineara}', "");
    Expect(1, 67455, '\p{Block=:\Alineara\z:}', "");;
    Expect(0, 67456, '\p{Block=:\Alineara\z:}', "");;
    Expect(1, 67455, '\p{Block=-linear_A}', "");
    Expect(0, 67455, '\p{^Block=-linear_A}', "");
    Expect(0, 67455, '\P{Block=-linear_A}', "");
    Expect(1, 67455, '\P{^Block=-linear_A}', "");
    Expect(0, 67456, '\p{Block=-linear_A}', "");
    Expect(1, 67456, '\p{^Block=-linear_A}', "");
    Expect(1, 67456, '\P{Block=-linear_A}', "");
    Expect(0, 67456, '\P{^Block=-linear_A}', "");
    Error('\p{Blk=/a/_ linear_a}');
    Error('\P{Blk=/a/_ linear_a}');
    Expect(1, 67455, '\p{Blk=:\ALinear_A\z:}', "");;
    Expect(0, 67456, '\p{Blk=:\ALinear_A\z:}', "");;
    Expect(1, 67455, '\p{Blk=lineara}', "");
    Expect(0, 67455, '\p{^Blk=lineara}', "");
    Expect(0, 67455, '\P{Blk=lineara}', "");
    Expect(1, 67455, '\P{^Blk=lineara}', "");
    Expect(0, 67456, '\p{Blk=lineara}', "");
    Expect(1, 67456, '\p{^Blk=lineara}', "");
    Expect(1, 67456, '\P{Blk=lineara}', "");
    Expect(0, 67456, '\P{^Blk=lineara}', "");
    Expect(1, 67455, '\p{Blk=:\Alineara\z:}', "");;
    Expect(0, 67456, '\p{Blk=:\Alineara\z:}', "");;
    Expect(1, 67455, '\p{Blk=	LINEAR_A}', "");
    Expect(0, 67455, '\p{^Blk=	LINEAR_A}', "");
    Expect(0, 67455, '\P{Blk=	LINEAR_A}', "");
    Expect(1, 67455, '\P{^Blk=	LINEAR_A}', "");
    Expect(0, 67456, '\p{Blk=	LINEAR_A}', "");
    Expect(1, 67456, '\p{^Blk=	LINEAR_A}', "");
    Expect(1, 67456, '\P{Blk=	LINEAR_A}', "");
    Expect(0, 67456, '\P{^Blk=	LINEAR_A}', "");
    Error('\p{Is_Block=:= -linear_a}');
    Error('\P{Is_Block=:= -linear_a}');
    Expect(1, 67455, '\p{Is_Block=lineara}', "");
    Expect(0, 67455, '\p{^Is_Block=lineara}', "");
    Expect(0, 67455, '\P{Is_Block=lineara}', "");
    Expect(1, 67455, '\P{^Is_Block=lineara}', "");
    Expect(0, 67456, '\p{Is_Block=lineara}', "");
    Expect(1, 67456, '\p{^Is_Block=lineara}', "");
    Expect(1, 67456, '\P{Is_Block=lineara}', "");
    Expect(0, 67456, '\P{^Is_Block=lineara}', "");
    Expect(1, 67455, '\p{Is_Block=- LINEAR_A}', "");
    Expect(0, 67455, '\p{^Is_Block=- LINEAR_A}', "");
    Expect(0, 67455, '\P{Is_Block=- LINEAR_A}', "");
    Expect(1, 67455, '\P{^Is_Block=- LINEAR_A}', "");
    Expect(0, 67456, '\p{Is_Block=- LINEAR_A}', "");
    Expect(1, 67456, '\p{^Is_Block=- LINEAR_A}', "");
    Expect(1, 67456, '\P{Is_Block=- LINEAR_A}', "");
    Expect(0, 67456, '\P{^Is_Block=- LINEAR_A}', "");
    Error('\p{Is_Blk=	/a/linear_A}');
    Error('\P{Is_Blk=	/a/linear_A}');
    Expect(1, 67455, '\p{Is_Blk=lineara}', "");
    Expect(0, 67455, '\p{^Is_Blk=lineara}', "");
    Expect(0, 67455, '\P{Is_Blk=lineara}', "");
    Expect(1, 67455, '\P{^Is_Blk=lineara}', "");
    Expect(0, 67456, '\p{Is_Blk=lineara}', "");
    Expect(1, 67456, '\p{^Is_Blk=lineara}', "");
    Expect(1, 67456, '\P{Is_Blk=lineara}', "");
    Expect(0, 67456, '\P{^Is_Blk=lineara}', "");
    Expect(1, 67455, '\p{Is_Blk=-	linear_a}', "");
    Expect(0, 67455, '\p{^Is_Blk=-	linear_a}', "");
    Expect(0, 67455, '\P{Is_Blk=-	linear_a}', "");
    Expect(1, 67455, '\P{^Is_Blk=-	linear_a}', "");
    Expect(0, 67456, '\p{Is_Blk=-	linear_a}', "");
    Expect(1, 67456, '\p{^Is_Blk=-	linear_a}', "");
    Expect(1, 67456, '\P{Is_Blk=-	linear_a}', "");
    Expect(0, 67456, '\P{^Is_Blk=-	linear_a}', "");
    Error('\p{Block=:= 	LINEAR_B_Ideograms}');
    Error('\P{Block=:= 	LINEAR_B_Ideograms}');
    Expect(1, 65791, '\p{Block=:\ALinear_B_Ideograms\z:}', "");;
    Expect(0, 65792, '\p{Block=:\ALinear_B_Ideograms\z:}', "");;
    Expect(1, 65791, '\p{Block=linearbideograms}', "");
    Expect(0, 65791, '\p{^Block=linearbideograms}', "");
    Expect(0, 65791, '\P{Block=linearbideograms}', "");
    Expect(1, 65791, '\P{^Block=linearbideograms}', "");
    Expect(0, 65792, '\p{Block=linearbideograms}', "");
    Expect(1, 65792, '\p{^Block=linearbideograms}', "");
    Expect(1, 65792, '\P{Block=linearbideograms}', "");
    Expect(0, 65792, '\P{^Block=linearbideograms}', "");
    Expect(1, 65791, '\p{Block=:\Alinearbideograms\z:}', "");;
    Expect(0, 65792, '\p{Block=:\Alinearbideograms\z:}', "");;
    Expect(1, 65791, '\p{Block=-Linear_B_IDEOGRAMS}', "");
    Expect(0, 65791, '\p{^Block=-Linear_B_IDEOGRAMS}', "");
    Expect(0, 65791, '\P{Block=-Linear_B_IDEOGRAMS}', "");
    Expect(1, 65791, '\P{^Block=-Linear_B_IDEOGRAMS}', "");
    Expect(0, 65792, '\p{Block=-Linear_B_IDEOGRAMS}', "");
    Expect(1, 65792, '\p{^Block=-Linear_B_IDEOGRAMS}', "");
    Expect(1, 65792, '\P{Block=-Linear_B_IDEOGRAMS}', "");
    Expect(0, 65792, '\P{^Block=-Linear_B_IDEOGRAMS}', "");
    Error('\p{Blk=/a/_LINEAR_B_ideograms}');
    Error('\P{Blk=/a/_LINEAR_B_ideograms}');
    Expect(1, 65791, '\p{Blk=:\ALinear_B_Ideograms\z:}', "");;
    Expect(0, 65792, '\p{Blk=:\ALinear_B_Ideograms\z:}', "");;
    Expect(1, 65791, '\p{Blk=linearbideograms}', "");
    Expect(0, 65791, '\p{^Blk=linearbideograms}', "");
    Expect(0, 65791, '\P{Blk=linearbideograms}', "");
    Expect(1, 65791, '\P{^Blk=linearbideograms}', "");
    Expect(0, 65792, '\p{Blk=linearbideograms}', "");
    Expect(1, 65792, '\p{^Blk=linearbideograms}', "");
    Expect(1, 65792, '\P{Blk=linearbideograms}', "");
    Expect(0, 65792, '\P{^Blk=linearbideograms}', "");
    Expect(1, 65791, '\p{Blk=:\Alinearbideograms\z:}', "");;
    Expect(0, 65792, '\p{Blk=:\Alinearbideograms\z:}', "");;
    Expect(1, 65791, '\p{Blk=_LINEAR_B_IDEOGRAMS}', "");
    Expect(0, 65791, '\p{^Blk=_LINEAR_B_IDEOGRAMS}', "");
    Expect(0, 65791, '\P{Blk=_LINEAR_B_IDEOGRAMS}', "");
    Expect(1, 65791, '\P{^Blk=_LINEAR_B_IDEOGRAMS}', "");
    Expect(0, 65792, '\p{Blk=_LINEAR_B_IDEOGRAMS}', "");
    Expect(1, 65792, '\p{^Blk=_LINEAR_B_IDEOGRAMS}', "");
    Expect(1, 65792, '\P{Blk=_LINEAR_B_IDEOGRAMS}', "");
    Expect(0, 65792, '\P{^Blk=_LINEAR_B_IDEOGRAMS}', "");
    Error('\p{Is_Block=/a/		LINEAR_b_Ideograms}');
    Error('\P{Is_Block=/a/		LINEAR_b_Ideograms}');
    Expect(1, 65791, '\p{Is_Block=linearbideograms}', "");
    Expect(0, 65791, '\p{^Is_Block=linearbideograms}', "");
    Expect(0, 65791, '\P{Is_Block=linearbideograms}', "");
    Expect(1, 65791, '\P{^Is_Block=linearbideograms}', "");
    Expect(0, 65792, '\p{Is_Block=linearbideograms}', "");
    Expect(1, 65792, '\p{^Is_Block=linearbideograms}', "");
    Expect(1, 65792, '\P{Is_Block=linearbideograms}', "");
    Expect(0, 65792, '\P{^Is_Block=linearbideograms}', "");
    Expect(1, 65791, '\p{Is_Block=_ linear_b_Ideograms}', "");
    Expect(0, 65791, '\p{^Is_Block=_ linear_b_Ideograms}', "");
    Expect(0, 65791, '\P{Is_Block=_ linear_b_Ideograms}', "");
    Expect(1, 65791, '\P{^Is_Block=_ linear_b_Ideograms}', "");
    Expect(0, 65792, '\p{Is_Block=_ linear_b_Ideograms}', "");
    Expect(1, 65792, '\p{^Is_Block=_ linear_b_Ideograms}', "");
    Expect(1, 65792, '\P{Is_Block=_ linear_b_Ideograms}', "");
    Expect(0, 65792, '\P{^Is_Block=_ linear_b_Ideograms}', "");
    Error('\p{Is_Blk=/a/-Linear_b_Ideograms}');
    Error('\P{Is_Blk=/a/-Linear_b_Ideograms}');
    Expect(1, 65791, '\p{Is_Blk=linearbideograms}', "");
    Expect(0, 65791, '\p{^Is_Blk=linearbideograms}', "");
    Expect(0, 65791, '\P{Is_Blk=linearbideograms}', "");
    Expect(1, 65791, '\P{^Is_Blk=linearbideograms}', "");
    Expect(0, 65792, '\p{Is_Blk=linearbideograms}', "");
    Expect(1, 65792, '\p{^Is_Blk=linearbideograms}', "");
    Expect(1, 65792, '\P{Is_Blk=linearbideograms}', "");
    Expect(0, 65792, '\P{^Is_Blk=linearbideograms}', "");
    Expect(1, 65791, '\p{Is_Blk=Linear_B_IDEOGRAMS}', "");
    Expect(0, 65791, '\p{^Is_Blk=Linear_B_IDEOGRAMS}', "");
    Expect(0, 65791, '\P{Is_Blk=Linear_B_IDEOGRAMS}', "");
    Expect(1, 65791, '\P{^Is_Blk=Linear_B_IDEOGRAMS}', "");
    Expect(0, 65792, '\p{Is_Blk=Linear_B_IDEOGRAMS}', "");
    Expect(1, 65792, '\p{^Is_Blk=Linear_B_IDEOGRAMS}', "");
    Expect(1, 65792, '\P{Is_Blk=Linear_B_IDEOGRAMS}', "");
    Expect(0, 65792, '\P{^Is_Blk=Linear_B_IDEOGRAMS}', "");
    Error('\p{Block=/a/-	LINEAR_b_SYLLABARY}');
    Error('\P{Block=/a/-	LINEAR_b_SYLLABARY}');
    Expect(1, 65663, '\p{Block=:\ALinear_B_Syllabary\z:}', "");;
    Expect(0, 65664, '\p{Block=:\ALinear_B_Syllabary\z:}', "");;
    Expect(1, 65663, '\p{Block=linearbsyllabary}', "");
    Expect(0, 65663, '\p{^Block=linearbsyllabary}', "");
    Expect(0, 65663, '\P{Block=linearbsyllabary}', "");
    Expect(1, 65663, '\P{^Block=linearbsyllabary}', "");
    Expect(0, 65664, '\p{Block=linearbsyllabary}', "");
    Expect(1, 65664, '\p{^Block=linearbsyllabary}', "");
    Expect(1, 65664, '\P{Block=linearbsyllabary}', "");
    Expect(0, 65664, '\P{^Block=linearbsyllabary}', "");
    Expect(1, 65663, '\p{Block=:\Alinearbsyllabary\z:}', "");;
    Expect(0, 65664, '\p{Block=:\Alinearbsyllabary\z:}', "");;
    Expect(1, 65663, '\p{Block= _Linear_B_syllabary}', "");
    Expect(0, 65663, '\p{^Block= _Linear_B_syllabary}', "");
    Expect(0, 65663, '\P{Block= _Linear_B_syllabary}', "");
    Expect(1, 65663, '\P{^Block= _Linear_B_syllabary}', "");
    Expect(0, 65664, '\p{Block= _Linear_B_syllabary}', "");
    Expect(1, 65664, '\p{^Block= _Linear_B_syllabary}', "");
    Expect(1, 65664, '\P{Block= _Linear_B_syllabary}', "");
    Expect(0, 65664, '\P{^Block= _Linear_B_syllabary}', "");
    Error('\p{Blk=	_Linear_b_syllabary:=}');
    Error('\P{Blk=	_Linear_b_syllabary:=}');
    Expect(1, 65663, '\p{Blk=:\ALinear_B_Syllabary\z:}', "");;
    Expect(0, 65664, '\p{Blk=:\ALinear_B_Syllabary\z:}', "");;
    Expect(1, 65663, '\p{Blk:   linearbsyllabary}', "");
    Expect(0, 65663, '\p{^Blk:   linearbsyllabary}', "");
    Expect(0, 65663, '\P{Blk:   linearbsyllabary}', "");
    Expect(1, 65663, '\P{^Blk:   linearbsyllabary}', "");
    Expect(0, 65664, '\p{Blk:   linearbsyllabary}', "");
    Expect(1, 65664, '\p{^Blk:   linearbsyllabary}', "");
    Expect(1, 65664, '\P{Blk:   linearbsyllabary}', "");
    Expect(0, 65664, '\P{^Blk:   linearbsyllabary}', "");
    Expect(1, 65663, '\p{Blk=:\Alinearbsyllabary\z:}', "");;
    Expect(0, 65664, '\p{Blk=:\Alinearbsyllabary\z:}', "");;
    Expect(1, 65663, '\p{Blk= 	linear_B_Syllabary}', "");
    Expect(0, 65663, '\p{^Blk= 	linear_B_Syllabary}', "");
    Expect(0, 65663, '\P{Blk= 	linear_B_Syllabary}', "");
    Expect(1, 65663, '\P{^Blk= 	linear_B_Syllabary}', "");
    Expect(0, 65664, '\p{Blk= 	linear_B_Syllabary}', "");
    Expect(1, 65664, '\p{^Blk= 	linear_B_Syllabary}', "");
    Expect(1, 65664, '\P{Blk= 	linear_B_Syllabary}', "");
    Expect(0, 65664, '\P{^Blk= 	linear_B_Syllabary}', "");
    Error('\p{Is_Block: --LINEAR_B_Syllabary:=}');
    Error('\P{Is_Block: --LINEAR_B_Syllabary:=}');
    Expect(1, 65663, '\p{Is_Block=linearbsyllabary}', "");
    Expect(0, 65663, '\p{^Is_Block=linearbsyllabary}', "");
    Expect(0, 65663, '\P{Is_Block=linearbsyllabary}', "");
    Expect(1, 65663, '\P{^Is_Block=linearbsyllabary}', "");
    Expect(0, 65664, '\p{Is_Block=linearbsyllabary}', "");
    Expect(1, 65664, '\p{^Is_Block=linearbsyllabary}', "");
    Expect(1, 65664, '\P{Is_Block=linearbsyllabary}', "");
    Expect(0, 65664, '\P{^Is_Block=linearbsyllabary}', "");
    Expect(1, 65663, '\p{Is_Block= 	Linear_B_Syllabary}', "");
    Expect(0, 65663, '\p{^Is_Block= 	Linear_B_Syllabary}', "");
    Expect(0, 65663, '\P{Is_Block= 	Linear_B_Syllabary}', "");
    Expect(1, 65663, '\P{^Is_Block= 	Linear_B_Syllabary}', "");
    Expect(0, 65664, '\p{Is_Block= 	Linear_B_Syllabary}', "");
    Expect(1, 65664, '\p{^Is_Block= 	Linear_B_Syllabary}', "");
    Expect(1, 65664, '\P{Is_Block= 	Linear_B_Syllabary}', "");
    Expect(0, 65664, '\P{^Is_Block= 	Linear_B_Syllabary}', "");
    Error('\p{Is_Blk= Linear_B_Syllabary:=}');
    Error('\P{Is_Blk= Linear_B_Syllabary:=}');
    Expect(1, 65663, '\p{Is_Blk=linearbsyllabary}', "");
    Expect(0, 65663, '\p{^Is_Blk=linearbsyllabary}', "");
    Expect(0, 65663, '\P{Is_Blk=linearbsyllabary}', "");
    Expect(1, 65663, '\P{^Is_Blk=linearbsyllabary}', "");
    Expect(0, 65664, '\p{Is_Blk=linearbsyllabary}', "");
    Expect(1, 65664, '\p{^Is_Blk=linearbsyllabary}', "");
    Expect(1, 65664, '\P{Is_Blk=linearbsyllabary}', "");
    Expect(0, 65664, '\P{^Is_Blk=linearbsyllabary}', "");
    Expect(1, 65663, '\p{Is_Blk=_	Linear_B_Syllabary}', "");
    Expect(0, 65663, '\p{^Is_Blk=_	Linear_B_Syllabary}', "");
    Expect(0, 65663, '\P{Is_Blk=_	Linear_B_Syllabary}', "");
    Expect(1, 65663, '\P{^Is_Blk=_	Linear_B_Syllabary}', "");
    Expect(0, 65664, '\p{Is_Blk=_	Linear_B_Syllabary}', "");
    Expect(1, 65664, '\p{^Is_Blk=_	Linear_B_Syllabary}', "");
    Expect(1, 65664, '\P{Is_Blk=_	Linear_B_Syllabary}', "");
    Expect(0, 65664, '\P{^Is_Blk=_	Linear_B_Syllabary}', "");
    Error('\p{Block=-:=LISU}');
    Error('\P{Block=-:=LISU}');
    Expect(1, 42239, '\p{Block=:\ALisu\z:}', "");;
    Expect(0, 42240, '\p{Block=:\ALisu\z:}', "");;
    Expect(1, 42239, '\p{Block=lisu}', "");
    Expect(0, 42239, '\p{^Block=lisu}', "");
    Expect(0, 42239, '\P{Block=lisu}', "");
    Expect(1, 42239, '\P{^Block=lisu}', "");
    Expect(0, 42240, '\p{Block=lisu}', "");
    Expect(1, 42240, '\p{^Block=lisu}', "");
    Expect(1, 42240, '\P{Block=lisu}', "");
    Expect(0, 42240, '\P{^Block=lisu}', "");
    Expect(1, 42239, '\p{Block=:\Alisu\z:}', "");;
    Expect(0, 42240, '\p{Block=:\Alisu\z:}', "");;
    Error('\p{Blk=/a/- LISU}');
    Error('\P{Blk=/a/- LISU}');
    Expect(1, 42239, '\p{Blk=:\ALisu\z:}', "");;
    Expect(0, 42240, '\p{Blk=:\ALisu\z:}', "");;
    Expect(1, 42239, '\p{Blk=lisu}', "");
    Expect(0, 42239, '\p{^Blk=lisu}', "");
    Expect(0, 42239, '\P{Blk=lisu}', "");
    Expect(1, 42239, '\P{^Blk=lisu}', "");
    Expect(0, 42240, '\p{Blk=lisu}', "");
    Expect(1, 42240, '\p{^Blk=lisu}', "");
    Expect(1, 42240, '\P{Blk=lisu}', "");
    Expect(0, 42240, '\P{^Blk=lisu}', "");
    Expect(1, 42239, '\p{Blk=:\Alisu\z:}', "");;
    Expect(0, 42240, '\p{Blk=:\Alisu\z:}', "");;
    Expect(1, 42239, '\p{Blk= -lisu}', "");
    Expect(0, 42239, '\p{^Blk= -lisu}', "");
    Expect(0, 42239, '\P{Blk= -lisu}', "");
    Expect(1, 42239, '\P{^Blk= -lisu}', "");
    Expect(0, 42240, '\p{Blk= -lisu}', "");
    Expect(1, 42240, '\p{^Blk= -lisu}', "");
    Expect(1, 42240, '\P{Blk= -lisu}', "");
    Expect(0, 42240, '\P{^Blk= -lisu}', "");
    Error('\p{Is_Block=:=LISU}');
    Error('\P{Is_Block=:=LISU}');
    Expect(1, 42239, '\p{Is_Block=lisu}', "");
    Expect(0, 42239, '\p{^Is_Block=lisu}', "");
    Expect(0, 42239, '\P{Is_Block=lisu}', "");
    Expect(1, 42239, '\P{^Is_Block=lisu}', "");
    Expect(0, 42240, '\p{Is_Block=lisu}', "");
    Expect(1, 42240, '\p{^Is_Block=lisu}', "");
    Expect(1, 42240, '\P{Is_Block=lisu}', "");
    Expect(0, 42240, '\P{^Is_Block=lisu}', "");
    Expect(1, 42239, '\p{Is_Block= _Lisu}', "");
    Expect(0, 42239, '\p{^Is_Block= _Lisu}', "");
    Expect(0, 42239, '\P{Is_Block= _Lisu}', "");
    Expect(1, 42239, '\P{^Is_Block= _Lisu}', "");
    Expect(0, 42240, '\p{Is_Block= _Lisu}', "");
    Expect(1, 42240, '\p{^Is_Block= _Lisu}', "");
    Expect(1, 42240, '\P{Is_Block= _Lisu}', "");
    Expect(0, 42240, '\P{^Is_Block= _Lisu}', "");
    Error('\p{Is_Blk:/a/ 	lisu}');
    Error('\P{Is_Blk:/a/ 	lisu}');
    Expect(1, 42239, '\p{Is_Blk=lisu}', "");
    Expect(0, 42239, '\p{^Is_Blk=lisu}', "");
    Expect(0, 42239, '\P{Is_Blk=lisu}', "");
    Expect(1, 42239, '\P{^Is_Blk=lisu}', "");
    Expect(0, 42240, '\p{Is_Blk=lisu}', "");
    Expect(1, 42240, '\p{^Is_Blk=lisu}', "");
    Expect(1, 42240, '\P{Is_Blk=lisu}', "");
    Expect(0, 42240, '\P{^Is_Blk=lisu}', "");
    Expect(1, 42239, '\p{Is_Blk=-_Lisu}', "");
    Expect(0, 42239, '\p{^Is_Blk=-_Lisu}', "");
    Expect(0, 42239, '\P{Is_Blk=-_Lisu}', "");
    Expect(1, 42239, '\P{^Is_Blk=-_Lisu}', "");
    Expect(0, 42240, '\p{Is_Blk=-_Lisu}', "");
    Expect(1, 42240, '\p{^Is_Blk=-_Lisu}', "");
    Expect(1, 42240, '\P{Is_Blk=-_Lisu}', "");
    Expect(0, 42240, '\P{^Is_Blk=-_Lisu}', "");
    Error('\p{Block=-/a/Lisu_SUPPLEMENT}');
    Error('\P{Block=-/a/Lisu_SUPPLEMENT}');
    Expect(1, 73663, '\p{Block=:\ALisu_Supplement\z:}', "");;
    Expect(0, 73664, '\p{Block=:\ALisu_Supplement\z:}', "");;
    Expect(1, 73663, '\p{Block=lisusupplement}', "");
    Expect(0, 73663, '\p{^Block=lisusupplement}', "");
    Expect(0, 73663, '\P{Block=lisusupplement}', "");
    Expect(1, 73663, '\P{^Block=lisusupplement}', "");
    Expect(0, 73664, '\p{Block=lisusupplement}', "");
    Expect(1, 73664, '\p{^Block=lisusupplement}', "");
    Expect(1, 73664, '\P{Block=lisusupplement}', "");
    Expect(0, 73664, '\P{^Block=lisusupplement}', "");
    Expect(1, 73663, '\p{Block=:\Alisusupplement\z:}', "");;
    Expect(0, 73664, '\p{Block=:\Alisusupplement\z:}', "");;
    Expect(1, 73663, '\p{Block=- LISU_SUPPLEMENT}', "");
    Expect(0, 73663, '\p{^Block=- LISU_SUPPLEMENT}', "");
    Expect(0, 73663, '\P{Block=- LISU_SUPPLEMENT}', "");
    Expect(1, 73663, '\P{^Block=- LISU_SUPPLEMENT}', "");
    Expect(0, 73664, '\p{Block=- LISU_SUPPLEMENT}', "");
    Expect(1, 73664, '\p{^Block=- LISU_SUPPLEMENT}', "");
    Expect(1, 73664, '\P{Block=- LISU_SUPPLEMENT}', "");
    Expect(0, 73664, '\P{^Block=- LISU_SUPPLEMENT}', "");
    Error('\p{Blk=_	Lisu_sup:=}');
    Error('\P{Blk=_	Lisu_sup:=}');
    Expect(1, 73663, '\p{Blk=:\ALisu_Sup\z:}', "");;
    Expect(0, 73664, '\p{Blk=:\ALisu_Sup\z:}', "");;
    Expect(1, 73663, '\p{Blk:lisusup}', "");
    Expect(0, 73663, '\p{^Blk:lisusup}', "");
    Expect(0, 73663, '\P{Blk:lisusup}', "");
    Expect(1, 73663, '\P{^Blk:lisusup}', "");
    Expect(0, 73664, '\p{Blk:lisusup}', "");
    Expect(1, 73664, '\p{^Blk:lisusup}', "");
    Expect(1, 73664, '\P{Blk:lisusup}', "");
    Expect(0, 73664, '\P{^Blk:lisusup}', "");
    Expect(1, 73663, '\p{Blk=:\Alisusup\z:}', "");;
    Expect(0, 73664, '\p{Blk=:\Alisusup\z:}', "");;
    Expect(1, 73663, '\p{Blk=Lisu_sup}', "");
    Expect(0, 73663, '\p{^Blk=Lisu_sup}', "");
    Expect(0, 73663, '\P{Blk=Lisu_sup}', "");
    Expect(1, 73663, '\P{^Blk=Lisu_sup}', "");
    Expect(0, 73664, '\p{Blk=Lisu_sup}', "");
    Expect(1, 73664, '\p{^Blk=Lisu_sup}', "");
    Expect(1, 73664, '\P{Blk=Lisu_sup}', "");
    Expect(0, 73664, '\P{^Blk=Lisu_sup}', "");
    Error('\p{Is_Block=:= LISU_Supplement}');
    Error('\P{Is_Block=:= LISU_Supplement}');
    Expect(1, 73663, '\p{Is_Block=lisusupplement}', "");
    Expect(0, 73663, '\p{^Is_Block=lisusupplement}', "");
    Expect(0, 73663, '\P{Is_Block=lisusupplement}', "");
    Expect(1, 73663, '\P{^Is_Block=lisusupplement}', "");
    Expect(0, 73664, '\p{Is_Block=lisusupplement}', "");
    Expect(1, 73664, '\p{^Is_Block=lisusupplement}', "");
    Expect(1, 73664, '\P{Is_Block=lisusupplement}', "");
    Expect(0, 73664, '\P{^Is_Block=lisusupplement}', "");
    Expect(1, 73663, '\p{Is_Block=-LISU_Supplement}', "");
    Expect(0, 73663, '\p{^Is_Block=-LISU_Supplement}', "");
    Expect(0, 73663, '\P{Is_Block=-LISU_Supplement}', "");
    Expect(1, 73663, '\P{^Is_Block=-LISU_Supplement}', "");
    Expect(0, 73664, '\p{Is_Block=-LISU_Supplement}', "");
    Expect(1, 73664, '\p{^Is_Block=-LISU_Supplement}', "");
    Expect(1, 73664, '\P{Is_Block=-LISU_Supplement}', "");
    Expect(0, 73664, '\P{^Is_Block=-LISU_Supplement}', "");
    Error('\p{Is_Blk:   :=lisu_Sup}');
    Error('\P{Is_Blk:   :=lisu_Sup}');
    Expect(1, 73663, '\p{Is_Blk=lisusup}', "");
    Expect(0, 73663, '\p{^Is_Blk=lisusup}', "");
    Expect(0, 73663, '\P{Is_Blk=lisusup}', "");
    Expect(1, 73663, '\P{^Is_Blk=lisusup}', "");
    Expect(0, 73664, '\p{Is_Blk=lisusup}', "");
    Expect(1, 73664, '\p{^Is_Blk=lisusup}', "");
    Expect(1, 73664, '\P{Is_Blk=lisusup}', "");
    Expect(0, 73664, '\P{^Is_Blk=lisusup}', "");
    Expect(1, 73663, '\p{Is_Blk=_Lisu_Sup}', "");
    Expect(0, 73663, '\p{^Is_Blk=_Lisu_Sup}', "");
    Expect(0, 73663, '\P{Is_Blk=_Lisu_Sup}', "");
    Expect(1, 73663, '\P{^Is_Blk=_Lisu_Sup}', "");
    Expect(0, 73664, '\p{Is_Blk=_Lisu_Sup}', "");
    Expect(1, 73664, '\p{^Is_Blk=_Lisu_Sup}', "");
    Expect(1, 73664, '\P{Is_Blk=_Lisu_Sup}', "");
    Expect(0, 73664, '\P{^Is_Blk=_Lisu_Sup}', "");
    Error('\p{Block= :=low_Surrogates}');
    Error('\P{Block= :=low_Surrogates}');
    Expect(1, 57343, '\p{Block=:\ALow_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\ALow_Surrogates\z:}', "");;
    Expect(1, 57343, '\p{Block=lowsurrogates}', "");
    Expect(0, 57343, '\p{^Block=lowsurrogates}', "");
    Expect(0, 57343, '\P{Block=lowsurrogates}', "");
    Expect(1, 57343, '\P{^Block=lowsurrogates}', "");
    Expect(0, 57344, '\p{Block=lowsurrogates}', "");
    Expect(1, 57344, '\p{^Block=lowsurrogates}', "");
    Expect(1, 57344, '\P{Block=lowsurrogates}', "");
    Expect(0, 57344, '\P{^Block=lowsurrogates}', "");
    Expect(1, 57343, '\p{Block=:\Alowsurrogates\z:}', "");;
    Expect(0, 57344, '\p{Block=:\Alowsurrogates\z:}', "");;
    Expect(1, 57343, '\p{Block=__Low_Surrogates}', "");
    Expect(0, 57343, '\p{^Block=__Low_Surrogates}', "");
    Expect(0, 57343, '\P{Block=__Low_Surrogates}', "");
    Expect(1, 57343, '\P{^Block=__Low_Surrogates}', "");
    Expect(0, 57344, '\p{Block=__Low_Surrogates}', "");
    Expect(1, 57344, '\p{^Block=__Low_Surrogates}', "");
    Expect(1, 57344, '\P{Block=__Low_Surrogates}', "");
    Expect(0, 57344, '\P{^Block=__Low_Surrogates}', "");
    Error('\p{Blk=:=_ Low_surrogates}');
    Error('\P{Blk=:=_ Low_surrogates}');
    Expect(1, 57343, '\p{Blk=:\ALow_Surrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\ALow_Surrogates\z:}', "");;
    Expect(1, 57343, '\p{Blk=lowsurrogates}', "");
    Expect(0, 57343, '\p{^Blk=lowsurrogates}', "");
    Expect(0, 57343, '\P{Blk=lowsurrogates}', "");
    Expect(1, 57343, '\P{^Blk=lowsurrogates}', "");
    Expect(0, 57344, '\p{Blk=lowsurrogates}', "");
    Expect(1, 57344, '\p{^Blk=lowsurrogates}', "");
    Expect(1, 57344, '\P{Blk=lowsurrogates}', "");
    Expect(0, 57344, '\P{^Blk=lowsurrogates}', "");
    Expect(1, 57343, '\p{Blk=:\Alowsurrogates\z:}', "");;
    Expect(0, 57344, '\p{Blk=:\Alowsurrogates\z:}', "");;
    Expect(1, 57343, '\p{Blk=_	Low_Surrogates}', "");
    Expect(0, 57343, '\p{^Blk=_	Low_Surrogates}', "");
    Expect(0, 57343, '\P{Blk=_	Low_Surrogates}', "");
    Expect(1, 57343, '\P{^Blk=_	Low_Surrogates}', "");
    Expect(0, 57344, '\p{Blk=_	Low_Surrogates}', "");
    Expect(1, 57344, '\p{^Blk=_	Low_Surrogates}', "");
    Expect(1, 57344, '\P{Blk=_	Low_Surrogates}', "");
    Expect(0, 57344, '\P{^Blk=_	Low_Surrogates}', "");
    Error('\p{Is_Block=- Low_Surrogates/a/}');
    Error('\P{Is_Block=- Low_Surrogates/a/}');
    Expect(1, 57343, '\p{Is_Block=lowsurrogates}', "");
    Expect(0, 57343, '\p{^Is_Block=lowsurrogates}', "");
    Expect(0, 57343, '\P{Is_Block=lowsurrogates}', "");
    Expect(1, 57343, '\P{^Is_Block=lowsurrogates}', "");
    Expect(0, 57344, '\p{Is_Block=lowsurrogates}', "");
    Expect(1, 57344, '\p{^Is_Block=lowsurrogates}', "");
    Expect(1, 57344, '\P{Is_Block=lowsurrogates}', "");
    Expect(0, 57344, '\P{^Is_Block=lowsurrogates}', "");
    Expect(1, 57343, '\p{Is_Block=_	Low_Surrogates}', "");
    Expect(0, 57343, '\p{^Is_Block=_	Low_Surrogates}', "");
    Expect(0, 57343, '\P{Is_Block=_	Low_Surrogates}', "");
    Expect(1, 57343, '\P{^Is_Block=_	Low_Surrogates}', "");
    Expect(0, 57344, '\p{Is_Block=_	Low_Surrogates}', "");
    Expect(1, 57344, '\p{^Is_Block=_	Low_Surrogates}', "");
    Expect(1, 57344, '\P{Is_Block=_	Low_Surrogates}', "");
    Expect(0, 57344, '\P{^Is_Block=_	Low_Surrogates}', "");
    Error('\p{Is_Blk=:=	-Low_surrogates}');
    Error('\P{Is_Blk=:=	-Low_surrogates}');
    Expect(1, 57343, '\p{Is_Blk=lowsurrogates}', "");
    Expect(0, 57343, '\p{^Is_Blk=lowsurrogates}', "");
    Expect(0, 57343, '\P{Is_Blk=lowsurrogates}', "");
    Expect(1, 57343, '\P{^Is_Blk=lowsurrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=lowsurrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=lowsurrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=lowsurrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=lowsurrogates}', "");
    Expect(1, 57343, '\p{Is_Blk=_ Low_Surrogates}', "");
    Expect(0, 57343, '\p{^Is_Blk=_ Low_Surrogates}', "");
    Expect(0, 57343, '\P{Is_Blk=_ Low_Surrogates}', "");
    Expect(1, 57343, '\P{^Is_Blk=_ Low_Surrogates}', "");
    Expect(0, 57344, '\p{Is_Blk=_ Low_Surrogates}', "");
    Expect(1, 57344, '\p{^Is_Blk=_ Low_Surrogates}', "");
    Expect(1, 57344, '\P{Is_Blk=_ Low_Surrogates}', "");
    Expect(0, 57344, '\P{^Is_Blk=_ Low_Surrogates}', "");
    Error('\p{Block:   := 	LYCIAN}');
    Error('\P{Block:   := 	LYCIAN}');
    Expect(1, 66207, '\p{Block=:\ALycian\z:}', "");;
    Expect(0, 66208, '\p{Block=:\ALycian\z:}', "");;
    Expect(1, 66207, '\p{Block=lycian}', "");
    Expect(0, 66207, '\p{^Block=lycian}', "");
    Expect(0, 66207, '\P{Block=lycian}', "");
    Expect(1, 66207, '\P{^Block=lycian}', "");
    Expect(0, 66208, '\p{Block=lycian}', "");
    Expect(1, 66208, '\p{^Block=lycian}', "");
    Expect(1, 66208, '\P{Block=lycian}', "");
    Expect(0, 66208, '\P{^Block=lycian}', "");
    Expect(1, 66207, '\p{Block=:\Alycian\z:}', "");;
    Expect(0, 66208, '\p{Block=:\Alycian\z:}', "");;
    Expect(1, 66207, '\p{Block=_lycian}', "");
    Expect(0, 66207, '\p{^Block=_lycian}', "");
    Expect(0, 66207, '\P{Block=_lycian}', "");
    Expect(1, 66207, '\P{^Block=_lycian}', "");
    Expect(0, 66208, '\p{Block=_lycian}', "");
    Expect(1, 66208, '\p{^Block=_lycian}', "");
    Expect(1, 66208, '\P{Block=_lycian}', "");
    Expect(0, 66208, '\P{^Block=_lycian}', "");
    Error('\p{Blk=-_LYCIAN/a/}');
    Error('\P{Blk=-_LYCIAN/a/}');
    Expect(1, 66207, '\p{Blk=:\ALycian\z:}', "");;
    Expect(0, 66208, '\p{Blk=:\ALycian\z:}', "");;
    Expect(1, 66207, '\p{Blk=lycian}', "");
    Expect(0, 66207, '\p{^Blk=lycian}', "");
    Expect(0, 66207, '\P{Blk=lycian}', "");
    Expect(1, 66207, '\P{^Blk=lycian}', "");
    Expect(0, 66208, '\p{Blk=lycian}', "");
    Expect(1, 66208, '\p{^Blk=lycian}', "");
    Expect(1, 66208, '\P{Blk=lycian}', "");
    Expect(0, 66208, '\P{^Blk=lycian}', "");
    Expect(1, 66207, '\p{Blk=:\Alycian\z:}', "");;
    Expect(0, 66208, '\p{Blk=:\Alycian\z:}', "");;
    Expect(1, 66207, '\p{Blk=_ lycian}', "");
    Expect(0, 66207, '\p{^Blk=_ lycian}', "");
    Expect(0, 66207, '\P{Blk=_ lycian}', "");
    Expect(1, 66207, '\P{^Blk=_ lycian}', "");
    Expect(0, 66208, '\p{Blk=_ lycian}', "");
    Expect(1, 66208, '\p{^Blk=_ lycian}', "");
    Expect(1, 66208, '\P{Blk=_ lycian}', "");
    Expect(0, 66208, '\P{^Blk=_ lycian}', "");
    Error('\p{Is_Block=_Lycian:=}');
    Error('\P{Is_Block=_Lycian:=}');
    Expect(1, 66207, '\p{Is_Block=lycian}', "");
    Expect(0, 66207, '\p{^Is_Block=lycian}', "");
    Expect(0, 66207, '\P{Is_Block=lycian}', "");
    Expect(1, 66207, '\P{^Is_Block=lycian}', "");
    Expect(0, 66208, '\p{Is_Block=lycian}', "");
    Expect(1, 66208, '\p{^Is_Block=lycian}', "");
    Expect(1, 66208, '\P{Is_Block=lycian}', "");
    Expect(0, 66208, '\P{^Is_Block=lycian}', "");
    Expect(1, 66207, '\p{Is_Block=_Lycian}', "");
    Expect(0, 66207, '\p{^Is_Block=_Lycian}', "");
    Expect(0, 66207, '\P{Is_Block=_Lycian}', "");
    Expect(1, 66207, '\P{^Is_Block=_Lycian}', "");
    Expect(0, 66208, '\p{Is_Block=_Lycian}', "");
    Expect(1, 66208, '\p{^Is_Block=_Lycian}', "");
    Expect(1, 66208, '\P{Is_Block=_Lycian}', "");
    Expect(0, 66208, '\P{^Is_Block=_Lycian}', "");
    Error('\p{Is_Blk:	-Lycian/a/}');
    Error('\P{Is_Blk:	-Lycian/a/}');
    Expect(1, 66207, '\p{Is_Blk=lycian}', "");
    Expect(0, 66207, '\p{^Is_Blk=lycian}', "");
    Expect(0, 66207, '\P{Is_Blk=lycian}', "");
    Expect(1, 66207, '\P{^Is_Blk=lycian}', "");
    Expect(0, 66208, '\p{Is_Blk=lycian}', "");
    Expect(1, 66208, '\p{^Is_Blk=lycian}', "");
    Expect(1, 66208, '\P{Is_Blk=lycian}', "");
    Expect(0, 66208, '\P{^Is_Blk=lycian}', "");
    Expect(1, 66207, '\p{Is_Blk=Lycian}', "");
    Expect(0, 66207, '\p{^Is_Blk=Lycian}', "");
    Expect(0, 66207, '\P{Is_Blk=Lycian}', "");
    Expect(1, 66207, '\P{^Is_Blk=Lycian}', "");
    Expect(0, 66208, '\p{Is_Blk=Lycian}', "");
    Expect(1, 66208, '\p{^Is_Blk=Lycian}', "");
    Expect(1, 66208, '\P{Is_Blk=Lycian}', "");
    Expect(0, 66208, '\P{^Is_Blk=Lycian}', "");
    Error('\p{Block=:= _Lydian}');
    Error('\P{Block=:= _Lydian}');
    Expect(1, 67903, '\p{Block=:\ALydian\z:}', "");;
    Expect(0, 67904, '\p{Block=:\ALydian\z:}', "");;
    Expect(1, 67903, '\p{Block=lydian}', "");
    Expect(0, 67903, '\p{^Block=lydian}', "");
    Expect(0, 67903, '\P{Block=lydian}', "");
    Expect(1, 67903, '\P{^Block=lydian}', "");
    Expect(0, 67904, '\p{Block=lydian}', "");
    Expect(1, 67904, '\p{^Block=lydian}', "");
    Expect(1, 67904, '\P{Block=lydian}', "");
    Expect(0, 67904, '\P{^Block=lydian}', "");
    Expect(1, 67903, '\p{Block=:\Alydian\z:}', "");;
    Expect(0, 67904, '\p{Block=:\Alydian\z:}', "");;
    Expect(1, 67903, '\p{Block=_	Lydian}', "");
    Expect(0, 67903, '\p{^Block=_	Lydian}', "");
    Expect(0, 67903, '\P{Block=_	Lydian}', "");
    Expect(1, 67903, '\P{^Block=_	Lydian}', "");
    Expect(0, 67904, '\p{Block=_	Lydian}', "");
    Expect(1, 67904, '\p{^Block=_	Lydian}', "");
    Expect(1, 67904, '\P{Block=_	Lydian}', "");
    Expect(0, 67904, '\P{^Block=_	Lydian}', "");
    Error('\p{Blk=_:=lydian}');
    Error('\P{Blk=_:=lydian}');
    Expect(1, 67903, '\p{Blk=:\ALydian\z:}', "");;
    Expect(0, 67904, '\p{Blk=:\ALydian\z:}', "");;
    Expect(1, 67903, '\p{Blk=lydian}', "");
    Expect(0, 67903, '\p{^Blk=lydian}', "");
    Expect(0, 67903, '\P{Blk=lydian}', "");
    Expect(1, 67903, '\P{^Blk=lydian}', "");
    Expect(0, 67904, '\p{Blk=lydian}', "");
    Expect(1, 67904, '\p{^Blk=lydian}', "");
    Expect(1, 67904, '\P{Blk=lydian}', "");
    Expect(0, 67904, '\P{^Blk=lydian}', "");
    Expect(1, 67903, '\p{Blk=:\Alydian\z:}', "");;
    Expect(0, 67904, '\p{Blk=:\Alydian\z:}', "");;
    Expect(1, 67903, '\p{Blk=	-lydian}', "");
    Expect(0, 67903, '\p{^Blk=	-lydian}', "");
    Expect(0, 67903, '\P{Blk=	-lydian}', "");
    Expect(1, 67903, '\P{^Blk=	-lydian}', "");
    Expect(0, 67904, '\p{Blk=	-lydian}', "");
    Expect(1, 67904, '\p{^Blk=	-lydian}', "");
    Expect(1, 67904, '\P{Blk=	-lydian}', "");
    Expect(0, 67904, '\P{^Blk=	-lydian}', "");
    Error('\p{Is_Block=_	Lydian/a/}');
    Error('\P{Is_Block=_	Lydian/a/}');
    Expect(1, 67903, '\p{Is_Block=lydian}', "");
    Expect(0, 67903, '\p{^Is_Block=lydian}', "");
    Expect(0, 67903, '\P{Is_Block=lydian}', "");
    Expect(1, 67903, '\P{^Is_Block=lydian}', "");
    Expect(0, 67904, '\p{Is_Block=lydian}', "");
    Expect(1, 67904, '\p{^Is_Block=lydian}', "");
    Expect(1, 67904, '\P{Is_Block=lydian}', "");
    Expect(0, 67904, '\P{^Is_Block=lydian}', "");
    Expect(1, 67903, '\p{Is_Block=  lydian}', "");
    Expect(0, 67903, '\p{^Is_Block=  lydian}', "");
    Expect(0, 67903, '\P{Is_Block=  lydian}', "");
    Expect(1, 67903, '\P{^Is_Block=  lydian}', "");
    Expect(0, 67904, '\p{Is_Block=  lydian}', "");
    Expect(1, 67904, '\p{^Is_Block=  lydian}', "");
    Expect(1, 67904, '\P{Is_Block=  lydian}', "");
    Expect(0, 67904, '\P{^Is_Block=  lydian}', "");
    Error('\p{Is_Blk=:=Lydian}');
    Error('\P{Is_Blk=:=Lydian}');
    Expect(1, 67903, '\p{Is_Blk=lydian}', "");
    Expect(0, 67903, '\p{^Is_Blk=lydian}', "");
    Expect(0, 67903, '\P{Is_Blk=lydian}', "");
    Expect(1, 67903, '\P{^Is_Blk=lydian}', "");
    Expect(0, 67904, '\p{Is_Blk=lydian}', "");
    Expect(1, 67904, '\p{^Is_Blk=lydian}', "");
    Expect(1, 67904, '\P{Is_Blk=lydian}', "");
    Expect(0, 67904, '\P{^Is_Blk=lydian}', "");
    Expect(1, 67903, '\p{Is_Blk: _-Lydian}', "");
    Expect(0, 67903, '\p{^Is_Blk: _-Lydian}', "");
    Expect(0, 67903, '\P{Is_Blk: _-Lydian}', "");
    Expect(1, 67903, '\P{^Is_Blk: _-Lydian}', "");
    Expect(0, 67904, '\p{Is_Blk: _-Lydian}', "");
    Expect(1, 67904, '\p{^Is_Blk: _-Lydian}', "");
    Expect(1, 67904, '\P{Is_Blk: _-Lydian}', "");
    Expect(0, 67904, '\P{^Is_Blk: _-Lydian}', "");
    Error('\p{Block:   _	Mahajani/a/}');
    Error('\P{Block:   _	Mahajani/a/}');
    Expect(1, 70015, '\p{Block=:\AMahajani\z:}', "");;
    Expect(0, 70016, '\p{Block=:\AMahajani\z:}', "");;
    Expect(1, 70015, '\p{Block=mahajani}', "");
    Expect(0, 70015, '\p{^Block=mahajani}', "");
    Expect(0, 70015, '\P{Block=mahajani}', "");
    Expect(1, 70015, '\P{^Block=mahajani}', "");
    Expect(0, 70016, '\p{Block=mahajani}', "");
    Expect(1, 70016, '\p{^Block=mahajani}', "");
    Expect(1, 70016, '\P{Block=mahajani}', "");
    Expect(0, 70016, '\P{^Block=mahajani}', "");
    Expect(1, 70015, '\p{Block=:\Amahajani\z:}', "");;
    Expect(0, 70016, '\p{Block=:\Amahajani\z:}', "");;
    Expect(1, 70015, '\p{Block=--Mahajani}', "");
    Expect(0, 70015, '\p{^Block=--Mahajani}', "");
    Expect(0, 70015, '\P{Block=--Mahajani}', "");
    Expect(1, 70015, '\P{^Block=--Mahajani}', "");
    Expect(0, 70016, '\p{Block=--Mahajani}', "");
    Expect(1, 70016, '\p{^Block=--Mahajani}', "");
    Expect(1, 70016, '\P{Block=--Mahajani}', "");
    Expect(0, 70016, '\P{^Block=--Mahajani}', "");
    Error('\p{Blk=-_Mahajani:=}');
    Error('\P{Blk=-_Mahajani:=}');
    Expect(1, 70015, '\p{Blk=:\AMahajani\z:}', "");;
    Expect(0, 70016, '\p{Blk=:\AMahajani\z:}', "");;
    Expect(1, 70015, '\p{Blk: mahajani}', "");
    Expect(0, 70015, '\p{^Blk: mahajani}', "");
    Expect(0, 70015, '\P{Blk: mahajani}', "");
    Expect(1, 70015, '\P{^Blk: mahajani}', "");
    Expect(0, 70016, '\p{Blk: mahajani}', "");
    Expect(1, 70016, '\p{^Blk: mahajani}', "");
    Expect(1, 70016, '\P{Blk: mahajani}', "");
    Expect(0, 70016, '\P{^Blk: mahajani}', "");
    Expect(1, 70015, '\p{Blk=:\Amahajani\z:}', "");;
    Expect(0, 70016, '\p{Blk=:\Amahajani\z:}', "");;
    Expect(1, 70015, '\p{Blk=_Mahajani}', "");
    Expect(0, 70015, '\p{^Blk=_Mahajani}', "");
    Expect(0, 70015, '\P{Blk=_Mahajani}', "");
    Expect(1, 70015, '\P{^Blk=_Mahajani}', "");
    Expect(0, 70016, '\p{Blk=_Mahajani}', "");
    Expect(1, 70016, '\p{^Blk=_Mahajani}', "");
    Expect(1, 70016, '\P{Blk=_Mahajani}', "");
    Expect(0, 70016, '\P{^Blk=_Mahajani}', "");
    Error('\p{Is_Block=- Mahajani:=}');
    Error('\P{Is_Block=- Mahajani:=}');
    Expect(1, 70015, '\p{Is_Block=mahajani}', "");
    Expect(0, 70015, '\p{^Is_Block=mahajani}', "");
    Expect(0, 70015, '\P{Is_Block=mahajani}', "");
    Expect(1, 70015, '\P{^Is_Block=mahajani}', "");
    Expect(0, 70016, '\p{Is_Block=mahajani}', "");
    Expect(1, 70016, '\p{^Is_Block=mahajani}', "");
    Expect(1, 70016, '\P{Is_Block=mahajani}', "");
    Expect(0, 70016, '\P{^Is_Block=mahajani}', "");
    Expect(1, 70015, '\p{Is_Block=-mahajani}', "");
    Expect(0, 70015, '\p{^Is_Block=-mahajani}', "");
    Expect(0, 70015, '\P{Is_Block=-mahajani}', "");
    Expect(1, 70015, '\P{^Is_Block=-mahajani}', "");
    Expect(0, 70016, '\p{Is_Block=-mahajani}', "");
    Expect(1, 70016, '\p{^Is_Block=-mahajani}', "");
    Expect(1, 70016, '\P{Is_Block=-mahajani}', "");
    Expect(0, 70016, '\P{^Is_Block=-mahajani}', "");
    Error('\p{Is_Blk= :=Mahajani}');
    Error('\P{Is_Blk= :=Mahajani}');
    Expect(1, 70015, '\p{Is_Blk=mahajani}', "");
    Expect(0, 70015, '\p{^Is_Blk=mahajani}', "");
    Expect(0, 70015, '\P{Is_Blk=mahajani}', "");
    Expect(1, 70015, '\P{^Is_Blk=mahajani}', "");
    Expect(0, 70016, '\p{Is_Blk=mahajani}', "");
    Expect(1, 70016, '\p{^Is_Blk=mahajani}', "");
    Expect(1, 70016, '\P{Is_Blk=mahajani}', "");
    Expect(0, 70016, '\P{^Is_Blk=mahajani}', "");
    Expect(1, 70015, '\p{Is_Blk=_ Mahajani}', "");
    Expect(0, 70015, '\p{^Is_Blk=_ Mahajani}', "");
    Expect(0, 70015, '\P{Is_Blk=_ Mahajani}', "");
    Expect(1, 70015, '\P{^Is_Blk=_ Mahajani}', "");
    Expect(0, 70016, '\p{Is_Blk=_ Mahajani}', "");
    Expect(1, 70016, '\p{^Is_Blk=_ Mahajani}', "");
    Expect(1, 70016, '\P{Is_Blk=_ Mahajani}', "");
    Expect(0, 70016, '\P{^Is_Blk=_ Mahajani}', "");
    Error('\p{Block:	:=_ MAHJONG_tiles}');
    Error('\P{Block:	:=_ MAHJONG_tiles}');
    Expect(1, 127023, '\p{Block=:\AMahjong_Tiles\z:}', "");;
    Expect(0, 127024, '\p{Block=:\AMahjong_Tiles\z:}', "");;
    Expect(1, 127023, '\p{Block=mahjongtiles}', "");
    Expect(0, 127023, '\p{^Block=mahjongtiles}', "");
    Expect(0, 127023, '\P{Block=mahjongtiles}', "");
    Expect(1, 127023, '\P{^Block=mahjongtiles}', "");
    Expect(0, 127024, '\p{Block=mahjongtiles}', "");
    Expect(1, 127024, '\p{^Block=mahjongtiles}', "");
    Expect(1, 127024, '\P{Block=mahjongtiles}', "");
    Expect(0, 127024, '\P{^Block=mahjongtiles}', "");
    Expect(1, 127023, '\p{Block=:\Amahjongtiles\z:}', "");;
    Expect(0, 127024, '\p{Block=:\Amahjongtiles\z:}', "");;
    Expect(1, 127023, '\p{Block=_	Mahjong_Tiles}', "");
    Expect(0, 127023, '\p{^Block=_	Mahjong_Tiles}', "");
    Expect(0, 127023, '\P{Block=_	Mahjong_Tiles}', "");
    Expect(1, 127023, '\P{^Block=_	Mahjong_Tiles}', "");
    Expect(0, 127024, '\p{Block=_	Mahjong_Tiles}', "");
    Expect(1, 127024, '\p{^Block=_	Mahjong_Tiles}', "");
    Expect(1, 127024, '\P{Block=_	Mahjong_Tiles}', "");
    Expect(0, 127024, '\P{^Block=_	Mahjong_Tiles}', "");
    Error('\p{Blk=_	Mahjong:=}');
    Error('\P{Blk=_	Mahjong:=}');
    Expect(1, 127023, '\p{Blk=:\AMahjong\z:}', "");;
    Expect(0, 127024, '\p{Blk=:\AMahjong\z:}', "");;
    Expect(1, 127023, '\p{Blk=mahjong}', "");
    Expect(0, 127023, '\p{^Blk=mahjong}', "");
    Expect(0, 127023, '\P{Blk=mahjong}', "");
    Expect(1, 127023, '\P{^Blk=mahjong}', "");
    Expect(0, 127024, '\p{Blk=mahjong}', "");
    Expect(1, 127024, '\p{^Blk=mahjong}', "");
    Expect(1, 127024, '\P{Blk=mahjong}', "");
    Expect(0, 127024, '\P{^Blk=mahjong}', "");
    Expect(1, 127023, '\p{Blk=:\Amahjong\z:}', "");;
    Expect(0, 127024, '\p{Blk=:\Amahjong\z:}', "");;
    Expect(1, 127023, '\p{Blk=-	Mahjong}', "");
    Expect(0, 127023, '\p{^Blk=-	Mahjong}', "");
    Expect(0, 127023, '\P{Blk=-	Mahjong}', "");
    Expect(1, 127023, '\P{^Blk=-	Mahjong}', "");
    Expect(0, 127024, '\p{Blk=-	Mahjong}', "");
    Expect(1, 127024, '\p{^Blk=-	Mahjong}', "");
    Expect(1, 127024, '\P{Blk=-	Mahjong}', "");
    Expect(0, 127024, '\P{^Blk=-	Mahjong}', "");
    Error('\p{Is_Block: 	/a/Mahjong_Tiles}');
    Error('\P{Is_Block: 	/a/Mahjong_Tiles}');
    Expect(1, 127023, '\p{Is_Block:	mahjongtiles}', "");
    Expect(0, 127023, '\p{^Is_Block:	mahjongtiles}', "");
    Expect(0, 127023, '\P{Is_Block:	mahjongtiles}', "");
    Expect(1, 127023, '\P{^Is_Block:	mahjongtiles}', "");
    Expect(0, 127024, '\p{Is_Block:	mahjongtiles}', "");
    Expect(1, 127024, '\p{^Is_Block:	mahjongtiles}', "");
    Expect(1, 127024, '\P{Is_Block:	mahjongtiles}', "");
    Expect(0, 127024, '\P{^Is_Block:	mahjongtiles}', "");
    Expect(1, 127023, '\p{Is_Block= _Mahjong_Tiles}', "");
    Expect(0, 127023, '\p{^Is_Block= _Mahjong_Tiles}', "");
    Expect(0, 127023, '\P{Is_Block= _Mahjong_Tiles}', "");
    Expect(1, 127023, '\P{^Is_Block= _Mahjong_Tiles}', "");
    Expect(0, 127024, '\p{Is_Block= _Mahjong_Tiles}', "");
    Expect(1, 127024, '\p{^Is_Block= _Mahjong_Tiles}', "");
    Expect(1, 127024, '\P{Is_Block= _Mahjong_Tiles}', "");
    Expect(0, 127024, '\P{^Is_Block= _Mahjong_Tiles}', "");
    Error('\p{Is_Blk=-_MAHJONG:=}');
    Error('\P{Is_Blk=-_MAHJONG:=}');
    Expect(1, 127023, '\p{Is_Blk=mahjong}', "");
    Expect(0, 127023, '\p{^Is_Blk=mahjong}', "");
    Expect(0, 127023, '\P{Is_Blk=mahjong}', "");
    Expect(1, 127023, '\P{^Is_Blk=mahjong}', "");
    Expect(0, 127024, '\p{Is_Blk=mahjong}', "");
    Expect(1, 127024, '\p{^Is_Blk=mahjong}', "");
    Expect(1, 127024, '\P{Is_Blk=mahjong}', "");
    Expect(0, 127024, '\P{^Is_Blk=mahjong}', "");
    Expect(1, 127023, '\p{Is_Blk= mahjong}', "");
    Expect(0, 127023, '\p{^Is_Blk= mahjong}', "");
    Expect(0, 127023, '\P{Is_Blk= mahjong}', "");
    Expect(1, 127023, '\P{^Is_Blk= mahjong}', "");
    Expect(0, 127024, '\p{Is_Blk= mahjong}', "");
    Expect(1, 127024, '\p{^Is_Blk= mahjong}', "");
    Expect(1, 127024, '\P{Is_Blk= mahjong}', "");
    Expect(0, 127024, '\P{^Is_Blk= mahjong}', "");
    Error('\p{Block=/a/Makasar}');
    Error('\P{Block=/a/Makasar}');
    Expect(1, 73471, '\p{Block=:\AMakasar\z:}', "");;
    Expect(0, 73472, '\p{Block=:\AMakasar\z:}', "");;
    Expect(1, 73471, '\p{Block=makasar}', "");
    Expect(0, 73471, '\p{^Block=makasar}', "");
    Expect(0, 73471, '\P{Block=makasar}', "");
    Expect(1, 73471, '\P{^Block=makasar}', "");
    Expect(0, 73472, '\p{Block=makasar}', "");
    Expect(1, 73472, '\p{^Block=makasar}', "");
    Expect(1, 73472, '\P{Block=makasar}', "");
    Expect(0, 73472, '\P{^Block=makasar}', "");
    Expect(1, 73471, '\p{Block=:\Amakasar\z:}', "");;
    Expect(0, 73472, '\p{Block=:\Amakasar\z:}', "");;
    Expect(1, 73471, '\p{Block=-_MAKASAR}', "");
    Expect(0, 73471, '\p{^Block=-_MAKASAR}', "");
    Expect(0, 73471, '\P{Block=-_MAKASAR}', "");
    Expect(1, 73471, '\P{^Block=-_MAKASAR}', "");
    Expect(0, 73472, '\p{Block=-_MAKASAR}', "");
    Expect(1, 73472, '\p{^Block=-_MAKASAR}', "");
    Expect(1, 73472, '\P{Block=-_MAKASAR}', "");
    Expect(0, 73472, '\P{^Block=-_MAKASAR}', "");
    Error('\p{Blk:/a/		Makasar}');
    Error('\P{Blk:/a/		Makasar}');
    Expect(1, 73471, '\p{Blk=:\AMakasar\z:}', "");;
    Expect(0, 73472, '\p{Blk=:\AMakasar\z:}', "");;
    Expect(1, 73471, '\p{Blk=makasar}', "");
    Expect(0, 73471, '\p{^Blk=makasar}', "");
    Expect(0, 73471, '\P{Blk=makasar}', "");
    Expect(1, 73471, '\P{^Blk=makasar}', "");
    Expect(0, 73472, '\p{Blk=makasar}', "");
    Expect(1, 73472, '\p{^Blk=makasar}', "");
    Expect(1, 73472, '\P{Blk=makasar}', "");
    Expect(0, 73472, '\P{^Blk=makasar}', "");
    Expect(1, 73471, '\p{Blk=:\Amakasar\z:}', "");;
    Expect(0, 73472, '\p{Blk=:\Amakasar\z:}', "");;
    Expect(1, 73471, '\p{Blk=__Makasar}', "");
    Expect(0, 73471, '\p{^Blk=__Makasar}', "");
    Expect(0, 73471, '\P{Blk=__Makasar}', "");
    Expect(1, 73471, '\P{^Blk=__Makasar}', "");
    Expect(0, 73472, '\p{Blk=__Makasar}', "");
    Expect(1, 73472, '\p{^Blk=__Makasar}', "");
    Expect(1, 73472, '\P{Blk=__Makasar}', "");
    Expect(0, 73472, '\P{^Blk=__Makasar}', "");
    Error('\p{Is_Block=	-makasar/a/}');
    Error('\P{Is_Block=	-makasar/a/}');
    Expect(1, 73471, '\p{Is_Block=makasar}', "");
    Expect(0, 73471, '\p{^Is_Block=makasar}', "");
    Expect(0, 73471, '\P{Is_Block=makasar}', "");
    Expect(1, 73471, '\P{^Is_Block=makasar}', "");
    Expect(0, 73472, '\p{Is_Block=makasar}', "");
    Expect(1, 73472, '\p{^Is_Block=makasar}', "");
    Expect(1, 73472, '\P{Is_Block=makasar}', "");
    Expect(0, 73472, '\P{^Is_Block=makasar}', "");
    Expect(1, 73471, '\p{Is_Block:	MAKASAR}', "");
    Expect(0, 73471, '\p{^Is_Block:	MAKASAR}', "");
    Expect(0, 73471, '\P{Is_Block:	MAKASAR}', "");
    Expect(1, 73471, '\P{^Is_Block:	MAKASAR}', "");
    Expect(0, 73472, '\p{Is_Block:	MAKASAR}', "");
    Expect(1, 73472, '\p{^Is_Block:	MAKASAR}', "");
    Expect(1, 73472, '\P{Is_Block:	MAKASAR}', "");
    Expect(0, 73472, '\P{^Is_Block:	MAKASAR}', "");
    Error('\p{Is_Blk=/a/Makasar}');
    Error('\P{Is_Blk=/a/Makasar}');
    Expect(1, 73471, '\p{Is_Blk=makasar}', "");
    Expect(0, 73471, '\p{^Is_Blk=makasar}', "");
    Expect(0, 73471, '\P{Is_Blk=makasar}', "");
    Expect(1, 73471, '\P{^Is_Blk=makasar}', "");
    Expect(0, 73472, '\p{Is_Blk=makasar}', "");
    Expect(1, 73472, '\p{^Is_Blk=makasar}', "");
    Expect(1, 73472, '\P{Is_Blk=makasar}', "");
    Expect(0, 73472, '\P{^Is_Blk=makasar}', "");
    Expect(1, 73471, '\p{Is_Blk:   -Makasar}', "");
    Expect(0, 73471, '\p{^Is_Blk:   -Makasar}', "");
    Expect(0, 73471, '\P{Is_Blk:   -Makasar}', "");
    Expect(1, 73471, '\P{^Is_Blk:   -Makasar}', "");
    Expect(0, 73472, '\p{Is_Blk:   -Makasar}', "");
    Expect(1, 73472, '\p{^Is_Blk:   -Makasar}', "");
    Expect(1, 73472, '\P{Is_Blk:   -Makasar}', "");
    Expect(0, 73472, '\P{^Is_Blk:   -Makasar}', "");
    Error('\p{Block= -Malayalam:=}');
    Error('\P{Block= -Malayalam:=}');
    Expect(1, 3455, '\p{Block=:\AMalayalam\z:}', "");;
    Expect(0, 3456, '\p{Block=:\AMalayalam\z:}', "");;
    Expect(1, 3455, '\p{Block=malayalam}', "");
    Expect(0, 3455, '\p{^Block=malayalam}', "");
    Expect(0, 3455, '\P{Block=malayalam}', "");
    Expect(1, 3455, '\P{^Block=malayalam}', "");
    Expect(0, 3456, '\p{Block=malayalam}', "");
    Expect(1, 3456, '\p{^Block=malayalam}', "");
    Expect(1, 3456, '\P{Block=malayalam}', "");
    Expect(0, 3456, '\P{^Block=malayalam}', "");
    Expect(1, 3455, '\p{Block=:\Amalayalam\z:}', "");;
    Expect(0, 3456, '\p{Block=:\Amalayalam\z:}', "");;
    Expect(1, 3455, '\p{Block=_	Malayalam}', "");
    Expect(0, 3455, '\p{^Block=_	Malayalam}', "");
    Expect(0, 3455, '\P{Block=_	Malayalam}', "");
    Expect(1, 3455, '\P{^Block=_	Malayalam}', "");
    Expect(0, 3456, '\p{Block=_	Malayalam}', "");
    Expect(1, 3456, '\p{^Block=_	Malayalam}', "");
    Expect(1, 3456, '\P{Block=_	Malayalam}', "");
    Expect(0, 3456, '\P{^Block=_	Malayalam}', "");
    Error('\p{Blk=	_Malayalam:=}');
    Error('\P{Blk=	_Malayalam:=}');
    Expect(1, 3455, '\p{Blk=:\AMalayalam\z:}', "");;
    Expect(0, 3456, '\p{Blk=:\AMalayalam\z:}', "");;
    Expect(1, 3455, '\p{Blk=malayalam}', "");
    Expect(0, 3455, '\p{^Blk=malayalam}', "");
    Expect(0, 3455, '\P{Blk=malayalam}', "");
    Expect(1, 3455, '\P{^Blk=malayalam}', "");
    Expect(0, 3456, '\p{Blk=malayalam}', "");
    Expect(1, 3456, '\p{^Blk=malayalam}', "");
    Expect(1, 3456, '\P{Blk=malayalam}', "");
    Expect(0, 3456, '\P{^Blk=malayalam}', "");
    Expect(1, 3455, '\p{Blk=:\Amalayalam\z:}', "");;
    Expect(0, 3456, '\p{Blk=:\Amalayalam\z:}', "");;
    Expect(1, 3455, '\p{Blk= 	Malayalam}', "");
    Expect(0, 3455, '\p{^Blk= 	Malayalam}', "");
    Expect(0, 3455, '\P{Blk= 	Malayalam}', "");
    Expect(1, 3455, '\P{^Blk= 	Malayalam}', "");
    Expect(0, 3456, '\p{Blk= 	Malayalam}', "");
    Expect(1, 3456, '\p{^Blk= 	Malayalam}', "");
    Expect(1, 3456, '\P{Blk= 	Malayalam}', "");
    Expect(0, 3456, '\P{^Blk= 	Malayalam}', "");
    Error('\p{Is_Block=	:=MALAYALAM}');
    Error('\P{Is_Block=	:=MALAYALAM}');
    Expect(1, 3455, '\p{Is_Block: malayalam}', "");
    Expect(0, 3455, '\p{^Is_Block: malayalam}', "");
    Expect(0, 3455, '\P{Is_Block: malayalam}', "");
    Expect(1, 3455, '\P{^Is_Block: malayalam}', "");
    Expect(0, 3456, '\p{Is_Block: malayalam}', "");
    Expect(1, 3456, '\p{^Is_Block: malayalam}', "");
    Expect(1, 3456, '\P{Is_Block: malayalam}', "");
    Expect(0, 3456, '\P{^Is_Block: malayalam}', "");
    Expect(1, 3455, '\p{Is_Block=		Malayalam}', "");
    Expect(0, 3455, '\p{^Is_Block=		Malayalam}', "");
    Expect(0, 3455, '\P{Is_Block=		Malayalam}', "");
    Expect(1, 3455, '\P{^Is_Block=		Malayalam}', "");
    Expect(0, 3456, '\p{Is_Block=		Malayalam}', "");
    Expect(1, 3456, '\p{^Is_Block=		Malayalam}', "");
    Expect(1, 3456, '\P{Is_Block=		Malayalam}', "");
    Expect(0, 3456, '\P{^Is_Block=		Malayalam}', "");
    Error('\p{Is_Blk= _Malayalam:=}');
    Error('\P{Is_Blk= _Malayalam:=}');
    Expect(1, 3455, '\p{Is_Blk=malayalam}', "");
    Expect(0, 3455, '\p{^Is_Blk=malayalam}', "");
    Expect(0, 3455, '\P{Is_Blk=malayalam}', "");
    Expect(1, 3455, '\P{^Is_Blk=malayalam}', "");
    Expect(0, 3456, '\p{Is_Blk=malayalam}', "");
    Expect(1, 3456, '\p{^Is_Blk=malayalam}', "");
    Expect(1, 3456, '\P{Is_Blk=malayalam}', "");
    Expect(0, 3456, '\P{^Is_Blk=malayalam}', "");
    Expect(1, 3455, '\p{Is_Blk=	 malayalam}', "");
    Expect(0, 3455, '\p{^Is_Blk=	 malayalam}', "");
    Expect(0, 3455, '\P{Is_Blk=	 malayalam}', "");
    Expect(1, 3455, '\P{^Is_Blk=	 malayalam}', "");
    Expect(0, 3456, '\p{Is_Blk=	 malayalam}', "");
    Expect(1, 3456, '\p{^Is_Blk=	 malayalam}', "");
    Expect(1, 3456, '\P{Is_Blk=	 malayalam}', "");
    Expect(0, 3456, '\P{^Is_Blk=	 malayalam}', "");
    Error('\p{Block= Mandaic/a/}');
    Error('\P{Block= Mandaic/a/}');
    Expect(1, 2143, '\p{Block=:\AMandaic\z:}', "");;
    Expect(0, 2144, '\p{Block=:\AMandaic\z:}', "");;
    Expect(1, 2143, '\p{Block=mandaic}', "");
    Expect(0, 2143, '\p{^Block=mandaic}', "");
    Expect(0, 2143, '\P{Block=mandaic}', "");
    Expect(1, 2143, '\P{^Block=mandaic}', "");
    Expect(0, 2144, '\p{Block=mandaic}', "");
    Expect(1, 2144, '\p{^Block=mandaic}', "");
    Expect(1, 2144, '\P{Block=mandaic}', "");
    Expect(0, 2144, '\P{^Block=mandaic}', "");
    Expect(1, 2143, '\p{Block=:\Amandaic\z:}', "");;
    Expect(0, 2144, '\p{Block=:\Amandaic\z:}', "");;
    Expect(1, 2143, '\p{Block=	Mandaic}', "");
    Expect(0, 2143, '\p{^Block=	Mandaic}', "");
    Expect(0, 2143, '\P{Block=	Mandaic}', "");
    Expect(1, 2143, '\P{^Block=	Mandaic}', "");
    Expect(0, 2144, '\p{Block=	Mandaic}', "");
    Expect(1, 2144, '\p{^Block=	Mandaic}', "");
    Expect(1, 2144, '\P{Block=	Mandaic}', "");
    Expect(0, 2144, '\P{^Block=	Mandaic}', "");
    Error('\p{Blk=		Mandaic/a/}');
    Error('\P{Blk=		Mandaic/a/}');
    Expect(1, 2143, '\p{Blk=:\AMandaic\z:}', "");;
    Expect(0, 2144, '\p{Blk=:\AMandaic\z:}', "");;
    Expect(1, 2143, '\p{Blk=mandaic}', "");
    Expect(0, 2143, '\p{^Blk=mandaic}', "");
    Expect(0, 2143, '\P{Blk=mandaic}', "");
    Expect(1, 2143, '\P{^Blk=mandaic}', "");
    Expect(0, 2144, '\p{Blk=mandaic}', "");
    Expect(1, 2144, '\p{^Blk=mandaic}', "");
    Expect(1, 2144, '\P{Blk=mandaic}', "");
    Expect(0, 2144, '\P{^Blk=mandaic}', "");
    Expect(1, 2143, '\p{Blk=:\Amandaic\z:}', "");;
    Expect(0, 2144, '\p{Blk=:\Amandaic\z:}', "");;
    Expect(1, 2143, '\p{Blk=	-MANDAIC}', "");
    Expect(0, 2143, '\p{^Blk=	-MANDAIC}', "");
    Expect(0, 2143, '\P{Blk=	-MANDAIC}', "");
    Expect(1, 2143, '\P{^Blk=	-MANDAIC}', "");
    Expect(0, 2144, '\p{Blk=	-MANDAIC}', "");
    Expect(1, 2144, '\p{^Blk=	-MANDAIC}', "");
    Expect(1, 2144, '\P{Blk=	-MANDAIC}', "");
    Expect(0, 2144, '\P{^Blk=	-MANDAIC}', "");
    Error('\p{Is_Block=_:=MANDAIC}');
    Error('\P{Is_Block=_:=MANDAIC}');
    Expect(1, 2143, '\p{Is_Block=mandaic}', "");
    Expect(0, 2143, '\p{^Is_Block=mandaic}', "");
    Expect(0, 2143, '\P{Is_Block=mandaic}', "");
    Expect(1, 2143, '\P{^Is_Block=mandaic}', "");
    Expect(0, 2144, '\p{Is_Block=mandaic}', "");
    Expect(1, 2144, '\p{^Is_Block=mandaic}', "");
    Expect(1, 2144, '\P{Is_Block=mandaic}', "");
    Expect(0, 2144, '\P{^Is_Block=mandaic}', "");
    Expect(1, 2143, '\p{Is_Block:    -Mandaic}', "");
    Expect(0, 2143, '\p{^Is_Block:    -Mandaic}', "");
    Expect(0, 2143, '\P{Is_Block:    -Mandaic}', "");
    Expect(1, 2143, '\P{^Is_Block:    -Mandaic}', "");
    Expect(0, 2144, '\p{Is_Block:    -Mandaic}', "");
    Expect(1, 2144, '\p{^Is_Block:    -Mandaic}', "");
    Expect(1, 2144, '\P{Is_Block:    -Mandaic}', "");
    Expect(0, 2144, '\P{^Is_Block:    -Mandaic}', "");
    Error('\p{Is_Blk:__MANDAIC:=}');
    Error('\P{Is_Blk:__MANDAIC:=}');
    Expect(1, 2143, '\p{Is_Blk=mandaic}', "");
    Expect(0, 2143, '\p{^Is_Blk=mandaic}', "");
    Expect(0, 2143, '\P{Is_Blk=mandaic}', "");
    Expect(1, 2143, '\P{^Is_Blk=mandaic}', "");
    Expect(0, 2144, '\p{Is_Blk=mandaic}', "");
    Expect(1, 2144, '\p{^Is_Blk=mandaic}', "");
    Expect(1, 2144, '\P{Is_Blk=mandaic}', "");
    Expect(0, 2144, '\P{^Is_Blk=mandaic}', "");
    Expect(1, 2143, '\p{Is_Blk= Mandaic}', "");
    Expect(0, 2143, '\p{^Is_Blk= Mandaic}', "");
    Expect(0, 2143, '\P{Is_Blk= Mandaic}', "");
    Expect(1, 2143, '\P{^Is_Blk= Mandaic}', "");
    Expect(0, 2144, '\p{Is_Blk= Mandaic}', "");
    Expect(1, 2144, '\p{^Is_Blk= Mandaic}', "");
    Expect(1, 2144, '\P{Is_Blk= Mandaic}', "");
    Expect(0, 2144, '\P{^Is_Blk= Mandaic}', "");
    Error('\p{Block= /a/manichaean}');
    Error('\P{Block= /a/manichaean}');
    Expect(1, 68351, '\p{Block=:\AManichaean\z:}', "");;
    Expect(0, 68352, '\p{Block=:\AManichaean\z:}', "");;
    Expect(1, 68351, '\p{Block=manichaean}', "");
    Expect(0, 68351, '\p{^Block=manichaean}', "");
    Expect(0, 68351, '\P{Block=manichaean}', "");
    Expect(1, 68351, '\P{^Block=manichaean}', "");
    Expect(0, 68352, '\p{Block=manichaean}', "");
    Expect(1, 68352, '\p{^Block=manichaean}', "");
    Expect(1, 68352, '\P{Block=manichaean}', "");
    Expect(0, 68352, '\P{^Block=manichaean}', "");
    Expect(1, 68351, '\p{Block=:\Amanichaean\z:}', "");;
    Expect(0, 68352, '\p{Block=:\Amanichaean\z:}', "");;
    Expect(1, 68351, '\p{Block=-_Manichaean}', "");
    Expect(0, 68351, '\p{^Block=-_Manichaean}', "");
    Expect(0, 68351, '\P{Block=-_Manichaean}', "");
    Expect(1, 68351, '\P{^Block=-_Manichaean}', "");
    Expect(0, 68352, '\p{Block=-_Manichaean}', "");
    Expect(1, 68352, '\p{^Block=-_Manichaean}', "");
    Expect(1, 68352, '\P{Block=-_Manichaean}', "");
    Expect(0, 68352, '\P{^Block=-_Manichaean}', "");
    Error('\p{Blk=_ manichaean/a/}');
    Error('\P{Blk=_ manichaean/a/}');
    Expect(1, 68351, '\p{Blk=:\AManichaean\z:}', "");;
    Expect(0, 68352, '\p{Blk=:\AManichaean\z:}', "");;
    Expect(1, 68351, '\p{Blk=manichaean}', "");
    Expect(0, 68351, '\p{^Blk=manichaean}', "");
    Expect(0, 68351, '\P{Blk=manichaean}', "");
    Expect(1, 68351, '\P{^Blk=manichaean}', "");
    Expect(0, 68352, '\p{Blk=manichaean}', "");
    Expect(1, 68352, '\p{^Blk=manichaean}', "");
    Expect(1, 68352, '\P{Blk=manichaean}', "");
    Expect(0, 68352, '\P{^Blk=manichaean}', "");
    Expect(1, 68351, '\p{Blk=:\Amanichaean\z:}', "");;
    Expect(0, 68352, '\p{Blk=:\Amanichaean\z:}', "");;
    Expect(1, 68351, '\p{Blk=  MANICHAEAN}', "");
    Expect(0, 68351, '\p{^Blk=  MANICHAEAN}', "");
    Expect(0, 68351, '\P{Blk=  MANICHAEAN}', "");
    Expect(1, 68351, '\P{^Blk=  MANICHAEAN}', "");
    Expect(0, 68352, '\p{Blk=  MANICHAEAN}', "");
    Expect(1, 68352, '\p{^Blk=  MANICHAEAN}', "");
    Expect(1, 68352, '\P{Blk=  MANICHAEAN}', "");
    Expect(0, 68352, '\P{^Blk=  MANICHAEAN}', "");
    Error('\p{Is_Block=_ Manichaean/a/}');
    Error('\P{Is_Block=_ Manichaean/a/}');
    Expect(1, 68351, '\p{Is_Block=manichaean}', "");
    Expect(0, 68351, '\p{^Is_Block=manichaean}', "");
    Expect(0, 68351, '\P{Is_Block=manichaean}', "");
    Expect(1, 68351, '\P{^Is_Block=manichaean}', "");
    Expect(0, 68352, '\p{Is_Block=manichaean}', "");
    Expect(1, 68352, '\p{^Is_Block=manichaean}', "");
    Expect(1, 68352, '\P{Is_Block=manichaean}', "");
    Expect(0, 68352, '\P{^Is_Block=manichaean}', "");
    Expect(1, 68351, '\p{Is_Block=  MANICHAEAN}', "");
    Expect(0, 68351, '\p{^Is_Block=  MANICHAEAN}', "");
    Expect(0, 68351, '\P{Is_Block=  MANICHAEAN}', "");
    Expect(1, 68351, '\P{^Is_Block=  MANICHAEAN}', "");
    Expect(0, 68352, '\p{Is_Block=  MANICHAEAN}', "");
    Expect(1, 68352, '\p{^Is_Block=  MANICHAEAN}', "");
    Expect(1, 68352, '\P{Is_Block=  MANICHAEAN}', "");
    Expect(0, 68352, '\P{^Is_Block=  MANICHAEAN}', "");
    Error('\p{Is_Blk=/a/- MANICHAEAN}');
    Error('\P{Is_Blk=/a/- MANICHAEAN}');
    Expect(1, 68351, '\p{Is_Blk=manichaean}', "");
    Expect(0, 68351, '\p{^Is_Blk=manichaean}', "");
    Expect(0, 68351, '\P{Is_Blk=manichaean}', "");
    Expect(1, 68351, '\P{^Is_Blk=manichaean}', "");
    Expect(0, 68352, '\p{Is_Blk=manichaean}', "");
    Expect(1, 68352, '\p{^Is_Blk=manichaean}', "");
    Expect(1, 68352, '\P{Is_Blk=manichaean}', "");
    Expect(0, 68352, '\P{^Is_Blk=manichaean}', "");
    Expect(1, 68351, '\p{Is_Blk= _Manichaean}', "");
    Expect(0, 68351, '\p{^Is_Blk= _Manichaean}', "");
    Expect(0, 68351, '\P{Is_Blk= _Manichaean}', "");
    Expect(1, 68351, '\P{^Is_Blk= _Manichaean}', "");
    Expect(0, 68352, '\p{Is_Blk= _Manichaean}', "");
    Expect(1, 68352, '\p{^Is_Blk= _Manichaean}', "");
    Expect(1, 68352, '\P{Is_Blk= _Manichaean}', "");
    Expect(0, 68352, '\P{^Is_Blk= _Manichaean}', "");
    Error('\p{Block=/a/ _Marchen}');
    Error('\P{Block=/a/ _Marchen}');
    Expect(1, 72895, '\p{Block=:\AMarchen\z:}', "");;
    Expect(0, 72896, '\p{Block=:\AMarchen\z:}', "");;
    Expect(1, 72895, '\p{Block:   marchen}', "");
    Expect(0, 72895, '\p{^Block:   marchen}', "");
    Expect(0, 72895, '\P{Block:   marchen}', "");
    Expect(1, 72895, '\P{^Block:   marchen}', "");
    Expect(0, 72896, '\p{Block:   marchen}', "");
    Expect(1, 72896, '\p{^Block:   marchen}', "");
    Expect(1, 72896, '\P{Block:   marchen}', "");
    Expect(0, 72896, '\P{^Block:   marchen}', "");
    Expect(1, 72895, '\p{Block=:\Amarchen\z:}', "");;
    Expect(0, 72896, '\p{Block=:\Amarchen\z:}', "");;
    Expect(1, 72895, '\p{Block=-_Marchen}', "");
    Expect(0, 72895, '\p{^Block=-_Marchen}', "");
    Expect(0, 72895, '\P{Block=-_Marchen}', "");
    Expect(1, 72895, '\P{^Block=-_Marchen}', "");
    Expect(0, 72896, '\p{Block=-_Marchen}', "");
    Expect(1, 72896, '\p{^Block=-_Marchen}', "");
    Expect(1, 72896, '\P{Block=-_Marchen}', "");
    Expect(0, 72896, '\P{^Block=-_Marchen}', "");
    Error('\p{Blk=/a/	-Marchen}');
    Error('\P{Blk=/a/	-Marchen}');
    Expect(1, 72895, '\p{Blk=:\AMarchen\z:}', "");;
    Expect(0, 72896, '\p{Blk=:\AMarchen\z:}', "");;
    Expect(1, 72895, '\p{Blk=marchen}', "");
    Expect(0, 72895, '\p{^Blk=marchen}', "");
    Expect(0, 72895, '\P{Blk=marchen}', "");
    Expect(1, 72895, '\P{^Blk=marchen}', "");
    Expect(0, 72896, '\p{Blk=marchen}', "");
    Expect(1, 72896, '\p{^Blk=marchen}', "");
    Expect(1, 72896, '\P{Blk=marchen}', "");
    Expect(0, 72896, '\P{^Blk=marchen}', "");
    Expect(1, 72895, '\p{Blk=:\Amarchen\z:}', "");;
    Expect(0, 72896, '\p{Blk=:\Amarchen\z:}', "");;
    Expect(1, 72895, '\p{Blk=_	Marchen}', "");
    Expect(0, 72895, '\p{^Blk=_	Marchen}', "");
    Expect(0, 72895, '\P{Blk=_	Marchen}', "");
    Expect(1, 72895, '\P{^Blk=_	Marchen}', "");
    Expect(0, 72896, '\p{Blk=_	Marchen}', "");
    Expect(1, 72896, '\p{^Blk=_	Marchen}', "");
    Expect(1, 72896, '\P{Blk=_	Marchen}', "");
    Expect(0, 72896, '\P{^Blk=_	Marchen}', "");
    Error('\p{Is_Block=:=_	MARCHEN}');
    Error('\P{Is_Block=:=_	MARCHEN}');
    Expect(1, 72895, '\p{Is_Block=marchen}', "");
    Expect(0, 72895, '\p{^Is_Block=marchen}', "");
    Expect(0, 72895, '\P{Is_Block=marchen}', "");
    Expect(1, 72895, '\P{^Is_Block=marchen}', "");
    Expect(0, 72896, '\p{Is_Block=marchen}', "");
    Expect(1, 72896, '\p{^Is_Block=marchen}', "");
    Expect(1, 72896, '\P{Is_Block=marchen}', "");
    Expect(0, 72896, '\P{^Is_Block=marchen}', "");
    Expect(1, 72895, '\p{Is_Block=_-MARCHEN}', "");
    Expect(0, 72895, '\p{^Is_Block=_-MARCHEN}', "");
    Expect(0, 72895, '\P{Is_Block=_-MARCHEN}', "");
    Expect(1, 72895, '\P{^Is_Block=_-MARCHEN}', "");
    Expect(0, 72896, '\p{Is_Block=_-MARCHEN}', "");
    Expect(1, 72896, '\p{^Is_Block=_-MARCHEN}', "");
    Expect(1, 72896, '\P{Is_Block=_-MARCHEN}', "");
    Expect(0, 72896, '\P{^Is_Block=_-MARCHEN}', "");
    Error('\p{Is_Blk=:=	Marchen}');
    Error('\P{Is_Blk=:=	Marchen}');
    Expect(1, 72895, '\p{Is_Blk=marchen}', "");
    Expect(0, 72895, '\p{^Is_Blk=marchen}', "");
    Expect(0, 72895, '\P{Is_Blk=marchen}', "");
    Expect(1, 72895, '\P{^Is_Blk=marchen}', "");
    Expect(0, 72896, '\p{Is_Blk=marchen}', "");
    Expect(1, 72896, '\p{^Is_Blk=marchen}', "");
    Expect(1, 72896, '\P{Is_Blk=marchen}', "");
    Expect(0, 72896, '\P{^Is_Blk=marchen}', "");
    Expect(1, 72895, '\p{Is_Blk= -Marchen}', "");
    Expect(0, 72895, '\p{^Is_Blk= -Marchen}', "");
    Expect(0, 72895, '\P{Is_Blk= -Marchen}', "");
    Expect(1, 72895, '\P{^Is_Blk= -Marchen}', "");
    Expect(0, 72896, '\p{Is_Blk= -Marchen}', "");
    Expect(1, 72896, '\p{^Is_Blk= -Marchen}', "");
    Expect(1, 72896, '\P{Is_Blk= -Marchen}', "");
    Expect(0, 72896, '\P{^Is_Blk= -Marchen}', "");
    Error('\p{Block=:= -Masaram_gondi}');
    Error('\P{Block=:= -Masaram_gondi}');
    Expect(1, 73055, '\p{Block=:\AMasaram_Gondi\z:}', "");;
    Expect(0, 73056, '\p{Block=:\AMasaram_Gondi\z:}', "");;
    Expect(1, 73055, '\p{Block=masaramgondi}', "");
    Expect(0, 73055, '\p{^Block=masaramgondi}', "");
    Expect(0, 73055, '\P{Block=masaramgondi}', "");
    Expect(1, 73055, '\P{^Block=masaramgondi}', "");
    Expect(0, 73056, '\p{Block=masaramgondi}', "");
    Expect(1, 73056, '\p{^Block=masaramgondi}', "");
    Expect(1, 73056, '\P{Block=masaramgondi}', "");
    Expect(0, 73056, '\P{^Block=masaramgondi}', "");
    Expect(1, 73055, '\p{Block=:\Amasaramgondi\z:}', "");;
    Expect(0, 73056, '\p{Block=:\Amasaramgondi\z:}', "");;
    Expect(1, 73055, '\p{Block=_-masaram_Gondi}', "");
    Expect(0, 73055, '\p{^Block=_-masaram_Gondi}', "");
    Expect(0, 73055, '\P{Block=_-masaram_Gondi}', "");
    Expect(1, 73055, '\P{^Block=_-masaram_Gondi}', "");
    Expect(0, 73056, '\p{Block=_-masaram_Gondi}', "");
    Expect(1, 73056, '\p{^Block=_-masaram_Gondi}', "");
    Expect(1, 73056, '\P{Block=_-masaram_Gondi}', "");
    Expect(0, 73056, '\P{^Block=_-masaram_Gondi}', "");
    Error('\p{Blk:   _	MASARAM_GONDI/a/}');
    Error('\P{Blk:   _	MASARAM_GONDI/a/}');
    Expect(1, 73055, '\p{Blk=:\AMasaram_Gondi\z:}', "");;
    Expect(0, 73056, '\p{Blk=:\AMasaram_Gondi\z:}', "");;
    Expect(1, 73055, '\p{Blk:   masaramgondi}', "");
    Expect(0, 73055, '\p{^Blk:   masaramgondi}', "");
    Expect(0, 73055, '\P{Blk:   masaramgondi}', "");
    Expect(1, 73055, '\P{^Blk:   masaramgondi}', "");
    Expect(0, 73056, '\p{Blk:   masaramgondi}', "");
    Expect(1, 73056, '\p{^Blk:   masaramgondi}', "");
    Expect(1, 73056, '\P{Blk:   masaramgondi}', "");
    Expect(0, 73056, '\P{^Blk:   masaramgondi}', "");
    Expect(1, 73055, '\p{Blk=:\Amasaramgondi\z:}', "");;
    Expect(0, 73056, '\p{Blk=:\Amasaramgondi\z:}', "");;
    Expect(1, 73055, '\p{Blk=-Masaram_gondi}', "");
    Expect(0, 73055, '\p{^Blk=-Masaram_gondi}', "");
    Expect(0, 73055, '\P{Blk=-Masaram_gondi}', "");
    Expect(1, 73055, '\P{^Blk=-Masaram_gondi}', "");
    Expect(0, 73056, '\p{Blk=-Masaram_gondi}', "");
    Expect(1, 73056, '\p{^Blk=-Masaram_gondi}', "");
    Expect(1, 73056, '\P{Blk=-Masaram_gondi}', "");
    Expect(0, 73056, '\P{^Blk=-Masaram_gondi}', "");
    Error('\p{Is_Block=_masaram_gondi/a/}');
    Error('\P{Is_Block=_masaram_gondi/a/}');
    Expect(1, 73055, '\p{Is_Block=masaramgondi}', "");
    Expect(0, 73055, '\p{^Is_Block=masaramgondi}', "");
    Expect(0, 73055, '\P{Is_Block=masaramgondi}', "");
    Expect(1, 73055, '\P{^Is_Block=masaramgondi}', "");
    Expect(0, 73056, '\p{Is_Block=masaramgondi}', "");
    Expect(1, 73056, '\p{^Is_Block=masaramgondi}', "");
    Expect(1, 73056, '\P{Is_Block=masaramgondi}', "");
    Expect(0, 73056, '\P{^Is_Block=masaramgondi}', "");
    Expect(1, 73055, '\p{Is_Block=	 Masaram_Gondi}', "");
    Expect(0, 73055, '\p{^Is_Block=	 Masaram_Gondi}', "");
    Expect(0, 73055, '\P{Is_Block=	 Masaram_Gondi}', "");
    Expect(1, 73055, '\P{^Is_Block=	 Masaram_Gondi}', "");
    Expect(0, 73056, '\p{Is_Block=	 Masaram_Gondi}', "");
    Expect(1, 73056, '\p{^Is_Block=	 Masaram_Gondi}', "");
    Expect(1, 73056, '\P{Is_Block=	 Masaram_Gondi}', "");
    Expect(0, 73056, '\P{^Is_Block=	 Masaram_Gondi}', "");
    Error('\p{Is_Blk:  /a/Masaram_Gondi}');
    Error('\P{Is_Blk:  /a/Masaram_Gondi}');
    Expect(1, 73055, '\p{Is_Blk=masaramgondi}', "");
    Expect(0, 73055, '\p{^Is_Blk=masaramgondi}', "");
    Expect(0, 73055, '\P{Is_Blk=masaramgondi}', "");
    Expect(1, 73055, '\P{^Is_Blk=masaramgondi}', "");
    Expect(0, 73056, '\p{Is_Blk=masaramgondi}', "");
    Expect(1, 73056, '\p{^Is_Blk=masaramgondi}', "");
    Expect(1, 73056, '\P{Is_Blk=masaramgondi}', "");
    Expect(0, 73056, '\P{^Is_Blk=masaramgondi}', "");
    Expect(1, 73055, '\p{Is_Blk:	_MASARAM_gondi}', "");
    Expect(0, 73055, '\p{^Is_Blk:	_MASARAM_gondi}', "");
    Expect(0, 73055, '\P{Is_Blk:	_MASARAM_gondi}', "");
    Expect(1, 73055, '\P{^Is_Blk:	_MASARAM_gondi}', "");
    Expect(0, 73056, '\p{Is_Blk:	_MASARAM_gondi}', "");
    Expect(1, 73056, '\p{^Is_Blk:	_MASARAM_gondi}', "");
    Expect(1, 73056, '\P{Is_Blk:	_MASARAM_gondi}', "");
    Expect(0, 73056, '\P{^Is_Blk:	_MASARAM_gondi}', "");
    Error('\p{Block=:=-mathematical_Alphanumeric_Symbols}');
    Error('\P{Block=:=-mathematical_Alphanumeric_Symbols}');
    Expect(1, 120831, '\p{Block=:\AMathematical_Alphanumeric_Symbols\z:}', "");;
    Expect(0, 120832, '\p{Block=:\AMathematical_Alphanumeric_Symbols\z:}', "");;
    Expect(1, 120831, '\p{Block:	mathematicalalphanumericsymbols}', "");
    Expect(0, 120831, '\p{^Block:	mathematicalalphanumericsymbols}', "");
    Expect(0, 120831, '\P{Block:	mathematicalalphanumericsymbols}', "");
    Expect(1, 120831, '\P{^Block:	mathematicalalphanumericsymbols}', "");
    Expect(0, 120832, '\p{Block:	mathematicalalphanumericsymbols}', "");
    Expect(1, 120832, '\p{^Block:	mathematicalalphanumericsymbols}', "");
    Expect(1, 120832, '\P{Block:	mathematicalalphanumericsymbols}', "");
    Expect(0, 120832, '\P{^Block:	mathematicalalphanumericsymbols}', "");
    Expect(1, 120831, '\p{Block=:\Amathematicalalphanumericsymbols\z:}', "");;
    Expect(0, 120832, '\p{Block=:\Amathematicalalphanumericsymbols\z:}', "");;
    Expect(1, 120831, '\p{Block= mathematical_ALPHANUMERIC_symbols}', "");
    Expect(0, 120831, '\p{^Block= mathematical_ALPHANUMERIC_symbols}', "");
    Expect(0, 120831, '\P{Block= mathematical_ALPHANUMERIC_symbols}', "");
    Expect(1, 120831, '\P{^Block= mathematical_ALPHANUMERIC_symbols}', "");
    Expect(0, 120832, '\p{Block= mathematical_ALPHANUMERIC_symbols}', "");
    Expect(1, 120832, '\p{^Block= mathematical_ALPHANUMERIC_symbols}', "");
    Expect(1, 120832, '\P{Block= mathematical_ALPHANUMERIC_symbols}', "");
    Expect(0, 120832, '\P{^Block= mathematical_ALPHANUMERIC_symbols}', "");
    Error('\p{Blk= :=Math_Alphanum}');
    Error('\P{Blk= :=Math_Alphanum}');
    Expect(1, 120831, '\p{Blk=:\AMath_Alphanum\z:}', "");;
    Expect(0, 120832, '\p{Blk=:\AMath_Alphanum\z:}', "");;
    Expect(1, 120831, '\p{Blk=mathalphanum}', "");
    Expect(0, 120831, '\p{^Blk=mathalphanum}', "");
    Expect(0, 120831, '\P{Blk=mathalphanum}', "");
    Expect(1, 120831, '\P{^Blk=mathalphanum}', "");
    Expect(0, 120832, '\p{Blk=mathalphanum}', "");
    Expect(1, 120832, '\p{^Blk=mathalphanum}', "");
    Expect(1, 120832, '\P{Blk=mathalphanum}', "");
    Expect(0, 120832, '\P{^Blk=mathalphanum}', "");
    Expect(1, 120831, '\p{Blk=:\Amathalphanum\z:}', "");;
    Expect(0, 120832, '\p{Blk=:\Amathalphanum\z:}', "");;
    Expect(1, 120831, '\p{Blk:    MATH_alphanum}', "");
    Expect(0, 120831, '\p{^Blk:    MATH_alphanum}', "");
    Expect(0, 120831, '\P{Blk:    MATH_alphanum}', "");
    Expect(1, 120831, '\P{^Blk:    MATH_alphanum}', "");
    Expect(0, 120832, '\p{Blk:    MATH_alphanum}', "");
    Expect(1, 120832, '\p{^Blk:    MATH_alphanum}', "");
    Expect(1, 120832, '\P{Blk:    MATH_alphanum}', "");
    Expect(0, 120832, '\P{^Blk:    MATH_alphanum}', "");
    Error('\p{Is_Block=:=-	mathematical_Alphanumeric_Symbols}');
    Error('\P{Is_Block=:=-	mathematical_Alphanumeric_Symbols}');
    Expect(1, 120831, '\p{Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120831, '\p{^Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120831, '\P{Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120831, '\P{^Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120832, '\p{Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120832, '\p{^Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120832, '\P{Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(0, 120832, '\P{^Is_Block=mathematicalalphanumericsymbols}', "");
    Expect(1, 120831, '\p{Is_Block= 	Mathematical_ALPHANUMERIC_SYMBOLS}', "");
    Expect(0, 120831, '\p{^Is_Block= 	Mathematical_ALPHANUMERIC_SYMBOLS}', "");
    Expect(0, 120831, '\P{Is_Block= 	Mathematical_ALPHANUMERIC_SYMBOLS}', "");
    Expect(1, 120831, '\P{^Is_Block= 	Mathematical_ALPHANUMERIC_SYMBOLS}', "");
    Expect(0, 120832, '\p{Is_Block= 	Mathematical_ALPHANUMERIC_SYMBOLS}', "");
    Expect(1, 120832, '\p{^Is_Block= 	Mathematical_ALPHANUMERIC_SYMBOLS}', "");
    Expect(1, 120832, '\P{Is_Block= 	Mathematical_ALPHANUMERIC_SYMBOLS}', "");
    Expect(0, 120832, '\P{^Is_Block= 	Mathematical_ALPHANUMERIC_SYMBOLS}', "");
    Error('\p{Is_Blk: /a/_ MATH_alphanum}');
    Error('\P{Is_Blk: /a/_ MATH_alphanum}');
    Expect(1, 120831, '\p{Is_Blk=mathalphanum}', "");
    Expect(0, 120831, '\p{^Is_Blk=mathalphanum}', "");
    Expect(0, 120831, '\P{Is_Blk=mathalphanum}', "");
    Expect(1, 120831, '\P{^Is_Blk=mathalphanum}', "");
    Expect(0, 120832, '\p{Is_Blk=mathalphanum}', "");
    Expect(1, 120832, '\p{^Is_Blk=mathalphanum}', "");
    Expect(1, 120832, '\P{Is_Blk=mathalphanum}', "");
    Expect(0, 120832, '\P{^Is_Blk=mathalphanum}', "");
    Expect(1, 120831, '\p{Is_Blk=--Math_ALPHANUM}', "");
    Expect(0, 120831, '\p{^Is_Blk=--Math_ALPHANUM}', "");
    Expect(0, 120831, '\P{Is_Blk=--Math_ALPHANUM}', "");
    Expect(1, 120831, '\P{^Is_Blk=--Math_ALPHANUM}', "");
    Expect(0, 120832, '\p{Is_Blk=--Math_ALPHANUM}', "");
    Expect(1, 120832, '\p{^Is_Blk=--Math_ALPHANUM}', "");
    Expect(1, 120832, '\P{Is_Blk=--Math_ALPHANUM}', "");
    Expect(0, 120832, '\P{^Is_Blk=--Math_ALPHANUM}', "");
    Error('\p{Block=/a/		mathematical_Operators}');
    Error('\P{Block=/a/		mathematical_Operators}');
    Expect(1, 8959, '\p{Block=:\AMathematical_Operators\z:}', "");;
    Expect(0, 8960, '\p{Block=:\AMathematical_Operators\z:}', "");;
    Expect(1, 8959, '\p{Block=mathematicaloperators}', "");
    Expect(0, 8959, '\p{^Block=mathematicaloperators}', "");
    Expect(0, 8959, '\P{Block=mathematicaloperators}', "");
    Expect(1, 8959, '\P{^Block=mathematicaloperators}', "");
    Expect(0, 8960, '\p{Block=mathematicaloperators}', "");
    Expect(1, 8960, '\p{^Block=mathematicaloperators}', "");
    Expect(1, 8960, '\P{Block=mathematicaloperators}', "");
    Expect(0, 8960, '\P{^Block=mathematicaloperators}', "");
    Expect(1, 8959, '\p{Block=:\Amathematicaloperators\z:}', "");;
    Expect(0, 8960, '\p{Block=:\Amathematicaloperators\z:}', "");;
    Expect(1, 8959, '\p{Block=	 MATHEMATICAL_Operators}', "");
    Expect(0, 8959, '\p{^Block=	 MATHEMATICAL_Operators}', "");
    Expect(0, 8959, '\P{Block=	 MATHEMATICAL_Operators}', "");
    Expect(1, 8959, '\P{^Block=	 MATHEMATICAL_Operators}', "");
    Expect(0, 8960, '\p{Block=	 MATHEMATICAL_Operators}', "");
    Expect(1, 8960, '\p{^Block=	 MATHEMATICAL_Operators}', "");
    Expect(1, 8960, '\P{Block=	 MATHEMATICAL_Operators}', "");
    Expect(0, 8960, '\P{^Block=	 MATHEMATICAL_Operators}', "");
    Error('\p{Blk=MATH_Operators/a/}');
    Error('\P{Blk=MATH_Operators/a/}');
    Expect(1, 8959, '\p{Blk=:\AMath_Operators\z:}', "");;
    Expect(0, 8960, '\p{Blk=:\AMath_Operators\z:}', "");;
    Expect(1, 8959, '\p{Blk=mathoperators}', "");
    Expect(0, 8959, '\p{^Blk=mathoperators}', "");
    Expect(0, 8959, '\P{Blk=mathoperators}', "");
    Expect(1, 8959, '\P{^Blk=mathoperators}', "");
    Expect(0, 8960, '\p{Blk=mathoperators}', "");
    Expect(1, 8960, '\p{^Blk=mathoperators}', "");
    Expect(1, 8960, '\P{Blk=mathoperators}', "");
    Expect(0, 8960, '\P{^Blk=mathoperators}', "");
    Expect(1, 8959, '\p{Blk=:\Amathoperators\z:}', "");;
    Expect(0, 8960, '\p{Blk=:\Amathoperators\z:}', "");;
    Expect(1, 8959, '\p{Blk=	math_Operators}', "");
    Expect(0, 8959, '\p{^Blk=	math_Operators}', "");
    Expect(0, 8959, '\P{Blk=	math_Operators}', "");
    Expect(1, 8959, '\P{^Blk=	math_Operators}', "");
    Expect(0, 8960, '\p{Blk=	math_Operators}', "");
    Expect(1, 8960, '\p{^Blk=	math_Operators}', "");
    Expect(1, 8960, '\P{Blk=	math_Operators}', "");
    Expect(0, 8960, '\P{^Blk=	math_Operators}', "");
    Error('\p{Is_Block=/a/mathematical_Operators}');
    Error('\P{Is_Block=/a/mathematical_Operators}');
    Expect(1, 8959, '\p{Is_Block=mathematicaloperators}', "");
    Expect(0, 8959, '\p{^Is_Block=mathematicaloperators}', "");
    Expect(0, 8959, '\P{Is_Block=mathematicaloperators}', "");
    Expect(1, 8959, '\P{^Is_Block=mathematicaloperators}', "");
    Expect(0, 8960, '\p{Is_Block=mathematicaloperators}', "");
    Expect(1, 8960, '\p{^Is_Block=mathematicaloperators}', "");
    Expect(1, 8960, '\P{Is_Block=mathematicaloperators}', "");
    Expect(0, 8960, '\P{^Is_Block=mathematicaloperators}', "");
    Expect(1, 8959, '\p{Is_Block=_Mathematical_Operators}', "");
    Expect(0, 8959, '\p{^Is_Block=_Mathematical_Operators}', "");
    Expect(0, 8959, '\P{Is_Block=_Mathematical_Operators}', "");
    Expect(1, 8959, '\P{^Is_Block=_Mathematical_Operators}', "");
    Expect(0, 8960, '\p{Is_Block=_Mathematical_Operators}', "");
    Expect(1, 8960, '\p{^Is_Block=_Mathematical_Operators}', "");
    Expect(1, 8960, '\P{Is_Block=_Mathematical_Operators}', "");
    Expect(0, 8960, '\P{^Is_Block=_Mathematical_Operators}', "");
    Error('\p{Is_Blk=	:=math_Operators}');
    Error('\P{Is_Blk=	:=math_Operators}');
    Expect(1, 8959, '\p{Is_Blk=mathoperators}', "");
    Expect(0, 8959, '\p{^Is_Blk=mathoperators}', "");
    Expect(0, 8959, '\P{Is_Blk=mathoperators}', "");
    Expect(1, 8959, '\P{^Is_Blk=mathoperators}', "");
    Expect(0, 8960, '\p{Is_Blk=mathoperators}', "");
    Expect(1, 8960, '\p{^Is_Blk=mathoperators}', "");
    Expect(1, 8960, '\P{Is_Blk=mathoperators}', "");
    Expect(0, 8960, '\P{^Is_Blk=mathoperators}', "");
    Expect(1, 8959, '\p{Is_Blk=--Math_Operators}', "");
    Expect(0, 8959, '\p{^Is_Blk=--Math_Operators}', "");
    Expect(0, 8959, '\P{Is_Blk=--Math_Operators}', "");
    Expect(1, 8959, '\P{^Is_Blk=--Math_Operators}', "");
    Expect(0, 8960, '\p{Is_Blk=--Math_Operators}', "");
    Expect(1, 8960, '\p{^Is_Blk=--Math_Operators}', "");
    Expect(1, 8960, '\P{Is_Blk=--Math_Operators}', "");
    Expect(0, 8960, '\P{^Is_Blk=--Math_Operators}', "");
    Error('\p{Block=:= -Mayan_Numerals}');
    Error('\P{Block=:= -Mayan_Numerals}');
    Expect(1, 119551, '\p{Block=:\AMayan_Numerals\z:}', "");;
    Expect(0, 119552, '\p{Block=:\AMayan_Numerals\z:}', "");;
    Expect(1, 119551, '\p{Block=mayannumerals}', "");
    Expect(0, 119551, '\p{^Block=mayannumerals}', "");
    Expect(0, 119551, '\P{Block=mayannumerals}', "");
    Expect(1, 119551, '\P{^Block=mayannumerals}', "");
    Expect(0, 119552, '\p{Block=mayannumerals}', "");
    Expect(1, 119552, '\p{^Block=mayannumerals}', "");
    Expect(1, 119552, '\P{Block=mayannumerals}', "");
    Expect(0, 119552, '\P{^Block=mayannumerals}', "");
    Expect(1, 119551, '\p{Block=:\Amayannumerals\z:}', "");;
    Expect(0, 119552, '\p{Block=:\Amayannumerals\z:}', "");;
    Expect(1, 119551, '\p{Block= Mayan_NUMERALS}', "");
    Expect(0, 119551, '\p{^Block= Mayan_NUMERALS}', "");
    Expect(0, 119551, '\P{Block= Mayan_NUMERALS}', "");
    Expect(1, 119551, '\P{^Block= Mayan_NUMERALS}', "");
    Expect(0, 119552, '\p{Block= Mayan_NUMERALS}', "");
    Expect(1, 119552, '\p{^Block= Mayan_NUMERALS}', "");
    Expect(1, 119552, '\P{Block= Mayan_NUMERALS}', "");
    Expect(0, 119552, '\P{^Block= Mayan_NUMERALS}', "");
    Error('\p{Blk=-Mayan_NUMERALS:=}');
    Error('\P{Blk=-Mayan_NUMERALS:=}');
    Expect(1, 119551, '\p{Blk=:\AMayan_Numerals\z:}', "");;
    Expect(0, 119552, '\p{Blk=:\AMayan_Numerals\z:}', "");;
    Expect(1, 119551, '\p{Blk: mayannumerals}', "");
    Expect(0, 119551, '\p{^Blk: mayannumerals}', "");
    Expect(0, 119551, '\P{Blk: mayannumerals}', "");
    Expect(1, 119551, '\P{^Blk: mayannumerals}', "");
    Expect(0, 119552, '\p{Blk: mayannumerals}', "");
    Expect(1, 119552, '\p{^Blk: mayannumerals}', "");
    Expect(1, 119552, '\P{Blk: mayannumerals}', "");
    Expect(0, 119552, '\P{^Blk: mayannumerals}', "");
    Expect(1, 119551, '\p{Blk=:\Amayannumerals\z:}', "");;
    Expect(0, 119552, '\p{Blk=:\Amayannumerals\z:}', "");;
    Expect(1, 119551, '\p{Blk=	Mayan_NUMERALS}', "");
    Expect(0, 119551, '\p{^Blk=	Mayan_NUMERALS}', "");
    Expect(0, 119551, '\P{Blk=	Mayan_NUMERALS}', "");
    Expect(1, 119551, '\P{^Blk=	Mayan_NUMERALS}', "");
    Expect(0, 119552, '\p{Blk=	Mayan_NUMERALS}', "");
    Expect(1, 119552, '\p{^Blk=	Mayan_NUMERALS}', "");
    Expect(1, 119552, '\P{Blk=	Mayan_NUMERALS}', "");
    Expect(0, 119552, '\P{^Blk=	Mayan_NUMERALS}', "");
    Error('\p{Is_Block=/a/_MAYAN_Numerals}');
    Error('\P{Is_Block=/a/_MAYAN_Numerals}');
    Expect(1, 119551, '\p{Is_Block=mayannumerals}', "");
    Expect(0, 119551, '\p{^Is_Block=mayannumerals}', "");
    Expect(0, 119551, '\P{Is_Block=mayannumerals}', "");
    Expect(1, 119551, '\P{^Is_Block=mayannumerals}', "");
    Expect(0, 119552, '\p{Is_Block=mayannumerals}', "");
    Expect(1, 119552, '\p{^Is_Block=mayannumerals}', "");
    Expect(1, 119552, '\P{Is_Block=mayannumerals}', "");
    Expect(0, 119552, '\P{^Is_Block=mayannumerals}', "");
    Expect(1, 119551, '\p{Is_Block=		mayan_NUMERALS}', "");
    Expect(0, 119551, '\p{^Is_Block=		mayan_NUMERALS}', "");
    Expect(0, 119551, '\P{Is_Block=		mayan_NUMERALS}', "");
    Expect(1, 119551, '\P{^Is_Block=		mayan_NUMERALS}', "");
    Expect(0, 119552, '\p{Is_Block=		mayan_NUMERALS}', "");
    Expect(1, 119552, '\p{^Is_Block=		mayan_NUMERALS}', "");
    Expect(1, 119552, '\P{Is_Block=		mayan_NUMERALS}', "");
    Expect(0, 119552, '\P{^Is_Block=		mayan_NUMERALS}', "");
    Error('\p{Is_Blk=/a/	Mayan_NUMERALS}');
    Error('\P{Is_Blk=/a/	Mayan_NUMERALS}');
    Expect(1, 119551, '\p{Is_Blk=mayannumerals}', "");
    Expect(0, 119551, '\p{^Is_Blk=mayannumerals}', "");
    Expect(0, 119551, '\P{Is_Blk=mayannumerals}', "");
    Expect(1, 119551, '\P{^Is_Blk=mayannumerals}', "");
    Expect(0, 119552, '\p{Is_Blk=mayannumerals}', "");
    Expect(1, 119552, '\p{^Is_Blk=mayannumerals}', "");
    Expect(1, 119552, '\P{Is_Blk=mayannumerals}', "");
    Expect(0, 119552, '\P{^Is_Blk=mayannumerals}', "");
    Expect(1, 119551, '\p{Is_Blk=_Mayan_NUMERALS}', "");
    Expect(0, 119551, '\p{^Is_Blk=_Mayan_NUMERALS}', "");
    Expect(0, 119551, '\P{Is_Blk=_Mayan_NUMERALS}', "");
    Expect(1, 119551, '\P{^Is_Blk=_Mayan_NUMERALS}', "");
    Expect(0, 119552, '\p{Is_Blk=_Mayan_NUMERALS}', "");
    Expect(1, 119552, '\p{^Is_Blk=_Mayan_NUMERALS}', "");
    Expect(1, 119552, '\P{Is_Blk=_Mayan_NUMERALS}', "");
    Expect(0, 119552, '\P{^Is_Blk=_Mayan_NUMERALS}', "");
    Error('\p{Block=:= _Medefaidrin}');
    Error('\P{Block=:= _Medefaidrin}');
    Expect(1, 93855, '\p{Block=:\AMedefaidrin\z:}', "");;
    Expect(0, 93856, '\p{Block=:\AMedefaidrin\z:}', "");;
    Expect(1, 93855, '\p{Block=medefaidrin}', "");
    Expect(0, 93855, '\p{^Block=medefaidrin}', "");
    Expect(0, 93855, '\P{Block=medefaidrin}', "");
    Expect(1, 93855, '\P{^Block=medefaidrin}', "");
    Expect(0, 93856, '\p{Block=medefaidrin}', "");
    Expect(1, 93856, '\p{^Block=medefaidrin}', "");
    Expect(1, 93856, '\P{Block=medefaidrin}', "");
    Expect(0, 93856, '\P{^Block=medefaidrin}', "");
    Expect(1, 93855, '\p{Block=:\Amedefaidrin\z:}', "");;
    Expect(0, 93856, '\p{Block=:\Amedefaidrin\z:}', "");;
    Expect(1, 93855, '\p{Block=	Medefaidrin}', "");
    Expect(0, 93855, '\p{^Block=	Medefaidrin}', "");
    Expect(0, 93855, '\P{Block=	Medefaidrin}', "");
    Expect(1, 93855, '\P{^Block=	Medefaidrin}', "");
    Expect(0, 93856, '\p{Block=	Medefaidrin}', "");
    Expect(1, 93856, '\p{^Block=	Medefaidrin}', "");
    Expect(1, 93856, '\P{Block=	Medefaidrin}', "");
    Expect(0, 93856, '\P{^Block=	Medefaidrin}', "");
    Error('\p{Blk=/a/medefaidrin}');
    Error('\P{Blk=/a/medefaidrin}');
    Expect(1, 93855, '\p{Blk=:\AMedefaidrin\z:}', "");;
    Expect(0, 93856, '\p{Blk=:\AMedefaidrin\z:}', "");;
    Expect(1, 93855, '\p{Blk:medefaidrin}', "");
    Expect(0, 93855, '\p{^Blk:medefaidrin}', "");
    Expect(0, 93855, '\P{Blk:medefaidrin}', "");
    Expect(1, 93855, '\P{^Blk:medefaidrin}', "");
    Expect(0, 93856, '\p{Blk:medefaidrin}', "");
    Expect(1, 93856, '\p{^Blk:medefaidrin}', "");
    Expect(1, 93856, '\P{Blk:medefaidrin}', "");
    Expect(0, 93856, '\P{^Blk:medefaidrin}', "");
    Expect(1, 93855, '\p{Blk=:\Amedefaidrin\z:}', "");;
    Expect(0, 93856, '\p{Blk=:\Amedefaidrin\z:}', "");;
    Expect(1, 93855, '\p{Blk=	Medefaidrin}', "");
    Expect(0, 93855, '\p{^Blk=	Medefaidrin}', "");
    Expect(0, 93855, '\P{Blk=	Medefaidrin}', "");
    Expect(1, 93855, '\P{^Blk=	Medefaidrin}', "");
    Expect(0, 93856, '\p{Blk=	Medefaidrin}', "");
    Expect(1, 93856, '\p{^Blk=	Medefaidrin}', "");
    Expect(1, 93856, '\P{Blk=	Medefaidrin}', "");
    Expect(0, 93856, '\P{^Blk=	Medefaidrin}', "");
    Error('\p{Is_Block=:=MEDEFAIDRIN}');
    Error('\P{Is_Block=:=MEDEFAIDRIN}');
    Expect(1, 93855, '\p{Is_Block=medefaidrin}', "");
    Expect(0, 93855, '\p{^Is_Block=medefaidrin}', "");
    Expect(0, 93855, '\P{Is_Block=medefaidrin}', "");
    Expect(1, 93855, '\P{^Is_Block=medefaidrin}', "");
    Expect(0, 93856, '\p{Is_Block=medefaidrin}', "");
    Expect(1, 93856, '\p{^Is_Block=medefaidrin}', "");
    Expect(1, 93856, '\P{Is_Block=medefaidrin}', "");
    Expect(0, 93856, '\P{^Is_Block=medefaidrin}', "");
    Expect(1, 93855, '\p{Is_Block=-_medefaidrin}', "");
    Expect(0, 93855, '\p{^Is_Block=-_medefaidrin}', "");
    Expect(0, 93855, '\P{Is_Block=-_medefaidrin}', "");
    Expect(1, 93855, '\P{^Is_Block=-_medefaidrin}', "");
    Expect(0, 93856, '\p{Is_Block=-_medefaidrin}', "");
    Expect(1, 93856, '\p{^Is_Block=-_medefaidrin}', "");
    Expect(1, 93856, '\P{Is_Block=-_medefaidrin}', "");
    Expect(0, 93856, '\P{^Is_Block=-_medefaidrin}', "");
    Error('\p{Is_Blk= /a/Medefaidrin}');
    Error('\P{Is_Blk= /a/Medefaidrin}');
    Expect(1, 93855, '\p{Is_Blk:	medefaidrin}', "");
    Expect(0, 93855, '\p{^Is_Blk:	medefaidrin}', "");
    Expect(0, 93855, '\P{Is_Blk:	medefaidrin}', "");
    Expect(1, 93855, '\P{^Is_Blk:	medefaidrin}', "");
    Expect(0, 93856, '\p{Is_Blk:	medefaidrin}', "");
    Expect(1, 93856, '\p{^Is_Blk:	medefaidrin}', "");
    Expect(1, 93856, '\P{Is_Blk:	medefaidrin}', "");
    Expect(0, 93856, '\P{^Is_Blk:	medefaidrin}', "");
    Expect(1, 93855, '\p{Is_Blk=		MEDEFAIDRIN}', "");
    Expect(0, 93855, '\p{^Is_Blk=		MEDEFAIDRIN}', "");
    Expect(0, 93855, '\P{Is_Blk=		MEDEFAIDRIN}', "");
    Expect(1, 93855, '\P{^Is_Blk=		MEDEFAIDRIN}', "");
    Expect(0, 93856, '\p{Is_Blk=		MEDEFAIDRIN}', "");
    Expect(1, 93856, '\p{^Is_Blk=		MEDEFAIDRIN}', "");
    Expect(1, 93856, '\P{Is_Blk=		MEDEFAIDRIN}', "");
    Expect(0, 93856, '\P{^Is_Blk=		MEDEFAIDRIN}', "");
    Error('\p{Block=	/a/Meetei_MAYEK}');
    Error('\P{Block=	/a/Meetei_MAYEK}');
    Expect(1, 44031, '\p{Block=:\AMeetei_Mayek\z:}', "");;
    Expect(0, 44032, '\p{Block=:\AMeetei_Mayek\z:}', "");;
    Expect(1, 44031, '\p{Block=meeteimayek}', "");
    Expect(0, 44031, '\p{^Block=meeteimayek}', "");
    Expect(0, 44031, '\P{Block=meeteimayek}', "");
    Expect(1, 44031, '\P{^Block=meeteimayek}', "");
    Expect(0, 44032, '\p{Block=meeteimayek}', "");
    Expect(1, 44032, '\p{^Block=meeteimayek}', "");
    Expect(1, 44032, '\P{Block=meeteimayek}', "");
    Expect(0, 44032, '\P{^Block=meeteimayek}', "");
    Expect(1, 44031, '\p{Block=:\Ameeteimayek\z:}', "");;
    Expect(0, 44032, '\p{Block=:\Ameeteimayek\z:}', "");;
    Expect(1, 44031, '\p{Block=  Meetei_Mayek}', "");
    Expect(0, 44031, '\p{^Block=  Meetei_Mayek}', "");
    Expect(0, 44031, '\P{Block=  Meetei_Mayek}', "");
    Expect(1, 44031, '\P{^Block=  Meetei_Mayek}', "");
    Expect(0, 44032, '\p{Block=  Meetei_Mayek}', "");
    Expect(1, 44032, '\p{^Block=  Meetei_Mayek}', "");
    Expect(1, 44032, '\P{Block=  Meetei_Mayek}', "");
    Expect(0, 44032, '\P{^Block=  Meetei_Mayek}', "");
    Error('\p{Blk=MEETEI_Mayek/a/}');
    Error('\P{Blk=MEETEI_Mayek/a/}');
    Expect(1, 44031, '\p{Blk=:\AMeetei_Mayek\z:}', "");;
    Expect(0, 44032, '\p{Blk=:\AMeetei_Mayek\z:}', "");;
    Expect(1, 44031, '\p{Blk=meeteimayek}', "");
    Expect(0, 44031, '\p{^Blk=meeteimayek}', "");
    Expect(0, 44031, '\P{Blk=meeteimayek}', "");
    Expect(1, 44031, '\P{^Blk=meeteimayek}', "");
    Expect(0, 44032, '\p{Blk=meeteimayek}', "");
    Expect(1, 44032, '\p{^Blk=meeteimayek}', "");
    Expect(1, 44032, '\P{Blk=meeteimayek}', "");
    Expect(0, 44032, '\P{^Blk=meeteimayek}', "");
    Expect(1, 44031, '\p{Blk=:\Ameeteimayek\z:}', "");;
    Expect(0, 44032, '\p{Blk=:\Ameeteimayek\z:}', "");;
    Expect(1, 44031, '\p{Blk=	_Meetei_Mayek}', "");
    Expect(0, 44031, '\p{^Blk=	_Meetei_Mayek}', "");
    Expect(0, 44031, '\P{Blk=	_Meetei_Mayek}', "");
    Expect(1, 44031, '\P{^Blk=	_Meetei_Mayek}', "");
    Expect(0, 44032, '\p{Blk=	_Meetei_Mayek}', "");
    Expect(1, 44032, '\p{^Blk=	_Meetei_Mayek}', "");
    Expect(1, 44032, '\P{Blk=	_Meetei_Mayek}', "");
    Expect(0, 44032, '\P{^Blk=	_Meetei_Mayek}', "");
    Error('\p{Is_Block=__Meetei_Mayek/a/}');
    Error('\P{Is_Block=__Meetei_Mayek/a/}');
    Expect(1, 44031, '\p{Is_Block=meeteimayek}', "");
    Expect(0, 44031, '\p{^Is_Block=meeteimayek}', "");
    Expect(0, 44031, '\P{Is_Block=meeteimayek}', "");
    Expect(1, 44031, '\P{^Is_Block=meeteimayek}', "");
    Expect(0, 44032, '\p{Is_Block=meeteimayek}', "");
    Expect(1, 44032, '\p{^Is_Block=meeteimayek}', "");
    Expect(1, 44032, '\P{Is_Block=meeteimayek}', "");
    Expect(0, 44032, '\P{^Is_Block=meeteimayek}', "");
    Expect(1, 44031, '\p{Is_Block=--MEETEI_Mayek}', "");
    Expect(0, 44031, '\p{^Is_Block=--MEETEI_Mayek}', "");
    Expect(0, 44031, '\P{Is_Block=--MEETEI_Mayek}', "");
    Expect(1, 44031, '\P{^Is_Block=--MEETEI_Mayek}', "");
    Expect(0, 44032, '\p{Is_Block=--MEETEI_Mayek}', "");
    Expect(1, 44032, '\p{^Is_Block=--MEETEI_Mayek}', "");
    Expect(1, 44032, '\P{Is_Block=--MEETEI_Mayek}', "");
    Expect(0, 44032, '\P{^Is_Block=--MEETEI_Mayek}', "");
    Error('\p{Is_Blk=/a/ -MEETEI_mayek}');
    Error('\P{Is_Blk=/a/ -MEETEI_mayek}');
    Expect(1, 44031, '\p{Is_Blk=meeteimayek}', "");
    Expect(0, 44031, '\p{^Is_Blk=meeteimayek}', "");
    Expect(0, 44031, '\P{Is_Blk=meeteimayek}', "");
    Expect(1, 44031, '\P{^Is_Blk=meeteimayek}', "");
    Expect(0, 44032, '\p{Is_Blk=meeteimayek}', "");
    Expect(1, 44032, '\p{^Is_Blk=meeteimayek}', "");
    Expect(1, 44032, '\P{Is_Blk=meeteimayek}', "");
    Expect(0, 44032, '\P{^Is_Blk=meeteimayek}', "");
    Expect(1, 44031, '\p{Is_Blk=- meetei_mayek}', "");
    Expect(0, 44031, '\p{^Is_Blk=- meetei_mayek}', "");
    Expect(0, 44031, '\P{Is_Blk=- meetei_mayek}', "");
    Expect(1, 44031, '\P{^Is_Blk=- meetei_mayek}', "");
    Expect(0, 44032, '\p{Is_Blk=- meetei_mayek}', "");
    Expect(1, 44032, '\p{^Is_Blk=- meetei_mayek}', "");
    Expect(1, 44032, '\P{Is_Blk=- meetei_mayek}', "");
    Expect(0, 44032, '\P{^Is_Blk=- meetei_mayek}', "");
    Error('\p{Block=-_MEETEI_MAYEK_extensions:=}');
    Error('\P{Block=-_MEETEI_MAYEK_extensions:=}');
    Expect(1, 43775, '\p{Block=:\AMeetei_Mayek_Extensions\z:}', "");;
    Expect(0, 43776, '\p{Block=:\AMeetei_Mayek_Extensions\z:}', "");;
    Expect(1, 43775, '\p{Block=meeteimayekextensions}', "");
    Expect(0, 43775, '\p{^Block=meeteimayekextensions}', "");
    Expect(0, 43775, '\P{Block=meeteimayekextensions}', "");
    Expect(1, 43775, '\P{^Block=meeteimayekextensions}', "");
    Expect(0, 43776, '\p{Block=meeteimayekextensions}', "");
    Expect(1, 43776, '\p{^Block=meeteimayekextensions}', "");
    Expect(1, 43776, '\P{Block=meeteimayekextensions}', "");
    Expect(0, 43776, '\P{^Block=meeteimayekextensions}', "");
    Expect(1, 43775, '\p{Block=:\Ameeteimayekextensions\z:}', "");;
    Expect(0, 43776, '\p{Block=:\Ameeteimayekextensions\z:}', "");;
    Expect(1, 43775, '\p{Block=--Meetei_Mayek_EXTENSIONS}', "");
    Expect(0, 43775, '\p{^Block=--Meetei_Mayek_EXTENSIONS}', "");
    Expect(0, 43775, '\P{Block=--Meetei_Mayek_EXTENSIONS}', "");
    Expect(1, 43775, '\P{^Block=--Meetei_Mayek_EXTENSIONS}', "");
    Expect(0, 43776, '\p{Block=--Meetei_Mayek_EXTENSIONS}', "");
    Expect(1, 43776, '\p{^Block=--Meetei_Mayek_EXTENSIONS}', "");
    Expect(1, 43776, '\P{Block=--Meetei_Mayek_EXTENSIONS}', "");
    Expect(0, 43776, '\P{^Block=--Meetei_Mayek_EXTENSIONS}', "");
    Error('\p{Blk=_:=meetei_mayek_ext}');
    Error('\P{Blk=_:=meetei_mayek_ext}');
    Expect(1, 43775, '\p{Blk=:\AMeetei_Mayek_Ext\z:}', "");;
    Expect(0, 43776, '\p{Blk=:\AMeetei_Mayek_Ext\z:}', "");;
    Expect(1, 43775, '\p{Blk=meeteimayekext}', "");
    Expect(0, 43775, '\p{^Blk=meeteimayekext}', "");
    Expect(0, 43775, '\P{Blk=meeteimayekext}', "");
    Expect(1, 43775, '\P{^Blk=meeteimayekext}', "");
    Expect(0, 43776, '\p{Blk=meeteimayekext}', "");
    Expect(1, 43776, '\p{^Blk=meeteimayekext}', "");
    Expect(1, 43776, '\P{Blk=meeteimayekext}', "");
    Expect(0, 43776, '\P{^Blk=meeteimayekext}', "");
    Expect(1, 43775, '\p{Blk=:\Ameeteimayekext\z:}', "");;
    Expect(0, 43776, '\p{Blk=:\Ameeteimayekext\z:}', "");;
    Expect(1, 43775, '\p{Blk:		_MEETEI_Mayek_Ext}', "");
    Expect(0, 43775, '\p{^Blk:		_MEETEI_Mayek_Ext}', "");
    Expect(0, 43775, '\P{Blk:		_MEETEI_Mayek_Ext}', "");
    Expect(1, 43775, '\P{^Blk:		_MEETEI_Mayek_Ext}', "");
    Expect(0, 43776, '\p{Blk:		_MEETEI_Mayek_Ext}', "");
    Expect(1, 43776, '\p{^Blk:		_MEETEI_Mayek_Ext}', "");
    Expect(1, 43776, '\P{Blk:		_MEETEI_Mayek_Ext}', "");
    Expect(0, 43776, '\P{^Blk:		_MEETEI_Mayek_Ext}', "");
    Error('\p{Is_Block=/a/meetei_Mayek_Extensions}');
    Error('\P{Is_Block=/a/meetei_Mayek_Extensions}');
    Expect(1, 43775, '\p{Is_Block=meeteimayekextensions}', "");
    Expect(0, 43775, '\p{^Is_Block=meeteimayekextensions}', "");
    Expect(0, 43775, '\P{Is_Block=meeteimayekextensions}', "");
    Expect(1, 43775, '\P{^Is_Block=meeteimayekextensions}', "");
    Expect(0, 43776, '\p{Is_Block=meeteimayekextensions}', "");
    Expect(1, 43776, '\p{^Is_Block=meeteimayekextensions}', "");
    Expect(1, 43776, '\P{Is_Block=meeteimayekextensions}', "");
    Expect(0, 43776, '\P{^Is_Block=meeteimayekextensions}', "");
    Expect(1, 43775, '\p{Is_Block=--MEETEI_Mayek_extensions}', "");
    Expect(0, 43775, '\p{^Is_Block=--MEETEI_Mayek_extensions}', "");
    Expect(0, 43775, '\P{Is_Block=--MEETEI_Mayek_extensions}', "");
    Expect(1, 43775, '\P{^Is_Block=--MEETEI_Mayek_extensions}', "");
    Expect(0, 43776, '\p{Is_Block=--MEETEI_Mayek_extensions}', "");
    Expect(1, 43776, '\p{^Is_Block=--MEETEI_Mayek_extensions}', "");
    Expect(1, 43776, '\P{Is_Block=--MEETEI_Mayek_extensions}', "");
    Expect(0, 43776, '\P{^Is_Block=--MEETEI_Mayek_extensions}', "");
    Error('\p{Is_Blk= 	Meetei_mayek_ext:=}');
    Error('\P{Is_Blk= 	Meetei_mayek_ext:=}');
    Expect(1, 43775, '\p{Is_Blk=meeteimayekext}', "");
    Expect(0, 43775, '\p{^Is_Blk=meeteimayekext}', "");
    Expect(0, 43775, '\P{Is_Blk=meeteimayekext}', "");
    Expect(1, 43775, '\P{^Is_Blk=meeteimayekext}', "");
    Expect(0, 43776, '\p{Is_Blk=meeteimayekext}', "");
    Expect(1, 43776, '\p{^Is_Blk=meeteimayekext}', "");
    Expect(1, 43776, '\P{Is_Blk=meeteimayekext}', "");
    Expect(0, 43776, '\P{^Is_Blk=meeteimayekext}', "");
    Expect(1, 43775, '\p{Is_Blk:	_meetei_mayek_ext}', "");
    Expect(0, 43775, '\p{^Is_Blk:	_meetei_mayek_ext}', "");
    Expect(0, 43775, '\P{Is_Blk:	_meetei_mayek_ext}', "");
    Expect(1, 43775, '\P{^Is_Blk:	_meetei_mayek_ext}', "");
    Expect(0, 43776, '\p{Is_Blk:	_meetei_mayek_ext}', "");
    Expect(1, 43776, '\p{^Is_Blk:	_meetei_mayek_ext}', "");
    Expect(1, 43776, '\P{Is_Blk:	_meetei_mayek_ext}', "");
    Expect(0, 43776, '\P{^Is_Blk:	_meetei_mayek_ext}', "");
    Error('\p{Block=	_Mende_KIKAKUI:=}');
    Error('\P{Block=	_Mende_KIKAKUI:=}');
    Expect(1, 125151, '\p{Block=:\AMende_Kikakui\z:}', "");;
    Expect(0, 125152, '\p{Block=:\AMende_Kikakui\z:}', "");;
    Expect(1, 125151, '\p{Block=mendekikakui}', "");
    Expect(0, 125151, '\p{^Block=mendekikakui}', "");
    Expect(0, 125151, '\P{Block=mendekikakui}', "");
    Expect(1, 125151, '\P{^Block=mendekikakui}', "");
    Expect(0, 125152, '\p{Block=mendekikakui}', "");
    Expect(1, 125152, '\p{^Block=mendekikakui}', "");
    Expect(1, 125152, '\P{Block=mendekikakui}', "");
    Expect(0, 125152, '\P{^Block=mendekikakui}', "");
    Expect(1, 125151, '\p{Block=:\Amendekikakui\z:}', "");;
    Expect(0, 125152, '\p{Block=:\Amendekikakui\z:}', "");;
    Expect(1, 125151, '\p{Block= mende_Kikakui}', "");
    Expect(0, 125151, '\p{^Block= mende_Kikakui}', "");
    Expect(0, 125151, '\P{Block= mende_Kikakui}', "");
    Expect(1, 125151, '\P{^Block= mende_Kikakui}', "");
    Expect(0, 125152, '\p{Block= mende_Kikakui}', "");
    Expect(1, 125152, '\p{^Block= mende_Kikakui}', "");
    Expect(1, 125152, '\P{Block= mende_Kikakui}', "");
    Expect(0, 125152, '\P{^Block= mende_Kikakui}', "");
    Error('\p{Blk=-:=Mende_KIKAKUI}');
    Error('\P{Blk=-:=Mende_KIKAKUI}');
    Expect(1, 125151, '\p{Blk=:\AMende_Kikakui\z:}', "");;
    Expect(0, 125152, '\p{Blk=:\AMende_Kikakui\z:}', "");;
    Expect(1, 125151, '\p{Blk=mendekikakui}', "");
    Expect(0, 125151, '\p{^Blk=mendekikakui}', "");
    Expect(0, 125151, '\P{Blk=mendekikakui}', "");
    Expect(1, 125151, '\P{^Blk=mendekikakui}', "");
    Expect(0, 125152, '\p{Blk=mendekikakui}', "");
    Expect(1, 125152, '\p{^Blk=mendekikakui}', "");
    Expect(1, 125152, '\P{Blk=mendekikakui}', "");
    Expect(0, 125152, '\P{^Blk=mendekikakui}', "");
    Expect(1, 125151, '\p{Blk=:\Amendekikakui\z:}', "");;
    Expect(0, 125152, '\p{Blk=:\Amendekikakui\z:}', "");;
    Expect(1, 125151, '\p{Blk=-_mende_kikakui}', "");
    Expect(0, 125151, '\p{^Blk=-_mende_kikakui}', "");
    Expect(0, 125151, '\P{Blk=-_mende_kikakui}', "");
    Expect(1, 125151, '\P{^Blk=-_mende_kikakui}', "");
    Expect(0, 125152, '\p{Blk=-_mende_kikakui}', "");
    Expect(1, 125152, '\p{^Blk=-_mende_kikakui}', "");
    Expect(1, 125152, '\P{Blk=-_mende_kikakui}', "");
    Expect(0, 125152, '\P{^Blk=-_mende_kikakui}', "");
    Error('\p{Is_Block=:=_mende_kikakui}');
    Error('\P{Is_Block=:=_mende_kikakui}');
    Expect(1, 125151, '\p{Is_Block:   mendekikakui}', "");
    Expect(0, 125151, '\p{^Is_Block:   mendekikakui}', "");
    Expect(0, 125151, '\P{Is_Block:   mendekikakui}', "");
    Expect(1, 125151, '\P{^Is_Block:   mendekikakui}', "");
    Expect(0, 125152, '\p{Is_Block:   mendekikakui}', "");
    Expect(1, 125152, '\p{^Is_Block:   mendekikakui}', "");
    Expect(1, 125152, '\P{Is_Block:   mendekikakui}', "");
    Expect(0, 125152, '\P{^Is_Block:   mendekikakui}', "");
    Expect(1, 125151, '\p{Is_Block=_MENDE_kikakui}', "");
    Expect(0, 125151, '\p{^Is_Block=_MENDE_kikakui}', "");
    Expect(0, 125151, '\P{Is_Block=_MENDE_kikakui}', "");
    Expect(1, 125151, '\P{^Is_Block=_MENDE_kikakui}', "");
    Expect(0, 125152, '\p{Is_Block=_MENDE_kikakui}', "");
    Expect(1, 125152, '\p{^Is_Block=_MENDE_kikakui}', "");
    Expect(1, 125152, '\P{Is_Block=_MENDE_kikakui}', "");
    Expect(0, 125152, '\P{^Is_Block=_MENDE_kikakui}', "");
    Error('\p{Is_Blk=/a/mende_Kikakui}');
    Error('\P{Is_Blk=/a/mende_Kikakui}');
    Expect(1, 125151, '\p{Is_Blk=mendekikakui}', "");
    Expect(0, 125151, '\p{^Is_Blk=mendekikakui}', "");
    Expect(0, 125151, '\P{Is_Blk=mendekikakui}', "");
    Expect(1, 125151, '\P{^Is_Blk=mendekikakui}', "");
    Expect(0, 125152, '\p{Is_Blk=mendekikakui}', "");
    Expect(1, 125152, '\p{^Is_Blk=mendekikakui}', "");
    Expect(1, 125152, '\P{Is_Blk=mendekikakui}', "");
    Expect(0, 125152, '\P{^Is_Blk=mendekikakui}', "");
    Expect(1, 125151, '\p{Is_Blk=-Mende_kikakui}', "");
    Expect(0, 125151, '\p{^Is_Blk=-Mende_kikakui}', "");
    Expect(0, 125151, '\P{Is_Blk=-Mende_kikakui}', "");
    Expect(1, 125151, '\P{^Is_Blk=-Mende_kikakui}', "");
    Expect(0, 125152, '\p{Is_Blk=-Mende_kikakui}', "");
    Expect(1, 125152, '\p{^Is_Blk=-Mende_kikakui}', "");
    Expect(1, 125152, '\P{Is_Blk=-Mende_kikakui}', "");
    Expect(0, 125152, '\P{^Is_Blk=-Mende_kikakui}', "");
    Error('\p{Block:   -meroitic_Cursive:=}');
    Error('\P{Block:   -meroitic_Cursive:=}');
    Expect(1, 68095, '\p{Block=:\AMeroitic_Cursive\z:}', "");;
    Expect(0, 68096, '\p{Block=:\AMeroitic_Cursive\z:}', "");;
    Expect(1, 68095, '\p{Block=meroiticcursive}', "");
    Expect(0, 68095, '\p{^Block=meroiticcursive}', "");
    Expect(0, 68095, '\P{Block=meroiticcursive}', "");
    Expect(1, 68095, '\P{^Block=meroiticcursive}', "");
    Expect(0, 68096, '\p{Block=meroiticcursive}', "");
    Expect(1, 68096, '\p{^Block=meroiticcursive}', "");
    Expect(1, 68096, '\P{Block=meroiticcursive}', "");
    Expect(0, 68096, '\P{^Block=meroiticcursive}', "");
    Expect(1, 68095, '\p{Block=:\Ameroiticcursive\z:}', "");;
    Expect(0, 68096, '\p{Block=:\Ameroiticcursive\z:}', "");;
    Expect(1, 68095, '\p{Block=-_MEROITIC_CURSIVE}', "");
    Expect(0, 68095, '\p{^Block=-_MEROITIC_CURSIVE}', "");
    Expect(0, 68095, '\P{Block=-_MEROITIC_CURSIVE}', "");
    Expect(1, 68095, '\P{^Block=-_MEROITIC_CURSIVE}', "");
    Expect(0, 68096, '\p{Block=-_MEROITIC_CURSIVE}', "");
    Expect(1, 68096, '\p{^Block=-_MEROITIC_CURSIVE}', "");
    Expect(1, 68096, '\P{Block=-_MEROITIC_CURSIVE}', "");
    Expect(0, 68096, '\P{^Block=-_MEROITIC_CURSIVE}', "");
    Error('\p{Blk= -Meroitic_Cursive/a/}');
    Error('\P{Blk= -Meroitic_Cursive/a/}');
    Expect(1, 68095, '\p{Blk=:\AMeroitic_Cursive\z:}', "");;
    Expect(0, 68096, '\p{Blk=:\AMeroitic_Cursive\z:}', "");;
    Expect(1, 68095, '\p{Blk=meroiticcursive}', "");
    Expect(0, 68095, '\p{^Blk=meroiticcursive}', "");
    Expect(0, 68095, '\P{Blk=meroiticcursive}', "");
    Expect(1, 68095, '\P{^Blk=meroiticcursive}', "");
    Expect(0, 68096, '\p{Blk=meroiticcursive}', "");
    Expect(1, 68096, '\p{^Blk=meroiticcursive}', "");
    Expect(1, 68096, '\P{Blk=meroiticcursive}', "");
    Expect(0, 68096, '\P{