/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action.recurrence;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;
import tr.model.action.Action;
import tr.model.action.Recurrence;
import tr.view.action.recurrence.NewRecurrenceWizardPanel1;
import tr.view.action.recurrence.NewRecurrenceWizardPanel2;
import tr.view.action.recurrence.NewRecurrenceWizardPanel3;
import tr.view.action.recurrence.NewRecurrenceWizardPanel4;

public final class NewRecurrenceWizardIterator
implements WizardDescriptor.Iterator,
PropertyChangeListener {
    private final Recurrence recurrence;
    private final Action action;
    private int index;
    private WizardDescriptor.Panel[] currentPanels;
    private WizardDescriptor.Panel[] sequentPanels;
    private WizardDescriptor.Panel[] regularPanels;
    private Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public NewRecurrenceWizardIterator(Recurrence recurrence, Action action) {
        this.recurrence = recurrence;
        this.action = action;
        this.initPanels();
    }

    private void initPanels() {
        NewRecurrenceWizardPanel1 p1 = new NewRecurrenceWizardPanel1(this.recurrence);
        NewRecurrenceWizardPanel2 p2 = new NewRecurrenceWizardPanel2(this.recurrence);
        NewRecurrenceWizardPanel3 p3 = new NewRecurrenceWizardPanel3(this.recurrence);
        NewRecurrenceWizardPanel4 p4 = new NewRecurrenceWizardPanel4(this.recurrence, this.action);
        WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{p1, p2, p3, p4};
        int nSteps = 3;
        String[] steps = new String[nSteps];
        for (int i = 0; i < panels.length; ++i) {
            Component c = panels[i].getComponent();
            if (i < steps.length) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.addPropertyChangeListener(this);
            jc.putClientProperty("WizardPanel_contentSelectedIndex", Math.min(i, nSteps - 1));
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
        this.sequentPanels = new WizardDescriptor.Panel[]{p1, p2, p3};
        this.regularPanels = new WizardDescriptor.Panel[]{p1, p2, p4};
        this.currentPanels = this.regularPanels;
    }

    private WizardDescriptor.Panel[] getPanels() {
        return this.currentPanels;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". " + NbBundle.getMessage(NewRecurrenceWizardIterator.class, (String)"of") + " " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop.equals("type")) {
            String type = (String)evt.getNewValue();
            if (type.equals("subsequent")) {
                this.currentPanels = this.sequentPanels;
                this.fireChangeEvent();
            } else if (type.equals("regular")) {
                this.currentPanels = this.regularPanels;
                this.fireChangeEvent();
            }
        }
    }
}

