/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTable {
    public static final String PARENT_RESOURCE_TABLE = "ParentResourceTable";
    private ArrayList<WeakReference<PropertyChangeListener>> listeners = new ArrayList();
    private HashMap<String, ArrayList<WeakReference<PropertyChangeListener>>> propertyListeners = new HashMap();
    private HashMap<String, Object> properties = new HashMap();
    private ArrayList<WeakReference<ResourceTable>> childrenTables = new ArrayList();
    private ResourceTable parentTable = null;

    public ResourceTable(ResourceTable resourceTable) {
        this();
        this.parentTable = resourceTable;
        if (this.parentTable != null) {
            this.parentTable.addChild(this);
        }
    }

    public ResourceTable() {
    }

    public void setParentTable(ResourceTable resourceTable) {
        ResourceTable resourceTable2 = this.parentTable;
        this.parentTable = resourceTable;
        this.firePropertyChange(PARENT_RESOURCE_TABLE, resourceTable2, resourceTable);
    }

    public ResourceTable getParentTable() {
        return this.parentTable;
    }

    private void addChild(ResourceTable resourceTable) {
        this.childrenTables.add(new WeakReference<ResourceTable>(resourceTable));
    }

    private void removeChild(ResourceTable resourceTable) {
        this.childrenTables.remove(resourceTable);
    }

    public void removeParent() {
        this.parentTable.removeChild(this);
        this.parentTable = null;
    }

    public void clear() {
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            this.firePropertyChange(entry.getKey(), entry.getValue(), null);
        }
        this.properties.clear();
    }

    public Object getProperty(String string) {
        Object object = this.properties.get(string);
        if (object == null && this.parentTable != null) {
            object = this.parentTable.getProperty(string);
        }
        return object;
    }

    public void addProperty(String string, Object object) {
        Object object2 = this.properties.remove(string);
        if (object != null) {
            this.properties.put(string, object);
        }
        this.firePropertyChange(string, object2, object);
    }

    public Set<String> getLocalPropertyNames() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy propertyChangeListenerProxy = (PropertyChangeListenerProxy)propertyChangeListener;
            this.addPropertyChangeListener(propertyChangeListenerProxy.getPropertyName(), (PropertyChangeListener)propertyChangeListenerProxy.getListener());
        } else {
            this.listeners.add(new WeakReference<PropertyChangeListener>(propertyChangeListener));
        }
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        ArrayList<WeakReference<PropertyChangeListener>> arrayList = this.propertyListeners.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.propertyListeners.put(string, arrayList);
        }
        arrayList.add(new WeakReference<PropertyChangeListener>(propertyChangeListener));
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            WeakReference<PropertyChangeListener> weakReference = this.listeners.get(i);
            PropertyChangeListener propertyChangeListener2 = (PropertyChangeListener)weakReference.get();
            if (propertyChangeListener2 != null) {
                if (!propertyChangeListener2.equals(propertyChangeListener)) continue;
                this.listeners.remove(i);
                continue;
            }
            this.listeners.remove(i);
        }
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        ArrayList<WeakReference<PropertyChangeListener>> arrayList = this.propertyListeners.get(string);
        if (arrayList != null) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                WeakReference<PropertyChangeListener> weakReference = arrayList.get(i);
                PropertyChangeListener propertyChangeListener2 = (PropertyChangeListener)weakReference.get();
                if (propertyChangeListener2 != null) {
                    if (!propertyChangeListener2.equals(propertyChangeListener)) continue;
                    arrayList.remove(i);
                    continue;
                }
                arrayList.remove(i);
            }
        }
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        this.firePropertyChange(string, propertyChangeEvent);
    }

    private void firePropertyChange(String string, PropertyChangeEvent propertyChangeEvent) {
        this.fireEventAndCleanList(this.listeners, propertyChangeEvent);
        ArrayList<WeakReference<PropertyChangeListener>> arrayList = this.propertyListeners.get(string);
        if (arrayList != null) {
            this.fireEventAndCleanList(arrayList, propertyChangeEvent);
        }
        for (int i = this.childrenTables.size() - 1; i >= 0; --i) {
            WeakReference<ResourceTable> weakReference = this.childrenTables.get(i);
            if (weakReference.get() != null) {
                ((ResourceTable)weakReference.get()).notifyPropertyChanged(string, propertyChangeEvent);
                continue;
            }
            this.childrenTables.remove(i);
        }
    }

    private void fireParentChangedChange(ResourceTable resourceTable, ResourceTable resourceTable2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PARENT_RESOURCE_TABLE, resourceTable, resourceTable2);
        this.fireEventAndCleanList(this.listeners, propertyChangeEvent);
        for (String weakReference : this.propertyListeners.keySet()) {
            Object object;
            Object object2;
            if (this.properties.containsKey(weakReference) || (object2 = resourceTable.getProperty(weakReference)).equals(object = this.getProperty(weakReference))) continue;
            this.firePropertyChange(weakReference, object2, object);
        }
        for (int i = this.childrenTables.size() - 1; i >= 0; --i) {
            WeakReference<ResourceTable> weakReference = this.childrenTables.get(i);
            if (weakReference.get() != null) {
                ((ResourceTable)weakReference.get()).notifyPropertyChanged(PARENT_RESOURCE_TABLE, propertyChangeEvent);
                continue;
            }
            this.childrenTables.remove(i);
        }
    }

    private void fireEventAndCleanList(ArrayList<WeakReference<PropertyChangeListener>> arrayList, PropertyChangeEvent propertyChangeEvent) {
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            WeakReference<PropertyChangeListener> weakReference = arrayList.get(i);
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)weakReference.get();
            if (propertyChangeListener != null) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
                continue;
            }
            arrayList.remove(i);
        }
    }

    private void notifyPropertyChanged(String string, PropertyChangeEvent propertyChangeEvent) {
        if (!PARENT_RESOURCE_TABLE.equals(string) && !this.properties.containsKey(string)) {
            this.firePropertyChange(string, propertyChangeEvent);
        }
    }
}

