%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/horizontally-aligning-custom-dynamics-e.g.-sempre-pp,-piu-f,-subito-p.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it is automatically
%% generated from Documentation/snippets/new
%% Make any changes in Documentation/snippets/new/
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
%% Note: this file works from version 2.19.56
\version "2.19.56"

\header {
%% Translation of GIT committish: f11513f36c131dab18338d6a3a729e24a927150d
  texidocja = "
強弱記号の中には追加のテキストを伴うもの (例えば @qq{sempre pp}) があります。@c
強弱記号は通常音符の下に中央揃えされるため、\\pp の部分が音符に揃えられる@c
必要があります。

@qq{sempre pp} を水平方向に正しく揃えるためには、あたかも \\pp のみが@c
存在するかのように揃える必要があります。いくつかのアプローチがあります:

* 強弱記号が適用される音符の前に
@code{\\once\\override DynamicText.X-offset = #-9.2} を設定し、手動で@c
正しい位置にシフトします。欠点: この強弱記号を使用する際に毎回手動でシフトを@c
行う必要があります。

* カスタム強弱記号の定義にいくらかのパディング (@code{#:hspace 7.1}) を@c
追加して、それを中央揃えさせます。欠点: パディングは実際にスペースを占有する@c
ため、その位置に他のマークアップや強弱記号は配置されません。

* 強弱記号のスクリプトを @code{\\once\\override ... .X-offset = ..} で@c
シフトします。欠点: @code{\\once \\override} が毎回必要です!

* 追加されるテキストの寸法を (@code{#:with-dimensions '(0 . 0) '(0 . 0)}
を用いて) 0 にします。欠点: LilyPond にとっては @qq{sempre} のサイズが
0 になるため、他のオブジェクトと衝突する可能性があります (衝突判定が@c
行われないということです!)。また、いくつかのスペースは占有されている@c
ようであり、テキストが存在しない場合に比べて配置が多少ずれます。

* dynamic-script の Scheme 関数内で、直接明示的にシフトを設定します。

* dynamic-script の内部で明示的に揃え位置を設定します。デフォルトでは、@c
これは何の効果も現れませんが、X-offset を指定した際にのみ有効となります!
欠点: @code{DynamicText.X-offset} をセットする必要があり、@c
それは全ての強弱記号に影響します! また、揃え位置は pp の中央ではなく、@c
追加したテキストの右端となります。
"
  doctitleja = "カスタム強弱記号を水平方向に揃える (\"sempre pp\" \"piu f\" \"subito p\" など)"

%% Translation of GIT committish: 5a886a7c8348e53e52ce65f4d8e9e197db3d5103
  texidocfr = "
Certaines indications de nuance requièrent un complément textuel, comme
« sempre pp ».  Dans la mesure où les nuances sont habituellement
centrées sous la note, le @emph{pp} se trouvera repoussé loin après la
note à laquelle il s'applique.

Différentes approches permettent de correctement aligner horizontalement
ce « sempre pp » :

-- Un simple @code{\\once \\override DynamicText.X-offset = #-9.2}
   avant la note considérée de telle sorte que la nuance soit décalée
   manuellement à la bonne place.  Inconvénient : il faut le faire
   manuellement à chaque fois qu'intervient ce @emph{markup}.

-- L'intégration d'un rembourrage (@code{#:hspace 7.1}) à la définition
   de cette nuance personnalisée afin qu'une fois centrée par LilyPond
   elle soit correctement alignée.  Inconvénient : le rembourrage
   occupera exactement cet espace et ne permettra à aucun autre
   @emph{markup} ou nuance d'apparaître à cet endroit.

-- L'application d'un décalage au script de nuance
   @code{\\once \\override @dots{} X-offset = @dots{}}.
   Inconvénient : là aussi il faut le faire à chaque fois.

-- L'attribution arbitraire d'une dimension à 0 du texte additionnel à
   l'aide d'un @code{#:with-dimensions '(0 . 0) '(0 . 0)}.
   Inconvénient : LilyPond considère que « sempre » n'occupe pas
   d'espace, et donc pourra mettre à cet endroit d'autres éléments, ce
   qui pourrait générer des collisions qui ne seront pas détectées par
   les routines @emph{ad hoc}.  D'autre part, il semble persister un
   espacement, ce qui laisse l'impression d'un alignement différent en
   l'absence de texte additionnel.

-- L'ajout, explicite, du décalage directement dans la fonction Scheme
   du script de nuance.

-- La définition d'un alignement explicite au sein du script de nuance.
   Ceci ne sera suivi d'effet, par défaut, qu'en jouant sur
   @code{X-offset}.  Inconvénient : il faut définir
   @code{DynamicText.X-offset}, ce qui s'appliquera à toutes les
   nuances textuelles.  Par ailleurs, l'alignement sera réalisé sur le
   bord droit du texte additionnel, non sur le milieu de @emph{pp}.

"
  doctitlefr = "Alignement de nuances personnalisées comme « sempre pp », « più f » ou « subito p »"

%% Translation of GIT committish: 0c00cd98e81b27325bed5891b950fe7f0f0ebe5d
  texidoces = "
Algunas expresiones de matiz dinámico llevan texto adicional, como
\"sempre pp\".  Dado que los matices suelen ir centrados bajo la
nota, el \\pp se imprimiría mucho después de la nota a la que se
aplica el matiz.

Para alinear correctamente el \"sempre pp\" en sentido horizontal, de
manera que se alinee como si estuviese solamente el \\pp, hay varios
enfoques:

* Sencillamente usar @code{\\once\\override DynamicText.X-offset =
#-9.2} antes de la nota que lleva el matiz, para desplazarlo
manualmente a la posicion correcta.  Inconveniente: hay que hacerlo
manualmente cada vez que usamos esa indicación dinámica.

* Añadir algo de relleno (@code{#:hspace 7.1}) dentro de la definición
de nuestra indicación dinámica personalizada, de forma que despues de
que lilypond la ha centrado, ya esté alineada correctamente.
Inconveniente: el relleno realmente ocupa ese espacio y no permite que
se imprima ningún otro elemento de marcado o matiz dinámico en esa
posición.

* Desplazar la inscripción dinámica @code{\\once\\override ... .X-offset = ..}.
Inconveniente: ¡se necesita @code{\\once\\override} para cada una de las invocaciones!

* Fijar las dimensiones del texto adicional a cero (usando
@code{#:with-dimensions '(0 . 0) '(0 . 0)}).  Inconveniente: para
LilyPond \"sempre\" no tiene dimensiones, por lo que podría imprimir
otros elementos en su mismo lugar y producir colisiones (que no serían
advertidas por el mecanismo de detección de colisiones).  Asimismo,
aparentemente hay algún espacio, y por tanto no es exactamente la
misma alineación que sin el texto adicional.

* Añadir un desplazamiento explícito directamente dentro de la función
de Scheme que produce el elemento dynamic-script.

* Fijar una alineación explícita dentro del dynamic-script.  De forma
predeterminada, esto no tendría ningún efecto, a no ser que fijásemos
un valor para X-offset.  Inconveniente: tenemos que dar un valor a
@code{DynamicText.X-offset} ¡que se aplicaría a todos los textos de
dinámica!.  Asimismo, se alinea con el extremo derecho del texto
adicional, no con el centro del pp.

"
  doctitlees = "Alinear horizontalmente indicaciones dinámicas personalizadas (p.ej. \"sempre pp\"\"piu f\"\"subito p\")"

  lsrtags = "expressive-marks, tweaks-and-overrides, version-specific"

  texidoc = "
Some dynamic expressions involve additional text, like @qq{sempre pp}.
Since dynamics are usually centered under the note, the \\pp would be
displayed way after the note it applies to.

To correctly align the @qq{sempre pp} horizontally, so that it is
aligned as if it were only the \\pp, there are several approaches:

* Simply use @code{\\once\\override DynamicText.X-offset = #-9.2}
before the note with the dynamics to manually shift it to the correct
position. Drawback: This has to be done manually each time you use that
dynamic markup...

* Add some padding (@code{#:hspace 7.1}) into the definition of your
custom dynamic mark, so that after lilypond center-aligns it, it is
already correctly aligned. Drawback: The padding really takes up that
space and does not allow any other markup or dynamics to be shown in
that position.

* Shift the dynamic script @code{\\once\\override ... .X-offset = ..}.
Drawback: @code{\\once\\override} is needed for every invocation!

* Set the dimensions of the additional text to 0 (using
@code{#:with-dimensions '(0 . 0) '(0 . 0)}). Drawback: To LilyPond
@qq{sempre} has no extent, so it might put other stuff there and create
collisions (which are not detected by the collision detection!). Also,
there seems to be some spacing, so it's not exactly the same alignment
as without the additional text

* Add an explicit shifting directly inside the scheme function for the
dynamic-script.

* Set an explicit alignment inside the dynamic-script. By default, this
won't have any effect, only if one sets X-offset! Drawback: One needs
to set @code{DynamicText.X-offset}, which will apply to all dynamic
texts! Also, it is aligned at the right edge of the additional text,
not at the center of pp.




"
  doctitle = "Horizontally aligning custom dynamics (e.g. \"sempre pp\" \"piu f\" \"subito p\")"
} % begin verbatim


\paper {
  ragged-right = ##f
  indent = 2.5\cm
}

% Solution 1: Using a simple markup with a particular halign value
% Drawback: It's a markup, not a dynamic command, so \dynamicDown
%           etc. will have no effect
semppMarkup = \markup { \halign #1.4 \italic "sempre" \dynamic "pp" }

% Solution 2: Using a dynamic script & shifting with
%             \once \override ...X-offset = ..
% Drawback: \once \override needed for every invocation
semppK =
#(make-dynamic-script
  (markup #:line
          (#:normal-text
           #:italic "sempre"
           #:dynamic "pp")))

% Solution 3: Padding the dynamic script so the center-alignment
%             puts it at the correct position
% Drawback: the padding really reserves the space, nothing else can be there
semppT =
#(make-dynamic-script
  (markup #:line
          (#:normal-text
           #:italic "sempre"
           #:dynamic "pp"
           #:hspace 7.1)))

% Solution 4: Dynamic, setting the dimensions of the additional text to 0
% Drawback: To lilypond "sempre" has no extent, so it might put
%           other stuff there => collisions
% Drawback: Also, there seems to be some spacing, so it's not exactly the
%           same alignment as without the additional text
semppM =
#(make-dynamic-script
  (markup #:line
          (#:with-dimensions '(0 . 0) '(0 . 0)
                             #:right-align
                             #:normal-text
                             #:italic "sempre"
                             #:dynamic "pp")))

% Solution 5: Dynamic with explicit shifting inside the scheme function
semppG =
#(make-dynamic-script
  (markup #:hspace 0
          #:translate '(-18.85 . 0)
          #:line (#:normal-text
                  #:italic "sempre"
                  #:dynamic "pp")))

% Solution 6: Dynamic with explicit alignment. This has only effect
%             if one sets X-offset!
% Drawback: One needs to set DynamicText.X-offset!
% Drawback: Aligned at the right edge of the additional text,
%           not at the center of pp
semppMII =
#(make-dynamic-script
  (markup #:line (#:right-align
                  #:normal-text
                  #:italic "sempre"
                  #:dynamic "pp")))

\new StaffGroup <<
  \new Staff = "s" \with { instrumentName = \markup \column { Normal } }
  <<
    \relative c'' {
      \key es \major
      c4\pp c\p c c | c\ff c c\pp c
    }
  >>
  \new Staff = "sMarkup" \with {
    instrumentName = \markup \column { Normal markup }
  }
  <<
    \relative c'' {
      \key es \major
      c4-\semppMarkup c\p c c | c\ff c c-\semppMarkup c
    }
  >>
  \new Staff = "sK" \with {
    instrumentName = \markup \column { Explicit shifting }
  }
  <<
    \relative c'' {
      \key es \major
      \once \override DynamicText.X-offset = #-9.2
      c4\semppK c\p c c
      c4\ff c
      \once \override DynamicText.X-offset = #-9.2
      c4\semppK c
    }
  >>
  \new Staff = "sT" \with {
    instrumentName = \markup \column { Right padding }
  }
  <<
    \relative c'' {
      \key es \major
      c4\semppT c\p c c | c\ff c c\semppT c
    }
  >>
  \new Staff = "sM" \with {
    instrumentName = \markup \column { Set dimension "to zero" }
  }
  <<
    \relative c'' {
      \key es \major
      c4\semppM c\p c c | c\ff c c\semppM c
    }
  >>
  \new Staff = "sG" \with {
    instrumentName = \markup \column { Shift inside dynamics}
  }
  <<
    \relative c'' {
      \key es \major
      c4\semppG c\p c c | c\ff c c\semppG c
    }
  >>
  \new Staff = "sMII" \with {
    instrumentName = \markup \column { Alignment inside dynamics }
  }
  <<
    \relative c'' {
      \key es \major
      % Setting to ##f (false) gives the same result
      \override DynamicText.X-offset = #0
      c4\semppMII c\p c c | c\ff c c\semppMII c
    }
  >>
>>

\layout { \override Staff.InstrumentName.self-alignment-X = #LEFT }



% ****************************************************************
% end ly snippet
% ****************************************************************
