/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.fontchooser;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jhotdraw.gui.fontchooser.FontFamilyNode;

public class FontCollectionNode
implements MutableTreeNode,
Comparable<FontCollectionNode>,
Cloneable {
    private MutableTreeNode parent;
    private String name;
    private ArrayList<FontFamilyNode> children;
    private boolean isEditable;

    public FontCollectionNode(String string) {
        this.name = string;
        this.children = new ArrayList();
    }

    public FontCollectionNode(String string, ArrayList<FontFamilyNode> arrayList) {
        this.name = string;
        this.children = arrayList;
    }

    @Override
    public int compareTo(FontCollectionNode fontCollectionNode) {
        return Collator.getInstance().compare(this.name, fontCollectionNode.name);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public FontCollectionNode clone() {
        FontCollectionNode fontCollectionNode;
        try {
            fontCollectionNode = (FontCollectionNode)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            InternalError internalError = new InternalError("Clone failed");
            internalError.initCause(cloneNotSupportedException);
            throw internalError;
        }
        fontCollectionNode.parent = null;
        fontCollectionNode.children = new ArrayList();
        for (FontFamilyNode fontFamilyNode : this.children) {
            fontCollectionNode.insert(fontFamilyNode.clone(), fontCollectionNode.getChildCount());
        }
        return fontCollectionNode;
    }

    public void add(FontFamilyNode fontFamilyNode) {
        this.insert(fontFamilyNode, this.getChildCount());
    }

    public void addAll(Collection<FontFamilyNode> collection) {
        this.children.addAll(collection);
    }

    @Override
    public void insert(MutableTreeNode mutableTreeNode, int n) {
        FontCollectionNode fontCollectionNode = (FontCollectionNode)mutableTreeNode.getParent();
        if (fontCollectionNode != null) {
            fontCollectionNode.remove(mutableTreeNode);
        }
        mutableTreeNode.setParent(this);
        this.children.add(n, (FontFamilyNode)mutableTreeNode);
    }

    @Override
    public void remove(int n) {
        FontFamilyNode fontFamilyNode = this.getChildAt(n);
        this.children.remove(n);
        fontFamilyNode.setParent(null);
    }

    @Override
    public void remove(MutableTreeNode mutableTreeNode) {
        if (mutableTreeNode == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(mutableTreeNode)) {
            throw new IllegalArgumentException("argument is not a child");
        }
        this.remove(this.getIndex(mutableTreeNode));
    }

    @Override
    public void setUserObject(Object object) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    @Override
    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = mutableTreeNode;
    }

    @Override
    public FontFamilyNode getChildAt(int n) {
        return this.children.get(n);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public MutableTreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.children.indexOf(treeNode);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    public List<FontFamilyNode> families() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean isNodeChild(TreeNode treeNode) {
        boolean bl = treeNode == null ? false : (this.getChildCount() == 0 ? false : treeNode.getParent() == this);
        return bl;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean bl) {
        this.isEditable = bl;
    }
}

