%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/customized-drum-notation-in-printed-and-midi-output.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it is automatically
%% generated from LSR http://lsr.di.unimi.it
%% Make any changes in LSR itself, or in Documentation/snippets/new/ ,
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
\version "2.21.2"

\header {
%% Translation of GIT committish: a8a85e19654e46d725563e6deba44083ef137a2c
\version "2.18.0"

  texidocja = "
drum-pitch-names を独自の drum-style に合わせてカスタマイズし、それを
@code{\\layout} や @code{\\midi} で使用できるようにするには、@c
下のコードで示した手順に従ってください。簡潔に説明すると以下の通りです:

* 名前を定義する * 見た目を定義する * @code{\\layout} で使用できるようにする
* ピッチを割り当てる * @code{\\midi} で使用できるようにする
"
  doctitleja = "\\layout と \\midi で drumPitchNames, drumStyleTable, drumPitchTable をカスタマイズする"

%% Translation of GIT committish: 7a89226d5472a2548ec19228d8bccee1bd2480b4
  texidocfr = "
Des noms de « hauteurs » de batterie personnalisée peuvent s'utiliser à
la fois pour la sortie imprimable et le fichier MIDI généré. Ces
variables doivent être définies en tant que @code{drumPitchNames},
@code{drumStyleTable} et @code{midiDrumPitches}, comme indiqué
ci-dessous. En résumé, cet extrait

– définit quelques noms de « hauteur », @*
– définit comment ils seront rendus, @*
– indique à LilyPond de les utiliser pour la mise en forme, @*
– assigne les hauteurs aux noms, @*
– indique à LilyPond de les utiliser pour le rendu MIDI.

"
  doctitlefr = "Personnalisation de batterie pour les sorties imprimable et MIDI"

  lsrtags = "midi, percussion, specific-notation"

  texidoc = "
Customized drum @qq{pitch} names (suitable for a custom drum style, for
example) may be used both in printed and MIDI output by defining such
variables as @code{drumPitchNames}, @code{drumStyleTable} and
@code{midiDrumPitches}, as demonstrated here. In short, this snippet:

@itemize
@item
defines some \"pitch\" names
@item
defines how they will be rendered
@item
tell LilyPond to use them for layout
@item
assigns pitches to the names
@item
tell LilyPond to use them for MIDI output
@end itemize

"
  doctitle = "Customized drum notation in printed and MIDI output"
} % begin verbatim

%% This snippet tries to amend
%% NR 2.5.1 Common notation for percussion - Custom percussion staves
%% http://lilypond.org/doc/v2.18/Documentation/notation/common-notation-for-percussion#custom-percussion-staves

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%% To use custom drum-pitch-names for your score and midi you need to follow
%% this route:
%%
%%%%%%%%%%%%
%% LAYOUT:
%%%%%%%%%%%%
%%
%% (1) Define a name and put it in `drumPitchNames'
%%     This can be done at toplevel with
%%         drumPitchNames.my-name  = #'my-name
%%     It's possible to add an alias as well.
%% (2) Define how it should be printed
%%     Therefore put them into a toplevel-list, where each entry should look:
%%         (my-name
%%           note-head-style-or-default
%%             articulation-string-or-#f
%%               staff-position)
%%     Example:
%%         #(define my-style
%%           '(
%%             (my-name default "tenuto" -1)
%%             ; ...
%%             ))
%% (3) Tell LilyPond to use this custom-definitions, with
%%         drumStyleTable = #(alist->hash-table my-style)
%%     in a \layout or \with
%%
%%     Now we're done for layout, here a short, but complete example:
%%         \new DrumStaff
%%           \with { drumStyleTable = #(alist->hash-table my-style) }
%%           \drummode { my-name }
%%
%%%%%%%%%%%%
%% MIDI:
%%%%%%%%%%%%
%%
%% (1) Again at toplvel, assign a pitch to your custom-note-name
%%         midiDrumPitches.my-name = ges
%%     Note that you have to use the name, which is in drumPitchNames, no alias
%% (2) Tell LilyPond to use this pitch(es), with
%%         drumPitchTable = #(alist->hash-table midiDrumPitches)
%%
%%     Example:
%%         \score {
%%            \new DrumStaff
%%             \with {
%%               drumStyleTable = #(alist->hash-table my-style)
%%               drumPitchTable = #(alist->hash-table midiDrumPitches)
%%             }
%%             \drummode { my-name4 }
%%           \layout {}
%%           \midi {}
%%         }
%%
%%%%%%%%%%%%
%% TESTING
%%%%%%%%%%%%
%%
%% To test whether all is fine, run the following sequence in terminal:
%%         lilypond my-file.ly
%%         midi2ly my-file.midi
%%         gedit my-file-midi.ly
%%
%% Which will do:
%% 1. create pdf and midi
%% 2. transform the midi back to a .ly-file
%%    (note: midi2ly is not always good in correctly identifying enharmonic pitches)
%% 3. open this file in gedit (or use another editor)
%% Now watch what you've got.
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% FULL EXAMPLE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

drumPitchNames.dbass      = #'dbass
drumPitchNames.dba        = #'dbass  % 'db is in use already
drumPitchNames.dbassmute  = #'dbassmute
drumPitchNames.dbm        = #'dbassmute
drumPitchNames.do         = #'dopen
drumPitchNames.dopenmute  = #'dopenmute
drumPitchNames.dom        = #'dopenmute
drumPitchNames.dslap      = #'dslap
drumPitchNames.ds         = #'dslap
drumPitchNames.dslapmute  = #'dslapmute
drumPitchNames.dsm        = #'dslapmute

#(define djembe
  '((dbass      default  #f         -2)
    (dbassmute  default  "stopped"  -2)
    (dopen      default  #f          0)
    (dopenmute  default  "stopped"   0)
    (dslap      default  #f          2)
    (dslapmute  default  "stopped"   2)))

midiDrumPitches.dbass = g
midiDrumPitches.dbassmute = fis
midiDrumPitches.dopen =  a
midiDrumPitches.dopenmute = gis
midiDrumPitches.dslap =  b
midiDrumPitches.dslapmute = ais

one = \drummode { r4 dba4 do ds r dbm dom dsm }

\score {
   \new DrumStaff
    \with {
      \override StaffSymbol.line-count =  #3
      instrumentName = #"Djembe "
      drumStyleTable = #(alist->hash-table djembe)
      drumPitchTable = #(alist->hash-table midiDrumPitches)
    }
    \one
  \layout {}
  \midi {}
}



% ****************************************************************
% end ly snippet
% ****************************************************************
