/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.math.BigDecimal;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssUnitsCSS2;
import org.w3c.css.values.CssUnitsCSS21;
import org.w3c.css.values.CssUnitsCSS3;

public class CssFrequency
extends CssCheckableValue {
    public static final int type = 9;
    private BigDecimal value;
    protected String unit;
    protected BigDecimal factor = BigDecimal.ONE;
    private static BigDecimal defaultValue = BigDecimal.ZERO;

    @Override
    public final int getType() {
        return 9;
    }

    public CssFrequency() {
        this.value = defaultValue;
    }

    public CssFrequency(BigDecimal value) {
        this.value = value;
    }

    @Override
    public void set(String s, ApplContext ac) throws InvalidParamException {
        String low_s = s.toLowerCase();
        int length = low_s.length();
        int unitIdx = length - 1;
        char c = low_s.charAt(unitIdx);
        while (unitIdx > 0 && c <= 'z' && c >= 'a') {
            c = low_s.charAt(--unitIdx);
        }
        if (unitIdx == length - 1) {
            throw new InvalidParamException("unit", s, ac);
        }
        String unit_str = low_s.substring(++unitIdx, length);
        switch (ac.getCssVersion()) {
            case CSS2: {
                CssUnitsCSS2.parseFrequencyUnit(unit_str, this, ac);
                break;
            }
            case CSS21: {
                CssUnitsCSS21.parseFrequencyUnit(unit_str, this, ac);
                break;
            }
            case CSS3: {
                CssUnitsCSS3.parseFrequencyUnit(unit_str, this, ac);
                break;
            }
            default: {
                throw new InvalidParamException("unit", s, ac);
            }
        }
        try {
            this.value = new BigDecimal(low_s.substring(0, unitIdx));
        }
        catch (NumberFormatException nex) {
            throw new InvalidParamException("invalid-number", low_s.substring(0, unitIdx), ac);
        }
    }

    @Override
    public Object get() {
        return Float.valueOf(this.value.multiply(this.factor).floatValue());
    }

    public String getUnit() {
        return this.unit;
    }

    public String toString() {
        if (BigDecimal.ZERO.compareTo(this.value) == 0) {
            return BigDecimal.ZERO.toPlainString();
        }
        return this.value.toPlainString() + this.unit;
    }

    @Override
    public boolean equals(Object value) {
        return value instanceof CssFrequency && this.value.equals(((CssFrequency)value).value) && this.unit.equals(((CssFrequency)value).unit);
    }

    @Override
    public void setValue(BigDecimal v) {
        this.value = v;
    }

    @Override
    public boolean isPositive() {
        return this.value.signum() >= 0;
    }

    @Override
    public boolean isStrictlyPositive() {
        return this.value.signum() == 1;
    }

    @Override
    public boolean isZero() {
        return BigDecimal.ZERO.compareTo(this.value) == 0;
    }

    @Override
    public CssFrequency getFrequency() {
        return this;
    }

    @Override
    public void checkEqualsZero(ApplContext ac, String callername) throws InvalidParamException {
        this.checkEqualsZero(ac, new String[]{"frequency", this.toString(), callername});
    }

    @Override
    public boolean warnEqualsZero(ApplContext ac, String callername) {
        return this.warnEqualsZero(ac, new String[]{"frequency", callername});
    }
}

