/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonParser;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.google.firebase.FirebaseException;
import com.google.firebase.IncomingHttpResponse;
import com.google.firebase.internal.ApiClientUtils;
import com.google.firebase.internal.HttpErrorHandler;
import com.google.firebase.internal.HttpRequestInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public final class ErrorHandlingHttpClient<T extends FirebaseException> {
    private final HttpRequestFactory requestFactory;
    private final JsonFactory jsonFactory;
    private final HttpErrorHandler<T> errorHandler;
    private HttpResponseInterceptor interceptor;

    public ErrorHandlingHttpClient(HttpRequestFactory requestFactory, JsonFactory jsonFactory, HttpErrorHandler<T> errorHandler) {
        this.requestFactory = (HttpRequestFactory)Preconditions.checkNotNull((Object)requestFactory, (Object)"requestFactory must not be null");
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory, (Object)"jsonFactory must not be null");
        this.errorHandler = (HttpErrorHandler)Preconditions.checkNotNull(errorHandler, (Object)"errorHandler must not be null");
    }

    public ErrorHandlingHttpClient<T> setInterceptor(HttpResponseInterceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public <V> V sendAndParse(HttpRequestInfo requestInfo, Class<V> responseType) throws T {
        IncomingHttpResponse response = this.send(requestInfo);
        return this.parse(response, responseType);
    }

    public void sendAndParse(HttpRequestInfo requestInfo, Object destination) throws T {
        IncomingHttpResponse response = this.send(requestInfo);
        this.parse(response, destination);
    }

    public IncomingHttpResponse send(HttpRequestInfo requestInfo) throws T {
        HttpRequest request = this.createHttpRequest(requestInfo);
        HttpResponse response = null;
        try {
            response = request.execute();
            String content = null;
            InputStream stream = response.getContent();
            if (stream != null) {
                content = CharStreams.toString((Readable)new InputStreamReader(stream, response.getContentCharset()));
            }
            IncomingHttpResponse incomingHttpResponse = new IncomingHttpResponse(response, content);
            return incomingHttpResponse;
        }
        catch (HttpResponseException e) {
            throw this.errorHandler.handleHttpResponseException(e, new IncomingHttpResponse(e, request));
        }
        catch (IOException e) {
            throw this.errorHandler.handleIOException(e);
        }
        finally {
            ApiClientUtils.disconnectQuietly(response);
        }
    }

    public <V> V parse(IncomingHttpResponse response, Class<V> responseType) throws T {
        Preconditions.checkNotNull(responseType, (Object)"responseType must not be null");
        try {
            JsonParser parser = this.jsonFactory.createJsonParser(response.getContent());
            return (V)parser.parseAndClose(responseType);
        }
        catch (IOException e) {
            throw this.errorHandler.handleParseException(e, response);
        }
    }

    public void parse(IncomingHttpResponse response, Object destination) throws T {
        try {
            JsonParser parser = this.jsonFactory.createJsonParser(response.getContent());
            parser.parse(destination);
        }
        catch (IOException e) {
            throw this.errorHandler.handleParseException(e, response);
        }
    }

    private HttpRequest createHttpRequest(HttpRequestInfo requestInfo) throws T {
        try {
            return requestInfo.newHttpRequest(this.requestFactory, this.jsonFactory).setResponseInterceptor(this.interceptor);
        }
        catch (IOException e) {
            throw this.errorHandler.handleIOException(e);
        }
    }
}

