/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.config.Keys;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DataConverter;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class AtrackProtocolDecoder
extends BaseProtocolDecoder {
    private static final int MIN_DATA_LENGTH = 40;
    private boolean longDate;
    private boolean decimalFuel;
    private boolean custom;
    private String form;
    private ByteBuf photo;
    private final Map<Integer, String> alarmMap = new HashMap<Integer, String>();
    private static final Pattern PATTERN_INFO = new PatternBuilder().text("$INFO=").number("(d+),").expression("([^,]+),").expression("([^,]+),").number("d+,").number("d+,").number("d+,").number("(d+),").number("(d+),").number("(d+),").number("d+,").number("(d+),").number("d+,").number("d+").any().compile();
    private static final Pattern PATTERN = new PatternBuilder().number("(d+),").number("d+,").number("d+,").number("(-?d+),").number("(-?d+),").number("(d+),").number("(d+),").number("(d+.?d*),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("([^,]+)?,").number("(d+),").number("(d+),").expression("[^,]*,").expression("(.*)").optional(2).compile();

    public AtrackProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected void init() {
        String alarmMapString;
        this.longDate = this.getConfig().getBoolean(Keys.PROTOCOL_LONG_DATE.withPrefix(this.getProtocolName()));
        this.decimalFuel = this.getConfig().getBoolean(Keys.PROTOCOL_DECIMAL_FUEL.withPrefix(this.getProtocolName()));
        this.custom = this.getConfig().getBoolean(Keys.PROTOCOL_CUSTOM.withPrefix(this.getProtocolName()));
        this.form = this.getConfig().getString(Keys.PROTOCOL_FORM.withPrefix(this.getProtocolName()));
        if (this.form != null) {
            this.custom = true;
        }
        if ((alarmMapString = this.getConfig().getString(Keys.PROTOCOL_ALARM_MAP.withPrefix(this.getProtocolName()))) != null) {
            for (String pair : alarmMapString.split(",")) {
                if (pair.isEmpty()) continue;
                this.alarmMap.put(Integer.parseInt(pair.substring(0, pair.indexOf(61))), pair.substring(pair.indexOf(61) + 1));
            }
        }
    }

    public void setLongDate(boolean longDate) {
        this.longDate = longDate;
    }

    public void setCustom(boolean custom) {
        this.custom = custom;
    }

    public void setForm(String form) {
        this.form = form;
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, long rawId, int index) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer((int)12);
            response.writeShort(65026);
            response.writeLong(rawId);
            response.writeShort(index);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    private static String readString(ByteBuf buf) {
        String result = null;
        int index = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)0);
        if (index > buf.readerIndex()) {
            result = buf.readSlice(index - buf.readerIndex()).toString(StandardCharsets.US_ASCII);
        }
        buf.readByte();
        return result;
    }

    private void decodeBeaconData(Position position, int mode, int mask, ByteBuf data) {
        int i = 1;
        while (data.isReadable()) {
            if (BitUtil.check(mask, 7)) {
                position.set("tag" + i + "Id", ByteBufUtil.hexDump((ByteBuf)data.readSlice(6)));
            }
            switch (mode) {
                case 1: {
                    if (BitUtil.check(mask, 6)) {
                        data.readUnsignedShort();
                    }
                    if (BitUtil.check(mask, 5)) {
                        data.readUnsignedShort();
                    }
                    if (BitUtil.check(mask, 4)) {
                        data.readUnsignedByte();
                    }
                    if (!BitUtil.check(mask, 3)) break;
                    position.set("tag" + i + "Rssi", data.readUnsignedByte());
                    break;
                }
                case 2: {
                    if (BitUtil.check(mask, 6)) {
                        data.readUnsignedShort();
                    }
                    if (BitUtil.check(mask, 5)) {
                        position.set("tag" + i + "Temp", data.readUnsignedShort());
                    }
                    if (BitUtil.check(mask, 4)) {
                        data.readUnsignedByte();
                    }
                    if (!BitUtil.check(mask, 3)) break;
                    position.set("tag" + i + "Rssi", data.readUnsignedByte());
                    break;
                }
                case 3: {
                    if (BitUtil.check(mask, 6)) {
                        position.set("tag" + i + "Humidity", data.readUnsignedShort());
                    }
                    if (BitUtil.check(mask, 5)) {
                        position.set("tag" + i + "Temp", data.readUnsignedShort());
                    }
                    if (BitUtil.check(mask, 3)) {
                        position.set("tag" + i + "Rssi", data.readUnsignedByte());
                    }
                    if (!BitUtil.check(mask, 2)) break;
                    data.readUnsignedShort();
                    break;
                }
                case 4: {
                    if (BitUtil.check(mask, 6)) {
                        short hardwareId = data.readUnsignedByte();
                        if (BitUtil.check(mask, 5)) {
                            switch (hardwareId) {
                                case 1: 
                                case 4: {
                                    data.skipBytes(11);
                                    break;
                                }
                                case 2: {
                                    data.skipBytes(2);
                                    break;
                                }
                                case 3: {
                                    data.skipBytes(6);
                                    break;
                                }
                                case 5: {
                                    data.skipBytes(10);
                                    break;
                                }
                            }
                        }
                    }
                    if (!BitUtil.check(mask, 4)) break;
                    data.skipBytes(9);
                    break;
                }
            }
            ++i;
        }
    }

    private void readTextCustomData(Position position, String data, String form) {
        CellTower cellTower = new CellTower();
        String[] keys = form.substring(1).split("%");
        String[] values = data.split(",|\r\n");
        block58: for (int i = 0; i < Math.min(keys.length, values.length); ++i) {
            switch (keys[i]) {
                case "SA": {
                    position.set("sat", Integer.parseInt(values[i]));
                    continue block58;
                }
                case "MV": {
                    position.set("power", (double)Integer.parseInt(values[i]) * 0.1);
                    continue block58;
                }
                case "BV": {
                    position.set("battery", (double)Integer.parseInt(values[i]) * 0.1);
                    continue block58;
                }
                case "GQ": {
                    cellTower.setSignalStrength(Integer.parseInt(values[i]));
                    continue block58;
                }
                case "CE": {
                    cellTower.setCellId(Long.parseLong(values[i]));
                    continue block58;
                }
                case "LC": {
                    cellTower.setLocationAreaCode(Integer.parseInt(values[i]));
                    continue block58;
                }
                case "CN": {
                    if (values[i].length() <= 3) continue block58;
                    cellTower.setMobileCountryCode(Integer.parseInt(values[i].substring(0, 3)));
                    cellTower.setMobileNetworkCode(Integer.parseInt(values[i].substring(3)));
                    continue block58;
                }
                case "PC": {
                    position.set("count1", Integer.parseInt(values[i]));
                    continue block58;
                }
                case "AT": {
                    position.setAltitude(Integer.parseInt(values[i]));
                    continue block58;
                }
                case "RP": {
                    position.set("rpm", Integer.parseInt(values[i]));
                    continue block58;
                }
                case "GS": {
                    position.set("rssi", Integer.parseInt(values[i]));
                    continue block58;
                }
                case "DT": {
                    position.set("archive", Integer.parseInt(values[i]) == 1);
                    continue block58;
                }
                case "VN": {
                    position.set("vin", values[i]);
                    continue block58;
                }
                case "TR": {
                    position.set("throttle", Integer.parseInt(values[i]));
                    continue block58;
                }
                case "ET": {
                    position.set("coolantTemp", Integer.parseInt(values[i]));
                    continue block58;
                }
                case "FL": {
                    position.set("fuel", Integer.parseInt(values[i]));
                    continue block58;
                }
                case "FC": {
                    position.set("fuelConsumption", Integer.parseInt(values[i]));
                    continue block58;
                }
                case "AV1": {
                    position.set("adc1", Integer.parseInt(values[i]));
                    continue block58;
                }
                case "CD": {
                    position.set("iccid", values[i]);
                    continue block58;
                }
                case "EH": {
                    position.set("hours", UnitsConverter.msFromHours((double)Integer.parseInt(values[i]) * 0.1));
                    continue block58;
                }
                case "IA": {
                    position.set("intakeTemp", Integer.parseInt(values[i]));
                    continue block58;
                }
                case "EL": {
                    position.set("engineLoad", Integer.parseInt(values[i]));
                    continue block58;
                }
                case "HA": {
                    if (Integer.parseInt(values[i]) <= 0) continue block58;
                    position.set("alarm", "hardAcceleration");
                    continue block58;
                }
                case "HB": {
                    if (Integer.parseInt(values[i]) <= 0) continue block58;
                    position.set("alarm", "hardBraking");
                    continue block58;
                }
                case "HC": {
                    if (Integer.parseInt(values[i]) <= 0) continue block58;
                    position.set("alarm", "hardCornering");
                    continue block58;
                }
                case "MT": {
                    position.set("motion", Integer.parseInt(values[i]) > 0);
                    continue block58;
                }
                case "BC": {
                    String[] beaconValues = values[i].split(":");
                    this.decodeBeaconData(position, Integer.parseInt(beaconValues[0]), Integer.parseInt(beaconValues[1]), Unpooled.wrappedBuffer((byte[])DataConverter.parseHex(beaconValues[2])));
                    continue block58;
                }
            }
        }
        if (cellTower.getMobileCountryCode() != null && cellTower.getMobileNetworkCode() != null && cellTower.getCellId() != null && cellTower.getLocationAreaCode() != null) {
            position.setNetwork(new Network(cellTower));
        } else if (cellTower.getSignalStrength() != null) {
            position.set("rssi", cellTower.getSignalStrength());
        }
    }

    private void readBinaryCustomData(Position position, ByteBuf buf, String form) {
        String[] keys;
        CellTower cellTower = new CellTower();
        String[] stringArray = keys = form.substring(1).split("%");
        int n = stringArray.length;
        block74: for (int i = 0; i < n; ++i) {
            String key;
            switch (key = stringArray[i]) {
                case "SA": {
                    position.set("sat", buf.readUnsignedByte());
                    continue block74;
                }
                case "MV": {
                    position.set("power", (double)buf.readUnsignedShort() * 0.1);
                    continue block74;
                }
                case "BV": {
                    position.set("battery", (double)buf.readUnsignedShort() * 0.1);
                    continue block74;
                }
                case "GQ": {
                    cellTower.setSignalStrength(Integer.valueOf(buf.readUnsignedByte()));
                    continue block74;
                }
                case "CE": {
                    cellTower.setCellId(buf.readUnsignedInt());
                    continue block74;
                }
                case "LC": {
                    cellTower.setLocationAreaCode(buf.readUnsignedShort());
                    continue block74;
                }
                case "CN": {
                    int combinedMobileCodes = (int)(buf.readUnsignedInt() % 100000L);
                    cellTower.setMobileCountryCode(combinedMobileCodes / 100);
                    cellTower.setMobileNetworkCode(combinedMobileCodes % 100);
                    continue block74;
                }
                case "RL": {
                    buf.readUnsignedByte();
                    continue block74;
                }
                case "PC": {
                    position.set("count1", buf.readUnsignedInt());
                    continue block74;
                }
                case "AT": {
                    position.setAltitude(buf.readUnsignedInt());
                    continue block74;
                }
                case "RP": {
                    position.set("rpm", buf.readUnsignedShort());
                    continue block74;
                }
                case "GS": {
                    position.set("rssi", buf.readUnsignedByte());
                    continue block74;
                }
                case "DT": {
                    position.set("archive", buf.readUnsignedByte() == 1);
                    continue block74;
                }
                case "VN": {
                    position.set("vin", AtrackProtocolDecoder.readString(buf));
                    continue block74;
                }
                case "MF": {
                    buf.readUnsignedShort();
                    continue block74;
                }
                case "EL": {
                    buf.readUnsignedByte();
                    continue block74;
                }
                case "TR": {
                    position.set("throttle", buf.readUnsignedByte());
                    continue block74;
                }
                case "ET": {
                    position.set("temp1", buf.readUnsignedShort());
                    continue block74;
                }
                case "FL": {
                    position.set("fuel", buf.readUnsignedByte());
                    continue block74;
                }
                case "ML": {
                    buf.readUnsignedByte();
                    continue block74;
                }
                case "FC": {
                    position.set("fuelConsumption", buf.readUnsignedInt());
                    continue block74;
                }
                case "CI": {
                    AtrackProtocolDecoder.readString(buf);
                    continue block74;
                }
                case "AV1": {
                    position.set("adc1", buf.readUnsignedShort());
                    continue block74;
                }
                case "NC": {
                    AtrackProtocolDecoder.readString(buf);
                    continue block74;
                }
                case "SM": {
                    buf.readUnsignedShort();
                    continue block74;
                }
                case "GL": {
                    AtrackProtocolDecoder.readString(buf);
                    continue block74;
                }
                case "MA": {
                    AtrackProtocolDecoder.readString(buf);
                    continue block74;
                }
                case "PD": {
                    buf.readUnsignedByte();
                    continue block74;
                }
                case "CD": {
                    position.set("iccid", AtrackProtocolDecoder.readString(buf));
                    continue block74;
                }
                case "CM": {
                    buf.readLong();
                    continue block74;
                }
                case "GN": {
                    buf.skipBytes(60);
                    continue block74;
                }
                case "GV": {
                    buf.skipBytes(6);
                    continue block74;
                }
                case "ME": {
                    buf.readLong();
                    continue block74;
                }
                case "IA": {
                    buf.readUnsignedByte();
                    continue block74;
                }
                case "MP": {
                    buf.readUnsignedByte();
                    continue block74;
                }
            }
        }
        if (cellTower.getMobileCountryCode() != null && cellTower.getMobileNetworkCode() != null && cellTower.getCellId() != null && cellTower.getCellId() != 0L && cellTower.getLocationAreaCode() != null) {
            position.setNetwork(new Network(cellTower));
        } else if (cellTower.getSignalStrength() != null) {
            position.set("rssi", cellTower.getSignalStrength());
        }
    }

    private Position decodeInfo(Channel channel, SocketAddress remoteAddress, String sentence) {
        DeviceSession deviceSession;
        Position position = new Position(this.getProtocolName());
        this.getLastLocation(position, null);
        if (sentence.startsWith("$INFO")) {
            Parser parser = new Parser(PATTERN_INFO, sentence);
            if (!parser.matches()) {
                return null;
            }
            deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
            position.set("model", parser.next());
            position.set("versionFw", parser.next());
            position.set("power", (double)parser.nextInt().intValue() * 0.1);
            position.set("battery", (double)parser.nextInt().intValue() * 0.1);
            position.set("sat", parser.nextInt());
            position.set("rssi", parser.nextInt());
        } else {
            deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            position.set("result", sentence);
        }
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        return position;
    }

    private List<Position> decodeText(Channel channel, SocketAddress remoteAddress, String sentence) {
        String[] lines;
        int positionIndex = -1;
        for (int i = 0; i < 5; ++i) {
            positionIndex = sentence.indexOf(44, positionIndex + 1);
        }
        String[] headers = sentence.substring(0, positionIndex).split(",");
        long id = Long.parseLong(headers[2]);
        int index = Integer.parseInt(headers[3]);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, headers[4]);
        if (deviceSession == null) {
            return null;
        }
        this.sendResponse(channel, remoteAddress, id, index);
        LinkedList<Position> positions = new LinkedList<Position>();
        for (String line : lines = sentence.substring(positionIndex + 1).split("\r\n")) {
            Position position = this.decodeTextLine(deviceSession, line);
            if (position == null) continue;
            positions.add(position);
        }
        return positions;
    }

    private Position decodeTextLine(DeviceSession deviceSession, String sentence) {
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setValid(true);
        String time = parser.next();
        if (time.length() >= 14) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                position.setTime(dateFormat.parse(time));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        } else {
            position.setTime(new Date(Long.parseLong(time) * 1000L));
        }
        position.setLongitude((double)parser.nextInt().intValue() * 1.0E-6);
        position.setLatitude((double)parser.nextInt().intValue() * 1.0E-6);
        position.setCourse(parser.nextInt().intValue());
        position.set("event", parser.nextInt());
        position.set("odometer", parser.nextDouble() * 100.0);
        position.set("hdop", (double)parser.nextInt().intValue() * 0.1);
        position.set("input", parser.nextInt());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt().intValue()));
        position.set("output", parser.nextInt());
        position.set("adc1", parser.nextInt());
        if (parser.hasNext()) {
            position.set("driverUniqueId", parser.next());
        }
        position.set("temp1", parser.nextInt());
        position.set("temp2", parser.nextInt());
        if (this.custom) {
            String data = parser.next();
            String form = this.form;
            if (form == null) {
                form = data.substring(0, data.indexOf(44)).substring("%CI".length());
                data = data.substring(data.indexOf(44) + 1);
            }
            this.readTextCustomData(position, data, form);
        }
        return position;
    }

    private Position decodePhoto(DeviceSession deviceSession, ByteBuf buf, long id) {
        long time = buf.readUnsignedInt();
        short index = buf.readUnsignedByte();
        short count = buf.readUnsignedByte();
        if (this.photo == null) {
            this.photo = Unpooled.buffer();
        }
        this.photo.writeBytes(buf.readSlice(buf.readUnsignedShort()));
        if (index == count - 1) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, new Date(time * 1000L));
            position.set("image", this.writeMediaFile(String.valueOf(id), this.photo, "jpg"));
            this.photo.release();
            this.photo = null;
            return position;
        }
        return null;
    }

    private List<Position> decodeBinary(DeviceSession deviceSession, ByteBuf buf) {
        LinkedList<Position> positions = new LinkedList<Position>();
        while (buf.readableBytes() >= 40) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            if (this.longDate) {
                DateBuilder dateBuilder = new DateBuilder().setDate(buf.readUnsignedShort(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
                position.setTime(dateBuilder.getDate());
                buf.skipBytes(14);
            } else {
                position.setFixTime(new Date(buf.readUnsignedInt() * 1000L));
                position.setDeviceTime(new Date(buf.readUnsignedInt() * 1000L));
                buf.readUnsignedInt();
            }
            position.setValid(true);
            position.setLongitude((double)buf.readInt() * 1.0E-6);
            position.setLatitude((double)buf.readInt() * 1.0E-6);
            position.setCourse(buf.readUnsignedShort());
            short type = buf.readUnsignedByte();
            position.set("type", Integer.valueOf(type));
            position.set("alarm", this.alarmMap.get(type));
            position.set("odometer", buf.readUnsignedInt() * 100L);
            position.set("hdop", (double)buf.readUnsignedShort() * 0.1);
            position.set("input", buf.readUnsignedByte());
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShort()));
            position.set("output", buf.readUnsignedByte());
            position.set("adc1", (double)buf.readUnsignedShort() * 0.001);
            position.set("driverUniqueId", AtrackProtocolDecoder.readString(buf));
            position.set("temp1", (double)buf.readShort() * 0.1);
            position.set("temp2", (double)buf.readShort() * 0.1);
            String message = AtrackProtocolDecoder.readString(buf);
            if (message != null && !message.isEmpty()) {
                Pattern pattern = Pattern.compile("FULS:F=(\\p{XDigit}+) t=(\\p{XDigit}+) N=(\\p{XDigit}+)");
                Matcher matcher = pattern.matcher(message);
                if (matcher.find()) {
                    int value = Integer.parseInt(matcher.group(3), this.decimalFuel ? 10 : 16);
                    position.set("fuel", (double)value * 0.1);
                } else {
                    position.set("message", message);
                }
            }
            if (this.custom) {
                String form = this.form;
                if (form == null) {
                    form = AtrackProtocolDecoder.readString(buf).trim().substring("%CI".length());
                }
                this.readBinaryCustomData(position, buf, form);
            }
            positions.add(position);
        }
        return positions;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        if (buf.getUnsignedShort(buf.readerIndex()) == 65026) {
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage(buf.retain(), remoteAddress));
            }
            return null;
        }
        if (buf.getByte(buf.readerIndex()) == 36) {
            return this.decodeInfo(channel, remoteAddress, buf.toString(StandardCharsets.US_ASCII).trim());
        }
        if (buf.getByte(buf.readerIndex() + 2) == 44) {
            return this.decodeText(channel, remoteAddress, buf.toString(StandardCharsets.US_ASCII).trim());
        }
        String prefix = buf.readCharSequence(2, StandardCharsets.US_ASCII).toString();
        buf.readUnsignedShort();
        buf.readUnsignedShort();
        int index = buf.readUnsignedShort();
        long id = buf.readLong();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, String.valueOf(id));
        if (deviceSession == null) {
            return null;
        }
        this.sendResponse(channel, remoteAddress, id, index);
        if (prefix.equals("@R")) {
            return this.decodePhoto(deviceSession, buf, id);
        }
        return this.decodeBinary(deviceSession, buf);
    }
}

