/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jparsec.EmptyParseError;
import org.jparsec.ParseTree;
import org.jparsec.Parser;
import org.jparsec.SourceLocator;
import org.jparsec.Token;
import org.jparsec.TreeNode;
import org.jparsec.error.ParseErrorDetails;
import org.jparsec.internal.annotations.Private;
import org.jparsec.internal.util.Checks;
import org.jparsec.internal.util.Lists;

abstract class ParseContext {
    static final String EOF = "EOF";
    final String module;
    final CharSequence source;
    final SourceLocator locator;
    int at;
    int step;
    Object result;
    private ParserTrace trace = new ParserTrace(){

        @Override
        public void push(String name) {
        }

        @Override
        public void pop() {
        }

        @Override
        public TreeNode getCurrentNode() {
            return null;
        }

        @Override
        public void setCurrentResult(Object result) {
        }

        @Override
        public TreeNode getLatestChild() {
            return null;
        }

        @Override
        public void setLatestChild(TreeNode node) {
        }

        @Override
        public void startFresh(ParseContext context) {
        }

        @Override
        public void setStateAs(ParserTrace that) {
        }
    };
    private ErrorType currentErrorType = ErrorType.NONE;
    private int currentErrorAt;
    private int currentErrorIndex = 0;
    private final ArrayList<Object> errors = Lists.arrayList(32);
    private String encountered = null;
    private TreeNode currentErrorNode = null;
    private boolean errorSuppressed = false;
    private ErrorType overrideErrorType = ErrorType.NONE;

    ParseContext(CharSequence source, int at, String module, SourceLocator locator) {
        this(source, null, at, module, locator);
    }

    ParseContext(CharSequence source, Object ret, int at, String module, SourceLocator locator) {
        this.source = source;
        this.result = ret;
        this.step = 0;
        this.at = at;
        this.module = module;
        this.locator = locator;
        this.currentErrorAt = at;
    }

    final boolean withErrorSuppressed(Parser<?> parser) {
        boolean oldValue = this.errorSuppressed;
        this.errorSuppressed = true;
        boolean ok = parser.apply(this);
        this.errorSuppressed = oldValue;
        return ok;
    }

    final boolean applyAsDelimiter(Parser<?> parser) {
        ErrorType oldValue = this.overrideErrorType;
        this.overrideErrorType = ErrorType.DELIMITING;
        int oldStep = this.step;
        boolean ok = parser.apply(this);
        if (ok) {
            this.step = oldStep;
        }
        this.overrideErrorType = oldValue;
        return ok;
    }

    final boolean applyNewNode(Parser<?> parser, String name) {
        int physical = this.at;
        int logical = this.step;
        TreeNode latestChild = this.trace.getLatestChild();
        this.trace.push(name);
        if (parser.apply(this)) {
            this.trace.setCurrentResult(this.result);
            this.trace.pop();
            return true;
        }
        if (this.stillThere(physical, logical)) {
            this.expected(name);
        }
        this.trace.pop();
        this.trace.setLatestChild(latestChild);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean applyNested(Parser<?> parser, ParseContext nestedState) {
        try {
            if (parser.apply(nestedState)) {
                this.set(nestedState.step, this.at, nestedState.result);
                boolean bl = true;
                return bl;
            }
            this.set(this.step, nestedState.getIndex(), null);
            this.copyErrorFrom(nestedState);
            boolean bl = false;
            return bl;
        }
        finally {
            this.trace.setStateAs(nestedState.trace);
        }
    }

    final boolean repeat(Parser<?> parser, int n) {
        for (int i = 0; i < n; ++i) {
            if (parser.apply(this)) continue;
            return false;
        }
        return true;
    }

    final <T> boolean repeat(Parser<? extends T> parser, int n, Collection<T> collection) {
        for (int i = 0; i < n; ++i) {
            if (!parser.apply(this)) {
                return false;
            }
            collection.add(parser.getReturn(this));
        }
        return true;
    }

    final ParserTrace getTrace() {
        return this.trace;
    }

    final int errorIndex() {
        return this.currentErrorIndex;
    }

    final ParseTree buildParseTree() {
        TreeNode currentNode = this.trace.getCurrentNode();
        if (currentNode == null) {
            return null;
        }
        return currentNode.freeze(this.getIndex()).toParseTree();
    }

    final ParseTree buildErrorParseTree() {
        if (this.currentErrorNode == null) {
            return null;
        }
        return this.currentErrorNode.orphanize().freeze(this.getIndex()).toParseTree();
    }

    final ParseErrorDetails renderError() {
        int errorIndex = this.toIndex(this.currentErrorAt);
        String encounteredName = this.getEncountered();
        final ArrayList errorStrings = Lists.arrayList(this.errors.size());
        for (Object error : this.errors) {
            errorStrings.add(String.valueOf(error));
        }
        switch (this.currentErrorType) {
            case UNEXPECTED: {
                return new EmptyParseError(errorIndex, encounteredName){

                    @Override
                    public String getUnexpected() {
                        return (String)errorStrings.get(0);
                    }
                };
            }
            case FAILURE: {
                return new EmptyParseError(errorIndex, encounteredName){

                    @Override
                    public String getFailureMessage() {
                        return (String)errorStrings.get(0);
                    }
                };
            }
            case EXPECTING: 
            case MISSING: 
            case DELIMITING: {
                return new EmptyParseError(errorIndex, encounteredName){

                    @Override
                    public List<String> getExpected() {
                        return errorStrings;
                    }
                };
            }
        }
        return new EmptyParseError(errorIndex, encounteredName);
    }

    private String getEncountered() {
        if (this.encountered != null) {
            return this.encountered;
        }
        return this.getInputName(this.currentErrorAt);
    }

    abstract String getInputName(int var1);

    abstract boolean isEof();

    final int getIndex() {
        return this.toIndex(this.at);
    }

    abstract Token getToken();

    abstract char peekChar();

    abstract int toIndex(int var1);

    @Private
    final void raise(ErrorType type, Object subject) {
        if (this.errorSuppressed) {
            return;
        }
        if (this.at < this.currentErrorAt) {
            return;
        }
        if (this.overrideErrorType != ErrorType.NONE) {
            type = this.overrideErrorType;
        }
        if (this.at > this.currentErrorAt) {
            this.setErrorState(this.at, this.getIndex(), type);
            this.errors.add(subject);
            return;
        }
        if (type.ordinal() < this.currentErrorType.ordinal()) {
            return;
        }
        if (type.ordinal() > this.currentErrorType.ordinal()) {
            this.setErrorState(this.at, this.getIndex(), type);
            this.errors.add(subject);
            return;
        }
        if (type.mergeable) {
            this.errors.add(subject);
        }
    }

    final void fail(String message) {
        this.raise(ErrorType.FAILURE, message);
    }

    final void missing(Object what) {
        this.raise(ErrorType.MISSING, what);
    }

    final void expected(Object what) {
        this.raise(ErrorType.EXPECTING, what);
    }

    final void unexpected(String what) {
        this.raise(ErrorType.UNEXPECTED, what);
    }

    final boolean stillThere(int wasAt, int originalStep) {
        if (this.step == originalStep) {
            this.setAt(originalStep, wasAt);
            return true;
        }
        return false;
    }

    final void set(int step, int at, Object ret) {
        this.step = step;
        this.at = at;
        this.result = ret;
    }

    final void setAt(int step, int at) {
        this.step = step;
        this.at = at;
    }

    final void next() {
        ++this.at;
        ++this.step;
    }

    final void next(int n) {
        this.at += n;
        if (n > 0) {
            ++this.step;
        }
    }

    final void enableTrace(final String rootName) {
        this.trace = new ParserTrace(){
            private TreeNode current;
            {
                this.current = new TreeNode(rootName, ParseContext.this.getIndex());
            }

            @Override
            public void push(String name) {
                this.current = this.current.addChild(name, ParseContext.this.getIndex());
            }

            @Override
            public void pop() {
                this.current.setEndIndex(ParseContext.this.getIndex());
                this.current = this.current.parent();
            }

            @Override
            public TreeNode getCurrentNode() {
                return this.current;
            }

            @Override
            public void setCurrentResult(Object result) {
                this.current.setResult(result);
            }

            @Override
            public TreeNode getLatestChild() {
                return this.current.latestChild;
            }

            @Override
            public void setLatestChild(TreeNode latest) {
                Checks.checkState(latest == null || latest.parent() == this.current, "Trying to set a child node not owned by the parent node");
                this.current.latestChild = latest;
            }

            @Override
            public void startFresh(ParseContext context) {
                context.enableTrace(rootName);
            }

            @Override
            public void setStateAs(ParserTrace that) {
                this.current = that.getCurrentNode();
            }
        };
    }

    private void setErrorState(int errorAt, int errorIndex, ErrorType errorType, List<Object> errors) {
        this.setErrorState(errorAt, errorIndex, errorType);
        this.errors.addAll(errors);
    }

    private void setErrorState(int errorAt, int errorIndex, ErrorType errorType) {
        this.currentErrorIndex = errorIndex;
        this.currentErrorAt = errorAt;
        this.currentErrorType = errorType;
        this.currentErrorNode = this.trace.getCurrentNode();
        this.encountered = null;
        this.errors.clear();
    }

    private void copyErrorFrom(ParseContext that) {
        int errorIndex = that.errorIndex();
        this.setErrorState(errorIndex, errorIndex, that.currentErrorType, that.errors);
        if (!that.isEof()) {
            this.encountered = that.getEncountered();
        }
        this.currentErrorNode = that.currentErrorNode;
    }

    abstract CharSequence characters();

    public String toString() {
        return this.source.subSequence(this.getIndex(), this.source.length()).toString();
    }

    static interface ParserTrace {
        public void push(String var1);

        public void pop();

        public TreeNode getCurrentNode();

        public void setCurrentResult(Object var1);

        public TreeNode getLatestChild();

        public void setLatestChild(TreeNode var1);

        public void startFresh(ParseContext var1);

        public void setStateAs(ParserTrace var1);
    }

    static enum ErrorType {
        NONE(false),
        DELIMITING(false),
        UNEXPECTED(false),
        MISSING(true),
        EXPECTING(true),
        FAILURE(false);

        final boolean mergeable;

        private ErrorType(boolean mergeable) {
            this.mergeable = mergeable;
        }
    }
}

