/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.modifiablevariable.util.BadRandom;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.crypto.KeyGenerator;
import de.rub.nds.tlsattacker.core.crypto.MD5Utils;
import de.rub.nds.tlsattacker.core.crypto.SHA1Utils;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jcajce.provider.asymmetric.ecgost.BCECGOST3410PrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ecgost12.BCECGOST3410_2012PrivateKey;

public class SignatureCalculator {
    private static final Logger LOGGER = LogManager.getLogger();

    public static byte[] generateSignature(SignatureAndHashAlgorithm algorithm, Chooser chooser, byte[] toBeSigned) throws CryptoException {
        switch (algorithm.getSignatureAlgorithm()) {
            case ANONYMOUS: {
                return SignatureCalculator.generateAnonymousSignature(chooser, toBeSigned, algorithm);
            }
            case DSA: {
                return SignatureCalculator.generateDSASignature(chooser, toBeSigned, algorithm);
            }
            case ECDSA: {
                return SignatureCalculator.generateECDSASignature(chooser, toBeSigned, algorithm);
            }
            case RSA: 
            case RSA_PSS_PSS: 
            case RSA_PSS_RSAE: {
                return SignatureCalculator.generateRSASignature(chooser, toBeSigned, algorithm);
            }
            case GOSTR34102001: {
                return SignatureCalculator.generateGost01Signature(chooser, toBeSigned, algorithm);
            }
            case GOSTR34102012_256: 
            case GOSTR34102012_512: {
                return SignatureCalculator.generateGost12Signature(chooser, toBeSigned, algorithm);
            }
        }
        throw new UnsupportedOperationException("Unknown SignatureAlgorithm:" + algorithm.getSignatureAlgorithm().name());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] generateSignature(PrivateKey key, byte[] toBeSigned, SignatureAndHashAlgorithm algorithm, BadRandom random, Chooser chooser) throws CryptoException {
        String algoName;
        if (chooser.getSelectedProtocolVersion() == ProtocolVersion.SSL3 || chooser.getSelectedProtocolVersion() == ProtocolVersion.TLS10 || chooser.getSelectedProtocolVersion() == ProtocolVersion.TLS11 || chooser.getSelectedProtocolVersion() == ProtocolVersion.DTLS10) {
            if (AlgorithmResolver.getKeyExchangeAlgorithm(chooser.getSelectedCipherSuite()).name().contains("RSA")) {
                algoName = "NONEwithRSA";
                toBeSigned = ArrayConverter.concatenate((byte[][])new byte[][]{MD5Utils.MD5(new byte[][]{toBeSigned}), SHA1Utils.sha1(new byte[][]{toBeSigned})});
            } else if (AlgorithmResolver.getKeyExchangeAlgorithm(chooser.getSelectedCipherSuite()).name().contains("ECDSA")) {
                algoName = "SHA1withECDSA";
            } else {
                if (!AlgorithmResolver.getKeyExchangeAlgorithm(chooser.getSelectedCipherSuite()).name().contains("DSS")) throw new UnsupportedOperationException("Ciphersuite not supported - Check Debug Log");
                algoName = "SHA1withDSA";
            }
        } else {
            algoName = algorithm.getJavaName();
        }
        try {
            LOGGER.trace("Creating Signature with " + algoName + " over " + ArrayConverter.bytesToHexString((byte[])toBeSigned) + " with the PrivateKey:" + key.toString());
            Signature instance = Signature.getInstance(algoName);
            algorithm.setupSignature(instance);
            instance.initSign(key, (SecureRandom)random);
            instance.update(toBeSigned);
            return instance.sign();
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            throw new CryptoException("Could not sign Data", ex);
        }
    }

    public static byte[] generateRSASignature(Chooser chooser, byte[] toBeSigned, SignatureAndHashAlgorithm algorithm) throws CryptoException {
        RSAPrivateKey key = KeyGenerator.getRSAPrivateKey(chooser);
        return SignatureCalculator.generateSignature(key, toBeSigned, algorithm, chooser.getContext().getBadSecureRandom(), chooser);
    }

    public static byte[] generateDSASignature(Chooser chooser, byte[] toBeSigned, SignatureAndHashAlgorithm algorithm) throws CryptoException {
        DSAPrivateKey key = KeyGenerator.getDSAPrivateKey(chooser);
        return SignatureCalculator.generateSignature(key, toBeSigned, algorithm, chooser.getContext().getBadSecureRandom(), chooser);
    }

    public static byte[] generateECDSASignature(Chooser chooser, byte[] toBeSigned, SignatureAndHashAlgorithm algorithm) throws CryptoException {
        ECPrivateKey key = KeyGenerator.getECPrivateKey(chooser);
        return SignatureCalculator.generateSignature(key, toBeSigned, algorithm, chooser.getContext().getBadSecureRandom(), chooser);
    }

    public static byte[] generateAnonymousSignature(Chooser chooser, byte[] toBeSigned, SignatureAndHashAlgorithm algorithm) {
        return new byte[0];
    }

    private static byte[] generateGost01Signature(Chooser chooser, byte[] toBeSigned, SignatureAndHashAlgorithm algorithm) throws CryptoException {
        BCECGOST3410PrivateKey privateKey = KeyGenerator.getGost01PrivateKey(chooser);
        return SignatureCalculator.generateSignature((PrivateKey)privateKey, toBeSigned, algorithm, chooser.getContext().getBadSecureRandom(), chooser);
    }

    private static byte[] generateGost12Signature(Chooser chooser, byte[] toBeSigned, SignatureAndHashAlgorithm algorithm) throws CryptoException {
        BCECGOST3410_2012PrivateKey privateKey = KeyGenerator.getGost12PrivateKey(chooser);
        return SignatureCalculator.generateSignature((PrivateKey)privateKey, toBeSigned, algorithm, chooser.getContext().getBadSecureRandom(), chooser);
    }

    private SignatureCalculator() {
    }
}

