/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.preferences;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.core.startup.preferences.PropertiesStorage;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;

public abstract class NbPreferences
extends AbstractPreferences {
    private static Preferences USER_ROOT;
    private static Preferences SYSTEM_ROOT;
    Properties properties;
    FileStorage fileStorage;
    private static final RequestProcessor RP;
    final RequestProcessor.Task flushTask = RP.create(new Runnable(){

        public void run() {
            NbPreferences.this.fileStorage.runAtomic(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = NbPreferences.this.lock;
                    synchronized (object) {
                        try {
                            NbPreferences.this.flushSpi();
                        }
                        catch (BackingStoreException backingStoreException) {
                            ErrorManager.getDefault().notify((Throwable)backingStoreException);
                        }
                    }
                }
            });
        }
    }, true);

    static Preferences userRootImpl() {
        if (USER_ROOT == null) {
            USER_ROOT = new UserPreferences();
        }
        assert (USER_ROOT != null);
        return USER_ROOT;
    }

    static Preferences systemRootImpl() {
        if (SYSTEM_ROOT == null) {
            SYSTEM_ROOT = new SystemPreferences();
        }
        assert (SYSTEM_ROOT != null);
        return SYSTEM_ROOT;
    }

    private NbPreferences(boolean bl) {
        super(null, "");
        this.fileStorage = this.getFileStorage(this.absolutePath());
    }

    private NbPreferences(NbPreferences nbPreferences, String string) {
        super(nbPreferences, string);
        this.fileStorage = this.getFileStorage(this.absolutePath());
        this.newNode = !this.fileStorage.existsNode();
    }

    protected final String getSpi(String string) {
        return this.properties().getProperty(string);
    }

    protected final String[] childrenNamesSpi() throws BackingStoreException {
        return this.fileStorage.childrenNames();
    }

    protected final String[] keysSpi() throws BackingStoreException {
        return this.properties().keySet().toArray(new String[0]);
    }

    protected final void putSpi(String string, String string2) {
        this.properties().put(string, string2);
        this.fileStorage.markModified();
        this.asyncInvocationOfFlushSpi();
    }

    public void put(String string, String string2) {
        String string3 = this.getSpi(string);
        if (string2.equals(string3)) {
            return;
        }
        try {
            super.put(string, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage().contains("too long")) {
                this.putSpi(string, string2);
            }
            throw illegalArgumentException;
        }
    }

    protected final void removeSpi(String string) {
        this.properties().remove(string);
        this.fileStorage.markModified();
        this.asyncInvocationOfFlushSpi();
    }

    protected final void removeNodeSpi() throws BackingStoreException {
        try {
            this.fileStorage.removeNode();
        }
        catch (IOException iOException) {
            throw new BackingStoreException(iOException);
        }
    }

    void asyncInvocationOfFlushSpi() {
        if (!this.fileStorage.isReadOnly()) {
            this.flushTask.schedule(200);
        }
    }

    protected void flushSpi() throws BackingStoreException {
        try {
            this.fileStorage.save(this.properties());
        }
        catch (IOException iOException) {
            throw new BackingStoreException(iOException);
        }
    }

    protected void syncSpi() throws BackingStoreException {
        if (this.properties != null) {
            try {
                this.properties.clear();
                this.properties().putAll((Map<?, ?>)this.fileStorage.load());
            }
            catch (IOException iOException) {
                throw new BackingStoreException(iOException);
            }
        }
    }

    Properties properties() {
        if (this.properties == null) {
            this.properties = new Properties();
            try {
                this.properties().putAll((Map<?, ?>)this.fileStorage.load());
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        return this.properties;
    }

    public final void removeNode() throws BackingStoreException {
        if (this.fileStorage.isReadOnly()) {
            throw new BackingStoreException("Unsupported operation: read-only storage");
        }
        this.properties().clear();
        super.removeNode();
    }

    public final void flush() throws BackingStoreException {
        if (this.fileStorage.isReadOnly()) {
            throw new BackingStoreException("Unsupported operation: read-only storage");
        }
        super.flush();
    }

    public final void sync() throws BackingStoreException {
        if (this.fileStorage.isReadOnly()) {
            throw new BackingStoreException("Unsupported operation: read-only storage");
        }
        this.flushTask.waitFinished();
        super.sync();
    }

    protected abstract FileStorage getFileStorage(String var1);

    static {
        RP = new RequestProcessor();
    }

    static interface FileStorage {
        public boolean isReadOnly();

        public String[] childrenNames();

        public boolean existsNode();

        public void removeNode() throws IOException;

        public void markModified();

        public Properties load() throws IOException;

        public void save(Properties var1) throws IOException;

        public void runAtomic(Runnable var1);
    }

    private static final class SystemPreferences
    extends NbPreferences {
        private SystemPreferences() {
            super(false);
        }

        private SystemPreferences(NbPreferences nbPreferences, String string) {
            super(nbPreferences, string);
        }

        protected AbstractPreferences childSpi(String string) {
            return new SystemPreferences(this, string);
        }

        protected FileStorage getFileStorage(String string) {
            return PropertiesStorage.instanceReadOnly(this.absolutePath());
        }
    }

    public static class UserPreferences
    extends NbPreferences {
        public UserPreferences() {
            super(true);
        }

        private UserPreferences(NbPreferences nbPreferences, String string) {
            super(nbPreferences, string);
        }

        protected AbstractPreferences childSpi(String string) {
            return new UserPreferences(this, string);
        }

        protected FileStorage getFileStorage(String string) {
            return PropertiesStorage.instance(this.absolutePath());
        }
    }
}

