/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.api.CoordinatorV2HttpSolrCall;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.DelegatedSolrQueryRequest;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.servlet.HttpSolrCall;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorHttpSolrCall
extends HttpSolrCall {
    public static final String SYNTHETIC_COLL_PREFIX = ".sys.COORDINATOR-COLL-";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String collectionName;
    private final Factory factory;

    public CoordinatorHttpSolrCall(Factory factory, SolrDispatchFilter solrDispatchFilter, CoreContainer cores, HttpServletRequest request, HttpServletResponse response, boolean retry) {
        super(solrDispatchFilter, cores, request, response, retry);
        this.factory = factory;
    }

    @Override
    protected SolrCore getCoreByCollection(String collectionName, boolean isPreferLeader) {
        this.collectionName = collectionName;
        SolrCore core = super.getCoreByCollection(collectionName, isPreferLeader);
        if (core != null) {
            return core;
        }
        if (!this.path.endsWith("/select")) {
            return null;
        }
        return CoordinatorHttpSolrCall.getCore(this.factory, this, collectionName, isPreferLeader);
    }

    public static SolrCore getCore(Factory factory, HttpSolrCall solrCall, String collectionName, boolean isPreferLeader) {
        String sytheticCoreName = factory.collectionVsCoreNameMapping.get(collectionName);
        if (sytheticCoreName != null) {
            return solrCall.cores.getCore(sytheticCoreName);
        }
        ZkStateReader zkStateReader = solrCall.cores.getZkController().getZkStateReader();
        ClusterState clusterState = zkStateReader.getClusterState();
        DocCollection coll = clusterState.getCollectionOrNull(collectionName, true);
        if (coll != null) {
            SolrCore core;
            String confName = coll.getConfigName();
            String syntheticCollectionName = SYNTHETIC_COLL_PREFIX + confName;
            DocCollection syntheticColl = clusterState.getCollectionOrNull(syntheticCollectionName);
            if (syntheticColl == null) {
                if (log.isInfoEnabled()) {
                    log.info("synthetic collection: {} does not exist, creating.. ", (Object)syntheticCollectionName);
                }
                CoordinatorHttpSolrCall.createColl(syntheticCollectionName, solrCall.cores, confName);
            }
            if ((core = solrCall.getCoreByCollection(syntheticCollectionName, isPreferLeader)) != null) {
                factory.collectionVsCoreNameMapping.put(collectionName, core.getName());
                solrCall.cores.getZkController().getZkStateReader().registerCore(collectionName);
                if (log.isDebugEnabled()) {
                    log.debug("coordinator node, returns synthetic core: {}", (Object)core.getName());
                }
            } else {
                if (log.isInfoEnabled()) {
                    log.info("this node does not have a replica of the synthetic collection: {} , adding replica ", (Object)syntheticCollectionName);
                }
                CoordinatorHttpSolrCall.addReplica(syntheticCollectionName, solrCall.cores);
                core = solrCall.getCoreByCollection(syntheticCollectionName, isPreferLeader);
            }
            return core;
        }
        return null;
    }

    private static void addReplica(String syntheticCollectionName, CoreContainer cores) {
        SolrQueryResponse rsp = new SolrQueryResponse();
        try {
            cores.getCollectionsHandler().handleRequestBody(new LocalSolrQueryRequest(null, CollectionAdminRequest.addReplicaToShard((String)syntheticCollectionName, (String)"shard1").setCreateNodeSet(cores.getZkController().getNodeName()).getParams()), rsp);
            if (rsp.getValues().get("success") == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not auto-create collection: " + Utils.toJSONString(rsp.getValues()));
            }
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private static void createColl(String syntheticCollectionName, CoreContainer cores, String confName) {
        SolrQueryResponse rsp = new SolrQueryResponse();
        try {
            SolrParams params = CollectionAdminRequest.createCollection((String)syntheticCollectionName, (String)confName, (int)1, (int)1).setCreateNodeSet(cores.getZkController().getNodeName()).getParams();
            if (log.isInfoEnabled()) {
                log.info("sending collection admin command : {}", (Object)Utils.toJSONString((Object)params));
            }
            cores.getCollectionsHandler().handleRequestBody(new LocalSolrQueryRequest(null, params), rsp);
            if (rsp.getValues().get("success") == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not create :" + syntheticCollectionName + " collection: " + Utils.toJSONString(rsp.getValues()));
            }
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    @Override
    protected void init() throws Exception {
        super.init();
        if (this.action == SolrDispatchFilter.Action.PROCESS && this.core != null) {
            this.solrReq = CoordinatorHttpSolrCall.wrappedReq(this.solrReq, this.collectionName, this);
        }
    }

    public static SolrQueryRequest wrappedReq(SolrQueryRequest delegate, String collectionName, final HttpSolrCall httpSolrCall) {
        Properties p = new Properties();
        p.put("collection", collectionName);
        p.put("replicaType", Replica.Type.PULL.toString());
        p.put("shard", "_");
        final CloudDescriptor cloudDescriptor = new CloudDescriptor(delegate.getCore().getCoreDescriptor(), delegate.getCore().getName(), p);
        return new DelegatedSolrQueryRequest(delegate){

            @Override
            public HttpSolrCall getHttpSolrCall() {
                return httpSolrCall;
            }

            @Override
            public CloudDescriptor getCloudDescriptor() {
                return cloudDescriptor;
            }
        };
    }

    public static class Factory
    implements SolrDispatchFilter.HttpSolrCallFactory {
        private final Map<String, String> collectionVsCoreNameMapping = new ConcurrentHashMap<String, String>();

        @Override
        public HttpSolrCall createInstance(SolrDispatchFilter filter, String path, CoreContainer cores, HttpServletRequest request, HttpServletResponse response, boolean retry) {
            if (path.startsWith("/____v2/") || path.equals("/____v2")) {
                return new CoordinatorV2HttpSolrCall(this, filter, cores, request, response, retry);
            }
            return new CoordinatorHttpSolrCall(this, filter, cores, request, response, retry);
        }
    }
}

