/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTreeFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.AbstractSpatialFieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.util.MapListener;
import org.locationtech.spatial4j.context.SpatialContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSpatialPrefixTreeFieldType<T extends PrefixTreeStrategy>
extends AbstractSpatialFieldType<T> {
    public static final String DEFAULT_FIELD_VALUES_ARRAY_LEN = "defaultFieldValuesArrayLen";
    public static final Map<String, String> FIELD_TYPE_INVARIANTS = new HashMap<String, String>();
    protected SpatialPrefixTree grid;
    private Double distErrPct;
    private Integer defaultFieldValuesArrayLen;
    private static final Logger log;

    @Override
    public void setArgs(IndexSchema schema, Map<String, String> args) {
        for (Map.Entry<String, String> entry : FIELD_TYPE_INVARIANTS.entrySet()) {
            String userConfiguredValue;
            String key = entry.getKey();
            String hardcodedValue = entry.getValue();
            if (hardcodedValue.equals(userConfiguredValue = args.remove(key))) {
                log.warn("FieldType {} does not allow {} to be specified in schema, hardcoded behavior is {}={}", new Object[]{this.getClass().getSimpleName(), key, key, hardcodedValue});
                continue;
            }
            if (userConfiguredValue == null) continue;
            String message = String.format(Locale.ROOT, "FieldType %s is incompatible with %s=%s; hardcoded behavior is %s=%s. Remove specification in schema", this.getClass().getSimpleName(), key, userConfiguredValue, key, hardcodedValue);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
        }
        super.setArgs(schema, args);
    }

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        this.properties &= 0xFFFFFE7F;
        this.properties |= 0x2030;
        args.putIfAbsent("version", schema.getDefaultLuceneMatchVersion().toString());
        if (args.containsKey("maxDistErr")) {
            double maxDistErrOriginal = Double.parseDouble(args.get("maxDistErr"));
            args.put("maxDistErr", Double.toString(maxDistErrOriginal * this.distanceUnits.multiplierFromThisUnitToDegrees()));
        }
        MapListener<String, String> argsWrap = new MapListener<String, String>(args);
        this.grid = SpatialPrefixTreeFactory.makeSPT(argsWrap, (ClassLoader)schema.getResourceLoader().getClassLoader(), (SpatialContext)this.ctx);
        args.keySet().removeAll(argsWrap.getSeenKeys());
        String v = args.remove("distErrPct");
        if (v != null) {
            this.distErrPct = Double.valueOf(v);
        }
        if ((v = args.remove(DEFAULT_FIELD_VALUES_ARRAY_LEN)) != null) {
            this.defaultFieldValuesArrayLen = Integer.valueOf(v);
        }
    }

    @Override
    public void checkSchemaField(SchemaField field) {
        super.checkSchemaField(field);
        if (!field.omitNorms()) {
            String message = String.format(Locale.ROOT, "%s of type %s is incompatible with omitNorms=false; hardcoded behavior is omitNorms=true.  Remove specification in schema", field.getName(), this.getClass().getSimpleName());
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
        }
        if (field.indexOptions() != IndexOptions.DOCS) {
            String message = String.format(Locale.ROOT, "%s of type %s is incompatible with termFreq or position storage.  Remove specification in schema.", field.getName(), this.getClass().getSimpleName());
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
        }
    }

    @Override
    public Analyzer getIndexAnalyzer() {
        return new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                Object s = AbstractSpatialPrefixTreeFieldType.this.newSpatialStrategy(fieldName == null ? AbstractSpatialPrefixTreeFieldType.this.getTypeName() : fieldName);
                PrefixTreeStrategy.ShapeTokenStream ts = s.tokenStream();
                return new Analyzer.TokenStreamComponents(r -> {
                    try {
                        ts.setShape(AbstractSpatialPrefixTreeFieldType.this.parseShape(IOUtils.toString((Reader)r)));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }, (TokenStream)ts);
            }
        };
    }

    @Override
    public Analyzer getQueryAnalyzer() {
        return this.getIndexAnalyzer();
    }

    @Override
    protected T newSpatialStrategy(String fieldName) {
        T strat = this.newPrefixTreeStrategy(fieldName);
        if (this.distErrPct != null) {
            strat.setDistErrPct(this.distErrPct.doubleValue());
        }
        if (this.defaultFieldValuesArrayLen != null) {
            strat.setDefaultFieldValuesArrayLen(this.defaultFieldValuesArrayLen.intValue());
        }
        if (log.isInfoEnabled()) {
            log.info("{} strat: {} maxLevels: {}", new Object[]{this, strat, this.grid.getMaxLevels()});
        }
        return strat;
    }

    protected abstract T newPrefixTreeStrategy(String var1);

    static {
        FIELD_TYPE_INVARIANTS.put("omitNorms", "true");
        FIELD_TYPE_INVARIANTS.put("termPositions", "false");
        FIELD_TYPE_INVARIANTS.put("termOffsets", "false");
        FIELD_TYPE_INVARIANTS.put("omitTermFreqAndPositions", "true");
        FIELD_TYPE_INVARIANTS.put("omitPositions", "true");
        log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }
}

