/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.HashMap;
import java.util.Locale;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.util.ReflectMapWriter;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.security.PermissionNameProvider;

@EndPoint(path={"/cores/{core}"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.CORE_EDIT_PERM)
public class ReloadCoreAPI {
    private static final String V2_RELOAD_CORE_CMD = "reload";
    private final CoreAdminHandler coreHandler;

    public ReloadCoreAPI(CoreAdminHandler coreHandler) {
        this.coreHandler = coreHandler;
    }

    @Command(name="reload")
    public void reloadCore(PayloadObj<ReloadCorePayload> obj) throws Exception {
        String coreName = obj.getRequest().getPathTemplateValues().get("core");
        HashMap<String, Object> v1Params = new HashMap<String, Object>();
        v1Params.put("action", CoreAdminParams.CoreAdminAction.RELOAD.name().toLowerCase(Locale.ROOT));
        v1Params.put("core", coreName);
        this.coreHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
    }

    public static class ReloadCorePayload
    implements ReflectMapWriter {
    }
}

