/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemConfigSetService
extends ConfigSetService {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Path configSetBase;

    public FileSystemConfigSetService(CoreContainer cc) {
        super(cc.getResourceLoader(), cc.getConfig().hasSchemaCache());
        this.configSetBase = cc.getConfig().getConfigSetBaseDirectory();
    }

    @Override
    public SolrResourceLoader createCoreResourceLoader(CoreDescriptor cd) {
        Path instanceDir = this.locateInstanceDir(cd);
        SolrResourceLoader solrResourceLoader = new SolrResourceLoader(instanceDir, this.parentLoader.getClassLoader());
        return solrResourceLoader;
    }

    @Override
    public String configSetName(CoreDescriptor cd) {
        return (cd.getConfigSet() == null ? "instancedir " : "configset ") + this.locateInstanceDir(cd);
    }

    @Override
    public boolean checkConfigExists(String configName) throws IOException {
        Path solrConfigXmlFile = this.configSetBase.resolve(configName).resolve("solrconfig.xml");
        return Files.exists(solrConfigXmlFile, new LinkOption[0]);
    }

    @Override
    public void deleteConfig(String configName) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteFilesFromConfig(String configName, List<String> filesToDelete) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyConfig(String fromConfig, String toConfig) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void uploadConfig(String configName, Path dir) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void uploadFileToConfig(String configName, String fileName, byte[] data, boolean overwriteOnExists) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setConfigMetadata(String configName, Map<String, Object> data) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Object> getConfigMetadata(String configName) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void downloadConfig(String configName, Path dir) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> listConfigs() throws IOException {
        try (Stream<Path> configs = Files.list(this.configSetBase);){
            List<String> list = configs.map(Path::getFileName).map(Path::toString).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public byte[] downloadFileFromConfig(String configName, String filePath) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getAllConfigFiles(String configName) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Path locateInstanceDir(CoreDescriptor cd) {
        String configSet = cd.getConfigSet();
        if (configSet == null) {
            return cd.getInstanceDir();
        }
        Path configSetDirectory = this.configSetBase.resolve(configSet);
        if (!Files.isDirectory(configSetDirectory, new LinkOption[0])) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load configuration from directory " + configSetDirectory);
        }
        return configSetDirectory;
    }

    @Override
    protected Long getCurrentSchemaModificationVersion(String configSet, SolrConfig solrConfig, String schemaFileName) throws IOException {
        Path schemaFile = solrConfig.getResourceLoader().getConfigPath().resolve(schemaFileName);
        try {
            return Files.getLastModifiedTime(schemaFile, new LinkOption[0]).toMillis();
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            log.warn("Unexpected exception when getting modification time of {}", (Object)schemaFile, (Object)e);
            return null;
        }
    }
}

