/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.adm;

import com.oracle.bmc.adm.ApplicationDependencyManagementClient;
import com.oracle.bmc.adm.model.KnowledgeBase;
import com.oracle.bmc.adm.requests.GetKnowledgeBaseRequest;
import com.oracle.bmc.adm.responses.GetKnowledgeBaseResponse;
import com.oracle.bmc.model.BmcException;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCIProfile;
import org.netbeans.modules.cloud.oracle.adm.AuditException;
import org.netbeans.modules.cloud.oracle.adm.AuditOptions;
import org.netbeans.modules.cloud.oracle.adm.Bundle;
import org.netbeans.modules.cloud.oracle.adm.ErrorUtils;
import org.netbeans.modules.cloud.oracle.adm.KnowledgeBaseItem;
import org.netbeans.modules.cloud.oracle.adm.VulnerabilityWorker;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.util.RequestProcessor;

public final class ProjectVulnerability {
    private final RequestProcessor AUDIT_PROCESSOR = new RequestProcessor(ProjectVulnerability.class.getName(), 4);
    private final RequestProcessor CALL_PROCESSOR = new RequestProcessor(ProjectVulnerability.class);
    private static final String PROJECT_PROPERTY_PROFILE_ID = "cloud.oracle.adm.kb.profilePath";
    private static final String PROJECT_PROPERTY_PROFILE_PATH = "cloud.oracle.adm.kb.profileId";
    private static final String PROJECT_PROPERTY_KB_OCID = "cloud.oracle.adm.kb.ocid";
    private final Project project;
    private KnowledgeBaseItem knowledgeBaseItem = null;
    private OCIProfile lastProfile;

    public ProjectVulnerability(Project project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KnowledgeBaseItem getProjectKnowledgeBase() {
        KnowledgeBaseItem item;
        OCIProfile profile;
        ProjectVulnerability projectVulnerability = this;
        synchronized (projectVulnerability) {
            if (this.knowledgeBaseItem != null) {
                return this.knowledgeBaseItem;
            }
        }
        AuxiliaryProperties props = (AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class);
        if (props == null) {
            return null;
        }
        OCIProfile active = OCIManager.getDefault().getActiveProfile();
        String ocid = props.get(PROJECT_PROPERTY_KB_OCID, false);
        if (ocid == null) {
            return null;
        }
        String profId = props.get(PROJECT_PROPERTY_PROFILE_ID, false);
        String profPath = props.get(PROJECT_PROPERTY_PROFILE_PATH, false);
        try {
            profile = OCIManager.forConfig(Paths.get(profPath, new String[0]), profId);
            if (!profile.getTenancy().isPresent()) {
                profile = active;
            }
        }
        catch (IllegalArgumentException ex) {
            profile = active;
        }
        try (ApplicationDependencyManagementClient admClient = profile.newClient(ApplicationDependencyManagementClient.class);){
            GetKnowledgeBaseRequest req = GetKnowledgeBaseRequest.builder().knowledgeBaseId(ocid).build();
            GetKnowledgeBaseResponse resp = admClient.getKnowledgeBase(req);
            KnowledgeBase p = resp.getKnowledgeBase();
            item = new KnowledgeBaseItem(OCID.of(p.getId(), "KnowledgeBase"), p.getCompartmentId(), p.getDisplayName(), p.getTimeUpdated());
        }
        catch (BmcException | IllegalArgumentException ex) {
            item = this.knowledgeBaseItem;
            profile = this.lastProfile;
        }
        ProjectVulnerability projectVulnerability2 = this;
        synchronized (projectVulnerability2) {
            if (this.knowledgeBaseItem == null) {
                this.lastProfile = profile;
                this.knowledgeBaseItem = item;
            }
        }
        return item;
    }

    public CompletableFuture<String> runProjectAudit(KnowledgeBaseItem item, AuditOptions options) {
        if (item != null) {
            this.setProjectKnowledgeBase(item);
        }
        CompletableFuture<String> result = new CompletableFuture<String>();
        this.AUDIT_PROCESSOR.post(() -> {
            try {
                result.complete(VulnerabilityWorker.getInstance().findVulnerability(this.project, options));
            }
            catch (ThreadDeath x) {
                throw x;
            }
            catch (AuditException ex) {
                String projectDisplayName = ProjectUtils.getInformation((Project)this.project).getDisplayName();
                ErrorUtils.processError(ex, Bundle.MSG_CreatingAuditFailed(projectDisplayName));
                result.completeExceptionally(ex);
            }
            catch (Error | Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<KnowledgeBaseItem> findKnowledgeBase(String knowledgeBaseId) {
        CompletableFuture<KnowledgeBaseItem> result = new CompletableFuture<KnowledgeBaseItem>();
        this.CALL_PROCESSOR.post(() -> {
            try (ApplicationDependencyManagementClient client = OCIManager.getDefault().getActiveSession().newClient(ApplicationDependencyManagementClient.class);){
                GetKnowledgeBaseRequest request = GetKnowledgeBaseRequest.builder().knowledgeBaseId(knowledgeBaseId).build();
                GetKnowledgeBaseResponse response = client.getKnowledgeBase(request);
                KnowledgeBase p = response.getKnowledgeBase();
                result.complete(new KnowledgeBaseItemProxy(OCID.of(p.getId(), "KnowledgeBase"), p.getCompartmentId(), p.getDisplayName(), p.getTimeUpdated()));
            }
            catch (ThreadDeath x) {
                throw x;
            }
            catch (BmcException ex) {
                result.completeExceptionally(new AuditException(ex.getStatusCode(), ex.getOpcRequestId(), ex.getMessage(), ex));
            }
            catch (Error | Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    public KnowledgeBaseItem setProjectKnowledgeBase(KnowledgeBaseItem item) {
        this.setProjectKnowledgeBase0(item);
        AuxiliaryProperties props = (AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class);
        if (props != null) {
            OCID kbOcid = item.getKey();
            OCIProfile profile = OCIManager.getDefault().getActiveProfile();
            props.put(PROJECT_PROPERTY_KB_OCID, kbOcid.toPersistentForm(), false);
            props.put(PROJECT_PROPERTY_PROFILE_ID, profile.getId(), false);
            props.put(PROJECT_PROPERTY_PROFILE_PATH, profile.getConfigPath().toString(), false);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KnowledgeBaseItem setProjectKnowledgeBase0(KnowledgeBaseItem item) {
        ProjectVulnerability projectVulnerability = this;
        synchronized (projectVulnerability) {
            this.lastProfile = OCIManager.getDefault().getActiveProfile();
            this.knowledgeBaseItem = item;
            return this.knowledgeBaseItem;
        }
    }

    static class KnowledgeBaseItemProxy
    extends KnowledgeBaseItem {
        public KnowledgeBaseItemProxy(OCID id, String compartmentId, String displayName, Date timeUpdated) {
            super(id, compartmentId, displayName, timeUpdated);
        }

        @Override
        void registerItem() {
        }

        @Override
        public void refresh() {
            super.refresh();
            Collection<KnowledgeBaseItem> delegates = KnowledgeBaseItemProxy.findKnownInstances(this.getKey());
            for (KnowledgeBaseItem kbi : delegates) {
                kbi.refresh();
            }
        }
    }
}

