/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.DataDerivType;
import com.thaiopensource.relaxng.impl.DatatypeValue;
import com.thaiopensource.relaxng.impl.InconsistentDataDerivType;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternMemo;
import com.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import java.util.HashMap;
import java.util.Map;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.ValidationContext;

class ValueDataDerivType
extends DataDerivType {
    private final Datatype dt;
    private PatternMemo noValue;
    private Map valueTable;

    ValueDataDerivType(Datatype datatype) {
        this.dt = datatype;
    }

    DataDerivType copy() {
        return new ValueDataDerivType(this.dt);
    }

    PatternMemo dataDeriv(ValidatorPatternBuilder validatorPatternBuilder, Pattern pattern, String string, ValidationContext validationContext) {
        PatternMemo patternMemo;
        Object object = this.dt.createValue(string, validationContext);
        if (object == null) {
            if (this.noValue == null) {
                this.noValue = super.dataDeriv(validatorPatternBuilder, pattern, string, validationContext);
            }
            return this.noValue;
        }
        DatatypeValue datatypeValue = new DatatypeValue(object, this.dt);
        if (this.valueTable == null) {
            this.valueTable = new HashMap();
        }
        if ((patternMemo = (PatternMemo)this.valueTable.get(datatypeValue)) == null) {
            patternMemo = super.dataDeriv(validatorPatternBuilder, pattern, string, validationContext);
            this.valueTable.put(datatypeValue, patternMemo);
        }
        return patternMemo;
    }

    DataDerivType combine(DataDerivType dataDerivType) {
        if (dataDerivType instanceof ValueDataDerivType) {
            if (((ValueDataDerivType)dataDerivType).dt == this.dt) {
                return this;
            }
            return InconsistentDataDerivType.getInstance();
        }
        return dataDerivType.combine(this);
    }

    Datatype getDatatype() {
        return this.dt;
    }
}

