/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms.android;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cordova.platforms.android.AndroidActionProvider;
import org.netbeans.modules.cordova.platforms.android.AndroidConfigurationPanel;
import org.netbeans.modules.cordova.platforms.android.AndroidDebugTransport;
import org.netbeans.modules.cordova.platforms.android.AndroidPlatform;
import org.netbeans.modules.cordova.platforms.android.Browser;
import org.netbeans.modules.cordova.platforms.api.ProcessUtilities;
import org.netbeans.modules.cordova.platforms.spi.Device;
import org.netbeans.modules.cordova.platforms.spi.MobileDebugTransport;
import org.netbeans.modules.cordova.platforms.spi.MobilePlatform;
import org.netbeans.modules.cordova.platforms.spi.PropertyProvider;
import org.netbeans.modules.web.clientproject.spi.platform.ProjectConfigurationCustomizer;
import org.netbeans.spi.project.ActionProvider;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;

public class AndroidDevice
implements Device {
    private Browser browser;
    private final String name;
    private boolean emulator;

    public static Collection<Device> parse(String output) throws IOException {
        BufferedReader r = new BufferedReader(new StringReader(output));
        Pattern pattern = Pattern.compile("([-\\w]+)\\s+([\\w]+) *");
        ArrayList<Device> result = new ArrayList<Device>();
        String line = r.readLine();
        while ((line = r.readLine()) != null) {
            Matcher m = pattern.matcher(line);
            if (!m.matches()) continue;
            String name = m.group(1);
            AndroidDevice device = new AndroidDevice(name, Browser.DEFAULT, name.startsWith("emulator"));
            result.add(device);
        }
        return result;
    }

    public void openUrl(String url) {
        try {
            if (this.browser == Browser.DEFAULT) {
                ProcessUtilities.callProcess((String)((AndroidPlatform)this.getPlatform()).getAdbCommand(), (boolean)true, (int)AndroidPlatform.DEFAULT_TIMEOUT, (String[])new String[]{this.isEmulator() ? "-e" : "-d", "wait-for-device", "shell", "am", "start", "-e", "com.android.browser.application_id", "org.netbeans.modules.cordova", "-a", "android.intent.action.VIEW", url});
            } else {
                ProcessUtilities.callProcess((String)((AndroidPlatform)this.getPlatform()).getAdbCommand(), (boolean)true, (int)AndroidPlatform.DEFAULT_TIMEOUT, (String[])new String[]{this.isEmulator() ? "-e" : "-d", "wait-for-device", "shell", "am", "start", "-e", "com.android.browser.application_id", "org.netbeans.modules.cordova", "-a", "android.intent.action.VIEW", "-n", this.getPrefferedBrowser(), url});
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    static Device get(String name, EditableProperties props) {
        String property = props.getProperty("device");
        boolean b = "emulator".equals(property);
        String property1 = props.getProperty("browser");
        if (property1 != null && property1.equals(Browser.CHROME.getName())) {
            return new AndroidDevice(name, Browser.CHROME, b);
        }
        return new AndroidDevice(name, Browser.DEFAULT, b);
    }

    public AndroidDevice(String name, Browser browser, boolean emulator) {
        this.name = name;
        this.browser = browser;
        this.emulator = emulator;
    }

    public boolean isEmulator() {
        return this.emulator;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Device{name=" + this.name + ", emulator: " + this.isEmulator() + '}';
    }

    public MobilePlatform getPlatform() {
        return AndroidPlatform.getDefault();
    }

    public MobileDebugTransport getDebugTransport() {
        return new AndroidDebugTransport();
    }

    public void addProperties(Properties props) {
        MobilePlatform android = this.getPlatform();
        if (android.isReady()) {
            if (android.getPrefferedTarget() != null) {
                props.put("android.build.target", android.getPrefferedTarget().getName());
            }
            props.put("android.sdk.home", android.getSdkLocation());
            props.put("android.target.device.arg", this.isEmulator() ? "emulate" : "run");
        } else {
            Logger.getLogger(AndroidDevice.class.getName()).fine("Android not configured.");
        }
    }

    public ActionProvider getActionProvider(Project p) {
        return new AndroidActionProvider(p);
    }

    public ProjectConfigurationCustomizer getProjectConfigurationCustomizer(Project project, PropertyProvider aThis) {
        return new AndroidConfigurationPanel.AndroidConfigurationCustomizer(project, aThis);
    }

    private String getPrefferedBrowser() {
        return this.browser.getCommand();
    }

    public boolean isWebViewDebugSupported() {
        return AndroidPlatform.getDefault().isWebViewDebugSupported(this.isEmulator());
    }
}

