/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.ui;

import java.awt.Dimension;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.glassfish.common.GlassFishLogger;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.common.ui.CommonPasswordPanel;
import org.netbeans.modules.glassfish.common.ui.ComponentFieldListener;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GlassFishPassword
extends CommonPasswordPanel {
    private static final Logger LOGGER = GlassFishLogger.get(GlassFishPassword.class);
    private final String passwordVerifyLabelText = NbBundle.getMessage(GlassFishPassword.class, (String)"GlassFishPassword.passwordVerifyLabel");
    private JLabel messageLabel;
    private JPasswordField password;
    private JLabel passwordLabel;
    private JPasswordField passwordVerify;
    private JLabel passwordVerifyLabel;
    private JLabel userLabel;
    private JTextField userText;

    public static String setPassword(GlassfishInstance instance) {
        String title = NbBundle.getMessage(GlassFishPassword.class, (String)"GlassFishPassword.title");
        String message = NbBundle.getMessage(GlassFishPassword.class, (String)"GlassFishPassword.message", (Object)instance.getDisplayName());
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor(null, title, 2, -1, null, null);
        GlassFishPassword panel = new GlassFishPassword(notifyDescriptor, instance, message);
        Object button = DialogDisplayer.getDefault().notify(notifyDescriptor);
        if (button == NotifyDescriptor.CANCEL_OPTION) {
            return null;
        }
        String password = panel.getPassword();
        instance.setAdminPassword(password);
        try {
            GlassfishInstance.writeInstanceToFile(instance);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Could not store GlassFish server attributes", ex);
        }
        return password;
    }

    public GlassFishPassword(NotifyDescriptor descriptor, GlassfishInstance instance, String message) {
        super(descriptor, instance, message);
        this.initComponents();
        this.initFileds(this.passwordValid());
        this.password.getDocument().addDocumentListener(this.initPasswordValidateListener());
        this.passwordVerify.getDocument().addDocumentListener(this.initPasswordValidateListener());
    }

    String getPassword() {
        return new String(this.password.getPassword());
    }

    final boolean passwordValid() {
        char[] password2;
        char[] password1 = this.password.getPassword();
        if (password1.length == (password2 = this.passwordVerify.getPassword()).length) {
            boolean valid = true;
            for (int i = 0; valid && i < password1.length; ++i) {
                valid = password1[i] == password2[i];
            }
            return valid;
        }
        return false;
    }

    private DocumentListener initPasswordValidateListener() {
        return new ComponentFieldListener(){

            @Override
            void processEvent() {
                GlassFishPassword.this.valid = GlassFishPassword.this.passwordValid();
                GlassFishPassword.this.setDescriptorButtons(GlassFishPassword.this.descriptor, GlassFishPassword.this.valid);
            }
        };
    }

    public void clear() {
        this.password.setText("");
        this.passwordVerify.setText("");
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.userLabel = new JLabel();
        this.passwordLabel = new JLabel();
        this.passwordVerifyLabel = new JLabel();
        this.userText = new JTextField();
        this.password = new JPasswordField();
        this.passwordVerify = new JPasswordField();
        this.setMaximumSize(new Dimension(500, 200));
        this.setMinimumSize(new Dimension(500, 150));
        this.setPreferredSize(new Dimension(500, 150));
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)this.message);
        this.messageLabel.setMaximumSize(new Dimension(93, 15));
        this.messageLabel.setMinimumSize(new Dimension(93, 15));
        this.messageLabel.setPreferredSize(new Dimension(15, 15));
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)this.userLabelText);
        this.userLabel.setMaximumSize(new Dimension(93, 15));
        this.userLabel.setMinimumSize(new Dimension(93, 15));
        this.userLabel.setPreferredSize(new Dimension(93, 15));
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)this.passwordLabelText);
        Mnemonics.setLocalizedText((JLabel)this.passwordVerifyLabel, (String)this.passwordVerifyLabelText);
        this.userText.setEditable(false);
        this.userText.setText(this.instance.getAdminUser());
        this.password.setText(this.instance.getAdminPassword());
        this.passwordVerify.setText(this.instance.getAdminPassword());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messageLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.userLabel, -1, 150, Short.MAX_VALUE).addComponent(this.passwordLabel, -1, -1, Short.MAX_VALUE).addComponent(this.passwordVerifyLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userText, -1, 314, Short.MAX_VALUE).addComponent(this.password).addComponent(this.passwordVerify)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.messageLabel, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.userLabel, -2, -1, -2).addComponent(this.userText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.passwordLabel).addComponent(this.password, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.passwordVerifyLabel).addComponent(this.passwordVerify, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

