/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.modules.versioning.core.Utils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.util.VCSSystemProvider;
import org.openide.util.NbPreferences;

public class VersioningConfig {
    private static final VersioningConfig INSTANCE = new VersioningConfig();
    private static final Logger LOG = Logger.getLogger(VersioningConfig.class.getName());
    private final Map<String, Set<String>> allDisconnectedRepositories = VersioningConfig.initializeDisconnectedRepositories();
    private static final String SEP = "###";
    private static final String PREF_KEY = "disconnectedFolders";

    private VersioningConfig() {
    }

    public static VersioningConfig getDefault() {
        return INSTANCE;
    }

    public Preferences getPreferences() {
        return VersioningConfig.getPrefs();
    }

    private static Preferences getPrefs() {
        return NbPreferences.root().node("org/netbeans/modules/versioning");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDisconnected(VCSSystemProvider.VersioningSystem vs, VCSFileProxy repository) {
        boolean disconnected = false;
        String className = vs.getDelegate().getClass().getName();
        Map<String, Set<String>> map = this.allDisconnectedRepositories;
        synchronized (map) {
            Set<String> disconnectedRepositories = this.allDisconnectedRepositories.get(className);
            if (disconnectedRepositories != null) {
                for (String disconnectedRepository : disconnectedRepositories) {
                    if (!disconnectedRepository.equals(repository.getPath())) continue;
                    disconnected = true;
                    LOG.log(Level.FINE, "isDisconnected: Folder is disconnected from {0}: {1}, disconnected root: {2}", new Object[]{className, repository, disconnectedRepository});
                    break;
                }
            }
        }
        return disconnected;
    }

    public void connectRepository(VCSSystemProvider.VersioningSystem vs, VCSFileProxy repository) {
        this.connectRepository(vs, repository.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectRepository(VCSSystemProvider.VersioningSystem vs, String path) {
        String className = vs.getDelegate().getClass().getName();
        Map<String, Set<String>> map = this.allDisconnectedRepositories;
        synchronized (map) {
            Set<String> disconnectedRepos = this.allDisconnectedRepositories.get(className);
            if (disconnectedRepos != null) {
                boolean changed = false;
                Iterator<String> it = disconnectedRepos.iterator();
                while (it.hasNext()) {
                    String disconnectedRepository = it.next();
                    if (!disconnectedRepository.equals(path)) continue;
                    LOG.log(Level.FINE, "connectRepository: Connecting repository to {0}: {1}", new Object[]{className, path});
                    it.remove();
                    changed = true;
                    break;
                }
                if (changed) {
                    this.saveDisconnectedRepositories();
                }
            }
        }
    }

    public void disconnectRepository(VCSSystemProvider.VersioningSystem vs, VCSFileProxy repository) {
        this.disconnectRepository(vs, repository.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectRepository(VCSSystemProvider.VersioningSystem vs, String path) {
        String className = vs.getDelegate().getClass().getName();
        Map<String, Set<String>> map = this.allDisconnectedRepositories;
        synchronized (map) {
            boolean added;
            Set<String> disconnectedRepos = this.allDisconnectedRepositories.get(className);
            if (disconnectedRepos == null) {
                disconnectedRepos = new HashSet<String>();
                this.allDisconnectedRepositories.put(className, disconnectedRepos);
            }
            if (!(added = disconnectedRepos.add(path))) {
                LOG.log(Level.FINE, "disconnectRepository: Repository already disconnected for {0}: {1}", new Object[]{className, path});
            } else {
                this.saveDisconnectedRepositories();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDisconnectedRoots(VCSSystemProvider.VersioningSystem vs) {
        String[] paths;
        String className = vs.getDelegate().getClass().getName();
        Map<String, Set<String>> map = this.allDisconnectedRepositories;
        synchronized (map) {
            Set<String> disconnectedRepos = this.allDisconnectedRepositories.get(className);
            paths = disconnectedRepos == null ? new String[]{} : disconnectedRepos.toArray(new String[disconnectedRepos.size()]);
        }
        return paths;
    }

    private static Map<String, Set<String>> initializeDisconnectedRepositories() {
        HashMap<String, Set<String>> disconnectedFolders = new HashMap<String, Set<String>>(5);
        List<String> list = Utils.getStringList(VersioningConfig.getPrefs(), PREF_KEY);
        for (String s : list) {
            String[] disconnectedFolder = s.split(SEP);
            if (disconnectedFolder.length != 2) continue;
            HashSet<String> files = (HashSet<String>)disconnectedFolders.get(disconnectedFolder[0]);
            if (files == null) {
                files = new HashSet<String>();
                disconnectedFolders.put(disconnectedFolder[0], files);
            }
            files.add(disconnectedFolder[1]);
        }
        return disconnectedFolders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDisconnectedRepositories() {
        LinkedList<String> list = new LinkedList<String>();
        Map<String, Set<String>> map = this.allDisconnectedRepositories;
        synchronized (map) {
            for (Map.Entry<String, Set<String>> e : this.allDisconnectedRepositories.entrySet()) {
                String vsKey = e.getKey();
                for (String f : e.getValue()) {
                    list.add(vsKey + SEP + f);
                }
            }
        }
        Utils.put(this.getPreferences(), PREF_KEY, list);
    }
}

