/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ear;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.StringInputStream;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.ApplicationMetadata;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.deployment.common.api.EjbChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationImplementation2;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleFactory;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleImplementation2;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.spi.MetadataModelFactory;
import org.netbeans.modules.j2ee.metadata.model.spi.MetadataModelImplementation;
import org.netbeans.modules.j2ee.spi.ejbjar.EarImplementation;
import org.netbeans.modules.j2ee.spi.ejbjar.EarImplementation2;
import org.netbeans.modules.javaee.project.api.JavaEEProjectSettings;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.j2ee.EjbChangeDescriptorImpl;
import org.netbeans.modules.maven.j2ee.ear.NonProjectJ2eeModule;
import org.netbeans.modules.maven.j2ee.ear.model.ApplicationMetadataModelImpl;
import org.netbeans.modules.maven.spi.debug.AdditionalDebuggedProjects;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EarImpl
implements EarImplementation,
EarImplementation2,
J2eeApplicationImplementation2,
ModuleChangeReporter,
AdditionalDebuggedProjects {
    private Project project;
    private J2eeModuleProvider provider;
    private MetadataModel<ApplicationMetadata> metadataModel;

    public EarImpl(Project project, J2eeModuleProvider provider) {
        this.project = project;
        this.provider = provider;
    }

    private NbMavenProject mavenproject() {
        return (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
    }

    public Profile getJ2eeProfile() {
        Profile profile = JavaEEProjectSettings.getProfile((Project)this.project);
        if (profile != null) {
            return profile;
        }
        if (this.isApplicationXmlGenerated()) {
            String version = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)"org.apache.maven.plugins", (String)"maven-ear-plugin", (String)"version", (String)"generate-application-xml", null);
            if (version != null) {
                if (!(version = version.trim()).startsWith("1.")) {
                    version = "1." + version;
                }
                return Profile.fromPropertiesString((String)version);
            }
        } else {
            DDProvider prov = DDProvider.getDefault();
            FileObject dd = this.getDeploymentDescriptor();
            if (dd != null) {
                try {
                    Application app = prov.getDDRoot(dd);
                    String appVersion = app.getVersion().toString();
                    appVersion = appVersion.trim();
                    if (!appVersion.startsWith("1.")) {
                        appVersion = "1." + appVersion;
                    }
                    return Profile.fromPropertiesString((String)appVersion);
                }
                catch (IOException exc) {
                    ErrorManager.getDefault().notify((Throwable)exc);
                }
            } else {
                return Profile.JAVA_EE_6_FULL;
            }
        }
        return Profile.JAVA_EE_5;
    }

    public String getJ2eePlatformVersion() {
        return this.getJ2eeProfile().toPropertiesString();
    }

    public FileObject getMetaInf() {
        File fil;
        boolean rootCreated;
        URI dir;
        FileObject root;
        String appsrcloc = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)"org.apache.maven.plugins", (String)"maven-ear-plugin", (String)"earSourceDirectory", (String)"ear", null);
        if (appsrcloc == null) {
            appsrcloc = "src/main/application";
        }
        if ((root = FileUtilities.convertURItoFileObject((URI)(dir = FileUtilities.getDirURI((FileObject)this.project.getProjectDirectory(), (String)appsrcloc)))) == null && (rootCreated = (fil = new File(dir)).mkdirs())) {
            this.project.getProjectDirectory().refresh();
            root = FileUtil.toFileObject((File)fil);
        }
        if (root != null) {
            FileObject metainf = root.getFileObject("META-INF");
            if (metainf == null) {
                try {
                    metainf = root.createFolder("META-INF");
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            return metainf;
        }
        return null;
    }

    public FileObject getDeploymentDescriptor() {
        String customLoc;
        FileObject fo;
        if (this.isApplicationXmlGenerated()) {
            String generatedLoc = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)"org.apache.maven.plugins", (String)"maven-ear-plugin", (String)"generatedDescriptorLocation", (String)"generate-application-xml", null);
            if (generatedLoc == null) {
                generatedLoc = this.mavenproject().getMavenProject().getBuild().getDirectory();
            }
            if ((fo = FileUtilities.convertURItoFileObject((URI)FileUtilities.getDirURI((FileObject)this.project.getProjectDirectory(), (String)generatedLoc))) != null) {
                return fo.getFileObject("application.xml");
            }
        }
        if ((customLoc = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)"org.apache.maven.plugins", (String)"maven-ear-plugin", (String)"applicationXml", (String)"ear", null)) != null && (fo = FileUtilities.convertURItoFileObject((URI)FileUtilities.getDirURI((FileObject)this.project.getProjectDirectory(), (String)customLoc))) != null) {
            return fo;
        }
        return null;
    }

    public void addWebModule(WebModule webModule) {
        throw new IllegalStateException("Not implemented for maven based projects.");
    }

    public void addEjbJarModule(EjbJar ejbJar) {
        throw new IllegalStateException("Not implemented for maven based projects.");
    }

    private boolean isApplicationXmlGenerated() {
        String str = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)"org.apache.maven.plugins", (String)"maven-ear-plugin", (String)"generateApplicationXml", (String)"generate-application-xml", null);
        return str == null || Boolean.valueOf(str) != false;
    }

    boolean isValid() {
        return true;
    }

    public J2eeModule.Type getModuleType() {
        return J2eeModule.Type.EAR;
    }

    public String getModuleVersion() {
        Profile prf = this.getJ2eeProfile();
        if (prf == Profile.JAKARTA_EE_9_1_FULL || prf == Profile.JAKARTA_EE_9_FULL) {
            return "9";
        }
        if (prf == Profile.JAKARTA_EE_8_FULL || prf == Profile.JAVA_EE_8_FULL) {
            return "8";
        }
        if (prf == Profile.JAVA_EE_7_FULL) {
            return "7";
        }
        if (prf == Profile.JAVA_EE_6_FULL) {
            return "6";
        }
        if (prf == Profile.JAVA_EE_5) {
            return "5";
        }
        return "1.4";
    }

    public String getUrl() {
        String toRet = "/" + this.mavenproject().getMavenProject().getBuild().getFinalName();
        return toRet;
    }

    public FileObject getArchive() throws IOException {
        MavenProject proj = this.mavenproject().getMavenProject();
        String finalName = proj.getBuild().getFinalName();
        String loc = proj.getBuild().getDirectory();
        File fil = FileUtil.normalizeFile((File)new File(loc, finalName + ".ear"));
        return FileUtil.toFileObject((File)fil);
    }

    public Iterator getArchiveContents() throws IOException {
        FileObject fo = this.getContentDirectory();
        if (fo != null) {
            return new ContentIterator(fo);
        }
        return null;
    }

    public FileObject getContentDirectory() throws IOException {
        MavenProject proj = this.mavenproject().getMavenProject();
        String finalName = proj.getBuild().getFinalName();
        String buildDir = proj.getBuild().getDirectory();
        if (finalName != null && buildDir != null) {
            File file = FileUtil.normalizeFile((File)new File(buildDir, finalName));
            FileObject fo = FileUtil.toFileObject((File)file);
            if (fo != null) {
                fo.refresh();
            }
            return FileUtil.toFileObject((File)file);
        }
        return null;
    }

    public RootInterface getDeploymentDescriptor(String location) {
        block8: {
            if ("application.xml".equals(location)) {
                location = "META-INF/application.xml";
            }
            if ("META-INF/application.xml".equals(location)) {
                try {
                    FileObject content = this.getDeploymentDescriptor();
                    if (content == null) {
                        StringInputStream str = new StringInputStream("<application xmlns=\"http://java.sun.com/xml/ns/j2ee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application_1_4.xsd\" version=\"1.4\"><description>description</description><display-name>" + this.mavenproject().getMavenProject().getArtifactId() + "</display-name></application>");
                        try {
                            return DDProvider.getDefault().getDDRoot(new InputSource((InputStream)str));
                        }
                        catch (SAXException ex) {
                            ex.printStackTrace();
                            break block8;
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                            break block8;
                        }
                    }
                    return DDProvider.getDefault().getDDRoot(content);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().log(e.getLocalizedMessage());
                }
            }
        }
        return null;
    }

    public J2eeModule[] getModules() {
        MavenProject mp = this.mavenproject().getMavenProject();
        Set artifactSet = mp.getArtifacts();
        List deps = mp.getRuntimeDependencies();
        String fileNameMapping = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)"org.apache.maven.plugins", (String)"maven-ear-plugin", (String)"fileNameMapping", (String)"ear", null);
        if (fileNameMapping == null) {
            fileNameMapping = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)"org.apache.maven.plugins", (String)"maven-ear-plugin", (String)"outputFileNameMapping", (String)"ear", null);
        }
        if (fileNameMapping == null) {
            fileNameMapping = "standard";
        }
        ArrayList<J2eeModule> toRet = new ArrayList<J2eeModule>();
        MavenModule[] mm = this.readPomModules();
        block0: for (Dependency d : deps) {
            if (!"war".equals(d.getType()) && !"ejb".equals(d.getType()) && !"app-client".equals(d.getType())) continue;
            for (Artifact a : artifactSet) {
                J2eeModuleProvider prov;
                if (!a.getGroupId().equals(d.getGroupId()) || !a.getArtifactId().equals(d.getArtifactId()) || !StringUtils.equals((String)a.getClassifier(), (String)d.getClassifier())) continue;
                URI uri = Utilities.toURI((File)FileUtil.normalizeFile((File)a.getFile()));
                Project owner = FileOwnerQuery.getOwner((URI)uri);
                boolean found = false;
                if (owner != null && (prov = (J2eeModuleProvider)owner.getLookup().lookup(J2eeModuleProvider.class)) != null) {
                    J2eeModule mod = prov.getJ2eeModule();
                    MavenModule m = this.findMavenModule(a, mm);
                    J2eeModule module = J2eeModuleFactory.createJ2eeModule((J2eeModuleImplementation2)new ProxyJ2eeModule(mod, m, fileNameMapping));
                    if (m.pomIndex > -1 && toRet.size() > m.pomIndex) {
                        toRet.add(m.pomIndex, module);
                    } else {
                        toRet.add(module);
                    }
                    found = true;
                }
                if (found) continue block0;
                J2eeModule mod = J2eeModuleFactory.createJ2eeModule((J2eeModuleImplementation2)new NonProjectJ2eeModule(a, this.getJ2eePlatformVersion()));
                MavenModule m = this.findMavenModule(a, mm);
                J2eeModule module = J2eeModuleFactory.createJ2eeModule((J2eeModuleImplementation2)new ProxyJ2eeModule(mod, m, fileNameMapping));
                if (m.pomIndex > -1 && toRet.size() > m.pomIndex) {
                    toRet.add(m.pomIndex, module);
                    continue block0;
                }
                toRet.add(module);
                continue block0;
            }
        }
        return toRet.toArray(new J2eeModule[toRet.size()]);
    }

    public List<Project> getProjects() {
        MavenProject mp = this.mavenproject().getMavenProject();
        Set artifactSet = mp.getArtifacts();
        List deps = mp.getRuntimeDependencies();
        ArrayList<Project> toRet = new ArrayList<Project>();
        MavenModule[] mm = this.readPomModules();
        for (Dependency d : deps) {
            if (!"war".equals(d.getType()) && !"ejb".equals(d.getType()) && !"app-client".equals(d.getType())) continue;
            for (Artifact a : artifactSet) {
                URI uri;
                Project owner;
                if (!a.getGroupId().equals(d.getGroupId()) || !a.getArtifactId().equals(d.getArtifactId()) || !StringUtils.equals((String)a.getClassifier(), (String)d.getClassifier()) || (owner = FileOwnerQuery.getOwner((URI)(uri = Utilities.toURI((File)FileUtil.normalizeFile((File)a.getFile()))))) == null) continue;
                MavenModule m = this.findMavenModule(a, mm);
                if (m.pomIndex > -1 && toRet.size() > m.pomIndex) {
                    toRet.add(m.pomIndex, owner);
                    continue;
                }
                toRet.add(owner);
            }
        }
        if (toRet.isEmpty()) {
            FileObject parentFO = this.project.getProjectDirectory().getParent();
            for (FileObject childFO : parentFO.getChildren()) {
                if (childFO.isData()) continue;
                try {
                    Project childProject = ProjectManager.getDefault().findProject(childFO);
                    if (childProject == null || childProject.equals(this.project)) continue;
                    toRet.add(childProject);
                }
                catch (IOException | IllegalArgumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return toRet;
    }

    File getDDFile(String path) {
        URI dir = this.mavenproject().getEarAppDirectory();
        File fil = new File(new File(dir), path);
        if (!fil.getParentFile().exists()) {
            fil.getParentFile().mkdirs();
        }
        fil = FileUtil.normalizeFile((File)fil);
        return fil;
    }

    public void addModuleListener(ModuleListener ml) {
    }

    public void removeModuleListener(ModuleListener ml) {
    }

    public EjbChangeDescriptor getEjbChanges(long timestamp) {
        return new EjbChangeDescriptorImpl();
    }

    public boolean isManifestChanged(long timestamp) {
        return false;
    }

    public void addCarModule(Car arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public File getResourceDirectory() {
        File toRet = new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), "src" + File.separator + "main" + File.separator + "setup");
        return toRet;
    }

    public File getDeploymentConfigurationFile(String name) {
        if (name == null) {
            return null;
        }
        String path = this.provider.getConfigSupport().getContentRelativePath(name);
        if (path == null) {
            path = name;
        }
        return this.getDDFile(path);
    }

    public void addPropertyChangeListener(PropertyChangeListener arg0) {
    }

    public void removePropertyChangeListener(PropertyChangeListener arg0) {
    }

    public synchronized MetadataModel<ApplicationMetadata> getMetadataModel() {
        if (this.metadataModel == null) {
            this.metadataModel = MetadataModelFactory.createMetadataModel((MetadataModelImplementation)new ApplicationMetadataModelImpl(this.project));
        }
        return this.metadataModel;
    }

    public <T> MetadataModel<T> getMetadataModel(Class<T> type) {
        if (type == ApplicationMetadata.class) {
            MetadataModel<ApplicationMetadata> model = this.getMetadataModel();
            return model;
        }
        return null;
    }

    private MavenModule findMavenModule(Artifact art, MavenModule[] mm) {
        MavenModule toRet = null;
        for (MavenModule m : mm) {
            if (!art.getGroupId().equals(m.groupId) || !art.getArtifactId().equals(m.artifactId)) continue;
            m.artifact = art;
            toRet = m;
            break;
        }
        if (toRet == null) {
            toRet = new MavenModule();
            toRet.artifact = art;
            toRet.groupId = art.getGroupId();
            toRet.artifactId = art.getArtifactId();
            toRet.classifier = art.getClassifier();
        }
        return toRet;
    }

    private MavenModule[] readPomModules() {
        Plugin plug;
        MavenProject prj = this.mavenproject().getMavenProject();
        MavenModule[] toRet = new MavenModule[]{};
        if (prj.getBuildPlugins() == null) {
            return toRet;
        }
        for (Object obj : prj.getBuildPlugins()) {
            plug = (Plugin)obj;
            if (!"maven-ear-plugin".equals(plug.getArtifactId()) || !"org.apache.maven.plugins".equals(plug.getGroupId())) continue;
            toRet = this.checkConfiguration(prj, plug.getConfiguration());
        }
        if (toRet == null && prj.getPluginManagement() != null) {
            for (Object obj : prj.getPluginManagement().getPlugins()) {
                plug = (Plugin)obj;
                if (!"maven-ear-plugin".equals(plug.getArtifactId()) || !"org.apache.maven.plugins".equals(plug.getGroupId())) continue;
                toRet = this.checkConfiguration(prj, plug.getConfiguration());
                break;
            }
        }
        return toRet;
    }

    private MavenModule[] checkConfiguration(MavenProject prj, Object conf) {
        ArrayList<MavenModule> toRet = new ArrayList<MavenModule>();
        if (conf instanceof Xpp3Dom) {
            ExpressionEvaluator eval = PluginPropertyUtils.createEvaluator((Project)this.project);
            Xpp3Dom dom = (Xpp3Dom)conf;
            Xpp3Dom modules = dom.getChild("modules");
            if (modules != null) {
                int index = 0;
                for (Xpp3Dom module : modules.getChildren()) {
                    MavenModule mm = new MavenModule();
                    mm.type = module.getName();
                    if (module.getChildren() != null) {
                        for (Xpp3Dom param : module.getChildren()) {
                            String value = param.getValue();
                            if (value == null) continue;
                            try {
                                Object evaluated = eval.evaluate(value.trim());
                                value = evaluated != null ? "" + evaluated : value.trim();
                            }
                            catch (ExpressionEvaluationException expressionEvaluationException) {
                                // empty catch block
                            }
                            if ("groupId".equals(param.getName())) {
                                mm.groupId = value;
                                continue;
                            }
                            if ("artifactId".equals(param.getName())) {
                                mm.artifactId = value;
                                continue;
                            }
                            if ("classifier".equals(param.getName())) {
                                mm.classifier = value;
                                continue;
                            }
                            if ("uri".equals(param.getName())) {
                                mm.uri = value;
                                continue;
                            }
                            if ("bundleDir".equals(param.getName())) {
                                mm.bundleDir = value;
                                continue;
                            }
                            if ("bundleFileName".equals(param.getName())) {
                                mm.bundleFileName = value;
                                continue;
                            }
                            if (!"excluded".equals(param.getName())) continue;
                            mm.excluded = Boolean.valueOf(value);
                        }
                    }
                    mm.pomIndex = index++;
                    toRet.add(mm);
                }
            }
        }
        return toRet.toArray(new MavenModule[0]);
    }

    private static class ProxyJ2eeModule
    implements J2eeModuleImplementation2 {
        private final J2eeModule module;
        private final MavenModule mavenModule;
        private final String fileNameMapping;

        ProxyJ2eeModule(J2eeModule module, MavenModule mavModule, String fileNameMapping) {
            this.mavenModule = mavModule;
            this.module = module;
            this.fileNameMapping = fileNameMapping;
        }

        public String getModuleVersion() {
            return this.module.getModuleVersion();
        }

        public J2eeModule.Type getModuleType() {
            return this.module.getType();
        }

        public String getUrl() {
            return this.mavenModule.resolveUri(this.fileNameMapping);
        }

        public FileObject getArchive() throws IOException {
            return this.module.getArchive();
        }

        public Iterator<J2eeModule.RootedEntry> getArchiveContents() throws IOException {
            return this.module.getArchiveContents();
        }

        public FileObject getContentDirectory() throws IOException {
            return this.module.getContentDirectory();
        }

        public <T> MetadataModel<T> getMetadataModel(Class<T> type) {
            return this.module.getMetadataModel(type);
        }

        public File getResourceDirectory() {
            return this.module.getResourceDirectory();
        }

        public File getDeploymentConfigurationFile(String name) {
            return this.module.getDeploymentConfigurationFile(name);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.module.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.module.removePropertyChangeListener(listener);
        }

        public boolean equals(Object obj) {
            return this.module.equals(obj);
        }

        public int hashCode() {
            return this.module.hashCode();
        }
    }

    private static class MavenModule {
        String uri;
        Artifact artifact;
        String groupId;
        String artifactId;
        String type;
        String classifier;
        String bundleDir;
        String bundleFileName;
        int pomIndex = -1;
        boolean excluded = false;

        private MavenModule() {
        }

        String resolveUri(String fileNameMapping) {
            if (this.uri != null) {
                return this.uri;
            }
            String bDir = this.resolveBundleDir();
            return "/" + bDir + this.resolveBundleName(fileNameMapping);
        }

        String resolveBundleDir() {
            String toRet = this.bundleDir;
            if (toRet != null) {
                if ((toRet = toRet.replace('\\', '/')).startsWith("/")) {
                    toRet = toRet.substring(1, toRet.length());
                }
                if (toRet.length() > 0 && !toRet.endsWith("/")) {
                    toRet = toRet + "/";
                }
                return toRet;
            }
            return "";
        }

        String resolveBundleName(String fileNameMapping) {
            if (this.bundleFileName != null) {
                return this.bundleFileName;
            }
            if ("standard".equals(fileNameMapping)) {
                return this.artifact.getFile().getName();
            }
            if ("full".equals(fileNameMapping)) {
                String dashedGroupId = this.groupId.replace('.', '-');
                return dashedGroupId + "-" + this.artifact.getFile().getName();
            }
            if ("no-version".equals(fileNameMapping)) {
                String version = "-" + this.artifact.getBaseVersion();
                return this.artifact.getFile().getName().replaceAll(version, "");
            }
            return this.artifact.getFile().getName();
        }
    }

    private static final class RootedFileObject
    implements J2eeModule.RootedEntry {
        private FileObject file;
        private FileObject root;

        private RootedFileObject(FileObject root, FileObject file) {
            this.file = file;
            this.root = root;
        }

        public FileObject getFileObject() {
            return this.file;
        }

        public String getRelativePath() {
            return FileUtil.getRelativePath((FileObject)this.root, (FileObject)this.file);
        }
    }

    private static final class ContentIterator
    implements Iterator {
        private List<FileObject> filesUnderRoot;
        private FileObject root;

        private ContentIterator(FileObject root) {
            this.root = root;
            this.filesUnderRoot = new ArrayList<FileObject>();
            this.filesUnderRoot.add(root);
        }

        @Override
        public boolean hasNext() {
            return !this.filesUnderRoot.isEmpty();
        }

        public Object next() {
            FileObject nextFile = this.filesUnderRoot.get(0);
            this.filesUnderRoot.remove(0);
            if (nextFile.isFolder()) {
                nextFile.refresh();
                for (FileObject child : nextFile.getChildren()) {
                    this.filesUnderRoot.add(child);
                }
            }
            return new RootedFileObject(this.root, nextFile);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

