/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ClassPathProviderImpl
implements ClassPathProvider {
    public static final String BOOTCLASSPATH_PREPEND = "bootclasspath.prepend";
    private final NbModuleProject project;
    private final Object cpLock = new Object();
    private volatile ClassPath boot;
    private volatile ClassPath source;
    private volatile ClassPath compile;
    private volatile ClassPath execute;
    private volatile ClassPath processor;
    private volatile ClassPath testSource;
    private volatile ClassPath testCompile;
    private volatile ClassPath testExecute;
    private volatile ClassPath testProcessor;
    private volatile ClassPath funcTestSource;
    private volatile ClassPath funcTestCompile;
    private volatile ClassPath funcTestExecute;
    private volatile ClassPath funcTestProcessor;
    private volatile Map<FileObject, ClassPath> extraCompilationUnitsCompile = null;
    private volatile Map<FileObject, ClassPath> extraCompilationUnitsExecute = null;
    private static final Logger LOG = Logger.getLogger(ClassPathProviderImpl.class.getName());

    public ClassPathProviderImpl(NbModuleProject project) {
        this.project = project;
    }

    /*
     * Unable to fully structure code
     */
    @CheckForNull
    public ClassPath findClassPath(final @NonNull FileObject file, @NonNull String type) {
        block39: {
            block43: {
                block42: {
                    block41: {
                        block40: {
                            block38: {
                                if (type.equals("classpath/boot")) {
                                    bcp = this.boot;
                                    if (bcp == null) {
                                        bcp = this.runGuarded(new Mutex.Action<ClassPath>(){

                                            public ClassPath run() {
                                                if (ClassPathProviderImpl.this.boot == null) {
                                                    ClassPathImplementation prependCP = ClassPathProviderImpl.this.createPathFromProperty(ClassPathProviderImpl.BOOTCLASSPATH_PREPEND);
                                                    String loc = ClassPathProviderImpl.this.project.evaluator().getProperty("nbjdk.bootclasspath.modular");
                                                    if (loc != null) {
                                                        File locf = new File(loc);
                                                        for (JavaPlatform jp : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
                                                            File jpLocf = jp.getInstallFolders().stream().map(fo -> FileUtil.toFile((FileObject)fo)).filter(f -> f != null).findFirst().orElse(null);
                                                            if (!locf.equals(jpLocf)) continue;
                                                            ClassPathProviderImpl.this.boot = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{ClassPathFactory.createClassPath((ClassPathImplementation)prependCP), jp.getBootstrapLibraries()});
                                                            break;
                                                        }
                                                    } else {
                                                        ClassPathProviderImpl.this.boot = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupport.createProxyClassPathImplementation((ClassPathImplementation[])new ClassPathImplementation[]{prependCP, ClassPathProviderImpl.this.createPathFromProperty("nbjdk.bootclasspath"), ClassPathProviderImpl.this.createFxPath()}));
                                                    }
                                                }
                                                return ClassPathProviderImpl.this.boot;
                                            }
                                        });
                                    }
                                    return bcp;
                                }
                                srcDir = this.project.getSourceDirectory();
                                testSrcDir = this.project.getTestSourceDirectory("unit");
                                funcTestSrcDir = this.project.getTestSourceDirectory("qa-functional");
                                dir = this.project.getClassesDirectory();
                                classesDir = (dir = FileUtil.normalizeFile((File)dir)).exists() != false ? FileUtil.toFileObject((File)dir) : null;
                                dir = this.project.getTestClassesDirectory("unit");
                                dir = FileUtil.normalizeFile((File)dir);
                                testClassesDir = dir.exists() != false ? FileUtil.toFileObject((File)dir) : null;
                                generatedClasses = FileUtil.urlForArchiveOrDir((File)this.project.getGeneratedClassesDirectory());
                                generatedUnitTestClasses = FileUtil.urlForArchiveOrDir((File)this.project.getTestGeneratedClassesDirectory("unit"));
                                generatedFunctionalTestClasses = FileUtil.urlForArchiveOrDir((File)this.project.getTestGeneratedClassesDirectory("qa-functional"));
                                fileU = file.toURL().toString();
                                if (srcDir == null || generatedClasses == null || !FileUtil.isParentOf((FileObject)srcDir, (FileObject)file) && file != srcDir && !fileU.startsWith(generatedClasses.toString())) break block38;
                                if (type.equals("classpath/compile")) {
                                    ccp = this.compile;
                                    if (ccp == null) {
                                        ccp = this.runGuarded(new Mutex.Action<ClassPath>(){

                                            public ClassPath run() {
                                                if (ClassPathProviderImpl.this.compile == null) {
                                                    ClassPathProviderImpl.this.compile = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathProviderImpl.this.createCompileClasspath());
                                                    LOG.log(Level.FINE, "compile/execute-time classpath for file ''{0}'' (prj: {1}): {2}", new Object[]{file.getPath(), ClassPathProviderImpl.this.project, ClassPathProviderImpl.this.compile});
                                                }
                                                return ClassPathProviderImpl.this.compile;
                                            }
                                        });
                                    }
                                    return ccp;
                                }
                                if (type.equals("classpath/execute")) {
                                    ecp = this.execute;
                                    if (ecp == null) {
                                        ecp = this.runGuarded(new Mutex.Action<ClassPath>(){

                                            public ClassPath run() {
                                                if (ClassPathProviderImpl.this.execute == null) {
                                                    ClassPathProviderImpl.this.execute = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathProviderImpl.this.createExecuteClasspath());
                                                }
                                                return ClassPathProviderImpl.this.execute;
                                            }
                                        });
                                    }
                                    return ecp;
                                }
                                if (type.equals("classpath/source")) {
                                    scp = this.source;
                                    if (scp == null) {
                                        scp = this.runGuarded(new Mutex.Action<ClassPath>(){

                                            public ClassPath run() {
                                                if (ClassPathProviderImpl.this.source == null) {
                                                    ClassPathProviderImpl.this.source = ClassPathSupport.createClassPath((URL[])new URL[]{srcDir.toURL(), generatedClasses});
                                                }
                                                return ClassPathProviderImpl.this.source;
                                            }
                                        });
                                    }
                                    return scp;
                                }
                                if (type.equals("classpath/processor")) {
                                    pcp = this.processor;
                                    if (pcp == null) {
                                        pcp = this.runGuarded(new Mutex.Action<ClassPath>(){

                                            public ClassPath run() {
                                                if (ClassPathProviderImpl.this.processor == null) {
                                                    ClassPathProviderImpl.this.processor = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathProviderImpl.this.createProcessorPath());
                                                }
                                                return ClassPathProviderImpl.this.processor;
                                            }
                                        });
                                    }
                                    return pcp;
                                }
                                break block39;
                            }
                            if (testSrcDir == null || generatedUnitTestClasses == null || !FileUtil.isParentOf((FileObject)testSrcDir, (FileObject)file) && file != testSrcDir && !fileU.startsWith(generatedUnitTestClasses.toString())) break block40;
                            if (type.equals("classpath/compile")) {
                                tcp = this.testCompile;
                                if (tcp == null) {
                                    tcp = this.runGuarded(new Mutex.Action<ClassPath>(){

                                        public ClassPath run() {
                                            if (ClassPathProviderImpl.this.testCompile == null) {
                                                ClassPathProviderImpl.this.testCompile = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathProviderImpl.this.createTestCompileClasspath("unit"));
                                                LOG.log(Level.FINE, "compile-time classpath for tests for file ''{0}'' (prj: {1}): {2}", new Object[]{file.getPath(), ClassPathProviderImpl.this.project, ClassPathProviderImpl.this.testCompile});
                                            }
                                            return ClassPathProviderImpl.this.testCompile;
                                        }
                                    });
                                }
                                return tcp;
                            }
                            if (type.equals("classpath/execute")) {
                                te = this.testExecute;
                                if (te == null) {
                                    te = this.runGuarded(new Mutex.Action<ClassPath>(){

                                        public ClassPath run() {
                                            if (ClassPathProviderImpl.this.testExecute == null) {
                                                ClassPathProviderImpl.this.testExecute = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathProviderImpl.this.createTestExecuteClasspath("unit"));
                                                LOG.log(Level.FINE, "runtime classpath for tests for file ''{0}'' (prj: {1}): {2}", new Object[]{file.getPath(), ClassPathProviderImpl.this.project, ClassPathProviderImpl.this.testExecute});
                                            }
                                            return ClassPathProviderImpl.this.testExecute;
                                        }
                                    });
                                }
                                return te;
                            }
                            if (type.equals("classpath/source")) {
                                tscp = this.testSource;
                                if (tscp == null) {
                                    tscp = this.runGuarded(new Mutex.Action<ClassPath>(){

                                        public ClassPath run() {
                                            if (ClassPathProviderImpl.this.testSource == null) {
                                                ClassPathProviderImpl.this.testSource = ClassPathSupport.createClassPath((URL[])new URL[]{testSrcDir.toURL(), generatedUnitTestClasses});
                                            }
                                            return ClassPathProviderImpl.this.testSource;
                                        }
                                    });
                                }
                                return tscp;
                            }
                            if (type.equals("classpath/processor")) {
                                tp = this.testProcessor;
                                if (tp == null) {
                                    tp = this.runGuarded(new Mutex.Action<ClassPath>(){

                                        public ClassPath run() {
                                            if (ClassPathProviderImpl.this.testProcessor == null) {
                                                ClassPathProviderImpl.this.testProcessor = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathProviderImpl.this.createTestProcessorPath("unit"));
                                            }
                                            return ClassPathProviderImpl.this.testProcessor;
                                        }
                                    });
                                }
                                return tp;
                            }
                            break block39;
                        }
                        if (funcTestSrcDir == null || generatedFunctionalTestClasses == null || !FileUtil.isParentOf((FileObject)funcTestSrcDir, (FileObject)file) && file != funcTestSrcDir && !fileU.startsWith(generatedFunctionalTestClasses.toString())) break block41;
                        if (type.equals("classpath/source")) {
                            fts = this.funcTestSource;
                            if (fts == null) {
                                fts = this.runGuarded(new Mutex.Action<ClassPath>(){

                                    public ClassPath run() {
                                        if (ClassPathProviderImpl.this.funcTestSource == null) {
                                            ClassPathProviderImpl.this.funcTestSource = ClassPathSupport.createClassPath((URL[])new URL[]{funcTestSrcDir.toURL(), generatedFunctionalTestClasses});
                                        }
                                        return ClassPathProviderImpl.this.funcTestSource;
                                    }
                                });
                            }
                            return fts;
                        }
                        if (type.equals("classpath/compile")) {
                            ftc = this.funcTestCompile;
                            if (ftc == null) {
                                ftc = this.runGuarded(new Mutex.Action<ClassPath>(){

                                    public ClassPath run() {
                                        if (ClassPathProviderImpl.this.funcTestCompile == null) {
                                            ClassPathProviderImpl.this.funcTestCompile = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathProviderImpl.this.createTestCompileClasspath("qa-functional"));
                                            LOG.log(Level.FINE, "compile-time classpath for func tests for file ''{0}'' (prj: {1}): {2}", new Object[]{file.getPath(), ClassPathProviderImpl.this.project, ClassPathProviderImpl.this.funcTestCompile});
                                        }
                                        return ClassPathProviderImpl.this.funcTestCompile;
                                    }
                                });
                            }
                            return ftc;
                        }
                        if (type.equals("classpath/execute")) {
                            fte = this.funcTestExecute;
                            if (fte == null) {
                                fte = this.runGuarded(new Mutex.Action<ClassPath>(){

                                    public ClassPath run() {
                                        if (ClassPathProviderImpl.this.funcTestExecute == null) {
                                            ClassPathProviderImpl.this.funcTestExecute = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathProviderImpl.this.createTestExecuteClasspath("qa-functional"));
                                        }
                                        return ClassPathProviderImpl.this.funcTestExecute;
                                    }
                                });
                            }
                            return fte;
                        }
                        if (type.equals("classpath/processor")) {
                            ftp = this.funcTestProcessor;
                            if (ftp == null) {
                                ftp = this.runGuarded(new Mutex.Action<ClassPath>(){

                                    public ClassPath run() {
                                        if (ClassPathProviderImpl.this.funcTestProcessor == null) {
                                            ClassPathProviderImpl.this.funcTestProcessor = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathProviderImpl.this.createTestProcessorPath("qa-functional"));
                                        }
                                        return ClassPathProviderImpl.this.funcTestProcessor;
                                    }
                                });
                            }
                            return ftp;
                        }
                        break block39;
                    }
                    if (classesDir == null || !classesDir.equals(file) && !FileUtil.isParentOf((FileObject)classesDir, (FileObject)file)) break block42;
                    if ("classpath/execute".equals(type)) {
                        roots = new ArrayList<PathResourceImplementation>();
                        roots.add(ClassPathSupport.createResource((URL)classesDir.toURL()));
                        roots.addAll(this.createCompileClasspath().getResources());
                        return ClassPathSupport.createClassPath(roots);
                    }
                    break block39;
                }
                if (testClassesDir == null || !testClassesDir.equals(file) && !FileUtil.isParentOf((FileObject)testClassesDir, (FileObject)file)) break block43;
                if ("classpath/execute".equals(type)) {
                    te = this.testExecute;
                    if (te == null) {
                        te = this.runGuarded(new Mutex.Action<ClassPath>(){

                            public ClassPath run() {
                                if (ClassPathProviderImpl.this.testExecute == null) {
                                    ClassPathProviderImpl.this.testExecute = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathProviderImpl.this.createTestExecuteClasspath("unit"));
                                    LOG.log(Level.FINE, "runtime classpath for tests for file ''{0}'' (prj: {1}): {2}", new Object[]{file.getPath(), ClassPathProviderImpl.this.project, ClassPathProviderImpl.this.testExecute});
                                }
                                return ClassPathProviderImpl.this.testExecute;
                            }
                        });
                    }
                    return te;
                }
                break block39;
            }
            if (FileUtil.getArchiveFile((FileObject)file) == null) ** GOTO lbl-1000
            moduleJar = this.project.getModuleJarLocation();
            if (FileUtil.toFile((FileObject)FileUtil.getArchiveFile((FileObject)file)).equals(moduleJar)) {
                if ("classpath/execute".equals(type)) {
                    roots = new ArrayList<PathResourceImplementation>();
                    roots.add(ClassPathSupport.createResource((URL)FileUtil.urlForArchiveOrDir((File)moduleJar)));
                    roots.addAll(this.createCompileClasspath().getResources());
                    return ClassPathSupport.createClassPath(roots);
                }
            } else lbl-1000:
            // 2 sources

            {
                this.calculateExtraCompilationUnits();
                for (Map.Entry<FileObject, ClassPath> entry : this.extraCompilationUnitsCompile.entrySet()) {
                    pkgroot = entry.getKey();
                    if (!FileUtil.isParentOf((FileObject)pkgroot, (FileObject)file) && file != pkgroot) continue;
                    if (type.equals("classpath/compile")) {
                        return entry.getValue();
                    }
                    if (type.equals("classpath/execute")) {
                        return this.extraCompilationUnitsExecute.get(pkgroot);
                    }
                    if (!type.equals("classpath/source")) break;
                    return ClassPathSupport.createClassPath((FileObject[])new FileObject[]{pkgroot});
                }
            }
        }
        if (type.equals("classpath/source") && (properties = this.project.evaluator().getProperties()) != null) {
            for (Map.Entry<K, V> entry : properties.entrySet()) {
                if (!((String)entry.getKey()).startsWith("source.reference.") || (sourceReference = this.project.getHelper().resolveFileObject((String)entry.getValue())) == null) continue;
                if (FileUtil.isArchiveFile((FileObject)sourceReference)) {
                    sourceReference = FileUtil.getArchiveRoot((FileObject)sourceReference);
                }
                if (sourceReference == null || sourceReference != file && !FileUtil.isParentOf((FileObject)sourceReference, (FileObject)file)) continue;
                return ClassPathSupport.createClassPath((FileObject[])new FileObject[]{sourceReference});
            }
        }
        return null;
    }

    private ClassPathImplementation createPathFromProperty(String prop) {
        return ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.project.getProjectDirectoryFile(), (PropertyEvaluator)this.project.evaluator(), (String[])new String[]{prop});
    }

    @NonNull
    private ClassPathImplementation createFxPath() {
        return new FxPathImpl(this.project);
    }

    private ClassPathImplementation createCompileClasspath() {
        return this.createPathFromProperty("cp");
    }

    private void addPathFromProjectEvaluated(List<PathResourceImplementation> entries, String path) {
        if (path != null) {
            for (String piece : PropertyUtils.tokenizePath((String)path)) {
                URL url = FileUtil.urlForArchiveOrDir((File)this.project.getHelper().resolveFile(piece));
                if (url == null) continue;
                entries.add(ClassPathSupport.createResource((URL)url));
            }
        }
    }

    private ClassPathImplementation createTestCompileClasspath(String testType) {
        return this.createPathFromProperty("test." + testType + ".cp");
    }

    private ClassPathImplementation createTestExecuteClasspath(String testType) {
        return this.createPathFromProperty("test." + testType + ".run.cp");
    }

    @NonNull
    private ClassPathImplementation createTestProcessorPath(@NonNull String testType) {
        return new FilteredClassPathImplementation(this.createTestExecuteClasspath(testType), this.project.getHelper(), this.project.evaluator(), MessageFormat.format("build.test.{0}.classes.dir", testType));
    }

    private ClassPathImplementation createExecuteClasspath() {
        return this.createPathFromProperty("run.cp");
    }

    @NonNull
    private ClassPathImplementation createProcessorPath() {
        return new FilteredClassPathImplementation(this.createExecuteClasspath(), this.project.getHelper(), this.project.evaluator(), "build.classes.dir");
    }

    private void calculateExtraCompilationUnits() {
        if (this.extraCompilationUnitsCompile != null) {
            return;
        }
        HashMap<FileObject, ClassPath> _extraCompilationUnitsCompile = new HashMap<FileObject, ClassPath>();
        HashMap<FileObject, ClassPath> _extraCompilationUnitsExecute = new HashMap<FileObject, ClassPath>();
        for (Map.Entry<FileObject, Element> entry : this.project.getExtraCompilationUnits().entrySet()) {
            final FileObject pkgroot = entry.getKey();
            Element pkgrootEl = entry.getValue();
            Element classpathEl = XMLUtil.findElement((Element)pkgrootEl, (String)"classpath", (String)"http://www.netbeans.org/ns/nb-module-project/3");
            assert (classpathEl != null) : "no <classpath> in " + pkgrootEl;
            final String classpathS = XMLUtil.findText((Node)classpathEl);
            if (classpathS == null) {
                _extraCompilationUnitsCompile.put(pkgroot, ClassPathSupport.createClassPath((URL[])new URL[0]));
                _extraCompilationUnitsExecute.put(pkgroot, ClassPathSupport.createClassPath((URL[])new URL[0]));
                continue;
            }
            class CPI
            implements ClassPathImplementation,
            PropertyChangeListener,
            AntProjectListener {
                final Set<String> relevantProperties = new HashSet<String>();
                final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
                String cpS = classpathS;

                CPI() {
                    ClassPathProviderImpl.this.project.evaluator().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)ClassPathProviderImpl.this.project.evaluator()));
                    ClassPathProviderImpl.this.project.getHelper().addAntProjectListener((AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)this, (Object)ClassPathProviderImpl.this.project.getHelper()));
                    Matcher m = Pattern.compile("\\$\\{([^{}]+)\\}").matcher(this.cpS);
                    while (m.find()) {
                        this.relevantProperties.add(m.group(1));
                    }
                }

                public List<? extends PathResourceImplementation> getResources() {
                    ArrayList resources = new ArrayList();
                    ClassPathProviderImpl.this.addPathFromProjectEvaluated(resources, ClassPathProviderImpl.this.project.evaluator().evaluate(this.cpS));
                    return resources;
                }

                public void addPropertyChangeListener(PropertyChangeListener listener) {
                    this.pcs.addPropertyChangeListener(listener);
                }

                public void removePropertyChangeListener(PropertyChangeListener listener) {
                    this.pcs.removePropertyChangeListener(listener);
                }

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (this.relevantProperties.contains(evt.getPropertyName())) {
                        this.pcs.firePropertyChange("resources", null, null);
                    }
                }

                public void configurationXmlChanged(AntProjectEvent ev) {
                    Element pkgrootEl = ClassPathProviderImpl.this.project.getExtraCompilationUnits().get(pkgroot);
                    Element classpathEl = XMLUtil.findElement((Element)pkgrootEl, (String)"classpath", (String)"http://www.netbeans.org/ns/nb-module-project/3");
                    assert (classpathEl != null) : "no <classpath> in " + pkgrootEl;
                    this.cpS = XMLUtil.findText((Node)classpathEl);
                    this.pcs.firePropertyChange("resources", null, null);
                }

                public void propertiesChanged(AntProjectEvent ev) {
                }
            }
            CPI ecuCompile = new CPI();
            _extraCompilationUnitsCompile.put(pkgroot, ClassPathFactory.createClassPath((ClassPathImplementation)ecuCompile));
            ArrayList<PathResourceImplementation> extraEntries = new ArrayList<PathResourceImplementation>();
            for (Element kid : XMLUtil.findSubElements((Element)pkgrootEl)) {
                if (!kid.getLocalName().equals("built-to")) continue;
                String rawtext = XMLUtil.findText((Node)kid);
                assert (rawtext != null) : "Null content for <built-to> in " + this.project;
                String text = this.project.evaluator().evaluate(rawtext);
                if (text == null) continue;
                this.addPathFromProjectEvaluated(extraEntries, text);
            }
            _extraCompilationUnitsExecute.put(pkgroot, ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupport.createProxyClassPathImplementation((ClassPathImplementation[])new ClassPathImplementation[]{ecuCompile, ClassPathSupport.createClassPathImplementation(extraEntries)})));
        }
        this.extraCompilationUnitsExecute = Collections.unmodifiableMap(_extraCompilationUnitsExecute);
        this.extraCompilationUnitsCompile = Collections.unmodifiableMap(_extraCompilationUnitsCompile);
    }

    public ClassPath[] getProjectClassPaths(String type) {
        FileObject srcDir;
        if ("classpath/boot".equals(type) && (srcDir = this.project.getSourceDirectory()) != null) {
            return new ClassPath[]{this.findClassPath(srcDir, "classpath/boot")};
        }
        ArrayList<ClassPath> paths = new ArrayList<ClassPath>(3);
        if ("classpath/compile".equals(type)) {
            FileObject srcDir2 = this.project.getSourceDirectory();
            if (srcDir2 != null) {
                paths.add(this.findClassPath(srcDir2, "classpath/compile"));
            }
            for (String testType : this.project.supportedTestTypes()) {
                FileObject testSrcDir = this.project.getTestSourceDirectory(testType);
                if (testSrcDir == null) continue;
                paths.add(this.findClassPath(testSrcDir, "classpath/compile"));
            }
            this.calculateExtraCompilationUnits();
            paths.addAll(this.extraCompilationUnitsCompile.values());
        } else if ("classpath/execute".equals(type)) {
            FileObject srcDir3 = this.project.getSourceDirectory();
            if (srcDir3 != null) {
                paths.add(this.findClassPath(srcDir3, "classpath/execute"));
            }
            for (String testType : this.project.supportedTestTypes()) {
                FileObject testSrcDir = this.project.getTestSourceDirectory(testType);
                if (testSrcDir == null) continue;
                paths.add(this.findClassPath(testSrcDir, "classpath/execute"));
            }
            this.calculateExtraCompilationUnits();
            paths.addAll(this.extraCompilationUnitsExecute.values());
        } else if ("classpath/source".equals(type)) {
            FileObject srcDir4 = this.project.getSourceDirectory();
            if (srcDir4 != null) {
                paths.add(this.findClassPath(srcDir4, "classpath/source"));
            }
            for (String testType : this.project.supportedTestTypes()) {
                FileObject testSrcDir = this.project.getTestSourceDirectory(testType);
                if (testSrcDir == null) continue;
                paths.add(this.findClassPath(testSrcDir, "classpath/source"));
            }
            this.calculateExtraCompilationUnits();
            for (FileObject root : this.extraCompilationUnitsCompile.keySet()) {
                paths.add(ClassPathSupport.createClassPath((FileObject[])new FileObject[]{root}));
            }
        }
        return paths.toArray(new ClassPath[paths.size()]);
    }

    private <T> T runGuarded(final @NonNull Mutex.Action<T> action) {
        return (T)ProjectManager.mutex().readAccess(new Mutex.Action<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T run() {
                Object object = ClassPathProviderImpl.this.cpLock;
                synchronized (object) {
                    return action.run();
                }
            }
        });
    }

    private static final class FxPathImpl
    implements ClassPathImplementation,
    PropertyChangeListener {
        private final PropertyChangeSupport listeners = new PropertyChangeSupport(this);
        private final NbModuleProject project;
        private volatile List<? extends PathResourceImplementation> jfx;

        FxPathImpl(@NonNull NbModuleProject project) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            this.project = project;
            this.project.evaluator().addPropertyChangeListener((PropertyChangeListener)this);
        }

        @NonNull
        public List<? extends PathResourceImplementation> getResources() {
            List<Object> res = this.jfx;
            if (res == null) {
                PathResourceImplementation pr = null;
                try {
                    for (ModuleEntry moduleEntryIter : this.project.getModuleList().getAllEntries()) {
                        File jdk7;
                        File jre;
                        File jdk8;
                        if (!moduleEntryIter.getCodeNameBase().equals("org.netbeans.libs.javafx") || (jdk8 = new File(new File(new File(jre = new File(System.getProperty("java.home")), "lib"), "ext"), "jfxrt.jar")).exists() || !(jdk7 = new File(new File(jre, "lib"), "jfxrt.jar")).exists() || !FileUtil.isArchiveFile((FileObject)FileUtil.toFileObject((File)jdk7))) continue;
                        pr = ClassPathSupport.createResource((URL)FileUtil.getArchiveRoot((URL)Utilities.toURI((File)jdk7).toURL()));
                    }
                }
                catch (IOException ioe) {
                    LOG.log(Level.INFO, null, ioe);
                }
                this.jfx = pr == null ? Collections.emptyList() : Collections.singletonList(pr);
                res = this.jfx;
            }
            assert (res != null);
            return res;
        }

        public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.listeners.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.listeners.removePropertyChangeListener(listener);
        }

        @Override
        public void propertyChange(@NonNull PropertyChangeEvent evt) {
            this.jfx = null;
            this.listeners.firePropertyChange("resources", null, null);
        }
    }

    private static final class FilteredClassPathImplementation
    implements ClassPathImplementation,
    PropertyChangeListener {
        private final ClassPathImplementation delegate;
        private final AntProjectHelper helper;
        private final PropertyEvaluator eval;
        private final String filteredProp;
        private final AtomicReference<List<PathResourceImplementation>> cache;
        private final PropertyChangeSupport listeners;

        FilteredClassPathImplementation(@NonNull ClassPathImplementation delegate, @NonNull AntProjectHelper helper, @NonNull PropertyEvaluator eval, @NonNull String filteredProp) {
            Parameters.notNull((CharSequence)"delegate", (Object)delegate);
            Parameters.notNull((CharSequence)"helper", (Object)helper);
            Parameters.notNull((CharSequence)"eval", (Object)eval);
            Parameters.notNull((CharSequence)"filteredProp", (Object)filteredProp);
            this.delegate = delegate;
            this.helper = helper;
            this.eval = eval;
            this.filteredProp = filteredProp;
            this.cache = new AtomicReference();
            this.listeners = new PropertyChangeSupport(this);
            this.delegate.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.delegate));
            this.eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.eval));
        }

        @NonNull
        public List<? extends PathResourceImplementation> getResources() {
            List<PathResourceImplementation> cur;
            List<PathResourceImplementation> res = this.cache.get();
            if (res != null) {
                return res;
            }
            String propVal = this.eval.getProperty(this.filteredProp);
            File propFile = propVal == null ? null : this.helper.resolveFile(propVal);
            URL propURL = null;
            try {
                if (propFile != null) {
                    propURL = Utilities.toURI((File)propFile).toURL();
                }
            }
            catch (MalformedURLException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            List resources = this.delegate.getResources();
            res = new ArrayList<PathResourceImplementation>(resources.size());
            block2: for (PathResourceImplementation pri : resources) {
                if (propURL != null) {
                    URL[] roots;
                    for (URL root : roots = pri.getRoots()) {
                        if (propURL.equals(root) && roots.length == 1) continue block2;
                    }
                }
                res.add(pri);
            }
            if (!this.cache.compareAndSet(null, res = Collections.unmodifiableList(res)) && (cur = this.cache.get()) != null) {
                res = cur;
            }
            return res;
        }

        public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.listeners.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.listeners.removePropertyChangeListener(listener);
        }

        @Override
        public void propertyChange(@NonNull PropertyChangeEvent event) {
            String propName = event.getPropertyName();
            if (propName == null || "resources".equals(propName) || this.filteredProp.equals(propName)) {
                this.reset();
            }
        }

        private void reset() {
            this.cache.set(null);
            this.listeners.firePropertyChange("resources", null, null);
        }
    }
}

