/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks;

import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.tasks.Category;
import org.netbeans.modules.bugtracking.tasks.dashboard.DashboardViewer;
import org.netbeans.modules.bugtracking.ui.search.QuickSearchComboBar;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class QuickSearchPanel
extends JPanel {
    private List<Category> categories;
    private final QuickSearchComboBar quickIssueSearch;
    private JComboBox cboxCategory;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JComboBox placeholderTask;

    public QuickSearchPanel(RepositoryImpl repositoryImpl) {
        this.initComponents();
        this.quickIssueSearch = new QuickSearchComboBar(this);
        GroupLayout layout = (GroupLayout)this.getLayout();
        this.quickIssueSearch.setRepository(repositoryImpl);
        layout.replace(this.placeholderTask, this.quickIssueSearch);
    }

    private DefaultComboBoxModel getCategoryModel() {
        this.categories = DashboardViewer.getInstance().getCategories(true, false);
        String[] catNames = new String[this.categories.size() + 1];
        catNames[0] = "<" + NbBundle.getMessage(QuickSearchPanel.class, (String)"LBL_NoCategory") + ">";
        for (int i = 0; i < this.categories.size(); ++i) {
            catNames[i + 1] = this.categories.get(i).getName();
        }
        return new DefaultComboBoxModel<String>(catNames);
    }

    private void initComponents() {
        this.cboxCategory = new JComboBox();
        this.jLabel3 = new JLabel();
        this.placeholderTask = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.cboxCategory.setModel(this.getCategoryModel());
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.jLabel3.text"));
        this.placeholderTask.setModel(new DefaultComboBoxModel<String>(new String[]{"Item1", "Item 2"}));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.jLabel5.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.jLabel1.text"));
        this.jLabel1.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.jLabel2.text"));
        this.jLabel2.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cboxCategory, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.placeholderTask, 0, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel5)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jLabel2, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.placeholderTask, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cboxCategory, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addContainerGap(68, Short.MAX_VALUE)));
    }

    public void addQuickSearchListener(ChangeListener listener) {
        this.quickIssueSearch.addChangeListener(listener);
    }

    public void removeQuickSearchListener(ChangeListener listener) {
        this.quickIssueSearch.removeChangeListener(listener);
    }

    public Category getSelectedCategory() {
        int selectedIndex = this.cboxCategory.getSelectedIndex();
        if (selectedIndex == 0) {
            return null;
        }
        return this.categories.get(selectedIndex - 1);
    }

    public IssueImpl getSelectedTask() {
        return this.quickIssueSearch.getIssueImpl();
    }
}

