/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.http.client;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.mock.http.MockHttpInputMessage;
import org.springframework.util.Assert;

public class MockClientHttpResponse
extends MockHttpInputMessage
implements ClientHttpResponse {
    private final HttpStatus status;

    public MockClientHttpResponse(byte[] body, HttpStatus statusCode) {
        super(body);
        Assert.notNull((Object)statusCode, (String)"HttpStatus is required");
        this.status = statusCode;
    }

    public MockClientHttpResponse(InputStream body, HttpStatus statusCode) {
        super(body);
        Assert.notNull((Object)statusCode, (String)"HttpStatus is required");
        this.status = statusCode;
    }

    public HttpStatus getStatusCode() throws IOException {
        return this.status;
    }

    public int getRawStatusCode() throws IOException {
        return this.status.value();
    }

    public String getStatusText() throws IOException {
        return this.status.getReasonPhrase();
    }

    public void close() {
    }
}

