/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;

public class MatchBindingsComputer
extends TreeScanner {
    public static final MatchBindings EMPTY = new MatchBindings(List.nil(), List.nil());
    protected static final Context.Key<MatchBindingsComputer> matchBindingsComputerKey = new Context.Key();
    private final Log log;

    public static MatchBindingsComputer instance(Context context) {
        MatchBindingsComputer instance = context.get(matchBindingsComputerKey);
        if (instance == null) {
            instance = new MatchBindingsComputer(context);
        }
        return instance;
    }

    protected MatchBindingsComputer(Context context) {
        this.log = Log.instance(context);
    }

    public MatchBindings conditional(JCTree tree, MatchBindings condBindings, MatchBindings trueBindings, MatchBindings falseBindings) {
        if (condBindings == EMPTY && trueBindings == EMPTY && falseBindings == EMPTY) {
            return EMPTY;
        }
        JCDiagnostic.DiagnosticPosition pos = tree.pos();
        List<Symbol.BindingSymbol> xTzT = this.intersection(pos, condBindings.bindingsWhenTrue, falseBindings.bindingsWhenTrue);
        List<Symbol.BindingSymbol> xFyT = this.intersection(pos, condBindings.bindingsWhenFalse, trueBindings.bindingsWhenTrue);
        List<Symbol.BindingSymbol> yTzT = this.intersection(pos, trueBindings.bindingsWhenTrue, falseBindings.bindingsWhenTrue);
        List<Symbol.BindingSymbol> xTzF = this.intersection(pos, condBindings.bindingsWhenTrue, falseBindings.bindingsWhenFalse);
        List<Symbol.BindingSymbol> xFyF = this.intersection(pos, condBindings.bindingsWhenFalse, trueBindings.bindingsWhenFalse);
        List<Symbol.BindingSymbol> yFzF = this.intersection(pos, trueBindings.bindingsWhenFalse, falseBindings.bindingsWhenFalse);
        List<Symbol.BindingSymbol> bindingsWhenTrue = this.union(pos, yTzT, xTzT, xFyT);
        List<Symbol.BindingSymbol> bindingsWhenFalse = this.union(pos, yFzF, xTzF, xFyF);
        return new MatchBindings(bindingsWhenTrue, bindingsWhenFalse);
    }

    public MatchBindings unary(JCTree tree, MatchBindings bindings) {
        if (bindings == EMPTY || !tree.hasTag(JCTree.Tag.NOT)) {
            return bindings;
        }
        return new MatchBindings(bindings.bindingsWhenFalse, bindings.bindingsWhenTrue);
    }

    public MatchBindings binary(JCTree tree, MatchBindings lhsBindings, MatchBindings rhsBindings) {
        switch (tree.getTag()) {
            case AND: {
                return this.andOperation(tree.pos(), lhsBindings, rhsBindings);
            }
            case OR: {
                List<Symbol.BindingSymbol> bindingsWhenTrue = this.intersection(tree.pos(), lhsBindings.bindingsWhenTrue, rhsBindings.bindingsWhenTrue);
                List<Symbol.BindingSymbol> bindingsWhenFalse = this.union(tree.pos(), lhsBindings.bindingsWhenFalse, rhsBindings.bindingsWhenFalse);
                return new MatchBindings(bindingsWhenTrue, bindingsWhenFalse);
            }
        }
        return EMPTY;
    }

    public MatchBindings caseGuard(JCTree.JCCase tree, MatchBindings patternBindings, MatchBindings guardBindings) {
        return this.andOperation(tree.pos(), patternBindings, guardBindings);
    }

    public MatchBindings andOperation(JCDiagnostic.DiagnosticPosition pos, MatchBindings lhsBindings, MatchBindings rhsBindings) {
        List<Symbol.BindingSymbol> bindingsWhenTrue = this.union(pos, lhsBindings.bindingsWhenTrue, rhsBindings.bindingsWhenTrue);
        List<Symbol.BindingSymbol> bindingsWhenFalse = this.intersection(pos, lhsBindings.bindingsWhenFalse, rhsBindings.bindingsWhenFalse);
        return new MatchBindings(bindingsWhenTrue, bindingsWhenFalse);
    }

    public MatchBindings switchCase(JCTree tree, MatchBindings prevBindings, MatchBindings currentBindings) {
        if (prevBindings == null) {
            return currentBindings;
        }
        if (prevBindings.nullPattern) {
            return currentBindings;
        }
        if (currentBindings.nullPattern) {
            return prevBindings;
        }
        return new MatchBindings(this.intersection(tree.pos(), prevBindings.bindingsWhenTrue, currentBindings.bindingsWhenTrue), this.intersection(tree.pos(), prevBindings.bindingsWhenFalse, currentBindings.bindingsWhenFalse));
    }

    public MatchBindings finishBindings(JCTree tree, MatchBindings matchBindings) {
        switch (tree.getTag()) {
            case AND: 
            case OR: 
            case NOT: 
            case BINDINGPATTERN: 
            case PARENTHESIZEDPATTERN: 
            case TYPETEST: 
            case PARENS: 
            case RECORDPATTERN: 
            case CONDEXPR: {
                return matchBindings;
            }
        }
        return EMPTY;
    }

    private List<Symbol.BindingSymbol> intersection(JCDiagnostic.DiagnosticPosition pos, List<Symbol.BindingSymbol> lhsBindings, List<Symbol.BindingSymbol> rhsBindings) {
        List<Symbol.BindingSymbol> list = List.nil();
        for (Symbol.BindingSymbol v1 : lhsBindings) {
            for (Symbol.BindingSymbol v2 : rhsBindings) {
                if (v1.name != v2.name || (v1.flags() & 0x40000000000L) != 0L || (v2.flags() & 0x40000000000L) != 0L) continue;
                this.log.error(pos, CompilerProperties.Errors.MatchBindingExists);
                v2.flags_field |= 0x40000000000L;
                list = list.append(v2);
            }
        }
        return list;
    }

    @SafeVarargs
    private final List<Symbol.BindingSymbol> union(JCDiagnostic.DiagnosticPosition pos, List<Symbol.BindingSymbol> lhsBindings, List<Symbol.BindingSymbol> ... rhsBindings_s) {
        List<Symbol.BindingSymbol> list = lhsBindings;
        for (List<Symbol.BindingSymbol> rhsBindings : rhsBindings_s) {
            for (Symbol.BindingSymbol v : rhsBindings) {
                for (Symbol.BindingSymbol ov : list) {
                    if (ov.name != v.name || (ov.flags() & 0x40000000000L) != 0L || (v.flags() & 0x40000000000L) != 0L) continue;
                    this.log.error(pos, CompilerProperties.Errors.MatchBindingExists);
                    v.flags_field |= 0x40000000000L;
                }
                list = list.append(v);
            }
        }
        return list;
    }

    public static class MatchBindings {
        public final List<Symbol.BindingSymbol> bindingsWhenTrue;
        public final List<Symbol.BindingSymbol> bindingsWhenFalse;
        public final boolean nullPattern;

        public MatchBindings(List<Symbol.BindingSymbol> bindingsWhenTrue, List<Symbol.BindingSymbol> bindingsWhenFalse) {
            this(bindingsWhenTrue, bindingsWhenFalse, false);
        }

        public MatchBindings(List<Symbol.BindingSymbol> bindingsWhenTrue, List<Symbol.BindingSymbol> bindingsWhenFalse, boolean nullPattern) {
            this.bindingsWhenTrue = bindingsWhenTrue;
            this.bindingsWhenFalse = bindingsWhenFalse;
            this.nullPattern = nullPattern;
        }
    }
}

