/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.DbSystemUpgradeHistoryEntrySummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListDbSystemUpgradeHistoryEntriesRequest
extends BmcRequest<Void> {
    private String dbSystemId;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private DbSystemUpgradeHistoryEntrySummary.Action upgradeAction;
    private DbSystemUpgradeHistoryEntrySummary.LifecycleState lifecycleState;
    private String opcRequestId;

    @ConstructorProperties(value={"dbSystemId", "limit", "page", "sortOrder", "sortBy", "upgradeAction", "lifecycleState", "opcRequestId"})
    ListDbSystemUpgradeHistoryEntriesRequest(String dbSystemId, Integer limit, String page, SortOrder sortOrder, SortBy sortBy, DbSystemUpgradeHistoryEntrySummary.Action upgradeAction, DbSystemUpgradeHistoryEntrySummary.LifecycleState lifecycleState, String opcRequestId) {
        this.dbSystemId = dbSystemId;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.upgradeAction = upgradeAction;
        this.lifecycleState = lifecycleState;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().dbSystemId(this.dbSystemId).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).upgradeAction(this.upgradeAction).lifecycleState(this.lifecycleState).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "ListDbSystemUpgradeHistoryEntriesRequest(super=" + super.toString() + ", dbSystemId=" + this.getDbSystemId() + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ", sortOrder=" + (Object)((Object)this.getSortOrder()) + ", sortBy=" + (Object)((Object)this.getSortBy()) + ", upgradeAction=" + (Object)((Object)this.getUpgradeAction()) + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListDbSystemUpgradeHistoryEntriesRequest)) {
            return false;
        }
        ListDbSystemUpgradeHistoryEntriesRequest other = (ListDbSystemUpgradeHistoryEntriesRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$dbSystemId = this.getDbSystemId();
        String other$dbSystemId = other.getDbSystemId();
        if (this$dbSystemId == null ? other$dbSystemId != null : !this$dbSystemId.equals(other$dbSystemId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        SortOrder this$sortOrder = this.getSortOrder();
        SortOrder other$sortOrder = other.getSortOrder();
        if (this$sortOrder == null ? other$sortOrder != null : !((Object)((Object)this$sortOrder)).equals((Object)other$sortOrder)) {
            return false;
        }
        SortBy this$sortBy = this.getSortBy();
        SortBy other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !((Object)((Object)this$sortBy)).equals((Object)other$sortBy)) {
            return false;
        }
        DbSystemUpgradeHistoryEntrySummary.Action this$upgradeAction = this.getUpgradeAction();
        DbSystemUpgradeHistoryEntrySummary.Action other$upgradeAction = other.getUpgradeAction();
        if (this$upgradeAction == null ? other$upgradeAction != null : !((Object)((Object)this$upgradeAction)).equals((Object)other$upgradeAction)) {
            return false;
        }
        DbSystemUpgradeHistoryEntrySummary.LifecycleState this$lifecycleState = this.getLifecycleState();
        DbSystemUpgradeHistoryEntrySummary.LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListDbSystemUpgradeHistoryEntriesRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $dbSystemId = this.getDbSystemId();
        result = result * 59 + ($dbSystemId == null ? 43 : $dbSystemId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        SortOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)((Object)$sortOrder)).hashCode());
        SortBy $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : ((Object)((Object)$sortBy)).hashCode());
        DbSystemUpgradeHistoryEntrySummary.Action $upgradeAction = this.getUpgradeAction();
        result = result * 59 + ($upgradeAction == null ? 43 : ((Object)((Object)$upgradeAction)).hashCode());
        DbSystemUpgradeHistoryEntrySummary.LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public DbSystemUpgradeHistoryEntrySummary.Action getUpgradeAction() {
        return this.upgradeAction;
    }

    public DbSystemUpgradeHistoryEntrySummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDbSystemUpgradeHistoryEntriesRequest, Void> {
        private String dbSystemId;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private DbSystemUpgradeHistoryEntrySummary.Action upgradeAction;
        private DbSystemUpgradeHistoryEntrySummary.LifecycleState lifecycleState;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDbSystemUpgradeHistoryEntriesRequest o) {
            this.dbSystemId(o.getDbSystemId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.upgradeAction(o.getUpgradeAction());
            this.lifecycleState(o.getLifecycleState());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDbSystemUpgradeHistoryEntriesRequest build() {
            ListDbSystemUpgradeHistoryEntriesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder upgradeAction(DbSystemUpgradeHistoryEntrySummary.Action upgradeAction) {
            this.upgradeAction = upgradeAction;
            return this;
        }

        public Builder lifecycleState(DbSystemUpgradeHistoryEntrySummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListDbSystemUpgradeHistoryEntriesRequest buildWithoutInvocationCallback() {
            return new ListDbSystemUpgradeHistoryEntriesRequest(this.dbSystemId, this.limit, this.page, this.sortOrder, this.sortBy, this.upgradeAction, this.lifecycleState, this.opcRequestId);
        }

        public String toString() {
            return "ListDbSystemUpgradeHistoryEntriesRequest.Builder(dbSystemId=" + this.dbSystemId + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", upgradeAction=" + (Object)((Object)this.upgradeAction) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortBy {
        Timestarted("TIMESTARTED");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

