/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.ant;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.java.testrunner.OutputUtils;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;

public class JUnitTestSession
extends TestSession {
    private LineConvertors.FileLocator projectFileLocator = null;

    public JUnitTestSession(String name, Project project, TestSession.SessionType sessionType) {
        super(name, project, sessionType);
        this.projectFileLocator = new ProjectFileLocator(project);
    }

    public LineConvertors.FileLocator getFileLocator() {
        LineConvertors.FileLocator locator = super.getFileLocator();
        if (locator == null) {
            return this.projectFileLocator;
        }
        return locator;
    }

    class ProjectFileLocator
    implements LineConvertors.FileLocator {
        private ClassPath classpath;

        ProjectFileLocator(Project project) {
            this.classpath = this.getProjectClasspath(project);
        }

        public FileObject find(String filename) {
            return this.classpath.findResource(filename);
        }

        private ClassPath getProjectClasspath(Project p) {
            ClassPath result = null;
            HashSet<FileObject> roots = new HashSet<FileObject>();
            Sources sources = ProjectUtils.getSources((Project)p);
            if (sources != null) {
                SourceGroup[] groups;
                for (SourceGroup group : groups = sources.getSourceGroups("java")) {
                    roots.add(group.getRootFolder());
                }
            }
            ClassPathProvider cpp = (ClassPathProvider)p.getLookup().lookup(ClassPathProvider.class);
            HashSet<ClassPath> setCP = new HashSet<ClassPath>();
            if (cpp != null) {
                for (FileObject file : roots) {
                    ClassPath path = cpp.findClassPath(file, "classpath/compile");
                    if (path == null) continue;
                    setCP.add(path);
                }
            }
            for (ClassPath cp : setCP) {
                FileObject[] rootsCP;
                for (FileObject fo : rootsCP = cp.getRoots()) {
                    try {
                        FileObject[] aaa = SourceForBinaryQuery.findSourceRoots((URL)fo.toURL()).getRoots();
                        roots.addAll(Arrays.asList(aaa));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            String platformId = null;
            try {
                Method evalMethod = p.getClass().getDeclaredMethod("evaluator", new Class[0]);
                PropertyEvaluator evaluator = (PropertyEvaluator)evalMethod.invoke((Object)p, new Object[0]);
                if (evaluator != null) {
                    platformId = evaluator.getProperty("platform.active");
                }
            }
            catch (Exception evalMethod) {
                // empty catch block
            }
            JavaPlatform platform = OutputUtils.getActivePlatform(platformId);
            if (platform != null) {
                roots.addAll(Arrays.asList(platform.getSourceFolders().getRoots()));
            }
            result = ClassPathSupport.createClassPath((FileObject[])roots.toArray(new FileObject[roots.size()]));
            return result;
        }
    }
}

