/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.api;

import java.util.Collections;
import java.util.List;
import org.netbeans.modules.docker.api.DockerContainer;
import org.netbeans.modules.docker.api.PortMapping;

public class DockerContainerDetail {
    private final String name;
    private final DockerContainer.Status status;
    private final boolean stdin;
    private final boolean tty;
    private final List<PortMapping> portMappings;

    public DockerContainerDetail(String name, DockerContainer.Status status, boolean stdin, boolean tty) {
        this.name = name;
        this.status = status;
        this.stdin = stdin;
        this.tty = tty;
        this.portMappings = Collections.emptyList();
    }

    public DockerContainerDetail(String name, DockerContainer.Status status, boolean stdin, boolean tty, List<PortMapping> portMappings) {
        this.name = name;
        this.status = status;
        this.stdin = stdin;
        this.tty = tty;
        this.portMappings = portMappings;
    }

    public String getName() {
        return this.name;
    }

    public DockerContainer.Status getStatus() {
        return this.status;
    }

    public boolean isStdin() {
        return this.stdin;
    }

    public boolean isTty() {
        return this.tty;
    }

    public List<PortMapping> portMappings() {
        return Collections.unmodifiableList(this.portMappings);
    }

    public boolean arePortExposed() {
        return this.portMappings.isEmpty();
    }
}

