/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.completion.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.xml.namespace.QName;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.axi.AXIType;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.AbstractElement;
import org.netbeans.modules.xml.axi.AnyAttribute;
import org.netbeans.modules.xml.axi.AnyElement;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.SchemaReference;
import org.netbeans.modules.xml.axi.datatype.Datatype;
import org.netbeans.modules.xml.schema.completion.AttributeResultItem;
import org.netbeans.modules.xml.schema.completion.CompletionResultItem;
import org.netbeans.modules.xml.schema.completion.ElementResultItem;
import org.netbeans.modules.xml.schema.completion.EndTagResultItem;
import org.netbeans.modules.xml.schema.completion.TagLastCharResultItem;
import org.netbeans.modules.xml.schema.completion.ValueResultItem;
import org.netbeans.modules.xml.schema.completion.spi.CompletionContext;
import org.netbeans.modules.xml.schema.completion.spi.CompletionModelProvider;
import org.netbeans.modules.xml.schema.completion.util.CompletionContextImpl;
import org.netbeans.modules.xml.schema.completion.util.CompletionModelEx;
import org.netbeans.modules.xml.schema.model.Form;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.schema.model.visitor.FindSubstitutions;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class CompletionUtil {
    public static final String TAG_FIRST_CHAR = "<";
    public static final String TAG_LAST_CHAR = ">";
    public static final String END_TAG_PREFIX = "</";
    public static final String END_TAG_SUFFIX = "/>";
    public static final Pattern PATTERN_TEXT_TAG_EOLs = Pattern.compile("</?[\\s]+.*");
    private static final Logger _logger = Logger.getLogger(CompletionUtil.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean noCompletion(JTextComponent target) {
        if (target == null || target.getCaret() == null) {
            return false;
        }
        int offset = target.getCaret().getDot();
        if (offset < 0) {
            return false;
        }
        BaseDocument document = (BaseDocument)target.getDocument();
        document.readLock();
        try {
            TokenHierarchy th = TokenHierarchy.get((Document)document);
            TokenSequence ts = th.tokenSequence();
            if (ts == null) {
                boolean bl = false;
                return bl;
            }
            ts.move(offset);
            Token token = ts.token();
            if (token == null) {
                ts.moveNext();
                token = ts.token();
                if (token == null) {
                    boolean bl = false;
                    return bl;
                }
            }
            if (token.id() == XMLTokenId.CDATA_SECTION || token.id() == XMLTokenId.BLOCK_COMMENT || token.id() == XMLTokenId.PI_START || token.id() == XMLTokenId.PI_END || token.id() == XMLTokenId.PI_CONTENT || token.id() == XMLTokenId.PI_TARGET) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            document.readUnlock();
        }
        return false;
    }

    private CompletionUtil() {
    }

    public static void printPath(List<QName> path) {
        StringBuffer buffer = new StringBuffer();
        for (QName item : path) {
            if (buffer.toString().equals("")) {
                buffer.append(item);
                continue;
            }
            buffer.append("/" + item);
        }
    }

    public static boolean isRoot(String tag, CompletionModelProvider.CompletionModel cm) {
        if (cm == null) {
            return false;
        }
        AXIModel model = AXIModelFactory.getDefault().getModel(cm.getSchemaModel());
        for (AbstractElement element : model.getRoot().getChildElements()) {
            if (!tag.endsWith(element.getName())) continue;
            return true;
        }
        return false;
    }

    public static String getPrefixFromTag(String tagName) {
        if (tagName == null) {
            return null;
        }
        int index = tagName.indexOf(":");
        if (index == -1) {
            return null;
        }
        String prefixName = tagName.substring(0, index);
        if (prefixName.startsWith(END_TAG_PREFIX)) {
            prefixName = prefixName.substring(END_TAG_PREFIX.length());
        } else if (prefixName.startsWith(TAG_FIRST_CHAR)) {
            prefixName = prefixName.substring(TAG_FIRST_CHAR.length());
        }
        return prefixName;
    }

    public static String getLocalNameFromTag(String tagName) {
        if (tagName == null) {
            return null;
        }
        return tagName.indexOf(":") == -1 ? tagName : tagName.substring(tagName.indexOf(":") + 1, tagName.length());
    }

    public static String getPrefixFromXMLNS(String namespace) {
        if (namespace == null) {
            return null;
        }
        return namespace.indexOf(":") == -1 ? null : namespace.substring(namespace.indexOf(":") + 1);
    }

    public static List<String> getPrefixesAgainstNamespace(CompletionContextImpl context, String namespace) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> entry : context.getDeclaredNamespaces().entrySet()) {
            String key = entry.getKey();
            String ns = entry.getValue();
            if (!ns.equals(namespace)) continue;
            list.add(CompletionUtil.getPrefixFromXMLNS(key));
        }
        return list;
    }

    public static void loadSchemaURIs(String schemaLocation, List<URI> uris, Map<String, String> schemaLocationMap) {
        StringTokenizer st = new StringTokenizer(schemaLocation.replace("\n", " "), " ");
        while (st.hasMoreTokens()) {
            URI uri = null;
            try {
                String token1 = st.nextToken().trim();
                if (schemaLocationMap == null) {
                    uri = URI.create(token1);
                    if (uri == null) continue;
                    uris.add(uri);
                    continue;
                }
                if (!st.hasMoreTokens()) continue;
                String token2 = st.nextToken().trim();
                uri = URI.create(token2);
                if (uri != null) {
                    uris.add(uri);
                }
                schemaLocationMap.put(token1, token2);
            }
            catch (Exception ex) {}
        }
    }

    private static AXIComponent findOriginal(AXIComponent c) {
        block4: while (true) {
            switch (c.getComponentType()) {
                case REFERENCE: {
                    c = c.getSharedComponent();
                    continue block4;
                }
                case PROXY: {
                    c = c.getOriginal();
                    continue block4;
                }
            }
            break;
        }
        return c;
    }

    public static List<CompletionResultItem> getAttributes(CompletionContextImpl context) {
        Element element = CompletionUtil.findAXIElementAtContext(context);
        if (element == null) {
            return null;
        }
        ArrayList<CompletionResultItem> results = new ArrayList<CompletionResultItem>();
        for (AbstractAttribute aa : element.getAttributes()) {
            AXIComponent original = CompletionUtil.findOriginal((AXIComponent)aa);
            if (original.getTargetNamespace() == null) {
                CompletionResultItem item = CompletionUtil.createResultItem(original, null, context);
                if (item == null) continue;
                results.add(item);
                continue;
            }
            if (original instanceof AnyAttribute) {
                results.addAll(CompletionUtil.substituteAny((AXIComponent)((AnyAttribute)original), context));
                continue;
            }
            CompletionUtil.addNSAwareCompletionItems(original, context, null, results);
        }
        return results;
    }

    public static List<CompletionResultItem> getElements(CompletionContextImpl context) {
        Element element = CompletionUtil.findAXIElementAtContext(context);
        if (element == null) {
            return null;
        }
        ArrayList<CompletionResultItem> results = new ArrayList<CompletionResultItem>();
        for (AbstractElement ae : element.getChildElements()) {
            AXIComponent original = CompletionUtil.findOriginal((AXIComponent)ae);
            if (original.getTargetNamespace() == null) {
                CompletionResultItem item = CompletionUtil.createResultItem(original, null, context);
                if (item == null) continue;
                results.add(item);
                continue;
            }
            if (original instanceof AnyElement) {
                results.addAll(CompletionUtil.substituteAny((AXIComponent)((AnyElement)original), context));
                continue;
            }
            if (!(original instanceof Element)) continue;
            Element childElement = (Element)original;
            if (!childElement.getAbstract()) {
                CompletionUtil.addNSAwareCompletionItems(original, context, null, results);
            }
            CompletionUtil.addSubstitutionCompletionItems(childElement, context, results);
        }
        return results;
    }

    public static List<CompletionResultItem> getElementValues(CompletionContextImpl context) {
        Element element = CompletionUtil.findAXIElementAtContext(context);
        ArrayList<CompletionResultItem> result = new ArrayList<CompletionResultItem>();
        if (element == null) {
            return null;
        }
        AXIType type = element.getType();
        if (!(type instanceof Datatype) || ((Datatype)type).getEnumerations() == null) {
            return null;
        }
        for (Object value : ((Datatype)type).getEnumerations()) {
            if (context.getTypedChars() == null || context.getTypedChars().equals("")) {
                ValueResultItem item = new ValueResultItem((AXIComponent)element, (String)value, context);
                result.add(item);
                continue;
            }
            String str = (String)value;
            if (!str.startsWith(context.getTypedChars())) continue;
            ValueResultItem item = new ValueResultItem((AXIComponent)element, (String)value, context);
            result.add(item);
        }
        return result;
    }

    public static List<CompletionResultItem> getAttributeValues(CompletionContextImpl context) {
        Element element = CompletionUtil.findAXIElementAtContext(context);
        if (element == null) {
            return null;
        }
        ArrayList<CompletionResultItem> result = new ArrayList<CompletionResultItem>();
        Attribute attr = null;
        for (AbstractAttribute a : element.getAttributes()) {
            if (a instanceof AnyAttribute || !a.getName().equals(context.getAttribute())) continue;
            attr = (Attribute)a;
            break;
        }
        if (attr == null) {
            return null;
        }
        AXIType type = attr.getType();
        if (!(type instanceof Datatype) || ((Datatype)type).getEnumerations() == null) {
            return null;
        }
        for (Object value : ((Datatype)type).getEnumerations()) {
            ValueResultItem item;
            String str;
            String string = str = value != null ? value.toString() : null;
            if (context.getTypedChars() == null || context.getTypedChars().equals("")) {
                item = new ValueResultItem((AXIComponent)attr, str, context);
                result.add(item);
                continue;
            }
            if (str == null || !str.startsWith(context.getTypedChars())) continue;
            item = new ValueResultItem((AXIComponent)attr, str, context);
            result.add(item);
        }
        return result;
    }

    private static void addSubstitutionCompletionItems(Element forSubstitution, CompletionContextImpl context, List<CompletionResultItem> results) {
        AXIModel model = forSubstitution.getModel();
        String nsUri = forSubstitution.getTargetNamespace();
        String localName = forSubstitution.getName();
        for (CompletionModelProvider.CompletionModel completionModel : context.getCompletionModels()) {
            SchemaModel schemaModel = completionModel.getSchemaModel();
            Set substitutions = FindSubstitutions.resolveSubstitutions((SchemaModel)schemaModel, (String)nsUri, (String)localName);
            for (GlobalElement substitution : substitutions) {
                AXIComponent substitutionElement = CompletionUtil.getAxiComponent(model, (SchemaComponent)substitution);
                CompletionUtil.addNSAwareCompletionItems(substitutionElement, context, completionModel, results);
            }
        }
    }

    private static AXIComponent getAxiComponent(AXIModel model, SchemaComponent schemaComponent) {
        if (model.getSchemaModel() == schemaComponent.getModel()) {
            return CompletionUtil.findChild(model.getRoot(), schemaComponent);
        }
        if (!schemaComponent.isInDocumentModel()) {
            return null;
        }
        AXIModelFactory factory = AXIModelFactory.getDefault();
        AXIModel otherModel = factory.getModel(schemaComponent.getModel());
        return otherModel == null ? null : CompletionUtil.findChild(otherModel.getRoot(), schemaComponent);
    }

    private static AXIComponent findChild(AXIDocument document, SchemaComponent child) {
        for (AXIComponent childRepresentation : document.getChildren()) {
            if (childRepresentation.getPeer() != child) continue;
            return childRepresentation;
        }
        return null;
    }

    private static void addNSAwareCompletionItems(AXIComponent axi, CompletionContextImpl context, CompletionModelProvider.CompletionModel cm, List<CompletionResultItem> results) {
        String typedChars = context.getTypedChars();
        CompletionResultItem item = null;
        if (!CompletionUtil.isFormQualified(axi)) {
            item = CompletionUtil.createResultItem(axi, null, context);
            if (item == null) {
                return;
            }
            if (typedChars == null) {
                results.add(item);
            } else if (CompletionUtil.isResultItemTextStartsWith(item, typedChars)) {
                results.add(item);
            }
            return;
        }
        List<String> prefixes = CompletionUtil.getPrefixes(context, axi, cm);
        if (prefixes.size() == 0) {
            prefixes.add(null);
        }
        for (String prefix : prefixes) {
            item = CompletionUtil.createResultItem(axi, prefix, context);
            if (item == null) continue;
            if (typedChars == null) {
                results.add(item);
                continue;
            }
            if (!CompletionUtil.isResultItemTextStartsWith(item, typedChars)) continue;
            results.add(item);
        }
    }

    private static boolean isResultItemTextStartsWith(CompletionResultItem resultItem, String text) {
        if (resultItem == null || text == null) {
            return false;
        }
        String resultText = resultItem.getReplacementText();
        int startIndex = 0;
        if (resultText.startsWith(END_TAG_PREFIX) && !text.startsWith(END_TAG_PREFIX)) {
            startIndex = END_TAG_PREFIX.length();
        } else if (resultText.startsWith(TAG_FIRST_CHAR) && !text.startsWith(TAG_FIRST_CHAR)) {
            startIndex = TAG_FIRST_CHAR.length();
        }
        boolean result = resultText.startsWith(text, startIndex);
        return result;
    }

    private static CompletionResultItem createResultItem(AXIComponent axi, String prefix, CompletionContextImpl context) {
        CompletionResultItem item = null;
        if (axi instanceof AbstractElement) {
            item = prefix == null ? new ElementResultItem((AbstractElement)axi, (CompletionContext)context) : new ElementResultItem((AbstractElement)axi, prefix, context);
        }
        if (axi instanceof AbstractAttribute) {
            Attribute a = (Attribute)axi;
            if (prefix == null) {
                if (!context.getExistingAttributes().contains(a.getName())) {
                    item = new AttributeResultItem((AbstractAttribute)axi, (CompletionContext)context);
                }
            } else if (!context.getExistingAttributes().contains(prefix + ":" + a.getName())) {
                item = new AttributeResultItem((AbstractAttribute)axi, prefix, context);
            }
        }
        return item;
    }

    private static List<String> getPrefixes(CompletionContextImpl context, AXIComponent ae, CompletionModelProvider.CompletionModel cm) {
        List<Object> prefixes = new ArrayList();
        if (cm == null) {
            String targetNS;
            ae = CompletionUtil.findOriginal(ae);
            String defaultNS = context.getDefaultNamespace();
            if (!(defaultNS == (targetNS = ae.getTargetNamespace()) || defaultNS != null && targetNS != null && context.getDefaultNamespace().equals(ae.getTargetNamespace()))) {
                prefixes = CompletionUtil.getPrefixesAgainstNamespace(context, ae.getTargetNamespace());
                if (prefixes.size() != 0) {
                    return prefixes;
                }
                String prefix = context.suggestPrefix(ae.getTargetNamespace());
                CompletionModelEx m = new CompletionModelEx(context, prefix, ae.getModel().getSchemaModel());
                context.addCompletionModel(m);
                prefixes.add(prefix);
                return prefixes;
            }
            return CompletionUtil.getPrefixesAgainstNamespace(context, ae.getTargetNamespace());
        }
        prefixes = CompletionUtil.getPrefixesAgainstNamespace(context, cm.getTargetNamespace());
        if (prefixes.size() == 0) {
            prefixes.add(cm.getSuggestedPrefix());
        }
        return prefixes;
    }

    private static boolean isFormQualified(AXIComponent component) {
        if (component instanceof Attribute) {
            AXIComponent original = component.getOriginal();
            if (((Attribute)original).isReference() || original.getParent() instanceof AXIDocument) {
                return true;
            }
            Attribute a = (Attribute)component;
            return a.getForm() == Form.QUALIFIED;
        }
        if (component instanceof Element) {
            AXIComponent original = component.getOriginal();
            if (((Element)original).isReference() || original.getParent() instanceof AXIDocument) {
                return true;
            }
            Element e = (Element)component;
            return e.getForm() == Form.QUALIFIED;
        }
        return false;
    }

    public static Element findAXIElementAtContext(CompletionContextImpl context) {
        List<QName> path = context.getPathFromRoot();
        if (path == null || path.size() == 0) {
            return null;
        }
        CompletionModelProvider.CompletionModel cm = null;
        QName tag = context.getPathFromRoot().get(0);
        String tns = tag.getNamespaceURI();
        cm = tns != null && tns.equals("") ? context.getActiveNoNSModel() : context.getCompletionModelMap().get(tns);
        if (cm == null) {
            return null;
        }
        AXIModel am = AXIModelFactory.getDefault().getModel(cm.getSchemaModel());
        AXIDocument parent = am.getRoot();
        if (parent == null) {
            return null;
        }
        AXIComponent child = null;
        for (QName qname : path) {
            child = CompletionUtil.findChildElement((AXIComponent)parent, qname, context);
            parent = child;
        }
        if (child instanceof Element) {
            return (Element)child;
        }
        return null;
    }

    private static AXIComponent findChildElement(AXIComponent parent, QName qname, CompletionContextImpl context) {
        AXIModel model;
        if (parent == null) {
            return null;
        }
        for (AXIComponent element : parent.getChildElements()) {
            if (!(element instanceof Element)) continue;
            Element e = (Element)element;
            if (qname.getLocalPart().equals(e.getName())) {
                return element;
            }
            if (!e.isReference()) continue;
            Element ref = e.getReferent();
            model = ref.getModel();
            String nsUri = ref.getTargetNamespace();
            String localName = ref.getName();
            for (CompletionModelProvider.CompletionModel completionModel : context.getCompletionModels()) {
                SchemaModel schemaModel = completionModel.getSchemaModel();
                Set substitutions = FindSubstitutions.resolveSubstitutions((SchemaModel)schemaModel, (String)nsUri, (String)localName);
                for (GlobalElement substitution : substitutions) {
                    AXIComponent substitutionElement = CompletionUtil.getAxiComponent(model, (SchemaComponent)substitution);
                    if (!(substitutionElement instanceof Element) || !((Element)substitutionElement).getName().equals(qname.getLocalPart())) continue;
                    return substitutionElement;
                }
            }
        }
        for (AXIComponent c : parent.getChildren()) {
            if (!(c instanceof SchemaReference)) continue;
            SchemaReference ref = (SchemaReference)c;
            SchemaModelReference in = (SchemaModelReference)ref.getPeer();
            try {
                model = in.resolveReferencedModel();
                AXIModel am = AXIModelFactory.getDefault().getModel((SchemaModel)model);
                AXIComponent check = CompletionUtil.findChildElement((AXIComponent)am.getRoot(), qname, context);
                if (check == null) continue;
                return check;
            }
            catch (CatalogModelException catalogModelException) {
            }
        }
        return null;
    }

    private static List<CompletionResultItem> substituteAny(AXIComponent any, CompletionContextImpl context) {
        ArrayList<CompletionResultItem> items = new ArrayList<CompletionResultItem>();
        String anyNamespace = any.getTargetNamespace();
        String tns = any.getModel().getRoot().getTargetNamespace();
        for (CompletionModelProvider.CompletionModel cm : context.getCompletionModels()) {
            if (cm == null) continue;
            if (anyNamespace.equals("##other") && tns != null && !tns.equals(cm.getTargetNamespace())) {
                CompletionUtil.populateItemsForAny(cm, any, context, items);
            }
            if (anyNamespace.equals("##targetNamespace") && tns != null && tns.equals(cm.getTargetNamespace())) {
                CompletionUtil.populateItemsForAny(cm, any, context, items);
            }
            if (anyNamespace.equals("##local") && cm.getTargetNamespace() == null) {
                CompletionUtil.populateItemsForAny(cm, any, context, items);
            }
            if (!anyNamespace.startsWith("##") && cm.getTargetNamespace() != null && anyNamespace.indexOf(cm.getTargetNamespace()) != -1) {
                CompletionUtil.populateItemsForAny(cm, any, context, items);
            }
            if (!anyNamespace.equals("##any")) continue;
            CompletionUtil.populateItemsForAny(cm, any, context, items);
        }
        return items;
    }

    private static void populateItemsForAny(CompletionModelProvider.CompletionModel cm, AXIComponent any, CompletionContextImpl context, List<CompletionResultItem> items) {
        if (cm == null) {
            return;
        }
        AXIModel am = AXIModelFactory.getDefault().getModel(cm.getSchemaModel());
        if (any instanceof AnyElement) {
            for (Element e : am.getRoot().getElements()) {
                CompletionUtil.addNSAwareCompletionItems((AXIComponent)e, context, cm, items);
            }
        }
        if (any instanceof AnyAttribute) {
            for (Attribute a : am.getRoot().getAttributes()) {
                CompletionUtil.addNSAwareCompletionItems((AXIComponent)a, context, cm, items);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> getNamespacesFromStartTags(Document document) {
        HashMap<String, String> map = new HashMap<String, String>();
        ((AbstractDocument)document).readLock();
        try {
            TokenHierarchy th = TokenHierarchy.get((Document)document);
            TokenSequence ts = th.tokenSequence();
            String lastNS = null;
            while (ts.moveNext()) {
                Token t = ts.token();
                if (t.id() == XMLTokenId.ARGUMENT && t.text().toString().startsWith("xmlns")) {
                    lastNS = t.text().toString();
                }
                if (t.id() != XMLTokenId.VALUE || lastNS == null) continue;
                String value = t.text().toString();
                if (value.length() >= 2 && (value.startsWith("'") || value.startsWith("\""))) {
                    value = value.substring(1, value.length() - 1);
                }
                map.put(value, CompletionUtil.getPrefixFromXMLNS(lastNS));
                lastNS = null;
            }
        }
        finally {
            ((AbstractDocument)document).readUnlock();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDTDBasedDocument(Document document) {
        ((AbstractDocument)document).readLock();
        try {
            TokenHierarchy th = TokenHierarchy.get((Document)document);
            TokenSequence ts = th.tokenSequence();
            while (ts.moveNext()) {
                Token token = ts.token();
                if (token.id() == XMLTokenId.TAG) {
                    boolean bl = false;
                    return bl;
                }
                if (token.id() != XMLTokenId.DECLARATION) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            ((AbstractDocument)document).readUnlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNamespaceInsertionOffset(Document document) {
        int offset = 0;
        ((AbstractDocument)document).readLock();
        try {
            TokenHierarchy th = TokenHierarchy.get((Document)document);
            TokenSequence ts = th.tokenSequence();
            while (ts.moveNext()) {
                Token nextToken = ts.token();
                if (nextToken.id() != XMLTokenId.TAG || !nextToken.text().toString().equals(TAG_LAST_CHAR)) continue;
                offset = nextToken.offset(th);
                break;
            }
        }
        finally {
            ((AbstractDocument)document).readUnlock();
        }
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocRoot getDocRoot(Document document) {
        ((AbstractDocument)document).readLock();
        try {
            TokenHierarchy th = TokenHierarchy.get((Document)document);
            TokenSequence ts = th.tokenSequence();
            ArrayList<DocRootAttribute> attributes = new ArrayList<DocRootAttribute>();
            String name = null;
            while (ts.moveNext()) {
                Token t;
                Token nextToken = ts.token();
                if (nextToken.id() != XMLTokenId.TAG) continue;
                String tagName = nextToken.text().toString();
                if (name == null && tagName.startsWith(TAG_FIRST_CHAR)) {
                    name = tagName.substring(1, tagName.length());
                }
                String lastAttrName = null;
                while (ts.moveNext() && ((t = ts.token()).id() != XMLTokenId.TAG || !t.text().toString().equals(TAG_LAST_CHAR))) {
                    if (t.id() == XMLTokenId.ARGUMENT) {
                        lastAttrName = t.text().toString();
                    }
                    if (t.id() != XMLTokenId.VALUE || lastAttrName == null) continue;
                    String value = t.text().toString();
                    if (value == null || value.length() == 1) {
                        value = null;
                    } else if (value.startsWith("'") || value.startsWith("\"")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    attributes.add(new DocRootAttribute(lastAttrName, value));
                    lastAttrName = null;
                }
                if (name == null) continue;
                break;
            }
            DocRoot docRoot = new DocRoot(name, attributes);
            return docRoot;
        }
        finally {
            ((AbstractDocument)document).readUnlock();
        }
    }

    public static boolean canProvideCompletion(BaseDocument doc) {
        DocRoot root;
        FileObject file = CompletionUtil.getPrimaryFile((Document)doc);
        if (file == null) {
            return false;
        }
        return !"xml".equals(file.getExt()) || (root = CompletionUtil.getDocRoot((Document)doc)) == null || root.declaresNamespace();
    }

    public static FileObject getPrimaryFile(Document doc) {
        Object o = doc.getProperty("stream");
        if (o instanceof FileObject) {
            return (FileObject)o;
        }
        if (o instanceof Lookup.Provider) {
            return (FileObject)((Lookup.Provider)o).getLookup().lookup(FileObject.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompletionResultItem getEndTagCompletionItem(JTextComponent component, BaseDocument document) {
        int caretPos = component.getCaret().getDot();
        try {
            document.readLock();
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            String incompleteTagName = CompletionUtil.findIncompleteTagName(caretPos, tokenSequence);
            if (CompletionUtil.isCaretInsideTag(caretPos, tokenSequence)) {
                CompletionResultItem completionResultItem = null;
                return completionResultItem;
            }
            boolean beforeUnclosedStartTagFound = CompletionUtil.isUnclosedStartTagFoundBefore(caretPos, tokenSequence);
            if (!beforeUnclosedStartTagFound) {
                CompletionResultItem completionResultItem = null;
                return completionResultItem;
            }
            Token token = tokenSequence.token();
            String startTagName = CompletionUtil.getTokenTagName(token);
            if (startTagName == null) {
                CompletionResultItem completionResultItem = null;
                return completionResultItem;
            }
            boolean closingTagFound = CompletionUtil.isClosingEndTagFoundAfter(caretPos, tokenSequence, startTagName);
            if (closingTagFound) {
                CompletionResultItem completionResultItem = null;
                return completionResultItem;
            }
            CompletionResultItem resultItem = incompleteTagName != null && !startTagName.startsWith(incompleteTagName) ? new TagLastCharResultItem(incompleteTagName, tokenSequence) : new EndTagResultItem(startTagName, tokenSequence);
            EndTagResultItem endTagResultItem = resultItem;
            return endTagResultItem;
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, e.getMessage() == null ? e.getClass().getName() : e.getMessage(), e);
            CompletionResultItem completionResultItem = null;
            return completionResultItem;
        }
        finally {
            document.readUnlock();
        }
    }

    private static boolean isUnclosedStartTagFoundBefore(int caretPos, TokenSequence tokenSequence) {
        tokenSequence.move(caretPos);
        boolean startTagFound = false;
        boolean tagLastCharFound = false;
        Stack<String> existingEndTags = new Stack<String>();
        while (tokenSequence.movePrevious()) {
            String endTagName;
            Token token = tokenSequence.token();
            if (CompletionUtil.isTagLastChar(token)) {
                tagLastCharFound = true;
                continue;
            }
            if (CompletionUtil.isEndTagPrefix(token)) {
                startTagFound = false;
                tagLastCharFound = false;
                endTagName = CompletionUtil.getTokenTagName(token);
                if (endTagName == null) continue;
                existingEndTags.push(endTagName);
                continue;
            }
            if (!CompletionUtil.isTagFirstChar(token) || !tagLastCharFound) continue;
            String startTagName = CompletionUtil.getTokenTagName(token);
            String string = endTagName = existingEndTags.isEmpty() ? null : (String)existingEndTags.peek();
            if (startTagName != null && endTagName != null && startTagName.equals(endTagName)) {
                existingEndTags.pop();
                startTagFound = false;
                tagLastCharFound = false;
                continue;
            }
            startTagFound = true;
            break;
        }
        return startTagFound;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String findIncompleteTagName(int caretPos, TokenSequence tokenSequence) {
        String tokenText;
        TokenId tokenID;
        boolean inMiddle;
        if (!CompletionUtil.isTokenSequenceUsable(tokenSequence)) {
            return null;
        }
        boolean tagFirstCharFound = false;
        Token token = null;
        String incompleteTagName = null;
        int cut = tokenSequence.move(caretPos);
        tokenSequence.moveNext();
        boolean bl = inMiddle = cut != 0;
        do {
            if ((tokenID = (token = tokenSequence.token()).id()).equals(XMLTokenId.TAG) || tokenID.equals(XMLTokenId.TEXT)) {
                tokenText = token.text().toString();
                if (tokenText == null || tokenText.isEmpty()) continue;
                if (!tokenText.startsWith(TAG_FIRST_CHAR)) return null;
                if (tokenSequence.offset() < caretPos) {
                    tagFirstCharFound = true;
                    incompleteTagName = CompletionUtil.getTokenTagName(token);
                    break;
                }
            } else if (!inMiddle || tokenID.equals(XMLTokenId.BLOCK_COMMENT)) {
                // empty if block
            }
            inMiddle = false;
        } while (tokenSequence.movePrevious());
        if (!tagFirstCharFound) {
            return null;
        }
        tokenSequence.move(caretPos);
        while (tokenSequence.moveNext()) {
            token = tokenSequence.token();
            tokenID = token.id();
            if (!tokenID.equals(XMLTokenId.TAG) || (tokenText = token.text().toString()) == null || tokenText.isEmpty()) continue;
            if (!tokenText.contains(TAG_LAST_CHAR)) return incompleteTagName;
            return null;
        }
        return incompleteTagName;
    }

    private static boolean isClosingEndTagFoundAfter(int caretPos, TokenSequence tokenSequence, String startTagName) {
        if (tokenSequence == null || startTagName == null) {
            return false;
        }
        tokenSequence.move(caretPos);
        int unclosedTagCount = 1;
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            String nextTagName = CompletionUtil.getTokenTagName(token);
            if (CompletionUtil.isEndTagPrefix(token)) {
                if (unclosedTagCount-- == 0) {
                    return false;
                }
            } else {
                if (!CompletionUtil.isTagFirstChar(token)) continue;
                ++unclosedTagCount;
            }
            if (unclosedTagCount != 0 || !CompletionUtil.isEndTagPrefix(token)) continue;
            return startTagName.equals(nextTagName);
        }
        return false;
    }

    public static boolean isTokenSequenceUsable(TokenSequence tokenSequence) {
        return tokenSequence != null && tokenSequence.isValid() && !tokenSequence.isEmpty();
    }

    public static boolean isCaretInsideTag(int caretPos, TokenSequence tokenSequence) {
        if (!CompletionUtil.isTokenSequenceUsable(tokenSequence)) {
            return false;
        }
        boolean tagFirstCharFound = false;
        boolean tagLastCharFound = false;
        Token token = null;
        boolean checkComment = tokenSequence.move(caretPos) != 0;
        tokenSequence.moveNext();
        do {
            if (CompletionUtil.isTagFirstChar(token = tokenSequence.token())) {
                tagFirstCharFound = true;
                break;
            }
            if (checkComment && token.id() == XMLTokenId.BLOCK_COMMENT) {
                return true;
            }
            checkComment = false;
        } while (tokenSequence.movePrevious());
        if (!tagFirstCharFound) {
            return false;
        }
        while (tokenSequence.moveNext()) {
            token = tokenSequence.token();
            int tokenOffset = tokenSequence.offset();
            boolean isEndTagSuffix = CompletionUtil.isEndTagSuffix(token);
            if (CompletionUtil.isTagLastChar(token) || isEndTagSuffix) {
                if (tokenOffset < caretPos && (!isEndTagSuffix || tokenOffset != caretPos - 1)) break;
                tagLastCharFound = true;
                break;
            }
            if (token.id() != XMLTokenId.TAG && token.id() != XMLTokenId.TEXT || token.text().charAt(0) != '<') continue;
            break;
        }
        return tagFirstCharFound && tagLastCharFound;
    }

    public static boolean isTagFirstChar(Token token) {
        if (token == null) {
            return false;
        }
        TokenId tokenID = token.id();
        if (tokenID.equals(XMLTokenId.TAG) || tokenID.equals(XMLTokenId.TEXT)) {
            String tokenText = token.text().toString();
            if (!CompletionUtil.isEndTagPrefix(token) && tokenText.startsWith(TAG_FIRST_CHAR)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isTagLastChar(Token token) {
        String tokenText;
        if (token == null) {
            return false;
        }
        TokenId tokenID = token.id();
        return tokenID.equals(XMLTokenId.TAG) && (tokenText = token.text().toString()).equals(TAG_LAST_CHAR);
    }

    public static boolean isEndTagPrefix(Token token) {
        String tokenText;
        if (token == null) {
            return false;
        }
        TokenId tokenID = token.id();
        return (tokenID.equals(XMLTokenId.TAG) || tokenID.equals(XMLTokenId.TEXT)) && (tokenText = token.text().toString()).startsWith(END_TAG_PREFIX);
    }

    public static boolean isEndTagSuffix(Token token) {
        String tokenText;
        if (token == null) {
            return false;
        }
        TokenId tokenID = token.id();
        return tokenID.equals(XMLTokenId.TAG) && (tokenText = token.text().toString()).equals(END_TAG_SUFFIX);
    }

    public static boolean isTextTag(Token token) {
        if (token == null) {
            return false;
        }
        TokenId tokenID = token.id();
        if (!tokenID.equals(XMLTokenId.TEXT)) {
            return false;
        }
        String tokenText = token.text().toString();
        if (tokenText.equals(TAG_FIRST_CHAR)) {
            return true;
        }
        boolean result = PATTERN_TEXT_TAG_EOLs.matcher(tokenText).matches();
        return result;
    }

    public static String getTokenTagName(Token token) {
        if (token == null) {
            return null;
        }
        int index = -1;
        if (CompletionUtil.isTagFirstChar(token)) {
            index = TAG_FIRST_CHAR.length();
        } else if (CompletionUtil.isEndTagPrefix(token)) {
            index = END_TAG_PREFIX.length();
        } else {
            return null;
        }
        String tokenText = token.text().toString().substring(index).trim();
        return tokenText.isEmpty() ? null : tokenText;
    }

    public static class DocRootAttribute {
        private String name;
        private String value;

        DocRootAttribute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.name + "=" + this.value;
        }
    }

    public static class DocRoot {
        private String name;
        private List<DocRootAttribute> attributes;

        DocRoot(String name, List<DocRootAttribute> attributes) {
            this.name = name;
            this.attributes = new ArrayList<DocRootAttribute>(attributes);
        }

        public String getName() {
            return this.name;
        }

        public String getPrefix() {
            return CompletionUtil.getPrefixFromTag(this.name);
        }

        public List<DocRootAttribute> getAttributes() {
            return this.attributes;
        }

        public boolean declaresNamespace() {
            for (DocRootAttribute attr : this.getAttributes()) {
                if (!attr.getName().startsWith("xmlns")) continue;
                return true;
            }
            return false;
        }
    }
}

