/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api;

import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.validation.api.AbstractValidator;
import org.netbeans.validation.api.AndValidator;
import org.netbeans.validation.api.CustomLevelValidator;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Severity;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.conversion.Converter;

public class ValidatorUtils {
    public static <T> Validator<T> merge(Validator<T> ... validators) {
        if (validators == null) {
            throw new NullPointerException();
        }
        if (validators.length == 1) {
            return validators[0];
        }
        if (validators.length == 0) {
            throw new IllegalArgumentException("Merging empty array of validators");
        }
        return new AndValidator<T>(validators[0].modelType(), Arrays.asList(validators));
    }

    public static <T> Validator<T> merge(Validator<T> validator1, Validator<T> validator2) {
        ArrayList validators = new ArrayList(2);
        validators.add(validator1);
        validators.add(validator2);
        return new AndValidator<T>(validator1.modelType(), validators);
    }

    public static <T> Validator<T> limitSeverity(Severity maximum, Validator<T> ... validators) {
        assert (maximum != null) : "Maximum null";
        assert (validators != null) : "Validators null";
        assert (validators.length > 0) : "Empty validators array";
        return new CustomLevelValidator<T>(maximum, ValidatorUtils.merge(validators));
    }

    public static <T> Validator<T> limitSeverity(Severity maximum, Validator<T> validator) {
        assert (maximum != null) : "Maximum null";
        assert (validator != null) : "Validator null";
        return new CustomLevelValidator<T>(maximum, validator);
    }

    public static <T, R> Validator<T> cast(Class<T> type, Validator<R> other) {
        return new CastValidator<T, R>(type, other);
    }

    public final <T, R> Validator<T> as(Class<T> t, Validator<R> v) {
        Class<R> type = v.modelType();
        if (t.equals(type) || type.isAssignableFrom(t)) {
            return ValidatorUtils.cast(t, v);
        }
        return Converter.find(type, t).convert(v);
    }

    private static final class CastValidator<T, R>
    extends AbstractValidator<T> {
        private final Validator<R> wrapped;
        private Exception e;

        CastValidator(Class<T> type, Validator<R> wrapped) {
            super(type);
            this.wrapped = wrapped;
            if (!type.isAssignableFrom(wrapped.modelType())) {
                throw new ClassCastException("Not assignable: " + type.getName() + " from " + wrapped.modelType().getName());
            }
            assert ((this.e = new Exception()) != null);
        }

        @Override
        public void validate(Problems problems, String compName, T model) {
            try {
                this.wrapped.validate(problems, compName, this.wrapped.modelType().cast(model));
            }
            catch (ClassCastException cce) {
                if (this.e != null) {
                    cce.initCause(this.e);
                }
                throw cce;
            }
        }

        public String toString() {
            return super.toString() + "[" + this.wrapped + "]";
        }
    }
}

