/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.websvc.api.support.LogUtils;
import org.netbeans.modules.websvc.rest.client.ClientJavaSourceHelper;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.nodes.RestServiceNode;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.text.ActiveEditorDrop;

public class ResourceToEditorDrop
implements ActiveEditorDrop {
    RestServiceNode resourceNode;

    public ResourceToEditorDrop(RestServiceNode resourceNode) {
        this.resourceNode = resourceNode;
    }

    public boolean handleTransfer(JTextComponent targetComponent) {
        Object mimeType = targetComponent.getDocument().getProperty("mimeType");
        RestServiceDescription serviceDescription = (RestServiceDescription)this.resourceNode.getLookup().lookup(RestServiceDescription.class);
        if (serviceDescription != null && mimeType != null && "text/x-java".equals(mimeType)) {
            try {
                FileObject targetFo = NbEditorUtilities.getFileObject((Document)targetComponent.getDocument());
                if (targetFo != null) {
                    ClientJavaSourceHelper.generateJerseyClient((Node)this.resourceNode, targetFo, serviceDescription.getName() + "_JerseyClient");
                    Object[] params = new Object[]{"JAX-RS", "DRAG & DROP REST RESOURCE"};
                    LogUtils.logWsAction((Object[])params);
                    return true;
                }
            }
            catch (Exception ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
        }
        return false;
    }
}

