/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.building.Source;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.ModelSource2;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixBase;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixProvider;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.model.pom.POMComponent;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Properties;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public final class PomModelUtils {
    private static final Logger LOG = Logger.getLogger(PomModelUtils.class.getName());
    static final String LAYER_POM = "pom";
    static final String LAYER_POM_SELECTION = "pom-selection";

    public static boolean implementInTransaction(Model m, Runnable r) {
        m.startTransaction();
        try {
            r.run();
        }
        finally {
            try {
                m.endTransaction();
            }
            catch (IllegalStateException ex) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(PomModelUtils.class, (String)"ERR_UpdatePomModel", (Object)Exceptions.findLocalizedMessage((Throwable)ex)));
                return false;
            }
        }
        return true;
    }

    static boolean checkModelValid(POMModel model) {
        assert (model != null);
        if (!model.getModelSource().isEditable()) {
            return false;
        }
        try {
            model.getBaseDocument();
            model.sync();
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, "Error while syncing pom model.", ex);
        }
        if (!model.getState().equals((Object)Model.State.VALID)) {
            LOG.log(Level.FINE, "Pom model document is not valid, is {0}", model.getState());
            return false;
        }
        if (model.getProject() == null) {
            LOG.log(Level.FINE, "Pom model root element missing");
            return false;
        }
        return true;
    }

    static void runMavenValidation(POMModel model, List<ErrorDescription> err) {
        File pom = (File)model.getModelSource().getLookup().lookup(File.class);
        if (pom == null) {
            return;
        }
        List<ModelProblem> problems = PomModelUtils.runMavenValidationImpl(pom, (Document)model.getModelSource().getLookup().lookup(Document.class));
        for (ModelProblem problem : problems) {
            if (!problem.getSource().equals(pom.getAbsolutePath())) {
                LOG.log(Level.FINE, "found problem not in {0}: {1}", new Object[]{pom, problem.getSource()});
                continue;
            }
            int line = problem.getLineNumber();
            if (line <= 0 || problem.getException() instanceof UnresolvableModelException) continue;
            try {
                err.add(ErrorDescriptionFactory.createErrorDescription((Severity)(problem.getSeverity() == ModelProblem.Severity.WARNING ? Severity.WARNING : Severity.ERROR), (String)problem.getMessage(), (Document)model.getBaseDocument(), (int)line));
            }
            catch (IndexOutOfBoundsException x) {
                LOG.log(Level.WARNING, "improper line number: {0}", problem);
            }
        }
    }

    public static List<ErrorDescription> findHints(@NonNull POMModel model, Project project) {
        ArrayList<ErrorDescription> err = new ArrayList<ErrorDescription>();
        PomModelUtils.runMavenValidation(model, err);
        if (!PomModelUtils.checkModelValid(model)) {
            return err;
        }
        for (POMErrorFixProvider prov : PomModelUtils.hintProviders(project, POMErrorFixProvider.class)) {
            List<ErrorDescription> lst = prov.getErrorsForDocument(model, project);
            if (lst == null) continue;
            err.addAll(lst);
        }
        return err;
    }

    static List<ModelProblem> runMavenValidationImpl(File pom, Document doc) {
        List problems;
        long t;
        block5: {
            MavenEmbedder embedder = EmbedderFactory.getProjectEmbedder();
            MavenExecutionRequest meReq = embedder.createMavenExecutionRequest();
            ProjectBuildingRequest req = meReq.getProjectBuildingRequest();
            req.setValidationLevel(30);
            req.setLocalRepository(embedder.getLocalRepository());
            List remoteRepos = RepositoryPreferences.getInstance().remoteRepositories(embedder);
            req.setRemoteRepositories(remoteRepos);
            req.setRepositorySession(((DefaultMaven)embedder.lookupComponent(Maven.class)).newRepositorySession(meReq));
            t = System.currentTimeMillis();
            try {
                problems = ((ProjectBuilder)embedder.lookupComponent(ProjectBuilder.class)).build((ModelSource)new M2S(pom, doc), req).getProblems();
            }
            catch (ProjectBuildingException x) {
                problems = new ArrayList();
                List results = x.getResults();
                if (results != null) {
                    Iterator iterator = results.iterator();
                    while (iterator.hasNext()) {
                        ProjectBuildingResult result = (ProjectBuildingResult)iterator.next();
                        problems.addAll(result.getProblems());
                    }
                }
                Throwable cause = x.getCause();
                if (!(cause instanceof ModelBuildingException)) break block5;
                problems.addAll(((ModelBuildingException)cause).getProblems());
            }
        }
        LinkedList<ModelProblem> toRet = new LinkedList<ModelProblem>();
        for (ModelProblem problem : problems) {
            if (!ModelUtils.checkByCLIMavenValidationLevel((ModelProblem)problem)) continue;
            toRet.add(problem);
        }
        long d = System.currentTimeMillis() - t;
        LOG.fine("Maven validation of " + pom.getPath() + " run for: " + d);
        return toRet;
    }

    static <T extends POMErrorFixBase> List<T> hintProviders(Project project, final Class<T> providerType) {
        List providers = (List)ProjectManager.mutex().readAccess(new Mutex.Action<List<T>>(){

            public List<T> run() {
                Lookup lkp = Lookups.forPath((String)"org-netbeans-modules-maven-hints");
                Lookup.Result res = lkp.lookupResult(providerType);
                ArrayList r = new ArrayList(res.allInstances());
                Iterator it = r.iterator();
                while (it.hasNext()) {
                    POMErrorFixBase prov = (POMErrorFixBase)it.next();
                    if (prov.getConfiguration().isEnabled(prov.getConfiguration().getPreferences())) continue;
                    it.remove();
                }
                return r;
            }
        });
        return providers;
    }

    static boolean isPropertyExpression(String expression) {
        return expression != null && expression.startsWith("${") && expression.endsWith("}");
    }

    static String getPropertyName(String expression) {
        if (PomModelUtils.isPropertyExpression(expression)) {
            return expression.substring(2, expression.length() - 1);
        }
        return expression;
    }

    static String getProperty(POMModel model, String expression) {
        Properties properties = model.getProject().getProperties();
        if (properties != null) {
            return properties.getProperty(PomModelUtils.getPropertyName(expression));
        }
        return null;
    }

    static POMComponent getFirstChild(POMComponent parent, String name) {
        for (POMComponent child : parent.getChildren()) {
            if (!name.equals(child.getPeer().getNodeName())) continue;
            return child;
        }
        return null;
    }

    private static class M2S
    implements ModelSource2,
    Source {
        private final File pomFile;
        private final Document doc;

        public M2S(File pomFile, Document doc) {
            this.pomFile = pomFile;
            this.doc = doc;
        }

        public ModelSource2 getRelatedSource(String relative) {
            return new M2S(new File(this.pomFile.getParentFile(), relative), null);
        }

        public URI getLocationURI() {
            return this.pomFile.toURI();
        }

        public InputStream getInputStream() throws IOException {
            AtomicReference content = new AtomicReference();
            AtomicReference err = new AtomicReference();
            if (this.doc != null) {
                this.doc.render(() -> {
                    try {
                        content.set(this.doc.getText(0, this.doc.getLength()));
                    }
                    catch (BadLocationException ex) {
                        err.set(ex);
                    }
                });
                if (err.get() != null) {
                    throw new IOException((Throwable)err.get());
                }
                return new ByteArrayInputStream(((String)content.get()).getBytes(StandardCharsets.UTF_8));
            }
            return new FileInputStream(this.pomFile);
        }

        public String getLocation() {
            return this.pomFile.getPath();
        }
    }
}

