/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.common;

import com.sun.xml.registry.common.ConnectionFactoryFactory;
import java.util.Collection;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.FederatedConnection;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.UnsupportedCapabilityException;

public class ConnectionFactoryImpl
extends ConnectionFactory
implements Referenceable {
    private Properties properties;

    public void setProperties(Properties properties) throws JAXRException {
        this.properties = properties;
    }

    public Properties getProperties() throws JAXRException {
        return this.properties;
    }

    public Connection createConnection() throws JAXRException {
        ClassLoader classLoader;
        String registryFactoryClassString = (String)this.properties.get("javax.xml.registry.ConnectionFactoryClass");
        String queryManagerURLString = (String)this.properties.get("javax.xml.registry.queryManagerURL");
        String lifeCycleManagerURLString = (String)this.properties.get("javax.xml.registry.lifeCycleManagerURL");
        if (queryManagerURLString == null) {
            throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/common/LocalStrings").getString("ConnectionFactoryImpl:Missing_connection_property_javax.xml.registry.queryManagerURL"));
        }
        if (registryFactoryClassString == null) {
            registryFactoryClassString = "com.sun.xml.registry.uddi.ConnectionFactoryImpl";
        }
        try {
            classLoader = this.getClass().getClassLoader();
        }
        catch (Exception x) {
            throw new JAXRException(x.toString(), (Throwable)x);
        }
        try {
            Class<?> registryFactoryClass = null;
            registryFactoryClass = classLoader == null ? Class.forName(registryFactoryClassString) : classLoader.loadClass(registryFactoryClassString);
            ConnectionFactory factory = (ConnectionFactory)registryFactoryClass.newInstance();
            factory.setProperties(this.properties);
            return factory.createConnection();
        }
        catch (ClassNotFoundException cnfe) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/common/LocalStrings").getString("ConnectionFactoryImpl:Unable_to_create_connection"), (Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/common/LocalStrings").getString("ConnectionFactoryImpl:Unable_to_create_connection"), (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/common/LocalStrings").getString("ConnectionFactoryImpl:Unable_to_create_connection"), (Throwable)iae);
        }
    }

    public FederatedConnection createFederatedConnection(Collection connections) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(ConnectionFactoryImpl.class.getName(), ConnectionFactoryFactory.class.getName(), null);
        return ref;
    }
}

