/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIFileFlushProc;
import org.lwjgl.assimp.AIFileFlushProcI;
import org.lwjgl.assimp.AIFileReadProc;
import org.lwjgl.assimp.AIFileReadProcI;
import org.lwjgl.assimp.AIFileSeek;
import org.lwjgl.assimp.AIFileSeekI;
import org.lwjgl.assimp.AIFileTellProc;
import org.lwjgl.assimp.AIFileTellProcI;
import org.lwjgl.assimp.AIFileWriteProc;
import org.lwjgl.assimp.AIFileWriteProcI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiFile")
public class AIFile
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int READPROC;
    public static final int WRITEPROC;
    public static final int TELLPROC;
    public static final int FILESIZEPROC;
    public static final int SEEKPROC;
    public static final int FLUSHPROC;
    public static final int USERDATA;

    public AIFile(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIFile.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="aiFileReadProc")
    public AIFileReadProc ReadProc() {
        return AIFile.nReadProc(this.address());
    }

    @NativeType(value="aiFileWriteProc")
    public AIFileWriteProc WriteProc() {
        return AIFile.nWriteProc(this.address());
    }

    @NativeType(value="aiFileTellProc")
    public AIFileTellProc TellProc() {
        return AIFile.nTellProc(this.address());
    }

    @NativeType(value="aiFileTellProc")
    public AIFileTellProc FileSizeProc() {
        return AIFile.nFileSizeProc(this.address());
    }

    @NativeType(value="aiFileSeek")
    public AIFileSeek SeekProc() {
        return AIFile.nSeekProc(this.address());
    }

    @NativeType(value="aiFileFlushProc")
    public AIFileFlushProc FlushProc() {
        return AIFile.nFlushProc(this.address());
    }

    @NativeType(value="aiUserData")
    public long UserData() {
        return AIFile.nUserData(this.address());
    }

    public AIFile ReadProc(@NativeType(value="aiFileReadProc") AIFileReadProcI value) {
        AIFile.nReadProc(this.address(), value);
        return this;
    }

    public AIFile WriteProc(@NativeType(value="aiFileWriteProc") AIFileWriteProcI value) {
        AIFile.nWriteProc(this.address(), value);
        return this;
    }

    public AIFile TellProc(@NativeType(value="aiFileTellProc") AIFileTellProcI value) {
        AIFile.nTellProc(this.address(), value);
        return this;
    }

    public AIFile FileSizeProc(@NativeType(value="aiFileTellProc") AIFileTellProcI value) {
        AIFile.nFileSizeProc(this.address(), value);
        return this;
    }

    public AIFile SeekProc(@NativeType(value="aiFileSeek") AIFileSeekI value) {
        AIFile.nSeekProc(this.address(), value);
        return this;
    }

    public AIFile FlushProc(@NativeType(value="aiFileFlushProc") AIFileFlushProcI value) {
        AIFile.nFlushProc(this.address(), value);
        return this;
    }

    public AIFile UserData(@NativeType(value="aiUserData") long value) {
        AIFile.nUserData(this.address(), value);
        return this;
    }

    public AIFile set(AIFileReadProcI ReadProc, AIFileWriteProcI WriteProc, AIFileTellProcI TellProc, AIFileTellProcI FileSizeProc, AIFileSeekI SeekProc, AIFileFlushProcI FlushProc, long UserData) {
        this.ReadProc(ReadProc);
        this.WriteProc(WriteProc);
        this.TellProc(TellProc);
        this.FileSizeProc(FileSizeProc);
        this.SeekProc(SeekProc);
        this.FlushProc(FlushProc);
        this.UserData(UserData);
        return this;
    }

    public AIFile set(AIFile src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIFile malloc() {
        return (AIFile)AIFile.wrap(AIFile.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static AIFile calloc() {
        return (AIFile)AIFile.wrap(AIFile.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static AIFile create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (AIFile)AIFile.wrap(AIFile.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static AIFile create(long address) {
        return (AIFile)AIFile.wrap(AIFile.class, (long)address);
    }

    @Nullable
    public static AIFile createSafe(long address) {
        return address == 0L ? null : (AIFile)AIFile.wrap(AIFile.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)AIFile.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)AIFile.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)AIFile.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIFile.__create((int)capacity, (int)SIZEOF);
        return (Buffer)AIFile.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)AIFile.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)AIFile.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static AIFile mallocStack() {
        return AIFile.mallocStack(MemoryStack.stackGet());
    }

    public static AIFile callocStack() {
        return AIFile.callocStack(MemoryStack.stackGet());
    }

    public static AIFile mallocStack(MemoryStack stack) {
        return (AIFile)AIFile.wrap(AIFile.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIFile callocStack(MemoryStack stack) {
        return (AIFile)AIFile.wrap(AIFile.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIFile.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIFile.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)AIFile.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)AIFile.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static AIFileReadProc nReadProc(long struct) {
        return AIFileReadProc.create(MemoryUtil.memGetAddress((long)(struct + (long)READPROC)));
    }

    public static AIFileWriteProc nWriteProc(long struct) {
        return AIFileWriteProc.create(MemoryUtil.memGetAddress((long)(struct + (long)WRITEPROC)));
    }

    public static AIFileTellProc nTellProc(long struct) {
        return AIFileTellProc.create(MemoryUtil.memGetAddress((long)(struct + (long)TELLPROC)));
    }

    public static AIFileTellProc nFileSizeProc(long struct) {
        return AIFileTellProc.create(MemoryUtil.memGetAddress((long)(struct + (long)FILESIZEPROC)));
    }

    public static AIFileSeek nSeekProc(long struct) {
        return AIFileSeek.create(MemoryUtil.memGetAddress((long)(struct + (long)SEEKPROC)));
    }

    public static AIFileFlushProc nFlushProc(long struct) {
        return AIFileFlushProc.create(MemoryUtil.memGetAddress((long)(struct + (long)FLUSHPROC)));
    }

    public static long nUserData(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)USERDATA));
    }

    public static void nReadProc(long struct, AIFileReadProcI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)READPROC), (long)value.address());
    }

    public static void nWriteProc(long struct, AIFileWriteProcI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)WRITEPROC), (long)value.address());
    }

    public static void nTellProc(long struct, AIFileTellProcI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)TELLPROC), (long)value.address());
    }

    public static void nFileSizeProc(long struct, AIFileTellProcI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)FILESIZEPROC), (long)value.address());
    }

    public static void nSeekProc(long struct, AIFileSeekI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SEEKPROC), (long)value.address());
    }

    public static void nFlushProc(long struct, AIFileFlushProcI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)FLUSHPROC), (long)value.address());
    }

    public static void nUserData(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)USERDATA), (long)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)READPROC)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)WRITEPROC)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)TELLPROC)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)FILESIZEPROC)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SEEKPROC)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)FLUSHPROC)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIFile.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = AIFile.__struct((Struct.Member[])new Struct.Member[]{AIFile.__member((int)POINTER_SIZE), AIFile.__member((int)POINTER_SIZE), AIFile.__member((int)POINTER_SIZE), AIFile.__member((int)POINTER_SIZE), AIFile.__member((int)POINTER_SIZE), AIFile.__member((int)POINTER_SIZE), AIFile.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        READPROC = layout.offsetof(0);
        WRITEPROC = layout.offsetof(1);
        TELLPROC = layout.offsetof(2);
        FILESIZEPROC = layout.offsetof(3);
        SEEKPROC = layout.offsetof(4);
        FLUSHPROC = layout.offsetof(5);
        USERDATA = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<AIFile, Buffer>
    implements NativeResource {
        private static final AIFile ELEMENT_FACTORY = AIFile.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AIFile getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="aiFileReadProc")
        public AIFileReadProc ReadProc() {
            return AIFile.nReadProc(this.address());
        }

        @NativeType(value="aiFileWriteProc")
        public AIFileWriteProc WriteProc() {
            return AIFile.nWriteProc(this.address());
        }

        @NativeType(value="aiFileTellProc")
        public AIFileTellProc TellProc() {
            return AIFile.nTellProc(this.address());
        }

        @NativeType(value="aiFileTellProc")
        public AIFileTellProc FileSizeProc() {
            return AIFile.nFileSizeProc(this.address());
        }

        @NativeType(value="aiFileSeek")
        public AIFileSeek SeekProc() {
            return AIFile.nSeekProc(this.address());
        }

        @NativeType(value="aiFileFlushProc")
        public AIFileFlushProc FlushProc() {
            return AIFile.nFlushProc(this.address());
        }

        @NativeType(value="aiUserData")
        public long UserData() {
            return AIFile.nUserData(this.address());
        }

        public Buffer ReadProc(@NativeType(value="aiFileReadProc") AIFileReadProcI value) {
            AIFile.nReadProc(this.address(), value);
            return this;
        }

        public Buffer WriteProc(@NativeType(value="aiFileWriteProc") AIFileWriteProcI value) {
            AIFile.nWriteProc(this.address(), value);
            return this;
        }

        public Buffer TellProc(@NativeType(value="aiFileTellProc") AIFileTellProcI value) {
            AIFile.nTellProc(this.address(), value);
            return this;
        }

        public Buffer FileSizeProc(@NativeType(value="aiFileTellProc") AIFileTellProcI value) {
            AIFile.nFileSizeProc(this.address(), value);
            return this;
        }

        public Buffer SeekProc(@NativeType(value="aiFileSeek") AIFileSeekI value) {
            AIFile.nSeekProc(this.address(), value);
            return this;
        }

        public Buffer FlushProc(@NativeType(value="aiFileFlushProc") AIFileFlushProcI value) {
            AIFile.nFlushProc(this.address(), value);
            return this;
        }

        public Buffer UserData(@NativeType(value="aiUserData") long value) {
            AIFile.nUserData(this.address(), value);
            return this;
        }
    }
}

