/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class OESGetProgramBinary {
    public static final int GL_PROGRAM_BINARY_LENGTH_OES = 34625;
    public static final int GL_NUM_PROGRAM_BINARY_FORMATS_OES = 34814;
    public static final int GL_PROGRAM_BINARY_FORMATS_OES = 34815;

    protected OESGetProgramBinary() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glGetProgramBinaryOES, caps.glProgramBinaryOES});
    }

    public static native void nglGetProgramBinaryOES(int var0, int var1, long var2, long var4, long var6);

    public static void glGetProgramBinaryOES(@NativeType(value="GLuint") int program, @Nullable @NativeType(value="GLsizei *") IntBuffer length, @NativeType(value="GLenum *") IntBuffer binaryFormat, @NativeType(value="void *") ByteBuffer binary) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
            Checks.check((Buffer)binaryFormat, (int)1);
        }
        OESGetProgramBinary.nglGetProgramBinaryOES(program, binary.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((IntBuffer)binaryFormat), MemoryUtil.memAddress((ByteBuffer)binary));
    }

    public static native void nglProgramBinaryOES(int var0, int var1, long var2, int var4);

    public static void glProgramBinaryOES(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int binaryFormat, @NativeType(value="void const *") ByteBuffer binary) {
        OESGetProgramBinary.nglProgramBinaryOES(program, binaryFormat, MemoryUtil.memAddress((ByteBuffer)binary), binary.remaining());
    }

    public static void glGetProgramBinaryOES(@NativeType(value="GLuint") int program, @Nullable @NativeType(value="GLsizei *") int[] length, @NativeType(value="GLenum *") int[] binaryFormat, @NativeType(value="void *") ByteBuffer binary) {
        long __functionAddress = GLES.getICD().glGetProgramBinaryOES;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])length, (int)1);
            Checks.check((int[])binaryFormat, (int)1);
        }
        JNI.callPPPV((int)program, (int)binary.remaining(), (int[])length, (int[])binaryFormat, (long)MemoryUtil.memAddress((ByteBuffer)binary), (long)__functionAddress);
    }

    static {
        GLES.initialize();
    }
}

