/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct Texture_t")
public class Texture
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HANDLE;
    public static final int ETYPE;
    public static final int ECOLORSPACE;

    public Texture(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), Texture.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long handle() {
        return Texture.nhandle(this.address());
    }

    @NativeType(value="ETextureType")
    public int eType() {
        return Texture.neType(this.address());
    }

    @NativeType(value="EColorSpace")
    public int eColorSpace() {
        return Texture.neColorSpace(this.address());
    }

    public Texture handle(@NativeType(value="void *") long value) {
        Texture.nhandle(this.address(), value);
        return this;
    }

    public Texture eType(@NativeType(value="ETextureType") int value) {
        Texture.neType(this.address(), value);
        return this;
    }

    public Texture eColorSpace(@NativeType(value="EColorSpace") int value) {
        Texture.neColorSpace(this.address(), value);
        return this;
    }

    public Texture set(long handle, int eType, int eColorSpace) {
        this.handle(handle);
        this.eType(eType);
        this.eColorSpace(eColorSpace);
        return this;
    }

    public Texture set(Texture src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static Texture malloc() {
        return (Texture)Texture.wrap(Texture.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static Texture calloc() {
        return (Texture)Texture.wrap(Texture.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static Texture create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (Texture)Texture.wrap(Texture.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static Texture create(long address) {
        return (Texture)Texture.wrap(Texture.class, (long)address);
    }

    @Nullable
    public static Texture createSafe(long address) {
        return address == 0L ? null : (Texture)Texture.wrap(Texture.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)Texture.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)Texture.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)Texture.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = Texture.__create((int)capacity, (int)SIZEOF);
        return (Buffer)Texture.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)Texture.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)Texture.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static Texture mallocStack() {
        return Texture.mallocStack(MemoryStack.stackGet());
    }

    public static Texture callocStack() {
        return Texture.callocStack(MemoryStack.stackGet());
    }

    public static Texture mallocStack(MemoryStack stack) {
        return (Texture)Texture.wrap(Texture.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static Texture callocStack(MemoryStack stack) {
        return (Texture)Texture.wrap(Texture.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return Texture.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return Texture.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)Texture.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)Texture.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nhandle(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HANDLE));
    }

    public static int neType(long struct) {
        return UNSAFE.getInt(null, struct + (long)ETYPE);
    }

    public static int neColorSpace(long struct) {
        return UNSAFE.getInt(null, struct + (long)ECOLORSPACE);
    }

    public static void nhandle(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)HANDLE), (long)Checks.check((long)value));
    }

    public static void neType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ETYPE, value);
    }

    public static void neColorSpace(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ECOLORSPACE, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)HANDLE)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            Texture.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = Texture.__struct((Struct.Member[])new Struct.Member[]{Texture.__member((int)POINTER_SIZE), Texture.__member((int)4), Texture.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HANDLE = layout.offsetof(0);
        ETYPE = layout.offsetof(1);
        ECOLORSPACE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<Texture, Buffer>
    implements NativeResource {
        private static final Texture ELEMENT_FACTORY = Texture.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Texture getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long handle() {
            return Texture.nhandle(this.address());
        }

        @NativeType(value="ETextureType")
        public int eType() {
            return Texture.neType(this.address());
        }

        @NativeType(value="EColorSpace")
        public int eColorSpace() {
            return Texture.neColorSpace(this.address());
        }

        public Buffer handle(@NativeType(value="void *") long value) {
            Texture.nhandle(this.address(), value);
            return this;
        }

        public Buffer eType(@NativeType(value="ETextureType") int value) {
            Texture.neType(this.address(), value);
            return this;
        }

        public Buffer eColorSpace(@NativeType(value="EColorSpace") int value) {
            Texture.neColorSpace(this.address(), value);
            return this;
        }
    }
}

