/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct NotificationBitmap_t")
public class NotificationBitmap
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_PIMAGEDATA;
    public static final int M_NWIDTH;
    public static final int M_NHEIGHT;
    public static final int M_NBYTESPERPIXEL;

    public NotificationBitmap(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NotificationBitmap.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public ByteBuffer m_pImageData(int capacity) {
        return NotificationBitmap.nm_pImageData(this.address(), capacity);
    }

    @NativeType(value="int32_t")
    public int m_nWidth() {
        return NotificationBitmap.nm_nWidth(this.address());
    }

    @NativeType(value="int32_t")
    public int m_nHeight() {
        return NotificationBitmap.nm_nHeight(this.address());
    }

    @NativeType(value="int32_t")
    public int m_nBytesPerPixel() {
        return NotificationBitmap.nm_nBytesPerPixel(this.address());
    }

    public NotificationBitmap m_pImageData(@NativeType(value="void *") ByteBuffer value) {
        NotificationBitmap.nm_pImageData(this.address(), value);
        return this;
    }

    public NotificationBitmap m_nWidth(@NativeType(value="int32_t") int value) {
        NotificationBitmap.nm_nWidth(this.address(), value);
        return this;
    }

    public NotificationBitmap m_nHeight(@NativeType(value="int32_t") int value) {
        NotificationBitmap.nm_nHeight(this.address(), value);
        return this;
    }

    public NotificationBitmap m_nBytesPerPixel(@NativeType(value="int32_t") int value) {
        NotificationBitmap.nm_nBytesPerPixel(this.address(), value);
        return this;
    }

    public NotificationBitmap set(ByteBuffer m_pImageData, int m_nWidth, int m_nHeight, int m_nBytesPerPixel) {
        this.m_pImageData(m_pImageData);
        this.m_nWidth(m_nWidth);
        this.m_nHeight(m_nHeight);
        this.m_nBytesPerPixel(m_nBytesPerPixel);
        return this;
    }

    public NotificationBitmap set(NotificationBitmap src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NotificationBitmap malloc() {
        return (NotificationBitmap)NotificationBitmap.wrap(NotificationBitmap.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NotificationBitmap calloc() {
        return (NotificationBitmap)NotificationBitmap.wrap(NotificationBitmap.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NotificationBitmap create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NotificationBitmap)NotificationBitmap.wrap(NotificationBitmap.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NotificationBitmap create(long address) {
        return (NotificationBitmap)NotificationBitmap.wrap(NotificationBitmap.class, (long)address);
    }

    @Nullable
    public static NotificationBitmap createSafe(long address) {
        return address == 0L ? null : (NotificationBitmap)NotificationBitmap.wrap(NotificationBitmap.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NotificationBitmap.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NotificationBitmap.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NotificationBitmap.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NotificationBitmap.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NotificationBitmap.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NotificationBitmap.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NotificationBitmap.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static NotificationBitmap mallocStack() {
        return NotificationBitmap.mallocStack(MemoryStack.stackGet());
    }

    public static NotificationBitmap callocStack() {
        return NotificationBitmap.callocStack(MemoryStack.stackGet());
    }

    public static NotificationBitmap mallocStack(MemoryStack stack) {
        return (NotificationBitmap)NotificationBitmap.wrap(NotificationBitmap.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NotificationBitmap callocStack(MemoryStack stack) {
        return (NotificationBitmap)NotificationBitmap.wrap(NotificationBitmap.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NotificationBitmap.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NotificationBitmap.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)NotificationBitmap.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)NotificationBitmap.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer nm_pImageData(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)M_PIMAGEDATA)), (int)capacity);
    }

    public static int nm_nWidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NWIDTH);
    }

    public static int nm_nHeight(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NHEIGHT);
    }

    public static int nm_nBytesPerPixel(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NBYTESPERPIXEL);
    }

    public static void nm_pImageData(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)M_PIMAGEDATA), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void nm_nWidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_NWIDTH, value);
    }

    public static void nm_nHeight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_NHEIGHT, value);
    }

    public static void nm_nBytesPerPixel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_NBYTESPERPIXEL, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)M_PIMAGEDATA)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            NotificationBitmap.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = NotificationBitmap.__struct((Struct.Member[])new Struct.Member[]{NotificationBitmap.__member((int)POINTER_SIZE), NotificationBitmap.__member((int)4), NotificationBitmap.__member((int)4), NotificationBitmap.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_PIMAGEDATA = layout.offsetof(0);
        M_NWIDTH = layout.offsetof(1);
        M_NHEIGHT = layout.offsetof(2);
        M_NBYTESPERPIXEL = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<NotificationBitmap, Buffer>
    implements NativeResource {
        private static final NotificationBitmap ELEMENT_FACTORY = NotificationBitmap.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NotificationBitmap getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public ByteBuffer m_pImageData(int capacity) {
            return NotificationBitmap.nm_pImageData(this.address(), capacity);
        }

        @NativeType(value="int32_t")
        public int m_nWidth() {
            return NotificationBitmap.nm_nWidth(this.address());
        }

        @NativeType(value="int32_t")
        public int m_nHeight() {
            return NotificationBitmap.nm_nHeight(this.address());
        }

        @NativeType(value="int32_t")
        public int m_nBytesPerPixel() {
            return NotificationBitmap.nm_nBytesPerPixel(this.address());
        }

        public Buffer m_pImageData(@NativeType(value="void *") ByteBuffer value) {
            NotificationBitmap.nm_pImageData(this.address(), value);
            return this;
        }

        public Buffer m_nWidth(@NativeType(value="int32_t") int value) {
            NotificationBitmap.nm_nWidth(this.address(), value);
            return this;
        }

        public Buffer m_nHeight(@NativeType(value="int32_t") int value) {
            NotificationBitmap.nm_nHeight(this.address(), value);
            return this;
        }

        public Buffer m_nBytesPerPixel(@NativeType(value="int32_t") int value) {
            NotificationBitmap.nm_nBytesPerPixel(this.address(), value);
            return this;
        }
    }
}

