/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPhysicalDeviceProperties;

public class VkPhysicalDeviceProperties2
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PROPERTIES;

    public VkPhysicalDeviceProperties2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPhysicalDeviceProperties2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceProperties2.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceProperties2.npNext(this.address());
    }

    public VkPhysicalDeviceProperties properties() {
        return VkPhysicalDeviceProperties2.nproperties(this.address());
    }

    public VkPhysicalDeviceProperties2 sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceProperties2.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceProperties2 pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceProperties2.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceProperties2 set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceProperties2 set(VkPhysicalDeviceProperties2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceProperties2 malloc() {
        return (VkPhysicalDeviceProperties2)VkPhysicalDeviceProperties2.wrap(VkPhysicalDeviceProperties2.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkPhysicalDeviceProperties2 calloc() {
        return (VkPhysicalDeviceProperties2)VkPhysicalDeviceProperties2.wrap(VkPhysicalDeviceProperties2.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkPhysicalDeviceProperties2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkPhysicalDeviceProperties2)VkPhysicalDeviceProperties2.wrap(VkPhysicalDeviceProperties2.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkPhysicalDeviceProperties2 create(long address) {
        return (VkPhysicalDeviceProperties2)VkPhysicalDeviceProperties2.wrap(VkPhysicalDeviceProperties2.class, (long)address);
    }

    @Nullable
    public static VkPhysicalDeviceProperties2 createSafe(long address) {
        return address == 0L ? null : (VkPhysicalDeviceProperties2)VkPhysicalDeviceProperties2.wrap(VkPhysicalDeviceProperties2.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkPhysicalDeviceProperties2.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkPhysicalDeviceProperties2.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkPhysicalDeviceProperties2.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceProperties2.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkPhysicalDeviceProperties2.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkPhysicalDeviceProperties2.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkPhysicalDeviceProperties2.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkPhysicalDeviceProperties2 mallocStack() {
        return VkPhysicalDeviceProperties2.mallocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceProperties2 callocStack() {
        return VkPhysicalDeviceProperties2.callocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceProperties2 mallocStack(MemoryStack stack) {
        return (VkPhysicalDeviceProperties2)VkPhysicalDeviceProperties2.wrap(VkPhysicalDeviceProperties2.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceProperties2 callocStack(MemoryStack stack) {
        return (VkPhysicalDeviceProperties2)VkPhysicalDeviceProperties2.wrap(VkPhysicalDeviceProperties2.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceProperties2.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceProperties2.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPhysicalDeviceProperties2.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPhysicalDeviceProperties2.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static VkPhysicalDeviceProperties nproperties(long struct) {
        return VkPhysicalDeviceProperties.create(struct + (long)PROPERTIES);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceProperties2.__struct((Struct.Member[])new Struct.Member[]{VkPhysicalDeviceProperties2.__member((int)4), VkPhysicalDeviceProperties2.__member((int)POINTER_SIZE), VkPhysicalDeviceProperties2.__member((int)VkPhysicalDeviceProperties.SIZEOF, (int)VkPhysicalDeviceProperties.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PROPERTIES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceProperties2, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceProperties2 ELEMENT_FACTORY = VkPhysicalDeviceProperties2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPhysicalDeviceProperties2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceProperties2.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceProperties2.npNext(this.address());
        }

        public VkPhysicalDeviceProperties properties() {
            return VkPhysicalDeviceProperties2.nproperties(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceProperties2.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceProperties2.npNext(this.address(), value);
            return this;
        }
    }
}

