/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExtensionProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EXTENSIONNAME;
    public static final int SPECVERSION;

    public VkExtensionProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkExtensionProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
    public ByteBuffer extensionName() {
        return VkExtensionProperties.nextensionName(this.address());
    }

    @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
    public String extensionNameString() {
        return VkExtensionProperties.nextensionNameString(this.address());
    }

    @NativeType(value="uint32_t")
    public int specVersion() {
        return VkExtensionProperties.nspecVersion(this.address());
    }

    public static VkExtensionProperties malloc() {
        return (VkExtensionProperties)VkExtensionProperties.wrap(VkExtensionProperties.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkExtensionProperties calloc() {
        return (VkExtensionProperties)VkExtensionProperties.wrap(VkExtensionProperties.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkExtensionProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkExtensionProperties)VkExtensionProperties.wrap(VkExtensionProperties.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkExtensionProperties create(long address) {
        return (VkExtensionProperties)VkExtensionProperties.wrap(VkExtensionProperties.class, (long)address);
    }

    @Nullable
    public static VkExtensionProperties createSafe(long address) {
        return address == 0L ? null : (VkExtensionProperties)VkExtensionProperties.wrap(VkExtensionProperties.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkExtensionProperties.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkExtensionProperties.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkExtensionProperties.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExtensionProperties.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkExtensionProperties.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkExtensionProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkExtensionProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkExtensionProperties mallocStack() {
        return VkExtensionProperties.mallocStack(MemoryStack.stackGet());
    }

    public static VkExtensionProperties callocStack() {
        return VkExtensionProperties.callocStack(MemoryStack.stackGet());
    }

    public static VkExtensionProperties mallocStack(MemoryStack stack) {
        return (VkExtensionProperties)VkExtensionProperties.wrap(VkExtensionProperties.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExtensionProperties callocStack(MemoryStack stack) {
        return (VkExtensionProperties)VkExtensionProperties.wrap(VkExtensionProperties.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExtensionProperties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExtensionProperties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkExtensionProperties.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkExtensionProperties.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer nextensionName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)EXTENSIONNAME), (int)256);
    }

    public static String nextensionNameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)EXTENSIONNAME));
    }

    public static int nspecVersion(long struct) {
        return UNSAFE.getInt(null, struct + (long)SPECVERSION);
    }

    static {
        Struct.Layout layout = VkExtensionProperties.__struct((Struct.Member[])new Struct.Member[]{VkExtensionProperties.__array((int)1, (int)256), VkExtensionProperties.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        EXTENSIONNAME = layout.offsetof(0);
        SPECVERSION = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkExtensionProperties, Buffer>
    implements NativeResource {
        private static final VkExtensionProperties ELEMENT_FACTORY = VkExtensionProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkExtensionProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
        public ByteBuffer extensionName() {
            return VkExtensionProperties.nextensionName(this.address());
        }

        @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
        public String extensionNameString() {
            return VkExtensionProperties.nextensionNameString(this.address());
        }

        @NativeType(value="uint32_t")
        public int specVersion() {
            return VkExtensionProperties.nspecVersion(this.address());
        }
    }
}

